use std::path::Path;

#[test]
fn firefox_test() {
    let profile_folder = Path::new("C:/Users/olejo/AppData/Roaming/Mozilla/Firefox/Profiles/lzmxm4e8.default-release-1");
    let domain_substring_filter = Some("ecosia");
    let out_path = Path::new("./firefox_test.txt");
    crate::firefox_cookie_file(profile_folder, domain_substring_filter, out_path);
}

#[test]
fn chrome_test() {
    let profile_folder = Path::new("C:/Users/olejo/AppData/Local/Google/Chrome/User Data/Default");
    let domain_substring_filter = None;
    let out_path = Path::new("./chrome_test.txt");
    crate::chrome_cookie_file(profile_folder, domain_substring_filter, out_path);
}