use std::{env, path::PathBuf};

use clap::Parser;
use env_logger::Env;
use server::{gen_docs, run, Config};

#[derive(Parser, Debug)]
struct Args {
    #[clap(long, short)]
    gen_docs: Option<PathBuf>,
}

#[actix_web::main]
async fn main() -> std::io::Result<()> {
    dotenv::dotenv().ok();

    match Args::parse().gen_docs {
        Some(path) => gen_docs(path).await,
        None => {
            env_logger::init_from_env(Env::default().default_filter_or("info"));

            let config = Config {
                db_path: env::var("DATABASE_URL").expect("DATABASE_URL must be set"),
            };

            run(config).await
        }
    }
}
