import React, { useEffect, useState } from 'react'
import logo from './logo.svg'
import './App.css'
import { useGetRecipes } from './queries/getRecipes'
import { useAddRecipy } from './queries/addRecipy'

function App() {
    const [test, setTest] = useState('Not fetched')
    const recipesQuery = useGetRecipes()
    const recipyMutation = useAddRecipy()
    const onClick = () => {
        recipyMutation.mutateAsync({ name: 'testing...' }).then(() => setTest("Fetched"))
    }

    return (
        <div className="App">
            <header className="App-header">
                <img src={logo} className="App-logo" alt="logo" />
                <p>
                    Edit <code>src/App.tsx</code> and save to reload.
                </p>
                <a
                    className="App-link"
                    href="https://reactjs.org"
                    target="_blank"
                    rel="noopener noreferrer"
                >
                    Learn React
                </a>
                <button onClick={onClick}>{test}</button>
                {recipesQuery.isLoading ? <p>Loading...</p> : recipesQuery.data?.data.map(recipy => <p>{recipy.name}</p>)}
            </header>
        </div>
    )
}

export default App
