// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array2, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_transpose_stride2_same() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(kernel1, None, 2, Padding::Same);
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.24858424, 1.0044042, 0.46611735, 1.2026571, 0.607674, 1.0398436, 0.15204486,
            0.3072405, 0.83711505, 1.9425447, 1.1114864, 2.7440317, 0.94433355, 2.3289723,
            1.1802319, 0.8646134, 0.20021535, 1.5911021, 0.83889574, 2.0007253, 1.0169982,
            1.8688753, 0.6497939, 0.65949893, 0.53375435, 1.9530745, 0.7593528, 2.585309,
            1.0535524, 2.23207, 1.0499439, 0.65207344, 0.07443302, 0.4970782, 0.25841802,
            1.2128702, 0.59266895, 1.138166, 0.12282969, 0.30535886, 1.0093067, 1.765773,
            0.4322542, 2.045883, 1.1588016, 1.5410925, 0.68110174, 0.50463367, 0.70455384,
            1.413969, 0.71151, 1.2771106, 0.32934356, 0.84927136, 0.20111695, 0.22095333, 0.93198,
            2.2128985, 0.65470946, 2.2802074, 1.1046441, 1.7397914, 0.5784988, 0.4555707,
            0.4959415, 1.2513329, 0.5904714, 1.5142156, 0.74028736, 1.1560278, 0.3237792,
            0.32498133, 0.2159425, 1.1645802, 0.31693456, 1.4154541, 0.33968112, 1.000927,
            0.24337435, 0.25955924,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.14352316, 0.8997107, 0.64410555, 0.04471071, 0.767672, 0.43464628, 0.16569944,
            0.18875164, 0.12285258, 0.2781115, 0.5390728, 0.5066572, 0.97435564, 0.39133722,
            0.7964828, 0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183,
            0.81628793, 0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133,
            0.0067116, 0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715,
            0.7567798, 0.23972042, 0.38848338, 0.00744711, 0.8715701,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.07988323, 0.6283005, 0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194,
            0.34163022, 0.03235205, 0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297,
            0.97700953, 0.18019113, 0.775954, 0.14120784,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(kernel2, None, 2, Padding::Same);
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.8805573, 1.1886215, 1.333165, 1.2442695, 1.2883204, 1.1279604, 0.44871566, 0.4530567,
            1.7299676, 2.561429, 1.7160745, 2.0621367, 1.4783854, 1.3141904, 1.0398229, 1.0862074,
            1.3228769, 1.2481385, 1.0589972, 1.0733559, 0.75514674, 0.9502192, 0.97536, 0.93481064,
            1.0405267, 0.8761964, 1.3669415, 1.432875, 1.3746045, 1.5553426, 1.1082746, 0.56217176,
            0.08585983, 0.21492471, 0.7792609, 0.92801356, 1.018051, 0.8746961, 0.3358971,
            0.08083438, 0.85245466, 1.45993, 0.9053254, 1.0753281, 1.3101006, 1.4669561, 1.2496339,
            1.5369762, 0.93083537, 0.54521435, 0.34415808, 0.30722648, 0.610601, 0.5465143,
            1.3363973, 0.8821693, 0.95370007, 0.9622226, 0.44529352, 0.9582989, 0.6930301,
            1.5425302, 1.9863622, 1.663812, 0.45355517, 0.37351927, 0.36160812, 0.47121483,
            0.35494697, 0.42140633, 1.3620077, 0.9765619, 0.30895022, 0.12025096, 0.30403057,
            0.39376482, 0.18909958, 0.7197994, 0.97212505, 0.15108703,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.3426181, 0.5417864, 0.7768226, 0.34603763, 0.6114103, 0.9716041, 0.5157695,
            0.50755495, 0.6659802, 0.629322, 0.60627973, 0.27978492, 0.28792506, 0.7547703,
            0.0509604, 0.10449678, 0.89887625, 0.6572328, 0.695583, 0.3626411, 0.37613922,
            0.9241278, 0.39898983, 0.6908677, 0.5511301, 0.36253917, 0.36786652, 0.88718724,
            0.69587743, 0.4870034, 0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529,
            0.5566727, 0.7035832, 0.92333794, 0.85647196, 0.36252776,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9373231, 0.01684272, 0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754,
            0.31284246, 0.4031665, 0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259,
            0.23846498, 0.82509995, 0.97324103, 0.96826524,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(kernel3, None, 2, Padding::Same);
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.13847348, 1.6246073, 0.23104082, 1.677525, 0.2973285, 1.5767721, 0.15125354,
            0.42296287, 0.920402, 3.2625203, 1.3726182, 3.2494628, 0.9316069, 2.9719129, 1.4923996,
            1.3051109, 0.24270733, 1.7893643, 0.36687818, 1.5973891, 0.20118423, 1.6891117,
            0.2172292, 0.59030336, 1.2904507, 3.244081, 1.053412, 2.923623, 1.0951627, 3.136854,
            1.8086834, 1.5181623, 0.267872, 1.6540356, 0.2468754, 1.746763, 0.24679282, 1.7126664,
            0.13796927, 0.44396427, 1.0717797, 3.2673266, 1.2834084, 2.7683842, 1.3302367,
            2.6907492, 1.4903902, 1.3059568, 0.11316772, 1.6038188, 0.3024169, 1.2646371,
            0.03913542, 0.7380182, 0.05843239, 0.210723, 0.8855423, 3.3936946, 1.7155874,
            3.3839746, 1.253248, 2.2600894, 0.86792743, 0.8373586, 0.35291094, 2.2235484,
            0.2730256, 2.0745778, 0.28453135, 1.3635185, 0.14526142, 0.35705492, 0.9659627,
            2.3021526, 1.1042407, 2.3913202, 1.0511615, 1.6828883, 0.4662764, 0.49722776,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.77620417, 0.8427075, 0.42989048, 0.76771307, 0.54514444, 0.7878393, 0.21897991,
            0.975659, 0.73295325, 0.69994044, 0.86701024, 0.76087946, 0.623545, 0.14890751,
            0.8610666, 0.21943341, 0.1644093, 0.6089244, 0.8612485, 0.02602104, 0.30423534,
            0.5087405, 0.16869895, 0.3329467, 0.179494, 0.33126613, 0.11996287, 0.21606164,
            0.87119263, 0.33579683, 0.2313126, 0.2576527, 0.3748985, 0.30113342, 0.8142977,
            0.423247, 0.8179498, 0.92175007, 0.21606776, 0.19149332,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.4240341, 0.14780204, 0.46443272, 0.00207204, 0.359202, 0.9019851, 0.21363449,
            0.6390296, 0.5977058, 0.81350476, 0.3685356, 0.90738845, 0.7828945, 0.9812083,
            0.6726924, 0.46724817, 0.17302093, 0.39839587, 0.78055173, 0.8576361, 0.7335981,
            0.52934057, 0.9529279, 0.78965247, 0.46750203, 0.08403921, 0.73126566, 0.34934825,
            0.3459232, 0.54770446, 0.68714255, 0.29283327, 0.53392637, 0.8850151, 0.6909357,
            0.44388366, 0.9043074, 0.9949724, 0.64743847, 0.36691284, 0.5396585, 0.5372604,
            0.47547424, 0.44373918, 0.34716287, 0.21774843, 0.9437953, 0.51856595, 0.15765554,
            0.9350713,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(kernel4, None, 2, Padding::Same);
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            2.12458, 2.605221, 2.9117098, 1.9351985, 2.7285852, 1.872889, 1.9563639, 1.0456114,
            2.5046387, 1.910007, 3.1686182, 1.8945227, 3.7914963, 1.2308786, 1.8912808, 1.5213561,
            3.638967, 3.90457, 5.149136, 2.8420267, 4.663398, 2.842582, 3.3145962, 1.8466333,
            2.645023, 2.2764237, 3.9340343, 1.8327875, 3.8497515, 1.4699796, 2.209813, 1.540236,
            3.6193118, 3.783656, 4.686215, 3.6307814, 4.6409197, 3.4615011, 3.781535, 1.864756,
            2.1543624, 2.0846858, 4.257942, 1.7475495, 3.4698102, 2.4556131, 2.878837, 1.213973,
            3.4843202, 3.7128754, 5.832033, 3.747091, 5.3915534, 3.5413961, 3.4579039, 1.1970829,
            2.38316, 2.06279, 4.2146735, 2.2633119, 3.2464266, 2.0664341, 2.2786303, 0.5441178,
            2.5395253, 2.991488, 3.966972, 3.560525, 3.578794, 2.50567, 2.4620981, 0.38951558,
            1.236363, 1.0918628, 1.6248461, 1.1494123, 1.4035847, 0.8755107, 0.91506535,
            0.10528385,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.86233217, 0.81734437, 0.6566154, 0.3879487, 0.28848994, 0.5814131, 0.06870039,
            0.78543746, 0.47194287, 0.12733267, 0.6111727, 0.25675833, 0.74741316, 0.45714313,
            0.9649919, 0.57969916, 0.5208711, 0.93666834, 0.13247305, 0.7087714, 0.17877895,
            0.40767, 0.6906785, 0.9675369, 0.224454, 0.28950995, 0.75431514, 0.99582964, 0.8120864,
            0.9536324, 0.7703749, 0.683158, 0.16371861, 0.42877796, 0.7300311, 0.9456737,
            0.05700503, 0.19623296, 0.44457257, 0.5512328,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.15101007, 0.25140873, 0.2031063, 0.5537751, 0.3641559, 0.701937, 0.27669305,
            0.85076064, 0.00186597, 0.3316532, 0.15485734, 0.35000807, 0.42372492, 0.03995521,
            0.5067197, 0.38907993, 0.37287286, 0.21294773, 0.8646356, 0.10154326, 0.75313085,
            0.7910046, 0.15368015, 0.25977603, 0.40315583, 0.635939, 0.25689796, 0.13678746,
            0.43744904, 0.6658951, 0.564682, 0.70429957, 0.67241764, 0.15790685, 0.25059524,
            0.6432024, 0.60438925, 0.45131883, 0.96080875, 0.40131757, 0.60942906, 0.7035094,
            0.6473561, 0.05433872, 0.7478619, 0.24740443, 0.35665986, 0.00020906, 0.23741227,
            0.57013196,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(kernel5, None, 2, Padding::Same);
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            1.1960706, 1.2171881, 2.4872348, 1.7312813, 3.1236472, 2.2317107, 2.0340092, 1.815699,
            1.8337827, 1.7476387, 2.6510327, 2.0566635, 3.6600993, 2.4685178, 2.841806, 0.5467229,
            2.181396, 2.5576358, 3.800905, 2.6954165, 4.12116, 3.5062802, 2.719244, 1.7597022,
            2.184837, 1.5180908, 2.9684298, 1.937231, 3.5761542, 1.7688123, 2.4565701, 0.8415837,
            2.269378, 2.8220363, 3.3542666, 3.014888, 4.217918, 3.6831737, 2.6992738, 1.84181,
            2.5658882, 1.6262779, 4.062735, 1.7814983, 4.3830485, 2.0901628, 2.767175, 0.40953436,
            1.5215272, 1.9618404, 3.522011, 2.978961, 3.908688, 2.8904877, 2.74324, 1.7942995,
            1.9540784, 1.5345917, 2.8535092, 1.6744654, 3.4272892, 2.410273, 2.5085804, 0.6409812,
            1.0829679, 1.2695842, 2.4511175, 1.7852664, 2.522235, 2.2335057, 1.6891894, 0.9330549,
            0.6318498, 0.9407712, 0.74449486, 1.1826963, 1.1695801, 0.7907775, 0.8537058,
            0.6427823,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6398819, 0.7132858, 0.90739846, 0.8246988, 0.1319153, 0.6876462, 0.846729,
            0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465, 0.05539654, 0.5554673,
            0.9149804, 0.9791666, 0.9000323, 0.6329186, 0.30872977, 0.30553624, 0.04431259,
            0.5287215, 0.3358437, 0.72178566, 0.72704846, 0.85191244, 0.07464863, 0.867838,
            0.5849202, 0.14913943, 0.18325551, 0.40498126, 0.75359416, 0.01821492, 0.5917236,
            0.91982275, 0.5287654, 0.7151285, 0.38420153, 0.517026,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.5150141, 0.26934662, 0.7356045, 0.97902703, 0.6362754, 0.27803296, 0.32063982,
            0.83432084, 0.78711736, 0.28247103, 0.7812688, 0.5270146, 0.4719829, 0.47535485,
            0.23715672, 0.4404677, 0.90286416, 0.66611385, 0.02649495, 0.3193976, 0.16608049,
            0.5121102, 0.17436478, 0.313714, 0.47244504, 0.9906781, 0.9064671, 0.29454133,
            0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972, 0.53866875, 0.6358971,
            0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548, 0.14977625, 0.53714937,
            0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625, 0.4744624, 0.73655206,
            0.42605233,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(kernel6, None, 2, Padding::Same);
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            2.8821201, 2.9283395, 3.4418237, 2.9644027, 4.4897423, 3.2337077, 2.3056486, 1.5077068,
            1.6284567, 1.8198807, 2.9355965, 2.5401669, 3.4266138, 2.2138457, 2.012564, 0.95667106,
            3.8316202, 3.9118521, 4.5504274, 3.1720634, 4.685827, 3.7693553, 3.1386414, 2.1895845,
            1.7812991, 2.634107, 2.795426, 1.8527932, 2.5929801, 1.3798399, 1.6114829, 1.2718494,
            3.0292115, 3.3852987, 3.8758166, 3.2739117, 5.493317, 4.542192, 3.4234288, 3.0088036,
            1.4730017, 1.4913499, 2.6251917, 1.3161781, 2.6094341, 2.5672088, 2.734476, 1.4704969,
            3.6319845, 3.7351906, 4.5975175, 3.5733025, 5.026454, 3.9507163, 2.8934474, 1.9359792,
            1.6432247, 2.1645844, 3.098862, 2.2119498, 2.6627395, 2.3008032, 2.3108544, 0.95860577,
            2.517604, 2.2748265, 2.82751, 1.9181901, 2.915578, 2.6303997, 2.0969226, 1.1844921,
            1.0191423, 1.2172139, 1.3674803, 0.8234925, 1.2113678, 0.7345414, 0.63975155,
            0.24061294,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.6592577, 0.3237799, 0.42867732, 0.87574345, 0.70010746, 0.01496939, 0.78416556,
            0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122, 0.68573385,
            0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448, 0.48578474,
            0.2764571, 0.9192946, 0.8920509,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.34320405, 0.4283556, 0.3897719, 0.06360459, 0.729173, 0.19460331, 0.8634254,
            0.6576018, 0.9657459, 0.22873744, 0.47843248, 0.22157177, 0.9162307, 0.02157675,
            0.44649428, 0.2792192, 0.685827, 0.75294507,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(kernel7, None, 2, Padding::Same);
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            0.49195915, 1.0098999, 0.25088748, 0.7772243, 0.32154694, 0.26897925, 1.5854475,
            2.4437222, 1.3339782, 1.8803797, 0.834126, 0.8535212, 0.6574794, 1.2782226, 0.5263233,
            0.96408117, 0.02267679, 0.24629763, 1.6105958, 3.0029533, 1.4913023, 2.2036645,
            1.0372783, 0.9157613, 0.576199, 0.7916375, 0.45831668, 0.8747501, 0.7274299,
            0.40824085, 1.1870923, 2.247117, 1.2454525, 2.6651077, 1.7101289, 1.7892325,
            0.68532133, 1.1503226, 0.0575751, 1.2829367, 0.5360566, 0.53622276, 0.8022765,
            1.4092965, 0.66451246, 1.6032019, 1.0778748, 1.356148,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.7919586, 0.22560763, 0.88778716, 0.80092114, 0.00003577, 0.9737877, 0.9146247,
            0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946, 0.17754778,
            0.41998118, 0.02919354, 0.82382417, 0.4156855, 0.49590722, 0.69720376, 0.7155315,
            0.40795937, 0.15397236, 0.02265206,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.7090415, 0.75877124, 0.67035425, 0.39483562, 0.86222315, 0.9993058, 0.84902793,
            0.26427644, 0.86764544, 0.24274233, 0.69865257, 0.5739991, 0.7620597, 0.29289714,
            0.88402116, 0.8942853, 0.7757528, 0.16431308,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(kernel8, None, 2, Padding::Same);
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            0.6925383, 1.045045, 0.24652736, 1.0529878, 0.8884819, 1.2584431, 0.8630813, 1.796563,
            0.77295, 2.6185184, 1.5897248, 1.7306788, 0.69912344, 1.4539902, 0.24132659, 1.429577,
            0.9613754, 1.3405864, 1.2747693, 2.6018314, 1.2314348, 2.501328, 1.615392, 1.7971659,
            0.93386036, 1.9384551, 0.32379568, 1.5789602, 0.8182762, 1.3380196, 0.9825181,
            2.138388, 0.8859884, 2.1144218, 1.152222, 1.0918523, 0.20026241, 0.6761374, 0.27339295,
            0.6233812, 0.45520633, 0.5399138, 0.3412328, 0.51080966, 0.18941821, 0.71699446,
            0.15506223, 0.4551146,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.48939565, 0.56055367, 0.46453193, 0.9573795, 0.8899508, 0.16098963, 0.63514715,
            0.810474, 0.29953358, 0.46075395, 0.02808736, 0.59781086, 0.8855644, 0.61877847,
            0.9537467, 0.6197168, 0.3379795, 0.13108306, 0.30692965, 0.33537498, 0.01351478,
            0.45529485, 0.6626128, 0.9497022,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.7403127, 0.06039312, 0.08292098, 0.80679554, 0.1354166, 0.2560622, 0.80891573,
            0.97702754, 0.4124968, 0.4359102, 0.8733311, 0.1396195, 0.52047473, 0.88564533,
            0.29781443, 0.21130918, 0.83071965, 0.3337948,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(kernel9, None, 2, Padding::Same);
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            0.85056823, 1.1633604, 0.6239265, 1.1990011, 0.90758663, 0.40298858, 1.812846,
            2.0537472, 1.4106228, 1.3123815, 1.3703581, 0.5416248, 0.6784944, 1.3236275,
            0.41984406, 0.52664906, 0.13789377, 0.08026178, 1.7566068, 2.2348056, 1.4921131,
            0.97951365, 0.29607722, 0.1368871, 0.35784027, 1.0824863, 0.4067749, 0.55610776,
            0.05253112, 0.08072412, 1.3009783, 1.502328, 1.6508346, 1.6428121, 1.1693877,
            0.3102358, 0.4656235, 0.621109, 0.5906434, 1.1811349, 0.92205286, 0.43591177,
            0.8283917, 0.50477105, 0.5778876, 0.91702205, 1.373014, 0.5636007,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.9783562, 0.42070097, 0.55396014, 0.16172563, 0.7634967, 0.36205766, 0.48491392,
            0.4980414, 0.6001484, 0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525,
            0.7446416, 0.471613, 0.72900707, 0.842964, 0.21457537, 0.938401, 0.41665936,
            0.05351101, 0.43856344, 0.7253113,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.8520324, 0.4151233, 0.35101932, 0.7388761, 0.3592986, 0.6741479, 0.9965808,
            0.3117034, 0.8605703, 0.94308543, 0.8192489, 0.31478795, 0.750324, 0.36604244,
            0.78454614, 0.039194, 0.23696694, 0.2418382, 0.24788351, 0.5622223, 0.15428482,
            0.50688076, 0.37682602, 0.44385925, 0.00051633, 0.53422695, 0.5675659, 0.53845215,
            0.2130759, 0.86445093, 0.432881, 0.6255918, 0.3942565, 0.07226853, 0.09869356,
            0.32627374, 0.8543963, 0.85603166, 0.25422713, 0.24929269, 0.36793318, 0.39957172,
            0.9079535, 0.865758, 0.82237726, 0.60374194, 0.7658025, 0.0215734, 0.473204, 0.6594781,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(kernel10, None, 2, Padding::Same);
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            2.9439647, 2.2523544, 4.4763694, 2.5337296, 3.0852933, 0.83921206, 1.8844699,
            2.3132734, 3.2918978, 2.8833797, 2.9984746, 1.1544929, 3.5639138, 3.6263661, 4.677559,
            3.8015723, 3.9973104, 1.4772959, 1.7431811, 2.43681, 3.2383184, 2.5981936, 2.795354,
            1.3661323, 2.6970396, 3.3256, 4.5503044, 3.3048139, 3.0105119, 1.1255698, 1.3397168,
            2.0055637, 2.8981233, 2.1634967, 2.2888012, 0.66186607, 1.8107644, 2.0307658,
            2.2023537, 2.1912982, 1.9612706, 0.69045615, 0.3819174, 0.47048804, 1.1690578,
            0.78854394, 1.2548707, 0.6567359,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.86392707, 0.8566667, 0.48541847, 0.54855824, 0.5860555, 0.158874, 0.10558709,
            0.19664533, 0.39609066, 0.27843866, 0.49128443, 0.75033015, 0.35650545, 0.4687038,
            0.6159849, 0.2547001, 0.17250927, 0.07203952, 0.8724657, 0.14018923, 0.12091745,
            0.4770398, 0.43290496, 0.6356798,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513, 0.06810815,
            0.79673207, 0.29373887, 0.55241185, 0.23906927, 0.18915932, 0.02753429, 0.1438574,
            0.5419741, 0.71984386, 0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492,
            0.62895286, 0.21388301, 0.30016333, 0.49605927, 0.8245107, 0.4528765, 0.6836941,
            0.28745723, 0.5031258, 0.26911622, 0.92149794, 0.7165893, 0.04745785, 0.55642486,
            0.34654748, 0.83168656, 0.8410765, 0.7668131, 0.84094906, 0.6012723, 0.9256995,
            0.66010624, 0.43380973, 0.62281454, 0.45852852, 0.61445725, 0.524579, 0.06486581,
            0.14233574,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(kernel11, None, 2, Padding::Same);
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            1.9775532, 1.5128568, 2.8890767, 1.4977827, 2.0917535, 0.6417521, 2.3429894, 1.1946319,
            2.8878338, 1.2163796, 1.654141, 0.38699254, 2.728716, 2.0513692, 3.550198, 1.5649874,
            2.116637, 0.4951414, 1.7669531, 0.6391633, 1.6880562, 0.4488688, 0.8921769, 0.17614487,
            2.9987433, 2.0822778, 4.044844, 1.4776183, 2.4401047, 0.75726897, 1.5930991, 1.0854677,
            2.48595, 1.0535605, 1.973217, 0.3598865, 1.3930806, 1.1569356, 2.023781, 1.4647905,
            1.4512792, 0.7221234, 1.083755, 0.71072316, 1.8070183, 0.9430953, 1.1569375,
            0.38348037,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.13930365, 0.5838787, 0.45914945, 0.30819193, 0.70949817, 0.8803759, 0.6927248,
            0.50569826, 0.7358748, 0.58652496, 0.85065925, 0.3247378, 0.6760192, 0.4483504,
            0.59195757, 0.37883574, 0.7796499, 0.32748002, 0.44507304, 0.7488422, 0.14428215,
            0.8785777, 0.15468395, 0.6638725,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.30651525, 0.9492515, 0.55669755, 0.08302987, 0.45890567, 0.05946975, 0.9099885,
            0.30235246, 0.24214035, 0.42138377, 0.38782486, 0.21880285, 0.9182205, 0.85290706,
            0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431, 0.2624427, 0.6557088, 0.00633,
            0.6603214, 0.45500925, 0.6523986, 0.14666249, 0.32440838, 0.2805719, 0.42671442,
            0.74477625, 0.9118973, 0.5335283, 0.36968935, 0.5693756, 0.36426732, 0.11819325,
            0.95361024, 0.13343851, 0.5940242, 0.7282295, 0.9320007, 0.46956548, 0.5087874,
            0.7952918, 0.73709416, 0.3358689, 0.03185032, 0.27057356, 0.26166973, 0.5843129,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(kernel12, None, 2, Padding::Same);
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            1.1072309, 2.1893516, 2.7621005, 2.762818, 2.61138, 0.9560869, 2.134172, 2.5499127,
            3.0058384, 2.684795, 2.0126522, 0.9720198, 2.2845337, 2.6152747, 4.4481454, 3.0848007,
            4.125762, 1.4318913, 2.553238, 2.5255842, 2.9832225, 2.8580356, 2.183007, 0.7156001,
            2.8696349, 3.2299206, 4.9685583, 2.3778462, 3.957678, 1.5098575, 2.2733195, 2.720664,
            3.2032213, 2.2470317, 1.9292603, 0.7342162, 2.1649344, 1.8144928, 3.7228482, 1.9568487,
            2.2231522, 1.0439116, 1.3686465, 1.5115961, 2.1473022, 0.8560316, 0.8571826, 0.599835,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.5337139, 0.19571388, 0.1192536, 0.75616854, 0.97167397, 0.71154076, 0.26672947,
            0.07128377, 0.3383284, 0.8008563, 0.9504947, 0.5971434, 0.7847773, 0.92326206,
            0.24163638, 0.12968542, 0.5954836, 0.6734995, 0.08627631, 0.7485715, 0.8782484,
            0.6863155, 0.7264353, 0.08944888, 0.68172634, 0.4284322, 0.48237634, 0.6856524,
            0.04009921, 0.0687674, 0.9063645, 0.42620143, 0.61030614, 0.10040135, 0.50107217,
            0.763057, 0.25769317, 0.8816114, 0.7770131, 0.23345616, 0.62762326, 0.15315741,
            0.73589575, 0.2752067, 0.85641515, 0.7439484, 0.6581306, 0.4056261, 0.13899311,
            0.26460668, 0.9179794, 0.96651816, 0.89336777, 0.18948041, 0.9371178, 0.7124811,
            0.9657549, 0.6203675, 0.32684848, 0.11439406, 0.07654371, 0.95680344, 0.9728639,
            0.6055871, 0.00439729, 0.8525613, 0.3167563, 0.13499211, 0.68338645, 0.7955047,
            0.21689218, 0.2826704,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.12328367, 0.6890043, 0.5906649, 0.41700745, 0.30266365, 0.5716598, 0.12726787,
            0.35587692, 0.16889893, 0.3114892, 0.1309899, 0.24026695, 0.55435276, 0.34375766,
            0.4225387, 0.37165096, 0.6202945, 0.6069533,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(kernel13, None, 2, Padding::Same);
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            0.2501198, 0.98432595, 0.36229616, 0.9648657, 0.30319795, 0.8412356, 0.30911708,
            1.2840354, 0.50984067, 1.2022831, 0.26800656, 0.4714742, 0.62995476, 1.0279825,
            0.7016729, 1.28881, 0.869708, 1.4108241, 1.0631577, 1.6002977, 1.4762111, 1.6120472,
            0.812791, 0.6633081, 0.33369914, 0.6457104, 0.11617942, 0.7728771, 0.39679897,
            1.3016502, 0.49812806, 1.5333643, 0.5139176, 1.2953185, 0.32017067, 0.51275563,
            1.1103165, 1.2962388, 0.8668698, 1.4650685, 0.9383674, 1.6356941, 0.9624313, 1.6128788,
            1.2738068, 1.4951712, 0.9529813, 0.79039145, 0.2853035, 1.0390482, 0.37039843,
            1.249247, 0.388697, 1.1158874, 0.3714991, 1.2260892, 0.48733327, 1.1037898, 0.26897916,
            0.4650754, 0.5476985, 1.0230889, 1.1017985, 1.7108989, 1.3870314, 2.0023336, 1.1998142,
            1.7621458, 1.3094009, 1.3532155, 0.43383172, 0.30907854, 0.3482541, 1.1524149,
            0.4714862, 1.630584, 0.59779954, 1.5402293, 0.42097884, 1.1385865, 0.33222222,
            0.65409553, 0.06639676, 0.09947024, 1.0917315, 1.7153375, 1.1288706, 1.8750261,
            1.3713956, 1.8442429, 1.1807976, 1.2631842, 0.4894684, 0.6737578, 0.26184875,
            0.33000046, 0.23264627, 1.1311243, 0.45857936, 1.3896682, 0.4804272, 1.3084588,
            0.41569728, 0.6670032, 0.01364818, 0.52607733, 0.31388786, 0.3995517, 0.95607126,
            1.2777799, 1.0573063, 1.6483383, 1.2851491, 1.7691349, 0.79303026, 0.8698773,
            0.39064956, 0.86524785, 1.1160884, 1.0477071, 0.383211, 0.90453637, 0.17540026,
            0.934021, 0.41963682, 1.1205031, 0.30384868, 0.7227125, 0.22621468, 0.8529877,
            0.32811975, 0.5556482, 0.5190364, 0.44975197, 0.23541012, 0.48557246, 0.64109474,
            0.8262917, 0.5291777, 0.64417046, 0.31285706, 0.41844136, 0.44689327, 0.30044726,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.05756181, 0.0153275, 0.8497578, 0.79796964, 0.4071996, 0.19325097, 0.04944435,
            0.59729165, 0.39304134, 0.679002, 0.6126854, 0.67232877, 0.7156292, 0.09058711,
            0.33372015, 0.8941644, 0.30899736, 0.3348802, 0.6412177, 0.26750943, 0.03709449,
            0.56803024, 0.8756273, 0.5771133, 0.56024176, 0.5868575, 0.75167763, 0.36936092,
            0.37185487, 0.35425207, 0.24336162, 0.01027582, 0.2671537, 0.83992416, 0.49819484,
            0.7831867, 0.70054483, 0.8701863, 0.49413827, 0.84670645, 0.8069649, 0.093459,
            0.93408287, 0.8206956, 0.70209366, 0.32817394, 0.744203, 0.39091238, 0.43911496,
            0.92919487, 0.29325068, 0.62813336, 0.8131431, 0.19520658, 0.47931832, 0.42483747,
            0.47526902, 0.28184402, 0.09741595, 0.45691565, 0.44086096, 0.9638409, 0.33859608,
            0.26381832, 0.29839757, 0.68755937, 0.09156765, 0.58584654, 0.04617033, 0.14705709,
            0.81179595, 0.16751295,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.06864621, 0.6308731, 0.38993102, 0.3644169, 0.68174505, 0.272409, 0.23609333,
            0.21866773, 0.80119157, 0.01742986, 0.49270406, 0.37920174, 0.90869635, 0.8191268,
            0.7636344, 0.7827788, 0.9694966, 0.79533535,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(kernel14, None, 2, Padding::Same);
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            0.6130775, 1.3469613, 0.7232424, 1.4273672, 0.9840801, 1.6690154, 1.2375717, 1.7456248,
            0.9386129, 0.88250077, 0.20830265, 0.12401181, 1.1831822, 1.7168603, 1.6281695,
            1.8751233, 1.2587636, 2.3968287, 1.585426, 2.4847922, 1.6245897, 1.66091, 0.74962413,
            0.6395588, 0.79884076, 1.6901932, 1.0794544, 1.5706398, 0.8430577, 1.1888611,
            0.7317223, 1.3350986, 1.0272918, 1.3354286, 0.7785636, 0.48166254, 1.584227, 2.0339365,
            1.4412371, 2.1893468, 1.1216438, 1.6041551, 1.3402275, 2.1544523, 1.4510539, 2.0027232,
            0.8334508, 1.0541735, 0.8475675, 1.4076345, 0.8228857, 1.122331, 0.46772155, 1.2114758,
            1.124113, 1.5747466, 0.87672466, 1.0045371, 0.38820186, 0.24029084, 1.2228945,
            2.1288981, 1.2987434, 1.3961782, 0.61484826, 1.4419949, 1.3017187, 2.3156118,
            1.4563141, 1.5521092, 0.85168904, 0.8218554, 0.8297695, 1.0242306, 0.530369, 0.8426856,
            0.41459456, 0.83614707, 0.6181178, 0.7775772, 0.6767506, 0.9384263, 0.767716,
            0.50612736, 1.1755664, 1.7333839, 1.3154951, 1.5848284, 1.109924, 1.2138999, 0.7604609,
            1.2370396, 0.6675308, 1.5673928, 1.1314256, 1.224637, 0.74306303, 1.5789709, 1.1895951,
            1.4774923, 0.7898056, 0.8376595, 0.46791065, 0.70874095, 0.49793565, 1.0830414,
            0.8047079, 0.62154543, 0.7485661, 1.8330541, 1.357899, 1.9245787, 0.6839238, 1.3471503,
            0.9388795, 1.2587501, 1.084881, 1.7158751, 1.3206756, 1.199574, 0.2409161, 0.6723194,
            0.48688808, 0.58948195, 0.21995008, 0.5477451, 0.69307256, 1.2603273, 1.0046057,
            1.1932529, 0.671148, 0.34126574, 0.14198986, 0.72882056, 0.5702232, 0.57339174,
            0.10317987, 0.56417584, 0.32623565, 1.542977, 0.89597255, 1.3608303, 0.3336609,
            0.7607115,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.00732174, 0.8372113, 0.9449071, 0.7670253, 0.50964797, 0.7843069, 0.7365313,
            0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833, 0.5585159,
            0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028, 0.52249014,
            0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726, 0.25884646,
            0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234, 0.32747796,
            0.9097073, 0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446, 0.9843364,
            0.4038572, 0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686, 0.5288406,
            0.92906404, 0.87780553, 0.9090181, 0.82569945, 0.20383635, 0.7166643, 0.17061436,
            0.91526777, 0.08598401, 0.70100874, 0.40537685, 0.5971982, 0.92796123, 0.15859716,
            0.7859081, 0.8564488, 0.35816404, 0.79062706, 0.9644883, 0.13154314, 0.31929043,
            0.80048305, 0.07180241,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.52815664, 0.45786336, 0.91537887, 0.9783313, 0.25753945, 0.42799363, 0.07738555,
            0.9294206, 0.07022415, 0.60058224, 0.6196278, 0.9008346, 0.04155485, 0.82207745,
            0.41282526, 0.9949608, 0.3109271, 0.47614527,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(kernel15, None, 2, Padding::Same);
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            0.61355096, 1.1307185, 0.2423787, 1.3089497, 0.49570745, 1.3075044, 0.7110764,
            1.0926974, 0.2880613, 1.1050862, 1.0111907, 0.74203724, 0.8256216, 2.2108219,
            1.4700348, 2.4867308, 1.7880914, 3.215314, 1.7668917, 2.7486687, 1.2197285, 2.829642,
            1.592871, 1.5770811, 0.52168775, 1.2016575, 0.6556763, 1.4462703, 0.7666652, 1.6150514,
            0.8066848, 0.89553976, 0.85229355, 1.4349961, 0.40064424, 0.49095288, 1.2540754,
            2.4327505, 1.6711427, 3.19123, 1.8181206, 3.1685374, 1.862045, 3.2530842, 1.1085593,
            2.147088, 1.3222339, 0.8132872, 0.50014967, 0.9120277, 0.9076025, 1.1675317, 0.8554762,
            1.0489416, 0.85951567, 0.8839099, 0.7545552, 0.9820652, 0.30098438, 0.3058656,
            1.2134746, 3.102679, 1.2428898, 3.0326982, 1.5623395, 3.024463, 0.98144317, 2.4623177,
            1.1164975, 2.0144832, 0.95120376, 0.80883, 0.79668313, 1.3512542, 0.3254298, 0.9273648,
            0.8869828, 1.1189191, 0.20596059, 0.6141571, 0.6617646, 0.7798493, 0.4205302,
            0.31239504, 1.4270651, 2.2501757, 1.6094434, 3.0215786, 1.1992022, 2.011495, 1.1204087,
            2.6817465, 1.4225101, 2.695055, 0.82878506, 0.8710122, 0.53889567, 1.0339038,
            0.93899596, 1.3890905, 0.31641206, 0.6605288, 0.7127405, 1.2515352, 0.90958637,
            1.0643404, 0.38771895, 0.30287772, 1.1712579, 3.700485, 1.9469125, 2.748978, 1.0169063,
            1.7900715, 0.7888117, 2.4596, 1.6539218, 2.3926823, 0.90900993, 1.0933821, 0.83142716,
            1.5763692, 1.0319939, 1.2598007, 0.22891565, 0.4948507, 0.32212305, 0.5845728,
            0.74239755, 1.363597, 0.29331267, 0.41899076, 0.90072656, 1.4574114, 1.1627963,
            0.69160676, 0.47676605, 0.4311689, 0.31451344, 0.9900826, 0.55325663, 0.5459819,
            0.86782604, 0.09807181,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.7615821, 0.35893062, 0.07713356, 0.6123928, 0.62511915, 0.88098776, 0.21521498,
            0.89468116, 0.1842307, 0.10784956, 0.8354833, 0.2630701, 0.7184675, 0.06132602,
            0.06056971, 0.71349823, 0.00944792, 0.07349233, 0.35231608, 0.8533961, 0.17608605,
            0.18067755, 0.51991457, 0.19053963, 0.5045173, 0.7456122, 0.27621788, 0.48649722,
            0.39297876, 0.54849166, 0.3746991, 0.8194284, 0.34880427, 0.79505837, 0.41293454,
            0.890512, 0.12076204, 0.20799449, 0.88948244, 0.24437675, 0.7731474, 0.65954226,
            0.4922565, 0.5211581, 0.97382414, 0.9779564, 0.1754263, 0.4551989, 0.81067127,
            0.7095975, 0.5087082, 0.78796804, 0.03310984, 0.20805901, 0.45704818, 0.9133983,
            0.5689028, 0.04247752, 0.55938286, 0.9835293, 0.04525762, 0.7176199, 0.82096803,
            0.5575717, 0.5744108, 0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355,
            0.1134909, 0.5645703,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.30096474, 0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894, 0.681929,
            0.24701218, 0.74485576, 0.61556435, 0.63869125, 0.05875124, 0.3210932, 0.96946657,
            0.09463912, 0.6275637, 0.34162354, 0.74390864, 0.8736778, 0.9513908, 0.24045336,
            0.7003475, 0.87750345, 0.16564246, 0.6314963, 0.21785556, 0.7654987, 0.13988015,
            0.03287261, 0.82226163, 0.60896695, 0.13331373, 0.62307173, 0.23316076, 0.9600204,
            0.55291533, 0.29808274, 0.8765127, 0.98263544, 0.27148733, 0.11101003, 0.2754741,
            0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969,
            0.5836321,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(kernel16, None, 2, Padding::Same);
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            1.2690394, 1.9127274, 2.3333526, 2.4540253, 2.8949182, 2.0459442, 2.8900764, 1.7054441,
            3.4808767, 2.8175077, 2.009529, 1.750587, 2.2414193, 1.823751, 3.1301754, 1.6693258,
            3.614348, 1.0873612, 3.632897, 1.9111977, 3.8477855, 2.084423, 2.6462836, 1.2017223,
            3.0903995, 2.73666, 4.819514, 3.1965244, 4.2215676, 3.246152, 4.953842, 3.197672,
            4.7083, 2.84327, 2.746136, 1.0431367, 2.1652281, 1.5948101, 3.406911, 1.5357907,
            3.735305, 1.4143894, 2.5460706, 1.3466762, 2.5045202, 1.072382, 1.3974824, 0.42277142,
            3.3163593, 4.3494244, 5.1701293, 3.5355794, 5.707375, 2.36276, 3.817216, 3.2363997,
            3.2608054, 2.2201698, 2.392324, 0.6054511, 2.6102538, 2.0765634, 3.1330996, 1.3987541,
            2.895922, 1.0066302, 2.4686687, 1.3645579, 2.2125509, 0.8759391, 1.6778634, 0.47644415,
            4.0867276, 3.4254572, 4.7367735, 4.0149474, 4.3868933, 3.0279768, 3.8431802, 1.7689271,
            3.9572413, 2.9622204, 2.5115755, 1.7209679, 2.2751448, 1.9314815, 3.2967448, 2.1629202,
            3.841405, 1.1425979, 2.8383112, 1.3348677, 3.3560734, 1.8315387, 2.6685133, 0.9968337,
            3.3514633, 3.3617468, 5.2970905, 4.2357283, 4.7390523, 2.3510354, 4.3286643, 3.1305285,
            4.934714, 3.724031, 3.6020222, 2.516333, 2.089882, 1.8649099, 3.4073303, 2.1563475,
            3.8815029, 1.7498769, 2.9960585, 1.7511195, 3.3564587, 1.9298834, 2.2094588, 1.4668368,
            2.4841902, 2.1676562, 3.7125843, 2.6590645, 3.9506612, 2.3796718, 3.0714679, 1.9982096,
            3.6563163, 2.247236, 2.5275254, 1.6910776, 0.98682845, 0.76699066, 1.46283, 1.142932,
            1.9821756, 0.79081225, 1.3372672, 0.89637566, 1.749285, 0.84287536, 1.321261,
            0.8892488,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643, 0.91682273,
            0.6142979, 0.19277428, 0.28408903, 0.25507236, 0.9800453, 0.36125833, 0.96792,
            0.33258557, 0.9508625, 0.8424581, 0.8130291, 0.7774976, 0.17691322, 0.9389267,
            0.22419459, 0.33442205, 0.7614585, 0.37563834, 0.70754576, 0.1499497, 0.9873837,
            0.7166968, 0.40278858, 0.22288306, 0.3279577, 0.07722609, 0.598755, 0.8143903,
            0.87905455, 0.83061284, 0.9923988, 0.6196494, 0.536406, 0.06662867, 0.83588266,
            0.28182983, 0.662181, 0.99850965, 0.60448396, 0.12318801, 0.91713256, 0.8540598,
            0.19103892, 0.5929614, 0.9118344, 0.9381113, 0.3421722, 0.8149188, 0.9595595,
            0.02717085, 0.8916309, 0.9755575, 0.27588442, 0.59208006, 0.00008138, 0.9552037,
            0.12578069, 0.01249961, 0.05413999, 0.5153533, 0.40144867, 0.8698811, 0.6468678,
            0.8840439, 0.34315115,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794, 0.6930413,
            0.90735817, 0.91156703, 0.45996496, 0.9045769, 0.17170428, 0.43418503, 0.69308424,
            0.42869946, 0.9244341, 0.41451567, 0.6224708, 0.00536506, 0.33826837, 0.47926104,
            0.0032256, 0.02230139, 0.35960108, 0.48593593, 0.86064774, 0.28908366, 0.4153976,
            0.3468706, 0.2242362, 0.93169004, 0.3198661, 0.5576108, 0.17364207, 0.69407916,
            0.88076496, 0.11111139, 0.19382912, 0.9307082, 0.9188555, 0.10532705, 0.88550454,
            0.20754221, 0.97926295, 0.3472928, 0.71126235, 0.03633394, 0.7482733, 0.28782296,
            0.7382309,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(kernel17, None, 2, Padding::Same);
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            3.756562, 2.6243544, 5.419595, 2.8873684, 4.4311037, 2.2139666, 2.7032065, 1.415283,
            3.8933434, 1.6374657, 2.139997, 2.253262, 3.3268223, 3.552504, 4.65718, 3.0447762,
            3.960491, 1.9435403, 2.8642764, 1.3015323, 3.6497724, 2.2272434, 2.2014816, 1.8736844,
            4.692574, 2.7206407, 6.6490808, 3.0715156, 6.7380605, 3.1012323, 6.0666704, 3.0322516,
            6.8143387, 2.4110515, 3.4923692, 2.7515023, 3.163004, 2.3314319, 3.8215032, 2.951498,
            4.049126, 2.9886594, 4.5685253, 2.717324, 4.937408, 2.944136, 2.896591, 1.703918,
            4.3826528, 3.0083165, 6.0750775, 2.5347238, 6.7914467, 2.6411488, 6.7248454, 3.0420628,
            6.3819113, 3.0065222, 3.912824, 2.2416449, 3.5380054, 2.6884553, 3.961806, 1.8424964,
            4.3558517, 3.0852218, 4.35328, 2.98095, 4.6906824, 2.6534, 2.8635666, 1.0814642,
            3.732158, 2.814846, 5.797167, 2.5830727, 6.2584524, 2.2910028, 5.973659, 3.1551576,
            6.45218, 2.7861528, 3.7923536, 1.5367098, 2.2570388, 2.660833, 3.9834802, 2.408318,
            3.3282967, 1.9412036, 3.450112, 3.2994337, 3.1587102, 2.469009, 1.7171656, 0.65081847,
            3.2621229, 2.1846366, 5.730932, 1.6870824, 4.793505, 2.507076, 6.3565946, 2.8296187,
            5.8744016, 2.6792936, 3.4633703, 1.5494133, 2.1841698, 1.5235362, 2.877402, 1.6122997,
            3.6097777, 2.3001833, 4.8231397, 1.9419308, 4.3106937, 1.845851, 2.4858868, 0.9160809,
            1.6374798, 1.042817, 3.012043, 1.0004953, 3.4476228, 1.3744195, 3.979608, 1.6491272,
            3.3029668, 1.8408824, 2.0166128, 1.0890584, 0.59115446, 0.9972904, 0.70484686,
            1.1971784, 1.1006082, 1.6732544, 1.6811504, 1.7570685, 1.9663742, 1.5383244, 1.2009087,
            0.34075138,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.60003114, 0.3259743, 0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927,
            0.968827, 0.47373444, 0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834,
            0.3979838, 0.2393961, 0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945,
            0.66457146, 0.8425775, 0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123,
            0.48163053, 0.437191, 0.43973154, 0.29997745, 0.21913478, 0.6611514, 0.209788,
            0.176356, 0.88925517, 0.14793599, 0.36509594, 0.5616029, 0.6617385, 0.30053073,
            0.36820948, 0.62227124, 0.4957459, 0.69923055, 0.3227648, 0.9702412, 0.5679234,
            0.13432135, 0.7430913, 0.19231908, 0.26170298, 0.10480803, 0.00958306, 0.20726651,
            0.20851518, 0.17973869, 0.23704103, 0.1163867, 0.2735905, 0.8537909, 0.40303,
            0.75797635, 0.34342998, 0.74670875, 0.82946825, 0.91931367, 0.9654975, 0.18782942,
            0.10021565, 0.05109123,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.3069365, 0.10895161, 0.9891213, 0.62504834, 0.507994, 0.47125, 0.84314245, 0.6054993,
            0.92367506, 0.6953895, 0.37023902, 0.67128026, 0.43450755, 0.28869846, 0.27641538,
            0.8369712, 0.6856483, 0.26890948, 0.65425915, 0.84581685, 0.51146317, 0.48995435,
            0.52071315, 0.80564773, 0.670521, 0.3835857, 0.47078377, 0.5100531, 0.82525116,
            0.02126783, 0.9583153, 0.23316967, 0.9487504, 0.9609589, 0.95734006, 0.00943314,
            0.7521432, 0.46106157, 0.84370506, 0.16933449, 0.71423984, 0.5316646, 0.6400151,
            0.9638914, 0.69432026, 0.8581641, 0.70813745, 0.2836983, 0.33953485, 0.8950543,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(kernel18, None, 2, Padding::Same);
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            2.1151824, 2.3341742, 2.7730367, 2.472099, 2.443064, 2.1902766, 2.4140577, 2.5380576,
            2.2380104, 2.031819, 1.6737024, 1.4067705, 2.8775973, 3.4265745, 4.93293, 3.1446223,
            4.419265, 3.0299878, 4.653687, 3.1344082, 4.296565, 2.5484986, 2.904684, 1.7555399,
            2.228706, 3.2837667, 4.3570914, 3.3449068, 3.7630947, 3.8539915, 3.7271128, 2.8291554,
            2.847681, 2.7848542, 2.1053295, 1.2173381, 2.623924, 2.855207, 4.131708, 2.9839425,
            4.6026616, 3.0129313, 3.7896898, 2.467386, 3.5472665, 2.1534119, 2.0305953, 1.4034523,
            2.4985445, 2.852765, 3.8944416, 3.4414825, 5.0040417, 3.3849113, 4.04088, 2.7705529,
            4.459237, 2.7071342, 2.3016071, 1.2213823, 1.6207647, 1.8878545, 2.967404, 2.788601,
            3.3806474, 2.915028, 3.5837872, 2.2837062, 2.373856, 1.9540093, 1.745739, 0.62098,
            2.2834747, 2.397598, 4.2946553, 3.7244492, 3.916211, 3.082763, 4.1203947, 2.8997033,
            2.9182258, 2.2684443, 2.0962176, 1.1607258, 2.529427, 2.3333561, 4.138, 3.48329,
            4.8184996, 3.1092496, 4.6400514, 3.0439436, 4.1627493, 2.4541888, 2.704275, 1.5150082,
            2.6030612, 3.581933, 3.8622134, 4.31906, 3.8491392, 3.8827703, 3.88726, 3.1983223,
            2.9243488, 2.593495, 2.0688717, 1.2946985, 3.5510921, 3.249939, 5.5849514, 3.5272112,
            5.207821, 3.4063168, 4.0594893, 2.6014938, 3.2425687, 1.7935834, 1.6383724, 1.2177746,
            2.1686661, 3.2635393, 2.9025471, 3.1728303, 3.644723, 3.0257826, 2.5967607, 1.753551,
            2.6844993, 1.5495372, 1.2449658, 0.6997752, 1.5568032, 1.7816613, 2.4898968, 1.7459517,
            2.2564044, 1.6271852, 1.4008805, 0.81073344, 0.9942765, 0.38193431, 0.32714695,
            0.16462892,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.20262088, 0.81930757, 0.09556881, 0.22266188, 0.63842744, 0.8304186, 0.12425002,
            0.7582065, 0.09737789, 0.84872884, 0.17490041, 0.37569723, 0.6669188, 0.8970669,
            0.22398192, 0.29424527, 0.56277037, 0.41113177, 0.7882464, 0.24159203,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633, 0.9636684, 0.98529965,
            0.26998708, 0.13811645, 0.9724998, 0.41856614, 0.13321315, 0.0937838, 0.4742414,
            0.79873264, 0.1621314, 0.5493846, 0.6481355,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(kernel19, None, 2, Padding::Same);
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            0.00895915, 0.82187486, 0.03622678, 0.86263293, 0.0042257, 0.2623909, 0.00984529,
            0.7028486, 0.02822892, 0.61523235, 0.3012574, 1.1640244, 0.25809243, 0.66041416,
            0.25091484, 0.5239997, 0.08902745, 1.1538761, 0.42435586, 0.3548543, 0.03671807,
            0.89527595, 0.00549388, 0.69962054, 0.03352511, 0.80513537, 0.00430569, 0.74295723,
            0.03752768, 0.81789315, 0.27613044, 0.49723807, 0.14509091, 1.2464672, 0.40271503,
            0.9000986, 0.29263112, 1.2538815, 0.29564634, 0.18760021, 0.00773346, 0.45588344,
            0.01661195, 0.8721145, 0.02948871, 1.3287753, 0.03966501, 1.0357789, 0.00990366,
            0.2158443, 0.13458265, 0.79410917, 0.26852065, 1.1103472, 0.30212504, 1.5356275,
            0.47622788, 0.7241933, 0.13220121, 0.10684561, 0.01301045, 0.7139679, 0.02488364,
            0.8567622, 0.01817874, 0.9990543, 0.03485337, 0.9443804, 0.01068231, 0.23281461,
            0.07944242, 0.59513754, 0.15194073, 0.48281583, 0.11100026, 0.8334429, 0.21281634,
            0.34691036, 0.06522673, 0.03336783, 0.09609121, 0.23867768, 0.38854957, 0.6633705,
            0.04532269, 0.097216, 0.10559548, 0.23772147, 0.30276874, 0.5099328, 0.4589019,
            0.49561703, 0.5021218, 1.3004243, 0.3698636, 0.29374507, 0.16308609, 1.0861847,
            0.7059913, 0.5268493, 0.39381889, 0.6749351, 0.0589245, 0.17035003, 0.35957292,
            0.61473674, 0.04618063, 0.15737592, 0.40250236, 0.6779074, 0.5294266, 0.94703305,
            0.22551517, 0.90208614, 0.6956966, 1.4684483, 0.42897972, 0.53804314, 0.5600298,
            0.5799286, 0.08294502, 0.17493299, 0.17817119, 0.36262783, 0.3162805, 0.61682016,
            0.42542627, 0.7375225, 0.1062215, 0.17890167, 0.2192487, 0.7607629, 0.4419589,
            0.8264252, 0.53848076, 1.399034, 0.822768, 0.9576884, 0.22417447, 0.17735386,
            0.1395433, 0.28780204, 0.266889, 0.48806056, 0.1949757, 0.40230912, 0.37381908,
            0.65225554, 0.11457295, 0.19296744, 0.16165382, 0.28195354, 0.30917737, 0.43140882,
            0.22586946, 0.39426857, 0.43305042, 0.55006015, 0.13272694, 0.15658437,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.05176858, 0.17029643, 0.955536, 0.089831, 0.05664136, 0.9231865, 0.98567015,
            0.01680515, 0.54690886, 0.8593988, 0.6496963, 0.8382851, 0.2400014, 0.36792266,
            0.01756373, 0.6596718, 0.5680892, 0.19350345, 0.4854058, 0.7869872,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.12335967, 0.14544043, 0.25711668, 0.05608724, 0.18204254, 0.9562488, 0.44598028,
            0.3229758, 0.8930679, 0.24216229, 0.21437034, 0.38366762, 0.64894366, 0.8650639,
            0.7790032, 0.3529938, 0.37360683, 0.26240814,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(kernel20, None, 2, Padding::Same);
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            0.00942408, 0.0590551, 0.0310012, 0.21643914, 0.1739482, 0.9187686, 0.01635306,
            0.08907765, 0.01031114, 0.05416323, 0.15098864, 0.4811403, 0.19835792, 0.8337418,
            0.31105918, 0.96520877, 0.1085559, 0.35212064, 0.14328511, 0.27155033, 0.16805921,
            0.93807954, 0.1794339, 0.9434884, 0.00305925, 0.04674451, 0.09956068, 0.57118225,
            0.15644714, 0.8217991, 0.392659, 1.5345159, 0.44026816, 1.1329087, 0.04033356,
            0.36601388, 0.23014916, 0.96846735, 0.2801195, 0.7720174, 0.11827236, 0.6682884,
            0.15260355, 0.8150701, 0.04369046, 0.25013682, 0.06697758, 0.35281074, 0.00319735,
            0.01679529, 0.30577913, 1.1937735, 0.35336894, 1.0256171, 0.10565788, 0.48805624,
            0.18942775, 0.5583014, 0.12013241, 0.21803313, 0.12008832, 0.66267294, 0.1034164,
            0.55408764, 0.03522586, 0.21226253, 0.0883645, 0.50830865, 0.14326514, 0.75255555,
            0.21305802, 0.8424883, 0.18347907, 0.5936409, 0.06249693, 0.38929313, 0.15677433,
            0.7844811, 0.25417784, 0.702833, 0.04478313, 0.15084068, 0.14731729, 0.7527505,
            0.8265997, 0.8026609, 0.07770956, 0.10673569, 0.0489984, 0.0441238, 0.2172449,
            0.666587, 0.27492237, 0.7642247, 0.3605973, 0.4213385, 0.15080252, 0.46151164,
            0.20539121, 0.34458664, 0.7986153, 1.3588096, 0.8526677, 0.7787458, 0.01453753,
            0.3680043, 0.47311112, 0.98374516, 0.74343485, 0.6694744, 0.48418438, 1.0424556,
            0.5479566, 0.64432216, 0.0577277, 0.378643, 0.2832006, 0.59228903, 0.3248424,
            0.23225187, 0.5620288, 1.0501153, 0.7251702, 0.8087741, 0.20761654, 0.42572296,
            0.3182766, 0.2980108, 0.01519375, 0.0136822, 0.38414502, 0.8570595, 0.4349705,
            0.5695085, 0.13114756, 0.38464072, 0.24151501, 0.4795589, 0.17526865, 0.30655035,
            0.57065827, 0.88254434, 0.49143344, 0.5681161, 0.16739285, 0.4657408, 0.41990703,
            0.88884306, 0.6807942, 0.61306554, 0.24645789, 0.3736352, 0.212242, 0.21737674,
            0.07229421, 0.22212212, 0.18135092, 0.40517598, 0.29402378, 0.20651184,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.554433, 0.90017563, 0.6817857, 0.95833224, 0.28551313, 0.85106283, 0.70093375,
            0.4791875, 0.5805011, 0.9803199, 0.97033703, 0.48236644, 0.66855663, 0.35855147,
            0.25242767, 0.6717967, 0.26290378, 0.53677225, 0.18097793, 0.07985484,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.79416144, 0.7215235, 0.42313012, 0.6529702, 0.00384528, 0.08442257, 0.7838985,
            0.980683, 0.36212954, 0.61172485, 0.5263662, 0.8496614, 0.13177402, 0.9175598,
            0.04323238, 0.03087392, 0.03482862, 0.36226457,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(kernel21, None, 2, Padding::Same);
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            0.00213195, 0.6345945, 0.00346143, 0.52118087, 0.00262166, 0.6833205, 0.00368506,
            0.26733643, 0.00109788, 0.02410375, 1.1577849, 1.8231877, 1.3885272, 1.5375694,
            1.0143607, 1.6619002, 1.3586653, 1.5950135, 0.9873218, 0.5181956, 0.00327257,
            0.52953774, 0.00269529, 0.37206978, 0.00184261, 0.41950414, 0.00223219, 0.6891271,
            0.0037696, 0.08276112, 1.5347438, 1.6513115, 1.0354326, 1.3645089, 0.9523104,
            1.1962161, 0.8279909, 1.3308702, 1.1435156, 0.46181256, 0.00373122, 0.39688927,
            0.00185483, 0.47727016, 0.00257079, 0.2905647, 0.00137873, 0.19509758, 0.00097065,
            0.02131059, 1.4363102, 1.2225595, 0.6627399, 1.236286, 1.042936, 0.8940223, 0.48220518,
            0.46771458, 0.3051687, 0.12520051, 0.00258325, 0.22838314, 0.00101094, 0.3726913,
            0.00206404, 0.16348888, 0.00069591, 0.06742145, 0.00030706, 0.00674155, 0.6588196,
            0.44936728, 0.2578253, 0.5159802, 0.5264034, 0.3362494, 0.17748198, 0.12813553,
            0.07831229, 0.0289178, 0.5087254, 0.14258923, 0.825965, 0.12875837, 0.6255792,
            0.1557585, 0.8793271, 0.0790542, 0.26197538, 0.01234341, 0.46728083, 1.3805373,
            0.40029967, 1.2358384, 0.27597374, 1.0388284, 0.3389335, 1.4489002, 0.52595127,
            0.93637127, 0.7809011, 0.12915833, 0.64314866, 0.09344749, 0.43968317, 0.09721138,
            0.53264445, 0.15427715, 0.89950216, 0.04238157, 0.54039395, 1.449484, 0.27831393,
            1.0875387, 0.36859503, 0.9788966, 0.20894742, 0.69962496, 0.16701259, 0.5696132,
            0.89034224, 0.10551335, 0.44260007, 0.10895225, 0.6134407, 0.07615107, 0.32899243,
            0.04876444, 0.23161748, 0.01091305, 0.38740656, 1.0980357, 0.15518382, 0.74712133,
            0.30582365, 0.8200476, 0.10774851, 0.34030306, 0.05082459, 0.15929517, 0.61641365,
            0.06368726, 0.24122994, 0.0820986, 0.49252063, 0.04705413, 0.16605806, 0.0183469,
            0.07327159, 0.00345231, 0.02339775, 0.251485, 0.00915658, 0.11181299, 0.01869504,
            0.20004107, 0.00630321, 0.06802732, 0.00278123, 0.02892858,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.6059544, 0.29194582, 0.34645593, 0.9409913, 0.60953087, 0.8610255, 0.1627552,
            0.8939359, 0.66327935, 0.48094535, 0.06551108, 0.86129206, 0.65446067, 0.9592776,
            0.8000413, 0.21450381, 0.6442533, 0.46971878, 0.84573215, 0.34651902,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.18830031, 0.57119006, 0.27269888, 0.7915957, 0.21737069, 0.04463017, 0.393406,
            0.8441482, 0.77705365, 0.6315176, 0.8522896, 0.16809769, 0.22305161, 0.773223,
            0.9678148, 0.2237789, 0.8982615, 0.271913, 0.34780893, 0.49277794, 0.14560463,
            0.33638617, 0.1585067, 0.18610527, 0.6963084, 0.9429821, 0.40789625, 0.20056698,
            0.37306353, 0.9367061, 0.7103306, 0.06833509, 0.48335183, 0.45182207, 0.96346164,
            0.00378525, 0.33689302, 0.28288215, 0.75004077, 0.1607512, 0.514175, 0.35879079,
            0.36688787, 0.00774159, 0.15532039, 0.01133456, 0.94680935, 0.052598, 0.73530346,
            0.8096563,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(kernel22, None, 2, Padding::Same);
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            0.6494291, 1.2921616, 1.3467247, 0.92342126, 1.5658734, 1.5125606, 1.5304449,
            1.6298171, 1.3219929, 0.8520175, 0.96419513, 1.2060919, 1.1765531, 0.89089864,
            1.3356438, 1.9213309, 1.7089006, 1.5794137, 1.4543009, 0.58572066, 0.64937055,
            1.447921, 2.522509, 1.5026067, 1.8637521, 2.2497194, 2.4566615, 2.1902056, 1.9277313,
            1.1186242, 0.3642859, 0.83541214, 1.4662318, 1.7863349, 1.6108986, 1.7926539,
            1.9872736, 1.7228605, 1.738779, 0.7889521, 1.0886669, 0.9482172, 1.8795656, 1.8852683,
            2.576116, 1.9116818, 2.724832, 2.0288498, 1.9232662, 0.9824197, 0.42037845, 1.2165849,
            1.1132053, 1.5728514, 1.658163, 1.7870221, 1.7884003, 1.8457935, 1.5168607, 0.5475254,
            0.7327279, 0.5760755, 1.0290672, 0.95755255, 2.2922347, 0.9498493, 1.6628255,
            1.1598381, 1.6905687, 0.41682836, 0.20249668, 0.6533143, 0.38599676, 0.64600736,
            0.6344535, 0.923061, 0.53897625, 0.60541785, 0.5109812, 0.12052241, 0.49868733,
            0.9404495, 1.8634424, 0.761041, 1.1057072, 1.1809136, 1.7481, 1.3547497, 1.0414505,
            0.63659614, 0.9042168, 0.50959074, 1.9225905, 0.2611889, 1.7163314, 0.7895264,
            2.2359557, 0.55852854, 1.2412946, 0.22202046, 1.1046883, 1.7983702, 1.5489888,
            1.5541991, 2.3894389, 2.6750731, 2.2299263, 2.6127427, 2.0956364, 1.1073849, 1.0430515,
            0.15351659, 1.5973951, 0.7558693, 2.521856, 0.60615116, 2.2919958, 0.6657872,
            1.5904024, 0.36519963, 0.7194668, 1.4693246, 1.7455595, 2.2644928, 2.0087295,
            2.6195652, 2.080091, 2.3889563, 1.8045502, 1.082978, 1.0282037, 0.45047346, 1.5144029,
            0.56466836, 2.3156285, 0.619269, 1.9724449, 0.70027363, 1.4248419, 0.16275853,
            0.07632607, 1.241581, 0.32426924, 1.8944218, 0.9822877, 2.0267096, 0.9054744, 2.21392,
            1.0527422, 0.8481766, 0.4099578, 0.23281275, 0.51120317, 0.17351833, 0.7072542,
            0.30707726, 0.5614172, 0.13087514, 0.25849307, 0.00268261,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.7097644, 0.37942106, 0.38656324, 0.13763146, 0.99930644, 0.67476803, 0.06055127,
            0.8463604, 0.4460729, 0.33209085, 0.94373864, 0.5397614, 0.05766413, 0.64256257,
            0.7357459, 0.09256811, 0.8832945, 0.03911254, 0.782554, 0.4004812,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.80732703, 0.8010379, 0.28867772, 0.7802926, 0.9490529, 0.5395702, 0.1369102,
            0.4513485, 0.1162144, 0.9589836, 0.24819064, 0.3149064, 0.22322156, 0.39812055,
            0.45308354, 0.5711523, 0.97817534, 0.06805564, 0.5386646, 0.6699801, 0.1879456,
            0.8407316, 0.64728755, 0.53731096, 0.63207716, 0.00916763, 0.46754488, 0.8670982,
            0.1932068, 0.43971533, 0.10441232, 0.46486124, 0.22910197, 0.7679019, 0.23872072,
            0.03931138, 0.8551502, 0.19610135, 0.8555064, 0.08035298, 0.05671094, 0.9091975,
            0.27582648, 0.33816597, 0.42012835, 0.7745094, 0.14011143, 0.47505257, 0.98297566,
            0.5085966,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(kernel23, None, 2, Padding::Same);
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            0.49627864, 0.97707427, 1.8433789, 0.99800104, 0.95427597, 1.2149699, 1.6540043,
            0.9835666, 0.8046393, 0.65697247, 0.6022379, 0.8401731, 1.8532282, 0.7054196,
            1.0398798, 0.5022868, 2.031279, 1.1489408, 0.7378841, 0.57688475, 1.4045836, 2.156824,
            2.3942032, 1.286857, 1.8906465, 1.3605523, 1.9209145, 2.287015, 1.8322897, 1.2432475,
            0.7976999, 0.60627824, 2.119367, 0.93112856, 1.2432998, 0.98691666, 1.529382,
            0.7405329, 1.2697453, 0.26438984, 1.5326056, 1.7389463, 1.5615759, 1.6977046, 2.568217,
            1.7124653, 1.8246284, 1.9378091, 1.8105748, 0.7838441, 0.8908926, 1.1680298, 1.2105038,
            0.45516244, 2.0195162, 0.77128553, 1.1093874, 1.2115881, 1.4117888, 0.44286194,
            0.9522047, 1.2758839, 1.205553, 0.70247424, 1.1024225, 0.833209, 0.882451, 1.4014857,
            1.3263466, 0.55476415, 0.51079553, 0.9138801, 0.14447117, 0.5140584, 1.0414091,
            0.7865435, 0.3081976, 0.8132749, 0.55155057, 0.21572503, 0.7397466, 1.0903502,
            0.50360185, 1.0625772, 0.876296, 0.82048464, 0.8593265, 1.2137533, 0.6911249,
            0.91907525, 0.37820214, 1.1312904, 0.6880928, 0.9197072, 0.5287683, 1.1131405,
            0.59595454, 1.4520257, 0.51602757, 0.5929446, 1.5890062, 1.8145907, 1.823522,
            1.3339369, 0.9648132, 1.81636, 1.7937628, 1.4090501, 1.5661973, 1.4085509, 0.46212295,
            1.2588495, 0.7031599, 1.2312747, 0.49333978, 1.0347615, 0.73525083, 1.2882277,
            0.60096115, 0.6772825, 0.6620984, 2.3715806, 2.0183764, 0.87813145, 1.2877758,
            1.8667071, 1.7585567, 2.0023358, 1.2719018, 1.0332483, 0.40435284, 1.2915827,
            0.7771883, 0.9314225, 0.5806444, 0.99753, 0.47362372, 1.673324, 0.75145984, 0.5563345,
            0.91925204, 1.837841, 0.9632497, 1.327763, 0.9089937, 0.84937507, 1.0767671, 1.7466613,
            0.81773853, 1.0658345, 0.0756252, 0.8343926, 0.28474462, 0.33426118, 0.4262647,
            0.7247226, 0.25499308, 0.6287496, 0.43923643, 0.13542911,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.22395916, 0.01153891, 0.669607, 0.12918296, 0.55476546, 0.528783, 0.5067741,
            0.14234911, 0.5152856, 0.6446142, 0.9118427, 0.8193508, 0.989135, 0.7842302,
            0.59264964, 0.35247177, 0.48483032, 0.22649786, 0.04158387, 0.5814206,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.8653732, 0.4524277, 0.44947338, 0.5519129, 0.79122764, 0.7513198, 0.9315116,
            0.03313805, 0.41213843, 0.45310238, 0.01799934, 0.4328227, 0.23842481, 0.20688592,
            0.57869387, 0.9324833, 0.43915927, 0.53123087, 0.5324186, 0.4149537, 0.22217223,
            0.0080786, 0.65063345, 0.7681623, 0.8421627, 0.27179125, 0.68530315, 0.9955617,
            0.77906156, 0.18006648, 0.5975193, 0.6555531, 0.9498266, 0.9690994, 0.5122471,
            0.3840358, 0.8757204, 0.7260429, 0.04691354, 0.40678895, 0.35535267, 0.19270384,
            0.23519029, 0.6665529, 0.26402712, 0.55168146, 0.08576613, 0.9567203, 0.57141143,
            0.20602623,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(kernel24, None, 2, Padding::Same);
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            0.72982776, 0.5724491, 0.9137618, 0.6363062, 1.0795239, 0.5061394, 1.3303529,
            0.8428753, 0.9044724, 0.47054407, 0.52800614, 0.81430525, 1.0867959, 0.64166856,
            1.102447, 0.95190513, 1.429677, 1.1252445, 0.6031519, 0.5610378, 1.4023689, 1.3748261,
            2.7200015, 1.080452, 2.5821035, 1.6686116, 2.636043, 1.1902821, 1.8085115, 0.8866025,
            1.3992754, 1.6431286, 1.8048393, 1.5914066, 1.7596388, 1.4402618, 1.8533326, 1.4327074,
            0.9312344, 0.5874583, 1.2667747, 1.3674507, 2.2403157, 1.358125, 1.8793904, 0.80140156,
            2.0694602, 1.1057904, 1.742729, 0.9386728, 1.6243727, 1.4421997, 2.0819333, 1.281428,
            1.8551595, 1.0031202, 1.9205259, 1.2365447, 0.6783619, 0.5551635, 0.86807704,
            0.9898294, 1.8444209, 0.8357232, 1.8431447, 0.8310094, 1.6263821, 0.86745894,
            1.2087365, 0.5755389, 0.63934004, 0.40058026, 0.61502177, 0.35760134, 0.36028105,
            0.13885362, 0.65824175, 0.27747628, 0.32612395, 0.30955914, 0.8312082, 0.77985996,
            0.9950652, 1.0792903, 0.9134887, 0.6085673, 1.2930624, 1.3350753, 1.1898726, 0.5282202,
            0.86183286, 0.99616486, 1.1370631, 0.721159, 0.9091308, 0.9469701, 1.3518337,
            1.1149545, 1.0408086, 0.9944758, 1.9296587, 1.8694472, 2.3130455, 1.5286376, 2.567091,
            2.1596575, 2.3671193, 1.7271806, 1.9662334, 0.808951, 1.6601185, 1.8709134, 2.1457427,
            1.807686, 2.178199, 1.6668555, 1.9935236, 1.6161951, 1.2522904, 1.0040059, 2.2448523,
            1.7127696, 2.6256974, 1.7393619, 2.2015967, 1.0636575, 2.317495, 1.3363583, 2.058511,
            0.84910566, 1.1300975, 1.4250957, 1.5613406, 1.3550808, 1.2159779, 1.0571944,
            1.1591318, 1.0583878, 0.91999346, 0.9584867, 1.766501, 1.0324214, 2.099813, 0.7741146,
            1.925419, 0.6795051, 1.6266453, 1.0100601, 1.167624, 0.36592326, 0.2551837, 0.32836974,
            0.2875761, 0.36681205, 0.19605538, 0.15898617, 0.27619106, 0.13975984, 0.14772375,
            0.38754758,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.75538653, 0.96776, 0.44755465, 0.82362133, 0.29203537, 0.30861592, 0.39762703,
            0.26186082, 0.9658112,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.27424002, 0.50570756, 0.8114843, 0.5536027, 0.59788686, 0.05054026, 0.28394443,
            0.6402348, 0.02258505, 0.60607, 0.6834324, 0.8004999, 0.3349493, 0.4295082, 0.37033585,
            0.0394791, 0.50698835, 0.29841292,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(kernel25, None, 2, Padding::Same);
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.4516357, 0.573932, 0.578611, 0.2966783, 0.26758704, 0.02261953, 0.9001363, 1.040294,
            0.7672782, 0.4705545, 0.4426095, 0.26054502, 0.4924324, 0.2032976, 0.17460412,
            0.18561015, 0.1845174, 0.01559753, 0.7283941, 0.49600416, 0.3193962, 0.5715854,
            0.68600464, 0.7907107, 0.23773597, 0.16506302, 0.15656315, 0.54791015, 0.5774458,
            0.04881235, 0.25457466, 0.08333435, 0.16765241, 0.28015086, 0.618346, 0.0218129,
            0.3244447, 0.6038973, 0.4156609, 0.50830436, 0.19222839, 0.16574553, 0.9458617,
            1.099926, 0.6902295, 0.7272783, 0.43782312, 0.3806031, 0.35375214, 0.40283358,
            0.12543158, 0.21152186, 0.13255307, 0.11429154, 0.6893176, 0.7343149, 0.3270227,
            0.8942998, 0.81653136, 0.86522675, 0.17078407, 0.23496565, 0.11247137, 0.42047423,
            0.41482383, 0.3576745, 0.20159227, 0.12899508, 0.13276038, 0.11627201, 0.48965502,
            0.28821054,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9388161, 0.84357476, 0.29760668, 0.25654384, 0.71037215, 0.14646496, 0.9906275,
            0.9552909, 0.7966291,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.6094893, 0.7271988, 0.09518696, 0.3957746, 0.6157527, 0.31079137, 0.46793708,
            0.8514491, 0.86081386, 0.8208274, 0.2372746, 0.6977758, 0.79387194, 0.9463199,
            0.99063903, 0.29514915, 0.8795419, 0.741553,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(kernel26, None, 2, Padding::Same);
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.5780785, 0.6256414, 0.51943344, 0.37996092, 0.18325211, 0.09249359, 0.98591244,
            1.6602697, 1.2348428, 1.0223091, 0.35990608, 0.2701255, 0.15796757, 0.36087885,
            0.43741357, 0.27874464, 0.09018619, 0.04552004, 0.93881714, 1.2297804, 1.2995322,
            1.2565027, 0.70401514, 0.20190777, 0.6099816, 0.6859584, 0.588223, 0.6121818,
            0.4905265, 0.24758545, 0.8434689, 1.2997619, 0.81338155, 1.1951, 0.67828906,
            0.68574935, 0.8884203, 1.5997181, 0.79829156, 1.0719397, 0.2816311, 0.2948208,
            0.8865994, 1.7072653, 0.91051257, 1.3292967, 0.29650992, 0.32289082, 0.24277253,
            0.81808686, 0.6722393, 0.8199968, 0.1386027, 0.1450939, 0.4606918, 1.8752716,
            0.8514683, 1.8904815, 0.3178419, 0.66448, 0.9374505, 1.739733, 0.9040108, 1.5787699,
            0.7538659, 0.7891719, 0.8712984, 1.0165561, 0.84021837, 0.9435233, 0.70066863,
            0.5907427,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.03520088, 0.83411527, 0.47134155, 0.26704508, 0.2872401, 0.04289522, 0.583651,
            0.94414073, 0.5729697,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.72244126, 0.7707775, 0.02079507, 0.22973806, 0.18128674, 0.05054512, 0.6523751,
            0.27093726, 0.32479268, 0.53774405, 0.08921466, 0.18494032, 0.78120434, 0.15868789,
            0.81183356, 0.21792394, 0.6620494, 0.6886836,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(kernel27, None, 2, Padding::Same);
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.00638145, 0.19340725, 0.15121403, 0.15044555, 0.08544797, 0.02382401, 0.21536958,
            0.7686563, 0.4473911, 0.6153685, 0.16076666, 0.1539803, 0.04841173, 0.0794878,
            0.05207282, 0.02437325, 0.00777634, 0.00216814, 0.5222175, 0.9683459, 0.8055465,
            0.55484766, 0.45325407, 0.025847, 0.10580818, 0.24640577, 0.17116019, 0.17935464,
            0.1038718, 0.02896082, 0.1581328, 0.80549943, 0.2558029, 0.68044114, 0.15523884,
            0.18609636, 0.00558595, 0.68019176, 0.13236399, 1.0453768, 0.07479619, 0.38265088,
            0.04712906, 0.40986502, 0.57785153, 0.7533471, 0.31587827, 0.33253825, 0.04237682,
            0.44118935, 0.04558152, 0.26670107, 0.00680695, 0.03482378, 0.22886726, 0.86215276,
            0.27439833, 0.68988615, 0.07951605, 0.13550644, 0.09261835, 1.2113943, 0.1498237,
            1.2140915, 0.09092335, 0.46515602, 0.3864058, 0.6077018, 0.62506783, 0.77507806,
            0.37933424, 0.39459485,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.39724785, 0.59319293, 0.02472531, 0.21891202, 0.5342134, 0.4041879, 0.53426075,
            0.20461221, 0.29362342,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.7835011, 0.47930118, 0.2895624, 0.7320774, 0.55179524, 0.37774232, 0.04187773,
            0.23883641, 0.63051957, 0.97746944, 0.6415133, 0.4162999, 0.04763152, 0.75958186,
            0.13098118, 0.6238241, 0.4102024, 0.5710282, 0.59153587, 0.66274744, 0.6454271,
            0.8120847, 0.22876394, 0.6206928, 0.19057496, 0.4622738, 0.9772445, 0.17967562,
            0.27354005, 0.48198408, 0.09082693, 0.6217685, 0.0965838, 0.8904992, 0.5337058,
            0.17222154, 0.62424076, 0.95776683, 0.998361, 0.150883, 0.28713444, 0.35105017,
            0.1765902, 0.9674033, 0.65025777, 0.1959308, 0.3119046, 0.55247456, 0.38556734,
            0.18145509,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(kernel28, None, 2, Padding::Same);
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.88140815, 0.96499807, 0.6883127, 1.045685, 0.49068886, 0.31467772, 0.85096693,
            0.6387155, 1.1116774, 0.71479577, 1.0259681, 0.26947427, 1.1418866, 1.6061575,
            1.1248806, 1.2528379, 0.4058543, 0.53731567, 0.6631518, 0.6940605, 1.3842828,
            0.6231135, 0.8549814, 0.42422694, 0.55158406, 1.0606985, 0.69288915, 0.93747234,
            0.23505738, 0.47390753, 0.43271998, 0.39996684, 0.6540886, 0.2414805, 0.30327344,
            0.17368878, 0.76891744, 1.3488303, 1.0206794, 1.1487744, 0.4432889, 0.13524637,
            0.3101405, 1.1196375, 0.57530713, 1.3095645, 0.7142453, 0.38384834, 0.8279443,
            1.2363143, 1.4489464, 1.3649875, 0.74039626, 0.49337646, 0.26223403, 1.0022922,
            0.68431157, 1.0234628, 0.55631405, 0.6524841, 0.772548, 0.9121413, 0.74120474,
            0.7196118, 0.63233453, 0.44898382, 0.15309642, 0.5886747, 0.46784908, 0.30101907,
            0.1849017, 0.28405225,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.94255227, 0.7036003, 0.3402552, 0.16401337, 0.28418577, 0.5504918, 0.6148071,
            0.7740251, 0.37459207,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.25677747, 0.80441076, 0.17314304, 0.5946227, 0.30094627, 0.06480476, 0.5798754,
            0.62549657, 0.6065069, 0.9259787, 0.3677915, 0.69532603, 0.8356569, 0.39276573,
            0.18570696, 0.61698794, 0.9064707, 0.01547038, 0.2551995, 0.11438051, 0.03861368,
            0.6524532, 0.36442748, 0.08230381, 0.79969245, 0.27816203, 0.3741886, 0.44356522,
            0.27386904, 0.4171807, 0.14990133, 0.4750283, 0.6358263, 0.77572674, 0.7072159,
            0.34310365, 0.36999545, 0.8200852, 0.46510443, 0.9230857, 0.86201537, 0.04691705,
            0.12260284, 0.89921826, 0.47400048, 0.7492544, 0.05440097, 0.28273952, 0.9184355,
            0.9064988,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(kernel29, None, 2, Padding::Same);
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.1477988, 1.1855619, 1.1280677, 1.1247432, 0.59583855, 0.4609755, 0.5697009,
            1.1425995, 0.6939325, 0.9795671, 0.69322276, 0.42071003, 0.9174423, 1.7868749,
            1.908936, 1.5358781, 1.4972577, 0.46695954, 0.6125968, 1.1211852, 1.440527, 1.2581971,
            0.99205846, 0.3676779, 0.86919206, 0.97859174, 1.154747, 0.9470339, 0.88464785,
            0.1924345, 0.48707545, 0.85852957, 0.3134152, 0.53708756, 0.09432846, 0.0955957,
            1.1661813, 0.8499714, 1.9114156, 0.7369579, 1.2912574, 0.30901688, 0.8689577,
            1.1427969, 1.2055439, 1.1306037, 0.926221, 0.7329949, 1.5136939, 1.5433888, 2.58564,
            1.3527268, 1.9368587, 0.6711278, 0.77201897, 1.0054231, 1.5702156, 1.0597463,
            0.98777443, 0.7855934, 1.0290655, 0.7384309, 1.972297, 0.7895534, 1.4349488,
            0.67981565, 0.7425986, 0.58916074, 0.70922065, 0.7135923, 0.41281432, 0.33684003,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.7027802, 0.19125043, 0.8670149, 0.08634489, 0.722654, 0.77540857, 0.00211577,
            0.6443405, 0.2344423,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.9849179, 0.9893316, 0.87634915, 0.48734385, 0.8760625, 0.53053117, 0.01152504,
            0.6788874, 0.76156837, 0.4680538, 0.07214947, 0.549209, 0.8383253, 0.00365476,
            0.9782156, 0.7419056, 0.40790308, 0.00302504, 0.80174476, 0.7689671, 0.50054824,
            0.16478458, 0.89107823, 0.7763043, 0.73042727, 0.41667554, 0.7348974, 0.71259016,
            0.93557405, 0.37013116, 0.14954911, 0.33766475, 0.39673004, 0.03940821, 0.2414454,
            0.9373305, 0.84819096, 0.9272432, 0.8604789, 0.92845494, 0.8023847, 0.06647868,
            0.12827316, 0.02774826, 0.8982795, 0.1193029, 0.37523487, 0.28379655, 0.0638791,
            0.08446726,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(kernel30, None, 2, Padding::Same);
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.3903801, 0.864629, 2.38301, 1.5961884, 2.2265434, 0.38105932, 0.5860246, 0.71554816,
            2.1266298, 1.066279, 1.014344, 1.2856512, 1.4829631, 1.6127875, 2.6613872, 1.2657982,
            3.0391643, 0.79015535, 0.87968135, 0.37303668, 1.2066662, 1.389087, 1.0187888,
            0.8002236, 0.48692578, 0.53999746, 1.6542907, 0.8198875, 2.0456386, 0.60280985,
            0.47804627, 0.2645248, 0.17751016, 0.61222637, 0.49618587, 0.18796287, 1.1935537,
            1.378803, 2.5125237, 2.1459033, 1.8015263, 1.4715002, 0.38593215, 0.27963248,
            1.7750127, 0.35325155, 0.7651204, 0.05461561, 1.2496803, 1.2794069, 2.251753,
            2.3921936, 2.0577059, 0.9419449, 0.68812215, 0.26809147, 1.0836357, 0.17615573,
            0.9971927, 0.03075518, 0.7166409, 0.825025, 1.1240631, 1.0904161, 1.0967251,
            0.25126505, 0.51728034, 0.04289361, 0.27266505, 0.03346474, 0.6088705, 0.00650536,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );
}
