// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array2, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_transpose_stride1_same_bias() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(
        kernel1,
        Some(Array::from_shape_vec((1,), vec![0.14352316]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            2.2728443, 3.75373, 3.6355407, 2.4194517, 3.1045563, 4.7545576, 5.199625, 3.306072,
            3.7987893, 4.753667, 5.066922, 2.4152188, 3.0122, 5.330374, 3.8929133, 2.6810534,
            2.7327435, 3.701478, 3.060283, 1.7144849,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.8997107, 0.64410555, 0.04471071, 0.767672, 0.43464628, 0.16569944, 0.18875164,
            0.12285258, 0.2781115, 0.5390728, 0.5066572, 0.97435564, 0.39133722, 0.7964828,
            0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183, 0.81628793,
            0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133, 0.0067116,
            0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715, 0.7567798,
            0.23972042, 0.38848338, 0.00744711, 0.8715701, 0.07988323,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.6283005, 0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194, 0.34163022,
            0.03235205, 0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297, 0.97700953,
            0.18019113, 0.775954, 0.14120784, 0.3426181,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(
        kernel2,
        Some(Array::from_shape_vec((1,), vec![0.5417864]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            4.4261913, 4.4449716, 4.1786127, 1.9854674, 4.893525, 5.3289795, 4.791672, 2.3636212,
            3.9498923, 5.1606207, 4.5350504, 2.5437014, 2.8644495, 4.5496287, 5.5903716, 2.9153159,
            1.6553848, 3.1637242, 3.1760325, 2.0061834,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.7768226, 0.34603763, 0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802,
            0.629322, 0.60627973, 0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678,
            0.89887625, 0.6572328, 0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983,
            0.6908677, 0.5511301, 0.36253917, 0.36786652, 0.88718724, 0.69587743, 0.4870034,
            0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529, 0.5566727, 0.7035832,
            0.92333794, 0.85647196, 0.36252776, 0.9373231, 0.01684272,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754, 0.31284246, 0.4031665,
            0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259, 0.23846498, 0.82509995,
            0.97324103, 0.96826524, 0.77620417, 0.8427075,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(
        kernel3,
        Some(Array::from_shape_vec((1,), vec![0.42989048]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            3.0516624, 4.379607, 4.7501454, 3.4499035, 5.020159, 6.7702, 6.723853, 5.5876184,
            4.409551, 6.5021152, 7.57589, 5.6318374, 4.831626, 6.155262, 7.060836, 5.256997,
            3.0740163, 4.6250186, 5.567507, 4.6789284,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.76771307, 0.54514444, 0.7878393, 0.21897991, 0.975659, 0.73295325, 0.69994044,
            0.86701024, 0.76087946, 0.623545, 0.14890751, 0.8610666, 0.21943341, 0.1644093,
            0.6089244, 0.8612485, 0.02602104, 0.30423534, 0.5087405, 0.16869895, 0.3329467,
            0.179494, 0.33126613, 0.11996287, 0.21606164, 0.87119263, 0.33579683, 0.2313126,
            0.2576527, 0.3748985, 0.30113342, 0.8142977, 0.423247, 0.8179498, 0.92175007,
            0.21606776, 0.19149332, 0.4240341, 0.14780204, 0.46443272,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.00207204, 0.359202, 0.9019851, 0.21363449, 0.6390296, 0.5977058, 0.81350476,
            0.3685356, 0.90738845, 0.7828945, 0.9812083, 0.6726924, 0.46724817, 0.17302093,
            0.39839587, 0.78055173, 0.8576361, 0.7335981, 0.52934057, 0.9529279, 0.78965247,
            0.46750203, 0.08403921, 0.73126566, 0.34934825, 0.3459232, 0.54770446, 0.68714255,
            0.29283327, 0.53392637, 0.8850151, 0.6909357, 0.44388366, 0.9043074, 0.9949724,
            0.64743847, 0.36691284, 0.5396585, 0.5372604, 0.47547424, 0.44373918, 0.34716287,
            0.21774843, 0.9437953, 0.51856595, 0.15765554, 0.9350713, 0.86233217, 0.81734437,
            0.6566154,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(
        kernel4,
        Some(Array::from_shape_vec((1,), vec![0.3879487]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            6.1127706, 6.8170853, 7.4482455, 6.028275, 7.437309, 9.819859, 10.352055, 7.2691493,
            8.314576, 11.478379, 11.642733, 9.431056, 6.9541187, 9.945222, 9.60607, 7.333007,
            4.114229, 6.4558897, 6.7533927, 5.253201,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.28848994, 0.5814131, 0.06870039, 0.78543746, 0.47194287, 0.12733267, 0.6111727,
            0.25675833, 0.74741316, 0.45714313, 0.9649919, 0.57969916, 0.5208711, 0.93666834,
            0.13247305, 0.7087714, 0.17877895, 0.40767, 0.6906785, 0.9675369, 0.224454, 0.28950995,
            0.75431514, 0.99582964, 0.8120864, 0.9536324, 0.7703749, 0.683158, 0.16371861,
            0.42877796, 0.7300311, 0.9456737, 0.05700503, 0.19623296, 0.44457257, 0.5512328,
            0.15101007, 0.25140873, 0.2031063, 0.5537751,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.3641559, 0.701937, 0.27669305, 0.85076064, 0.00186597, 0.3316532, 0.15485734,
            0.35000807, 0.42372492, 0.03995521, 0.5067197, 0.38907993, 0.37287286, 0.21294773,
            0.8646356, 0.10154326, 0.75313085, 0.7910046, 0.15368015, 0.25977603, 0.40315583,
            0.635939, 0.25689796, 0.13678746, 0.43744904, 0.6658951, 0.564682, 0.70429957,
            0.67241764, 0.15790685, 0.25059524, 0.6432024, 0.60438925, 0.45131883, 0.96080875,
            0.40131757, 0.60942906, 0.7035094, 0.6473561, 0.05433872, 0.7478619, 0.24740443,
            0.35665986, 0.00020906, 0.23741227, 0.57013196, 0.6398819, 0.7132858, 0.90739846,
            0.8246988,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(
        kernel5,
        Some(Array::from_shape_vec((1,), vec![0.1319153]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            4.545073, 7.1819606, 7.0422697, 6.384361, 6.024588, 7.964457, 8.042324, 5.6777563,
            6.2409325, 9.310606, 9.845416, 7.495718, 5.5756636, 7.9975805, 8.258152, 6.578929,
            4.259518, 5.8143234, 5.5409513, 4.766061,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6876462, 0.846729, 0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465,
            0.05539654, 0.5554673, 0.9149804, 0.9791666, 0.9000323, 0.6329186, 0.30872977,
            0.30553624, 0.04431259, 0.5287215, 0.3358437, 0.72178566, 0.72704846, 0.85191244,
            0.07464863, 0.867838, 0.5849202, 0.14913943, 0.18325551, 0.40498126, 0.75359416,
            0.01821492, 0.5917236, 0.91982275, 0.5287654, 0.7151285, 0.38420153, 0.517026,
            0.5150141, 0.26934662, 0.7356045, 0.97902703, 0.6362754,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.27803296, 0.32063982, 0.83432084, 0.78711736, 0.28247103, 0.7812688, 0.5270146,
            0.4719829, 0.47535485, 0.23715672, 0.4404677, 0.90286416, 0.66611385, 0.02649495,
            0.3193976, 0.16608049, 0.5121102, 0.17436478, 0.313714, 0.47244504, 0.9906781,
            0.9064671, 0.29454133, 0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972,
            0.53866875, 0.6358971, 0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548,
            0.14977625, 0.53714937, 0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625,
            0.4744624, 0.73655206, 0.42605233, 0.6592577, 0.3237799, 0.42867732, 0.87574345,
            0.70010746,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(
        kernel6,
        Some(Array::from_shape_vec((1,), vec![0.01496939]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            4.5758953, 6.499373, 6.8871884, 5.5835495, 6.7641497, 8.9234705, 8.30044, 5.1186976,
            8.340484, 11.381234, 10.779814, 8.081835, 7.211056, 9.158911, 7.913366, 6.1600766,
            5.5128183, 7.2840023, 7.1165247, 5.5267043,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.78416556, 0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122,
            0.68573385, 0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448,
            0.48578474, 0.2764571, 0.9192946, 0.8920509, 0.34320405, 0.4283556, 0.3897719,
            0.06360459, 0.729173, 0.19460331,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.8634254, 0.6576018, 0.9657459, 0.22873744, 0.47843248, 0.22157177, 0.9162307,
            0.02157675, 0.44649428, 0.2792192, 0.685827, 0.75294507, 0.7919586, 0.22560763,
            0.88778716, 0.80092114, 0.00003577, 0.9737877,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(
        kernel7,
        Some(Array::from_shape_vec((1,), vec![0.9146247]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            3.0194216, 4.9309516, 3.9434125, 4.475068, 6.2935762, 4.643378, 3.9981217, 6.6151314,
            4.4164543, 3.0761495, 3.2341595, 2.761453,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946, 0.17754778,
            0.41998118, 0.02919354, 0.82382417, 0.4156855, 0.49590722, 0.69720376, 0.7155315,
            0.40795937, 0.15397236, 0.02265206, 0.7090415, 0.75877124, 0.67035425, 0.39483562,
            0.86222315, 0.9993058, 0.84902793,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.26427644, 0.86764544, 0.24274233, 0.69865257, 0.5739991, 0.7620597, 0.29289714,
            0.88402116, 0.8942853, 0.7757528, 0.16431308, 0.48939565, 0.56055367, 0.46453193,
            0.9573795, 0.8899508, 0.16098963, 0.63514715,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(
        kernel8,
        Some(Array::from_shape_vec((1,), vec![0.810474]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            2.518369, 3.7689269, 2.55937, 3.3983114, 4.7890153, 3.3315058, 4.1069756, 5.8417478,
            3.7552614, 3.5331664, 5.268794, 3.6537457,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.29953358, 0.46075395, 0.02808736, 0.59781086, 0.8855644, 0.61877847, 0.9537467,
            0.6197168, 0.3379795, 0.13108306, 0.30692965, 0.33537498, 0.01351478, 0.45529485,
            0.6626128, 0.9497022, 0.7403127, 0.06039312, 0.08292098, 0.80679554, 0.1354166,
            0.2560622, 0.80891573, 0.97702754,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.4124968, 0.4359102, 0.8733311, 0.1396195, 0.52047473, 0.88564533, 0.29781443,
            0.21130918, 0.83071965, 0.3337948, 0.9783562, 0.42070097, 0.55396014, 0.16172563,
            0.7634967, 0.36205766, 0.48491392, 0.4980414,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(
        kernel9,
        Some(Array::from_shape_vec((1,), vec![0.6001484]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            2.876923, 3.8675203, 2.8912685, 2.9923503, 5.4890633, 4.3787065, 3.4663131, 5.4171104,
            4.9376316, 1.9191582, 3.295831, 2.8758605,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525, 0.7446416, 0.471613,
            0.72900707, 0.842964, 0.21457537, 0.938401, 0.41665936, 0.05351101, 0.43856344,
            0.7253113, 0.8520324, 0.4151233, 0.35101932, 0.7388761, 0.3592986, 0.6741479,
            0.9965808, 0.3117034, 0.8605703,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.94308543, 0.8192489, 0.31478795, 0.750324, 0.36604244, 0.78454614, 0.039194,
            0.23696694, 0.2418382, 0.24788351, 0.5622223, 0.15428482, 0.50688076, 0.37682602,
            0.44385925, 0.00051633, 0.53422695, 0.5675659, 0.53845215, 0.2130759, 0.86445093,
            0.432881, 0.6255918, 0.3942565, 0.07226853, 0.09869356, 0.32627374, 0.8543963,
            0.85603166, 0.25422713, 0.24929269, 0.36793318, 0.39957172, 0.9079535, 0.865758,
            0.82237726, 0.60374194, 0.7658025, 0.0215734, 0.473204, 0.6594781, 0.86392707,
            0.8566667, 0.48541847, 0.54855824, 0.5860555, 0.158874, 0.10558709, 0.19664533,
            0.39609066,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(
        kernel10,
        Some(Array::from_shape_vec((1,), vec![0.27843866]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            5.251691, 5.3062053, 5.1204453, 7.2942615, 6.7145433, 6.948665, 6.688881, 6.1093373,
            6.2989287, 6.02119, 5.285459, 5.4886856,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.49128443, 0.75033015, 0.35650545, 0.4687038, 0.6159849, 0.2547001, 0.17250927,
            0.07203952, 0.8724657, 0.14018923, 0.12091745, 0.4770398, 0.43290496, 0.6356798,
            0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513, 0.06810815,
            0.79673207, 0.29373887, 0.55241185,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.23906927, 0.18915932, 0.02753429, 0.1438574, 0.5419741, 0.71984386, 0.12837073,
            0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286, 0.21388301, 0.30016333,
            0.49605927, 0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258, 0.26911622,
            0.92149794, 0.7165893, 0.04745785, 0.55642486, 0.34654748, 0.83168656, 0.8410765,
            0.7668131, 0.84094906, 0.6012723, 0.9256995, 0.66010624, 0.43380973, 0.62281454,
            0.45852852, 0.61445725, 0.524579, 0.06486581, 0.14233574, 0.13930365, 0.5838787,
            0.45914945, 0.30819193, 0.70949817, 0.8803759, 0.6927248, 0.50569826, 0.7358748,
            0.58652496,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(
        kernel11,
        Some(Array::from_shape_vec((1,), vec![0.85065925]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            5.5033226, 4.728496, 3.9279737, 6.732407, 5.838501, 5.7494116, 7.7460895, 6.3400507,
            5.5228577, 5.6832623, 4.2647943, 4.3162546,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.3247378, 0.6760192, 0.4483504, 0.59195757, 0.37883574, 0.7796499, 0.32748002,
            0.44507304, 0.7488422, 0.14428215, 0.8785777, 0.15468395, 0.6638725, 0.30651525,
            0.9492515, 0.55669755, 0.08302987, 0.45890567, 0.05946975, 0.9099885, 0.30235246,
            0.24214035, 0.42138377, 0.38782486,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.21880285, 0.9182205, 0.85290706, 0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431,
            0.2624427, 0.6557088, 0.00633, 0.6603214, 0.45500925, 0.6523986, 0.14666249,
            0.32440838, 0.2805719, 0.42671442, 0.74477625, 0.9118973, 0.5335283, 0.36968935,
            0.5693756, 0.36426732, 0.11819325, 0.95361024, 0.13343851, 0.5940242, 0.7282295,
            0.9320007, 0.46956548, 0.5087874, 0.7952918, 0.73709416, 0.3358689, 0.03185032,
            0.27057356, 0.26166973, 0.5843129, 0.5337139, 0.19571388, 0.1192536, 0.75616854,
            0.97167397, 0.71154076, 0.26672947, 0.07128377, 0.3383284, 0.8008563, 0.9504947,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(
        kernel12,
        Some(Array::from_shape_vec((1,), vec![0.5971434]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            4.3813686, 5.381424, 5.2795916, 5.547638, 6.756645, 7.0753183, 4.8471546, 5.744134,
            6.6946125, 3.3635855, 4.2019253, 5.2463818,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.7847773, 0.92326206, 0.24163638, 0.12968542, 0.5954836, 0.6734995, 0.08627631,
            0.7485715, 0.8782484, 0.6863155, 0.7264353, 0.08944888, 0.68172634, 0.4284322,
            0.48237634, 0.6856524, 0.04009921, 0.0687674, 0.9063645, 0.42620143, 0.61030614,
            0.10040135, 0.50107217, 0.763057, 0.25769317, 0.8816114, 0.7770131, 0.23345616,
            0.62762326, 0.15315741, 0.73589575, 0.2752067, 0.85641515, 0.7439484, 0.6581306,
            0.4056261, 0.13899311, 0.26460668, 0.9179794, 0.96651816, 0.89336777, 0.18948041,
            0.9371178, 0.7124811, 0.9657549, 0.6203675, 0.32684848, 0.11439406, 0.07654371,
            0.95680344, 0.9728639, 0.6055871, 0.00439729, 0.8525613, 0.3167563, 0.13499211,
            0.68338645, 0.7955047, 0.21689218, 0.2826704, 0.12328367, 0.6890043, 0.5906649,
            0.41700745, 0.30266365, 0.5716598, 0.12726787, 0.35587692, 0.16889893, 0.3114892,
            0.1309899, 0.24026695,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.55435276, 0.34375766, 0.4225387, 0.37165096, 0.6202945, 0.6069533, 0.05756181,
            0.0153275, 0.8497578, 0.79796964, 0.4071996, 0.19325097, 0.04944435, 0.59729165,
            0.39304134, 0.679002, 0.6126854, 0.67232877,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(
        kernel13,
        Some(Array::from_shape_vec((1,), vec![0.7156292]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            3.0364194, 4.135023, 4.1988244, 3.8560987, 3.2704368, 2.4065742, 3.2388349, 5.857635,
            6.8409224, 5.6680775, 4.685433, 3.0304813, 3.2776394, 5.611095, 6.082516, 5.4421124,
            3.8648124, 2.833129, 3.5411034, 5.526158, 5.427699, 4.821819, 4.4624085, 2.9167113,
            2.3763213, 4.9530053, 5.099806, 4.95107, 3.7437892, 2.9491467, 1.9660606, 3.105524,
            3.8293252, 3.7585092, 3.0094833, 2.6510978,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.09058711, 0.33372015, 0.8941644, 0.30899736, 0.3348802, 0.6412177, 0.26750943,
            0.03709449, 0.56803024, 0.8756273, 0.5771133, 0.56024176, 0.5868575, 0.75167763,
            0.36936092, 0.37185487, 0.35425207, 0.24336162, 0.01027582, 0.2671537, 0.83992416,
            0.49819484, 0.7831867, 0.70054483, 0.8701863, 0.49413827, 0.84670645, 0.8069649,
            0.093459, 0.93408287, 0.8206956, 0.70209366, 0.32817394, 0.744203, 0.39091238,
            0.43911496, 0.92919487, 0.29325068, 0.62813336, 0.8131431, 0.19520658, 0.47931832,
            0.42483747, 0.47526902, 0.28184402, 0.09741595, 0.45691565, 0.44086096, 0.9638409,
            0.33859608, 0.26381832, 0.29839757, 0.68755937, 0.09156765, 0.58584654, 0.04617033,
            0.14705709, 0.81179595, 0.16751295, 0.06864621, 0.6308731, 0.38993102, 0.3644169,
            0.68174505, 0.272409, 0.23609333, 0.21866773, 0.80119157, 0.01742986, 0.49270406,
            0.37920174, 0.90869635,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.8191268, 0.7636344, 0.7827788, 0.9694966, 0.79533535, 0.00732174, 0.8372113,
            0.9449071, 0.7670253, 0.50964797, 0.7843069, 0.7365313, 0.71123123, 0.89694643,
            0.9544987, 0.16811895, 0.97018677, 0.25394833,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(
        kernel14,
        Some(Array::from_shape_vec((1,), vec![0.5585159]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            2.8061981, 4.820502, 4.7941384, 4.7061067, 4.98075, 3.249073, 4.8344817, 6.378289,
            6.598789, 6.3814144, 5.5168314, 4.2585955, 4.3449416, 5.7049437, 5.5208097, 6.707863,
            6.5998726, 4.3340974, 5.3226647, 7.086091, 6.708675, 6.408688, 6.724382, 3.280261,
            5.1640215, 6.4173756, 7.1730275, 6.8119073, 7.0603776, 4.7790117, 4.57145, 4.823851,
            5.098828, 4.550021, 4.723699, 3.3401604,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028, 0.52249014,
            0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726, 0.25884646,
            0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234, 0.32747796,
            0.9097073, 0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446, 0.9843364,
            0.4038572, 0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686, 0.5288406,
            0.92906404, 0.87780553, 0.9090181, 0.82569945, 0.20383635, 0.7166643, 0.17061436,
            0.91526777, 0.08598401, 0.70100874, 0.40537685, 0.5971982, 0.92796123, 0.15859716,
            0.7859081, 0.8564488, 0.35816404, 0.79062706, 0.9644883, 0.13154314, 0.31929043,
            0.80048305, 0.07180241, 0.52815664, 0.45786336, 0.91537887, 0.9783313, 0.25753945,
            0.42799363, 0.07738555, 0.9294206, 0.07022415, 0.60058224, 0.6196278, 0.9008346,
            0.04155485, 0.82207745,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.41282526, 0.9949608, 0.3109271, 0.47614527, 0.7615821, 0.35893062, 0.07713356,
            0.6123928, 0.62511915, 0.88098776, 0.21521498, 0.89468116, 0.1842307, 0.10784956,
            0.8354833, 0.2630701, 0.7184675, 0.06132602,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(
        kernel15,
        Some(Array::from_shape_vec((1,), vec![0.06056971]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            1.9354559, 3.979683, 2.7921665, 3.546054, 3.3632855, 2.986937, 3.5969198, 5.1250286,
            4.3075085, 4.6540527, 5.2060523, 4.4156575, 2.8083382, 3.6512413, 4.2165513, 5.2899523,
            4.4260244, 3.8585136, 3.0062366, 4.3764443, 4.726912, 4.8880005, 4.9073653, 3.5602653,
            2.8285027, 4.588989, 5.583103, 3.8970323, 5.5693207, 2.9574742, 2.1510997, 2.9361525,
            2.8176718, 2.5246208, 3.1134243, 2.358273,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.71349823, 0.00944792, 0.07349233, 0.35231608, 0.8533961, 0.17608605, 0.18067755,
            0.51991457, 0.19053963, 0.5045173, 0.7456122, 0.27621788, 0.48649722, 0.39297876,
            0.54849166, 0.3746991, 0.8194284, 0.34880427, 0.79505837, 0.41293454, 0.890512,
            0.12076204, 0.20799449, 0.88948244, 0.24437675, 0.7731474, 0.65954226, 0.4922565,
            0.5211581, 0.97382414, 0.9779564, 0.1754263, 0.4551989, 0.81067127, 0.7095975,
            0.5087082, 0.78796804, 0.03310984, 0.20805901, 0.45704818, 0.9133983, 0.5689028,
            0.04247752, 0.55938286, 0.9835293, 0.04525762, 0.7176199, 0.82096803, 0.5575717,
            0.5744108, 0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355, 0.1134909,
            0.5645703, 0.30096474, 0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894,
            0.681929, 0.24701218, 0.74485576, 0.61556435, 0.63869125, 0.05875124, 0.3210932,
            0.96946657, 0.09463912,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.6275637, 0.34162354, 0.74390864, 0.8736778, 0.9513908, 0.24045336, 0.7003475,
            0.87750345, 0.16564246, 0.6314963, 0.21785556, 0.7654987, 0.13988015, 0.03287261,
            0.82226163, 0.60896695, 0.13331373, 0.62307173, 0.23316076, 0.9600204, 0.55291533,
            0.29808274, 0.8765127, 0.98263544, 0.27148733, 0.11101003, 0.2754741, 0.4540411,
            0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969, 0.5836321,
            0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643, 0.91682273,
            0.6142979, 0.19277428, 0.28408903, 0.25507236, 0.9800453, 0.36125833, 0.96792,
            0.33258557,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(
        kernel16,
        Some(Array::from_shape_vec((1,), vec![0.9508625]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            5.350966, 5.539909, 7.988808, 8.704291, 7.810769, 5.42366, 7.3473563, 7.9194345,
            10.856416, 10.792727, 9.997356, 6.5414715, 8.424494, 11.241109, 12.750721, 13.291385,
            12.976979, 9.782504, 9.53326, 12.167869, 13.93993, 13.914165, 14.242102, 9.71659,
            8.778961, 9.369434, 12.641815, 12.276781, 10.91404, 7.2100573, 6.1916404, 7.2183013,
            8.587385, 9.284393, 7.3272343, 5.800124,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.8424581, 0.8130291, 0.7774976, 0.17691322, 0.9389267, 0.22419459, 0.33442205,
            0.7614585, 0.37563834, 0.70754576, 0.1499497, 0.9873837, 0.7166968, 0.40278858,
            0.22288306, 0.3279577, 0.07722609, 0.598755, 0.8143903, 0.87905455, 0.83061284,
            0.9923988, 0.6196494, 0.536406, 0.06662867, 0.83588266, 0.28182983, 0.662181,
            0.99850965, 0.60448396, 0.12318801, 0.91713256, 0.8540598, 0.19103892, 0.5929614,
            0.9118344, 0.9381113, 0.3421722, 0.8149188, 0.9595595, 0.02717085, 0.8916309,
            0.9755575, 0.27588442, 0.59208006, 0.00008138, 0.9552037, 0.12578069, 0.01249961,
            0.05413999, 0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439, 0.34315115,
            0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794, 0.6930413,
            0.90735817, 0.91156703, 0.45996496, 0.9045769, 0.17170428, 0.43418503, 0.69308424,
            0.42869946, 0.9244341,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.41451567, 0.6224708, 0.00536506, 0.33826837, 0.47926104, 0.0032256, 0.02230139,
            0.35960108, 0.48593593, 0.86064774, 0.28908366, 0.4153976, 0.3468706, 0.2242362,
            0.93169004, 0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496, 0.11111139,
            0.19382912, 0.9307082, 0.9188555, 0.10532705, 0.88550454, 0.20754221, 0.97926295,
            0.3472928, 0.71126235, 0.03633394, 0.7482733, 0.28782296, 0.7382309, 0.60003114,
            0.3259743, 0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927, 0.968827,
            0.47373444, 0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834, 0.3979838,
            0.2393961,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(
        kernel17,
        Some(Array::from_shape_vec((1,), vec![0.36507484]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            3.384909, 5.3650627, 6.984501, 6.952221, 6.286247, 4.1938, 6.2164855, 8.931842,
            11.041458, 11.684279, 9.272891, 7.504865, 7.845093, 11.048375, 14.195403, 14.827918,
            11.553749, 9.662743, 7.258074, 9.461692, 13.202706, 14.349618, 11.879109, 9.826926,
            5.4586234, 8.431676, 11.006513, 11.547409, 10.154126, 8.025545, 5.556083, 7.7087655,
            9.545092, 10.470132, 8.751504, 6.2894635,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.01646563, 0.27730468, 0.62646276, 0.94121945, 0.66457146, 0.8425775, 0.4301739,
            0.68211764, 0.6059688, 0.7629583, 0.56038123, 0.48163053, 0.437191, 0.43973154,
            0.29997745, 0.21913478, 0.6611514, 0.209788, 0.176356, 0.88925517, 0.14793599,
            0.36509594, 0.5616029, 0.6617385, 0.30053073, 0.36820948, 0.62227124, 0.4957459,
            0.69923055, 0.3227648, 0.9702412, 0.5679234, 0.13432135, 0.7430913, 0.19231908,
            0.26170298, 0.10480803, 0.00958306, 0.20726651, 0.20851518, 0.17973869, 0.23704103,
            0.1163867, 0.2735905, 0.8537909, 0.40303, 0.75797635, 0.34342998, 0.74670875,
            0.82946825, 0.91931367, 0.9654975, 0.18782942, 0.10021565, 0.05109123, 0.3069365,
            0.10895161, 0.9891213, 0.62504834, 0.507994, 0.47125, 0.84314245, 0.6054993,
            0.92367506, 0.6953895, 0.37023902, 0.67128026, 0.43450755, 0.28869846, 0.27641538,
            0.8369712, 0.6856483,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.26890948, 0.65425915, 0.84581685, 0.51146317, 0.48995435, 0.52071315, 0.80564773,
            0.670521, 0.3835857, 0.47078377, 0.5100531, 0.82525116, 0.02126783, 0.9583153,
            0.23316967, 0.9487504, 0.9609589, 0.95734006, 0.00943314, 0.7521432, 0.46106157,
            0.84370506, 0.16933449, 0.71423984, 0.5316646, 0.6400151, 0.9638914, 0.69432026,
            0.8581641, 0.70813745, 0.2836983, 0.33953485, 0.8950543, 0.20262088, 0.81930757,
            0.09556881, 0.22266188, 0.63842744, 0.8304186, 0.12425002, 0.7582065, 0.09737789,
            0.84872884, 0.17490041, 0.37569723, 0.6669188, 0.8970669, 0.22398192, 0.29424527,
            0.56277037,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(
        kernel18,
        Some(Array::from_shape_vec((1,), vec![0.41113177]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            5.2860155, 7.3411508, 9.014214, 8.658599, 8.115117, 4.8375845, 5.81894, 8.522849,
            11.430818, 12.26867, 9.915437, 7.8984623, 8.078898, 11.37521, 14.505981, 15.461487,
            12.289593, 9.001145, 9.641521, 11.294623, 14.67268, 14.926493, 11.998367, 8.302479,
            7.0209365, 9.562044, 10.572207, 11.417736, 8.264289, 6.811918, 4.902732, 7.1602592,
            8.855072, 7.738021, 6.735509, 4.974356,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.7882464, 0.24159203, 0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633,
            0.9636684, 0.98529965, 0.26998708, 0.13811645, 0.9724998, 0.41856614, 0.13321315,
            0.0937838, 0.4742414, 0.79873264, 0.1621314, 0.5493846, 0.6481355,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.05176858, 0.17029643, 0.955536, 0.089831, 0.05664136, 0.9231865, 0.98567015,
            0.01680515, 0.54690886, 0.8593988, 0.6496963, 0.8382851, 0.2400014, 0.36792266,
            0.01756373, 0.6596718, 0.5680892, 0.19350345,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(
        kernel19,
        Some(Array::from_shape_vec((2,), vec![0.4854058, 0.7869872]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            0.6842892, 2.0640664, 1.0234097, 2.1371822, 1.7647654, 0.8579401, 2.573223, 2.1107073,
            2.495966, 1.7212328, 0.75913584, 2.6720505, 3.2497058, 1.9795393, 1.7924366, 1.5449035,
            1.487473, 1.9515271, 1.0480199, 1.1037331, 1.6698778, 2.518814, 2.5733294, 2.6612267,
            1.9091775, 2.6116552, 2.8053112, 3.1332836, 2.2308586, 1.3121779, 2.5293965, 3.11231,
            3.4430614, 2.8400254, 2.0495, 1.8731614, 1.9834092, 1.5063627, 1.3660567, 1.1141549,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.12335967, 0.14544043, 0.25711668, 0.05608724, 0.18204254, 0.9562488, 0.44598028,
            0.3229758, 0.8930679, 0.24216229, 0.21437034, 0.38366762, 0.64894366, 0.8650639,
            0.7790032, 0.3529938, 0.37360683, 0.26240814, 0.554433, 0.90017563,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.6817857, 0.95833224, 0.28551313, 0.85106283, 0.70093375, 0.4791875, 0.5805011,
            0.9803199, 0.97033703, 0.48236644, 0.66855663, 0.35855147, 0.25242767, 0.6717967,
            0.26290378, 0.53677225, 0.18097793, 0.07985484,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(
        kernel20,
        Some(Array::from_shape_vec((2,), vec![0.79416144, 0.7215235]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            2.2248745, 2.0946596, 2.1375425, 2.224784, 1.4356921, 2.5163631, 3.1227217, 3.7412868,
            3.736567, 2.6182625, 3.0602732, 3.9084072, 4.1730466, 4.9239025, 3.8796577, 1.7924206,
            2.409352, 3.139607, 4.004576, 3.293878, 1.6955417, 1.7133851, 1.753269, 1.7024331,
            1.3406746, 1.9052869, 2.1746416, 2.3581328, 2.7827106, 1.9874004, 1.7910466, 2.0327988,
            2.6269865, 2.8862963, 2.3880367, 1.2977107, 1.5664427, 1.7484097, 2.0167332, 1.682083,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.42313012, 0.6529702, 0.00384528, 0.08442257, 0.7838985, 0.980683, 0.36212954,
            0.61172485, 0.5263662, 0.8496614, 0.13177402, 0.9175598, 0.04323238, 0.03087392,
            0.03482862, 0.36226457, 0.6059544, 0.29194582, 0.34645593, 0.9409913,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.60953087, 0.8610255, 0.1627552, 0.8939359, 0.66327935, 0.48094535, 0.06551108,
            0.86129206, 0.65446067, 0.9592776, 0.8000413, 0.21450381, 0.6442533, 0.46971878,
            0.84573215, 0.34651902, 0.18830031, 0.57119006,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(
        kernel21,
        Some(Array::from_shape_vec((2,), vec![0.27269888, 0.7915957]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            2.202188, 1.7570196, 1.5712463, 2.10197, 1.6504941, 2.3268435, 3.2088025, 1.9647117,
            1.8570077, 1.854845, 2.7299864, 2.7357655, 2.1297963, 2.1738572, 2.2535462, 1.2282722,
            1.9891862, 1.707246, 1.5412587, 1.1136687, 2.5429957, 2.545533, 2.472044, 2.706925,
            2.023878, 2.7771053, 3.354994, 2.3882847, 2.4607058, 1.866179, 2.625886, 3.0447614,
            2.8081274, 2.8505235, 2.121861, 1.6949112, 1.8337154, 2.2073488, 1.8500535, 1.550799,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.21737069, 0.04463017, 0.393406, 0.8441482, 0.77705365, 0.6315176, 0.8522896,
            0.16809769, 0.22305161, 0.773223, 0.9678148, 0.2237789, 0.8982615, 0.271913,
            0.34780893, 0.49277794, 0.14560463, 0.33638617, 0.1585067, 0.18610527,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.6963084, 0.9429821, 0.40789625, 0.20056698, 0.37306353, 0.9367061, 0.7103306,
            0.06833509, 0.48335183, 0.45182207, 0.96346164, 0.00378525, 0.33689302, 0.28288215,
            0.75004077, 0.1607512, 0.514175, 0.35879079, 0.36688787, 0.00774159, 0.15532039,
            0.01133456, 0.94680935, 0.052598, 0.73530346, 0.8096563, 0.7097644, 0.37942106,
            0.38656324, 0.13763146, 0.99930644, 0.67476803, 0.06055127, 0.8463604, 0.4460729,
            0.33209085, 0.94373864, 0.5397614, 0.05766413, 0.64256257, 0.7357459, 0.09256811,
            0.8832945, 0.03911254, 0.782554, 0.4004812, 0.80732703, 0.8010379, 0.28867772,
            0.7802926,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(
        kernel22,
        Some(Array::from_shape_vec((2,), vec![0.9490529, 0.5395702]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            3.438759, 3.8539677, 4.8715343, 3.1144986, 2.512818, 3.1302004, 4.025762, 4.9394965,
            3.7238846, 2.7845247, 3.5528362, 3.048192, 4.261737, 3.2427645, 3.4881544, 2.68011,
            3.1091578, 3.0516484, 2.670697, 2.4078283, 2.864305, 3.4669614, 4.9204173, 3.5656805,
            1.9317509, 3.8960943, 4.2974906, 4.443194, 4.268438, 2.9351158, 3.163786, 4.1768193,
            5.443554, 4.089055, 3.6120095, 3.8524146, 2.6254616, 4.461382, 2.9128237, 2.7010393,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.1369102, 0.4513485, 0.1162144, 0.9589836, 0.24819064, 0.3149064, 0.22322156,
            0.39812055, 0.45308354, 0.5711523, 0.97817534, 0.06805564, 0.5386646, 0.6699801,
            0.1879456, 0.8407316, 0.64728755, 0.53731096, 0.63207716, 0.00916763,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.46754488, 0.8670982, 0.1932068, 0.43971533, 0.10441232, 0.46486124, 0.22910197,
            0.7679019, 0.23872072, 0.03931138, 0.8551502, 0.19610135, 0.8555064, 0.08035298,
            0.05671094, 0.9091975, 0.27582648, 0.33816597, 0.42012835, 0.7745094, 0.14011143,
            0.47505257, 0.98297566, 0.5085966, 0.22395916, 0.01153891, 0.669607, 0.12918296,
            0.55476546, 0.528783, 0.5067741, 0.14234911, 0.5152856, 0.6446142, 0.9118427,
            0.8193508, 0.989135, 0.7842302, 0.59264964, 0.35247177, 0.48483032, 0.22649786,
            0.04158387, 0.5814206, 0.8653732, 0.4524277, 0.44947338, 0.5519129, 0.79122764,
            0.7513198,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(
        kernel23,
        Some(Array::from_shape_vec((2,), vec![0.9315116, 0.03313805]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            2.2144094, 3.9435155, 3.120901, 2.9545007, 2.1770444, 3.8536496, 4.704217, 4.4480824,
            3.3896554, 2.7172, 4.181309, 4.293991, 4.4760027, 4.101526, 2.8053095, 3.5478563,
            4.0226016, 3.8173618, 3.080534, 2.6638787, 1.2561212, 2.893108, 3.6574447, 2.5808244,
            2.467272, 2.3263056, 3.7484205, 4.928465, 3.3316998, 3.214223, 2.6942627, 4.366033,
            5.078573, 3.996016, 3.284345, 2.5444717, 3.8630738, 4.0135064, 2.516497, 2.4406507,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.41213843, 0.45310238, 0.01799934, 0.4328227, 0.23842481, 0.20688592, 0.57869387,
            0.9324833, 0.43915927, 0.53123087, 0.5324186, 0.4149537, 0.22217223, 0.0080786,
            0.65063345, 0.7681623, 0.8421627, 0.27179125, 0.68530315, 0.9955617,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.77906156, 0.18006648, 0.5975193, 0.6555531, 0.9498266, 0.9690994, 0.5122471,
            0.3840358, 0.8757204, 0.7260429, 0.04691354, 0.40678895, 0.35535267, 0.19270384,
            0.23519029, 0.6665529, 0.26402712, 0.55168146, 0.08576613, 0.9567203, 0.57141143,
            0.20602623, 0.75538653, 0.96776, 0.44755465, 0.82362133, 0.29203537, 0.30861592,
            0.39762703, 0.26186082, 0.9658112, 0.27424002, 0.50570756, 0.8114843, 0.5536027,
            0.59788686, 0.05054026, 0.28394443, 0.6402348, 0.02258505, 0.60607, 0.6834324,
            0.8004999, 0.3349493, 0.4295082, 0.37033585, 0.0394791, 0.50698835, 0.29841292,
            0.9388161,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(
        kernel24,
        Some(Array::from_shape_vec((2,), vec![0.84357476, 0.29760668]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            3.0206811, 3.061569, 4.395152, 3.5436916, 2.886642, 3.0099554, 4.4044333, 6.0680075,
            4.667347, 3.2426863, 3.5052178, 4.851921, 5.970953, 4.486573, 4.138274, 2.8315873,
            2.8526192, 4.4629803, 3.9374173, 3.2091482, 2.0807002, 2.5015216, 3.366962, 2.2886474,
            2.0462508, 2.8980908, 3.599226, 5.075294, 3.192652, 2.2037294, 2.8442726, 4.5077076,
            5.711252, 3.7258573, 2.942373, 2.0382986, 2.6738265, 3.560293, 2.5044878, 2.919956,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.25654384, 0.71037215, 0.14646496, 0.9906275, 0.9552909, 0.7966291, 0.6094893,
            0.7271988, 0.09518696,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.3957746, 0.6157527, 0.31079137, 0.46793708, 0.8514491, 0.86081386, 0.8208274,
            0.2372746, 0.6977758, 0.79387194, 0.9463199, 0.99063903, 0.29514915, 0.8795419,
            0.741553, 0.03520088, 0.83411527, 0.47134155,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(
        kernel25,
        Some(Array::from_shape_vec((2,), vec![0.26704508, 0.2872401]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            1.8059499, 2.3726506, 1.7906733, 2.8645957, 3.448602, 2.5827134, 2.1454573, 3.027213,
            1.8296733, 2.418376, 3.6632986, 2.643055, 2.8335593, 4.183306, 2.9637728, 1.8978682,
            2.6986935, 2.0249662,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.04289522, 0.583651, 0.94414073, 0.5729697, 0.72244126, 0.7707775, 0.02079507,
            0.22973806, 0.18128674,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.05054512, 0.6523751, 0.27093726, 0.32479268, 0.53774405, 0.08921466, 0.18494032,
            0.78120434, 0.15868789, 0.81183356, 0.21792394, 0.6620494, 0.6886836, 0.39724785,
            0.59319293, 0.02472531, 0.21891202, 0.5342134,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(
        kernel26,
        Some(Array::from_shape_vec((2,), vec![0.4041879, 0.53426075]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            1.0271271, 1.6940202, 1.6625365, 1.1135714, 1.8961767, 1.893818, 1.0712025, 1.3863095,
            1.2389472, 1.6646175, 2.604289, 1.901799, 1.4742672, 2.0769873, 1.9790801, 0.8440309,
            1.2460053, 1.2972257,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.20461221, 0.29362342, 0.7835011, 0.47930118, 0.2895624, 0.7320774, 0.55179524,
            0.37774232, 0.04187773,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.23883641, 0.63051957, 0.97746944, 0.6415133, 0.4162999, 0.04763152, 0.75958186,
            0.13098118, 0.6238241, 0.4102024, 0.5710282, 0.59153587, 0.66274744, 0.6454271,
            0.8120847, 0.22876394, 0.6206928, 0.19057496,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(
        kernel27,
        Some(Array::from_shape_vec((2,), vec![0.4622738, 0.9772445]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            1.107184, 1.9228053, 1.5470586, 1.5355327, 2.624059, 1.4622594, 1.2170386, 1.5656755,
            0.7742243, 1.6963787, 2.6013548, 2.3107078, 2.1427183, 2.9983187, 2.4745288, 1.947476,
            2.1354535, 1.8206108,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.17967562, 0.27354005, 0.48198408, 0.09082693, 0.6217685, 0.0965838, 0.8904992,
            0.5337058, 0.17222154,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.62424076, 0.95776683, 0.998361, 0.150883, 0.28713444, 0.35105017, 0.1765902,
            0.9674033, 0.65025777, 0.1959308, 0.3119046, 0.55247456, 0.38556734, 0.18145509,
            0.94255227, 0.7036003, 0.3402552, 0.16401337, 0.28418577, 0.5504918, 0.6148071,
            0.7740251, 0.37459207, 0.25677747, 0.80441076, 0.17314304, 0.5946227, 0.30094627,
            0.06480476, 0.5798754, 0.62549657, 0.6065069, 0.9259787, 0.3677915, 0.69532603,
            0.8356569, 0.39276573, 0.18570696, 0.61698794, 0.9064707, 0.01547038, 0.2551995,
            0.11438051, 0.03861368, 0.6524532, 0.36442748, 0.08230381, 0.79969245, 0.27816203,
            0.3741886,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(
        kernel28,
        Some(Array::from_shape_vec((2,), vec![0.44356522, 0.27386904]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            2.5535824, 2.3576782, 1.8720919, 2.3300653, 2.1388383, 1.6230651, 2.0052605, 1.588402,
            2.0840113, 1.954235, 1.6132926, 1.6790831, 1.9694752, 1.5707091, 1.915636, 1.3051853,
            1.3977213, 2.0654297,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.4171807, 0.14990133, 0.4750283, 0.6358263, 0.77572674, 0.7072159, 0.34310365,
            0.36999545, 0.8200852,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.46510443, 0.9230857, 0.86201537, 0.04691705, 0.12260284, 0.89921826, 0.47400048,
            0.7492544, 0.05440097, 0.28273952, 0.9184355, 0.9064988, 0.7027802, 0.19125043,
            0.8670149, 0.08634489, 0.722654, 0.77540857, 0.00211577, 0.6443405, 0.2344423,
            0.9849179, 0.9893316, 0.87634915, 0.48734385, 0.8760625, 0.53053117, 0.01152504,
            0.6788874, 0.76156837, 0.4680538, 0.07214947, 0.549209, 0.8383253, 0.00365476,
            0.9782156, 0.7419056, 0.40790308, 0.00302504, 0.80174476, 0.7689671, 0.50054824,
            0.16478458, 0.89107823, 0.7763043, 0.73042727, 0.41667554, 0.7348974, 0.71259016,
            0.93557405,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(
        kernel29,
        Some(Array::from_shape_vec((2,), vec![0.37013116, 0.14954911]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            3.7342412, 3.0289524, 2.6125512, 3.8124187, 2.822994, 2.9358318, 3.4862623, 3.5348666,
            3.079057, 2.5504904, 2.2467468, 2.2412186, 2.7842636, 2.1768038, 2.2476804, 3.1191318,
            2.563703, 2.9078498,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.33766475, 0.39673004, 0.03940821, 0.2414454, 0.9373305, 0.84819096, 0.9272432,
            0.8604789, 0.92845494,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.8023847, 0.06647868, 0.12827316, 0.02774826, 0.8982795, 0.1193029, 0.37523487,
            0.28379655, 0.0638791, 0.08446726, 0.68760884, 0.2630593, 0.01052708, 0.45302406,
            0.10402057, 0.5539082, 0.39986408, 0.53770447, 0.24856173, 0.12796782, 0.80071914,
            0.38390577, 0.6908975, 0.5850918, 0.71101063, 0.17578217, 0.55867785, 0.71616316,
            0.3247584, 0.9196999, 0.46712968, 0.08430128, 0.83232373, 0.49657014, 0.24024557,
            0.60874844, 0.47418702, 0.9770886, 0.99522823, 0.7749884, 0.7253688, 0.26021662,
            0.8869578, 0.5181486, 0.5871326, 0.76900613, 0.5745777, 0.81429285, 0.78002185,
            0.7069771,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(
        kernel30,
        Some(Array::from_shape_vec((2,), vec![0.33134556, 0.7407027]).unwrap()),
        1,
        Padding::Same,
    );
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            1.9089153, 1.2963923, 1.8434926, 2.2225122, 1.638551, 1.3498158, 2.5974822, 2.394682,
            2.046781, 3.2669327, 3.8907242, 4.462316, 3.6467514, 4.0910583, 4.5510373, 4.2264524,
            4.7308207, 5.1828766,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );
}
