// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array2, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_transpose_stride2_same_bias() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(
        kernel1,
        Some(Array::from_shape_vec((1,), vec![0.14352316]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.3921074, 1.1479273, 0.6096405, 1.3461802, 0.75119716, 1.1833668, 0.29556802,
            0.45076364, 0.9806382, 2.086068, 1.2550097, 2.887555, 1.0878568, 2.4724956, 1.323755,
            1.0081365, 0.3437385, 1.7346253, 0.9824189, 2.1442485, 1.1605213, 2.0123985, 0.7933171,
            0.8030221, 0.6772775, 2.0965977, 0.90287596, 2.7288322, 1.1970756, 2.3755932,
            1.1934671, 0.7955966, 0.21795619, 0.6406014, 0.40194118, 1.3563933, 0.7361921,
            1.2816892, 0.26635283, 0.448882, 1.1528299, 1.9092963, 0.57577735, 2.1894062,
            1.3023248, 1.6846156, 0.8246249, 0.6481568, 0.848077, 1.5574923, 0.85503316, 1.4206338,
            0.4728667, 0.9927945, 0.3446401, 0.3644765, 1.0755031, 2.3564217, 0.7982326, 2.4237306,
            1.2481673, 1.8833146, 0.72202194, 0.59909385, 0.6394646, 1.394856, 0.73399454,
            1.6577387, 0.8838105, 1.299551, 0.46730235, 0.4685045, 0.35946566, 1.3081033,
            0.4604577, 1.5589774, 0.48320428, 1.1444502, 0.3868975, 0.4030824,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.8997107, 0.64410555, 0.04471071, 0.767672, 0.43464628, 0.16569944, 0.18875164,
            0.12285258, 0.2781115, 0.5390728, 0.5066572, 0.97435564, 0.39133722, 0.7964828,
            0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183, 0.81628793,
            0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133, 0.0067116,
            0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715, 0.7567798,
            0.23972042, 0.38848338, 0.00744711, 0.8715701, 0.07988323,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.6283005, 0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194, 0.34163022,
            0.03235205, 0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297, 0.97700953,
            0.18019113, 0.775954, 0.14120784, 0.3426181,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(
        kernel2,
        Some(Array::from_shape_vec((1,), vec![0.5417864]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            1.469215, 2.5427704, 1.5610316, 1.5662277, 0.99484307, 1.9751365, 1.5303473, 1.1862385,
            1.8321118, 2.7926533, 1.4896265, 2.2571769, 1.6279938, 1.987664, 0.8009799, 1.070431,
            1.4313594, 1.7226508, 1.2548592, 1.7484086, 1.4765971, 0.9136811, 0.5660821, 0.6202233,
            1.5116463, 2.5096395, 1.768583, 2.1853323, 1.1039581, 1.8471317, 1.6526165, 0.80949986,
            1.2191528, 1.8521852, 1.3307836, 1.3477155, 0.62262076, 1.7925324, 1.0003601,
            1.2129138, 1.0569453, 2.2340786, 1.4136565, 2.3352015, 2.0787625, 1.9611096, 1.1389782,
            1.0186011, 0.69436395, 1.4161084, 0.75670934, 2.3972967, 1.4239557, 1.7533603,
            0.82795465, 0.81119525, 0.936176, 1.4573033, 1.0311908, 2.8602283, 2.2055984,
            2.2892761, 1.3684719, 0.8770213, 0.922431, 0.97149175, 0.6265419, 2.2424572, 1.5183482,
            1.8728783, 0.743663, 1.0952961, 0.5968881, 0.86594915, 0.5601983, 1.6555655, 0.6928734,
            1.4198472, 0.5808122, 0.79147315,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.7768226, 0.34603763, 0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802,
            0.629322, 0.60627973, 0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678,
            0.89887625, 0.6572328, 0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983,
            0.6908677, 0.5511301, 0.36253917, 0.36786652, 0.88718724, 0.69587743, 0.4870034,
            0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529, 0.5566727, 0.7035832,
            0.92333794, 0.85647196, 0.36252776, 0.9373231, 0.01684272,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754, 0.31284246, 0.4031665,
            0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259, 0.23846498, 0.82509995,
            0.97324103, 0.96826524, 0.77620417, 0.8427075,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(
        kernel3,
        Some(Array::from_shape_vec((1,), vec![0.42989048]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            1.3461226, 1.4841897, 1.2614175, 1.7981895, 1.3466556, 1.9690171, 1.4632388, 1.0866874,
            2.0985131, 2.8881533, 2.4379098, 2.765228, 2.509842, 2.7825665, 2.4191113, 1.752407,
            1.1231714, 1.5395712, 1.5454555, 2.1150227, 1.5073237, 1.9012306, 1.3072801, 1.1007408,
            2.2569017, 2.9136658, 2.5830185, 2.8420603, 1.9197615, 2.9167213, 2.6065242, 1.6415309,
            1.4767808, 1.7579685, 1.455076, 1.7466866, 0.8362223, 1.4862871, 1.6246668, 1.4025391,
            1.9519083, 2.856844, 1.9678353, 2.4430144, 2.2422397, 2.8020227, 2.959063, 1.9389127,
            0.9319023, 1.203277, 0.9681667, 1.8428844, 1.6896756, 2.1064675, 1.6883912, 1.5341312,
            2.2674785, 2.0655668, 1.5792938, 2.640525, 2.7767055, 3.3887994, 2.4976318, 2.065869,
            1.6622005, 1.838107, 1.003051, 1.4003627, 1.4875149, 2.1534097, 1.1421281, 0.73538893,
            1.6077682, 2.2002163, 0.9787798, 2.082061, 1.4348949, 1.9068061, 1.1246252, 1.1765792,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.76771307, 0.54514444, 0.7878393, 0.21897991, 0.975659, 0.73295325, 0.69994044,
            0.86701024, 0.76087946, 0.623545, 0.14890751, 0.8610666, 0.21943341, 0.1644093,
            0.6089244, 0.8612485, 0.02602104, 0.30423534, 0.5087405, 0.16869895, 0.3329467,
            0.179494, 0.33126613, 0.11996287, 0.21606164, 0.87119263, 0.33579683, 0.2313126,
            0.2576527, 0.3748985, 0.30113342, 0.8142977, 0.423247, 0.8179498, 0.92175007,
            0.21606776, 0.19149332, 0.4240341, 0.14780204, 0.46443272,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.00207204, 0.359202, 0.9019851, 0.21363449, 0.6390296, 0.5977058, 0.81350476,
            0.3685356, 0.90738845, 0.7828945, 0.9812083, 0.6726924, 0.46724817, 0.17302093,
            0.39839587, 0.78055173, 0.8576361, 0.7335981, 0.52934057, 0.9529279, 0.78965247,
            0.46750203, 0.08403921, 0.73126566, 0.34934825, 0.3459232, 0.54770446, 0.68714255,
            0.29283327, 0.53392637, 0.8850151, 0.6909357, 0.44388366, 0.9043074, 0.9949724,
            0.64743847, 0.36691284, 0.5396585, 0.5372604, 0.47547424, 0.44373918, 0.34716287,
            0.21774843, 0.9437953, 0.51856595, 0.15765554, 0.9350713, 0.86233217, 0.81734437,
            0.6566154,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(
        kernel4,
        Some(Array::from_shape_vec((1,), vec![0.3879487]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            2.90883, 2.1443703, 4.307395, 2.07726, 3.407318, 1.5795462, 2.5939345, 0.7432474,
            3.1933823, 3.9173, 4.84431, 3.8909223, 4.4453363, 3.1510036, 2.8015392, 1.6129768,
            4.048372, 3.409085, 5.5062575, 3.2617164, 4.6782637, 3.294277, 3.563146, 1.3428252,
            3.208694, 3.7290735, 4.456229, 3.5490503, 5.1892138, 3.5698047, 3.010465, 2.5829015,
            3.4935465, 3.9402497, 4.9462137, 3.7953975, 6.1173196, 3.6891458, 3.9761422, 2.0447624,
            2.746206, 2.9795651, 4.231839, 3.3251886, 4.666913, 4.0081506, 3.3021424, 2.5891552,
            2.5497613, 2.8762455, 4.1016865, 3.1701207, 5.296041, 3.633091, 3.4874487, 2.1203187,
            1.7840827, 2.0657847, 2.9456954, 3.2646887, 3.8093665, 3.4472835, 2.9387314, 1.6208317,
            1.7187033, 2.2036788, 3.1551137, 3.00021, 3.6491573, 2.6426156, 2.0670269, 1.4730618,
            0.874367, 0.99058527, 1.2902498, 1.4368198, 1.6409128, 1.1026566, 1.1742735, 0.9155773,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.28848994, 0.5814131, 0.06870039, 0.78543746, 0.47194287, 0.12733267, 0.6111727,
            0.25675833, 0.74741316, 0.45714313, 0.9649919, 0.57969916, 0.5208711, 0.93666834,
            0.13247305, 0.7087714, 0.17877895, 0.40767, 0.6906785, 0.9675369, 0.224454, 0.28950995,
            0.75431514, 0.99582964, 0.8120864, 0.9536324, 0.7703749, 0.683158, 0.16371861,
            0.42877796, 0.7300311, 0.9456737, 0.05700503, 0.19623296, 0.44457257, 0.5512328,
            0.15101007, 0.25140873, 0.2031063, 0.5537751,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.3641559, 0.701937, 0.27669305, 0.85076064, 0.00186597, 0.3316532, 0.15485734,
            0.35000807, 0.42372492, 0.03995521, 0.5067197, 0.38907993, 0.37287286, 0.21294773,
            0.8646356, 0.10154326, 0.75313085, 0.7910046, 0.15368015, 0.25977603, 0.40315583,
            0.635939, 0.25689796, 0.13678746, 0.43744904, 0.6658951, 0.564682, 0.70429957,
            0.67241764, 0.15790685, 0.25059524, 0.6432024, 0.60438925, 0.45131883, 0.96080875,
            0.40131757, 0.60942906, 0.7035094, 0.6473561, 0.05433872, 0.7478619, 0.24740443,
            0.35665986, 0.00020906, 0.23741227, 0.57013196, 0.6398819, 0.7132858, 0.90739846,
            0.8246988,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(
        kernel5,
        Some(Array::from_shape_vec((1,), vec![0.1319153]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            2.1921134, 2.3167524, 2.7230892, 2.543164, 3.4151986, 3.1513116, 1.9007276, 1.6216362,
            1.6529241, 1.8853846, 3.2102013, 1.5341866, 3.3567793, 2.0663643, 2.5726662,
            0.66994655, 2.7342067, 3.4959297, 4.339513, 4.119083, 5.091698, 5.3603516, 3.7863023,
            2.768963, 2.1405911, 1.2736143, 2.6356547, 1.8087827, 3.3250363, 2.0247886, 2.434763,
            0.84395015, 2.8810585, 3.5786235, 5.067456, 4.3644166, 5.1464787, 4.2153544, 3.99812,
            2.4962199, 1.7251873, 1.2148832, 2.200793, 1.9015548, 3.056482, 1.6720102, 2.365421,
            0.7703072, 2.128855, 2.261407, 3.7095459, 3.4286854, 5.0857654, 4.5438595, 3.4614375,
            2.7725995, 1.1581756, 1.3347018, 2.1644216, 1.009463, 2.251395, 1.7128848, 1.9252037,
            0.9008533, 1.2762569, 1.42378, 2.0174048, 1.4488914, 3.1337326, 2.349396, 2.4903483,
            1.2935786, 0.5566046, 0.52865016, 0.84837484, 0.7650393, 1.4286696, 1.1037897,
            1.3223925, 0.2807223,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6876462, 0.846729, 0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465,
            0.05539654, 0.5554673, 0.9149804, 0.9791666, 0.9000323, 0.6329186, 0.30872977,
            0.30553624, 0.04431259, 0.5287215, 0.3358437, 0.72178566, 0.72704846, 0.85191244,
            0.07464863, 0.867838, 0.5849202, 0.14913943, 0.18325551, 0.40498126, 0.75359416,
            0.01821492, 0.5917236, 0.91982275, 0.5287654, 0.7151285, 0.38420153, 0.517026,
            0.5150141, 0.26934662, 0.7356045, 0.97902703, 0.6362754,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.27803296, 0.32063982, 0.83432084, 0.78711736, 0.28247103, 0.7812688, 0.5270146,
            0.4719829, 0.47535485, 0.23715672, 0.4404677, 0.90286416, 0.66611385, 0.02649495,
            0.3193976, 0.16608049, 0.5121102, 0.17436478, 0.313714, 0.47244504, 0.9906781,
            0.9064671, 0.29454133, 0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972,
            0.53866875, 0.6358971, 0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548,
            0.14977625, 0.53714937, 0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625,
            0.4744624, 0.73655206, 0.42605233, 0.6592577, 0.3237799, 0.42867732, 0.87574345,
            0.70010746,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(
        kernel6,
        Some(Array::from_shape_vec((1,), vec![0.01496939]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            1.5648606, 1.8677626, 2.6079495, 1.3948092, 2.259988, 2.5566895, 2.3070786, 0.7514762,
            1.5382421, 1.9441472, 2.889693, 1.9761405, 2.9675612, 2.6650262, 1.9430202, 0.8348365,
            2.8490038, 3.5518832, 4.3400755, 3.9339044, 5.0937166, 4.262842, 3.7053952, 2.757319,
            1.855892, 1.8269329, 3.5393853, 2.7308755, 3.871139, 2.5941024, 2.357387, 1.0710617,
            2.5822158, 3.2603114, 4.122639, 3.6949968, 4.0461674, 3.6483974, 3.121075, 1.3038898,
            2.1322348, 1.9331595, 2.9305472, 2.645369, 3.036454, 2.4709206, 1.9943156, 0.76221555,
            2.939282, 3.2160926, 4.741089, 4.4136925, 5.159669, 4.769798, 3.5864248, 2.519755,
            2.1384854, 2.224335, 3.660327, 2.3297307, 3.575968, 2.221419, 2.0127563, 0.8209782,
            1.6945632, 2.5076003, 2.6116552, 2.6197, 2.6669736, 2.4357467, 2.1807213, 0.81541127,
            0.68061435, 1.0570335, 1.425868, 1.7049766, 1.5353937, 1.7723558, 1.2017505, 0.7117047,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.78416556, 0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122,
            0.68573385, 0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448,
            0.48578474, 0.2764571, 0.9192946, 0.8920509, 0.34320405, 0.4283556, 0.3897719,
            0.06360459, 0.729173, 0.19460331,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.8634254, 0.6576018, 0.9657459, 0.22873744, 0.47843248, 0.22157177, 0.9162307,
            0.02157675, 0.44649428, 0.2792192, 0.685827, 0.75294507, 0.7919586, 0.22560763,
            0.88778716, 0.80092114, 0.00003577, 0.9737877,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(
        kernel7,
        Some(Array::from_shape_vec((1,), vec![0.9146247]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            1.335871, 1.8495883, 1.3327892, 2.152991, 1.494633, 1.5637553, 1.7338283, 3.8786228,
            1.5923643, 4.621959, 2.013732, 3.1828327, 1.4227417, 2.1063757, 1.1467867, 2.610818,
            1.4549723, 1.8636174, 1.512871, 3.8569942, 1.660492, 4.649215, 1.4705563, 2.7945788,
            1.2414228, 1.8308973, 1.3393424, 1.8505961, 1.2013905, 1.3527415, 1.5458599, 4.1840553,
            1.9117907, 4.11315, 1.4155293, 2.1526918, 1.3482964, 1.9105136, 1.4300017, 2.003273,
            1.2193228, 1.20817, 0.9335379, 2.6238422, 0.9304746, 2.6074321, 0.92639315, 1.3475115,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946, 0.17754778,
            0.41998118, 0.02919354, 0.82382417, 0.4156855, 0.49590722, 0.69720376, 0.7155315,
            0.40795937, 0.15397236, 0.02265206, 0.7090415, 0.75877124, 0.67035425, 0.39483562,
            0.86222315, 0.9993058, 0.84902793,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.26427644, 0.86764544, 0.24274233, 0.69865257, 0.5739991, 0.7620597, 0.29289714,
            0.88402116, 0.8942853, 0.7757528, 0.16431308, 0.48939565, 0.56055367, 0.46453193,
            0.9573795, 0.8899508, 0.16098963, 0.63514715,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(
        kernel8,
        Some(Array::from_shape_vec((1,), vec![0.810474]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            1.2139586, 2.477975, 1.5480843, 2.3276286, 1.0537559, 1.272435, 1.3003569, 2.5155852,
            2.0048695, 2.9829373, 1.1041846, 1.5083992, 1.0339795, 1.5358298, 1.1196196, 1.6491996,
            1.1588427, 1.5145159, 1.348053, 2.3630502, 1.7485754, 2.6748443, 1.0440849, 1.490733,
            1.2648597, 2.3413985, 1.3629438, 2.0140307, 1.0106448, 1.2107288, 1.9460461, 3.6777925,
            1.814533, 3.3514183, 1.4696242, 1.6232483, 1.6838784, 3.114336, 1.5132866, 2.9063587,
            1.4895248, 2.001227, 1.6775609, 3.1059325, 1.3388267, 2.7177646, 1.3855512, 1.7932142,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.29953358, 0.46075395, 0.02808736, 0.59781086, 0.8855644, 0.61877847, 0.9537467,
            0.6197168, 0.3379795, 0.13108306, 0.30692965, 0.33537498, 0.01351478, 0.45529485,
            0.6626128, 0.9497022, 0.7403127, 0.06039312, 0.08292098, 0.80679554, 0.1354166,
            0.2560622, 0.80891573, 0.97702754,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.4124968, 0.4359102, 0.8733311, 0.1396195, 0.52047473, 0.88564533, 0.29781443,
            0.21130918, 0.83071965, 0.3337948, 0.9783562, 0.42070097, 0.55396014, 0.16172563,
            0.7634967, 0.36205766, 0.48491392, 0.4980414,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(
        kernel9,
        Some(Array::from_shape_vec((1,), vec![0.6001484]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            0.7582337, 1.1922928, 0.913592, 1.7268116, 0.7219286, 1.1309265, 1.859735, 2.6918025,
            2.0286047, 2.8181746, 1.2562115, 1.5192957, 1.064885, 2.388437, 1.1807898, 2.0695195,
            0.93197405, 1.1942766, 1.6838694, 3.4942794, 2.2057385, 2.9759119, 1.0400017,
            1.4963961, 1.1099598, 2.0415967, 1.0531749, 1.8871872, 0.7979585, 1.0028684, 1.1495538,
            2.5292335, 2.047528, 2.7392914, 1.8393061, 1.6522875, 0.70978564, 1.4027045, 0.8907199,
            2.077643, 0.932713, 1.6431289, 0.7520156, 1.2208534, 1.0572599, 1.7116141, 1.1447904,
            1.3653512,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525, 0.7446416, 0.471613,
            0.72900707, 0.842964, 0.21457537, 0.938401, 0.41665936, 0.05351101, 0.43856344,
            0.7253113, 0.8520324, 0.4151233, 0.35101932, 0.7388761, 0.3592986, 0.6741479,
            0.9965808, 0.3117034, 0.8605703,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.94308543, 0.8192489, 0.31478795, 0.750324, 0.36604244, 0.78454614, 0.039194,
            0.23696694, 0.2418382, 0.24788351, 0.5622223, 0.15428482, 0.50688076, 0.37682602,
            0.44385925, 0.00051633, 0.53422695, 0.5675659, 0.53845215, 0.2130759, 0.86445093,
            0.432881, 0.6255918, 0.3942565, 0.07226853, 0.09869356, 0.32627374, 0.8543963,
            0.85603166, 0.25422713, 0.24929269, 0.36793318, 0.39957172, 0.9079535, 0.865758,
            0.82237726, 0.60374194, 0.7658025, 0.0215734, 0.473204, 0.6594781, 0.86392707,
            0.8566667, 0.48541847, 0.54855824, 0.5860555, 0.158874, 0.10558709, 0.19664533,
            0.39609066,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(
        kernel10,
        Some(Array::from_shape_vec((1,), vec![0.27843866]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            2.8912346, 2.625986, 3.4581294, 2.6148467, 2.2221167, 1.1970608, 2.1730149, 2.256866,
            3.358251, 2.124204, 2.1764882, 1.1918517, 4.389659, 2.9808185, 4.8965926, 3.1041145,
            3.0560431, 1.9646219, 2.5042074, 2.6059191, 3.7863767, 2.4325616, 2.3755713, 1.6657397,
            4.8767486, 3.402163, 5.6758204, 3.4933991, 3.7348847, 2.0225441, 2.6793838, 2.6991138,
            3.7551517, 2.7210493, 2.6318944, 1.9417003, 3.1481273, 1.4176549, 4.446127, 2.0527015,
            2.506211, 0.9189242, 1.460008, 1.6483442, 2.2382147, 1.9010899, 1.6230804, 0.9205265,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.49128443, 0.75033015, 0.35650545, 0.4687038, 0.6159849, 0.2547001, 0.17250927,
            0.07203952, 0.8724657, 0.14018923, 0.12091745, 0.4770398, 0.43290496, 0.6356798,
            0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513, 0.06810815,
            0.79673207, 0.29373887, 0.55241185,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.23906927, 0.18915932, 0.02753429, 0.1438574, 0.5419741, 0.71984386, 0.12837073,
            0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286, 0.21388301, 0.30016333,
            0.49605927, 0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258, 0.26911622,
            0.92149794, 0.7165893, 0.04745785, 0.55642486, 0.34654748, 0.83168656, 0.8410765,
            0.7668131, 0.84094906, 0.6012723, 0.9256995, 0.66010624, 0.43380973, 0.62281454,
            0.45852852, 0.61445725, 0.524579, 0.06486581, 0.14233574, 0.13930365, 0.5838787,
            0.45914945, 0.30819193, 0.70949817, 0.8803759, 0.6927248, 0.50569826, 0.7358748,
            0.58652496,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(
        kernel11,
        Some(Array::from_shape_vec((1,), vec![0.85065925]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            2.8227863, 3.0495496, 3.8188643, 3.0913424, 3.3506336, 1.4243916, 3.5281525, 2.9698992,
            4.261135, 2.8634605, 3.399828, 1.4398787, 4.038851, 4.123572, 5.3650813, 3.2362723,
            3.2481909, 1.7146628, 2.5998473, 2.3345947, 3.6314936, 1.9588503, 2.8442585, 1.2316618,
            3.6376524, 3.3841019, 5.0355763, 3.5725422, 3.2505445, 1.9865689, 2.234879, 1.8661134,
            3.713129, 2.0565178, 2.4157271, 1.430571, 2.133387, 1.8693922, 2.7952714, 2.4785433,
            2.1065536, 1.1212062, 1.4529415, 1.3627726, 2.1742902, 1.5145274, 1.699692, 1.1580367,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.3247378, 0.6760192, 0.4483504, 0.59195757, 0.37883574, 0.7796499, 0.32748002,
            0.44507304, 0.7488422, 0.14428215, 0.8785777, 0.15468395, 0.6638725, 0.30651525,
            0.9492515, 0.55669755, 0.08302987, 0.45890567, 0.05946975, 0.9099885, 0.30235246,
            0.24214035, 0.42138377, 0.38782486,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.21880285, 0.9182205, 0.85290706, 0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431,
            0.2624427, 0.6557088, 0.00633, 0.6603214, 0.45500925, 0.6523986, 0.14666249,
            0.32440838, 0.2805719, 0.42671442, 0.74477625, 0.9118973, 0.5335283, 0.36968935,
            0.5693756, 0.36426732, 0.11819325, 0.95361024, 0.13343851, 0.5940242, 0.7282295,
            0.9320007, 0.46956548, 0.5087874, 0.7952918, 0.73709416, 0.3358689, 0.03185032,
            0.27057356, 0.26166973, 0.5843129, 0.5337139, 0.19571388, 0.1192536, 0.75616854,
            0.97167397, 0.71154076, 0.26672947, 0.07128377, 0.3383284, 0.8008563, 0.9504947,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(
        kernel12,
        Some(Array::from_shape_vec((1,), vec![0.5971434]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 8, 6),
        vec![
            1.9303043, 2.7907155, 3.2315376, 2.799849, 2.5269604, 2.173803, 2.401587, 2.5307217,
            3.7170851, 2.4688733, 3.1546025, 2.3962972, 3.148934, 3.2424183, 4.445549, 3.873236,
            4.020589, 2.8973331, 2.2762983, 2.5375538, 3.8364942, 2.5948584, 2.6850278, 2.0431051,
            2.4041386, 3.3055322, 4.218255, 3.4670613, 3.509054, 2.2747293, 2.1571803, 2.0557609,
            3.1168096, 2.8842552, 3.2589548, 1.7751105, 1.4318959, 1.9232408, 2.407589, 2.8129098,
            2.5689716, 1.4395896, 1.2092983, 1.2366385, 1.720629, 1.7505842, 2.0574145, 1.0891876,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.7847773, 0.92326206, 0.24163638, 0.12968542, 0.5954836, 0.6734995, 0.08627631,
            0.7485715, 0.8782484, 0.6863155, 0.7264353, 0.08944888, 0.68172634, 0.4284322,
            0.48237634, 0.6856524, 0.04009921, 0.0687674, 0.9063645, 0.42620143, 0.61030614,
            0.10040135, 0.50107217, 0.763057, 0.25769317, 0.8816114, 0.7770131, 0.23345616,
            0.62762326, 0.15315741, 0.73589575, 0.2752067, 0.85641515, 0.7439484, 0.6581306,
            0.4056261, 0.13899311, 0.26460668, 0.9179794, 0.96651816, 0.89336777, 0.18948041,
            0.9371178, 0.7124811, 0.9657549, 0.6203675, 0.32684848, 0.11439406, 0.07654371,
            0.95680344, 0.9728639, 0.6055871, 0.00439729, 0.8525613, 0.3167563, 0.13499211,
            0.68338645, 0.7955047, 0.21689218, 0.2826704, 0.12328367, 0.6890043, 0.5906649,
            0.41700745, 0.30266365, 0.5716598, 0.12726787, 0.35587692, 0.16889893, 0.3114892,
            0.1309899, 0.24026695,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.55435276, 0.34375766, 0.4225387, 0.37165096, 0.6202945, 0.6069533, 0.05756181,
            0.0153275, 0.8497578, 0.79796964, 0.4071996, 0.19325097, 0.04944435, 0.59729165,
            0.39304134, 0.679002, 0.6126854, 0.67232877,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(
        kernel13,
        Some(Array::from_shape_vec((1,), vec![0.7156292]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            1.2854416, 1.602797, 1.446371, 1.5152009, 1.4138165, 1.3190815, 1.3733656, 1.4397079,
            1.6186056, 1.687866, 1.2465724, 1.1988857, 1.2240691, 2.9098268, 1.4393504, 4.0267906,
            1.976925, 3.6351008, 1.7983282, 3.1899219, 1.6549201, 2.5006883, 0.9193741, 1.4752362,
            1.3288786, 1.4497564, 1.6055231, 1.8241647, 1.8372393, 1.9140102, 1.5118873, 1.662162,
            1.3614569, 1.3239064, 0.83944046, 0.8148821, 1.5566273, 3.24971, 1.7005165, 3.946713,
            1.8827649, 3.8271317, 1.588532, 2.4121509, 0.94259393, 2.3717282, 1.1578897, 1.0623647,
            1.1842192, 1.3660259, 1.5528741, 1.5791092, 1.5959282, 1.675551, 1.5026478, 1.3849293,
            0.743129, 0.8094077, 1.267513, 1.0924597, 1.2135284, 2.8088999, 1.5098941, 3.5011425,
            1.8071544, 3.3106685, 1.4556159, 2.357715, 0.9795038, 2.2377117, 1.6164451, 1.7243137,
            1.467038, 1.5553212, 1.0606292, 1.2879815, 1.5023798, 1.4313031, 1.2530559, 1.2861824,
            1.1559894, 1.4025716, 1.3577859, 1.2898704, 1.0623785, 2.9862146, 1.3884925, 3.0754452,
            1.6513073, 3.1442714, 1.4546199, 2.280572, 1.1951909, 2.387854, 1.1859417, 1.729279,
            0.9491112, 1.2822117, 1.6740245, 1.839516, 1.5504055, 1.5267785, 1.1095159, 1.2694492,
            1.2857189, 1.3007131, 1.1520796, 1.0332745, 1.0999063, 2.308155, 1.3908024, 3.1684031,
            1.4526055, 3.1250873, 1.3572781, 2.2799182, 1.1902632, 2.5694058, 1.305498, 1.4479438,
            1.2481173, 1.332182, 1.0989008, 1.3491797, 1.3477408, 1.593708, 1.3631463, 1.5406709,
            1.2021031, 1.3291993, 1.1107463, 1.0562601, 0.80488384, 1.6840107, 0.937888, 1.3527341,
            0.83223784, 1.8112551, 0.91787696, 1.6840539, 0.80597234, 1.5494394, 0.8690545,
            1.2218516,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.09058711, 0.33372015, 0.8941644, 0.30899736, 0.3348802, 0.6412177, 0.26750943,
            0.03709449, 0.56803024, 0.8756273, 0.5771133, 0.56024176, 0.5868575, 0.75167763,
            0.36936092, 0.37185487, 0.35425207, 0.24336162, 0.01027582, 0.2671537, 0.83992416,
            0.49819484, 0.7831867, 0.70054483, 0.8701863, 0.49413827, 0.84670645, 0.8069649,
            0.093459, 0.93408287, 0.8206956, 0.70209366, 0.32817394, 0.744203, 0.39091238,
            0.43911496, 0.92919487, 0.29325068, 0.62813336, 0.8131431, 0.19520658, 0.47931832,
            0.42483747, 0.47526902, 0.28184402, 0.09741595, 0.45691565, 0.44086096, 0.9638409,
            0.33859608, 0.26381832, 0.29839757, 0.68755937, 0.09156765, 0.58584654, 0.04617033,
            0.14705709, 0.81179595, 0.16751295, 0.06864621, 0.6308731, 0.38993102, 0.3644169,
            0.68174505, 0.272409, 0.23609333, 0.21866773, 0.80119157, 0.01742986, 0.49270406,
            0.37920174, 0.90869635,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.8191268, 0.7636344, 0.7827788, 0.9694966, 0.79533535, 0.00732174, 0.8372113,
            0.9449071, 0.7670253, 0.50964797, 0.7843069, 0.7365313, 0.71123123, 0.89694643,
            0.9544987, 0.16811895, 0.97018677, 0.25394833,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(
        kernel14,
        Some(Array::from_shape_vec((1,), vec![0.5585159]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            1.464001, 1.978204, 1.0869656, 2.154504, 1.8330784, 2.04252, 1.5336182, 1.8004246,
            0.9999478, 1.7098567, 1.4984219, 1.0207195, 2.0830872, 1.987573, 1.5594418, 2.7311811,
            2.6676445, 3.2184033, 2.3844533, 2.7779717, 1.8633991, 2.9542446, 2.4030256, 1.9353215,
            1.1523321, 1.3399706, 1.0143093, 1.7635908, 1.2630894, 1.7498976, 1.3423102, 1.5423925,
            1.4273434, 1.8555734, 1.3995247, 0.98341906, 2.4275508, 2.9401097, 1.8942367,
            2.5053988, 1.8576642, 2.7553582, 1.9984105, 2.9663148, 2.3569045, 2.6900883, 1.7732662,
            1.3581321, 1.889778, 2.4523668, 1.4600542, 1.432939, 1.0889126, 1.3857763, 1.1219119,
            1.6785185, 1.456969, 1.5184482, 0.8342013, 0.64769894, 2.515478, 2.6215549, 1.8375024,
            2.5807233, 1.9202136, 2.8579106, 2.2165213, 3.0464826, 2.289762, 2.569241, 1.4661076,
            1.3673656, 1.0921617, 1.4096234, 0.812405, 1.5234368, 1.3584397, 1.7654042, 1.6828854,
            2.2154589, 1.3316622, 1.4521402, 1.1772559, 0.62916785, 2.2959085, 2.6959095,
            1.5389118, 3.056353, 2.427228, 3.7333212, 2.967781, 3.179842, 1.7460942, 2.9590764,
            2.1855328, 2.0183544, 1.8164653, 1.9234513, 1.3012688, 2.0143862, 1.5587939, 2.1797788,
            1.8118124, 1.499503, 0.87718344, 1.8927213, 1.5131881, 0.7907058, 2.79104, 3.652341,
            2.5682597, 3.2240782, 1.9764026, 3.221146, 2.937173, 2.9335527, 1.5070382, 2.9291935,
            2.7182121, 2.34795, 1.4073774, 2.0237527, 1.8355417, 1.658953, 0.8351579, 1.6494843,
            1.5923359, 1.6829386, 1.209546, 1.9953394, 1.7228115, 1.4290805, 1.5461456, 1.9660367,
            1.9992347, 1.578182, 0.88552, 1.5205479, 1.7397336, 1.645487, 1.2957883, 1.4750543,
            1.855044, 1.12609,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028, 0.52249014,
            0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726, 0.25884646,
            0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234, 0.32747796,
            0.9097073, 0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446, 0.9843364,
            0.4038572, 0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686, 0.5288406,
            0.92906404, 0.87780553, 0.9090181, 0.82569945, 0.20383635, 0.7166643, 0.17061436,
            0.91526777, 0.08598401, 0.70100874, 0.40537685, 0.5971982, 0.92796123, 0.15859716,
            0.7859081, 0.8564488, 0.35816404, 0.79062706, 0.9644883, 0.13154314, 0.31929043,
            0.80048305, 0.07180241, 0.52815664, 0.45786336, 0.91537887, 0.9783313, 0.25753945,
            0.42799363, 0.07738555, 0.9294206, 0.07022415, 0.60058224, 0.6196278, 0.9008346,
            0.04155485, 0.82207745,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.41282526, 0.9949608, 0.3109271, 0.47614527, 0.7615821, 0.35893062, 0.07713356,
            0.6123928, 0.62511915, 0.88098776, 0.21521498, 0.89468116, 0.1842307, 0.10784956,
            0.8354833, 0.2630701, 0.7184675, 0.06132602,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(
        kernel15,
        Some(Array::from_shape_vec((1,), vec![0.06056971]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            0.55106086, 1.3554772, 0.49049464, 1.2686543, 0.3736732, 1.1402369, 0.4770815,
            0.93252844, 0.75155705, 1.3223453, 0.62655, 0.46118727, 1.7263625, 1.9859676,
            1.5216603, 1.6234928, 1.3150795, 1.616111, 0.9486932, 1.718639, 1.3827285, 2.4006567,
            1.5036612, 1.5633782, 0.5572001, 1.2787392, 0.46987137, 0.60812664, 0.38895354,
            1.0014317, 0.36238638, 0.7195734, 0.26677984, 1.1229607, 0.6815216, 1.0813507,
            1.7909688, 1.672178, 0.8706929, 2.4717882, 1.7457933, 1.9232633, 0.9968125, 1.8892294,
            1.4748973, 2.6698945, 2.2774491, 1.6966046, 0.62780106, 0.7203844, 0.34246236,
            1.3478436, 0.76068753, 1.3009926, 0.37504128, 0.9709787, 0.68247336, 1.5937997,
            0.87167215, 1.199629, 1.1117887, 1.3889607, 1.0828663, 1.755511, 1.6626996, 1.9909098,
            1.4602827, 1.6908472, 1.914087, 1.9955652, 1.4530241, 1.1198676, 0.4319119, 0.50788766,
            0.27137402, 0.71385413, 0.3963028, 1.2932829, 0.76113033, 0.898659, 0.684185,
            0.86875147, 0.13474432, 0.45479232, 0.94470054, 2.4978557, 1.2638748, 1.8359184,
            1.0814457, 1.4765704, 1.7407424, 1.7538548, 1.3141595, 1.9319332, 1.1813667, 1.1192472,
            0.39307898, 1.4132141, 0.641829, 1.2404356, 0.23361288, 0.8917404, 0.85638154,
            0.9780112, 0.3764861, 0.715083, 0.5985425, 1.043388, 1.5696588, 1.6903402, 1.9540877,
            2.2951324, 1.474896, 2.1138117, 1.3472354, 1.8715703, 0.89860684, 1.9160019, 2.1816194,
            1.5012362, 0.56439066, 0.78861684, 0.6449329, 1.3899504, 0.87685984, 1.1847721,
            0.29741132, 1.1384966, 0.4678069, 0.8789265, 0.85678893, 1.0808713, 0.51005894,
            0.68282396, 0.9098745, 0.76280135, 1.1084003, 0.96487135, 0.82011324, 0.28219488,
            0.4142837, 0.6816325, 1.2201577, 0.6917602,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.71349823, 0.00944792, 0.07349233, 0.35231608, 0.8533961, 0.17608605, 0.18067755,
            0.51991457, 0.19053963, 0.5045173, 0.7456122, 0.27621788, 0.48649722, 0.39297876,
            0.54849166, 0.3746991, 0.8194284, 0.34880427, 0.79505837, 0.41293454, 0.890512,
            0.12076204, 0.20799449, 0.88948244, 0.24437675, 0.7731474, 0.65954226, 0.4922565,
            0.5211581, 0.97382414, 0.9779564, 0.1754263, 0.4551989, 0.81067127, 0.7095975,
            0.5087082, 0.78796804, 0.03310984, 0.20805901, 0.45704818, 0.9133983, 0.5689028,
            0.04247752, 0.55938286, 0.9835293, 0.04525762, 0.7176199, 0.82096803, 0.5575717,
            0.5744108, 0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355, 0.1134909,
            0.5645703, 0.30096474, 0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894,
            0.681929, 0.24701218, 0.74485576, 0.61556435, 0.63869125, 0.05875124, 0.3210932,
            0.96946657, 0.09463912,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.6275637, 0.34162354, 0.74390864, 0.8736778, 0.9513908, 0.24045336, 0.7003475,
            0.87750345, 0.16564246, 0.6314963, 0.21785556, 0.7654987, 0.13988015, 0.03287261,
            0.82226163, 0.60896695, 0.13331373, 0.62307173, 0.23316076, 0.9600204, 0.55291533,
            0.29808274, 0.8765127, 0.98263544, 0.27148733, 0.11101003, 0.2754741, 0.4540411,
            0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969, 0.5836321,
            0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643, 0.91682273,
            0.6142979, 0.19277428, 0.28408903, 0.25507236, 0.9800453, 0.36125833, 0.96792,
            0.33258557,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(
        kernel16,
        Some(Array::from_shape_vec((1,), vec![0.9508625]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            2.3458061, 1.7294468, 2.9263692, 2.0865045, 2.7872522, 2.198675, 3.118752, 3.3901167,
            4.1424975, 2.9482954, 3.8622932, 1.520746, 2.7591262, 2.2509375, 3.9828935, 2.4476695,
            3.1741571, 2.0865147, 4.5751324, 3.3898206, 5.20421, 3.1261826, 4.134685, 1.3002225,
            3.0792365, 4.1482425, 4.0188546, 3.2525716, 4.648695, 3.3801975, 4.693366, 4.839838,
            5.4019666, 5.5333295, 4.975626, 2.3940644, 3.1007638, 2.605951, 4.806857, 3.6218266,
            4.765902, 2.1678004, 4.5297976, 2.8607364, 5.21676, 3.3567204, 4.1151543, 1.395132,
            3.2697878, 3.7109342, 5.2531085, 5.2576623, 5.177658, 4.161057, 5.069542, 3.772553,
            4.564654, 5.0920773, 4.747043, 3.1668768, 3.1057248, 2.3107328, 4.754923, 3.389585,
            4.609294, 2.2663212, 4.4931226, 2.1421802, 4.2105803, 3.3517447, 4.0976653, 1.4553244,
            3.444467, 3.9499187, 5.202418, 5.4392395, 5.509539, 4.498436, 5.477022, 3.6158295,
            5.0533285, 5.353492, 4.455563, 3.333366, 3.4100251, 2.6831293, 5.550283, 3.172317,
            5.1991796, 2.82625, 4.639974, 2.2559881, 4.626591, 3.264153, 3.965465, 1.5682105,
            4.300781, 4.6813135, 5.423684, 4.0743403, 5.255301, 4.65086, 5.222153, 3.9144106,
            5.4278827, 4.825028, 4.6576457, 3.0828543, 4.3222265, 2.8797436, 4.7644486, 2.5754125,
            4.8058515, 2.9138975, 5.317839, 3.1342359, 5.178354, 2.6798182, 4.105228, 1.4233965,
            2.9441535, 3.7523208, 4.5218973, 3.8549027, 3.379736, 4.0786414, 3.5563402, 3.9413147,
            4.5011783, 3.4864564, 3.3584676, 2.6722474, 2.3434477, 1.906502, 2.8708844, 1.2294371,
            2.2640607, 1.4707819, 2.9917846, 2.185206, 3.2119985, 1.4577861, 2.2826037, 1.0877173,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.8424581, 0.8130291, 0.7774976, 0.17691322, 0.9389267, 0.22419459, 0.33442205,
            0.7614585, 0.37563834, 0.70754576, 0.1499497, 0.9873837, 0.7166968, 0.40278858,
            0.22288306, 0.3279577, 0.07722609, 0.598755, 0.8143903, 0.87905455, 0.83061284,
            0.9923988, 0.6196494, 0.536406, 0.06662867, 0.83588266, 0.28182983, 0.662181,
            0.99850965, 0.60448396, 0.12318801, 0.91713256, 0.8540598, 0.19103892, 0.5929614,
            0.9118344, 0.9381113, 0.3421722, 0.8149188, 0.9595595, 0.02717085, 0.8916309,
            0.9755575, 0.27588442, 0.59208006, 0.00008138, 0.9552037, 0.12578069, 0.01249961,
            0.05413999, 0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439, 0.34315115,
            0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794, 0.6930413,
            0.90735817, 0.91156703, 0.45996496, 0.9045769, 0.17170428, 0.43418503, 0.69308424,
            0.42869946, 0.9244341,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.41451567, 0.6224708, 0.00536506, 0.33826837, 0.47926104, 0.0032256, 0.02230139,
            0.35960108, 0.48593593, 0.86064774, 0.28908366, 0.4153976, 0.3468706, 0.2242362,
            0.93169004, 0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496, 0.11111139,
            0.19382912, 0.9307082, 0.9188555, 0.10532705, 0.88550454, 0.20754221, 0.97926295,
            0.3472928, 0.71126235, 0.03633394, 0.7482733, 0.28782296, 0.7382309, 0.60003114,
            0.3259743, 0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927, 0.968827,
            0.47373444, 0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834, 0.3979838,
            0.2393961,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(
        kernel17,
        Some(Array::from_shape_vec((1,), vec![0.36507484]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            2.6536026, 2.535378, 3.830956, 2.4119549, 3.3266652, 2.526606, 3.1248071, 1.7250485,
            3.0638566, 2.4656246, 2.324967, 1.142478, 1.8364096, 3.5591028, 3.8747742, 3.4395447,
            3.5408025, 3.1924767, 3.231448, 2.834472, 2.737947, 2.920584, 2.760561, 1.7760764,
            2.7509532, 3.2085605, 4.080848, 2.7889345, 4.627028, 2.6462047, 4.123366, 2.6104968,
            5.296489, 3.0950992, 3.0300288, 1.6238275, 1.5603892, 2.4430587, 2.697534, 2.5142114,
            2.3703382, 2.2702382, 2.509995, 2.9736302, 2.685502, 3.0500853, 2.200211, 1.9152035,
            3.3856988, 2.8044796, 5.0750213, 2.9691567, 4.2109, 3.0328977, 4.9998136, 3.2631264,
            5.047498, 3.3030431, 3.8495204, 2.1869874, 1.2196504, 2.4738867, 3.1492546, 2.3999536,
            2.816801, 2.7948909, 3.2339575, 3.5064104, 3.6554239, 3.7191007, 2.8422523, 2.1644685,
            3.8512335, 3.3137414, 4.982389, 2.8841703, 5.706758, 3.1702497, 6.0029435, 3.8216476,
            5.741802, 3.5362487, 4.02406, 1.9905013, 1.70476, 3.7767222, 3.5605285, 3.8360212,
            4.0457673, 3.8810322, 3.8334124, 4.554461, 4.587361, 4.1853194, 3.658182, 2.0218925,
            4.01118, 4.1011686, 4.5001717, 3.7602587, 5.27561, 3.6563535, 5.743225, 4.181004,
            5.950512, 3.813352, 4.4015036, 2.1417348, 1.9074017, 3.2800689, 2.975149, 3.4133918,
            4.0663333, 3.5980933, 3.660136, 3.8978832, 3.4366004, 3.8554952, 3.389013, 2.2623742,
            1.9730208, 1.8710945, 3.1769223, 2.6033921, 3.3996317, 2.1153364, 3.5886514, 2.509049,
            3.4608166, 3.2602394, 2.535141, 1.6703366, 1.2122513, 1.8209771, 1.7066352, 2.0299966,
            2.093992, 2.0683248, 2.1470244, 1.7743511, 2.0402353, 2.5089629, 1.699977, 1.7058103,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.01646563, 0.27730468, 0.62646276, 0.94121945, 0.66457146, 0.8425775, 0.4301739,
            0.68211764, 0.6059688, 0.7629583, 0.56038123, 0.48163053, 0.437191, 0.43973154,
            0.29997745, 0.21913478, 0.6611514, 0.209788, 0.176356, 0.88925517, 0.14793599,
            0.36509594, 0.5616029, 0.6617385, 0.30053073, 0.36820948, 0.62227124, 0.4957459,
            0.69923055, 0.3227648, 0.9702412, 0.5679234, 0.13432135, 0.7430913, 0.19231908,
            0.26170298, 0.10480803, 0.00958306, 0.20726651, 0.20851518, 0.17973869, 0.23704103,
            0.1163867, 0.2735905, 0.8537909, 0.40303, 0.75797635, 0.34342998, 0.74670875,
            0.82946825, 0.91931367, 0.9654975, 0.18782942, 0.10021565, 0.05109123, 0.3069365,
            0.10895161, 0.9891213, 0.62504834, 0.507994, 0.47125, 0.84314245, 0.6054993,
            0.92367506, 0.6953895, 0.37023902, 0.67128026, 0.43450755, 0.28869846, 0.27641538,
            0.8369712, 0.6856483,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.26890948, 0.65425915, 0.84581685, 0.51146317, 0.48995435, 0.52071315, 0.80564773,
            0.670521, 0.3835857, 0.47078377, 0.5100531, 0.82525116, 0.02126783, 0.9583153,
            0.23316967, 0.9487504, 0.9609589, 0.95734006, 0.00943314, 0.7521432, 0.46106157,
            0.84370506, 0.16933449, 0.71423984, 0.5316646, 0.6400151, 0.9638914, 0.69432026,
            0.8581641, 0.70813745, 0.2836983, 0.33953485, 0.8950543, 0.20262088, 0.81930757,
            0.09556881, 0.22266188, 0.63842744, 0.8304186, 0.12425002, 0.7582065, 0.09737789,
            0.84872884, 0.17490041, 0.37569723, 0.6669188, 0.8970669, 0.22398192, 0.29424527,
            0.56277037,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(
        kernel18,
        Some(Array::from_shape_vec((1,), vec![0.41113177]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 12, 12),
        vec![
            1.4239382, 1.7748157, 2.548826, 3.0510604, 3.2190306, 3.9370427, 3.554702, 3.9080634,
            3.24659, 3.5286, 2.21481, 1.9564855, 1.6116253, 1.5280606, 3.0458913, 2.1327865,
            4.677446, 2.5350256, 5.1689672, 2.1957598, 5.057088, 2.1547692, 3.501495, 0.71487117,
            2.5665157, 3.780641, 4.009518, 4.916665, 4.8398776, 5.926167, 4.324071, 5.1179953,
            4.331787, 4.235801, 2.2196906, 2.0227273, 3.2021163, 2.0725756, 5.157781, 2.0214264,
            5.6597624, 2.1442988, 5.669602, 1.9772493, 4.6768413, 1.5399662, 2.5654666, 0.57651854,
            2.4167914, 4.171889, 3.9027677, 4.7384863, 4.430145, 4.9085636, 5.0538087, 5.8320885,
            4.4723477, 4.480087, 3.1702528, 1.9148452, 3.2236333, 1.9478332, 4.2309136, 1.4976155,
            4.398437, 1.5881494, 4.5398464, 2.2408366, 4.4130583, 1.7092568, 2.939766, 0.7874021,
            3.1476448, 4.683555, 4.3563337, 5.2031097, 5.160988, 4.7532277, 5.2322893, 5.52593,
            4.6886473, 4.4444065, 2.8384073, 2.1292686, 2.7539656, 2.0998454, 3.9226973, 1.6449711,
            4.86926, 1.9531412, 5.268659, 2.364876, 5.4930043, 2.0059807, 3.5797534, 0.70504856,
            3.360318, 4.611375, 3.8975189, 4.0900187, 4.142392, 4.527185, 4.432011, 5.521324,
            4.7428904, 5.255268, 3.1643186, 2.3722608, 3.7578142, 2.045589, 4.8601136, 1.7311369,
            4.7223363, 1.8917834, 4.938869, 2.0971758, 4.762748, 1.572569, 3.3869848, 0.7182436,
            2.0800436, 3.8841298, 2.4732616, 3.0706031, 2.9459825, 3.3238566, 2.5972655, 3.537485,
            2.809467, 2.9675899, 1.9039538, 1.5707734, 2.7779815, 1.1257539, 2.6518958, 0.6496748,
            2.2897408, 1.2038893, 2.3836763, 0.7327999, 2.7365215, 0.87758535, 1.7026992,
            0.53352064,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.7882464, 0.24159203, 0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633,
            0.9636684, 0.98529965, 0.26998708, 0.13811645, 0.9724998, 0.41856614, 0.13321315,
            0.0937838, 0.4742414, 0.79873264, 0.1621314, 0.5493846, 0.6481355,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.05176858, 0.17029643, 0.955536, 0.089831, 0.05664136, 0.9231865, 0.98567015,
            0.01680515, 0.54690886, 0.8593988, 0.6496963, 0.8382851, 0.2400014, 0.36792266,
            0.01756373, 0.6596718, 0.5680892, 0.19350345,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(
        kernel19,
        Some(Array::from_shape_vec((2,), vec![0.4854058, 0.7869872]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            0.53005314, 1.2348067, 0.4990899, 0.75749624, 0.51633716, 1.016221, 0.5022227,
            0.78772664, 0.5032029, 0.7754779, 0.628897, 1.8877283, 0.4969957, 1.2479388,
            0.65869224, 2.0485423, 0.6581883, 1.9129548, 0.53666395, 0.91523105, 0.52872574,
            1.195441, 0.48791027, 0.612793, 0.5399893, 1.4635619, 0.5412145, 1.4192743, 0.5006982,
            0.7346542, 0.5217793, 1.1295906, 0.6517621, 2.4103746, 0.5728807, 2.3904762, 0.5246496,
            1.422538, 0.50591403, 0.72267795, 0.4932289, 0.70027363, 0.5404895, 1.4208047,
            0.50911397, 0.88378704, 0.49295118, 0.6168111, 0.49071786, 0.5719857, 0.5684885,
            2.014011, 0.6377701, 2.2014537, 0.5200503, 1.0289907, 0.5812027, 1.209211, 0.59735703,
            1.1560137, 0.5122675, 0.99497, 0.5306471, 1.2373495, 0.49458915, 0.68443507, 0.5165237,
            1.050813, 0.5221171, 1.0837557, 0.4933755, 1.5320596, 0.49882862, 1.0820478,
            0.48813045, 1.1155889, 0.4946383, 1.424717, 0.4962978, 0.83987683, 1.0770009,
            0.8588142, 0.8758744, 0.9222932, 0.98790663, 0.8678353, 0.8962239, 0.8676121,
            0.9025912, 0.79250586, 1.7316763, 1.7780162, 0.9529602, 2.0592184, 1.7233076,
            2.7431092, 1.5957992, 2.1097012, 1.1408947, 1.0741136, 1.0683784, 0.8110321, 0.8032554,
            1.0190456, 1.1415427, 1.0403861, 1.1495013, 0.86908996, 0.88632154, 0.79172915,
            1.3112018, 1.9156951, 1.4439355, 2.6061954, 1.6063776, 2.0887957, 1.4332733, 1.3480172,
            1.0012949, 0.91784817, 0.83780336, 1.0228143, 1.1447918, 0.9045243, 0.94098717,
            0.8263101, 0.8359993, 0.81183517, 0.8214924, 0.78863436, 1.1735625, 2.5392232,
            1.8583875, 2.0601869, 1.1301062, 1.563911, 1.2195973, 1.8921787, 1.261356, 1.348457,
            0.9614713, 0.9870136, 1.0808591, 0.8399277, 0.846639, 0.9216879, 0.9891182, 0.95218986,
            1.025451, 0.79837084, 1.0563986, 1.4056559, 1.2407386, 1.0484982, 0.8790923, 1.1807737,
            1.0990866, 1.3208517, 1.1551859, 0.91240364,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.12335967, 0.14544043, 0.25711668, 0.05608724, 0.18204254, 0.9562488, 0.44598028,
            0.3229758, 0.8930679, 0.24216229, 0.21437034, 0.38366762, 0.64894366, 0.8650639,
            0.7790032, 0.3529938, 0.37360683, 0.26240814, 0.554433, 0.90017563,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.6817857, 0.95833224, 0.28551313, 0.85106283, 0.70093375, 0.4791875, 0.5805011,
            0.9803199, 0.97033703, 0.48236644, 0.66855663, 0.35855147, 0.25242767, 0.6717967,
            0.26290378, 0.53677225, 0.18097793, 0.07985484,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(
        kernel20,
        Some(Array::from_shape_vec((2,), vec![0.79416144, 0.7215235]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            0.8806284, 0.9770528, 0.8961055, 1.0826771, 0.9743832, 0.9651023, 0.8334749, 0.9759674,
            0.9217612, 0.88139397, 1.8314974, 1.5753748, 1.3641369, 1.4320776, 1.3557361,
            1.7773046, 1.7050006, 1.3743463, 1.2046933, 1.0399445, 1.4644285, 1.6319412, 1.1067641,
            1.2827423, 1.0205461, 1.7089844, 1.4201429, 1.4282037, 0.96390116, 0.91020256,
            1.9370292, 2.303722, 1.5990459, 1.9663831, 1.7326847, 2.401054, 2.4986725, 2.5794141,
            1.7781018, 1.2515562, 0.9444208, 1.2234102, 1.063087, 1.530302, 1.249028, 1.8413509,
            1.4005139, 1.8716699, 1.3401911, 1.1674501, 1.3425982, 1.5803965, 1.5283179, 1.8287367,
            1.681808, 2.3789515, 2.173532, 2.857802, 2.4205012, 1.8070691, 1.0415866, 1.2812746,
            1.056035, 1.196515, 0.9780922, 1.3917614, 1.1827822, 1.8259448, 1.4251249, 1.2255144,
            1.1402082, 1.3535635, 1.1604156, 1.3090142, 1.0514054, 1.3706348, 1.3376832, 1.8547012,
            1.6766216, 1.6676352, 0.80439615, 0.7906684, 0.8192299, 0.82466376, 0.8942537,
            0.80327845, 0.7592027, 0.7822217, 0.8438191, 0.7693832, 1.3831553, 1.3674331,
            1.0460081, 1.1868503, 0.9839836, 1.3187511, 1.3287406, 1.2607396, 0.9163684,
            0.82288814, 1.3639283, 1.0855027, 1.0211316, 0.92030144, 0.9384976, 1.0318701,
            1.3214836, 1.017443, 0.88420737, 0.7851889, 1.0379021, 1.2992057, 1.0587397, 1.3810949,
            1.2138306, 1.8766463, 1.4614933, 1.6087602, 1.2861574, 1.0201741, 0.8655368, 0.8747306,
            0.97927016, 0.98620254, 1.1574817, 1.1104994, 1.3026706, 1.1455941, 1.2448553,
            0.9263264, 0.9963162, 1.2513659, 1.0407362, 1.3610303, 1.0144026, 1.5992138, 1.2487508,
            1.8417577, 1.4643242, 1.10649, 0.9586636, 0.9086356, 0.97251135, 0.88598526,
            0.89780843, 0.9304658, 1.0939897, 1.0945153, 1.3262585, 0.9581831, 0.7854076,
            0.95025355, 0.78913814, 0.89221126, 0.7690136, 1.0400823, 0.82186365, 1.248987,
            0.8844354, 0.7934069,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.42313012, 0.6529702, 0.00384528, 0.08442257, 0.7838985, 0.980683, 0.36212954,
            0.61172485, 0.5263662, 0.8496614, 0.13177402, 0.9175598, 0.04323238, 0.03087392,
            0.03482862, 0.36226457, 0.6059544, 0.29194582, 0.34645593, 0.9409913,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.60953087, 0.8610255, 0.1627552, 0.8939359, 0.66327935, 0.48094535, 0.06551108,
            0.86129206, 0.65446067, 0.9592776, 0.8000413, 0.21450381, 0.6442533, 0.46971878,
            0.84573215, 0.34651902, 0.18830031, 0.57119006,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(
        kernel21,
        Some(Array::from_shape_vec((2,), vec![0.27269888, 0.7915957]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            0.55335236, 1.0599148, 0.70580053, 0.5901793, 0.27524936, 0.3500166, 0.3286946,
            1.0140564, 0.79264253, 0.6497112, 1.4815307, 0.9727381, 1.1468997, 1.1320977,
            0.8027215, 0.7011439, 0.79862607, 0.98286784, 1.6794446, 0.9240164, 0.9231657,
            1.0680745, 0.51289195, 0.9937062, 0.6784433, 1.0374427, 0.6218267, 1.2853951,
            0.83626175, 0.6813396, 1.2308142, 1.5189687, 1.3746406, 0.72546226, 0.8367968,
            0.73338646, 0.75263715, 0.6991011, 1.0344939, 0.8344374, 0.36010188, 1.1563146,
            0.88129735, 0.752642, 0.30137402, 0.3210906, 0.29317692, 0.3186821, 0.29579997,
            0.28944954, 0.6981138, 0.84735847, 1.584728, 1.1526101, 0.5613074, 0.56170666,
            0.5975977, 0.92513704, 1.112914, 0.44864407, 0.5129815, 0.9886127, 0.6746159,
            0.8251107, 0.4663405, 0.72281826, 0.50249594, 1.2805111, 0.89683896, 0.72526425,
            0.5847145, 0.54948354, 0.7946026, 0.6883979, 0.52414954, 0.48646265, 0.5710986,
            0.561086, 1.0831672, 0.8885407, 0.99034786, 1.5701287, 1.0983081, 1.3463109, 0.7934019,
            0.8492373, 0.83125055, 1.3680238, 1.1598076, 1.4545639, 1.6558583, 1.8172929,
            1.2042688, 1.8303903, 1.2817249, 1.4591947, 1.2286072, 2.0394216, 1.6189682, 1.4216063,
            1.2522409, 1.8542941, 0.9616947, 1.491966, 1.0789343, 1.6480643, 1.0388398, 1.7841578,
            1.1906977, 1.5101817, 1.0816833, 2.3856974, 1.5938705, 1.4487067, 0.9413714, 1.3622929,
            0.915411, 1.4267075, 0.97945154, 1.2843847, 0.85349244, 1.4941821, 1.2225908, 1.595458,
            0.81190276, 0.84804934, 0.80609775, 0.84014523, 0.8079554, 0.82105136, 1.1062354,
            1.8438011, 1.449161, 1.7407142, 1.033305, 1.2219589, 1.0745883, 1.7982874, 1.5509858,
            1.0133357, 0.96175814, 1.4883627, 1.0762239, 1.4921579, 0.9287281, 1.261709, 0.9543326,
            1.6908414, 1.233597, 1.5874223, 0.85981023, 1.2084923, 0.9056971, 1.2388756, 0.8465692,
            1.0784059, 0.85683346, 1.3155593, 0.96878463, 1.3290806,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.21737069, 0.04463017, 0.393406, 0.8441482, 0.77705365, 0.6315176, 0.8522896,
            0.16809769, 0.22305161, 0.773223, 0.9678148, 0.2237789, 0.8982615, 0.271913,
            0.34780893, 0.49277794, 0.14560463, 0.33638617, 0.1585067, 0.18610527,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.6963084, 0.9429821, 0.40789625, 0.20056698, 0.37306353, 0.9367061, 0.7103306,
            0.06833509, 0.48335183, 0.45182207, 0.96346164, 0.00378525, 0.33689302, 0.28288215,
            0.75004077, 0.1607512, 0.514175, 0.35879079, 0.36688787, 0.00774159, 0.15532039,
            0.01133456, 0.94680935, 0.052598, 0.73530346, 0.8096563, 0.7097644, 0.37942106,
            0.38656324, 0.13763146, 0.99930644, 0.67476803, 0.06055127, 0.8463604, 0.4460729,
            0.33209085, 0.94373864, 0.5397614, 0.05766413, 0.64256257, 0.7357459, 0.09256811,
            0.8832945, 0.03911254, 0.782554, 0.4004812, 0.80732703, 0.8010379, 0.28867772,
            0.7802926,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(
        kernel22,
        Some(Array::from_shape_vec((2,), vec![0.9490529, 0.5395702]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            1.916333, 1.9410675, 2.2064466, 1.2926214, 2.4702048, 1.3075843, 2.969267, 1.9646609,
            2.2425895, 1.3239505, 1.8757176, 1.962404, 1.5310221, 1.6990674, 1.8317508, 1.7671194,
            2.1953585, 2.3153586, 1.3880055, 1.6078832, 2.746283, 1.5479944, 3.2127988, 2.0895202,
            3.0354645, 1.4642801, 3.7926638, 1.4507995, 2.9765816, 1.2784142, 1.588393, 2.245727,
            2.5807364, 2.094406, 1.4690123, 1.7527379, 1.90491, 1.8069487, 1.3748288, 1.4008532,
            2.523398, 1.502692, 4.390663, 1.4088998, 2.8038843, 1.4324911, 2.8241136, 1.2550701,
            2.3013232, 1.1254383, 1.5023315, 1.7608064, 1.7289245, 1.8023419, 1.5540321, 1.69361,
            1.4466217, 1.4364599, 1.1602829, 1.166614, 2.2064443, 1.1424437, 2.7548366, 1.0134668,
            2.381565, 1.0951393, 2.4060278, 1.0128404, 1.6598842, 1.0199928, 1.1492631, 1.2047133,
            1.0591838, 1.1754348, 1.0963525, 1.153969, 1.0384444, 1.1028978, 1.0170528, 1.0173327,
            1.6013926, 1.4432702, 1.3803753, 1.3621898, 1.422604, 1.5822054, 2.23986, 1.9566126,
            1.8254879, 0.8832779, 1.6543467, 1.6617928, 1.5398341, 1.4125037, 2.1563263,
            0.92587787, 3.0259538, 1.3550456, 2.032846, 1.2243881, 1.9038657, 2.0120578, 2.7695227,
            1.8019068, 2.5318232, 2.095066, 2.8275247, 2.5051498, 2.5507727, 0.9429257, 2.006681,
            1.6132842, 3.2531714, 1.3839817, 1.945059, 1.5105236, 2.201754, 1.0846968, 1.5394571,
            0.8641846, 2.2883296, 1.9707836, 3.2187724, 2.0769854, 2.4235325, 1.3191211, 2.2556505,
            1.7654881, 1.7878793, 0.85478, 1.7344221, 1.1134558, 2.7202768, 0.98168975, 1.9518932,
            0.99153316, 2.0842133, 0.8421331, 1.141549, 0.710686, 1.7187823, 1.1654478, 2.3406844,
            1.6552178, 1.8703878, 1.1873873, 1.9610893, 1.0836358, 1.2326529, 0.6507065, 1.0819663,
            0.57232237, 1.3013021, 0.5764038, 1.0672624, 0.5673998, 1.0797448, 0.5629972, 0.827996,
            0.54684925,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.1369102, 0.4513485, 0.1162144, 0.9589836, 0.24819064, 0.3149064, 0.22322156,
            0.39812055, 0.45308354, 0.5711523, 0.97817534, 0.06805564, 0.5386646, 0.6699801,
            0.1879456, 0.8407316, 0.64728755, 0.53731096, 0.63207716, 0.00916763,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.46754488, 0.8670982, 0.1932068, 0.43971533, 0.10441232, 0.46486124, 0.22910197,
            0.7679019, 0.23872072, 0.03931138, 0.8551502, 0.19610135, 0.8555064, 0.08035298,
            0.05671094, 0.9091975, 0.27582648, 0.33816597, 0.42012835, 0.7745094, 0.14011143,
            0.47505257, 0.98297566, 0.5085966, 0.22395916, 0.01153891, 0.669607, 0.12918296,
            0.55476546, 0.528783, 0.5067741, 0.14234911, 0.5152856, 0.6446142, 0.9118427,
            0.8193508, 0.989135, 0.7842302, 0.59264964, 0.35247177, 0.48483032, 0.22649786,
            0.04158387, 0.5814206, 0.8653732, 0.4524277, 0.44947338, 0.5519129, 0.79122764,
            0.7513198,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(
        kernel23,
        Some(Array::from_shape_vec((2,), vec![0.9315116, 0.03313805]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            1.599818, 1.3630469, 1.6869354, 1.4339322, 2.1886687, 1.6968353, 2.366906, 1.7517122,
            1.3558831, 1.2025988, 1.7337592, 1.2398405, 1.6647048, 1.2976887, 2.7174041, 1.4436915,
            2.2005515, 1.6418779, 2.2145834, 1.1721294, 1.8104317, 1.7737653, 2.3385327, 1.8092825,
            2.446329, 2.3848236, 3.1071463, 2.143129, 2.010836, 1.1862769, 2.0237339, 1.3744855,
            1.9539835, 1.274761, 2.3787367, 1.5058299, 2.5353906, 1.4824007, 1.646235, 1.2163354,
            2.6324368, 2.2206035, 2.3156347, 2.0957944, 2.9408748, 2.308237, 2.4930212, 1.8098502,
            1.8609644, 1.2411308, 2.2706716, 1.7102373, 2.981763, 1.3863016, 2.5073996, 1.6156955,
            2.256914, 1.4178199, 1.545862, 1.0126613, 3.175349, 1.6558275, 2.353872, 1.3793973,
            2.6070213, 1.690876, 2.3161151, 1.4141324, 1.3099943, 1.0278367, 1.8043306, 1.4632659,
            2.2900786, 1.35166, 2.1892252, 1.3315947, 1.569746, 1.1995938, 1.4241614, 0.9353632,
            0.5535762, 0.88489234, 0.73052394, 0.8060012, 1.2438028, 1.5748283, 1.3051599,
            1.4807761, 0.8791573, 0.49708372, 0.5330484, 0.44973844, 0.8306546, 0.5224476,
            1.5317997, 0.6390454, 1.1798513, 1.0202926, 1.580785, 0.5456141, 0.86990774, 1.3399882,
            1.5821879, 1.3670284, 1.7456918, 1.9876904, 2.0991936, 2.2344656, 1.8767886,
            0.67227226, 0.6929862, 0.9070237, 1.7079444, 0.3736452, 1.1416826, 0.8098379,
            1.6050682, 0.8845675, 1.1567373, 0.4863702, 1.2468839, 1.9295014, 1.9469417, 1.6807268,
            2.0399172, 2.2550561, 2.0758781, 1.5881084, 1.4077327, 0.6015213, 0.8680553, 1.2513721,
            2.516064, 0.68844986, 1.6266716, 0.93441164, 1.4385552, 0.8739985, 1.2018152,
            0.14832309, 1.7934785, 1.9762006, 2.293531, 1.2441888, 1.852102, 1.7041295, 1.5852423,
            1.0313897, 0.8702159, 0.187279, 0.38192356, 0.668566, 1.048106, 0.53118414, 0.92207694,
            0.4887058, 0.5288415, 0.40271717, 0.5805019, 0.0384683,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.41213843, 0.45310238, 0.01799934, 0.4328227, 0.23842481, 0.20688592, 0.57869387,
            0.9324833, 0.43915927, 0.53123087, 0.5324186, 0.4149537, 0.22217223, 0.0080786,
            0.65063345, 0.7681623, 0.8421627, 0.27179125, 0.68530315, 0.9955617,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.77906156, 0.18006648, 0.5975193, 0.6555531, 0.9498266, 0.9690994, 0.5122471,
            0.3840358, 0.8757204, 0.7260429, 0.04691354, 0.40678895, 0.35535267, 0.19270384,
            0.23519029, 0.6665529, 0.26402712, 0.55168146, 0.08576613, 0.9567203, 0.57141143,
            0.20602623, 0.75538653, 0.96776, 0.44755465, 0.82362133, 0.29203537, 0.30861592,
            0.39762703, 0.26186082, 0.9658112, 0.27424002, 0.50570756, 0.8114843, 0.5536027,
            0.59788686, 0.05054026, 0.28394443, 0.6402348, 0.02258505, 0.60607, 0.6834324,
            0.8004999, 0.3349493, 0.4295082, 0.37033585, 0.0394791, 0.50698835, 0.29841292,
            0.9388161,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(
        kernel24,
        Some(Array::from_shape_vec((2,), vec![0.84357476, 0.29760668]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (2, 8, 10),
        vec![
            1.5857424, 1.3471406, 2.3711095, 1.4854848, 2.4258091, 1.713481, 2.5747633, 1.407519,
            1.7646412, 1.2377702, 2.0132241, 1.4761621, 2.7759576, 1.8716238, 2.7793486, 2.0009482,
            2.6189895, 1.6003491, 1.9120598, 1.3292332, 2.1558774, 2.0347986, 2.6053596, 2.0886478,
            2.328525, 1.4556053, 2.4378426, 1.7347448, 1.905889, 1.6032078, 1.9500391, 1.6929181,
            2.7435336, 1.6165985, 2.598805, 1.2381992, 3.1270077, 1.3618588, 1.8125294, 1.4589093,
            2.6542776, 2.089631, 3.6338058, 2.3670907, 3.731022, 2.1841466, 3.425086, 2.2727702,
            2.9202979, 2.135702, 2.5250301, 2.102888, 2.8744943, 1.8145466, 2.7484732, 1.4538202,
            2.9195812, 2.1261601, 2.090137, 1.7712107, 1.7953433, 1.9349298, 2.0149431, 1.5637734,
            1.5285316, 1.3913975, 1.6750431, 1.5224845, 1.8536223, 1.6650803, 1.8287017, 1.1318109,
            2.22426, 0.9875641, 2.256022, 1.0478239, 2.1452665, 1.1652058, 2.0484512, 0.9289602,
            1.2260079, 0.83563447, 1.4471152, 1.0910307, 1.3727473, 0.83003604, 1.3807074,
            0.91652477, 0.65402627, 0.66148627, 1.5656681, 1.0719028, 2.1560261, 1.1869996,
            1.9850225, 1.4765713, 2.0476944, 1.1075832, 1.1861339, 0.8085524, 1.5851712, 0.9330703,
            2.097888, 1.0810357, 1.6166922, 1.0299698, 1.6821581, 0.9374132, 1.188496, 0.9675777,
            1.483963, 1.3082473, 2.1340303, 1.526386, 1.9086506, 1.0925817, 2.1270955, 0.9927485,
            1.244982, 1.003521, 1.9467696, 1.2954186, 2.0781493, 1.1982459, 2.4224136, 1.0440644,
            3.0913692, 1.0509197, 1.6508508, 1.2685534, 2.1771343, 1.6138391, 2.106751, 1.3463727,
            1.9241216, 0.78603613, 2.2523797, 1.5741122, 1.7047573, 1.3234186, 1.4428424,
            1.0072366, 1.5090817, 0.9831238, 1.3087301, 0.57287025, 1.5471939, 0.81477475,
            0.93321645, 1.1291574, 1.4229301, 1.1304634, 1.4664145, 0.7654395, 1.292233, 0.8570013,
            1.5663084, 1.2075477, 1.3888971, 0.6310694,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.25654384, 0.71037215, 0.14646496, 0.9906275, 0.9552909, 0.7966291, 0.6094893,
            0.7271988, 0.09518696,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.3957746, 0.6157527, 0.31079137, 0.46793708, 0.8514491, 0.86081386, 0.8208274,
            0.2372746, 0.6977758, 0.79387194, 0.9463199, 0.99063903, 0.29514915, 0.8795419,
            0.741553, 0.03520088, 0.83411527, 0.47134155,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(
        kernel25,
        Some(Array::from_shape_vec((2,), vec![0.26704508, 0.2872401]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.48547912, 0.82029104, 0.8718908, 0.94707966, 0.39175254, 0.39312416, 0.93789804,
            1.7151065, 1.0238214, 1.4951298, 0.792324, 0.6168302, 1.1105139, 1.566807, 1.0804267,
            1.4621451, 0.94533414, 0.95279443, 0.8773905, 2.2196407, 0.94148594, 1.8511987,
            0.5146766, 0.8524968, 0.7859942, 1.1319852, 0.88621783, 0.9375694, 0.34809193,
            0.34898335, 0.41166142, 1.2892365, 0.43959087, 0.85259885, 0.28963053, 0.33346424,
            0.51288116, 0.68714666, 0.91204214, 0.85724765, 0.41606215, 0.3958516, 1.4386778,
            2.1728985, 1.7837832, 2.2059937, 1.1632746, 1.145447, 1.1585385, 1.3037963, 1.1274585,
            1.2307634, 0.9879087, 0.8779828, 1.6903095, 1.9688776, 1.7722254, 1.5615082, 1.0417979,
            0.75702035, 0.82331145, 0.9538408, 0.92684186, 0.8545909, 0.370961, 0.35782626,
            0.79562443, 0.6001158, 0.8938077, 0.6333498, 0.366637, 0.33210567,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.04289522, 0.583651, 0.94414073, 0.5729697, 0.72244126, 0.7707775, 0.02079507,
            0.22973806, 0.18128674,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.05054512, 0.6523751, 0.27093726, 0.32479268, 0.53774405, 0.08921466, 0.18494032,
            0.78120434, 0.15868789, 0.81183356, 0.21792394, 0.6620494, 0.6886836, 0.39724785,
            0.59319293, 0.02472531, 0.21891202, 0.5342134,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(
        kernel26,
        Some(Array::from_shape_vec((2,), vec![0.4041879, 0.53426075]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.42725453, 0.5975803, 0.71804273, 0.7629081, 0.91189396, 0.4884191, 0.811489,
            0.71069014, 1.3314413, 0.90611124, 1.6445909, 0.76284397, 0.7122989, 0.6899488,
            0.7926763, 0.7189832, 0.8186689, 0.47295254, 0.8653605, 0.64596605, 1.1184375,
            0.7327862, 1.1245896, 0.57561827, 0.41537032, 0.48066035, 0.52772814, 0.4835645,
            0.50167376, 0.4203613, 0.42043307, 0.44997564, 0.58366024, 0.47417176, 0.54580986,
            0.4329559, 0.55130076, 0.9616568, 0.76611483, 1.5306927, 0.9093186, 1.0943184,
            0.66851485, 1.5374432, 0.81946623, 1.973434, 0.9089154, 1.5489262, 0.7618717,
            1.3716757, 0.821249, 1.4936297, 0.84045047, 0.9914805, 0.6642224, 1.0584879,
            0.74247724, 1.2385288, 0.74249995, 1.0660412, 0.54252154, 0.70481306, 0.6255237,
            0.79538894, 0.6062765, 0.64179873, 0.53881305, 0.5510501, 0.5845532, 0.66147226,
            0.5739466, 0.63110656,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.20461221, 0.29362342, 0.7835011, 0.47930118, 0.2895624, 0.7320774, 0.55179524,
            0.37774232, 0.04187773,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.23883641, 0.63051957, 0.97746944, 0.6415133, 0.4162999, 0.04763152, 0.75958186,
            0.13098118, 0.6238241, 0.4102024, 0.5710282, 0.59153587, 0.66274744, 0.6454271,
            0.8120847, 0.22876394, 0.6206928, 0.19057496,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(
        kernel27,
        Some(Array::from_shape_vec((2,), vec![0.4622738, 0.9772445]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.5474539, 0.6603831, 0.5845092, 0.9788859, 0.78844523, 0.49959314, 0.7912829,
            1.3506072, 0.6833077, 1.6984615, 1.0264869, 1.6666241, 0.6618068, 0.6708618, 0.5828186,
            0.9457035, 0.7670376, 0.49714378, 0.87297094, 1.6108015, 0.73837495, 1.5782161,
            0.5845669, 0.95989555, 0.6919861, 0.73088336, 0.61952794, 0.50713134, 0.4797075,
            0.4642685, 0.5345486, 1.0934232, 0.51175094, 0.7297281, 0.467759, 0.48839813,
            1.1093068, 1.3380051, 1.166757, 1.7349548, 1.4829373, 1.6135137, 1.3779403, 1.4857119,
            1.3248427, 1.684025, 1.8815948, 1.5596102, 1.2865984, 1.5583844, 1.1641359, 1.697576,
            1.4497471, 1.5717533, 1.589834, 1.6161863, 1.3726753, 1.4405272, 1.455553, 1.1415323,
            1.3333881, 1.6756967, 1.2210497, 1.3117576, 1.0042735, 1.0112528, 1.3197398, 1.1688167,
            1.2117064, 1.0588129, 1.0032377, 0.9852253,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.17967562, 0.27354005, 0.48198408, 0.09082693, 0.6217685, 0.0965838, 0.8904992,
            0.5337058, 0.17222154,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.62424076, 0.95776683, 0.998361, 0.150883, 0.28713444, 0.35105017, 0.1765902,
            0.9674033, 0.65025777, 0.1959308, 0.3119046, 0.55247456, 0.38556734, 0.18145509,
            0.94255227, 0.7036003, 0.3402552, 0.16401337, 0.28418577, 0.5504918, 0.6148071,
            0.7740251, 0.37459207, 0.25677747, 0.80441076, 0.17314304, 0.5946227, 0.30094627,
            0.06480476, 0.5798754, 0.62549657, 0.6065069, 0.9259787, 0.3677915, 0.69532603,
            0.8356569, 0.39276573, 0.18570696, 0.61698794, 0.9064707, 0.01547038, 0.2551995,
            0.11438051, 0.03861368, 0.6524532, 0.36442748, 0.08230381, 0.79969245, 0.27816203,
            0.3741886,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(
        kernel28,
        Some(Array::from_shape_vec((2,), vec![0.44356522, 0.27386904]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.076972, 1.2365056, 1.5758406, 0.9458034, 1.162185, 0.54559654, 0.97163546, 0.756559,
            1.579666, 1.1066645, 0.88845766, 0.6433426, 2.1301975, 1.7069479, 2.2383907, 1.2985303,
            1.7926246, 0.6108388, 1.944768, 1.3542382, 1.4147428, 1.030585, 1.0728618, 0.5830014,
            1.3696687, 1.4045963, 1.9077556, 0.8699713, 1.5493506, 0.49961624, 0.9651345,
            0.87822855, 1.1424878, 0.6538361, 0.7656125, 0.49250814, 0.6708106, 0.8677676,
            1.1468214, 0.72967124, 1.0009477, 0.5775065, 0.77167004, 0.7611265, 1.1291547,
            0.69469345, 1.029237, 0.32800293, 1.414092, 1.021672, 1.7208216, 0.9481785, 1.7045271,
            0.4786905, 1.4522913, 1.0872655, 1.6268532, 0.62327194, 1.2211642, 0.34094012,
            1.184459, 1.1093562, 1.8905193, 0.8517034, 1.0995364, 0.4069936, 0.3839814, 0.44445592,
            0.9185879, 0.33842823, 0.64178586, 0.28051916,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.4171807, 0.14990133, 0.4750283, 0.6358263, 0.77572674, 0.7072159, 0.34310365,
            0.36999545, 0.8200852,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.46510443, 0.9230857, 0.86201537, 0.04691705, 0.12260284, 0.89921826, 0.47400048,
            0.7492544, 0.05440097, 0.28273952, 0.9184355, 0.9064988, 0.7027802, 0.19125043,
            0.8670149, 0.08634489, 0.722654, 0.77540857, 0.00211577, 0.6443405, 0.2344423,
            0.9849179, 0.9893316, 0.87634915, 0.48734385, 0.8760625, 0.53053117, 0.01152504,
            0.6788874, 0.76156837, 0.4680538, 0.07214947, 0.549209, 0.8383253, 0.00365476,
            0.9782156, 0.7419056, 0.40790308, 0.00302504, 0.80174476, 0.7689671, 0.50054824,
            0.16478458, 0.89107823, 0.7763043, 0.73042727, 0.41667554, 0.7348974, 0.71259016,
            0.93557405,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(
        kernel29,
        Some(Array::from_shape_vec((2,), vec![0.37013116, 0.14954911]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.7098781, 1.3316959, 2.3490353, 1.5186281, 1.5386757, 0.494161, 1.8805032, 0.88162506,
            2.19312, 1.0911504, 1.5842729, 0.40960944, 2.4451528, 2.0658, 3.3215115, 2.5331776,
            2.835018, 0.9601531, 1.5199149, 1.1261016, 2.5540547, 1.2916937, 2.1374094, 0.4162409,
            1.7619807, 2.0923834, 2.9239464, 2.5606563, 2.344979, 1.1467409, 0.6681239, 0.6382358,
            0.9489145, 0.9635519, 1.2444353, 0.3718663, 1.1532673, 1.1052254, 2.1225777, 1.40426,
            1.0624169, 0.6311061, 1.0458466, 1.1853201, 1.6227659, 1.2222341, 0.73543996,
            1.1657135, 1.9119031, 1.5159506, 3.4989963, 1.6676002, 1.8405286, 1.0469345, 1.2124453,
            1.4187361, 1.9031, 1.5641233, 1.3200378, 1.4672321, 1.6853164, 1.2013986, 3.0592852,
            1.6065491, 2.026187, 0.655985, 0.4906016, 0.6404819, 1.1074901, 0.88973624, 0.57191557,
            0.8803092,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.33766475, 0.39673004, 0.03940821, 0.2414454, 0.9373305, 0.84819096, 0.9272432,
            0.8604789, 0.92845494,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.8023847, 0.06647868, 0.12827316, 0.02774826, 0.8982795, 0.1193029, 0.37523487,
            0.28379655, 0.0638791, 0.08446726, 0.68760884, 0.2630593, 0.01052708, 0.45302406,
            0.10402057, 0.5539082, 0.39986408, 0.53770447, 0.24856173, 0.12796782, 0.80071914,
            0.38390577, 0.6908975, 0.5850918, 0.71101063, 0.17578217, 0.55867785, 0.71616316,
            0.3247584, 0.9196999, 0.46712968, 0.08430128, 0.83232373, 0.49657014, 0.24024557,
            0.60874844, 0.47418702, 0.9770886, 0.99522823, 0.7749884, 0.7253688, 0.26021662,
            0.8869578, 0.5181486, 0.5871326, 0.76900613, 0.5745777, 0.81429285, 0.78002185,
            0.7069771,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(
        kernel30,
        Some(Array::from_shape_vec((2,), vec![0.33134556, 0.7407027]).unwrap()),
        2,
        Padding::Same,
    );
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.3907659, 0.6576915, 1.4154387, 0.6038364, 1.3238134, 0.37273425, 0.91300905,
            0.9410566, 0.99730486, 0.823862, 0.7231916, 0.39532262, 2.3387403, 1.1201043,
            3.1835678, 1.3119551, 1.6391289, 0.76441693, 1.3461729, 1.1482775, 1.7693596,
            1.3068464, 1.2435443, 0.6014823, 1.8501322, 1.4788804, 2.5737026, 1.8394518, 1.6830919,
            1.2482276, 1.3065547, 0.9058973, 1.426965, 0.91648346, 0.94069356, 0.5621239,
            1.6498201, 1.8669577, 2.4564548, 1.932498, 2.556175, 1.05538, 1.9667883, 1.2178117,
            2.5538087, 1.4934764, 1.9397483, 1.1823083, 2.9425745, 2.6986647, 4.5843253, 3.2060177,
            4.064757, 1.917109, 2.8084865, 1.642697, 3.7017589, 1.9526505, 3.0228508, 1.6412346,
            3.0879366, 2.7984512, 4.451487, 3.2558267, 3.6680937, 2.3263347, 2.1872928, 1.4450634,
            2.721798, 1.428158, 2.0694182, 1.2217803,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );
}
