// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array2, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_transpose_stride1_valid_bias() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(
        kernel1,
        Some(Array::from_shape_vec((1,), vec![0.14352316]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.3485275, 1.093564, 1.3289816, 1.1265688, 1.1620376, 0.2865959, 0.91592366, 2.2728443,
            3.75373, 3.6355407, 2.4194517, 0.99245495, 1.4025929, 3.1045563, 4.7545576, 5.199625,
            3.306072, 1.2476263, 1.573493, 3.7987893, 4.753667, 5.066922, 2.4152188, 1.1487284,
            2.0268407, 3.0122, 5.330374, 3.8929133, 2.6810534, 0.96918124, 2.0620933, 2.7327435,
            3.701478, 3.060283, 1.7144849, 0.6545492, 0.8265263, 1.2497814, 1.7765949, 1.4346833,
            0.80992717, 0.4030824,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.8997107, 0.64410555, 0.04471071, 0.767672, 0.43464628, 0.16569944, 0.18875164,
            0.12285258, 0.2781115, 0.5390728, 0.5066572, 0.97435564, 0.39133722, 0.7964828,
            0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183, 0.81628793,
            0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133, 0.0067116,
            0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715, 0.7567798,
            0.23972042, 0.38848338, 0.00744711, 0.8715701, 0.07988323,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.6283005, 0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194, 0.34163022,
            0.03235205, 0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297, 0.97700953,
            0.18019113, 0.775954, 0.14120784, 0.3426181,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(
        kernel2,
        Some(Array::from_shape_vec((1,), vec![0.5417864]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            1.5914972, 3.01043, 2.584458, 2.3364258, 2.1194246, 0.8680956, 2.6502557, 4.4261913,
            4.4449716, 4.1786127, 1.9854674, 1.2080836, 3.1033394, 4.893525, 5.3289795, 4.791672,
            2.3636212, 1.3605901, 2.4304364, 3.9498923, 5.1606207, 4.5350504, 2.5437014, 1.3598186,
            1.7223351, 2.8644495, 4.5496287, 5.5903716, 2.9153159, 1.335069, 1.1133897, 1.6553848,
            3.1637242, 3.1760325, 2.0061834, 1.2707132, 0.84581697, 0.7859877, 1.6673865,
            1.1895015, 1.103899, 0.79147315,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.7768226, 0.34603763, 0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802,
            0.629322, 0.60627973, 0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678,
            0.89887625, 0.6572328, 0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983,
            0.6908677, 0.5511301, 0.36253917, 0.36786652, 0.88718724, 0.69587743, 0.4870034,
            0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529, 0.5566727, 0.7035832,
            0.92333794, 0.85647196, 0.36252776, 0.9373231, 0.01684272,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754, 0.31284246, 0.4031665,
            0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259, 0.23846498, 0.82509995,
            0.97324103, 0.96826524, 0.77620417, 0.8427075,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(
        kernel3,
        Some(Array::from_shape_vec((1,), vec![0.42989048]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.8415039, 1.8526291, 2.0393243, 2.0750802, 1.8742993, 0.79676867, 1.4154179,
            3.0516624, 4.379607, 4.7501454, 3.4499035, 1.3335629, 2.0694191, 5.020159, 6.7702,
            6.723853, 5.5876184, 2.4787986, 1.8382615, 4.409551, 6.5021152, 7.57589, 5.6318374,
            2.584788, 2.0872204, 4.831626, 6.155262, 7.060836, 5.256997, 3.1070573, 1.7176483,
            3.0740163, 4.6250186, 5.567507, 4.6789284, 2.034438, 1.5396183, 2.104996, 3.3111022,
            2.416727, 2.212655, 1.1765792,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.76771307, 0.54514444, 0.7878393, 0.21897991, 0.975659, 0.73295325, 0.69994044,
            0.86701024, 0.76087946, 0.623545, 0.14890751, 0.8610666, 0.21943341, 0.1644093,
            0.6089244, 0.8612485, 0.02602104, 0.30423534, 0.5087405, 0.16869895, 0.3329467,
            0.179494, 0.33126613, 0.11996287, 0.21606164, 0.87119263, 0.33579683, 0.2313126,
            0.2576527, 0.3748985, 0.30113342, 0.8142977, 0.423247, 0.8179498, 0.92175007,
            0.21606776, 0.19149332, 0.4240341, 0.14780204, 0.46443272,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.00207204, 0.359202, 0.9019851, 0.21363449, 0.6390296, 0.5977058, 0.81350476,
            0.3685356, 0.90738845, 0.7828945, 0.9812083, 0.6726924, 0.46724817, 0.17302093,
            0.39839587, 0.78055173, 0.8576361, 0.7335981, 0.52934057, 0.9529279, 0.78965247,
            0.46750203, 0.08403921, 0.73126566, 0.34934825, 0.3459232, 0.54770446, 0.68714255,
            0.29283327, 0.53392637, 0.8850151, 0.6909357, 0.44388366, 0.9043074, 0.9949724,
            0.64743847, 0.36691284, 0.5396585, 0.5372604, 0.47547424, 0.44373918, 0.34716287,
            0.21774843, 0.9437953, 0.51856595, 0.15765554, 0.9350713, 0.86233217, 0.81734437,
            0.6566154,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(
        kernel4,
        Some(Array::from_shape_vec((1,), vec![0.3879487]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.5047134, 0.90928984, 1.719548, 1.7708876, 2.3079412, 1.3774123, 1.1501839, 0.5919347,
            1.2182404, 2.4989035, 4.0367756, 4.8216786, 5.1263866, 4.2640953, 2.5210605, 1.3562958,
            2.221877, 4.3751593, 6.1127706, 6.8170853, 7.4482455, 6.028275, 3.517996, 2.426178,
            3.0618155, 5.781344, 7.437309, 9.819859, 10.352055, 7.2691493, 5.3148503, 3.2642815,
            3.3895216, 6.4029965, 8.314576, 11.478379, 11.642733, 9.431056, 6.3930106, 3.464615,
            2.5750437, 4.8616977, 6.9541187, 9.945222, 9.60607, 7.333007, 5.262796, 3.1255457,
            1.538002, 3.0233095, 4.114229, 6.4558897, 6.7533927, 5.253201, 4.202661, 2.4442291,
            0.73323596, 1.6595087, 3.1708324, 4.8096538, 4.3786483, 3.5833194, 3.1013806,
            1.2322948, 0.43868625, 0.886265, 1.5190291, 1.5371954, 1.7751887, 1.6801622, 1.1656907,
            0.751837,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.28848994, 0.5814131, 0.06870039, 0.78543746, 0.47194287, 0.12733267, 0.6111727,
            0.25675833, 0.74741316, 0.45714313, 0.9649919, 0.57969916, 0.5208711, 0.93666834,
            0.13247305, 0.7087714, 0.17877895, 0.40767, 0.6906785, 0.9675369, 0.224454, 0.28950995,
            0.75431514, 0.99582964, 0.8120864, 0.9536324, 0.7703749, 0.683158, 0.16371861,
            0.42877796, 0.7300311, 0.9456737, 0.05700503, 0.19623296, 0.44457257, 0.5512328,
            0.15101007, 0.25140873, 0.2031063, 0.5537751,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.3641559, 0.701937, 0.27669305, 0.85076064, 0.00186597, 0.3316532, 0.15485734,
            0.35000807, 0.42372492, 0.03995521, 0.5067197, 0.38907993, 0.37287286, 0.21294773,
            0.8646356, 0.10154326, 0.75313085, 0.7910046, 0.15368015, 0.25977603, 0.40315583,
            0.635939, 0.25689796, 0.13678746, 0.43744904, 0.6658951, 0.564682, 0.70429957,
            0.67241764, 0.15790685, 0.25059524, 0.6432024, 0.60438925, 0.45131883, 0.96080875,
            0.40131757, 0.60942906, 0.7035094, 0.6473561, 0.05433872, 0.7478619, 0.24740443,
            0.35665986, 0.00020906, 0.23741227, 0.57013196, 0.6398819, 0.7132858, 0.90739846,
            0.8246988,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(
        kernel5,
        Some(Array::from_shape_vec((1,), vec![0.1319153]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.38643342, 0.86567044, 1.4687302, 2.316364, 2.521139, 1.6630657, 1.5889877, 0.2906292,
            0.99646616, 2.0575695, 2.9225738, 4.806671, 4.134577, 3.4206235, 2.4422543, 1.2284539,
            1.1093969, 2.7374527, 4.545073, 7.1819606, 7.0422697, 6.384361, 3.472088, 1.6821977,
            1.4106641, 3.1557145, 6.024588, 7.964457, 8.042324, 5.6777563, 3.973497, 1.8516392,
            1.8285675, 3.939004, 6.2409325, 9.310606, 9.845416, 7.495718, 5.996457, 2.7254672,
            1.3674598, 3.6310072, 5.5756636, 7.9975805, 8.258152, 6.578929, 3.7320182, 2.3962524,
            0.7732972, 2.2580583, 4.259518, 5.8143234, 5.5409513, 4.766061, 3.51525, 2.3470497,
            0.5054964, 1.3905556, 2.121021, 3.1266851, 3.497022, 2.9348984, 1.5300915, 1.2793837,
            0.29008675, 0.64992714, 1.0999302, 1.8524387, 1.9105036, 1.4399192, 1.236395,
            1.0118611,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6876462, 0.846729, 0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465,
            0.05539654, 0.5554673, 0.9149804, 0.9791666, 0.9000323, 0.6329186, 0.30872977,
            0.30553624, 0.04431259, 0.5287215, 0.3358437, 0.72178566, 0.72704846, 0.85191244,
            0.07464863, 0.867838, 0.5849202, 0.14913943, 0.18325551, 0.40498126, 0.75359416,
            0.01821492, 0.5917236, 0.91982275, 0.5287654, 0.7151285, 0.38420153, 0.517026,
            0.5150141, 0.26934662, 0.7356045, 0.97902703, 0.6362754,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.27803296, 0.32063982, 0.83432084, 0.78711736, 0.28247103, 0.7812688, 0.5270146,
            0.4719829, 0.47535485, 0.23715672, 0.4404677, 0.90286416, 0.66611385, 0.02649495,
            0.3193976, 0.16608049, 0.5121102, 0.17436478, 0.313714, 0.47244504, 0.9906781,
            0.9064671, 0.29454133, 0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972,
            0.53866875, 0.6358971, 0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548,
            0.14977625, 0.53714937, 0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625,
            0.4744624, 0.73655206, 0.42605233, 0.6592577, 0.3237799, 0.42867732, 0.87574345,
            0.70010746,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(
        kernel6,
        Some(Array::from_shape_vec((1,), vec![0.01496939]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.3564641, 0.62308353, 1.4912512, 2.311902, 2.4169126, 1.95007, 1.643582, 0.64187735,
            1.4917955, 2.1304188, 3.523224, 4.2971234, 4.321405, 2.8834844, 1.7376547, 0.88931996,
            1.1635435, 2.850916, 4.5758953, 6.499373, 6.8871884, 5.5835495, 3.3216085, 1.5838089,
            1.596263, 3.9048858, 6.7641497, 8.9234705, 8.30044, 5.1186976, 3.8165264, 2.0088565,
            3.003115, 5.282759, 8.340484, 11.381234, 10.779814, 8.081835, 6.53357, 2.3575683,
            1.7965136, 4.339559, 7.211056, 9.158911, 7.913366, 6.1600766, 4.2456937, 1.9749019,
            1.3346388, 3.7718482, 5.5128183, 7.2840023, 7.1165247, 5.5267043, 4.2085776, 1.4748956,
            1.3440105, 2.2810059, 3.0923104, 4.625933, 4.1684227, 3.1609333, 2.3650696, 0.9956575,
            0.71633106, 1.3991129, 2.189256, 3.3012414, 2.744817, 2.6331675, 2.0700526, 0.5514221,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.78416556, 0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122,
            0.68573385, 0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448,
            0.48578474, 0.2764571, 0.9192946, 0.8920509, 0.34320405, 0.4283556, 0.3897719,
            0.06360459, 0.729173, 0.19460331, 0.8634254, 0.6576018, 0.9657459, 0.22873744,
            0.47843248, 0.22157177, 0.9162307, 0.02157675, 0.44649428, 0.2792192, 0.685827,
            0.75294507, 0.7919586, 0.22560763, 0.88778716, 0.80092114,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.00003577, 0.9737877, 0.9146247, 0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025,
            0.0330946, 0.17754778, 0.41998118, 0.02919354, 0.82382417, 0.4156855, 0.49590722,
            0.69720376, 0.7155315, 0.40795937, 0.15397236, 0.02265206, 0.7090415, 0.75877124,
            0.67035425, 0.39483562, 0.86222315, 0.9993058, 0.84902793, 0.26427644, 0.86764544,
            0.24274233, 0.69865257, 0.5739991,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(
        kernel7,
        Some(Array::from_shape_vec((1,), vec![0.7620597]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            1.0409818, 1.7302146, 2.683083, 2.843504, 2.8466096, 1.797049, 0.895688, 2.2098274,
            2.4816945, 4.377497, 4.8112006, 3.589392, 2.6952052, 1.4238925, 2.1151729, 3.750952,
            6.5196557, 6.7327304, 5.318257, 3.1517103, 1.3638465, 3.4445424, 4.963204, 8.772989,
            9.596617, 6.869471, 4.570537, 1.9513092, 3.0075817, 5.247328, 8.889782, 9.273651,
            7.1039395, 4.374734, 1.9117367, 3.1217976, 4.1835675, 6.470391, 7.68963, 6.300781,
            4.2148895, 1.9006319, 2.0309775, 2.8338645, 4.688351, 5.3358984, 4.187318, 3.2621052,
            1.6111662, 2.206536, 2.2670796, 3.2498498, 3.8635483, 2.6764305, 2.2829223, 1.5204389,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.29289714, 0.88402116, 0.8942853, 0.7757528, 0.16431308, 0.48939565, 0.56055367,
            0.46453193, 0.9573795, 0.8899508, 0.16098963, 0.63514715, 0.810474, 0.29953358,
            0.46075395, 0.02808736, 0.59781086, 0.8855644, 0.61877847, 0.9537467, 0.6197168,
            0.3379795, 0.13108306, 0.30692965, 0.33537498, 0.01351478, 0.45529485, 0.6626128,
            0.9497022, 0.7403127, 0.06039312, 0.08292098, 0.80679554, 0.1354166, 0.2560622,
            0.80891573, 0.97702754, 0.4124968, 0.4359102, 0.8733311,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.1396195, 0.52047473, 0.88564533, 0.29781443, 0.21130918, 0.83071965, 0.3337948,
            0.9783562, 0.42070097, 0.55396014, 0.16172563, 0.7634967, 0.36205766, 0.48491392,
            0.4980414, 0.6001484, 0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525,
            0.7446416, 0.471613, 0.72900707, 0.842964, 0.21457537, 0.938401, 0.41665936,
            0.05351101, 0.43856344, 0.7253113, 0.8520324,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(
        kernel8,
        Some(Array::from_shape_vec((1,), vec![0.4151233]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.85961473, 1.1399022, 1.5416255, 2.3138058, 2.0939152, 1.4395165, 0.72897273,
            1.2569395, 1.8868984, 2.9130578, 4.409775, 3.9448526, 2.5674746, 1.7149774, 2.1390963,
            3.3238611, 4.993279, 6.183703, 4.739505, 3.5502832, 2.2843509, 2.5724027, 4.730991,
            6.546122, 8.377346, 6.540378, 3.7648895, 2.6814415, 3.2880697, 5.0715585, 5.974295,
            9.418804, 6.370424, 4.4563785, 2.9148374, 2.8090472, 4.2897153, 6.1040854, 8.838768,
            5.859242, 3.815173, 2.7952125, 1.8268328, 2.5387464, 4.0094905, 5.193087, 3.5667071,
            3.1383631, 2.2132664, 0.68384707, 1.4761972, 2.2791948, 3.2298665, 2.7678978, 2.266334,
            1.7316194,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.35101932, 0.7388761, 0.3592986, 0.6741479, 0.9965808, 0.3117034, 0.8605703,
            0.94308543, 0.8192489, 0.31478795, 0.750324, 0.36604244, 0.78454614, 0.039194,
            0.23696694, 0.2418382, 0.24788351, 0.5622223, 0.15428482, 0.50688076, 0.37682602,
            0.44385925, 0.00051633, 0.53422695, 0.5675659, 0.53845215, 0.2130759, 0.86445093,
            0.432881, 0.6255918, 0.3942565, 0.07226853, 0.09869356, 0.32627374, 0.8543963,
            0.85603166, 0.25422713, 0.24929269, 0.36793318, 0.39957172,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.9079535, 0.865758, 0.82237726, 0.60374194, 0.7658025, 0.0215734, 0.473204, 0.6594781,
            0.86392707, 0.8566667, 0.48541847, 0.54855824, 0.5860555, 0.158874, 0.10558709,
            0.19664533, 0.39609066, 0.27843866, 0.49128443, 0.75033015, 0.35650545, 0.4687038,
            0.6159849, 0.2547001, 0.17250927, 0.07203952, 0.8724657, 0.14018923, 0.12091745,
            0.4770398, 0.43290496, 0.6356798,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(
        kernel9,
        Some(Array::from_shape_vec((1,), vec![0.7619444]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            1.2299109, 2.017439, 2.32545, 3.217216, 2.5692067, 1.7961167, 1.5698023, 2.294753,
            3.1873264, 4.043424, 5.9786363, 4.2593255, 3.5268135, 2.5606017, 3.0110297, 3.8862925,
            6.222372, 7.6714315, 5.13427, 4.438364, 2.323987, 3.50524, 4.2971544, 6.608395,
            8.255323, 5.647247, 5.0658684, 2.9207516, 3.1588278, 3.655817, 5.998303, 8.1266575,
            5.736241, 4.2460256, 2.6911929, 2.269692, 2.7720122, 3.4000196, 4.7561026, 3.692728,
            3.0255141, 1.5685811, 1.4916756, 1.7554835, 2.3300576, 3.1423569, 3.021008, 2.4786572,
            1.687732, 0.9379584, 1.2822404, 1.241328, 1.6849861, 1.4776855, 1.2526681, 1.1156198,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513, 0.06810815, 0.79673207,
            0.29373887, 0.55241185, 0.23906927, 0.18915932, 0.02753429, 0.1438574, 0.5419741,
            0.71984386, 0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286,
            0.21388301, 0.30016333, 0.49605927,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258, 0.26911622, 0.92149794,
            0.7165893, 0.04745785, 0.55642486, 0.34654748, 0.83168656, 0.8410765, 0.7668131,
            0.84094906, 0.6012723, 0.9256995, 0.66010624,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(
        kernel10,
        Some(Array::from_shape_vec((1,), vec![0.43380973]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.7103783, 1.6804304, 2.1464853, 2.0116394, 1.3718905, 1.2773498, 2.1563692, 3.2300735,
            2.564534, 1.338716, 1.7648466, 4.0217, 5.4066486, 3.897053, 1.9723688, 1.7932849,
            3.2972913, 3.929743, 3.1267467, 1.640777, 1.478095, 2.4876475, 3.4420063, 2.701345,
            1.2997723, 0.78271353, 1.1579055, 1.323391, 1.1198591, 0.76256824,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.62281454, 0.45852852, 0.61445725, 0.524579, 0.06486581, 0.14233574, 0.13930365,
            0.5838787, 0.45914945, 0.30819193, 0.70949817, 0.8803759, 0.6927248, 0.50569826,
            0.7358748, 0.58652496, 0.85065925, 0.3247378, 0.6760192, 0.4483504, 0.59195757,
            0.37883574, 0.7796499, 0.32748002,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.44507304, 0.7488422, 0.14428215, 0.8785777, 0.15468395, 0.6638725, 0.30651525,
            0.9492515, 0.55669755, 0.08302987, 0.45890567, 0.05946975, 0.9099885, 0.30235246,
            0.24214035, 0.42138377, 0.38782486, 0.21880285,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(
        kernel11,
        Some(Array::from_shape_vec((1,), vec![0.9182205]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            1.2529353, 1.9485724, 1.959289, 1.8122804, 1.050638, 2.3779583, 2.848526, 3.572566,
            1.9781737, 1.5441754, 2.51377, 3.9329245, 4.681176, 3.2484288, 1.6958745, 2.2323456,
            3.9540534, 4.7097607, 3.1059778, 1.6631632, 1.8612895, 3.175563, 3.9752824, 2.9017842,
            1.9671034, 1.1723213, 1.903698, 2.5563838, 2.446489, 1.4799771,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.85290706, 0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431, 0.2624427, 0.6557088,
            0.00633, 0.6603214, 0.45500925, 0.6523986, 0.14666249, 0.32440838, 0.2805719,
            0.42671442, 0.74477625, 0.9118973, 0.5335283, 0.36968935, 0.5693756, 0.36426732,
            0.11819325, 0.95361024,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.13343851, 0.5940242, 0.7282295, 0.9320007, 0.46956548, 0.5087874, 0.7952918,
            0.73709416, 0.3358689, 0.03185032, 0.27057356, 0.26166973, 0.5843129, 0.5337139,
            0.19571388, 0.1192536, 0.75616854, 0.97167397,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(
        kernel12,
        Some(Array::from_shape_vec((1,), vec![0.71154076]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.83002263, 1.3358613, 1.8392842, 1.5547636, 1.1688976, 1.7014953, 2.4927258,
            3.4682574, 2.4118567, 1.4344661, 2.3775015, 3.815222, 4.900132, 3.5516386, 1.6059039,
            1.9891958, 3.8884637, 4.7061706, 4.1969404, 2.5112157, 1.8121505, 2.871599, 4.00314,
            2.796134, 1.7854812, 1.2801292, 1.8496673, 2.3445985, 2.1811788, 1.8572595,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.26672947, 0.07128377, 0.3383284, 0.8008563, 0.9504947, 0.5971434, 0.7847773,
            0.92326206, 0.24163638, 0.12968542, 0.5954836, 0.6734995, 0.08627631, 0.7485715,
            0.8782484, 0.6863155, 0.7264353, 0.08944888, 0.68172634, 0.4284322, 0.48237634,
            0.6856524, 0.04009921, 0.0687674,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.9063645, 0.42620143, 0.61030614, 0.10040135, 0.50107217, 0.763057, 0.25769317,
            0.8816114, 0.7770131, 0.23345616, 0.62762326, 0.15315741, 0.73589575, 0.2752067,
            0.85641515, 0.7439484, 0.6581306, 0.4056261, 0.13899311, 0.26460668, 0.9179794,
            0.96651816, 0.89336777, 0.18948041, 0.9371178, 0.7124811, 0.9657549, 0.6203675,
            0.32684848, 0.11439406, 0.07654371, 0.95680344, 0.9728639, 0.6055871, 0.00439729,
            0.8525613, 0.3167563, 0.13499211, 0.68338645, 0.7955047, 0.21689218, 0.2826704,
            0.12328367, 0.6890043, 0.5906649, 0.41700745, 0.30266365, 0.5716598, 0.12726787,
            0.35587692,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(
        kernel13,
        Some(Array::from_shape_vec((1,), vec![0.16889893]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.47212327, 0.9638533, 2.0709107, 1.7241415, 1.3155663, 0.61127216, 0.43889225,
            1.5938871, 2.8150792, 4.1741357, 3.8233647, 3.1255457, 1.6321304, 0.56119007,
            2.2705038, 4.6988673, 6.6340213, 5.3065505, 4.497263, 2.955539, 1.4733576, 2.7308748,
            5.0176997, 6.1778407, 6.2203627, 6.018361, 3.98979, 1.7636042, 2.4195788, 4.843926,
            6.134727, 5.7206798, 6.0509744, 3.7350185, 1.757552, 2.5879161, 4.4600735, 5.189421,
            4.650937, 4.5648227, 3.0802097, 1.7406869, 1.4187852, 2.8907988, 3.7610395, 3.0532537,
            2.6993992, 1.6159967, 0.78583825, 0.5738696, 1.0651276, 1.9113331, 1.5074053,
            1.2933675, 0.87757444, 0.82452005,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.3114892, 0.1309899, 0.24026695, 0.55435276, 0.34375766, 0.4225387, 0.37165096,
            0.6202945, 0.6069533, 0.05756181, 0.0153275, 0.8497578, 0.79796964, 0.4071996,
            0.19325097, 0.04944435, 0.59729165, 0.39304134, 0.679002, 0.6126854, 0.67232877,
            0.7156292, 0.09058711, 0.33372015,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.8941644, 0.30899736, 0.3348802, 0.6412177, 0.26750943, 0.03709449, 0.56803024,
            0.8756273, 0.5771133, 0.56024176, 0.5868575, 0.75167763, 0.36936092, 0.37185487,
            0.35425207, 0.24336162, 0.01027582, 0.2671537, 0.83992416, 0.49819484, 0.7831867,
            0.70054483, 0.8701863, 0.49413827, 0.84670645, 0.8069649, 0.093459, 0.93408287,
            0.8206956, 0.70209366, 0.32817394, 0.744203, 0.39091238, 0.43911496, 0.92919487,
            0.29325068, 0.62813336, 0.8131431, 0.19520658, 0.47931832, 0.42483747, 0.47526902,
            0.28184402, 0.09741595, 0.45691565, 0.44086096, 0.9638409, 0.33859608, 0.26381832,
            0.29839757,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(
        kernel14,
        Some(Array::from_shape_vec((1,), vec![0.68755937]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            1.6100154, 1.3041084, 1.9865575, 2.058709, 2.0102882, 1.3211563, 0.88751334, 1.4965692,
            2.562121, 2.810881, 3.0082724, 3.5461302, 2.4676533, 1.3907197, 2.021402, 3.4070258,
            5.3854465, 4.8752565, 5.203265, 3.7573037, 2.1016426, 2.3077712, 3.2115028, 5.9452715,
            5.812087, 5.874607, 4.2502155, 2.6600218, 2.0934312, 4.168728, 5.346838, 5.584136,
            5.7040367, 3.5271058, 2.6621888, 1.7660695, 2.9222274, 4.7971134, 4.2820015, 4.399644,
            3.0635798, 2.2331734, 1.5960114, 2.7412057, 3.6465688, 3.1858065, 3.1272411, 2.6681504,
            1.9779189, 1.048134, 1.4695773, 1.8906505, 1.8657557, 1.8337557, 1.2355075, 1.5066361,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.09156765, 0.58584654, 0.04617033, 0.14705709, 0.81179595, 0.16751295, 0.06864621,
            0.6308731, 0.38993102, 0.3644169, 0.68174505, 0.272409, 0.23609333, 0.21866773,
            0.80119157, 0.01742986, 0.49270406, 0.37920174, 0.90869635, 0.8191268, 0.7636344,
            0.7827788, 0.9694966, 0.79533535,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.00732174, 0.8372113, 0.9449071, 0.7670253, 0.50964797, 0.7843069, 0.7365313,
            0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833, 0.5585159,
            0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028, 0.52249014,
            0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726, 0.25884646,
            0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234, 0.32747796,
            0.9097073, 0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446, 0.9843364,
            0.4038572, 0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686, 0.5288406,
            0.92906404,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(
        kernel15,
        Some(Array::from_shape_vec((1,), vec![0.87780553]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            1.0399482, 1.278852, 2.2221718, 2.3640099, 1.8848557, 1.9303548, 1.1915264, 1.1289791,
            2.256639, 3.7285123, 3.7471666, 3.3807535, 2.7588384, 1.4069664, 1.8575859, 3.8268034,
            5.8882165, 5.682065, 4.858097, 4.291579, 2.1616776, 2.2354953, 5.6792955, 8.054387,
            7.738584, 6.772793, 5.8181224, 2.8061655, 2.8297079, 5.928639, 7.828898, 7.0889177,
            6.2229495, 5.575576, 3.198449, 1.9431419, 5.010884, 6.1674604, 5.3640285, 5.1650834,
            4.840734, 2.6776564, 1.8417511, 4.056324, 4.8596573, 5.048859, 4.9922953, 4.0908275,
            2.3739777, 1.6022619, 2.8571877, 3.1394484, 2.7451384, 2.6529539, 2.4183912, 1.6674441,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.9090181, 0.82569945, 0.20383635, 0.7166643, 0.17061436, 0.91526777, 0.08598401,
            0.70100874, 0.40537685, 0.5971982, 0.92796123, 0.15859716, 0.7859081, 0.8564488,
            0.35816404, 0.79062706, 0.9644883, 0.13154314, 0.31929043, 0.80048305, 0.07180241,
            0.52815664, 0.45786336, 0.91537887,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.9783313, 0.25753945, 0.42799363, 0.07738555, 0.9294206, 0.07022415, 0.60058224,
            0.6196278, 0.9008346, 0.04155485, 0.82207745, 0.41282526, 0.9949608, 0.3109271,
            0.47614527, 0.7615821, 0.35893062, 0.07713356, 0.6123928, 0.62511915, 0.88098776,
            0.21521498, 0.89468116, 0.1842307, 0.10784956, 0.8354833, 0.2630701, 0.7184675,
            0.06132602, 0.06056971, 0.71349823, 0.00944792,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(
        kernel16,
        Some(Array::from_shape_vec((1,), vec![0.07349233]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            1.2448996, 1.4834335, 1.5505173, 1.593123, 0.97934985, 0.31316152, 2.5956433,
            2.5870645, 3.9217486, 3.5943062, 2.274174, 0.41883844, 2.5384665, 3.8527317, 5.2204995,
            4.979322, 3.0143876, 1.0825853, 2.8920267, 4.924083, 6.3850694, 5.7269206, 4.4894614,
            1.5533744, 1.9672717, 2.9827163, 5.1832967, 4.4597487, 3.532419, 1.2576363, 0.77356213,
            2.2175355, 2.3090084, 3.4579918, 1.9424138, 1.1060413, 0.70007086, 1.2425315,
            1.2648796, 1.4065831, 1.5131733, 0.2029255,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.35231608, 0.8533961, 0.17608605, 0.18067755, 0.51991457, 0.19053963, 0.5045173,
            0.7456122, 0.27621788, 0.48649722, 0.39297876, 0.54849166, 0.3746991, 0.8194284,
            0.34880427, 0.79505837, 0.41293454, 0.890512, 0.12076204, 0.20799449, 0.88948244,
            0.24437675, 0.7731474, 0.65954226,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.4922565, 0.5211581, 0.97382414, 0.9779564, 0.1754263, 0.4551989, 0.81067127,
            0.7095975, 0.5087082, 0.78796804, 0.03310984, 0.20805901, 0.45704818, 0.9133983,
            0.5689028, 0.04247752, 0.55938286, 0.9835293, 0.04525762, 0.7176199, 0.82096803,
            0.5575717, 0.5744108, 0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355,
            0.1134909, 0.5645703, 0.30096474, 0.4096875,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(
        kernel17,
        Some(Array::from_shape_vec((1,), vec![0.5703153]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.9533454, 2.0009193, 2.462848, 2.4867277, 2.1802006, 0.99282867, 1.4734185, 3.1250882,
            3.7147145, 4.8713336, 3.3510838, 1.8618088, 1.8793681, 3.510714, 5.6246943, 6.1855597,
            3.809399, 2.5736642, 1.7044075, 4.119006, 7.704243, 6.636786, 5.077498, 2.968994,
            1.3274872, 3.4189668, 4.8185444, 4.808972, 3.9743915, 2.167817, 1.14656, 2.3954425,
            3.2241478, 3.364864, 1.9076526, 1.159062, 0.8204025, 1.4200044, 2.0416152, 2.0207047,
            1.4142942, 0.8638201,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.88738924, 0.6242374, 0.77620894, 0.681929, 0.24701218, 0.74485576, 0.61556435,
            0.63869125, 0.05875124, 0.3210932, 0.96946657, 0.09463912, 0.6275637, 0.34162354,
            0.74390864, 0.8736778, 0.9513908, 0.24045336, 0.7003475, 0.87750345, 0.16564246,
            0.6314963, 0.21785556, 0.7654987,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.13988015, 0.03287261, 0.82226163, 0.60896695, 0.13331373, 0.62307173, 0.23316076,
            0.9600204, 0.55291533, 0.29808274, 0.8765127, 0.98263544, 0.27148733, 0.11101003,
            0.2754741, 0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706,
            0.18621969, 0.5836321, 0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146,
            0.46701643, 0.91682273, 0.6142979, 0.19277428,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(
        kernel18,
        Some(Array::from_shape_vec((1,), vec![0.28408903]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.531856, 0.5209744, 1.9334369, 2.3761315, 2.366457, 1.4858656, 1.0626705, 1.5692067,
            3.5361345, 4.6678553, 3.4909105, 1.8521688, 2.1469693, 3.3226676, 5.361343, 7.3358593,
            4.08188, 2.2466087, 2.5954626, 4.6175656, 6.602836, 7.1874266, 5.0923266, 2.4845638,
            2.225271, 4.167998, 5.7276864, 4.510522, 3.384312, 1.0089447, 1.4694545, 2.983774,
            3.4827251, 3.757539, 2.1847162, 0.6861488, 0.6661809, 1.2636437, 1.4510181, 1.6648386,
            1.2625785, 0.47462755,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.25507236, 0.9800453, 0.36125833, 0.96792, 0.33258557, 0.9508625, 0.8424581,
            0.8130291, 0.7774976, 0.17691322, 0.9389267, 0.22419459, 0.33442205, 0.7614585,
            0.37563834, 0.70754576, 0.1499497, 0.9873837, 0.7166968, 0.40278858, 0.22288306,
            0.3279577, 0.07722609, 0.598755, 0.8143903, 0.87905455, 0.83061284, 0.9923988,
            0.6196494, 0.536406, 0.06662867, 0.83588266, 0.28182983, 0.662181, 0.99850965,
            0.60448396, 0.12318801, 0.91713256, 0.8540598, 0.19103892, 0.5929614, 0.9118344,
            0.9381113, 0.3421722, 0.8149188, 0.9595595, 0.02717085, 0.8916309, 0.9755575,
            0.27588442, 0.59208006, 0.00008138, 0.9552037, 0.12578069, 0.01249961, 0.05413999,
            0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439, 0.34315115, 0.52290094,
            0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794, 0.6930413, 0.90735817,
            0.91156703, 0.45996496,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9045769, 0.17170428, 0.43418503, 0.69308424, 0.42869946, 0.9244341, 0.41451567,
            0.6224708, 0.00536506, 0.33826837, 0.47926104, 0.0032256, 0.02230139, 0.35960108,
            0.48593593, 0.86064774, 0.28908366, 0.4153976,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(
        kernel19,
        Some(Array::from_shape_vec((1,), vec![0.3468706]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.6192738, 1.6464701, 1.6815279, 2.1868775, 1.2656612, 2.2776058, 1.0934608,
            0.76266205, 1.6058061, 2.645673, 3.3132725, 4.1984158, 3.5122118, 3.1282132, 2.551571,
            1.7691915, 1.7959499, 4.313555, 5.374065, 4.778566, 4.9418, 4.9326205, 3.0463798,
            1.8003874, 2.4095407, 3.313775, 4.634403, 4.7071934, 3.2644632, 5.282364, 2.280977,
            1.9544044, 2.857838, 3.45702, 4.5997334, 3.9780335, 4.477297, 4.293855, 3.150744,
            1.5079055, 1.5690727, 3.763602, 4.5452924, 5.0192485, 5.6852984, 5.4703274, 3.6144407,
            1.7918737, 1.509274, 2.685004, 3.5173223, 4.226133, 4.3993917, 4.4898405, 3.1280828,
            1.4853473, 1.0612779, 1.7783816, 2.185345, 2.1748676, 2.509197, 2.2588358, 1.2401323,
            0.54118204,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.2242362, 0.93169004, 0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496,
            0.11111139, 0.19382912, 0.9307082, 0.9188555, 0.10532705, 0.88550454, 0.20754221,
            0.97926295, 0.3472928, 0.71126235, 0.03633394, 0.7482733, 0.28782296, 0.7382309,
            0.60003114, 0.3259743, 0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927,
            0.968827, 0.47373444, 0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834,
            0.3979838, 0.2393961, 0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945,
            0.66457146, 0.8425775, 0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123,
            0.48163053, 0.437191, 0.43973154, 0.29997745, 0.21913478, 0.6611514, 0.209788,
            0.176356, 0.88925517, 0.14793599, 0.36509594, 0.5616029, 0.6617385, 0.30053073,
            0.36820948, 0.62227124, 0.4957459, 0.69923055, 0.3227648, 0.9702412, 0.5679234,
            0.13432135, 0.7430913,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.19231908, 0.26170298, 0.10480803, 0.00958306, 0.20726651, 0.20851518, 0.17973869,
            0.23704103, 0.1163867, 0.2735905, 0.8537909, 0.40303, 0.75797635, 0.34342998,
            0.74670875, 0.82946825, 0.91931367, 0.9654975,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(
        kernel20,
        Some(Array::from_shape_vec((1,), vec![0.18782942]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.29645082, 0.7299697, 0.92935985, 0.71348935, 0.81546766, 1.3293377, 1.443759,
            0.63991416, 0.72264326, 1.6519624, 2.010962, 2.0770395, 2.3162816, 2.8416672,
            2.1784225, 1.3539064, 1.2624891, 2.8637185, 3.4850173, 3.4686348, 3.3998358, 4.447108,
            3.1626694, 1.8611519, 1.6554114, 3.3425198, 4.0663896, 4.0985923, 4.296921, 4.0964246,
            2.690757, 1.3447666, 1.5009638, 2.6665435, 3.7862675, 3.644147, 3.37399, 3.7013037,
            2.1510775, 1.1041495, 1.636328, 2.9090333, 3.5777135, 3.9007375, 3.6472788, 3.7600873,
            2.6943994, 1.4500898, 1.2164195, 2.0053053, 3.3447833, 2.7979963, 2.807797, 3.0788417,
            2.0257056, 1.3594657, 0.905447, 1.3705877, 2.269989, 2.05937, 1.9365844, 1.6888094,
            1.1610136, 0.9516022,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.10021565, 0.05109123, 0.3069365, 0.10895161, 0.9891213, 0.62504834, 0.507994,
            0.47125, 0.84314245, 0.6054993, 0.92367506, 0.6953895, 0.37023902, 0.67128026,
            0.43450755, 0.28869846, 0.27641538, 0.8369712, 0.6856483, 0.26890948, 0.65425915,
            0.84581685, 0.51146317, 0.48995435, 0.52071315, 0.80564773, 0.670521, 0.3835857,
            0.47078377, 0.5100531, 0.82525116, 0.02126783, 0.9583153, 0.23316967, 0.9487504,
            0.9609589, 0.95734006, 0.00943314, 0.7521432, 0.46106157, 0.84370506, 0.16933449,
            0.71423984, 0.5316646, 0.6400151, 0.9638914, 0.69432026, 0.8581641, 0.70813745,
            0.2836983, 0.33953485, 0.8950543, 0.20262088, 0.81930757, 0.09556881, 0.22266188,
            0.63842744, 0.8304186, 0.12425002, 0.7582065, 0.09737789, 0.84872884, 0.17490041,
            0.37569723, 0.6669188, 0.8970669, 0.22398192, 0.29424527, 0.56277037, 0.41113177,
            0.7882464, 0.24159203,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633, 0.9636684, 0.98529965,
            0.26998708, 0.13811645, 0.9724998, 0.41856614, 0.13321315, 0.0937838, 0.4742414,
            0.79873264, 0.1621314, 0.5493846, 0.6481355,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(
        kernel21,
        Some(Array::from_shape_vec((1,), vec![0.05176858]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            1.0375085, 0.5193071, 1.1289793, 0.9829098, 1.8343921, 1.3002505, 0.7314059,
            0.27072105, 1.1902069, 1.7743398, 2.9250827, 2.6105309, 4.120447, 3.560632, 2.7351696,
            1.1221762, 1.6520774, 2.4769094, 4.263504, 4.0641384, 5.545001, 5.7060246, 3.5846956,
            1.9755434, 1.4850376, 2.631002, 4.7688327, 4.9971447, 4.945761, 5.618818, 2.7824202,
            2.4199407, 1.4437875, 3.0110688, 4.1042433, 3.768557, 4.5919805, 5.561379, 2.634402,
            2.0559118, 1.818697, 1.9919527, 4.187648, 4.7172303, 5.070252, 4.4992666, 2.9756591,
            2.1530223, 1.2327821, 1.3638346, 3.4599783, 2.2107809, 3.5175211, 3.2162106, 2.8805296,
            1.8226494, 0.90120274, 0.46628955, 1.5137863, 1.1097263, 1.9003043, 2.025645,
            1.0858705, 0.34107718,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.17029643, 0.955536, 0.089831, 0.05664136, 0.9231865, 0.98567015, 0.01680515,
            0.54690886, 0.8593988, 0.6496963, 0.8382851, 0.2400014, 0.36792266, 0.01756373,
            0.6596718, 0.5680892, 0.19350345, 0.4854058, 0.7869872, 0.12335967, 0.14544043,
            0.25711668, 0.05608724, 0.18204254, 0.9562488, 0.44598028, 0.3229758, 0.8930679,
            0.24216229, 0.21437034, 0.38366762, 0.64894366, 0.8650639, 0.7790032, 0.3529938,
            0.37360683, 0.26240814, 0.554433, 0.90017563, 0.6817857, 0.95833224, 0.28551313,
            0.85106283, 0.70093375, 0.4791875, 0.5805011, 0.9803199, 0.97033703, 0.48236644,
            0.66855663, 0.35855147, 0.25242767, 0.6717967, 0.26290378, 0.53677225, 0.18097793,
            0.07985484, 0.79416144, 0.7215235, 0.42313012, 0.6529702, 0.00384528, 0.08442257,
            0.7838985, 0.980683, 0.36212954, 0.61172485, 0.5263662, 0.8496614, 0.13177402,
            0.9175598, 0.04323238,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.03087392, 0.03482862, 0.36226457, 0.6059544, 0.29194582, 0.34645593, 0.9409913,
            0.60953087, 0.8610255, 0.1627552, 0.8939359, 0.66327935, 0.48094535, 0.06551108,
            0.86129206, 0.65446067, 0.9592776, 0.8000413, 0.21450381, 0.6442533, 0.46971878,
            0.84573215, 0.34651902, 0.18830031, 0.57119006, 0.27269888, 0.7915957, 0.21737069,
            0.04463017, 0.393406, 0.8441482, 0.77705365, 0.6315176, 0.8522896, 0.16809769,
            0.22305161, 0.773223, 0.9678148, 0.2237789, 0.8982615, 0.271913, 0.34780893,
            0.49277794, 0.14560463, 0.33638617, 0.1585067, 0.18610527, 0.6963084, 0.9429821,
            0.40789625,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(
        kernel22,
        Some(Array::from_shape_vec((1,), vec![0.20056698]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.2773831, 0.5949137, 1.0397162, 1.6855193, 2.0169973, 1.8600324, 1.4487692, 1.5066367,
            1.4571147, 0.60065186, 0.7136812, 2.2461064, 3.5132577, 3.8688436, 5.796063, 6.3711596,
            5.465888, 3.984789, 2.4230747, 0.86078787, 1.2784771, 3.5300934, 5.0753818, 6.426252,
            8.572098, 10.85455, 8.003611, 5.0521684, 3.9465263, 1.7532954, 1.2935575, 4.342728,
            6.6624904, 8.066196, 10.201652, 11.106928, 9.391577, 6.090654, 4.4220176, 2.352763,
            1.9344163, 4.4908, 7.007652, 9.499838, 12.040188, 13.062072, 11.283161, 7.2351723,
            4.7473154, 2.3210979, 2.5997202, 4.7689877, 7.020522, 9.925786, 12.581889, 11.921771,
            10.418359, 7.7143607, 4.7253737, 1.8933289, 2.7606347, 4.8315196, 6.7171907, 8.228884,
            11.375899, 9.435135, 7.398631, 6.2054048, 3.0587223, 1.4226763, 1.9381105, 3.9150126,
            5.393129, 6.1439967, 7.878722, 6.7750087, 6.346672, 4.3430634, 2.7071955, 1.0976838,
            1.1706665, 2.4895544, 3.7407496, 4.607138, 5.4950013, 4.50462, 4.479729, 3.4029574,
            1.7432591, 0.72596467, 0.47774535, 1.0271459, 1.9472702, 2.71758, 3.1737711, 2.7633858,
            2.3974445, 1.7905524, 0.8875804, 0.43160182,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.37306353, 0.9367061, 0.7103306, 0.06833509, 0.48335183, 0.45182207, 0.96346164,
            0.00378525, 0.33689302, 0.28288215, 0.75004077, 0.1607512, 0.514175, 0.35879079,
            0.36688787, 0.00774159, 0.15532039, 0.01133456, 0.94680935, 0.052598, 0.73530346,
            0.8096563, 0.7097644, 0.37942106, 0.38656324, 0.13763146, 0.99930644, 0.67476803,
            0.06055127, 0.8463604, 0.4460729, 0.33209085, 0.94373864, 0.5397614, 0.05766413,
            0.64256257, 0.7357459, 0.09256811, 0.8832945, 0.03911254, 0.782554, 0.4004812,
            0.80732703, 0.8010379, 0.28867772, 0.7802926, 0.9490529, 0.5395702, 0.1369102,
            0.4513485, 0.1162144, 0.9589836, 0.24819064, 0.3149064, 0.22322156, 0.39812055,
            0.45308354, 0.5711523, 0.97817534, 0.06805564, 0.5386646, 0.6699801, 0.1879456,
            0.8407316, 0.64728755, 0.53731096, 0.63207716, 0.00916763, 0.46754488, 0.8670982,
            0.1932068, 0.43971533,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.10441232, 0.46486124, 0.22910197, 0.7679019, 0.23872072, 0.03931138, 0.8551502,
            0.19610135, 0.8555064, 0.08035298, 0.05671094, 0.9091975, 0.27582648, 0.33816597,
            0.42012835, 0.7745094, 0.14011143, 0.47505257, 0.98297566, 0.5085966, 0.22395916,
            0.01153891, 0.669607, 0.12918296, 0.55476546, 0.528783, 0.5067741, 0.14234911,
            0.5152856, 0.6446142, 0.9118427, 0.8193508, 0.989135, 0.7842302, 0.59264964,
            0.35247177, 0.48483032, 0.22649786, 0.04158387, 0.5814206, 0.8653732, 0.4524277,
            0.44947338, 0.5519129, 0.79122764, 0.7513198, 0.9315116, 0.03313805, 0.41213843,
            0.45310238,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(
        kernel23,
        Some(Array::from_shape_vec((1,), vec![0.01799934]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.44600174, 0.71103126, 1.2317896, 1.7170261, 2.1526582, 2.203331, 1.4647037,
            0.99445194, 1.191148, 0.38401452, 1.2310475, 2.3420684, 3.4603114, 4.5747085,
            5.5854616, 5.170395, 3.8119512, 3.3077607, 2.4135218, 0.6778389, 1.198598, 3.600137,
            4.0917945, 6.39271, 6.4752107, 6.7120905, 5.386101, 3.8317254, 2.3969374, 0.97906244,
            1.644782, 4.5054936, 4.7993894, 7.3590355, 9.755276, 9.6216345, 6.556913, 5.3348746,
            4.0345135, 1.2679049, 2.7425585, 5.075645, 5.6780005, 10.529102, 12.219203, 11.856426,
            9.2873, 7.086794, 5.0520372, 1.7658716, 2.3766026, 5.2541165, 5.610291, 10.071071,
            12.417599, 11.150108, 9.736647, 6.265123, 4.9578676, 1.6288455, 1.9681766, 2.9671826,
            4.929202, 8.548584, 10.033071, 8.456056, 8.372943, 5.4031754, 3.6173677, 1.3940045,
            1.411386, 2.2660854, 4.011606, 5.5324817, 7.5432515, 7.098474, 5.7562647, 4.581127,
            2.975616, 1.6405348, 1.4017533, 1.6720353, 2.967611, 3.8350694, 5.1333575, 5.2627645,
            3.9257343, 3.2592034, 1.7321666, 1.4057077, 0.5927936, 0.6931963, 0.91264504,
            1.7775675, 2.217982, 1.5660702, 1.6425203, 1.2422374, 0.4017636, 0.5737069,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.4328227, 0.23842481, 0.20688592, 0.57869387, 0.9324833, 0.43915927, 0.53123087,
            0.5324186, 0.4149537, 0.22217223, 0.0080786, 0.65063345, 0.7681623, 0.8421627,
            0.27179125, 0.68530315, 0.9955617, 0.77906156, 0.18006648, 0.5975193, 0.6555531,
            0.9498266, 0.9690994, 0.5122471, 0.3840358, 0.8757204, 0.7260429, 0.04691354,
            0.40678895, 0.35535267, 0.19270384, 0.23519029, 0.6665529, 0.26402712, 0.55168146,
            0.08576613, 0.9567203, 0.57141143, 0.20602623, 0.75538653, 0.96776, 0.44755465,
            0.82362133, 0.29203537, 0.30861592, 0.39762703, 0.26186082, 0.9658112, 0.27424002,
            0.50570756, 0.8114843, 0.5536027, 0.59788686, 0.05054026, 0.28394443, 0.6402348,
            0.02258505, 0.60607, 0.6834324, 0.8004999, 0.3349493, 0.4295082, 0.37033585, 0.0394791,
            0.50698835, 0.29841292, 0.9388161, 0.84357476, 0.29760668, 0.25654384, 0.71037215,
            0.14646496,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.9906275, 0.9552909, 0.7966291, 0.6094893, 0.7271988, 0.09518696, 0.3957746,
            0.6157527, 0.31079137, 0.46793708, 0.8514491, 0.86081386, 0.8208274, 0.2372746,
            0.6977758, 0.79387194, 0.9463199, 0.99063903, 0.29514915, 0.8795419, 0.741553,
            0.03520088, 0.83411527, 0.47134155, 0.26704508, 0.2872401, 0.04289522, 0.583651,
            0.94414073, 0.5729697, 0.72244126, 0.7707775, 0.02079507, 0.22973806, 0.18128674,
            0.05054512, 0.6523751, 0.27093726, 0.32479268, 0.53774405, 0.08921466, 0.18494032,
            0.78120434, 0.15868789, 0.81183356, 0.21792394, 0.6620494, 0.6886836, 0.39724785,
            0.59319293,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(
        kernel24,
        Some(Array::from_shape_vec((1,), vec![0.02472531]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.7282998, 0.8795581, 1.444317, 2.7119668, 3.6444604, 3.2439117, 3.1055183, 2.9714673,
            1.9475406, 0.6005166, 1.5199276, 2.523072, 2.9392147, 3.8191433, 4.6185775, 4.6524262,
            3.4370084, 2.947878, 2.3401468, 1.3378803, 1.9269291, 4.0851793, 4.546829, 5.856332,
            8.852578, 9.202348, 7.2744303, 5.1484127, 3.5097969, 1.6468648, 1.478811, 4.2351165,
            6.769006, 8.423829, 11.236075, 11.384119, 9.670404, 8.109716, 5.4379945, 2.9525611,
            2.4162197, 5.8428693, 8.853724, 9.691192, 13.510861, 13.90875, 10.887582, 8.531687,
            5.0201526, 3.148825, 2.1392057, 4.923321, 8.457863, 10.453961, 13.741056, 13.771473,
            10.717018, 7.9624577, 5.3568215, 2.6522014, 1.8629029, 4.470568, 6.4404917, 8.4302635,
            9.9519005, 10.919503, 8.232524, 6.0305014, 3.9028976, 1.838277, 0.7664202, 2.981792,
            5.213991, 5.9799995, 7.503708, 7.566848, 6.4642963, 3.9975905, 3.0048497, 1.3297848,
            0.61924005, 1.6209446, 3.3686075, 3.6953235, 5.03631, 4.079755, 3.530842, 1.8711576,
            1.8306215, 0.490977, 0.37221593, 1.0112925, 1.9579167, 1.73782, 2.5830338, 2.0024781,
            1.6549953, 0.9620435, 0.6920449, 0.13451071,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.21891202, 0.5342134, 0.4041879, 0.53426075, 0.20461221, 0.29362342, 0.7835011,
            0.47930118, 0.2895624, 0.7320774, 0.55179524, 0.37774232, 0.04187773, 0.23883641,
            0.63051957, 0.97746944, 0.6415133, 0.4162999, 0.04763152, 0.75958186, 0.13098118,
            0.6238241, 0.4102024, 0.5710282, 0.59153587, 0.66274744, 0.6454271, 0.8120847,
            0.22876394, 0.6206928, 0.19057496, 0.4622738, 0.9772445, 0.17967562, 0.27354005,
            0.48198408, 0.09082693, 0.6217685, 0.0965838, 0.8904992, 0.5337058, 0.17222154,
            0.62424076, 0.95776683, 0.998361, 0.150883, 0.28713444, 0.35105017, 0.1765902,
            0.9674033, 0.65025777, 0.1959308, 0.3119046, 0.55247456, 0.38556734, 0.18145509,
            0.94255227, 0.7036003, 0.3402552, 0.16401337, 0.28418577, 0.5504918, 0.6148071,
            0.7740251, 0.37459207, 0.25677747, 0.80441076, 0.17314304, 0.5946227, 0.30094627,
            0.06480476, 0.5798754,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.62549657, 0.6065069, 0.9259787, 0.3677915, 0.69532603, 0.8356569, 0.39276573,
            0.18570696, 0.61698794, 0.9064707, 0.01547038, 0.2551995, 0.11438051, 0.03861368,
            0.6524532, 0.36442748, 0.08230381, 0.79969245, 0.27816203, 0.3741886, 0.44356522,
            0.27386904, 0.4171807, 0.14990133, 0.4750283, 0.6358263, 0.77572674, 0.7072159,
            0.34310365, 0.36999545, 0.8200852, 0.46510443,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(
        kernel25,
        Some(Array::from_shape_vec((1,), vec![0.9230857]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            1.0674899, 1.5138135, 2.2330532, 2.4350586, 2.9614275, 2.5990343, 2.106529, 1.5178415,
            1.0955212, 1.6570432, 3.1311715, 4.206597, 5.253577, 4.397836, 4.2210574, 3.1777062,
            1.9860778, 1.2737192, 1.9637058, 3.7836642, 5.501226, 6.7341404, 7.328535, 6.472616,
            5.196837, 2.8230333, 1.6024296, 1.9282057, 4.6032057, 5.861317, 9.334084, 9.241022,
            8.385155, 5.8054914, 3.6131887, 1.8863767, 1.9341426, 4.124815, 7.6583586, 9.783682,
            9.877411, 8.364878, 5.90117, 3.9017453, 2.1759772, 1.9237832, 4.5318804, 6.646142,
            8.598952, 8.940878, 7.9970274, 6.1222873, 3.690018, 2.1414847, 2.0501103, 3.381821,
            5.3632693, 6.7123413, 6.3787317, 6.124959, 4.656289, 2.7617245, 1.7238969, 1.5879514,
            2.367437, 4.0976176, 5.042277, 4.0889635, 4.6835346, 3.2732573, 2.3691502, 1.8018107,
            1.22088, 1.340354, 2.1048195, 2.1918254, 2.4691372, 2.2084403, 1.5933158, 1.8429315,
            1.3684366,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.86201537, 0.04691705, 0.12260284, 0.89921826, 0.47400048, 0.7492544, 0.05440097,
            0.28273952, 0.9184355, 0.9064988, 0.7027802, 0.19125043, 0.8670149, 0.08634489,
            0.722654, 0.77540857, 0.00211577, 0.6443405, 0.2344423, 0.9849179, 0.9893316,
            0.87634915, 0.48734385, 0.8760625, 0.53053117, 0.01152504, 0.6788874, 0.76156837,
            0.4680538, 0.07214947, 0.549209, 0.8383253, 0.00365476, 0.9782156, 0.7419056,
            0.40790308, 0.00302504, 0.80174476, 0.7689671, 0.50054824, 0.16478458, 0.89107823,
            0.7763043, 0.73042727, 0.41667554, 0.7348974, 0.71259016, 0.93557405, 0.37013116,
            0.14954911, 0.33766475, 0.39673004, 0.03940821, 0.2414454, 0.9373305, 0.84819096,
            0.9272432, 0.8604789, 0.92845494, 0.8023847, 0.06647868, 0.12827316, 0.02774826,
            0.8982795, 0.1193029, 0.37523487, 0.28379655, 0.0638791, 0.08446726, 0.68760884,
            0.2630593, 0.01052708,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.45302406, 0.10402057, 0.5539082, 0.39986408, 0.53770447, 0.24856173, 0.12796782,
            0.80071914, 0.38390577, 0.6908975, 0.5850918, 0.71101063, 0.17578217, 0.55867785,
            0.71616316, 0.3247584, 0.9196999, 0.46712968, 0.08430128, 0.83232373, 0.49657014,
            0.24024557, 0.60874844, 0.47418702, 0.9770886, 0.99522823, 0.7749884, 0.7253688,
            0.26021662, 0.8869578, 0.5181486, 0.5871326,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(
        kernel26,
        Some(Array::from_shape_vec((1,), vec![0.76900613]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            1.162302, 1.6187057, 2.3888988, 2.449471, 2.2814574, 3.283578, 2.3158207, 1.5858332,
            1.8102716, 1.9726297, 2.5755022, 2.798687, 5.1648297, 5.0272093, 5.2855496, 4.168089,
            2.9239364, 2.6466608, 2.250824, 3.3234758, 5.55873, 7.4546924, 6.482493, 7.953001,
            6.275893, 4.2600527, 3.0034785, 3.3189878, 5.2162085, 7.6207824, 11.0491295, 10.769256,
            12.076087, 9.125205, 5.6418867, 3.9987073, 2.5680737, 4.3180504, 6.6311345, 9.809854,
            9.794716, 10.0433445, 8.512531, 4.420662, 3.4368196, 2.851678, 4.7834435, 6.6968923,
            10.821541, 9.830537, 9.749007, 8.225887, 4.945232, 2.7325068, 1.7589924, 3.3748488,
            4.4363017, 8.100884, 8.283619, 7.7066603, 7.0410347, 4.04531, 2.1797113, 1.3677018,
            2.2059135, 2.6981504, 4.096899, 5.296184, 4.6046247, 4.438425, 2.2022922, 1.3104093,
            0.93939584, 1.4915377, 1.8570122, 2.1753101, 2.4804025, 2.5988822, 2.3952603,
            1.4619766, 0.9076569,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.5745777, 0.81429285, 0.78002185, 0.7069771, 0.33134556, 0.7407027, 0.58577555,
            0.40479863, 0.7506117, 0.11343616, 0.8795398, 0.83064, 0.8858372, 0.3898591, 0.9350765,
            0.9673369, 0.64465624, 0.0283905, 0.22112074, 0.1391855, 0.34128338, 0.65248054,
            0.291874, 0.70765275, 0.32796225, 0.22921298, 0.59572685, 0.5726663, 0.72872376,
            0.8248998, 0.29288608, 0.92347336, 0.25887516, 0.91578674, 0.800785, 0.7670362,
            0.8990461, 0.8424308, 0.7045559, 0.43518323, 0.48451254, 0.31151697, 0.10086012,
            0.5242353, 0.19001916, 0.01069371, 0.01020448, 0.12606935, 0.04778918, 0.8456499,
            0.57045126, 0.46361542, 0.7532553, 0.62787765, 0.3127784, 0.9686197, 0.96754897,
            0.5766132, 0.6463905, 0.6347338, 0.52757853, 0.55145216, 0.08155768, 0.13378453,
            0.2262157, 0.73179847, 0.5428326, 0.9094368, 0.2528448, 0.24383228, 0.7446406,
            0.5544842,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.01949351, 0.13375893, 0.04438103, 0.8489, 0.6848837, 0.9220802, 0.00185038,
            0.44556108, 0.00844186, 0.8082305, 0.33159012, 0.5138473, 0.65069795, 0.9300001,
            0.58097035, 0.5413155, 0.5714561, 0.21683556, 0.8548128, 0.02262598, 0.62476623,
            0.33444464, 0.98826236, 0.03221937, 0.12669064, 0.50246465, 0.42635268, 0.91064155,
            0.7792924, 0.07601635, 0.6067355, 0.3940292,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(
        kernel27,
        Some(Array::from_shape_vec((1,), vec![0.30074376]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.82570964, 1.0698295, 1.8041763, 2.0846815, 2.120204, 1.7240593, 1.5062397, 0.8921475,
            0.93657464, 1.3250122, 2.622941, 3.6005492, 4.2462935, 3.3072147, 3.1356285, 2.1791153,
            1.6647229, 1.3487918, 0.92827463, 3.1288075, 3.9938915, 6.7383666, 5.5551133, 5.988362,
            4.6467347, 2.9112616, 1.377502, 2.2125652, 4.965528, 6.6695967, 9.847891, 8.654203,
            7.6272087, 5.9450836, 3.8492224, 2.0140378, 1.4287753, 3.862366, 5.1633787, 7.571697,
            7.6042957, 8.158454, 6.2555485, 4.699612, 2.4389853, 1.8260343, 4.175614, 5.5795736,
            8.227374, 9.119864, 8.451317, 7.2039285, 4.8492117, 2.5599587, 1.2977166, 3.6297946,
            4.637462, 6.1326976, 6.9352756, 6.5263114, 5.98385, 3.6058497, 2.383816, 0.99653035,
            1.8572309, 3.083778, 3.9047022, 4.6910286, 4.74018, 4.2210383, 3.2879286, 1.9347005,
            0.91434944, 1.9240115, 2.0937097, 2.807369, 3.4343665, 2.953041, 2.5650764, 1.8096819,
            0.9344353,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.1328066, 0.72018456, 0.34319454, 0.6295161, 0.03357495, 0.03066352, 0.51702976,
            0.9283114, 0.36689135, 0.6327302, 0.37459058, 0.93406814, 0.33968034, 0.59511477,
            0.4350908, 0.7094508, 0.29612544, 0.80898666, 0.7905302, 0.4748418,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.6989706, 0.85952836, 0.70326394, 0.38940284, 0.37933362, 0.22292, 0.3949557,
            0.27719194, 0.8619771, 0.9255003, 0.30563155, 0.5844432, 0.36121982, 0.09087573,
            0.23811613, 0.17829578, 0.9398569, 0.04807154,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(
        kernel28,
        Some(Array::from_shape_vec((2,), vec![0.7588201, 0.05337733]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (2, 6, 7),
        vec![
            0.85164803, 1.376359, 1.7111201, 2.0002987, 1.5647314, 1.2303947, 0.7824322, 0.8319683,
            1.4773848, 2.3100853, 2.7126489, 2.497657, 1.713759, 1.211281, 1.085041, 2.267896,
            3.0766423, 3.698458, 2.8894222, 2.425054, 1.2347928, 1.4126828, 2.2941232, 3.1842265,
            3.6316867, 3.9618115, 2.5122588, 1.7351487, 1.1830289, 1.6159997, 2.0602863, 2.5738888,
            2.053538, 1.7487476, 1.2397102, 1.0390217, 1.0724306, 1.7719479, 1.5505424, 1.8628182,
            1.5718614, 1.1681229, 0.17628987, 0.7604982, 0.66873306, 1.1617926, 0.47742867,
            0.43155533, 0.07299998, 0.12972881, 0.81347406, 1.3095108, 1.4089004, 1.4447039,
            0.6141359, 0.43116695, 0.43481615, 1.4751172, 2.0062153, 2.0633, 1.933545, 0.7408456,
            0.45994046, 0.850751, 1.0367208, 2.2569354, 2.6363358, 2.0016534, 1.4540824,
            0.46491385, 0.37643296, 0.7434175, 1.4979026, 0.9532215, 1.1425989, 0.7222981,
            0.1873603, 0.17986941, 0.77295744, 0.5100361, 0.9688924, 0.9199141, 0.5376627,
            0.0762037,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.19222781, 0.98696715, 0.32119673, 0.3872288, 0.74463385, 0.6260977, 0.0084233,
            0.31085488, 0.10247751, 0.60939455, 0.00353958, 0.22236562, 0.31823838, 0.9627444,
            0.866447, 0.8205645, 0.7792785, 0.61566937, 0.59327537, 0.33567885,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.96525836, 0.47292593, 0.2669342, 0.705448, 0.28257245, 0.02662205, 0.05098573,
            0.8293213, 0.9416077, 0.9101412, 0.07020015, 0.8425068, 0.9708137, 0.3117258,
            0.11623824, 0.19467542, 0.09732427, 0.43287596,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(
        kernel29,
        Some(Array::from_shape_vec((2,), vec![0.20617688, 0.8857049]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (2, 6, 7),
        vec![
            0.39172637, 1.2497647, 1.0342891, 0.9953102, 1.1938099, 0.66169816, 0.4049451,
            0.9461296, 1.2609776, 1.1879374, 0.84456015, 1.5691136, 0.7424519, 0.3886688,
            0.6610737, 0.81509113, 1.8736992, 2.7211442, 2.7114506, 2.030016, 1.1548375, 1.0326526,
            2.0239816, 2.287837, 2.3239894, 2.2756233, 1.3956354, 0.8926583, 0.78522295, 1.0020592,
            1.0865184, 1.3418083, 1.7692711, 1.9419152, 1.0309665, 0.24801396, 0.9264206,
            1.6564895, 1.4807879, 1.2950267, 1.0431952, 0.5222547, 1.0606593, 1.7974788, 1.4092777,
            2.0922122, 1.8612208, 1.2642212, 1.5130639, 1.6421596, 1.955407, 2.3385391, 1.5986683,
            2.5903766, 1.2919549, 1.4856789, 1.5341725, 1.5025324, 1.8129191, 2.702869, 2.9913702,
            2.199617, 2.0088615, 1.7578566, 1.9321154, 2.9031243, 3.2389827, 3.193005, 1.8947787,
            1.5330231, 1.6830091, 1.9416639, 1.9068342, 2.0588183, 1.8682221, 1.5603812, 1.2997876,
            1.0454487, 1.1172721, 1.4366059, 1.3984516, 1.2753018, 1.1751893, 1.0310122,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.9601851, 0.09430943, 0.28105715, 0.6942895, 0.07089514, 0.7148581, 0.00085336,
            0.23516753, 0.04615124, 0.59699446, 0.53420085, 0.75324225, 0.38793716, 0.2669936,
            0.29911962, 0.7380972, 0.17850904, 0.65695775, 0.8119258, 0.26960826,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.12972821, 0.6597052, 0.7345929, 0.6485681, 0.22981846, 0.24392553, 0.26706976,
            0.32711208, 0.9581323, 0.31259444, 0.91530424, 0.17250775, 0.715259, 0.5014661,
            0.7273789, 0.23862323, 0.4093651, 0.04974006,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(
        kernel30,
        Some(Array::from_shape_vec((2,), vec![0.8688277, 0.46409306]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (2, 6, 7),
        vec![
            0.9933908, 1.5145013, 1.6728504, 1.2135905, 1.5425138, 1.4256177, 0.9209068, 1.5843104,
            1.6223683, 1.8632007, 1.5684736, 1.4235713, 1.4822184, 1.3246688, 1.6581992, 1.823076,
            3.1614785, 2.1646228, 2.3392406, 2.0991597, 1.302108, 1.5019623, 2.2242765, 2.91705,
            2.0748105, 2.6718764, 2.0164976, 1.7118425, 1.4902029, 1.530143, 2.377811, 2.5098515,
            1.9294491, 1.4824989, 1.2211882, 1.0659511, 1.1579425, 1.8098686, 1.4716027, 1.8358752,
            1.7349522, 1.1271482, 0.7642416, 1.3724351, 0.80391115, 0.95464605, 1.1702251,
            0.648754, 0.476323, 1.3743348, 1.6676284, 1.6084448, 1.4000529, 1.3368269, 1.5590491,
            0.61864686, 1.3715124, 1.963167, 2.2089996, 1.4695534, 1.8052185, 1.180435, 0.95346105,
            1.2474918, 2.294966, 2.0959623, 2.3907309, 2.2079208, 1.4418182, 0.75787044, 1.1194965,
            1.3603282, 1.9878736, 1.7641014, 1.7419142, 1.3255997, 0.67507863, 0.64022017,
            0.8088407, 0.73064685, 0.935652, 0.8934791, 0.61484647, 0.4775034,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );

    let test_input31 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.20740515, 0.19872624, 0.27135858, 0.02647329, 0.90772045, 0.97377276, 0.47016057,
            0.06899374, 0.47393376, 0.49847803, 0.02369655, 0.10663922, 0.02373338, 0.21085607,
            0.56809616, 0.70259374, 0.4123619, 0.01858313, 0.25862443, 0.4823392,
        ],
    )
    .unwrap();

    let kernel31: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.47215322, 0.593886, 0.8265343, 0.06712108, 0.3228139, 0.11140465, 0.59627575,
            0.49184018, 0.8395536, 0.13370071, 0.25792846, 0.54400545, 0.8792363, 0.58678144,
            0.03434712, 0.8123595, 0.67917913, 0.02545591, 0.2468276, 0.9191908, 0.02958322,
            0.20474248, 0.76555794, 0.82307637, 0.24628638, 0.17773865, 0.17740512, 0.4937253,
            0.9466453, 0.13741271, 0.728613, 0.5338591, 0.7898385, 0.47936276, 0.23633894,
            0.8572216, 0.06004518, 0.3347224, 0.50485814, 0.09635731, 0.18004768, 0.24514198,
            0.228041, 0.05106571, 0.30884218, 0.38737774, 0.7948706, 0.5052517, 0.23866583,
            0.5068071,
        ],
    )
    .unwrap();
    let conv_layer31 = TransposedConvolutionLayer::new(
        kernel31,
        Some(Array::from_shape_vec((2,), vec![0.15044466, 0.09537497]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output31: Array3<f32> = Array::from_shape_vec(
        (2, 8, 9),
        vec![
            0.24837166, 0.3674489, 0.5680157, 0.50227547, 0.89932907, 0.79377365, 0.990082,
            0.21991777, 0.44346943, 0.63332045, 1.0965521, 1.517835, 1.305776, 1.5151423,
            1.8032738, 1.1214969, 1.1025149, 0.43272316, 0.32361156, 1.0119696, 1.3719975,
            1.9474211, 2.0861518, 2.0323763, 2.117054, 1.2720503, 0.43165845, 0.9044677, 1.7417208,
            2.5531507, 2.1881745, 2.8533714, 2.8729897, 2.0299, 1.3286065, 1.2335949, 1.0320182,
            1.7473687, 1.4365841, 2.221356, 3.3475378, 2.4262426, 2.207946, 2.24288, 0.91620183,
            0.37972105, 0.9550245, 1.9334035, 2.3876379, 2.1428032, 1.7978505, 1.6039408,
            1.3034029, 0.8119687, 0.7219044, 0.9706242, 0.50417036, 0.6693182, 1.6377578,
            1.1917831, 0.8579465, 1.026742, 0.7337208, 0.17122965, 0.30649444, 0.7732986,
            1.0558755, 0.74433625, 0.5640464, 0.7371477, 0.61114234, 0.26923823, 0.13223888,
            0.16749105, 0.2812621, 0.44267598, 0.61200845, 0.55366766, 0.6058885, 0.958302,
            0.2201073, 0.41957012, 0.60721254, 1.1394466, 1.7663388, 1.9151193, 1.2302696,
            1.5933894, 1.0737654, 0.37840188, 0.98688245, 1.1637614, 1.5145738, 1.6426495,
            2.4667518, 1.3415339, 1.559282, 1.4739165, 0.37871388, 1.1096004, 0.9317868, 1.1698484,
            2.4618258, 2.4410808, 1.461787, 1.8412125, 1.2615321, 0.62429214, 0.8832768, 1.4289558,
            1.6362833, 1.8211064, 2.7357287, 2.0698388, 1.6652609, 1.0967233, 0.8781009, 1.0791379,
            1.47221, 1.2995015, 1.5886247, 2.1890314, 1.3719436, 0.9367658, 0.8171023, 0.56993616,
            0.23105486, 0.40200034, 0.4659591, 0.43649018, 0.9250277, 1.0187054, 0.5736981,
            0.4423286, 0.53225684, 0.36754414, 0.8135859, 0.7853347, 0.5863632, 0.95168066,
            0.82286584, 0.41022056, 0.34156555, 0.3398279,
        ],
    )
    .unwrap();
    let current_output31: Array3<f32> = conv_layer31.transposed_convolve(&test_input31);

    assert!(
        arr_allclose(&current_output31, &target_output31),
        "{:?} was not equal to {:?}",
        current_output31,
        target_output31
    );

    let test_input32 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.13518302, 0.7257979, 0.86458087, 0.7176047, 0.09527912, 0.72005635, 0.7382226,
            0.41232714, 0.5491061, 0.7183669, 0.07962471, 0.04476061, 0.19437055, 0.79608136,
            0.6295519, 0.98047, 0.56819236, 0.10505454, 0.9480506, 0.10080674,
        ],
    )
    .unwrap();

    let kernel32: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.9538371, 0.2355401, 0.94827145, 0.46488547, 0.60260093, 0.76637876, 0.3219317,
            0.4168223, 0.25562465, 0.8997145, 0.59076214, 0.22263806, 0.6840723, 0.24348243,
            0.94946456, 0.34627816, 0.9748906, 0.7407666, 0.9677088, 0.13005458, 0.69001645,
            0.14445187, 0.9216249, 0.03732051, 0.44508553, 0.666532, 0.9382296, 0.80578685,
            0.976145, 0.6098745, 0.04455515, 0.5690737, 0.6428197, 0.21377262, 0.6692434,
            0.86947584, 0.12576632, 0.8154824, 0.3646563, 0.32867205, 0.00950876, 0.02384425,
            0.68798536, 0.6243543, 0.061506, 0.4878141, 0.24558064, 0.15653013, 0.40195072,
            0.52372193,
        ],
    )
    .unwrap();
    let conv_layer32 = TransposedConvolutionLayer::new(
        kernel32,
        Some(Array::from_shape_vec((2,), vec![0.62839466, 0.67610437]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output32: Array3<f32> = Array::from_shape_vec(
        (2, 8, 9),
        vec![
            0.7573372, 1.3525286, 1.7522087, 2.2676141, 2.1270318, 2.1706183, 1.5733464, 1.1051178,
            0.68580997, 1.4188125, 2.1018968, 2.8309786, 3.4494293, 3.5826042, 3.1586452,
            2.8143694, 1.9632399, 1.1470072, 1.3360405, 1.9462817, 2.5184596, 3.7041419, 4.517796,
            4.290385, 3.5841594, 2.7829938, 1.7445524, 2.0968192, 2.4407775, 3.9963565, 6.1200542,
            6.5903907, 5.459229, 3.762872, 3.005526, 1.9500134, 1.7694635, 2.9016063, 3.701634,
            5.569605, 5.80167, 5.0011897, 3.4328637, 3.505809, 1.4526634, 1.7320421, 1.8888752,
            2.7123687, 3.5603254, 4.5349503, 4.215601, 3.1560163, 2.5370457, 1.1257179, 1.0228524,
            1.8233857, 2.1589665, 3.0504184, 3.1083713, 2.4563174, 2.330601, 1.2270641, 0.9217095,
            1.3049351, 1.1620874, 1.6865859, 1.8579924, 1.3893197, 1.7735183, 0.8034407, 1.0541204,
            0.6732623, 0.7662082, 1.2867045, 2.042269, 2.6823828, 2.9004855, 2.6303363, 1.9806511,
            1.2067595, 0.7342127, 1.1620681, 1.9529986, 2.7622201, 3.746127, 4.3761215, 3.8313444,
            2.8356967, 2.2128408, 1.1779829, 0.87879735, 1.871367, 2.766408, 3.7643032, 4.5279903,
            4.620249, 3.557674, 2.5678017, 1.57213, 1.9605238, 2.7645857, 3.3116643, 5.018425,
            6.1489916, 4.9367332, 3.940126, 2.5661092, 1.4008746, 0.8618121, 1.7197537, 3.0120244,
            3.8379655, 4.4431467, 4.12068, 3.500027, 2.719762, 1.0445683, 1.88061, 1.8327155,
            2.1913009, 3.2013247, 2.9132998, 3.1884985, 2.6297703, 2.0428162, 1.1241825,
            0.72426945, 0.7462749, 1.4834731, 2.1657777, 1.7797267, 1.8120775, 1.8641644,
            1.4673283, 1.0120147, 1.1543915, 1.194061, 1.0203617, 1.647416, 1.7164254, 1.1890606,
            1.1279726, 1.2131386, 0.72889906,
        ],
    )
    .unwrap();
    let current_output32: Array3<f32> = conv_layer32.transposed_convolve(&test_input32);

    assert!(
        arr_allclose(&current_output32, &target_output32),
        "{:?} was not equal to {:?}",
        current_output32,
        target_output32
    );

    let test_input33 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.6370576, 0.74306166, 0.8282889, 0.39436254, 0.45260343, 0.6606655, 0.7309763,
            0.40489906, 0.9551375, 0.4431474, 0.6631732, 0.18731794, 0.43634078, 0.4686375,
            0.7620647, 0.57885796, 0.26523942, 0.13030814, 0.7995473, 0.951001,
        ],
    )
    .unwrap();

    let kernel33: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.58605653, 0.82163817, 0.21192186, 0.12197074, 0.06249312, 0.3968833, 0.23130116,
            0.670139, 0.89535373, 0.9697048, 0.7154457, 0.8203782, 0.21395262, 0.7457981,
            0.7147152, 0.05275504, 0.93545914, 0.8986874, 0.8690856, 0.63580817, 0.15263815,
            0.7466949, 0.6235891, 0.62486136, 0.7352324, 0.23342584, 0.9827126, 0.93357897,
            0.96423954, 0.02081718, 0.47192466, 0.50718915, 0.9034243, 0.678573, 0.48106775,
            0.27722874, 0.0061415, 0.2891619, 0.9937529, 0.02278532, 0.7661429, 0.23943478,
            0.7568481, 0.1846646, 0.05945846, 0.7522374, 0.723256, 0.5690188, 0.80126184,
            0.13196982,
        ],
    )
    .unwrap();
    let conv_layer33 = TransposedConvolutionLayer::new(
        kernel33,
        Some(Array::from_shape_vec((2,), vec![0.2549996, 0.9684265]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output33: Array3<f32> = Array::from_shape_vec(
        (2, 8, 9),
        vec![
            0.6283514, 1.2139066, 1.485958, 1.4018456, 1.1502502, 0.85791314, 0.4507792,
            0.33484894, 0.28328422, 0.89502454, 1.6684821, 2.160423, 2.7993832, 3.624715,
            2.7477152, 1.9503114, 1.1563956, 0.721585, 1.3616439, 2.4068403, 2.9161673, 4.1586146,
            5.040741, 4.4638114, 3.0286562, 2.3196187, 1.0558281, 1.3637238, 2.8139038, 3.6749198,
            5.645393, 7.472064, 5.663345, 4.288266, 3.2149575, 1.6579016, 1.0912958, 2.4179235,
            3.741141, 5.7267776, 7.4890614, 6.306734, 5.1823854, 4.3502755, 2.3363745, 0.80496955,
            2.1547902, 2.5035088, 3.9167702, 5.6617374, 4.8423066, 3.6883414, 3.4751198, 1.7450378,
            0.3867628, 1.3342702, 1.6502261, 2.0890682, 3.1117592, 3.4166977, 2.976239, 2.4106019,
            1.4199486, 0.34335542, 0.72771555, 0.833912, 1.0014478, 1.6697683, 1.7401333,
            1.4434464, 1.4370965, 0.95420635, 1.1171322, 1.767921, 2.48673, 3.1824338, 2.9646454,
            2.5955117, 1.7884701, 1.4130542, 0.9778485, 1.4232862, 2.4620774, 3.7413597, 4.618542,
            5.079686, 4.206596, 3.3865094, 1.9124496, 1.1953845, 1.6116233, 2.5538187, 3.450572,
            5.048114, 5.202182, 5.2503805, 3.925748, 2.9319506, 1.2077872, 2.0877473, 2.9524758,
            4.3023963, 5.4662776, 6.033695, 5.2786036, 5.397475, 3.2137964, 1.3918368, 2.4108372,
            3.1811259, 4.5095305, 6.223004, 5.765887, 5.2279096, 4.347521, 3.319691, 1.5293652,
            2.1339653, 2.3755105, 3.2638297, 4.527219, 4.579206, 3.254767, 3.8011024, 2.5814216,
            1.0938886, 1.910778, 1.930788, 2.410945, 3.2259104, 3.4685845, 3.0332742, 2.7103,
            1.864042, 1.1255411, 1.4038651, 1.586612, 1.5876663, 2.278865, 2.6251483, 2.2506156,
            2.1674075, 1.8359435, 1.09393,
        ],
    )
    .unwrap();
    let current_output33: Array3<f32> = conv_layer33.transposed_convolve(&test_input33);

    assert!(
        arr_allclose(&current_output33, &target_output33),
        "{:?} was not equal to {:?}",
        current_output33,
        target_output33
    );

    let test_input34 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.09975351, 0.6575368, 0.01221572, 0.5690517, 0.8633032, 0.5916843, 0.7327984,
            0.38392547, 0.45234743, 0.88714564, 0.48625886, 0.4974664, 0.280569, 0.3272779,
            0.7308698, 0.16297498, 0.8690239, 0.5834708, 0.33016786, 0.2406453,
        ],
    )
    .unwrap();

    let kernel34: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.599151, 0.8538999, 0.30761606, 0.3641591, 0.11430372, 0.45364544, 0.6984523,
            0.7053654, 0.4003387, 0.38632825, 0.91106904, 0.5180514, 0.1837249, 0.38816592,
            0.16589011, 0.91154295,
        ],
    )
    .unwrap();
    let conv_layer34 = TransposedConvolutionLayer::new(
        kernel34,
        Some(Array::from_shape_vec((1,), vec![0.93466866]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output34: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.9944361, 1.413812, 1.5341442, 1.5246426, 2.1810365, 1.851341, 1.40746, 1.2490484,
            1.3005791, 1.9993763, 2.341804, 2.5746217, 3.0665812, 2.768867, 2.3766608, 1.866675,
            1.3335781, 2.3018942, 2.816515, 3.7387605, 3.9283724, 3.609099, 3.2987032, 2.273819,
            1.3430978, 2.5534396, 3.9237127, 4.425389, 4.8758187, 3.6066265, 3.5747752, 2.784357,
            1.2566726, 1.8592497, 2.7100825, 3.7966166, 4.1350665, 3.1812449, 2.7305593, 2.2917109,
            1.0892518, 1.6256804, 1.9777772, 2.863236, 2.9016654, 2.224452, 1.744529, 1.7255545,
            0.96461123, 1.1575913, 1.4062282, 1.5145334, 1.9959859, 1.6147093, 1.2755516,
            1.1540272,
        ],
    )
    .unwrap();
    let current_output34: Array3<f32> = conv_layer34.transposed_convolve(&test_input34);

    assert!(
        arr_allclose(&current_output34, &target_output34),
        "{:?} was not equal to {:?}",
        current_output34,
        target_output34
    );

    let test_input35 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.9079338, 0.6218017, 0.7199313, 0.5790186, 0.5812801, 0.5897581, 0.00632351,
            0.51240736, 0.3697457, 0.13892107, 0.9900367, 0.47229373, 0.56468743, 0.59834725,
            0.6383385, 0.03793695, 0.9450343, 0.96132326, 0.6061949, 0.63035446,
        ],
    )
    .unwrap();

    let kernel35: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.5111371, 0.03746503, 0.558335, 0.30164844, 0.68653256, 0.99669343, 0.5127781,
            0.25915265, 0.34361982, 0.6647127, 0.42920145, 0.22015804, 0.22396304, 0.553291,
            0.21043801, 0.03016802,
        ],
    )
    .unwrap();
    let conv_layer35 = TransposedConvolutionLayer::new(
        kernel35,
        Some(Array::from_shape_vec((1,), vec![0.13123624]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output35: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.5953149, 0.48307794, 1.0294468, 1.0752168, 1.0395714, 0.6934665, 0.63044536,
            0.30657846, 1.0560097, 1.4883823, 2.3022368, 2.1900601, 2.0105772, 1.5602878,
            0.76845586, 0.32378185, 1.3541529, 1.8190626, 2.7012265, 3.0854833, 2.696481,
            1.9138163, 1.2121515, 0.4877653, 1.2363158, 2.9625125, 3.1750097, 3.7750094, 3.8801572,
            2.7017138, 1.4292511, 0.53492945, 0.6295615, 1.9659481, 2.927848, 3.387053, 3.2131693,
            2.295054, 1.0576607, 0.43932062, 0.36600375, 1.1347407, 1.7021512, 1.9682031,
            1.9785465, 1.5182011, 0.68762565, 0.28927124, 0.13973272, 0.36387917, 0.8773995,
            0.99890864, 0.8386233, 0.6365734, 0.28217447, 0.15025279,
        ],
    )
    .unwrap();
    let current_output35: Array3<f32> = conv_layer35.transposed_convolve(&test_input35);

    assert!(
        arr_allclose(&current_output35, &target_output35),
        "{:?} was not equal to {:?}",
        current_output35,
        target_output35
    );

    let test_input36 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.4177692, 0.15363416, 0.26550946, 0.9799374, 0.6468661, 0.22700246, 0.28266105,
            0.7568015, 0.49555436, 0.7577122, 0.20788053, 0.91674453, 0.56273526, 0.45675126,
            0.48490578, 0.82385767, 0.42006218, 0.8251126, 0.35886785, 0.09741933,
        ],
    )
    .unwrap();

    let kernel36: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.50827706, 0.09494945, 0.9338919, 0.41674572, 0.12654002, 0.47637334, 0.72644436,
            0.22123201, 0.29542014, 0.46568522, 0.6850643, 0.6808416, 0.3779981, 0.805789,
            0.2891591, 0.6993045,
        ],
    )
    .unwrap();
    let conv_layer36 = TransposedConvolutionLayer::new(
        kernel36,
        Some(Array::from_shape_vec((1,), vec![0.33186397]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output36: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.5442065, 0.44961965, 0.8715551, 1.1727349, 1.0656792, 1.4190891, 1.3443516,
            0.60144264, 0.5001086, 0.7155428, 1.365634, 1.4686916, 2.3641498, 2.260755, 1.9327112,
            0.7907448, 0.5896672, 1.2014037, 1.730575, 3.0418313, 3.4074702, 3.0806806, 2.745458,
            1.14199, 1.0018942, 1.4225532, 3.0751405, 4.1340203, 4.635502, 3.9052868, 2.7545023,
            1.4479781, 0.5833335, 1.4348756, 2.5499105, 3.4619246, 3.675325, 3.0264466, 1.6908365,
            1.2134318, 0.6538266, 1.3536527, 2.347157, 2.7073636, 2.7341561, 2.101178, 1.1025578,
            0.7372879, 0.6432806, 1.1545022, 1.2204624, 1.8299742, 1.1902002, 1.0911382, 0.6109916,
            0.39998975,
        ],
    )
    .unwrap();
    let current_output36: Array3<f32> = conv_layer36.transposed_convolve(&test_input36);

    assert!(
        arr_allclose(&current_output36, &target_output36),
        "{:?} was not equal to {:?}",
        current_output36,
        target_output36
    );

    let test_input37 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9734199, 0.9644196, 0.09362596, 0.0414281, 0.27610767, 0.43870836, 0.34610718,
            0.3848816, 0.24301769,
        ],
    )
    .unwrap();

    let kernel37: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.23232727, 0.32100558, 0.22719596, 0.85453415, 0.76819396, 0.8545096, 0.653471,
            0.6439924, 0.61992764, 0.5419032, 0.42076096, 0.7094996, 0.8802664, 0.30416232,
            0.00992903, 0.07512625, 0.21167818, 0.9575676,
        ],
    )
    .unwrap();
    let conv_layer37 = TransposedConvolutionLayer::new(
        kernel37,
        Some(Array::from_shape_vec((2,), vec![0.33277866, 0.5804159]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output37: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            0.55893064, 0.8693129, 0.88527167, 0.58194536, 0.3540501, 1.1742241, 1.9821295,
            2.1854115, 1.4323658, 0.5124557, 1.0846922, 2.058163, 2.4995284, 1.7293468, 0.82091314,
            0.65561116, 1.1346583, 1.6220381, 1.3020401, 0.812407, 0.55894965, 0.807178,
            0.95400596, 0.7278789, 0.48343205, 1.1079153, 1.512615, 1.7275834, 1.3040653,
            0.6468435, 1.4597348, 1.8924949, 1.349143, 0.9989588, 0.89260894, 0.8775697, 1.468767,
            2.733483, 2.035237, 0.846846, 0.8881948, 1.0539994, 1.0459139, 1.0154109, 1.0029217,
            0.60641766, 0.68259394, 1.011565, 1.0004076, 0.8131218,
        ],
    )
    .unwrap();
    let current_output37: Array3<f32> = conv_layer37.transposed_convolve(&test_input37);

    assert!(
        arr_allclose(&current_output37, &target_output37),
        "{:?} was not equal to {:?}",
        current_output37,
        target_output37
    );

    let test_input38 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.14874539, 0.84465176, 0.33960778, 0.03217437, 0.23459853, 0.86872333, 0.05481404,
            0.4075119, 0.13763186,
        ],
    )
    .unwrap();

    let kernel38: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.38947833, 0.19455469, 0.2231027, 0.710135, 0.38075933, 0.36192992, 0.5788371,
            0.45671245, 0.02821646, 0.65663046, 0.6821529, 0.13092387, 0.04243296, 0.40237483,
            0.96532, 0.08922233, 0.65666056, 0.07955468,
        ],
    )
    .unwrap();
    let conv_layer38 = TransposedConvolutionLayer::new(
        kernel38,
        Some(Array::from_shape_vec((2,), vec![0.30693734, 0.61528814]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output38: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            0.36487043, 0.66485, 0.63672364, 0.5614537, 0.38270473, 0.42509785, 1.0610211,
            1.3147185, 0.96330464, 0.62366605, 0.43723372, 1.2120156, 1.7564734, 1.0192502,
            0.6616429, 0.36448643, 0.76768553, 1.1905785, 0.910209, 0.38126272, 0.33866572,
            0.5678546, 0.5742662, 0.38129407, 0.31082082, 0.7129589, 1.2713794, 1.4339409,
            0.95753765, 0.6597509, 0.64272654, 0.886973, 1.8478268, 2.1906137, 1.056855, 0.6659174,
            1.1162024, 1.7499244, 1.6287452, 1.4989209, 0.6204847, 0.6966949, 1.0721346, 1.6531669,
            0.81725794, 0.62017876, 0.6876415, 0.89952564, 0.73808503, 0.6262374,
        ],
    )
    .unwrap();
    let current_output38: Array3<f32> = conv_layer38.transposed_convolve(&test_input38);

    assert!(
        arr_allclose(&current_output38, &target_output38),
        "{:?} was not equal to {:?}",
        current_output38,
        target_output38
    );

    let test_input39 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.8301079, 0.9080613, 0.10633651, 0.95870477, 0.24841434, 0.49642795, 0.02807361,
            0.67816275, 0.14359485,
        ],
    )
    .unwrap();

    let kernel39: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.96717685, 0.970054, 0.53526694, 0.789418, 0.44380167, 0.1696324, 0.22258878,
            0.54548246, 0.33204898, 0.6242531, 0.39491078, 0.95525235, 0.17685722, 0.4390062,
            0.25685027, 0.9619644, 0.7054154, 0.25693816,
        ],
    )
    .unwrap();
    let conv_layer39 = TransposedConvolutionLayer::new(
        kernel39,
        Some(Array::from_shape_vec((2,), vec![0.06693318, 0.71142703]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output39: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            0.86979437, 1.7504386, 1.4949772, 0.65614057, 0.1238516, 1.6494722, 2.3224323,
            1.9289614, 0.882692, 0.35069278, 1.0356768, 2.0265806, 2.3380969, 1.1912062,
            0.26331395, 0.3024919, 1.192997, 1.0503634, 0.5989777, 0.25612992, 0.07318205,
            0.23319826, 0.47814348, 0.3704449, 0.11461371, 1.2296245, 1.6061057, 1.9293737,
            1.6208482, 0.8130052, 1.456712, 1.770123, 2.6658945, 1.4246883, 1.2129536, 1.6970402,
            3.0697634, 2.4949324, 2.006018, 1.003426, 1.6386319, 1.7589405, 1.9408603, 1.3626673,
            0.8758607, 0.7384328, 1.383599, 1.3351598, 0.98696697, 0.748322,
        ],
    )
    .unwrap();
    let current_output39: Array3<f32> = conv_layer39.transposed_convolve(&test_input39);

    assert!(
        arr_allclose(&current_output39, &target_output39),
        "{:?} was not equal to {:?}",
        current_output39,
        target_output39
    );

    let test_input40 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.30001205, 0.24983038, 0.04385825, 0.83179814, 0.9035203, 0.99454165, 0.4820838,
            0.2207663, 0.6613494,
        ],
    )
    .unwrap();

    let kernel40: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.6531026, 0.941437, 0.02962555, 0.00604056, 0.6749602, 0.09254023, 0.16296797,
            0.7694261, 0.49170363, 0.04446485, 0.8114944, 0.29030007, 0.1919063, 0.18254054,
            0.13724734, 0.00911832, 0.20514874, 0.59104544, 0.815183, 0.26495343, 0.62743604,
            0.94401777, 0.54503894, 0.6431647, 0.52856827, 0.51207054, 0.03335644, 0.28076503,
            0.07791043, 0.86478263, 0.980501, 0.54355013, 0.03467919, 0.886572, 0.36146563,
            0.13580918, 0.8819829, 0.48148784, 0.09721047, 0.7819647, 0.49357224, 0.6708243,
            0.72222507, 0.366483, 0.37231642, 0.11044633, 0.88196933, 0.7812372, 0.2546282,
            0.8222847,
        ],
    )
    .unwrap();
    let conv_layer40 = TransposedConvolutionLayer::new(
        kernel40,
        Some(Array::from_shape_vec((2,), vec![0.328725, 0.78940445]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output40: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.5246637, 0.7743323, 0.6014565, 0.37922838, 0.53402966, 0.49761552, 0.35832757,
            0.8997377, 1.7739136, 2.1291227, 1.6437056, 1.0950054, 0.97724676, 1.0019512,
            0.9640081, 1.4357574, 2.0277514, 2.3425055, 2.0167117, 1.0532174, 0.8253511, 1.0510724,
            1.4662168, 2.2547896, 1.8585764, 1.7465907, 1.071225, 0.5062504, 0.91575634, 1.2666749,
            2.1349459, 2.4377267, 2.4500105, 1.6901324, 0.7061827, 0.8550209, 1.7817703, 2.5952919,
            2.9541714, 2.5901458, 2.043565, 1.029635, 0.63120174, 0.9223374, 1.2148412, 1.3834361,
            1.0859895, 0.87077165, 0.67829335, 0.9430318, 0.92734253, 0.9044293, 0.8843851,
            1.0806279, 1.0088705, 0.8273323, 1.509506, 1.6878469, 1.7515606, 1.4395468, 2.189813,
            1.7774268, 1.66532, 1.8925886, 2.5550942, 3.1366367, 2.4085097, 2.82538, 2.4397917,
            1.7551162, 1.5231316, 2.4488056, 3.3129478, 3.2968054, 2.6343832, 2.367828, 1.8224852,
            1.2985635, 2.5407135, 3.4633453, 3.4606605, 3.209942, 1.9438033, 1.7129045, 1.1192167,
            2.055173, 3.1686487, 3.3639903, 3.218452, 2.110162, 1.8534319, 0.84264886, 1.2389704,
            1.433779, 1.6679174, 1.7586987, 1.1393354, 1.3332219,
        ],
    )
    .unwrap();
    let current_output40: Array3<f32> = conv_layer40.transposed_convolve(&test_input40);

    assert!(
        arr_allclose(&current_output40, &target_output40),
        "{:?} was not equal to {:?}",
        current_output40,
        target_output40
    );

    let test_input41 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.46583235, 0.3009351, 0.90517753, 0.7002328, 0.750793, 0.75040495, 0.53337294,
            0.51972127, 0.72387767,
        ],
    )
    .unwrap();

    let kernel41: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.9831707, 0.20632543, 0.16955712, 0.76152086, 0.05444199, 0.2814817, 0.15761587,
            0.95890856, 0.90069485, 0.01261302, 0.21181779, 0.78206104, 0.92161584, 0.74544144,
            0.8816592, 0.9976662, 0.2966056, 0.2162454, 0.06208929, 0.50320554, 0.6565798,
            0.5351854, 0.10227188, 0.28489798, 0.20003575, 0.1822242, 0.05310873, 0.13790856,
            0.78958035, 0.5917116, 0.38009274, 0.2742251, 0.9041115, 0.99974847, 0.9090851,
            0.4171188, 0.48332873, 0.169661, 0.15740211, 0.04401799, 0.33348852, 0.42292982,
            0.4798304, 0.90991354, 0.54084134, 0.4826352, 0.5674032, 0.6246967, 0.70394504,
            0.12639284,
        ],
    )
    .unwrap();
    let conv_layer41 = TransposedConvolutionLayer::new(
        kernel41,
        Some(Array::from_shape_vec((2,), vec![0.16602974, 0.4649844]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output41: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.6240224, 0.5580134, 1.1970495, 0.7585576, 0.5740382, 0.87172484, 0.21530941,
            0.9856014, 1.2067934, 1.9263568, 1.8322139, 2.0480416, 1.5974379, 0.2183003, 0.9862007,
            1.5368078, 2.932816, 3.6110961, 3.587483, 2.371007, 1.012962, 0.92923146, 1.541447,
            3.447679, 3.4221635, 3.6524587, 2.2535384, 1.2922518, 1.2834623, 2.0968745, 3.1431625,
            2.6850643, 2.5235834, 1.9063315, 1.3629189, 1.1579165, 1.7104492, 2.1238382, 1.2041256,
            1.0539466, 0.8364757, 0.6803968, 0.51623166, 0.7927216, 0.97400945, 0.75854826,
            0.49482328, 0.47622383, 0.31083113, 0.5498703, 0.5445618, 0.7101542, 0.9223708,
            1.1030669, 1.3577616, 1.0005884, 0.76964325, 0.8811117, 1.5859079, 2.1472847, 3.118341,
            2.6802678, 1.7318912, 1.0226387, 1.4160851, 2.4243, 3.1427588, 3.5778491, 2.9325433,
            1.6153373, 1.1151456, 1.7577763, 2.8122253, 3.2179966, 3.3603344, 2.7987058, 1.6456397,
            1.145811, 1.8956512, 2.9110196, 3.331273, 2.9512012, 2.365896, 1.017106, 0.9808152,
            1.6235583, 2.4077306, 2.8935606, 2.6594913, 2.027876, 0.95133317, 0.72240895,
            1.0184577, 1.4424411, 1.5758483, 1.3504581, 1.0402435, 0.55647737,
        ],
    )
    .unwrap();
    let current_output41: Array3<f32> = conv_layer41.transposed_convolve(&test_input41);

    assert!(
        arr_allclose(&current_output41, &target_output41),
        "{:?} was not equal to {:?}",
        current_output41,
        target_output41
    );

    let test_input42 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.36747122, 0.75747913, 0.91581804, 0.02039539, 0.51063865, 0.6296097, 0.55201155,
            0.25472447, 0.48130554,
        ],
    )
    .unwrap();

    let kernel42: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.324559, 0.66492975, 0.01730853, 0.77949584, 0.13672462, 0.73892075, 0.02376527,
            0.8798877, 0.6356067, 0.22369854, 0.584571, 0.96449506, 0.7977554, 0.32541806,
            0.10196066, 0.8232674, 0.8543414, 0.9710584, 0.505133, 0.04858193, 0.16233306,
            0.651015, 0.62667716, 0.04012987, 0.8986551, 0.5988572, 0.7548613, 0.9230523,
            0.8094736, 0.41193417, 0.11411006, 0.29621908, 0.8657136, 0.3099813, 0.7817938,
            0.5514695, 0.9309671, 0.35345063, 0.04673942, 0.2836077, 0.4491099, 0.16020048,
            0.0033604, 0.7036799, 0.09309967, 0.8027366, 0.66168624, 0.75922126, 0.98626304,
            0.41794768,
        ],
    )
    .unwrap();
    let conv_layer42 = TransposedConvolutionLayer::new(
        kernel42,
        Some(Array::from_shape_vec((2,), vec![0.85175455, 0.6952307]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output42: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.97102064, 1.3419437, 1.6590223, 1.7602624, 1.5083002, 1.669197, 0.9769694, 1.1299062,
            1.5994985, 2.414044, 2.2169657, 2.6329598, 2.1638966, 1.1427048, 1.2607985, 2.4765072,
            3.2413054, 3.690886, 3.0317926, 2.1514273, 1.1517811, 1.5740969, 2.308824, 4.3339386,
            4.163041, 3.5209565, 1.9710182, 1.0681095, 1.2508881, 2.3330812, 3.665648, 3.8285308,
            3.1797628, 2.0946608, 1.754421, 1.3095186, 1.6292385, 2.4490762, 2.5198548, 1.9080001,
            1.5914071, 1.4409392, 0.9413643, 1.2524725, 1.4416488, 1.3468738, 1.6596677, 1.0999787,
            1.2842822, 0.9152935, 1.4262424, 2.1546617, 2.3831973, 2.305112, 1.7485927, 1.0724875,
            0.74937683, 1.211714, 2.123573, 2.6993065, 3.0130708, 2.2913115, 1.6705693, 1.2307833,
            2.0886073, 3.2661602, 3.512907, 2.7556996, 2.0417776, 1.6454549, 0.9345032, 1.5874633,
            2.667184, 2.4048612, 2.4449215, 1.932781, 1.3353369, 1.3037906, 2.4334152, 3.2729082,
            2.919577, 2.9931154, 2.5003767, 1.2731131, 0.9595167, 1.3214662, 1.8128297, 1.9860386,
            1.9176459, 1.8920115, 1.0031841, 1.1383506, 1.2649658, 1.6692388, 1.7515248, 1.5425854,
            1.276386, 0.8963913,
        ],
    )
    .unwrap();
    let current_output42: Array3<f32> = conv_layer42.transposed_convolve(&test_input42);

    assert!(
        arr_allclose(&current_output42, &target_output42),
        "{:?} was not equal to {:?}",
        current_output42,
        target_output42
    );

    let test_input43 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.8909816, 0.77955645, 0.25186005, 0.6967979, 0.44887283, 0.443149, 0.75464064,
            0.81323266, 0.85127234,
        ],
    )
    .unwrap();

    let kernel43: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.15431848, 0.56885445, 0.29611066, 0.87579244, 0.9531821, 0.5536974, 0.53754663,
            0.23263316, 0.527793, 0.6797737, 0.74194604, 0.01885639, 0.08134871, 0.6701397,
            0.42471457, 0.93320847,
        ],
    )
    .unwrap();
    let conv_layer43 = TransposedConvolutionLayer::new(
        kernel43,
        Some(Array::from_shape_vec((1,), vec![0.6966494]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output43: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.8341443, 1.3237882, 1.4427993, 1.8510711, 1.4539576, 0.9172265, 1.653446, 2.3986888,
            2.3773592, 2.4576771, 1.5377271, 1.1433469, 1.9475336, 3.0822098, 3.8834994, 3.4977713,
            2.2051454, 1.5500276, 1.8562045, 3.2607255, 4.3413286, 3.759463, 2.515147, 1.1380777,
            1.1516271, 2.14232, 2.891459, 3.0307987, 1.950686, 1.1262517, 0.7580384, 1.2685194,
            1.6313856, 2.3167496, 1.8171127, 1.491064,
        ],
    )
    .unwrap();
    let current_output43: Array3<f32> = conv_layer43.transposed_convolve(&test_input43);

    assert!(
        arr_allclose(&current_output43, &target_output43),
        "{:?} was not equal to {:?}",
        current_output43,
        target_output43
    );

    let test_input44 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.5644708, 0.03809474, 0.09368633, 0.5213245, 0.7867202, 0.5103296, 0.05583452,
            0.7863488, 0.5674216,
        ],
    )
    .unwrap();

    let kernel44: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.06023929, 0.39982173, 0.32429224, 0.11995548, 0.8987073, 0.1602559, 0.33672985,
            0.742261, 0.14132027, 0.06929818, 0.4782574, 0.5697997, 0.11632108, 0.49556065,
            0.47647962, 0.7417032,
        ],
    )
    .unwrap();
    let conv_layer44 = TransposedConvolutionLayer::new(
        kernel44,
        Some(Array::from_shape_vec((1,), vec![0.34966558]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output44: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.3836689, 0.57764804, 0.55359375, 0.4671886, 0.384617, 0.36090377, 0.88836384,
            0.7301897, 1.1443925, 1.3181956, 0.6693561, 0.4804221, 0.9013183, 1.2544354, 1.7624538,
            1.9182386, 1.4503102, 0.84991115, 0.539178, 1.496778, 1.6791298, 1.9387479, 1.8896458,
            1.1311136, 0.41819715, 0.8145219, 1.2086797, 1.811302, 1.8957751, 1.0514953, 0.3561603,
            0.4688039, 0.83195615, 1.0469493, 1.2032678, 0.770524,
        ],
    )
    .unwrap();
    let current_output44: Array3<f32> = conv_layer44.transposed_convolve(&test_input44);

    assert!(
        arr_allclose(&current_output44, &target_output44),
        "{:?} was not equal to {:?}",
        current_output44,
        target_output44
    );

    let test_input45 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.47131556, 0.9838283, 0.6777289, 0.90295655, 0.67075133, 0.0573609, 0.8237337,
            0.36602104, 0.15022676,
        ],
    )
    .unwrap();

    let kernel45: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.66375136, 0.17951131, 0.7120909, 0.48833874, 0.85454535, 0.18296848, 0.10698621,
            0.61914563, 0.5212063, 0.922373, 0.6521379, 0.45965454, 0.3666493, 0.99957263,
            0.63527644, 0.17045999,
        ],
    )
    .unwrap();
    let conv_layer45 = TransposedConvolutionLayer::new(
        kernel45,
        Some(Array::from_shape_vec((1,), vec![0.32906872]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output45: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.64190507, 1.0666926, 1.2911401, 1.3814654, 1.2921147, 0.66003, 1.3311679, 1.8633335,
            1.9401207, 1.7790225, 1.3791094, 0.77669317, 1.8930931, 2.4057913, 2.9174638,
            3.1436083, 1.9304094, 0.7494662, 1.6764207, 2.8068643, 3.3812869, 3.1938868, 1.5157309,
            0.56397283, 1.0894723, 2.428132, 2.5472865, 1.7223296, 0.7460568, 0.40789887,
            0.6310901, 1.2866517, 1.2733126, 0.85216945, 0.4868962, 0.35467637,
        ],
    )
    .unwrap();
    let current_output45: Array3<f32> = conv_layer45.transposed_convolve(&test_input45);

    assert!(
        arr_allclose(&current_output45, &target_output45),
        "{:?} was not equal to {:?}",
        current_output45,
        target_output45
    );

    let test_input46 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.39238515, 0.8330784, 0.24240606, 0.16471672, 0.39931872, 0.18019378, 0.04206449,
            0.4967664, 0.8137173, 0.2356948, 0.4160782, 0.9648439,
        ],
    )
    .unwrap();

    let kernel46: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.08041501, 0.65951824, 0.8111227, 0.5044555, 0.5347742, 0.6593625, 0.2873256,
            0.93752426, 0.7753997, 0.7233747, 0.5849598, 0.73156756, 0.514743, 0.9262702,
            0.2988856, 0.6292863, 0.3348592, 0.68505603, 0.09462127, 0.39446756, 0.7353366,
            0.06431016, 0.30438656, 0.65234166, 0.58759433, 0.62632954, 0.4344534, 0.21980144,
            0.00100083, 0.6921164, 0.8472264, 0.3598078, 0.8860002, 0.3531883, 0.25727805,
            0.25435162, 0.7503538, 0.4171089, 0.7314984, 0.4653744, 0.71255463, 0.95627284,
            0.9875905, 0.22617352, 0.7417731, 0.37862286, 0.5094745, 0.18060002, 0.9620671,
            0.49016726, 0.45882288, 0.75507283, 0.45673513, 0.9690947, 0.10567724, 0.2728893,
            0.70271283, 0.8472397, 0.55496895, 0.91851914, 0.9672113, 0.64802116, 0.21997769,
            0.3842727, 0.94689554, 0.74909705, 0.3282922, 0.2643334, 0.3491095, 0.3052412,
            0.5038705, 0.37622157, 0.04119791, 0.7131295, 0.14328648, 0.13365868, 0.36297327,
            0.68727154, 0.93408334, 0.21441843, 0.91439056, 0.40976977, 0.9953925, 0.3781238,
            0.28116077, 0.97598535, 0.36442432, 0.14792818, 0.83921397, 0.625257, 0.09807894,
            0.3419448, 0.9480976, 0.12152596, 0.29696485, 0.41873357,
        ],
    )
    .unwrap();
    let conv_layer46 = TransposedConvolutionLayer::new(
        kernel46,
        Some(Array::from_shape_vec((2,), vec![0.95614773, 0.47523478]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output46: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            2.112003, 2.4153428, 2.4339242, 2.270214, 1.4845333, 2.2004368, 4.1462107, 3.8182902,
            3.1270537, 2.374196, 1.8849156, 4.0882654, 3.5600514, 3.4415689, 2.386462, 1.9847631,
            3.7118106, 4.5640297, 2.9782872, 1.9252894, 1.2631521, 2.286054, 2.442451, 2.409068,
            1.3563981, 1.7348554, 1.9410498, 2.2611585, 1.6353314, 1.0290384, 1.677037, 4.2152853,
            2.5997443, 2.8076828, 1.9076259, 1.9837346, 3.4637623, 3.4324844, 2.3769696, 1.290194,
            2.1545107, 3.2062485, 3.1559498, 2.6021101, 1.7653375, 0.91064537, 2.11624, 1.3665932,
            1.2881991, 1.1294074,
        ],
    )
    .unwrap();
    let current_output46: Array3<f32> = conv_layer46.transposed_convolve(&test_input46);

    assert!(
        arr_allclose(&current_output46, &target_output46),
        "{:?} was not equal to {:?}",
        current_output46,
        target_output46
    );

    let test_input47 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.25687808, 0.7602087, 0.78506595, 0.43647116, 0.97631705, 0.26839125, 0.08090039,
            0.48662946, 0.70590997, 0.99664134, 0.77797663, 0.2436962,
        ],
    )
    .unwrap();

    let kernel47: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.6407154, 0.34835714, 0.8761795, 0.19121103, 0.5305259, 0.6565131, 0.5287279,
            0.29444507, 0.775589, 0.24550702, 0.9532204, 0.8754091, 0.341333, 0.6382999, 0.5125449,
            0.5005919, 0.937352, 0.6224484, 0.14624618, 0.8417525, 0.9414587, 0.44898897,
            0.6993321, 0.36183158, 0.24969168, 0.9671642, 0.20102102, 0.799053, 0.29777643,
            0.05473179, 0.82243276, 0.49220118, 0.959262, 0.60974807, 0.82510734, 0.77621484,
            0.31383017, 0.20135997, 0.40562743, 0.25492424, 0.5874371, 0.69954115, 0.11803117,
            0.95850575, 0.9031762, 0.8240507, 0.7735656, 0.5868046, 0.50450677, 0.31319898,
            0.23300357, 0.8095447, 0.34135282, 0.24274388, 0.6729072, 0.57593447, 0.8085596,
            0.7018395, 0.76145005, 0.58241343, 0.3309161, 0.67546684, 0.32411024, 0.3949699,
            0.412044, 0.8408538, 0.76511306, 0.8994237, 0.8364367, 0.38108206, 0.69459295,
            0.8441607, 0.40802577, 0.95296425, 0.72987187, 0.07076582, 0.8826578, 0.44925806,
            0.8213124, 0.6112075, 0.96117723, 0.3876701, 0.88056743, 0.9483631, 0.8974017,
            0.4120727, 0.27696642, 0.69025475, 0.42224765, 0.96611446, 0.04551166, 0.40275672,
            0.19091433, 0.4437527, 0.31289253, 0.2396215,
        ],
    )
    .unwrap();
    let conv_layer47 = TransposedConvolutionLayer::new(
        kernel47,
        Some(Array::from_shape_vec((2,), vec![0.6389319, 0.85605]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output47: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            2.0309277, 3.0724869, 3.4761753, 3.7308679, 1.8890243, 2.5732281, 4.418193, 4.597556,
            4.645471, 2.45289, 2.7923331, 4.6278896, 4.3040876, 4.8392644, 2.0904975, 3.2053227,
            5.0206866, 5.2652903, 4.6589103, 2.6519074, 1.6666553, 2.3598123, 2.5319462, 2.3552089,
            1.2919312, 2.2678983, 3.4013224, 2.6863227, 3.5834327, 2.65841, 3.589115, 4.9054446,
            4.042632, 4.842764, 2.9660912, 3.47255, 4.787791, 4.803167, 3.8846302, 2.627624,
            1.9803257, 4.5213227, 3.5237195, 4.0184402, 2.3053823, 1.2651223, 1.6364223, 2.2320895,
            2.053774, 1.3214805,
        ],
    )
    .unwrap();
    let current_output47: Array3<f32> = conv_layer47.transposed_convolve(&test_input47);

    assert!(
        arr_allclose(&current_output47, &target_output47),
        "{:?} was not equal to {:?}",
        current_output47,
        target_output47
    );

    let test_input48 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.27247688, 0.19161025, 0.50402254, 0.5852498, 0.97299683, 0.594723, 0.38096267,
            0.29591832, 0.28942943, 0.4529504, 0.19683413, 0.1757779,
        ],
    )
    .unwrap();

    let kernel48: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.88774997, 0.5229589, 0.7137983, 0.82603574, 0.8461087, 0.9091735, 0.80568945,
            0.79286724, 0.3410004, 0.32917508, 0.17503856, 0.7846004, 0.7272445, 0.48829708,
            0.9584728, 0.7469263, 0.66009414, 0.59341496, 0.42636782, 0.9874962, 0.85196227,
            0.43363968, 0.02657376, 0.11542477, 0.13354255, 0.5618466, 0.070237, 0.35689688,
            0.27853093, 0.8144841, 0.99201185, 0.6685596, 0.5670808, 0.68718493, 0.73198694,
            0.84016347, 0.55920875, 0.27009216, 0.10123584, 0.2636, 0.9657689, 0.005051, 0.5576874,
            0.9025137, 0.55897933, 0.35369453, 0.9429427, 0.5162179, 0.5906877, 0.05157892,
            0.76241785, 0.07249359, 0.45541912, 0.01278013, 0.4782056, 0.76319754, 0.5541978,
            0.04795831, 0.5815242, 0.27330735, 0.8815459, 0.29006037, 0.23429064, 0.18781203,
            0.94584274, 0.4523076, 0.29750833, 0.17197818, 0.06818328, 0.6987018, 0.6090657,
            0.24505253, 0.8169458, 0.03939039, 0.5665328, 0.8011893, 0.75747067, 0.1555473,
            0.18986696, 0.13435428, 0.38600448, 0.19166702, 0.46490034, 0.18260308, 0.82895696,
            0.03558233, 0.14173116, 0.8877225, 0.12655611, 0.4754852, 0.7843472, 0.8912908,
            0.15408872, 0.45979473, 0.18853948, 0.826404,
        ],
    )
    .unwrap();
    let conv_layer48 = TransposedConvolutionLayer::new(
        kernel48,
        Some(Array::from_shape_vec((2,), vec![0.8497178, 0.36331993]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output48: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            1.9171317, 2.7275298, 2.5563018, 2.6489024, 1.5855569, 2.4937623, 3.5560791, 3.2814553,
            3.340542, 2.0316918, 2.771687, 3.3367834, 2.987303, 3.952181, 2.4848044, 2.5115912,
            2.9913626, 3.0709438, 3.6888826, 2.227788, 1.5783117, 1.9853704, 2.14719, 2.3226452,
            1.4632311, 1.2296386, 1.2832892, 1.5870764, 1.5014772, 0.6783581, 1.9122169, 2.2992167,
            1.9767916, 2.8661256, 1.8729036, 1.7416418, 2.1227255, 2.0141346, 2.404669, 1.447396,
            1.6449001, 2.3074377, 2.2909048, 2.192731, 1.4238586, 0.8698718, 1.4258049, 1.6330159,
            1.6175497, 0.95543486,
        ],
    )
    .unwrap();
    let current_output48: Array3<f32> = conv_layer48.transposed_convolve(&test_input48);

    assert!(
        arr_allclose(&current_output48, &target_output48),
        "{:?} was not equal to {:?}",
        current_output48,
        target_output48
    );

    let test_input49 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.98673576, 0.43612492, 0.03541405, 0.783278, 0.24658875, 0.74658084, 0.34663445,
            0.03917093, 0.3931895, 0.30789322, 0.68702215, 0.44194368,
        ],
    )
    .unwrap();

    let kernel49: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.33855647, 0.9119313, 0.31810585, 0.16017109, 0.00698695, 0.293519, 0.14280626,
            0.48469457, 0.1767692, 0.42322084, 0.46112144, 0.9255381, 0.5532242, 0.9853486,
            0.24325794, 0.63504064, 0.15406865, 0.11709648, 0.1119092, 0.21574858, 0.62332,
            0.8729103, 0.52609015, 0.06899712, 0.6168495, 0.3181057, 0.10088859, 0.28579375,
            0.08647749, 0.8464018, 0.5181164, 0.47873196, 0.83375126, 0.9057766, 0.00922728,
            0.36432305, 0.53910846, 0.47707382, 0.23459193, 0.6104503, 0.99977493, 0.2879088,
            0.9237121, 0.24345838, 0.00414109, 0.03638967, 0.30595168, 0.16491044, 0.7087876,
            0.79154646, 0.6065011, 0.46475387, 0.6585233, 0.93920064, 0.09687401, 0.5544905,
            0.56360936, 0.10987341, 0.79093266, 0.6827511, 0.93982804, 0.14053226, 0.49555323,
            0.4556152, 0.66896224, 0.46089745, 0.33559954, 0.3038908, 0.7388162, 0.5641086,
            0.07862057, 0.46463865, 0.07132971, 0.5696929, 0.89171886, 0.97521317, 0.86021405,
            0.61829454, 0.4099887, 0.3409378, 0.49427044, 0.10122171, 0.23691536, 0.70967704,
            0.4641384, 0.8326181, 0.38735756, 0.9489551, 0.07998312, 0.5111061, 0.02956773,
            0.17711017, 0.11328588, 0.74999446, 0.8589006, 0.07875007, 0.73433584, 0.4188041,
            0.48477763, 0.00624699, 0.6286288, 0.21567076, 0.81573004, 0.70090973, 0.8734742,
            0.6482149, 0.5717835, 0.16271727, 0.53025377, 0.0984337, 0.82271063, 0.12299971,
            0.06295575, 0.7953895, 0.5933358, 0.27819812, 0.70772564, 0.8846656, 0.33805057,
            0.66772455, 0.9335431, 0.0900248, 0.08626243, 0.0064692, 0.9791513, 0.52760124,
            0.61633664, 0.9759571, 0.5431996, 0.11189567, 0.662313, 0.47249612, 0.88115114,
            0.93577164, 0.61019063, 0.4513792, 0.21412608, 0.21063799, 0.59758914, 0.26163143,
            0.57292384, 0.3575447, 0.41482434, 0.5686212, 0.43116546, 0.8888871, 0.5989078,
            0.96428144, 0.67385226, 0.18009396, 0.650084, 0.1288117, 0.6034601, 0.23165825,
            0.01380609, 0.45430455, 0.3510245, 0.375879, 0.7931324, 0.20369534, 0.9617992,
            0.17212614, 0.8661392, 0.818001, 0.04731771, 0.6331485, 0.83272296, 0.58803684,
            0.6773803, 0.966571, 0.59957683, 0.85136724, 0.03105091, 0.388052, 0.55736136,
            0.02805966, 0.80824125, 0.57193863, 0.9242484, 0.43400672, 0.95459735, 0.19825369,
            0.3165235, 0.34878272, 0.04700416, 0.89200944, 0.8226108, 0.49845085, 0.02590412,
            0.3321073, 0.9764468, 0.5381227, 0.92109436, 0.7710321, 0.8660679, 0.3895538, 0.854895,
            0.07690383, 0.03470363, 0.623576, 0.7447061, 0.23551573, 0.09116793, 0.13018292,
            0.29478395, 0.694041, 0.0967541, 0.8266735, 0.00767931, 0.24422543, 0.47754803,
            0.05508777, 0.30187264, 0.58673537, 0.38990366, 0.6169217,
        ],
    )
    .unwrap();
    let conv_layer49 = TransposedConvolutionLayer::new(
        kernel49,
        Some(Array::from_shape_vec((2,), vec![0.5919785, 0.35687554]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output49: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            1.113163, 2.315454, 2.457957, 2.3585207, 2.1707692, 1.9576209, 1.237046, 1.4225305,
            3.0724745, 3.492422, 3.3125145, 2.7935014, 2.9265184, 1.9990549, 1.9841306, 3.2522922,
            3.4485762, 2.8059182, 2.7358236, 2.2917323, 2.031155, 1.471891, 2.6961162, 3.3900673,
            3.305794, 4.10444, 2.8861997, 1.0497253, 2.2573328, 3.5176249, 2.4271128, 3.0402584,
            3.1173465, 3.3969817, 1.5586176, 2.2652876, 3.8865955, 3.96484, 4.095241, 3.003213,
            2.3551333, 1.8488913, 1.2760068, 1.5552738, 1.8943973, 2.2861547, 2.413115, 1.3975468,
            1.075525, 1.3949254, 1.8547553, 1.2582741, 1.9406836, 1.8428446, 1.6853288, 1.3509059,
            2.5968127, 3.0129347, 1.9891098, 1.9394068, 2.6312895, 3.2873688, 1.7438785, 2.4521623,
            4.3107815, 2.6520967, 2.1443205, 2.9204936, 4.0168076, 1.5772055, 1.5996028, 3.490705,
            4.1128874, 2.613647, 3.0269594, 3.2667117, 1.8377883, 1.8583418, 3.0593853, 3.4759893,
            2.9406023, 2.3777623, 2.376761, 1.4011636, 1.5643927, 3.1895657, 2.4396787, 3.2706199,
            2.2267475, 2.4550605, 1.6511793, 0.9039915, 0.9934997, 1.0616534, 1.6384416, 1.4864879,
            1.2444191, 1.0157349,
        ],
    )
    .unwrap();
    let current_output49: Array3<f32> = conv_layer49.transposed_convolve(&test_input49);

    assert!(
        arr_allclose(&current_output49, &target_output49),
        "{:?} was not equal to {:?}",
        current_output49,
        target_output49
    );

    let test_input50 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.9651153, 0.31502706, 0.15851368, 0.90410787, 0.24201743, 0.99100995, 0.46153438,
            0.5230941, 0.05274187, 0.85842836, 0.8584512, 0.30464408,
        ],
    )
    .unwrap();

    let kernel50: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.00721753, 0.18392335, 0.8556412, 0.1809689, 0.5768042, 0.3628767, 0.69780505,
            0.11757887, 0.08762363, 0.36607084, 0.24363868, 0.7472844, 0.08178072, 0.8810783,
            0.3569205, 0.451316, 0.0383365, 0.8465622, 0.9883213, 0.56150496, 0.52739674,
            0.47732064, 0.43933925, 0.21088907, 0.5524299, 0.8005311, 0.17473145, 0.40513718,
            0.82864845, 0.4856008, 0.41349155, 0.8595507, 0.77320266, 0.9890798, 0.24298015,
            0.27266598, 0.4846638, 0.87975013, 0.4469587, 0.10110632, 0.5594282, 0.9304254,
            0.09035328, 0.76902574, 0.2852155, 0.07585676, 0.24124639, 0.06790887, 0.14329627,
            0.6381789, 0.9543389, 0.6581925, 0.1983508, 0.44280005, 0.15768081, 0.7742759,
            0.90144795, 0.8614371, 0.28797778, 0.37103122, 0.0877872, 0.45872805, 0.76575243,
            0.6829663, 0.2304093, 0.5233105, 0.6974145, 0.8921432, 0.22412036, 0.0491925,
            0.5368815, 0.19189753, 0.45287937, 0.6024187, 0.37045264, 0.23233427, 0.42484194,
            0.98901117, 0.36564678, 0.8630159, 0.8116843, 0.39872772, 0.6879206, 0.7998495,
            0.594579, 0.7541534, 0.80124223, 0.59222096, 0.05390601, 0.82877624, 0.29753333,
            0.82358676, 0.29054287, 0.26042402, 0.88391197, 0.8143526, 0.579024, 0.05703124,
            0.6139959, 0.10031959, 0.78280455, 0.24171719, 0.4721017, 0.53194064, 0.6437402,
            0.09277638, 0.8693754, 0.60042983, 0.8875286, 0.86002535, 0.69702214, 0.12023476,
            0.9464669, 0.9782188, 0.38164645, 0.7172452, 0.9105007, 0.41190186, 0.29969904,
            0.43725935, 0.7022435, 0.7566894, 0.5551452, 0.88240683, 0.10910437, 0.51675713,
            0.33856305, 0.4310923, 0.43717158, 0.2241604, 0.7074267, 0.04574655, 0.62335473,
            0.6056931, 0.19430637, 0.9464095, 0.43765876, 0.47719213, 0.45312902, 0.417855,
            0.8179389, 0.03511541, 0.5549018, 0.6715673, 0.61512816, 0.655004, 0.09111205,
            0.49298653, 0.3268639, 0.77552783, 0.77209026, 0.47542888, 0.31814525, 0.52555007,
            0.81072354, 0.00102462, 0.5109687, 0.48937833, 0.122188, 0.22519495, 0.40227205,
            0.84508294, 0.43985215, 0.05504967, 0.02137936, 0.26612982, 0.12310848, 0.00158825,
            0.75761557, 0.88188004, 0.12094665, 0.13906257, 0.9157668, 0.91879827, 0.8513396,
            0.28533912, 0.30878848, 0.12668495, 0.24235713, 0.45707443, 0.7712829, 0.6903243,
            0.09853197, 0.43307763, 0.05488254, 0.70532215, 0.34688666, 0.9355463, 0.38260135,
            0.4838589, 0.17318112, 0.21472165, 0.77769446, 0.356957, 0.22671694, 0.18250434,
            0.41477197, 0.18007399, 0.9827863, 0.58704966, 0.2950183, 0.46143153, 0.19057809,
            0.3653109, 0.93977064, 0.26191843, 0.3693467, 0.1444909, 0.9363978, 0.42698747,
            0.1281546, 0.30951205, 0.1389484, 0.7072368, 0.44510987, 0.68366706,
        ],
    )
    .unwrap();
    let conv_layer50 = TransposedConvolutionLayer::new(
        kernel50,
        Some(Array::from_shape_vec((2,), vec![0.60059834, 0.09438256]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output50: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.7496118, 1.9375727, 2.73807, 1.5723697, 1.9877887, 2.1143978, 2.3607693, 2.141496,
            3.4932861, 3.26458, 3.7374637, 3.0100386, 4.992922, 2.711237, 1.792546, 4.5953493,
            3.9546611, 3.496686, 3.3459785, 3.3891954, 3.5083914, 2.3756728, 3.7769902, 4.0928087,
            2.9279914, 3.0446486, 3.5489223, 2.93179, 1.9854248, 4.531288, 3.1812425, 2.850195,
            3.2166433, 4.306879, 2.3989758, 2.1640067, 4.846296, 3.998957, 3.4768133, 3.310481,
            4.5942545, 2.519276, 1.6148671, 2.1074576, 2.427658, 2.0388193, 2.2297719, 2.0615928,
            1.3004441, 0.8176154, 2.8823159, 2.4216702, 1.1600446, 1.3890226, 2.427602, 1.9623848,
            1.440804, 4.0303755, 4.299045, 2.8554213, 2.115191, 3.020785, 2.301205, 0.9319027,
            3.9639833, 4.5684547, 3.4664156, 2.3292649, 2.0075037, 1.2561071, 1.3947716, 3.6964302,
            3.9444883, 3.8653812, 2.9933183, 2.2642305, 1.295706, 1.4044623, 3.594354, 3.5718176,
            3.5107296, 3.3215654, 3.1295874, 1.5693516, 1.9922545, 3.1204722, 2.8163035, 2.7637064,
            3.6266396, 2.971575, 2.2600694, 0.5240814, 1.6009634, 1.7461581, 1.3983333, 1.0959964,
            1.9329119, 0.8274467,
        ],
    )
    .unwrap();
    let current_output50: Array3<f32> = conv_layer50.transposed_convolve(&test_input50);

    assert!(
        arr_allclose(&current_output50, &target_output50),
        "{:?} was not equal to {:?}",
        current_output50,
        target_output50
    );

    let test_input51 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.36583102, 0.60821444, 0.03161661, 0.8738241, 0.29876906, 0.33316013, 0.562216,
            0.3353904, 0.10716959, 0.9334109, 0.8606402, 0.42792627,
        ],
    )
    .unwrap();

    let kernel51: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.48052302, 0.6958078, 0.4525564, 0.99052715, 0.04395659, 0.71055365, 0.9117777,
            0.93380785, 0.90260816, 0.01515595, 0.88177705, 0.43487665, 0.56912595, 0.05581366,
            0.02638636, 0.50119185, 0.31323937, 0.05636088, 0.31307653, 0.3326902, 0.3734779,
            0.4210294, 0.08686391, 0.3808534, 0.36317897, 0.19031978, 0.46563995, 0.41320488,
            0.94399136, 0.28572702, 0.6142756, 0.8158052, 0.26794037, 0.12281225, 0.32823455,
            0.14740174, 0.70965314, 0.19252698, 0.79887706, 0.02814319, 0.39099365, 0.7551387,
            0.5038018, 0.15413615, 0.82638884, 0.2631662, 0.7053773, 0.6478343, 0.32534242,
            0.6635084, 0.8839653, 0.59479696, 0.68739474, 0.903793, 0.9826564, 0.56865096,
            0.33996934, 0.63317853, 0.7065151, 0.82775307, 0.22001709, 0.37304193, 0.20307006,
            0.59174454, 0.3759951, 0.673529, 0.42676452, 0.6453951, 0.93520576, 0.59322685,
            0.5885291, 0.23145947, 0.15739693, 0.8825847, 0.17851174, 0.5603199, 0.14435844,
            0.10347797, 0.37213182, 0.14642915, 0.21561022, 0.3830422, 0.90021485, 0.32565016,
            0.82000726, 0.72865623, 0.48349917, 0.41356984, 0.03333719, 0.08149401, 0.85722613,
            0.04374503, 0.88704216, 0.09240989, 0.8528545, 0.7946653, 0.54765993, 0.74729836,
            0.72924787, 0.21080038, 0.12833528, 0.06738389, 0.9163098, 0.2233036, 0.09597177,
            0.4226413, 0.73019654, 0.8065446, 0.13412596, 0.9296237, 0.88961375, 0.8097079,
            0.92300737, 0.8407575, 0.5467569, 0.90232325, 0.40697718, 0.7049378, 0.17525117,
            0.60480595, 0.01006908, 0.09306768, 0.04155758, 0.00396548, 0.29594678, 0.24183853,
            0.23543635, 0.10814751, 0.366542, 0.58264214, 0.1795904, 0.47117367, 0.7827338,
            0.22905576, 0.3444951, 0.83183694, 0.12226541, 0.8971257, 0.27640048, 0.37137195,
            0.2710384, 0.27672654, 0.33046693, 0.4244338, 0.8525934, 0.79606473, 0.24516417,
            0.5116681, 0.32966596, 0.36674044, 0.40403318, 0.31310067, 0.7258184, 0.01080465,
            0.05479572, 0.52210695, 0.6023438, 0.20002392, 0.6150934, 0.23236814, 0.28950065,
            0.33898464, 0.5701668, 0.51984864, 0.45874897, 0.78067493, 0.8138102, 0.9551208,
            0.5881804, 0.47504795, 0.19136074, 0.8406687, 0.04588939, 0.30594054, 0.8511978,
            0.8773192, 0.8241661, 0.44152674, 0.38872027, 0.07202522, 0.9640743, 0.5195077,
            0.19128811, 0.25130445, 0.39854062, 0.8797602, 0.7229711, 0.62001854, 0.69522935,
            0.91174835, 0.65982074, 0.10557687, 0.23464549, 0.5982146, 0.28930026, 0.45670658,
            0.47519284, 0.96985734, 0.13737752, 0.33859882, 0.8539295, 0.74257755, 0.9444382,
            0.24404159, 0.7431825, 0.0306461, 0.32723787, 0.8498817, 0.780418, 0.7744034,
            0.47136632, 0.2987932, 0.90784407, 0.6841086, 0.38890767, 0.05255083,
        ],
    )
    .unwrap();
    let conv_layer51 = TransposedConvolutionLayer::new(
        kernel51,
        Some(Array::from_shape_vec((2,), vec![0.16184397, 0.90099066]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output51: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.4760316, 1.9059143, 1.8673091, 1.3100142, 1.5231105, 0.8745492, 0.9708072, 1.4873419,
            3.6772852, 3.1135905, 2.9282246, 2.5448747, 1.985729, 1.8347185, 1.2653667, 3.0787323,
            2.6187856, 2.6416879, 1.7044238, 2.457057, 1.252335, 1.5910106, 2.974218, 2.4956024,
            2.2748058, 2.5050972, 2.4856665, 1.7713977, 1.5039182, 2.7455962, 2.811891, 2.7281816,
            3.5722854, 2.9700546, 1.6516885, 1.57715, 3.6821733, 2.9759812, 2.933039, 2.102376,
            2.4679878, 0.99062854, 1.4290043, 2.2765782, 2.0967748, 1.4023414, 1.3553052,
            1.3800082, 0.5919759, 1.3039958, 2.6810253, 2.3912594, 2.140957, 1.8839555, 2.4400392,
            2.4615614, 2.2536974, 4.510313, 3.7648828, 4.3434415, 3.8060582, 4.5087843, 2.9133697,
            1.9937081, 3.6346684, 3.8166544, 4.335694, 3.6264374, 3.776936, 3.2506554, 1.5634332,
            2.9581826, 3.0916238, 3.8365054, 3.9002821, 4.6443343, 3.0751033, 1.5766499, 3.5640802,
            3.0749002, 3.772916, 4.5916343, 4.0791416, 3.3181336, 2.2768447, 3.0114539, 3.1141963,
            4.4313455, 4.260307, 3.8448439, 2.4530444, 1.4755571, 2.0546699, 2.6806457, 2.9606974,
            2.3440368, 1.9836895, 1.2680844,
        ],
    )
    .unwrap();
    let current_output51: Array3<f32> = conv_layer51.transposed_convolve(&test_input51);

    assert!(
        arr_allclose(&current_output51, &target_output51),
        "{:?} was not equal to {:?}",
        current_output51,
        target_output51
    );
}
