// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array2, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_transpose_stride1_same() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(kernel1, None, 1, Padding::Same);
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            2.129321, 3.6102068, 3.4920175, 2.2759285, 2.961033, 4.6110344, 5.056102, 3.1625488,
            3.655266, 4.6101437, 4.923399, 2.2716956, 2.868677, 5.1868505, 3.7493901, 2.5375302,
            2.5892203, 3.5579548, 2.9167597, 1.5709618,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.14352316, 0.8997107, 0.64410555, 0.04471071, 0.767672, 0.43464628, 0.16569944,
            0.18875164, 0.12285258, 0.2781115, 0.5390728, 0.5066572, 0.97435564, 0.39133722,
            0.7964828, 0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183,
            0.81628793, 0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133,
            0.0067116, 0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715,
            0.7567798, 0.23972042, 0.38848338, 0.00744711, 0.8715701,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.07988323, 0.6283005, 0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194,
            0.34163022, 0.03235205, 0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297,
            0.97700953, 0.18019113, 0.775954, 0.14120784,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(kernel2, None, 1, Padding::Same);
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            2.4801147, 4.948943, 4.248997, 2.9309442, 3.2820787, 4.7746215, 4.7418694, 3.657943,
            2.5235906, 3.742593, 4.055015, 3.8372264, 1.826671, 2.8332467, 3.2692723, 3.3612194,
            1.3899677, 1.5449216, 2.2082677, 2.4120436,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.3426181, 0.5417864, 0.7768226, 0.34603763, 0.6114103, 0.9716041, 0.5157695,
            0.50755495, 0.6659802, 0.629322, 0.60627973, 0.27978492, 0.28792506, 0.7547703,
            0.0509604, 0.10449678, 0.89887625, 0.6572328, 0.695583, 0.3626411, 0.37613922,
            0.9241278, 0.39898983, 0.6908677, 0.5511301, 0.36253917, 0.36786652, 0.88718724,
            0.69587743, 0.4870034, 0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529,
            0.5566727, 0.7035832, 0.92333794, 0.85647196, 0.36252776,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9373231, 0.01684272, 0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754,
            0.31284246, 0.4031665, 0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259,
            0.23846498, 0.82509995, 0.97324103, 0.96826524,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(kernel3, None, 1, Padding::Same);
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            3.0429893, 3.0979333, 3.7195776, 1.8485445, 4.601478, 6.200628, 6.763774, 3.4238458,
            4.4718704, 5.45767, 5.7891073, 3.01157, 5.0805173, 6.34371, 5.842485, 3.0566144,
            3.245428, 4.2877626, 3.7733746, 2.0074868,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.77620417, 0.8427075, 0.42989048, 0.76771307, 0.54514444, 0.7878393, 0.21897991,
            0.975659, 0.73295325, 0.69994044, 0.86701024, 0.76087946, 0.623545, 0.14890751,
            0.8610666, 0.21943341, 0.1644093, 0.6089244, 0.8612485, 0.02602104, 0.30423534,
            0.5087405, 0.16869895, 0.3329467, 0.179494, 0.33126613, 0.11996287, 0.21606164,
            0.87119263, 0.33579683, 0.2313126, 0.2576527, 0.3748985, 0.30113342, 0.8142977,
            0.423247, 0.8179498, 0.92175007, 0.21606776, 0.19149332,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.4240341, 0.14780204, 0.46443272, 0.00207204, 0.359202, 0.9019851, 0.21363449,
            0.6390296, 0.5977058, 0.81350476, 0.3685356, 0.90738845, 0.7828945, 0.9812083,
            0.6726924, 0.46724817, 0.17302093, 0.39839587, 0.78055173, 0.8576361, 0.7335981,
            0.52934057, 0.9529279, 0.78965247, 0.46750203, 0.08403921, 0.73126566, 0.34934825,
            0.3459232, 0.54770446, 0.68714255, 0.29283327, 0.53392637, 0.8850151, 0.6909357,
            0.44388366, 0.9043074, 0.9949724, 0.64743847, 0.36691284, 0.5396585, 0.5372604,
            0.47547424, 0.44373918, 0.34716287, 0.21774843, 0.9437953, 0.51856595, 0.15765554,
            0.9350713,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(kernel4, None, 1, Padding::Same);
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            4.7387366, 6.7601576, 6.741786, 5.0231147, 6.1374135, 8.490736, 9.399002, 6.5965943,
            9.325594, 11.029676, 11.6051235, 8.902636, 6.881201, 9.702231, 10.010415, 7.9663415,
            6.7219944, 7.777974, 7.9563823, 5.7190313,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.86233217, 0.81734437, 0.6566154, 0.3879487, 0.28848994, 0.5814131, 0.06870039,
            0.78543746, 0.47194287, 0.12733267, 0.6111727, 0.25675833, 0.74741316, 0.45714313,
            0.9649919, 0.57969916, 0.5208711, 0.93666834, 0.13247305, 0.7087714, 0.17877895,
            0.40767, 0.6906785, 0.9675369, 0.224454, 0.28950995, 0.75431514, 0.99582964, 0.8120864,
            0.9536324, 0.7703749, 0.683158, 0.16371861, 0.42877796, 0.7300311, 0.9456737,
            0.05700503, 0.19623296, 0.44457257, 0.5512328,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.15101007, 0.25140873, 0.2031063, 0.5537751, 0.3641559, 0.701937, 0.27669305,
            0.85076064, 0.00186597, 0.3316532, 0.15485734, 0.35000807, 0.42372492, 0.03995521,
            0.5067197, 0.38907993, 0.37287286, 0.21294773, 0.8646356, 0.10154326, 0.75313085,
            0.7910046, 0.15368015, 0.25977603, 0.40315583, 0.635939, 0.25689796, 0.13678746,
            0.43744904, 0.6658951, 0.564682, 0.70429957, 0.67241764, 0.15790685, 0.25059524,
            0.6432024, 0.60438925, 0.45131883, 0.96080875, 0.40131757, 0.60942906, 0.7035094,
            0.6473561, 0.05433872, 0.7478619, 0.24740443, 0.35665986, 0.00020906, 0.23741227,
            0.57013196,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(kernel5, None, 1, Padding::Same);
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            3.8259244, 6.053112, 5.5964975, 5.0935526, 6.1928873, 8.423359, 7.7538404, 6.2572675,
            7.4473248, 9.735344, 10.054958, 6.237293, 5.549368, 7.910409, 7.076833, 5.7307,
            3.7213798, 5.5014973, 4.9807963, 4.4879804,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6398819, 0.7132858, 0.90739846, 0.8246988, 0.1319153, 0.6876462, 0.846729,
            0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465, 0.05539654, 0.5554673,
            0.9149804, 0.9791666, 0.9000323, 0.6329186, 0.30872977, 0.30553624, 0.04431259,
            0.5287215, 0.3358437, 0.72178566, 0.72704846, 0.85191244, 0.07464863, 0.867838,
            0.5849202, 0.14913943, 0.18325551, 0.40498126, 0.75359416, 0.01821492, 0.5917236,
            0.91982275, 0.5287654, 0.7151285, 0.38420153, 0.517026,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.5150141, 0.26934662, 0.7356045, 0.97902703, 0.6362754, 0.27803296, 0.32063982,
            0.83432084, 0.78711736, 0.28247103, 0.7812688, 0.5270146, 0.4719829, 0.47535485,
            0.23715672, 0.4404677, 0.90286416, 0.66611385, 0.02649495, 0.3193976, 0.16608049,
            0.5121102, 0.17436478, 0.313714, 0.47244504, 0.9906781, 0.9064671, 0.29454133,
            0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972, 0.53866875, 0.6358971,
            0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548, 0.14977625, 0.53714937,
            0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625, 0.4744624, 0.73655206,
            0.42605233,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(kernel6, None, 1, Padding::Same);
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 5, 4),
        vec![
            4.7064695, 8.149392, 6.9905963, 5.4687176, 7.183258, 10.105035, 8.660454, 7.4568315,
            7.718365, 10.839016, 11.462591, 7.8528314, 6.6298823, 8.712183, 8.973379, 5.9587235,
            4.4787836, 6.578704, 6.2997336, 3.255145,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.6592577, 0.3237799, 0.42867732, 0.87574345, 0.70010746, 0.01496939, 0.78416556,
            0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122, 0.68573385,
            0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448, 0.48578474,
            0.2764571, 0.9192946, 0.8920509,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.34320405, 0.4283556, 0.3897719, 0.06360459, 0.729173, 0.19460331, 0.8634254,
            0.6576018, 0.9657459, 0.22873744, 0.47843248, 0.22157177, 0.9162307, 0.02157675,
            0.44649428, 0.2792192, 0.685827, 0.75294507,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(kernel7, None, 1, Padding::Same);
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            2.3433251, 2.336067, 1.3933153, 3.406716, 5.114383, 2.8975387, 3.8696904, 5.1775703,
            3.6608071, 2.8702347, 3.9038558, 2.945689,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.7919586, 0.22560763, 0.88778716, 0.80092114, 0.00003577, 0.9737877, 0.9146247,
            0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946, 0.17754778,
            0.41998118, 0.02919354, 0.82382417, 0.4156855, 0.49590722, 0.69720376, 0.7155315,
            0.40795937, 0.15397236, 0.02265206,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.7090415, 0.75877124, 0.67035425, 0.39483562, 0.86222315, 0.9993058, 0.84902793,
            0.26427644, 0.86764544, 0.24274233, 0.69865257, 0.5739991, 0.7620597, 0.29289714,
            0.88402116, 0.8942853, 0.7757528, 0.16431308,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(kernel8, None, 1, Padding::Same);
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            1.7450328, 3.6583858, 2.773089, 3.2202752, 5.9523973, 4.003776, 3.0722237, 6.0173364,
            2.9648824, 1.7898118, 3.642166, 1.832456,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.48939565, 0.56055367, 0.46453193, 0.9573795, 0.8899508, 0.16098963, 0.63514715,
            0.810474, 0.29953358, 0.46075395, 0.02808736, 0.59781086, 0.8855644, 0.61877847,
            0.9537467, 0.6197168, 0.3379795, 0.13108306, 0.30692965, 0.33537498, 0.01351478,
            0.45529485, 0.6626128, 0.9497022,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.7403127, 0.06039312, 0.08292098, 0.80679554, 0.1354166, 0.2560622, 0.80891573,
            0.97702754, 0.4124968, 0.4359102, 0.8733311, 0.1396195, 0.52047473, 0.88564533,
            0.29781443, 0.21130918, 0.83071965, 0.3337948,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(kernel9, None, 1, Padding::Same);
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            3.0300868, 2.5753088, 1.4805901, 4.4230227, 3.8491464, 2.2942827, 4.1628747, 4.3581924,
            2.0663955, 2.4351592, 3.5008845, 1.8767245,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.9783562, 0.42070097, 0.55396014, 0.16172563, 0.7634967, 0.36205766, 0.48491392,
            0.4980414, 0.6001484, 0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525,
            0.7446416, 0.471613, 0.72900707, 0.842964, 0.21457537, 0.938401, 0.41665936,
            0.05351101, 0.43856344, 0.7253113,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.8520324, 0.4151233, 0.35101932, 0.7388761, 0.3592986, 0.6741479, 0.9965808,
            0.3117034, 0.8605703, 0.94308543, 0.8192489, 0.31478795, 0.750324, 0.36604244,
            0.78454614, 0.039194, 0.23696694, 0.2418382, 0.24788351, 0.5622223, 0.15428482,
            0.50688076, 0.37682602, 0.44385925, 0.00051633, 0.53422695, 0.5675659, 0.53845215,
            0.2130759, 0.86445093, 0.432881, 0.6255918, 0.3942565, 0.07226853, 0.09869356,
            0.32627374, 0.8543963, 0.85603166, 0.25422713, 0.24929269, 0.36793318, 0.39957172,
            0.9079535, 0.865758, 0.82237726, 0.60374194, 0.7658025, 0.0215734, 0.473204, 0.6594781,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(kernel10, None, 1, Padding::Same);
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            6.358123, 5.4534817, 4.9795165, 6.234275, 7.140948, 6.5452733, 6.444521, 6.6835814,
            6.1061664, 3.9202785, 4.5752883, 4.536955,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.86392707, 0.8566667, 0.48541847, 0.54855824, 0.5860555, 0.158874, 0.10558709,
            0.19664533, 0.39609066, 0.27843866, 0.49128443, 0.75033015, 0.35650545, 0.4687038,
            0.6159849, 0.2547001, 0.17250927, 0.07203952, 0.8724657, 0.14018923, 0.12091745,
            0.4770398, 0.43290496, 0.6356798,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513, 0.06810815,
            0.79673207, 0.29373887, 0.55241185, 0.23906927, 0.18915932, 0.02753429, 0.1438574,
            0.5419741, 0.71984386, 0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492,
            0.62895286, 0.21388301, 0.30016333, 0.49605927, 0.8245107, 0.4528765, 0.6836941,
            0.28745723, 0.5031258, 0.26911622, 0.92149794, 0.7165893, 0.04745785, 0.55642486,
            0.34654748, 0.83168656, 0.8410765, 0.7668131, 0.84094906, 0.6012723, 0.9256995,
            0.66010624, 0.43380973, 0.62281454, 0.45852852, 0.61445725, 0.524579, 0.06486581,
            0.14233574,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(kernel11, None, 1, Padding::Same);
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            3.2689705, 2.9965467, 3.697768, 5.453937, 4.1977415, 5.072977, 5.0462627, 4.5375757,
            4.380199, 3.3067229, 2.7536871, 3.0206835,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.13930365, 0.5838787, 0.45914945, 0.30819193, 0.70949817, 0.8803759, 0.6927248,
            0.50569826, 0.7358748, 0.58652496, 0.85065925, 0.3247378, 0.6760192, 0.4483504,
            0.59195757, 0.37883574, 0.7796499, 0.32748002, 0.44507304, 0.7488422, 0.14428215,
            0.8785777, 0.15468395, 0.6638725,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.30651525, 0.9492515, 0.55669755, 0.08302987, 0.45890567, 0.05946975, 0.9099885,
            0.30235246, 0.24214035, 0.42138377, 0.38782486, 0.21880285, 0.9182205, 0.85290706,
            0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431, 0.2624427, 0.6557088, 0.00633,
            0.6603214, 0.45500925, 0.6523986, 0.14666249, 0.32440838, 0.2805719, 0.42671442,
            0.74477625, 0.9118973, 0.5335283, 0.36968935, 0.5693756, 0.36426732, 0.11819325,
            0.95361024, 0.13343851, 0.5940242, 0.7282295, 0.9320007, 0.46956548, 0.5087874,
            0.7952918, 0.73709416, 0.3358689, 0.03185032, 0.27057356, 0.26166973, 0.5843129,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(kernel12, None, 1, Padding::Same);
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 4, 3),
        vec![
            4.1474743, 5.034623, 4.559716, 6.4944124, 6.5415416, 6.6377025, 6.6090937, 6.04299,
            6.581129, 4.068395, 5.2305527, 5.464061,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.5337139, 0.19571388, 0.1192536, 0.75616854, 0.97167397, 0.71154076, 0.26672947,
            0.07128377, 0.3383284, 0.8008563, 0.9504947, 0.5971434, 0.7847773, 0.92326206,
            0.24163638, 0.12968542, 0.5954836, 0.6734995, 0.08627631, 0.7485715, 0.8782484,
            0.6863155, 0.7264353, 0.08944888, 0.68172634, 0.4284322, 0.48237634, 0.6856524,
            0.04009921, 0.0687674, 0.9063645, 0.42620143, 0.61030614, 0.10040135, 0.50107217,
            0.763057, 0.25769317, 0.8816114, 0.7770131, 0.23345616, 0.62762326, 0.15315741,
            0.73589575, 0.2752067, 0.85641515, 0.7439484, 0.6581306, 0.4056261, 0.13899311,
            0.26460668, 0.9179794, 0.96651816, 0.89336777, 0.18948041, 0.9371178, 0.7124811,
            0.9657549, 0.6203675, 0.32684848, 0.11439406, 0.07654371, 0.95680344, 0.9728639,
            0.6055871, 0.00439729, 0.8525613, 0.3167563, 0.13499211, 0.68338645, 0.7955047,
            0.21689218, 0.2826704,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.12328367, 0.6890043, 0.5906649, 0.41700745, 0.30266365, 0.5716598, 0.12726787,
            0.35587692, 0.16889893, 0.3114892, 0.1309899, 0.24026695, 0.55435276, 0.34375766,
            0.4225387, 0.37165096, 0.6202945, 0.6069533,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(kernel13, None, 1, Padding::Same);
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            1.1951423, 1.984751, 2.0163236, 2.835759, 3.0152307, 2.2727869, 1.9734954, 3.8459177,
            3.7884746, 4.008124, 3.8901417, 3.0901344, 1.9761584, 3.8308418, 4.450101, 4.8263526,
            4.0602293, 2.595211, 2.4673147, 4.104005, 4.5204506, 4.5434194, 3.470886, 1.8036022,
            2.6743417, 4.5944138, 4.5940104, 3.5265627, 2.9766128, 1.67339, 1.3359864, 2.791241,
            2.9437308, 2.5690227, 1.9206154, 1.2689613,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.05756181, 0.0153275, 0.8497578, 0.79796964, 0.4071996, 0.19325097, 0.04944435,
            0.59729165, 0.39304134, 0.679002, 0.6126854, 0.67232877, 0.7156292, 0.09058711,
            0.33372015, 0.8941644, 0.30899736, 0.3348802, 0.6412177, 0.26750943, 0.03709449,
            0.56803024, 0.8756273, 0.5771133, 0.56024176, 0.5868575, 0.75167763, 0.36936092,
            0.37185487, 0.35425207, 0.24336162, 0.01027582, 0.2671537, 0.83992416, 0.49819484,
            0.7831867, 0.70054483, 0.8701863, 0.49413827, 0.84670645, 0.8069649, 0.093459,
            0.93408287, 0.8206956, 0.70209366, 0.32817394, 0.744203, 0.39091238, 0.43911496,
            0.92919487, 0.29325068, 0.62813336, 0.8131431, 0.19520658, 0.47931832, 0.42483747,
            0.47526902, 0.28184402, 0.09741595, 0.45691565, 0.44086096, 0.9638409, 0.33859608,
            0.26381832, 0.29839757, 0.68755937, 0.09156765, 0.58584654, 0.04617033, 0.14705709,
            0.81179595, 0.16751295,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.06864621, 0.6308731, 0.38993102, 0.3644169, 0.68174505, 0.272409, 0.23609333,
            0.21866773, 0.80119157, 0.01742986, 0.49270406, 0.37920174, 0.90869635, 0.8191268,
            0.7636344, 0.7827788, 0.9694966, 0.79533535,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(kernel14, None, 1, Padding::Same);
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            1.9561242, 3.22645, 3.9032784, 3.7926514, 3.1532838, 2.07332, 3.8290508, 5.613692,
            5.213581, 6.2217684, 5.574827, 3.350961, 4.091234, 4.913117, 4.9805703, 5.111314,
            5.000969, 3.6696777, 3.2719898, 4.9563117, 4.41199, 4.2285676, 4.637951, 3.057804,
            3.0429473, 4.4504833, 3.9135225, 3.1984298, 4.1672177, 3.5607905, 2.2199647, 3.0671887,
            3.132947, 3.2497768, 3.2815356, 2.706079,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.00732174, 0.8372113, 0.9449071, 0.7670253, 0.50964797, 0.7843069, 0.7365313,
            0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833, 0.5585159,
            0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028, 0.52249014,
            0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726, 0.25884646,
            0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234, 0.32747796,
            0.9097073, 0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446, 0.9843364,
            0.4038572, 0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686, 0.5288406,
            0.92906404, 0.87780553, 0.9090181, 0.82569945, 0.20383635, 0.7166643, 0.17061436,
            0.91526777, 0.08598401, 0.70100874, 0.40537685, 0.5971982, 0.92796123, 0.15859716,
            0.7859081, 0.8564488, 0.35816404, 0.79062706, 0.9644883, 0.13154314, 0.31929043,
            0.80048305, 0.07180241,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.52815664, 0.45786336, 0.91537887, 0.9783313, 0.25753945, 0.42799363, 0.07738555,
            0.9294206, 0.07022415, 0.60058224, 0.6196278, 0.9008346, 0.04155485, 0.82207745,
            0.41282526, 0.9949608, 0.3109271, 0.47614527,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(kernel15, None, 1, Padding::Same);
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            2.7422843, 4.074735, 4.5409536, 4.696369, 4.4800787, 2.9063168, 2.8736432, 5.9057508,
            6.9055333, 5.6943765, 6.6837454, 3.4170837, 3.8174345, 6.2248445, 6.001985, 6.423986,
            4.5103583, 3.548554, 4.2490883, 5.579898, 6.4580526, 5.4931355, 4.7543325, 3.7004132,
            4.325874, 6.755368, 4.6352544, 5.119625, 4.4170313, 3.3628173, 3.1147776, 3.5595477,
            3.2768075, 2.4558537, 3.6510553, 1.6757619,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.7615821, 0.35893062, 0.07713356, 0.6123928, 0.62511915, 0.88098776, 0.21521498,
            0.89468116, 0.1842307, 0.10784956, 0.8354833, 0.2630701, 0.7184675, 0.06132602,
            0.06056971, 0.71349823, 0.00944792, 0.07349233, 0.35231608, 0.8533961, 0.17608605,
            0.18067755, 0.51991457, 0.19053963, 0.5045173, 0.7456122, 0.27621788, 0.48649722,
            0.39297876, 0.54849166, 0.3746991, 0.8194284, 0.34880427, 0.79505837, 0.41293454,
            0.890512, 0.12076204, 0.20799449, 0.88948244, 0.24437675, 0.7731474, 0.65954226,
            0.4922565, 0.5211581, 0.97382414, 0.9779564, 0.1754263, 0.4551989, 0.81067127,
            0.7095975, 0.5087082, 0.78796804, 0.03310984, 0.20805901, 0.45704818, 0.9133983,
            0.5689028, 0.04247752, 0.55938286, 0.9835293, 0.04525762, 0.7176199, 0.82096803,
            0.5575717, 0.5744108, 0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355,
            0.1134909, 0.5645703,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.30096474, 0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894, 0.681929,
            0.24701218, 0.74485576, 0.61556435, 0.63869125, 0.05875124, 0.3210932, 0.96946657,
            0.09463912, 0.6275637, 0.34162354, 0.74390864, 0.8736778, 0.9513908, 0.24045336,
            0.7003475, 0.87750345, 0.16564246, 0.6314963, 0.21785556, 0.7654987, 0.13988015,
            0.03287261, 0.82226163, 0.60896695, 0.13331373, 0.62307173, 0.23316076, 0.9600204,
            0.55291533, 0.29808274, 0.8765127, 0.98263544, 0.27148733, 0.11101003, 0.2754741,
            0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969,
            0.5836321,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(kernel16, None, 1, Padding::Same);
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            3.9705598, 5.3050566, 7.605779, 7.076497, 5.436322, 5.5418963, 4.9794617, 7.9182315,
            10.010529, 9.220495, 7.237857, 6.230055, 7.5918703, 10.2776, 12.176399, 13.016567,
            10.292295, 6.7530055, 7.7299433, 11.320428, 12.525111, 11.935645, 9.801254, 7.823039,
            6.383092, 8.149623, 10.79394, 9.786787, 7.006672, 6.1559043, 5.0805273, 6.3784103,
            7.1890254, 8.54358, 5.903902, 4.338979,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643, 0.91682273,
            0.6142979, 0.19277428, 0.28408903, 0.25507236, 0.9800453, 0.36125833, 0.96792,
            0.33258557, 0.9508625, 0.8424581, 0.8130291, 0.7774976, 0.17691322, 0.9389267,
            0.22419459, 0.33442205, 0.7614585, 0.37563834, 0.70754576, 0.1499497, 0.9873837,
            0.7166968, 0.40278858, 0.22288306, 0.3279577, 0.07722609, 0.598755, 0.8143903,
            0.87905455, 0.83061284, 0.9923988, 0.6196494, 0.536406, 0.06662867, 0.83588266,
            0.28182983, 0.662181, 0.99850965, 0.60448396, 0.12318801, 0.91713256, 0.8540598,
            0.19103892, 0.5929614, 0.9118344, 0.9381113, 0.3421722, 0.8149188, 0.9595595,
            0.02717085, 0.8916309, 0.9755575, 0.27588442, 0.59208006, 0.00008138, 0.9552037,
            0.12578069, 0.01249961, 0.05413999, 0.5153533, 0.40144867, 0.8698811, 0.6468678,
            0.8840439, 0.34315115,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794, 0.6930413,
            0.90735817, 0.91156703, 0.45996496, 0.9045769, 0.17170428, 0.43418503, 0.69308424,
            0.42869946, 0.9244341, 0.41451567, 0.6224708, 0.00536506, 0.33826837, 0.47926104,
            0.0032256, 0.02230139, 0.35960108, 0.48593593, 0.86064774, 0.28908366, 0.4153976,
            0.3468706, 0.2242362, 0.93169004, 0.3198661, 0.5576108, 0.17364207, 0.69407916,
            0.88076496, 0.11111139, 0.19382912, 0.9307082, 0.9188555, 0.10532705, 0.88550454,
            0.20754221, 0.97926295, 0.3472928, 0.71126235, 0.03633394, 0.7482733, 0.28782296,
            0.7382309,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(kernel17, None, 1, Padding::Same);
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            6.7204432, 8.805362, 10.175813, 11.789903, 7.794962, 6.417556, 8.538196, 11.673905,
            13.938214, 13.380728, 10.501698, 7.1781416, 9.131038, 12.454089, 14.61664, 15.670159,
            11.072683, 9.545144, 7.6567736, 11.929808, 15.11018, 15.10865, 11.172414, 10.217181,
            6.790306, 8.061532, 12.025834, 10.597757, 9.491959, 7.698024, 3.154765, 6.91362,
            7.122584, 8.005591, 5.3014894, 4.733845,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.60003114, 0.3259743, 0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927,
            0.968827, 0.47373444, 0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834,
            0.3979838, 0.2393961, 0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945,
            0.66457146, 0.8425775, 0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123,
            0.48163053, 0.437191, 0.43973154, 0.29997745, 0.21913478, 0.6611514, 0.209788,
            0.176356, 0.88925517, 0.14793599, 0.36509594, 0.5616029, 0.6617385, 0.30053073,
            0.36820948, 0.62227124, 0.4957459, 0.69923055, 0.3227648, 0.9702412, 0.5679234,
            0.13432135, 0.7430913, 0.19231908, 0.26170298, 0.10480803, 0.00958306, 0.20726651,
            0.20851518, 0.17973869, 0.23704103, 0.1163867, 0.2735905, 0.8537909, 0.40303,
            0.75797635, 0.34342998, 0.74670875, 0.82946825, 0.91931367, 0.9654975, 0.18782942,
            0.10021565, 0.05109123,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.3069365, 0.10895161, 0.9891213, 0.62504834, 0.507994, 0.47125, 0.84314245, 0.6054993,
            0.92367506, 0.6953895, 0.37023902, 0.67128026, 0.43450755, 0.28869846, 0.27641538,
            0.8369712, 0.6856483, 0.26890948, 0.65425915, 0.84581685, 0.51146317, 0.48995435,
            0.52071315, 0.80564773, 0.670521, 0.3835857, 0.47078377, 0.5100531, 0.82525116,
            0.02126783, 0.9583153, 0.23316967, 0.9487504, 0.9609589, 0.95734006, 0.00943314,
            0.7521432, 0.46106157, 0.84370506, 0.16933449, 0.71423984, 0.5316646, 0.6400151,
            0.9638914, 0.69432026, 0.8581641, 0.70813745, 0.2836983, 0.33953485, 0.8950543,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(kernel18, None, 1, Padding::Same);
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            4.576749, 7.3510118, 7.732251, 8.465681, 6.0988774, 4.8326044, 6.5381684, 8.163401,
            10.939853, 9.563825, 8.826987, 5.6376505, 7.7155824, 11.67995, 14.7064905, 14.329108,
            11.008777, 7.9822774, 8.647253, 12.466508, 13.966044, 14.880844, 10.26346, 7.625294,
            7.2697296, 8.787803, 11.676642, 9.9921665, 8.374546, 4.7419577, 4.972109, 7.382642,
            8.619491, 8.545452, 6.1494026, 4.324534,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.20262088, 0.81930757, 0.09556881, 0.22266188, 0.63842744, 0.8304186, 0.12425002,
            0.7582065, 0.09737789, 0.84872884, 0.17490041, 0.37569723, 0.6669188, 0.8970669,
            0.22398192, 0.29424527, 0.56277037, 0.41113177, 0.7882464, 0.24159203,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633, 0.9636684, 0.98529965,
            0.26998708, 0.13811645, 0.9724998, 0.41856614, 0.13321315, 0.0937838, 0.4742414,
            0.79873264, 0.1621314, 0.5493846, 0.6481355,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(kernel19, None, 1, Padding::Same);
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            0.94997895, 1.0164421, 1.2813909, 1.3208477, 0.5253867, 1.2508075, 2.2596772,
            1.3920242, 2.6846461, 0.68285376, 1.0363826, 2.0745826, 2.124783, 2.3160646, 1.4363759,
            0.8608186, 1.4055815, 2.2791915, 1.1708186, 0.95466244, 0.6413472, 1.4593375,
            1.1492237, 1.2089542, 0.8488372, 1.0881968, 2.2193813, 2.2891695, 1.7013061, 1.1885908,
            1.2649986, 1.7844094, 2.2269819, 2.2812955, 1.5582577, 0.34932196, 0.96835977,
            1.4737439, 1.6862638, 1.4486442,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.05176858, 0.17029643, 0.955536, 0.089831, 0.05664136, 0.9231865, 0.98567015,
            0.01680515, 0.54690886, 0.8593988, 0.6496963, 0.8382851, 0.2400014, 0.36792266,
            0.01756373, 0.6596718, 0.5680892, 0.19350345, 0.4854058, 0.7869872,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.12335967, 0.14544043, 0.25711668, 0.05608724, 0.18204254, 0.9562488, 0.44598028,
            0.3229758, 0.8930679, 0.24216229, 0.21437034, 0.38366762, 0.64894366, 0.8650639,
            0.7790032, 0.3529938, 0.37360683, 0.26240814,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(kernel20, None, 1, Padding::Same);
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            0.27483612, 0.51689416, 0.6651752, 1.1231388, 0.3618226, 0.5139142, 1.9091319,
            1.7728736, 1.1888504, 0.87510055, 1.0690681, 2.2137527, 2.229632, 1.0898181, 1.3602805,
            0.7356457, 1.7030845, 1.595932, 0.65854263, 0.9416864, 0.5918918, 1.3772991, 1.5317694,
            1.1906348, 0.51303786, 1.859991, 2.4843354, 2.0328515, 1.5234054, 1.3591378, 2.0778565,
            2.4252055, 1.934372, 1.3976136, 1.1213385, 1.4779565, 1.6992863, 1.3644505, 1.2879938,
            1.1620346,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.554433, 0.90017563, 0.6817857, 0.95833224, 0.28551313, 0.85106283, 0.70093375,
            0.4791875, 0.5805011, 0.9803199, 0.97033703, 0.48236644, 0.66855663, 0.35855147,
            0.25242767, 0.6717967, 0.26290378, 0.53677225, 0.18097793, 0.07985484,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.79416144, 0.7215235, 0.42313012, 0.6529702, 0.00384528, 0.08442257, 0.7838985,
            0.980683, 0.36212954, 0.61172485, 0.5263662, 0.8496614, 0.13177402, 0.9175598,
            0.04323238, 0.03087392, 0.03482862, 0.36226457,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(kernel21, None, 1, Padding::Same);
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            1.7606362, 1.7418567, 1.807722, 1.6478107, 1.0349542, 2.7935286, 3.2950132, 3.157129,
            2.8353925, 1.0136617, 2.396291, 2.7917762, 2.0984926, 2.1550565, 1.3370345, 1.503971,
            1.7567389, 1.2538215, 0.8897615, 0.3929793, 1.5040944, 2.32497, 1.9936706, 2.2588148,
            1.3126429, 1.7261962, 2.4836714, 1.9070047, 1.8829131, 1.7192292, 1.5196233, 1.9577055,
            1.5867043, 1.2154206, 0.6873595, 0.69974554, 0.7299658, 0.7368338, 0.46226248,
            0.21977791,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.6059544, 0.29194582, 0.34645593, 0.9409913, 0.60953087, 0.8610255, 0.1627552,
            0.8939359, 0.66327935, 0.48094535, 0.06551108, 0.86129206, 0.65446067, 0.9592776,
            0.8000413, 0.21450381, 0.6442533, 0.46971878, 0.84573215, 0.34651902,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.18830031, 0.57119006, 0.27269888, 0.7915957, 0.21737069, 0.04463017, 0.393406,
            0.8441482, 0.77705365, 0.6315176, 0.8522896, 0.16809769, 0.22305161, 0.773223,
            0.9678148, 0.2237789, 0.8982615, 0.271913, 0.34780893, 0.49277794, 0.14560463,
            0.33638617, 0.1585067, 0.18610527, 0.6963084, 0.9429821, 0.40789625, 0.20056698,
            0.37306353, 0.9367061, 0.7103306, 0.06833509, 0.48335183, 0.45182207, 0.96346164,
            0.00378525, 0.33689302, 0.28288215, 0.75004077, 0.1607512, 0.514175, 0.35879079,
            0.36688787, 0.00774159, 0.15532039, 0.01133456, 0.94680935, 0.052598, 0.73530346,
            0.8096563,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(kernel22, None, 1, Padding::Same);
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            1.9433353, 3.4228127, 4.847467, 3.8331764, 3.804578, 2.4241257, 4.0808473, 6.0651836,
            5.2626843, 4.849197, 1.9977381, 3.8111708, 5.463112, 4.9356112, 4.114871, 1.8158009,
            2.7521765, 3.863211, 3.4117572, 2.8816507, 2.3149717, 3.0260105, 4.1155033, 3.2621598,
            3.458694, 2.1111393, 4.085838, 4.2228155, 4.3918104, 3.3376374, 1.9386842, 3.0858266,
            4.766195, 4.0014625, 3.3781059, 1.1585866, 3.0447168, 3.4465826, 2.8690333, 2.4472578,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.7097644, 0.37942106, 0.38656324, 0.13763146, 0.99930644, 0.67476803, 0.06055127,
            0.8463604, 0.4460729, 0.33209085, 0.94373864, 0.5397614, 0.05766413, 0.64256257,
            0.7357459, 0.09256811, 0.8832945, 0.03911254, 0.782554, 0.4004812,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.80732703, 0.8010379, 0.28867772, 0.7802926, 0.9490529, 0.5395702, 0.1369102,
            0.4513485, 0.1162144, 0.9589836, 0.24819064, 0.3149064, 0.22322156, 0.39812055,
            0.45308354, 0.5711523, 0.97817534, 0.06805564, 0.5386646, 0.6699801, 0.1879456,
            0.8407316, 0.64728755, 0.53731096, 0.63207716, 0.00916763, 0.46754488, 0.8670982,
            0.1932068, 0.43971533, 0.10441232, 0.46486124, 0.22910197, 0.7679019, 0.23872072,
            0.03931138, 0.8551502, 0.19610135, 0.8555064, 0.08035298, 0.05671094, 0.9091975,
            0.27582648, 0.33816597, 0.42012835, 0.7745094, 0.14011143, 0.47505257, 0.98297566,
            0.5085966,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(kernel23, None, 1, Padding::Same);
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            1.8947343, 2.4426258, 4.5688577, 2.4065573, 2.2348871, 2.3167987, 3.2224967, 5.3705425,
            4.3484287, 2.2617307, 2.0183833, 3.9389546, 3.9471571, 4.130721, 2.5504436, 1.5804148,
            2.606216, 4.1682005, 2.9336529, 1.8431025, 1.8211585, 2.6728508, 2.134366, 3.313332,
            1.7529054, 1.7467892, 3.7858887, 3.0247731, 4.261167, 2.190734, 2.0637167, 3.4395082,
            4.9149113, 2.9692075, 2.8052857, 2.513916, 2.0296254, 3.801062, 2.8139968, 2.2223105,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.22395916, 0.01153891, 0.669607, 0.12918296, 0.55476546, 0.528783, 0.5067741,
            0.14234911, 0.5152856, 0.6446142, 0.9118427, 0.8193508, 0.989135, 0.7842302,
            0.59264964, 0.35247177, 0.48483032, 0.22649786, 0.04158387, 0.5814206,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.8653732, 0.4524277, 0.44947338, 0.5519129, 0.79122764, 0.7513198, 0.9315116,
            0.03313805, 0.41213843, 0.45310238, 0.01799934, 0.4328227, 0.23842481, 0.20688592,
            0.57869387, 0.9324833, 0.43915927, 0.53123087, 0.5324186, 0.4149537, 0.22217223,
            0.0080786, 0.65063345, 0.7681623, 0.8421627, 0.27179125, 0.68530315, 0.9955617,
            0.77906156, 0.18006648, 0.5975193, 0.6555531, 0.9498266, 0.9690994, 0.5122471,
            0.3840358, 0.8757204, 0.7260429, 0.04691354, 0.40678895, 0.35535267, 0.19270384,
            0.23519029, 0.6665529, 0.26402712, 0.55168146, 0.08576613, 0.9567203, 0.57141143,
            0.20602623,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(kernel24, None, 1, Padding::Same);
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (2, 4, 5),
        vec![
            2.3034997, 3.0933988, 4.260963, 3.136785, 2.3265605, 3.20681, 3.3054733, 4.8378954,
            3.5454512, 2.238543, 2.1540961, 2.5372102, 4.2754025, 3.433806, 2.7149425, 2.444301,
            3.225262, 3.6984525, 3.0090983, 2.3562305, 3.0875251, 4.4669847, 5.009917, 4.030303,
            3.2448783, 3.914193, 4.744957, 5.4094176, 4.953395, 3.425089, 3.40465, 3.7303526,
            5.131832, 3.3868535, 2.8532045, 2.1192021, 2.936121, 2.9060504, 2.6555126, 2.3799818,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.75538653, 0.96776, 0.44755465, 0.82362133, 0.29203537, 0.30861592, 0.39762703,
            0.26186082, 0.9658112,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.27424002, 0.50570756, 0.8114843, 0.5536027, 0.59788686, 0.05054026, 0.28394443,
            0.6402348, 0.02258505, 0.60607, 0.6834324, 0.8004999, 0.3349493, 0.4295082, 0.37033585,
            0.0394791, 0.50698835, 0.29841292,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(kernel25, None, 1, Padding::Same);
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            1.4839896, 1.7652309, 0.7095494, 1.6854146, 1.8707725, 1.2085879, 0.9929357, 1.0045376,
            0.79486257, 1.3884788, 1.8912537, 0.99531704, 1.3032048, 2.3501618, 1.6260877,
            0.6875899, 0.98924637, 0.7554121,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9388161, 0.84357476, 0.29760668, 0.25654384, 0.71037215, 0.14646496, 0.9906275,
            0.9552909, 0.7966291,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.6094893, 0.7271988, 0.09518696, 0.3957746, 0.6157527, 0.31079137, 0.46793708,
            0.8514491, 0.86081386, 0.8208274, 0.2372746, 0.6977758, 0.79387194, 0.9463199,
            0.99063903, 0.29514915, 0.8795419, 0.741553,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(kernel26, None, 1, Padding::Same);
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            1.5314665, 1.5592647, 0.61955523, 2.9358315, 3.5152984, 1.9607604, 1.5389049,
            2.1056056, 1.5236282, 2.202075, 2.4323668, 1.647742, 2.9006052, 4.140433, 2.5852365,
            2.131136, 3.3760586, 2.355815,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.03520088, 0.83411527, 0.47134155, 0.26704508, 0.2872401, 0.04289522, 0.583651,
            0.94414073, 0.5729697,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.72244126, 0.7707775, 0.02079507, 0.22973806, 0.18128674, 0.05054512, 0.6523751,
            0.27093726, 0.32479268, 0.53774405, 0.08921466, 0.18494032, 0.78120434, 0.15868789,
            0.81183356, 0.21792394, 0.6620494, 0.6886836,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(kernel27, None, 1, Padding::Same);
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            0.6113559, 0.5192191, 0.16664428, 1.8000462, 1.774139, 0.88217914, 0.582454, 0.524836,
            0.25650892, 0.8354865, 0.6272354, 0.8089081, 1.0316247, 1.4753548, 1.352218, 1.0695786,
            1.4546822, 1.0836248,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.39724785, 0.59319293, 0.02472531, 0.21891202, 0.5342134, 0.4041879, 0.53426075,
            0.20461221, 0.29362342,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.7835011, 0.47930118, 0.2895624, 0.7320774, 0.55179524, 0.37774232, 0.04187773,
            0.23883641, 0.63051957, 0.97746944, 0.6415133, 0.4162999, 0.04763152, 0.75958186,
            0.13098118, 0.6238241, 0.4102024, 0.5710282, 0.59153587, 0.66274744, 0.6454271,
            0.8120847, 0.22876394, 0.6206928, 0.19057496, 0.4622738, 0.9772445, 0.17967562,
            0.27354005, 0.48198408, 0.09082693, 0.6217685, 0.0965838, 0.8904992, 0.5337058,
            0.17222154, 0.62424076, 0.95776683, 0.998361, 0.150883, 0.28713444, 0.35105017,
            0.1765902, 0.9674033, 0.65025777, 0.1959308, 0.3119046, 0.55247456, 0.38556734,
            0.18145509,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(kernel28, None, 1, Padding::Same);
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            0.99189097, 1.2139368, 1.6807517, 1.2247887, 1.3418759, 1.8033566, 1.483831, 1.5404893,
            1.3808284, 1.57672, 1.9478678, 1.6736608, 1.1037357, 2.158333, 2.2857265, 1.4415758,
            1.8492526, 1.6110936,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.94255227, 0.7036003, 0.3402552, 0.16401337, 0.28418577, 0.5504918, 0.6148071,
            0.7740251, 0.37459207,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.25677747, 0.80441076, 0.17314304, 0.5946227, 0.30094627, 0.06480476, 0.5798754,
            0.62549657, 0.6065069, 0.9259787, 0.3677915, 0.69532603, 0.8356569, 0.39276573,
            0.18570696, 0.61698794, 0.9064707, 0.01547038, 0.2551995, 0.11438051, 0.03861368,
            0.6524532, 0.36442748, 0.08230381, 0.79969245, 0.27816203, 0.3741886, 0.44356522,
            0.27386904, 0.4171807, 0.14990133, 0.4750283, 0.6358263, 0.77572674, 0.7072159,
            0.34310365, 0.36999545, 0.8200852, 0.46510443, 0.9230857, 0.86201537, 0.04691705,
            0.12260284, 0.89921826, 0.47400048, 0.7492544, 0.05440097, 0.28273952, 0.9184355,
            0.9064988,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(kernel29, None, 1, Padding::Same);
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            2.530352, 2.5921295, 2.1144242, 2.2571082, 2.3187785, 2.167787, 2.6052265, 2.250003,
            1.7666745, 2.1383805, 2.3625872, 2.7974262, 1.68515, 2.6098163, 3.12961, 1.986789,
            2.350586, 3.2323365,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.7027802, 0.19125043, 0.8670149, 0.08634489, 0.722654, 0.77540857, 0.00211577,
            0.6443405, 0.2344423,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.9849179, 0.9893316, 0.87634915, 0.48734385, 0.8760625, 0.53053117, 0.01152504,
            0.6788874, 0.76156837, 0.4680538, 0.07214947, 0.549209, 0.8383253, 0.00365476,
            0.9782156, 0.7419056, 0.40790308, 0.00302504, 0.80174476, 0.7689671, 0.50054824,
            0.16478458, 0.89107823, 0.7763043, 0.73042727, 0.41667554, 0.7348974, 0.71259016,
            0.93557405, 0.37013116, 0.14954911, 0.33766475, 0.39673004, 0.03940821, 0.2414454,
            0.9373305, 0.84819096, 0.9272432, 0.8604789, 0.92845494, 0.8023847, 0.06647868,
            0.12827316, 0.02774826, 0.8982795, 0.1193029, 0.37523487, 0.28379655, 0.0638791,
            0.08446726,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(kernel30, None, 1, Padding::Same);
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (2, 3, 3),
        vec![
            2.1053019, 2.0020053, 3.0535119, 1.3818408, 2.3914309, 2.0843809, 2.3346102, 1.9154978,
            2.2834659, 2.5934947, 2.7028081, 2.7486267, 2.471838, 1.8386153, 2.2877162, 1.8241762,
            1.3692772, 1.2885038,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );
}
