// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array2, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_transpose_stride1_valid() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(kernel1, None, 1, Padding::Valid);
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.20500435, 0.95004094, 1.1854585, 0.9830456, 1.0185144, 0.14307275, 0.7724005,
            2.129321, 3.6102068, 3.4920175, 2.2759285, 0.8489318, 1.2590698, 2.961033, 4.6110344,
            5.056102, 3.1625488, 1.1041031, 1.4299698, 3.655266, 4.6101437, 4.923399, 2.2716956,
            1.0052052, 1.8833175, 2.868677, 5.1868505, 3.7493901, 2.5375302, 0.8256581, 1.9185702,
            2.5892203, 3.5579548, 2.9167597, 1.5709618, 0.511026, 0.6830031, 1.1062582, 1.6330717,
            1.2911601, 0.666404, 0.25955924,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.14352316, 0.8997107, 0.64410555, 0.04471071, 0.767672, 0.43464628, 0.16569944,
            0.18875164, 0.12285258, 0.2781115, 0.5390728, 0.5066572, 0.97435564, 0.39133722,
            0.7964828, 0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183,
            0.81628793, 0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133,
            0.0067116, 0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715,
            0.7567798, 0.23972042, 0.38848338, 0.00744711, 0.8715701,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.07988323, 0.6283005, 0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194,
            0.34163022, 0.03235205, 0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297,
            0.97700953, 0.18019113, 0.775954, 0.14120784,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(kernel2, None, 1, Padding::Valid);
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.23378246, 0.8826004, 2.2634954, 2.5907102, 1.7126744, 0.46233523, 0.508057,
            2.4801147, 4.948943, 4.248997, 2.9309442, 1.47327, 0.58261955, 3.2820787, 4.7746215,
            4.7418694, 3.657943, 1.4257001, 0.82847613, 2.5235906, 3.742593, 4.055015, 3.8372264,
            1.7375858, 0.40289268, 1.826671, 2.8332467, 3.2692723, 3.3612194, 2.4246259, 0.7838861,
            1.3899677, 1.5449216, 2.2082677, 2.4120436, 1.1154187, 0.26940888, 0.38370866,
            0.68818617, 0.9455888, 0.990537, 0.15108703,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.3426181, 0.5417864, 0.7768226, 0.34603763, 0.6114103, 0.9716041, 0.5157695,
            0.50755495, 0.6659802, 0.629322, 0.60627973, 0.27978492, 0.28792506, 0.7547703,
            0.0509604, 0.10449678, 0.89887625, 0.6572328, 0.695583, 0.3626411, 0.37613922,
            0.9241278, 0.39898983, 0.6908677, 0.5511301, 0.36253917, 0.36786652, 0.88718724,
            0.69587743, 0.4870034, 0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529,
            0.5566727, 0.7035832, 0.92333794, 0.85647196, 0.36252776,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9373231, 0.01684272, 0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754,
            0.31284246, 0.4031665, 0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259,
            0.23846498, 0.82509995, 0.97324103, 0.96826524,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(kernel3, None, 1, Padding::Valid);
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.5985942, 1.4934016, 2.018358, 1.68512, 0.965047, 0.36986947, 1.6128728, 3.0429893,
            3.0979333, 3.7195776, 1.8485445, 0.91961986, 2.7355242, 4.601478, 6.200628, 6.763774,
            3.4238458, 1.8532579, 2.5565567, 4.4718704, 5.45767, 5.7891073, 3.01157, 1.7458267,
            2.8974357, 5.0805173, 6.34371, 5.842485, 3.0566144, 1.5347013, 1.8287315, 3.245428,
            4.2877626, 3.7733746, 2.0074868, 0.9381913, 1.259785, 2.2244635, 3.3802028, 2.7833323,
            1.5760041, 0.49722776,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.77620417, 0.8427075, 0.42989048, 0.76771307, 0.54514444, 0.7878393, 0.21897991,
            0.975659, 0.73295325, 0.69994044, 0.86701024, 0.76087946, 0.623545, 0.14890751,
            0.8610666, 0.21943341, 0.1644093, 0.6089244, 0.8612485, 0.02602104, 0.30423534,
            0.5087405, 0.16869895, 0.3329467, 0.179494, 0.33126613, 0.11996287, 0.21606164,
            0.87119263, 0.33579683, 0.2313126, 0.2576527, 0.3748985, 0.30113342, 0.8142977,
            0.423247, 0.8179498, 0.92175007, 0.21606776, 0.19149332,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.4240341, 0.14780204, 0.46443272, 0.00207204, 0.359202, 0.9019851, 0.21363449,
            0.6390296, 0.5977058, 0.81350476, 0.3685356, 0.90738845, 0.7828945, 0.9812083,
            0.6726924, 0.46724817, 0.17302093, 0.39839587, 0.78055173, 0.8576361, 0.7335981,
            0.52934057, 0.9529279, 0.78965247, 0.46750203, 0.08403921, 0.73126566, 0.34934825,
            0.3459232, 0.54770446, 0.68714255, 0.29283327, 0.53392637, 0.8850151, 0.6909357,
            0.44388366, 0.9043074, 0.9949724, 0.64743847, 0.36691284, 0.5396585, 0.5372604,
            0.47547424, 0.44373918, 0.34716287, 0.21774843, 0.9437953, 0.51856595, 0.15765554,
            0.9350713,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(kernel4, None, 1, Padding::Valid);
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.35470474, 0.7372923, 1.1598226, 1.2163785, 1.2387083, 1.1134547, 0.3635794,
            0.45812047, 1.155422, 1.9383423, 2.2686524, 3.7026346, 3.2780452, 3.1466527, 1.440932,
            1.3233795, 1.4201655, 3.6935241, 4.7387366, 6.7601576, 6.741786, 5.0231147, 2.8841608,
            1.9960122, 2.3630996, 3.7889538, 6.1374135, 8.490736, 9.399002, 6.5965943, 4.9128747,
            2.6172352, 2.6025715, 5.5668826, 9.325594, 11.029676, 11.6051235, 8.902636, 5.9486604,
            2.7735543, 2.3581715, 4.7618256, 6.881201, 9.702231, 10.010415, 7.9663415, 4.953452,
            1.8565445, 1.6447266, 3.8606153, 6.7219944, 7.777974, 7.9563823, 5.7190313, 3.4514852,
            1.0195315, 1.0572984, 2.108552, 3.5346332, 3.879755, 4.4280562, 3.29988, 2.3229127,
            0.58714765, 0.29871762, 1.5064211, 2.4519615, 2.0376337, 2.5951183, 1.9848248,
            0.6554117, 0.1912248,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.86233217, 0.81734437, 0.6566154, 0.3879487, 0.28848994, 0.5814131, 0.06870039,
            0.78543746, 0.47194287, 0.12733267, 0.6111727, 0.25675833, 0.74741316, 0.45714313,
            0.9649919, 0.57969916, 0.5208711, 0.93666834, 0.13247305, 0.7087714, 0.17877895,
            0.40767, 0.6906785, 0.9675369, 0.224454, 0.28950995, 0.75431514, 0.99582964, 0.8120864,
            0.9536324, 0.7703749, 0.683158, 0.16371861, 0.42877796, 0.7300311, 0.9456737,
            0.05700503, 0.19623296, 0.44457257, 0.5512328,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.15101007, 0.25140873, 0.2031063, 0.5537751, 0.3641559, 0.701937, 0.27669305,
            0.85076064, 0.00186597, 0.3316532, 0.15485734, 0.35000807, 0.42372492, 0.03995521,
            0.5067197, 0.38907993, 0.37287286, 0.21294773, 0.8646356, 0.10154326, 0.75313085,
            0.7910046, 0.15368015, 0.25977603, 0.40315583, 0.635939, 0.25689796, 0.13678746,
            0.43744904, 0.6658951, 0.564682, 0.70429957, 0.67241764, 0.15790685, 0.25059524,
            0.6432024, 0.60438925, 0.45131883, 0.96080875, 0.40131757, 0.60942906, 0.7035094,
            0.6473561, 0.05433872, 0.7478619, 0.24740443, 0.35665986, 0.00020906, 0.23741227,
            0.57013196,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(kernel5, None, 1, Padding::Valid);
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.24391334, 0.64540625, 1.0482018, 1.7939079, 1.6379621, 1.4460019, 1.3371141,
            0.7855519, 0.8925601, 1.570544, 3.0179605, 3.8647056, 3.4820838, 2.532435, 1.9422468,
            1.3202643, 1.165482, 2.5611184, 3.8259244, 6.053112, 5.5964975, 5.0935526, 3.1021304,
            1.6433254, 1.6403401, 3.428741, 6.1928873, 8.423359, 7.7538404, 6.2572675, 4.373275,
            2.6577895, 2.2701283, 4.7164774, 7.4473248, 9.735344, 10.054958, 6.237293, 5.210122,
            2.991201, 1.5701892, 3.8554506, 5.549368, 7.910409, 7.076833, 5.7307, 3.7529721,
            2.467851, 1.0642533, 2.315851, 3.7213798, 5.5014973, 4.9807963, 4.4879804, 2.914559,
            1.8394697, 0.8408056, 1.8183205, 2.4944139, 3.7514296, 3.443647, 1.830387, 2.1690755,
            1.2570848, 0.4063874, 1.1863256, 1.1007156, 1.226355, 1.3101003, 0.7385016, 0.6218636,
            0.60002077,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6398819, 0.7132858, 0.90739846, 0.8246988, 0.1319153, 0.6876462, 0.846729,
            0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465, 0.05539654, 0.5554673,
            0.9149804, 0.9791666, 0.9000323, 0.6329186, 0.30872977, 0.30553624, 0.04431259,
            0.5287215, 0.3358437, 0.72178566, 0.72704846, 0.85191244, 0.07464863, 0.867838,
            0.5849202, 0.14913943, 0.18325551, 0.40498126, 0.75359416, 0.01821492, 0.5917236,
            0.91982275, 0.5287654, 0.7151285, 0.38420153, 0.517026,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.5150141, 0.26934662, 0.7356045, 0.97902703, 0.6362754, 0.27803296, 0.32063982,
            0.83432084, 0.78711736, 0.28247103, 0.7812688, 0.5270146, 0.4719829, 0.47535485,
            0.23715672, 0.4404677, 0.90286416, 0.66611385, 0.02649495, 0.3193976, 0.16608049,
            0.5121102, 0.17436478, 0.313714, 0.47244504, 0.9906781, 0.9064671, 0.29454133,
            0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972, 0.53866875, 0.6358971,
            0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548, 0.14977625, 0.53714937,
            0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625, 0.4744624, 0.73655206,
            0.42605233,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(kernel6, None, 1, Padding::Valid);
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.37344772, 1.103663, 1.9551777, 3.0395248, 3.278956, 2.5611959, 2.1436744, 0.6150685,
            0.9739357, 2.3967001, 2.9606707, 4.939715, 5.5328407, 4.309079, 3.0953982, 0.91593283,
            1.74879, 3.108517, 4.7064695, 8.149392, 6.9905963, 5.4687176, 3.1304746, 1.5858881,
            2.1704786, 4.5262623, 7.183258, 10.105035, 8.660454, 7.4568315, 4.91765, 2.356207,
            2.6603363, 5.2687516, 7.718365, 10.839016, 11.462591, 7.8528314, 5.615874, 2.8767843,
            1.9526424, 4.3018107, 6.6298823, 8.712183, 8.973379, 5.9587235, 3.3808098, 1.9512453,
            1.7728577, 3.7792397, 4.4787836, 6.578704, 6.2997336, 3.255145, 2.3781667, 1.8286393,
            0.8842493, 2.1309881, 2.9121337, 3.6295204, 3.937992, 2.7868788, 2.3129213, 1.3620441,
            0.42973223, 1.3086534, 1.4785846, 1.8685424, 2.123891, 1.2821229, 0.78621536,
            0.3646292,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6592577, 0.3237799, 0.42867732, 0.87574345, 0.70010746, 0.01496939, 0.78416556,
            0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122, 0.68573385,
            0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448, 0.48578474,
            0.2764571, 0.9192946, 0.8920509, 0.34320405, 0.4283556, 0.3897719, 0.06360459,
            0.729173, 0.19460331, 0.8634254, 0.6576018, 0.9657459, 0.22873744, 0.47843248,
            0.22157177, 0.9162307, 0.02157675, 0.44649428, 0.2792192,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.685827, 0.75294507, 0.7919586, 0.22560763, 0.88778716, 0.80092114, 0.00003577,
            0.9737877, 0.9146247, 0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946,
            0.17754778, 0.41998118, 0.02919354, 0.82382417, 0.4156855, 0.49590722, 0.69720376,
            0.7155315, 0.40795937, 0.15397236, 0.02265206, 0.7090415, 0.75877124, 0.67035425,
            0.39483562, 0.86222315, 0.9993058,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(kernel7, None, 1, Padding::Valid);
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.6561572, 0.8487304, 1.8542502, 2.1597006, 1.9702271, 1.907296, 0.56838703, 1.4504765,
            2.0185788, 3.198617, 4.955788, 3.9955273, 2.3068962, 1.3812443, 2.4500825, 2.9491827,
            5.325045, 6.7261496, 3.9353063, 4.4302397, 1.8141692, 3.1909494, 4.196878, 7.069769,
            8.859523, 7.4611673, 4.6818166, 2.400816, 3.256423, 4.6006846, 6.570181, 8.101447,
            5.1809444, 3.8904862, 1.9228524, 2.4800045, 3.6539538, 4.9320536, 6.6401486, 4.2300806,
            3.221109, 1.6880069, 1.5972342, 1.6117313, 3.226777, 3.8167262, 1.9316177, 1.7199585,
            0.6409267, 0.8083781, 0.90209156, 1.4597586, 1.6992339, 0.9092958, 0.74157655,
            0.37764335,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.84902793, 0.26427644, 0.86764544, 0.24274233, 0.69865257, 0.5739991, 0.7620597,
            0.29289714, 0.88402116, 0.8942853, 0.7757528, 0.16431308, 0.48939565, 0.56055367,
            0.46453193, 0.9573795, 0.8899508, 0.16098963, 0.63514715, 0.810474, 0.29953358,
            0.46075395, 0.02808736, 0.59781086, 0.8855644, 0.61877847, 0.9537467, 0.6197168,
            0.3379795, 0.13108306, 0.30692965, 0.33537498, 0.01351478, 0.45529485, 0.6626128,
            0.9497022, 0.7403127, 0.06039312, 0.08292098, 0.80679554,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.1354166, 0.2560622, 0.80891573, 0.97702754, 0.4124968, 0.4359102, 0.8733311,
            0.1396195, 0.52047473, 0.88564533, 0.29781443, 0.21130918, 0.83071965, 0.3337948,
            0.9783562, 0.42070097, 0.55396014, 0.16172563, 0.7634967, 0.36205766, 0.48491392,
            0.4980414, 0.6001484, 0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525,
            0.7446416, 0.471613, 0.72900707, 0.842964,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(kernel8, None, 1, Padding::Valid);
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.28090215, 0.55687296, 1.1907247, 2.094282, 1.30716, 1.5106674, 0.45360795, 1.0806458,
            1.5943438, 3.757305, 4.2754803, 3.8198109, 2.5101476, 0.93376416, 1.5770354, 2.851549,
            5.0584655, 6.802816, 5.043401, 3.0546362, 1.2972777, 2.2212286, 3.6778781, 6.8243685,
            8.666477, 6.5101194, 5.152601, 2.7271044, 2.563748, 3.9994192, 7.722192, 9.450778,
            6.557911, 6.2576323, 2.807935, 1.9718447, 3.042171, 5.1537094, 5.9864116, 4.893305,
            3.5404148, 2.0180721, 1.153128, 1.9546822, 2.7453787, 5.255179, 3.4341464, 3.0483298,
            2.0757437, 1.2905673, 0.8249105, 2.0819774, 2.725158, 1.4515151, 1.7181983, 1.0210668,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.21457537, 0.938401, 0.41665936, 0.05351101, 0.43856344, 0.7253113, 0.8520324,
            0.4151233, 0.35101932, 0.7388761, 0.3592986, 0.6741479, 0.9965808, 0.3117034,
            0.8605703, 0.94308543, 0.8192489, 0.31478795, 0.750324, 0.36604244, 0.78454614,
            0.039194, 0.23696694, 0.2418382, 0.24788351, 0.5622223, 0.15428482, 0.50688076,
            0.37682602, 0.44385925, 0.00051633, 0.53422695, 0.5675659, 0.53845215, 0.2130759,
            0.86445093, 0.432881, 0.6255918, 0.3942565, 0.07226853,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.09869356, 0.32627374, 0.8543963, 0.85603166, 0.25422713, 0.24929269, 0.36793318,
            0.39957172, 0.9079535, 0.865758, 0.82237726, 0.60374194, 0.7658025, 0.0215734,
            0.473204, 0.6594781, 0.86392707, 0.8566667, 0.48541847, 0.54855824, 0.5860555,
            0.158874, 0.10558709, 0.19664533, 0.39609066, 0.27843866, 0.49128443, 0.75033015,
            0.35650545, 0.4687038, 0.6159849, 0.2547001,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(kernel9, None, 1, Padding::Valid);
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.6989679, 0.86857975, 1.1497612, 1.9880028, 1.5204554, 0.6497761, 0.17846945,
            0.7717751, 1.3524208, 2.0774548, 3.179339, 2.91459, 1.6730373, 0.70235014, 1.1225376,
            2.828094, 3.762158, 5.269684, 3.9436946, 2.3123882, 1.3494592, 1.8391682, 4.337564,
            5.602902, 7.8411045, 6.4401035, 4.2570715, 2.383777, 1.9330065, 4.080106, 5.807275,
            7.955097, 5.7419834, 4.1744614, 2.1105332, 1.9947761, 3.1450474, 4.2282887, 6.1961393,
            4.1666117, 3.2845159, 1.9591287, 1.8808244, 2.0815902, 3.9858258, 4.9357796, 3.1139185,
            2.6859124, 1.1173403, 0.7817073, 0.68465924, 1.669483, 1.6919024, 1.0066158, 0.8129685,
            0.25980377,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.17250927, 0.07203952, 0.8724657, 0.14018923, 0.12091745, 0.4770398, 0.43290496,
            0.6356798, 0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513,
            0.06810815, 0.79673207, 0.29373887, 0.55241185, 0.23906927, 0.18915932, 0.02753429,
            0.1438574, 0.5419741, 0.71984386,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286, 0.21388301,
            0.30016333, 0.49605927, 0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258,
            0.26911622, 0.92149794, 0.7165893, 0.04745785,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(kernel10, None, 1, Padding::Valid);
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.60474586, 0.5131774, 0.7644067, 0.5995305, 0.17181505, 0.8956684, 1.2411102,
            1.8060486, 1.6059419, 1.0132327, 1.1840781, 1.8789177, 2.0158055, 1.859172, 1.0129342,
            1.02637, 2.2954364, 3.6058974, 2.854466, 1.312911, 0.37861872, 1.1460247, 2.2957706,
            2.115947, 0.88521993, 0.18354347, 0.8782778, 1.5695462, 1.1642044, 0.28041375,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.55642486, 0.34654748, 0.83168656, 0.8410765, 0.7668131, 0.84094906, 0.6012723,
            0.9256995, 0.66010624, 0.43380973, 0.62281454, 0.45852852, 0.61445725, 0.524579,
            0.06486581, 0.14233574, 0.13930365, 0.5838787, 0.45914945, 0.30819193, 0.70949817,
            0.8803759, 0.6927248, 0.50569826,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.7358748, 0.58652496, 0.85065925, 0.3247378, 0.6760192, 0.4483504, 0.59195757,
            0.37883574, 0.7796499, 0.32748002, 0.44507304, 0.7488422, 0.14428215, 0.8785777,
            0.15468395, 0.6638725, 0.30651525, 0.9492515,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(kernel11, None, 1, Padding::Valid);
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.6106815, 1.02664, 2.0034535, 1.2042956, 0.75605613, 0.93488646, 2.2707865, 3.4629688,
            2.3654637, 1.5355148, 1.6237904, 3.25442, 5.4952917, 4.2711167, 2.2701824, 1.4614124,
            3.3950438, 5.7682953, 4.302489, 2.3843403, 0.9286413, 2.4900365, 3.7937455, 2.622479,
            1.4719489, 0.8412543, 1.2627519, 2.2293415, 1.4718585, 0.83752656,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.55669755, 0.08302987, 0.45890567, 0.05946975, 0.9099885, 0.30235246, 0.24214035,
            0.42138377, 0.38782486, 0.21880285, 0.9182205, 0.85290706, 0.5070326, 0.5272234,
            0.71761, 0.560904, 0.22129431, 0.2624427, 0.6557088, 0.00633, 0.6603214, 0.45500925,
            0.6523986, 0.14666249,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.32440838, 0.2805719, 0.42671442, 0.74477625, 0.9118973, 0.5335283, 0.36968935,
            0.5693756, 0.36426732, 0.11819325, 0.95361024, 0.13343851, 0.5940242, 0.7282295,
            0.9320007, 0.46956548, 0.5087874, 0.7952918,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(kernel12, None, 1, Padding::Valid);
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.24052519, 0.728955, 1.0649595, 0.91885823, 0.29157847, 0.8013923, 2.124842, 2.692956,
            2.2296653, 1.0776904, 0.97742504, 2.955769, 3.8736515, 3.1536832, 1.3973868,
            0.97997427, 2.6457562, 4.471608, 2.7364278, 1.5247093, 0.8306606, 2.2325249, 3.8818402,
            2.6978118, 1.2581596, 0.2945457, 1.0018842, 1.6804907, 1.4135695, 0.42732564,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.73709416, 0.3358689, 0.03185032, 0.27057356, 0.26166973, 0.5843129, 0.5337139,
            0.19571388, 0.1192536, 0.75616854, 0.97167397, 0.71154076, 0.26672947, 0.07128377,
            0.3383284, 0.8008563, 0.9504947, 0.5971434, 0.7847773, 0.92326206, 0.24163638,
            0.12968542, 0.5954836, 0.6734995,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.08627631, 0.7485715, 0.8782484, 0.6863155, 0.7264353, 0.08944888, 0.68172634,
            0.4284322, 0.48237634, 0.6856524, 0.04009921, 0.0687674, 0.9063645, 0.42620143,
            0.61030614, 0.10040135, 0.50107217, 0.763057, 0.25769317, 0.8816114, 0.7770131,
            0.23345616, 0.62762326, 0.15315741, 0.73589575, 0.2752067, 0.85641515, 0.7439484,
            0.6581306, 0.4056261, 0.13899311, 0.26460668, 0.9179794, 0.96651816, 0.89336777,
            0.18948041, 0.9371178, 0.7124811, 0.9657549, 0.6203675, 0.32684848, 0.11439406,
            0.07654371, 0.95680344, 0.9728639, 0.6055871, 0.00439729, 0.8525613, 0.3167563,
            0.13499211,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(kernel13, None, 1, Padding::Valid);
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.1369995, 0.8287942, 1.2541133, 1.3430215, 1.200741, 0.51742524, 0.16037202,
            0.34675092, 1.7855935, 2.9164274, 3.5324264, 3.58277, 2.0059893, 0.99077237,
            0.47763577, 2.2220988, 4.4962063, 5.7294874, 5.5740933, 3.234633, 1.3480746, 0.5815302,
            3.0587285, 6.34994, 8.26717, 8.874112, 5.40153, 2.1719992, 1.2789497, 2.7159429,
            5.1521993, 6.1189165, 8.116567, 5.4149394, 2.4774234, 1.060211, 1.8495626, 4.054232,
            5.037123, 6.45746, 3.8483253, 1.7028925, 1.0082614, 1.525158, 2.7262828, 2.8087442,
            3.3094428, 2.627192, 1.4029031, 0.6660887, 1.2927231, 1.7753547, 1.443498, 1.9321891,
            1.1177492, 0.61453694,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.68338645, 0.7955047, 0.21689218, 0.2826704, 0.12328367, 0.6890043, 0.5906649,
            0.41700745, 0.30266365, 0.5716598, 0.12726787, 0.35587692, 0.16889893, 0.3114892,
            0.1309899, 0.24026695, 0.55435276, 0.34375766, 0.4225387, 0.37165096, 0.6202945,
            0.6069533, 0.05756181, 0.0153275,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.8497578, 0.79796964, 0.4071996, 0.19325097, 0.04944435, 0.59729165, 0.39304134,
            0.679002, 0.6126854, 0.67232877, 0.7156292, 0.09058711, 0.33372015, 0.8941644,
            0.30899736, 0.3348802, 0.6412177, 0.26750943, 0.03709449, 0.56803024, 0.8756273,
            0.5771133, 0.56024176, 0.5868575, 0.75167763, 0.36936092, 0.37185487, 0.35425207,
            0.24336162, 0.01027582, 0.2671537, 0.83992416, 0.49819484, 0.7831867, 0.70054483,
            0.8701863, 0.49413827, 0.84670645, 0.8069649, 0.093459, 0.93408287, 0.8206956,
            0.70209366, 0.32817394, 0.744203, 0.39091238, 0.43911496, 0.92919487, 0.29325068,
            0.62813336,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(kernel14, None, 1, Padding::Valid);
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.64309764, 1.3991657, 1.3214132, 0.8292261, 0.39978358, 0.11632656, 0.01207012,
            0.78224957, 1.5932496, 2.5041924, 2.4788933, 2.099176, 1.2171293, 0.27518693,
            1.5270412, 2.6404307, 3.5427918, 3.6323466, 3.427633, 1.9710509, 0.80465543, 1.9736215,
            3.5958095, 4.9501276, 4.369449, 3.9616532, 3.009458, 1.1214993, 2.2774885, 3.9344258,
            5.2451825, 5.3541675, 5.075606, 2.8709786, 1.2940111, 1.8711843, 2.2984822, 4.1543913,
            3.7372785, 3.1329694, 2.049566, 1.4787793, 1.4407601, 1.9979191, 2.4762983, 2.0321836,
            2.71504, 1.0397846, 0.83068883, 0.7378265, 0.7303755, 1.300577, 0.85037106, 1.116139,
            0.34516475, 0.27713242,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.8131431, 0.19520658, 0.47931832, 0.42483747, 0.47526902, 0.28184402, 0.09741595,
            0.45691565, 0.44086096, 0.9638409, 0.33859608, 0.26381832, 0.29839757, 0.68755937,
            0.09156765, 0.58584654, 0.04617033, 0.14705709, 0.81179595, 0.16751295, 0.06864621,
            0.6308731, 0.38993102, 0.3644169,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.68174505, 0.272409, 0.23609333, 0.21866773, 0.80119157, 0.01742986, 0.49270406,
            0.37920174, 0.90869635, 0.8191268, 0.7636344, 0.7827788, 0.9694966, 0.79533535,
            0.00732174, 0.8372113, 0.9449071, 0.7670253, 0.50964797, 0.7843069, 0.7365313,
            0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833, 0.5585159,
            0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028, 0.52249014,
            0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726, 0.25884646,
            0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234, 0.32747796,
            0.9097073,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(kernel15, None, 1, Padding::Valid);
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.84385765, 1.0974271, 1.0020287, 0.91681945, 1.3458605, 0.60842973, 0.42392978,
            0.9599709, 1.3942082, 1.9399698, 2.514615, 2.6215405, 1.5594969, 0.7303623, 1.8114436,
            2.487154, 3.634607, 3.5520658, 3.0948036, 2.2163737, 0.7569667, 3.0381427, 3.977551,
            5.3173857, 5.1243453, 5.6024733, 2.8016834, 1.3102603, 2.3580046, 4.1896586, 5.804402,
            5.9135795, 6.1113243, 3.2121484, 0.94523776, 2.5921798, 3.2027822, 4.772436, 4.2378483,
            3.8545856, 1.711868, 0.82647145, 2.0881011, 2.581229, 3.2150614, 2.7874107, 3.6646235,
            1.4792519, 0.60025924, 1.2956264, 1.592785, 1.9669464, 1.8791201, 1.5078565, 0.7828003,
            0.37586558,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446, 0.9843364, 0.4038572,
            0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686, 0.5288406, 0.92906404,
            0.87780553, 0.9090181, 0.82569945, 0.20383635, 0.7166643, 0.17061436, 0.91526777,
            0.08598401, 0.70100874, 0.40537685,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.5971982, 0.92796123, 0.15859716, 0.7859081, 0.8564488, 0.35816404, 0.79062706,
            0.9644883, 0.13154314, 0.31929043, 0.80048305, 0.07180241, 0.52815664, 0.45786336,
            0.91537887, 0.9783313, 0.25753945, 0.42799363, 0.07738555, 0.9294206, 0.07022415,
            0.60058224, 0.6196278, 0.9008346, 0.04155485, 0.82207745, 0.41282526, 0.9949608,
            0.3109271, 0.47614527, 0.7615821, 0.35893062,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(kernel16, None, 1, Padding::Valid);
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.5805416, 1.1755016, 0.996167, 1.8138838, 1.0056922, 1.0571041, 1.2815437, 1.9725263,
            3.150295, 4.8631973, 2.7441647, 2.0498784, 1.1444458, 2.7749143, 5.4943905, 6.4518485,
            4.1516237, 3.3911943, 1.5031457, 4.4221272, 6.965188, 7.686783, 6.297915, 2.862761,
            1.2858257, 3.0651643, 4.9462423, 6.7787066, 4.6265554, 2.5356932, 0.5294488, 1.3298677,
            3.4017067, 3.6460454, 2.999376, 1.3825027, 0.38707054, 1.0910339, 1.6972778, 2.4100175,
            1.691001, 0.32494462,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.07713356, 0.6123928, 0.62511915, 0.88098776, 0.21521498, 0.89468116, 0.1842307,
            0.10784956, 0.8354833, 0.2630701, 0.7184675, 0.06132602, 0.06056971, 0.71349823,
            0.00944792, 0.07349233, 0.35231608, 0.8533961, 0.17608605, 0.18067755, 0.51991457,
            0.19053963, 0.5045173, 0.7456122,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.27621788, 0.48649722, 0.39297876, 0.54849166, 0.3746991, 0.8194284, 0.34880427,
            0.79505837, 0.41293454, 0.890512, 0.12076204, 0.20799449, 0.88948244, 0.24437675,
            0.7731474, 0.65954226, 0.4922565, 0.5211581, 0.97382414, 0.9779564, 0.1754263,
            0.4551989, 0.81067127, 0.7095975, 0.5087082, 0.78796804, 0.03310984, 0.20805901,
            0.45704818, 0.9133983, 0.5689028, 0.04247752,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(kernel17, None, 1, Padding::Valid);
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.0511215, 0.5894697, 0.93638873, 1.3460634, 1.2885215, 0.3521123, 0.31904903,
            1.1451814, 2.5118, 3.275634, 2.8641298, 1.8290198, 0.5432285, 1.9301883, 3.447571,
            4.094205, 2.847113, 2.415588, 0.76384884, 3.0328395, 4.90473, 5.6990776, 3.7417755,
            2.5723405, 1.1148622, 1.734148, 4.377553, 4.5903907, 3.0673265, 1.4861214, 0.4499096,
            1.3221054, 2.8948212, 1.8341798, 1.3070382, 0.741008, 0.32108203, 1.1079798, 1.3435216,
            1.7201296, 0.9668852, 0.07211886,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.55938286, 0.9835293, 0.04525762, 0.7176199, 0.82096803, 0.5575717, 0.5744108,
            0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355, 0.1134909, 0.5645703,
            0.30096474, 0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894, 0.681929,
            0.24701218, 0.74485576, 0.61556435,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.63869125, 0.05875124, 0.3210932, 0.96946657, 0.09463912, 0.6275637, 0.34162354,
            0.74390864, 0.8736778, 0.9513908, 0.24045336, 0.7003475, 0.87750345, 0.16564246,
            0.6314963, 0.21785556, 0.7654987, 0.13988015, 0.03287261, 0.82226163, 0.60896695,
            0.13331373, 0.62307173, 0.23316076, 0.9600204, 0.55291533, 0.29808274, 0.8765127,
            0.98263544, 0.27148733, 0.11101003, 0.2754741,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(kernel18, None, 1, Padding::Valid);
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.44415006, 1.1090889, 0.5793943, 1.0147436, 1.4421487, 0.2913475, 0.8940045,
            1.8634522, 2.5491748, 2.6707008, 2.539328, 1.374054, 1.759799, 4.2661343, 4.5432773,
            4.364296, 4.4911976, 1.8129889, 2.458607, 5.9104342, 6.335393, 5.8020444, 4.890305,
            2.3281093, 2.3153071, 4.7806835, 6.0991497, 4.55145, 3.7009811, 1.4603161, 1.6450738,
            3.8222165, 3.9019885, 2.6086597, 2.2092772, 0.9072808, 0.5344868, 1.6260464, 1.3212401,
            0.97058254, 0.55947936, 0.202103,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969,
            0.5836321, 0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643,
            0.91682273, 0.6142979, 0.19277428, 0.28408903, 0.25507236, 0.9800453, 0.36125833,
            0.96792, 0.33258557, 0.9508625, 0.8424581, 0.8130291, 0.7774976, 0.17691322, 0.9389267,
            0.22419459, 0.33442205, 0.7614585, 0.37563834, 0.70754576, 0.1499497, 0.9873837,
            0.7166968, 0.40278858, 0.22288306, 0.3279577, 0.07722609, 0.598755, 0.8143903,
            0.87905455, 0.83061284, 0.9923988, 0.6196494, 0.536406, 0.06662867, 0.83588266,
            0.28182983, 0.662181, 0.99850965, 0.60448396, 0.12318801, 0.91713256, 0.8540598,
            0.19103892, 0.5929614, 0.9118344, 0.9381113, 0.3421722, 0.8149188, 0.9595595,
            0.02717085, 0.8916309, 0.9755575, 0.27588442, 0.59208006, 0.00008138, 0.9552037,
            0.12578069,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.01249961, 0.05413999, 0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439,
            0.34315115, 0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794,
            0.6930413, 0.90735817, 0.91156703, 0.45996496,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(kernel19, None, 1, Padding::Valid);
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.48162568, 0.9977244, 1.3984518, 0.89739656, 0.67153275, 1.318335, 1.192123,
            0.8317557, 1.2973466, 2.8725724, 3.7905424, 3.8881643, 4.066704, 4.7979684, 3.3533397,
            1.4218719, 1.8246634, 3.8597286, 5.3059373, 6.45571, 6.989967, 7.6048717, 4.659522,
            1.8180112, 1.1730818, 4.0778785, 6.1933575, 8.149513, 7.430545, 6.950018, 4.622121,
            2.2629454, 1.1839198, 4.0112906, 7.14848, 7.466683, 7.0291524, 6.6986666, 4.916982,
            2.5474505, 2.0761154, 5.284709, 7.356443, 7.148855, 5.8183055, 6.7459, 4.3339896,
            2.2954032, 2.5087118, 3.9116092, 5.3283386, 4.473075, 4.6628275, 3.8751693, 3.1298742,
            1.2532284, 1.1808238, 1.9275321, 2.005684, 1.8192613, 1.7109011, 2.27922, 0.9712485,
            0.5741586,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.9045769, 0.17170428, 0.43418503, 0.69308424, 0.42869946, 0.9244341, 0.41451567,
            0.6224708, 0.00536506, 0.33826837, 0.47926104, 0.0032256, 0.02230139, 0.35960108,
            0.48593593, 0.86064774, 0.28908366, 0.4153976, 0.3468706, 0.2242362, 0.93169004,
            0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496, 0.11111139, 0.19382912,
            0.9307082, 0.9188555, 0.10532705, 0.88550454, 0.20754221, 0.97926295, 0.3472928,
            0.71126235, 0.03633394, 0.7482733, 0.28782296, 0.7382309, 0.60003114, 0.3259743,
            0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927, 0.968827, 0.47373444,
            0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834, 0.3979838, 0.2393961,
            0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945, 0.66457146, 0.8425775,
            0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123, 0.48163053, 0.437191,
            0.43973154, 0.29997745,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.21913478, 0.6611514, 0.209788, 0.176356, 0.88925517, 0.14793599, 0.36509594,
            0.5616029, 0.6617385, 0.30053073, 0.36820948, 0.62227124, 0.4957459, 0.69923055,
            0.3227648, 0.9702412, 0.5679234, 0.13432135,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(kernel20, None, 1, Padding::Valid);
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.20914373, 0.8739463, 0.7830674, 1.2684315, 1.2745187, 1.409694, 1.1945359, 0.3967796,
            0.525566, 1.9991163, 2.2427855, 1.7996352, 2.438559, 2.4030519, 2.1430168, 0.84552,
            1.0101255, 2.962335, 3.8251805, 3.5037673, 3.9885433, 4.1808925, 2.595572, 1.4088521,
            1.4160633, 2.3743548, 3.4193773, 3.3591216, 3.3418534, 3.5131772, 2.4131312, 0.8030794,
            1.1612126, 3.0989351, 4.110075, 4.1496305, 3.371249, 4.181319, 2.9693913, 1.1488134,
            1.3541653, 3.2081194, 4.8098154, 3.5190878, 3.950955, 4.4053354, 3.3853958, 0.8664518,
            1.5634239, 2.9518127, 4.0323405, 2.9237936, 3.1833906, 3.1959627, 2.603238, 0.8914801,
            0.77870804, 1.359453, 1.5308067, 1.833035, 1.5537208, 1.702244, 0.8586936, 0.5109631,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.7430913, 0.19231908, 0.26170298, 0.10480803, 0.00958306, 0.20726651, 0.20851518,
            0.17973869, 0.23704103, 0.1163867, 0.2735905, 0.8537909, 0.40303, 0.75797635,
            0.34342998, 0.74670875, 0.82946825, 0.91931367, 0.9654975, 0.18782942, 0.10021565,
            0.05109123, 0.3069365, 0.10895161, 0.9891213, 0.62504834, 0.507994, 0.47125,
            0.84314245, 0.6054993, 0.92367506, 0.6953895, 0.37023902, 0.67128026, 0.43450755,
            0.28869846, 0.27641538, 0.8369712, 0.6856483, 0.26890948, 0.65425915, 0.84581685,
            0.51146317, 0.48995435, 0.52071315, 0.80564773, 0.670521, 0.3835857, 0.47078377,
            0.5100531, 0.82525116, 0.02126783, 0.9583153, 0.23316967, 0.9487504, 0.9609589,
            0.95734006, 0.00943314, 0.7521432, 0.46106157, 0.84370506, 0.16933449, 0.71423984,
            0.5316646, 0.6400151, 0.9638914, 0.69432026, 0.8581641, 0.70813745, 0.2836983,
            0.33953485, 0.8950543,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.20262088, 0.81930757, 0.09556881, 0.22266188, 0.63842744, 0.8304186, 0.12425002,
            0.7582065, 0.09737789, 0.84872884, 0.17490041, 0.37569723, 0.6669188, 0.8970669,
            0.22398192, 0.29424527, 0.56277037, 0.41113177,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(kernel21, None, 1, Padding::Valid);
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.3851675, 1.4064949, 1.113776, 0.9166304, 0.9727396, 0.9931923, 0.5644679, 0.33757925,
            0.8261478, 2.0359373, 3.003144, 2.5258932, 2.196584, 2.504327, 2.0902455, 0.5872735,
            1.0424259, 2.9468892, 3.974762, 3.3390574, 4.290266, 3.5807762, 3.402926, 1.3383043,
            1.5809793, 3.6116273, 4.437208, 3.473799, 3.913049, 4.3254185, 3.3468862, 1.2401174,
            1.9528148, 4.193305, 5.699412, 3.6302254, 3.7545993, 4.6677623, 3.1952345, 0.79912734,
            1.9584963, 4.959979, 5.357194, 4.211625, 3.9582915, 4.618832, 3.3381195, 1.2827387,
            1.039877, 3.2919722, 3.9767313, 3.1125617, 2.76502, 3.4869695, 2.7708864, 0.89546514,
            0.3190671, 1.4299921, 1.6399691, 1.266654, 1.149711, 1.0017681, 0.90450805, 0.3960981,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.7882464, 0.24159203, 0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633,
            0.9636684, 0.98529965, 0.26998708, 0.13811645, 0.9724998, 0.41856614, 0.13321315,
            0.0937838, 0.4742414, 0.79873264, 0.1621314, 0.5493846, 0.6481355, 0.05176858,
            0.17029643, 0.955536, 0.089831, 0.05664136, 0.9231865, 0.98567015, 0.01680515,
            0.54690886, 0.8593988, 0.6496963, 0.8382851, 0.2400014, 0.36792266, 0.01756373,
            0.6596718, 0.5680892, 0.19350345, 0.4854058, 0.7869872, 0.12335967, 0.14544043,
            0.25711668, 0.05608724, 0.18204254, 0.9562488, 0.44598028, 0.3229758, 0.8930679,
            0.24216229, 0.21437034, 0.38366762, 0.64894366, 0.8650639, 0.7790032, 0.3529938,
            0.37360683, 0.26240814, 0.554433, 0.90017563, 0.6817857, 0.95833224, 0.28551313,
            0.85106283, 0.70093375, 0.4791875, 0.5805011, 0.9803199, 0.97033703, 0.48236644,
            0.66855663, 0.35855147,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.25242767, 0.6717967, 0.26290378, 0.53677225, 0.18097793, 0.07985484, 0.79416144,
            0.7215235, 0.42313012, 0.6529702, 0.00384528, 0.08442257, 0.7838985, 0.980683,
            0.36212954, 0.61172485, 0.5263662, 0.8496614, 0.13177402, 0.9175598, 0.04323238,
            0.03087392, 0.03482862, 0.36226457, 0.6059544, 0.29194582, 0.34645593, 0.9409913,
            0.60953087, 0.8610255, 0.1627552, 0.8939359, 0.66327935, 0.48094535, 0.06551108,
            0.86129206, 0.65446067, 0.9592776, 0.8000413, 0.21450381, 0.6442533, 0.46971878,
            0.84573215, 0.34651902, 0.18830031, 0.57119006, 0.27269888, 0.7915957, 0.21737069,
            0.04463017,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(kernel22, None, 1, Padding::Valid);
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.36482647, 0.84383625, 1.2507019, 1.8547151, 2.0671954, 2.1072779, 1.9187117,
            1.313128, 0.66226023, 0.26364183, 0.24163032, 1.5630312, 2.6552467, 3.4877138,
            4.3365803, 4.236132, 4.222474, 2.863784, 1.7346841, 0.9630182, 0.9040848, 1.6518975,
            4.066333, 6.043483, 6.9380865, 6.835289, 6.3522406, 4.947094, 3.0104914, 1.7385144,
            1.6146884, 3.2646532, 5.3913155, 6.7448783, 9.55292, 9.686721, 8.098556, 6.798823,
            4.1164293, 2.1044667, 1.706063, 3.9277716, 7.635542, 9.815468, 9.862004, 12.624156,
            10.635405, 8.305595, 4.821972, 2.3531003, 2.1022086, 3.9047608, 7.844469, 10.050026,
            11.729996, 12.515321, 11.4019165, 7.765052, 5.1241393, 2.1616457, 2.09995, 4.2208548,
            7.049353, 8.732849, 10.453306, 9.730744, 7.5974364, 6.520392, 4.146068, 1.2570171,
            1.445081, 3.2735777, 5.9305916, 7.7524853, 8.327122, 7.889859, 5.8646517, 4.573242,
            2.828625, 1.2891867, 1.1633031, 2.5339968, 3.7538528, 4.5006824, 4.56633, 5.2145023,
            3.2467616, 2.3340478, 1.1313534, 1.2149464, 0.35966435, 0.7745507, 1.3399862,
            1.7302079, 2.2383738, 1.6604118, 1.0748554, 0.70296305, 0.3573949, 0.41573325,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.393406, 0.8441482, 0.77705365, 0.6315176, 0.8522896, 0.16809769, 0.22305161,
            0.773223, 0.9678148, 0.2237789, 0.8982615, 0.271913, 0.34780893, 0.49277794,
            0.14560463, 0.33638617, 0.1585067, 0.18610527, 0.6963084, 0.9429821, 0.40789625,
            0.20056698, 0.37306353, 0.9367061, 0.7103306, 0.06833509, 0.48335183, 0.45182207,
            0.96346164, 0.00378525, 0.33689302, 0.28288215, 0.75004077, 0.1607512, 0.514175,
            0.35879079, 0.36688787, 0.00774159, 0.15532039, 0.01133456, 0.94680935, 0.052598,
            0.73530346, 0.8096563, 0.7097644, 0.37942106, 0.38656324, 0.13763146, 0.99930644,
            0.67476803, 0.06055127, 0.8463604, 0.4460729, 0.33209085, 0.94373864, 0.5397614,
            0.05766413, 0.64256257, 0.7357459, 0.09256811, 0.8832945, 0.03911254, 0.782554,
            0.4004812, 0.80732703, 0.8010379, 0.28867772, 0.7802926, 0.9490529, 0.5395702,
            0.1369102, 0.4513485,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.1162144, 0.9589836, 0.24819064, 0.3149064, 0.22322156, 0.39812055, 0.45308354,
            0.5711523, 0.97817534, 0.06805564, 0.5386646, 0.6699801, 0.1879456, 0.8407316,
            0.64728755, 0.53731096, 0.63207716, 0.00916763, 0.46754488, 0.8670982, 0.1932068,
            0.43971533, 0.10441232, 0.46486124, 0.22910197, 0.7679019, 0.23872072, 0.03931138,
            0.8551502, 0.19610135, 0.8555064, 0.08035298, 0.05671094, 0.9091975, 0.27582648,
            0.33816597, 0.42012835, 0.7745094, 0.14011143, 0.47505257, 0.98297566, 0.5085966,
            0.22395916, 0.01153891, 0.669607, 0.12918296, 0.55476546, 0.528783, 0.5067741,
            0.14234911,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(kernel23, None, 1, Padding::Valid);
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.32745335, 0.5689006, 1.1330106, 1.5117995, 2.0656009, 1.8279341, 0.83498514,
            1.2650348, 0.47383422, 0.04783757, 1.0610607, 1.6514534, 2.74739, 4.1643267, 4.9540834,
            4.300933, 2.6265414, 2.650314, 1.0110488, 0.11363447, 1.8616309, 3.1832135, 3.7976844,
            5.7161784, 7.666835, 6.102922, 4.820926, 3.5804868, 2.1744752, 0.29692814, 2.7398305,
            4.473556, 5.401785, 8.077239, 10.032934, 7.769857, 6.448093, 4.3656993, 3.6846666,
            0.753876, 3.3367448, 5.5719395, 6.694145, 9.35281, 10.4703865, 10.647238, 6.8387556,
            6.0518847, 4.4071198, 0.8993677, 3.3007655, 5.447144, 7.179201, 9.474049, 10.653117,
            11.655663, 6.858767, 5.3259497, 4.0362697, 1.5057273, 2.5605183, 4.700088, 5.4708767,
            6.375854, 9.53376, 8.864413, 6.173524, 4.5534105, 3.5664418, 1.4960073, 1.7854654,
            2.818278, 4.197647, 5.36206, 7.1466703, 6.3742514, 4.949965, 3.3584507, 2.822317,
            1.2140961, 0.7161268, 2.0993872, 2.7667632, 3.5030713, 3.1486084, 4.1599717, 3.4676213,
            2.2885401, 1.4538333, 0.72822726, 0.10238227, 0.4637407, 1.0126051, 1.7021126,
            1.7124138, 1.7372742, 1.1893402, 0.69816595, 0.53280723, 0.14644873,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.5152856, 0.6446142, 0.9118427, 0.8193508, 0.989135, 0.7842302, 0.59264964,
            0.35247177, 0.48483032, 0.22649786, 0.04158387, 0.5814206, 0.8653732, 0.4524277,
            0.44947338, 0.5519129, 0.79122764, 0.7513198, 0.9315116, 0.03313805, 0.41213843,
            0.45310238, 0.01799934, 0.4328227, 0.23842481, 0.20688592, 0.57869387, 0.9324833,
            0.43915927, 0.53123087, 0.5324186, 0.4149537, 0.22217223, 0.0080786, 0.65063345,
            0.7681623, 0.8421627, 0.27179125, 0.68530315, 0.9955617, 0.77906156, 0.18006648,
            0.5975193, 0.6555531, 0.9498266, 0.9690994, 0.5122471, 0.3840358, 0.8757204, 0.7260429,
            0.04691354, 0.40678895, 0.35535267, 0.19270384, 0.23519029, 0.6665529, 0.26402712,
            0.55168146, 0.08576613, 0.9567203, 0.57141143, 0.20602623, 0.75538653, 0.96776,
            0.44755465, 0.82362133, 0.29203537, 0.30861592, 0.39762703, 0.26186082, 0.9658112,
            0.27424002,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.50570756, 0.8114843, 0.5536027, 0.59788686, 0.05054026, 0.28394443, 0.6402348,
            0.02258505, 0.60607, 0.6834324, 0.8004999, 0.3349493, 0.4295082, 0.37033585, 0.0394791,
            0.50698835, 0.29841292, 0.9388161, 0.84357476, 0.29760668, 0.25654384, 0.71037215,
            0.14646496, 0.9906275, 0.9552909, 0.7966291, 0.6094893, 0.7271988, 0.09518696,
            0.3957746, 0.6157527, 0.31079137, 0.46793708, 0.8514491, 0.86081386, 0.8208274,
            0.2372746, 0.6977758, 0.79387194, 0.9463199, 0.99063903, 0.29514915, 0.8795419,
            0.741553, 0.03520088, 0.83411527, 0.47134155, 0.26704508, 0.2872401, 0.04289522,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(kernel24, None, 1, Padding::Valid);
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.9314751, 1.4739385, 2.5934894, 3.3078277, 4.1662874, 3.7456582, 2.7622135, 1.6660718,
            0.84434485, 0.11090094, 1.4405851, 2.4876194, 4.033809, 5.7555037, 6.337282, 5.9375615,
            5.2317934, 3.8515124, 2.5642648, 0.8723488, 2.77521, 4.2235675, 6.0169463, 8.092015,
            9.395473, 9.033356, 7.7293363, 5.316782, 3.0065832, 1.0435454, 3.5037763, 5.0076656,
            7.3908424, 11.022608, 11.687035, 12.117566, 9.267213, 7.2635264, 3.9742432, 1.7059844,
            4.123686, 5.6919813, 8.338599, 13.460702, 14.964471, 14.591679, 10.679282, 7.9854155,
            5.1697206, 2.627646, 3.8168626, 5.328245, 7.768558, 11.578372, 11.465536, 12.342375,
            10.595807, 7.8112087, 5.3834696, 2.9441366, 2.6486, 4.0633326, 5.4579315, 8.588892,
            9.514996, 10.576257, 7.848666, 6.939651, 5.9202385, 2.4499218, 1.7880023, 2.7189617,
            3.9024856, 6.206969, 7.216504, 8.092144, 6.5786004, 4.8320184, 3.3716333, 0.9314455,
            1.0970211, 1.4248035, 2.6882875, 4.073086, 5.0796857, 4.732806, 4.7879467, 4.0327034,
            2.280548, 0.78107315, 0.38017988, 0.8797388, 0.984866, 1.320241, 2.2612565, 2.15829,
            1.3406671, 1.1266484, 1.5027084, 0.74558204,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.583651, 0.94414073, 0.5729697, 0.72244126, 0.7707775, 0.02079507, 0.22973806,
            0.18128674, 0.05054512, 0.6523751, 0.27093726, 0.32479268, 0.53774405, 0.08921466,
            0.18494032, 0.78120434, 0.15868789, 0.81183356, 0.21792394, 0.6620494, 0.6886836,
            0.39724785, 0.59319293, 0.02472531, 0.21891202, 0.5342134, 0.4041879, 0.53426075,
            0.20461221, 0.29362342, 0.7835011, 0.47930118, 0.2895624, 0.7320774, 0.55179524,
            0.37774232, 0.04187773, 0.23883641, 0.63051957, 0.97746944, 0.6415133, 0.4162999,
            0.04763152, 0.75958186, 0.13098118, 0.6238241, 0.4102024, 0.5710282, 0.59153587,
            0.66274744, 0.6454271, 0.8120847, 0.22876394, 0.6206928, 0.19057496, 0.4622738,
            0.9772445, 0.17967562, 0.27354005, 0.48198408, 0.09082693, 0.6217685, 0.0965838,
            0.8904992, 0.5337058, 0.17222154, 0.62424076, 0.95776683, 0.998361, 0.150883,
            0.28713444, 0.35105017,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.1765902, 0.9674033, 0.65025777, 0.1959308, 0.3119046, 0.55247456, 0.38556734,
            0.18145509, 0.94255227, 0.7036003, 0.3402552, 0.16401337, 0.28418577, 0.5504918,
            0.6148071, 0.7740251, 0.37459207, 0.25677747, 0.80441076, 0.17314304, 0.5946227,
            0.30094627, 0.06480476, 0.5798754, 0.62549657, 0.6065069, 0.9259787, 0.3677915,
            0.69532603, 0.8356569, 0.39276573, 0.18570696,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(kernel25, None, 1, Padding::Valid);
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.11875411, 0.83157146, 1.7252716, 2.1375878, 2.4324155, 2.547486, 1.4550484,
            0.6104909, 0.07615383, 0.26535678, 1.3225815, 1.9909898, 3.0361319, 3.1848204,
            3.281708, 2.3762476, 1.3415042, 0.40768188, 0.9928401, 3.0609398, 3.8514547, 5.147337,
            6.4779854, 5.6766176, 4.0894847, 2.3020792, 0.8131145, 1.070654, 3.0740447, 5.013685,
            8.27501, 8.508072, 7.6797094, 5.3955803, 2.8086734, 0.95222783, 1.2292356, 3.2031817,
            5.1699963, 7.159046, 6.7330446, 7.5519824, 4.975694, 2.4399884, 1.0902047, 1.3832198,
            4.5048895, 6.8268113, 7.94546, 8.175698, 6.1785016, 4.960344, 2.7176673, 1.2129111,
            1.0731559, 3.2300818, 4.7673044, 5.986119, 5.7304883, 5.5282984, 3.285414, 1.6387076,
            0.49225426, 1.2543172, 2.7612815, 3.8261008, 4.8348866, 5.043054, 3.7123418, 2.3277664,
            1.1553535, 0.4503227, 0.6567107, 1.7551328, 2.567574, 2.699879, 2.0045557, 1.8140271,
            1.547992, 0.8505454, 0.3575745,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.61698794, 0.9064707, 0.01547038, 0.2551995, 0.11438051, 0.03861368, 0.6524532,
            0.36442748, 0.08230381, 0.79969245, 0.27816203, 0.3741886, 0.44356522, 0.27386904,
            0.4171807, 0.14990133, 0.4750283, 0.6358263, 0.77572674, 0.7072159, 0.34310365,
            0.36999545, 0.8200852, 0.46510443, 0.9230857, 0.86201537, 0.04691705, 0.12260284,
            0.89921826, 0.47400048, 0.7492544, 0.05440097, 0.28273952, 0.9184355, 0.9064988,
            0.7027802, 0.19125043, 0.8670149, 0.08634489, 0.722654, 0.77540857, 0.00211577,
            0.6443405, 0.2344423, 0.9849179, 0.9893316, 0.87634915, 0.48734385, 0.8760625,
            0.53053117, 0.01152504, 0.6788874, 0.76156837, 0.4680538, 0.07214947, 0.549209,
            0.8383253, 0.00365476, 0.9782156, 0.7419056, 0.40790308, 0.00302504, 0.80174476,
            0.7689671, 0.50054824, 0.16478458, 0.89107823, 0.7763043, 0.73042727, 0.41667554,
            0.7348974, 0.71259016,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.93557405, 0.37013116, 0.14954911, 0.33766475, 0.39673004, 0.03940821, 0.2414454,
            0.9373305, 0.84819096, 0.9272432, 0.8604789, 0.92845494, 0.8023847, 0.06647868,
            0.12827316, 0.02774826, 0.8982795, 0.1193029, 0.37523487, 0.28379655, 0.0638791,
            0.08446726, 0.68760884, 0.2630593, 0.01052708, 0.45302406, 0.10402057, 0.5539082,
            0.39986408, 0.53770447, 0.24856173, 0.12796782,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(kernel26, None, 1, Padding::Valid);
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.7490342, 1.8780754, 0.6950198, 1.627438, 1.5710692, 0.5119288, 0.61386895, 0.2652491,
            0.01363893, 1.4462106, 1.3253857, 1.8650256, 3.92945, 3.339795, 2.4746854, 2.109675,
            0.903427, 0.30140716, 2.0272818, 2.6779034, 3.488827, 4.867939, 4.96989, 4.024511,
            3.479823, 2.1331062, 0.86348987, 2.1542215, 4.1110806, 4.328575, 5.7945294, 6.392436,
            6.265216, 4.3977795, 3.2476575, 1.7054082, 2.7090063, 3.3738878, 4.050523, 6.4939895,
            7.117228, 5.899781, 4.5704484, 3.9745455, 1.7602828, 3.2586322, 3.8349247, 4.884109,
            6.7354817, 7.869287, 7.4537845, 4.6514735, 4.1786113, 1.8474928, 1.7927012, 2.8252988,
            3.7760756, 5.321213, 4.877529, 4.9405622, 4.451247, 3.6318324, 1.4854003, 1.5486668,
            2.1263099, 2.0240047, 3.722467, 4.189684, 4.363712, 3.376146, 2.118327, 1.081449,
            0.95750046, 0.8830129, 1.2575735, 1.6498599, 1.6250001, 1.6269567, 0.80763566,
            0.38646746, 0.11068954,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.80071914, 0.38390577, 0.6908975, 0.5850918, 0.71101063, 0.17578217, 0.55867785,
            0.71616316, 0.3247584, 0.9196999, 0.46712968, 0.08430128, 0.83232373, 0.49657014,
            0.24024557, 0.60874844, 0.47418702, 0.9770886, 0.99522823, 0.7749884, 0.7253688,
            0.26021662, 0.8869578, 0.5181486, 0.5871326, 0.76900613, 0.5745777, 0.81429285,
            0.78002185, 0.7069771, 0.33134556, 0.7407027, 0.58577555, 0.40479863, 0.7506117,
            0.11343616, 0.8795398, 0.83064, 0.8858372, 0.3898591, 0.9350765, 0.9673369, 0.64465624,
            0.0283905, 0.22112074, 0.1391855, 0.34128338, 0.65248054, 0.291874, 0.70765275,
            0.32796225, 0.22921298, 0.59572685, 0.5726663, 0.72872376, 0.8248998, 0.29288608,
            0.92347336, 0.25887516, 0.91578674, 0.800785, 0.7670362, 0.8990461, 0.8424308,
            0.7045559, 0.43518323, 0.48451254, 0.31151697, 0.10086012, 0.5242353, 0.19001916,
            0.01069371,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.01020448, 0.12606935, 0.04778918, 0.8456499, 0.57045126, 0.46361542, 0.7532553,
            0.62787765, 0.3127784, 0.9686197, 0.96754897, 0.5766132, 0.6463905, 0.6347338,
            0.52757853, 0.55145216, 0.08155768, 0.13378453, 0.2262157, 0.73179847, 0.5428326,
            0.9094368, 0.2528448, 0.24383228, 0.7446406, 0.5544842, 0.01949351, 0.13375893,
            0.04438103, 0.8489, 0.6848837, 0.9220802,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(kernel27, None, 1, Padding::Valid);
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.07990414, 0.2902776, 0.476054, 1.7704031, 1.3753561, 1.644088, 1.1771642, 1.5127809,
            0.85654587, 0.9924918, 2.0073104, 2.9218798, 3.9638472, 3.5860894, 3.6650074,
            3.2727022, 1.8478334, 0.8950113, 1.6063256, 3.4778829, 4.03928, 5.807488, 5.6659155,
            5.708329, 4.5240974, 2.342169, 1.6881262, 1.9142193, 4.300512, 6.3296876, 9.375547,
            8.635023, 9.091167, 7.1857634, 4.914053, 2.9862523, 1.9020145, 5.2819133, 6.542543,
            8.492962, 8.329782, 7.9350147, 7.6834345, 4.9226127, 2.7530828, 2.2174027, 5.348255,
            7.1442833, 9.598414, 9.041218, 8.82805, 7.4844823, 4.8695154, 2.1418877, 1.9076126,
            4.7981863, 6.6889534, 8.096222, 8.652669, 6.9665604, 6.081056, 3.470695, 1.6698565,
            0.87948203, 2.6368258, 3.8873074, 5.803751, 5.9142294, 5.3509183, 4.0873604, 2.3190305,
            0.85797703, 0.23568179, 1.1142275, 1.6243573, 1.9759681, 2.2694101, 1.7001762,
            1.3138413, 0.6563098, 0.07241507,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.00185038, 0.44556108, 0.00844186, 0.8082305, 0.33159012, 0.5138473, 0.65069795,
            0.9300001, 0.58097035, 0.5413155, 0.5714561, 0.21683556, 0.8548128, 0.02262598,
            0.62476623, 0.33444464, 0.98826236, 0.03221937, 0.12669064, 0.50246465,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.42635268, 0.91064155, 0.7792924, 0.07601635, 0.6067355, 0.3940292, 0.30074376,
            0.1328066, 0.72018456, 0.34319454, 0.6295161, 0.03357495, 0.03066352, 0.51702976,
            0.9283114, 0.36689135, 0.6327302, 0.37459058,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(kernel28, None, 1, Padding::Valid);
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (2, 6, 7),
        vec![
            0.00078891, 0.1916512, 0.4107876, 0.69950116, 0.8839613, 0.93180764, 0.25840566,
            0.21922082, 0.78035015, 1.6612065, 1.8438038, 2.003504, 1.4653441, 0.55249923,
            0.28325912, 1.1083186, 1.7382549, 2.386952, 1.9263572, 1.7700374, 0.93897575,
            0.34056774, 1.3530489, 2.3322053, 2.2261615, 1.6624725, 1.4345735, 1.02759, 0.1972851,
            0.41914865, 1.4312747, 0.69507444, 0.934281, 0.45405096, 0.64793277, 0.10058214,
            0.3416302, 0.3817994, 0.7541117, 0.19114235, 0.15797126, 0.36186728, 0.00063504,
            0.15407898, 0.28344724, 0.2976543, 0.6228775, 0.23587762, 0.01113312, 0.17640632,
            0.5614103, 0.97839314, 1.2494503, 1.0186151, 1.2820045, 0.32599354, 0.21255586,
            0.88442796, 1.5767231, 2.1246436, 2.073879, 1.7258203, 0.6476964, 0.32082856,
            1.4156754, 2.2586322, 1.7862289, 1.9922377, 1.2247225, 0.7996195, 0.21991754,
            0.64435405, 1.4873017, 1.56835, 0.6745621, 0.7811815, 0.7004752, 0.12270485, 0.5741981,
            0.7624043, 0.43706167, 0.27658, 0.3653817, 0.18821852,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.93406814, 0.33968034, 0.59511477, 0.4350908, 0.7094508, 0.29612544, 0.80898666,
            0.7905302, 0.4748418, 0.6989706, 0.85952836, 0.70326394, 0.38940284, 0.37933362,
            0.22292, 0.3949557, 0.27719194, 0.8619771, 0.9255003, 0.30563155,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.5844432, 0.36121982, 0.09087573, 0.23811613, 0.17829578, 0.9398569, 0.04807154,
            0.7588201, 0.05337733, 0.19222781, 0.98696715, 0.32119673, 0.3872288, 0.74463385,
            0.6260977, 0.0084233, 0.31085488, 0.10247751,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(kernel29, None, 1, Padding::Valid);
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (2, 6, 7),
        vec![
            0.54590976, 0.5359278, 0.5553942, 0.50012183, 0.62587863, 0.29580688, 0.06447186,
            0.39548522, 0.8271969, 1.861313, 1.16555, 1.4577001, 0.83104885, 0.7303017, 0.6177598,
            1.6920459, 1.5067418, 1.9312477, 1.6928035, 1.2474717, 0.7150589, 0.44973195,
            0.8889727, 2.3334253, 2.3640559, 1.5140799, 1.1465094, 0.27459657, 0.13536417,
            0.8224572, 1.224124, 0.98584443, 1.3672711, 1.1137346, 0.2991488, 0.01898613,
            0.31302536, 0.27285707, 0.7133716, 0.7629904, 0.2813201, 0.0163138, 0.17955388,
            0.98719054, 0.7496706, 0.78009945, 0.75694543, 0.8399544, 0.22787328, 0.4186216,
            1.2748486, 2.1137207, 1.9556445, 1.8282336, 1.6430691, 0.6686926, 0.28776148,
            1.8105019, 2.3452735, 2.1856337, 1.8637221, 1.4247532, 0.58192784, 0.41124997,
            1.4543166, 2.067227, 2.3274891, 2.0961494, 1.2683488, 0.30936635, 0.16017827,
            0.6745465, 1.097445, 1.3700986, 1.5068904, 0.9152061, 0.21419948, 0.00332683,
            0.12510878, 0.13390122, 0.30415148, 0.37860397, 0.18985003, 0.03132036,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.60939455, 0.00353958, 0.22236562, 0.31823838, 0.9627444, 0.866447, 0.8205645,
            0.7792785, 0.61566937, 0.59327537, 0.33567885, 0.96525836, 0.47292593, 0.2669342,
            0.705448, 0.28257245, 0.02662205, 0.05098573, 0.8293213, 0.9416077,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.9101412, 0.07020015, 0.8425068, 0.9708137, 0.3117258, 0.11623824, 0.19467542,
            0.09732427, 0.43287596, 0.20617688, 0.8857049, 0.9601851, 0.09430943, 0.28105715,
            0.6942895, 0.07089514, 0.7148581, 0.00085336,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(kernel30, None, 1, Padding::Valid);
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (2, 6, 7),
        vec![
            0.5546351, 0.04600111, 0.7160517, 0.30823407, 1.0859183, 0.33570278, 0.8111187,
            1.3801978, 1.0010545, 1.7846588, 1.6850613, 2.299428, 0.8974575, 0.6117463, 1.2653078,
            2.028793, 2.201468, 2.1105137, 2.232353, 0.76237607, 1.0800549, 0.7517384, 1.3298622,
            1.6920111, 1.8504755, 2.2939577, 1.3399928, 1.1321256, 0.3396736, 0.33451194,
            0.42195958, 1.3399343, 1.5466038, 0.57412887, 0.41482228, 0.05500991, 0.03268382,
            0.13483545, 0.17793468, 0.28609148, 0.45063454, 0.40759933, 0.12564306, 0.5404735,
            0.63411325, 0.26596236, 0.69387305, 1.1582751, 0.92441285, 0.23611298, 1.1082063,
            2.1644588, 1.7000092, 1.7504978, 1.6081592, 1.2380775, 0.19412646, 1.253116, 2.1992533,
            2.429054, 1.901942, 2.1638193, 1.0900872, 0.15134446, 1.1187032, 1.4969393, 1.6713915,
            1.9303707, 2.4385226, 1.3944091, 0.05044725, 0.3903246, 0.93231523, 0.46884912,
            0.5985245, 1.3449577, 0.65435034, 0.02003301, 0.20388658, 0.02288676, 0.09526514,
            0.659646, 0.6738236, 0.00080353,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );

    let test_input31 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.23516753, 0.04615124, 0.59699446, 0.53420085, 0.75324225, 0.38793716, 0.2669936,
            0.29911962, 0.7380972, 0.17850904, 0.65695775, 0.8119258, 0.26960826, 0.12972821,
            0.6597052, 0.7345929, 0.6485681, 0.22981846, 0.24392553, 0.26706976,
        ],
    )
    .unwrap();

    let kernel31: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.32711208, 0.9581323, 0.31259444, 0.91530424, 0.17250775, 0.715259, 0.5014661,
            0.7273789, 0.23862323, 0.4093651, 0.04974006, 0.8688277, 0.46409306, 0.20740515,
            0.19872624, 0.27135858, 0.02647329, 0.90772045, 0.97377276, 0.47016057, 0.06899374,
            0.47393376, 0.49847803, 0.02369655, 0.10663922, 0.02373338, 0.21085607, 0.56809616,
            0.70259374, 0.4123619, 0.01858313, 0.25862443, 0.4823392, 0.47215322, 0.593886,
            0.8265343, 0.06712108, 0.3228139, 0.11140465, 0.59627575, 0.49184018, 0.8395536,
            0.13370071, 0.25792846, 0.54400545, 0.8792363, 0.58678144, 0.03434712, 0.8123595,
            0.67917913,
        ],
    )
    .unwrap();
    let conv_layer31 = TransposedConvolutionLayer::new(kernel31, None, 1, Padding::Valid);
    let target_output31: Array3<f32> = Array::from_shape_vec(
        (2, 8, 9),
        vec![
            0.07692614, 0.24041826, 0.31301516, 0.9764197, 1.0276575, 1.4430869, 0.8274018,
            0.78159964, 0.12994012, 0.29510462, 0.6099706, 1.0961328, 1.7377284, 2.5185633,
            1.6492457, 1.7027388, 0.68914187, 0.33914527, 0.5040716, 1.4871658, 1.8804312,
            2.7360313, 3.0537264, 2.9018896, 1.3788993, 1.2333437, 0.33656865, 0.7932999, 2.195251,
            2.8076465, 3.083057, 4.146375, 3.1968832, 2.7475557, 1.6654062, 0.7057511, 0.6795965,
            1.640795, 2.668328, 2.8672192, 2.9163764, 3.2161975, 2.206402, 0.92185783, 0.40468284,
            0.24157503, 1.1104867, 1.9473863, 2.4191995, 2.6979823, 1.7893757, 1.2104915,
            0.8902023, 0.3822772, 0.24466407, 0.5628139, 1.4772173, 1.9333422, 1.5951638,
            1.2275035, 0.9486778, 0.4042163, 0.19591612, 0.05068231, 0.39289552, 0.6894128,
            0.46645233, 0.34229538, 0.32277358, 0.16341625, 0.03234066, 0.02848011, 0.00558132,
            0.05068183, 0.15749775, 0.33000386, 0.59906644, 0.9007787, 1.049418, 0.7495074,
            0.3106084, 0.01357721, 0.14981326, 0.42024234, 0.80244917, 1.2789183, 1.5389619,
            1.7134279, 1.1026827, 0.5209504, 0.21717495, 0.31701517, 1.3849897, 1.9084799,
            2.7289906, 1.7560401, 1.847981, 1.4420747, 0.8271914, 0.4659509, 0.82213247, 1.8455981,
            3.3030877, 3.4896202, 2.7921505, 1.8389134, 1.6216398, 1.0181276, 0.95421994,
            1.5527983, 1.9989413, 2.9467802, 4.265399, 2.7283413, 2.0109165, 1.8441029, 1.1606715,
            1.2713728, 1.9986442, 1.8057054, 2.2251961, 2.9385152, 2.1458576, 1.3276427, 1.062243,
            0.63937, 0.9389234, 2.035087, 1.4917942, 1.4229398, 2.7049646, 1.8309542, 0.5348025,
            0.82560825, 0.5933454, 0.64588076, 1.0012901, 0.6078636, 0.96835136, 1.4116327,
            0.7922789, 0.3634162, 0.3826258, 0.1813882,
        ],
    )
    .unwrap();
    let current_output31: Array3<f32> = conv_layer31.transposed_convolve(&test_input31);

    assert!(
        arr_allclose(&current_output31, &target_output31),
        "{:?} was not equal to {:?}",
        current_output31,
        target_output31
    );

    let test_input32 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.02545591, 0.2468276, 0.9191908, 0.02958322, 0.20474248, 0.76555794, 0.82307637,
            0.24628638, 0.17773865, 0.17740512, 0.4937253, 0.9466453, 0.13741271, 0.728613,
            0.5338591, 0.7898385, 0.47936276, 0.23633894, 0.8572216, 0.06004518,
        ],
    )
    .unwrap();

    let kernel32: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.3347224, 0.50485814, 0.09635731, 0.18004768, 0.24514198, 0.228041, 0.05106571,
            0.30884218, 0.38737774, 0.7948706, 0.5052517, 0.23866583, 0.5068071, 0.15044466,
            0.09537497, 0.13518302, 0.7257979, 0.86458087, 0.7176047, 0.09527912, 0.72005635,
            0.7382226, 0.41232714, 0.5491061, 0.7183669, 0.07962471, 0.04476061, 0.19437055,
            0.79608136, 0.6295519, 0.98047, 0.56819236, 0.10505454, 0.9480506, 0.10080674,
            0.9538371, 0.2355401, 0.94827145, 0.46488547, 0.60260093, 0.76637876, 0.3219317,
            0.4168223, 0.25562465, 0.8997145, 0.59076214, 0.22263806, 0.6840723, 0.24348243,
            0.94946456,
        ],
    )
    .unwrap();
    let conv_layer32 = TransposedConvolutionLayer::new(kernel32, None, 1, Padding::Valid);
    let target_output32: Array3<f32> = Array::from_shape_vec(
        (2, 8, 9),
        vec![
            0.00852066, 0.09547035, 0.43473953, 0.50233006, 0.22271901, 0.33222243, 0.25038707,
            0.04411549, 0.05019098, 0.26205438, 0.71958697, 0.80182093, 0.5407563, 0.9566441,
            0.9246667, 0.9148016, 0.1783401, 0.20623322, 0.35270116, 0.9236991, 1.4423549,
            1.4604867, 2.5201335, 1.6358178, 0.7316033, 0.51835966, 0.2914127, 0.7672069,
            1.4507123, 1.6636666, 2.8351543, 3.193253, 2.4362426, 1.2003798, 1.2002945, 0.47549617,
            0.5513912, 1.6092057, 3.0150394, 3.8959234, 3.3783472, 2.7310133, 1.9971318, 1.1323665,
            0.26262817, 1.0170554, 2.074835, 2.867242, 3.2918162, 3.3107228, 2.6670334, 1.5271199,
            0.7684081, 0.1840344, 0.46228278, 1.684182, 2.064105, 2.5561745, 3.1072998, 2.4500158,
            1.4085015, 0.94132084, 0.38922775, 0.5687282, 0.9282448, 0.8497256, 1.4230781, 1.60412,
            0.87191594, 0.66524196, 0.64877087, 0.04313447, 0.00202692, 0.020793, 0.08918633,
            0.11174008, 0.408811, 0.902056, 0.6420249, 0.18161584, 0.12889601, 0.08591607,
            0.35627496, 1.2494127, 1.395951, 1.7578359, 1.7724835, 0.47324297, 0.45021307,
            0.13232516, 0.8142001, 1.5808909, 1.8978822, 2.2582903, 3.5285459, 1.9591419,
            1.7440895, 1.1828101, 0.47735363, 1.2967, 2.44497, 2.8675318, 3.95269, 4.7912045,
            2.6209147, 2.9227567, 1.435573, 0.38273242, 1.8470922, 2.966748, 2.797512, 4.779923,
            4.689207, 3.306225, 3.1315613, 1.1137884, 0.6817666, 1.5840205, 2.184392, 2.555622,
            3.7277677, 3.8094072, 3.5906935, 1.5287493, 1.5484395, 0.6849439, 0.8969897, 1.2908117,
            1.2943509, 2.3635702, 2.5245285, 2.4178884, 1.129864, 1.6083813, 0.5609038, 0.46660668,
            0.45903748, 0.78665113, 1.0792626, 1.2546356, 1.1124523, 0.4741891, 0.8285215,
            0.05701077,
        ],
    )
    .unwrap();
    let current_output32: Array3<f32> = conv_layer32.transposed_convolve(&test_input32);

    assert!(
        arr_allclose(&current_output32, &target_output32),
        "{:?} was not equal to {:?}",
        current_output32,
        target_output32
    );

    let test_input33 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.34627816, 0.9748906, 0.7407666, 0.9677088, 0.13005458, 0.69001645, 0.14445187,
            0.9216249, 0.03732051, 0.44508553, 0.666532, 0.9382296, 0.80578685, 0.976145,
            0.6098745, 0.04455515, 0.5690737, 0.6428197, 0.21377262, 0.6692434,
        ],
    )
    .unwrap();

    let kernel33: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.86947584, 0.12576632, 0.8154824, 0.3646563, 0.32867205, 0.00950876, 0.02384425,
            0.68798536, 0.6243543, 0.061506, 0.4878141, 0.24558064, 0.15653013, 0.40195072,
            0.52372193, 0.62839466, 0.67610437, 0.6370576, 0.74306166, 0.8282889, 0.39436254,
            0.45260343, 0.6606655, 0.7309763, 0.40489906, 0.9551375, 0.4431474, 0.6631732,
            0.18731794, 0.43634078, 0.4686375, 0.7620647, 0.57885796, 0.26523942, 0.13030814,
            0.7995473, 0.951001, 0.58605653, 0.82163817, 0.21192186, 0.12197074, 0.06249312,
            0.3968833, 0.23130116, 0.670139, 0.89535373, 0.9697048, 0.7154457, 0.8203782,
            0.21395262,
        ],
    )
    .unwrap();
    let conv_layer33 = TransposedConvolutionLayer::new(kernel33, None, 1, Padding::Valid);
    let target_output33: Array3<f32> = Array::from_shape_vec(
        (2, 8, 9),
        vec![
            0.3010805, 0.8911939, 1.0490708, 1.8558415, 1.3081785, 1.3960505, 0.7024076,
            0.36548406, 0.0427453, 0.6032453, 0.229905, 1.6507176, 1.4315509, 2.5866408, 1.6612977,
            1.4187112, 0.3152895, 0.15428631, 0.75501406, 1.4780263, 2.5040576, 3.4565327,
            3.6334167, 3.0872674, 2.3016224, 1.3824986, 0.29593655, 0.5992766, 1.6118703,
            3.0937033, 4.368976, 5.574489, 4.5504513, 3.8964264, 1.8517506, 0.59829634, 0.8957292,
            1.7263255, 2.856685, 4.3909445, 5.6037383, 4.480788, 3.7111497, 2.0358908, 0.7818855,
            0.71269643, 1.698038, 2.9103205, 3.6519809, 4.7237334, 4.122585, 3.0031252, 1.9831227,
            1.0358645, 0.29085344, 1.0594041, 1.9998547, 2.8213186, 3.6047318, 3.427512, 2.5603576,
            1.5153986, 0.8012645, 0.01757088, 0.24458715, 0.54050475, 0.7837824, 1.2193873,
            1.1444374, 0.85868585, 0.5757574, 0.27097604, 0.33074325, 1.0846068, 1.3691965,
            1.9639492, 1.3780239, 1.2635353, 0.5907446, 0.4466124, 0.05674811, 0.82133955,
            1.164507, 2.692419, 2.3432975, 2.9119003, 1.4404482, 1.1327876, 0.2602529, 0.21115613,
            1.2368631, 2.893825, 4.291187, 5.3570166, 5.2475915, 3.608062, 2.3548453, 0.9750261,
            0.35167277, 0.94885474, 2.423169, 3.9415066, 4.8554416, 5.142418, 4.6227126, 2.7399867,
            1.5597908, 0.5529678, 0.94800735, 2.9540744, 4.9395003, 6.4209714, 7.1825995,
            4.8787208, 3.7064042, 1.3550252, 0.5425483, 0.7347302, 1.4519112, 2.961642, 3.4448566,
            4.071216, 3.8964398, 2.2581432, 1.7635199, 0.6457552, 0.60221636, 1.5585814, 2.239789,
            3.1758385, 3.4930294, 2.808273, 2.1553762, 1.0072306, 0.5789704, 0.03989262, 0.5527276,
            1.1592612, 1.2584409, 1.7427968, 1.4510213, 0.79171467, 0.5947699, 0.14318638,
        ],
    )
    .unwrap();
    let current_output33: Array3<f32> = conv_layer33.transposed_convolve(&test_input33);

    assert!(
        arr_allclose(&current_output33, &target_output33),
        "{:?} was not equal to {:?}",
        current_output33,
        target_output33
    );

    let test_input34 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.7457981, 0.7147152, 0.05275504, 0.93545914, 0.8986874, 0.8690856, 0.63580817,
            0.15263815, 0.7466949, 0.6235891, 0.62486136, 0.7352324, 0.23342584, 0.9827126,
            0.93357897, 0.96423954, 0.02081718, 0.47192466, 0.50718915, 0.9034243,
        ],
    )
    .unwrap();

    let kernel34: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.678573, 0.48106775, 0.27722874, 0.0061415, 0.2891619, 0.9937529, 0.02278532,
            0.7661429, 0.23943478, 0.7568481, 0.1846646, 0.05945846, 0.7522374, 0.723256,
            0.5690188, 0.80126184,
        ],
    )
    .unwrap();
    let conv_layer34 = TransposedConvolutionLayer::new(kernel34, None, 1, Padding::Valid);
    let target_output34: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.5060785, 0.84376585, 0.5863812, 0.862876, 1.0788589, 0.6919897, 0.2548871,
            0.00551929, 0.8053944, 1.7973387, 1.3928767, 1.6723158, 2.5668395, 1.4627372,
            0.9146349, 0.6923528, 0.85389054, 2.582601, 2.0723832, 2.4749677, 3.5638423, 2.3326871,
            1.0727106, 0.5369265, 1.6040995, 3.1985884, 3.0691655, 3.804005, 5.5388613, 3.5505612,
            2.4482102, 1.4779649, 1.0821936, 2.7200508, 1.9760578, 3.669984, 3.4515169, 3.1710286,
            1.5931258, 1.2473195, 0.7009165, 1.7397712, 1.3697224, 2.366889, 2.823525, 2.2269084,
            1.5156213, 0.80175745, 0.725337, 0.7130515, 0.9187259, 1.5073028, 1.3316312, 1.3201424,
            0.9204567, 0.72387946,
        ],
    )
    .unwrap();
    let current_output34: Array3<f32> = conv_layer34.transposed_convolve(&test_input34);

    assert!(
        arr_allclose(&current_output34, &target_output34),
        "{:?} was not equal to {:?}",
        current_output34,
        target_output34
    );

    let test_input35 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.13196982, 0.2549996, 0.9684265, 0.09975351, 0.6575368, 0.01221572, 0.5690517,
            0.8633032, 0.5916843, 0.7327984, 0.38392547, 0.45234743, 0.88714564, 0.48625886,
            0.4974664, 0.280569, 0.3272779, 0.7308698, 0.16297498, 0.8690239,
        ],
    )
    .unwrap();

    let kernel35: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.5834708, 0.33016786, 0.2406453, 0.599151, 0.8538999, 0.30761606, 0.3641591,
            0.11430372, 0.45364544, 0.6984523, 0.7053654, 0.4003387, 0.38632825, 0.91106904,
            0.5180514, 0.1837249,
        ],
    )
    .unwrap();
    let conv_layer35 = TransposedConvolutionLayer::new(kernel35, None, 1, Padding::Valid);
    let target_output35: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.07700054, 0.19235703, 0.6809992, 0.5183809, 0.80241954, 0.8213365, 0.21800056,
            0.39396384, 0.11981653, 0.5943985, 1.6479738, 1.2655523, 2.1455843, 1.2508713,
            0.78170294, 0.5142158, 0.29430783, 1.0882163, 2.386551, 2.8492892, 3.275631, 2.2696834,
            1.2492814, 0.6450565, 0.54806304, 1.27338, 3.1110337, 3.83485, 4.357867, 3.299008,
            1.6562412, 0.9917122, 0.41846314, 1.0700992, 2.6744301, 3.1403868, 3.8418615,
            2.5885842, 1.36899, 0.43312103, 0.27560008, 0.8689693, 1.7117897, 2.228566, 2.3325064,
            1.8826481, 1.0252756, 0.43930086, 0.10839172, 0.3820544, 0.7258776, 0.949929,
            0.9229672, 1.0104492, 0.4801416, 0.15966132,
        ],
    )
    .unwrap();
    let current_output35: Array3<f32> = conv_layer35.transposed_convolve(&test_input35);

    assert!(
        arr_allclose(&current_output35, &target_output35),
        "{:?} was not equal to {:?}",
        current_output35,
        target_output35
    );

    let test_input36 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.38816592, 0.16589011, 0.91154295, 0.93466866, 0.9079338, 0.6218017, 0.7199313,
            0.5790186, 0.5812801, 0.5897581, 0.00632351, 0.51240736, 0.3697457, 0.13892107,
            0.9900367, 0.47229373, 0.56468743, 0.59834725, 0.6383385, 0.03793695,
        ],
    )
    .unwrap();

    let kernel36: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.9450343, 0.96132326, 0.6061949, 0.63035446, 0.5111371, 0.03746503, 0.558335,
            0.30164844, 0.68653256, 0.99669343, 0.5127781, 0.25915265, 0.34361982, 0.6647127,
            0.42920145, 0.22015804,
        ],
    )
    .unwrap();
    let conv_layer36 = TransposedConvolutionLayer::new(kernel36, None, 1, Padding::Valid);
    let target_output36: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.3668301, 0.5299248, 1.2562177, 2.1048253, 2.4136899, 2.0140045, 1.1395574, 0.5723201,
            0.78602993, 1.3774475, 2.3050773, 2.6559348, 2.9790328, 2.1151435, 1.5127935,
            0.64563346, 0.5902904, 1.3823724, 2.5061371, 3.4455388, 4.5452943, 3.4107718,
            1.9001399, 1.0372671, 1.0098345, 2.678847, 3.630334, 4.781564, 5.0691814, 3.2680774,
            2.0685709, 0.6752831, 0.45941156, 1.3251163, 2.302878, 2.5652447, 2.6843164, 2.4611192,
            1.1385047, 0.39785424, 0.32641792, 1.038685, 1.6861567, 1.9613932, 1.8194773,
            1.3193185, 0.64039016, 0.227796, 0.16228949, 0.5079775, 0.78366804, 0.9634187,
            0.81847966, 0.43092394, 0.15681794, 0.00835212,
        ],
    )
    .unwrap();
    let current_output36: Array3<f32> = conv_layer36.transposed_convolve(&test_input36);

    assert!(
        arr_allclose(&current_output36, &target_output36),
        "{:?} was not equal to {:?}",
        current_output36,
        target_output36
    );

    let test_input37 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.22396304, 0.553291, 0.21043801, 0.03016802, 0.13123624, 0.4177692, 0.15363416,
            0.26550946, 0.9799374,
        ],
    )
    .unwrap();

    let kernel37: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.6468661, 0.22700246, 0.28266105, 0.7568015, 0.49555436, 0.7577122, 0.20788053,
            0.91674453, 0.56273526, 0.45675126, 0.48490578, 0.82385767, 0.42006218, 0.8251126,
            0.35886785, 0.09741933, 0.50827706, 0.09494945,
        ],
    )
    .unwrap();
    let conv_layer37 = TransposedConvolutionLayer::new(kernel37, None, 1, Padding::Valid);
    let target_output37: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            0.1448741, 0.40874538, 0.32502925, 0.20416377, 0.05948263, 0.18901022, 0.6214578,
            0.91170406, 0.6554488, 0.2775385, 0.16876948, 0.6412294, 1.8186519, 1.1082382,
            0.7119598, 0.12254191, 0.33200988, 1.2137357, 1.1436309, 0.977604, 0.03193755,
            0.19603752, 0.5335696, 1.0477637, 0.5514453, 0.1022954, 0.36131734, 0.5489255,
            0.55787563, 0.17337097, 0.10785768, 0.4917823, 0.9046056, 0.6828921, 0.41970178,
            0.10466337, 0.4435258, 1.3204983, 1.2452179, 0.9772338, 0.06747485, 0.2664146,
            0.79611176, 1.1286448, 0.39133498, 0.01496694, 0.10395446, 0.24500468, 0.5232897,
            0.09304452,
        ],
    )
    .unwrap();
    let current_output37: Array3<f32> = conv_layer37.transposed_convolve(&test_input37);

    assert!(
        arr_allclose(&current_output37, &target_output37),
        "{:?} was not equal to {:?}",
        current_output37,
        target_output37
    );

    let test_input38 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9338919, 0.41674572, 0.12654002, 0.47637334, 0.72644436, 0.22123201, 0.29542014,
            0.46568522, 0.6850643,
        ],
    )
    .unwrap();

    let kernel38: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.6808416, 0.3779981, 0.805789, 0.2891591, 0.6993045, 0.33186397, 0.9734199, 0.9644196,
            0.09362596, 0.0414281, 0.27610767, 0.43870836, 0.34610718, 0.3848816, 0.24301769,
            0.23232727, 0.32100558, 0.22719596,
        ],
    )
    .unwrap();
    let conv_layer38 = TransposedConvolutionLayer::new(kernel38, None, 1, Padding::Valid);
    let target_output38: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            0.6358325, 0.63674724, 0.9962026, 0.383641, 0.10196456, 0.5943781, 1.4482424,
            1.4470224, 0.89577913, 0.22026038, 1.2479509, 2.2782464, 2.2230937, 1.1910422,
            0.6372836, 0.54913473, 1.5078049, 1.5823374, 0.9149873, 0.24806122, 0.28756785,
            0.7382163, 1.1436301, 0.7042897, 0.06413981, 0.03868936, 0.2751197, 0.5300152,
            0.21776849, 0.05551416, 0.34296194, 0.66530204, 0.8498775, 0.5297606, 0.1278078,
            0.3940835, 0.9322411, 1.1338484, 0.79044145, 0.38305613, 0.21292154, 0.59657013,
            0.88095266, 0.6129004, 0.21674576, 0.06863415, 0.20302288, 0.37576494, 0.32571128,
            0.15564385,
        ],
    )
    .unwrap();
    let current_output38: Array3<f32> = conv_layer38.transposed_convolve(&test_input38);

    assert!(
        arr_allclose(&current_output38, &target_output38),
        "{:?} was not equal to {:?}",
        current_output38,
        target_output38
    );

    let test_input39 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.85453415, 0.76819396, 0.8545096, 0.653471, 0.6439924, 0.61992764, 0.5419032,
            0.42076096, 0.7094996,
        ],
    )
    .unwrap();

    let kernel39: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.8802664, 0.30416232, 0.00992903, 0.07512625, 0.21167818, 0.9575676, 0.33277866,
            0.5804159, 0.14874539, 0.84465176, 0.33960778, 0.03217437, 0.23459853, 0.86872333,
            0.05481404, 0.4075119, 0.13763186, 0.38947833,
        ],
    )
    .unwrap();
    let conv_layer39 = TransposedConvolutionLayer::new(kernel39, None, 1, Padding::Valid);
    let target_output39: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            0.7522177, 0.93613243, 0.9943365, 0.26753706, 0.00848445, 0.6394265, 1.004244,
            1.7931483, 1.1114315, 0.8244059, 0.81048274, 1.4735384, 2.4238863, 1.5781084,
            0.7277716, 0.25817236, 0.7399112, 1.3385597, 1.0086993, 0.7716052, 0.18033382,
            0.4545495, 0.5609283, 0.4743911, 0.10553479, 0.72178376, 0.93906283, 1.0101417,
            0.31491426, 0.02749331, 0.7524279, 1.6884441, 1.678008, 1.0156925, 0.0667849,
            0.9592557, 1.6888556, 2.2870872, 1.2451375, 0.3896214, 0.3934269, 0.92184687,
            1.1574509, 0.9755653, 0.28033894, 0.22083199, 0.24604824, 0.5580992, 0.26152703,
            0.2763347,
        ],
    )
    .unwrap();
    let current_output39: Array3<f32> = conv_layer39.transposed_convolve(&test_input39);

    assert!(
        arr_allclose(&current_output39, &target_output39),
        "{:?} was not equal to {:?}",
        current_output39,
        target_output39
    );

    let test_input40 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.19455469, 0.2231027, 0.710135, 0.38075933, 0.36192992, 0.5788371, 0.45671245,
            0.02821646, 0.65663046,
        ],
    )
    .unwrap();

    let kernel40: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.6821529, 0.13092387, 0.04243296, 0.40237483, 0.96532, 0.08922233, 0.65666056,
            0.07955468, 0.30693734, 0.61528814, 0.8301079, 0.9080613, 0.10633651, 0.95870477,
            0.24841434, 0.49642795, 0.02807361, 0.67816275, 0.14359485, 0.96717685, 0.970054,
            0.53526694, 0.789418, 0.44380167, 0.1696324, 0.22258878, 0.54548246, 0.33204898,
            0.6242531, 0.39491078, 0.95525235, 0.17685722, 0.4390062, 0.25685027, 0.9619644,
            0.7054154, 0.25693816, 0.06693318, 0.71142703, 0.30001205, 0.24983038, 0.04385825,
            0.83179814, 0.9035203, 0.99454165, 0.4820838, 0.2207663, 0.6613494, 0.6531026,
            0.941437,
        ],
    )
    .unwrap();
    let conv_layer40 = TransposedConvolutionLayer::new(kernel40, None, 1, Padding::Valid);
    let target_output40: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.13271604, 0.17766201, 0.5218857, 0.18072444, 0.30771157, 0.5011059, 0.6855075,
            0.27709472, 0.44440418, 0.68373775, 0.78813195, 0.78242815, 0.93752706, 0.99570066,
            0.50702137, 0.72323126, 1.6033657, 1.651788, 1.2092388, 1.4280392, 1.1664178,
            0.45340267, 1.0648326, 1.4538226, 1.701925, 1.5468223, 1.1814997, 1.2346345, 0.7568687,
            0.9490674, 2.136864, 1.9960628, 1.715717, 1.422697, 0.84341615, 0.596082, 0.58172846,
            1.6922978, 0.8676789, 1.5732343, 0.43986297, 0.7332673, 0.44303572, 0.27183455,
            1.0126073, 0.57643694, 0.60835165, 0.29620013, 0.1113858, 0.04330569, 0.15578632,
            0.34436837, 0.58289856, 0.45190388, 0.5314096, 0.28043997, 0.27060157, 0.53578687,
            1.255926, 0.9471215, 1.1247164, 0.9012861, 0.9117136, 0.60262215, 0.87585235, 1.668588,
            1.3475182, 1.3939819, 1.4900275, 1.0291802, 0.75347483, 0.52514, 1.7085658, 1.0821625,
            2.1310754, 1.579689, 1.5115721, 0.51108897, 0.39487702, 1.498483, 1.5973697, 2.1867287,
            2.0323837, 1.441222, 0.29765853, 0.28561932, 1.1559412, 1.0807428, 2.0035496,
            1.3401157, 1.1979849, 0.22017367, 0.11442941, 0.62482667, 0.46190292, 0.8826564,
            0.45541108, 0.6181762,
        ],
    )
    .unwrap();
    let current_output40: Array3<f32> = conv_layer40.transposed_convolve(&test_input40);

    assert!(
        arr_allclose(&current_output40, &target_output40),
        "{:?} was not equal to {:?}",
        current_output40,
        target_output40
    );

    let test_input41 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.02962555, 0.00604056, 0.6749602, 0.09254023, 0.16296797, 0.7694261, 0.49170363,
            0.04446485, 0.8114944,
        ],
    )
    .unwrap();

    let kernel41: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.29030007, 0.1919063, 0.18254054, 0.13724734, 0.00911832, 0.20514874, 0.59104544,
            0.815183, 0.26495343, 0.62743604, 0.94401777, 0.54503894, 0.6431647, 0.52856827,
            0.51207054, 0.03335644, 0.28076503, 0.07791043, 0.86478263, 0.980501, 0.54355013,
            0.03467919, 0.886572, 0.36146563, 0.13580918, 0.8819829, 0.48148784, 0.09721047,
            0.7819647, 0.49357224, 0.6708243, 0.72222507, 0.366483, 0.37231642, 0.11044633,
            0.88196933, 0.7812372, 0.2546282, 0.8222847, 0.328725, 0.78940445, 0.46583235,
            0.3009351, 0.90517753, 0.7002328, 0.750793, 0.75040495, 0.53337294, 0.51972127,
            0.72387767,
        ],
    )
    .unwrap();
    let conv_layer41 = TransposedConvolutionLayer::new(kernel41, None, 1, Padding::Valid);
    let target_output41: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.0086003, 0.00743891, 0.20250808, 0.1346978, 0.12430678, 0.09269157, 0.0061545,
            0.03294208, 0.08381792, 0.4377191, 0.6018126, 0.73406684, 0.2897108, 0.43051022,
            0.18969317, 0.21724679, 1.3229922, 1.2308897, 1.3396556, 0.7777507, 0.83579236,
            0.1892202, 0.5125431, 1.494799, 1.4348475, 1.6970626, 1.322669, 1.5649605, 0.48336673,
            0.34570205, 1.5785269, 1.0790163, 1.6934358, 1.5216713, 1.2616313, 0.06670173,
            0.23132683, 0.58377844, 0.8611364, 1.3374189, 1.0456177, 0.9001662, 0.2672656,
            0.04122076, 0.87856054, 0.24529722, 0.8022986, 0.29936606, 0.11020839, 0.02612923,
            0.01959202, 0.60109174, 0.34873846, 0.08495905, 0.5307765, 0.33314162, 0.10149243,
            0.21374044, 1.2340833, 0.9593917, 0.5007892, 0.9340665, 0.45431423, 0.5218813,
            0.48059645, 2.0602527, 1.9826229, 0.8957945, 1.5179709, 0.7073877, 0.43485093,
            0.61954635, 2.1307209, 1.8471941, 0.9579365, 1.6084912, 0.8151854, 0.52896184,
            0.621876, 2.113895, 2.0659564, 1.2332796, 1.8476427, 1.2941245, 0.4576316, 0.45595002,
            1.5586114, 1.5488795, 1.1908395, 1.2835382, 1.1252053, 0.36916763, 0.40236074,
            0.9048923, 0.8882146, 0.81187177, 0.453938, 0.58742267,
        ],
    )
    .unwrap();
    let current_output41: Array3<f32> = conv_layer41.transposed_convolve(&test_input41);

    assert!(
        arr_allclose(&current_output41, &target_output41),
        "{:?} was not equal to {:?}",
        current_output41,
        target_output41
    );

    let test_input42 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9831707, 0.20632543, 0.16955712, 0.76152086, 0.05444199, 0.2814817, 0.15761587,
            0.95890856, 0.90069485,
        ],
    )
    .unwrap();

    let kernel42: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.01261302, 0.21181779, 0.78206104, 0.92161584, 0.74544144, 0.8816592, 0.9976662,
            0.2966056, 0.2162454, 0.06208929, 0.50320554, 0.6565798, 0.5351854, 0.10227188,
            0.28489798, 0.20003575, 0.1822242, 0.05310873, 0.13790856, 0.78958035, 0.5917116,
            0.38009274, 0.2742251, 0.9041115, 0.99974847, 0.9090851, 0.4171188, 0.48332873,
            0.169661, 0.15740211, 0.04401799, 0.33348852, 0.42292982, 0.4798304, 0.90991354,
            0.54084134, 0.4826352, 0.5674032, 0.6246967, 0.70394504, 0.12639284, 0.16602974,
            0.4649844, 0.36747122, 0.75747913, 0.91581804, 0.02039539, 0.51063865, 0.6296097,
            0.55201155,
        ],
    )
    .unwrap();
    let conv_layer42 = TransposedConvolutionLayer::new(kernel42, None, 1, Padding::Valid);
    let target_output42: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.01240075, 0.21085542, 0.8147415, 1.10338, 1.055653, 0.31007004, 0.12639491,
            0.8764265, 1.3247752, 1.2575873, 1.2469943, 0.9939326, 0.34947786, 0.22035582,
            1.1681268, 1.6025776, 1.6130666, 1.8699183, 2.2401304, 1.6852769, 0.7371987, 0.7188343,
            1.7505033, 2.5061994, 1.6863707, 1.6712167, 0.484901, 0.26999605, 0.81339806,
            1.2314546, 1.7222204, 2.2898188, 2.464713, 0.806684, 0.648373, 0.4821295, 0.5421999,
            0.7593554, 1.0472096, 1.1922672, 1.190268, 0.99258184, 0.09326313, 0.6273059, 0.940648,
            0.74780667, 1.2715296, 1.772996, 0.9004683, 0.89378583, 0.5976663, 0.71539867,
            0.3372542, 0.27171034, 0.06124329, 0.02668865, 0.7355645, 0.70409524, 1.1387475,
            0.8884868, 1.3304622, 0.3254227, 0.19858813, 0.7085462, 1.779931, 2.396721, 2.1612904,
            2.3781145, 0.7395116, 0.5172542, 0.5430656, 0.6810672, 1.5495402, 1.9093909, 2.6136446,
            1.7374641, 1.1461381, 1.0819014, 0.9370132, 2.099616, 2.1569726, 2.707972, 1.6030039,
            0.9408537, 0.71733606, 0.21275857, 0.99409604, 1.1663411, 1.488952, 1.2646089,
            0.8376387, 0.14434746, 0.8814004, 0.92491466, 0.60726225, 1.1506735, 1.0964148,
            0.49719396,
        ],
    )
    .unwrap();
    let current_output42: Array3<f32> = conv_layer42.transposed_convolve(&test_input42);

    assert!(
        arr_allclose(&current_output42, &target_output42),
        "{:?} was not equal to {:?}",
        current_output42,
        target_output42
    );

    let test_input43 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.25472447, 0.48130554, 0.324559, 0.66492975, 0.01730853, 0.77949584, 0.13672462,
            0.73892075, 0.02376527,
        ],
    )
    .unwrap();

    let kernel43: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.8798877, 0.6356067, 0.22369854, 0.584571, 0.96449506, 0.7977554, 0.32541806,
            0.10196066, 0.8232674, 0.8543414, 0.9710584, 0.505133, 0.04858193, 0.16233306,
            0.651015, 0.62667716,
        ],
    )
    .unwrap();
    let conv_layer43 = TransposedConvolutionLayer::new(kernel43, None, 1, Padding::Valid);
    let target_output43: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.22412893, 0.5853994, 0.648478, 0.4628638, 0.35396063, 0.18972778, 0.830744, 1.105288,
            1.6255056, 1.3295394, 0.33918172, 0.48876292, 0.97133017, 1.8980805, 2.4289174,
            1.828932, 1.2509837, 0.25731584, 0.69166017, 1.4688178, 2.2188277, 1.8176525,
            1.3616697, 0.59956586, 0.14486448, 0.8339198, 1.2571818, 1.3614054, 0.914641,
            0.50049686, 0.00664235, 0.05809312, 0.21011561, 0.5705885, 0.4785363, 0.01489315,
        ],
    )
    .unwrap();
    let current_output43: Array3<f32> = conv_layer43.transposed_convolve(&test_input43);

    assert!(
        arr_allclose(&current_output43, &target_output43),
        "{:?} was not equal to {:?}",
        current_output43,
        target_output43
    );

    let test_input44 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.04012987, 0.8986551, 0.5988572, 0.7548613, 0.9230523, 0.8094736, 0.41193417,
            0.11411006, 0.29621908,
        ],
    )
    .unwrap();

    let kernel44: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.8657136, 0.3099813, 0.7817938, 0.5514695, 0.9309671, 0.35345063, 0.04673942,
            0.2836077, 0.4491099, 0.16020048, 0.0033604, 0.7036799, 0.09309967, 0.8027366,
            0.66168624, 0.75922126,
        ],
    )
    .unwrap();
    let conv_layer44 = TransposedConvolutionLayer::new(kernel44, None, 1, Padding::Valid);
    let target_output44: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.03474097, 0.79041743, 0.8283783, 0.9103279, 0.9637637, 0.3302515, 0.6908533,
            1.8838941, 2.4540694, 1.6538914, 1.4247324, 0.6162405, 1.0773908, 1.7626399, 2.1420414,
            1.0787339, 1.2285075, 0.8143325, 0.7262489, 0.9031903, 1.6529989, 1.9966404, 1.7769948,
            1.1082854, 0.25528103, 0.80913067, 1.4685106, 2.1713796, 1.3177109, 0.82301295,
            0.03835094, 0.34129822, 0.39174938, 0.6260401, 0.28263888, 0.22489582,
        ],
    )
    .unwrap();
    let current_output44: Array3<f32> = conv_layer44.transposed_convolve(&test_input44);

    assert!(
        arr_allclose(&current_output44, &target_output44),
        "{:?} was not equal to {:?}",
        current_output44,
        target_output44
    );

    let test_input45 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.98626304, 0.41794768, 0.85175455, 0.6952307, 0.8909816, 0.77955645, 0.25186005,
            0.6967979, 0.44887283,
        ],
    )
    .unwrap();

    let kernel45: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.443149, 0.75464064, 0.81323266, 0.85127234, 0.15431848, 0.56885445, 0.29611066,
            0.87579244, 0.9531821, 0.5536974, 0.53754663, 0.23263316, 0.527793, 0.6797737,
            0.74194604, 0.01885639,
        ],
    )
    .unwrap();
    let conv_layer45 = TransposedConvolutionLayer::new(kernel45, None, 1, Padding::Valid);
    let target_output45: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.4370615, 0.9294872, 1.4949157, 1.8222358, 1.0484619, 0.72507507, 0.46028942,
            1.5450242, 2.2444508, 3.376736, 2.0106778, 1.409575, 1.1589868, 1.9763007, 3.3360305,
            3.3616774, 2.524439, 1.262989, 1.2220908, 2.3760412, 3.6157508, 2.6622584, 2.009323,
            0.5905311, 0.60700643, 1.7464828, 2.4819932, 1.885784, 0.9985779, 0.11912232,
            0.13292997, 0.53897285, 0.8974434, 0.8268676, 0.34617853, 0.00846412,
        ],
    )
    .unwrap();
    let current_output45: Array3<f32> = conv_layer45.transposed_convolve(&test_input45);

    assert!(
        arr_allclose(&current_output45, &target_output45),
        "{:?} was not equal to {:?}",
        current_output45,
        target_output45
    );

    let test_input46 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.08134871, 0.6701397, 0.42471457, 0.93320847, 0.6966494, 0.5644708, 0.03809474,
            0.09368633, 0.5213245, 0.7867202, 0.5103296, 0.05583452,
        ],
    )
    .unwrap();

    let kernel46: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.7863488, 0.5674216, 0.06023929, 0.39982173, 0.32429224, 0.11995548, 0.8987073,
            0.1602559, 0.33672985, 0.742261, 0.14132027, 0.06929818, 0.4782574, 0.5697997,
            0.11632108, 0.49556065, 0.47647962, 0.7417032, 0.34966558, 0.47131556, 0.9838283,
            0.6777289, 0.90295655, 0.67075133, 0.0573609, 0.8237337, 0.36602104, 0.15022676,
            0.66375136, 0.17951131, 0.7120909, 0.48833874, 0.85454535, 0.18296848, 0.10698621,
            0.61914563, 0.5212063, 0.922373, 0.6521379, 0.45965454, 0.3666493, 0.99957263,
            0.63527644, 0.17045999, 0.32906872, 0.39238515, 0.8330784, 0.24240606, 0.16471672,
            0.39931872, 0.18019378, 0.04206449, 0.4967664, 0.8137173, 0.2356948, 0.4160782,
            0.9648439, 0.08041501, 0.65951824, 0.8111227, 0.5044555, 0.5347742, 0.6593625,
            0.2873256, 0.93752426, 0.7753997, 0.7233747, 0.5849598, 0.73156756, 0.514743,
            0.9262702, 0.2988856, 0.6292863, 0.3348592, 0.68505603, 0.09462127, 0.39446756,
            0.7353366, 0.06431016, 0.30438656, 0.65234166, 0.58759433, 0.62632954, 0.4344534,
            0.21980144, 0.00100083, 0.6921164, 0.8472264, 0.3598078, 0.8860002, 0.3531883,
            0.25727805, 0.25435162, 0.7503538, 0.4171089, 0.7314984,
        ],
    )
    .unwrap();
    let conv_layer46 = TransposedConvolutionLayer::new(kernel46, None, 1, Padding::Valid);
    let target_output46: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            1.1480414, 2.3247576, 1.5501, 1.4386592, 1.0776258, 1.6158369, 3.5176475, 3.0050836,
            2.7867057, 1.0657783, 1.1418083, 2.600077, 3.2426243, 2.3555624, 0.42640322, 0.9519217,
            2.427582, 3.0440452, 1.2805247, 0.7943156, 0.41696715, 1.131382, 0.7235187, 0.5652343,
            0.5021668, 0.4935925, 1.5703452, 1.6652186, 1.1229213, 0.6813847, 1.082245, 2.8617651,
            2.7501378, 2.8704119, 1.8189253, 1.4133422, 2.7473388, 3.422234, 3.2433038, 1.47317,
            0.7827617, 2.6770704, 2.9337413, 2.4478598, 1.2954756, 0.43092513, 1.1604215,
            0.79993474, 1.3412471, 0.52348316,
        ],
    )
    .unwrap();
    let current_output46: Array3<f32> = conv_layer46.transposed_convolve(&test_input46);

    assert!(
        arr_allclose(&current_output46, &target_output46),
        "{:?} was not equal to {:?}",
        current_output46,
        target_output46
    );

    let test_input47 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.4653744, 0.71255463, 0.95627284, 0.9875905, 0.22617352, 0.7417731, 0.37862286,
            0.5094745, 0.18060002, 0.9620671, 0.49016726, 0.45882288,
        ],
    )
    .unwrap();

    let kernel47: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.75507283, 0.45673513, 0.9690947, 0.10567724, 0.2728893, 0.70271283, 0.8472397,
            0.55496895, 0.91851914, 0.9672113, 0.64802116, 0.21997769, 0.3842727, 0.94689554,
            0.74909705, 0.3282922, 0.2643334, 0.3491095, 0.3052412, 0.5038705, 0.37622157,
            0.04119791, 0.7131295, 0.14328648, 0.13365868, 0.36297327, 0.68727154, 0.93408334,
            0.21441843, 0.91439056, 0.40976977, 0.9953925, 0.3781238, 0.28116077, 0.97598535,
            0.36442432, 0.14792818, 0.83921397, 0.625257, 0.09807894, 0.3419448, 0.9480976,
            0.12152596, 0.29696485, 0.41873357, 0.95614773, 0.47523478, 0.25687808, 0.7602087,
            0.78506595, 0.43647116, 0.97631705, 0.26839125, 0.08090039, 0.48662946, 0.70590997,
            0.99664134, 0.77797663, 0.2436962, 0.6407154, 0.34835714, 0.8761795, 0.19121103,
            0.5305259, 0.6565131, 0.5287279, 0.29444507, 0.775589, 0.24550702, 0.9532204,
            0.8754091, 0.341333, 0.6382999, 0.5125449, 0.5005919, 0.937352, 0.6224484, 0.14624618,
            0.8417525, 0.9414587, 0.44898897, 0.6993321, 0.36183158, 0.24969168, 0.9671642,
            0.20102102, 0.799053, 0.29777643, 0.05473179, 0.82243276, 0.49220118, 0.959262,
            0.60974807, 0.82510734, 0.77621484, 0.31383017,
        ],
    )
    .unwrap();
    let conv_layer47 = TransposedConvolutionLayer::new(kernel47, None, 1, Padding::Valid);
    let target_output47: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            0.55547947, 1.8217546, 1.7675886, 1.9694426, 1.0917896, 1.3918148, 3.271309, 5.011569,
            4.460412, 1.442472, 1.0573763, 4.1938243, 5.339968, 3.6644044, 2.0334845, 1.706648,
            4.7759075, 4.7172537, 3.7908492, 2.1288402, 0.8311155, 2.2176266, 2.7982545, 2.2408054,
            0.8870539, 0.3760405, 1.6505389, 1.8100213, 1.3897698, 1.3234612, 1.1711437, 3.2996593,
            2.5691328, 3.5816987, 2.021796, 1.2329615, 2.5011935, 3.5228052, 3.7659543, 2.7015033,
            0.82068765, 3.4801888, 4.5923443, 4.455248, 3.0937786, 0.63581705, 2.2795923,
            2.5727363, 2.1648123, 1.397322,
        ],
    )
    .unwrap();
    let current_output47: Array3<f32> = conv_layer47.transposed_convolve(&test_input47);

    assert!(
        arr_allclose(&current_output47, &target_output47),
        "{:?} was not equal to {:?}",
        current_output47,
        target_output47
    );

    let test_input48 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.20135997, 0.40562743, 0.25492424, 0.5874371, 0.69954115, 0.11803117, 0.95850575,
            0.9031762, 0.8240507, 0.7735656, 0.5868046, 0.50450677,
        ],
    )
    .unwrap();

    let kernel48: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.31319898, 0.23300357, 0.8095447, 0.34135282, 0.24274388, 0.6729072, 0.57593447,
            0.8085596, 0.7018395, 0.76145005, 0.58241343, 0.3309161, 0.67546684, 0.32411024,
            0.3949699, 0.412044, 0.8408538, 0.76511306, 0.8994237, 0.8364367, 0.38108206,
            0.69459295, 0.8441607, 0.40802577, 0.95296425, 0.72987187, 0.07076582, 0.8826578,
            0.44925806, 0.8213124, 0.6112075, 0.96117723, 0.3876701, 0.88056743, 0.9483631,
            0.8974017, 0.4120727, 0.27696642, 0.69025475, 0.42224765, 0.96611446, 0.04551166,
            0.40275672, 0.19091433, 0.4437527, 0.31289253, 0.2396215, 0.6389319, 0.85605,
            0.27247688, 0.19161025, 0.50402254, 0.5852498, 0.97299683, 0.594723, 0.38096267,
            0.29591832, 0.28942943, 0.4529504, 0.19683413, 0.1757779, 0.88774997, 0.5229589,
            0.7137983, 0.82603574, 0.8461087, 0.9091735, 0.80568945, 0.79286724, 0.3410004,
            0.32917508, 0.17503856, 0.7846004, 0.7272445, 0.48829708, 0.9584728, 0.7469263,
            0.66009414, 0.59341496, 0.42636782, 0.9874962, 0.85196227, 0.43363968, 0.02657376,
            0.11542477, 0.13354255, 0.5618466, 0.070237, 0.35689688, 0.27853093, 0.8144841,
            0.99201185, 0.6685596, 0.5670808, 0.68718493, 0.73198694,
        ],
    )
    .unwrap();
    let conv_layer48 = TransposedConvolutionLayer::new(kernel48, None, 1, Padding::Valid);
    let target_output48: Array3<f32> = Array::from_shape_vec(
        (2, 5, 5),
        vec![
            1.0149523, 2.1719394, 2.4286017, 2.5040483, 0.8676371, 1.9266512, 3.7214708, 4.4474564,
            4.3829026, 1.930727, 2.3858232, 3.3419986, 3.4972806, 3.492906, 1.8428543, 2.6272898,
            4.077436, 3.091545, 3.310844, 1.4227514, 1.0358322, 1.9442897, 1.484598, 1.7154768,
            1.0342234, 1.5819035, 2.252739, 1.6740487, 1.2658031, 0.4193286, 2.195607, 3.9649673,
            3.3416748, 2.8858907, 1.2247865, 1.4188411, 3.2752504, 4.01709, 3.67199, 1.7678499,
            1.5003554, 3.6079087, 3.6926012, 3.9946709, 2.2371287, 0.6753248, 2.1530137, 2.630674,
            2.5368, 1.5786091,
        ],
    )
    .unwrap();
    let current_output48: Array3<f32> = conv_layer48.transposed_convolve(&test_input48);

    assert!(
        arr_allclose(&current_output48, &target_output48),
        "{:?} was not equal to {:?}",
        current_output48,
        target_output48
    );

    let test_input49 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.84016347, 0.55920875, 0.27009216, 0.10123584, 0.2636, 0.9657689, 0.005051, 0.5576874,
            0.9025137, 0.55897933, 0.35369453, 0.9429427,
        ],
    )
    .unwrap();

    let kernel49: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.5162179, 0.5906877, 0.05157892, 0.76241785, 0.07249359, 0.45541912, 0.01278013,
            0.4782056, 0.76319754, 0.5541978, 0.04795831, 0.5815242, 0.27330735, 0.8815459,
            0.29006037, 0.23429064, 0.18781203, 0.94584274, 0.4523076, 0.29750833, 0.17197818,
            0.06818328, 0.6987018, 0.6090657, 0.24505253, 0.8169458, 0.03939039, 0.5665328,
            0.8011893, 0.75747067, 0.1555473, 0.18986696, 0.13435428, 0.38600448, 0.19166702,
            0.46490034, 0.18260308, 0.82895696, 0.03558233, 0.14173116, 0.8877225, 0.12655611,
            0.4754852, 0.7843472, 0.8912908, 0.15408872, 0.45979473, 0.18853948, 0.826404,
            0.8497178, 0.36331993, 0.98673576, 0.43612492, 0.03541405, 0.783278, 0.24658875,
            0.74658084, 0.34663445, 0.03917093, 0.3931895, 0.30789322, 0.68702215, 0.44194368,
            0.33855647, 0.9119313, 0.31810585, 0.16017109, 0.00698695, 0.293519, 0.14280626,
            0.48469457, 0.1767692, 0.42322084, 0.46112144, 0.9255381, 0.5532242, 0.9853486,
            0.24325794, 0.63504064, 0.15406865, 0.11709648, 0.1119092, 0.21574858, 0.62332,
            0.8729103, 0.52609015, 0.06899712, 0.6168495, 0.3181057, 0.10088859, 0.28579375,
            0.08647749, 0.8464018, 0.5181164, 0.47873196, 0.83375126, 0.9057766, 0.00922728,
            0.36432305, 0.53910846, 0.47707382, 0.23459193, 0.6104503, 0.99977493, 0.2879088,
            0.9237121, 0.24345838, 0.00414109, 0.03638967, 0.30595168, 0.16491044, 0.7087876,
            0.79154646, 0.6065011, 0.46475387, 0.6585233, 0.93920064, 0.09687401, 0.5544905,
            0.56360936, 0.10987341, 0.79093266, 0.6827511, 0.93982804, 0.14053226, 0.49555323,
            0.4556152, 0.66896224, 0.46089745, 0.33559954, 0.3038908, 0.7388162, 0.5641086,
            0.07862057, 0.46463865, 0.07132971, 0.5696929, 0.89171886, 0.97521317, 0.86021405,
            0.61829454, 0.4099887, 0.3409378, 0.49427044, 0.10122171, 0.23691536, 0.70967704,
            0.4641384, 0.8326181, 0.38735756, 0.9489551, 0.07998312, 0.5111061, 0.02956773,
            0.17711017, 0.11328588, 0.74999446, 0.8589006, 0.07875007, 0.73433584, 0.4188041,
            0.48477763, 0.00624699, 0.6286288, 0.21567076, 0.81573004, 0.70090973, 0.8734742,
            0.6482149, 0.5717835, 0.16271727, 0.53025377, 0.0984337, 0.82271063, 0.12299971,
            0.06295575, 0.7953895, 0.5933358, 0.27819812, 0.70772564, 0.8846656, 0.33805057,
            0.66772455, 0.9335431, 0.0900248, 0.08626243, 0.0064692, 0.9791513, 0.52760124,
            0.61633664, 0.9759571, 0.5431996, 0.11189567, 0.662313, 0.47249612, 0.88115114,
            0.93577164, 0.61019063, 0.4513792, 0.21412608, 0.21063799, 0.59758914, 0.26163143,
            0.57292384, 0.3575447, 0.41482434, 0.5686212, 0.43116546, 0.8888871, 0.5989078,
            0.96428144, 0.67385226, 0.18009396, 0.650084, 0.1288117, 0.6034601,
        ],
    )
    .unwrap();
    let conv_layer49 = TransposedConvolutionLayer::new(kernel49, None, 1, Padding::Valid);
    let target_output49: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.63662237, 1.5856332, 1.835885, 2.5246708, 2.2921748, 2.2539191, 0.70613015,
            1.2119447, 2.2948606, 2.4042506, 2.910822, 1.8339424, 2.6925142, 1.5375235, 1.4789019,
            4.478072, 2.4113698, 2.0802689, 1.9799335, 2.397583, 1.4106501, 0.80448174, 3.1387599,
            2.462601, 2.4324503, 3.6009102, 3.7834353, 2.243195, 1.1554874, 3.0931854, 1.8594677,
            2.5638404, 3.5256658, 3.880835, 2.4602919, 0.70264065, 2.7892818, 2.7105806, 2.604969,
            3.027523, 2.464974, 1.6428608, 0.08859982, 0.55076766, 0.9552141, 1.2429533, 1.2650963,
            0.7934077, 0.71671873, 0.96143156, 1.7139705, 1.6239978, 1.7008567, 2.3213458,
            1.6552496, 0.7047301, 0.8902378, 3.6525962, 3.914413, 3.5088806, 3.5030403, 2.819336,
            1.3857772, 0.9573248, 3.0258465, 4.3229246, 4.370287, 4.3229737, 3.1357186, 1.6850885,
            1.4488947, 2.425313, 3.2628317, 3.3453774, 3.1055136, 2.7365992, 2.108977, 1.1035775,
            2.7938824, 2.5773876, 2.5440173, 3.1081955, 3.3325758, 2.3659267, 1.4743837, 3.4267845,
            2.6108513, 2.7610435, 2.49674, 3.046204, 2.0077634, 0.38924783, 1.7139112, 1.2619405,
            0.8149209, 1.0342889, 0.6243483, 0.862572,
        ],
    )
    .unwrap();
    let current_output49: Array3<f32> = conv_layer49.transposed_convolve(&test_input49);

    assert!(
        arr_allclose(&current_output49, &target_output49),
        "{:?} was not equal to {:?}",
        current_output49,
        target_output49
    );

    let test_input50 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.23165825, 0.01380609, 0.45430455, 0.3510245, 0.375879, 0.7931324, 0.20369534,
            0.9617992, 0.17212614, 0.8661392, 0.818001, 0.04731771,
        ],
    )
    .unwrap();

    let kernel50: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.6331485, 0.83272296, 0.58803684, 0.6773803, 0.966571, 0.59957683, 0.85136724,
            0.03105091, 0.388052, 0.55736136, 0.02805966, 0.80824125, 0.57193863, 0.9242484,
            0.43400672, 0.95459735, 0.19825369, 0.3165235, 0.34878272, 0.04700416, 0.89200944,
            0.8226108, 0.49845085, 0.02590412, 0.3321073, 0.9764468, 0.5381227, 0.92109436,
            0.7710321, 0.8660679, 0.3895538, 0.854895, 0.07690383, 0.03470363, 0.623576, 0.7447061,
            0.23551573, 0.09116793, 0.13018292, 0.29478395, 0.694041, 0.0967541, 0.8266735,
            0.00767931, 0.24422543, 0.47754803, 0.05508777, 0.30187264, 0.58673537, 0.38990366,
            0.6169217, 0.5919785, 0.35687554, 0.9651153, 0.31502706, 0.15851368, 0.90410787,
            0.24201743, 0.99100995, 0.46153438, 0.5230941, 0.05274187, 0.85842836, 0.8584512,
            0.30464408, 0.00721753, 0.18392335, 0.8556412, 0.1809689, 0.5768042, 0.3628767,
            0.69780505, 0.11757887, 0.08762363, 0.36607084, 0.24363868, 0.7472844, 0.08178072,
            0.8810783, 0.3569205, 0.451316, 0.0383365, 0.8465622, 0.9883213, 0.56150496,
            0.52739674, 0.47732064, 0.43933925, 0.21088907, 0.5524299, 0.8005311, 0.17473145,
            0.40513718, 0.82864845, 0.4856008, 0.41349155, 0.8595507, 0.77320266, 0.9890798,
            0.24298015, 0.27266598, 0.4846638, 0.87975013, 0.4469587, 0.10110632, 0.5594282,
            0.9304254, 0.09035328, 0.76902574, 0.2852155, 0.07585676, 0.24124639, 0.06790887,
            0.14329627, 0.6381789, 0.9543389, 0.6581925, 0.1983508, 0.44280005, 0.15768081,
            0.7742759, 0.90144795, 0.8614371, 0.28797778, 0.37103122, 0.0877872, 0.45872805,
            0.76575243, 0.6829663, 0.2304093, 0.5233105, 0.6974145, 0.8921432, 0.22412036,
            0.0491925, 0.5368815, 0.19189753, 0.45287937, 0.6024187, 0.37045264, 0.23233427,
            0.42484194, 0.98901117, 0.36564678, 0.8630159, 0.8116843, 0.39872772, 0.6879206,
            0.7998495, 0.594579, 0.7541534, 0.80124223, 0.59222096, 0.05390601, 0.82877624,
            0.29753333, 0.82358676, 0.29054287, 0.26042402, 0.88391197, 0.8143526, 0.579024,
            0.05703124, 0.6139959, 0.10031959, 0.78280455, 0.24171719, 0.4721017, 0.53194064,
            0.6437402, 0.09277638, 0.8693754, 0.60042983, 0.8875286, 0.86002535, 0.69702214,
            0.12023476, 0.9464669, 0.9782188, 0.38164645, 0.7172452, 0.9105007, 0.41190186,
            0.29969904, 0.43725935, 0.7022435, 0.7566894, 0.5551452, 0.88240683, 0.10910437,
            0.51675713, 0.33856305, 0.4310923, 0.43717158, 0.2241604, 0.7074267, 0.04574655,
            0.62335473, 0.6056931, 0.19430637, 0.9464095, 0.43765876, 0.47719213, 0.45312902,
            0.417855, 0.8179389, 0.03511541, 0.5549018, 0.6715673, 0.61512816, 0.655004,
            0.09111205, 0.49298653, 0.3268639, 0.77552783, 0.77209026,
        ],
    )
    .unwrap();
    let conv_layer50 = TransposedConvolutionLayer::new(kernel50, None, 1, Padding::Valid);
    let target_output50: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.3394171, 1.2150439, 1.1264788, 1.0107234, 1.4409022, 1.5708003, 0.5881289, 1.6757549,
            3.0793252, 2.4218376, 2.526516, 2.3024232, 3.8708868, 1.3699906, 1.6684628, 3.5531244,
            2.1522486, 2.0519865, 2.49079, 2.9311547, 2.1923933, 1.4394228, 2.4161634, 2.4000893,
            2.9272768, 3.2848396, 1.8849987, 1.4070492, 0.859753, 3.2289698, 2.4801447, 3.2169776,
            2.9887657, 2.4181652, 1.5942105, 1.3300481, 4.030205, 2.6852496, 2.8903024, 3.421651,
            3.6454976, 1.2246587, 1.0596787, 2.0731711, 0.91683996, 1.0338581, 1.8680247, 1.828975,
            0.36637044, 0.46707645, 1.5194724, 1.1456627, 0.62928075, 0.71656084, 0.6393206,
            0.72322935, 1.4119799, 3.329586, 2.4546545, 2.0600195, 1.5630646, 1.9642296,
            0.62748605, 1.6256866, 3.0917778, 3.5179765, 2.3601875, 1.9808156, 1.6185763,
            0.8965053, 1.1265674, 2.9402099, 3.0705545, 3.553856, 1.866952, 2.7396455, 1.4046953,
            1.2604573, 2.281362, 3.2356887, 2.1113758, 2.4510205, 2.6120217, 1.7463032, 1.1429625,
            3.2009475, 1.3001633, 2.2669108, 2.7881284, 2.8151155, 1.435597, 0.742061, 1.2136717,
            1.1937671, 0.9262685, 1.6272476, 2.138372, 0.633159,
        ],
    )
    .unwrap();
    let current_output50: Array3<f32> = conv_layer50.transposed_convolve(&test_input50);

    assert!(
        arr_allclose(&current_output50, &target_output50),
        "{:?} was not equal to {:?}",
        current_output50,
        target_output50
    );

    let test_input51 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.47542888, 0.31814525, 0.52555007, 0.81072354, 0.00102462, 0.5109687, 0.48937833,
            0.122188, 0.22519495, 0.40227205, 0.84508294, 0.43985215,
        ],
    )
    .unwrap();

    let kernel51: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.05504967, 0.02137936, 0.26612982, 0.12310848, 0.00158825, 0.75761557, 0.88188004,
            0.12094665, 0.13906257, 0.9157668, 0.91879827, 0.8513396, 0.28533912, 0.30878848,
            0.12668495, 0.24235713, 0.45707443, 0.7712829, 0.6903243, 0.09853197, 0.43307763,
            0.05488254, 0.70532215, 0.34688666, 0.9355463, 0.38260135, 0.4838589, 0.17318112,
            0.21472165, 0.77769446, 0.356957, 0.22671694, 0.18250434, 0.41477197, 0.18007399,
            0.9827863, 0.58704966, 0.2950183, 0.46143153, 0.19057809, 0.3653109, 0.93977064,
            0.26191843, 0.3693467, 0.1444909, 0.9363978, 0.42698747, 0.1281546, 0.30951205,
            0.1389484, 0.7072368, 0.44510987, 0.68366706, 0.60059834, 0.09438256, 0.36583102,
            0.60821444, 0.03161661, 0.8738241, 0.29876906, 0.33316013, 0.562216, 0.3353904,
            0.10716959, 0.9334109, 0.8606402, 0.42792627, 0.48052302, 0.6958078, 0.4525564,
            0.99052715, 0.04395659, 0.71055365, 0.9117777, 0.93380785, 0.90260816, 0.01515595,
            0.88177705, 0.43487665, 0.56912595, 0.05581366, 0.02638636, 0.50119185, 0.31323937,
            0.05636088, 0.31307653, 0.3326902, 0.3734779, 0.4210294, 0.08686391, 0.3808534,
            0.36317897, 0.19031978, 0.46563995, 0.41320488, 0.94399136, 0.28572702, 0.6142756,
            0.8158052, 0.26794037, 0.12281225, 0.32823455, 0.14740174, 0.70965314, 0.19252698,
            0.79887706, 0.02814319, 0.39099365, 0.7551387, 0.5038018, 0.15413615, 0.82638884,
            0.2631662, 0.7053773, 0.6478343, 0.32534242, 0.6635084, 0.8839653, 0.59479696,
            0.68739474, 0.903793, 0.9826564, 0.56865096, 0.33996934, 0.63317853, 0.7065151,
            0.82775307, 0.22001709, 0.37304193, 0.20307006, 0.59174454, 0.3759951, 0.673529,
            0.42676452, 0.6453951, 0.93520576, 0.59322685, 0.5885291, 0.23145947, 0.15739693,
            0.8825847, 0.17851174, 0.5603199, 0.14435844, 0.10347797, 0.37213182, 0.14642915,
            0.21561022, 0.3830422, 0.90021485, 0.32565016, 0.82000726, 0.72865623, 0.48349917,
            0.41356984, 0.03333719, 0.08149401, 0.85722613, 0.04374503, 0.88704216, 0.09240989,
            0.8528545, 0.7946653, 0.54765993, 0.74729836, 0.72924787, 0.21080038, 0.12833528,
            0.06738389, 0.9163098, 0.2233036, 0.09597177, 0.4226413, 0.73019654, 0.8065446,
            0.13412596, 0.9296237, 0.88961375, 0.8097079, 0.92300737, 0.8407575, 0.5467569,
            0.90232325, 0.40697718, 0.7049378, 0.17525117, 0.60480595, 0.01006908, 0.09306768,
            0.04155758, 0.00396548, 0.29594678, 0.24183853, 0.23543635, 0.10814751, 0.366542,
            0.58264214, 0.1795904, 0.47117367, 0.7827338, 0.22905576, 0.3444951, 0.83183694,
            0.12226541, 0.8971257, 0.27640048, 0.37137195, 0.2710384, 0.27672654, 0.33046693,
            0.4244338, 0.8525934, 0.79606473, 0.24516417, 0.5116681, 0.32966596,
        ],
    )
    .unwrap();
    let conv_layer51 = TransposedConvolutionLayer::new(kernel51, None, 1, Padding::Valid);
    let target_output51: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.05020297, 0.51711154, 0.7828476, 0.72872734, 0.6741346, 0.72615635, 1.0537236,
            0.95716, 1.8254089, 1.9024299, 1.9930599, 1.6666839, 2.8894172, 1.5622365, 1.105561,
            2.4389224, 1.9179215, 1.8861127, 2.8992941, 2.5734878, 1.3759829, 0.75395596,
            2.2184334, 1.7436172, 1.9488046, 2.0886078, 2.346359, 1.6553769, 1.6809925, 2.5076878,
            2.4027865, 2.3408937, 1.6011908, 2.303354, 1.1618972, 1.0399384, 2.7511194, 2.4155276,
            1.8221711, 1.9114791, 2.6343055, 1.8755343, 0.941331, 1.2419521, 1.3052543, 1.9411161,
            1.6178579, 1.9934456, 1.2505295, 0.46920842, 1.1747358, 0.9939651, 0.7716427,
            0.97930336, 1.0212508, 0.72990793, 1.649969, 2.637511, 1.9998327, 2.5162148, 2.32181,
            2.1952252, 1.4362274, 1.1683363, 1.6970117, 1.8251133, 2.0525694, 2.3239489, 2.1765664,
            0.942391, 0.96116066, 2.2135558, 1.9624505, 1.9695584, 2.5809464, 2.7860274,
            0.98859775, 1.2139802, 2.4873245, 2.1153998, 1.7453651, 2.7814517, 2.786561, 1.049406,
            1.5621145, 2.3306684, 2.522726, 2.520286, 2.2556357, 2.8730896, 1.1353717, 0.6968497,
            1.6119773, 2.2541587, 1.5544847, 1.7237282, 1.4689087, 0.1982798,
        ],
    )
    .unwrap();
    let current_output51: Array3<f32> = conv_layer51.transposed_convolve(&test_input51);

    assert!(
        arr_allclose(&current_output51, &target_output51),
        "{:?} was not equal to {:?}",
        current_output51,
        target_output51
    );
}
