// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array2, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_transpose_stride2_valid_bias() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(
        kernel1,
        Some(Array::from_shape_vec((1,), vec![0.14352316]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.3485275, 0.6731098, 0.7818945, 0.55962276, 1.0755012, 0.6332077, 0.7498816,
            0.6685037, 0.2865959, 0.75415295, 0.3921074, 1.1479273, 0.6096405, 1.3461802,
            0.75119716, 1.1833668, 0.29556802, 0.45076364, 0.9683833, 0.9806382, 2.086068,
            1.2550097, 2.887555, 1.0878568, 2.4724956, 1.323755, 1.0081365, 0.6810722, 0.3437385,
            1.7346253, 0.9824189, 2.1442485, 1.1605213, 2.0123985, 0.7933171, 0.8030221, 0.7880372,
            0.6772775, 2.0965977, 0.90287596, 2.7288322, 1.1970756, 2.3755932, 1.1934671,
            0.7955966, 0.3667397, 0.21795619, 0.6406014, 0.40194118, 1.3563933, 0.7361921,
            1.2816892, 0.26635283, 0.448882, 1.0086638, 1.1528299, 1.9092963, 0.57577735,
            2.1894062, 1.3023248, 1.6846156, 0.8246249, 0.6481568, 1.3322301, 0.848077, 1.5574923,
            0.85503316, 1.4206338, 0.4728667, 0.9927945, 0.3446401, 0.3644765, 1.8566155,
            1.0755031, 2.3564217, 0.7982326, 2.4237306, 1.2481673, 1.8833146, 0.72202194,
            0.59909385, 0.7991412, 0.6394646, 1.394856, 0.73399454, 1.6577387, 0.8838105, 1.299551,
            0.46730235, 0.4685045, 0.8265263, 0.35946566, 1.3081033, 0.4604577, 1.5589774,
            0.48320428, 1.1444502, 0.3868975, 0.4030824,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.8997107, 0.64410555, 0.04471071, 0.767672, 0.43464628, 0.16569944, 0.18875164,
            0.12285258, 0.2781115, 0.5390728, 0.5066572, 0.97435564, 0.39133722, 0.7964828,
            0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183, 0.81628793,
            0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133, 0.0067116,
            0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715, 0.7567798,
            0.23972042, 0.38848338, 0.00744711, 0.8715701, 0.07988323,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.6283005, 0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194, 0.34163022,
            0.03235205, 0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297, 0.97700953,
            0.18019113, 0.775954, 0.14120784, 0.3426181,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(
        kernel2,
        Some(Array::from_shape_vec((1,), vec![0.5417864]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            1.5914972, 2.0431283, 1.8390853, 1.9550991, 1.1579888, 1.0041215, 1.6659648, 2.0107093,
            0.8680956, 1.8749514, 1.469215, 2.5427704, 1.5610316, 1.5662277, 0.99484307, 1.9751365,
            1.5303473, 1.1862385, 2.257861, 1.8321118, 2.7926533, 1.4896265, 2.2571769, 1.6279938,
            1.987664, 0.8009799, 1.070431, 1.6007836, 1.4313594, 1.7226508, 1.2548592, 1.7484086,
            1.4765971, 0.9136811, 0.5660821, 0.6202233, 1.9087279, 1.5116463, 2.5096395, 1.768583,
            2.1853323, 1.1039581, 1.8471317, 1.6526165, 0.80949986, 1.3210473, 1.2191528,
            1.8521852, 1.3307836, 1.3477155, 0.62262076, 1.7925324, 1.0003601, 1.2129138,
            1.4471118, 1.0569453, 2.2340786, 1.4136565, 2.3352015, 2.0787625, 1.9611096, 1.1389782,
            1.0186011, 0.8859445, 0.69436395, 1.4161084, 0.75670934, 2.3972967, 1.4239557,
            1.7533603, 0.82795465, 0.81119525, 0.98707986, 0.936176, 1.4573033, 1.0311908,
            2.8602283, 2.2055984, 2.2892761, 1.3684719, 0.8770213, 0.90339446, 0.922431,
            0.97149175, 0.6265419, 2.2424572, 1.5183482, 1.8728783, 0.743663, 1.0952961,
            0.84581697, 0.5968881, 0.86594915, 0.5601983, 1.6555655, 0.6928734, 1.4198472,
            0.5808122, 0.79147315,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.7768226, 0.34603763, 0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802,
            0.629322, 0.60627973, 0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678,
            0.89887625, 0.6572328, 0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983,
            0.6908677, 0.5511301, 0.36253917, 0.36786652, 0.88718724, 0.69587743, 0.4870034,
            0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529, 0.5566727, 0.7035832,
            0.92333794, 0.85647196, 0.36252776, 0.9373231, 0.01684272,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754, 0.31284246, 0.4031665,
            0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259, 0.23846498, 0.82509995,
            0.97324103, 0.96826524, 0.77620417, 0.8427075,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(
        kernel3,
        Some(Array::from_shape_vec((1,), vec![0.42989048]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.8415039, 1.4827596, 1.0970885, 1.3318483, 0.99129164, 1.4586177, 1.1378069,
            1.6315919, 0.79676867, 1.1047049, 1.3461226, 1.4841897, 1.2614175, 1.7981895,
            1.3466556, 1.9690171, 1.4632388, 1.0866874, 1.4401203, 2.0985131, 2.8881533, 2.4379098,
            2.765228, 2.509842, 2.7825665, 2.4191113, 1.752407, 0.9024837, 1.1231714, 1.5395712,
            1.5454555, 2.1150227, 1.5073237, 1.9012306, 1.3072801, 1.1007408, 1.4614426, 2.2569017,
            2.9136658, 2.5830185, 2.8420603, 1.9197615, 2.9167213, 2.6065242, 1.6415309, 1.0524534,
            1.4767808, 1.7579685, 1.455076, 1.7466866, 0.8362223, 1.4862871, 1.6246668, 1.4025391,
            1.5868903, 1.9519083, 2.856844, 1.9678353, 2.4430144, 2.2422397, 2.8020227, 2.959063,
            1.9389127, 0.6018758, 0.9319023, 1.203277, 0.9681667, 1.8428844, 1.6896756, 2.1064675,
            1.6883912, 1.5341312, 1.5443815, 2.2674785, 2.0655668, 1.5792938, 2.640525, 2.7767055,
            3.3887994, 2.4976318, 2.065869, 1.1531769, 1.6622005, 1.838107, 1.003051, 1.4003627,
            1.4875149, 2.1534097, 1.1421281, 0.73538893, 1.5396183, 1.6077682, 2.2002163,
            0.9787798, 2.082061, 1.4348949, 1.9068061, 1.1246252, 1.1765792,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.76771307, 0.54514444, 0.7878393, 0.21897991, 0.975659, 0.73295325, 0.69994044,
            0.86701024, 0.76087946, 0.623545, 0.14890751, 0.8610666, 0.21943341, 0.1644093,
            0.6089244, 0.8612485, 0.02602104, 0.30423534, 0.5087405, 0.16869895, 0.3329467,
            0.179494, 0.33126613, 0.11996287, 0.21606164, 0.87119263, 0.33579683, 0.2313126,
            0.2576527, 0.3748985, 0.30113342, 0.8142977, 0.423247, 0.8179498, 0.92175007,
            0.21606776, 0.19149332, 0.4240341, 0.14780204, 0.46443272,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.00207204, 0.359202, 0.9019851, 0.21363449, 0.6390296, 0.5977058, 0.81350476,
            0.3685356, 0.90738845, 0.7828945, 0.9812083, 0.6726924, 0.46724817, 0.17302093,
            0.39839587, 0.78055173, 0.8576361, 0.7335981, 0.52934057, 0.9529279, 0.78965247,
            0.46750203, 0.08403921, 0.73126566, 0.34934825, 0.3459232, 0.54770446, 0.68714255,
            0.29283327, 0.53392637, 0.8850151, 0.6909357, 0.44388366, 0.9043074, 0.9949724,
            0.64743847, 0.36691284, 0.5396585, 0.5372604, 0.47547424, 0.44373918, 0.34716287,
            0.21774843, 0.9437953, 0.51856595, 0.15765554, 0.9350713, 0.86233217, 0.81734437,
            0.6566154,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(
        kernel4,
        Some(Array::from_shape_vec((1,), vec![0.3879487]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 13, 11),
        vec![
            0.5047134, 0.84606916, 1.372417, 0.9435832, 1.7875843, 1.0214015, 1.8123467, 0.7976263,
            1.3482213, 0.46985948, 0.5919347, 1.1414781, 1.2425317, 1.3033588, 1.9531453, 2.364911,
            1.9147189, 1.6677759, 1.6634192, 1.4682958, 0.6951319, 0.6787466, 1.4335601, 1.4953425,
            2.90883, 2.1443703, 4.307395, 2.07726, 3.407318, 1.5795462, 2.5939345, 0.7432474,
            1.2097778, 1.9093049, 2.1049418, 3.1933823, 3.9173, 4.84431, 3.8909223, 4.4453363,
            3.1510036, 2.8015392, 1.6129768, 1.5677567, 2.234582, 2.2082062, 4.048372, 3.409085,
            5.5062575, 3.2617164, 4.6782637, 3.294277, 3.563146, 1.3428252, 1.9836369, 1.9281847,
            2.096718, 3.208694, 3.7290735, 4.456229, 3.5490503, 5.1892138, 3.5698047, 3.010465,
            2.5829015, 2.818426, 2.2527046, 1.9631135, 3.4935465, 3.9402497, 4.9462137, 3.7953975,
            6.1173196, 3.6891458, 3.9761422, 2.0447624, 2.2386713, 1.6019218, 1.6009004, 2.746206,
            2.9795651, 4.231839, 3.3251886, 4.666913, 4.0081506, 3.3021424, 2.5891552, 2.5199983,
            1.5850315, 1.4017196, 2.5497613, 2.8762455, 4.1016865, 3.1701207, 5.296041, 3.633091,
            3.4874487, 2.1203187, 2.0250702, 0.9320665, 0.87655616, 1.7840827, 2.0657847,
            2.9456954, 3.2646887, 3.8093665, 3.4472835, 2.9387314, 1.6208317, 1.9148731, 0.7774643,
            0.9740659, 1.7187033, 2.2036788, 3.1551137, 3.00021, 3.6491573, 2.6426156, 2.0670269,
            1.4730618, 1.1187325, 0.49323255, 0.47674465, 0.874367, 0.99058527, 1.2902498,
            1.4368198, 1.6409128, 1.1026566, 1.1742735, 0.9155773, 0.78954566, 0.43868625,
            0.5791735, 0.86235785, 1.1022258, 1.3390324, 1.33305, 1.1493026, 1.393923, 1.0773981,
            0.8909139, 0.751837,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.28848994, 0.5814131, 0.06870039, 0.78543746, 0.47194287, 0.12733267, 0.6111727,
            0.25675833, 0.74741316, 0.45714313, 0.9649919, 0.57969916, 0.5208711, 0.93666834,
            0.13247305, 0.7087714, 0.17877895, 0.40767, 0.6906785, 0.9675369, 0.224454, 0.28950995,
            0.75431514, 0.99582964, 0.8120864, 0.9536324, 0.7703749, 0.683158, 0.16371861,
            0.42877796, 0.7300311, 0.9456737, 0.05700503, 0.19623296, 0.44457257, 0.5512328,
            0.15101007, 0.25140873, 0.2031063, 0.5537751,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.3641559, 0.701937, 0.27669305, 0.85076064, 0.00186597, 0.3316532, 0.15485734,
            0.35000807, 0.42372492, 0.03995521, 0.5067197, 0.38907993, 0.37287286, 0.21294773,
            0.8646356, 0.10154326, 0.75313085, 0.7910046, 0.15368015, 0.25977603, 0.40315583,
            0.635939, 0.25689796, 0.13678746, 0.43744904, 0.6658951, 0.564682, 0.70429957,
            0.67241764, 0.15790685, 0.25059524, 0.6432024, 0.60438925, 0.45131883, 0.96080875,
            0.40131757, 0.60942906, 0.7035094, 0.6473561, 0.05433872, 0.7478619, 0.24740443,
            0.35665986, 0.00020906, 0.23741227, 0.57013196, 0.6398819, 0.7132858, 0.90739846,
            0.8246988,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(
        kernel5,
        Some(Array::from_shape_vec((1,), vec![0.1319153]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 13, 11),
        vec![
            0.38643342, 0.4611622, 0.77432954, 1.0998745, 1.0599835, 1.2954018, 1.6781284,
            1.8112324, 1.1698425, 1.469748, 0.2906292, 0.283841, 0.32095945, 0.633924, 0.6317056,
            0.9493878, 1.0047519, 1.4232982, 1.2636129, 1.736191, 0.91416144, 1.1200994, 1.0808014,
            1.1707945, 2.1921134, 2.3167524, 2.7230892, 2.543164, 3.4151986, 3.1513116, 1.9007276,
            1.6216362, 0.97349906, 0.68909645, 1.0001366, 1.6529241, 1.8853846, 3.2102013,
            1.5341866, 3.3567793, 2.0663643, 2.5726662, 0.66994655, 1.2390183, 1.3224318, 1.75462,
            2.7342067, 3.4959297, 4.339513, 4.119083, 5.091698, 5.3603516, 3.7863023, 2.768963,
            1.706298, 1.0760756, 0.90931046, 2.1405911, 1.2736143, 2.6356547, 1.8087827, 3.3250363,
            2.0247886, 2.434763, 0.84395015, 1.2925787, 1.457248, 1.7400684, 2.8810585, 3.5786235,
            5.067456, 4.3644166, 5.1464787, 4.2153544, 3.99812, 2.4962199, 1.4486148, 0.5172827,
            0.85264635, 1.7251873, 1.2148832, 2.200793, 1.9015548, 3.056482, 1.6720102, 2.365421,
            0.7703072, 1.0649703, 0.9790535, 1.1601503, 2.128855, 2.261407, 3.7095459, 3.4286854,
            5.0857654, 4.5438595, 3.4614375, 2.7725995, 1.8974327, 0.32457316, 0.663118, 1.1581756,
            1.3347018, 2.1644216, 1.009463, 2.251395, 1.7128848, 1.9252037, 0.9008533, 1.0176367,
            0.52560174, 0.6612233, 1.2762569, 1.42378, 2.0174048, 1.4488914, 3.1337326, 2.349396,
            2.4903483, 1.2935786, 1.763226, 0.26300377, 0.3039198, 0.5566046, 0.52865016,
            0.84837484, 0.7650393, 1.4286696, 1.1037897, 1.3223925, 0.2807223, 0.51473117,
            0.29008675, 0.3422364, 0.5932473, 0.7135215, 1.0129641, 0.9850007, 1.5456865,
            1.3803349, 1.2451116, 0.7667569, 1.0118611,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6876462, 0.846729, 0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465,
            0.05539654, 0.5554673, 0.9149804, 0.9791666, 0.9000323, 0.6329186, 0.30872977,
            0.30553624, 0.04431259, 0.5287215, 0.3358437, 0.72178566, 0.72704846, 0.85191244,
            0.07464863, 0.867838, 0.5849202, 0.14913943, 0.18325551, 0.40498126, 0.75359416,
            0.01821492, 0.5917236, 0.91982275, 0.5287654, 0.7151285, 0.38420153, 0.517026,
            0.5150141, 0.26934662, 0.7356045, 0.97902703, 0.6362754,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.27803296, 0.32063982, 0.83432084, 0.78711736, 0.28247103, 0.7812688, 0.5270146,
            0.4719829, 0.47535485, 0.23715672, 0.4404677, 0.90286416, 0.66611385, 0.02649495,
            0.3193976, 0.16608049, 0.5121102, 0.17436478, 0.313714, 0.47244504, 0.9906781,
            0.9064671, 0.29454133, 0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972,
            0.53866875, 0.6358971, 0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548,
            0.14977625, 0.53714937, 0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625,
            0.4744624, 0.73655206, 0.42605233, 0.6592577, 0.3237799, 0.42867732, 0.87574345,
            0.70010746,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(
        kernel6,
        Some(Array::from_shape_vec((1,), vec![0.01496939]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 13, 11),
        vec![
            0.3564641, 0.37449443, 1.2526257, 1.2988044, 1.6973131, 0.9214397, 1.2301828,
            1.0100608, 1.6562873, 1.0405012, 0.64187735, 1.3134633, 1.0780648, 1.857497,
            0.93941194, 1.8050115, 1.234713, 2.3548398, 1.1495639, 1.2716794, 0.50577104,
            0.39446372, 0.62378377, 1.2930802, 1.5648606, 1.8677626, 2.6079495, 1.3948092,
            2.259988, 2.5566895, 2.3070786, 0.7514762, 1.2619109, 1.1411417, 1.3637366, 1.5382421,
            1.9441472, 2.889693, 1.9761405, 2.9675612, 2.6650262, 1.9430202, 0.8348365, 0.9168866,
            1.6786574, 1.6689732, 2.8490038, 3.5518832, 4.3400755, 3.9339044, 5.0937166, 4.262842,
            3.7053952, 2.757319, 1.7431476, 0.6350688, 0.7052468, 1.855892, 1.8269329, 3.5393853,
            2.7308755, 3.871139, 2.5941024, 2.357387, 1.0710617, 0.72521406, 1.2044983, 1.3898315,
            2.5822158, 3.2603114, 4.122639, 3.6949968, 4.0461674, 3.6483974, 3.121075, 1.3038898,
            1.5962503, 1.2503846, 1.2337036, 2.1322348, 1.9331595, 2.9305472, 2.645369, 3.036454,
            2.4709206, 1.9943156, 0.76221555, 0.8216402, 1.1576803, 1.6934385, 2.939282, 3.2160926,
            4.741089, 4.4136925, 5.159669, 4.769798, 3.5864248, 2.519755, 1.5302981, 1.1528728,
            1.3310145, 2.1384854, 2.224335, 3.660327, 2.3297307, 3.575968, 2.221419, 2.0127563,
            0.8209782, 0.6077133, 1.3866684, 1.4422765, 1.6945632, 2.5076003, 2.6116552, 2.6197,
            2.6669736, 2.4357467, 2.1807213, 0.81541127, 1.117815, 0.2455379, 0.47094256,
            0.68061435, 1.0570335, 1.425868, 1.7049766, 1.5353937, 1.7723558, 1.2017505, 0.7117047,
            0.62954646, 0.71633106, 0.58144706, 1.1038284, 1.3185849, 2.0444567, 1.963998,
            2.3440259, 2.4542897, 1.277629, 1.2942955, 0.5514221,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.78416556, 0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122,
            0.68573385, 0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448,
            0.48578474, 0.2764571, 0.9192946, 0.8920509, 0.34320405, 0.4283556, 0.3897719,
            0.06360459, 0.729173, 0.19460331, 0.8634254, 0.6576018, 0.9657459, 0.22873744,
            0.47843248, 0.22157177, 0.9162307, 0.02157675, 0.44649428, 0.2792192, 0.685827,
            0.75294507, 0.7919586, 0.22560763, 0.88778716, 0.80092114,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.00003577, 0.9737877, 0.9146247, 0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025,
            0.0330946, 0.17754778, 0.41998118, 0.02919354, 0.82382417, 0.4156855, 0.49590722,
            0.69720376, 0.7155315, 0.40795937, 0.15397236, 0.02265206, 0.7090415, 0.75877124,
            0.67035425, 0.39483562, 0.86222315, 0.9993058, 0.84902793, 0.26427644, 0.86764544,
            0.24274233, 0.69865257, 0.5739991,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(
        kernel7,
        Some(Array::from_shape_vec((1,), vec![0.7620597]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            1.0409818, 1.6846817, 1.5848241, 1.5016599, 1.8534827, 2.103332, 1.9129012, 1.9015968,
            1.6441612, 0.895688, 1.5920174, 1.1312673, 1.7081965, 1.4295206, 2.1779108, 1.7510059,
            2.306915, 1.7964294, 1.1391983, 1.3236028, 1.7418916, 1.6934305, 2.1482625, 2.0453925,
            3.1749277, 2.7147174, 2.7818253, 2.198595, 1.9809799, 0.9409776, 2.395001, 1.842631,
            3.5418348, 2.735598, 4.2339263, 3.2210348, 4.127165, 3.190918, 1.694947, 1.9703997,
            1.8505863, 2.2339497, 2.7196689, 2.7870839, 3.959343, 3.2286713, 2.8481193, 2.0449147,
            1.7461447, 0.9186206, 2.1864636, 1.3951168, 3.7520223, 2.403338, 4.3882685, 3.392133,
            3.6671433, 2.8311024, 1.420721, 1.6635592, 1.507817, 1.6949756, 2.0182033, 1.9708956,
            3.1743026, 2.7282095, 2.9732876, 1.8032441, 1.3780984, 0.83907455, 1.9803028,
            1.4088682, 3.1601837, 2.2909808, 3.914104, 2.9926765, 3.5510695, 3.1518445, 1.6253927,
            1.5956076, 1.7205006, 2.4627895, 2.610261, 2.369812, 3.3256948, 2.4488902, 3.2304196,
            2.570578, 2.0325422, 1.0466697, 2.5282297, 1.6423726, 3.4391563, 2.5051138, 3.4870393,
            2.9369483, 3.9194539, 2.9690313, 2.0755224, 1.9260806, 1.4753284, 1.7166872, 2.0445871,
            1.3820258, 2.1050804, 1.7958306, 2.3647041, 1.883119, 1.6219654, 0.9862295, 2.206536,
            1.336439, 2.7018888, 2.283156, 2.4150798, 1.8716681, 2.600317, 1.8834106, 1.53405,
            1.5204389,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.29289714, 0.88402116, 0.8942853, 0.7757528, 0.16431308, 0.48939565, 0.56055367,
            0.46453193, 0.9573795, 0.8899508, 0.16098963, 0.63514715, 0.810474, 0.29953358,
            0.46075395, 0.02808736, 0.59781086, 0.8855644, 0.61877847, 0.9537467, 0.6197168,
            0.3379795, 0.13108306, 0.30692965, 0.33537498, 0.01351478, 0.45529485, 0.6626128,
            0.9497022, 0.7403127, 0.06039312, 0.08292098, 0.80679554, 0.1354166, 0.2560622,
            0.80891573, 0.97702754, 0.4124968, 0.4359102, 0.8733311,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.1396195, 0.52047473, 0.88564533, 0.29781443, 0.21130918, 0.83071965, 0.3337948,
            0.9783562, 0.42070097, 0.55396014, 0.16172563, 0.7634967, 0.36205766, 0.48491392,
            0.4980414, 0.6001484, 0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525,
            0.7446416, 0.471613, 0.72900707, 0.842964, 0.21457537, 0.938401, 0.41665936,
            0.05351101, 0.43856344, 0.7253113, 0.8520324,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(
        kernel8,
        Some(Array::from_shape_vec((1,), vec![0.4151233]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            0.85961473, 0.7963628, 1.0900463, 1.2544607, 1.4475381, 1.2834424, 1.5305699,
            1.2339001, 1.1378152, 0.72897273, 1.0155816, 1.1199056, 1.2856811, 2.1395063,
            1.1724893, 2.3669105, 1.2061132, 2.258599, 0.81881756, 1.3978397, 1.3021023,
            0.91969085, 1.9624563, 1.8583316, 2.1717582, 2.3636591, 2.3135772, 2.4243212, 1.316979,
            1.4524307, 0.88051, 1.2151706, 1.676811, 2.5176852, 2.1151967, 3.0181262, 2.3287199,
            3.3339345, 1.491655, 2.0797312, 1.5191318, 1.4270228, 2.5382934, 2.2322125, 2.0625536,
            1.7735127, 1.9792925, 1.8577523, 1.684193, 1.2574064, 1.5202045, 2.1443858, 2.5170074,
            3.962293, 1.6286865, 2.7809346, 1.516672, 2.4462283, 1.3781954, 1.9403291, 2.2570508,
            1.868949, 3.4011323, 2.8585951, 1.8845018, 1.9652885, 1.8034819, 1.4524167, 0.71448755,
            1.161241, 1.6849777, 2.5699248, 2.7746017, 4.285851, 1.9405721, 2.6497507, 1.7569885,
            2.1706932, 1.182467, 1.484142, 2.1559558, 1.7090675, 2.5786767, 2.6199358, 2.202824,
            1.8684537, 2.7242088, 2.183461, 2.1248724, 1.2933013, 1.7271453, 2.386113, 2.7255797,
            4.1335306, 1.8427624, 3.0517313, 2.2564096, 3.6439803, 1.7460576, 2.6909707, 1.490222,
            0.95593274, 2.1489258, 1.8577167, 1.5732065, 1.6994337, 2.061683, 1.7849177, 1.3889034,
            1.5071874, 0.68384707, 1.1334987, 1.7642055, 2.216686, 1.4027191, 1.7892826, 1.4315153,
            2.003388, 1.5235656, 1.7316194,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.35101932, 0.7388761, 0.3592986, 0.6741479, 0.9965808, 0.3117034, 0.8605703,
            0.94308543, 0.8192489, 0.31478795, 0.750324, 0.36604244, 0.78454614, 0.039194,
            0.23696694, 0.2418382, 0.24788351, 0.5622223, 0.15428482, 0.50688076, 0.37682602,
            0.44385925, 0.00051633, 0.53422695, 0.5675659, 0.53845215, 0.2130759, 0.86445093,
            0.432881, 0.6255918, 0.3942565, 0.07226853, 0.09869356, 0.32627374, 0.8543963,
            0.85603166, 0.25422713, 0.24929269, 0.36793318, 0.39957172,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.9079535, 0.865758, 0.82237726, 0.60374194, 0.7658025, 0.0215734, 0.473204, 0.6594781,
            0.86392707, 0.8566667, 0.48541847, 0.54855824, 0.5860555, 0.158874, 0.10558709,
            0.19664533, 0.39609066, 0.27843866, 0.49128443, 0.75033015, 0.35650545, 0.4687038,
            0.6159849, 0.2547001, 0.17250927, 0.07203952, 0.8724657, 0.14018923, 0.12091745,
            0.4770398, 0.43290496, 0.6356798,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(
        kernel9,
        Some(Array::from_shape_vec((1,), vec![0.7619444]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            1.2299109, 1.1707652, 2.082417, 2.0198889, 1.9140714, 1.8522853, 1.8813744, 1.7116537,
            1.5788057, 1.5698023, 1.1650964, 0.9461369, 1.8842387, 1.3133903, 1.66033, 1.3702613,
            1.639003, 1.2639633, 1.4100296, 1.3425978, 2.259862, 2.1106274, 3.5706983, 3.119597,
            3.2049837, 2.9339008, 3.6224518, 3.3117385, 2.755546, 2.4246507, 1.9787505, 1.2849932,
            2.7006927, 2.4605193, 2.4569077, 1.7078632, 2.8286662, 2.2421937, 2.0431557, 2.0762296,
            2.636128, 2.486371, 3.523065, 2.9601474, 3.5668983, 3.1798153, 3.5011811, 3.219924,
            2.3104687, 1.6756889, 2.196332, 1.4115937, 2.4790688, 2.575632, 2.80753, 1.9718012,
            2.5062716, 2.2658377, 1.4534762, 1.7567155, 2.2958145, 2.2016594, 2.775671, 2.2592669,
            2.9228926, 2.4050336, 2.9721136, 2.7794657, 1.6221173, 1.7611855, 1.9304048, 1.1617866,
            1.8743483, 2.2429628, 2.2590013, 2.0433257, 2.3639135, 2.0330744, 1.4736207, 1.257383,
            1.7825242, 1.7265426, 2.2569962, 2.1598034, 2.2883968, 1.8562458, 2.905139, 2.1998663,
            2.239346, 1.6204491, 1.5141289, 1.0581741, 1.7432543, 1.4980307, 1.8184438, 2.0323346,
            2.2323468, 2.1921244, 1.6440479, 1.7897105, 1.0199542, 0.99261236, 1.6328005,
            1.4331589, 1.4491196, 1.2639806, 1.664684, 1.3611717, 1.3566062, 1.0960137, 0.9379584,
            0.92260313, 1.2578112, 1.1805416, 1.0641369, 1.2310038, 1.2828904, 1.2973132,
            0.98844105, 1.1156198,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513, 0.06810815, 0.79673207,
            0.29373887, 0.55241185, 0.23906927, 0.18915932, 0.02753429, 0.1438574, 0.5419741,
            0.71984386, 0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286,
            0.21388301, 0.30016333, 0.49605927,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258, 0.26911622, 0.92149794,
            0.7165893, 0.04745785, 0.55642486, 0.34654748, 0.83168656, 0.8410765, 0.7668131,
            0.84094906, 0.6012723, 0.9256995, 0.66010624,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(
        kernel10,
        Some(Array::from_shape_vec((1,), vec![0.43380973]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.7103783, 0.5916066, 1.8052368, 1.0540432, 2.3472033, 0.90808475, 1.3718905,
            0.62332046, 0.6640419, 1.349241, 1.3297951, 1.8946807, 1.2355548, 1.1727552, 1.3939762,
            1.102268, 2.7332082, 1.860842, 2.3988428, 1.5364892, 1.0985029, 0.7448971, 0.88775563,
            1.2305362, 0.914111, 1.0707196, 0.5781593, 0.5728642, 1.87594, 1.4552438, 2.3440409,
            1.4617273, 2.689662, 1.0836438, 1.4325783, 0.748842, 0.91307807, 1.5550573, 1.2529799,
            1.9369442, 1.1940317, 1.11139, 1.5456059, 1.281788, 2.0005608, 1.644482, 2.5906148,
            1.5962613, 1.3065926, 0.6824239, 0.71809995, 0.9848474, 0.7591498, 1.1622764,
            0.8280477, 0.8583802, 0.78271353, 0.8031156, 0.94113076, 0.8472203, 0.964566,
            0.9127423, 0.76256824,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.62281454, 0.45852852, 0.61445725, 0.524579, 0.06486581, 0.14233574, 0.13930365,
            0.5838787, 0.45914945, 0.30819193, 0.70949817, 0.8803759, 0.6927248, 0.50569826,
            0.7358748, 0.58652496, 0.85065925, 0.3247378, 0.6760192, 0.4483504, 0.59195757,
            0.37883574, 0.7796499, 0.32748002,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.44507304, 0.7488422, 0.14428215, 0.8785777, 0.15468395, 0.6638725, 0.30651525,
            0.9492515, 0.55669755, 0.08302987, 0.45890567, 0.05946975, 0.9099885, 0.30235246,
            0.24214035, 0.42138377, 0.38782486, 0.21880285,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(
        kernel11,
        Some(Array::from_shape_vec((1,), vec![0.9182205]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            1.2529353, 1.7025056, 1.2953445, 1.4936538, 1.3490297, 1.7160492, 1.050638, 2.0957832,
            1.224007, 2.3624592, 1.1420467, 2.554561, 1.2357607, 1.5043268, 1.6832007, 2.4400706,
            1.9802171, 1.9885483, 1.9328169, 2.0424967, 1.4611474, 1.9128349, 1.1767018, 2.2395754,
            1.1854532, 1.5878227, 1.0384228, 1.0913454, 1.4442942, 2.0581923, 2.074319, 1.9526849,
            1.685337, 1.7947575, 1.1699626, 1.6557794, 1.1441646, 2.0953684, 1.1440971, 2.3564782,
            1.1682234, 1.366374, 1.4144053, 1.7172687, 1.9590893, 2.5354376, 2.299298, 2.3931897,
            1.4498476, 1.5337272, 1.0804348, 2.5473738, 1.2636976, 2.6495032, 1.153415, 1.581974,
            1.1723213, 1.3576941, 1.7186844, 1.8940804, 1.8916295, 1.8809235, 1.4799771,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.85290706, 0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431, 0.2624427, 0.6557088,
            0.00633, 0.6603214, 0.45500925, 0.6523986, 0.14666249, 0.32440838, 0.2805719,
            0.42671442, 0.74477625, 0.9118973, 0.5335283, 0.36968935, 0.5693756, 0.36426732,
            0.11819325, 0.95361024,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.13343851, 0.5940242, 0.7282295, 0.9320007, 0.46956548, 0.5087874, 0.7952918,
            0.73709416, 0.3358689, 0.03185032, 0.27057356, 0.26166973, 0.5843129, 0.5337139,
            0.19571388, 0.1192536, 0.75616854, 0.97167397,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(
        kernel12,
        Some(Array::from_shape_vec((1,), vec![0.71154076]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.83002263, 1.2578712, 1.4490201, 1.1005067, 1.2449529, 1.1006396, 1.1688976,
            1.5921475, 1.1903123, 1.8363037, 1.122767, 1.6883183, 1.1088518, 1.0346972, 1.5166886,
            1.9928505, 2.3152502, 1.8652861, 2.3117378, 1.6905031, 1.561012, 1.6296885, 1.276249,
            2.118111, 1.3724194, 1.8817644, 1.3021452, 1.0026035, 1.3851504, 1.863411, 2.3320887,
            2.1776912, 2.5015736, 1.7220218, 1.8255315, 1.267885, 1.1195263, 1.7766225, 1.2167473,
            1.4561036, 1.0183967, 0.8261961, 1.0835989, 1.799231, 2.5243328, 1.7766738, 1.8436313,
            1.7923129, 1.9915411, 1.5398068, 1.2160194, 1.6119269, 0.98827875, 2.1314185,
            1.5268396, 1.2301078, 1.2801292, 1.4737073, 1.6632314, 1.1362995, 1.6117783, 1.9135101,
            1.8572595,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.26672947, 0.07128377, 0.3383284, 0.8008563, 0.9504947, 0.5971434, 0.7847773,
            0.92326206, 0.24163638, 0.12968542, 0.5954836, 0.6734995, 0.08627631, 0.7485715,
            0.8782484, 0.6863155, 0.7264353, 0.08944888, 0.68172634, 0.4284322, 0.48237634,
            0.6856524, 0.04009921, 0.0687674,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.9063645, 0.42620143, 0.61030614, 0.10040135, 0.50107217, 0.763057, 0.25769317,
            0.8816114, 0.7770131, 0.23345616, 0.62762326, 0.15315741, 0.73589575, 0.2752067,
            0.85641515, 0.7439484, 0.6581306, 0.4056261, 0.13899311, 0.26460668, 0.9179794,
            0.96651816, 0.89336777, 0.18948041, 0.9371178, 0.7124811, 0.9657549, 0.6203675,
            0.32684848, 0.11439406, 0.07654371, 0.95680344, 0.9728639, 0.6055871, 0.00439729,
            0.8525613, 0.3167563, 0.13499211, 0.68338645, 0.7955047, 0.21689218, 0.2826704,
            0.12328367, 0.6890043, 0.5906649, 0.41700745, 0.30266365, 0.5716598, 0.12726787,
            0.35587692,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(
        kernel13,
        Some(Array::from_shape_vec((1,), vec![0.16889893]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.47212327, 0.36590117, 0.98316073, 0.9771961, 1.7526977, 1.4130942, 1.0415701,
            0.4899217, 0.43889225, 0.3790326, 0.32018274, 0.5996778, 1.1630042, 1.348039,
            1.6051086, 1.3415226, 0.96364045, 0.2517457, 1.6247149, 1.2412177, 3.3533745, 1.960686,
            3.6960824, 1.7038428, 2.1722682, 0.95138246, 1.4667436, 1.0496767, 1.2318738,
            2.6577394, 2.5018215, 3.0509965, 2.5834262, 1.7139878, 1.3391985, 0.91697353, 2.734502,
            1.785716, 4.7759185, 2.6998494, 5.9615555, 2.5498705, 4.1081753, 0.75216895, 1.5573188,
            1.5645628, 1.7444779, 3.5354266, 3.2544484, 3.36322, 2.720458, 2.0024714, 0.793404,
            0.43827403, 2.8700817, 2.2042434, 5.139228, 3.035146, 6.719256, 2.208703, 4.03387,
            0.7796761, 1.6963376, 1.0520335, 1.5675423, 2.5898893, 2.1842306, 2.6074038, 1.6141347,
            1.6236051, 1.0998067, 0.67529535, 1.8395475, 1.3707812, 2.881823, 2.0345414, 4.2211037,
            1.0941267, 2.7249873, 0.5084216, 1.1985073, 0.4140908, 0.44806248, 0.75773877,
            1.0625826, 1.3706566, 0.7419847, 0.63181996, 0.30989176, 0.38772988, 0.5738696,
            0.5017643, 1.240079, 0.8684156, 1.7362815, 0.9585977, 1.3822019, 0.30526578,
            0.82452005,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.3114892, 0.1309899, 0.24026695, 0.55435276, 0.34375766, 0.4225387, 0.37165096,
            0.6202945, 0.6069533, 0.05756181, 0.0153275, 0.8497578, 0.79796964, 0.4071996,
            0.19325097, 0.04944435, 0.59729165, 0.39304134, 0.679002, 0.6126854, 0.67232877,
            0.7156292, 0.09058711, 0.33372015,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.8941644, 0.30899736, 0.3348802, 0.6412177, 0.26750943, 0.03709449, 0.56803024,
            0.8756273, 0.5771133, 0.56024176, 0.5868575, 0.75167763, 0.36936092, 0.37185487,
            0.35425207, 0.24336162, 0.01027582, 0.2671537, 0.83992416, 0.49819484, 0.7831867,
            0.70054483, 0.8701863, 0.49413827, 0.84670645, 0.8069649, 0.093459, 0.93408287,
            0.8206956, 0.70209366, 0.32817394, 0.744203, 0.39091238, 0.43911496, 0.92919487,
            0.29325068, 0.62813336, 0.8131431, 0.19520658, 0.47931832, 0.42483747, 0.47526902,
            0.28184402, 0.09741595, 0.45691565, 0.44086096, 0.9638409, 0.33859608, 0.26381832,
            0.29839757,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(
        kernel14,
        Some(Array::from_shape_vec((1,), vec![0.68755937]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            1.6100154, 0.85838616, 1.982963, 1.620714, 2.126144, 1.1980422, 1.2694657, 1.000223,
            0.88751334, 0.96098673, 1.458346, 1.4107354, 1.5951697, 1.949748, 1.2222596, 1.4252416,
            0.91108, 1.0017347, 1.6399467, 1.5988448, 2.6689548, 1.871477, 3.3085904, 1.9956621,
            2.194973, 1.4081342, 1.2542881, 1.1391611, 1.4216962, 1.9140513, 2.2032042, 2.5333467,
            1.924748, 2.3287475, 1.3246341, 1.4974943, 2.5033808, 2.3009377, 3.9405286, 3.430095,
            5.3520365, 3.174167, 3.5055902, 2.0320816, 1.9211411, 1.0800903, 1.4331794, 2.0019364,
            2.7663498, 3.3812625, 2.6977541, 3.0664942, 1.7262588, 2.0424178, 2.1897006, 1.9140987,
            3.7268734, 3.5503237, 5.5517597, 3.2965763, 3.6059077, 2.1757474, 2.161503, 1.3034565,
            1.5793573, 1.7499155, 1.7870129, 2.841776, 2.3736866, 2.595461, 1.8997977, 2.0832987,
            1.5216162, 2.095146, 2.6355176, 2.3049371, 3.763115, 3.1006718, 2.7854803, 1.5459818,
            1.8630786, 1.0055938, 1.0282673, 0.9468479, 0.84883136, 1.4214201, 0.87659675,
            1.0576591, 1.4338012, 1.2633862, 1.048134, 1.4176366, 1.0318987, 1.0028481, 1.8064928,
            1.6359783, 1.5800121, 1.1954987, 1.5066361,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.09156765, 0.58584654, 0.04617033, 0.14705709, 0.81179595, 0.16751295, 0.06864621,
            0.6308731, 0.38993102, 0.3644169, 0.68174505, 0.272409, 0.23609333, 0.21866773,
            0.80119157, 0.01742986, 0.49270406, 0.37920174, 0.90869635, 0.8191268, 0.7636344,
            0.7827788, 0.9694966, 0.79533535,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.00732174, 0.8372113, 0.9449071, 0.7670253, 0.50964797, 0.7843069, 0.7365313,
            0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833, 0.5585159,
            0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028, 0.52249014,
            0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726, 0.25884646,
            0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234, 0.32747796,
            0.9097073, 0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446, 0.9843364,
            0.4038572, 0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686, 0.5288406,
            0.92906404,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(
        kernel15,
        Some(Array::from_shape_vec((1,), vec![0.87780553]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            1.0399482, 1.1250083, 1.1792841, 1.7848765, 2.1684573, 2.1190565, 1.5065944, 1.5525783,
            1.1915264, 1.1159815, 1.1644464, 1.6672144, 1.6491258, 2.1624987, 2.2317817, 1.9171727,
            1.1047597, 1.1842476, 1.1209732, 1.2780163, 1.6925485, 2.8947558, 3.2018275, 3.3430645,
            2.2053225, 1.580631, 1.6250107, 1.0903625, 1.2616341, 2.4142408, 2.6661842, 3.0153143,
            3.5954826, 3.0221803, 1.6135786, 1.7171302, 1.7492937, 2.027746, 2.894319, 4.6959467,
            4.2995243, 5.069624, 3.321229, 2.4355938, 2.430018, 1.6393517, 1.8324552, 2.9557276,
            3.2273135, 3.7995965, 3.9894385, 3.5283191, 1.7573359, 1.8675979, 2.3427584, 2.5854468,
            3.8033829, 5.5622096, 5.0882053, 5.524083, 3.7371979, 2.4309413, 2.3678892, 1.9184351,
            2.7876308, 3.555637, 4.3576946, 4.8102694, 4.4984374, 3.9104903, 2.0594552, 2.1762204,
            2.306997, 2.7440772, 3.0703359, 4.345688, 4.471586, 4.015523, 3.0808036, 1.8100846,
            2.298286, 1.1859245, 1.755532, 1.8647401, 2.7762525, 2.6650074, 2.8474238, 2.4620266,
            1.5544529, 1.5919093, 1.6022619, 1.8395419, 2.1599815, 2.727433, 2.761963, 2.5473204,
            2.1417618, 1.3907294, 1.6674441,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.9090181, 0.82569945, 0.20383635, 0.7166643, 0.17061436, 0.91526777, 0.08598401,
            0.70100874, 0.40537685, 0.5971982, 0.92796123, 0.15859716, 0.7859081, 0.8564488,
            0.35816404, 0.79062706, 0.9644883, 0.13154314, 0.31929043, 0.80048305, 0.07180241,
            0.52815664, 0.45786336, 0.91537887,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.9783313, 0.25753945, 0.42799363, 0.07738555, 0.9294206, 0.07022415, 0.60058224,
            0.6196278, 0.9008346, 0.04155485, 0.82207745, 0.41282526, 0.9949608, 0.3109271,
            0.47614527, 0.7615821, 0.35893062, 0.07713356, 0.6123928, 0.62511915, 0.88098776,
            0.21521498, 0.89468116, 0.1842307, 0.10784956, 0.8354833, 0.2630701, 0.7184675,
            0.06132602, 0.06056971, 0.71349823, 0.00944792,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(
        kernel16,
        Some(Array::from_shape_vec((1,), vec![0.07349233]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            1.2448996, 0.3682202, 2.059044, 0.9138346, 1.279345, 0.75289446, 0.3800701, 0.31316152,
            1.6107279, 0.30646655, 2.8445127, 1.0238383, 1.8406292, 0.8342993, 0.51635545,
            0.2657798, 1.9620426, 1.0134327, 3.1677146, 2.4312978, 2.8061554, 2.1993902, 0.8075687,
            0.568029, 2.3887417, 0.6242148, 4.0871725, 1.891093, 3.234428, 1.1714836, 1.0934802,
            0.823474, 1.0030811, 0.81060123, 2.3338196, 2.198823, 2.5187726, 1.6493998, 1.0779884,
            0.62210286, 1.1962374, 0.41896498, 2.9017937, 1.0718331, 3.338826, 1.1308489, 0.910851,
            1.0361977, 0.9592143, 0.5383679, 2.5972292, 1.6869876, 2.394552, 1.484324, 1.0540825,
            0.87692386, 1.1989716, 0.2751714, 3.1858494, 1.0394881, 3.3069546, 1.6128063,
            1.2319643, 0.6498106, 0.6684306, 0.53957486, 1.5886977, 1.1205926, 1.1983914,
            1.5569123, 0.44468027, 0.7966352, 0.70007086, 0.29116774, 1.686048, 0.8495587,
            1.0559559, 0.88929325, 0.80212885, 0.2029255,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.35231608, 0.8533961, 0.17608605, 0.18067755, 0.51991457, 0.19053963, 0.5045173,
            0.7456122, 0.27621788, 0.48649722, 0.39297876, 0.54849166, 0.3746991, 0.8194284,
            0.34880427, 0.79505837, 0.41293454, 0.890512, 0.12076204, 0.20799449, 0.88948244,
            0.24437675, 0.7731474, 0.65954226,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.4922565, 0.5211581, 0.97382414, 0.9779564, 0.1754263, 0.4551989, 0.81067127,
            0.7095975, 0.5087082, 0.78796804, 0.03310984, 0.20805901, 0.45704818, 0.9133983,
            0.5689028, 0.04247752, 0.55938286, 0.9835293, 0.04525762, 0.7176199, 0.82096803,
            0.5575717, 0.5744108, 0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355,
            0.1134909, 0.5645703, 0.30096474, 0.4096875,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(
        kernel17,
        Some(Array::from_shape_vec((1,), vec![0.5703153]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.9533454, 1.1224552, 1.8088312, 2.4344428, 1.720253, 2.4277656, 0.7575782, 0.99282867,
            0.9397368, 0.93961084, 1.8935916, 2.0321546, 2.0500748, 2.2519782, 0.91342014,
            1.0364201, 1.4127326, 1.8486388, 2.3278284, 3.0688076, 2.6465294, 2.904887, 1.1088628,
            1.4844248, 1.4582787, 1.6292105, 2.3999338, 3.3536415, 2.8456812, 2.6561027, 1.4414537,
            1.7268844, 1.2529323, 1.3587412, 2.6631227, 2.4468095, 2.7245734, 3.0835998, 1.669301,
            1.6513724, 0.9307729, 1.4812014, 1.9767997, 2.5432267, 2.681139, 2.7925713, 1.6815767,
            2.0092192, 1.2448887, 1.501905, 2.2552047, 2.9663527, 2.2825565, 3.143575, 1.9259725,
            1.7703073, 1.1005793, 1.4570298, 2.4964979, 2.6338923, 2.6846519, 3.094135, 1.8186538,
            1.9807444, 0.9022658, 1.0349132, 1.2685542, 1.2747476, 1.7704918, 1.4190145, 1.1687121,
            0.7829191, 0.8204025, 1.1526489, 1.1879892, 1.4865408, 1.3521113, 1.7771063, 1.0808527,
            0.8638201,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.88738924, 0.6242374, 0.77620894, 0.681929, 0.24701218, 0.74485576, 0.61556435,
            0.63869125, 0.05875124, 0.3210932, 0.96946657, 0.09463912, 0.6275637, 0.34162354,
            0.74390864, 0.8736778, 0.9513908, 0.24045336, 0.7003475, 0.87750345, 0.16564246,
            0.6314963, 0.21785556, 0.7654987,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.13988015, 0.03287261, 0.82226163, 0.60896695, 0.13331373, 0.62307173, 0.23316076,
            0.9600204, 0.55291533, 0.29808274, 0.8765127, 0.98263544, 0.27148733, 0.11101003,
            0.2754741, 0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706,
            0.18621969, 0.5836321, 0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146,
            0.46701643, 0.91682273, 0.6142979, 0.19277428,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(
        kernel18,
        Some(Array::from_shape_vec((1,), vec![0.28408903]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.531856, 0.36635137, 1.7835019, 1.4889646, 1.3873637, 1.0874981, 1.6514981, 1.4858656,
            0.79515535, 0.95386094, 1.1542866, 1.7013075, 1.1980789, 1.5669084, 0.8992395,
            1.1629124, 1.5526931, 1.2383256, 3.5016158, 3.230647, 3.2493873, 3.0717258, 2.0231621,
            1.9794691, 1.4557943, 1.5455496, 2.5403395, 2.3331838, 2.086702, 2.3185086, 1.2689035,
            1.5382016, 1.5958397, 1.3929491, 3.4943466, 3.3697314, 2.8034391, 2.5523896, 1.2156925,
            1.2928033, 1.3976266, 1.674757, 2.706626, 2.9399471, 2.0236442, 1.7210426, 0.7473602,
            0.7547983, 1.3634098, 1.1937699, 3.1502745, 3.002962, 2.4342432, 2.2446895, 1.2106127,
            1.2038983, 1.2163134, 1.3121784, 2.1761057, 2.6403296, 1.9372871, 2.0729923, 0.870863,
            0.57107735, 0.9752628, 0.9769116, 1.4575047, 1.3011947, 1.8704593, 2.0600257,
            0.58371526, 0.6275418, 0.6661809, 0.89870375, 1.1254088, 0.8589702, 1.0681739,
            1.4785962, 0.7804039, 0.47462755,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.25507236, 0.9800453, 0.36125833, 0.96792, 0.33258557, 0.9508625, 0.8424581,
            0.8130291, 0.7774976, 0.17691322, 0.9389267, 0.22419459, 0.33442205, 0.7614585,
            0.37563834, 0.70754576, 0.1499497, 0.9873837, 0.7166968, 0.40278858, 0.22288306,
            0.3279577, 0.07722609, 0.598755, 0.8143903, 0.87905455, 0.83061284, 0.9923988,
            0.6196494, 0.536406, 0.06662867, 0.83588266, 0.28182983, 0.662181, 0.99850965,
            0.60448396, 0.12318801, 0.91713256, 0.8540598, 0.19103892, 0.5929614, 0.9118344,
            0.9381113, 0.3421722, 0.8149188, 0.9595595, 0.02717085, 0.8916309, 0.9755575,
            0.27588442, 0.59208006, 0.00008138, 0.9552037, 0.12578069, 0.01249961, 0.05413999,
            0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439, 0.34315115, 0.52290094,
            0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794, 0.6930413, 0.90735817,
            0.91156703, 0.45996496,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9045769, 0.17170428, 0.43418503, 0.69308424, 0.42869946, 0.9244341, 0.41451567,
            0.6224708, 0.00536506, 0.33826837, 0.47926104, 0.0032256, 0.02230139, 0.35960108,
            0.48593593, 0.86064774, 0.28908366, 0.4153976,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(
        kernel19,
        Some(Array::from_shape_vec((1,), vec![0.3468706]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.6192738, 0.44970682, 1.6547799, 0.9546945, 1.3910372, 0.81821775, 1.4466588,
            0.60462415, 1.2691724, 0.68816024, 1.6617599, 0.9471445, 0.76266205, 0.5264045,
            0.50051856, 1.342237, 1.0968174, 1.9679549, 0.8088627, 1.7709589, 0.8305152, 1.5782154,
            0.7026794, 1.6218283, 1.0824015, 1.6689734, 1.638025, 1.1355112, 2.8149855, 1.5256386,
            2.9509716, 1.3426967, 2.0940452, 1.4948549, 2.018044, 0.8995505, 2.6860528, 1.6681702,
            0.83096385, 0.9516862, 1.0453777, 2.1526582, 0.81846124, 1.8217814, 0.9732291,
            1.6056294, 0.76777184, 1.6280608, 0.7591586, 1.4033201, 0.7636142, 0.9873992,
            2.1359768, 1.6674373, 2.3030512, 1.2148402, 2.3885927, 1.4146795, 2.3937967,
            0.85591453, 1.9249651, 1.4227188, 2.2274063, 0.9740009, 1.1475677, 0.6004095,
            0.8410487, 1.6639876, 0.7725158, 1.4584043, 0.7208192, 1.4722271, 0.6502243, 1.1262197,
            0.75464624, 1.6368022, 0.8153924, 1.3207631, 1.9776409, 0.9661068, 2.0008712,
            0.9957177, 1.68184, 1.0371139, 1.4190886, 1.0360311, 1.7427502, 1.1465039, 2.0587745,
            1.4106767, 0.666474, 0.84388065, 0.65861297, 1.2958574, 0.53901464, 0.9115005,
            0.62774205, 1.0395951, 0.63182724, 0.91804796, 0.6927875, 1.2703812, 0.8361709,
            1.2147164, 1.6904333, 1.3601289, 1.837163, 0.9286421, 2.2184606, 1.0278149, 2.52826,
            1.1557379, 2.6215055, 1.2230372, 2.5586622, 1.4062734, 0.854433, 0.9310271, 1.0139024,
            2.1462212, 0.8471183, 1.9135942, 0.8909896, 2.07144, 1.0111184, 2.038333, 0.96533936,
            1.7872164, 0.8826545, 1.2560124, 1.7755041, 1.5032537, 2.4852946, 1.5894327, 2.1438115,
            1.3956039, 2.581976, 1.705148, 3.2313604, 1.624548, 2.8509345, 1.2508581, 0.9669697,
            0.41084617, 0.6623925, 1.396637, 1.0448489, 1.7893331, 0.7169093, 1.4233601,
            0.95703423, 2.1123118, 1.1027317, 2.1421063, 0.7714164, 1.1291897, 1.0612779, 0.619031,
            1.838062, 1.1402167, 1.4569771, 0.7226484, 1.6916704, 1.0213614, 1.9257736, 1.2319329,
            1.3773263, 0.85611254, 0.54118204,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.2242362, 0.93169004, 0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496,
            0.11111139, 0.19382912, 0.9307082, 0.9188555, 0.10532705, 0.88550454, 0.20754221,
            0.97926295, 0.3472928, 0.71126235, 0.03633394, 0.7482733, 0.28782296, 0.7382309,
            0.60003114, 0.3259743, 0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927,
            0.968827, 0.47373444, 0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834,
            0.3979838, 0.2393961, 0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945,
            0.66457146, 0.8425775, 0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123,
            0.48163053, 0.437191, 0.43973154, 0.29997745, 0.21913478, 0.6611514, 0.209788,
            0.176356, 0.88925517, 0.14793599, 0.36509594, 0.5616029, 0.6617385, 0.30053073,
            0.36820948, 0.62227124, 0.4957459, 0.69923055, 0.3227648, 0.9702412, 0.5679234,
            0.13432135, 0.7430913,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.19231908, 0.26170298, 0.10480803, 0.00958306, 0.20726651, 0.20851518, 0.17973869,
            0.23704103, 0.1163867, 0.2735905, 0.8537909, 0.40303, 0.75797635, 0.34342998,
            0.74670875, 0.82946825, 0.91931367, 0.9654975,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(
        kernel20,
        Some(Array::from_shape_vec((1,), vec![0.18782942]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.29645082, 0.45090693, 0.58687776, 0.74335307, 0.49863535, 0.28559753, 0.41109723,
            0.570518, 0.5628226, 0.76814026, 0.8495051, 1.1730766, 0.63991416, 0.37143487,
            0.31652188, 0.69899184, 0.50631523, 0.67025137, 0.25978175, 0.48235542, 0.3986382,
            0.9876736, 0.43896568, 1.4118952, 0.6549318, 1.0353723, 0.77791315, 1.2589666,
            1.5273861, 1.4927596, 1.2260925, 0.6967921, 1.1304965, 1.400891, 1.7862662, 1.5627433,
            2.2878735, 1.8966018, 1.4958903, 0.69999933, 0.59861624, 1.5074421, 0.5002255,
            1.168077, 0.37573832, 1.0754085, 0.6149937, 1.3593549, 0.58638525, 1.4112206,
            0.47168297, 0.77949935, 1.2209922, 1.717744, 2.1411855, 1.4542865, 1.9297279,
            1.2587854, 1.8247327, 1.5018518, 2.0550046, 1.4049687, 1.7940011, 1.1107981, 1.0288483,
            0.621071, 0.5638166, 1.1579655, 0.39625233, 0.93150765, 0.5409423, 1.0551091,
            0.4108286, 0.82278854, 0.43827152, 0.7265814, 0.27061766, 0.35903543, 1.1365992,
            1.6732068, 1.7263764, 0.9342342, 1.5205873, 1.1656389, 1.6582131, 1.5906711, 1.553922,
            0.843816, 1.1067932, 0.933574, 0.64047056, 0.6961373, 0.5699806, 0.99931586, 0.319533,
            0.5452436, 0.40140587, 1.1532328, 0.6175927, 1.0922154, 0.30619863, 0.6512003,
            0.49059093, 0.638895, 1.0515759, 1.4895102, 1.6365885, 1.1164689, 1.1034583,
            0.79597646, 1.6334935, 1.6202942, 1.8659265, 1.1859326, 1.4043287, 1.2735654,
            0.8893829, 0.61486644, 0.41001418, 1.1420113, 0.49632198, 0.9920004, 0.30247632,
            0.7086356, 0.43969905, 1.0698968, 0.6023414, 1.2348033, 0.45627272, 0.65678805,
            1.0176452, 1.5350288, 1.9132866, 1.2967361, 1.6835438, 1.4465005, 1.5126692, 1.1699249,
            1.6849066, 1.252687, 1.7911776, 1.494468, 1.0628072, 0.7251675, 0.5866726, 1.1190983,
            0.40328825, 1.274663, 0.6326528, 1.4556348, 0.3949697, 0.7313228, 0.35153925,
            0.9734761, 0.52551794, 0.8256879, 0.905447, 1.0121467, 1.3104943, 0.60419106,
            1.4597747, 1.2074325, 1.6688353, 0.7237655, 0.95633066, 0.4457835, 1.0714449,
            0.9653019, 0.9516022,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.10021565, 0.05109123, 0.3069365, 0.10895161, 0.9891213, 0.62504834, 0.507994,
            0.47125, 0.84314245, 0.6054993, 0.92367506, 0.6953895, 0.37023902, 0.67128026,
            0.43450755, 0.28869846, 0.27641538, 0.8369712, 0.6856483, 0.26890948, 0.65425915,
            0.84581685, 0.51146317, 0.48995435, 0.52071315, 0.80564773, 0.670521, 0.3835857,
            0.47078377, 0.5100531, 0.82525116, 0.02126783, 0.9583153, 0.23316967, 0.9487504,
            0.9609589, 0.95734006, 0.00943314, 0.7521432, 0.46106157, 0.84370506, 0.16933449,
            0.71423984, 0.5316646, 0.6400151, 0.9638914, 0.69432026, 0.8581641, 0.70813745,
            0.2836983, 0.33953485, 0.8950543, 0.20262088, 0.81930757, 0.09556881, 0.22266188,
            0.63842744, 0.8304186, 0.12425002, 0.7582065, 0.09737789, 0.84872884, 0.17490041,
            0.37569723, 0.6669188, 0.8970669, 0.22398192, 0.29424527, 0.56277037, 0.41113177,
            0.7882464, 0.24159203,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633, 0.9636684, 0.98529965,
            0.26998708, 0.13811645, 0.9724998, 0.41856614, 0.13321315, 0.0937838, 0.4742414,
            0.79873264, 0.1621314, 0.5493846, 0.6481355,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(
        kernel21,
        Some(Array::from_shape_vec((1,), vec![0.05176858]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            1.0375085, 0.48223287, 0.24786156, 0.07088603, 0.96815294, 0.4577201, 0.75628555,
            0.27710122, 1.5080752, 0.6985864, 0.98096186, 0.30822393, 0.27072105, 0.21819761,
            0.51021004, 0.9529618, 0.05850123, 0.41382542, 0.42203763, 1.0748824, 0.2752405,
            1.3606435, 0.49562377, 2.1727731, 0.15971136, 0.7893609, 1.2777352, 1.054554,
            1.7671165, 0.4331965, 1.7910519, 1.0660721, 2.381977, 0.9177101, 2.9753118, 1.3471963,
            2.9755607, 0.8792138, 0.58066505, 0.5072721, 0.4129523, 1.5220718, 0.32474288,
            1.635423, 0.3925709, 1.9289691, 0.5356588, 2.1767137, 0.42188552, 2.108785, 0.48949307,
            1.4073371, 1.5589435, 0.9876396, 1.9885192, 0.78913885, 2.2121532, 0.90214425,
            2.5457642, 1.2051469, 2.340739, 0.84947616, 2.821342, 1.3024092, 1.076145, 0.40134332,
            0.4039673, 1.5141776, 0.21599162, 1.2894182, 0.2320024, 1.0464287, 0.48900557,
            1.2752953, 0.16008186, 1.1969439, 0.47732595, 1.512739, 0.99874365, 0.7843399,
            1.860837, 0.56190336, 1.9038385, 0.81708974, 2.321512, 1.2201517, 1.7534857,
            0.44157487, 2.3609476, 1.1906825, 0.9533408, 0.5851229, 0.12740812, 1.0153872,
            0.16925424, 1.0490142, 0.38346624, 1.9169602, 0.48298636, 1.9329633, 0.13330811,
            1.089722, 0.43300548, 1.1295264, 1.1218894, 0.4847483, 1.9513963, 0.84114474,
            1.8838336, 0.8514382, 2.33276, 1.0074886, 2.3071456, 0.67704403, 2.196321, 1.1275141,
            0.8906235, 0.45914823, 0.12097323, 1.3271075, 0.4898937, 2.035278, 0.16436158,
            1.1662321, 0.2469005, 1.1441064, 0.3888654, 1.5123625, 0.4997475, 1.2598072, 1.2491,
            0.5846217, 1.7051167, 0.86503714, 2.5186558, 0.8489699, 1.5998325, 0.60304826,
            2.332948, 1.1568874, 2.359872, 1.0687432, 1.0377599, 0.70393574, 0.19447967, 1.0698,
            0.19225225, 1.0929959, 0.3610308, 1.6416581, 0.2570542, 1.4043907, 0.4675379, 2.353257,
            0.20883161, 1.1707817, 0.90120274, 0.39762795, 0.37958154, 0.21916443, 1.2808872,
            0.61967874, 0.84527856, 0.34059083, 1.413045, 0.74096936, 1.6796992, 0.44394198,
            0.34107718,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.17029643, 0.955536, 0.089831, 0.05664136, 0.9231865, 0.98567015, 0.01680515,
            0.54690886, 0.8593988, 0.6496963, 0.8382851, 0.2400014, 0.36792266, 0.01756373,
            0.6596718, 0.5680892, 0.19350345, 0.4854058, 0.7869872, 0.12335967, 0.14544043,
            0.25711668, 0.05608724, 0.18204254, 0.9562488, 0.44598028, 0.3229758, 0.8930679,
            0.24216229, 0.21437034, 0.38366762, 0.64894366, 0.8650639, 0.7790032, 0.3529938,
            0.37360683, 0.26240814, 0.554433, 0.90017563, 0.6817857, 0.95833224, 0.28551313,
            0.85106283, 0.70093375, 0.4791875, 0.5805011, 0.9803199, 0.97033703, 0.48236644,
            0.66855663, 0.35855147, 0.25242767, 0.6717967, 0.26290378, 0.53677225, 0.18097793,
            0.07985484, 0.79416144, 0.7215235, 0.42313012, 0.6529702, 0.00384528, 0.08442257,
            0.7838985, 0.980683, 0.36212954, 0.61172485, 0.5263662, 0.8496614, 0.13177402,
            0.9175598, 0.04323238,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.03087392, 0.03482862, 0.36226457, 0.6059544, 0.29194582, 0.34645593, 0.9409913,
            0.60953087, 0.8610255, 0.1627552, 0.8939359, 0.66327935, 0.48094535, 0.06551108,
            0.86129206, 0.65446067, 0.9592776, 0.8000413, 0.21450381, 0.6442533, 0.46971878,
            0.84573215, 0.34651902, 0.18830031, 0.57119006, 0.27269888, 0.7915957, 0.21737069,
            0.04463017, 0.393406, 0.8441482, 0.77705365, 0.6315176, 0.8522896, 0.16809769,
            0.22305161, 0.773223, 0.9678148, 0.2237789, 0.8982615, 0.271913, 0.34780893,
            0.49277794, 0.14560463, 0.33638617, 0.1585067, 0.18610527, 0.6963084, 0.9429821,
            0.40789625,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(
        kernel22,
        Some(Array::from_shape_vec((1,), vec![0.20056698]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (1, 15, 15),
        vec![
            0.2773831, 0.41421932, 0.4999936, 0.787637, 1.0684419, 1.5200266, 1.1135343, 0.8368468,
            1.0394852, 1.0560822, 1.1363635, 1.0630869, 1.2662367, 0.8105806, 0.60065186,
            0.48107854, 0.5647197, 1.269158, 1.9008195, 1.9959608, 2.2798603, 1.6676679, 1.6282072,
            1.9604071, 2.4438016, 2.0748131, 2.9615967, 1.2930168, 1.2925941, 0.408984, 0.64393437,
            1.1907041, 1.913401, 1.9550029, 2.7076056, 1.9147942, 3.6679738, 1.9969265, 3.9068139,
            2.9349895, 4.3849163, 2.6782284, 3.5351748, 0.5177673, 1.7577862, 1.1076169, 1.1323314,
            2.5711148, 3.1838863, 3.363848, 3.1348653, 3.4889922, 2.8531816, 3.908297, 4.135637,
            4.6355815, 4.1201115, 3.1072721, 1.4872246, 1.1338038, 0.66990554, 1.4572891,
            2.8770034, 3.2619834, 4.4694204, 2.6273224, 5.124571, 2.9197776, 5.4953923, 4.1937857,
            5.4383626, 3.720865, 4.870041, 1.1941336, 2.2034996, 0.9776381, 1.2337316, 2.281249,
            2.3604572, 3.0784688, 2.8952937, 3.4491007, 2.8841267, 3.8439112, 2.977953, 3.4562614,
            2.491071, 2.346892, 1.0353507, 0.8047925, 0.95052636, 1.4424955, 2.4305413, 2.908286,
            4.3410892, 2.7971706, 4.073359, 2.8965013, 4.3341203, 3.2675672, 4.6855707, 2.762132,
            3.5542324, 1.3805954, 1.6072912, 1.2982913, 1.8789272, 1.9400889, 1.9909124, 1.9981862,
            1.5185661, 2.5307062, 2.0793655, 2.9582174, 2.290139, 2.6119366, 2.0603049, 1.577703,
            0.8603411, 0.702484, 1.480677, 2.0887322, 2.3299623, 1.8845811, 3.7195206, 2.0142314,
            2.5998476, 2.8534338, 3.4902823, 2.9847934, 4.325119, 2.427636, 2.7427504, 0.7925565,
            1.3269851, 1.7440763, 2.5494149, 2.377627, 2.431343, 1.9157486, 1.1774673, 2.17539,
            2.5657976, 3.168973, 3.1030874, 2.6919854, 2.1669014, 1.397183, 0.79444313, 0.55594665,
            1.8344449, 2.6027966, 2.860591, 2.1995397, 4.0152636, 1.9613369, 3.2499015, 2.60059,
            4.235197, 3.5489619, 4.7870317, 2.0838165, 3.036448, 0.95724857, 1.1131444, 1.6532557,
            2.1813548, 2.8696306, 2.8012972, 3.5394924, 3.1176014, 3.2258968, 3.7159162, 3.7014863,
            2.9078724, 3.0648713, 2.1980143, 1.5031419, 0.6578095, 0.5285649, 1.2326556, 1.8582971,
            2.6707692, 2.3737185, 3.9997187, 1.9680932, 4.167199, 2.1075714, 4.0746746, 2.5193822,
            4.146032, 1.9293164, 2.4151065, 0.6165645, 0.83134305, 0.61799824, 0.7813741,
            1.3767953, 1.1775271, 2.2292697, 1.5417655, 2.4521527, 1.3029536, 2.2123888, 1.0446076,
            1.7375987, 0.7833158, 1.0568436, 0.2870019, 0.4558072, 0.47774535, 0.63889223,
            1.1477178, 1.4964494, 1.8016326, 1.7088561, 2.064127, 1.8480263, 1.7141986, 0.940815,
            1.6428424, 1.4562954, 0.93602765, 0.3116846, 0.43160182,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.37306353, 0.9367061, 0.7103306, 0.06833509, 0.48335183, 0.45182207, 0.96346164,
            0.00378525, 0.33689302, 0.28288215, 0.75004077, 0.1607512, 0.514175, 0.35879079,
            0.36688787, 0.00774159, 0.15532039, 0.01133456, 0.94680935, 0.052598, 0.73530346,
            0.8096563, 0.7097644, 0.37942106, 0.38656324, 0.13763146, 0.99930644, 0.67476803,
            0.06055127, 0.8463604, 0.4460729, 0.33209085, 0.94373864, 0.5397614, 0.05766413,
            0.64256257, 0.7357459, 0.09256811, 0.8832945, 0.03911254, 0.782554, 0.4004812,
            0.80732703, 0.8010379, 0.28867772, 0.7802926, 0.9490529, 0.5395702, 0.1369102,
            0.4513485, 0.1162144, 0.9589836, 0.24819064, 0.3149064, 0.22322156, 0.39812055,
            0.45308354, 0.5711523, 0.97817534, 0.06805564, 0.5386646, 0.6699801, 0.1879456,
            0.8407316, 0.64728755, 0.53731096, 0.63207716, 0.00916763, 0.46754488, 0.8670982,
            0.1932068, 0.43971533,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.10441232, 0.46486124, 0.22910197, 0.7679019, 0.23872072, 0.03931138, 0.8551502,
            0.19610135, 0.8555064, 0.08035298, 0.05671094, 0.9091975, 0.27582648, 0.33816597,
            0.42012835, 0.7745094, 0.14011143, 0.47505257, 0.98297566, 0.5085966, 0.22395916,
            0.01153891, 0.669607, 0.12918296, 0.55476546, 0.528783, 0.5067741, 0.14234911,
            0.5152856, 0.6446142, 0.9118427, 0.8193508, 0.989135, 0.7842302, 0.59264964,
            0.35247177, 0.48483032, 0.22649786, 0.04158387, 0.5814206, 0.8653732, 0.4524277,
            0.44947338, 0.5519129, 0.79122764, 0.7513198, 0.9315116, 0.03313805, 0.41213843,
            0.45310238,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(
        kernel23,
        Some(Array::from_shape_vec((1,), vec![0.01799934]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (1, 15, 15),
        vec![
            0.44600174, 0.56427914, 0.35495383, 1.1659442, 1.3503462, 1.5628327, 0.6175726,
            1.0702001, 1.2424465, 0.7118978, 0.540601, 1.205393, 0.7983523, 0.5713166, 0.38401452,
            0.7035495, 0.9398587, 0.9401404, 1.791022, 1.592617, 2.2231197, 1.1994721, 1.4088815,
            1.3832163, 1.1616583, 1.2984452, 1.7597226, 1.0053513, 0.71860546, 0.29164964,
            0.8259838, 1.5709081, 1.1329178, 2.6348355, 2.2865973, 2.1312625, 1.9566926, 1.3104181,
            2.1834908, 2.310522, 1.7263494, 2.2321134, 1.7958537, 0.5889177, 0.8268599, 1.7176656,
            1.8885301, 3.049577, 3.0808487, 4.216438, 2.6450593, 2.9381523, 2.6268528, 4.100078,
            2.8014715, 3.4308805, 3.1350224, 2.4656088, 1.243831, 0.89735925, 1.1196116, 2.283456,
            1.7160977, 2.078553, 3.6460593, 2.2265403, 3.031007, 2.1036637, 2.9449723, 2.7457302,
            2.8775997, 1.8941005, 2.23449, 0.48918933, 1.0370659, 1.607902, 1.0701227, 2.1966112,
            2.997457, 2.7790277, 1.7115053, 3.1958287, 2.098521, 3.585909, 2.3560507, 3.2860837,
            2.140933, 1.9425502, 0.7304655, 0.7142196, 1.1346468, 1.8682737, 2.1095471, 3.0143087,
            2.5532944, 1.9683992, 3.0356414, 2.9754274, 3.2950795, 3.3145826, 3.213987, 2.4962661,
            2.1702392, 0.6044975, 0.67395943, 0.7754744, 1.144544, 1.7638265, 2.2096946, 2.200402,
            2.0810163, 3.0051565, 3.0224674, 3.0375082, 3.23794, 2.8345983, 2.2062616, 1.2187647,
            0.58091027, 0.3437475, 0.69358927, 1.5732065, 1.7752018, 2.1136453, 2.3937519,
            2.296106, 3.4350035, 3.8911798, 2.8250585, 3.3718815, 3.124778, 2.1382523, 1.9237329,
            1.2071762, 0.9143487, 1.4508556, 1.0235746, 2.178321, 2.6791677, 3.092332, 2.2491555,
            3.6171901, 3.6308825, 4.536225, 3.4898293, 3.73912, 3.0629356, 2.4497025, 1.573964,
            0.65126383, 0.9903503, 1.3771635, 1.6745611, 2.0341158, 2.923214, 2.628888, 3.3283813,
            3.8639102, 4.105365, 2.895386, 3.5708628, 2.3233876, 2.216333, 1.12362, 1.3641485,
            1.3774327, 1.2152202, 1.8642318, 2.1864903, 2.8920083, 2.2295215, 3.9189928, 3.925008,
            3.4753194, 2.796015, 3.6524699, 1.9070644, 1.8846024, 2.0410545, 1.1858195, 0.7573697,
            1.2362506, 1.1171556, 1.3991352, 1.8227965, 1.6959157, 2.703367, 2.2652175, 2.7220874,
            1.4200071, 2.4105246, 1.6278089, 1.342804, 0.58435905, 1.256606, 0.91046965,
            0.36646846, 0.7791502, 0.8560071, 2.042404, 0.6932551, 2.0210416, 1.6716415, 1.725926,
            1.1226258, 1.9710156, 0.47028488, 0.70308906, 0.8923073, 0.6927194, 0.5927936,
            0.6119337, 0.41890132, 0.3484994, 1.3371696, 0.51109135, 1.6261657, 1.1465477,
            1.3016351, 0.6257316, 1.229614, 0.5220909, 0.5823676, 0.28223106, 0.5737069,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.4328227, 0.23842481, 0.20688592, 0.57869387, 0.9324833, 0.43915927, 0.53123087,
            0.5324186, 0.4149537, 0.22217223, 0.0080786, 0.65063345, 0.7681623, 0.8421627,
            0.27179125, 0.68530315, 0.9955617, 0.77906156, 0.18006648, 0.5975193, 0.6555531,
            0.9498266, 0.9690994, 0.5122471, 0.3840358, 0.8757204, 0.7260429, 0.04691354,
            0.40678895, 0.35535267, 0.19270384, 0.23519029, 0.6665529, 0.26402712, 0.55168146,
            0.08576613, 0.9567203, 0.57141143, 0.20602623, 0.75538653, 0.96776, 0.44755465,
            0.82362133, 0.29203537, 0.30861592, 0.39762703, 0.26186082, 0.9658112, 0.27424002,
            0.50570756, 0.8114843, 0.5536027, 0.59788686, 0.05054026, 0.28394443, 0.6402348,
            0.02258505, 0.60607, 0.6834324, 0.8004999, 0.3349493, 0.4295082, 0.37033585, 0.0394791,
            0.50698835, 0.29841292, 0.9388161, 0.84357476, 0.29760668, 0.25654384, 0.71037215,
            0.14646496,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.9906275, 0.9552909, 0.7966291, 0.6094893, 0.7271988, 0.09518696, 0.3957746,
            0.6157527, 0.31079137, 0.46793708, 0.8514491, 0.86081386, 0.8208274, 0.2372746,
            0.6977758, 0.79387194, 0.9463199, 0.99063903, 0.29514915, 0.8795419, 0.741553,
            0.03520088, 0.83411527, 0.47134155, 0.26704508, 0.2872401, 0.04289522, 0.583651,
            0.94414073, 0.5729697, 0.72244126, 0.7707775, 0.02079507, 0.22973806, 0.18128674,
            0.05054512, 0.6523751, 0.27093726, 0.32479268, 0.53774405, 0.08921466, 0.18494032,
            0.78120434, 0.15868789, 0.81183356, 0.21792394, 0.6620494, 0.6886836, 0.39724785,
            0.59319293,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(
        kernel24,
        Some(Array::from_shape_vec((1,), vec![0.02472531]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (1, 15, 15),
        vec![
            0.7282998, 0.47923565, 1.3282377, 1.4440807, 1.675212, 0.91600925, 1.6008152,
            0.9305613, 2.3968287, 2.0229292, 2.7496407, 1.9454885, 1.8683859, 0.71494275,
            0.6005166, 0.7570986, 0.933444, 0.7466383, 0.9138315, 0.7279278, 0.4707812, 0.9723638,
            0.9476231, 1.3188355, 1.4931003, 1.3918971, 1.0556375, 0.9162314, 0.26403257,
            0.31135994, 1.2044383, 1.564255, 2.386312, 2.6387084, 3.3308165, 1.58925, 2.654407,
            1.9052551, 2.7732878, 2.3711932, 3.7294996, 2.1454394, 2.915453, 1.5827049, 1.5983502,
            1.0992688, 1.4563267, 2.0470393, 1.4257268, 3.0415723, 1.0543202, 2.4634364, 1.4000893,
            2.9490879, 1.7422354, 4.1614375, 2.0164747, 2.887189, 0.6494591, 1.2538685, 1.88786,
            2.4135401, 4.224773, 3.5911775, 5.381295, 2.5726871, 4.9278045, 2.9841216, 5.5628157,
            3.5478015, 6.287926, 4.355231, 4.1811886, 1.4001235, 1.976333, 0.791175, 1.1951576,
            2.5673337, 1.8949002, 3.8235042, 1.7889242, 2.7292712, 1.4487847, 2.4352195, 1.404497,
            2.5153573, 1.6570461, 2.6984663, 0.62375844, 1.7547767, 1.5259995, 1.6130509, 4.025947,
            3.1166744, 5.258739, 3.3339064, 5.515998, 3.247339, 5.813612, 4.156713, 6.5671525,
            3.6884782, 5.0310135, 1.9843227, 2.1733415, 0.8812872, 1.0924944, 2.3498094, 2.036605,
            3.036187, 1.3704656, 4.000664, 2.0366077, 4.37192, 2.7122896, 4.9455523, 2.43797,
            3.106438, 0.6057921, 1.1357923, 1.2984387, 0.9548013, 3.8472044, 3.3324525, 5.568337,
            3.7468617, 5.844056, 3.0803924, 6.0224023, 3.1770315, 5.9273825, 3.2863276, 4.054517,
            1.2918736, 1.4800414, 0.47154346, 0.6578016, 1.5934849, 1.6807287, 3.153378, 1.8708566,
            3.5206006, 1.5924467, 3.7059376, 2.020136, 3.863713, 1.6655514, 3.0720048, 0.48194158,
            1.3455218, 1.0246128, 0.99250394, 3.3031511, 3.165924, 5.6953435, 3.4019115, 5.237422,
            2.086529, 5.1832247, 2.86525, 4.6342025, 3.157902, 3.5585139, 0.9559611, 1.1910845,
            1.0560653, 1.2499772, 2.1703594, 2.118234, 3.1480849, 1.8669997, 3.0830405, 0.9272445,
            2.5089283, 1.4304273, 1.8443118, 1.0982009, 1.8220408, 0.23726583, 0.64621985,
            0.59403175, 1.038339, 1.9741508, 1.7574037, 3.6148129, 1.9765687, 2.9006712, 1.1913007,
            2.3337555, 1.496786, 2.1255963, 1.1589371, 1.8130457, 0.37868255, 0.43524313,
            0.26146364, 0.38070974, 1.2110027, 0.60915667, 2.4040802, 0.91381836, 2.0417233,
            0.56598383, 1.8159024, 0.7968067, 1.6478362, 0.40853053, 1.2860385, 0.07328133,
            0.21906538, 0.37221593, 0.6530513, 1.190251, 1.0552644, 1.9693568, 0.6911821,
            1.6005703, 0.6362617, 1.3400779, 0.7408049, 1.2923183, 0.6669356, 0.76584375,
            0.12333335, 0.13451071,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.21891202, 0.5342134, 0.4041879, 0.53426075, 0.20461221, 0.29362342, 0.7835011,
            0.47930118, 0.2895624, 0.7320774, 0.55179524, 0.37774232, 0.04187773, 0.23883641,
            0.63051957, 0.97746944, 0.6415133, 0.4162999, 0.04763152, 0.75958186, 0.13098118,
            0.6238241, 0.4102024, 0.5710282, 0.59153587, 0.66274744, 0.6454271, 0.8120847,
            0.22876394, 0.6206928, 0.19057496, 0.4622738, 0.9772445, 0.17967562, 0.27354005,
            0.48198408, 0.09082693, 0.6217685, 0.0965838, 0.8904992, 0.5337058, 0.17222154,
            0.62424076, 0.95776683, 0.998361, 0.150883, 0.28713444, 0.35105017, 0.1765902,
            0.9674033, 0.65025777, 0.1959308, 0.3119046, 0.55247456, 0.38556734, 0.18145509,
            0.94255227, 0.7036003, 0.3402552, 0.16401337, 0.28418577, 0.5504918, 0.6148071,
            0.7740251, 0.37459207, 0.25677747, 0.80441076, 0.17314304, 0.5946227, 0.30094627,
            0.06480476, 0.5798754,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.62549657, 0.6065069, 0.9259787, 0.3677915, 0.69532603, 0.8356569, 0.39276573,
            0.18570696, 0.61698794, 0.9064707, 0.01547038, 0.2551995, 0.11438051, 0.03861368,
            0.6524532, 0.36442748, 0.08230381, 0.79969245, 0.27816203, 0.3741886, 0.44356522,
            0.27386904, 0.4171807, 0.14990133, 0.4750283, 0.6358263, 0.77572674, 0.7072159,
            0.34310365, 0.36999545, 0.8200852, 0.46510443,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(
        kernel25,
        Some(Array::from_shape_vec((1,), vec![0.9230857]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            1.0674899, 1.1284909, 1.5363808, 1.8588138, 1.8514757, 1.6746036, 1.7316908, 2.1440415,
            1.8374131, 2.003696, 1.4588438, 1.5138558, 1.2428802, 1.0955212, 1.1155885, 1.1308957,
            1.6942055, 1.5940565, 1.7161798, 1.4797105, 1.8886096, 1.702963, 1.8834295, 1.4729397,
            1.5066576, 1.3336214, 1.1102583, 1.0034299, 1.6427517, 2.1536727, 2.8996646, 3.501139,
            2.682458, 3.435608, 2.7730708, 3.1897783, 3.09054, 3.1040206, 2.459223, 2.5486355,
            1.5086552, 1.3901055, 1.8009682, 1.7908425, 2.7410922, 2.1976967, 3.092901, 2.2062728,
            2.7388349, 2.3219318, 3.069992, 2.435648, 2.3418252, 1.8782588, 1.5507131, 1.2329633,
            1.7437569, 2.1968322, 2.4870472, 3.607915, 3.264531, 3.972269, 3.6176317, 3.687326,
            2.914855, 2.9707022, 2.540834, 2.8795414, 1.7404108, 1.6275948, 1.3343302, 1.2676637,
            3.0149438, 2.3706043, 3.6211565, 2.81814, 3.351746, 2.6621015, 2.7361662, 2.2199957,
            2.5988417, 2.0672734, 1.851426, 1.3841468, 1.094336, 1.4105514, 2.3090286, 2.6578522,
            3.2884693, 3.8336573, 2.9649987, 3.8963757, 2.692113, 3.1045375, 2.5394158, 2.7917063,
            1.9324775, 1.6914352, 1.1926081, 1.1354389, 2.2426693, 2.1387243, 3.0506887, 2.260858,
            3.2372785, 2.4451504, 2.876606, 2.1678982, 2.6074667, 2.171711, 1.9404817, 1.4623849,
            1.5290225, 1.7974479, 2.86442, 3.1779191, 2.8252785, 3.2961419, 3.7157261, 4.214899,
            3.0344577, 3.1946769, 2.349008, 2.6964102, 1.7053233, 1.5091734, 1.5981886, 1.6397338,
            2.4753966, 2.073285, 3.117309, 2.55142, 3.5122607, 2.7962475, 3.0378647, 2.1799989,
            2.3829546, 2.001207, 1.7810692, 1.3612256, 1.6084626, 2.3988547, 2.5267196, 3.015731,
            3.1870618, 3.7605357, 3.4861877, 3.6824384, 2.281687, 2.519697, 2.3426661, 2.8531928,
            1.7394836, 1.6573358, 1.5775714, 1.430633, 2.61544, 2.0897985, 3.2887692, 2.7643352,
            3.0971642, 2.2651727, 2.6574535, 2.0512779, 2.2654583, 1.9217476, 1.9698577, 1.4451435,
            1.422786, 1.6073018, 1.9175022, 2.0697389, 1.9499596, 2.4274273, 1.6532844, 1.9472249,
            1.3588724, 1.4709334, 1.5504239, 1.8443284, 1.380367, 1.4561849, 1.22088, 1.2280728,
            1.8193934, 1.4485836, 1.6824847, 1.4298232, 2.1721404, 1.6740687, 1.3406396, 1.1630757,
            1.4087901, 1.2860746, 1.713105, 1.3684366,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.86201537, 0.04691705, 0.12260284, 0.89921826, 0.47400048, 0.7492544, 0.05440097,
            0.28273952, 0.9184355, 0.9064988, 0.7027802, 0.19125043, 0.8670149, 0.08634489,
            0.722654, 0.77540857, 0.00211577, 0.6443405, 0.2344423, 0.9849179, 0.9893316,
            0.87634915, 0.48734385, 0.8760625, 0.53053117, 0.01152504, 0.6788874, 0.76156837,
            0.4680538, 0.07214947, 0.549209, 0.8383253, 0.00365476, 0.9782156, 0.7419056,
            0.40790308, 0.00302504, 0.80174476, 0.7689671, 0.50054824, 0.16478458, 0.89107823,
            0.7763043, 0.73042727, 0.41667554, 0.7348974, 0.71259016, 0.93557405, 0.37013116,
            0.14954911, 0.33766475, 0.39673004, 0.03940821, 0.2414454, 0.9373305, 0.84819096,
            0.9272432, 0.8604789, 0.92845494, 0.8023847, 0.06647868, 0.12827316, 0.02774826,
            0.8982795, 0.1193029, 0.37523487, 0.28379655, 0.0638791, 0.08446726, 0.68760884,
            0.2630593, 0.01052708,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.45302406, 0.10402057, 0.5539082, 0.39986408, 0.53770447, 0.24856173, 0.12796782,
            0.80071914, 0.38390577, 0.6908975, 0.5850918, 0.71101063, 0.17578217, 0.55867785,
            0.71616316, 0.3247584, 0.9196999, 0.46712968, 0.08430128, 0.83232373, 0.49657014,
            0.24024557, 0.60874844, 0.47418702, 0.9770886, 0.99522823, 0.7749884, 0.7253688,
            0.26021662, 0.8869578, 0.5181486, 0.5871326,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(
        kernel26,
        Some(Array::from_shape_vec((1,), vec![0.76900613]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            1.162302, 0.86008656, 2.0053577, 1.495612, 1.625343, 1.8270384, 1.7694634, 1.7854183,
            1.6755733, 1.6714709, 2.2044053, 1.589883, 1.2591434, 1.8102716, 1.2340178, 0.98399687,
            1.3045079, 1.6649501, 1.7108411, 1.4019659, 1.9848739, 1.5755765, 1.5254843, 1.883788,
            1.7753356, 1.6269996, 1.4073291, 1.7914861, 1.8415065, 1.7358747, 2.9725342, 3.2529407,
            3.233694, 3.2451162, 3.901382, 3.6850352, 3.5638466, 3.6430507, 3.728788, 3.9610896,
            2.0827694, 2.803269, 1.3360615, 1.4533038, 2.5990658, 2.4454875, 2.621262, 2.9066567,
            2.767104, 3.5415144, 3.0936613, 3.1861043, 2.6485653, 3.4015684, 2.3613086, 2.132289,
            2.2815971, 1.8422782, 2.912806, 3.0266762, 2.9585934, 2.941002, 3.8402648, 3.9179478,
            3.3351455, 3.800242, 3.2384605, 3.0622826, 1.9832239, 2.042233, 1.63057, 1.792377,
            1.9069334, 2.9754229, 2.2781696, 2.5731678, 2.905209, 3.496992, 2.4694, 3.3385487,
            2.4092293, 2.5908322, 1.6201735, 2.0108485, 2.4317799, 2.1986313, 3.177558, 3.2350097,
            3.4608183, 3.4100661, 3.953392, 4.1187954, 3.202105, 3.1998076, 2.7671087, 2.9181552,
            1.8860222, 2.420426, 1.6092372, 1.8651417, 3.1871867, 2.5295546, 2.7580097, 3.2475972,
            3.290609, 3.6434507, 2.8995667, 2.743825, 2.464095, 2.6079736, 1.9561218, 2.201982,
            2.0763488, 1.9500798, 3.2621336, 3.4688196, 3.6386905, 3.8858433, 4.7931952, 4.400255,
            3.8622165, 4.4335938, 3.5411205, 3.6620555, 1.975019, 2.3150876, 1.3724062, 1.8791974,
            1.9946793, 3.1880536, 2.7874289, 3.2074757, 3.2952614, 3.8493805, 3.124936, 3.8353486,
            2.319538, 3.212953, 2.049821, 1.760324, 1.5474482, 1.3914092, 2.0273614, 1.9029272,
            1.7119815, 1.795125, 3.4424853, 3.1867113, 3.3848524, 3.567707, 2.157251, 2.1745877,
            1.3288512, 1.2643566, 1.3158, 1.3290591, 1.944337, 1.8986012, 1.1603553, 1.9747084,
            2.5565195, 2.6793017, 2.9664898, 3.2679882, 1.7559862, 2.1868985, 1.0737112, 1.3443575,
            1.2571449, 1.4308956, 1.6945363, 2.0081277, 1.3929441, 1.4979894, 1.884003, 2.193049,
            2.4160948, 2.7376823, 1.5738392, 1.7796199, 1.0158253, 1.0666655, 0.93939584,
            1.3275526, 1.4733632, 1.6390045, 1.425105, 1.1557256, 1.1662703, 1.976174, 2.0247178,
            2.138216, 1.5110768, 1.4016204, 1.0665859, 0.9076569,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.5745777, 0.81429285, 0.78002185, 0.7069771, 0.33134556, 0.7407027, 0.58577555,
            0.40479863, 0.7506117, 0.11343616, 0.8795398, 0.83064, 0.8858372, 0.3898591, 0.9350765,
            0.9673369, 0.64465624, 0.0283905, 0.22112074, 0.1391855, 0.34128338, 0.65248054,
            0.291874, 0.70765275, 0.32796225, 0.22921298, 0.59572685, 0.5726663, 0.72872376,
            0.8248998, 0.29288608, 0.92347336, 0.25887516, 0.91578674, 0.800785, 0.7670362,
            0.8990461, 0.8424308, 0.7045559, 0.43518323, 0.48451254, 0.31151697, 0.10086012,
            0.5242353, 0.19001916, 0.01069371, 0.01020448, 0.12606935, 0.04778918, 0.8456499,
            0.57045126, 0.46361542, 0.7532553, 0.62787765, 0.3127784, 0.9686197, 0.96754897,
            0.5766132, 0.6463905, 0.6347338, 0.52757853, 0.55145216, 0.08155768, 0.13378453,
            0.2262157, 0.73179847, 0.5428326, 0.9094368, 0.2528448, 0.24383228, 0.7446406,
            0.5544842,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.01949351, 0.13375893, 0.04438103, 0.8489, 0.6848837, 0.9220802, 0.00185038,
            0.44556108, 0.00844186, 0.8082305, 0.33159012, 0.5138473, 0.65069795, 0.9300001,
            0.58097035, 0.5413155, 0.5714561, 0.21683556, 0.8548128, 0.02262598, 0.62476623,
            0.33444464, 0.98826236, 0.03221937, 0.12669064, 0.50246465, 0.42635268, 0.91064155,
            0.7792924, 0.07601635, 0.6067355, 0.3940292,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(
        kernel27,
        Some(Array::from_shape_vec((1,), vec![0.30074376]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            0.82570964, 0.57254386, 1.5920458, 1.1004324, 1.4748316, 1.2681656, 1.2000949,
            1.1677732, 0.98745704, 1.0601231, 0.9220739, 0.75960916, 0.5999056, 0.93657464,
            1.2559563, 1.1312317, 2.2743187, 1.6183097, 2.1092002, 1.6455812, 1.7545581, 1.4684258,
            1.2617674, 1.0973363, 1.4821029, 1.2511616, 0.60997486, 0.64080894, 0.48855093,
            1.3170967, 1.4078634, 3.163491, 1.6150813, 2.967869, 1.1249485, 2.7922041, 0.82204455,
            1.7879689, 0.79890007, 2.552721, 0.8237999, 1.6730149, 1.8394423, 1.4773076, 3.071923,
            2.6001859, 3.4932005, 2.805382, 2.2541053, 2.1399064, 2.1882365, 2.065205, 2.1713212,
            2.5838497, 1.046205, 1.1986071, 0.36304432, 0.95371515, 1.1788328, 2.2727532,
            1.7732806, 2.287138, 1.445888, 1.9931505, 1.2338898, 2.1659923, 1.6515858, 2.200915,
            1.1679037, 0.8806769, 1.3970587, 1.6859779, 2.2184007, 2.1124268, 3.3237567, 2.6928976,
            2.4519148, 2.3702724, 2.3254888, 2.477402, 2.61399, 2.1106236, 1.4803722, 0.8329366,
            0.49732587, 1.1381152, 1.5586982, 1.9628875, 2.2644572, 2.709064, 2.1053693, 2.839401,
            1.8169668, 2.8656483, 1.8574574, 2.1510615, 1.15184, 1.5021915, 1.2612534, 1.4367034,
            2.7670765, 1.786834, 3.8890665, 2.4894824, 3.9447901, 2.9442766, 3.3253076, 2.4584575,
            3.1606343, 2.0363128, 1.3267865, 0.8992674, 0.65011764, 0.79488605, 1.4164443,
            1.7389641, 1.4251108, 2.3207486, 1.0887575, 2.7874506, 1.1305499, 2.3574853, 1.4194899,
            2.8229802, 1.4681754, 1.9591992, 1.2426016, 1.0090157, 2.4878938, 1.3056657, 2.94974,
            1.845175, 2.5174801, 2.3582156, 2.497013, 2.2087898, 3.0646858, 2.7571528, 1.8217199,
            1.3250322, 0.686266, 0.98778397, 1.7209499, 1.9936776, 1.5951424, 2.33713, 0.9396523,
            1.6120408, 1.2726989, 2.470984, 1.7423882, 2.8350744, 1.3942986, 2.0547051, 1.4650226,
            1.0974653, 3.127932, 2.2449048, 2.45543, 1.966366, 2.203119, 2.247574, 2.6214206,
            2.7616854, 3.5775452, 2.8806381, 1.7733893, 1.3952513, 0.37198806, 0.81021744,
            0.752313, 2.1489077, 1.0289178, 1.9397154, 0.5330075, 1.526701, 0.80946726, 2.0147367,
            0.96047884, 2.2888763, 0.7914912, 1.1998196, 0.91434944, 0.614392, 2.109877, 1.6011419,
            1.7545316, 1.4189532, 1.3904696, 1.4107223, 2.0820923, 1.6938853, 2.1489902, 1.7831249,
            1.0827943, 0.9344353,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.1328066, 0.72018456, 0.34319454, 0.6295161, 0.03357495, 0.03066352, 0.51702976,
            0.9283114, 0.36689135, 0.6327302, 0.37459058, 0.93406814, 0.33968034, 0.59511477,
            0.4350908, 0.7094508, 0.29612544, 0.80898666, 0.7905302, 0.4748418,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.6989706, 0.85952836, 0.70326394, 0.38940284, 0.37933362, 0.22292, 0.3949557,
            0.27719194, 0.8619771, 0.9255003, 0.30563155, 0.5844432, 0.36121982, 0.09087573,
            0.23811613, 0.17829578, 0.9398569, 0.04807154,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(
        kernel28,
        Some(Array::from_shape_vec((2,), vec![0.7588201, 0.05337733]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (2, 9, 11),
        vec![
            0.85164803, 0.8729712, 1.3556061, 1.3778391, 1.5051829, 1.0538056, 1.4401897,
            1.2999071, 1.225004, 0.7876787, 0.7824322, 0.8105354, 0.80919814, 1.0688672, 1.0320103,
            1.0530046, 0.88900536, 1.0804604, 0.99761677, 0.912226, 0.7715562, 0.7663047,
            0.83270574, 0.8219892, 1.5406905, 1.4028512, 2.5276203, 1.6518608, 2.2125711,
            1.2486705, 2.0149903, 1.3119764, 1.2327373, 0.7707606, 0.77045184, 0.96698844,
            0.9549469, 1.2355635, 1.1109598, 1.1086278, 0.89799434, 1.0869944, 0.9988359,
            0.8998683, 1.0327587, 1.0892911, 1.9057775, 1.7049947, 2.4654527, 1.3081055, 2.3587618,
            1.3720374, 2.0476108, 1.3081808, 1.6102028, 0.90468675, 0.9009149, 1.2060527,
            1.1131436, 1.099315, 0.8876723, 1.0662811, 0.98456717, 1.0609087, 0.9238647, 0.8558106,
            1.402652, 1.4724467, 2.1565382, 1.2722645, 2.4718363, 1.5483239, 2.4081492, 1.6032643,
            2.3314888, 1.2875638, 1.4677975, 1.0350822, 1.0279386, 1.032283, 0.87115043, 1.1398541,
            1.065696, 1.2469941, 1.0586948, 1.1199498, 0.93894356, 0.8646718, 1.0390217,
            0.95547414, 1.4873068, 0.8409037, 1.3335874, 0.9830647, 1.7683725, 0.9779487,
            1.6277806, 0.89044243, 1.1681229, 0.17628987, 0.09396721, 0.7975263, 0.27348843,
            0.79191095, 0.1582684, 0.8365724, 0.24577732, 0.4523674, 0.0636389, 0.07299998,
            0.1013497, 0.06544622, 0.34514567, 0.11882463, 0.34883356, 0.08456538, 0.3624912,
            0.11058506, 0.21540321, 0.05642847, 0.06137206, 0.10543528, 0.18756826, 0.68459964,
            0.88826835, 1.3105148, 0.6596523, 1.0642185, 0.75716597, 0.88964456, 0.27831528,
            0.4247862, 0.0644536, 0.0561639, 0.2474402, 0.10036279, 0.51181495, 0.1377383,
            0.40695167, 0.08671884, 0.36929476, 0.11087714, 0.20404059, 0.4055282, 0.19668335,
            1.2304428, 0.82479197, 1.1040297, 1.0296742, 0.9127206, 0.58008856, 0.9343149,
            0.78103065, 0.3380795, 0.18868688, 0.08741852, 0.4799773, 0.13826145, 0.3984933,
            0.08424602, 0.34922796, 0.10745881, 0.35224718, 0.09291652, 0.15697947, 0.7767621,
            0.6222694, 0.92662275, 1.021773, 1.0806289, 0.6198801, 1.3802553, 0.85431105,
            1.0610464, 0.60742706, 0.35181087, 0.30964503, 0.11784919, 0.32927537, 0.08028794,
            0.4161116, 0.12689458, 0.5315653, 0.12521733, 0.4131376, 0.09652892, 0.16644482,
            0.17986941, 0.72015953, 0.14027964, 0.33169287, 0.21185143, 0.813709, 0.23321475,
            0.7963626, 0.17604162, 0.49966067, 0.0762037,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.19222781, 0.98696715, 0.32119673, 0.3872288, 0.74463385, 0.6260977, 0.0084233,
            0.31085488, 0.10247751, 0.60939455, 0.00353958, 0.22236562, 0.31823838, 0.9627444,
            0.866447, 0.8205645, 0.7792785, 0.61566937, 0.59327537, 0.33567885,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.96525836, 0.47292593, 0.2669342, 0.705448, 0.28257245, 0.02662205, 0.05098573,
            0.8293213, 0.9416077, 0.9101412, 0.07020015, 0.8425068, 0.9708137, 0.3117258,
            0.11623824, 0.19467542, 0.09732427, 0.43287596,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(
        kernel29,
        Some(Array::from_shape_vec((2,), vec![0.20617688, 0.8857049]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (2, 9, 11),
        vec![
            0.39172637, 0.2970864, 1.2101673, 0.67293924, 0.77967, 0.35807914, 0.6656911,
            0.3893074, 1.0283055, 0.5583335, 0.4049451, 0.34178358, 0.26049516, 0.9075483,
            0.4850666, 0.45903954, 0.29693824, 0.48789755, 0.31559706, 0.7417861, 0.4165899,
            0.22600055, 0.82032377, 0.66169333, 0.6127589, 1.0286734, 1.454193, 0.6195635,
            0.71025646, 0.57577825, 1.2243382, 1.1119161, 1.069998, 0.64785624, 0.38309485,
            0.22878708, 0.20855707, 0.42569306, 0.29401588, 0.286745, 0.2351342, 0.6388012,
            0.378375, 0.2224002, 0.24151553, 0.72708696, 1.0117298, 0.31832495, 0.5964967,
            0.61447865, 1.518351, 0.74647045, 1.4270755, 1.121326, 1.0112718, 0.20867386,
            0.20717706, 0.3631385, 0.26901126, 0.43659732, 0.2961023, 0.8938151, 0.47822192,
            0.84304035, 0.4510109, 0.22924347, 0.9984141, 0.5971786, 1.1920891, 0.7591305,
            1.2340798, 0.7612648, 1.291926, 1.2851766, 1.6392633, 1.0834911, 1.1116343, 0.78504246,
            0.4380458, 0.7777624, 0.4263795, 0.6612456, 0.38014808, 0.6410922, 0.37382016,
            0.45877504, 0.30103046, 0.21511334, 0.24801396, 0.88668853, 1.0185589, 0.8524492,
            0.9713419, 0.7167646, 0.81614447, 0.69819283, 0.78192437, 0.48456252, 0.5222547,
            1.0606593, 0.8991993, 1.9459376, 0.9549901, 2.0095658, 0.90825295, 1.5087482,
            0.9128884, 1.8896698, 0.93797827, 1.5130639, 1.0723222, 0.9456272, 1.8662103, 1.193368,
            1.3122504, 0.9858302, 1.2989672, 1.006414, 1.6536164, 1.1178265, 0.9722598, 1.4929643,
            0.94836545, 1.6962119, 0.982352, 1.6654868, 0.93878716, 1.4552935, 0.93058556,
            1.8392619, 1.0009553, 1.7214581, 1.4935291, 1.0808756, 0.96665883, 0.88833064,
            1.1884661, 0.98260635, 1.0213246, 0.91764975, 1.4892253, 1.0756688, 0.9565398,
            1.0108123, 0.94688785, 1.3637335, 0.9021348, 1.4268534, 0.938299, 2.1845677, 0.9632632,
            2.648407, 1.0058384, 1.8794847, 0.88914114, 0.8868083, 1.1019919, 0.955022, 1.2205024,
            0.984908, 1.8573418, 1.1858171, 1.8387711, 1.1557987, 0.98641914, 1.6332235, 0.9436531,
            2.331111, 0.9620519, 2.2608085, 0.9598973, 2.2695553, 1.0210513, 2.2764835, 0.9935959,
            1.5435807, 1.6823201, 1.141496, 1.7376201, 1.1286261, 1.573987, 1.0776249, 1.5332291,
            1.0706441, 1.2805479, 0.99034464, 0.9247236, 1.0454487, 0.9655657, 1.3926139,
            0.9615476, 1.3428915, 0.9456245, 1.2677095, 0.94344497, 1.207868, 0.9183746, 1.0310122,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.9601851, 0.09430943, 0.28105715, 0.6942895, 0.07089514, 0.7148581, 0.00085336,
            0.23516753, 0.04615124, 0.59699446, 0.53420085, 0.75324225, 0.38793716, 0.2669936,
            0.29911962, 0.7380972, 0.17850904, 0.65695775, 0.8119258, 0.26960826,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.12972821, 0.6597052, 0.7345929, 0.6485681, 0.22981846, 0.24392553, 0.26706976,
            0.32711208, 0.9581323, 0.31259444, 0.91530424, 0.17250775, 0.715259, 0.5014661,
            0.7273789, 0.23862323, 0.4093651, 0.04974006,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(
        kernel30,
        Some(Array::from_shape_vec((2,), vec![0.8688277, 0.46409306]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (2, 9, 11),
        vec![
            0.9933908, 1.5022669, 1.5864074, 0.9310441, 0.9745678, 1.0542426, 1.1653593, 1.3268541,
            1.388045, 0.9155976, 0.9209068, 1.4915731, 1.089496, 1.1642075, 0.89050174, 1.0741168,
            0.9334198, 1.3876787, 1.0283883, 1.084163, 0.8851207, 0.88612086, 1.2180014, 1.6545115,
            2.3392396, 0.9002404, 1.0653852, 1.1159061, 1.502281, 1.1263844, 1.6643323, 1.2858588,
            1.3753026, 1.3324618, 1.0331153, 1.0437533, 0.8690238, 1.021558, 0.92287356, 0.9561233,
            0.8794341, 1.2672768, 1.006028, 1.0144498, 1.1290456, 1.4550815, 2.0441213, 1.3660247,
            1.5361043, 1.201678, 1.4260874, 1.0600615, 1.3074217, 1.2614425, 1.6605585, 1.2152933,
            0.99159694, 1.4876618, 1.0419366, 1.3041663, 0.95798284, 1.136619, 0.93018776,
            1.1279538, 0.9375709, 0.9417906, 1.1072487, 1.5304978, 2.1471896, 1.2329857, 1.9104971,
            1.4291251, 1.899755, 1.4917963, 1.8359394, 1.1445353, 1.3534762, 1.347534, 1.0384561,
            1.1646438, 0.9098524, 1.3384525, 1.0198088, 1.5556657, 1.0554233, 1.2417364,
            0.93078864, 0.934592, 1.0659511, 1.1102682, 1.6236968, 0.92722017, 1.2153165,
            1.0837265, 1.715121, 1.1344185, 1.7187643, 0.9570198, 1.1271482, 0.7642416, 1.3429545,
            0.65921307, 0.55041486, 0.56821907, 0.7213459, 0.72960865, 1.0995792, 0.6060248,
            0.5289837, 0.476323, 1.1508741, 0.94559336, 1.2299671, 0.51138604, 0.7337204,
            0.6050337, 1.1651249, 0.81225574, 1.0198131, 0.49964458, 0.5156607, 0.91667616,
            1.511472, 0.6579425, 0.50348115, 0.60951006, 0.7943979, 0.6987413, 0.7905534,
            0.7101229, 1.0395466, 0.5706056, 0.97540176, 0.8225702, 0.9846761, 0.464521, 0.6329195,
            0.5820216, 0.66815907, 0.48723635, 0.9246682, 0.7634655, 0.89833426, 0.80166304,
            1.2456874, 0.8274669, 1.1538882, 0.77145904, 0.91544294, 0.63718593, 0.72736615,
            0.74840695, 0.98226726, 0.54538804, 0.846185, 0.7319766, 1.3914227, 0.8418185,
            1.2894611, 0.6586304, 0.93723994, 0.59798133, 0.8722466, 0.6140914, 0.6816664,
            0.8222909, 1.3583597, 0.85353374, 0.93583417, 0.8302857, 1.2242172, 0.91423374,
            1.3165501, 0.7730918, 0.83331573, 0.5254808, 0.9920237, 0.83422375, 1.1286496,
            0.5536093, 1.0638317, 0.7935351, 1.5226876, 0.87124634, 1.2475106, 0.59929246,
            0.6602004, 0.64022017, 0.7662443, 0.54340243, 0.53716844, 0.6297375, 0.73302865,
            0.69051456, 0.7964672, 0.5688131, 0.5744613, 0.4775034,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );

    let test_input31 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.20740515, 0.19872624, 0.27135858, 0.02647329, 0.90772045, 0.97377276, 0.47016057,
            0.06899374, 0.47393376, 0.49847803, 0.02369655, 0.10663922, 0.02373338, 0.21085607,
            0.56809616, 0.70259374, 0.4123619, 0.01858313, 0.25862443, 0.4823392,
        ],
    )
    .unwrap();

    let kernel31: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.47215322, 0.593886, 0.8265343, 0.06712108, 0.3228139, 0.11140465, 0.59627575,
            0.49184018, 0.8395536, 0.13370071, 0.25792846, 0.54400545, 0.8792363, 0.58678144,
            0.03434712, 0.8123595, 0.67917913, 0.02545591, 0.2468276, 0.9191908, 0.02958322,
            0.20474248, 0.76555794, 0.82307637, 0.24628638, 0.17773865, 0.17740512, 0.4937253,
            0.9466453, 0.13741271, 0.728613, 0.5338591, 0.7898385, 0.47936276, 0.23633894,
            0.8572216, 0.06004518, 0.3347224, 0.50485814, 0.09635731, 0.18004768, 0.24514198,
            0.228041, 0.05106571, 0.30884218, 0.38737774, 0.7948706, 0.5052517, 0.23866583,
            0.5068071,
        ],
    )
    .unwrap();
    let conv_layer31 = TransposedConvolutionLayer::new(
        kernel31,
        Some(Array::from_shape_vec((2,), vec![0.15044466, 0.09537497]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output31: Array3<f32> = Array::from_shape_vec(
        (2, 11, 13),
        vec![
            0.24837166, 0.27361968, 0.41570136, 0.28238666, 0.5097748, 0.32493943, 0.45138288,
            0.18438065, 0.6885072, 0.6913041, 0.90925264, 0.21137184, 0.44346943, 0.17355056,
            0.27411532, 0.2745939, 0.44306803, 0.30614704, 0.47909054, 0.31342882, 0.39405012,
            0.30087042, 0.713922, 0.6004375, 0.9125246, 0.27180752, 0.66371024, 0.8415842,
            1.4109043, 0.7248368, 1.1378137, 0.48720616, 0.8352562, 0.610168, 1.0665208, 0.9876336,
            1.5144564, 0.7165365, 0.34253788, 0.427415, 0.87194705, 0.8484801, 1.4344884,
            0.9357133, 0.81966114, 0.51111865, 0.5759227, 1.4358011, 1.468607, 0.5064223,
            0.79299414, 1.0514598, 0.41893247, 0.7367201, 1.3624845, 1.2539264, 0.93331015,
            0.70423734, 0.760561, 0.804338, 1.2622076, 1.2588906, 1.8440536, 1.2281967, 0.5745145,
            0.94413817, 0.8259405, 0.5807073, 0.7936028, 1.1718054, 0.41703334, 1.018794,
            0.63501394, 0.80104005, 1.1217474, 0.9063735, 0.75043, 0.68459594, 0.5170959, 0.779969,
            1.7335888, 1.4121677, 1.4293566, 0.6657481, 0.6825799, 0.58774006, 1.3252417,
            1.3791753, 1.6376724, 0.9264535, 0.44843125, 0.24796697, 0.5854785, 0.62918013,
            1.0644672, 0.49304464, 0.55016595, 0.51344657, 0.46932477, 0.8225473, 1.093065,
            0.6305351, 0.6956161, 0.73712254, 0.33236462, 0.53751117, 0.89584637, 0.82837844,
            0.63011014, 0.49515176, 0.29832453, 0.36474758, 0.6869577, 0.8544599, 1.0702593,
            0.9010588, 0.30692595, 0.7212033, 0.62763166, 0.5033159, 0.6039318, 0.82185555,
            0.26484823, 0.74005294, 0.33068383, 0.5659424, 0.541875, 0.40044826, 0.2694993,
            0.5938064, 0.17122965, 0.29429543, 0.7005199, 0.813161, 0.63972056, 0.49365473,
            0.2738812, 0.21869141, 0.36728257, 0.46206763, 0.58339894, 0.54744667, 0.26923823,
            0.13223888, 0.13216971, 0.23309746, 0.32696915, 0.27022216, 0.33163863, 0.2613644,
            0.3569518, 0.3070706, 0.28147006, 0.5471773, 0.95466423, 0.2201073, 0.24649307,
            0.20610009, 0.40398607, 0.30088907, 0.4990699, 0.33550417, 0.37595996, 0.23958717,
            0.84179413, 0.59266007, 0.8185842, 0.5305023, 0.30990466, 0.4462442, 0.28058094,
            0.8994925, 1.2172441, 0.79269433, 0.6693125, 0.4109533, 0.38335302, 1.2405736,
            0.7003242, 0.712996, 1.0255269, 0.2513377, 0.84222126, 0.66607606, 1.2901404,
            0.8724723, 0.9053668, 0.43425485, 0.7343228, 0.4018087, 1.1024865, 0.8125504,
            0.81627464, 0.38068017, 0.4935271, 1.0146699, 0.32290947, 1.0367779, 0.8640357,
            0.7764858, 0.7051662, 0.8819624, 0.30434537, 1.398837, 1.3928031, 1.0893956, 1.1014631,
            0.68150973, 0.28796613, 0.34673816, 0.49850157, 0.32864702, 0.6228757, 0.20008647,
            0.53922546, 0.3390236, 0.9005829, 0.6461345, 0.8539568, 0.39315426, 0.38358924,
            0.61778414, 0.9954649, 1.2890311, 1.4581268, 1.2149303, 0.71134734, 0.8628825,
            0.57667327, 1.3387192, 1.0756712, 1.0715781, 0.95775676, 0.46902692, 0.61156046,
            0.47627002, 0.9753667, 0.67966723, 0.63657415, 0.31423035, 0.47225797, 0.29525366,
            0.8131751, 0.6268828, 0.7321385, 0.35560066, 0.38482258, 0.706833, 0.15639803,
            0.7373167, 0.5652654, 0.39211464, 0.3489912, 0.5107455, 0.2935536, 0.93583596,
            0.7567929, 0.67564, 0.47447297, 0.42976704, 0.22187534, 0.2676102, 0.32983994,
            0.23234063, 0.40974683, 0.12098803, 0.27353215, 0.15972364, 0.24693525, 0.2268234,
            0.2852422, 0.12000597, 0.24434166, 0.36754414, 0.65384614, 0.61010146, 0.59083444,
            0.6669997, 0.20856285, 0.41393742, 0.3053831, 0.42231095, 0.54049706, 0.47015038,
            0.21049285, 0.3398279,
        ],
    )
    .unwrap();
    let current_output31: Array3<f32> = conv_layer31.transposed_convolve(&test_input31);

    assert!(
        arr_allclose(&current_output31, &target_output31),
        "{:?} was not equal to {:?}",
        current_output31,
        target_output31
    );

    let test_input32 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.13518302, 0.7257979, 0.86458087, 0.7176047, 0.09527912, 0.72005635, 0.7382226,
            0.41232714, 0.5491061, 0.7183669, 0.07962471, 0.04476061, 0.19437055, 0.79608136,
            0.6295519, 0.98047, 0.56819236, 0.10505454, 0.9480506, 0.10080674,
        ],
    )
    .unwrap();

    let kernel32: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.9538371, 0.2355401, 0.94827145, 0.46488547, 0.60260093, 0.76637876, 0.3219317,
            0.4168223, 0.25562465, 0.8997145, 0.59076214, 0.22263806, 0.6840723, 0.24348243,
            0.94946456, 0.34627816, 0.9748906, 0.7407666, 0.9677088, 0.13005458, 0.69001645,
            0.14445187, 0.9216249, 0.03732051, 0.44508553, 0.666532, 0.9382296, 0.80578685,
            0.976145, 0.6098745, 0.04455515, 0.5690737, 0.6428197, 0.21377262, 0.6692434,
            0.86947584, 0.12576632, 0.8154824, 0.3646563, 0.32867205, 0.00950876, 0.02384425,
            0.68798536, 0.6243543, 0.061506, 0.4878141, 0.24558064, 0.15653013, 0.40195072,
            0.52372193,
        ],
    )
    .unwrap();
    let conv_layer32 = TransposedConvolutionLayer::new(
        kernel32,
        Some(Array::from_shape_vec((2,), vec![0.62839466, 0.67610437]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output32: Array3<f32> = Array::from_shape_vec(
        (2, 11, 13),
        vec![
            0.7573372, 0.6602357, 1.4488778, 0.8621938, 2.2227788, 1.169451, 2.5700965, 1.1993504,
            1.9207566, 0.9844407, 1.1511743, 0.67268854, 0.68580997, 0.73199606, 0.67191434,
            1.240978, 0.8966081, 1.7151461, 1.0922625, 2.191739, 1.0804225, 1.7784042, 0.84250546,
            1.3137485, 0.6527504, 0.71411866, 1.3950721, 0.8280937, 2.5365965, 1.3315244,
            3.2912412, 1.4379108, 3.692493, 1.3196924, 3.4508395, 1.2488072, 2.3870113, 0.98555183,
            1.1517475, 1.2270415, 0.9919923, 1.8457553, 1.8885074, 2.7545598, 2.4950764, 2.8686113,
            2.4468188, 2.4558055, 1.787344, 1.5857722, 0.9042294, 1.2871113, 1.2230042, 0.8269889,
            2.30068, 1.1255194, 3.662129, 1.1185067, 4.5214047, 1.2648361, 4.404335, 1.4809442,
            3.125079, 1.0995297, 1.7322345, 0.9387571, 1.3560045, 1.4849117, 2.0796497, 1.6509299,
            1.818769, 1.951375, 1.8686953, 2.3267117, 2.2662694, 2.2106078, 1.4844936, 1.2882385,
            2.1074934, 0.98107564, 3.354029, 1.3808962, 3.364643, 1.0585686, 3.7079263, 1.2198083,
            3.9731796, 1.55113, 3.388257, 0.8553529, 1.6066129, 1.4073783, 1.0216644, 1.54701,
            1.1826363, 1.9387035, 1.0402642, 2.3354306, 1.924643, 2.028328, 2.2873118, 2.093273,
            1.2633862, 0.80096805, 1.2625616, 0.85818654, 1.7390432, 1.0030606, 2.2208743,
            0.8198763, 2.5481787, 0.98729515, 2.6908293, 1.0023218, 2.5320292, 0.6764345,
            1.0043116, 0.96791005, 1.5842457, 1.5514467, 2.1311295, 1.2131853, 1.2806561,
            1.1084008, 1.6543026, 1.3792489, 1.6441071, 0.82636726, 0.72594625, 0.64150506,
            1.3049351, 0.7700254, 1.9240823, 0.74706274, 1.6609373, 0.6647752, 1.6322803, 0.769263,
            1.6184583, 0.6783381, 1.1432643, 0.63215685, 0.6732623, 0.7662082, 0.8029371,
            1.2688005, 1.4890277, 1.9196582, 2.1957638, 2.2937243, 2.1933386, 1.8451331, 1.4659843,
            1.1905279, 0.7691106, 0.7342127, 0.6821275, 0.75303346, 0.7953407, 1.1180353,
            1.2716534, 1.3232703, 1.7495825, 1.2692981, 1.7202549, 0.88372946, 1.2176039,
            0.6964724, 0.7398693, 1.2735834, 1.368684, 2.4896684, 2.2121823, 3.372966, 2.1569762,
            3.3921118, 1.9993083, 2.8010497, 2.1597667, 1.9033959, 1.4120789, 1.1455336, 0.709472,
            1.0890929, 1.2717679, 1.3518438, 2.1667867, 1.542331, 2.105956, 1.633646, 1.884819,
            1.6526034, 1.6150581, 0.88915944, 1.1627269, 1.4211926, 0.8745678, 2.374374, 1.3838208,
            2.6936278, 1.7272751, 3.3124576, 2.3559108, 3.675249, 2.6462812, 2.8259294, 1.5908928,
            1.3460588, 0.6864989, 0.7385859, 1.2316909, 1.1857708, 1.3229208, 1.2670282, 1.2007763,
            1.4412158, 1.7559404, 1.5645118, 2.1415641, 1.2592008, 1.1416117, 1.7501044, 1.7828565,
            2.4215493, 2.6716654, 2.727407, 1.768064, 3.3236055, 2.1397257, 3.4840727, 2.4627223,
            2.5105882, 1.2928245, 1.3207245, 0.7205465, 1.2359626, 1.3868918, 1.2598267, 1.7397435,
            0.8899332, 1.3101819, 1.3784108, 1.925962, 1.4481862, 1.8574679, 1.0907176, 0.7822898,
            1.5674415, 0.8189688, 2.0039885, 1.148096, 1.6965749, 0.9622368, 2.2150373, 1.1072755,
            2.1049116, 1.5090864, 1.5853772, 0.96591306, 1.0389469, 0.6854274, 0.6994829,
            1.3560562, 1.3018131, 1.1283162, 1.0333626, 0.79234236, 0.7643012, 1.3357694,
            1.2704275, 0.80376875, 0.7390435, 0.68230456, 1.1543915, 0.91688883, 1.1067498,
            1.2097421, 1.3297844, 0.93028903, 1.4525958, 0.951154, 0.92869717, 1.0819302,
            1.1883986, 0.7166237, 0.72889906,
        ],
    )
    .unwrap();
    let current_output32: Array3<f32> = conv_layer32.transposed_convolve(&test_input32);

    assert!(
        arr_allclose(&current_output32, &target_output32),
        "{:?} was not equal to {:?}",
        current_output32,
        target_output32
    );

    let test_input33 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.6370576, 0.74306166, 0.8282889, 0.39436254, 0.45260343, 0.6606655, 0.7309763,
            0.40489906, 0.9551375, 0.4431474, 0.6631732, 0.18731794, 0.43634078, 0.4686375,
            0.7620647, 0.57885796, 0.26523942, 0.13030814, 0.7995473, 0.951001,
        ],
    )
    .unwrap();

    let kernel33: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.58605653, 0.82163817, 0.21192186, 0.12197074, 0.06249312, 0.3968833, 0.23130116,
            0.670139, 0.89535373, 0.9697048, 0.7154457, 0.8203782, 0.21395262, 0.7457981,
            0.7147152, 0.05275504, 0.93545914, 0.8986874, 0.8690856, 0.63580817, 0.15263815,
            0.7466949, 0.6235891, 0.62486136, 0.7352324, 0.23342584, 0.9827126, 0.93357897,
            0.96423954, 0.02081718, 0.47192466, 0.50718915, 0.9034243, 0.678573, 0.48106775,
            0.27722874, 0.0061415, 0.2891619, 0.9937529, 0.02278532, 0.7661429, 0.23943478,
            0.7568481, 0.1846646, 0.05945846, 0.7522374, 0.723256, 0.5690188, 0.80126184,
            0.13196982,
        ],
    )
    .unwrap();
    let conv_layer33 = TransposedConvolutionLayer::new(
        kernel33,
        Some(Array::from_shape_vec((2,), vec![0.2549996, 0.9684265]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output33: Array3<f32> = Array::from_shape_vec(
        (2, 11, 13),
        vec![
            0.6283514, 0.77843046, 0.82548225, 0.9432298, 0.9377065, 1.0261852, 0.7080871,
            0.6800499, 0.6555872, 0.6749765, 0.37556112, 0.31020397, 0.28328422, 0.5078372,
            0.40235177, 0.9768256, 0.9972625, 1.6994461, 1.1118869, 1.6871347, 1.0878277,
            1.5021038, 0.7127813, 0.9407221, 0.6602398, 0.6938913, 1.097967, 1.3204558, 1.491323,
            2.0208874, 1.8953807, 1.910522, 1.9366891, 2.0304255, 1.7426057, 1.401026, 0.7872944,
            0.64660144, 0.6061758, 0.55081475, 1.0037537, 1.5995655, 2.264366, 2.6627266,
            2.4237502, 2.8518698, 1.9272159, 2.3685036, 1.9788129, 2.1356592, 1.0451244, 0.9724908,
            1.2135662, 1.8175714, 1.6803261, 2.535108, 2.5683048, 2.5964818, 3.0492718, 2.5908523,
            2.5629745, 2.598568, 1.795435, 0.9612621, 0.9521164, 0.5530554, 1.026418, 1.4060557,
            2.1500745, 2.2951236, 1.5376891, 1.7940727, 1.9994595, 2.4338107, 2.095505, 2.2256641,
            1.3224502, 1.2757342, 1.1695503, 1.7679799, 1.3325797, 2.1504397, 2.253362, 1.651178,
            2.2660089, 2.6039162, 2.9082158, 3.0363142, 1.9830818, 1.216246, 1.1849061, 0.51972437,
            1.0092615, 1.3540514, 1.586215, 1.6587958, 1.0935974, 1.4528104, 1.3742164, 2.0333948,
            2.3110113, 2.6504488, 1.7687814, 1.6617168, 0.77036655, 1.2250701, 1.0107516,
            1.4585681, 1.4896934, 1.0025778, 1.5258343, 1.6306962, 1.9289569, 2.4933443, 1.8496902,
            1.4404392, 1.4949892, 0.28553727, 0.7964976, 0.7892047, 1.0061975, 0.868284, 0.6074133,
            0.58292747, 1.1161923, 1.1065638, 1.8394973, 1.618011, 1.0815009, 0.85965383,
            0.34335542, 0.6872299, 0.6564548, 0.81475854, 0.86588514, 0.5180379, 0.6533124,
            0.9334421, 0.9945544, 1.4647135, 1.4358866, 0.8492434, 0.95420635, 1.1171322,
            1.5944711, 1.73662, 2.3129187, 1.8687391, 2.4988859, 1.8492224, 2.1546404, 1.4594871,
            1.7934656, 1.3991771, 1.4048446, 0.9778485, 1.2690697, 1.2915353, 1.894629, 1.7775894,
            2.3370843, 1.8927473, 2.2602952, 1.7304974, 1.936761, 1.4655858, 1.5670346, 1.275551,
            1.1861594, 1.2992536, 1.6215835, 2.1460495, 2.9614472, 2.2181237, 2.8146687, 1.9503715,
            3.1230085, 2.230376, 2.719573, 1.5418842, 1.8455027, 0.98796433, 1.7682881, 1.4560426,
            2.9617007, 2.0830364, 3.3725657, 2.005346, 3.1098325, 1.9749951, 2.9297173, 2.0225105,
            2.1942627, 1.3527142, 1.2085216, 1.7856023, 2.0849483, 2.9464192, 3.5008652, 2.727593,
            3.5011919, 2.753633, 3.2068365, 2.675348, 3.7644238, 2.149118, 2.5062723, 1.0541178,
            1.7875586, 1.4629672, 2.716009, 1.8104663, 2.5653362, 1.5487752, 2.7555833, 1.8056672,
            3.0478346, 1.9554272, 2.2745268, 1.5673767, 1.3613801, 1.784375, 2.0191808, 2.740243,
            3.5054681, 2.2564652, 2.419613, 2.5879493, 3.331532, 3.2265658, 4.230157, 2.482152,
            2.9978004, 1.0640696, 1.7496893, 1.4208038, 2.2619874, 1.6630654, 2.0635176, 1.3535678,
            2.291499, 1.6551566, 3.166727, 2.2623208, 2.816852, 1.7544765, 1.4712336, 1.6277663,
            1.4516256, 1.7276077, 2.2121515, 1.6167765, 1.6984861, 1.8593407, 1.7913991, 2.36374,
            2.6954887, 1.7571129, 2.5240998, 1.090665, 1.4119145, 1.1070253, 1.6097454, 1.1388286,
            1.3034251, 1.0486071, 1.6953882, 1.1839292, 2.309913, 1.3437773, 1.7357297, 1.1440427,
            1.0249716, 1.4038651, 1.387089, 1.4973307, 1.6240792, 1.2937672, 1.2751989, 1.6790273,
            1.651115, 2.1559591, 2.2968905, 1.6150801, 1.7304273, 1.09393,
        ],
    )
    .unwrap();
    let current_output33: Array3<f32> = conv_layer33.transposed_convolve(&test_input33);

    assert!(
        arr_allclose(&current_output33, &target_output33),
        "{:?} was not equal to {:?}",
        current_output33,
        target_output33
    );

    let test_input34 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.09975351, 0.6575368, 0.01221572, 0.5690517, 0.8633032, 0.5916843, 0.7327984,
            0.38392547, 0.45234743, 0.88714564, 0.48625886, 0.4974664, 0.280569, 0.3272779,
            0.7308698, 0.16297498, 0.8690239, 0.5834708, 0.33016786, 0.2406453,
        ],
    )
    .unwrap();

    let kernel34: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.599151, 0.8538999, 0.30761606, 0.3641591, 0.11430372, 0.45364544, 0.6984523,
            0.7053654, 0.4003387, 0.38632825, 0.91106904, 0.5180514, 0.1837249, 0.38816592,
            0.16589011, 0.91154295,
        ],
    )
    .unwrap();
    let conv_layer34 = TransposedConvolutionLayer::new(
        kernel34,
        Some(Array::from_shape_vec((1,), vec![0.93466866]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output34: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.9944361, 1.0198482, 1.3593183, 1.5324655, 1.1442566, 1.1845477, 1.2793744, 1.4250304,
            1.6269671, 1.8790685, 1.2002347, 1.2490484, 0.94607085, 0.9799214, 1.0795007,
            1.3033199, 1.395323, 1.404014, 1.0082455, 1.201433, 1.4308028, 1.7276917, 1.5376447,
            1.543613, 1.329112, 1.4784454, 1.909857, 2.081575, 1.9940704, 1.8747149, 1.5627375,
            1.686907, 2.4694114, 2.4852452, 1.9940977, 1.7049662, 1.0206276, 1.2418045, 1.5690475,
            2.0306158, 1.6017007, 2.2298403, 1.3611027, 1.6427033, 1.6050261, 2.5100083, 1.697511,
            2.3473685, 1.4628853, 1.5784694, 2.2147398, 2.1261544, 2.0771308, 1.8833519, 1.7479398,
            1.6899507, 2.2405243, 2.2550082, 1.9677469, 1.6604086, 1.098957, 1.3849294, 1.5639474,
            2.327125, 1.5062959, 2.229847, 1.3148388, 1.8065908, 1.4848285, 2.253769, 1.5923151,
            2.2588701, 1.2269835, 1.2616885, 2.1476493, 2.1801693, 2.1171303, 2.1154623, 1.6986138,
            1.700861, 1.7711847, 1.7122917, 1.6745679, 1.4009299, 1.0426352, 1.1973506, 1.3198941,
            2.0801997, 1.7424057, 2.3747063, 1.4866073, 1.8787967, 1.3813529, 1.858752, 1.223992,
            1.7706308, 0.9999139, 0.9976305, 1.431054, 1.3548266, 1.9599954, 1.610279, 1.5984298,
            1.3644897, 1.331814, 1.1986806, 1.1539131, 1.0593352, 0.96461123, 0.99793, 1.1213659,
            1.4205528, 1.1860292, 1.9533048, 1.0921208, 1.5946873, 1.0336528, 1.3290411,
            0.97458935, 1.1540272,
        ],
    )
    .unwrap();
    let current_output34: Array3<f32> = conv_layer34.transposed_convolve(&test_input34);

    assert!(
        arr_allclose(&current_output34, &target_output34),
        "{:?} was not equal to {:?}",
        current_output34,
        target_output34
    );

    let test_input35 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.9079338, 0.6218017, 0.7199313, 0.5790186, 0.5812801, 0.5897581, 0.00632351,
            0.51240736, 0.3697457, 0.13892107, 0.9900367, 0.47229373, 0.56468743, 0.59834725,
            0.6383385, 0.03793695, 0.9450343, 0.96132326, 0.6061949, 0.63035446,
        ],
    )
    .unwrap();

    let kernel35: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.5111371, 0.03746503, 0.558335, 0.30164844, 0.68653256, 0.99669343, 0.5127781,
            0.25915265, 0.34361982, 0.6647127, 0.42920145, 0.22015804, 0.22396304, 0.553291,
            0.21043801, 0.03016802,
        ],
    )
    .unwrap();
    let conv_layer35 = TransposedConvolutionLayer::new(
        kernel35,
        Some(Array::from_shape_vec((1,), vec![0.13123624]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output35: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.5953149, 0.165252, 0.95599335, 0.42840886, 0.8463935, 0.345774, 0.829157, 0.37009534,
            0.75163645, 0.32767397, 0.45578527, 0.30657846, 0.7545624, 1.0361679, 1.0236919,
            0.9862754, 0.94433886, 1.0099286, 0.8979164, 0.8949124, 0.82721204, 0.8606485,
            0.42930394, 0.2818765, 0.7446676, 0.7568467, 1.0671009, 0.92258126, 0.9109382,
            0.7677832, 1.1142797, 0.84303534, 0.8569409, 0.761834, 0.458287, 0.30111504, 0.739468,
            1.2213959, 0.768317, 0.6618041, 0.77835184, 1.0606781, 0.92900974, 0.97463584,
            0.66824037, 0.7046035, 0.32479537, 0.18477407, 0.83993334, 0.56034774, 1.1807132,
            0.58161706, 0.86235446, 0.6368548, 1.0993364, 0.6825757, 0.99802446, 0.5093872,
            0.5472681, 0.35437465, 0.9430127, 1.4443072, 1.0886742, 0.87982947, 0.8771855,
            1.1001538, 1.0222198, 1.0939806, 0.9852176, 1.0105455, 0.4877965, 0.30085433,
            0.49082345, 0.7907476, 1.2226745, 0.70998985, 1.546997, 0.9316545, 1.425794,
            0.96597856, 1.2680508, 0.89375293, 0.7571611, 0.46191704, 0.37901282, 0.7168262,
            1.113604, 1.3741604, 1.5016665, 1.6609735, 1.2931937, 1.3326517, 1.1437178, 1.2878412,
            0.5887989, 0.31385168, 0.14427213, 0.15645342, 0.47225136, 0.7677647, 0.8671761,
            0.978297, 0.7521382, 0.74582475, 0.6080183, 0.6836996, 0.4017853, 0.27001384,
            0.13973272, 0.15222642, 0.35087237, 0.6552597, 0.54540825, 0.6916376, 0.46930045,
            0.49563968, 0.39997882, 0.4982934, 0.26388678, 0.15025279,
        ],
    )
    .unwrap();
    let current_output35: Array3<f32> = conv_layer35.transposed_convolve(&test_input35);

    assert!(
        arr_allclose(&current_output35, &target_output35),
        "{:?} was not equal to {:?}",
        current_output35,
        target_output35
    );

    let test_input36 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.4177692, 0.15363416, 0.26550946, 0.9799374, 0.6468661, 0.22700246, 0.28266105,
            0.7568015, 0.49555436, 0.7577122, 0.20788053, 0.91674453, 0.56273526, 0.45675126,
            0.48490578, 0.82385767, 0.42006218, 0.8251126, 0.35886785, 0.09741933,
        ],
    )
    .unwrap();

    let kernel36: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.50827706, 0.09494945, 0.9338919, 0.41674572, 0.12654002, 0.47637334, 0.72644436,
            0.22123201, 0.29542014, 0.46568522, 0.6850643, 0.6808416, 0.3779981, 0.805789,
            0.2891591, 0.6993045,
        ],
    )
    .unwrap();
    let conv_layer36 = TransposedConvolutionLayer::new(
        kernel36,
        Some(Array::from_shape_vec((1,), vec![0.33186397]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output36: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.5442065, 0.37153092, 0.8001039, 0.52055496, 0.610294, 0.42110032, 1.0779008,
            0.5355584, 1.5758067, 0.8016683, 0.93596697, 0.60144264, 0.3847285, 0.53087807,
            0.6547909, 0.4974751, 0.47706822, 0.4923344, 0.64874315, 0.85741925, 1.1255884,
            0.85680723, 0.8017762, 0.47497147, 0.57066154, 0.54796666, 1.0191152, 0.80928457,
            1.1641898, 0.74976397, 1.761898, 1.3314227, 2.0422032, 1.5787467, 1.4826301, 1.0880506,
            0.51850486, 0.77663577, 0.7114117, 0.93268096, 0.77775395, 1.0762994, 1.3915346,
            1.7106563, 1.3156096, 2.0089624, 1.0693469, 0.95185053, 0.504586, 0.4573138, 1.2309772,
            0.7917255, 1.891245, 1.3122234, 1.7544085, 1.355784, 1.5682168, 1.258504, 1.3037951,
            1.0498284, 0.4439757, 0.61380875, 0.77136767, 1.2010754, 1.43684, 1.6102378, 1.2046118,
            1.6024901, 1.1547362, 1.6210077, 0.9032204, 0.96901226, 0.812024, 0.50689566,
            1.7280022, 1.283536, 1.9378148, 1.4714824, 1.8052776, 1.3056363, 1.1726787, 1.0274593,
            0.75503474, 0.7026071, 0.5146934, 0.8918357, 1.3901438, 1.5983086, 1.2192235,
            1.9123863, 1.3120446, 1.4469289, 0.92025614, 1.167805, 0.5428486, 0.69251305,
            0.5752481, 0.7155223, 1.0203543, 1.0883974, 0.8633884, 1.0021025, 1.0031359, 1.0607544,
            0.6064912, 0.6215629, 0.3986025, 0.3981911, 0.6432806, 0.99571943, 0.72887266,
            1.2464728, 0.76521975, 1.290482, 0.70610416, 1.1980407, 0.47245818, 0.6613213,
            0.36003366, 0.39998975,
        ],
    )
    .unwrap();
    let current_output36: Array3<f32> = conv_layer36.transposed_convolve(&test_input36);

    assert!(
        arr_allclose(&current_output36, &target_output36),
        "{:?} was not equal to {:?}",
        current_output36,
        target_output36
    );

    let test_input37 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9734199, 0.9644196, 0.09362596, 0.0414281, 0.27610767, 0.43870836, 0.34610718,
            0.3848816, 0.24301769,
        ],
    )
    .unwrap();

    let kernel37: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.23232727, 0.32100558, 0.22719596, 0.85453415, 0.76819396, 0.8545096, 0.653471,
            0.6439924, 0.61992764, 0.5419032, 0.42076096, 0.7094996, 0.8802664, 0.30416232,
            0.00992903, 0.07512625, 0.21167818, 0.9575676,
        ],
    )
    .unwrap();
    let conv_layer37 = TransposedConvolutionLayer::new(
        kernel37,
        Some(Array::from_shape_vec((2,), vec![0.33277866, 0.5804159]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output37: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.55893064, 0.64525187, 0.77799666, 0.6423627, 0.5736428, 0.3628331, 0.3540501,
            1.1645992, 1.080554, 1.9887048, 1.07364, 1.236891, 0.40470156, 0.41278294, 0.97850525,
            0.97295237, 1.6400084, 1.0424896, 1.1564853, 0.5339009, 0.49049276, 0.3681804,
            0.36460346, 0.6041228, 0.5448829, 0.9436066, 0.6697918, 0.7076591, 0.44026086,
            0.47056037, 0.7069421, 0.63413906, 0.9345318, 0.6933136, 0.6599587, 0.6285391,
            0.5986561, 0.957425, 0.6284424, 0.86933064, 0.5194634, 0.5404396, 0.55894965,
            0.55566907, 0.798849, 0.5806395, 0.7301824, 0.48928022, 0.48343205, 1.1079153,
            0.989993, 1.793679, 0.98620605, 1.3154074, 0.61981004, 0.6468435, 1.4372847, 0.8764936,
            1.4390273, 0.87375605, 0.67240745, 0.6088934, 0.5813455, 0.67599535, 0.803899,
            1.7640014, 0.9007378, 1.9445825, 0.7848258, 0.98133254, 0.61688364, 0.59301674,
            0.82387555, 0.6643975, 0.96933764, 0.71385443, 0.5847719, 0.77108485, 0.7348137,
            1.0949605, 0.80080503, 1.2825315, 0.77553326, 1.1729298, 0.8850825, 0.6856887,
            0.92265075, 0.6974824, 0.7981577, 0.65433276, 0.5828288, 0.60641766, 0.65367925,
            0.9407517, 0.66188693, 0.96722305, 0.63185745, 0.8131218,
        ],
    )
    .unwrap();
    let current_output37: Array3<f32> = conv_layer37.transposed_convolve(&test_input37);

    assert!(
        arr_allclose(&current_output37, &target_output37),
        "{:?} was not equal to {:?}",
        current_output37,
        target_output37
    );

    let test_input38 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.14874539, 0.84465176, 0.33960778, 0.03217437, 0.23459853, 0.86872333, 0.05481404,
            0.4075119, 0.13763186,
        ],
    )
    .unwrap();

    let kernel38: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.38947833, 0.19455469, 0.2231027, 0.710135, 0.38075933, 0.36192992, 0.5788371,
            0.45671245, 0.02821646, 0.65663046, 0.6821529, 0.13092387, 0.04243296, 0.40237483,
            0.96532, 0.08922233, 0.65666056, 0.07955468,
        ],
    )
    .unwrap();
    let conv_layer38 = TransposedConvolutionLayer::new(
        kernel38,
        Some(Array::from_shape_vec((2,), vec![0.30693734, 0.61528814]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output38: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.36487043, 0.33587646, 0.6690964, 0.4712683, 0.62765133, 0.37300962, 0.38270473,
            0.41256663, 0.36357352, 0.96058947, 0.62854636, 0.8538095, 0.43624616, 0.42985156,
            0.4055679, 0.38113087, 0.8985994, 0.7383426, 0.91803646, 0.63105464, 0.5103344,
            0.32978547, 0.31918803, 0.48517883, 0.3962629, 1.0087564, 0.6377119, 0.62135434,
            0.34690994, 0.3322961, 0.6145857, 0.49336475, 0.9609278, 0.730471, 0.36215568,
            0.34586272, 0.3278083, 0.6161646, 0.46210128, 0.55216527, 0.35934195, 0.35675043,
            0.33866572, 0.3319716, 0.54436696, 0.49305308, 0.3981023, 0.36979553, 0.31082082,
            0.7129589, 0.7167553, 1.1893866, 1.1914698, 0.94887, 0.84695256, 0.6597509, 0.62159985,
            0.67513955, 0.7947161, 0.9551548, 1.4450579, 0.75193775, 0.94311833, 0.6496862,
            0.7349112, 0.8607403, 1.3299696, 1.3139296, 1.4308974, 0.7560421, 0.6166534,
            0.62823427, 0.6563014, 0.70968467, 0.8786133, 0.96484053, 1.4538841, 0.6541514,
            0.6738073, 0.91354036, 1.0473251, 0.85518736, 1.2796304, 0.70241845, 0.61761403,
            0.63734394, 0.6854932, 0.77926064, 1.0145077, 0.67066777, 0.7481469, 0.62017876,
            0.65128237, 0.656008, 0.8828851, 0.65998745, 0.7056655, 0.6262374,
        ],
    )
    .unwrap();
    let current_output38: Array3<f32> = conv_layer38.transposed_convolve(&test_input38);

    assert!(
        arr_allclose(&current_output38, &target_output38),
        "{:?} was not equal to {:?}",
        current_output38,
        target_output38
    );

    let test_input39 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.8301079, 0.9080613, 0.10633651, 0.95870477, 0.24841434, 0.49642795, 0.02807361,
            0.67816275, 0.14359485,
        ],
    )
    .unwrap();

    let kernel39: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.96717685, 0.970054, 0.53526694, 0.789418, 0.44380167, 0.1696324, 0.22258878,
            0.54548246, 0.33204898, 0.6242531, 0.39491078, 0.95525235, 0.17685722, 0.4390062,
            0.25685027, 0.9619644, 0.7054154, 0.25693816,
        ],
    )
    .unwrap();
    let conv_layer39 = TransposedConvolutionLayer::new(
        kernel39,
        Some(Array::from_shape_vec((2,), vec![0.06693318, 0.71142703]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output39: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.86979437, 0.8721827, 1.3895184, 0.9478017, 0.65583456, 0.17008534, 0.1238516,
            0.7222353, 0.43533647, 0.9245863, 0.46993232, 0.30491376, 0.11412551, 0.0849713,
            1.1789429, 1.4497378, 1.2981174, 0.80324006, 1.005225, 0.6064998, 0.36796358,
            0.8237519, 0.49240798, 0.42566332, 0.17717987, 0.5009614, 0.28724873, 0.15114346,
            0.30748224, 0.61712277, 1.1114945, 0.8602934, 0.7617979, 0.47702068, 0.30863315,
            0.089095, 0.0793923, 0.6070492, 0.36790293, 0.2953279, 0.13066082, 0.09129152,
            0.07318205, 0.08224685, 0.22720641, 0.43685907, 0.32407904, 0.14526165, 0.11461371,
            1.2296245, 1.0392456, 2.0712497, 1.0700302, 1.6452357, 0.7534205, 0.8130052, 0.8582376,
            1.0758495, 1.0852377, 1.1100717, 0.9634692, 0.75810945, 0.7387396, 2.1084356,
            1.6756008, 2.8691144, 1.450089, 1.5942297, 0.9824832, 1.2129629, 0.8809809, 1.1323044,
            1.0016046, 0.8204825, 0.8630292, 0.929362, 0.83893466, 1.651192, 1.3987987, 1.6468832,
            1.1544762, 1.9902563, 1.1183221, 0.97614765, 0.71639204, 0.72375154, 0.8385757,
            1.0091447, 0.9110091, 0.77446604, 0.74830943, 0.7384328, 0.7312306, 1.3710086,
            1.1898135, 1.0238061, 0.8127211, 0.748322,
        ],
    )
    .unwrap();
    let current_output39: Array3<f32> = conv_layer39.transposed_convolve(&test_input39);

    assert!(
        arr_allclose(&current_output39, &target_output39),
        "{:?} was not equal to {:?}",
        current_output39,
        target_output39
    );

    let test_input40 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.30001205, 0.24983038, 0.04385825, 0.83179814, 0.9035203, 0.99454165, 0.4820838,
            0.2207663, 0.6613494,
        ],
    )
    .unwrap();

    let kernel40: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.6531026, 0.941437, 0.02962555, 0.00604056, 0.6749602, 0.09254023, 0.16296797,
            0.7694261, 0.49170363, 0.04446485, 0.8114944, 0.29030007, 0.1919063, 0.18254054,
            0.13724734, 0.00911832, 0.20514874, 0.59104544, 0.815183, 0.26495343, 0.62743604,
            0.94401777, 0.54503894, 0.6431647, 0.52856827, 0.51207054, 0.03335644, 0.28076503,
            0.07791043, 0.86478263, 0.980501, 0.54355013, 0.03467919, 0.886572, 0.36146563,
            0.13580918, 0.8819829, 0.48148784, 0.09721047, 0.7819647, 0.49357224, 0.6708243,
            0.72222507, 0.366483, 0.37231642, 0.11044633, 0.88196933, 0.7812372, 0.2546282,
            0.8222847,
        ],
    )
    .unwrap();
    let conv_layer40 = TransposedConvolutionLayer::new(
        kernel40,
        Some(Array::from_shape_vec((2,), vec![0.328725, 0.78940445]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output40: Array3<f32> = Array::from_shape_vec(
        (2, 9, 9),
        vec![
            0.5246637, 0.61116743, 0.5007779, 0.56573683, 0.5672665, 0.37152392, 0.4986499,
            0.32898995, 0.35832757, 0.3564882, 0.37761736, 0.5826815, 0.5169564, 0.5383497,
            0.45871502, 0.37357935, 0.35029027, 0.33067515, 1.1154326, 1.198904, 1.2037691,
            1.3116472, 1.6911713, 1.3288172, 1.0107342, 0.3427385, 1.0060204, 0.4084354,
            0.52582854, 1.2319429, 1.1807851, 1.3804882, 1.1477225, 1.2262418, 0.85349727,
            0.38456756, 1.506813, 1.3072643, 1.7002898, 1.3824049, 2.5094626, 1.6084069,
            0.96814775, 0.5424722, 0.9347898, 0.38092175, 0.5779316, 1.2199517, 1.4651688,
            1.3447034, 1.4856187, 1.674611, 1.4646463, 0.621639, 1.2418334, 1.2539062, 1.6206541,
            1.8687357, 2.5300648, 2.080991, 1.5055778, 1.0891021, 0.9451766, 0.3331208, 0.4276239,
            0.61567146, 0.76700145, 0.5929681, 0.64436495, 0.7781054, 0.8678458, 0.5039518,
            0.63120174, 0.7838207, 0.7299962, 0.8471916, 1.11882, 1.0950397, 0.80587626, 0.7540816,
            0.67829335, 0.9430318, 0.7994118, 1.0015681, 0.821112, 1.1414518, 0.8103318, 1.0177673,
            0.79282147, 0.8273323, 1.0835665, 0.952476, 1.0447676, 1.1911821, 0.94951546,
            1.0347363, 0.88123053, 0.82828796, 0.8052577, 1.2560881, 1.0817558, 1.6639918,
            1.1338589, 2.6325269, 0.95594084, 2.0664613, 0.8711531, 1.6837624, 1.7530609,
            1.4427838, 2.0441387, 2.2955036, 2.4103339, 2.2520032, 1.2751774, 1.6872106, 1.1652262,
            1.1823664, 1.8037183, 1.8229852, 2.008811, 3.274198, 1.8959606, 2.5910792, 0.94877785,
            2.1750884, 1.6726406, 1.6094315, 2.0692823, 2.2477472, 3.072886, 2.3428936, 1.9468174,
            1.740221, 1.3987437, 0.9467449, 1.9482145, 1.8011262, 2.0396566, 2.8621726, 2.5013812,
            2.8003914, 1.1069329, 2.1243527, 1.0273476, 1.112798, 1.2465415, 1.1141753, 1.4547589,
            1.3139608, 1.3492424, 1.0317777, 1.0356357, 0.84264886, 1.2145876, 1.1904091,
            1.1068656, 1.431329, 1.4289076, 1.487608, 0.95780265, 1.3332219,
        ],
    )
    .unwrap();
    let current_output40: Array3<f32> = conv_layer40.transposed_convolve(&test_input40);

    assert!(
        arr_allclose(&current_output40, &target_output40),
        "{:?} was not equal to {:?}",
        current_output40,
        target_output40
    );

    let test_input41 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.46583235, 0.3009351, 0.90517753, 0.7002328, 0.750793, 0.75040495, 0.53337294,
            0.51972127, 0.72387767,
        ],
    )
    .unwrap();

    let kernel41: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.9831707, 0.20632543, 0.16955712, 0.76152086, 0.05444199, 0.2814817, 0.15761587,
            0.95890856, 0.90069485, 0.01261302, 0.21181779, 0.78206104, 0.92161584, 0.74544144,
            0.8816592, 0.9976662, 0.2966056, 0.2162454, 0.06208929, 0.50320554, 0.6565798,
            0.5351854, 0.10227188, 0.28489798, 0.20003575, 0.1822242, 0.05310873, 0.13790856,
            0.78958035, 0.5917116, 0.38009274, 0.2742251, 0.9041115, 0.99974847, 0.9090851,
            0.4171188, 0.48332873, 0.169661, 0.15740211, 0.04401799, 0.33348852, 0.42292982,
            0.4798304, 0.90991354, 0.54084134, 0.4826352, 0.5674032, 0.6246967, 0.70394504,
            0.12639284,
        ],
    )
    .unwrap();
    let conv_layer41 = TransposedConvolutionLayer::new(
        kernel41,
        Some(Array::from_shape_vec((2,), vec![0.16602974, 0.4649844]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output41: Array3<f32> = Array::from_shape_vec(
        (2, 9, 9),
        vec![
            0.6240224, 0.26214278, 0.5408855, 0.58286136, 1.1323602, 0.58195925, 0.33589256,
            0.8553413, 0.21530941, 0.29715303, 0.2394523, 0.6974281, 0.6330347, 0.71526545,
            0.5797508, 1.037808, 0.9813185, 0.17744675, 0.9531497, 0.67481494, 1.5159787,
            1.4367796, 1.9490149, 1.8248354, 1.433689, 1.4122355, 1.0049413, 0.8278777, 0.41456604,
            1.4497904, 1.033245, 2.308579, 1.2477064, 1.2422419, 0.8981174, 0.63098496, 1.1446042,
            1.0730096, 1.817048, 2.0823555, 3.1814253, 2.4278708, 1.8233637, 1.534544, 1.0481083,
            1.014763, 0.45779073, 1.7242405, 0.99451864, 2.1382508, 1.0174251, 1.4067923,
            0.8646147, 0.552768, 0.7387663, 0.9579143, 1.3322505, 1.5713902, 1.9781537, 1.7350731,
            1.5183146, 0.91942704, 0.95435095, 0.6981579, 0.32423115, 0.7998775, 0.35329872,
            1.2690016, 0.41300502, 0.58409154, 0.21097478, 0.530289, 0.51623166, 0.45148313,
            0.5618173, 0.5961338, 0.8011597, 0.7015061, 0.3440249, 0.37226102, 0.31083113,
            0.5498703, 0.48972416, 0.5840643, 0.8487787, 0.9470695, 0.75066966, 0.76788294,
            1.1796948, 1.0005884, 0.6420439, 0.5927273, 1.000532, 1.0132235, 1.504596, 1.0140662,
            1.5569415, 1.3699342, 1.2878678, 0.7868912, 0.72732306, 0.9029244, 1.2765217,
            1.5687314, 1.582515, 1.1795444, 1.1999662, 0.9488518, 0.8864875, 0.8540202, 1.7073228,
            1.9220688, 2.7637851, 2.0780199, 2.4230587, 2.0388339, 1.6367238, 1.0790852, 1.0960685,
            1.5014647, 1.8854969, 2.139122, 2.1201015, 1.6361986, 1.7918546, 1.0407505, 0.90123516,
            0.907398, 1.7311292, 2.0954278, 2.684112, 2.1836057, 2.3580484, 1.8714836, 1.5289009,
            1.0254213, 1.1200932, 1.5720547, 1.7190624, 1.798276, 1.8509597, 1.1743456, 1.1071681,
            0.5916939, 0.64285815, 0.6905637, 0.89423406, 1.1701133, 1.2442375, 1.2440352,
            1.0934097, 1.1236504, 0.8564874, 0.72240895, 0.7676219, 1.0490165, 1.1353412,
            1.2064359, 1.2415701, 0.9828774, 0.97455454, 0.55647737,
        ],
    )
    .unwrap();
    let current_output41: Array3<f32> = conv_layer41.transposed_convolve(&test_input41);

    assert!(
        arr_allclose(&current_output41, &target_output41),
        "{:?} was not equal to {:?}",
        current_output41,
        target_output41
    );

    let test_input42 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.36747122, 0.75747913, 0.91581804, 0.02039539, 0.51063865, 0.6296097, 0.55201155,
            0.25472447, 0.48130554,
        ],
    )
    .unwrap();

    let kernel42: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.324559, 0.66492975, 0.01730853, 0.77949584, 0.13672462, 0.73892075, 0.02376527,
            0.8798877, 0.6356067, 0.22369854, 0.584571, 0.96449506, 0.7977554, 0.32541806,
            0.10196066, 0.8232674, 0.8543414, 0.9710584, 0.505133, 0.04858193, 0.16233306,
            0.651015, 0.62667716, 0.04012987, 0.8986551, 0.5988572, 0.7548613, 0.9230523,
            0.8094736, 0.41193417, 0.11411006, 0.29621908, 0.8657136, 0.3099813, 0.7817938,
            0.5514695, 0.9309671, 0.35345063, 0.04673942, 0.2836077, 0.4491099, 0.16020048,
            0.0033604, 0.7036799, 0.09309967, 0.8027366, 0.66168624, 0.75922126, 0.98626304,
            0.41794768,
        ],
    )
    .unwrap();
    let conv_layer42 = TransposedConvolutionLayer::new(
        kernel42,
        Some(Array::from_shape_vec((2,), vec![0.85175455, 0.6952307]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output42: Array3<f32> = Array::from_shape_vec(
        (2, 9, 9),
        vec![
            0.97102064, 1.0960971, 1.1039616, 1.6418672, 1.2123448, 2.051161, 0.9711721, 1.5656309,
            0.9769694, 1.1232867, 0.8604876, 1.734805, 1.1033235, 2.277171, 1.3549781, 1.8270185,
            1.4338546, 1.0566217, 1.0731871, 1.2197402, 1.7537924, 2.0573583, 2.2448382, 2.7982407,
            1.7403009, 1.6405565, 1.0312151, 1.1693522, 1.1661851, 2.2274656, 1.7096211, 3.2782254,
            2.3563318, 2.446082, 1.7145486, 1.0370896, 1.1024902, 1.4777039, 1.6120069, 2.4584415,
            2.8189373, 2.770381, 2.7038865, 1.4685682, 1.8047608, 1.2764382, 0.8822979, 1.9658811,
            1.6552324, 2.5702024, 1.8209395, 1.9684265, 1.4757122, 0.99000955, 1.1777554,
            1.3974447, 1.5367042, 1.6103215, 1.8331436, 1.8292406, 2.1151404, 1.0336462, 1.4666307,
            1.3062077, 1.3233609, 1.5974964, 1.3482155, 1.5221679, 1.3916235, 1.3315053, 1.0948778,
            0.87513727, 0.9413643, 1.2111223, 1.2390378, 1.0397362, 1.5855844, 1.1753137,
            1.3822873, 0.87106925, 1.2842822, 0.9152935, 0.9726205, 1.4880477, 1.5644805,
            2.0942419, 1.9997057, 1.8526102, 1.4365612, 1.0724875, 0.7371629, 0.8040827, 1.0997915,
            1.0335197, 1.7427814, 1.2013178, 2.0802593, 0.97911716, 1.4112115, 0.91009384,
            1.0527301, 1.5674659, 1.8195652, 2.4290195, 2.4718478, 2.0252662, 1.2476879, 1.2143215,
            0.862593, 0.7601413, 1.1125826, 1.2327445, 1.6731472, 1.719759, 1.7131052, 1.5348407,
            1.272718, 1.3320369, 1.374061, 2.5331683, 2.6743288, 3.4432995, 3.227813, 2.623683,
            2.0175, 1.454823, 0.7673806, 0.8620144, 1.4315827, 1.0379546, 1.6886089, 1.3769524,
            1.3607016, 1.2874701, 1.1301289, 1.0160204, 1.2226306, 1.4562054, 1.3161693, 2.1088657,
            2.0754442, 1.6290237, 1.3386874, 1.0948765, 0.94314456, 0.7836632, 0.811485, 1.1244771,
            0.9636379, 0.9515806, 0.7205629, 1.0339158, 0.7400401, 1.1383506, 1.0604892, 1.3188063,
            1.4082069, 1.5056965, 1.2649293, 1.1671096, 1.1699246, 0.8963913,
        ],
    )
    .unwrap();
    let current_output42: Array3<f32> = conv_layer42.transposed_convolve(&test_input42);

    assert!(
        arr_allclose(&current_output42, &target_output42),
        "{:?} was not equal to {:?}",
        current_output42,
        target_output42
    );

    let test_input43 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.8909816, 0.77955645, 0.25186005, 0.6967979, 0.44887283, 0.443149, 0.75464064,
            0.81323266, 0.85127234,
        ],
    )
    .unwrap();

    let kernel43: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.15431848, 0.56885445, 0.29611066, 0.87579244, 0.9531821, 0.5536974, 0.53754663,
            0.23263316, 0.527793, 0.6797737, 0.74194604, 0.01885639, 0.08134871, 0.6701397,
            0.42471457, 0.93320847,
        ],
    )
    .unwrap();
    let conv_layer43 = TransposedConvolutionLayer::new(
        kernel43,
        Some(Array::from_shape_vec((1,), vec![0.6966494]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output43: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.8341443, 1.2034882, 1.0807785, 1.9204185, 0.96635103, 1.5226507, 0.77122784,
            0.9172265, 1.545917, 1.1899836, 1.9186528, 1.3355596, 1.3557658, 1.0174544, 0.8320359,
            0.7552404, 1.274432, 1.6986918, 2.0447526, 2.1089656, 1.6092703, 1.5277636, 1.0147371,
            1.0895051, 1.4333048, 1.6795467, 1.940897, 2.4611707, 1.7119186, 1.9427125, 1.0418313,
            1.0347785, 1.1808693, 1.599595, 1.7995017, 2.1384401, 1.6357536, 2.2028277, 1.2775128,
            1.4505434, 1.4726429, 1.5814438, 2.209918, 2.2735538, 2.1719098, 2.0730453, 1.3424598,
            1.308234, 1.0949434, 1.2096343, 1.6857705, 1.2636933, 1.7493198, 1.2906566, 1.3282475,
            0.7127013, 0.7580384, 1.202364, 1.0833117, 1.9458659, 1.111291, 2.0260363, 1.0581971,
            1.491064,
        ],
    )
    .unwrap();
    let current_output43: Array3<f32> = conv_layer43.transposed_convolve(&test_input43);

    assert!(
        arr_allclose(&current_output43, &target_output43),
        "{:?} was not equal to {:?}",
        current_output43,
        target_output43
    );

    let test_input44 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.5644708, 0.03809474, 0.09368633, 0.5213245, 0.7867202, 0.5103296, 0.05583452,
            0.7863488, 0.5674216,
        ],
    )
    .unwrap();

    let kernel44: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.06023929, 0.39982173, 0.32429224, 0.11995548, 0.8987073, 0.1602559, 0.33672985,
            0.742261, 0.14132027, 0.06929818, 0.4782574, 0.5697997, 0.11632108, 0.49556065,
            0.47647962, 0.7417032,
        ],
    )
    .unwrap();
    let conv_layer44 = TransposedConvolutionLayer::new(
        kernel44,
        Some(Array::from_shape_vec((1,), vec![0.34966558]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output44: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.3836689, 0.57535326, 0.5350139, 0.43260807, 0.367663, 0.3916931, 0.38004732,
            0.36090377, 0.85695964, 0.44012535, 0.5739758, 0.7747552, 0.44668978, 0.3929556,
            0.38121256, 0.41920528, 0.46084097, 0.5972192, 0.8414644, 1.0510244, 0.6669936,
            0.6762765, 0.5599677, 0.46426487, 0.8838436, 0.71294045, 1.5056324, 1.3002491,
            1.1022637, 1.0900829, 0.5661484, 0.7979508, 0.42670274, 0.40811628, 0.7756482,
            1.0223315, 1.0872282, 1.1544979, 0.7777449, 0.7085166, 0.46048552, 0.61696136,
            1.4150767, 1.2936621, 1.5586169, 1.8606865, 0.783895, 1.1493536, 0.35755613,
            0.35353482, 0.4874959, 0.43597263, 0.8059309, 0.8370482, 0.62103915, 0.6729822,
            0.3561603, 0.37733498, 0.46773854, 0.7807617, 0.7903478, 1.2140949, 0.6200304,
            0.770524,
        ],
    )
    .unwrap();
    let current_output44: Array3<f32> = conv_layer44.transposed_convolve(&test_input44);

    assert!(
        arr_allclose(&current_output44, &target_output44),
        "{:?} was not equal to {:?}",
        current_output44,
        target_output44
    );

    let test_input45 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.47131556, 0.9838283, 0.6777289, 0.90295655, 0.67075133, 0.0573609, 0.8237337,
            0.36602104, 0.15022676,
        ],
    )
    .unwrap();

    let kernel45: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.66375136, 0.17951131, 0.7120909, 0.48833874, 0.85454535, 0.18296848, 0.10698621,
            0.61914563, 0.5212063, 0.922373, 0.6521379, 0.45965454, 0.3666493, 0.99957263,
            0.63527644, 0.17045999,
        ],
    )
    .unwrap();
    let conv_layer45 = TransposedConvolutionLayer::new(
        kernel45,
        Some(Array::from_shape_vec((1,), vec![0.32906872]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output45: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.64190507, 0.4136752, 1.3177056, 0.73583865, 1.4794874, 0.9311702, 0.8116733, 0.66003,
            0.7318293, 0.4153046, 1.2202189, 0.8008913, 1.013475, 1.0622048, 0.40157637, 0.7486816,
            1.1740601, 0.92588836, 2.2374082, 2.0145237, 1.8396063, 1.7442596, 0.81188756,
            0.66860145, 1.2734935, 0.96539545, 1.6589956, 2.074605, 1.3233391, 1.5999994,
            0.76575077, 0.48010913, 1.3464496, 1.309801, 2.097041, 1.8307657, 1.1567414,
            0.89600044, 0.47345105, 0.42879647, 1.3640549, 1.3823566, 1.549536, 1.7304327,
            0.94374734, 0.7548485, 0.38158095, 0.43185872, 0.7584039, 1.0888584, 1.0570291,
            1.0453095, 0.64606404, 0.6358771, 0.42703727, 0.39812112, 0.6310901, 1.1524503,
            0.9865687, 0.83534694, 0.6166738, 0.54162323, 0.42450425, 0.35467637,
        ],
    )
    .unwrap();
    let current_output45: Array3<f32> = conv_layer45.transposed_convolve(&test_input45);

    assert!(
        arr_allclose(&current_output45, &target_output45),
        "{:?} was not equal to {:?}",
        current_output45,
        target_output45
    );

    let test_input46 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.39238515, 0.8330784, 0.24240606, 0.16471672, 0.39931872, 0.18019378, 0.04206449,
            0.4967664, 0.8137173, 0.2356948, 0.4160782, 0.9648439,
        ],
    )
    .unwrap();

    let kernel46: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.08041501, 0.65951824, 0.8111227, 0.5044555, 0.5347742, 0.6593625, 0.2873256,
            0.93752426, 0.7753997, 0.7233747, 0.5849598, 0.73156756, 0.514743, 0.9262702,
            0.2988856, 0.6292863, 0.3348592, 0.68505603, 0.09462127, 0.39446756, 0.7353366,
            0.06431016, 0.30438656, 0.65234166, 0.58759433, 0.62632954, 0.4344534, 0.21980144,
            0.00100083, 0.6921164, 0.8472264, 0.3598078, 0.8860002, 0.3531883, 0.25727805,
            0.25435162, 0.7503538, 0.4171089, 0.7314984, 0.4653744, 0.71255463, 0.95627284,
            0.9875905, 0.22617352, 0.7417731, 0.37862286, 0.5094745, 0.18060002, 0.9620671,
            0.49016726, 0.45882288, 0.75507283, 0.45673513, 0.9690947, 0.10567724, 0.2728893,
            0.70271283, 0.8472397, 0.55496895, 0.91851914, 0.9672113, 0.64802116, 0.21997769,
            0.3842727, 0.94689554, 0.74909705, 0.3282922, 0.2643334, 0.3491095, 0.3052412,
            0.5038705, 0.37622157, 0.04119791, 0.7131295, 0.14328648, 0.13365868, 0.36297327,
            0.68727154, 0.93408334, 0.21441843, 0.91439056, 0.40976977, 0.9953925, 0.3781238,
            0.28116077, 0.97598535, 0.36442432, 0.14792818, 0.83921397, 0.625257, 0.09807894,
            0.3419448, 0.9480976, 0.12152596, 0.29696485, 0.41873357,
        ],
    )
    .unwrap();
    let conv_layer46 = TransposedConvolutionLayer::new(
        kernel46,
        Some(Array::from_shape_vec((2,), vec![0.95614773, 0.47523478]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output46: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            2.112003, 1.9655209, 2.0941153, 2.2603796, 1.7556132, 1.4845333, 1.749692, 1.6298113,
            2.4340005, 2.512394, 1.4460835, 1.9097099, 2.0292077, 2.6885436, 4.1917377, 3.6351159,
            2.233358, 2.1023445, 2.0561395, 2.3344214, 3.7927256, 3.4652295, 2.413973, 2.312076,
            1.1912241, 1.468441, 1.7205504, 2.4808652, 1.6813512, 1.3179643, 1.2631521, 1.4825666,
            2.2421691, 2.2092712, 2.1597137, 1.3563981, 1.7348554, 1.2732103, 2.173387, 1.9948297,
            0.87134755, 1.0290384, 1.1749382, 1.681623, 1.6945708, 1.4187804, 0.8337479, 1.1027254,
            2.171386, 1.925275, 3.6327827, 3.0647435, 2.164199, 1.7093532, 1.9477837, 1.5669056,
            2.38489, 3.4974358, 1.7449195, 1.3286611, 0.99640906, 0.9228554, 1.9002831, 1.8367513,
            0.9171173, 1.2976526, 0.91064537, 0.720831, 2.2088306, 1.3060163, 1.0105894, 1.1294074,
        ],
    )
    .unwrap();
    let current_output46: Array3<f32> = conv_layer46.transposed_convolve(&test_input46);

    assert!(
        arr_allclose(&current_output46, &target_output46),
        "{:?} was not equal to {:?}",
        current_output46,
        target_output46
    );

    let test_input47 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.25687808, 0.7602087, 0.78506595, 0.43647116, 0.97631705, 0.26839125, 0.08090039,
            0.48662946, 0.70590997, 0.99664134, 0.77797663, 0.2436962,
        ],
    )
    .unwrap();

    let kernel47: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.6407154, 0.34835714, 0.8761795, 0.19121103, 0.5305259, 0.6565131, 0.5287279,
            0.29444507, 0.775589, 0.24550702, 0.9532204, 0.8754091, 0.341333, 0.6382999, 0.5125449,
            0.5005919, 0.937352, 0.6224484, 0.14624618, 0.8417525, 0.9414587, 0.44898897,
            0.6993321, 0.36183158, 0.24969168, 0.9671642, 0.20102102, 0.799053, 0.29777643,
            0.05473179, 0.82243276, 0.49220118, 0.959262, 0.60974807, 0.82510734, 0.77621484,
            0.31383017, 0.20135997, 0.40562743, 0.25492424, 0.5874371, 0.69954115, 0.11803117,
            0.95850575, 0.9031762, 0.8240507, 0.7735656, 0.5868046, 0.50450677, 0.31319898,
            0.23300357, 0.8095447, 0.34135282, 0.24274388, 0.6729072, 0.57593447, 0.8085596,
            0.7018395, 0.76145005, 0.58241343, 0.3309161, 0.67546684, 0.32411024, 0.3949699,
            0.412044, 0.8408538, 0.76511306, 0.8994237, 0.8364367, 0.38108206, 0.69459295,
            0.8441607, 0.40802577, 0.95296425, 0.72987187, 0.07076582, 0.8826578, 0.44925806,
            0.8213124, 0.6112075, 0.96117723, 0.3876701, 0.88056743, 0.9483631, 0.8974017,
            0.4120727, 0.27696642, 0.69025475, 0.42224765, 0.96611446, 0.04551166, 0.40275672,
            0.19091433, 0.4437527, 0.31289253, 0.2396215,
        ],
    )
    .unwrap();
    let conv_layer47 = TransposedConvolutionLayer::new(
        kernel47,
        Some(Array::from_shape_vec((2,), vec![0.6389319, 0.85605]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output47: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            2.0309277, 1.9172918, 3.3648653, 3.3472986, 2.2890062, 1.8890243, 1.672059, 1.2731764,
            2.9822588, 2.492289, 1.8420024, 1.7725165, 2.600887, 3.034655, 4.8649035, 4.740038,
            3.093081, 2.3125815, 3.324091, 2.7527366, 5.063587, 4.3119707, 2.6521792, 2.2444234,
            1.6127788, 1.6296482, 2.6884656, 2.1385913, 1.2902896, 1.5047052, 1.6666553, 1.5562177,
            2.5464516, 2.3439965, 1.4392335, 1.2919312, 2.2678983, 1.5953851, 3.5486414, 3.4757276,
            1.9073737, 2.65841, 2.0646434, 1.4992666, 3.589886, 2.8157134, 1.844327, 1.9736297,
            3.5321412, 3.2873, 4.2184834, 5.7834177, 1.6504029, 3.0136774, 2.85527, 2.5355356,
            3.7247427, 3.4845867, 2.5802908, 2.181457, 1.445986, 2.4237313, 1.7162256, 2.8429255,
            1.3254249, 1.5863833, 1.2651223, 1.2988929, 2.1088872, 1.9215653, 1.4489906, 1.3214805,
        ],
    )
    .unwrap();
    let current_output47: Array3<f32> = conv_layer47.transposed_convolve(&test_input47);

    assert!(
        arr_allclose(&current_output47, &target_output47),
        "{:?} was not equal to {:?}",
        current_output47,
        target_output47
    );

    let test_input48 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.27247688, 0.19161025, 0.50402254, 0.5852498, 0.97299683, 0.594723, 0.38096267,
            0.29591832, 0.28942943, 0.4529504, 0.19683413, 0.1757779,
        ],
    )
    .unwrap();

    let kernel48: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.88774997, 0.5229589, 0.7137983, 0.82603574, 0.8461087, 0.9091735, 0.80568945,
            0.79286724, 0.3410004, 0.32917508, 0.17503856, 0.7846004, 0.7272445, 0.48829708,
            0.9584728, 0.7469263, 0.66009414, 0.59341496, 0.42636782, 0.9874962, 0.85196227,
            0.43363968, 0.02657376, 0.11542477, 0.13354255, 0.5618466, 0.070237, 0.35689688,
            0.27853093, 0.8144841, 0.99201185, 0.6685596, 0.5670808, 0.68718493, 0.73198694,
            0.84016347, 0.55920875, 0.27009216, 0.10123584, 0.2636, 0.9657689, 0.005051, 0.5576874,
            0.9025137, 0.55897933, 0.35369453, 0.9429427, 0.5162179, 0.5906877, 0.05157892,
            0.76241785, 0.07249359, 0.45541912, 0.01278013, 0.4782056, 0.76319754, 0.5541978,
            0.04795831, 0.5815242, 0.27330735, 0.8815459, 0.29006037, 0.23429064, 0.18781203,
            0.94584274, 0.4523076, 0.29750833, 0.17197818, 0.06818328, 0.6987018, 0.6090657,
            0.24505253, 0.8169458, 0.03939039, 0.5665328, 0.8011893, 0.75747067, 0.1555473,
            0.18986696, 0.13435428, 0.38600448, 0.19166702, 0.46490034, 0.18260308, 0.82895696,
            0.03558233, 0.14173116, 0.8877225, 0.12655611, 0.4754852, 0.7843472, 0.8912908,
            0.15408872, 0.45979473, 0.18853948, 0.826404,
        ],
    )
    .unwrap();
    let conv_layer48 = TransposedConvolutionLayer::new(
        kernel48,
        Some(Array::from_shape_vec((2,), vec![0.8497178, 0.36331993]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output48: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.9171317, 1.7917519, 2.7783177, 2.6558073, 1.5565748, 1.5855569, 1.6441054, 1.5624702,
            1.8696144, 2.0444775, 1.3401799, 1.2694049, 2.9684277, 1.5701301, 4.164564, 3.6166337,
            2.158192, 2.661987, 2.4639108, 2.0705984, 4.1353827, 3.2518852, 2.2887084, 1.9458034,
            1.5503144, 1.025307, 1.8908725, 1.9477677, 1.2167729, 1.7168067, 1.5783117, 1.261192,
            2.4535866, 1.867073, 1.7230723, 1.4632311, 1.2296386, 0.630672, 2.0084984, 0.9869718,
            1.1090206, 0.6783581, 1.2785058, 0.50421035, 1.6864436, 1.5010998, 0.71700877,
            1.2414219, 1.6092801, 1.0571637, 2.8136244, 2.2935379, 1.6347585, 1.6294394, 2.1076252,
            1.2309906, 2.566152, 2.2917309, 0.9601119, 1.4268773, 0.66666764, 0.75836533,
            1.0390451, 1.2493525, 0.7143807, 0.80973965, 0.8698718, 0.97484374, 1.4406445,
            1.5778356, 1.0463666, 0.95543486,
        ],
    )
    .unwrap();
    let current_output48: Array3<f32> = conv_layer48.transposed_convolve(&test_input48);

    assert!(
        arr_allclose(&current_output48, &target_output48),
        "{:?} was not equal to {:?}",
        current_output48,
        target_output48
    );

    let test_input49 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.98673576, 0.43612492, 0.03541405, 0.783278, 0.24658875, 0.74658084, 0.34663445,
            0.03917093, 0.3931895, 0.30789322, 0.68702215, 0.44194368,
        ],
    )
    .unwrap();

    let kernel49: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.33855647, 0.9119313, 0.31810585, 0.16017109, 0.00698695, 0.293519, 0.14280626,
            0.48469457, 0.1767692, 0.42322084, 0.46112144, 0.9255381, 0.5532242, 0.9853486,
            0.24325794, 0.63504064, 0.15406865, 0.11709648, 0.1119092, 0.21574858, 0.62332,
            0.8729103, 0.52609015, 0.06899712, 0.6168495, 0.3181057, 0.10088859, 0.28579375,
            0.08647749, 0.8464018, 0.5181164, 0.47873196, 0.83375126, 0.9057766, 0.00922728,
            0.36432305, 0.53910846, 0.47707382, 0.23459193, 0.6104503, 0.99977493, 0.2879088,
            0.9237121, 0.24345838, 0.00414109, 0.03638967, 0.30595168, 0.16491044, 0.7087876,
            0.79154646, 0.6065011, 0.46475387, 0.6585233, 0.93920064, 0.09687401, 0.5544905,
            0.56360936, 0.10987341, 0.79093266, 0.6827511, 0.93982804, 0.14053226, 0.49555323,
            0.4556152, 0.66896224, 0.46089745, 0.33559954, 0.3038908, 0.7388162, 0.5641086,
            0.07862057, 0.46463865, 0.07132971, 0.5696929, 0.89171886, 0.97521317, 0.86021405,
            0.61829454, 0.4099887, 0.3409378, 0.49427044, 0.10122171, 0.23691536, 0.70967704,
            0.4641384, 0.8326181, 0.38735756, 0.9489551, 0.07998312, 0.5111061, 0.02956773,
            0.17711017, 0.11328588, 0.74999446, 0.8589006, 0.07875007, 0.73433584, 0.4188041,
            0.48477763, 0.00624699, 0.6286288, 0.21567076, 0.81573004, 0.70090973, 0.8734742,
            0.6482149, 0.5717835, 0.16271727, 0.53025377, 0.0984337, 0.82271063, 0.12299971,
            0.06295575, 0.7953895, 0.5933358, 0.27819812, 0.70772564, 0.8846656, 0.33805057,
            0.66772455, 0.9335431, 0.0900248, 0.08626243, 0.0064692, 0.9791513, 0.52760124,
            0.61633664, 0.9759571, 0.5431996, 0.11189567, 0.662313, 0.47249612, 0.88115114,
            0.93577164, 0.61019063, 0.4513792, 0.21412608, 0.21063799, 0.59758914, 0.26163143,
            0.57292384, 0.3575447, 0.41482434, 0.5686212, 0.43116546, 0.8888871, 0.5989078,
            0.96428144, 0.67385226, 0.18009396, 0.650084, 0.1288117, 0.6034601, 0.23165825,
            0.01380609, 0.45430455, 0.3510245, 0.375879, 0.7931324, 0.20369534, 0.9617992,
            0.17212614, 0.8661392, 0.818001, 0.04731771, 0.6331485, 0.83272296, 0.58803684,
            0.6773803, 0.966571, 0.59957683, 0.85136724, 0.03105091, 0.388052, 0.55736136,
            0.02805966, 0.80824125, 0.57193863, 0.9242484, 0.43400672, 0.95459735, 0.19825369,
            0.3165235, 0.34878272, 0.04700416, 0.89200944, 0.8226108, 0.49845085, 0.02590412,
            0.3321073, 0.9764468, 0.5381227, 0.92109436, 0.7710321, 0.8660679, 0.3895538, 0.854895,
            0.07690383, 0.03470363, 0.623576, 0.7447061, 0.23551573, 0.09116793, 0.13018292,
            0.29478395, 0.694041, 0.0967541, 0.8266735, 0.00767931, 0.24422543, 0.47754803,
            0.05508777, 0.30187264, 0.58673537, 0.38990366, 0.6169217,
        ],
    )
    .unwrap();
    let conv_layer49 = TransposedConvolutionLayer::new(
        kernel49,
        Some(Array::from_shape_vec((2,), vec![0.5919785, 0.35687554]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output49: Array3<f32> = Array::from_shape_vec(
        (2, 8, 8),
        vec![
            1.113163, 1.9817946, 1.6948962, 2.466367, 2.0648172, 2.1997054, 1.4447196, 1.237046,
            1.0895953, 1.2049627, 1.6940863, 1.6312165, 1.7427402, 2.1903396, 0.9742123, 1.6653373,
            1.7232702, 2.7578185, 3.1256065, 4.8354173, 3.0915375, 2.8876402, 1.3519897, 1.4113431,
            1.6440468, 1.3940103, 2.5985289, 3.0245376, 2.5537488, 3.0749984, 2.0956159, 1.8154452,
            2.0697036, 1.9709291, 3.3670702, 3.4211829, 2.685252, 2.9485245, 1.6574488, 1.4294193,
            2.13279, 1.8792474, 3.5198815, 3.8744888, 3.772111, 3.6439736, 2.1211905, 1.3229859,
            1.333745, 1.4124715, 1.9868078, 1.8819132, 1.1972703, 1.5636692, 0.6980611, 1.4348915,
            1.2760068, 0.8711694, 2.1636653, 1.6565201, 2.4699552, 1.947087, 1.0300691, 1.075525,
            1.3949254, 0.9298453, 1.8405906, 1.4692903, 2.191382, 1.653278, 0.8543761, 1.3509059,
            1.738087, 0.86169076, 1.6447673, 1.2088575, 1.6642133, 1.6744345, 1.0433321, 1.0929918,
            2.5073533, 1.6505039, 3.9826827, 2.3890781, 2.6252003, 3.3072662, 2.4446468, 1.8349463,
            1.4216262, 1.8373563, 3.2264237, 2.7059283, 3.0583882, 2.2191687, 1.9087826, 1.4406253,
            2.598937, 1.5881377, 3.8380647, 3.4670143, 3.5855064, 2.5552769, 1.7428299, 1.580647,
            1.2640655, 1.5292584, 2.9206471, 2.529808, 2.6450286, 2.3636737, 1.5066671, 1.7848092,
            0.8981191, 1.1630446, 1.5533504, 1.5508752, 0.9148831, 1.3538978, 0.8926403,
            0.83407116, 0.9039915, 0.4961745, 1.2863536, 1.1765155, 1.5058758, 1.709436, 0.6070218,
            1.0157349,
        ],
    )
    .unwrap();
    let current_output49: Array3<f32> = conv_layer49.transposed_convolve(&test_input49);

    assert!(
        arr_allclose(&current_output49, &target_output49),
        "{:?} was not equal to {:?}",
        current_output49,
        target_output49
    );

    let test_input50 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.9651153, 0.31502706, 0.15851368, 0.90410787, 0.24201743, 0.99100995, 0.46153438,
            0.5230941, 0.05274187, 0.85842836, 0.8584512, 0.30464408,
        ],
    )
    .unwrap();

    let kernel50: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.00721753, 0.18392335, 0.8556412, 0.1809689, 0.5768042, 0.3628767, 0.69780505,
            0.11757887, 0.08762363, 0.36607084, 0.24363868, 0.7472844, 0.08178072, 0.8810783,
            0.3569205, 0.451316, 0.0383365, 0.8465622, 0.9883213, 0.56150496, 0.52739674,
            0.47732064, 0.43933925, 0.21088907, 0.5524299, 0.8005311, 0.17473145, 0.40513718,
            0.82864845, 0.4856008, 0.41349155, 0.8595507, 0.77320266, 0.9890798, 0.24298015,
            0.27266598, 0.4846638, 0.87975013, 0.4469587, 0.10110632, 0.5594282, 0.9304254,
            0.09035328, 0.76902574, 0.2852155, 0.07585676, 0.24124639, 0.06790887, 0.14329627,
            0.6381789, 0.9543389, 0.6581925, 0.1983508, 0.44280005, 0.15768081, 0.7742759,
            0.90144795, 0.8614371, 0.28797778, 0.37103122, 0.0877872, 0.45872805, 0.76575243,
            0.6829663, 0.2304093, 0.5233105, 0.6974145, 0.8921432, 0.22412036, 0.0491925,
            0.5368815, 0.19189753, 0.45287937, 0.6024187, 0.37045264, 0.23233427, 0.42484194,
            0.98901117, 0.36564678, 0.8630159, 0.8116843, 0.39872772, 0.6879206, 0.7998495,
            0.594579, 0.7541534, 0.80124223, 0.59222096, 0.05390601, 0.82877624, 0.29753333,
            0.82358676, 0.29054287, 0.26042402, 0.88391197, 0.8143526, 0.579024, 0.05703124,
            0.6139959, 0.10031959, 0.78280455, 0.24171719, 0.4721017, 0.53194064, 0.6437402,
            0.09277638, 0.8693754, 0.60042983, 0.8875286, 0.86002535, 0.69702214, 0.12023476,
            0.9464669, 0.9782188, 0.38164645, 0.7172452, 0.9105007, 0.41190186, 0.29969904,
            0.43725935, 0.7022435, 0.7566894, 0.5551452, 0.88240683, 0.10910437, 0.51675713,
            0.33856305, 0.4310923, 0.43717158, 0.2241604, 0.7074267, 0.04574655, 0.62335473,
            0.6056931, 0.19430637, 0.9464095, 0.43765876, 0.47719213, 0.45312902, 0.417855,
            0.8179389, 0.03511541, 0.5549018, 0.6715673, 0.61512816, 0.655004, 0.09111205,
            0.49298653, 0.3268639, 0.77552783, 0.77209026, 0.47542888, 0.31814525, 0.52555007,
            0.81072354, 0.00102462, 0.5109687, 0.48937833, 0.122188, 0.22519495, 0.40227205,
            0.84508294, 0.43985215, 0.05504967, 0.02137936, 0.26612982, 0.12310848, 0.00158825,
            0.75761557, 0.88188004, 0.12094665, 0.13906257, 0.9157668, 0.91879827, 0.8513396,
            0.28533912, 0.30878848, 0.12668495, 0.24235713, 0.45707443, 0.7712829, 0.6903243,
            0.09853197, 0.43307763, 0.05488254, 0.70532215, 0.34688666, 0.9355463, 0.38260135,
            0.4838589, 0.17318112, 0.21472165, 0.77769446, 0.356957, 0.22671694, 0.18250434,
            0.41477197, 0.18007399, 0.9827863, 0.58704966, 0.2950183, 0.46143153, 0.19057809,
            0.3653109, 0.93977064, 0.26191843, 0.3693467, 0.1444909, 0.9363978, 0.42698747,
            0.1281546, 0.30951205, 0.1389484, 0.7072368, 0.44510987, 0.68366706,
        ],
    )
    .unwrap();
    let conv_layer50 = TransposedConvolutionLayer::new(
        kernel50,
        Some(Array::from_shape_vec((2,), vec![0.60059834, 0.09438256]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output50: Array3<f32> = Array::from_shape_vec(
        (2, 8, 8),
        vec![
            0.7496118, 0.9584476, 2.4999774, 2.074702, 1.9922249, 1.9415262, 1.4839191, 2.3607693,
            1.403275, 0.94801545, 2.1433578, 2.3785357, 2.1500816, 2.477058, 2.0550354, 1.6295515,
            1.5885952, 2.5287497, 3.0146954, 3.876481, 3.2464662, 4.2002354, 1.8547212, 3.4957426,
            2.5918212, 2.169823, 3.8838222, 3.5744512, 3.3702693, 2.8263447, 2.5477524, 2.5697634,
            2.0398726, 2.3413558, 3.3943117, 3.9673126, 3.5607672, 3.551233, 2.6089404, 3.2382035,
            1.8303993, 2.0903294, 4.2670765, 4.006754, 3.4234917, 2.6049476, 2.643833, 2.2910266,
            1.6057816, 1.5108663, 2.048646, 1.8527563, 2.3953822, 2.0390058, 2.0382493, 1.4459811,
            1.6148671, 1.2273076, 2.1654997, 2.0512617, 2.3782783, 2.2946742, 1.3488765, 1.3004441,
            0.8176154, 1.1879929, 2.3939605, 1.9659346, 1.7823939, 1.7890675, 1.2556884, 1.9623848,
            0.29224443, 1.0595094, 1.314641, 2.0489607, 1.7294811, 1.1245255, 0.61605006,
            0.7334272, 1.5922117, 2.0412507, 4.1849594, 4.109012, 2.7508545, 3.3854778, 1.6386384,
            2.4683464, 0.8685854, 2.2329972, 3.495477, 4.152409, 2.6999793, 2.20079, 1.4774101,
            0.92573446, 1.3939719, 1.4543388, 3.6879938, 3.7096016, 2.8830569, 3.590069, 1.7672825,
            1.8241899, 1.9088193, 1.8985066, 2.511721, 2.888996, 3.4400895, 2.5657735, 1.8839952,
            1.8779163, 1.2027448, 0.6714896, 1.3142478, 1.574847, 2.0432346, 1.9206775, 0.8169022,
            0.94720733, 0.5240814, 0.6943549, 1.5333046, 1.8449776, 1.4905148, 1.2999465,
            1.0056473, 0.8274467,
        ],
    )
    .unwrap();
    let current_output50: Array3<f32> = conv_layer50.transposed_convolve(&test_input50);

    assert!(
        arr_allclose(&current_output50, &target_output50),
        "{:?} was not equal to {:?}",
        current_output50,
        target_output50
    );

    let test_input51 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.36583102, 0.60821444, 0.03161661, 0.8738241, 0.29876906, 0.33316013, 0.562216,
            0.3353904, 0.10716959, 0.9334109, 0.8606402, 0.42792627,
        ],
    )
    .unwrap();

    let kernel51: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.48052302, 0.6958078, 0.4525564, 0.99052715, 0.04395659, 0.71055365, 0.9117777,
            0.93380785, 0.90260816, 0.01515595, 0.88177705, 0.43487665, 0.56912595, 0.05581366,
            0.02638636, 0.50119185, 0.31323937, 0.05636088, 0.31307653, 0.3326902, 0.3734779,
            0.4210294, 0.08686391, 0.3808534, 0.36317897, 0.19031978, 0.46563995, 0.41320488,
            0.94399136, 0.28572702, 0.6142756, 0.8158052, 0.26794037, 0.12281225, 0.32823455,
            0.14740174, 0.70965314, 0.19252698, 0.79887706, 0.02814319, 0.39099365, 0.7551387,
            0.5038018, 0.15413615, 0.82638884, 0.2631662, 0.7053773, 0.6478343, 0.32534242,
            0.6635084, 0.8839653, 0.59479696, 0.68739474, 0.903793, 0.9826564, 0.56865096,
            0.33996934, 0.63317853, 0.7065151, 0.82775307, 0.22001709, 0.37304193, 0.20307006,
            0.59174454, 0.3759951, 0.673529, 0.42676452, 0.6453951, 0.93520576, 0.59322685,
            0.5885291, 0.23145947, 0.15739693, 0.8825847, 0.17851174, 0.5603199, 0.14435844,
            0.10347797, 0.37213182, 0.14642915, 0.21561022, 0.3830422, 0.90021485, 0.32565016,
            0.82000726, 0.72865623, 0.48349917, 0.41356984, 0.03333719, 0.08149401, 0.85722613,
            0.04374503, 0.88704216, 0.09240989, 0.8528545, 0.7946653, 0.54765993, 0.74729836,
            0.72924787, 0.21080038, 0.12833528, 0.06738389, 0.9163098, 0.2233036, 0.09597177,
            0.4226413, 0.73019654, 0.8065446, 0.13412596, 0.9296237, 0.88961375, 0.8097079,
            0.92300737, 0.8407575, 0.5467569, 0.90232325, 0.40697718, 0.7049378, 0.17525117,
            0.60480595, 0.01006908, 0.09306768, 0.04155758, 0.00396548, 0.29594678, 0.24183853,
            0.23543635, 0.10814751, 0.366542, 0.58264214, 0.1795904, 0.47117367, 0.7827338,
            0.22905576, 0.3444951, 0.83183694, 0.12226541, 0.8971257, 0.27640048, 0.37137195,
            0.2710384, 0.27672654, 0.33046693, 0.4244338, 0.8525934, 0.79606473, 0.24516417,
            0.5116681, 0.32966596, 0.36674044, 0.40403318, 0.31310067, 0.7258184, 0.01080465,
            0.05479572, 0.52210695, 0.6023438, 0.20002392, 0.6150934, 0.23236814, 0.28950065,
            0.33898464, 0.5701668, 0.51984864, 0.45874897, 0.78067493, 0.8138102, 0.9551208,
            0.5881804, 0.47504795, 0.19136074, 0.8406687, 0.04588939, 0.30594054, 0.8511978,
            0.8773192, 0.8241661, 0.44152674, 0.38872027, 0.07202522, 0.9640743, 0.5195077,
            0.19128811, 0.25130445, 0.39854062, 0.8797602, 0.7229711, 0.62001854, 0.69522935,
            0.91174835, 0.65982074, 0.10557687, 0.23464549, 0.5982146, 0.28930026, 0.45670658,
            0.47519284, 0.96985734, 0.13737752, 0.33859882, 0.8539295, 0.74257755, 0.9444382,
            0.24404159, 0.7431825, 0.0306461, 0.32723787, 0.8498817, 0.780418, 0.7744034,
            0.47136632, 0.2987932, 0.90784407, 0.6841086, 0.38890767, 0.05255083,
        ],
    )
    .unwrap();
    let conv_layer51 = TransposedConvolutionLayer::new(
        kernel51,
        Some(Array::from_shape_vec((2,), vec![0.16184397, 0.90099066]).unwrap()),
        2,
        Padding::Valid,
    );
    let target_output51: Array3<f32> = Array::from_shape_vec(
        (2, 8, 8),
        vec![
            0.4760316, 0.7653949, 1.5475305, 2.206749, 0.8199479, 1.7587318, 0.5443873, 0.9708072,
            0.6498821, 0.5807632, 1.6899143, 1.191979, 2.057553, 0.62110114, 1.0492162, 1.0221763,
            1.5170535, 1.6247264, 2.7266471, 2.9884517, 1.9952008, 2.571354, 0.86158985, 1.3522283,
            1.1793673, 0.7336497, 3.4897342, 2.3535063, 3.2393112, 2.4490244, 2.3543222, 2.2624044,
            1.5187814, 1.0892246, 3.355074, 2.10132, 1.9814641, 2.4409685, 1.230365, 0.86528736,
            1.7341058, 1.1035444, 3.5606742, 3.03483, 3.5087693, 3.1058877, 1.6777828, 1.5954769,
            0.98744136, 0.99684966, 1.5039858, 1.637165, 1.0366946, 1.2635798, 1.0494062,
            0.56503904, 1.4290043, 1.068238, 2.141923, 1.9465303, 1.5363013, 1.1199515, 0.85990775,
            0.5919759, 1.3039958, 1.3048413, 2.8557181, 2.0918596, 2.3233285, 2.0441694, 1.81831,
            2.4615614, 1.3261316, 1.2934119, 2.5628152, 2.2786884, 2.5692568, 2.575955, 2.0042818,
            1.5950568, 1.9757318, 2.2114844, 3.4557385, 3.5363934, 4.065923, 3.8546188, 2.6829953,
            3.75485, 2.2910826, 2.2234063, 3.8169909, 3.976204, 4.2851057, 3.9510148, 3.2295926,
            2.603328, 1.5128756, 1.6973298, 2.889938, 3.0699754, 3.209694, 4.644499, 2.8021283,
            3.6182578, 1.4718773, 1.650265, 4.161187, 3.7339158, 4.484756, 3.777235, 2.8138044,
            2.217993, 1.9876251, 1.067939, 2.1555307, 2.5347245, 2.0862987, 3.2529042, 1.6045122,
            2.1218114, 1.4755571, 1.3873405, 2.5315971, 2.480476, 2.7367008, 2.0960948, 1.6925209,
            1.2680844,
        ],
    )
    .unwrap();
    let current_output51: Array3<f32> = conv_layer51.transposed_convolve(&test_input51);

    assert!(
        arr_allclose(&current_output51, &target_output51),
        "{:?} was not equal to {:?}",
        current_output51,
        target_output51
    );
}
