// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array2, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_transpose_stride2_valid() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(kernel1, None, 2, Padding::Valid);
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.20500435, 0.5295867, 0.63837135, 0.41609964, 0.9319781, 0.48968455, 0.60635847,
            0.52498055, 0.14307275, 0.6106298, 0.24858424, 1.0044042, 0.46611735, 1.2026571,
            0.607674, 1.0398436, 0.15204486, 0.3072405, 0.82486016, 0.83711505, 1.9425447,
            1.1114864, 2.7440317, 0.94433355, 2.3289723, 1.1802319, 0.8646134, 0.537549,
            0.20021535, 1.5911021, 0.83889574, 2.0007253, 1.0169982, 1.8688753, 0.6497939,
            0.65949893, 0.644514, 0.53375435, 1.9530745, 0.7593528, 2.585309, 1.0535524, 2.23207,
            1.0499439, 0.65207344, 0.22321652, 0.07443302, 0.4970782, 0.25841802, 1.2128702,
            0.59266895, 1.138166, 0.12282969, 0.30535886, 0.8651406, 1.0093067, 1.765773,
            0.4322542, 2.045883, 1.1588016, 1.5410925, 0.68110174, 0.50463367, 1.188707,
            0.70455384, 1.413969, 0.71151, 1.2771106, 0.32934356, 0.84927136, 0.20111695,
            0.22095333, 1.7130924, 0.93198, 2.2128985, 0.65470946, 2.2802074, 1.1046441, 1.7397914,
            0.5784988, 0.4555707, 0.6556181, 0.4959415, 1.2513329, 0.5904714, 1.5142156,
            0.74028736, 1.1560278, 0.3237792, 0.32498133, 0.6830031, 0.2159425, 1.1645802,
            0.31693456, 1.4154541, 0.33968112, 1.000927, 0.24337435, 0.25955924,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.14352316, 0.8997107, 0.64410555, 0.04471071, 0.767672, 0.43464628, 0.16569944,
            0.18875164, 0.12285258, 0.2781115, 0.5390728, 0.5066572, 0.97435564, 0.39133722,
            0.7964828, 0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183,
            0.81628793, 0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133,
            0.0067116, 0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715,
            0.7567798, 0.23972042, 0.38848338, 0.00744711, 0.8715701,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.07988323, 0.6283005, 0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194,
            0.34163022, 0.03235205, 0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297,
            0.97700953, 0.18019113, 0.775954, 0.14120784,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(kernel2, None, 2, Padding::Valid);
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.23378246, 0.59912515, 1.2000495, 1.0497109, 1.7985523, 0.9673016, 1.5353795,
            0.29936162, 0.46233523, 0.21385102, 0.8805573, 1.1886215, 1.333165, 1.2442695,
            1.2883204, 1.1279604, 0.44871566, 0.4530567, 0.5389626, 1.7299676, 2.561429, 1.7160745,
            2.0621367, 1.4783854, 1.3141904, 1.0398229, 1.0862074, 0.3263092, 1.3228769, 1.2481385,
            1.0589972, 1.0733559, 0.75514674, 0.9502192, 0.97536, 0.93481064, 0.6560059, 1.0405267,
            0.8761964, 1.3669415, 1.432875, 1.3746045, 1.5553426, 1.1082746, 0.56217176,
            0.02184504, 0.08585983, 0.21492471, 0.7792609, 0.92801356, 1.018051, 0.8746961,
            0.3358971, 0.08083438, 0.24061574, 0.85245466, 1.45993, 0.9053254, 1.0753281,
            1.3101006, 1.4669561, 1.2496339, 1.5369762, 0.23356734, 0.93083537, 0.54521435,
            0.34415808, 0.30722648, 0.610601, 0.5465143, 1.3363973, 0.8821693, 0.7620158,
            0.95370007, 0.9622226, 0.44529352, 0.9582989, 0.6930301, 1.5425302, 1.9863622,
            1.663812, 0.11275871, 0.45355517, 0.37351927, 0.36160812, 0.47121483, 0.35494697,
            0.42140633, 1.3620077, 0.9765619, 0.26940888, 0.30895022, 0.12025096, 0.30403057,
            0.39376482, 0.18909958, 0.7197994, 0.97212505, 0.15108703,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.3426181, 0.5417864, 0.7768226, 0.34603763, 0.6114103, 0.9716041, 0.5157695,
            0.50755495, 0.6659802, 0.629322, 0.60627973, 0.27978492, 0.28792506, 0.7547703,
            0.0509604, 0.10449678, 0.89887625, 0.6572328, 0.695583, 0.3626411, 0.37613922,
            0.9241278, 0.39898983, 0.6908677, 0.5511301, 0.36253917, 0.36786652, 0.88718724,
            0.69587743, 0.4870034, 0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529,
            0.5566727, 0.7035832, 0.92333794, 0.85647196, 0.36252776,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.9373231, 0.01684272, 0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754,
            0.31284246, 0.4031665, 0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259,
            0.23846498, 0.82509995, 0.97324103, 0.96826524,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(kernel3, None, 2, Padding::Valid);
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.5985942, 0.30391142, 1.4437885, 0.7416204, 1.544271, 0.32933676, 1.2455649,
            0.55343354, 0.36986947, 0.6332556, 0.13847348, 1.6246073, 0.23104082, 1.677525,
            0.2973285, 1.5767721, 0.15125354, 0.42296287, 1.5488778, 0.920402, 3.2625203,
            1.3726182, 3.2494628, 0.9316069, 2.9719129, 1.4923996, 1.3051109, 1.0287272,
            0.24270733, 1.7893643, 0.36687818, 1.5973891, 0.20118423, 1.6891117, 0.2172292,
            0.59030336, 2.0543015, 1.2904507, 3.244081, 1.053412, 2.923623, 1.0951627, 3.136854,
            1.8086834, 1.5181623, 1.2011695, 0.267872, 1.6540356, 0.2468754, 1.746763, 0.24679282,
            1.7126664, 0.13796927, 0.44396427, 1.5160552, 1.0717797, 3.2673266, 1.2834084,
            2.7683842, 1.3302367, 2.6907492, 1.4903902, 1.3059568, 0.4584833, 0.11316772,
            1.6038188, 0.3024169, 1.2646371, 0.03913542, 0.7380182, 0.05843239, 0.210723,
            1.7678511, 0.8855423, 3.3936946, 1.7155874, 3.3839746, 1.253248, 2.2600894, 0.86792743,
            0.8373586, 1.4223996, 0.35291094, 2.2235484, 0.2730256, 2.0745778, 0.28453135,
            1.3635185, 0.14526142, 0.35705492, 1.259785, 0.9659627, 2.3021526, 1.1042407,
            2.3913202, 1.0511615, 1.6828883, 0.4662764, 0.49722776,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.77620417, 0.8427075, 0.42989048, 0.76771307, 0.54514444, 0.7878393, 0.21897991,
            0.975659, 0.73295325, 0.69994044, 0.86701024, 0.76087946, 0.623545, 0.14890751,
            0.8610666, 0.21943341, 0.1644093, 0.6089244, 0.8612485, 0.02602104, 0.30423534,
            0.5087405, 0.16869895, 0.3329467, 0.179494, 0.33126613, 0.11996287, 0.21606164,
            0.87119263, 0.33579683, 0.2313126, 0.2576527, 0.3748985, 0.30113342, 0.8142977,
            0.423247, 0.8179498, 0.92175007, 0.21606776, 0.19149332,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.4240341, 0.14780204, 0.46443272, 0.00207204, 0.359202, 0.9019851, 0.21363449,
            0.6390296, 0.5977058, 0.81350476, 0.3685356, 0.90738845, 0.7828945, 0.9812083,
            0.6726924, 0.46724817, 0.17302093, 0.39839587, 0.78055173, 0.8576361, 0.7335981,
            0.52934057, 0.9529279, 0.78965247, 0.46750203, 0.08403921, 0.73126566, 0.34934825,
            0.3459232, 0.54770446, 0.68714255, 0.29283327, 0.53392637, 0.8850151, 0.6909357,
            0.44388366, 0.9043074, 0.9949724, 0.64743847, 0.36691284, 0.5396585, 0.5372604,
            0.47547424, 0.44373918, 0.34716287, 0.21774843, 0.9437953, 0.51856595, 0.15765554,
            0.9350713,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(kernel4, None, 2, Padding::Valid);
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 13, 11),
        vec![
            0.35470474, 0.33720142, 0.86686957, 0.6034287, 1.2110193, 0.36463368, 1.1934485,
            0.41618967, 0.71968013, 0.11676471, 0.45812047, 0.90917766, 0.25491422, 1.7681437,
            1.0622021, 2.155473, 1.0951742, 2.3230867, 0.66775703, 1.1346385, 0.75352937,
            0.85458297, 0.6673483, 1.1912723, 2.12458, 2.605221, 2.9117098, 1.9351985, 2.7285852,
            1.872889, 1.9563639, 1.0456114, 1.1073937, 1.1419133, 0.4667766, 2.5046387, 1.910007,
            3.1686182, 1.8945227, 3.7914963, 1.2308786, 1.8912808, 1.5213561, 1.7169931, 1.3002597,
            2.1003928, 3.638967, 3.90457, 5.149136, 2.8420267, 4.663398, 2.842582, 3.3145962,
            1.8466333, 1.8202575, 1.6113296, 0.60245466, 2.645023, 2.2764237, 3.9340343, 1.8327875,
            3.8497515, 1.4699796, 2.209813, 1.540236, 1.7087694, 1.3917395, 2.2771835, 3.6193118,
            3.783656, 4.686215, 3.6307814, 4.6409197, 3.4615011, 3.781535, 1.864756, 1.5751648,
            1.6326545, 0.837867, 2.1543624, 2.0846858, 4.257942, 1.7475495, 3.4698102, 2.4556131,
            2.878837, 1.213973, 1.2129517, 1.2620587, 2.737469, 3.4843202, 3.7128754, 5.832033,
            3.747091, 5.3915534, 3.5413961, 3.4579039, 1.1970829, 1.0137708, 1.2040102, 0.5839509,
            2.38316, 2.06279, 4.2146735, 2.2633119, 3.2464266, 2.0664341, 2.2786303, 0.5441178,
            0.48860747, 0.9627302, 1.5727563, 2.5395253, 2.991488, 3.966972, 3.560525, 3.578794,
            2.50567, 2.4620981, 0.38951558, 0.5861172, 0.5182335, 0.46789828, 1.236363, 1.0918628,
            1.6248461, 1.1494123, 1.4035847, 0.8755107, 0.91506535, 0.10528385, 0.08879595,
            0.29871762, 0.8590057, 1.2282465, 1.4510523, 2.578811, 1.2859752, 2.1401148,
            0.90865576, 0.7287722, 0.05073756, 0.1912248,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.86233217, 0.81734437, 0.6566154, 0.3879487, 0.28848994, 0.5814131, 0.06870039,
            0.78543746, 0.47194287, 0.12733267, 0.6111727, 0.25675833, 0.74741316, 0.45714313,
            0.9649919, 0.57969916, 0.5208711, 0.93666834, 0.13247305, 0.7087714, 0.17877895,
            0.40767, 0.6906785, 0.9675369, 0.224454, 0.28950995, 0.75431514, 0.99582964, 0.8120864,
            0.9536324, 0.7703749, 0.683158, 0.16371861, 0.42877796, 0.7300311, 0.9456737,
            0.05700503, 0.19623296, 0.44457257, 0.5512328,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.15101007, 0.25140873, 0.2031063, 0.5537751, 0.3641559, 0.701937, 0.27669305,
            0.85076064, 0.00186597, 0.3316532, 0.15485734, 0.35000807, 0.42372492, 0.03995521,
            0.5067197, 0.38907993, 0.37287286, 0.21294773, 0.8646356, 0.10154326, 0.75313085,
            0.7910046, 0.15368015, 0.25977603, 0.40315583, 0.635939, 0.25689796, 0.13678746,
            0.43744904, 0.6658951, 0.564682, 0.70429957, 0.67241764, 0.15790685, 0.25059524,
            0.6432024, 0.60438925, 0.45131883, 0.96080875, 0.40131757, 0.60942906, 0.7035094,
            0.6473561, 0.05433872, 0.7478619, 0.24740443, 0.35665986, 0.00020906, 0.23741227,
            0.57013196,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(kernel5, None, 2, Padding::Valid);
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 13, 11),
        vec![
            0.24391334, 0.26272577, 0.5822803, 0.8659618, 1.1932282, 0.97347254, 1.4708238,
            1.0118458, 0.9101715, 0.6380844, 0.7855519, 0.70625615, 0.36451524, 1.6577806,
            0.54311484, 2.1512017, 0.73402447, 2.2149482, 0.8990666, 1.3714896, 0.15350461,
            0.3711246, 0.43483347, 0.540066, 1.1960706, 1.2171881, 2.4872348, 1.7312813, 3.1236472,
            2.2317107, 2.0340092, 1.815699, 1.5340106, 0.7737161, 0.68521893, 1.8337827, 1.7476387,
            2.6510327, 2.0566635, 3.6600993, 2.4685178, 2.841806, 0.5467229, 1.2730206, 1.4704294,
            1.3097773, 2.181396, 2.5576358, 3.800905, 2.6954165, 4.12116, 3.5062802, 2.719244,
            1.7597022, 2.0540795, 1.0388792, 0.96801096, 2.184837, 1.5180908, 2.9684298, 1.937231,
            3.5761542, 1.7688123, 2.4565701, 0.8415837, 1.0808499, 1.0852033, 1.1942158, 2.269378,
            2.8220363, 3.3542666, 3.014888, 4.217918, 3.6831737, 2.6992738, 1.84181, 2.129496,
            1.2956185, 1.069396, 2.5658882, 1.6262779, 4.062735, 1.7814983, 4.3830485, 2.0901628,
            2.767175, 0.40953436, 0.9662203, 0.89230365, 1.1690941, 1.5215272, 1.9618404, 3.522011,
            2.978961, 3.908688, 2.8904877, 2.74324, 1.7942995, 1.7914308, 0.78838676, 0.57813764,
            1.9540784, 1.5345917, 2.8535092, 1.6744654, 3.4272892, 2.410273, 2.5085804, 0.6409812,
            1.1393006, 0.7207311, 0.86636144, 1.0829679, 1.2695842, 2.4511175, 1.7852664, 2.522235,
            2.2335057, 1.6891894, 0.9330549, 1.3532357, 0.23740101, 0.23432226, 0.6318498,
            0.9407712, 0.74449486, 1.1826963, 1.1695801, 0.7907775, 0.8537058, 0.6427823, 0.484217,
            0.4063874, 0.43234286, 0.8340422, 0.95974094, 0.59623975, 0.5532601, 1.1801285,
            0.8972044, 0.41591164, 0.31499127, 0.60002077,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6398819, 0.7132858, 0.90739846, 0.8246988, 0.1319153, 0.6876462, 0.846729,
            0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465, 0.05539654, 0.5554673,
            0.9149804, 0.9791666, 0.9000323, 0.6329186, 0.30872977, 0.30553624, 0.04431259,
            0.5287215, 0.3358437, 0.72178566, 0.72704846, 0.85191244, 0.07464863, 0.867838,
            0.5849202, 0.14913943, 0.18325551, 0.40498126, 0.75359416, 0.01821492, 0.5917236,
            0.91982275, 0.5287654, 0.7151285, 0.38420153, 0.517026,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.5150141, 0.26934662, 0.7356045, 0.97902703, 0.6362754, 0.27803296, 0.32063982,
            0.83432084, 0.78711736, 0.28247103, 0.7812688, 0.5270146, 0.4719829, 0.47535485,
            0.23715672, 0.4404677, 0.90286416, 0.66611385, 0.02649495, 0.3193976, 0.16608049,
            0.5121102, 0.17436478, 0.313714, 0.47244504, 0.9906781, 0.9064671, 0.29454133,
            0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972, 0.53866875, 0.6358971,
            0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548, 0.14977625, 0.53714937,
            0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625, 0.4744624, 0.73655206,
            0.42605233,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(kernel6, None, 2, Padding::Valid);
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 13, 11),
        vec![
            0.37344772, 0.21251793, 1.374897, 1.3418632, 1.8931495, 1.7722939, 2.4262118, 2.098336,
            1.4386348, 1.5242876, 0.6150685, 0.18572651, 0.21240374, 0.84707284, 0.84253097,
            1.3733546, 1.1920056, 1.815138, 1.2773695, 1.5098456, 1.0379381, 0.69193494, 1.3277261,
            1.0682505, 2.8821201, 2.9283395, 3.4418237, 2.9644027, 4.4897423, 3.2337077, 2.3056486,
            1.5077068, 0.6237273, 0.4534372, 0.76248574, 1.6284567, 1.8198807, 2.9355965,
            2.5401669, 3.4266138, 2.2138457, 2.012564, 0.95667106, 1.4388076, 1.9268208, 1.7990011,
            3.8316202, 3.9118521, 4.5504274, 3.1720634, 4.685827, 3.7693553, 3.1386414, 2.1895845,
            1.5686841, 0.52115196, 0.89450854, 1.7812991, 2.634107, 2.795426, 1.8527932, 2.5929801,
            1.3798399, 1.6114829, 1.2718494, 1.2399296, 2.410207, 2.2223008, 3.0292115, 3.3852987,
            3.8758166, 3.2739117, 5.493317, 4.542192, 3.4234288, 3.0088036, 1.5065383, 0.63353586,
            1.2698708, 1.4730017, 1.4913499, 2.6251917, 1.3161781, 2.6094341, 2.5672088, 2.734476,
            1.4704969, 1.4498687, 2.1639688, 2.2351906, 3.6319845, 3.7351906, 4.5975175, 3.5733025,
            5.026454, 3.9507163, 2.8934474, 1.9359792, 1.3193408, 0.48080176, 0.8296927, 1.6432247,
            2.1645844, 3.098862, 2.2119498, 2.6627395, 2.3008032, 2.3108544, 0.95860577, 1.457172,
            1.5842825, 1.4557977, 2.517604, 2.2748265, 2.82751, 1.9181901, 2.915578, 2.6303997,
            2.0969226, 1.1844921, 1.0731883, 0.47563162, 1.0966328, 1.0191423, 1.2172139,
            1.3674803, 0.8234925, 1.2113678, 0.7345414, 0.63975155, 0.24061294, 0.50754905,
            0.42973223, 0.82450795, 0.8919586, 1.4876802, 1.3550649, 1.147575, 1.1645982,
            0.8918255, 0.608132, 0.47666755, 0.3646292,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6592577, 0.3237799, 0.42867732, 0.87574345, 0.70010746, 0.01496939, 0.78416556,
            0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122, 0.68573385,
            0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448, 0.48578474,
            0.2764571, 0.9192946, 0.8920509, 0.34320405, 0.4283556, 0.3897719, 0.06360459,
            0.729173, 0.19460331, 0.8634254, 0.6576018, 0.9657459, 0.22873744, 0.47843248,
            0.22157177, 0.9162307, 0.02157675, 0.44649428, 0.2792192,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.685827, 0.75294507, 0.7919586, 0.22560763, 0.88778716, 0.80092114, 0.00003577,
            0.9737877, 0.9146247, 0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946,
            0.17754778, 0.41998118, 0.02919354, 0.82382417, 0.4156855, 0.49590722, 0.69720376,
            0.7155315, 0.40795937, 0.15397236, 0.02265206, 0.7090415, 0.75877124, 0.67035425,
            0.39483562, 0.86222315, 0.9993058,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(kernel7, None, 2, Padding::Valid);
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            0.6561572, 0.5105666, 1.2604698, 0.6025265, 1.1642572, 0.5375744, 2.072085, 1.1642791,
            1.4284457, 0.56838703, 0.8261847, 0.8667044, 0.7721626, 1.2922266, 1.0342844,
            1.4123485, 1.8776479, 2.1158183, 0.6383219, 1.2167088, 1.3020626, 0.6396021, 2.1759217,
            0.8059183, 2.0244653, 1.1036296, 3.2814193, 1.6810372, 1.7879076, 0.923437, 1.2919464,
            1.334798, 1.1830384, 2.0125086, 2.1748042, 2.0088754, 2.490574, 3.259803, 0.8436623,
            1.6689284, 1.6737474, 0.8664851, 2.9173362, 1.5698954, 2.387811, 0.7992804, 2.914167,
            1.3789907, 1.5802816, 0.5388603, 1.6499444, 1.7956158, 2.0556223, 2.7810016, 1.452152,
            2.62266, 2.139878, 2.301077, 0.54565895, 1.1306958, 1.7746252, 0.5735313, 3.8679943,
            1.8210478, 2.1934628, 0.8383461, 2.8156662, 1.7322133, 1.8432751, 0.8552034, 1.6907928,
            1.8902092, 2.4516468, 3.075019, 1.5610342, 2.1552157, 2.6049945, 2.956715, 0.74902856,
            1.7268527, 1.5131865, 0.6731057, 3.4336472, 1.839277, 1.8771188, 0.60503346, 2.4961379,
            1.1865796, 1.4457631, 0.4916073, 1.8908435, 1.8786502, 2.3350902, 3.044246, 1.0688646,
            1.769926, 1.7579343, 2.1159136, 0.4198601, 1.0318251, 0.8118365, 0.12247043, 1.669267,
            0.8400033, 0.6556633, 0.10587637, 1.0117784, 0.4412819, 0.5901024, 0.26389706,
            0.8083781, 0.74329853, 0.97305906, 1.3379116, 0.39002836, 0.40088624, 0.72598016,
            0.88166094, 0.2591315, 0.37764335,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.84902793, 0.26427644, 0.86764544, 0.24274233, 0.69865257, 0.5739991, 0.7620597,
            0.29289714, 0.88402116, 0.8942853, 0.7757528, 0.16431308, 0.48939565, 0.56055367,
            0.46453193, 0.9573795, 0.8899508, 0.16098963, 0.63514715, 0.810474, 0.29953358,
            0.46075395, 0.02808736, 0.59781086, 0.8855644, 0.61877847, 0.9537467, 0.6197168,
            0.3379795, 0.13108306, 0.30692965, 0.33537498, 0.01351478, 0.45529485, 0.6626128,
            0.9497022, 0.7403127, 0.06039312, 0.08292098, 0.80679554,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.1354166, 0.2560622, 0.80891573, 0.97702754, 0.4124968, 0.4359102, 0.8733311,
            0.1396195, 0.52047473, 0.88564533, 0.29781443, 0.21130918, 0.83071965, 0.3337948,
            0.9783562, 0.42070097, 0.55396014, 0.16172563, 0.7634967, 0.36205766, 0.48491392,
            0.4980414, 0.6001484, 0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525,
            0.7446416, 0.471613, 0.72900707, 0.842964,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(kernel8, None, 2, Padding::Valid);
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            0.28090215, 0.26584622, 1.2065117, 1.0801591, 0.69861436, 0.65173846, 1.0873314,
            1.0167212, 0.6527847, 0.45360795, 0.4954693, 0.5192801, 1.2536862, 0.6582907,
            0.87884253, 0.7291733, 1.1646156, 0.54298085, 0.57076967, 0.42322236, 1.1376593,
            1.1088457, 2.3031158, 1.97757, 2.2332735, 2.3621783, 2.34061, 1.7572591, 0.94368076,
            1.0813645, 1.6459638, 1.1702626, 3.2901022, 2.147863, 2.985617, 2.0927649, 3.1753962,
            1.9155152, 1.3010151, 1.0505464, 0.99751186, 1.0026417, 2.1410816, 2.7337382,
            2.1852179, 2.6142156, 1.9354355, 2.286641, 0.64342076, 0.88242185, 1.7683594,
            1.2045319, 3.6740491, 2.322497, 3.6844335, 2.1685119, 3.2377353, 2.0614653, 1.0831101,
            0.886979, 0.65864867, 0.94968724, 1.6026409, 1.9879843, 2.0498, 1.9642105, 2.0605998,
            1.7076433, 1.6389631, 1.6054125, 1.1944749, 0.67454064, 2.8393078, 1.5653789,
            3.1191971, 1.797702, 3.0277445, 2.1848185, 1.811319, 1.1040084, 0.7903254, 0.782611,
            1.9496182, 1.8530262, 1.0844828, 1.3577034, 2.2998257, 2.6208022, 1.8129711, 2.1116061,
            1.1427041, 0.92637646, 2.6105623, 1.3257611, 2.238687, 1.4671519, 3.770032, 2.4192414,
            2.821007, 1.8419275, 0.7365138, 0.87416863, 0.57088697, 0.9810198, 0.4254327,
            0.65864986, 0.9312236, 1.0177774, 0.45906907, 0.8724083, 1.2905673, 0.646202,
            1.5890905, 1.0806798, 0.79090786, 0.36975315, 1.9559003, 0.98813367, 1.3810918,
            1.0210668,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.21457537, 0.938401, 0.41665936, 0.05351101, 0.43856344, 0.7253113, 0.8520324,
            0.4151233, 0.35101932, 0.7388761, 0.3592986, 0.6741479, 0.9965808, 0.3117034,
            0.8605703, 0.94308543, 0.8192489, 0.31478795, 0.750324, 0.36604244, 0.78454614,
            0.039194, 0.23696694, 0.2418382, 0.24788351, 0.5622223, 0.15428482, 0.50688076,
            0.37682602, 0.44385925, 0.00051633, 0.53422695, 0.5675659, 0.53845215, 0.2130759,
            0.86445093, 0.432881, 0.6255918, 0.3942565, 0.07226853,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.09869356, 0.32627374, 0.8543963, 0.85603166, 0.25422713, 0.24929269, 0.36793318,
            0.39957172, 0.9079535, 0.865758, 0.82237726, 0.60374194, 0.7658025, 0.0215734,
            0.473204, 0.6594781, 0.86392707, 0.8566667, 0.48541847, 0.54855824, 0.5860555,
            0.158874, 0.10558709, 0.19664533, 0.39609066, 0.27843866, 0.49128443, 0.75033015,
            0.35650545, 0.4687038, 0.6159849, 0.2547001,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(kernel9, None, 2, Padding::Valid);
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            0.6989679, 0.7421048, 0.69064045, 0.9538043, 1.0666356, 1.1637478, 0.6852321,
            0.71129775, 0.16311234, 0.17846945, 0.5143385, 0.17813605, 0.42332423, 0.480179,
            0.59420913, 0.5241838, 0.333658, 0.26484546, 0.04522347, 0.06893784, 0.7630125,
            0.7596636, 2.481783, 2.7712479, 2.37314, 2.362135, 1.8851887, 1.9266955, 0.7635467,
            0.8471776, 0.7007855, 0.5210618, 2.0188317, 0.8740666, 1.5050156, 1.3861833, 1.2027059,
            1.0044429, 0.38054803, 0.36243284, 0.8565731, 0.88605285, 2.302898, 2.3637722,
            2.5900643, 2.634022, 2.1894746, 2.1161692, 1.4257238, 1.5011017, 0.7343044, 0.27301967,
            1.7330111, 1.1005946, 1.8074014, 1.1843895, 1.6135563, 1.2443275, 0.81311774,
            0.77729106, 1.0566581, 1.2201936, 2.943401, 2.9853666, 1.9488347, 2.1158576, 2.798028,
            2.8515198, 2.0422504, 2.0893705, 0.989135, 0.5228042, 1.9437034, 1.2245119, 1.4135798,
            1.087135, 1.962563, 1.260222, 1.0863526, 1.127474, 1.5844887, 1.6589642, 3.0763144,
            3.0247192, 2.3739147, 2.591779, 2.9420872, 2.7765336, 1.548089, 1.5709913, 1.427492,
            0.56052625, 2.0456572, 1.6512187, 1.8178515, 0.95962775, 2.0219843, 1.527385,
            1.1210703, 1.0025914, 0.9153, 0.8298021, 1.4200033, 1.2661377, 1.4036386, 1.4188263,
            1.1717159, 1.0858511, 0.33652937, 0.27522042, 0.7817073, 0.22056696, 1.1184123,
            0.95053995, 1.2494686, 0.5679106, 0.9039927, 0.6370088, 0.21772906, 0.25980377,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.17250927, 0.07203952, 0.8724657, 0.14018923, 0.12091745, 0.4770398, 0.43290496,
            0.6356798, 0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513,
            0.06810815, 0.79673207, 0.29373887, 0.55241185, 0.23906927, 0.18915932, 0.02753429,
            0.1438574, 0.5419741, 0.71984386,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286, 0.21388301,
            0.30016333, 0.49605927, 0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258,
            0.26911622, 0.92149794, 0.7165893, 0.04745785,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(kernel10, None, 2, Padding::Valid);
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.60474586, 0.4159831, 0.60505897, 0.08838709, 0.25142318, 0.5162623, 0.17181505,
            0.22075805, 0.50654995, 0.3366864, 0.11674013, 0.18280858, 0.79815364, 0.5670688,
            1.3629392, 0.99694324, 1.0553678, 0.29836154, 1.0250587, 0.82627493, 0.8821909,
            0.2433617, 0.523599, 0.39938796, 0.25365677, 0.36267665, 0.6956045, 0.44869855,
            1.0168586, 0.9621355, 0.86705935, 0.68612695, 1.0260975, 0.97543836, 0.39106497,
            0.11298969, 0.4993115, 0.4559921, 0.65173984, 0.5365474, 0.680973, 0.48663706,
            0.46210206, 0.49901855, 1.2383689, 1.1030399, 1.6775124, 0.85063183, 0.94269407,
            0.06572585, 0.28106615, 0.44205657, 1.1086694, 1.0040743, 0.7968082, 0.5059436,
            0.18354347, 0.17463082, 0.8287102, 0.67497355, 1.2688757, 0.66483814, 0.28041375,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.55642486, 0.34654748, 0.83168656, 0.8410765, 0.7668131, 0.84094906, 0.6012723,
            0.9256995, 0.66010624, 0.43380973, 0.62281454, 0.45852852, 0.61445725, 0.524579,
            0.06486581, 0.14233574, 0.13930365, 0.5838787, 0.45914945, 0.30819193, 0.70949817,
            0.8803759, 0.6927248, 0.50569826,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.7358748, 0.58652496, 0.85065925, 0.3247378, 0.6760192, 0.4483504, 0.59195757,
            0.37883574, 0.7796499, 0.32748002, 0.44507304, 0.7488422, 0.14428215, 0.8785777,
            0.15468395, 0.6638725, 0.30651525, 0.9492515,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(kernel11, None, 2, Padding::Valid);
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.6106815, 0.5998354, 1.3602642, 0.4367347, 1.3208802, 0.51667494, 0.75605613,
            0.2693474, 0.91600233, 0.5327444, 0.69515616, 0.5159577, 0.61922574, 0.38292068,
            1.4028403, 0.95579624, 3.0024402, 0.80383134, 2.870184, 1.0880612, 1.8625925,
            0.29366583, 0.69363683, 0.66822624, 0.6407694, 0.7226802, 1.0814805, 0.4673565,
            1.1851978, 0.91927415, 2.974692, 1.0133086, 3.351851, 1.2004966, 2.302721, 0.2615029,
            0.80987006, 0.6856799, 0.89656115, 0.77943945, 1.0695938, 0.40570688, 1.2682796,
            1.0147915, 3.3706589, 1.118763, 3.4276145, 0.9615549, 1.9568837, 0.26789695, 1.0667424,
            0.63287807, 1.0296471, 0.60825735, 0.7542693, 0.28380483, 0.8412543, 0.43419126,
            2.0024786, 0.44827512, 1.7502959, 0.3287112, 0.83752656,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.55669755, 0.08302987, 0.45890567, 0.05946975, 0.9099885, 0.30235246, 0.24214035,
            0.42138377, 0.38782486, 0.21880285, 0.9182205, 0.85290706, 0.5070326, 0.5272234,
            0.71761, 0.560904, 0.22129431, 0.2624427, 0.6557088, 0.00633, 0.6603214, 0.45500925,
            0.6523986, 0.14666249,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.32440838, 0.2805719, 0.42671442, 0.74477625, 0.9118973, 0.5335283, 0.36968935,
            0.5693756, 0.36426732, 0.11819325, 0.95361024, 0.13343851, 0.5940242, 0.7282295,
            0.9320007, 0.46956548, 0.5087874, 0.7952918,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(kernel12, None, 2, Padding::Valid);
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.24052519, 0.6397051, 0.39445835, 0.5260615, 0.33947146, 0.81307626, 0.29157847,
            0.71580476, 0.8768871, 1.1445907, 0.45965436, 1.3037311, 0.94105965, 0.9136522,
            0.5294777, 1.1265111, 1.3058729, 0.78186554, 1.503098, 0.9615003, 0.9019118, 0.3774822,
            0.46269718, 1.3636837, 0.9909692, 1.0728333, 0.46683294, 0.4059104, 0.4414192, 1.01247,
            1.2363406, 0.75498176, 1.1269975, 1.0441817, 0.5724584, 0.5698473, 0.69831365,
            1.0579066, 0.38886842, 0.9118094, 0.834522, 0.8223356, 0.52217543, 0.9667766,
            1.2975068, 1.1229072, 1.3848672, 0.9359418, 1.0499382, 0.43324566, 0.5308769,
            1.6122158, 1.3124187, 1.8202786, 0.8845676, 0.5917396, 0.2945457, 0.35608396, 1.087368,
            0.8547445, 1.2375033, 0.5602445, 0.42732564,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.73709416, 0.3358689, 0.03185032, 0.27057356, 0.26166973, 0.5843129, 0.5337139,
            0.19571388, 0.1192536, 0.75616854, 0.97167397, 0.71154076, 0.26672947, 0.07128377,
            0.3383284, 0.8008563, 0.9504947, 0.5971434, 0.7847773, 0.92326206, 0.24163638,
            0.12968542, 0.5954836, 0.6734995,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.08627631, 0.7485715, 0.8782484, 0.6863155, 0.7264353, 0.08944888, 0.68172634,
            0.4284322, 0.48237634, 0.6856524, 0.04009921, 0.0687674, 0.9063645, 0.42620143,
            0.61030614, 0.10040135, 0.50107217, 0.763057, 0.25769317, 0.8816114, 0.7770131,
            0.23345616, 0.62762326, 0.15315741, 0.73589575, 0.2752067, 0.85641515, 0.7439484,
            0.6581306, 0.4056261, 0.13899311, 0.26460668, 0.9179794, 0.96651816, 0.89336777,
            0.18948041, 0.9371178, 0.7124811, 0.9657549, 0.6203675, 0.32684848, 0.11439406,
            0.07654371, 0.95680344, 0.9728639, 0.6055871, 0.00439729, 0.8525613, 0.3167563,
            0.13499211,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(kernel13, None, 2, Padding::Valid);
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.1369995, 0.7801989, 0.89438003, 0.9938923, 1.0875096, 0.59101784, 0.55257297,
            0.24452363, 0.16037202, 0.1030058, 0.5730749, 0.6005981, 0.86118853, 1.0028863,
            0.34214944, 0.6181961, 0.34236437, 0.3240899, 0.32384202, 1.1890541, 2.0026755,
            2.3843074, 2.7089977, 2.2851746, 2.052173, 1.1343384, 0.89600885, 0.29670137,
            0.7962187, 1.6464922, 1.9560556, 3.3057318, 1.8106611, 2.2427154, 1.19093, 1.2913313,
            1.158879, 2.0139737, 3.32413, 3.8935568, 4.43412, 2.7503474, 3.0708034, 1.1786488,
            0.9808124, 0.44574335, 0.7986942, 1.6996064, 2.4695106, 3.5866048, 2.469954, 2.878878,
            1.0129933, 1.3937129, 0.96625865, 1.5159303, 3.8654885, 4.0660896, 5.940823, 3.8581057,
            4.242517, 1.4944205, 1.5233648, 0.39575267, 0.90701866, 1.4014393, 2.4021802, 3.299494,
            2.7287576, 3.301567, 1.2561094, 1.429767, 0.9448483, 0.30157995, 2.6447883, 1.452458,
            3.650718, 2.0206265, 2.6367226, 1.0484996, 0.97245216, 0.11830782, 0.39373025,
            0.87911665, 0.87394154, 1.8714082, 1.2537321, 2.0304618, 0.8277659, 1.2825259,
            0.6660887, 0.17710248, 1.7007743, 0.3863533, 2.6522384, 0.5065174, 1.8162155,
            0.32231295, 0.61453694,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.68338645, 0.7955047, 0.21689218, 0.2826704, 0.12328367, 0.6890043, 0.5906649,
            0.41700745, 0.30266365, 0.5716598, 0.12726787, 0.35587692, 0.16889893, 0.3114892,
            0.1309899, 0.24026695, 0.55435276, 0.34375766, 0.4225387, 0.37165096, 0.6202945,
            0.6069533, 0.05756181, 0.0153275,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.8497578, 0.79796964, 0.4071996, 0.19325097, 0.04944435, 0.59729165, 0.39304134,
            0.679002, 0.6126854, 0.67232877, 0.7156292, 0.09058711, 0.33372015, 0.8941644,
            0.30899736, 0.3348802, 0.6412177, 0.26750943, 0.03709449, 0.56803024, 0.8756273,
            0.5771133, 0.56024176, 0.5868575, 0.75167763, 0.36936092, 0.37185487, 0.35425207,
            0.24336162, 0.01027582, 0.2671537, 0.83992416, 0.49819484, 0.7831867, 0.70054483,
            0.8701863, 0.49413827, 0.84670645, 0.8069649, 0.093459, 0.93408287, 0.8206956,
            0.70209366, 0.32817394, 0.744203, 0.39091238, 0.43911496, 0.92919487, 0.29325068,
            0.62813336,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(kernel14, None, 2, Padding::Valid);
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.64309764, 0.60812753, 1.1291456, 0.9237859, 0.7024884, 0.45131916, 0.17725587,
            0.07379254, 0.01207012, 0.45330298, 0.4104614, 1.1065291, 1.1252738, 1.4376554,
            0.92661744, 0.96558154, 0.2354762, 0.23758715, 0.9649714, 0.46027225, 1.7211435,
            1.39095, 2.00085, 1.8834128, 0.8723428, 0.5164497, 0.11686106, 0.61964303, 0.8897213,
            1.3921179, 1.7219394, 2.3619905, 1.4475429, 1.9439995, 0.74240226, 0.9247395, 1.733772,
            1.2413446, 3.1083484, 2.4661274, 3.829843, 2.1739497, 2.01517, 1.268627, 0.51167893,
            0.784772, 0.96549547, 1.763336, 1.7922198, 2.821316, 2.0969455, 1.9635061, 0.80961454,
            1.2852343, 1.8417789, 1.2128025, 2.4601858, 2.0226104, 3.5322585, 2.1184895, 2.0933313,
            1.3488451, 0.9030827, 1.0960855, 1.4600011, 1.7234036, 1.6569558, 2.8445103, 1.1163862,
            1.4050945, 0.4448365, 0.883551, 1.6196369, 0.8781275, 2.0798137, 1.9153241, 2.3884528,
            1.0008233, 1.4692872, 0.6901034, 0.7285307, 0.75838226, 0.8646823, 0.67544943,
            0.3492388, 0.984369, 0.264385, 0.22109145, 0.01823116, 0.21355562, 0.7378265,
            0.5964347, 1.0181865, 0.61219656, 1.2533457, 0.30367997, 0.34544027, 0.21334384,
            0.27713242,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.8131431, 0.19520658, 0.47931832, 0.42483747, 0.47526902, 0.28184402, 0.09741595,
            0.45691565, 0.44086096, 0.9638409, 0.33859608, 0.26381832, 0.29839757, 0.68755937,
            0.09156765, 0.58584654, 0.04617033, 0.14705709, 0.81179595, 0.16751295, 0.06864621,
            0.6308731, 0.38993102, 0.3644169,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.68174505, 0.272409, 0.23609333, 0.21866773, 0.80119157, 0.01742986, 0.49270406,
            0.37920174, 0.90869635, 0.8191268, 0.7636344, 0.7827788, 0.9694966, 0.79533535,
            0.00732174, 0.8372113, 0.9449071, 0.7670253, 0.50964797, 0.7843069, 0.7365313,
            0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833, 0.5585159,
            0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028, 0.52249014,
            0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726, 0.25884646,
            0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234, 0.32747796,
            0.9097073,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(kernel15, None, 2, Padding::Valid);
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.84385765, 0.29728505, 1.1587796, 0.5606761, 1.6272316, 0.55385756, 0.6203333,
            0.15240228, 0.42392978, 0.10195946, 0.55522007, 0.7544766, 1.4058095, 1.4853394,
            0.9553381, 0.774687, 0.5013922, 0.44046566, 1.6356916, 1.000058, 2.1959908, 1.6218714,
            2.1149154, 0.93091154, 1.5169809, 0.536329, 0.3560323, 1.0760761, 1.3583935, 2.1769621,
            1.9502788, 2.9335542, 1.5052513, 1.7171052, 0.6392944, 0.74815595, 2.362098, 1.4779668,
            3.528604, 2.7796934, 3.3536088, 1.775862, 2.0490663, 0.8711167, 0.64965236, 1.019386,
            1.0216143, 1.9729681, 1.8738536, 2.3296647, 1.3517395, 1.4231117, 0.6468706, 0.7216613,
            2.6267815, 1.3453696, 2.9051592, 2.3288376, 4.6921444, 1.9417669, 1.6843739, 0.9276801,
            0.6015168, 0.8703544, 1.1038839, 2.220554, 2.5170467, 3.2247934, 1.6346891, 1.7441106,
            0.7512949, 0.8006455, 1.8928475, 1.4138595, 2.3790522, 2.040871, 2.8837583, 1.5060962,
            1.2889663, 0.7209579, 0.38773367, 1.262648, 1.0740395, 1.8078756, 1.1405948, 2.2554681,
            0.657409, 1.0334847, 0.26644567, 0.4636942, 1.2956264, 0.9813711, 1.6220267, 1.550266,
            1.6626029, 0.80941796, 0.73267096, 0.37115276, 0.37586558,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446, 0.9843364, 0.4038572,
            0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686, 0.5288406, 0.92906404,
            0.87780553, 0.9090181, 0.82569945, 0.20383635, 0.7166643, 0.17061436, 0.91526777,
            0.08598401, 0.70100874, 0.40537685,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.5971982, 0.92796123, 0.15859716, 0.7859081, 0.8564488, 0.35816404, 0.79062706,
            0.9644883, 0.13154314, 0.31929043, 0.80048305, 0.07180241, 0.52815664, 0.45786336,
            0.91537887, 0.9783313, 0.25753945, 0.42799363, 0.07738555, 0.9294206, 0.07022415,
            0.60058224, 0.6196278, 0.9008346, 0.04155485, 0.82207745, 0.41282526, 0.9949608,
            0.3109271, 0.47614527, 0.7615821, 0.35893062,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(kernel16, None, 2, Padding::Valid);
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.5805416, 0.9167884, 0.4176417, 1.5041133, 0.48645347, 1.5496328, 0.11661471,
            1.0571041, 0.67437667, 0.58410364, 1.0090746, 1.7636638, 0.9259646, 1.5054747,
            0.78661484, 1.0868306, 0.7270174, 1.6410501, 1.3527867, 3.2199583, 1.2209477,
            3.6643543, 0.7799949, 1.8584713, 1.1562482, 1.3621562, 2.668398, 3.3606105, 2.692206,
            2.3265996, 1.8540643, 1.7483976, 0.5456989, 1.6282299, 1.4414182, 3.278847, 1.3607228,
            2.9237714, 1.0462638, 1.6362538, 1.0087786, 1.2939067, 2.8891966, 2.7613502, 2.5691867,
            2.5218563, 2.1385772, 2.4891362, 0.51248926, 1.388005, 1.5849249, 2.8951528, 1.0785339,
            2.9401324, 0.9599005, 1.4783564, 1.026482, 0.8221462, 2.756832, 2.505702, 2.6827638,
            3.247489, 1.68971, 1.5080798, 0.09331859, 0.28852195, 0.74020755, 1.0250313, 1.1181122,
            1.1599505, 0.31417188, 0.41650385, 0.38707054, 0.35331893, 1.4277177, 1.4826901,
            1.6576042, 1.4913756, 0.47662365, 0.32494462,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.07713356, 0.6123928, 0.62511915, 0.88098776, 0.21521498, 0.89468116, 0.1842307,
            0.10784956, 0.8354833, 0.2630701, 0.7184675, 0.06132602, 0.06056971, 0.71349823,
            0.00944792, 0.07349233, 0.35231608, 0.8533961, 0.17608605, 0.18067755, 0.51991457,
            0.19053963, 0.5045173, 0.7456122,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.27621788, 0.48649722, 0.39297876, 0.54849166, 0.3746991, 0.8194284, 0.34880427,
            0.79505837, 0.41293454, 0.890512, 0.12076204, 0.20799449, 0.88948244, 0.24437675,
            0.7731474, 0.65954226, 0.4922565, 0.5211581, 0.97382414, 0.9779564, 0.1754263,
            0.4551989, 0.81067127, 0.7095975, 0.5087082, 0.78796804, 0.03310984, 0.20805901,
            0.45704818, 0.9133983, 0.5689028, 0.04247752,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(kernel17, None, 2, Padding::Valid);
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.0511215, 0.06909166, 0.6096741, 0.7713144, 1.112799, 1.342705, 0.25485915, 0.3521123,
            0.03952739, 0.0907767, 0.430636, 0.93090147, 1.0279068, 1.5097256, 0.22570337,
            0.50371045, 0.34218505, 0.58331454, 1.277815, 1.9796029, 1.4554026, 2.1825523,
            1.2584519, 1.4572965, 0.43929002, 0.82953393, 1.4742264, 1.9441222, 2.2853565,
            2.138304, 1.4925765, 1.7295854, 0.53874373, 1.0238361, 0.73952425, 1.0876802,
            1.5462667, 2.5005066, 0.9709319, 1.3303549, 0.9171339, 0.5135387, 1.3545139, 1.4006126,
            2.141023, 2.290277, 1.8901198, 1.6595182, 0.33211067, 0.53009397, 0.9002637, 1.2564616,
            1.7861165, 2.5195937, 0.8683039, 1.0447619, 0.3763476, 0.5081589, 1.0250616, 1.4831251,
            1.9803263, 2.0767498, 1.5675697, 1.1509635, 0.2055598, 0.3844062, 0.5914097, 1.131708,
            0.50809073, 0.8965368, 0.03209295, 0.16788681, 0.32108203, 0.23832679, 1.1814435,
            0.8180015, 1.2378317, 1.1913179, 0.4715949, 0.07211886,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.55938286, 0.9835293, 0.04525762, 0.7176199, 0.82096803, 0.5575717, 0.5744108,
            0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355, 0.1134909, 0.5645703,
            0.30096474, 0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894, 0.681929,
            0.24701218, 0.74485576, 0.61556435,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.63869125, 0.05875124, 0.3210932, 0.96946657, 0.09463912, 0.6275637, 0.34162354,
            0.74390864, 0.8736778, 0.9513908, 0.24045336, 0.7003475, 0.87750345, 0.16564246,
            0.6314963, 0.21785556, 0.7654987, 0.13988015, 0.03287261, 0.82226163, 0.60896695,
            0.13331373, 0.62307173, 0.23316076, 0.9600204, 0.55291533, 0.29808274, 0.8765127,
            0.98263544, 0.27148733, 0.11101003, 0.2754741,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(kernel18, None, 2, Padding::Valid);
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.44415006, 0.04873956, 1.2436941, 0.77237797, 0.59365726, 1.4624813, 0.02442541,
            0.2913475, 0.12205171, 0.36617827, 0.6986963, 1.1350837, 0.8753253, 0.9318164,
            0.20298369, 0.1038407, 1.3696268, 0.6944108, 2.774433, 2.8997064, 2.0510209, 2.8148668,
            0.30879802, 1.5657088, 0.9197816, 0.62843806, 2.7090836, 1.6899236, 2.2481885,
            1.6709099, 0.8053769, 0.71445435, 1.865001, 1.0303253, 2.9832816, 3.1942747, 2.7887933,
            3.798118, 0.5319836, 2.0641084, 1.466789, 0.67379206, 2.9298942, 1.850153, 3.2087483,
            1.8856264, 0.99358165, 0.7820436, 1.5025785, 0.9457261, 3.170847, 2.9904695, 2.296749,
            3.6314678, 0.3545626, 1.4907038, 1.2993343, 0.5062101, 2.85737, 1.6261811, 2.8308322,
            1.673193, 0.72852206, 0.51776105, 0.52762854, 0.4529077, 1.6372794, 1.6982043,
            1.154984, 1.7514307, 0.21939446, 0.6441283, 0.5344868, 0.12213565, 1.7412997,
            0.48842478, 1.3741566, 0.58870053, 0.1626311, 0.202103,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969,
            0.5836321, 0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643,
            0.91682273, 0.6142979, 0.19277428, 0.28408903, 0.25507236, 0.9800453, 0.36125833,
            0.96792, 0.33258557, 0.9508625, 0.8424581, 0.8130291, 0.7774976, 0.17691322, 0.9389267,
            0.22419459, 0.33442205, 0.7614585, 0.37563834, 0.70754576, 0.1499497, 0.9873837,
            0.7166968, 0.40278858, 0.22288306, 0.3279577, 0.07722609, 0.598755, 0.8143903,
            0.87905455, 0.83061284, 0.9923988, 0.6196494, 0.536406, 0.06662867, 0.83588266,
            0.28182983, 0.662181, 0.99850965, 0.60448396, 0.12318801, 0.91713256, 0.8540598,
            0.19103892, 0.5929614, 0.9118344, 0.9381113, 0.3421722, 0.8149188, 0.9595595,
            0.02717085, 0.8916309, 0.9755575, 0.27588442, 0.59208006, 0.00008138, 0.9552037,
            0.12578069,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.01249961, 0.05413999, 0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439,
            0.34315115, 0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794,
            0.6930413, 0.90735817, 0.91156703, 0.45996496,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(kernel19, None, 2, Padding::Valid);
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.48162568, 0.72777444, 1.1134647, 0.40586552, 0.5931597, 0.22326368, 0.46319696,
            0.37484503, 0.84758866, 0.12883258, 0.9762155, 0.6213571, 0.8317557, 0.75419146,
            1.0718671, 1.1909175, 0.55180424, 0.618412, 0.2840999, 0.8643898, 1.1623869, 1.3164114,
            0.92549264, 1.4165542, 1.109933, 0.8198087, 1.5948482, 1.6182493, 2.4863586, 1.3288635,
            2.1675372, 1.056892, 2.779048, 1.6530397, 3.2863796, 1.0658786, 3.018616, 1.3021922,
            1.2047307, 0.7246334, 0.93116385, 1.6206412, 1.3379395, 1.7216973, 0.9407753,
            1.8103108, 1.6448303, 2.087976, 1.4077606, 1.582764, 0.7528436, 0.55484694, 0.95190704,
            0.8893597, 2.5717564, 1.8470082, 2.772187, 1.1449645, 3.255104, 1.8667071, 3.8251765,
            1.8794503, 2.8699086, 1.1945734, 1.0552313, 0.1845156, 0.34753838, 1.1123291,
            1.1957227, 1.4743538, 1.0637093, 1.563406, 1.1597824, 1.7304785, 1.1107625, 1.4131275,
            0.81804633, 0.6027004, 0.43469495, 0.3076857, 2.2305648, 1.8751317, 3.551655,
            1.4290416, 2.8044271, 1.0542619, 2.761452, 1.576154, 2.6528263, 1.5946463, 1.6921023,
            0.20070131, 0.33823118, 1.3756735, 1.7187357, 2.096129, 1.1208937, 1.3666025,
            1.0224077, 1.3652077, 0.8493497, 1.7354434, 1.6883461, 1.2470213, 0.97079045,
            1.1658684, 3.357997, 1.5520737, 3.2895203, 1.7441566, 3.3439517, 1.457345, 2.3630676,
            0.7321435, 3.2165267, 2.0444562, 1.790456, 1.0868076, 1.6188653, 1.7945486, 1.0304133,
            1.7254846, 1.4460045, 1.9044514, 1.0601777, 1.1780668, 0.8424169, 1.4277076, 1.0371497,
            0.7629613, 2.24801, 2.1195233, 3.0959961, 0.9028163, 3.0342245, 1.6109133, 2.5144775,
            0.97379714, 2.3894975, 1.2922857, 2.4962025, 1.0665816, 1.1431737, 0.9127389,
            1.2123014, 1.4182682, 0.9229455, 1.3070362, 0.8859681, 0.9374325, 0.61555755,
            1.2801856, 1.0326086, 1.255749, 0.9777037, 0.72587794, 1.1808238, 1.0040433, 1.5470806,
            0.5127825, 1.394374, 0.66862136, 1.094333, 0.24286932, 1.3692877, 0.9221876, 1.5047877,
            0.45347938, 0.5741586,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.9045769, 0.17170428, 0.43418503, 0.69308424, 0.42869946, 0.9244341, 0.41451567,
            0.6224708, 0.00536506, 0.33826837, 0.47926104, 0.0032256, 0.02230139, 0.35960108,
            0.48593593, 0.86064774, 0.28908366, 0.4153976, 0.3468706, 0.2242362, 0.93169004,
            0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496, 0.11111139, 0.19382912,
            0.9307082, 0.9188555, 0.10532705, 0.88550454, 0.20754221, 0.97926295, 0.3472928,
            0.71126235, 0.03633394, 0.7482733, 0.28782296, 0.7382309, 0.60003114, 0.3259743,
            0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927, 0.968827, 0.47373444,
            0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834, 0.3979838, 0.2393961,
            0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945, 0.66457146, 0.8425775,
            0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123, 0.48163053, 0.437191,
            0.43973154, 0.29997745,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.21913478, 0.6611514, 0.209788, 0.176356, 0.88925517, 0.14793599, 0.36509594,
            0.5616029, 0.6617385, 0.30053073, 0.36820948, 0.62227124, 0.4957459, 0.69923055,
            0.3227648, 0.9702412, 0.5679234, 0.13432135,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(kernel20, None, 2, Padding::Valid);
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.20914373, 0.6114408, 0.47488445, 0.38904384, 0.68329513, 0.3930412, 0.6439307,
            0.73005724, 0.8790514, 0.5043724, 0.76385903, 0.73121774, 0.3967796, 0.17753997,
            0.8298055, 0.5467813, 0.67590445, 0.48617572, 0.5873559, 0.6453352, 1.1325223,
            0.71387374, 0.8007833, 0.5817189, 1.049989, 0.2419701, 0.713536, 1.1178155, 2.1905706,
            0.9850145, 0.98946285, 0.55515647, 1.6309952, 1.0524588, 1.6886613, 1.1211956,
            1.7870089, 1.0631572, 1.259069, 0.49735668, 0.9670047, 0.51742995, 0.6524268,
            0.3329726, 0.27881274, 0.21429914, 0.33938596, 0.45234293, 0.84928465, 0.74706346,
            0.68030185, 0.31318045, 1.1289195, 0.90799445, 1.3621246, 0.94959533, 1.6232147,
            0.7327133, 0.9996766, 0.988607, 1.589857, 0.8254215, 1.6980804, 1.0355527, 0.5724213,
            0.2387849, 0.35108122, 0.5992203, 0.8551862, 0.6362537, 0.7850372, 0.65353423,
            1.1418728, 0.3810492, 0.2978839, 0.4160947, 0.7660598, 0.24455297, 0.6633966,
            0.65744483, 1.3941114, 0.8732207, 1.5178208, 1.309958, 1.7237287, 1.006713, 1.0869141,
            0.6662718, 1.4170659, 0.9009381, 0.77734137, 0.25847155, 0.5867389, 0.33799484,
            0.36679626, 0.45573473, 1.0837816, 0.32023686, 0.29595584, 0.2884449, 0.6897582,
            0.5131841, 0.592454, 0.22788805, 0.94774354, 1.2262852, 1.7211688, 1.0889108,
            1.7507951, 1.1142808, 1.5177068, 0.47553343, 1.4038091, 1.3371449, 2.0806355,
            1.2839267, 0.7688948, 0.5890107, 1.275343, 0.89125854, 1.2479135, 0.7820966, 0.6879623,
            0.53583163, 0.47315428, 0.6698123, 1.3045945, 0.82030106, 1.2408088, 0.3315172,
            1.4189886, 1.274903, 2.4114032, 1.663856, 2.2548738, 0.8554777, 1.3640661, 1.1615798,
            1.873408, 1.3016055, 2.2234197, 1.4408824, 1.0253183, 0.3968085, 0.62714636, 0.6958085,
            1.1792752, 0.587237, 0.52132875, 0.5755909, 1.1765119, 0.56522036, 0.61630565,
            0.46745497, 0.8422471, 0.20204346, 0.77870804, 0.49245387, 1.0391796, 0.8155555,
            1.2043142, 0.39008558, 0.9837376, 0.79824793, 1.260181, 0.44477448, 0.8396118,
            0.5698112, 0.5109631,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.7430913, 0.19231908, 0.26170298, 0.10480803, 0.00958306, 0.20726651, 0.20851518,
            0.17973869, 0.23704103, 0.1163867, 0.2735905, 0.8537909, 0.40303, 0.75797635,
            0.34342998, 0.74670875, 0.82946825, 0.91931367, 0.9654975, 0.18782942, 0.10021565,
            0.05109123, 0.3069365, 0.10895161, 0.9891213, 0.62504834, 0.507994, 0.47125,
            0.84314245, 0.6054993, 0.92367506, 0.6953895, 0.37023902, 0.67128026, 0.43450755,
            0.28869846, 0.27641538, 0.8369712, 0.6856483, 0.26890948, 0.65425915, 0.84581685,
            0.51146317, 0.48995435, 0.52071315, 0.80564773, 0.670521, 0.3835857, 0.47078377,
            0.5100531, 0.82525116, 0.02126783, 0.9583153, 0.23316967, 0.9487504, 0.9609589,
            0.95734006, 0.00943314, 0.7521432, 0.46106157, 0.84370506, 0.16933449, 0.71423984,
            0.5316646, 0.6400151, 0.9638914, 0.69432026, 0.8581641, 0.70813745, 0.2836983,
            0.33953485, 0.8950543,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.20262088, 0.81930757, 0.09556881, 0.22266188, 0.63842744, 0.8304186, 0.12425002,
            0.7582065, 0.09737789, 0.84872884, 0.17490041, 0.37569723, 0.6669188, 0.8970669,
            0.22398192, 0.29424527, 0.56277037, 0.41113177,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(kernel21, None, 2, Padding::Valid);
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.3851675, 0.65716547, 0.9241943, 0.3039551, 0.96778345, 0.33433542, 0.53207433,
            0.13290238, 0.6682753, 0.12228167, 1.0065849, 0.31774873, 0.33757925, 0.3498047,
            0.72237295, 1.2800028, 0.87360096, 0.86271477, 0.78215075, 0.57357335, 0.30814213,
            0.58573693, 0.5930323, 0.7647417, 0.8910789, 0.36156565, 0.65000606, 0.97926825,
            1.1205143, 0.8497947, 1.2883241, 0.8695699, 1.3251667, 0.46706504, 1.2527949,
            0.7168928, 1.321166, 1.3997581, 0.5936332, 0.3875328, 0.5919385, 0.6544941, 0.55427194,
            0.65905267, 0.618448, 0.87669015, 0.79702437, 0.7852015, 0.7761699, 0.82330644,
            0.88918555, 0.7949201, 0.65763366, 0.8584797, 1.1989506, 1.1222351, 1.4356731,
            0.8984795, 1.0008985, 1.1571436, 1.634622, 1.4319868, 1.3447436, 1.6572026, 0.41630352,
            0.40371397, 0.6796299, 0.9490671, 0.9414646, 1.3705246, 0.95956063, 0.6504795,
            0.49579802, 1.4486539, 1.3892282, 1.2636526, 0.79608387, 0.8156409, 1.1894641,
            1.5274994, 1.7794256, 1.1837075, 1.7808148, 0.9743644, 0.8593718, 0.62163764, 1.175482,
            1.5512452, 1.3829033, 0.99815536, 0.36901623, 0.84771895, 1.4674926, 1.696974,
            0.9819599, 1.0319967, 0.9227785, 0.315315, 0.0410802, 0.6145015, 0.87067944, 0.7551023,
            0.48316076, 0.1937449, 1.3156219, 2.2239342, 1.4720486, 1.2249362, 1.5399956,
            1.1558709, 1.276086, 0.52313346, 1.2271242, 1.458737, 1.7501205, 1.0067548, 0.6201647,
            0.7829224, 1.388342, 1.2624662, 0.5509524, 1.1464305, 0.96503824, 1.0413309,
            0.77779764, 1.1249919, 1.1124216, 1.621172, 1.2512424, 0.7187121, 1.1476, 2.1029813,
            1.7890584, 1.2890433, 1.4686669, 1.2143105, 1.2363336, 1.2561138, 1.1045069, 1.4148378,
            1.6913302, 1.3946213, 0.8191086, 0.66872245, 1.2125512, 1.6497146, 1.2137864,
            1.3243859, 0.8716174, 0.8047356, 0.6830601, 0.9441773, 0.581987, 1.0980835, 0.98723656,
            0.44021654, 0.3190671, 1.0910792, 0.71431553, 1.0101981, 0.6749024, 0.6792364,
            0.49407437, 0.66862607, 0.33589935, 0.5205266, 0.48114127, 0.7226031, 0.3960981,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.7882464, 0.24159203, 0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633,
            0.9636684, 0.98529965, 0.26998708, 0.13811645, 0.9724998, 0.41856614, 0.13321315,
            0.0937838, 0.4742414, 0.79873264, 0.1621314, 0.5493846, 0.6481355, 0.05176858,
            0.17029643, 0.955536, 0.089831, 0.05664136, 0.9231865, 0.98567015, 0.01680515,
            0.54690886, 0.8593988, 0.6496963, 0.8382851, 0.2400014, 0.36792266, 0.01756373,
            0.6596718, 0.5680892, 0.19350345, 0.4854058, 0.7869872, 0.12335967, 0.14544043,
            0.25711668, 0.05608724, 0.18204254, 0.9562488, 0.44598028, 0.3229758, 0.8930679,
            0.24216229, 0.21437034, 0.38366762, 0.64894366, 0.8650639, 0.7790032, 0.3529938,
            0.37360683, 0.26240814, 0.554433, 0.90017563, 0.6817857, 0.95833224, 0.28551313,
            0.85106283, 0.70093375, 0.4791875, 0.5805011, 0.9803199, 0.97033703, 0.48236644,
            0.66855663, 0.35855147,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.25242767, 0.6717967, 0.26290378, 0.53677225, 0.18097793, 0.07985484, 0.79416144,
            0.7215235, 0.42313012, 0.6529702, 0.00384528, 0.08442257, 0.7838985, 0.980683,
            0.36212954, 0.61172485, 0.5263662, 0.8496614, 0.13177402, 0.9175598, 0.04323238,
            0.03087392, 0.03482862, 0.36226457, 0.6059544, 0.29194582, 0.34645593, 0.9409913,
            0.60953087, 0.8610255, 0.1627552, 0.8939359, 0.66327935, 0.48094535, 0.06551108,
            0.86129206, 0.65446067, 0.9592776, 0.8000413, 0.21450381, 0.6442533, 0.46971878,
            0.84573215, 0.34651902, 0.18830031, 0.57119006, 0.27269888, 0.7915957, 0.21737069,
            0.04463017,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(kernel22, None, 2, Padding::Valid);
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (1, 15, 15),
        vec![
            0.36482647, 0.7263592, 0.859277, 0.99871784, 1.1569557, 0.7826604, 1.11537, 1.0611103,
            1.4507108, 0.89288366, 1.1655555, 0.8080357, 0.50101036, 0.4991798, 0.26364183,
            0.15540476, 1.1338302, 0.9963262, 0.9715934, 0.97718906, 1.0628959, 1.0382018,
            1.4038252, 1.169763, 0.86393285, 0.6386992, 0.92967784, 0.8615464, 0.39356354,
            0.5089268, 0.5785473, 0.55712175, 1.8436525, 2.2218266, 2.0398672, 2.0319655,
            2.7020414, 2.6165214, 2.8679435, 2.003132, 2.4371476, 1.677778, 1.8478847, 1.5852702,
            0.7622496, 0.89356124, 0.94670916, 1.7111723, 1.4765972, 2.7324765, 1.9942899,
            3.4630466, 2.3398056, 3.3499773, 1.61767, 2.1180954, 1.8890126, 2.1196742, 0.7180078,
            1.3853183, 0.94657236, 0.9418591, 1.9861794, 1.778813, 3.2002788, 1.8274424, 3.8440201,
            2.9201717, 4.0577254, 2.905146, 3.090952, 2.2225566, 3.1154656, 2.1350973, 1.6655664,
            0.37147248, 1.2748011, 1.8250648, 1.5574052, 2.3061604, 1.1895052, 3.0801568,
            1.6465797, 3.1896298, 2.2487464, 3.2205796, 2.388484, 2.5649772, 0.72471863, 1.1156814,
            1.2856824, 1.3302598, 2.8168015, 2.7390914, 2.5225422, 1.6412296, 2.9403536, 1.681053,
            4.0398126, 2.781088, 4.3541903, 3.3704696, 3.2994964, 1.8704977, 1.6393087, 1.0020671,
            1.7724888, 2.3707383, 1.9858855, 2.2421777, 1.0706358, 1.7539024, 1.0878905, 2.2822742,
            2.3734264, 3.7306309, 2.3688083, 3.0465915, 0.7920713, 0.42928547, 1.4146112, 1.086929,
            3.5193362, 3.2618396, 4.2249894, 3.1699193, 3.212939, 1.7448767, 3.3293006, 2.4153166,
            5.41767, 4.112847, 3.981629, 1.8084283, 0.9305986, 0.9534349, 1.309545, 2.4722939,
            2.7910135, 3.2809508, 2.3000112, 3.0003715, 1.6777046, 2.822882, 2.3541088, 3.194213,
            2.4675386, 3.1597404, 0.9178659, 0.84448254, 1.3896207, 1.3179605, 3.6076744, 3.396126,
            5.048895, 3.9020507, 5.388466, 3.0648036, 4.1024337, 2.2366302, 4.197739, 3.182528,
            3.8908665, 2.0270238, 0.9367177, 0.6202526, 1.3849561, 2.8871775, 3.2759688, 4.456565,
            2.9908695, 4.2013226, 1.9290531, 3.394264, 1.9135063, 2.9065878, 2.165776, 2.5383248,
            0.73086464, 1.333016, 0.8943572, 0.6224351, 3.0426955, 2.2724798, 3.8552, 2.912739,
            3.3990479, 2.010164, 3.330387, 1.5848684, 2.1360903, 1.3501415, 1.7827735, 1.349276,
            0.85793996, 0.7714251, 0.6146504, 2.1873446, 1.1884873, 3.0187478, 1.0322778, 2.51417,
            0.7881048, 1.5649569, 0.5389103, 1.6432995, 0.7496293, 1.0057414, 0.2111725, 0.6728037,
            0.35966435, 0.17836067, 1.0783403, 0.65475917, 1.7894303, 0.78879344, 1.619617,
            0.4407668, 0.9660219, 0.42099458, 1.007631, 0.26983058, 0.34728387, 0.3169143,
            0.41573325,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.393406, 0.8441482, 0.77705365, 0.6315176, 0.8522896, 0.16809769, 0.22305161,
            0.773223, 0.9678148, 0.2237789, 0.8982615, 0.271913, 0.34780893, 0.49277794,
            0.14560463, 0.33638617, 0.1585067, 0.18610527, 0.6963084, 0.9429821, 0.40789625,
            0.20056698, 0.37306353, 0.9367061, 0.7103306, 0.06833509, 0.48335183, 0.45182207,
            0.96346164, 0.00378525, 0.33689302, 0.28288215, 0.75004077, 0.1607512, 0.514175,
            0.35879079, 0.36688787, 0.00774159, 0.15532039, 0.01133456, 0.94680935, 0.052598,
            0.73530346, 0.8096563, 0.7097644, 0.37942106, 0.38656324, 0.13763146, 0.99930644,
            0.67476803, 0.06055127, 0.8463604, 0.4460729, 0.33209085, 0.94373864, 0.5397614,
            0.05766413, 0.64256257, 0.7357459, 0.09256811, 0.8832945, 0.03911254, 0.782554,
            0.4004812, 0.80732703, 0.8010379, 0.28867772, 0.7802926, 0.9490529, 0.5395702,
            0.1369102, 0.4513485,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.1162144, 0.9589836, 0.24819064, 0.3149064, 0.22322156, 0.39812055, 0.45308354,
            0.5711523, 0.97817534, 0.06805564, 0.5386646, 0.6699801, 0.1879456, 0.8407316,
            0.64728755, 0.53731096, 0.63207716, 0.00916763, 0.46754488, 0.8670982, 0.1932068,
            0.43971533, 0.10441232, 0.46486124, 0.22910197, 0.7679019, 0.23872072, 0.03931138,
            0.8551502, 0.19610135, 0.8555064, 0.08035298, 0.05671094, 0.9091975, 0.27582648,
            0.33816597, 0.42012835, 0.7745094, 0.14011143, 0.47505257, 0.98297566, 0.5085966,
            0.22395916, 0.01153891, 0.669607, 0.12918296, 0.55476546, 0.528783, 0.5067741,
            0.14234911,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(kernel23, None, 2, Padding::Valid);
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (1, 15, 15),
        vec![
            0.32745335, 0.4648536, 0.21610951, 1.2490027, 0.57915354, 1.0547078, 0.47100878,
            0.9858422, 1.187201, 1.2519164, 0.45186722, 1.2518148, 0.41970798, 0.09791423,
            0.04783757, 0.47049794, 0.20772631, 0.588197, 1.1014853, 1.0527859, 1.1973143,
            0.7733257, 1.1883526, 1.6063753, 1.0902777, 0.6985074, 1.774914, 0.41815048,
            0.21225098, 0.02594792, 0.9265456, 0.8071492, 1.611289, 2.584794, 2.139906, 3.3300765,
            2.0772781, 2.3198242, 2.310421, 2.8499534, 1.9157712, 1.8909793, 1.4230051, 0.35201734,
            0.2214809, 1.2898815, 0.5954057, 1.7165527, 2.0277853, 2.8645163, 2.9529376, 2.4121714,
            2.493919, 3.2740383, 2.3175633, 1.7979099, 1.9067887, 1.7171949, 0.4703129, 0.23744482,
            1.2999988, 1.4069835, 2.4019332, 3.4907742, 2.9180799, 3.420602, 3.3166864, 2.5686269,
            2.9952803, 3.293044, 2.3361194, 2.7175906, 1.4802783, 0.6952803, 0.39405304, 1.8360164,
            0.7528424, 2.4068332, 2.5395706, 2.820683, 2.5099335, 3.0378838, 1.2130032, 2.9755676,
            2.0795934, 1.5546693, 1.3379284, 1.3299966, 0.6126994, 0.4321992, 1.4689873, 2.0519004,
            2.7330468, 4.3710237, 3.0447507, 3.384358, 2.978785, 2.353823, 2.6339588, 2.7467844,
            2.1536582, 2.9363909, 1.4323586, 0.7732786, 0.5873575, 2.2537646, 1.1194041, 2.4434564,
            2.838583, 2.3527372, 1.9636075, 2.9855711, 1.305781, 1.8556983, 1.5026555, 2.2839985,
            1.8314935, 1.2807941, 1.09127, 0.47302276, 1.6513436, 2.4623778, 2.548388, 3.8892174,
            3.4070532, 2.5398796, 2.2776375, 2.8214676, 3.0105896, 3.3215792, 3.2055445, 2.8376458,
            1.5394027, 1.7414962, 0.89813244, 2.3402677, 1.3129174, 1.7714555, 2.7390249,
            2.8362188, 1.1185484, 2.79351, 2.0661461, 3.0654786, 2.0186687, 2.7907474, 2.5645988,
            1.1813029, 1.1710246, 1.0954056, 1.1986046, 2.0687237, 2.4183395, 3.1097102, 3.2601726,
            3.3409662, 2.4989178, 2.9812207, 3.080742, 3.4495363, 2.9833262, 3.0025368, 2.2136517,
            1.0967227, 0.77936333, 1.6310152, 1.0740612, 1.2684526, 1.1882629, 3.6646142,
            2.1381598, 2.1438572, 2.437026, 3.1052747, 2.1272383, 2.6291926, 1.6958361, 1.8587188,
            0.7723381, 0.6885744, 0.5304406, 1.1493578, 1.262642, 1.6706142, 2.2484426, 1.946651,
            2.3233814, 2.140061, 2.4792395, 1.8972695, 1.7011817, 2.1845338, 1.5744891, 0.77259076,
            0.5615493, 0.4647795, 0.35976288, 0.98674476, 0.7365011, 1.998668, 1.0980325,
            1.6039588, 0.7376595, 1.8190181, 0.47601476, 1.1725099, 0.69831747, 0.64188915,
            0.17295887, 0.613333, 0.10238227, 0.30828544, 0.3432789, 0.8601699, 0.8279322,
            1.3832393, 0.8568009, 1.19964, 0.7260612, 0.65021086, 0.3673451, 0.71656096,
            0.41341516, 0.39551967, 0.14644873,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.5152856, 0.6446142, 0.9118427, 0.8193508, 0.989135, 0.7842302, 0.59264964,
            0.35247177, 0.48483032, 0.22649786, 0.04158387, 0.5814206, 0.8653732, 0.4524277,
            0.44947338, 0.5519129, 0.79122764, 0.7513198, 0.9315116, 0.03313805, 0.41213843,
            0.45310238, 0.01799934, 0.4328227, 0.23842481, 0.20688592, 0.57869387, 0.9324833,
            0.43915927, 0.53123087, 0.5324186, 0.4149537, 0.22217223, 0.0080786, 0.65063345,
            0.7681623, 0.8421627, 0.27179125, 0.68530315, 0.9955617, 0.77906156, 0.18006648,
            0.5975193, 0.6555531, 0.9498266, 0.9690994, 0.5122471, 0.3840358, 0.8757204, 0.7260429,
            0.04691354, 0.40678895, 0.35535267, 0.19270384, 0.23519029, 0.6665529, 0.26402712,
            0.55168146, 0.08576613, 0.9567203, 0.57141143, 0.20602623, 0.75538653, 0.96776,
            0.44755465, 0.82362133, 0.29203537, 0.30861592, 0.39762703, 0.26186082, 0.9658112,
            0.27424002,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.50570756, 0.8114843, 0.5536027, 0.59788686, 0.05054026, 0.28394443, 0.6402348,
            0.02258505, 0.60607, 0.6834324, 0.8004999, 0.3349493, 0.4295082, 0.37033585, 0.0394791,
            0.50698835, 0.29841292, 0.9388161, 0.84357476, 0.29760668, 0.25654384, 0.71037215,
            0.14646496, 0.9906275, 0.9552909, 0.7966291, 0.6094893, 0.7271988, 0.09518696,
            0.3957746, 0.6157527, 0.31079137, 0.46793708, 0.8514491, 0.86081386, 0.8208274,
            0.2372746, 0.6977758, 0.79387194, 0.9463199, 0.99063903, 0.29514915, 0.8795419,
            0.741553, 0.03520088, 0.83411527, 0.47134155, 0.26704508, 0.2872401, 0.04289522,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(kernel24, None, 2, Padding::Valid);
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (1, 15, 15),
        vec![
            0.9314751, 0.93143535, 1.4401863, 1.0769936, 1.9209138, 1.5689082, 2.3507426,
            1.8820852, 2.6157126, 1.8621407, 2.0895863, 1.4116864, 0.92342, 0.4860209, 0.11090094,
            0.66487646, 0.5916407, 0.75610775, 1.5265326, 1.8997381, 1.4188775, 1.8614546,
            1.9701301, 2.4580352, 2.2196584, 2.1374097, 1.8208709, 1.4486055, 0.6286158,
            0.69097203, 1.8794649, 1.2175258, 3.0111556, 2.2365918, 4.5163846, 2.1679971,
            4.7484927, 2.5471334, 4.8220277, 2.1835647, 4.10898, 2.069691, 2.0447536, 0.8175572,
            0.38273796, 1.6317267, 0.9674703, 2.6172621, 2.6291199, 4.1250353, 2.597096, 4.9835052,
            3.3645096, 5.148391, 3.1027932, 4.0999093, 2.6522512, 1.8786259, 1.4744542, 0.9676757,
            2.9347804, 2.3392534, 4.1072545, 3.7162266, 5.299768, 3.4590669, 5.6630096, 4.359837,
            5.6610074, 4.3835425, 5.0304856, 3.787562, 2.88206, 1.8163456, 1.2575059, 1.6773374,
            1.17942, 2.9149017, 3.0271206, 4.14337, 2.4032242, 3.8669019, 2.2590933, 2.7651205,
            2.3711748, 2.5098255, 2.0248046, 1.8678148, 1.3946846, 0.8659115, 2.720419, 2.0995326,
            4.058935, 3.6700761, 4.7592154, 2.813815, 4.616629, 2.8313456, 3.5966763, 2.040688,
            3.9190674, 2.6081364, 2.0442781, 1.467351, 1.1844406, 1.7155734, 1.186188, 3.0822146,
            2.72189, 3.057384, 2.0015736, 2.5038695, 1.6348548, 2.599774, 1.8907496, 3.3428473,
            1.8704355, 1.6664158, 1.853614, 1.3497443, 2.4669597, 1.9370613, 3.036401, 2.9637468,
            3.961122, 2.8135703, 5.035663, 3.4518673, 4.1775513, 3.3040764, 4.7717533, 3.1954045,
            2.9603012, 2.1154475, 2.001263, 1.1248018, 0.6776289, 2.2168665, 1.9943438, 2.7587337,
            1.6292293, 2.9746656, 2.7331815, 3.0565808, 2.6314216, 3.761483, 1.7336371, 2.33899,
            2.0978117, 1.2345334, 1.5969305, 1.5980582, 2.562384, 2.859108, 4.3005724, 1.95486,
            4.0550756, 2.7588072, 4.6891856, 3.1738174, 5.719451, 2.9636064, 2.6233032, 2.0395362,
            1.4022524, 1.0179399, 0.67143565, 1.4919374, 1.6803261, 2.5851831, 1.5030277,
            3.6118345, 2.1719966, 3.9877272, 2.7119923, 3.2872992, 2.8976707, 2.7913122, 1.7579534,
            0.94814664, 1.203701, 0.68632615, 1.4303826, 1.2856247, 2.3113165, 1.598696, 2.442121,
            2.3715851, 3.3510509, 2.3826082, 3.9809356, 2.6592264, 2.1974163, 1.2650185, 0.8326546,
            0.5592317, 0.24507459, 1.2728043, 0.88060987, 1.3362806, 0.7625579, 0.9561704,
            0.5619792, 1.6046524, 0.68021435, 2.1330407, 1.5752294, 1.1899989, 0.85136586,
            0.23826373, 0.38017988, 0.5158638, 0.5198423, 1.0515478, 1.0529958, 0.8449545,
            0.768859, 0.46346906, 1.2729211, 1.0006386, 0.7979752, 1.5968969, 0.84871626,
            0.83973545, 0.74558204,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.583651, 0.94414073, 0.5729697, 0.72244126, 0.7707775, 0.02079507, 0.22973806,
            0.18128674, 0.05054512, 0.6523751, 0.27093726, 0.32479268, 0.53774405, 0.08921466,
            0.18494032, 0.78120434, 0.15868789, 0.81183356, 0.21792394, 0.6620494, 0.6886836,
            0.39724785, 0.59319293, 0.02472531, 0.21891202, 0.5342134, 0.4041879, 0.53426075,
            0.20461221, 0.29362342, 0.7835011, 0.47930118, 0.2895624, 0.7320774, 0.55179524,
            0.37774232, 0.04187773, 0.23883641, 0.63051957, 0.97746944, 0.6415133, 0.4162999,
            0.04763152, 0.75958186, 0.13098118, 0.6238241, 0.4102024, 0.5710282, 0.59153587,
            0.66274744, 0.6454271, 0.8120847, 0.22876394, 0.6206928, 0.19057496, 0.4622738,
            0.9772445, 0.17967562, 0.27354005, 0.48198408, 0.09082693, 0.6217685, 0.0965838,
            0.8904992, 0.5337058, 0.17222154, 0.62424076, 0.95776683, 0.998361, 0.150883,
            0.28713444, 0.35105017,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.1765902, 0.9674033, 0.65025777, 0.1959308, 0.3119046, 0.55247456, 0.38556734,
            0.18145509, 0.94255227, 0.7036003, 0.3402552, 0.16401337, 0.28418577, 0.5504918,
            0.6148071, 0.7740251, 0.37459207, 0.25677747, 0.80441076, 0.17314304, 0.5946227,
            0.30094627, 0.06480476, 0.5798754, 0.62549657, 0.6065069, 0.9259787, 0.3677915,
            0.69532603, 0.8356569, 0.39276573, 0.18570696,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(kernel25, None, 2, Padding::Valid);
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            0.11875411, 0.5753792, 0.6694027, 1.0962987, 1.1434258, 0.94253504, 1.373503,
            1.1713166, 1.6324775, 1.2211694, 1.176859, 0.38910627, 0.34839827, 0.07615383,
            0.20694488, 0.3350553, 0.66425, 0.723681, 0.93314064, 0.8161182, 1.0683373, 1.1628872,
            0.9637618, 1.3167971, 0.5927872, 0.64863193, 0.03499611, 0.24517545, 0.6347279,
            0.67053616, 1.7809125, 1.3439631, 2.2637372, 1.2778163, 2.5582588, 2.2509017, 3.406219,
            2.012664, 1.9136915, 1.2144225, 1.0631006, 0.31902868, 0.29496312, 0.49754947,
            1.4095365, 1.5769216, 1.4882901, 2.1581569, 2.0872755, 2.4083943, 2.1135669, 2.454354,
            1.593116, 1.7133837, 0.3385281, 0.48346618, 0.5628785, 0.862641, 1.8577878, 1.1077098,
            1.7601743, 0.9009788, 2.2251825, 2.0060802, 2.5865242, 1.281783, 1.7984135, 1.7856141,
            1.6664653, 0.5298215, 0.6178732, 0.64138293, 1.4072108, 1.6105489, 1.0340497,
            1.1155732, 1.5413561, 2.0276926, 1.5476801, 1.8819184, 1.5153424, 1.7386308,
            0.77720547, 0.8646774, 0.9867266, 0.99688315, 1.8144383, 1.6053565, 2.5121179,
            1.9068898, 3.2762437, 2.0444787, 1.9205091, 1.430244, 2.2099423, 1.3690935, 1.2547699,
            0.44973373, 0.7454212, 0.96809494, 1.6268723, 1.7839592, 1.8976115, 1.8960665,
            1.7134818, 2.3368669, 1.5158938, 1.6203232, 1.3904616, 1.5558738, 0.7836761, 1.0276238,
            0.39728945, 0.5040149, 1.7064427, 1.5870982, 2.8687937, 1.9840058, 2.3944876,
            1.7022752, 2.331544, 1.3083597, 1.4586467, 0.96839285, 0.7841877, 0.26867378,
            0.31673002, 0.42749795, 1.345041, 1.529474, 1.8935834, 2.5039, 1.9033113, 1.7758747,
            1.3184528, 1.7829629, 1.1217668, 1.4869885, 0.3288805, 0.2617923, 0.63534224,
            1.1273662, 2.5060632, 1.7934948, 2.7061136, 1.4554856, 2.4647143, 1.9943657, 2.3354678,
            1.6599045, 1.7362893, 1.1542987, 0.7873988, 0.24629304, 0.7409313, 0.81713676,
            1.8159623, 2.0571659, 1.685504, 1.9349602, 1.55185, 2.4503753, 1.7423594, 1.7491328,
            1.0965359, 1.1440117, 0.4165593, 0.53136325, 1.1289512, 0.92987794, 1.8954704,
            1.2762238, 1.9473555, 1.2401192, 1.8073843, 1.0212823, 1.088505, 0.7379563, 1.0292542,
            0.67480135, 0.45359376, 0.19106807, 0.6567107, 0.952962, 1.5290532, 1.786591,
            1.4473317, 1.5425441, 0.8831059, 0.9386202, 0.86581254, 1.138371, 0.8034675, 0.9817277,
            0.37011915, 0.3575745,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.61698794, 0.9064707, 0.01547038, 0.2551995, 0.11438051, 0.03861368, 0.6524532,
            0.36442748, 0.08230381, 0.79969245, 0.27816203, 0.3741886, 0.44356522, 0.27386904,
            0.4171807, 0.14990133, 0.4750283, 0.6358263, 0.77572674, 0.7072159, 0.34310365,
            0.36999545, 0.8200852, 0.46510443, 0.9230857, 0.86201537, 0.04691705, 0.12260284,
            0.89921826, 0.47400048, 0.7492544, 0.05440097, 0.28273952, 0.9184355, 0.9064988,
            0.7027802, 0.19125043, 0.8670149, 0.08634489, 0.722654, 0.77540857, 0.00211577,
            0.6443405, 0.2344423, 0.9849179, 0.9893316, 0.87634915, 0.48734385, 0.8760625,
            0.53053117, 0.01152504, 0.6788874, 0.76156837, 0.4680538, 0.07214947, 0.549209,
            0.8383253, 0.00365476, 0.9782156, 0.7419056, 0.40790308, 0.00302504, 0.80174476,
            0.7689671, 0.50054824, 0.16478458, 0.89107823, 0.7763043, 0.73042727, 0.41667554,
            0.7348974, 0.71259016,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.93557405, 0.37013116, 0.14954911, 0.33766475, 0.39673004, 0.03940821, 0.2414454,
            0.9373305, 0.84819096, 0.9272432, 0.8604789, 0.92845494, 0.8023847, 0.06647868,
            0.12827316, 0.02774826, 0.8982795, 0.1193029, 0.37523487, 0.28379655, 0.0638791,
            0.08446726, 0.68760884, 0.2630593, 0.01052708, 0.45302406, 0.10402057, 0.5539082,
            0.39986408, 0.53770447, 0.24856173, 0.12796782,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(kernel26, None, 2, Padding::Valid);
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            0.7490342, 0.25118318, 1.790926, 0.70156175, 0.55293167, 0.5681663, 0.9226165,
            0.2104002, 1.1128749, 0.42610285, 0.34609234, 0.2732251, 0.00656855, 0.01363893,
            0.25699455, 0.04046879, 0.6954827, 0.7375886, 0.82668346, 1.085642, 0.21051455,
            0.10831225, 0.6534306, 0.49931127, 0.57624876, 0.31289116, 0.01077791, 0.03675035,
            1.7145531, 0.9771038, 2.219683, 2.4781058, 1.9884207, 1.71288, 2.2651107, 1.347531,
            1.9382166, 1.8528669, 1.3701423, 1.1117358, 0.27227432, 0.30167982, 0.8715435,
            0.22399044, 1.9608482, 1.3832812, 0.723484, 0.6732574, 1.5947477, 0.86833656,
            1.6538854, 1.6189159, 1.0885673, 0.6532781, 0.43092707, 0.4802809, 1.762125, 1.1655786,
            2.067873, 1.969861, 1.0588335, 1.3895465, 1.6787671, 2.0922842, 2.4418743, 2.455371,
            2.0251374, 1.9791303, 0.64339256, 0.96488917, 1.0131048, 0.4813177, 1.4820337,
            0.95267534, 1.162059, 0.9888602, 1.5041175, 1.1707711, 1.6622107, 1.0406437, 1.669127,
            1.1169736, 0.64448863, 0.7918527, 1.1760106, 1.1038985, 2.0087636, 2.0010715,
            2.0307102, 1.5618633, 1.2097865, 1.3314153, 2.3132024, 1.8469083, 2.6234818, 2.4796758,
            0.94374716, 1.2171946, 1.0185788, 0.5372146, 1.2591047, 1.2482437, 1.2444136,
            1.0011227, 1.2544215, 0.94507724, 1.3533397, 0.994828, 2.050114, 1.5115962, 0.8203379,
            0.70866066, 1.88875, 1.1422997, 2.3809397, 2.411632, 1.8596498, 2.0636983, 1.8096122,
            1.5081367, 2.622436, 2.2012963, 2.1235137, 2.7114096, 0.6101053, 1.0495946, 1.0435535,
            0.161196, 1.75004, 1.3798498, 1.1177843, 1.4418447, 1.2111025, 0.4680285, 2.044618,
            0.9861633, 1.7780662, 1.5849185, 0.47182232, 0.5954891, 2.2886672, 1.4243455, 2.76256,
            2.502285, 2.0103788, 1.6392058, 1.7857754, 1.6421127, 2.7554061, 2.451896, 2.9385366,
            2.4860954, 0.7974972, 0.97089833, 1.2579486, 0.38549054, 1.7774632, 1.1411662,
            1.1753187, 0.78657246, 1.5726604, 1.0540823, 2.0433743, 1.4990172, 1.7345104,
            1.3400185, 0.76142704, 0.8804306, 0.64489126, 1.0984209, 0.79172266, 1.591352,
            0.3750689, 1.0735797, 1.1026659, 1.7074777, 1.6102576, 2.256997, 1.4600608, 2.2231774,
            0.67885154, 1.0472093, 0.95750046, 0.52894616, 0.6716639, 0.5558586, 0.71887517,
            0.51240164, 1.1213763, 0.3864214, 1.2426, 0.5342265, 1.1477861, 0.5490798, 0.26727048,
            0.11068954,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.80071914, 0.38390577, 0.6908975, 0.5850918, 0.71101063, 0.17578217, 0.55867785,
            0.71616316, 0.3247584, 0.9196999, 0.46712968, 0.08430128, 0.83232373, 0.49657014,
            0.24024557, 0.60874844, 0.47418702, 0.9770886, 0.99522823, 0.7749884, 0.7253688,
            0.26021662, 0.8869578, 0.5181486, 0.5871326, 0.76900613, 0.5745777, 0.81429285,
            0.78002185, 0.7069771, 0.33134556, 0.7407027, 0.58577555, 0.40479863, 0.7506117,
            0.11343616, 0.8795398, 0.83064, 0.8858372, 0.3898591, 0.9350765, 0.9673369, 0.64465624,
            0.0283905, 0.22112074, 0.1391855, 0.34128338, 0.65248054, 0.291874, 0.70765275,
            0.32796225, 0.22921298, 0.59572685, 0.5726663, 0.72872376, 0.8248998, 0.29288608,
            0.92347336, 0.25887516, 0.91578674, 0.800785, 0.7670362, 0.8990461, 0.8424308,
            0.7045559, 0.43518323, 0.48451254, 0.31151697, 0.10086012, 0.5242353, 0.19001916,
            0.01069371,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.01020448, 0.12606935, 0.04778918, 0.8456499, 0.57045126, 0.46361542, 0.7532553,
            0.62787765, 0.3127784, 0.9686197, 0.96754897, 0.5766132, 0.6463905, 0.6347338,
            0.52757853, 0.55145216, 0.08155768, 0.13378453, 0.2262157, 0.73179847, 0.5428326,
            0.9094368, 0.2528448, 0.24383228, 0.7446406, 0.5544842, 0.01949351, 0.13375893,
            0.04438103, 0.8489, 0.6848837, 0.9220802,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(kernel27, None, 2, Padding::Valid);
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            0.07990414, 0.21861497, 0.30889404, 1.4802995, 0.28554744, 1.1381233, 0.27117425,
            1.358431, 0.19967146, 0.99481654, 0.32619512, 1.437129, 0.22722729, 0.85654587,
            0.9342141, 1.1711116, 1.4954311, 1.6506131, 1.3741868, 1.5695064, 1.2897961, 1.2756046,
            1.4524844, 1.6424547, 1.3973789, 1.6356566, 0.37699497, 0.34623766, 0.9636664,
            1.4199605, 1.7126397, 2.4500756, 1.3253632, 2.1897945, 1.2453319, 1.870786, 1.6004281,
            2.5808518, 1.6350672, 1.9843905, 0.34056467, 0.77952194, 1.2252511, 2.1001706,
            2.317615, 3.0671859, 2.1092587, 2.9763894, 2.2674317, 2.7109313, 2.256476, 3.0655615,
            2.012525, 3.1960404, 0.9837289, 1.2009244, 0.6870775, 1.0425768, 0.9668402, 2.1925242,
            1.1727216, 1.8658695, 0.82041293, 1.735428, 1.4271774, 2.012641, 1.1849545, 1.7951919,
            0.2705251, 1.3812355, 1.0229734, 1.5531795, 2.5685992, 2.8487315, 1.4850582, 1.7089288,
            1.6590154, 1.8063915, 2.0080132, 2.4214544, 1.93969, 2.596476, 1.3721417, 1.4012542,
            0.5472629, 1.1910044, 1.7808621, 2.975294, 1.0685387, 2.1852, 0.7788191, 1.8832308,
            1.4368839, 2.2136, 1.3833802, 2.7444088, 1.1884716, 1.748345, 1.514264, 1.9002073,
            2.815191, 3.556093, 2.2815986, 2.647635, 2.0252013, 2.5032027, 1.8870928, 2.3889382,
            2.8414292, 3.6102219, 1.5295509, 1.6154941, 0.9252247, 1.5492156, 2.1134048, 3.1614854,
            1.5003471, 2.8265543, 1.7844381, 2.5807095, 1.0348713, 2.773926, 1.9465842, 2.8783038,
            0.65141714, 1.3375876, 1.4452703, 2.2507858, 3.0614948, 4.03093, 3.044697, 3.6509185,
            2.3744042, 3.3428128, 3.0083618, 3.496822, 2.4260356, 3.2192054, 1.5431396, 1.6801699,
            0.82283634, 1.1193236, 1.5537887, 2.3856685, 1.7282561, 2.5427558, 1.553155, 2.3977566,
            1.7339973, 2.5744276, 1.3945119, 2.2596476, 0.70035833, 0.5696149, 0.8670823,
            1.6467097, 2.353054, 3.1543052, 2.367954, 3.1635723, 2.4648464, 3.4346619, 2.5108411,
            3.2218313, 2.0543213, 2.4779122, 0.75918615, 0.8649694, 0.46442544, 0.58960235,
            0.7936819, 1.1460565, 0.98106116, 1.0920862, 1.0857118, 1.034033, 0.7781528, 1.1359532,
            0.773401, 0.5740354, 0.10996349, 0.06683916, 0.23568179, 0.6216189, 0.9992542,
            1.3640764, 0.9872478, 1.1531374, 0.66304415, 1.1179911, 1.0662248, 1.34436, 0.5999463,
            0.670219, 0.06717043, 0.07241507,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.00185038, 0.44556108, 0.00844186, 0.8082305, 0.33159012, 0.5138473, 0.65069795,
            0.9300001, 0.58097035, 0.5413155, 0.5714561, 0.21683556, 0.8548128, 0.02262598,
            0.62476623, 0.33444464, 0.98826236, 0.03221937, 0.12669064, 0.50246465,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.42635268, 0.91064155, 0.7792924, 0.07601635, 0.6067355, 0.3940292, 0.30074376,
            0.1328066, 0.72018456, 0.34319454, 0.6295161, 0.03357495, 0.03066352, 0.51702976,
            0.9283114, 0.36689135, 0.6327302, 0.37459058,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(kernel28, None, 2, Padding::Valid);
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (2, 9, 11),
        vec![
            0.00078891, 0.00168503, 0.19140814, 0.40574643, 0.35082155, 0.00768751, 0.35116994,
            0.7360083, 0.77122223, 0.30195972, 0.25840566, 0.00014066, 0.00112269, 0.03459903,
            0.27033773, 0.1762058, 0.00512198, 0.06476507, 0.49038216, 0.3436727, 0.2011875,
            0.13065618, 0.21963665, 0.46817645, 0.8131964, 0.65172607, 1.227017, 0.84801793,
            1.2215903, 0.6363941, 1.3653358, 0.53698176, 0.6606491, 0.0390608, 0.3117694,
            0.25193453, 0.39480156, 0.32708922, 0.5642641, 0.41061047, 0.35249534, 0.2700681,
            0.32843533, 0.21329412, 0.3981782, 0.58863395, 1.103538, 0.28387645, 1.2817445,
            0.9019382, 1.5202907, 0.09776086, 0.8652061, 0.6408284, 0.87672263, 0.04344001,
            0.3467227, 0.24165343, 0.13156183, 0.1504193, 0.5186453, 0.33854115, 0.01372799,
            0.05640775, 0.37906787, 0.24617614, 0.3144532, 0.38045233, 1.1587442, 0.92875,
            1.1971234, 0.14286508, 0.70155084, 0.11837464, 0.51714563, 0.54053825, 0.8415139,
            0.02542326, 0.20291945, 0.20690505, 0.5996139, 0.39185342, 0.01954864, 0.02232593,
            0.07686771, 0.08811533, 0.30486315, 0.19798574, 0.10058214, 0.04441645, 0.53807557,
            0.13124776, 0.72142106, 0.00427895, 0.06130531, 0.01682535, 0.24235375, 0.06673062,
            0.36186728, 0.00063504, 0.00116484, 0.15297626, 0.2804879, 0.01785689, 0.00531429,
            0.27766377, 0.5087941, 0.14093623, 0.20874132, 0.01113312, 0.00005674, 0.0009567,
            0.0153802, 0.23036835, 0.4138783, 0.00436469, 0.03261987, 0.41787922, 0.76045734,
            0.17144196, 0.3078189, 0.17702846, 0.32464594, 0.40473402, 0.6915448, 0.5110184,
            0.59079146, 0.5303056, 0.87712204, 0.62969565, 0.55057395, 0.14238517, 0.01575637,
            0.26567435, 0.496963, 0.3364302, 0.6325674, 0.48083773, 0.8811443, 0.30037895,
            0.55592006, 0.27987623, 0.50250936, 0.3846467, 0.6848675, 0.52482116, 0.5482177,
            0.88560164, 1.1265576, 0.59798765, 0.3818409, 0.631406, 0.73580706, 0.22374818,
            0.01752286, 0.2954598, 0.53713816, 0.11211044, 0.2275025, 0.44196367, 0.7942263,
            0.01169831, 0.04016149, 0.32302272, 0.57997763, 0.32444185, 0.5721158, 0.64401233,
            0.7593255, 0.43908638, 0.56114846, 0.3730674, 0.09406994, 0.41439354, 0.71161807,
            0.25090176, 0.01025525, 0.17291783, 0.34077236, 0.51096106, 0.91840315, 0.01665838,
            0.03379439, 0.06550283, 0.1330157, 0.25978917, 0.46644366, 0.12270485, 0.21161322,
            0.48786473, 0.62530345, 0.38201478, 0.02038617, 0.05855078, 0.08016099, 0.23180705,
            0.31792456, 0.18821852,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.93406814, 0.33968034, 0.59511477, 0.4350908, 0.7094508, 0.29612544, 0.80898666,
            0.7905302, 0.4748418, 0.6989706, 0.85952836, 0.70326394, 0.38940284, 0.37933362,
            0.22292, 0.3949557, 0.27719194, 0.8619771, 0.9255003, 0.30563155,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.5844432, 0.36121982, 0.09087573, 0.23811613, 0.17829578, 0.9398569, 0.04807154,
            0.7588201, 0.05337733, 0.19222781, 0.98696715, 0.32119673, 0.3872288, 0.74463385,
            0.6260977, 0.0084233, 0.31085488, 0.10247751,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(kernel29, None, 2, Padding::Valid);
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (2, 9, 11),
        vec![
            0.54590976, 0.33740392, 0.283408, 0.12269928, 0.37867948, 0.21496725, 0.30836737,
            0.15716343, 0.45417288, 0.2562677, 0.06447186, 0.2224167, 0.1665404, 0.95877373,
            0.06056357, 0.46095735, 0.10610645, 0.6629249, 0.07757486, 0.57785475, 0.12649208,
            0.6667822, 0.2179706, 0.8157561, 0.5659043, 0.5499783, 0.5822766, 0.73714024,
            0.4020392, 0.50167793, 0.50898856, 0.7908276, 0.10138805, 0.07051224, 0.05279792,
            0.47094834, 0.1442389, 0.94856966, 0.14094819, 0.85605276, 0.08466229, 0.61271954,
            0.12462351, 0.65693235, 0.5165807, 0.5351846, 0.5438237, 0.86790824, 0.37267703,
            0.74053025, 0.32210898, 0.49734235, 0.22370268, 0.6109161, 0.0575672, 0.20466757,
            0.15325028, 0.97529215, 0.125389, 0.75369054, 0.06942888, 0.4563084, 0.06763358,
            0.40960017, 0.0397457, 0.2095129, 0.272148, 0.79489326, 0.27758116, 0.63377804,
            0.5852242, 0.6068499, 0.6582556, 0.622155, 0.29369372, 0.27955636, 0.03967337,
            0.09404532, 0.07041893, 0.43720573, 0.04942215, 0.4657714, 0.15368688, 1.0305116,
            0.16501279, 0.9426136, 0.05449281, 0.28724992, 0.01898613, 0.29970032, 0.03440672,
            0.21033882, 0.05623233, 0.6540856, 0.09050025, 0.7022882, 0.06409291, 0.23191936,
            0.0163138, 0.17955388, 0.92189455, 0.36531568, 0.33525333, 0.22350183, 0.5873587,
            0.27478546, 0.42942032, 0.2761259, 0.7002046, 0.22787328, 0.36169806, 0.69553876,
            0.71635187, 0.2529375, 0.44311863, 0.4431426, 0.54107964, 0.32398334, 0.54712915,
            0.5282811, 0.4441855, 0.06479148, 0.58262575, 0.34920648, 0.90403455, 0.4516282,
            0.9652217, 0.40984434, 0.60390335, 0.33744216, 0.9103973, 0.29720983, 0.11466829,
            0.22050503, 0.49866635, 0.6023989, 0.8126207, 0.58865553, 0.67882156, 0.35358328,
            0.5679589, 0.5204772, 0.4376239, 0.1677196, 0.9403783, 0.4484251, 0.94557583,
            0.39030194, 0.63006794, 0.2830047, 0.52199674, 0.21924038, 0.43729314, 0.14322995,
            0.33283412, 0.6400339, 0.8104727, 0.52367413, 0.5910999, 0.28996253, 0.39069313,
            0.28246465, 0.32382095, 0.16599378, 0.1395697, 0.08316153, 0.65699685, 0.2741486,
            0.49219236, 0.3300779, 0.97179085, 0.49787137, 1.0313561, 0.39676943, 0.37094405,
            0.12101214, 0.15293822, 0.2940974, 0.35461754, 0.2064065, 0.5073316, 0.6418573,
            0.8980622, 0.68915886, 0.6978029, 0.2275836, 0.1913552, 0.00332683, 0.12277391,
            0.04280895, 0.08616646, 0.03566663, 0.2679498, 0.09612904, 0.28769627, 0.09741738,
            0.09500706, 0.03132036,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.60939455, 0.00353958, 0.22236562, 0.31823838, 0.9627444, 0.866447, 0.8205645,
            0.7792785, 0.61566937, 0.59327537, 0.33567885, 0.96525836, 0.47292593, 0.2669342,
            0.705448, 0.28257245, 0.02662205, 0.05098573, 0.8293213, 0.9416077,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.9101412, 0.07020015, 0.8425068, 0.9708137, 0.3117258, 0.11623824, 0.19467542,
            0.09732427, 0.43287596, 0.20617688, 0.8857049, 0.9601851, 0.09430943, 0.28105715,
            0.6942895, 0.07089514, 0.7148581, 0.00085336,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(kernel30, None, 2, Padding::Valid);
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (2, 9, 11),
        vec![
            0.5546351, 0.04277959, 0.5166406, 0.00024848, 0.20536624, 0.0156101, 0.4769864,
            0.02234038, 1.1443514, 0.0675848, 0.8111187, 0.5916086, 0.189964, 0.07427122,
            0.00110338, 0.21628702, 0.0693171, 0.33479756, 0.09920311, 0.97163695, 0.30011228,
            0.11190772, 0.9072232, 0.12013358, 1.7412984, 0.05794824, 1.445406, 0.07634704,
            1.3751035, 0.0741924, 1.3838505, 0.13534641, 0.9165875, 0.84115857, 0.27009386,
            0.8973295, 0.25579113, 0.85191524, 0.24292122, 0.6882822, 0.19192003, 0.6475242,
            0.18493924, 0.06896129, 0.4741911, 0.10789102, 1.696141, 0.14762211, 1.7505752,
            0.10904218, 1.0985777, 0.07865839, 1.2489557, 0.10726264, 0.8511594, 0.32588163,
            0.10463975, 0.97610474, 0.30089593, 0.5713229, 0.14742321, 0.31411543, 0.08321027,
            0.71588653, 0.21990633, 0.08200003, 0.32252926, 0.05250632, 0.5955184, 0.09581193,
            0.5787377, 0.04960638, 1.0544392, 0.08419766, 1.8085877, 0.1347582, 1.0986824,
            0.2743252, 0.08808512, 0.05869077, 0.00829878, 0.05259215, 0.01589357, 0.81104296,
            0.25852084, 1.0105245, 0.2935234, 0.10945082, 0.05500991, 0.02750116, 0.12750147,
            0.00259097, 0.02144971, 0.00496215, 0.18351898, 0.08071309, 0.5423011, 0.09164128,
            0.40759933, 0.12564306, 0.5397437, 0.5858614, 0.00313502, 0.0492453, 0.19695032,
            0.27912554, 0.28186527, 0.50406337, 0.85270745, 0.92441285, 0.05747165, 0.17127469,
            0.42343006, 0.00099482, 0.02342867, 0.06249745, 0.184399, 0.08944317, 0.31174543,
            0.2705862, 0.66842335, 0.22184445, 1.2030469, 1.0019019, 0.72930825, 0.96433073,
            0.8491706, 0.89793974, 0.77279663, 0.7820016, 1.2136925, 0.57047576, 0.08171412,
            0.24352111, 0.67895204, 0.23062553, 0.6432026, 0.2190218, 0.59910834, 0.17303827,
            0.48340422, 0.16674428, 0.41190487, 0.1306361, 0.91669905, 0.58024114, 1.4415212,
            1.0802804, 0.9759464, 0.55344504, 0.67654115, 0.44433904, 1.0489264, 0.67786694,
            0.03165768, 0.09434494, 0.32409126, 0.27129278, 0.71477014, 0.1329192, 0.3535219,
            0.07502376, 0.25186, 0.1982712, 0.48978513, 0.08205791, 0.49023855, 0.3455293,
            0.71360207, 0.07042604, 0.38323328, 0.23927054, 0.925354, 1.0406804, 1.3382818,
            0.9047197, 0.02664925, 0.07941901, 0.19869779, 0.00748232, 0.02329184, 0.01432991,
            0.11361168, 0.23308669, 0.66459155, 0.26464558, 0.65374833, 0.02003301, 0.2019992,
            0.00212851, 0.01903099, 0.00363736, 0.03644757, 0.05883836, 0.59284705, 0.06746312,
            0.6731159, 0.00080353,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );

    let test_input31 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.23516753, 0.04615124, 0.59699446, 0.53420085, 0.75324225, 0.38793716, 0.2669936,
            0.29911962, 0.7380972, 0.17850904, 0.65695775, 0.8119258, 0.26960826, 0.12972821,
            0.6597052, 0.7345929, 0.6485681, 0.22981846, 0.24392553, 0.26706976,
        ],
    )
    .unwrap();

    let kernel31: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.32711208, 0.9581323, 0.31259444, 0.91530424, 0.17250775, 0.715259, 0.5014661,
            0.7273789, 0.23862323, 0.4093651, 0.04974006, 0.8688277, 0.46409306, 0.20740515,
            0.19872624, 0.27135858, 0.02647329, 0.90772045, 0.97377276, 0.47016057, 0.06899374,
            0.47393376, 0.49847803, 0.02369655, 0.10663922, 0.02373338, 0.21085607, 0.56809616,
            0.70259374, 0.4123619, 0.01858313, 0.25862443, 0.4823392, 0.47215322, 0.593886,
            0.8265343, 0.06712108, 0.3228139, 0.11140465, 0.59627575, 0.49184018, 0.8395536,
            0.13370071, 0.25792846, 0.54400545, 0.8792363, 0.58678144, 0.03434712, 0.8123595,
            0.67917913,
        ],
    )
    .unwrap();
    let conv_layer31 = TransposedConvolutionLayer::new(kernel31, None, 2, Padding::Valid);
    let target_output31: Array3<f32> = Array::from_shape_vec(
        (2, 11, 13),
        vec![
            0.07692614, 0.22532162, 0.08860869, 0.25946882, 0.25027895, 0.6142421, 0.36932215,
            1.0582666, 0.51636904, 1.210662, 0.32761312, 0.68944585, 0.12994012, 0.1682057,
            0.11792854, 0.204066, 0.07925972, 0.5568445, 0.31038526, 0.8352259, 0.41034034,
            1.1717184, 0.5051982, 0.7665757, 0.1797411, 0.30835107, 0.13859618, 0.57601523,
            0.32003903, 0.6997682, 0.34607548, 1.0592339, 0.6938058, 1.5689285, 0.7447417,
            1.6118524, 0.63886267, 0.3196164, 0.18048319, 0.34129027, 0.20076299, 0.6991368,
            0.45668057, 0.88141996, 0.27445447, 1.5633644, 1.0369866, 1.7569927, 0.8057744,
            1.3668885, 0.7760832, 0.42722017, 0.2504199, 1.0779569, 0.78468126, 1.7191256,
            0.7604796, 1.6007683, 0.8347349, 1.341711, 1.0956465, 1.42865, 0.8905649, 0.658704,
            0.22960386, 0.57516503, 0.339712, 1.483184, 0.94874954, 1.55827, 0.59685355, 1.2186066,
            0.4402035, 1.53565, 1.0852406, 1.0420223, 0.33124822, 0.35398823, 0.29973656,
            1.4584768, 0.998858, 2.2712002, 1.1205095, 1.364564, 0.7849416, 0.9695937, 0.76199406,
            1.1813226, 0.6252016, 0.3855064, 0.1962084, 0.7036953, 0.38576528, 1.8148786,
            1.1617477, 2.055889, 1.0677782, 1.2688035, 0.44313192, 0.8860628, 0.33592308,
            0.95393646, 0.70613205, 0.41949642, 0.08186467, 0.94958913, 0.7566761, 1.1162189,
            0.95179594, 0.48120528, 0.47760487, 0.32746616, 0.31109217, 0.5983597, 0.5151023,
            0.07102438, 0.12342422, 0.1993381, 0.01944709, 0.84279954, 0.73249626, 0.9964584,
            0.63764197, 0.5797334, 0.23024847, 0.40193945, 0.24459825, 0.35710883, 0.26006526,
            0.12556566, 0.05068231, 0.34814838, 0.41092557, 0.32478565, 0.41748938, 0.12428755,
            0.20055157, 0.12105045, 0.16452532, 0.13235356, 0.15914044, 0.00632863, 0.02848011,
            0.00558132, 0.0495865, 0.1346931, 0.1749585, 0.13736117, 0.15830547, 0.37085965,
            0.53208405, 0.5675322, 0.5341519, 0.6481981, 0.5292233, 0.3106084, 0.00437015,
            0.06082007, 0.11428816, 0.12297095, 0.1730173, 0.17618781, 0.32528952, 0.42003027,
            0.62621033, 0.4470315, 0.6805727, 0.35564575, 0.44734004, 0.20358108, 0.09758361,
            0.34078318, 0.35815588, 0.967307, 0.29587162, 0.9593165, 0.46815595, 1.6978936,
            0.6662931, 0.9674616, 0.20933402, 0.52275044, 0.12287392, 0.2977658, 0.24621996,
            0.3516197, 0.7924593, 0.7165341, 0.68422365, 0.9345923, 1.3036395, 1.1648346,
            0.9157647, 0.27856624, 0.51578194, 0.543003, 0.30255425, 0.78705096, 0.9120341,
            1.9894994, 1.0649208, 1.8784128, 1.0980775, 1.8507932, 1.20041, 1.3146954, 1.095295,
            0.89006436, 0.20301141, 0.49559933, 0.51515025, 0.844384, 1.180648, 0.77307284,
            1.1629092, 0.85767096, 0.5841537, 0.57211167, 0.82064116, 0.3575245, 0.4888996,
            0.90152085, 0.4266234, 1.5639468, 1.2523717, 2.0891368, 1.0050999, 1.9227549,
            0.92773974, 1.3730468, 0.99077237, 1.0500542, 0.40614927, 0.6247352, 0.33676925,
            0.7415349, 0.8535488, 1.3656793, 1.3519129, 0.80142957, 1.0421033, 0.35004804,
            0.7475865, 0.7715595, 0.4324581, 0.29625458, 0.51749223, 1.1847873, 0.4347973,
            1.5096397, 1.1354785, 1.5484684, 0.90545595, 1.337292, 0.33711633, 1.2041248,
            0.5375892, 0.34242836, 0.5656706, 0.6073052, 0.36130232, 0.6167301, 0.41720742,
            0.7339801, 0.59937054, 0.36022907, 0.5035238, 0.26406527, 0.28899115, 0.2871347,
            0.16840424, 0.06888489, 0.14528741, 0.64588076, 0.4310455, 0.59547573, 0.97732127,
            0.72326136, 0.66172373, 0.6628557, 0.32982618, 0.39928347, 0.3548668, 0.17484221,
            0.21695666, 0.1813882,
        ],
    )
    .unwrap();
    let current_output31: Array3<f32> = conv_layer31.transposed_convolve(&test_input31);

    assert!(
        arr_allclose(&current_output31, &target_output31),
        "{:?} was not equal to {:?}",
        current_output31,
        target_output31
    );

    let test_input32 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.02545591, 0.2468276, 0.9191908, 0.02958322, 0.20474248, 0.76555794, 0.82307637,
            0.24628638, 0.17773865, 0.17740512, 0.4937253, 0.9466453, 0.13741271, 0.728613,
            0.5338591, 0.7898385, 0.47936276, 0.23633894, 0.8572216, 0.06004518,
        ],
    )
    .unwrap();

    let kernel32: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.3347224, 0.50485814, 0.09635731, 0.18004768, 0.24514198, 0.228041, 0.05106571,
            0.30884218, 0.38737774, 0.7948706, 0.5052517, 0.23866583, 0.5068071, 0.15044466,
            0.09537497, 0.13518302, 0.7257979, 0.86458087, 0.7176047, 0.09527912, 0.72005635,
            0.7382226, 0.41232714, 0.5491061, 0.7183669, 0.07962471, 0.04476061, 0.19437055,
            0.79608136, 0.6295519, 0.98047, 0.56819236, 0.10505454, 0.9480506, 0.10080674,
            0.9538371, 0.2355401, 0.94827145, 0.46488547, 0.60260093, 0.76637876, 0.3219317,
            0.4168223, 0.25562465, 0.8997145, 0.59076214, 0.22263806, 0.6840723, 0.24348243,
            0.94946456,
        ],
    )
    .unwrap();
    let conv_layer32 = TransposedConvolutionLayer::new(kernel32, None, 2, Padding::Valid);
    let target_output32: Array3<f32> = Array::from_shape_vec(
        (2, 11, 13),
        vec![
            0.00852066, 0.01285162, 0.08507159, 0.1291962, 0.3376977, 0.5085017, 0.15898073,
            0.1804335, 0.29671472, 0.1086923, 0.02698052, 0.03686341, 0.05019098, 0.00580499,
            0.00129992, 0.06414867, 0.02246548, 0.3060781, 0.14255466, 0.48682714, 0.35758474,
            0.78646404, 0.0219152, 0.08674795, 0.07931267, 0.16274378, 0.26911104, 0.3925736,
            0.48688048, 0.6161127, 0.941362, 0.529046, 0.7893357, 0.27942395, 0.34299028,
            0.17488152, 0.16725193, 0.06274379, 0.06301675, 0.17801979, 0.0575696, 0.47950733,
            0.5360053, 1.2589704, 1.1756896, 1.5930661, 0.7855693, 0.43194914, 0.24774203,
            0.37590453, 0.21564695, 0.1605218, 0.57039005, 0.45076588, 1.3565142, 1.0746217,
            1.6547663, 1.2365247, 1.3599312, 0.998632, 1.3057308, 0.6371784, 0.44258937, 0.2352351,
            0.2948715, 0.21608004, 0.58085275, 1.1415098, 1.3863544, 1.533999, 1.143124, 1.2764367,
            0.39617637, 0.65711105, 0.5658167, 0.91434705, 0.33411187, 0.4412519, 1.0650771,
            1.081744, 1.8733996, 1.7124152, 1.9818726, 1.0146097, 1.7760806, 0.93634367, 1.190692,
            0.65024674, 0.75681233, 0.18854147, 0.19307837, 0.24685884, 0.39867845, 0.90808564,
            1.3718176, 1.7138307, 0.97681427, 0.95700055, 0.7627609, 1.1815039, 1.2454647,
            1.2309108, 0.40635994, 0.09859377, 0.7545773, 0.5529866, 1.5277089, 1.203177,
            1.2816342, 0.7497735, 1.8599503, 0.8534782, 1.2708731, 0.93748784, 0.85572493,
            0.30217877, 0.3892335, 0.10677275, 0.5732631, 0.74768096, 0.9147123, 0.521652,
            0.51552725, 0.3658892, 0.79176754, 0.7717726, 0.6587269, 0.13358924, 0.0430887,
            0.00572105, 0.5687282, 0.5830766, 0.67084, 0.78758156, 0.9352255, 0.43769178,
            1.0590552, 0.76259553, 0.5664697, 0.51503235, 0.64055794, 0.03297118, 0.04313447,
            0.00202692, 0.00113942, 0.02460145, 0.03131313, 0.13719213, 0.23763838, 0.33641,
            0.73307484, 0.60073096, 0.03271505, 0.05842008, 0.16299167, 0.12889601, 0.02495875,
            0.01446385, 0.24468131, 0.16437905, 0.9297355, 0.7562822, 0.15045252, 0.88824844,
            0.29651234, 0.14437951, 0.02449132, 0.19410624, 0.02063942, 0.08523811, 0.04026272,
            0.47391158, 0.71625966, 1.7877084, 0.9975126, 1.628791, 0.63830614, 0.9809722,
            0.21141306, 0.3583564, 0.2364107, 0.23506373, 0.77011544, 0.44317925, 1.087201,
            1.2794222, 1.2353523, 1.279268, 0.91099817, 0.5789733, 1.2136905, 0.34278074,
            0.14851215, 0.22052626, 0.20209341, 0.78456867, 0.2080865, 1.8456097, 1.0463334,
            2.7185504, 1.4651489, 2.4603772, 0.5287576, 1.7707405, 0.78113174, 1.0059468,
            0.5573195, 0.6373922, 1.0707902, 0.5269883, 1.9299152, 1.4666232, 1.5045581, 1.2652304,
            1.8036537, 0.66444314, 1.0454614, 1.0966433, 0.36339387, 0.5514746, 0.21343055,
            0.9860868, 0.3220881, 2.5727606, 1.472379, 3.3709128, 1.1198757, 2.8666701, 0.56155133,
            2.0633605, 1.2323459, 1.786757, 0.33917922, 0.5279454, 1.1527935, 0.60772604,
            1.4842615, 1.4521406, 1.3058084, 0.8749695, 2.3810124, 0.9808178, 1.0092248, 1.2049242,
            0.97078985, 0.19339342, 0.48637372, 1.0450515, 0.2959607, 2.1032012, 0.8110663,
            2.353479, 0.5396009, 2.753871, 0.50745517, 1.9568464, 0.7089147, 1.6304921, 0.15789944,
            0.5430636, 0.60531545, 0.25427404, 0.6965958, 0.35622424, 1.0915635, 0.19862193,
            1.1867574, 0.33638084, 0.61596406, 0.23845741, 0.7962829, 0.01534903, 0.05402352,
            0.46660668, 0.17584811, 0.823496, 0.29903618, 1.2174625, 0.16933444, 1.123225,
            0.24839453, 0.8462694, 0.22208673, 0.8549768, 0.01461995, 0.05701077,
        ],
    )
    .unwrap();
    let current_output32: Array3<f32> = conv_layer32.transposed_convolve(&test_input32);

    assert!(
        arr_allclose(&current_output32, &target_output32),
        "{:?} was not equal to {:?}",
        current_output32,
        target_output32
    );

    let test_input33 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.34627816, 0.9748906, 0.7407666, 0.9677088, 0.13005458, 0.69001645, 0.14445187,
            0.9216249, 0.03732051, 0.44508553, 0.666532, 0.9382296, 0.80578685, 0.976145,
            0.6098745, 0.04455515, 0.5690737, 0.6428197, 0.21377262, 0.6692434,
        ],
    )
    .unwrap();

    let kernel33: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.86947584, 0.12576632, 0.8154824, 0.3646563, 0.32867205, 0.00950876, 0.02384425,
            0.68798536, 0.6243543, 0.061506, 0.4878141, 0.24558064, 0.15653013, 0.40195072,
            0.52372193, 0.62839466, 0.67610437, 0.6370576, 0.74306166, 0.8282889, 0.39436254,
            0.45260343, 0.6606655, 0.7309763, 0.40489906, 0.9551375, 0.4431474, 0.6631732,
            0.18731794, 0.43634078, 0.4686375, 0.7620647, 0.57885796, 0.26523942, 0.13030814,
            0.7995473, 0.951001, 0.58605653, 0.82163817, 0.21192186, 0.12197074, 0.06249312,
            0.3968833, 0.23130116, 0.670139, 0.89535373, 0.9697048, 0.7154457, 0.8203782,
            0.21395262,
        ],
    )
    .unwrap();
    let conv_layer33 = TransposedConvolutionLayer::new(kernel33, None, 2, Padding::Valid);
    let target_output33: Array3<f32> = Array::from_shape_vec(
        (2, 11, 13),
        vec![
            0.3010805, 0.04355013, 1.1300275, 0.24888092, 1.5528967, 0.44866347, 1.7659009,
            0.39183038, 1.1456981, 0.36923763, 0.42411608, 0.04742522, 0.0427453, 0.00329268,
            0.00825674, 0.24750431, 0.23944579, 0.6990524, 0.62634015, 0.5787999, 0.4855751,
            0.7125678, 0.6072942, 0.14899555, 0.08120014, 0.00799914, 0.768872, 0.17182004,
            1.218062, 0.648387, 1.8412272, 0.7423606, 1.9300814, 0.8761722, 1.3232114, 0.4904961,
            0.90239346, 0.21457878, 0.2143996, 0.22416055, 0.2505731, 1.30931, 1.350693, 1.5239581,
            1.337404, 2.530809, 1.7810178, 1.3983742, 0.84091175, 1.1929026, 0.37452963, 0.1350982,
            1.0526923, 0.41000864, 2.1510215, 1.3682399, 3.5947769, 1.7757634, 3.3180888,
            1.7756855, 3.2873316, 1.3231999, 1.3851354, 0.49636385, 0.48620874, 0.43994054,
            0.4824161, 0.99783874, 1.0489128, 1.9368473, 1.3354524, 1.3515862, 1.2364285,
            1.7937698, 0.95265806, 0.79408073, 0.71150374, 0.40617034, 0.6359999, 0.48159468,
            1.6059802, 1.1559067, 2.6649182, 1.3860906, 2.6728873, 1.5154798, 2.413152, 0.932985,
            1.5318733, 0.81453025, 0.71958095, 0.41926882, 0.45170757, 1.0502622, 1.1710029,
            2.0565066, 1.6125896, 2.3831468, 1.6651697, 1.8655002, 1.2871022, 1.6706333,
            0.87101936, 0.5463148, 0.28458986, 0.31261656, 1.0949337, 1.0695275, 1.6334944,
            1.4371293, 1.8001373, 1.3416979, 1.9082663, 1.2398494, 1.0148774, 0.7148067,
            0.59743506, 0.02799822, 0.03012393, 0.38598704, 0.41786042, 0.8033817, 0.85747004,
            1.0152042, 0.62218726, 1.0891749, 0.6113246, 0.6034121, 0.49728912, 0.5543269,
            0.01757088, 0.02016581, 0.25385737, 0.29013345, 0.6475117, 0.70692176, 0.73941016,
            0.56664014, 0.6654338, 0.4591646, 0.5287024, 0.48920104, 0.27097604, 0.33074325,
            0.15345226, 1.1607969, 0.49688435, 1.5051506, 0.5108833, 1.8409361, 0.5675965,
            1.0892053, 0.23890257, 0.50849956, 0.02436155, 0.05674811, 0.16227894, 0.26388636,
            0.65731615, 0.8347763, 0.9565971, 0.8230915, 1.0093395, 0.93393725, 0.7176423,
            0.35578454, 0.20138346, 0.0344956, 0.01694717, 0.9359264, 0.6350899, 1.5779815,
            1.4049033, 2.5141602, 1.9409511, 2.124334, 1.7181096, 1.6801119, 1.1230178, 0.59275126,
            0.19023031, 0.22177038, 0.3656034, 0.5474772, 0.7234572, 0.43411976, 1.314764,
            1.0124383, 1.6351452, 0.5047072, 1.2466291, 0.5810425, 0.9626204, 0.148136, 0.14515291,
            1.4983718, 1.2873659, 2.9786644, 2.4743803, 4.0852666, 3.0460868, 4.0816936, 2.9223492,
            3.121793, 1.8270562, 1.3992295, 0.5866336, 0.38826194, 0.39652368, 0.55106175,
            1.1169919, 1.0604111, 1.6397269, 0.95392424, 1.5132855, 1.1731172, 1.642576, 0.7601231,
            0.68188727, 0.26471156, 0.3777408, 1.193289, 1.3227293, 2.3368807, 2.406585, 3.4223485,
            2.9408603, 3.0540287, 2.5977955, 2.9143336, 2.1808646, 1.4278088, 0.99159586,
            0.5164911, 0.10217761, 0.07560757, 0.6714524, 0.6582913, 1.5537872, 0.9081807,
            1.6140468, 0.5807915, 1.5229329, 0.83060414, 1.311455, 0.3185744, 0.49590853,
            0.6324059, 0.6887112, 1.798028, 2.034412, 2.392239, 2.6299734, 2.3194778, 2.3390856,
            2.2134345, 2.2043014, 1.0826985, 1.0502036, 0.27231154, 0.00543442, 0.00278439,
            0.08709353, 0.04586885, 0.33411917, 0.17179921, 0.6625569, 0.16204427, 0.59724945,
            0.09126896, 0.4088689, 0.15479678, 0.44848612, 0.03989262, 0.04320534, 0.54139906,
            0.5883855, 0.99222505, 1.090201, 0.77305955, 0.73465157, 0.8896852, 0.8243429,
            0.52454454, 0.5490327, 0.14318638,
        ],
    )
    .unwrap();
    let current_output33: Array3<f32> = conv_layer33.transposed_convolve(&test_input33);

    assert!(
        arr_allclose(&current_output33, &target_output33),
        "{:?} was not equal to {:?}",
        current_output33,
        target_output33
    );

    let test_input34 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.7457981, 0.7147152, 0.05275504, 0.93545914, 0.8986874, 0.8690856, 0.63580817,
            0.15263815, 0.7466949, 0.6235891, 0.62486136, 0.7352324, 0.23342584, 0.9827126,
            0.93357897, 0.96423954, 0.02081718, 0.47192466, 0.50718915, 0.9034243,
        ],
    )
    .unwrap();

    let kernel34: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.678573, 0.48106775, 0.27722874, 0.0061415, 0.2891619, 0.9937529, 0.02278532,
            0.7661429, 0.23943478, 0.7568481, 0.1846646, 0.05945846, 0.7522374, 0.723256,
            0.5690188, 0.80126184,
        ],
    )
    .unwrap();
    let conv_layer34 = TransposedConvolutionLayer::new(kernel34, None, 2, Padding::Valid);
    let target_output34: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.5060785, 0.35877943, 0.6917431, 0.34840673, 0.23393774, 0.02976817, 0.6494025,
            0.4503432, 0.8691612, 0.43807465, 0.24914199, 0.00551929, 0.21565638, 0.74113905,
            0.22366163, 1.2816381, 0.03153976, 0.5999994, 0.2717012, 0.9700331, 0.2811809,
            1.6097686, 0.02047688, 0.688523, 0.76830804, 0.9825449, 0.981228, 0.8964791,
            0.42445442, 0.15975752, 0.7827261, 1.0712855, 1.0180793, 1.0403652, 0.3388326,
            0.05726434, 0.8123237, 1.4030592, 1.1656625, 2.4121816, 0.50499487, 1.2496339,
            0.95309955, 1.57782, 1.405652, 2.5912971, 0.5255787, 1.1978424, 0.6321034, 0.95836645,
            0.9848623, 0.8904189, 0.5161822, 0.27013716, 0.9385262, 1.0483952, 1.1931347,
            0.97150964, 0.37396976, 0.04281123, 0.83444476, 1.2495291, 1.1996436, 2.3655896,
            0.5608573, 1.4151059, 0.9380275, 1.8177658, 1.1863173, 2.7299578, 0.3761058, 1.214913,
            0.8039205, 0.93678963, 0.57287085, 0.6095489, 0.5176681, 0.44753927, 0.75339705,
            1.004534, 1.1586504, 1.2027313, 0.4228542, 0.06105755, 0.74886537, 1.4101505,
            0.9366172, 1.7918712, 0.7308897, 1.2428658, 1.0294696, 1.7633704, 1.5342473, 2.7489867,
            0.5518088, 1.4401934, 0.23087248, 0.7297829, 0.18304527, 0.07308764, 0.11683937,
            0.35841304, 0.2085865, 0.41192508, 0.3099711, 0.71391165, 0.1668305, 0.05371622,
            0.725337, 0.69739205, 0.56432986, 0.7876645, 0.3668447, 0.35800233, 0.65006065,
            0.7449628, 0.9681897, 1.0597984, 0.5140654, 0.72387946,
        ],
    )
    .unwrap();
    let current_output34: Array3<f32> = conv_layer34.transposed_convolve(&test_input34);

    assert!(
        arr_allclose(&current_output34, &target_output34),
        "{:?} was not equal to {:?}",
        current_output34,
        target_output34
    );

    let test_input35 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.13196982, 0.2549996, 0.9684265, 0.09975351, 0.6575368, 0.01221572, 0.5690517,
            0.8633032, 0.5916843, 0.7327984, 0.38392547, 0.45234743, 0.88714564, 0.48625886,
            0.4974664, 0.280569, 0.3272779, 0.7308698, 0.16297498, 0.8690239,
        ],
    )
    .unwrap();

    let kernel35: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.5834708, 0.33016786, 0.2406453, 0.599151, 0.8538999, 0.30761606, 0.3641591,
            0.11430372, 0.45364544, 0.6984523, 0.7053654, 0.4003387, 0.38632825, 0.91106904,
            0.5180514, 0.1837249,
        ],
    )
    .unwrap();
    let conv_layer35 = TransposedConvolutionLayer::new(kernel35, None, 2, Padding::Valid);
    let target_output35: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.07700054, 0.04357219, 0.18054275, 0.16326253, 0.6264131, 0.47252658, 0.29125056,
            0.61316913, 0.40765876, 0.27686495, 0.15823315, 0.39396384, 0.11268902, 0.04059604,
            0.26580215, 0.09352661, 0.9197997, 0.32705095, 0.43784085, 0.14138053, 0.5977968,
            0.21367109, 0.23944801, 0.0751589, 0.06699502, 0.09620786, 0.54373103, 0.42613932,
            1.2598419, 1.4044688, 1.2813277, 1.1699758, 0.93860376, 1.095648, 0.6401482,
            0.70229435, 0.06141467, 0.12399137, 0.6572424, 0.43301415, 1.4506333, 1.2597638,
            1.3598511, 0.54949677, 1.1469061, 0.91044086, 0.60749304, 0.20456746, 0.22955091,
            0.13529195, 0.6230856, 0.7817258, 1.4195018, 1.3947208, 1.3745644, 1.4509581,
            1.1570573, 1.2042887, 0.6366036, 0.59142506, 0.3325532, 0.129231, 0.7522384, 0.7037232,
            1.5505764, 1.215683, 1.4140983, 0.9486606, 1.1914856, 0.9849469, 0.56078416,
            0.19149557, 0.33786985, 0.3607885, 0.7344878, 0.7458031, 1.2267189, 1.2381197,
            1.1173224, 1.1864979, 1.1149328, 0.92669517, 0.5600221, 0.7198316, 0.3878991,
            0.43609014, 0.75528204, 0.6154024, 1.3203396, 1.1535947, 1.0527599, 0.739681,
            1.2455007, 0.8285184, 0.5741761, 0.19072962, 0.12727883, 0.19596405, 0.34637177,
            0.3409106, 0.5624063, 0.64149976, 0.5894631, 0.4064257, 0.5091857, 0.67221695,
            0.6129794, 0.3479039, 0.10839172, 0.2556177, 0.27178586, 0.34972027, 0.45190245,
            0.726002, 0.44158998, 0.28276044, 0.4201579, 0.82168335, 0.45019904, 0.15966132,
        ],
    )
    .unwrap();
    let current_output35: Array3<f32> = conv_layer35.transposed_convolve(&test_input35);

    assert!(
        arr_allclose(&current_output35, &target_output35),
        "{:?} was not equal to {:?}",
        current_output35,
        target_output35
    );

    let test_input36 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.38816592, 0.16589011, 0.91154295, 0.93466866, 0.9079338, 0.6218017, 0.7199313,
            0.5790186, 0.5812801, 0.5897581, 0.00632351, 0.51240736, 0.3697457, 0.13892107,
            0.9900367, 0.47229373, 0.56468743, 0.59834725, 0.6383385, 0.03793695,
        ],
    )
    .unwrap();

    let kernel36: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.9450343, 0.96132326, 0.6061949, 0.63035446, 0.5111371, 0.03746503, 0.558335,
            0.30164844, 0.68653256, 0.99669343, 0.5127781, 0.25915265, 0.34361982, 0.6647127,
            0.42920145, 0.22015804,
        ],
    )
    .unwrap();
    let conv_layer36 = TransposedConvolutionLayer::new(kernel36, None, 2, Padding::Valid);
    let target_output36: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.3668301, 0.37315294, 0.39207608, 0.40415615, 0.96200114, 0.980857, 1.4358667,
            1.4731139, 1.4246199, 1.4619904, 0.5503848, 0.5723201, 0.19840601, 0.01454265,
            0.30151922, 0.12330472, 0.5585457, 0.08419148, 0.9866902, 0.3099829, 0.9859369,
            0.31595713, 0.5069312, 0.27387682, 0.8541125, 0.9846348, 1.3702248, 1.3499781,
            1.6944798, 1.9619558, 2.0094275, 2.0915918, 2.0123143, 2.0805142, 0.8230769,
            0.60705006, 0.4512074, 0.28131464, 0.9387618, 0.41026485, 1.0823452, 0.8812953,
            1.3328065, 1.0184073, 1.3391416, 1.0067275, 0.7189691, 0.37778854, 0.43286303,
            0.62582463, 1.3011785, 1.3752675, 1.4267211, 1.4421196, 1.0513989, 1.0960312,
            1.7227877, 1.7777631, 0.90257025, 0.77691144, 0.21689557, 0.4135564, 0.77970195,
            0.63654697, 0.98304355, 0.7117991, 0.72570467, 0.6305978, 1.0357478, 0.5989903,
            0.80589724, 0.428483, 0.4506751, 0.46032956, 1.174978, 1.3529114, 1.4243631, 1.4324733,
            1.2509382, 1.2251028, 1.1737374, 1.4616141, 0.53066635, 0.28048435, 0.24357975,
            0.02189782, 0.7311182, 0.5056186, 0.9681002, 0.55133945, 0.8667882, 0.37815094,
            0.77561915, 0.88264966, 0.44610673, 0.22940816, 0.32424504, 0.47073206, 0.6298582,
            0.6852164, 0.7003442, 0.74270904, 0.74505955, 0.79129106, 0.35337096, 0.20323862,
            0.01945324, 0.00983146, 0.16228949, 0.31393966, 0.39674693, 0.47933418, 0.44796863,
            0.52204955, 0.47615725, 0.5560427, 0.2870117, 0.16575253, 0.01628259, 0.00835212,
        ],
    )
    .unwrap();
    let current_output36: Array3<f32> = conv_layer36.transposed_convolve(&test_input36);

    assert!(
        arr_allclose(&current_output36, &target_output36),
        "{:?} was not equal to {:?}",
        current_output36,
        target_output36
    );

    let test_input37 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.22396304, 0.553291, 0.21043801, 0.03016802, 0.13123624, 0.4177692, 0.15363416,
            0.26550946, 0.9799374,
        ],
    )
    .unwrap();

    let kernel37: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.6468661, 0.22700246, 0.28266105, 0.7568015, 0.49555436, 0.7577122, 0.20788053,
            0.91674453, 0.56273526, 0.45675126, 0.48490578, 0.82385767, 0.42006218, 0.8251126,
            0.35886785, 0.09741933, 0.50827706, 0.09494945,
        ],
    )
    .unwrap();
    let conv_layer37 = TransposedConvolutionLayer::new(kernel37, None, 2, Padding::Valid);
    let target_output37: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.1448741, 0.05084016, 0.42121083, 0.12559842, 0.29251903, 0.04776995, 0.05948263,
            0.16949555, 0.11098586, 0.588431, 0.27418578, 0.57849514, 0.10428347, 0.15945144,
            0.06607223, 0.2121651, 0.3344699, 0.53701746, 0.6624384, 0.28775254, 0.23650797,
            0.0228312, 0.01494989, 0.12217846, 0.06503469, 0.41560763, 0.20702735, 0.3165488,
            0.10565207, 0.0625317, 0.2594335, 0.1805814, 0.86963475, 0.6054358, 0.5120836,
            0.11627056, 0.07613408, 0.31734842, 0.13157436, 0.9427978, 0.48561224, 0.7425105,
            0.03193755, 0.14084327, 0.1416496, 0.24340434, 0.35312143, 0.8983522, 0.5514453,
            0.1022954, 0.10860097, 0.43723002, 0.268294, 0.5519509, 0.10204261, 0.17337097,
            0.0940784, 0.18479472, 0.31278977, 0.45652738, 0.28695542, 0.17363505, 0.07551944,
            0.03559761, 0.12846392, 0.15996288, 0.34486234, 0.371972, 0.3095395, 0.3641633,
            0.01267244, 0.02489201, 0.06595372, 0.10828467, 0.2225855, 0.34470662, 0.14992394,
            0.07311154, 0.08983181, 0.26349387, 0.19545144, 0.7194892, 0.6875198, 0.8469959,
            0.0645359, 0.12676547, 0.16666484, 0.21907519, 0.5069174, 0.80855864, 0.35166803,
            0.01496694, 0.07808872, 0.04045323, 0.13495237, 0.12067482, 0.4980797, 0.09304452,
        ],
    )
    .unwrap();
    let current_output37: Array3<f32> = conv_layer37.transposed_convolve(&test_input37);

    assert!(
        arr_allclose(&current_output37, &target_output37),
        "{:?} was not equal to {:?}",
        current_output37,
        target_output37
    );

    let test_input38 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9338919, 0.41674572, 0.12654002, 0.47637334, 0.72644436, 0.22123201, 0.29542014,
            0.46568522, 0.6850643,
        ],
    )
    .unwrap();

    let kernel38: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.6808416, 0.3779981, 0.805789, 0.2891591, 0.6993045, 0.33186397, 0.9734199, 0.9644196,
            0.09362596, 0.0414281, 0.27610767, 0.43870836, 0.34610718, 0.3848816, 0.24301769,
            0.23232727, 0.32100558, 0.22719596,
        ],
    )
    .unwrap();
    let conv_layer38 = TransposedConvolutionLayer::new(kernel38, None, 2, Padding::Valid);
    let target_output38: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.6358325, 0.35300937, 1.0362576, 0.1575291, 0.42196283, 0.04783189, 0.10196456,
            0.27004334, 0.6530748, 0.4304309, 0.29143217, 0.17489308, 0.08849001, 0.04199407,
            1.2334037, 1.0807319, 1.3715551, 0.67651236, 0.89817965, 0.20566297, 0.19011375,
            0.13774768, 0.33313003, 0.36814913, 0.50800586, 0.30505195, 0.15470855, 0.07341893,
            0.6648456, 0.571092, 1.3068405, 0.8766253, 1.1250299, 0.4723135, 0.5727303, 0.08542342,
            0.20658864, 0.23269641, 0.3256558, 0.35263672, 0.47906858, 0.22734816, 0.28756785,
            0.28490898, 0.48096627, 0.44911596, 0.7104554, 0.6606895, 0.06413981, 0.03868936,
            0.2578547, 0.42697117, 0.11506669, 0.18807214, 0.03493867, 0.05551416, 0.3232267,
            0.3594378, 0.37119097, 0.16039775, 0.145073, 0.04870293, 0.03075146, 0.2367038,
            0.43131483, 0.548082, 0.33435458, 0.4519441, 0.1017039, 0.12580572, 0.16487624,
            0.18334733, 0.36719477, 0.27959505, 0.2531088, 0.08514813, 0.05376329, 0.12291321,
            0.23448627, 0.42589867, 0.36177194, 0.44912437, 0.26016822, 0.35080647, 0.10224703,
            0.11370178, 0.23296931, 0.17923367, 0.35027543, 0.26366863, 0.16648275, 0.06863415,
            0.09483151, 0.17530963, 0.14948756, 0.2649609, 0.21990947, 0.15564385,
        ],
    )
    .unwrap();
    let current_output38: Array3<f32> = conv_layer38.transposed_convolve(&test_input38);

    assert!(
        arr_allclose(&current_output38, &target_output38),
        "{:?} was not equal to {:?}",
        current_output38,
        target_output38
    );

    let test_input39 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.85453415, 0.76819396, 0.8545096, 0.653471, 0.6439924, 0.61992764, 0.5419032,
            0.42076096, 0.7094996,
        ],
    )
    .unwrap();

    let kernel39: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.8802664, 0.30416232, 0.00992903, 0.07512625, 0.21167818, 0.9575676, 0.33277866,
            0.5804159, 0.14874539, 0.84465176, 0.33960778, 0.03217437, 0.23459853, 0.86872333,
            0.05481404, 0.4075119, 0.13763186, 0.38947833,
        ],
    )
    .unwrap();
    let conv_layer39 = TransposedConvolutionLayer::new(kernel39, None, 2, Padding::Valid);
    let target_output39: Array3<f32> = Array::from_shape_vec(
        (2, 7, 7),
        vec![
            0.7522177, 0.25991708, 0.6847001, 0.23365566, 0.75982356, 0.25990963, 0.00848445,
            0.06419795, 0.18088622, 0.87598574, 0.16260989, 0.7997937, 0.18088104, 0.81825066,
            0.8595993, 0.6947465, 0.9561198, 0.6417502, 0.9507236, 0.6845296, 0.13325964,
            0.04909283, 0.13832554, 0.67412335, 0.13631915, 0.6632391, 0.13122515, 0.5936226,
            0.6944804, 0.5441115, 0.68727005, 0.5017631, 0.93081605, 0.5756189, 0.09925602,
            0.04071116, 0.11470908, 0.5505191, 0.08906591, 0.4562091, 0.15018559, 0.6793938,
            0.18033382, 0.31452924, 0.22062588, 0.24421635, 0.29869258, 0.41180485, 0.10553479,
            0.72178376, 0.29020643, 0.6763505, 0.26088464, 0.74647915, 0.2901981, 0.02749331,
            0.20047246, 0.74235374, 0.22705765, 0.667348, 0.24257451, 0.7423324, 0.04683912,
            0.9001882, 0.33953494, 1.210845, 0.3244328, 1.1917608, 0.32814, 0.35275874, 0.15330334,
            0.5676855, 0.18689907, 0.5594512, 0.18073393, 0.5385456, 0.03398074, 0.72401667,
            0.273973, 0.8897792, 0.23152757, 1.1162667, 0.32627338, 0.2642761, 0.12712969,
            0.47076395, 0.12841381, 0.36552486, 0.18951118, 0.6163589, 0.03889054, 0.22083199,
            0.07458315, 0.38252467, 0.05791011, 0.4530068, 0.09764975, 0.2763347,
        ],
    )
    .unwrap();
    let current_output39: Array3<f32> = conv_layer39.transposed_convolve(&test_input39);

    assert!(
        arr_allclose(&current_output39, &target_output39),
        "{:?} was not equal to {:?}",
        current_output39,
        target_output39
    );

    let test_input40 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.19455469, 0.2231027, 0.710135, 0.38075933, 0.36192992, 0.5788371, 0.45671245,
            0.02821646, 0.65663046,
        ],
    )
    .unwrap();

    let kernel40: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.6821529, 0.13092387, 0.04243296, 0.40237483, 0.96532, 0.08922233, 0.65666056,
            0.07955468, 0.30693734, 0.61528814, 0.8301079, 0.9080613, 0.10633651, 0.95870477,
            0.24841434, 0.49642795, 0.02807361, 0.67816275, 0.14359485, 0.96717685, 0.970054,
            0.53526694, 0.789418, 0.44380167, 0.1696324, 0.22258878, 0.54548246, 0.33204898,
            0.6242531, 0.39491078, 0.95525235, 0.17685722, 0.4390062, 0.25685027, 0.9619644,
            0.7054154, 0.25693816, 0.06693318, 0.71142703, 0.30001205, 0.24983038, 0.04385825,
            0.83179814, 0.9035203, 0.99454165, 0.4820838, 0.2207663, 0.6613494, 0.6531026,
            0.941437,
        ],
    )
    .unwrap();
    let conv_layer40 = TransposedConvolutionLayer::new(kernel40, None, 2, Padding::Valid);
    let target_output40: Array3<f32> = Array::from_shape_vec(
        (2, 9, 9),
        vec![
            0.13271604, 0.02547185, 0.16044569, 0.10749337, 0.6816951, 0.18274453, 0.24549863,
            0.28574044, 0.6855075, 0.01735862, 0.12775639, 0.03538348, 0.20621884, 0.20081595,
            0.5347962, 0.19376701, 0.21796694, 0.43693763, 0.42123747, 0.22651806, 0.46893588,
            0.5897047, 1.4393106, 1.0801508, 0.5048751, 0.9137193, 0.7351707, 0.13055462,
            0.25549147, 0.3052776, 0.3887347, 1.0067147, 0.54316175, 0.96610725, 0.27963844,
            1.0429777, 0.8163476, 0.50968605, 0.74956375, 1.0869173, 2.4015563, 1.4490508,
            0.80499953, 1.1343045, 0.8981118, 0.22976853, 0.31059435, 0.4767401, 0.2235465,
            1.2429005, 0.5080653, 0.8121953, 0.28466243, 0.9638548, 0.7484777, 0.6185308,
            0.7236577, 0.8261854, 1.5733349, 1.0937694, 0.59517264, 0.8864036, 0.26130596,
            0.22672483, 0.01282157, 0.32373282, 0.06637369, 0.7868268, 0.02248573, 0.47259262,
            0.09428875, 0.6350778, 0.44303572, 0.24446307, 0.38790852, 0.21779309, 0.7367148,
            0.3639951, 0.52314234, 0.2914137, 0.1113858, 0.04330569, 0.10612617, 0.11426184,
            0.24314997, 0.30898082, 0.52663875, 0.32390526, 0.44330397, 0.28043997, 0.18584882,
            0.0344084, 0.2985301, 0.08942875, 0.9634563, 0.1828965, 0.5263705, 0.18239836,
            0.6831246, 0.22199462, 0.25768608, 0.37739453, 0.6308517, 0.97362894, 0.8828634,
            0.44959742, 0.8665501, 0.44163805, 0.41232693, 0.07587287, 0.7304582, 0.34737706,
            1.6345844, 0.42805642, 1.4148507, 0.79029584, 1.2630795, 0.4640442, 0.38991132,
            0.6749508, 0.8406896, 1.5557209, 1.0844895, 1.0561876, 1.2854949, 1.1015159,
            0.53140086, 0.09747232, 0.63458943, 0.48219436, 1.9033208, 0.47577503, 1.156838,
            0.69164675, 1.2073327, 0.5057299, 0.20140569, 0.47676906, 0.6607443, 1.4789761,
            0.55295247, 0.7759634, 0.8451847, 0.74193573, 0.11410064, 0.02003061, 0.38694188,
            0.4138865, 0.6417362, 0.05429281, 0.57424647, 0.59327894, 0.6530463, 0.22017367,
            0.10082672, 0.3156492, 0.30450934, 0.76517785, 0.16339013, 0.4608262, 0.42884704,
            0.6181762,
        ],
    )
    .unwrap();
    let current_output40: Array3<f32> = conv_layer40.transposed_convolve(&test_input40);

    assert!(
        arr_allclose(&current_output40, &target_output40),
        "{:?} was not equal to {:?}",
        current_output40,
        target_output40
    );

    let test_input41 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.02962555, 0.00604056, 0.6749602, 0.09254023, 0.16296797, 0.7694261, 0.49170363,
            0.04446485, 0.8114944,
        ],
    )
    .unwrap();

    let kernel41: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.29030007, 0.1919063, 0.18254054, 0.13724734, 0.00911832, 0.20514874, 0.59104544,
            0.815183, 0.26495343, 0.62743604, 0.94401777, 0.54503894, 0.6431647, 0.52856827,
            0.51207054, 0.03335644, 0.28076503, 0.07791043, 0.86478263, 0.980501, 0.54355013,
            0.03467919, 0.886572, 0.36146563, 0.13580918, 0.8819829, 0.48148784, 0.09721047,
            0.7819647, 0.49357224, 0.6708243, 0.72222507, 0.366483, 0.37231642, 0.11044633,
            0.88196933, 0.7812372, 0.2546282, 0.8222847, 0.328725, 0.78940445, 0.46583235,
            0.3009351, 0.90517753, 0.7002328, 0.750793, 0.75040495, 0.53337294, 0.51972127,
            0.72387767,
        ],
    )
    .unwrap();
    let conv_layer41 = TransposedConvolutionLayer::new(kernel41, None, 2, Padding::Valid);
    let target_output41: Array3<f32> = Array::from_shape_vec(
        (2, 9, 9),
        vec![
            0.0086003, 0.00568533, 0.00716144, 0.00522525, 0.19731376, 0.13035817, 0.12326268,
            0.09263649, 0.0061545, 0.00607764, 0.01751005, 0.02538946, 0.01141964, 0.16197954,
            0.40053263, 0.55400616, 0.17883302, 0.42349434, 0.05483148, 0.03390613, 0.08895846,
            0.06292695, 0.9101864, 0.5410971, 0.5791412, 0.4623642, 0.3526431, 0.01997271,
            0.0630133, 0.11137953, 0.14815596, 0.40079135, 0.6926737, 0.78798425, 0.78755593,
            1.1445649, 0.2462042, 0.14582644, 0.34557578, 0.22467391, 1.5029848, 0.69293094,
            1.326076, 0.7620446, 0.4930657, 0.1039592, 0.31660125, 0.4225962, 0.2823422,
            0.64033467, 0.848371, 0.9091518, 0.8803946, 1.2635839, 0.5144772, 0.27120686,
            0.52884686, 0.3232357, 1.6217227, 0.55138916, 1.2489779, 0.7070513, 0.5200375,
            0.01640148, 0.13805318, 0.03979203, 0.43770093, 0.51264876, 0.26629168, 0.10682171,
            0.70176625, 0.7956711, 0.2672656, 0.01705188, 0.46009955, 0.17927596, 0.54728705,
            0.04421448, 0.72548693, 0.29332733, 0.11020839, 0.02612923, 0.01426434, 0.00820759,
            0.02607459, 0.6105129, 0.32970864, 0.06859465, 0.5277951, 0.33314162, 0.01987354,
            0.02139632, 0.01490942, 0.01539272, 0.45826548, 0.48972216, 0.24802859, 0.25129876,
            0.07454687, 0.10774773, 0.06770158, 0.16560194, 0.17991003, 1.346709, 1.0301756,
            0.3290823, 1.1566734, 0.6016437, 0.08546478, 0.08063541, 0.1569211, 0.18178406,
            1.1414746, 0.9362606, 0.50732976, 0.89742875, 0.55760956, 0.53753453, 0.33127636,
            0.27464873, 0.6292451, 2.2446873, 1.6702378, 0.71469975, 1.6180384, 1.1420493,
            0.4028984, 0.3982289, 0.36652535, 0.37486404, 1.3362036, 1.1085751, 0.6479727,
            0.9985999, 0.62840396, 0.50314605, 0.45357978, 0.3361319, 0.60944504, 1.6202607,
            1.3326114, 0.749606, 1.0671666, 0.82372886, 0.38815305, 0.22905146, 0.18307163,
            0.46579227, 0.99828535, 0.41826892, 0.27534288, 0.7345465, 0.568235, 0.36916763,
            0.36897683, 0.29564533, 0.2889155, 0.9889139, 0.63205874, 0.46501628, 0.4217509,
            0.58742267,
        ],
    )
    .unwrap();
    let current_output41: Array3<f32> = conv_layer41.transposed_convolve(&test_input41);

    assert!(
        arr_allclose(&current_output41, &target_output41),
        "{:?} was not equal to {:?}",
        current_output41,
        target_output41
    );

    let test_input42 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9831707, 0.20632543, 0.16955712, 0.76152086, 0.05444199, 0.2814817, 0.15761587,
            0.95890856, 0.90069485,
        ],
    )
    .unwrap();

    let kernel42: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.01261302, 0.21181779, 0.78206104, 0.92161584, 0.74544144, 0.8816592, 0.9976662,
            0.2966056, 0.2162454, 0.06208929, 0.50320554, 0.6565798, 0.5351854, 0.10227188,
            0.28489798, 0.20003575, 0.1822242, 0.05310873, 0.13790856, 0.78958035, 0.5917116,
            0.38009274, 0.2742251, 0.9041115, 0.99974847, 0.9090851, 0.4171188, 0.48332873,
            0.169661, 0.15740211, 0.04401799, 0.33348852, 0.42292982, 0.4798304, 0.90991354,
            0.54084134, 0.4826352, 0.5674032, 0.6246967, 0.70394504, 0.12639284, 0.16602974,
            0.4649844, 0.36747122, 0.75747913, 0.91581804, 0.02039539, 0.51063865, 0.6296097,
            0.55201155,
        ],
    )
    .unwrap();
    let conv_layer42 = TransposedConvolutionLayer::new(kernel42, None, 2, Padding::Valid);
    let target_output42: Array3<f32> = Array::from_shape_vec(
        (2, 9, 9),
        vec![
            0.01240075, 0.20825304, 0.7715019, 0.9498091, 0.89639384, 0.22606799, 0.28640753,
            0.15626653, 0.12639491, 0.86682147, 0.98087615, 0.4735226, 0.41845003, 0.27173322,
            0.21377833, 0.06310219, 0.03666595, 0.01052768, 0.504342, 0.8068336, 1.2262452,
            0.9493813, 1.0896443, 0.24222651, 0.41024542, 0.27675894, 0.25813463, 0.86807114,
            0.9389011, 0.36735803, 0.39217547, 1.1327684, 0.35194907, 0.25878477, 0.08425251,
            0.15135598, 0.966943, 0.90708107, 0.9620055, 1.4293215, 2.4063463, 1.5159001,
            1.8381343, 1.0121808, 0.9211233, 0.29129487, 0.29601556, 0.9435141, 1.1056952,
            1.7487893, 1.1647532, 0.38462454, 0.23358986, 0.27817592, 0.5299139, 0.39293596,
            0.8079238, 1.3549124, 1.9541477, 0.8456582, 0.88684744, 0.3466066, 0.53801703,
            0.03152881, 0.02872143, 0.20018676, 0.19647293, 0.355548, 0.2963701, 0.8049701,
            0.12421353, 0.711171, 0.09326313, 0.05990865, 0.61061954, 0.5069765, 0.95348454,
            1.2093079, 1.2056605, 0.81432855, 0.9004683, 0.89378583, 0.41009897, 0.662762,
            0.25286794, 0.408618, 0.10573085, 0.11442788, 0.02876723, 0.02668865, 0.0432772,
            0.32787615, 0.4248942, 0.5405624, 0.98932505, 0.15554658, 0.25944906, 0.08135866,
            0.15428232, 1.2240267, 0.7921574, 1.0870008, 0.8656726, 1.3029406, 0.33737305,
            0.3860665, 0.15367824, 0.16366471, 0.15778635, 0.41719404, 0.8077034, 0.77909976,
            1.5904337, 0.22396404, 0.40371314, 0.19737084, 0.38456, 1.4555537, 0.4533335, 2.100445,
            1.5519371, 2.8296444, 0.84161156, 0.9847802, 0.4354083, 0.4335164, 0.10318872,
            0.17899819, 0.46984607, 0.6842899, 1.2263427, 0.82722515, 1.425578, 0.53561723,
            1.032771, 0.7826597, 0.09160248, 1.0467701, 1.0418365, 1.8481283, 1.0737522, 1.3598641,
            0.7398847, 0.78942084, 0.01992152, 0.02616892, 0.1944881, 0.21712662, 0.67910963,
            0.5019134, 1.1451623, 0.33097944, 0.68225753, 0.14434746, 0.00321464, 0.9586705,
            0.11879379, 1.4015341, 0.62210816, 0.98925817, 0.5670862, 0.49719396,
        ],
    )
    .unwrap();
    let current_output42: Array3<f32> = conv_layer42.transposed_convolve(&test_input42);

    assert!(
        arr_allclose(&current_output42, &target_output42),
        "{:?} was not equal to {:?}",
        current_output42,
        target_output42
    );

    let test_input43 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.25472447, 0.48130554, 0.324559, 0.66492975, 0.01730853, 0.77949584, 0.13672462,
            0.73892075, 0.02376527,
        ],
    )
    .unwrap();

    let kernel43: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.8798877, 0.6356067, 0.22369854, 0.584571, 0.96449506, 0.7977554, 0.32541806,
            0.10196066, 0.8232674, 0.8543414, 0.9710584, 0.505133, 0.04858193, 0.16233306,
            0.651015, 0.62667716,
        ],
    )
    .unwrap();
    let conv_layer43 = TransposedConvolutionLayer::new(kernel43, None, 2, Padding::Valid);
    let target_output43: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.22412893, 0.16190459, 0.48047632, 0.45482558, 0.39324284, 0.48764914, 0.07260337,
            0.18972778, 0.2456805, 0.20320784, 0.54710877, 0.40993595, 0.46966106, 0.30799294,
            0.10561736, 0.03309225, 0.7947699, 0.64025545, 0.8075689, 0.939569, 1.4243155,
            1.0259783, 0.48953784, 0.6196161, 0.6536965, 0.5718015, 0.42228633, 0.31936646,
            1.0865573, 0.9779216, 0.4649548, 0.2828716, 0.6677173, 0.6549801, 1.3406875, 0.9002536,
            0.8447474, 1.1217557, 0.7622523, 0.40764153, 0.1641738, 0.21701288, 1.1908982,
            1.0229245, 0.31251714, 0.23168452, 0.5151971, 0.49091533, 0.11256092, 0.1168095,
            0.741097, 0.7003547, 0.73710036, 0.39355686, 0.02307746, 0.01200462, 0.00664235,
            0.02219493, 0.12490797, 0.20563346, 0.48220304, 0.46692264, 0.01547154, 0.01489315,
        ],
    )
    .unwrap();
    let current_output43: Array3<f32> = conv_layer43.transposed_convolve(&test_input43);

    assert!(
        arr_allclose(&current_output43, &target_output43),
        "{:?} was not equal to {:?}",
        current_output43,
        target_output43
    );

    let test_input44 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.04012987, 0.8986551, 0.5988572, 0.7548613, 0.9230523, 0.8094736, 0.41193417,
            0.11411006, 0.29621908,
        ],
    )
    .unwrap();

    let kernel44: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.8657136, 0.3099813, 0.7817938, 0.5514695, 0.9309671, 0.35345063, 0.04673942,
            0.2836077, 0.4491099, 0.16020048, 0.0033604, 0.7036799, 0.09309967, 0.8027366,
            0.66168624, 0.75922126,
        ],
    )
    .unwrap();
    let conv_layer44 = TransposedConvolutionLayer::new(kernel44, None, 2, Padding::Valid);
    let target_output44: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.03474097, 0.01243951, 0.8093512, 0.30069667, 1.2210019, 0.6812154, 0.46818286,
            0.3302515, 0.03735959, 0.01418393, 0.838494, 0.32901135, 0.599519, 0.46653196,
            0.02799024, 0.16984051, 0.6715164, 0.2404217, 1.7929746, 0.8746155, 1.6943814,
            1.4882597, 0.6348538, 0.8678038, 0.7064871, 0.2990199, 1.004831, 1.2921886, 1.4471173,
            1.7108963, 0.4340899, 0.6842381, 0.6956327, 0.24862102, 0.8379228, 0.94159526,
            0.7122959, 0.93396205, 0.2343024, 0.73296607, 0.45377448, 0.7515532, 0.71090347,
            1.4712346, 0.9672364, 1.4876564, 0.5494626, 0.69857955, 0.18500371, 0.06599205,
            0.05263222, 0.3081503, 0.13341838, 0.1277514, 0.00099542, 0.20844342, 0.03835094,
            0.33067462, 0.28319478, 0.4043495, 0.10308295, 0.3244207, 0.1960041, 0.22489582,
        ],
    )
    .unwrap();
    let current_output44: Array3<f32> = conv_layer44.transposed_convolve(&test_input44);

    assert!(
        arr_allclose(&current_output44, &target_output44),
        "{:?} was not equal to {:?}",
        current_output44,
        target_output44
    );

    let test_input45 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.98626304, 0.41794768, 0.85175455, 0.6952307, 0.8909816, 0.77955645, 0.25186005,
            0.6967979, 0.44887283,
        ],
    )
    .unwrap();

    let kernel45: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.443149, 0.75464064, 0.81323266, 0.85127234, 0.15431848, 0.56885445, 0.29611066,
            0.87579244, 0.9531821, 0.5536974, 0.53754663, 0.23263316, 0.527793, 0.6797737,
            0.74194604, 0.01885639,
        ],
    )
    .unwrap();
    let conv_layer45 = TransposedConvolutionLayer::new(kernel45, None, 2, Padding::Valid);
    let target_output45: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.4370615, 0.74427414, 0.9872744, 1.1549788, 0.71734285, 0.9985559, 0.69267464,
            0.72507507, 0.15219861, 0.5610401, 0.35654005, 1.1015131, 0.25520024, 0.85055983,
            0.2522136, 0.7459602, 1.2481791, 1.0707407, 1.8887646, 1.7250557, 2.1065786, 1.9155958,
            1.0918186, 0.8617612, 0.6278297, 1.0659208, 1.295704, 1.4184239, 1.1437738, 1.8106505,
            0.8627909, 0.69879067, 0.774293, 0.57501125, 1.7365928, 1.3953015, 1.9875798,
            1.5708127, 0.784086, 0.5634637, 0.40580457, 0.6158713, 1.1681848, 1.2357291, 1.3481033,
            1.4123163, 0.71130484, 0.40781903, 0.2400685, 0.13945426, 0.7995618, 0.4444062,
            0.80241895, 0.41063803, 0.24129008, 0.1044227, 0.13292997, 0.17120783, 0.5546316,
            0.47841406, 0.7538984, 0.31827104, 0.33303943, 0.00846412,
        ],
    )
    .unwrap();
    let current_output45: Array3<f32> = conv_layer45.transposed_convolve(&test_input45);

    assert!(
        arr_allclose(&current_output45, &target_output45),
        "{:?} was not equal to {:?}",
        current_output45,
        target_output45
    );

    let test_input46 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.08134871, 0.6701397, 0.42471457, 0.93320847, 0.6966494, 0.5644708, 0.03809474,
            0.09368633, 0.5213245, 0.7867202, 0.5103296, 0.05583452,
        ],
    )
    .unwrap();

    let kernel46: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.7863488, 0.5674216, 0.06023929, 0.39982173, 0.32429224, 0.11995548, 0.8987073,
            0.1602559, 0.33672985, 0.742261, 0.14132027, 0.06929818, 0.4782574, 0.5697997,
            0.11632108, 0.49556065, 0.47647962, 0.7417032, 0.34966558, 0.47131556, 0.9838283,
            0.6777289, 0.90295655, 0.67075133, 0.0573609, 0.8237337, 0.36602104, 0.15022676,
            0.66375136, 0.17951131, 0.7120909, 0.48833874, 0.85454535, 0.18296848, 0.10698621,
            0.61914563, 0.5212063, 0.922373, 0.6521379, 0.45965454, 0.3666493, 0.99957263,
            0.63527644, 0.17045999, 0.32906872, 0.39238515, 0.8330784, 0.24240606, 0.16471672,
            0.39931872, 0.18019378, 0.04206449, 0.4967664, 0.8137173, 0.2356948, 0.4160782,
            0.9648439, 0.08041501, 0.65951824, 0.8111227, 0.5044555, 0.5347742, 0.6593625,
            0.2873256, 0.93752426, 0.7753997, 0.7233747, 0.5849598, 0.73156756, 0.514743,
            0.9262702, 0.2988856, 0.6292863, 0.3348592, 0.68505603, 0.09462127, 0.39446756,
            0.7353366, 0.06431016, 0.30438656, 0.65234166, 0.58759433, 0.62632954, 0.4344534,
            0.21980144, 0.00100083, 0.6921164, 0.8472264, 0.3598078, 0.8860002, 0.3531883,
            0.25727805, 0.25435162, 0.7503538, 0.4171089, 0.7314984,
        ],
    )
    .unwrap();
    let conv_layer46 = TransposedConvolutionLayer::new(kernel46, None, 2, Padding::Valid);
    let target_output46: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.1480414, 0.57785875, 2.203444, 1.862361, 0.66985285, 1.0776258, 0.77086294,
            0.92067695, 2.0973732, 1.4950693, 1.6990877, 0.60199475, 1.4558548, 1.5749757,
            3.003941, 2.5806823, 1.0988749, 0.68088305, 1.0047241, 1.0518293, 2.711486, 2.0149102,
            1.5502894, 0.91769665, 0.47812492, 0.52421606, 0.8175509, 0.88924086, 0.22964777,
            0.08592255, 0.41696715, 0.63221407, 0.6131265, 0.9846039, 0.1901906, 0.5021668,
            0.4935925, 0.64484906, 1.4059937, 1.4788572, 0.828785, 0.6813847, 0.54069304,
            0.6225298, 1.7111028, 1.7003853, 1.2826518, 1.3508912, 1.4059527, 1.2150153, 2.511005,
            3.191731, 1.2735878, 1.2289679, 1.0869652, 1.0976814, 3.386996, 3.075565, 2.0809112,
            1.7771628, 0.24473806, 0.80506724, 0.52483314, 1.0517181, 0.42308187, 0.230549,
            0.43092513, 0.4795409, 1.2212971, 0.8511736, 0.7495916, 0.52348316,
        ],
    )
    .unwrap();
    let current_output46: Array3<f32> = conv_layer46.transposed_convolve(&test_input46);

    assert!(
        arr_allclose(&current_output46, &target_output46),
        "{:?} was not equal to {:?}",
        current_output46,
        target_output46
    );

    let test_input47 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.4653744, 0.71255463, 0.95627284, 0.9875905, 0.22617352, 0.7417731, 0.37862286,
            0.5094745, 0.18060002, 0.9620671, 0.49016726, 0.45882288,
        ],
    )
    .unwrap();

    let kernel47: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.75507283, 0.45673513, 0.9690947, 0.10567724, 0.2728893, 0.70271283, 0.8472397,
            0.55496895, 0.91851914, 0.9672113, 0.64802116, 0.21997769, 0.3842727, 0.94689554,
            0.74909705, 0.3282922, 0.2643334, 0.3491095, 0.3052412, 0.5038705, 0.37622157,
            0.04119791, 0.7131295, 0.14328648, 0.13365868, 0.36297327, 0.68727154, 0.93408334,
            0.21441843, 0.91439056, 0.40976977, 0.9953925, 0.3781238, 0.28116077, 0.97598535,
            0.36442432, 0.14792818, 0.83921397, 0.625257, 0.09807894, 0.3419448, 0.9480976,
            0.12152596, 0.29696485, 0.41873357, 0.95614773, 0.47523478, 0.25687808, 0.7602087,
            0.78506595, 0.43647116, 0.97631705, 0.26839125, 0.08090039, 0.48662946, 0.70590997,
            0.99664134, 0.77797663, 0.2436962, 0.6407154, 0.34835714, 0.8761795, 0.19121103,
            0.5305259, 0.6565131, 0.5287279, 0.29444507, 0.775589, 0.24550702, 0.9532204,
            0.8754091, 0.341333, 0.6382999, 0.5125449, 0.5005919, 0.937352, 0.6224484, 0.14624618,
            0.8417525, 0.9414587, 0.44898897, 0.6993321, 0.36183158, 0.24969168, 0.9671642,
            0.20102102, 0.799053, 0.29777643, 0.05473179, 0.82243276, 0.49220118, 0.959262,
            0.60974807, 0.82510734, 0.77621484, 0.31383017,
        ],
    )
    .unwrap();
    let conv_layer47 = TransposedConvolutionLayer::new(kernel47, None, 2, Padding::Valid);
    let target_output47: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.55547947, 0.37163225, 2.175033, 1.314352, 1.6977686, 1.0917896, 0.20479171,
            0.68898416, 1.234171, 2.3823855, 1.9097058, 0.7965833, 1.8070943, 1.559498, 4.6218405,
            3.6804981, 2.6229048, 1.924711, 0.82325643, 2.1402965, 3.724913, 4.1996202, 3.2530475,
            2.0848799, 1.3206967, 1.535122, 2.2852707, 2.4556632, 0.9315769, 0.7986224, 0.8311155,
            1.3391949, 2.1873071, 2.3620481, 1.3681364, 0.8870539, 0.3760405, 0.46632713,
            1.4903283, 2.0043046, 0.8893699, 1.3234612, 0.41045675, 0.07377438, 1.9838846,
            0.5628797, 1.637855, 0.9122054, 1.0581868, 1.4672852, 2.8399005, 4.4193125, 1.8338572,
            3.173316, 1.2241563, 0.9412781, 3.5818465, 3.4595785, 2.4994183, 2.0425053, 0.5319931,
            1.0447909, 1.6556246, 2.738206, 1.028733, 1.6890514, 0.63581705, 1.6105891, 1.5137267,
            3.0345778, 0.85824704, 1.397322,
        ],
    )
    .unwrap();
    let current_output47: Array3<f32> = conv_layer47.transposed_convolve(&test_input47);

    assert!(
        arr_allclose(&current_output47, &target_output47),
        "{:?} was not equal to {:?}",
        current_output47,
        target_output47
    );

    let test_input48 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.20135997, 0.40562743, 0.25492424, 0.5874371, 0.69954115, 0.11803117, 0.95850575,
            0.9031762, 0.8240507, 0.7735656, 0.5868046, 0.50450677,
        ],
    )
    .unwrap();

    let kernel48: Array4<f32> = Array::from_shape_vec(
        (3, 2, 4, 4),
        vec![
            0.31319898, 0.23300357, 0.8095447, 0.34135282, 0.24274388, 0.6729072, 0.57593447,
            0.8085596, 0.7018395, 0.76145005, 0.58241343, 0.3309161, 0.67546684, 0.32411024,
            0.3949699, 0.412044, 0.8408538, 0.76511306, 0.8994237, 0.8364367, 0.38108206,
            0.69459295, 0.8441607, 0.40802577, 0.95296425, 0.72987187, 0.07076582, 0.8826578,
            0.44925806, 0.8213124, 0.6112075, 0.96117723, 0.3876701, 0.88056743, 0.9483631,
            0.8974017, 0.4120727, 0.27696642, 0.69025475, 0.42224765, 0.96611446, 0.04551166,
            0.40275672, 0.19091433, 0.4437527, 0.31289253, 0.2396215, 0.6389319, 0.85605,
            0.27247688, 0.19161025, 0.50402254, 0.5852498, 0.97299683, 0.594723, 0.38096267,
            0.29591832, 0.28942943, 0.4529504, 0.19683413, 0.1757779, 0.88774997, 0.5229589,
            0.7137983, 0.82603574, 0.8461087, 0.9091735, 0.80568945, 0.79286724, 0.3410004,
            0.32917508, 0.17503856, 0.7846004, 0.7272445, 0.48829708, 0.9584728, 0.7469263,
            0.66009414, 0.59341496, 0.42636782, 0.9874962, 0.85196227, 0.43363968, 0.02657376,
            0.11542477, 0.13354255, 0.5618466, 0.070237, 0.35689688, 0.27853093, 0.8144841,
            0.99201185, 0.6685596, 0.5670808, 0.68718493, 0.73198694,
        ],
    )
    .unwrap();
    let conv_layer48 = TransposedConvolutionLayer::new(kernel48, None, 2, Padding::Valid);
    let target_output48: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.0149523, 1.3601472, 2.3874261, 2.2134008, 1.1436152, 0.8676371, 0.99050355,
            0.6102476, 1.6305246, 1.1718583, 0.5697249, 0.51321614, 2.3998573, 2.1843767, 4.406809,
            4.64584, 2.4522903, 2.3157148, 1.9840539, 1.46521, 3.5566936, 3.091341, 1.7753568,
            1.5170238, 1.5653493, 0.6644857, 2.5017452, 1.6850961, 0.9522407, 0.8503777, 1.0358322,
            0.76987916, 1.8529952, 1.7736678, 0.7478223, 1.0342234, 1.5819035, 1.0467321,
            1.8784952, 1.5444679, 0.7228956, 0.4193286, 0.5812568, 0.9305604, 1.3619472, 0.9064318,
            0.8472358, 0.26480484, 2.3073473, 1.5351102, 4.13256, 3.5158744, 1.6324105, 2.1086307,
            1.4901977, 2.4417555, 3.7009473, 4.0372477, 2.157717, 1.6595712, 0.73600185, 0.626925,
            1.9372683, 1.8264749, 0.8615772, 1.1967585, 0.6753248, 1.3930515, 1.820276, 2.9291005,
            1.1780593, 1.5786091,
        ],
    )
    .unwrap();
    let current_output48: Array3<f32> = conv_layer48.transposed_convolve(&test_input48);

    assert!(
        arr_allclose(&current_output48, &target_output48),
        "{:?} was not equal to {:?}",
        current_output48,
        target_output48
    );

    let test_input49 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.84016347, 0.55920875, 0.27009216, 0.10123584, 0.2636, 0.9657689, 0.005051, 0.5576874,
            0.9025137, 0.55897933, 0.35369453, 0.9429427,
        ],
    )
    .unwrap();

    let kernel49: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.5162179, 0.5906877, 0.05157892, 0.76241785, 0.07249359, 0.45541912, 0.01278013,
            0.4782056, 0.76319754, 0.5541978, 0.04795831, 0.5815242, 0.27330735, 0.8815459,
            0.29006037, 0.23429064, 0.18781203, 0.94584274, 0.4523076, 0.29750833, 0.17197818,
            0.06818328, 0.6987018, 0.6090657, 0.24505253, 0.8169458, 0.03939039, 0.5665328,
            0.8011893, 0.75747067, 0.1555473, 0.18986696, 0.13435428, 0.38600448, 0.19166702,
            0.46490034, 0.18260308, 0.82895696, 0.03558233, 0.14173116, 0.8877225, 0.12655611,
            0.4754852, 0.7843472, 0.8912908, 0.15408872, 0.45979473, 0.18853948, 0.826404,
            0.8497178, 0.36331993, 0.98673576, 0.43612492, 0.03541405, 0.783278, 0.24658875,
            0.74658084, 0.34663445, 0.03917093, 0.3931895, 0.30789322, 0.68702215, 0.44194368,
            0.33855647, 0.9119313, 0.31810585, 0.16017109, 0.00698695, 0.293519, 0.14280626,
            0.48469457, 0.1767692, 0.42322084, 0.46112144, 0.9255381, 0.5532242, 0.9853486,
            0.24325794, 0.63504064, 0.15406865, 0.11709648, 0.1119092, 0.21574858, 0.62332,
            0.8729103, 0.52609015, 0.06899712, 0.6168495, 0.3181057, 0.10088859, 0.28579375,
            0.08647749, 0.8464018, 0.5181164, 0.47873196, 0.83375126, 0.9057766, 0.00922728,
            0.36432305, 0.53910846, 0.47707382, 0.23459193, 0.6104503, 0.99977493, 0.2879088,
            0.9237121, 0.24345838, 0.00414109, 0.03638967, 0.30595168, 0.16491044, 0.7087876,
            0.79154646, 0.6065011, 0.46475387, 0.6585233, 0.93920064, 0.09687401, 0.5544905,
            0.56360936, 0.10987341, 0.79093266, 0.6827511, 0.93982804, 0.14053226, 0.49555323,
            0.4556152, 0.66896224, 0.46089745, 0.33559954, 0.3038908, 0.7388162, 0.5641086,
            0.07862057, 0.46463865, 0.07132971, 0.5696929, 0.89171886, 0.97521317, 0.86021405,
            0.61829454, 0.4099887, 0.3409378, 0.49427044, 0.10122171, 0.23691536, 0.70967704,
            0.4641384, 0.8326181, 0.38735756, 0.9489551, 0.07998312, 0.5111061, 0.02956773,
            0.17711017, 0.11328588, 0.74999446, 0.8589006, 0.07875007, 0.73433584, 0.4188041,
            0.48477763, 0.00624699, 0.6286288, 0.21567076, 0.81573004, 0.70090973, 0.8734742,
            0.6482149, 0.5717835, 0.16271727, 0.53025377, 0.0984337, 0.82271063, 0.12299971,
            0.06295575, 0.7953895, 0.5933358, 0.27819812, 0.70772564, 0.8846656, 0.33805057,
            0.66772455, 0.9335431, 0.0900248, 0.08626243, 0.0064692, 0.9791513, 0.52760124,
            0.61633664, 0.9759571, 0.5431996, 0.11189567, 0.662313, 0.47249612, 0.88115114,
            0.93577164, 0.61019063, 0.4513792, 0.21412608, 0.21063799, 0.59758914, 0.26163143,
            0.57292384, 0.3575447, 0.41482434, 0.5686212, 0.43116546, 0.8888871, 0.5989078,
            0.96428144, 0.67385226, 0.18009396, 0.650084, 0.1288117, 0.6034601,
        ],
    )
    .unwrap();
    let conv_layer49 = TransposedConvolutionLayer::new(kernel49, None, 2, Padding::Valid);
    let target_output49: Array3<f32> = Array::from_shape_vec(
        (2, 8, 8),
        vec![
            0.63662237, 0.83164525, 1.6817877, 2.113362, 2.3914876, 2.016426, 1.4575744,
            0.70613015, 1.034579, 0.5145692, 2.2842531, 0.9827217, 1.0825812, 1.189643, 0.3341829,
            0.99050087, 1.313968, 1.9001545, 2.4014015, 3.4165878, 2.402098, 3.4806113, 1.9883122,
            1.4443618, 0.80328524, 0.9983246, 2.7324429, 1.901806, 3.0811496, 2.8609774, 1.5370387,
            2.1473708, 1.3731658, 1.749387, 2.978356, 3.4006784, 1.6951215, 4.062212, 1.5551226,
            1.7191591, 0.5284266, 0.7830124, 1.9899845, 3.1908677, 2.4059196, 4.0127225, 1.4964476,
            2.0098476, 0.3000319, 0.42293397, 1.2112092, 0.97029614, 0.61421925, 1.3547664,
            0.43998447, 0.98328114, 0.08859982, 0.07859854, 0.7912363, 0.954929, 1.0755659,
            1.4896072, 0.4175021, 0.71671873, 0.96143156, 1.0822035, 1.3077629, 2.096451,
            1.5881398, 1.6296682, 1.3111951, 0.7047301, 0.5278329, 1.716264, 2.190927, 2.3331685,
            3.1136675, 1.3214616, 1.3381708, 0.9533866, 1.1866692, 1.865145, 2.6620307, 4.426614,
            3.3754773, 4.0207434, 1.5188766, 1.2718682, 1.318618, 1.1382577, 2.8147006, 3.4527159,
            2.9131858, 2.790851, 1.7376912, 2.0992641, 0.9934057, 1.4400735, 2.4429529, 3.1189277,
            4.0448556, 3.2248523, 2.5619247, 2.2291827, 1.6354222, 0.9864993, 3.1800232, 2.9327343,
            2.1111743, 2.7609448, 1.0924606, 1.9055912, 0.21247046, 0.3326775, 1.0057409,
            0.7488551, 1.4036183, 0.7828704, 1.2482003, 1.0942398, 0.38924783, 0.24456993,
            1.6154397, 1.3864149, 0.7225423, 1.1197757, 0.36066723, 0.862572,
        ],
    )
    .unwrap();
    let current_output49: Array3<f32> = conv_layer49.transposed_convolve(&test_input49);

    assert!(
        arr_allclose(&current_output49, &target_output49),
        "{:?} was not equal to {:?}",
        current_output49,
        target_output49
    );

    let test_input50 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.23165825, 0.01380609, 0.45430455, 0.3510245, 0.375879, 0.7931324, 0.20369534,
            0.9617992, 0.17212614, 0.8661392, 0.818001, 0.04731771,
        ],
    )
    .unwrap();

    let kernel50: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.6331485, 0.83272296, 0.58803684, 0.6773803, 0.966571, 0.59957683, 0.85136724,
            0.03105091, 0.388052, 0.55736136, 0.02805966, 0.80824125, 0.57193863, 0.9242484,
            0.43400672, 0.95459735, 0.19825369, 0.3165235, 0.34878272, 0.04700416, 0.89200944,
            0.8226108, 0.49845085, 0.02590412, 0.3321073, 0.9764468, 0.5381227, 0.92109436,
            0.7710321, 0.8660679, 0.3895538, 0.854895, 0.07690383, 0.03470363, 0.623576, 0.7447061,
            0.23551573, 0.09116793, 0.13018292, 0.29478395, 0.694041, 0.0967541, 0.8266735,
            0.00767931, 0.24422543, 0.47754803, 0.05508777, 0.30187264, 0.58673537, 0.38990366,
            0.6169217, 0.5919785, 0.35687554, 0.9651153, 0.31502706, 0.15851368, 0.90410787,
            0.24201743, 0.99100995, 0.46153438, 0.5230941, 0.05274187, 0.85842836, 0.8584512,
            0.30464408, 0.00721753, 0.18392335, 0.8556412, 0.1809689, 0.5768042, 0.3628767,
            0.69780505, 0.11757887, 0.08762363, 0.36607084, 0.24363868, 0.7472844, 0.08178072,
            0.8810783, 0.3569205, 0.451316, 0.0383365, 0.8465622, 0.9883213, 0.56150496,
            0.52739674, 0.47732064, 0.43933925, 0.21088907, 0.5524299, 0.8005311, 0.17473145,
            0.40513718, 0.82864845, 0.4856008, 0.41349155, 0.8595507, 0.77320266, 0.9890798,
            0.24298015, 0.27266598, 0.4846638, 0.87975013, 0.4469587, 0.10110632, 0.5594282,
            0.9304254, 0.09035328, 0.76902574, 0.2852155, 0.07585676, 0.24124639, 0.06790887,
            0.14329627, 0.6381789, 0.9543389, 0.6581925, 0.1983508, 0.44280005, 0.15768081,
            0.7742759, 0.90144795, 0.8614371, 0.28797778, 0.37103122, 0.0877872, 0.45872805,
            0.76575243, 0.6829663, 0.2304093, 0.5233105, 0.6974145, 0.8921432, 0.22412036,
            0.0491925, 0.5368815, 0.19189753, 0.45287937, 0.6024187, 0.37045264, 0.23233427,
            0.42484194, 0.98901117, 0.36564678, 0.8630159, 0.8116843, 0.39872772, 0.6879206,
            0.7998495, 0.594579, 0.7541534, 0.80124223, 0.59222096, 0.05390601, 0.82877624,
            0.29753333, 0.82358676, 0.29054287, 0.26042402, 0.88391197, 0.8143526, 0.579024,
            0.05703124, 0.6139959, 0.10031959, 0.78280455, 0.24171719, 0.4721017, 0.53194064,
            0.6437402, 0.09277638, 0.8693754, 0.60042983, 0.8875286, 0.86002535, 0.69702214,
            0.12023476, 0.9464669, 0.9782188, 0.38164645, 0.7172452, 0.9105007, 0.41190186,
            0.29969904, 0.43725935, 0.7022435, 0.7566894, 0.5551452, 0.88240683, 0.10910437,
            0.51675713, 0.33856305, 0.4310923, 0.43717158, 0.2241604, 0.7074267, 0.04574655,
            0.62335473, 0.6056931, 0.19430637, 0.9464095, 0.43765876, 0.47719213, 0.45312902,
            0.417855, 0.8179389, 0.03511541, 0.5549018, 0.6715673, 0.61512816, 0.655004,
            0.09111205, 0.49298653, 0.3268639, 0.77552783, 0.77209026,
        ],
    )
    .unwrap();
    let conv_layer50 = TransposedConvolutionLayer::new(kernel50, None, 2, Padding::Valid);
    let target_output50: Array3<f32> = Array::from_shape_vec(
        (2, 8, 8),
        vec![
            0.3394171, 0.3655551, 1.1919422, 1.1509339, 1.2862926, 1.0704038, 1.2988211, 0.5881289,
            0.65821457, 0.27926686, 1.72524, 1.1303071, 1.3436159, 0.69472927, 1.3896589,
            1.0527337, 1.5028534, 1.522474, 2.535415, 2.5562036, 2.6984837, 2.7879357, 1.9712174,
            1.2612923, 1.5746675, 0.92447805, 2.9999492, 2.0050316, 2.2215784, 2.6362443,
            1.4646764, 1.9855747, 1.5394884, 1.39262, 2.9466772, 3.7302954, 2.679635, 3.0234413,
            1.057919, 1.8349152, 0.93712544, 1.045217, 2.9894629, 2.7476983, 2.078566, 3.141087,
            2.2472897, 0.8416301, 0.7610923, 1.1276821, 1.4902968, 2.295984, 2.0415568, 1.8163433,
            0.5613121, 0.81215614, 1.0596787, 1.0495908, 1.1774651, 1.6668849, 1.402929, 1.2639391,
            1.1600599, 0.36637044, 0.46707645, 0.2850473, 1.3639951, 1.2266473, 0.6802957,
            0.65214163, 0.44217017, 0.72322935, 0.56162983, 0.45604992, 1.6288347, 1.4418197,
            1.557841, 0.44588682, 0.7995432, 0.42247218, 1.3515084, 1.3487139, 2.768674, 2.2437718,
            1.9408791, 2.210446, 0.66845703, 0.82787716, 1.4741888, 1.0099889, 3.4284751,
            2.2892807, 3.180764, 1.82199, 1.3117249, 1.2256289, 1.3053476, 0.9556114, 2.9102862,
            3.3139548, 1.6703994, 2.6805644, 1.2223711, 1.3447881, 1.1138037, 0.74008095, 3.166238,
            2.0503438, 3.169248, 2.109685, 2.33491, 1.8226016, 0.7611752, 0.738688, 1.4901861,
            1.2260442, 1.0771369, 1.4426701, 0.32328144, 0.46721902, 0.742061, 0.5387109,
            1.2077646, 1.2769214, 1.3110065, 1.6496186, 1.115305, 0.633159,
        ],
    )
    .unwrap();
    let current_output50: Array3<f32> = conv_layer50.transposed_convolve(&test_input50);

    assert!(
        arr_allclose(&current_output50, &target_output50),
        "{:?} was not equal to {:?}",
        current_output50,
        target_output50
    );

    let test_input51 = Array::from_shape_vec(
        (3, 2, 2),
        vec![
            0.47542888, 0.31814525, 0.52555007, 0.81072354, 0.00102462, 0.5109687, 0.48937833,
            0.122188, 0.22519495, 0.40227205, 0.84508294, 0.43985215,
        ],
    )
    .unwrap();

    let kernel51: Array4<f32> = Array::from_shape_vec(
        (3, 2, 6, 6),
        vec![
            0.05504967, 0.02137936, 0.26612982, 0.12310848, 0.00158825, 0.75761557, 0.88188004,
            0.12094665, 0.13906257, 0.9157668, 0.91879827, 0.8513396, 0.28533912, 0.30878848,
            0.12668495, 0.24235713, 0.45707443, 0.7712829, 0.6903243, 0.09853197, 0.43307763,
            0.05488254, 0.70532215, 0.34688666, 0.9355463, 0.38260135, 0.4838589, 0.17318112,
            0.21472165, 0.77769446, 0.356957, 0.22671694, 0.18250434, 0.41477197, 0.18007399,
            0.9827863, 0.58704966, 0.2950183, 0.46143153, 0.19057809, 0.3653109, 0.93977064,
            0.26191843, 0.3693467, 0.1444909, 0.9363978, 0.42698747, 0.1281546, 0.30951205,
            0.1389484, 0.7072368, 0.44510987, 0.68366706, 0.60059834, 0.09438256, 0.36583102,
            0.60821444, 0.03161661, 0.8738241, 0.29876906, 0.33316013, 0.562216, 0.3353904,
            0.10716959, 0.9334109, 0.8606402, 0.42792627, 0.48052302, 0.6958078, 0.4525564,
            0.99052715, 0.04395659, 0.71055365, 0.9117777, 0.93380785, 0.90260816, 0.01515595,
            0.88177705, 0.43487665, 0.56912595, 0.05581366, 0.02638636, 0.50119185, 0.31323937,
            0.05636088, 0.31307653, 0.3326902, 0.3734779, 0.4210294, 0.08686391, 0.3808534,
            0.36317897, 0.19031978, 0.46563995, 0.41320488, 0.94399136, 0.28572702, 0.6142756,
            0.8158052, 0.26794037, 0.12281225, 0.32823455, 0.14740174, 0.70965314, 0.19252698,
            0.79887706, 0.02814319, 0.39099365, 0.7551387, 0.5038018, 0.15413615, 0.82638884,
            0.2631662, 0.7053773, 0.6478343, 0.32534242, 0.6635084, 0.8839653, 0.59479696,
            0.68739474, 0.903793, 0.9826564, 0.56865096, 0.33996934, 0.63317853, 0.7065151,
            0.82775307, 0.22001709, 0.37304193, 0.20307006, 0.59174454, 0.3759951, 0.673529,
            0.42676452, 0.6453951, 0.93520576, 0.59322685, 0.5885291, 0.23145947, 0.15739693,
            0.8825847, 0.17851174, 0.5603199, 0.14435844, 0.10347797, 0.37213182, 0.14642915,
            0.21561022, 0.3830422, 0.90021485, 0.32565016, 0.82000726, 0.72865623, 0.48349917,
            0.41356984, 0.03333719, 0.08149401, 0.85722613, 0.04374503, 0.88704216, 0.09240989,
            0.8528545, 0.7946653, 0.54765993, 0.74729836, 0.72924787, 0.21080038, 0.12833528,
            0.06738389, 0.9163098, 0.2233036, 0.09597177, 0.4226413, 0.73019654, 0.8065446,
            0.13412596, 0.9296237, 0.88961375, 0.8097079, 0.92300737, 0.8407575, 0.5467569,
            0.90232325, 0.40697718, 0.7049378, 0.17525117, 0.60480595, 0.01006908, 0.09306768,
            0.04155758, 0.00396548, 0.29594678, 0.24183853, 0.23543635, 0.10814751, 0.366542,
            0.58264214, 0.1795904, 0.47117367, 0.7827338, 0.22905576, 0.3444951, 0.83183694,
            0.12226541, 0.8971257, 0.27640048, 0.37137195, 0.2710384, 0.27672654, 0.33046693,
            0.4244338, 0.8525934, 0.79606473, 0.24516417, 0.5116681, 0.32966596,
        ],
    )
    .unwrap();
    let conv_layer51 = TransposedConvolutionLayer::new(kernel51, None, 2, Padding::Valid);
    let target_output51: Array3<f32> = Array::from_shape_vec(
        (2, 8, 8),
        vec![
            0.05020297, 0.0949008, 0.5826685, 0.73039836, 0.70774865, 1.1509244, 0.16233668,
            1.0537236, 0.4930516, 0.24274616, 0.86403555, 1.2034407, 0.8963498, 0.9119074,
            0.7147722, 0.4443158, 0.61817664, 1.1120932, 1.1203432, 1.8994627, 1.1926631,
            3.0789855, 0.5693443, 1.7507651, 1.4590377, 1.2056029, 2.7357883, 2.0590892, 2.436581,
            2.3307445, 1.5083694, 1.3874747, 0.70666397, 1.4288013, 1.292329, 2.6338425, 1.5449553,
            2.5660005, 0.76373506, 1.7199159, 1.572228, 0.83105284, 2.7176483, 2.1251845,
            2.2524843, 2.7484083, 1.1124237, 1.3367765, 0.68845, 1.2760471, 1.6652603, 1.0915256,
            1.1202936, 1.4017794, 0.37498575, 0.99178, 0.941331, 0.57978755, 1.6379074, 1.6902454,
            1.3730628, 2.3130422, 0.5055807, 1.2505295, 0.46920842, 0.26390332, 1.3335669,
            0.7543329, 0.9212379, 1.1335884, 0.5342684, 0.72990793, 0.2613866, 0.17819895,
            0.747981, 0.743251, 0.6269443, 0.89458495, 0.44136184, 0.51106006, 1.5911201,
            0.9837375, 3.0372293, 2.3252654, 2.7222872, 2.2111669, 1.4138107, 1.5494962, 1.1176248,
            0.7122547, 2.0204704, 1.9399561, 1.8376153, 1.9616603, 1.3355807, 0.6544198, 1.1704466,
            1.0828533, 2.2638826, 1.6673985, 2.9445388, 2.481975, 1.599308, 1.3597062, 1.1521341,
            1.3820246, 2.0168135, 1.921706, 3.6705222, 1.0754188, 1.9538864, 0.56230253, 1.2628485,
            0.73790324, 1.5529475, 1.3725649, 1.5288405, 1.3399675, 0.95094216, 0.9150091,
            0.6968497, 1.0500777, 2.03224, 1.3162032, 2.249282, 0.86888844, 1.0965663, 0.1982798,
        ],
    )
    .unwrap();
    let current_output51: Array3<f32> = conv_layer51.transposed_convolve(&test_input51);

    assert!(
        arr_allclose(&current_output51, &target_output51),
        "{:?} was not equal to {:?}",
        current_output51,
        target_output51
    );
}
