// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array2, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_torch_transpose_stride2() {
    let test_input1 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335, 0.22177844, 0.16487044,
            0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337, 0.41083884, 0.4583148,
            0.70402896, 0.6177326, 0.9269775, 0.56033564,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(kernel1, None, 2, Padding::Same);
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.12302814, 0.2981639, 0.31132853, 0.44118133, 0.4132545, 0.12675367, 0.11276765,
            0.19478104, 0.26577038, 0.5081095, 0.65049326, 0.3301649, 0.04714558, 0.09109226,
            0.09160915, 0.48182896, 0.5424107, 0.16636854, 0.5336932, 0.21568838, 0.34342188,
            0.21784604, 0.37150982, 0.40653735, 0.7113484, 0.5543243, 0.40183634, 0.14854227,
            0.03023378, 0.00927332, 0.45916766, 0.623222, 0.259381, 0.3071895, 0.01951558,
            0.02259396, 0.07798158, 0.29668385, 0.19733606, 0.53794086, 0.261942, 0.40237573,
            0.17587984, 0.49268383, 0.43440676, 1.1984463, 0.7386832, 0.8226026, 0.0298833,
            0.09795609, 0.0580666, 0.39739102, 0.34380785, 0.5281319, 0.33438516, 1.1583171,
            0.27219343, 0.9354929, 0.7070214, 0.4483404, 0.4508893, 0.92094266, 0.2547046,
            0.40843675, 0.01916373, 0.02943789, 0.9119588, 0.8945569, 0.5151599, 0.3372313,
            0.03876014, 0.02342957,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9098013, 0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727,
            0.9148518, 0.3356524,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.37189406, 0.55898565, 0.5888119, 0.44166553, 0.9034325, 0.2795916, 0.7567664,
            0.85028297, 0.96145767, 0.5566679, 0.84558666, 0.0474241, 0.23985276, 0.07658575,
            0.7197864, 0.13313323, 0.69580543, 0.12692,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(kernel2, None, 2, Padding::Same);
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.82194406, 0.37349287, 0.2436616, 0.18247789, 0.21901353, 0.06777965, 1.2176942,
            1.8264226, 0.64985824, 1.246201, 0.74793035, 0.803791, 0.7177635, 0.5544014,
            0.67966276, 0.638428, 0.87565947, 0.27099648, 0.7473931, 1.7491059, 1.1510668,
            2.1203206, 1.0117687, 1.129537, 0.11613378, 0.43999922, 0.82650685, 0.40403098,
            0.3032393, 0.09384559, 0.10930155, 0.8159218, 0.7778829, 1.1336018, 0.28539953,
            0.32271558, 0.06967781, 0.7195524, 0.02065567, 0.25227708, 0.01856621, 0.17449334,
            1.3048506, 0.60784435, 0.82380795, 0.64173853, 0.98827165, 0.07673463, 0.06084622,
            0.7523034, 0.05761635, 0.77398294, 0.07423137, 0.69765896, 0.66150475, 0.7163586,
            1.297049, 0.45475683, 0.95823836, 0.13893628, 0.00984489, 0.3119563, 0.0700646,
            0.739005, 0.02570619, 0.24159804, 0.08944388, 0.1381124, 0.63655883, 0.16079947,
            0.23354878, 0.042601,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.38484824, 0.775336, 0.52113837, 0.4364637, 0.14352316, 0.8997107, 0.64410555,
            0.04471071, 0.767672,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (1, 2, 3, 3),
        vec![
            0.43464628, 0.16569944, 0.18875164, 0.12285258, 0.2781115, 0.5390728, 0.5066572,
            0.97435564, 0.39133722, 0.7964828, 0.988919, 0.35985747, 0.00756764, 0.53660643,
            0.8659267, 0.8576183, 0.81628793, 0.9480399,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(kernel3, None, 2, Padding::Same);
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.10703071, 0.30271325, 0.21562986, 0.48198578, 0.14493456, 0.28093153, 0.44730085,
            0.68820006, 0.77923477, 0.9856025, 0.6568557, 0.37376273, 0.12138557, 0.25291792,
            0.03991544, 0.18790121, 0.25021988, 0.48500958, 0.5319988, 0.38453087, 0.14725114,
            0.85411584, 1.003841, 0.49698967, 0.17913315, 0.35271263, 0.01243456, 0.11841282,
            0.2134984, 0.4138311, 0.62758785, 0.27471548, 0.04356413, 0.4064435, 0.74798554,
            0.30041862, 0.20651203, 0.33911783, 0.4160503, 0.67532796, 0.2796462, 0.45126763,
            0.74577427, 1.3011723, 0.7748302, 1.9502393, 1.31514, 0.8178276, 0.23420924,
            0.37903172, 0.07701545, 0.13108921, 0.48279056, 0.7790835, 0.99324834, 0.8042706,
            0.1613715, 1.5352011, 1.4935884, 1.1292142, 0.34563118, 0.5580866, 0.02399205,
            0.04452566, 0.41193774, 0.66474766, 0.5257756, 0.6489825, 0.03649681, 0.7007571,
            0.6266414, 0.7277837,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133, 0.0067116, 0.65220493,
            0.72789615, 0.00785976,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.32536873, 0.09833383, 0.1022715, 0.7567798, 0.23972042, 0.38848338, 0.00744711,
            0.8715701, 0.07988323, 0.6283005, 0.8241853, 0.16570753, 0.6487234, 0.14438818,
            0.6286194, 0.34163022, 0.03235205, 0.25922647, 0.59344524, 0.9308157, 0.22162326,
            0.91818297, 0.97700953, 0.18019113, 0.775954, 0.14120784, 0.3426181, 0.5417864,
            0.7768226, 0.34603763, 0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802,
            0.629322, 0.60627973, 0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678,
            0.89887625, 0.6572328, 0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983,
            0.6908677,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(kernel4, None, 2, Padding::Same);
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.4113413, 0.84001744, 1.8339031, 0.97359073, 1.3370962, 0.1272708, 1.4010482,
            0.36359856, 2.2028804, 0.6347679, 1.6450813, 0.5027519, 2.1724207, 1.7281638,
            2.7048604, 1.6257769, 2.287493, 0.1594078, 1.3514118, 0.50616837, 1.9469028, 0.6096815,
            1.3305748, 0.00461083, 1.9180386, 1.1948013, 2.3450449, 0.27994645, 1.1900197,
            0.00234423, 0.4177401, 0.41059685, 0.7984577, 0.4322208, 0.6795746, 0.00466434,
            1.2065846, 1.5424839, 1.8772444, 1.4956415, 1.2399137, 0.24887647, 1.3884195,
            1.6548519, 2.1215773, 1.156868, 2.0076852, 0.55960387, 1.9862913, 2.0426066, 2.8705754,
            1.5164227, 2.3618512, 0.34569174, 1.4628037, 1.5989138, 2.1405473, 0.9882975,
            1.1409874, 0.00840035, 1.6292672, 1.2599288, 2.0490477, 0.5874962, 1.199552,
            0.00494088, 0.6233454, 0.5047133, 1.1083518, 0.47921857, 0.51337713, 0.0051657,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.5511301, 0.36253917, 0.36786652, 0.88718724, 0.69587743, 0.4870034, 0.7135373,
            0.9862549, 0.22876498,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.75677496, 0.5617529, 0.5566727, 0.7035832, 0.92333794, 0.85647196, 0.36252776,
            0.9373231, 0.01684272, 0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754,
            0.31284246, 0.4031665, 0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259,
            0.23846498, 0.82509995, 0.97324103, 0.96826524, 0.77620417, 0.8427075, 0.42989048,
            0.76771307, 0.54514444, 0.7878393, 0.21897991, 0.975659, 0.73295325, 0.69994044,
            0.86701024, 0.76087946, 0.623545, 0.14890751, 0.8610666, 0.21943341, 0.1644093,
            0.6089244, 0.8612485, 0.02602104, 0.30423534, 0.5087405, 0.16869895, 0.3329467,
            0.179494,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(kernel5, None, 2, Padding::Same);
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.7660103, 1.5635334, 2.3572176, 1.1710206, 1.3015531, 0.62063503, 2.010589,
            0.73496115, 2.2745132, 0.5913968, 1.292762, 0.1419148, 2.9152234, 2.6025717, 3.4730663,
            1.9660728, 2.273659, 0.8869945, 2.497284, 1.2053357, 2.8617165, 0.7117095, 1.5260434,
            0.1808693, 2.1992893, 1.9275141, 2.621144, 1.6219313, 1.5548685, 0.64684373, 0.9631989,
            0.9868449, 1.4760103, 0.52722764, 1.0134706, 0.08315162, 1.5795159, 1.6254424,
            2.1803737, 1.2785225, 1.1302636, 0.42865697, 1.8289816, 1.3369148, 1.9994198,
            0.9894066, 1.1956586, 0.6737752, 2.4320843, 2.4084392, 2.8826084, 1.7319698, 1.6659929,
            0.37062427, 2.1661081, 1.6174569, 2.1955993, 1.4523649, 1.228172, 0.587105, 1.6613936,
            1.5060792, 1.8525212, 0.80037177, 1.1989392, 0.196211, 0.6509075, 0.7766824, 0.6693203,
            0.8870216, 0.16496395, 0.1970235,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.33126613, 0.11996287, 0.21606164, 0.87119263, 0.33579683, 0.2313126, 0.2576527,
            0.3748985, 0.30113342,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (1, 2, 5, 5),
        vec![
            0.8142977, 0.423247, 0.8179498, 0.92175007, 0.21606776, 0.19149332, 0.4240341,
            0.14780204, 0.46443272, 0.00207204, 0.359202, 0.9019851, 0.21363449, 0.6390296,
            0.5977058, 0.81350476, 0.3685356, 0.90738845, 0.7828945, 0.9812083, 0.6726924,
            0.46724817, 0.17302093, 0.39839587, 0.78055173, 0.8576361, 0.7335981, 0.52934057,
            0.9529279, 0.78965247, 0.46750203, 0.08403921, 0.73126566, 0.34934825, 0.3459232,
            0.54770446, 0.68714255, 0.29283327, 0.53392637, 0.8850151, 0.6909357, 0.44388366,
            0.9043074, 0.9949724, 0.64743847, 0.36691284, 0.5396585, 0.5372604, 0.47547424,
            0.44373918,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(kernel6, None, 2, Padding::Same);
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            1.0998912, 1.2650405, 0.9524965, 0.67896736, 0.3796177, 0.35128218, 0.59124434,
            0.85055673, 0.7053926, 0.42758414, 0.34864467, 0.2765826, 0.96077573, 1.4437952,
            1.7077429, 1.0449883, 0.70846, 0.5114634, 1.1735547, 1.0844371, 1.4613032, 0.6499464,
            0.58466196, 0.32094958, 0.5663303, 1.0067806, 1.2359724, 0.75304955, 0.59054023,
            0.28458714, 0.5387728, 0.33987832, 0.837963, 0.40448436, 0.6410985, 0.2357557,
            0.91185904, 1.3358269, 1.5107148, 0.70219713, 0.5570449, 0.33578524, 1.176512,
            0.71541995, 1.127304, 0.35201532, 0.5583656, 0.29578403, 1.1189362, 1.4386898,
            1.9469329, 1.0900364, 0.98967654, 0.5131941, 1.3835183, 1.137384, 1.5315882, 0.5930616,
            0.7764802, 0.3353501, 0.8720483, 0.99062157, 1.1546056, 0.6915823, 0.693254,
            0.27076626, 0.492028, 0.42276865, 0.7139016, 0.50668186, 0.5150409, 0.29961944,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );
}
