// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array2, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_torch_transpose() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637, 0.14352316, 0.8997107, 0.64410555,
            0.04471071, 0.767672, 0.43464628, 0.16569944, 0.18875164, 0.12285258, 0.2781115,
            0.5390728, 0.5066572, 0.97435564, 0.39133722,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(
        kernel1,
        Some(Array::from_shape_vec((1,), vec![0.7964828]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            1.2991878, 1.7394323, 2.076244, 2.7141016, 2.356033, 1.8451858, 1.4853458, 1.8277926,
            3.0655777, 4.5368757, 5.489974, 4.7476206, 3.5101807, 2.3966742, 1.646284, 2.9933794,
            4.7904983, 6.341546, 4.881093, 3.8712862, 2.1238065, 2.6740947, 3.8697772, 6.071162,
            7.86866, 6.1022396, 5.0844126, 2.2200782, 3.0936677, 4.528604, 7.580206, 8.067666,
            6.8340282, 5.478548, 2.5842676, 1.964928, 2.8138847, 4.9020815, 5.359416, 4.391408,
            3.555112, 1.4334152, 1.913409, 2.2649083, 3.5701735, 3.7628956, 3.477822, 2.227549,
            1.21557, 1.3217137, 1.7214563, 2.4893293, 2.87452, 2.533421, 2.1011243, 1.1852194,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183, 0.81628793,
            0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133, 0.0067116,
            0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715, 0.7567798,
            0.23972042, 0.38848338, 0.00744711, 0.8715701, 0.07988323, 0.6283005, 0.8241853,
            0.16570753, 0.6487234, 0.14438818, 0.6286194, 0.34163022, 0.03235205, 0.25922647,
            0.59344524, 0.9308157, 0.22162326, 0.91818297, 0.97700953,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.18019113, 0.775954, 0.14120784, 0.3426181, 0.5417864, 0.7768226, 0.34603763,
            0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802, 0.629322, 0.60627973,
            0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678, 0.89887625, 0.6572328,
            0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983, 0.6908677, 0.5511301,
            0.36253917, 0.36786652, 0.88718724, 0.69587743,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(
        kernel2,
        Some(Array::from_shape_vec((1,), vec![0.4870034]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            1.2363927, 1.5387018, 1.2917559, 1.709923, 1.2842014, 0.9153459, 0.6775485, 2.3340342,
            3.0653026, 3.3135664, 4.8273563, 2.6869175, 1.8905756, 1.8835473, 3.3966126, 4.6809015,
            5.4255543, 7.673375, 5.3900867, 2.9310334, 2.5448484, 3.812293, 5.5270634, 7.18433,
            10.170728, 6.5829654, 4.521795, 3.1828368, 3.3769648, 4.9391108, 6.88736, 10.304645,
            6.416896, 5.530104, 3.7312214, 2.6690152, 3.2529855, 5.1311693, 7.2874265, 4.7738266,
            3.738039, 2.369389, 2.0632725, 2.0881891, 3.4177465, 4.4425836, 3.0491765, 2.8837502,
            1.7161183, 0.82940686, 1.1192933, 1.9885633, 2.2406073, 1.9984345, 2.0496633,
            1.1963289,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529, 0.5566727, 0.7035832,
            0.92333794, 0.85647196, 0.36252776, 0.9373231, 0.01684272, 0.34317794, 0.921993,
            0.36392415, 0.7462054, 0.7556754, 0.31284246, 0.4031665, 0.7376267, 0.7926341,
            0.36348057, 0.84374106, 0.03665259, 0.23846498, 0.82509995, 0.97324103, 0.96826524,
            0.77620417, 0.8427075, 0.42989048, 0.76771307, 0.54514444, 0.7878393, 0.21897991,
            0.975659, 0.73295325, 0.69994044, 0.86701024, 0.76087946,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.623545, 0.14890751, 0.8610666, 0.21943341, 0.1644093, 0.6089244, 0.8612485,
            0.02602104, 0.30423534, 0.5087405, 0.16869895, 0.3329467, 0.179494, 0.33126613,
            0.11996287, 0.21606164, 0.87119263, 0.33579683, 0.2313126, 0.2576527, 0.3748985,
            0.30113342, 0.8142977, 0.423247, 0.8179498, 0.92175007, 0.21606776, 0.19149332,
            0.4240341, 0.14780204, 0.46443272, 0.00207204,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(
        kernel3,
        Some(Array::from_shape_vec((1,), vec![0.359202]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            1.4946617, 1.663253, 2.303574, 2.474514, 1.1864182, 1.2869047, 0.53470737, 1.3316987,
            2.560455, 4.8685355, 5.095947, 3.5229723, 2.8280582, 0.8464945, 2.6166499, 4.213301,
            6.2062964, 6.5092363, 5.476372, 3.2549615, 1.2535273, 2.3100615, 5.019946, 7.1929708,
            8.961775, 6.2559566, 3.1542726, 1.7561208, 2.8271523, 4.9646797, 7.0815134, 8.778705,
            5.4752774, 4.299115, 1.5035902, 1.7914014, 3.776753, 5.118646, 5.722188, 4.751816,
            3.0532894, 1.1409444, 1.4813824, 2.780758, 3.1556032, 4.0585694, 2.6669393, 1.5700288,
            0.9137436, 0.8056383, 1.0708156, 1.4373571, 1.6033376, 1.2360888, 0.88997245,
            0.5201514,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.9019851, 0.21363449, 0.6390296, 0.5977058, 0.81350476, 0.3685356, 0.90738845,
            0.7828945, 0.9812083, 0.6726924, 0.46724817, 0.17302093, 0.39839587, 0.78055173,
            0.8576361, 0.7335981, 0.52934057, 0.9529279, 0.78965247, 0.46750203, 0.08403921,
            0.73126566, 0.34934825, 0.3459232, 0.54770446, 0.68714255, 0.29283327, 0.53392637,
            0.8850151, 0.6909357, 0.44388366, 0.9043074, 0.9949724, 0.64743847, 0.36691284,
            0.5396585, 0.5372604, 0.47547424, 0.44373918, 0.34716287,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.21774843, 0.9437953, 0.51856595, 0.15765554, 0.9350713, 0.86233217, 0.81734437,
            0.6566154, 0.3879487, 0.28848994, 0.5814131, 0.06870039, 0.78543746, 0.47194287,
            0.12733267, 0.6111727, 0.25675833, 0.74741316,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(
        kernel4,
        Some(Array::from_shape_vec((1,), vec![0.45714313]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.67779344, 1.6147754, 1.7973812, 1.6543386, 1.5777586, 0.79085803, 1.0005002,
            3.3129756, 3.6545527, 3.4522936, 3.3148181, 1.4592748, 2.2731538, 5.095925, 5.582965,
            5.6245155, 4.213112, 1.8425202, 2.6804051, 5.148268, 6.5380216, 6.5903535, 4.203273,
            1.8417728, 2.9145806, 4.931064, 6.487819, 6.3516164, 4.1259575, 2.16776, 1.8963075,
            3.2800968, 5.072697, 5.007097, 3.022785, 1.5924366, 1.2181555, 2.0121295, 2.728464,
            2.4089243, 1.4912503, 0.897984,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.9649919, 0.57969916, 0.5208711, 0.93666834, 0.13247305, 0.7087714, 0.17877895,
            0.40767, 0.6906785, 0.9675369, 0.224454, 0.28950995, 0.75431514, 0.99582964, 0.8120864,
            0.9536324, 0.7703749, 0.683158, 0.16371861, 0.42877796, 0.7300311, 0.9456737,
            0.05700503, 0.19623296, 0.44457257, 0.5512328, 0.15101007, 0.25140873, 0.2031063,
            0.5537751, 0.3641559, 0.701937, 0.27669305, 0.85076064, 0.00186597, 0.3316532,
            0.15485734, 0.35000807, 0.42372492, 0.03995521,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.5067197, 0.38907993, 0.37287286, 0.21294773, 0.8646356, 0.10154326, 0.75313085,
            0.7910046, 0.15368015, 0.25977603, 0.40315583, 0.635939, 0.25689796, 0.13678746,
            0.43744904, 0.6658951, 0.564682, 0.70429957,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(
        kernel5,
        Some(Array::from_shape_vec((1,), vec![0.67241764]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            1.3510426, 1.8816012, 2.3820395, 2.2412097, 1.3464394, 1.146468, 1.24807, 2.7061505,
            2.8058429, 2.8701572, 2.0096326, 1.1652616, 2.430469, 4.36691, 4.925436, 4.6237144,
            2.8263266, 1.660286, 1.7215865, 4.0330267, 4.925303, 4.4955063, 2.6078506, 1.8150897,
            1.9901403, 4.3508124, 4.7452993, 4.6832285, 3.0553966, 1.6384885, 1.6285963, 3.6645048,
            3.792426, 3.5306911, 2.3183243, 1.1135731, 1.3557295, 2.116809, 2.0433574, 1.7422199,
            1.3577346, 0.7664527,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.15790685, 0.25059524, 0.6432024, 0.60438925, 0.45131883, 0.96080875, 0.40131757,
            0.60942906, 0.7035094, 0.6473561, 0.05433872, 0.7478619, 0.24740443, 0.35665986,
            0.00020906, 0.23741227, 0.57013196, 0.6398819, 0.7132858, 0.90739846, 0.8246988,
            0.1319153, 0.6876462, 0.846729, 0.18134636, 0.9026019, 0.54676574, 0.33139232,
            0.83673465, 0.05539654, 0.5554673, 0.9149804, 0.9791666, 0.9000323, 0.6329186,
            0.30872977, 0.30553624, 0.04431259, 0.5287215, 0.3358437,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.72178566, 0.72704846, 0.85191244, 0.07464863, 0.867838, 0.5849202, 0.14913943,
            0.18325551, 0.40498126, 0.75359416, 0.01821492, 0.5917236, 0.91982275, 0.5287654,
            0.7151285, 0.38420153, 0.517026, 0.5150141,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(
        kernel6,
        Some(Array::from_shape_vec((1,), vec![0.26934662]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            1.0048097, 0.679461, 2.0589213, 2.1153836, 1.6790386, 1.2852628, 1.5021279, 2.6876292,
            3.8277214, 4.599983, 3.2240996, 1.943659, 1.9485854, 3.2379737, 5.4938536, 5.3860183,
            3.6977518, 2.7221742, 2.1449604, 3.221539, 5.1171107, 4.606451, 3.1112566, 2.163531,
            2.256634, 3.450993, 5.612342, 4.816673, 3.5959206, 2.374844, 1.0060405, 1.9647905,
            3.318025, 3.0398202, 2.5588982, 1.2954215, 0.47176325, 0.64425325, 1.1072822,
            1.2197453, 1.1704388, 0.80979025,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.7356045, 0.97902703, 0.6362754, 0.27803296, 0.32063982, 0.83432084, 0.78711736,
            0.28247103, 0.7812688, 0.5270146, 0.4719829, 0.47535485, 0.23715672, 0.4404677,
            0.90286416, 0.66611385, 0.02649495, 0.3193976, 0.16608049, 0.5121102, 0.17436478,
            0.313714, 0.47244504, 0.9906781, 0.9064671, 0.29454133, 0.99321055, 0.12515199,
            0.17643407, 0.16320723, 0.48754972, 0.53866875, 0.6358971, 0.8935865, 0.82249755,
            0.92702305, 0.10556214, 0.28283548, 0.14977625, 0.53714937,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625, 0.4744624, 0.73655206,
            0.42605233, 0.6592577, 0.3237799, 0.42867732, 0.87574345, 0.70010746, 0.01496939,
            0.78416556, 0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122,
            0.68573385, 0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448,
            0.48578474, 0.2764571, 0.9192946, 0.8920509, 0.34320405, 0.4283556, 0.3897719,
            0.06360459, 0.729173, 0.19460331, 0.8634254, 0.6576018, 0.9657459, 0.22873744,
            0.47843248, 0.22157177, 0.9162307, 0.02157675, 0.44649428, 0.2792192, 0.685827,
            0.75294507,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(
        kernel7,
        Some(Array::from_shape_vec((1,), vec![0.7919586]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.9339278, 1.3918426, 2.2745626, 3.1574776, 3.1115797, 2.8893592, 1.9887066, 1.257021,
            1.815837, 2.7853208, 4.6870756, 5.887635, 5.784416, 4.1598225, 2.8161085, 1.4969518,
            2.2498379, 4.2243176, 6.6250143, 7.1990614, 7.314949, 5.634097, 4.3158894, 2.277478,
            2.5003595, 5.660144, 8.214821, 11.539489, 9.715596, 8.196053, 5.830923, 3.2786982,
            3.3532805, 6.2386007, 9.754515, 11.262954, 12.249561, 9.054738, 7.3477335, 3.8612862,
            1.878975, 4.5887733, 6.959221, 9.350528, 10.333023, 7.5983887, 6.114748, 3.4309382,
            1.9803307, 3.450999, 4.9720974, 6.9115047, 7.368307, 5.852682, 4.6248274, 3.6224515,
            1.0474539, 2.0062203, 2.957667, 4.709475, 4.9666157, 4.940299, 3.6934476, 2.833583,
            0.808046, 1.029839, 1.2675469, 1.5585613, 2.0666308, 1.8502468, 1.8437614, 1.5719709,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.22560763, 0.88778716, 0.80092114, 0.00003577, 0.9737877, 0.9146247, 0.13869576,
            0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946, 0.17754778, 0.41998118,
            0.02919354, 0.82382417, 0.4156855, 0.49590722, 0.69720376, 0.7155315, 0.40795937,
            0.15397236, 0.02265206, 0.7090415, 0.75877124, 0.67035425, 0.39483562, 0.86222315,
            0.9993058, 0.84902793, 0.26427644, 0.86764544, 0.24274233, 0.69865257, 0.5739991,
            0.7620597, 0.29289714, 0.88402116, 0.8942853, 0.7757528,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.16431308, 0.48939565, 0.56055367, 0.46453193, 0.9573795, 0.8899508, 0.16098963,
            0.63514715, 0.810474, 0.29953358, 0.46075395, 0.02808736, 0.59781086, 0.8855644,
            0.61877847, 0.9537467, 0.6197168, 0.3379795, 0.13108306, 0.30692965, 0.33537498,
            0.01351478, 0.45529485, 0.6626128, 0.9497022, 0.7403127, 0.06039312, 0.08292098,
            0.80679554, 0.1354166, 0.2560622, 0.80891573, 0.97702754, 0.4124968, 0.4359102,
            0.8733311, 0.1396195, 0.52047473, 0.88564533, 0.29781443, 0.21130918, 0.83071965,
            0.3337948, 0.9783562, 0.42070097, 0.55396014, 0.16172563, 0.7634967, 0.36205766,
            0.48491392,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(
        kernel8,
        Some(Array::from_shape_vec((1,), vec![0.4980414]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.8371292, 0.89295346, 1.2504845, 2.3606567, 1.7995839, 1.8179846, 1.8399625,
            0.59409165, 1.5250181, 2.8628287, 3.4379466, 4.371185, 5.1396894, 3.9989548, 2.2501574,
            1.599766, 2.7743819, 3.639282, 4.1517286, 7.8306894, 6.6116314, 5.2377377, 4.019109,
            1.4457159, 2.4588876, 4.9604197, 6.7553415, 8.865691, 8.333117, 6.655184, 4.7982616,
            2.7700014, 3.3099718, 5.9381695, 6.81034, 11.247767, 11.0488615, 9.636426, 6.85738,
            3.0692322, 2.284203, 4.446228, 6.7445383, 10.666536, 10.169594, 8.543846, 5.817297,
            3.25098, 1.7509887, 3.133019, 4.5367956, 6.8455048, 6.9512854, 6.611244, 4.5787764,
            2.1974459, 1.1504066, 2.2282698, 3.3445232, 5.044937, 4.7042313, 4.4109783, 3.0688684,
            2.19594, 0.79970527, 1.2070556, 1.7898209, 2.6040158, 2.8188562, 3.1015012, 2.3488164,
            1.5537566,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6001484, 0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525, 0.7446416,
            0.471613, 0.72900707, 0.842964, 0.21457537, 0.938401, 0.41665936, 0.05351101,
            0.43856344, 0.7253113, 0.8520324, 0.4151233, 0.35101932, 0.7388761, 0.3592986,
            0.6741479, 0.9965808, 0.3117034, 0.8605703, 0.94308543, 0.8192489, 0.31478795,
            0.750324, 0.36604244, 0.78454614, 0.039194, 0.23696694, 0.2418382, 0.24788351,
            0.5622223, 0.15428482, 0.50688076, 0.37682602, 0.44385925,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.00051633, 0.53422695, 0.5675659, 0.53845215, 0.2130759, 0.86445093, 0.432881,
            0.6255918, 0.3942565, 0.07226853, 0.09869356, 0.32627374, 0.8543963, 0.85603166,
            0.25422713, 0.24929269, 0.36793318, 0.39957172, 0.9079535, 0.865758, 0.82237726,
            0.60374194, 0.7658025, 0.0215734, 0.473204, 0.6594781, 0.86392707, 0.8566667,
            0.48541847, 0.54855824, 0.5860555, 0.158874, 0.10558709, 0.19664533, 0.39609066,
            0.27843866, 0.49128443, 0.75033015, 0.35650545, 0.4687038, 0.6159849, 0.2547001,
            0.17250927, 0.07203952, 0.8724657, 0.14018923, 0.12091745, 0.4770398, 0.43290496,
            0.6356798,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(
        kernel9,
        Some(Array::from_shape_vec((1,), vec![0.7619444]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.99920386, 1.8378897, 2.998117, 3.4704857, 3.159452, 2.2860212, 1.601141, 0.9576808,
            2.0589786, 3.546905, 5.17761, 5.3266444, 4.876613, 3.5616212, 2.3052657, 1.1669701,
            2.1540139, 4.2232523, 6.6520486, 7.5054193, 7.357517, 4.910205, 3.160005, 1.3177878,
            2.6255379, 4.4759064, 6.55002, 8.536626, 8.871167, 7.0825515, 4.7650247, 1.9481918,
            2.7853398, 5.0344114, 8.093604, 9.755105, 10.399155, 8.781638, 6.1786747, 2.6309605,
            2.682476, 4.145001, 6.2221212, 7.8405843, 8.259751, 6.921629, 5.1088653, 2.708957,
            1.8435377, 2.9492192, 4.436238, 6.149936, 5.9987206, 5.2775626, 3.7510233, 2.745259,
            1.4452584, 1.8885673, 2.6195598, 3.7206821, 4.05144, 3.4007082, 2.721591, 2.4894977,
            1.4842656, 1.707455, 2.1414485, 2.3341703, 2.4399254, 2.2288704, 1.3756778, 1.3937359,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513, 0.06810815, 0.79673207,
            0.29373887, 0.55241185, 0.23906927, 0.18915932, 0.02753429, 0.1438574, 0.5419741,
            0.71984386, 0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286,
            0.21388301, 0.30016333, 0.49605927,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258, 0.26911622, 0.92149794,
            0.7165893, 0.04745785, 0.55642486, 0.34654748, 0.83168656, 0.8410765, 0.7668131,
            0.84094906, 0.6012723, 0.9256995, 0.66010624, 0.43380973, 0.62281454, 0.45852852,
            0.61445725, 0.524579, 0.06486581, 0.14233574, 0.13930365, 0.5838787, 0.45914945,
            0.30819193, 0.70949817, 0.8803759, 0.6927248,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(
        kernel10,
        Some(Array::from_shape_vec((1,), vec![0.50569826]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.8353897, 1.9975638, 2.596897, 2.2517145, 1.769388, 1.0967257, 1.3930148, 2.3948634,
            3.1140156, 3.1488695, 2.5461473, 1.017106, 1.7034304, 2.839642, 4.931988, 4.343891,
            3.6718488, 1.8577096, 1.6451614, 3.765725, 6.062338, 6.63053, 4.5396357, 2.17891,
            1.4102867, 2.4244843, 3.3371103, 4.299841, 2.784499, 1.4462214, 1.2491145, 1.9206078,
            3.197347, 3.5655267, 2.9014165, 1.5242047, 0.77269083, 1.0923748, 1.429096, 1.5940027,
            1.2872386, 0.86588645,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.7358748, 0.58652496, 0.85065925, 0.3247378, 0.6760192, 0.4483504, 0.59195757,
            0.37883574, 0.7796499, 0.32748002, 0.44507304, 0.7488422, 0.14428215, 0.8785777,
            0.15468395, 0.6638725, 0.30651525, 0.9492515, 0.55669755, 0.08302987, 0.45890567,
            0.05946975, 0.9099885, 0.30235246,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.24214035, 0.42138377, 0.38782486, 0.21880285, 0.9182205, 0.85290706, 0.5070326,
            0.5272234, 0.71761, 0.560904, 0.22129431, 0.2624427, 0.6557088, 0.00633, 0.6603214,
            0.45500925, 0.6523986, 0.14666249, 0.32440838, 0.2805719, 0.42671442, 0.74477625,
            0.9118973, 0.5335283, 0.36968935, 0.5693756, 0.36426732, 0.11819325, 0.95361024,
            0.13343851, 0.5940242, 0.7282295,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(
        kernel11,
        Some(Array::from_shape_vec((1,), vec![0.9320007]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            1.2043152, 1.9784515, 1.9470985, 2.027121, 1.6869259, 1.1615274, 2.1810048, 3.1784184,
            4.8373566, 4.2833257, 2.9980853, 1.82745, 2.6014018, 4.1725283, 6.106061, 5.2496915,
            3.6046867, 2.2157116, 2.9297633, 5.4878416, 6.8202662, 6.3237295, 4.949937, 2.5661347,
            2.734685, 3.8303452, 6.2020955, 5.478758, 4.147235, 2.642251, 2.1080132, 2.2109642,
            4.1269464, 3.087522, 2.4524722, 1.8532014, 1.2034432, 2.1016219, 2.0871627, 2.003847,
            2.4712749, 1.4929128,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.46956548, 0.5087874, 0.7952918, 0.73709416, 0.3358689, 0.03185032, 0.27057356,
            0.26166973, 0.5843129, 0.5337139, 0.19571388, 0.1192536, 0.75616854, 0.97167397,
            0.71154076, 0.26672947, 0.07128377, 0.3383284, 0.8008563, 0.9504947, 0.5971434,
            0.7847773, 0.92326206, 0.24163638,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.12968542, 0.5954836, 0.6734995, 0.08627631, 0.7485715, 0.8782484, 0.6863155,
            0.7264353, 0.08944888, 0.68172634, 0.4284322, 0.48237634, 0.6856524, 0.04009921,
            0.0687674, 0.9063645, 0.42620143, 0.61030614, 0.10040135, 0.50107217, 0.763057,
            0.25769317, 0.8816114, 0.7770131, 0.23345616, 0.62762326, 0.15315741, 0.73589575,
            0.2752067, 0.85641515, 0.7439484, 0.6581306,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(
        kernel12,
        Some(Array::from_shape_vec((1,), vec![0.4056261]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.788802, 1.62685, 2.1001892, 2.1730998, 1.5434694, 0.8307742, 1.5433999, 2.8108397,
            4.1451063, 4.0779977, 2.8234699, 1.7085054, 1.7558734, 3.583512, 4.5817804, 5.1040487,
            3.38765, 1.9485228, 2.2812202, 4.9857144, 6.8025913, 7.054431, 4.8104258, 2.878895,
            2.1939423, 3.3678916, 3.7910247, 5.479844, 3.3327677, 1.652837, 1.0424978, 2.6327772,
            3.5383298, 3.7310536, 2.6147022, 1.5635692, 0.9875443, 1.4874023, 1.9729719, 2.3178926,
            1.3786069, 0.67274165,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.13899311, 0.26460668, 0.9179794, 0.96651816, 0.89336777, 0.18948041, 0.9371178,
            0.7124811, 0.9657549, 0.6203675, 0.32684848, 0.11439406, 0.07654371, 0.95680344,
            0.9728639, 0.6055871, 0.00439729, 0.8525613, 0.3167563, 0.13499211, 0.68338645,
            0.7955047, 0.21689218, 0.2826704,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.12328367, 0.6890043, 0.5906649, 0.41700745, 0.30266365, 0.5716598, 0.12726787,
            0.35587692, 0.16889893, 0.3114892, 0.1309899, 0.24026695, 0.55435276, 0.34375766,
            0.4225387, 0.37165096, 0.6202945, 0.6069533,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(
        kernel13,
        Some(Array::from_shape_vec((1,), vec![0.05756181]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.09853993, 0.49401075, 0.8819063, 1.203671, 0.83352715, 0.46574494, 1.6234603,
            3.1218953, 1.9963491, 1.3101683, 1.0566504, 2.2365186, 4.3956413, 3.68432, 2.0062819,
            1.2962878, 2.2964528, 3.8764858, 2.1599598, 1.5833552, 0.99423766, 1.446145, 2.190934,
            1.4377084, 0.8202941, 0.43216476, 0.89398897, 1.0156437, 0.4604587, 0.24845059,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.0153275, 0.8497578, 0.79796964, 0.4071996, 0.19325097, 0.04944435, 0.59729165,
            0.39304134, 0.679002, 0.6126854, 0.67232877, 0.7156292, 0.09058711, 0.33372015,
            0.8941644, 0.30899736, 0.3348802, 0.6412177, 0.26750943, 0.03709449, 0.56803024,
            0.8756273, 0.5771133, 0.56024176,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.5868575, 0.75167763, 0.36936092, 0.37185487, 0.35425207, 0.24336162, 0.01027582,
            0.2671537, 0.83992416, 0.49819484, 0.7831867, 0.70054483, 0.8701863, 0.49413827,
            0.84670645, 0.8069649, 0.093459, 0.93408287,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(
        kernel14,
        Some(Array::from_shape_vec((1,), vec![0.8206956]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.87482065, 1.568108, 2.7036889, 2.6684625, 1.7418365, 1.298132, 2.3056052, 3.5647516,
            2.8799176, 2.2394502, 1.7980549, 2.6791174, 4.491156, 3.934264, 3.5298367, 2.3249109,
            3.5811906, 5.8245845, 3.646559, 2.7641735, 2.0324929, 2.441169, 4.3135543, 2.6025698,
            2.57011, 1.5335919, 1.5388309, 2.846214, 2.168015, 1.9450822,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.70209366, 0.32817394, 0.744203, 0.39091238, 0.43911496, 0.92919487, 0.29325068,
            0.62813336, 0.8131431, 0.19520658, 0.47931832, 0.42483747, 0.47526902, 0.28184402,
            0.09741595, 0.45691565, 0.44086096, 0.9638409, 0.33859608, 0.26381832, 0.29839757,
            0.68755937, 0.09156765, 0.58584654,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.04617033, 0.14705709, 0.81179595, 0.16751295, 0.06864621, 0.6308731, 0.38993102,
            0.3644169, 0.68174505, 0.272409, 0.23609333, 0.21866773, 0.80119157, 0.01742986,
            0.49270406, 0.37920174, 0.90869635, 0.8191268,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(
        kernel15,
        Some(Array::from_shape_vec((1,), vec![0.7636344]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.92551786, 1.0710188, 1.613216, 1.2241144, 1.3890771, 1.4045422, 1.4066285, 2.5622594,
            1.9793959, 2.2462068, 1.7549613, 2.371708, 4.3574476, 2.910411, 3.1372356, 1.6060402,
            2.2404175, 4.0478106, 3.8357713, 3.3196151, 1.5899446, 1.7021894, 3.17672, 2.3623173,
            2.1190836, 1.1004752, 1.6811774, 2.105604, 1.8525875, 1.5331478,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.7827788, 0.9694966, 0.79533535, 0.00732174, 0.8372113, 0.9449071, 0.7670253,
            0.50964797, 0.7843069, 0.7365313, 0.71123123, 0.89694643, 0.9544987, 0.16811895,
            0.97018677, 0.25394833, 0.5585159, 0.51973414, 0.4357872, 0.29419306, 0.5180376,
            0.80581653, 0.7190028, 0.52249014,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726, 0.25884646,
            0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234, 0.32747796,
            0.9097073, 0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446, 0.9843364,
            0.4038572, 0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686, 0.5288406,
            0.92906404, 0.87780553, 0.9090181, 0.82569945, 0.20383635, 0.7166643, 0.17061436,
            0.91526777, 0.08598401, 0.70100874, 0.40537685, 0.5971982, 0.92796123, 0.15859716,
            0.7859081, 0.8564488, 0.35816404, 0.79062706, 0.9644883, 0.13154314, 0.31929043,
            0.80048305,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(
        kernel16,
        Some(Array::from_shape_vec((1,), vec![0.07180241]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            1.422275, 1.1813705, 2.566993, 1.9637407, 2.5643537, 1.9319025, 1.4673944, 1.7586503,
            2.954078, 4.2621107, 4.0796156, 3.5880919, 3.4886599, 1.9002281, 2.7400596, 3.790728,
            6.543473, 4.3855085, 6.0309463, 4.341976, 3.1203544, 3.9092553, 5.107138, 8.728093,
            6.754502, 7.8948097, 6.094631, 3.4540963, 4.2136064, 6.740462, 8.856314, 7.14056,
            8.472874, 5.5202746, 3.5014474, 2.6762478, 4.0647635, 6.4745073, 4.6450977, 5.3856454,
            4.5898542, 2.595639, 2.46714, 2.8843207, 4.3899612, 3.904463, 4.0640635, 2.7324433,
            1.3798022, 1.4338973, 2.4150102, 2.8778365, 2.1785648, 2.4966228, 1.8838675, 1.1019901,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.52815664, 0.45786336, 0.91537887, 0.9783313, 0.25753945, 0.42799363, 0.07738555,
            0.9294206, 0.07022415, 0.60058224, 0.6196278, 0.9008346, 0.04155485, 0.82207745,
            0.41282526, 0.9949608, 0.3109271, 0.47614527, 0.7615821, 0.35893062, 0.07713356,
            0.6123928, 0.62511915, 0.88098776,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.21521498, 0.89468116, 0.1842307, 0.10784956, 0.8354833, 0.2630701, 0.7184675,
            0.06132602, 0.06056971, 0.71349823, 0.00944792, 0.07349233, 0.35231608, 0.8533961,
            0.17608605, 0.18067755, 0.51991457, 0.19053963, 0.5045173, 0.7456122, 0.27621788,
            0.48649722, 0.39297876, 0.54849166, 0.3746991, 0.8194284, 0.34880427, 0.79505837,
            0.41293454, 0.890512, 0.12076204, 0.20799449, 0.88948244, 0.24437675, 0.7731474,
            0.65954226, 0.4922565, 0.5211581, 0.97382414, 0.9779564, 0.1754263, 0.4551989,
            0.81067127, 0.7095975, 0.5087082, 0.78796804, 0.03310984, 0.20805901, 0.45704818,
            0.9133983,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(
        kernel17,
        Some(Array::from_shape_vec((1,), vec![0.5689028]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.7166212, 1.8281016, 1.9309139, 2.343943, 1.9328794, 1.9527028, 1.7013123, 1.738714,
            2.7092853, 3.2213016, 3.4739032, 3.946821, 2.4223335, 2.3227932, 1.6195397, 3.0188608,
            4.515488, 3.7907877, 5.5056996, 4.338683, 1.9346759, 2.0804749, 3.7569134, 6.6446595,
            7.2804255, 7.473506, 5.760664, 3.6493437, 1.8338137, 4.087558, 5.2633114, 6.6034045,
            7.8281593, 4.931093, 3.2619805, 2.1802893, 2.7754745, 4.5678964, 5.2221475, 6.258246,
            4.7146597, 2.2759724, 1.406322, 1.983942, 2.8368883, 3.667835, 4.412363, 3.1784122,
            1.7855084, 1.2173402, 1.5450867, 2.1974943, 2.0191953, 2.5161755, 2.2688136, 1.7111375,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.04247752, 0.55938286, 0.9835293, 0.04525762, 0.7176199, 0.82096803, 0.5575717,
            0.5744108, 0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355, 0.1134909,
            0.5645703, 0.30096474, 0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894,
            0.681929, 0.24701218, 0.74485576,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.61556435, 0.63869125, 0.05875124, 0.3210932, 0.96946657, 0.09463912, 0.6275637,
            0.34162354, 0.74390864, 0.8736778, 0.9513908, 0.24045336, 0.7003475, 0.87750345,
            0.16564246, 0.6314963, 0.21785556, 0.7654987, 0.13988015, 0.03287261, 0.82226163,
            0.60896695, 0.13331373, 0.62307173, 0.23316076, 0.9600204, 0.55291533, 0.29808274,
            0.8765127, 0.98263544, 0.27148733, 0.11101003, 0.2754741, 0.4540411, 0.19701396,
            0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969, 0.5836321, 0.17965508,
            0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643, 0.91682273, 0.6142979,
            0.19277428,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(
        kernel18,
        Some(Array::from_shape_vec((1,), vec![0.28408903]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.45359033, 0.84707206, 1.8985438, 1.4356375, 0.97716266, 1.7485697, 1.7923546,
            0.64543974, 1.4414368, 2.7798407, 2.5680442, 2.4571676, 3.6449409, 2.610918, 1.6182587,
            3.0230463, 4.872683, 5.045059, 5.812177, 5.356304, 3.0926945, 1.6276927, 3.4747987,
            6.2581472, 6.8174896, 7.331799, 5.483785, 3.3106697, 1.3954923, 3.6273003, 7.0082827,
            7.336202, 6.95615, 5.0769234, 2.0325844, 1.6763117, 3.2730243, 6.6450653, 6.0984416,
            5.9806857, 3.7978165, 1.1217375, 1.6491597, 2.266555, 4.7978535, 4.2576785, 3.9323056,
            2.5327907, 0.9015202, 0.7914068, 1.1672561, 2.240304, 2.0727472, 1.6552265, 1.4149456,
            0.6328027,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.25507236, 0.9800453, 0.36125833, 0.96792, 0.33258557, 0.9508625, 0.8424581,
            0.8130291, 0.7774976, 0.17691322, 0.9389267, 0.22419459, 0.33442205, 0.7614585,
            0.37563834, 0.70754576, 0.1499497, 0.9873837, 0.7166968, 0.40278858, 0.22288306,
            0.3279577, 0.07722609, 0.598755, 0.8143903, 0.87905455, 0.83061284, 0.9923988,
            0.6196494, 0.536406, 0.06662867, 0.83588266, 0.28182983, 0.662181, 0.99850965,
            0.60448396, 0.12318801, 0.91713256, 0.8540598, 0.19103892, 0.5929614, 0.9118344,
            0.9381113, 0.3421722, 0.8149188, 0.9595595, 0.02717085, 0.8916309, 0.9755575,
            0.27588442, 0.59208006, 0.00008138, 0.9552037, 0.12578069, 0.01249961, 0.05413999,
            0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439, 0.34315115, 0.52290094,
            0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794, 0.6930413, 0.90735817,
            0.91156703, 0.45996496,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.9045769, 0.17170428, 0.43418503, 0.69308424, 0.42869946, 0.9244341, 0.41451567,
            0.6224708, 0.00536506, 0.33826837, 0.47926104, 0.0032256, 0.02230139, 0.35960108,
            0.48593593, 0.86064774, 0.28908366, 0.4153976, 0.3468706, 0.2242362, 0.93169004,
            0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496, 0.11111139, 0.19382912,
            0.9307082, 0.9188555, 0.10532705, 0.88550454,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(
        kernel19,
        Some(Array::from_shape_vec((1,), vec![0.20754221]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.4738864, 1.4541656, 1.4839544, 2.5031877, 2.2633693, 2.563104, 1.8133557, 1.3001542,
            1.0710363, 1.4649254, 3.1260784, 4.443712, 4.680823, 5.8003817, 4.607085, 3.6461477,
            2.4835966, 1.3130808, 2.1141315, 4.0215735, 6.14331, 6.807788, 5.297416, 7.221894,
            3.8799133, 2.8503182, 1.3942733, 2.6877308, 4.353918, 6.941918, 7.5283213, 8.399872,
            7.8824883, 7.1266556, 3.2633219, 3.2033777, 3.089481, 5.1680965, 6.406161, 9.601822,
            8.304082, 8.818752, 6.636427, 3.900757, 2.2651126, 2.5992208, 4.895395, 6.3403106,
            8.77543, 10.107029, 9.49787, 6.457411, 4.7743015, 2.2996964, 1.6251682, 3.3882797,
            5.0057797, 6.4773226, 7.5606422, 7.7987404, 5.4504156, 3.2340088, 1.918381, 1.6027172,
            3.0370924, 3.5507576, 5.573451, 5.6797805, 5.882042, 4.395937, 2.4806192, 1.5133908,
            0.9517244, 1.862416, 2.1436985, 3.0745792, 3.915754, 3.119374, 2.8021555, 2.2162912,
            1.1350911,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.97926295, 0.3472928, 0.71126235, 0.03633394, 0.7482733, 0.28782296, 0.7382309,
            0.60003114, 0.3259743, 0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927,
            0.968827, 0.47373444, 0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834,
            0.3979838, 0.2393961, 0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945,
            0.66457146, 0.8425775, 0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123,
            0.48163053, 0.437191, 0.43973154, 0.29997745, 0.21913478, 0.6611514, 0.209788,
            0.176356, 0.88925517, 0.14793599, 0.36509594, 0.5616029, 0.6617385, 0.30053073,
            0.36820948, 0.62227124, 0.4957459, 0.69923055, 0.3227648, 0.9702412, 0.5679234,
            0.13432135, 0.7430913, 0.19231908, 0.26170298, 0.10480803, 0.00958306, 0.20726651,
            0.20851518, 0.17973869, 0.23704103, 0.1163867, 0.2735905, 0.8537909, 0.40303,
            0.75797635, 0.34342998,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.74670875, 0.82946825, 0.91931367, 0.9654975, 0.18782942, 0.10021565, 0.05109123,
            0.3069365, 0.10895161, 0.9891213, 0.62504834, 0.507994, 0.47125, 0.84314245, 0.6054993,
            0.92367506, 0.6953895, 0.37023902, 0.67128026, 0.43450755, 0.28869846, 0.27641538,
            0.8369712, 0.6856483, 0.26890948, 0.65425915, 0.84581685, 0.51146317, 0.48995435,
            0.52071315, 0.80564773, 0.670521,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(
        kernel20,
        Some(Array::from_shape_vec((1,), vec![0.3835857]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            1.418828, 1.9228296, 2.7678943, 3.0140264, 2.894975, 2.6074107, 1.9620092, 1.7987431,
            0.7526325, 1.367616, 2.5388112, 3.1463602, 4.75, 4.1805882, 3.8540926, 3.2854116,
            2.4419458, 1.2816973, 1.0476024, 3.1513877, 4.7968693, 6.838257, 6.9186525, 6.821128,
            5.5597067, 4.185332, 1.8386614, 2.3610482, 4.5190535, 6.8943405, 9.003118, 8.204397,
            8.283077, 6.612707, 4.861494, 2.1700664, 1.3711413, 2.9957185, 5.647418, 9.078336,
            9.156685, 9.640987, 8.337992, 5.0927906, 2.8187723, 1.3119097, 3.563639, 6.290327,
            8.486452, 9.6454, 9.666448, 7.4296207, 4.9072285, 2.4208922, 1.2571065, 2.0486372,
            3.2965763, 5.3136625, 5.7548027, 6.161931, 5.4508724, 3.3259847, 1.8288379, 0.52086186,
            1.2369487, 2.6301942, 4.1118336, 5.366438, 5.763543, 5.0599985, 3.0829725, 1.7411118,
            0.6433293, 1.2623825, 2.1592884, 3.0049143, 3.7404563, 3.5648625, 2.8934352, 1.9777455,
            1.0587327,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.47078377, 0.5100531, 0.82525116, 0.02126783, 0.9583153, 0.23316967, 0.9487504,
            0.9609589, 0.95734006, 0.00943314, 0.7521432, 0.46106157, 0.84370506, 0.16933449,
            0.71423984, 0.5316646, 0.6400151, 0.9638914, 0.69432026, 0.8581641, 0.70813745,
            0.2836983, 0.33953485, 0.8950543, 0.20262088, 0.81930757, 0.09556881, 0.22266188,
            0.63842744, 0.8304186, 0.12425002, 0.7582065, 0.09737789, 0.84872884, 0.17490041,
            0.37569723, 0.6669188, 0.8970669, 0.22398192, 0.29424527, 0.56277037, 0.41113177,
            0.7882464, 0.24159203, 0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633,
            0.9636684, 0.98529965, 0.26998708, 0.13811645, 0.9724998, 0.41856614, 0.13321315,
            0.0937838, 0.4742414, 0.79873264, 0.1621314, 0.5493846, 0.6481355, 0.05176858,
            0.17029643, 0.955536, 0.089831, 0.05664136, 0.9231865, 0.98567015, 0.01680515,
            0.54690886, 0.8593988,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.6496963, 0.8382851, 0.2400014, 0.36792266, 0.01756373, 0.6596718, 0.5680892,
            0.19350345, 0.4854058, 0.7869872, 0.12335967, 0.14544043, 0.25711668, 0.05608724,
            0.18204254, 0.9562488, 0.44598028, 0.3229758, 0.8930679, 0.24216229, 0.21437034,
            0.38366762, 0.64894366, 0.8650639, 0.7790032, 0.3529938, 0.37360683, 0.26240814,
            0.554433, 0.90017563, 0.6817857, 0.95833224,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(
        kernel21,
        Some(Array::from_shape_vec((1,), vec![0.28551313]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.8888123, 1.6270165, 2.3474605, 2.4529645, 2.0749624, 2.2312157, 1.4254307, 1.1975105,
            0.47086215, 1.4046915, 2.8351986, 4.4096766, 4.622999, 3.9009109, 3.906831, 2.935347,
            2.5035489, 1.0411309, 1.7870781, 4.0961285, 5.3955073, 6.9733286, 5.655955, 6.1187925,
            4.1704073, 3.2992935, 1.7682774, 2.5129638, 5.3375955, 7.1595335, 7.7724423, 7.983954,
            8.398762, 6.0667534, 4.698383, 2.5665956, 1.8890462, 4.7726927, 6.3606234, 7.8743114,
            7.184522, 8.047427, 6.7090096, 4.638953, 2.49546, 1.4173665, 3.6895218, 6.2479186,
            8.048492, 7.8625774, 7.1562796, 6.6551332, 4.833001, 2.8966727, 1.2367516, 2.5666468,
            3.4646535, 4.472505, 6.336514, 5.797571, 4.222465, 3.4068022, 2.2572658, 0.74664277,
            2.5664058, 3.1537993, 3.1214442, 4.5201163, 3.3087573, 2.5095503, 2.560521, 1.4458427,
            0.34886372, 1.0502617, 1.7918304, 2.346327, 2.9959338, 2.5643933, 2.3126097, 1.6312006,
            1.4683627,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.85106283, 0.70093375, 0.4791875, 0.5805011, 0.9803199, 0.97033703, 0.48236644,
            0.66855663, 0.35855147, 0.25242767, 0.6717967, 0.26290378, 0.53677225, 0.18097793,
            0.07985484, 0.79416144, 0.7215235, 0.42313012, 0.6529702, 0.00384528, 0.08442257,
            0.7838985, 0.980683, 0.36212954, 0.61172485, 0.5263662, 0.8496614, 0.13177402,
            0.9175598, 0.04323238, 0.03087392, 0.03482862, 0.36226457, 0.6059544, 0.29194582,
            0.34645593, 0.9409913, 0.60953087, 0.8610255, 0.1627552, 0.8939359, 0.66327935,
            0.48094535, 0.06551108, 0.86129206, 0.65446067, 0.9592776, 0.8000413, 0.21450381,
            0.6442533, 0.46971878, 0.84573215, 0.34651902, 0.18830031, 0.57119006, 0.27269888,
            0.7915957, 0.21737069, 0.04463017, 0.393406, 0.8441482, 0.77705365, 0.6315176,
            0.8522896, 0.16809769, 0.22305161, 0.773223, 0.9678148, 0.2237789, 0.8982615, 0.271913,
            0.34780893,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.49277794, 0.14560463, 0.33638617, 0.1585067, 0.18610527, 0.6963084, 0.9429821,
            0.40789625, 0.20056698, 0.37306353, 0.9367061, 0.7103306, 0.06833509, 0.48335183,
            0.45182207, 0.96346164, 0.00378525, 0.33689302,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(
        kernel22,
        Some(Array::from_shape_vec((1,), vec![0.28288215]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            1.0533166, 1.8610315, 2.4679437, 2.174711, 2.1092393, 2.2994652, 2.0102217, 1.0804377,
            0.89920676, 1.9234834, 3.021107, 3.1537986, 3.4798756, 3.5484786, 3.5656402, 1.9149513,
            2.4458852, 2.923114, 4.342534, 4.271616, 5.6195035, 5.1442485, 3.2426453, 1.5215828,
            1.8357172, 2.1850421, 4.0613494, 3.7159812, 4.6789365, 4.095089, 2.462616, 1.3861113,
            1.7546129, 3.139926, 4.2438707, 4.6247945, 4.691212, 3.580852, 2.3215003, 1.0340717,
            1.9072638, 2.5831451, 4.643152, 4.2169456, 4.7809615, 3.8245718, 2.142119, 0.9825341,
            1.7307642, 2.2317538, 3.2351115, 2.7391562, 2.715385, 2.3192475, 1.1007559, 0.7650856,
            1.0569663, 1.2636976, 1.1246492, 2.2013757, 1.2187741, 1.4889498, 0.57567704,
            0.46954417,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.75004077, 0.1607512, 0.514175, 0.35879079, 0.36688787, 0.00774159, 0.15532039,
            0.01133456, 0.94680935, 0.052598, 0.73530346, 0.8096563, 0.7097644, 0.37942106,
            0.38656324, 0.13763146, 0.99930644, 0.67476803, 0.06055127, 0.8463604, 0.4460729,
            0.33209085, 0.94373864, 0.5397614, 0.05766413, 0.64256257, 0.7357459, 0.09256811,
            0.8832945, 0.03911254, 0.782554, 0.4004812, 0.80732703, 0.8010379, 0.28867772,
            0.7802926, 0.9490529, 0.5395702, 0.1369102, 0.4513485, 0.1162144, 0.9589836,
            0.24819064, 0.3149064, 0.22322156, 0.39812055, 0.45308354, 0.5711523, 0.97817534,
            0.06805564, 0.5386646, 0.6699801, 0.1879456, 0.8407316, 0.64728755, 0.53731096,
            0.63207716, 0.00916763, 0.46754488, 0.8670982, 0.1932068, 0.43971533, 0.10441232,
            0.46486124, 0.22910197, 0.7679019, 0.23872072, 0.03931138, 0.8551502, 0.19610135,
            0.8555064, 0.08035298,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.05671094, 0.9091975, 0.27582648, 0.33816597, 0.42012835, 0.7745094, 0.14011143,
            0.47505257, 0.98297566, 0.5085966, 0.22395916, 0.01153891, 0.669607, 0.12918296,
            0.55476546, 0.528783, 0.5067741, 0.14234911,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(
        kernel23,
        Some(Array::from_shape_vec((1,), vec![0.5152856]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            1.0405061, 1.6933098, 1.0989054, 1.3139017, 1.1658967, 1.4672334, 0.8396358,
            0.52848655, 1.5394536, 1.7262655, 2.319254, 2.7194414, 2.0732558, 2.9829907, 2.063149,
            1.2832077, 1.8786802, 2.892919, 3.5181284, 3.1732488, 3.575231, 4.421094, 3.6965241,
            1.7991679, 1.8959402, 2.002678, 4.131732, 3.2211003, 3.9791198, 4.8576493, 4.197624,
            2.54037, 1.6874133, 2.5481548, 4.1066713, 4.185518, 3.6443415, 4.6154146, 4.0538597,
            2.216979, 1.1807088, 2.6433644, 3.6076021, 4.5957313, 4.220671, 4.082515, 3.9491324,
            1.8417397, 1.0500116, 1.4844997, 3.0433426, 3.0545454, 3.9098644, 2.8983717, 2.8602805,
            1.3119633, 0.7511618, 1.0849166, 2.093975, 1.9473653, 2.4033368, 2.053104, 1.3322301,
            1.2937324,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.6446142, 0.9118427, 0.8193508, 0.989135, 0.7842302, 0.59264964, 0.35247177,
            0.48483032, 0.22649786, 0.04158387, 0.5814206, 0.8653732, 0.4524277, 0.44947338,
            0.5519129, 0.79122764, 0.7513198, 0.9315116, 0.03313805, 0.41213843, 0.45310238,
            0.01799934, 0.4328227, 0.23842481, 0.20688592, 0.57869387, 0.9324833, 0.43915927,
            0.53123087, 0.5324186, 0.4149537, 0.22217223, 0.0080786, 0.65063345, 0.7681623,
            0.8421627, 0.27179125, 0.68530315, 0.9955617, 0.77906156, 0.18006648, 0.5975193,
            0.6555531, 0.9498266, 0.9690994, 0.5122471, 0.3840358, 0.8757204, 0.7260429,
            0.04691354, 0.40678895, 0.35535267, 0.19270384, 0.23519029, 0.6665529, 0.26402712,
            0.55168146, 0.08576613, 0.9567203, 0.57141143, 0.20602623, 0.75538653, 0.96776,
            0.44755465, 0.82362133, 0.29203537, 0.30861592, 0.39762703, 0.26186082, 0.9658112,
            0.27424002, 0.50570756,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.8114843, 0.5536027, 0.59788686, 0.05054026, 0.28394443, 0.6402348, 0.02258505,
            0.60607, 0.6834324, 0.8004999, 0.3349493, 0.4295082, 0.37033585, 0.0394791, 0.50698835,
            0.29841292, 0.9388161, 0.84357476,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(
        kernel24,
        Some(Array::from_shape_vec((1,), vec![0.29760668]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            1.0382699, 2.0340343, 2.9959276, 3.3504925, 2.8041553, 2.677316, 1.3720587, 0.9085835,
            1.2416352, 2.359723, 3.5825906, 3.43092, 3.2703464, 3.9055188, 2.367824, 1.8735013,
            1.6021954, 2.5667164, 5.2029543, 5.9284887, 5.765402, 5.351823, 3.8792968, 2.8626716,
            1.3534049, 2.405686, 4.969147, 4.165699, 4.475004, 4.0523424, 4.2111354, 2.7313683,
            1.1058172, 2.6897426, 4.7003536, 4.2909603, 5.316653, 3.9955323, 3.6753507, 2.0187368,
            1.1677935, 2.2391102, 3.2446368, 4.561845, 4.665111, 4.9543133, 4.214487, 2.1522372,
            0.4990235, 1.1433935, 2.5808477, 3.6945276, 3.1965735, 3.534652, 2.8422368, 1.7034023,
            0.39907342, 0.96250606, 1.4278158, 1.338515, 1.9242613, 2.4499557, 2.0391116,
            1.2997701,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.25654384, 0.71037215, 0.14646496, 0.9906275, 0.9552909, 0.7966291, 0.6094893,
            0.7271988, 0.09518696, 0.3957746, 0.6157527, 0.31079137, 0.46793708, 0.8514491,
            0.86081386, 0.8208274, 0.2372746, 0.6977758, 0.79387194, 0.9463199, 0.99063903,
            0.29514915, 0.8795419, 0.741553, 0.03520088, 0.83411527, 0.47134155, 0.26704508,
            0.2872401, 0.04289522, 0.583651, 0.94414073, 0.5729697, 0.72244126, 0.7707775,
            0.02079507, 0.22973806, 0.18128674, 0.05054512, 0.6523751, 0.27093726, 0.32479268,
            0.53774405, 0.08921466, 0.18494032, 0.78120434, 0.15868789, 0.81183356, 0.21792394,
            0.6620494, 0.6886836, 0.39724785, 0.59319293, 0.02472531, 0.21891202, 0.5342134,
            0.4041879, 0.53426075, 0.20461221, 0.29362342, 0.7835011, 0.47930118, 0.2895624,
            0.7320774, 0.55179524, 0.37774232, 0.04187773, 0.23883641, 0.63051957, 0.97746944,
            0.6415133, 0.4162999,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.04763152, 0.75958186, 0.13098118, 0.6238241, 0.4102024, 0.5710282, 0.59153587,
            0.66274744, 0.6454271, 0.8120847, 0.22876394, 0.6206928, 0.19057496, 0.4622738,
            0.9772445, 0.17967562, 0.27354005, 0.48198408, 0.09082693, 0.6217685, 0.0965838,
            0.8904992, 0.5337058, 0.17222154, 0.62424076, 0.95776683, 0.998361, 0.150883,
            0.28713444, 0.35105017, 0.1765902, 0.9674033, 0.65025777, 0.1959308, 0.3119046,
            0.55247456, 0.38556734, 0.18145509, 0.94255227, 0.7036003, 0.3402552, 0.16401337,
            0.28418577, 0.5504918, 0.6148071, 0.7740251, 0.37459207, 0.25677747, 0.80441076,
            0.17314304,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(
        kernel25,
        Some(Array::from_shape_vec((1,), vec![0.5946227]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.8268777, 1.2263167, 1.4388509, 1.7747478, 3.0112839, 2.6288624, 2.5731137, 2.0570748,
            1.6718135, 1.0354204, 1.3257501, 2.5261872, 2.5862517, 3.8776436, 5.529293, 5.782983,
            4.817607, 4.0408688, 2.7679844, 1.7553389, 1.4542398, 3.6645045, 4.7170277, 5.7602234,
            8.286184, 7.5361376, 6.6173162, 5.5465355, 4.050357, 2.402161, 1.7085745, 4.1621113,
            5.907156, 8.680738, 9.595843, 10.708813, 8.158373, 6.496876, 5.0410194, 3.1461802,
            2.5612178, 5.0928483, 7.691169, 9.590214, 12.974835, 13.34772, 10.541516, 7.818345,
            5.3479834, 3.3837907, 1.7568648, 5.207456, 7.823289, 10.16873, 12.829895, 13.8679695,
            10.279081, 6.8722134, 5.1062675, 2.6168494, 1.8072152, 4.0391207, 6.390901, 8.829282,
            11.841602, 11.081169, 9.007882, 6.5228267, 3.853, 2.1305118, 1.270311, 3.0659008,
            4.531842, 6.308111, 7.485772, 8.110085, 7.0187526, 5.1668262, 3.8792896, 1.6805093,
            1.323589, 1.7884402, 2.9146993, 4.24136, 4.350176, 4.8223557, 4.023946, 3.1029363,
            2.285427, 0.9556769, 0.6834083, 1.4061046, 2.390474, 2.8668268, 3.3691142, 3.7187018,
            2.7227259, 1.9816215, 1.5253046, 0.6796832,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.30094627, 0.06480476, 0.5798754, 0.62549657, 0.6065069, 0.9259787, 0.3677915,
            0.69532603, 0.8356569, 0.39276573, 0.18570696, 0.61698794, 0.9064707, 0.01547038,
            0.2551995, 0.11438051, 0.03861368, 0.6524532, 0.36442748, 0.08230381, 0.79969245,
            0.27816203, 0.3741886, 0.44356522, 0.27386904, 0.4171807, 0.14990133, 0.4750283,
            0.6358263, 0.77572674, 0.7072159, 0.34310365, 0.36999545, 0.8200852, 0.46510443,
            0.9230857, 0.86201537, 0.04691705, 0.12260284, 0.89921826, 0.47400048, 0.7492544,
            0.05440097, 0.28273952, 0.9184355, 0.9064988, 0.7027802, 0.19125043, 0.8670149,
            0.08634489, 0.722654, 0.77540857, 0.00211577, 0.6443405, 0.2344423, 0.9849179,
            0.9893316, 0.87634915, 0.48734385, 0.8760625, 0.53053117, 0.01152504, 0.6788874,
            0.76156837, 0.4680538, 0.07214947, 0.549209, 0.8383253, 0.00365476, 0.9782156,
            0.7419056, 0.40790308,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.00302504, 0.80174476, 0.7689671, 0.50054824, 0.16478458, 0.89107823, 0.7763043,
            0.73042727, 0.41667554, 0.7348974, 0.71259016, 0.93557405, 0.37013116, 0.14954911,
            0.33766475, 0.39673004, 0.03940821, 0.2414454, 0.9373305, 0.84819096, 0.9272432,
            0.8604789, 0.92845494, 0.8023847, 0.06647868, 0.12827316, 0.02774826, 0.8982795,
            0.1193029, 0.37523487, 0.28379655, 0.0638791, 0.08446726, 0.68760884, 0.2630593,
            0.01052708, 0.45302406, 0.10402057, 0.5539082, 0.39986408, 0.53770447, 0.24856173,
            0.12796782, 0.80071914, 0.38390577, 0.6908975, 0.5850918, 0.71101063, 0.17578217,
            0.55867785,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(
        kernel26,
        Some(Array::from_shape_vec((1,), vec![0.71616316]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.827647, 0.98757887, 1.7926512, 1.6471714, 2.2723613, 2.9363918, 2.933451, 2.901876,
            1.5468528, 1.1498966, 1.2370577, 1.4106705, 2.6309533, 4.5483265, 5.2364073, 5.2333884,
            5.364401, 3.9585884, 2.8135586, 1.7671947, 1.3968157, 3.18567, 4.8341146, 5.328919,
            6.491467, 6.5570874, 6.3966074, 5.025307, 2.7845428, 2.1814597, 2.6466916, 3.083066,
            4.633713, 7.853328, 7.5314255, 8.674434, 8.393978, 6.6045456, 4.737308, 3.1248302,
            2.8811615, 4.168442, 6.517303, 8.164421, 11.534599, 13.085146, 12.141663, 8.201509,
            5.390836, 2.9823496, 2.6499481, 4.0368443, 7.606692, 11.490995, 11.458963, 12.814602,
            11.171516, 7.5368786, 5.512669, 3.0591092, 3.41313, 4.63404, 6.068897, 8.064407,
            9.57762, 10.60844, 9.038876, 7.171313, 4.7383204, 2.9085312, 2.1197093, 3.4018512,
            5.15453, 7.079838, 8.324499, 8.682005, 7.080823, 6.0401177, 3.8447857, 2.3955498,
            1.912535, 2.408295, 2.9330919, 5.0771375, 6.508962, 5.636642, 5.4654713, 4.913412,
            3.5262084, 1.7475901, 1.7513714, 2.5433826, 2.894606, 4.0515547, 4.0606527, 4.9338207,
            3.5650663, 2.9678621, 1.9739408, 1.0054151,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.3247584, 0.9196999, 0.46712968, 0.08430128, 0.83232373, 0.49657014, 0.24024557,
            0.60874844, 0.47418702, 0.9770886, 0.99522823, 0.7749884, 0.7253688, 0.26021662,
            0.8869578, 0.5181486, 0.5871326, 0.76900613, 0.5745777, 0.81429285, 0.78002185,
            0.7069771, 0.33134556, 0.7407027, 0.58577555, 0.40479863, 0.7506117, 0.11343616,
            0.8795398, 0.83064, 0.8858372, 0.3898591, 0.9350765, 0.9673369, 0.64465624, 0.0283905,
            0.22112074, 0.1391855, 0.34128338, 0.65248054, 0.291874, 0.70765275, 0.32796225,
            0.22921298, 0.59572685, 0.5726663, 0.72872376, 0.8248998, 0.29288608, 0.92347336,
            0.25887516, 0.91578674, 0.800785, 0.7670362, 0.8990461, 0.8424308, 0.7045559,
            0.43518323, 0.48451254, 0.31151697, 0.10086012, 0.5242353, 0.19001916, 0.01069371,
            0.01020448, 0.12606935, 0.04778918, 0.8456499, 0.57045126, 0.46361542, 0.7532553,
            0.62787765,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.3127784, 0.9686197, 0.96754897, 0.5766132, 0.6463905, 0.6347338, 0.52757853,
            0.55145216, 0.08155768, 0.13378453, 0.2262157, 0.73179847, 0.5428326, 0.9094368,
            0.2528448, 0.24383228, 0.7446406, 0.5544842, 0.01949351, 0.13375893, 0.04438103,
            0.8489, 0.6848837, 0.9220802, 0.00185038, 0.44556108, 0.00844186, 0.8082305,
            0.33159012, 0.5138473, 0.65069795, 0.9300001, 0.58097035, 0.5413155, 0.5714561,
            0.21683556, 0.8548128, 0.02262598, 0.62476623, 0.33444464, 0.98826236, 0.03221937,
            0.12669064, 0.50246465, 0.42635268, 0.91064155, 0.7792924, 0.07601635, 0.6067355,
            0.3940292,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(
        kernel27,
        Some(Array::from_shape_vec((1,), vec![0.30074376]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.500844, 0.9668557, 1.983865, 2.3361137, 2.4061017, 3.2374768, 2.5712018, 2.3196247,
            1.5097082, 0.98534745, 0.8720326, 1.8800609, 3.2443764, 4.123512, 5.724642, 6.6084895,
            6.1424503, 4.753616, 2.7406075, 1.6963873, 1.1454308, 3.1308773, 4.590857, 7.43871,
            8.86041, 9.718573, 8.661221, 6.3789396, 4.0506005, 2.129263, 1.9552088, 4.1703963,
            7.599061, 9.736346, 11.487822, 12.53389, 10.6869135, 7.3008633, 4.624923, 2.3207734,
            2.3046775, 5.653737, 9.107517, 11.764907, 13.309617, 13.962741, 11.518028, 7.814377,
            5.4175596, 2.3656397, 2.1371071, 6.4356112, 8.371501, 11.971558, 14.829518, 14.726566,
            12.037852, 7.865898, 5.0270553, 1.8727243, 2.3759935, 5.514812, 7.736665, 9.745485,
            11.180745, 11.153776, 8.32467, 5.7823544, 4.132566, 1.451082, 1.5982127, 4.309305,
            5.6386237, 7.150413, 8.100024, 8.090016, 6.4526916, 3.6086946, 2.3988154, 0.80688536,
            0.6818124, 2.9639184, 3.274663, 3.7925134, 4.5133677, 4.7446356, 3.0089726, 2.5142329,
            1.8722203, 0.6234506, 0.38357693, 1.8773592, 2.4620082, 3.181297, 3.774583, 4.2480464,
            2.712678, 1.6038363, 1.0058751, 0.5481984,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.1328066, 0.72018456, 0.34319454, 0.6295161, 0.03357495, 0.03066352, 0.51702976,
            0.9283114, 0.36689135, 0.6327302, 0.37459058, 0.93406814, 0.33968034, 0.59511477,
            0.4350908, 0.7094508, 0.29612544, 0.80898666, 0.7905302, 0.4748418,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.6989706, 0.85952836, 0.70326394, 0.38940284, 0.37933362, 0.22292, 0.3949557,
            0.27719194, 0.8619771, 0.9255003, 0.30563155, 0.5844432, 0.36121982, 0.09087573,
            0.23811613, 0.17829578,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(
        kernel28,
        Some(Array::from_shape_vec((1,), vec![0.9398569]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            1.0326848, 1.5573958, 1.8921568, 2.2330508, 2.0262098, 1.5450724, 1.2086043,
            0.95293105, 1.0116678, 1.6303971, 2.3978672, 3.0063176, 3.0398946, 2.454461, 1.7154591,
            1.1955506, 1.3277926, 2.8613718, 3.7260313, 4.1673536, 4.3272223, 2.8319507, 2.2073576,
            1.3042928, 1.6522405, 2.9407206, 4.2529006, 5.2515893, 5.076581, 4.099571, 2.4464774,
            1.6211464, 1.5429401, 2.551715, 3.2543216, 3.4109082, 3.848473, 2.6756406, 2.0433936,
            1.4385781, 1.6866968, 2.2231522, 2.424859, 3.410173, 2.9597845, 2.33555, 1.7567122,
            1.2949498, 1.1961246, 1.1112951, 1.4279212, 1.4959337, 1.4286499, 1.3154854, 1.1938726,
            1.0245192,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.04807154, 0.7588201, 0.05337733, 0.19222781, 0.98696715, 0.32119673, 0.3872288,
            0.74463385, 0.6260977, 0.0084233, 0.31085488, 0.10247751, 0.60939455, 0.00353958,
            0.22236562, 0.31823838, 0.9627444, 0.866447, 0.8205645, 0.7792785,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.61566937, 0.59327537, 0.33567885, 0.96525836, 0.47292593, 0.2669342, 0.705448,
            0.28257245, 0.02662205, 0.05098573, 0.8293213, 0.9416077, 0.9101412, 0.07020015,
            0.8425068, 0.9708137,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(
        kernel29,
        Some(Array::from_shape_vec((1,), vec![0.3117258]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.34132197, 0.80742776, 0.81091446, 0.76286334, 1.7837903, 1.0133188, 0.82857925,
            1.264404, 0.53221107, 1.1123865, 1.3694367, 2.2330399, 2.0822449, 1.6597998, 1.6694715,
            0.5987462, 0.65629166, 0.85076183, 1.6141417, 2.551105, 2.3548925, 1.9474022,
            1.5721622, 1.4580822, 0.70696956, 1.9453964, 2.5063071, 3.8286862, 5.7711525,
            3.6237724, 3.1379054, 2.0928578, 0.76283896, 1.2455397, 2.457744, 3.3691986, 3.4454646,
            3.1825087, 1.8960016, 0.74948704, 0.6031198, 0.46867272, 1.4715269, 1.9099488,
            2.8149376, 2.4580235, 1.9214289, 1.261376, 0.60136765, 1.2102995, 1.4360178, 2.239449,
            2.743216, 1.898921, 1.7648885, 1.0682601,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.11623824, 0.19467542, 0.09732427, 0.43287596, 0.20617688, 0.8857049, 0.9601851,
            0.09430943, 0.28105715, 0.6942895, 0.07089514, 0.7148581, 0.00085336, 0.23516753,
            0.04615124, 0.59699446, 0.53420085, 0.75324225, 0.38793716, 0.2669936,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.29911962, 0.7380972, 0.17850904, 0.65695775, 0.8119258, 0.26960826, 0.12972821,
            0.6597052, 0.7345929, 0.6485681, 0.22981846, 0.24392553, 0.26706976, 0.32711208,
            0.9581323, 0.31259444,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(
        kernel30,
        Some(Array::from_shape_vec((1,), vec![0.91530424]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.95007336, 1.0593306, 1.1088548, 1.2277356, 1.4417472, 1.208693, 1.2364899, 1.0507537,
            1.2746128, 2.0456514, 1.9569159, 2.301896, 2.4032247, 1.7158345, 1.5362014, 1.5074391,
            1.7410247, 2.418248, 2.1306643, 2.577155, 3.359689, 1.5347147, 1.5064943, 1.4539418,
            1.8331149, 3.4850597, 2.9407167, 3.480193, 3.6384506, 2.7704928, 1.9399285, 1.3549587,
            1.6886435, 2.6272616, 3.416805, 3.554151, 2.7156692, 2.1445994, 2.026913, 1.3197298,
            1.372786, 1.9090236, 2.25429, 2.727376, 1.9799838, 1.6020429, 1.1890231, 0.99485743,
            1.0747434, 1.2532573, 1.8632157, 1.9637575, 2.002203, 1.6097956, 1.2923864, 0.998765,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );

    let test_input31 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.17250775, 0.715259, 0.5014661, 0.7273789, 0.23862323, 0.4093651, 0.04974006,
            0.8688277, 0.46409306,
        ],
    )
    .unwrap();

    let kernel31: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.20740515, 0.19872624, 0.27135858, 0.02647329, 0.90772045, 0.97377276, 0.47016057,
            0.06899374, 0.47393376, 0.49847803, 0.02369655, 0.10663922, 0.02373338, 0.21085607,
            0.56809616, 0.70259374,
        ],
    )
    .unwrap();
    let conv_layer31 = TransposedConvolutionLayer::new(
        kernel31,
        Some(Array::from_shape_vec((1,), vec![0.4123619]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output31: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.4481409, 0.5949921, 0.7053207, 0.7106749, 0.5673743, 0.42563733, 0.71981287,
            1.4236414, 1.9748646, 1.4142246, 0.81488174, 0.45779717, 1.1646922, 1.9523277,
            2.2390027, 1.5879894, 0.85838675, 0.50636756, 0.80633557, 1.7784739, 2.293971,
            2.1967607, 1.5130684, 0.84036267, 0.45319855, 1.0079585, 1.5398333, 1.4025245,
            0.91622436, 0.74946976, 0.4135424, 0.44347012, 0.6348311, 1.0387435, 1.2864443,
            0.73843074,
        ],
    )
    .unwrap();
    let current_output31: Array3<f32> = conv_layer31.transposed_convolve(&test_input31);

    assert!(
        arr_allclose(&current_output31, &target_output31),
        "{:?} was not equal to {:?}",
        current_output31,
        target_output31
    );

    let test_input32 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.01858313, 0.25862443, 0.4823392, 0.47215322, 0.593886, 0.8265343, 0.06712108,
            0.3228139, 0.11140465,
        ],
    )
    .unwrap();

    let kernel32: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.59627575, 0.49184018, 0.8395536, 0.13370071, 0.25792846, 0.54400545, 0.8792363,
            0.58678144, 0.03434712, 0.8123595, 0.67917913, 0.02545591, 0.2468276, 0.9191908,
            0.02958322, 0.20474248,
        ],
    )
    .unwrap();
    let conv_layer32 = TransposedConvolutionLayer::new(
        kernel32,
        Some(Array::from_shape_vec((1,), vec![0.76555794]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output32: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.7766386, 0.92890936, 1.1959685, 1.2224054, 1.2050858, 0.830047, 1.0518845, 1.4287176,
            2.228336, 2.2344983, 2.114727, 1.1590939, 0.9280006, 1.42507, 2.237793, 2.917159,
            2.3116271, 1.2777262, 0.80367434, 1.3702086, 2.2177646, 2.6910124, 1.6966335,
            0.95072365, 0.8844038, 1.4117584, 1.8410864, 1.9509974, 0.9954844, 0.9376205,
            0.7821253, 0.9069344, 1.091769, 0.8912525, 0.83494735, 0.7883672,
        ],
    )
    .unwrap();
    let current_output32: Array3<f32> = conv_layer32.transposed_convolve(&test_input32);

    assert!(
        arr_allclose(&current_output32, &target_output32),
        "{:?} was not equal to {:?}",
        current_output32,
        target_output32
    );

    let test_input33 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.82307637, 0.24628638, 0.17773865, 0.17740512, 0.4937253, 0.9466453, 0.13741271,
            0.728613, 0.5338591,
        ],
    )
    .unwrap();

    let kernel33: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.7898385, 0.47936276, 0.23633894, 0.8572216, 0.06004518, 0.3347224, 0.50485814,
            0.09635731, 0.18004768, 0.24514198, 0.228041, 0.05106571, 0.30884218, 0.38737774,
            0.7948706, 0.5052517,
        ],
    )
    .unwrap();
    let conv_layer33 = TransposedConvolutionLayer::new(
        kernel33,
        Some(Array::from_shape_vec((1,), vec![0.23866583]).unwrap()),
        1,
        Padding::Valid,
    );
    let target_output33: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.8887632, 0.8277444, 0.69163615, 1.087633, 0.4917944, 0.39102724, 0.428209, 1.0039608,
            1.7736106, 1.2243565, 0.99909127, 1.0672771, 0.506045, 1.2151641, 1.6338127, 1.5095552,
            1.5680245, 0.7965939, 0.5330589, 0.85569924, 1.7204466, 1.8326373, 1.0851983,
            0.4282509, 0.31819686, 0.6247425, 1.1693716, 1.391499, 1.3995308, 0.74422187,
            0.28110468, 0.5169229, 0.79501784, 1.0940521, 1.0311477, 0.50839907,
        ],
    )
    .unwrap();
    let current_output33: Array3<f32> = conv_layer33.transposed_convolve(&test_input33);

    assert!(
        arr_allclose(&current_output33, &target_output33),
        "{:?} was not equal to {:?}",
        current_output33,
        target_output33
    );
}
