// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_torch_transpose_stride2() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637, 0.14352316, 0.8997107, 0.64410555,
            0.04471071, 0.767672, 0.43464628, 0.16569944, 0.18875164, 0.12285258, 0.2781115,
            0.5390728, 0.5066572, 0.97435564, 0.39133722,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(kernel1, 2, Padding::Valid);
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            0.502705, 0.33985585, 0.8279686, 1.0468774, 1.1399916, 1.095575, 0.92409825, 1.2238286,
            0.15038757, 0.68886304, 0.59492445, 0.12465733, 1.3365544, 0.5571886, 1.5241804,
            0.5376345, 1.3512745, 0.29408306, 0.59559774, 0.30909574, 0.5881587, 0.44447196,
            1.7214268, 1.597253, 2.45496, 2.2933457, 2.4011168, 2.2345557, 0.68456775, 1.4955748,
            0.9990853, 0.4590318, 3.1386993, 1.3903263, 3.86348, 1.8105443, 3.473777, 1.6277075,
            1.8794243, 0.74786395, 0.31107634, 0.25570893, 0.91120994, 0.87130654, 2.072812,
            1.4480093, 1.9799176, 1.9871776, 0.6412851, 1.0280609, 0.63507986, 0.36439386,
            2.2985206, 1.1666975, 3.568377, 1.7900283, 3.356094, 1.9325955, 1.7019255, 1.1152639,
            1.1062762, 0.64626634, 1.477261, 1.7890793, 1.6973181, 1.479852, 1.2202978, 1.6375108,
            0.28583828, 0.65518975, 1.3803257, 0.5219913, 2.607832, 1.1490655, 2.6241403,
            1.0004312, 2.6608715, 1.6072481, 1.1410483, 0.47016898, 0.92114687, 0.52208376,
            1.9352266, 1.556231, 2.162416, 1.7345943, 1.4572903, 1.7489198, 0.43402213, 0.74943554,
            1.631637, 0.84429, 3.3093083, 1.5147332, 2.9818506, 1.782845, 2.8619628, 1.1844623,
            0.9650073, 0.46435708, 0.173569, 0.10594045, 0.6038621, 0.3124579, 0.72121084,
            0.39155364, 0.71057093, 0.36060572, 0.2546881, 0.15990391, 0.5252309, 0.24766012,
            1.2192905, 0.8592037, 1.551678, 1.02389, 1.2719585, 1.0262538, 0.53750235, 0.3887366,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.7964828, 0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183,
            0.81628793, 0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133,
            0.0067116, 0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715,
            0.7567798, 0.23972042, 0.38848338, 0.00744711, 0.8715701, 0.07988323, 0.6283005,
            0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194, 0.34163022, 0.03235205,
            0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.97700953, 0.18019113, 0.775954, 0.14120784, 0.3426181, 0.5417864, 0.7768226,
            0.34603763, 0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802, 0.629322,
            0.60627973, 0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678, 0.89887625,
            0.6572328, 0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983, 0.6908677,
            0.5511301, 0.36253917, 0.36786652, 0.88718724,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(kernel2, 2, Padding::Valid);
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            0.80761784, 0.22071062, 1.8073249, 0.872546, 1.2265272, 0.46450114, 0.41069686,
            0.37044403, 0.02566941, 0.04166387, 0.36481884, 0.49873972, 1.708937, 1.3458643,
            1.6333904, 0.9691607, 0.7980822, 0.47088075, 0.27610114, 0.14349873, 1.0518599,
            0.9706904, 2.8546236, 3.0255325, 2.699427, 2.0241175, 2.079968, 1.4653839, 0.82432437,
            0.45315325, 0.77735186, 0.8339421, 3.098342, 2.4406471, 2.8942919, 2.3943224,
            2.0917263, 1.639893, 1.2186441, 0.85708874, 1.4944355, 1.3211501, 2.4089532, 2.351716,
            2.776413, 2.6821122, 2.8081641, 2.320333, 1.3357277, 0.9829718, 1.4271297, 1.3957148,
            3.0004244, 2.0011718, 2.8220756, 2.7155557, 3.0081017, 2.151831, 1.4838662, 1.131008,
            1.7597928, 2.2843356, 2.7449088, 2.2383766, 1.8492393, 2.011353, 2.012621, 2.1773357,
            1.0133817, 0.6484671, 1.8923308, 1.690728, 2.8842661, 2.5440478, 2.284537, 1.5456864,
            1.9106722, 1.9495964, 1.2531538, 0.684567, 1.5497447, 1.845335, 2.181806, 2.879316,
            1.0669173, 1.0681946, 1.1368461, 1.6788406, 0.5629096, 0.6199537, 1.5990341, 1.4561963,
            3.2834344, 2.5466013, 1.6754099, 1.2411487, 1.8591284, 1.3847023, 1.2058398,
            0.77945757, 0.66826123, 1.2556461, 0.9671271, 1.6472688, 0.6577348, 1.1679976,
            0.66172767, 1.2623148, 0.41706327, 0.6842528, 0.81183, 0.6732282, 1.1778524, 1.0725548,
            0.6860135, 1.1131157, 0.8503189, 0.6824155, 0.39738658, 0.84211254,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.69587743, 0.4870034, 0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529,
            0.5566727, 0.7035832, 0.92333794, 0.85647196, 0.36252776, 0.9373231, 0.01684272,
            0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754, 0.31284246, 0.4031665,
            0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259, 0.23846498, 0.82509995,
            0.97324103, 0.96826524, 0.77620417, 0.8427075, 0.42989048, 0.76771307, 0.54514444,
            0.7878393, 0.21897991, 0.975659, 0.73295325, 0.69994044,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.86701024, 0.76087946, 0.623545, 0.14890751, 0.8610666, 0.21943341, 0.1644093,
            0.6089244, 0.8612485, 0.02602104, 0.30423534, 0.5087405, 0.16869895, 0.3329467,
            0.179494, 0.33126613, 0.11996287, 0.21606164, 0.87119263, 0.33579683, 0.2313126,
            0.2576527, 0.3748985, 0.30113342, 0.8142977, 0.423247, 0.8179498, 0.92175007,
            0.21606776, 0.19149332, 0.4240341, 0.14780204,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(kernel3, 2, Padding::Valid);
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            0.6516979, 0.61658764, 1.2958713, 0.7689271, 1.6600143, 1.034385, 2.0341568, 1.2013704,
            0.93163586, 0.2689164, 0.6924543, 0.2565757, 0.8555199, 0.84205997, 1.1543524,
            0.8794705, 1.3477783, 0.98324794, 0.29841778, 0.71001077, 1.2271801, 0.5451091,
            3.099794, 1.9516344, 3.0309453, 1.8856595, 3.1504595, 2.0386796, 1.6632938, 1.1967447,
            0.5966549, 0.5764847, 1.5514368, 1.1623907, 1.3688571, 1.316269, 1.561042, 1.5001147,
            0.73200583, 0.96787274, 1.6108465, 1.1086856, 3.644649, 2.2726395, 3.193182, 1.8163457,
            3.142949, 1.7153966, 1.8044628, 1.3806995, 1.0518526, 0.64288515, 2.033993, 1.6330647,
            1.729502, 1.7305591, 1.4130353, 1.616623, 0.8253226, 0.7808777, 2.2627075, 1.236302,
            3.6594772, 2.1514869, 3.484865, 2.3522558, 3.476708, 2.6232018, 2.0608501, 1.3630439,
            1.2355164, 0.7370673, 1.4113077, 1.7714713, 1.6006912, 1.3399823, 1.9630387, 1.4589555,
            0.8693522, 1.0433158, 1.4991224, 0.53055555, 2.4581556, 2.104775, 3.430931, 2.1279485,
            3.4508543, 1.7824321, 1.7297702, 1.4768685, 0.6150266, 0.5306777, 1.5293939, 1.2293298,
            1.8129259, 1.4405545, 1.4488305, 1.5819527, 0.8134037, 0.8231422, 0.49174395,
            0.10215227, 1.7269783, 0.8193495, 2.2727284, 1.6088223, 1.668817, 1.3644305,
            0.66769385, 0.80432576, 0.10870812, 0.16310053, 0.49486968, 0.5882002, 0.8335013,
            0.78335226, 0.65044713, 0.5968554, 0.35295194, 0.20708674,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.46443272, 0.00207204, 0.359202, 0.9019851, 0.21363449, 0.6390296, 0.5977058,
            0.81350476, 0.3685356, 0.90738845, 0.7828945, 0.9812083, 0.6726924, 0.46724817,
            0.17302093, 0.39839587, 0.78055173, 0.8576361, 0.7335981, 0.52934057, 0.9529279,
            0.78965247, 0.46750203, 0.08403921, 0.73126566, 0.34934825, 0.3459232, 0.54770446,
            0.68714255, 0.29283327, 0.53392637, 0.8850151, 0.6909357, 0.44388366, 0.9043074,
            0.9949724, 0.64743847, 0.36691284, 0.5396585, 0.5372604,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.47547424, 0.44373918, 0.34716287, 0.21774843, 0.9437953, 0.51856595, 0.15765554,
            0.9350713, 0.86233217, 0.81734437, 0.6566154, 0.3879487, 0.28848994, 0.5814131,
            0.06870039, 0.78543746, 0.47194287, 0.12733267,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(kernel4, 2, Padding::Valid);
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.999696, 0.8317941, 1.177324, 0.5194174, 0.85996544, 0.46636102, 0.8036281, 0.4554276,
            0.34573865, 0.3760396, 0.9923742, 0.5345635, 0.46106985, 0.26840922, 0.61082494,
            0.4390378, 0.90015084, 0.4735123, 1.5209593, 1.4589635, 2.089623, 0.8875582, 1.4504678,
            1.0488777, 1.7536557, 1.6036972, 1.2834115, 0.25748137, 0.6267947, 0.40095297,
            0.8062288, 0.58532417, 0.7652362, 0.6688615, 1.0862246, 0.45948339, 1.3449054,
            1.1596012, 1.717779, 1.3573332, 2.1987357, 1.4201387, 2.7867389, 2.0356853, 1.4552315,
            0.27848175, 0.74733585, 0.5203788, 1.0266461, 0.8151649, 1.0493239, 0.9116379,
            1.4406192, 0.5696221, 1.4823895, 1.421078, 1.8649044, 1.4854707, 2.518364, 1.6546032,
            3.0064716, 2.1652741, 1.4831253, 0.3458057, 1.036603, 0.6261015, 0.6990664, 0.5713526,
            0.6890725, 0.52563864, 0.9544941, 0.27494952, 1.549053, 1.726577, 2.3201997, 1.2678854,
            2.4269753, 1.2684426, 2.2634997, 1.4297612, 0.8624389, 0.3567434, 1.1131103,
            0.74184644, 1.0227609, 0.7853738, 1.0061309, 0.68775105, 0.8119594, 0.31140798,
            0.6315807, 1.0354254, 1.1789331, 0.9751128, 1.3258109, 0.9406545, 1.2067593, 0.7485274,
            0.5248782,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6111727, 0.25675833, 0.74741316, 0.45714313, 0.9649919, 0.57969916, 0.5208711,
            0.93666834, 0.13247305, 0.7087714, 0.17877895, 0.40767, 0.6906785, 0.9675369, 0.224454,
            0.28950995, 0.75431514, 0.99582964, 0.8120864, 0.9536324, 0.7703749, 0.683158,
            0.16371861, 0.42877796, 0.7300311, 0.9456737, 0.05700503, 0.19623296, 0.44457257,
            0.5512328, 0.15101007, 0.25140873, 0.2031063, 0.5537751, 0.3641559, 0.701937,
            0.27669305, 0.85076064, 0.00186597, 0.3316532,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.15485734, 0.35000807, 0.42372492, 0.03995521, 0.5067197, 0.38907993, 0.37287286,
            0.21294773, 0.8646356, 0.10154326, 0.75313085, 0.7910046, 0.15368015, 0.25977603,
            0.40315583, 0.635939, 0.25689796, 0.13678746,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(kernel5, 2, Padding::Valid);
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.17287096, 0.79410845, 0.97747016, 0.6043748, 0.78154296, 0.38490218, 0.56053126,
            0.4829297, 0.53286827, 0.14281087, 0.5098182, 0.6636228, 0.30757257, 0.430342,
            0.42125916, 0.4409675, 0.34302968, 0.35072955, 0.941367, 1.2156194, 2.336151,
            1.1452935, 1.7783693, 0.42646024, 1.5425409, 0.6831304, 1.0060246, 0.15074775,
            0.678625, 0.8382685, 0.5394083, 0.63637525, 0.2787442, 0.29322428, 0.5256049,
            0.44355133, 0.8897323, 0.7742243, 2.325294, 1.0296134, 1.6404263, 0.30186722, 1.216074,
            0.5819047, 1.2083244, 0.07361496, 0.182616, 0.34380728, 0.5023455, 0.52835184,
            0.1298196, 0.18536496, 0.27188438, 0.2599731, 0.45969734, 0.53712827, 1.449563,
            1.0482527, 1.7706697, 0.4296825, 0.98639, 0.78138, 1.0647836, 0.05880961, 0.40274253,
            0.47437498, 0.6341275, 0.66463846, 0.20833424, 0.35358334, 0.32904682, 0.3956325,
            0.531606, 0.67165846, 2.116991, 1.3375809, 2.4484506, 0.42698997, 1.3251538, 0.825534,
            1.0127538, 0.07266105, 0.45410457, 0.5755729, 0.7256137, 0.76318026, 0.41198492,
            0.40578988, 0.56937987, 0.50474715, 0.45722353, 0.23171157, 1.6024055, 0.43061835,
            1.2813947, 0.17341132, 1.2689089, 0.28827488, 0.86991054,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.43744904, 0.6658951, 0.564682, 0.70429957, 0.67241764, 0.15790685, 0.25059524,
            0.6432024, 0.60438925, 0.45131883, 0.96080875, 0.40131757, 0.60942906, 0.7035094,
            0.6473561, 0.05433872, 0.7478619, 0.24740443, 0.35665986, 0.00020906, 0.23741227,
            0.57013196, 0.6398819, 0.7132858, 0.90739846, 0.8246988, 0.1319153, 0.6876462,
            0.846729, 0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465, 0.05539654,
            0.5554673, 0.9149804, 0.9791666, 0.9000323, 0.6329186,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.30872977, 0.30553624, 0.04431259, 0.5287215, 0.3358437, 0.72178566, 0.72704846,
            0.85191244, 0.07464863, 0.867838, 0.5849202, 0.14913943, 0.18325551, 0.40498126,
            0.75359416, 0.01821492, 0.5917236, 0.91982275,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(kernel6, 2, Padding::Valid);
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.34108895, 0.27252376, 0.75515586, 0.5369368, 0.8441847, 0.5468107, 0.95690894,
            0.6324043, 0.13758838, 0.27479583, 0.24306203, 0.9512098, 0.45452943, 1.3261031,
            0.4487851, 1.3928826, 0.52540195, 1.0458814, 1.3174413, 1.2493544, 1.6751361,
            1.4352741, 1.3181748, 1.0134187, 1.9819026, 1.6208093, 0.83972865, 0.52180743,
            0.5933066, 1.4037709, 0.38701957, 0.8921324, 0.13758406, 0.7463765, 0.49449933,
            0.98246044, 1.426825, 1.7897017, 1.4644461, 0.866484, 2.0819495, 1.1130545, 1.3958023,
            1.3972801, 0.77985454, 0.47472134, 0.5458897, 1.3461843, 0.22501446, 1.135824,
            0.6882184, 1.6860765, 0.35620984, 0.70170474, 0.9305872, 1.395957, 2.1751647,
            1.1961616, 1.3193899, 1.5828091, 1.7394729, 1.0069281, 0.61813533, 0.38294774,
            0.3388806, 1.2149093, 0.57513106, 1.4907641, 0.23984504, 0.63952136, 0.24320316,
            0.45781782, 1.4740628, 1.4789623, 1.9727801, 1.7427695, 2.3420212, 1.2196898,
            0.8482741, 0.7452457, 0.60939014, 0.5630859, 0.62171465, 1.5395657, 0.47963336,
            1.2699769, 0.48427817, 1.0517874, 0.2563904, 0.47711465, 0.56039816, 1.1785284,
            1.0951571, 0.7901629, 1.1948311, 0.8364133, 0.8661749, 0.37469098, 0.58218855,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.5287654, 0.7151285, 0.38420153, 0.517026, 0.5150141, 0.26934662, 0.7356045,
            0.97902703, 0.6362754, 0.27803296, 0.32063982, 0.83432084, 0.78711736, 0.28247103,
            0.7812688, 0.5270146, 0.4719829, 0.47535485, 0.23715672, 0.4404677, 0.90286416,
            0.66611385, 0.02649495, 0.3193976, 0.16608049, 0.5121102, 0.17436478, 0.313714,
            0.47244504, 0.9906781, 0.9064671, 0.29454133, 0.99321055, 0.12515199, 0.17643407,
            0.16320723, 0.48754972, 0.53866875, 0.6358971, 0.8935865,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.82249755, 0.92702305, 0.10556214, 0.28283548, 0.14977625, 0.53714937, 0.06378802,
            0.4497216, 0.79292244, 0.5300166, 0.687625, 0.4744624, 0.73655206, 0.42605233,
            0.6592577, 0.3237799, 0.42867732, 0.87574345, 0.70010746, 0.01496939, 0.78416556,
            0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122, 0.68573385,
            0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448, 0.48578474,
            0.2764571, 0.9192946, 0.8920509, 0.34320405, 0.4283556, 0.3897719, 0.06360459,
            0.729173, 0.19460331, 0.8634254, 0.6576018, 0.9657459, 0.22873744, 0.47843248,
            0.22157177,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(kernel7, 2, Padding::Valid);
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 13, 11),
        vec![
            1.0748228, 0.9607686, 1.7352488, 1.5349047, 1.7375624, 0.84906536, 1.4012793,
            0.7654482, 0.35436586, 0.2789708, 0.35737422, 0.9461634, 0.5258812, 1.2948315,
            1.3294771, 1.4023061, 0.97598076, 1.3927709, 0.5264425, 0.5142526, 0.58736926,
            0.42919084, 1.1545045, 1.6448718, 2.6235096, 2.2181025, 3.458706, 1.8017529, 3.2212226,
            2.0633264, 1.5118431, 0.7371777, 0.89925873, 0.9215534, 0.40747842, 2.398363,
            1.6917679, 3.1365454, 1.4366674, 2.7474356, 1.4296743, 1.693252, 1.3746729, 0.9548136,
            2.2666008, 2.42872, 3.901482, 4.031037, 5.145789, 3.3056047, 5.498466, 3.516077,
            3.300315, 1.5176809, 1.2604537, 0.9197387, 0.5294554, 2.1174545, 1.8656094, 2.7976582,
            1.899952, 3.2789195, 1.9600837, 2.2933495, 1.5716271, 0.87081164, 2.4325514, 2.4591973,
            3.5327053, 3.6570761, 5.1900377, 3.5066388, 5.0767517, 3.6532602, 3.0272202, 1.7356687,
            1.0183597, 1.5413537, 0.8944154, 2.1782084, 1.9816339, 3.4417543, 1.0220513, 3.1869237,
            1.617339, 2.5030253, 1.1499673, 0.62541384, 2.3592086, 2.823901, 4.4546685, 3.928611,
            4.8984985, 3.410474, 4.9846387, 3.526487, 3.4816573, 1.6947305, 1.3749485, 1.2530601,
            0.69646287, 2.5159903, 1.8424017, 2.9342358, 1.6061255, 2.8014576, 1.8740509,
            1.5597606, 1.2463222, 0.81635225, 1.7297012, 2.1131291, 2.5632536, 2.5914454,
            2.9853554, 2.0561583, 3.207439, 2.642249, 2.185329, 1.0634377, 0.73659325, 0.34285176,
            0.23333877, 1.1327124, 0.6633532, 1.5617411, 0.5797359, 1.634493, 0.5354376, 1.5899156,
            0.4822696, 0.7781388, 0.6907263, 0.7597533, 1.3025773, 1.4841821, 1.3271918, 1.4598758,
            1.4556146, 1.6577791, 0.7906512, 0.83789593, 0.22079077,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.9162307, 0.02157675, 0.44649428, 0.2792192, 0.685827, 0.75294507, 0.7919586,
            0.22560763, 0.88778716, 0.80092114, 0.00003577, 0.9737877, 0.9146247, 0.13869576,
            0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946, 0.17754778, 0.41998118,
            0.02919354, 0.82382417, 0.4156855, 0.49590722, 0.69720376, 0.7155315, 0.40795937,
            0.15397236, 0.02265206, 0.7090415, 0.75877124, 0.67035425, 0.39483562, 0.86222315,
            0.9993058, 0.84902793, 0.26427644, 0.86764544, 0.24274233,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.69865257, 0.5739991, 0.7620597, 0.29289714, 0.88402116, 0.8942853, 0.7757528,
            0.16431308, 0.48939565, 0.56055367, 0.46453193, 0.9573795, 0.8899508, 0.16098963,
            0.63514715, 0.810474, 0.29953358, 0.46075395, 0.02808736, 0.59781086, 0.8855644,
            0.61877847, 0.9537467, 0.6197168, 0.3379795, 0.13108306, 0.30692965, 0.33537498,
            0.01351478, 0.45529485, 0.6626128, 0.9497022, 0.7403127, 0.06039312, 0.08292098,
            0.80679554, 0.1354166, 0.2560622, 0.80891573, 0.97702754, 0.4124968, 0.4359102,
            0.8733311, 0.1396195, 0.52047473, 0.88564533, 0.29781443, 0.21130918, 0.83071965,
            0.3337948,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(kernel8, 2, Padding::Valid);
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 13, 11),
        vec![
            0.69517934, 0.65482026, 0.85797507, 0.29538268, 1.4473499, 0.51585764, 0.89847785,
            0.42976847, 1.1219854, 0.0874004, 0.43609515, 1.0976565, 1.1096256, 0.50010586,
            0.5182267, 1.5187491, 1.1410794, 1.2229081, 0.8796482, 0.67221296, 0.1617532,
            0.19098641, 1.3086171, 1.4799256, 2.2629123, 1.3656045, 4.1778016, 1.4702721, 3.153257,
            1.5582409, 2.7780528, 0.45279926, 0.96866524, 1.8577416, 1.4605123, 2.43361, 1.715386,
            3.751245, 2.2020357, 2.9628592, 1.3856497, 2.0297368, 0.20092966, 0.54356766,
            2.5424578, 1.9726187, 3.947884, 2.9943528, 5.881364, 2.552086, 5.4497304, 3.0366132,
            3.6067958, 1.1801544, 1.9813192, 1.6563642, 1.2565305, 2.6380496, 1.7045593, 3.6895738,
            1.7343585, 4.503292, 1.8864207, 2.0866394, 0.5856878, 0.9559816, 2.3100486, 2.1736083,
            4.333469, 3.0255988, 6.560884, 2.7080746, 5.0577536, 3.533805, 3.9847608, 1.2902082,
            2.1100574, 2.0451622, 1.6791997, 2.234203, 1.2668781, 3.3782122, 1.7929792, 3.822783,
            2.1407185, 2.7028136, 0.23948771, 1.1124377, 2.1845474, 1.9741911, 3.8618255,
            2.5249438, 5.474667, 2.3019533, 5.1874433, 2.6515331, 3.5968325, 2.1125183, 1.8857188,
            1.8171594, 1.5778985, 2.594553, 1.1683652, 3.3366952, 1.7665809, 3.1357646, 1.0407417,
            2.0860624, 0.24370486, 0.6957693, 2.2116435, 1.1340536, 2.3944108, 2.5903766, 4.381148,
            1.554278, 3.1207514, 2.4193702, 1.9158151, 1.1131389, 0.7151596, 0.5648143, 0.44940883,
            1.3941408, 0.3970108, 1.4554142, 0.43963903, 1.4655789, 0.28106514, 0.7651721,
            0.03887841, 0.23248124, 0.98641264, 0.41668966, 1.1267055, 1.2700144, 1.7226539,
            0.82082283, 0.85116684, 0.9234343, 0.52143013, 0.31168017, 0.14103363,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.9783562, 0.42070097, 0.55396014, 0.16172563, 0.7634967, 0.36205766, 0.48491392,
            0.4980414, 0.6001484, 0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525,
            0.7446416, 0.471613, 0.72900707, 0.842964, 0.21457537, 0.938401, 0.41665936,
            0.05351101, 0.43856344, 0.7253113, 0.8520324, 0.4151233, 0.35101932, 0.7388761,
            0.3592986, 0.6741479, 0.9965808, 0.3117034, 0.8605703, 0.94308543, 0.8192489,
            0.31478795, 0.750324, 0.36604244, 0.78454614, 0.039194,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.23696694, 0.2418382, 0.24788351, 0.5622223, 0.15428482, 0.50688076, 0.37682602,
            0.44385925, 0.00051633, 0.53422695, 0.5675659, 0.53845215, 0.2130759, 0.86445093,
            0.432881, 0.6255918, 0.3942565, 0.07226853, 0.09869356, 0.32627374, 0.8543963,
            0.85603166, 0.25422713, 0.24929269, 0.36793318, 0.39957172, 0.9079535, 0.865758,
            0.82237726, 0.60374194, 0.7658025, 0.0215734, 0.473204, 0.6594781, 0.86392707,
            0.8566667, 0.48541847, 0.54855824, 0.5860555, 0.158874, 0.10558709, 0.19664533,
            0.39609066, 0.27843866, 0.49128443, 0.75033015, 0.35650545, 0.4687038, 0.6159849,
            0.2547001,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(kernel9, 2, Padding::Valid);
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 13, 11),
        vec![
            0.39832336, 0.6149112, 0.72431827, 1.0430319, 0.85962045, 0.81269765, 0.9423595,
            1.3697736, 1.01828, 0.6874053, 0.46285266, 0.81498873, 0.37765884, 0.88564146,
            0.43496835, 1.7113259, 0.25371444, 1.3618104, 0.36609888, 1.0898309, 0.47841042,
            0.71301425, 1.4335914, 1.6873007, 1.9002221, 2.9368482, 2.635329, 1.8871284, 2.4062088,
            2.5276654, 1.7916946, 1.4525214, 0.7081718, 1.6955358, 0.7737441, 1.748069, 1.0966376,
            2.9840884, 0.82531637, 2.3067303, 0.8185307, 1.8281872, 0.70544577, 1.3135031,
            2.5975595, 2.282109, 2.918327, 3.8380566, 4.287452, 3.6708486, 4.2452846, 3.395238,
            2.4309986, 1.672293, 0.7833306, 1.1469563, 0.7024646, 1.9457695, 1.0341818, 3.388133,
            1.0170685, 2.7491078, 1.1951548, 1.9165785, 0.46050668, 0.8568361, 2.3478577, 2.301506,
            3.8810987, 4.5062504, 5.447869, 4.7149267, 4.688848, 3.6361609, 2.2535703, 1.3864026,
            0.7340522, 1.209184, 0.42751145, 2.3540068, 1.4640989, 3.7470658, 1.5141804, 3.5480127,
            1.1461799, 2.2057867, 0.3060929, 0.7149341, 2.1452847, 2.0624266, 4.390291, 4.395228,
            5.3932343, 4.890713, 4.298343, 3.475404, 2.0642753, 1.3729519, 0.5447346, 1.2037886,
            0.56650555, 2.3898454, 1.6150757, 3.794142, 1.1426578, 3.19219, 1.4214013, 2.0316958,
            0.16052641, 0.8437052, 1.9327914, 1.2945383, 3.2810357, 3.3790185, 3.8414292,
            3.1666722, 3.2377183, 2.375805, 1.1890607, 1.1456457, 0.66614145, 0.5352854, 0.4349635,
            0.9158814, 0.6851921, 1.0294586, 0.42399055, 1.3723208, 0.6173032, 0.5387868,
            0.10352726, 0.325431, 1.1858517, 0.89154774, 1.5318911, 1.4960244, 1.6172042,
            0.8989997, 1.6568309, 1.3540344, 0.5357107, 0.2580794, 0.35525158,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.17250927, 0.07203952, 0.8724657, 0.14018923, 0.12091745, 0.4770398, 0.43290496,
            0.6356798, 0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513,
            0.06810815, 0.79673207, 0.29373887, 0.55241185, 0.23906927, 0.18915932, 0.02753429,
            0.1438574, 0.5419741, 0.71984386,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286, 0.21388301,
            0.30016333, 0.49605927, 0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258,
            0.26911622, 0.92149794, 0.7165893, 0.04745785, 0.55642486, 0.34654748, 0.83168656,
            0.8410765, 0.7668131, 0.84094906, 0.6012723, 0.9256995, 0.66010624, 0.43380973,
            0.62281454, 0.45852852, 0.61445725, 0.524579,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(kernel10, 2, Padding::Valid);
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.5284884, 0.12951356, 0.50361884, 0.3076544, 0.23049766, 0.53298104, 0.16314697,
            0.11281832, 0.73871154, 0.70280635, 0.7305144, 0.78102005, 0.9177316, 0.7173475,
            0.23883182, 0.3191577, 1.0993607, 0.91214556, 1.3338876, 0.9542679, 1.2146744,
            1.2837186, 0.8159367, 0.86626315, 1.2750448, 1.169076, 1.5588391, 1.6499882, 1.5063537,
            1.6404986, 0.8022716, 1.4474436, 0.7754819, 1.105325, 1.238339, 1.3028579, 1.1315018,
            1.6705776, 0.70539504, 0.65324694, 1.114375, 0.90920955, 1.734791, 1.6325547,
            1.6652402, 1.6110888, 0.65189326, 0.98123753, 0.49217618, 0.71768045, 1.408141,
            1.7300973, 1.8254722, 1.766201, 0.835046, 0.83310354, 0.60166955, 0.59833217,
            2.0119734, 2.1797903, 2.1766098, 2.7410247, 0.8801308, 1.4709319, 0.20473354,
            0.3296914, 1.0024239, 1.5143268, 1.4692478, 1.9635745, 0.6999883, 0.6516716,
            0.15811212, 0.1858831, 0.7645564, 1.0240073, 1.1810038, 1.7439975, 0.57590675,
            0.8350608,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.06486581, 0.14233574, 0.13930365, 0.5838787, 0.45914945, 0.30819193, 0.70949817,
            0.8803759, 0.6927248, 0.50569826, 0.7358748, 0.58652496, 0.85065925, 0.3247378,
            0.6760192, 0.4483504, 0.59195757, 0.37883574, 0.7796499, 0.32748002, 0.44507304,
            0.7488422, 0.14428215, 0.8785777,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.15468395, 0.6638725, 0.30651525, 0.9492515, 0.55669755, 0.08302987, 0.45890567,
            0.05946975, 0.9099885, 0.30235246, 0.24214035, 0.42138377, 0.38782486, 0.21880285,
            0.9182205, 0.85290706, 0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431, 0.2624427,
            0.6557088, 0.00633, 0.6603214, 0.45500925, 0.6523986, 0.14666249, 0.32440838,
            0.2805719, 0.42671442, 0.74477625,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(kernel11, 2, Padding::Valid);
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.44134566, 0.4915501, 0.81699365, 0.8044143, 0.64097494, 0.76615214, 0.52781683,
            0.5114161, 0.2243567, 0.22863512, 0.7386526, 0.10628541, 0.5054013, 0.19950293,
            0.5071989, 0.01256356, 0.9383806, 1.030672, 1.786504, 1.7655272, 1.6247637, 1.6295296,
            0.84108686, 0.6628891, 0.72537875, 0.41900957, 1.5316355, 1.0421703, 1.3968595,
            0.7394726, 0.8062155, 0.64302224, 1.3324342, 1.2626067, 2.3217664, 2.5878778,
            1.8656468, 2.2597692, 0.85349715, 1.0926414, 0.9393993, 0.51707184, 2.496941, 1.304636,
            2.0194907, 1.2349634, 1.0543765, 0.58902043, 1.6183655, 1.2997928, 2.5771794, 2.293166,
            2.2163734, 2.4630077, 1.2683567, 1.4067359, 0.97532153, 0.6125043, 2.5965114,
            1.6040905, 2.3144064, 1.5951743, 1.6712439, 0.9627516, 0.9546562, 0.49362925,
            1.3759038, 0.61106336, 1.3861891, 0.90834475, 0.71520424, 0.37600648, 0.43905303,
            0.3207523, 1.1160811, 1.1905265, 1.2497494, 1.1099283, 0.913461, 1.1545951,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.9118973, 0.5335283, 0.36968935, 0.5693756, 0.36426732, 0.11819325, 0.95361024,
            0.13343851, 0.5940242, 0.7282295, 0.9320007, 0.46956548, 0.5087874, 0.7952918,
            0.73709416, 0.3358689, 0.03185032, 0.27057356, 0.26166973, 0.5843129, 0.5337139,
            0.19571388, 0.1192536, 0.75616854,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.97167397, 0.71154076, 0.26672947, 0.07128377, 0.3383284, 0.8008563, 0.9504947,
            0.5971434, 0.7847773, 0.92326206, 0.24163638, 0.12968542, 0.5954836, 0.6734995,
            0.08627631, 0.7485715, 0.8782484, 0.6863155, 0.7264353, 0.08944888, 0.68172634,
            0.4284322, 0.48237634, 0.6856524, 0.04009921, 0.0687674, 0.9063645, 0.42620143,
            0.61030614, 0.10040135, 0.50107217, 0.763057,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(kernel12, 2, Padding::Valid);
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            1.3329085, 0.9980408, 1.8297102, 1.0359621, 1.7266049, 0.878098, 0.63405824, 0.0922851,
            0.6553745, 0.9482796, 1.8348597, 1.6613929, 1.5183187, 1.4757495, 0.7069445,
            0.72614795, 1.584262, 1.5125542, 1.9098637, 1.234063, 1.6421989, 1.098767, 0.98548615,
            0.39472166, 1.2751426, 1.2651304, 1.9848521, 2.385693, 1.7005697, 1.7791642,
            0.64409316, 1.0952815, 1.6167104, 1.4069002, 1.81642, 1.1428449, 1.7264822, 1.0392915,
            0.8199504, 0.22073117, 1.0450573, 1.2930083, 1.9298842, 2.0370972, 1.2564152,
            1.5884585, 0.967842, 1.015599, 1.6383514, 1.5509129, 1.9424939, 1.2129931, 2.5050128,
            1.7816708, 1.3018316, 0.4056167, 1.1073619, 1.3355854, 1.8326663, 2.4285908, 2.6015103,
            2.337739, 1.1297567, 1.6507905, 0.57934594, 0.68580544, 1.0895498, 1.046536, 0.7321186,
            0.6572247, 0.7988284, 0.3831759, 0.5530941, 0.51011217, 0.78866804, 1.3341479,
            0.8812771, 1.180839, 0.4194074, 0.92850304,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.25769317, 0.8816114, 0.7770131, 0.23345616, 0.62762326, 0.15315741, 0.73589575,
            0.2752067, 0.85641515, 0.7439484, 0.6581306, 0.4056261, 0.13899311, 0.26460668,
            0.9179794, 0.96651816, 0.89336777, 0.18948041, 0.9371178, 0.7124811, 0.9657549,
            0.6203675, 0.32684848, 0.11439406,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.07654371, 0.95680344, 0.9728639, 0.6055871, 0.00439729, 0.8525613, 0.3167563,
            0.13499211, 0.68338645, 0.7955047, 0.21689218, 0.2826704, 0.12328367, 0.6890043,
            0.5906649, 0.41700745, 0.30266365, 0.5716598,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(kernel13, 2, Padding::Valid);
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.13029447, 0.27670822, 0.5679673, 0.9009199, 1.7222168, 0.94255143, 1.0154136,
            0.17319125, 0.09690001, 0.86831176, 0.18619184, 1.4916426, 0.63590854, 1.2046696,
            0.92632645, 0.5098566, 1.9042058, 0.993374, 2.4082508, 0.570368, 1.258334, 0.26053396,
            0.6669617, 1.2601423, 0.61829406, 1.1788783, 0.1312263, 0.24249552, 1.2788038,
            1.2314057, 2.8520741, 0.7729644, 2.370092, 1.1069096, 1.3191497, 0.5611803, 0.64891416,
            1.4354178, 0.4921127, 1.293164, 0.6691752, 1.300584, 1.1743345, 1.2293369, 2.6324024,
            0.95338535, 2.1240823, 0.8208238, 1.5643005, 0.52700675, 0.43070725, 1.4395415,
            0.228094, 1.0138994, 0.08060165, 0.41338968, 0.49434823, 0.28818986, 1.2078087,
            0.1877676, 0.81279147, 0.08937924, 0.34259385,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.12726787, 0.35587692, 0.16889893, 0.3114892, 0.1309899, 0.24026695, 0.55435276,
            0.34375766, 0.4225387, 0.37165096, 0.6202945, 0.6069533, 0.05756181, 0.0153275,
            0.8497578, 0.79796964, 0.4071996, 0.19325097, 0.04944435, 0.59729165, 0.39304134,
            0.679002, 0.6126854, 0.67232877,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.7156292, 0.09058711, 0.33372015, 0.8941644, 0.30899736, 0.3348802, 0.6412177,
            0.26750943, 0.03709449, 0.56803024, 0.8756273, 0.5771133, 0.56024176, 0.5868575,
            0.75167763, 0.36936092, 0.37185487, 0.35425207,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(kernel14, 2, Padding::Valid);
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.12377346, 0.06193152, 0.33907396, 0.04565904, 0.7311661, 0.75937116, 0.54677147,
            0.14604692, 0.07310602, 0.412687, 0.11896009, 0.7577907, 0.5508761, 0.6953048,
            0.77904916, 0.7823909, 1.1484792, 0.46932113, 1.001228, 0.55214953, 0.4990033,
            0.7255785, 0.5645438, 1.0493842, 0.27944365, 0.67305416, 0.18765263, 0.22572307,
            0.91926813, 0.47356722, 1.32745, 0.74060506, 1.3596174, 0.5185693, 0.44521117,
            0.5233833, 0.20031033, 0.86481154, 0.4567453, 1.1621056, 0.3612226, 0.43694022,
            1.0253816, 0.7949002, 1.786932, 0.906739, 2.017307, 0.902879, 0.74547195, 0.7127223,
            0.5133166, 1.5327463, 0.5512284, 1.5876489, 0.58210814, 0.70863116, 0.48910597,
            0.35191032, 0.8783699, 0.39376467, 0.87757576, 0.41237447, 0.26068848,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.24336162, 0.01027582, 0.2671537, 0.83992416, 0.49819484, 0.7831867, 0.70054483,
            0.8701863, 0.49413827, 0.84670645, 0.8069649, 0.093459, 0.93408287, 0.8206956,
            0.70209366, 0.32817394, 0.744203, 0.39091238, 0.43911496, 0.92919487, 0.29325068,
            0.62813336, 0.8131431, 0.19520658,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.47931832, 0.42483747, 0.47526902, 0.28184402, 0.09741595, 0.45691565, 0.44086096,
            0.9638409, 0.33859608, 0.26381832, 0.29839757, 0.68755937, 0.09156765, 0.58584654,
            0.04617033, 0.14705709, 0.81179595, 0.16751295,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(kernel15, 2, Padding::Valid);
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.36307585, 0.38211718, 0.9793396, 0.24925911, 0.8824375, 0.32299995, 0.609701,
            0.15412179, 0.5709365, 0.23236799, 0.4818027, 0.18217172, 0.43734416, 0.15448262,
            0.7338215, 1.4476042, 1.4240489, 1.1098619, 1.5889679, 1.2768248, 0.84906685,
            0.26677772, 0.2740816, 0.6074845, 0.48452085, 0.5185245, 0.30530953, 0.3758988,
            0.8701806, 1.504612, 1.9655433, 1.7312788, 2.062777, 1.3696423, 0.76714265, 0.2376531,
            0.32549822, 0.67070496, 0.6291356, 0.6066252, 0.21993685, 0.23931898, 0.9449729,
            1.5788316, 2.2666426, 2.1785066, 1.75017, 0.8122844, 0.39507085, 0.29615584,
            0.45047247, 0.71777034, 0.5549883, 0.45047343, 0.1234655, 0.05171563, 0.46565127,
            1.3260064, 0.8672497, 1.4378921, 0.47935605, 0.24854752, 0.06434448,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.06864621, 0.6308731, 0.38993102, 0.3644169, 0.68174505, 0.272409, 0.23609333,
            0.21866773, 0.80119157, 0.01742986, 0.49270406, 0.37920174, 0.90869635, 0.8191268,
            0.7636344, 0.7827788, 0.9694966, 0.79533535, 0.00732174, 0.8372113, 0.9449071,
            0.7670253, 0.50964797, 0.7843069,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.7365313, 0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833,
            0.5585159, 0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028,
            0.52249014, 0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726,
            0.25884646, 0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234,
            0.32747796, 0.9097073, 0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446,
            0.9843364, 0.4038572, 0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686,
            0.5288406, 0.92906404, 0.87780553, 0.9090181, 0.82569945, 0.20383635, 0.7166643,
            0.17061436,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(kernel16, 2, Padding::Valid);
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.89422953, 0.4749701, 1.4971774, 1.1959392, 2.5899277, 1.5058625, 1.3778188,
            0.62226206, 0.7602386, 0.74271363, 0.04701633, 1.538821, 0.790201, 1.7535343,
            0.96346354, 0.8833692, 0.6796892, 0.3155861, 1.9098253, 1.0288254, 3.479889, 2.8428068,
            5.0498233, 3.0326848, 3.0666978, 1.298415, 1.4940455, 1.8662717, 0.30748233, 3.4678822,
            2.0997355, 4.2904444, 2.2029982, 2.5648108, 1.4204805, 1.2074277, 1.9340223, 1.444342,
            4.4905777, 3.808424, 6.447476, 4.6270733, 4.481236, 2.476778, 2.084279, 1.1962388,
            0.32472405, 2.8188112, 1.4092737, 4.5696564, 2.1348202, 2.8227484, 1.7963119,
            1.4138445, 1.7764338, 1.238035, 3.9363306, 3.1531296, 6.2714424, 4.443052, 3.9676704,
            2.4792066, 2.1681635, 0.7188296, 0.10910354, 2.1250393, 0.90681887, 3.5724535,
            1.9540517, 2.4201674, 1.7140836, 1.6922603, 0.9373356, 0.38595548, 2.2104158,
            1.8120366, 4.056389, 2.8663268, 2.490391, 1.7510734, 1.4589835, 0.7639754, 0.14647059,
            1.1718769, 0.97287476, 2.0927238, 0.83495224, 1.327632, 0.7992767, 0.9478178,
            0.7098303, 0.637844, 0.9894395, 1.1043634, 1.6270792, 1.28946, 0.89660525, 0.699431,
            0.40101156,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.91526777, 0.08598401, 0.70100874, 0.40537685, 0.5971982, 0.92796123, 0.15859716,
            0.7859081, 0.8564488, 0.35816404, 0.79062706, 0.9644883, 0.13154314, 0.31929043,
            0.80048305, 0.07180241, 0.52815664, 0.45786336, 0.91537887, 0.9783313, 0.25753945,
            0.42799363, 0.07738555, 0.9294206,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.07022415, 0.60058224, 0.6196278, 0.9008346, 0.04155485, 0.82207745, 0.41282526,
            0.9949608, 0.3109271, 0.47614527, 0.7615821, 0.35893062, 0.07713356, 0.6123928,
            0.62511915, 0.88098776, 0.21521498, 0.89468116, 0.1842307, 0.10784956, 0.8354833,
            0.2630701, 0.7184675, 0.06132602, 0.06056971, 0.71349823, 0.00944792, 0.07349233,
            0.35231608, 0.8533961, 0.17608605, 0.18067755, 0.51991457, 0.19053963, 0.5045173,
            0.7456122, 0.27621788, 0.48649722, 0.39297876, 0.54849166, 0.3746991, 0.8194284,
            0.34880427, 0.79505837, 0.41293454, 0.890512, 0.12076204, 0.20799449, 0.88948244,
            0.24437675,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(kernel17, 2, Padding::Valid);
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.1581297, 0.5509364, 0.81064403, 0.9255068, 0.8474067, 0.6185248, 0.7692481, 0.913516,
            0.7122594, 0.7755839, 0.40161255, 1.1059549, 0.4028307, 1.470958, 0.52159566,
            1.3156874, 0.37048635, 0.73763955, 0.8748298, 0.6089927, 1.1133802, 1.4853843,
            2.8158207, 1.9365493, 1.7565658, 1.7411177, 1.3065723, 1.2015233, 0.4850924, 2.0847538,
            1.035034, 3.200357, 1.8286328, 2.7596629, 1.1413475, 1.078995, 1.9083548, 0.5258994,
            2.8747077, 1.8176367, 4.74874, 3.172633, 3.1278882, 2.365467, 1.3246727, 0.6756009,
            0.37694144, 2.5638165, 1.4180158, 4.3583307, 1.9357011, 3.1262589, 0.85035163,
            0.826875, 1.5364534, 0.6442335, 3.4251335, 2.267784, 5.3527102, 3.377636, 2.9112542,
            2.2861545, 1.6779814, 0.85251606, 1.0094079, 2.7625997, 2.261095, 4.4603877, 2.1446376,
            3.2031693, 0.83952004, 1.1268599, 1.5395498, 0.39904073, 2.7278407, 1.8415188,
            3.9311335, 2.2923045, 2.0188174, 1.2374876, 1.227511, 0.47590697, 0.4277924, 1.1952577,
            0.6398314, 2.1476681, 1.1763498, 1.3043194, 0.916632, 0.4878095, 0.68037355,
            0.14590764, 1.0758181, 0.6199932, 2.3438952, 0.4832859, 0.9530671, 0.8858515,
            0.28554755,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.7731474, 0.65954226, 0.4922565, 0.5211581, 0.97382414, 0.9779564, 0.1754263,
            0.4551989, 0.81067127, 0.7095975, 0.5087082, 0.78796804, 0.03310984, 0.20805901,
            0.45704818, 0.9133983, 0.5689028, 0.04247752, 0.55938286, 0.9835293, 0.04525762,
            0.7176199, 0.82096803, 0.5575717,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.5744108, 0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355, 0.1134909,
            0.5645703, 0.30096474, 0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894,
            0.681929, 0.24701218, 0.74485576, 0.61556435, 0.63869125, 0.05875124, 0.3210932,
            0.96946657, 0.09463912, 0.6275637, 0.34162354, 0.74390864, 0.8736778, 0.9513908,
            0.24045336, 0.7003475, 0.87750345, 0.16564246, 0.6314963, 0.21785556, 0.7654987,
            0.13988015, 0.03287261, 0.82226163, 0.60896695, 0.13331373, 0.62307173, 0.23316076,
            0.9600204, 0.55291533, 0.29808274, 0.8765127, 0.98263544, 0.27148733, 0.11101003,
            0.2754741,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(kernel18, 2, Padding::Valid);
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.46873492, 0.78511876, 0.8323531, 1.0918818, 1.7520361, 1.1500953, 1.3309231,
            0.27357066, 0.7531583, 0.14450312, 0.09322959, 0.7384625, 0.34921873, 1.3204076,
            0.375399, 0.99601275, 0.24772233, 0.5515411, 1.424413, 1.9949155, 2.9468193, 3.054813,
            4.028483, 2.544696, 2.7941835, 0.9957987, 1.2867271, 1.090938, 0.7940475, 2.315926,
            1.6124783, 3.072467, 1.5445592, 2.2559662, 0.8706932, 0.59833187, 1.2191608, 1.9348707,
            3.773596, 4.6736817, 5.2058244, 4.555174, 3.2511568, 1.42505, 1.7115202, 1.2149007,
            0.7137231, 3.176012, 2.0851324, 3.2554603, 2.1256351, 2.2952085, 0.9019418, 0.43688452,
            2.0876846, 2.8978467, 3.906219, 4.4679565, 5.7344027, 4.9616327, 3.4036014, 1.67132,
            1.988362, 1.1275417, 0.46049464, 3.0204105, 1.5533348, 3.8825293, 1.9626659, 2.4962144,
            0.90141296, 0.81075954, 1.0517094, 1.3730186, 2.6146946, 3.0461514, 2.9236429,
            2.8376079, 1.9221497, 1.4649425, 0.9010819, 0.6224079, 0.6958686, 1.7629118, 1.4203285,
            1.8989334, 1.4957597, 1.2949289, 0.81155825, 0.21249661, 0.8568499, 1.3930898,
            1.144912, 1.8248686, 1.4528569, 1.722181, 0.62588835, 0.5563962, 0.422785,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969,
            0.5836321, 0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643,
            0.91682273, 0.6142979, 0.19277428, 0.28408903, 0.25507236, 0.9800453, 0.36125833,
            0.96792, 0.33258557, 0.9508625, 0.8424581, 0.8130291, 0.7774976, 0.17691322, 0.9389267,
            0.22419459, 0.33442205, 0.7614585, 0.37563834, 0.70754576, 0.1499497, 0.9873837,
            0.7166968, 0.40278858, 0.22288306, 0.3279577, 0.07722609, 0.598755, 0.8143903,
            0.87905455, 0.83061284, 0.9923988, 0.6196494, 0.536406, 0.06662867, 0.83588266,
            0.28182983, 0.662181, 0.99850965, 0.60448396, 0.12318801, 0.91713256, 0.8540598,
            0.19103892, 0.5929614, 0.9118344, 0.9381113, 0.3421722, 0.8149188, 0.9595595,
            0.02717085, 0.8916309, 0.9755575, 0.27588442, 0.59208006, 0.00008138, 0.9552037,
            0.12578069,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.01249961, 0.05413999, 0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439,
            0.34315115, 0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794,
            0.6930413, 0.90735817, 0.91156703, 0.45996496, 0.9045769, 0.17170428, 0.43418503,
            0.69308424, 0.42869946, 0.9244341, 0.41451567, 0.6224708, 0.00536506, 0.33826837,
            0.47926104, 0.0032256, 0.02230139, 0.35960108,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(kernel19, 2, Padding::Valid);
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            0.6589925, 0.3542372, 1.2519304, 0.50126904, 0.67011535, 0.2553501, 0.55642074,
            0.27614814, 0.8844479, 0.53838545, 1.1285734, 0.7160026, 0.86415744, 0.3540583,
            0.7061408, 0.79043585, 1.0549033, 1.2249521, 0.51720816, 0.6491585, 1.1653714,
            1.0964185, 1.8931994, 1.3270315, 1.7039334, 1.227541, 0.8099711, 0.7682731, 1.2791996,
            1.1323195, 2.3605719, 1.6606634, 2.1874425, 1.2757382, 2.491424, 1.717658, 3.401507,
            2.476605, 3.0778034, 2.3960147, 1.2483678, 0.94054025, 1.2213905, 1.1160448, 2.0840268,
            2.660621, 1.7295749, 2.1090267, 2.656272, 3.1271768, 3.7417715, 4.1708493, 3.048015,
            2.962257, 0.9272828, 1.3761902, 0.49977812, 0.67896104, 1.8533292, 1.9211725,
            2.2807605, 1.9403286, 2.3561254, 2.345932, 3.3828375, 2.8710985, 2.8585663, 2.0778866,
            0.9738023, 0.64001137, 0.85244524, 0.43633002, 2.1212323, 2.071189, 2.6566274,
            2.7394025, 3.0209143, 2.6645663, 3.0655107, 3.6296203, 2.2601352, 2.9417753, 0.7184165,
            1.1060103, 0.31418455, 0.32922375, 2.0032272, 1.7297053, 3.1766665, 2.4275243,
            2.6417432, 2.1271403, 2.337287, 2.2081141, 2.1444795, 1.772867, 1.5968337, 0.984373,
            0.56838924, 0.5596088, 2.5305507, 2.2356317, 3.153638, 3.600919, 3.0596673, 3.187571,
            2.5572271, 2.1156583, 2.4435394, 2.7135878, 1.4418733, 1.644364, 1.0501227, 0.72318065,
            2.7483926, 2.1810112, 2.9905128, 2.7173324, 2.9591053, 2.260831, 2.3660808, 1.7768819,
            2.5287175, 2.486332, 1.8599265, 1.3602164, 1.4027369, 1.4364572, 3.4038782, 3.1237206,
            3.2928622, 3.226063, 2.7405794, 3.3493414, 2.620966, 2.8369315, 2.8633611, 2.5263262,
            1.2597618, 2.0918562, 1.7228502, 1.6102418, 2.714404, 2.2566106, 2.7302914, 2.476517,
            1.9955671, 1.9424831, 1.9182724, 1.8470261, 2.4765394, 1.8471328, 0.8473837, 0.9102604,
            1.8363535, 1.6911807, 2.9135869, 3.5711203, 2.9573557, 2.7673953, 2.3594875, 2.3026853,
            2.076994, 2.3943715, 2.713126, 2.7366986, 1.1020733, 0.9791541, 0.5792535, 0.829342,
            0.8458805, 1.2918195, 1.1904392, 1.358924, 0.74174714, 0.9896719, 1.1685703, 1.2959344,
            0.720691, 1.1846471, 0.9694541, 0.88227963, 0.7344123, 0.3190015, 0.99338186,
            1.3743238, 1.1173916, 1.1468165, 0.83819085, 1.2220138, 1.0678105, 0.7867322,
            0.9734283, 1.4125197, 0.6871028, 0.94114155,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.48593593, 0.86064774, 0.28908366, 0.4153976, 0.3468706, 0.2242362, 0.93169004,
            0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496, 0.11111139, 0.19382912,
            0.9307082, 0.9188555, 0.10532705, 0.88550454, 0.20754221, 0.97926295, 0.3472928,
            0.71126235, 0.03633394, 0.7482733, 0.28782296, 0.7382309, 0.60003114, 0.3259743,
            0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927, 0.968827, 0.47373444,
            0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834, 0.3979838, 0.2393961,
            0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945, 0.66457146, 0.8425775,
            0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123, 0.48163053, 0.437191,
            0.43973154, 0.29997745, 0.21913478, 0.6611514, 0.209788, 0.176356, 0.88925517,
            0.14793599, 0.36509594, 0.5616029, 0.6617385, 0.30053073, 0.36820948, 0.62227124,
            0.4957459, 0.69923055,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.3227648, 0.9702412, 0.5679234, 0.13432135, 0.7430913, 0.19231908, 0.26170298,
            0.10480803, 0.00958306, 0.20726651, 0.20851518, 0.17973869, 0.23704103, 0.1163867,
            0.2735905, 0.8537909, 0.40303, 0.75797635, 0.34342998, 0.74670875, 0.82946825,
            0.91931367, 0.9654975, 0.18782942, 0.10021565, 0.05109123, 0.3069365, 0.10895161,
            0.9891213, 0.62504834, 0.507994, 0.47125,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(kernel20, 2, Padding::Valid);
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            0.36026064, 0.85404146, 0.94413006, 1.6853589, 0.7905512, 0.84243244, 0.5469337,
            0.91544324, 0.7030949, 1.1176064, 0.50253487, 0.74278986, 0.20956479, 0.20887887,
            0.77974457, 0.5574514, 1.7006879, 0.8063029, 1.0083891, 0.3006069, 0.91123706,
            0.6426669, 1.2442977, 0.58267224, 0.84022886, 0.37431288, 0.28981963, 0.06846739,
            0.50309056, 1.3071872, 1.0828402, 1.068806, 0.8324176, 1.0827293, 0.8594703, 1.0986841,
            1.221072, 2.1066537, 1.4901725, 2.318745, 0.84867686, 0.68093336, 1.6095655, 0.8868314,
            1.9736478, 1.3323691, 1.3792603, 1.457499, 1.830654, 1.3970922, 2.8244715, 2.0457554,
            2.883136, 1.6893083, 1.0551015, 0.52140355, 0.42096156, 0.95821893, 0.89944506,
            1.4325824, 0.93801314, 1.9563186, 1.5694591, 2.1836128, 1.400906, 1.5478128, 1.3421621,
            2.3115711, 1.0829846, 0.7680974, 1.3634093, 1.1325877, 1.8758984, 1.6176779, 2.2257948,
            1.4262726, 3.0418115, 1.9779983, 2.9978976, 2.0443404, 3.4211745, 2.3938575, 1.3513532,
            1.2632325, 0.34660313, 0.6325086, 1.102301, 1.8429403, 1.2453401, 1.4377158, 1.1716896,
            1.7554818, 1.062068, 0.8128716, 0.9246594, 1.709876, 1.0086638, 0.81441045, 1.4134693,
            1.0222675, 2.5395083, 1.4858322, 2.4680653, 1.5586818, 2.7111294, 2.1333368, 2.0233755,
            1.8985496, 2.506103, 1.6994785, 1.3611014, 1.2227241, 0.22770578, 0.5058957,
            0.78916407, 1.3603299, 1.4176672, 1.8051487, 1.0552683, 1.4460958, 0.92198956,
            1.4405582, 1.0316643, 1.1697499, 0.63214993, 0.6448779, 0.91347826, 0.5734123,
            1.9387361, 1.1650777, 2.5542333, 2.400785, 2.16425, 1.2026279, 1.7392507, 1.4520062,
            2.0999787, 1.3363876, 1.11982, 1.070745, 0.41698045, 0.95221263, 0.7379271, 1.0647063,
            0.78117764, 1.4197023, 1.4496075, 2.0477414, 1.2747984, 1.7009277, 1.3163978,
            1.9583387, 0.8768689, 0.7115808, 1.1158544, 0.8483452, 1.5664982, 0.9930177, 2.3730319,
            1.8561676, 2.589436, 1.9527342, 2.3458953, 1.4411097, 2.760223, 2.2030466, 1.199479,
            0.59699494, 0.07007235, 0.11504075, 0.31547943, 0.16933063, 0.14644738, 0.18688786,
            0.3108336, 0.3814736, 0.44723424, 0.3654507, 0.32835504, 0.3335917, 0.3742819,
            0.21381032, 0.7474406, 0.45923275, 0.75372434, 0.84072894, 0.6753984, 0.48930526,
            1.1977494, 1.1918495, 1.1838193, 1.4854226, 1.2545741, 1.1642619, 0.56469643,
            0.9832702,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.84314245, 0.6054993, 0.92367506, 0.6953895, 0.37023902, 0.67128026, 0.43450755,
            0.28869846, 0.27641538, 0.8369712, 0.6856483, 0.26890948, 0.65425915, 0.84581685,
            0.51146317, 0.48995435, 0.52071315, 0.80564773, 0.670521, 0.3835857, 0.47078377,
            0.5100531, 0.82525116, 0.02126783, 0.9583153, 0.23316967, 0.9487504, 0.9609589,
            0.95734006, 0.00943314, 0.7521432, 0.46106157, 0.84370506, 0.16933449, 0.71423984,
            0.5316646, 0.6400151, 0.9638914, 0.69432026, 0.8581641, 0.70813745, 0.2836983,
            0.33953485, 0.8950543, 0.20262088, 0.81930757, 0.09556881, 0.22266188, 0.63842744,
            0.8304186, 0.12425002, 0.7582065, 0.09737789, 0.84872884, 0.17490041, 0.37569723,
            0.6669188, 0.8970669, 0.22398192, 0.29424527, 0.56277037, 0.41113177, 0.7882464,
            0.24159203, 0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633, 0.9636684,
            0.98529965, 0.26998708,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.13811645, 0.9724998, 0.41856614, 0.13321315, 0.0937838, 0.4742414, 0.79873264,
            0.1621314, 0.5493846, 0.6481355, 0.05176858, 0.17029643, 0.955536, 0.089831,
            0.05664136, 0.9231865, 0.98567015, 0.01680515, 0.54690886, 0.8593988, 0.6496963,
            0.8382851, 0.2400014, 0.36792266, 0.01756373, 0.6596718, 0.5680892, 0.19350345,
            0.4854058, 0.7869872, 0.12335967, 0.14544043,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(kernel21, 2, Padding::Valid);
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            0.7472957, 0.83071136, 1.7366492, 1.2673922, 1.5925477, 1.8189695, 1.7082605,
            1.4104314, 1.5095301, 1.2020979, 0.91460395, 1.3154807, 0.4361323, 0.33323333,
            0.49488857, 0.93636817, 1.5100726, 1.4673445, 1.2526904, 1.4728912, 1.5271695,
            1.4543815, 1.2561876, 1.1976862, 0.7129489, 0.8767361, 0.60426146, 0.21321464,
            0.8691325, 1.3969349, 2.0464826, 1.9412055, 1.9468172, 2.4262068, 1.9890418, 2.3471425,
            1.7266673, 2.4755898, 1.3910944, 1.261031, 0.43024933, 0.39639086, 1.3776643,
            1.0701125, 2.2102966, 2.7670178, 1.975806, 2.0056329, 2.0992036, 2.8946424, 1.8343061,
            2.199758, 1.6279359, 1.1888694, 0.34124509, 0.7864991, 0.9643181, 1.1525972, 1.9480593,
            2.389586, 1.6801379, 1.8609987, 1.7006724, 1.8333614, 1.6747814, 2.033409, 1.4604818,
            1.4072375, 0.94180703, 0.9255996, 1.0561427, 1.1517028, 2.0714674, 2.6190608, 1.492819,
            1.3703675, 2.2150009, 2.0012112, 1.5354416, 1.7156174, 1.4819137, 2.060069, 0.88989216,
            0.72352505, 0.6356572, 1.500222, 1.6754228, 1.9499456, 1.8871238, 1.5612073, 1.8960099,
            2.075833, 1.782733, 2.2770877, 1.3006792, 1.5176219, 0.6936883, 0.5571381, 1.1115807,
            1.0258121, 2.1847193, 2.0962815, 1.5733784, 2.0281036, 2.047252, 2.4465482, 1.5117204,
            1.6778803, 2.1293852, 1.7081436, 0.23793846, 0.97891027, 1.0585109, 1.4913841,
            1.497753, 1.4894545, 1.7340797, 2.2033947, 1.8982803, 2.8739736, 2.1981773, 2.2189014,
            1.1801381, 1.0027721, 0.33458492, 0.31697255, 1.181109, 1.1241128, 1.7979323,
            1.7922336, 1.7276604, 2.275691, 2.2258143, 2.3855023, 2.3069394, 2.0082273, 1.3270261,
            1.6374104, 0.11629393, 0.17319547, 0.9499563, 1.7291013, 1.8088315, 1.5258932,
            1.5520828, 2.7941093, 2.3796647, 1.4275646, 2.3902779, 2.7530131, 1.5475614, 1.934166,
            0.5393499, 0.36190915, 1.4635551, 1.1490724, 1.762378, 2.408389, 2.0127823, 1.7739508,
            2.5129569, 2.3081636, 2.3377461, 2.9847412, 1.3069532, 2.1545105, 0.52661514,
            0.2374239, 0.41873452, 0.69476455, 0.48416832, 0.9922422, 0.92264456, 0.8025142,
            0.1787516, 0.8976925, 0.9659137, 1.3282088, 0.8935436, 0.83498496, 0.18090026,
            0.14278401, 0.8712181, 0.31484306, 0.8931677, 1.3833811, 0.9481154, 0.6474688,
            0.68281853, 1.5589342, 1.2892212, 1.1360627, 0.8010797, 1.0629153, 0.06341972,
            0.53009266,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.25711668, 0.05608724, 0.18204254, 0.9562488, 0.44598028, 0.3229758, 0.8930679,
            0.24216229, 0.21437034, 0.38366762, 0.64894366, 0.8650639, 0.7790032, 0.3529938,
            0.37360683, 0.26240814, 0.554433, 0.90017563, 0.6817857, 0.95833224, 0.28551313,
            0.85106283, 0.70093375, 0.4791875, 0.5805011, 0.9803199, 0.97033703, 0.48236644,
            0.66855663, 0.35855147, 0.25242767, 0.6717967, 0.26290378, 0.53677225, 0.18097793,
            0.07985484, 0.79416144, 0.7215235, 0.42313012, 0.6529702, 0.00384528, 0.08442257,
            0.7838985, 0.980683, 0.36212954, 0.61172485, 0.5263662, 0.8496614, 0.13177402,
            0.9175598, 0.04323238, 0.03087392, 0.03482862, 0.36226457, 0.6059544, 0.29194582,
            0.34645593, 0.9409913, 0.60953087, 0.8610255, 0.1627552, 0.8939359, 0.66327935,
            0.48094535, 0.06551108, 0.86129206, 0.65446067, 0.9592776, 0.8000413, 0.21450381,
            0.6442533, 0.46971878,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.84573215, 0.34651902, 0.18830031, 0.57119006, 0.27269888, 0.7915957, 0.21737069,
            0.04463017, 0.393406, 0.8441482, 0.77705365, 0.6315176, 0.8522896, 0.16809769,
            0.22305161, 0.773223, 0.9678148, 0.2237789,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(kernel22, 2, Padding::Valid);
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.8878418, 0.70620185, 1.2064496, 0.5800978, 0.9773598, 0.391876, 1.6614268,
            0.83875126, 0.97284997, 0.15752865, 0.4308228, 0.17751813, 0.11413078, 0.823718,
            0.20361213, 1.0276549, 0.13658136, 0.6699457, 0.12076999, 1.3412035, 0.37053078,
            1.1606253, 0.12226471, 0.61032677, 0.10226639, 0.27449685, 2.0869763, 1.6986725,
            2.544815, 1.5467615, 1.7021801, 0.77331364, 1.9889799, 1.282923, 2.0739546, 0.6575118,
            2.215253, 1.0561135, 0.8454206, 1.17822, 0.37531015, 1.8559451, 0.23088793, 0.84152305,
            0.11933169, 0.99098206, 0.20745526, 1.2594424, 0.26544714, 1.8493814, 0.37872806,
            0.87429917, 1.57032, 1.1708612, 2.6406827, 1.7952396, 1.6397188, 0.52309746, 1.0674108,
            0.7240796, 1.4030993, 0.7575727, 2.4116125, 1.4543498, 0.9287374, 0.5572685, 0.2345842,
            1.6297013, 0.25050068, 0.7343386, 0.10914943, 0.48158705, 0.07674824, 0.5609783,
            0.15704787, 1.2695811, 0.30637273, 0.79337883, 1.3593466, 0.8694107, 2.690151, 1.46272,
            1.3575908, 0.42666566, 2.0242286, 1.0677017, 2.119434, 0.77497715, 2.350707, 1.2258906,
            1.0691856, 0.9058779, 0.28778172, 1.4710699, 0.31041154, 1.2820938, 0.13609755,
            1.5914042, 0.39026234, 1.8034505, 0.29360458, 1.6983632, 0.2754103, 0.5713759,
            1.2450761, 0.9445041, 2.6336648, 1.3596557, 2.9019768, 1.1996915, 2.5179734, 1.4895579,
            2.1843293, 0.903769, 2.3796353, 1.6482145, 0.99263096, 0.47029102, 0.18566076,
            1.8176662, 0.4176007, 2.0949638, 0.37610555, 1.6014879, 0.2123866, 0.9268221,
            0.1933269, 1.4827102, 0.2425578, 0.47594038, 1.017978, 0.77944684, 3.0078669,
            1.8871167, 2.9394932, 1.3980141, 2.1966782, 0.83967686, 1.4268119, 0.65657204,
            1.9265672, 1.2422414, 0.64546764, 0.7019742, 0.17885007, 1.5471051, 0.34445053,
            1.5777948, 0.20617867, 0.87598234, 0.18243478, 1.1252153, 0.15764998, 0.7329118,
            0.10073496, 0.16798428, 0.5609144, 0.6446626, 1.1335255, 0.9583854, 1.1547128,
            0.7860253, 0.56499815, 0.23155619, 0.7966616, 0.63159496, 0.59592354, 0.45816472,
            0.13652852,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.8982615, 0.271913, 0.34780893, 0.49277794, 0.14560463, 0.33638617, 0.1585067,
            0.18610527, 0.6963084, 0.9429821, 0.40789625, 0.20056698, 0.37306353, 0.9367061,
            0.7103306, 0.06833509, 0.48335183, 0.45182207, 0.96346164, 0.00378525, 0.33689302,
            0.28288215, 0.75004077, 0.1607512, 0.514175, 0.35879079, 0.36688787, 0.00774159,
            0.15532039, 0.01133456, 0.94680935, 0.052598, 0.73530346, 0.8096563, 0.7097644,
            0.37942106, 0.38656324, 0.13763146, 0.99930644, 0.67476803, 0.06055127, 0.8463604,
            0.4460729, 0.33209085, 0.94373864, 0.5397614, 0.05766413, 0.64256257, 0.7357459,
            0.09256811, 0.8832945, 0.03911254, 0.782554, 0.4004812, 0.80732703, 0.8010379,
            0.28867772, 0.7802926, 0.9490529, 0.5395702, 0.1369102, 0.4513485, 0.1162144,
            0.9589836, 0.24819064, 0.3149064, 0.22322156, 0.39812055, 0.45308354, 0.5711523,
            0.97817534, 0.06805564,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.5386646, 0.6699801, 0.1879456, 0.8407316, 0.64728755, 0.53731096, 0.63207716,
            0.00916763, 0.46754488, 0.8670982, 0.1932068, 0.43971533, 0.10441232, 0.46486124,
            0.22910197, 0.7679019, 0.23872072, 0.03931138,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(kernel23, 2, Padding::Valid);
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.81904995, 0.67650396, 0.604612, 0.20876762, 1.1654727, 0.42609787, 1.3553116,
            0.4605212, 0.52025723, 0.10925112, 0.969068, 0.38889462, 0.43537992, 0.79555875,
            0.76113176, 0.8141844, 0.23998544, 0.5743873, 0.6896712, 0.9005727, 0.63264257,
            0.5481024, 0.12239601, 0.4632883, 0.6111787, 0.3746468, 1.3367841, 0.29289627,
            1.3268708, 0.22419733, 2.494147, 0.89059323, 2.5533514, 0.90166354, 1.079743,
            0.30021316, 1.7002221, 0.46365097, 0.5107875, 0.17983711, 0.30996144, 0.37850255,
            0.2748398, 0.8600254, 0.88941926, 1.4394991, 0.8612947, 0.9792871, 0.29083198,
            0.46809256, 0.42852694, 0.2549792, 1.2816488, 0.50003624, 1.4427613, 0.72644234,
            2.6301732, 0.8782394, 1.9658021, 0.1908371, 1.7331648, 0.49253595, 1.8387573,
            0.5353192, 0.38004977, 0.39046726, 0.58349913, 1.1661956, 0.6493496, 1.2139342,
            0.8703975, 0.64556825, 0.06241435, 0.5337554, 0.67664665, 0.86067116, 0.478627,
            0.33451998, 2.0198002, 0.9805391, 2.099191, 0.18798731, 2.3535829, 0.49885887,
            1.4592851, 0.3502467, 2.563143, 0.87711895, 1.9626, 0.31169403, 0.49446034, 0.89430755,
            0.99893177, 0.7894593, 0.37482163, 0.49893135, 0.35226175, 0.56645304, 0.5458339,
            1.060438, 0.92666996, 0.81192136, 0.35487753, 0.20998998, 1.6246125, 0.57249737,
            1.8411796, 0.5188453, 1.0321751, 0.34026286, 1.9026117, 0.3793342, 2.0878036,
            0.38544837, 1.3214157, 0.19871628, 0.23696908, 0.4465783, 0.39646333, 0.6564114,
            0.44205526, 0.6167755, 0.29150552, 0.33039612, 0.45080534, 0.38036162, 0.21591116,
            0.18272573, 0.15372449, 0.07823586, 1.1336995, 0.7148684, 1.4688017, 0.22319472,
            1.4805318, 0.61128384, 2.1862068, 0.88180435, 1.9638939, 0.72519034, 1.1582649,
            0.34263197, 0.11891445, 0.81931967, 0.7166249, 0.64566106, 0.21911685, 0.784972,
            0.68657374, 1.239228, 0.789587, 1.2647443, 0.9141375, 0.9315632, 0.27723095,
            0.21945877, 0.7698688, 0.06196761, 0.7904145, 0.09552182, 0.85293484, 0.11490142,
            1.311953, 0.14376852, 1.600772, 0.24001758, 0.66238356, 0.01972468, 0.18007173,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.8551502, 0.19610135, 0.8555064, 0.08035298, 0.05671094, 0.9091975, 0.27582648,
            0.33816597, 0.42012835, 0.7745094, 0.14011143, 0.47505257, 0.98297566, 0.5085966,
            0.22395916, 0.01153891, 0.669607, 0.12918296, 0.55476546, 0.528783, 0.5067741,
            0.14234911, 0.5152856, 0.6446142, 0.9118427, 0.8193508, 0.989135, 0.7842302,
            0.59264964, 0.35247177, 0.48483032, 0.22649786, 0.04158387, 0.5814206, 0.8653732,
            0.4524277, 0.44947338, 0.5519129, 0.79122764, 0.7513198, 0.9315116, 0.03313805,
            0.41213843, 0.45310238, 0.01799934, 0.4328227, 0.23842481, 0.20688592, 0.57869387,
            0.9324833, 0.43915927, 0.53123087, 0.5324186, 0.4149537, 0.22217223, 0.0080786,
            0.65063345, 0.7681623, 0.8421627, 0.27179125, 0.68530315, 0.9955617, 0.77906156,
            0.18006648, 0.5975193, 0.6555531, 0.9498266, 0.9690994, 0.5122471, 0.3840358,
            0.8757204, 0.7260429,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.04691354, 0.40678895, 0.35535267, 0.19270384, 0.23519029, 0.6665529, 0.26402712,
            0.55168146, 0.08576613, 0.9567203, 0.57141143, 0.20602623, 0.75538653, 0.96776,
            0.44755465, 0.82362133, 0.29203537, 0.30861592,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(kernel24, 2, Padding::Valid);
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.47013843, 0.6046999, 0.93370926, 0.3951412, 0.980512, 0.800127, 1.1895927,
            0.46199945, 1.0772017, 0.5553458, 0.2864257, 0.38878697, 0.32991305, 0.50431687,
            0.6361054, 1.2258638, 0.58024037, 1.1402652, 0.96692526, 1.507379, 0.7459955,
            1.1043959, 0.9148175, 0.6549411, 0.2459041, 0.6208593, 1.00322, 0.9507364, 1.3506846,
            0.6658336, 1.3151461, 0.8842221, 1.5610045, 0.8261229, 1.6200227, 0.49655515,
            0.8788183, 0.822728, 0.29964042, 0.36447665, 0.46372283, 0.77574074, 0.5180277,
            0.5227504, 0.11622915, 0.76429284, 0.6010256, 0.91706616, 0.26369086, 0.44792312,
            0.31194368, 0.40924042, 1.0120347, 1.0030633, 1.9978338, 1.058605, 1.0980942,
            0.5790782, 1.2814046, 0.8619273, 1.0877048, 0.7235441, 1.1321148, 0.6121552,
            0.23598856, 0.62656075, 0.7912231, 1.7165962, 1.022037, 1.1312366, 0.4776738,
            0.7493366, 0.5168178, 0.77666384, 0.6727385, 1.0229594, 0.4319582, 0.27182174,
            0.97473955, 1.0639127, 1.4406433, 0.77262074, 1.5880495, 0.82973367, 1.651045,
            0.6583468, 1.8189753, 1.2157288, 1.2445, 0.6099756, 0.42420235, 0.27473134, 0.34548485,
            0.57721573, 0.13218278, 0.9452145, 0.7488454, 1.2366765, 0.7768759, 1.1741337,
            0.9362016, 1.049906, 0.41463572, 0.5513109, 1.0278801, 1.1334536, 1.7185416, 1.1962572,
            2.0055406, 1.3171197, 1.635582, 0.7247701, 1.9941872, 1.1127274, 1.6755685, 0.9529666,
            0.39947808, 0.69338435, 0.8776655, 1.824428, 1.1561682, 1.7708116, 0.9865796,
            1.2951274, 0.35870448, 1.1688843, 0.7176407, 1.2255735, 0.71731603, 0.52833694,
            1.736645, 1.4431448, 2.631755, 1.3886511, 2.0525033, 1.0828207, 1.1956344, 0.94118893,
            1.935585, 1.3538715, 2.072002, 0.9848087, 0.54289955, 0.8109149, 1.0332316, 1.5239561,
            0.99112576, 0.9796556, 0.50551236, 0.6591139, 0.50839895, 1.3876927, 1.0510145,
            1.6043774, 0.8090419, 0.62651086, 0.9103058, 0.5448549, 1.1926861, 0.407966,
            0.75138223, 0.17253532, 0.63146496, 0.432911, 1.1181297, 0.7331517, 1.0619186,
            0.46162617, 0.26287138,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.39762703, 0.26186082, 0.9658112, 0.27424002, 0.50570756, 0.8114843, 0.5536027,
            0.59788686, 0.05054026, 0.28394443, 0.6402348, 0.02258505, 0.60607, 0.6834324,
            0.8004999, 0.3349493, 0.4295082, 0.37033585, 0.0394791, 0.50698835, 0.29841292,
            0.9388161, 0.84357476, 0.29760668, 0.25654384, 0.71037215, 0.14646496, 0.9906275,
            0.9552909, 0.7966291, 0.6094893, 0.7271988, 0.09518696, 0.3957746, 0.6157527,
            0.31079137, 0.46793708, 0.8514491, 0.86081386, 0.8208274, 0.2372746, 0.6977758,
            0.79387194, 0.9463199, 0.99063903, 0.29514915, 0.8795419, 0.741553, 0.03520088,
            0.83411527, 0.47134155, 0.26704508, 0.2872401, 0.04289522, 0.583651, 0.94414073,
            0.5729697, 0.72244126, 0.7707775, 0.02079507, 0.22973806, 0.18128674, 0.05054512,
            0.6523751, 0.27093726, 0.32479268, 0.53774405, 0.08921466, 0.18494032, 0.78120434,
            0.15868789, 0.81183356,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.21792394, 0.6620494, 0.6886836, 0.39724785, 0.59319293, 0.02472531, 0.21891202,
            0.5342134, 0.4041879, 0.53426075, 0.20461221, 0.29362342, 0.7835011, 0.47930118,
            0.2895624, 0.7320774, 0.55179524, 0.37774232, 0.04187773, 0.23883641, 0.63051957,
            0.97746944, 0.6415133, 0.4162999, 0.04763152, 0.75958186, 0.13098118, 0.6238241,
            0.4102024, 0.5710282, 0.59153587, 0.66274744, 0.6454271, 0.8120847, 0.22876394,
            0.6206928, 0.19057496, 0.4622738, 0.9772445, 0.17967562, 0.27354005, 0.48198408,
            0.09082693, 0.6217685, 0.0965838, 0.8904992, 0.5337058, 0.17222154, 0.62424076,
            0.95776683,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(kernel25, 2, Padding::Valid);
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (1, 15, 15),
        vec![
            0.44208896, 0.3245397, 1.2695606, 0.634794, 2.0789006, 1.2054553, 2.5269194, 1.0258477,
            2.055813, 0.81152856, 1.8345426, 0.9268601, 1.429618, 0.6085897, 0.87981635, 0.286633,
            0.39716944, 1.0245743, 1.1623408, 1.5420038, 1.5792196, 1.8985542, 1.6934587,
            1.5420654, 1.0453845, 1.1904142, 1.0371807, 1.2083287, 0.89464515, 0.5931701,
            1.0954585, 0.67642426, 2.8355193, 1.9523718, 4.0771976, 2.1941257, 3.7829463,
            2.1941762, 3.0623312, 1.9002366, 3.2267075, 1.5727149, 2.5076072, 1.3840015, 0.7971936,
            0.902385, 1.0922738, 2.000003, 2.4889853, 3.2537344, 3.165957, 2.396993, 2.2053018,
            2.058997, 1.992781, 2.7104297, 2.422242, 1.5475504, 1.0791705, 0.4429127, 1.4322487,
            1.3581108, 3.991303, 3.3819888, 5.8944235, 4.6643343, 5.584522, 3.5455782, 4.399416,
            2.592222, 4.7453437, 3.3778434, 2.2966142, 1.6736153, 1.0909125, 0.65824366, 0.8441143,
            1.8345774, 2.2787821, 2.3625925, 2.5600169, 2.0859182, 1.8736305, 2.018434, 1.6092469,
            1.3268441, 1.4599271, 0.8344489, 0.6465399, 0.28468493, 1.653792, 1.2520729, 4.0791597,
            3.2144418, 5.601583, 3.7466202, 5.163023, 3.137791, 5.7103662, 3.3287764, 4.361541,
            2.6879416, 2.6595263, 0.81848514, 1.014666, 0.79954565, 0.74684846, 1.9294479,
            2.0530565, 2.5781665, 2.6328394, 2.3738782, 1.9103525, 2.5156136, 2.2171538, 2.2116013,
            1.4674388, 1.0735346, 0.17935608, 0.25634938, 1.0142431, 0.9339591, 3.1715593,
            2.9957697, 3.891791, 3.66184, 4.6994905, 3.0339134, 4.805859, 3.7589023, 4.5685105,
            3.0524843, 2.6386995, 0.79360276, 0.8066558, 0.3307951, 0.5115137, 1.1074693,
            1.6652787, 1.4378916, 1.5489991, 2.2042022, 1.9844573, 2.599229, 2.644361, 2.4817364,
            1.6846012, 1.5977834, 0.6111398, 0.57299626, 1.2810048, 0.94314355, 2.8327875,
            2.9266648, 3.9506912, 2.3809152, 4.780689, 2.7979503, 5.1774864, 4.4283285, 5.1473966,
            2.7745757, 3.2488596, 1.2925793, 0.97106254, 0.58381724, 0.7421028, 1.4308363,
            1.5343058, 1.49577, 0.7574289, 2.2017903, 1.6916606, 2.1646726, 2.139161, 2.666543,
            1.788411, 1.6400297, 1.0202026, 0.5733956, 0.8248203, 0.6548172, 1.7437705, 2.0894928,
            1.874924, 1.0779616, 2.46822, 1.900452, 2.6033385, 3.06217, 3.5012753, 2.2150204,
            1.697587, 1.4767079, 0.5848805, 0.5932879, 0.59549737, 0.8358412, 0.80414116,
            0.60057527, 0.2275863, 0.73848027, 0.7138909, 0.7552377, 0.9185568, 0.86657834,
            0.6872375, 0.35352623, 0.51778775, 0.15263826, 0.8631556, 0.88275427, 1.0215652,
            1.347841, 1.250643, 0.5501703, 1.1582043, 0.95886445, 1.0996541, 1.3389926, 2.108303,
            1.0924666, 0.5205073, 0.636162, 0.7923507,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.998361, 0.150883, 0.28713444, 0.35105017, 0.1765902, 0.9674033, 0.65025777,
            0.1959308, 0.3119046, 0.55247456, 0.38556734, 0.18145509, 0.94255227, 0.7036003,
            0.3402552, 0.16401337, 0.28418577, 0.5504918, 0.6148071, 0.7740251, 0.37459207,
            0.25677747, 0.80441076, 0.17314304, 0.5946227, 0.30094627, 0.06480476, 0.5798754,
            0.62549657, 0.6065069, 0.9259787, 0.3677915, 0.69532603, 0.8356569, 0.39276573,
            0.18570696, 0.61698794, 0.9064707, 0.01547038, 0.2551995, 0.11438051, 0.03861368,
            0.6524532, 0.36442748, 0.08230381, 0.79969245, 0.27816203, 0.3741886, 0.44356522,
            0.27386904, 0.4171807, 0.14990133, 0.4750283, 0.6358263, 0.77572674, 0.7072159,
            0.34310365, 0.36999545, 0.8200852, 0.46510443, 0.9230857, 0.86201537, 0.04691705,
            0.12260284, 0.89921826, 0.47400048, 0.7492544, 0.05440097, 0.28273952, 0.9184355,
            0.9064988, 0.7027802,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.19125043, 0.8670149, 0.08634489, 0.722654, 0.77540857, 0.00211577, 0.6443405,
            0.2344423, 0.9849179, 0.9893316, 0.87634915, 0.48734385, 0.8760625, 0.53053117,
            0.01152504, 0.6788874, 0.76156837, 0.4680538, 0.07214947, 0.549209, 0.8383253,
            0.00365476, 0.9782156, 0.7419056, 0.40790308, 0.00302504, 0.80174476, 0.7689671,
            0.50054824, 0.16478458, 0.89107823, 0.7763043, 0.73042727, 0.41667554, 0.7348974,
            0.71259016, 0.93557405, 0.37013116, 0.14954911, 0.33766475, 0.39673004, 0.03940821,
            0.2414454, 0.9373305, 0.84819096, 0.9272432, 0.8604789, 0.92845494, 0.8023847,
            0.06647868,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(kernel26, 2, Padding::Valid);
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (1, 15, 15),
        vec![
            0.19280338, 1.3602607, 0.59224534, 1.8878777, 1.6408433, 0.82412165, 0.37096763,
            0.72421306, 0.48586613, 0.62623775, 0.6025959, 1.054578, 0.26900068, 0.71842587,
            0.7564957, 0.5518968, 1.1222548, 1.4927784, 2.0413046, 2.15301, 0.7233336, 1.1221981,
            0.71355826, 0.66644156, 0.6546693, 0.6962519, 0.8748995, 0.5137689, 0.9689022,
            0.98545974, 1.4409081, 2.1506672, 2.4775972, 2.8020823, 1.9189723, 1.0304332,
            1.4648699, 1.9512365, 1.6394311, 1.7743196, 2.0057514, 1.4935695, 1.5506709, 0.8374409,
            0.22655018, 1.505315, 1.7101243, 2.0324779, 2.1224475, 3.0711145, 1.6895202, 2.6380804,
            1.6309038, 1.8933913, 1.7452568, 2.9532635, 1.7612773, 1.5578542, 0.440625, 1.0185678,
            2.6254392, 2.634704, 4.31688, 4.628062, 3.700486, 2.5161169, 3.4037187, 2.3586073,
            2.8178804, 2.2459276, 3.0776, 2.3744166, 2.292749, 1.6170089, 1.0572457, 1.0975451,
            1.4725939, 1.5299753, 2.6011794, 3.3305557, 1.9467078, 2.690672, 1.2829131, 2.2799346,
            1.8699133, 2.7547426, 1.7676159, 1.8467028, 1.1709528, 1.4289262, 2.4121242, 2.5931156,
            4.345466, 4.5564337, 3.9381845, 2.9933038, 3.5570996, 2.4123728, 3.7382853, 3.7103558,
            3.8205032, 3.4316583, 2.7134497, 1.1799359, 0.53083086, 1.5083964, 1.7336433,
            2.4771504, 3.0069156, 3.868723, 2.1477864, 3.003687, 1.5109867, 2.7207265, 1.9495103,
            2.8192616, 2.51667, 2.7489936, 1.0000263, 1.354737, 2.4095335, 2.6661215, 5.006969,
            4.618274, 5.12479, 2.8646965, 3.0217876, 2.109476, 3.240924, 3.7462637, 4.7990193,
            4.018047, 2.9364061, 1.7555587, 0.9742597, 1.5489385, 1.5985225, 2.8635197, 3.2221932,
            3.9278767, 1.7513053, 2.6954036, 1.1109535, 2.7044127, 2.7335813, 3.2223308, 2.7264285,
            3.0987864, 1.2433126, 1.4379673, 2.5929348, 3.2266922, 5.093485, 4.503286, 4.3886843,
            2.9249263, 3.3044932, 3.4161077, 5.4060063, 4.7990103, 5.620159, 4.3230696, 3.0118437,
            1.3802829, 0.52839446, 1.439501, 1.667518, 1.8611042, 2.6747234, 3.3672237, 1.9333391,
            2.9739537, 2.5491815, 3.728838, 2.831089, 4.4146767, 2.7983575, 3.1161869, 0.96379167,
            1.4353391, 2.699804, 1.948722, 3.9399183, 2.7581177, 2.9133162, 1.7621968, 3.010026,
            1.8710333, 4.234467, 2.9248338, 4.3023047, 2.687609, 2.0817344, 1.033925, 0.5183513,
            0.925887, 0.73472285, 0.8855834, 1.0513501, 1.9135671, 0.6182082, 1.5735409,
            0.98779154, 1.8608599, 1.2560112, 2.0455527, 1.0471506, 1.2411985, 0.67213595,
            0.69808376, 1.4710125, 0.6481018, 1.9602275, 1.3363341, 1.6828849, 0.56234974,
            2.6484947, 1.5360806, 3.1424105, 2.1383758, 2.4351072, 1.624162, 1.0546343, 0.7016771,
            0.12247033,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.12827316, 0.02774826, 0.8982795, 0.1193029, 0.37523487, 0.28379655, 0.0638791,
            0.08446726, 0.68760884, 0.2630593, 0.01052708, 0.45302406, 0.10402057, 0.5539082,
            0.39986408, 0.53770447, 0.24856173, 0.12796782, 0.80071914, 0.38390577, 0.6908975,
            0.5850918, 0.71101063, 0.17578217, 0.55867785, 0.71616316, 0.3247584, 0.9196999,
            0.46712968, 0.08430128, 0.83232373, 0.49657014, 0.24024557, 0.60874844, 0.47418702,
            0.9770886, 0.99522823, 0.7749884, 0.7253688, 0.26021662, 0.8869578, 0.5181486,
            0.5871326, 0.76900613, 0.5745777, 0.81429285, 0.78002185, 0.7069771, 0.33134556,
            0.7407027, 0.58577555, 0.40479863, 0.7506117, 0.11343616, 0.8795398, 0.83064,
            0.8858372, 0.3898591, 0.9350765, 0.9673369, 0.64465624, 0.0283905, 0.22112074,
            0.1391855, 0.34128338, 0.65248054, 0.291874, 0.70765275, 0.32796225, 0.22921298,
            0.59572685, 0.5726663,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.72872376, 0.8248998, 0.29288608, 0.92347336, 0.25887516, 0.91578674, 0.800785,
            0.7670362, 0.8990461, 0.8424308, 0.7045559, 0.43518323, 0.48451254, 0.31151697,
            0.10086012, 0.5242353, 0.19001916, 0.01069371, 0.01020448, 0.12606935, 0.04778918,
            0.8456499, 0.57045126, 0.46361542, 0.7532553, 0.62787765, 0.3127784, 0.9686197,
            0.96754897, 0.5766132, 0.6463905, 0.6347338, 0.52757853, 0.55145216, 0.08155768,
            0.13378453, 0.2262157, 0.73179847, 0.5428326, 0.9094368, 0.2528448, 0.24383228,
            0.7446406, 0.5544842, 0.01949351, 0.13375893, 0.04438103, 0.8489, 0.6848837, 0.9220802,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(kernel27, 2, Padding::Valid);
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (1, 15, 15),
        vec![
            0.71835726, 0.4170984, 1.5083859, 1.3466781, 2.475905, 1.7433343, 1.670075, 1.7111701,
            1.768136, 0.94889784, 1.6820982, 1.6008639, 1.1935796, 0.7634127, 0.3722392,
            0.76077694, 0.73442423, 1.1498079, 1.178276, 1.9108849, 1.6320608, 1.4357417,
            1.4683052, 1.9616483, 1.1142204, 1.4723092, 1.3826147, 0.87949395, 0.5408803,
            0.28133795, 0.6387194, 0.5172948, 2.0455008, 1.7048674, 4.2150865, 2.5533173,
            3.7187195, 2.446978, 3.2540727, 1.8258129, 3.4191186, 2.198336, 2.631134, 1.472066,
            1.0247762, 0.7569002, 0.69086945, 1.8861458, 1.6843472, 2.840576, 2.1929016, 2.428377,
            2.1600485, 2.5147457, 1.6221563, 2.5438533, 1.9270276, 1.2464218, 1.0873548,
            0.48517942, 0.54665315, 0.50270545, 2.8661475, 2.453527, 5.29025, 3.9496846, 5.5609956,
            3.356668, 4.8413153, 2.6232488, 4.4733753, 2.9250295, 3.794061, 1.2392688, 1.4787254,
            0.4913804, 0.44891447, 1.9172492, 1.7197175, 2.773913, 2.296491, 2.7015135, 1.9441967,
            2.6332507, 2.028523, 2.3094032, 1.5029557, 0.9764375, 0.5742341, 0.18794954, 1.3349507,
            1.1359146, 3.3117468, 3.325102, 5.57368, 4.0591755, 5.868994, 3.8387127, 5.7431393,
            3.184895, 5.156518, 3.5287156, 4.150178, 1.8939431, 1.7124871, 1.4401245, 1.3000362,
            2.6922073, 2.5102165, 3.6190796, 2.5539117, 3.0852447, 2.355396, 3.2534087, 2.3641007,
            3.082689, 2.380361, 1.4522231, 0.7556807, 0.24532215, 1.5429988, 1.3125834, 3.2071452,
            3.5976012, 4.835, 3.2256687, 5.4156218, 3.4141936, 4.8445554, 3.1609488, 4.5310135,
            2.8021874, 3.7382329, 1.4260365, 1.4965034, 1.5704818, 1.2231781, 2.5176206, 2.2206354,
            2.8547626, 1.871708, 3.0405197, 1.9432098, 2.7289855, 2.07955, 2.9454517, 1.8848418,
            1.6603181, 0.9737693, 0.16525032, 1.425572, 1.8829973, 3.9163575, 3.8591754, 5.3542137,
            3.2443228, 4.8772864, 3.2050438, 4.688306, 3.1850035, 5.0567527, 3.6761138, 4.502186,
            2.5808554, 2.2094145, 1.4067723, 1.1151221, 2.5732093, 2.262229, 2.2491715, 1.3759067,
            2.3152876, 1.3644336, 2.1262326, 1.6900835, 3.0614626, 2.2698772, 2.0519533, 1.5568962,
            0.89318174, 0.73839414, 0.92929614, 1.965368, 2.1013124, 2.813971, 1.353482, 2.5107856,
            1.6555641, 2.3582554, 1.5870684, 3.1691854, 1.576411, 2.7506294, 1.1011982, 1.2844929,
            0.5101323, 0.22932576, 0.66548777, 0.43723935, 0.851746, 0.52306855, 0.7002627,
            0.35586485, 0.61308384, 0.36866897, 1.1869059, 0.66046, 0.5082725, 0.32750508,
            0.1343442, 0.07881682, 0.71680814, 0.8409575, 1.0371087, 1.835428, 0.9325964,
            1.5017631, 0.86095834, 1.1275587, 0.8666446, 1.5694023, 1.4795344, 1.9500096,
            0.84520316, 1.2640414,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.00185038, 0.44556108, 0.00844186, 0.8082305, 0.33159012, 0.5138473, 0.65069795,
            0.9300001, 0.58097035, 0.5413155, 0.5714561, 0.21683556, 0.8548128, 0.02262598,
            0.62476623, 0.33444464, 0.98826236, 0.03221937, 0.12669064, 0.50246465,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.42635268, 0.91064155, 0.7792924, 0.07601635, 0.6067355, 0.3940292, 0.30074376,
            0.1328066, 0.72018456, 0.34319454, 0.6295161, 0.03357495, 0.03066352, 0.51702976,
            0.9283114, 0.36689135,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(kernel28, 2, Padding::Valid);
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.00078891, 0.00168503, 0.19140814, 0.4058871, 0.35082155, 0.04155744, 0.35116994,
            0.73665, 0.77122223, 0.36339846, 0.25840566, 0.02520627, 0.00112269, 0.0007291,
            0.27089423, 0.17580982, 0.1391217, 0.0624998, 0.492921, 0.31958756, 0.4442578,
            0.23799452, 0.09972366, 0.04403736, 0.22041278, 0.46856573, 0.9999152, 0.78458965,
            1.1901596, 0.91421735, 1.5598296, 0.87741464, 1.4311373, 0.6780439, 0.63058436,
            0.05228195, 0.31182614, 0.20342754, 0.5647181, 0.55568355, 1.1738358, 0.62070143,
            0.66480696, 0.7734059, 1.2636158, 0.7584256, 0.47061616, 0.19354782, 0.6137067,
            0.6967412, 1.3298776, 0.48146784, 1.6128266, 1.1359292, 1.6796517, 0.31619444,
            1.0395802, 0.7759406, 0.82764244, 0.06566709, 0.36247906, 0.49084473, 0.80038667,
            0.68628895, 1.2164247, 1.0851916, 1.1519519, 0.764028, 0.94179255, 0.74221027,
            0.6904039, 0.28157705, 0.5541452, 0.5006798, 1.1978809, 1.0189794, 1.5360066,
            0.40511173, 0.6335365, 0.15428436, 0.77714664, 0.6823718, 0.7848673, 0.05917203,
            0.22044231, 0.42724076, 1.2373343, 0.7555934, 0.54426485, 0.6654619, 0.8807838,
            0.37952048, 0.38312608, 0.54613507, 0.7310907, 0.29595196, 0.24086186, 0.11477958,
            0.9222696, 0.3503952, 0.645331, 0.04423837, 0.11152326, 0.0445613, 0.44162107,
            0.17669675, 0.3163096, 0.01687023, 0.01025525, 0.17291783, 0.34077236, 0.6336659,
            0.91840315, 0.37924328, 0.03379439, 0.07732384, 0.1330157, 0.30627087, 0.46644366,
            0.18434994,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.6327302, 0.37459058, 0.93406814, 0.33968034, 0.59511477, 0.4350908, 0.7094508,
            0.29612544, 0.80898666, 0.7905302, 0.4748418, 0.6989706, 0.85952836, 0.70326394,
            0.38940284, 0.37933362, 0.22292, 0.3949557, 0.27719194, 0.8619771,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.9255003, 0.30563155, 0.5844432, 0.36121982, 0.09087573, 0.23811613, 0.17829578,
            0.9398569, 0.04807154, 0.7588201, 0.05337733, 0.19222781, 0.98696715, 0.32119673,
            0.3872288, 0.74463385,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(kernel29, 2, Padding::Valid);
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.585592, 0.19338231, 0.7164786, 0.34304136, 1.0834073, 0.42079023, 0.860284,
            0.44122094, 0.74930274, 0.30458513, 0.34781078, 0.21496725, 0.05749982, 0.15066326,
            0.14685431, 0.68387187, 0.15167204, 0.57447827, 0.1974091, 0.95877373, 0.11464506,
            0.46095735, 0.10610645, 0.5593227, 0.43309298, 0.6131059, 0.96266335, 0.77986914,
            0.7535946, 1.1275694, 0.98797286, 0.7915284, 1.2511821, 1.0507141, 0.49378565,
            0.3999528, 0.6640231, 0.30683303, 0.7567667, 1.1693244, 1.2203496, 1.3162469,
            0.82326657, 1.2755914, 0.9349716, 1.3926561, 0.37139374, 1.1861279, 0.4603817,
            0.4752823, 0.981744, 1.0071318, 1.2561063, 0.87626314, 1.2079122, 1.1962172, 0.8525938,
            1.1284266, 0.26978022, 0.2926219, 0.4725719, 0.25281724, 1.016866, 1.1645762,
            0.7697196, 1.4849956, 1.1302714, 1.455641, 1.2542665, 1.6100051, 0.37554494, 0.9546385,
            0.37389973, 0.47625583, 0.48695785, 0.82682496, 0.5744437, 0.987823, 0.5670567,
            0.92626053, 1.0160205, 0.7942482, 0.52456194, 0.38621727, 0.5031255, 0.24284309,
            0.96162504, 0.9876905, 1.1946254, 1.1001132, 1.1225414, 1.3031256, 0.7844068,
            1.1145204, 0.3044749, 1.1000977, 0.01823515, 0.28784597, 0.03096392, 0.24207464,
            0.030885, 0.34255174, 0.03440672, 0.28626028, 0.05623233, 0.70736957, 0.04601003,
            0.16569597, 0.37438983, 0.12184072, 0.3669036, 0.35406584, 0.47612935, 0.29285225,
            0.42651755, 0.38313055, 0.95807976, 0.48327073, 0.33378235, 0.6418573,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.6260977, 0.0084233, 0.31085488, 0.10247751, 0.60939455, 0.00353958, 0.22236562,
            0.31823838, 0.9627444, 0.866447, 0.8205645, 0.7792785, 0.61566937, 0.59327537,
            0.33567885, 0.96525836, 0.47292593, 0.2669342, 0.705448, 0.28257245,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.02662205, 0.05098573, 0.8293213, 0.9416077, 0.9101412, 0.07020015, 0.8425068,
            0.9708137, 0.3117258, 0.11623824, 0.19467542, 0.09732427, 0.43287596, 0.20617688,
            0.8857049, 0.9601851,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(kernel30, 2, Padding::Valid);
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.016668, 0.03192205, 0.5194604, 0.58996785, 0.01526121, 0.0237806, 0.26052675,
            0.29792824, 0.10121012, 0.12756404, 0.5053839, 0.57381064, 0.56983733, 0.04395215,
            0.535158, 0.60841554, 0.29001853, 0.02999951, 0.35516638, 0.30897608, 0.6409731,
            0.14226615, 0.5134191, 0.5916086, 0.19526502, 0.07295696, 0.13336687, 0.07658398,
            0.291426, 0.26255983, 0.3820128, 0.39090747, 1.031405, 1.0315125, 0.83719707,
            0.87516207, 0.27424416, 0.12933534, 0.7635503, 0.6219527, 0.61900854, 0.31039497,
            1.4640371, 0.6961417, 1.954265, 1.2195106, 1.2697313, 1.4262902, 0.02294849,
            0.04224852, 0.77126384, 0.8385739, 0.8051549, 0.82379806, 0.8884474, 0.7528476,
            0.9584689, 0.77016014, 0.44706157, 0.40040413, 0.74836177, 0.05833353, 1.4999764,
            0.900566, 1.5516016, 1.07888, 1.7572842, 1.1434116, 2.0331252, 1.7025788, 1.050228,
            1.1578311, 0.28148827, 0.14459538, 1.2157645, 1.10345, 0.7429403, 0.60632753,
            0.5449496, 0.41619593, 0.8127016, 0.77542126, 0.29969177, 0.2987421, 1.2337241,
            0.23694271, 2.307775, 1.9188485, 1.5981103, 1.3530502, 1.6690671, 1.0221422, 1.5222998,
            1.3435585, 0.5353816, 0.59663904, 0.30089593, 0.11219994, 0.33533528, 0.14891514,
            0.17527732, 0.07705513, 0.27187186, 0.10797921, 0.22541851, 0.10150293, 0.05500991,
            0.02750116, 0.41783714, 0.19901395, 1.0596523, 1.0243331, 0.5344222, 0.5091321,
            0.5417964, 0.4017533, 0.7471375, 0.73562056, 0.2502758, 0.27132186,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );

    let test_input31 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.09430943, 0.28105715, 0.6942895, 0.07089514, 0.7148581, 0.00085336, 0.23516753,
            0.04615124, 0.59699446,
        ],
    )
    .unwrap();

    let kernel31: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.53420085, 0.75324225, 0.38793716, 0.2669936, 0.29911962, 0.7380972, 0.17850904,
            0.65695775, 0.8119258, 0.26960826, 0.12972821, 0.6597052, 0.7345929, 0.6485681,
            0.22981846, 0.24392553,
        ],
    )
    .unwrap();
    let conv_layer31 = TransposedConvolutionLayer::new(kernel31, 2, Padding::Valid);
    let target_output31: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.05038017, 0.07103784, 0.1867271, 0.23688413, 0.47992256, 0.59800863, 0.2693407,
            0.18537086, 0.0282098, 0.06960952, 0.10090479, 0.2694048, 0.25784686, 0.6970958,
            0.12393695, 0.45611888, 0.11444451, 0.07882781, 0.6498128, 0.6953816, 0.8779485,
            0.5641064, 0.09039999, 0.45825425, 0.09048516, 0.11349359, 0.45462012, 0.77949905,
            0.70247614, 0.9891125, 0.15971288, 0.16991556, 0.18318829, 0.19625203, 0.70549315,
            0.33705282, 0.43024886, 0.9338293, 0.23170704, 0.15995668, 0.12242229, 0.21955681,
            0.597207, 0.6694866, 0.35172564, 0.645885, 0.10676502, 0.3924083, 0.19093859,
            0.06340311, 0.06797925, 0.167584, 0.49070233, 0.19140086, 0.07744703, 0.39384037,
            0.17275241, 0.15252216, 0.08794822, 0.08729558, 0.44915432, 0.39844903, 0.13720036,
            0.1456222,
        ],
    )
    .unwrap();
    let current_output31: Array3<f32> = conv_layer31.transposed_convolve(&test_input31);

    assert!(
        arr_allclose(&current_output31, &target_output31),
        "{:?} was not equal to {:?}",
        current_output31,
        target_output31
    );

    let test_input32 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.26706976, 0.32711208, 0.9581323, 0.31259444, 0.91530424, 0.17250775, 0.715259,
            0.5014661, 0.7273789,
        ],
    )
    .unwrap();

    let kernel32: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.23862323, 0.4093651, 0.04974006, 0.8688277, 0.46409306, 0.20740515, 0.19872624,
            0.27135858, 0.02647329, 0.90772045, 0.97377276, 0.47016057, 0.06899374, 0.47393376,
            0.49847803, 0.02369655,
        ],
    )
    .unwrap();
    let conv_layer32 = TransposedConvolutionLayer::new(kernel32, 2, Padding::Valid);
    let target_output32: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.06372905, 0.10932904, 0.09134061, 0.36594588, 0.2449032, 0.67643, 0.04765756,
            0.8324519, 0.12394522, 0.05539164, 0.20488422, 0.1403164, 0.50966835, 0.28748626,
            0.19040602, 0.25999743, 0.08166251, 0.37038994, 0.5026863, 1.0687764, 0.43058938,
            1.8893719, 0.94158375, 0.60035557, 0.16349904, 0.19140707, 0.6426042, 0.4360221,
            0.4911179, 0.7459973, 0.5118897, 0.06951589, 0.17895283, 0.5765504, 0.48386553,
            1.8045294, 1.0943776, 1.3203799, 0.20416322, 0.7130733, 0.35351378, 0.29649746,
            0.5938394, 0.7392993, 0.9053869, 0.39038607, 0.23054059, 0.20146835, 0.01893526,
            0.6492552, 0.7097752, 0.79147756, 0.50757015, 0.89602625, 0.7083018, 0.3419849,
            0.0493484, 0.33898538, 0.3911389, 0.25461087, 0.30015442, 0.35661244, 0.3625824,
            0.01723637,
        ],
    )
    .unwrap();
    let current_output32: Array3<f32> = conv_layer32.transposed_convolve(&test_input32);

    assert!(
        arr_allclose(&current_output32, &target_output32),
        "{:?} was not equal to {:?}",
        current_output32,
        target_output32
    );

    let test_input33 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.10663922, 0.02373338, 0.21085607, 0.56809616, 0.70259374, 0.4123619, 0.01858313,
            0.25862443, 0.4823392,
        ],
    )
    .unwrap();

    let kernel33: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.47215322, 0.593886, 0.8265343, 0.06712108, 0.3228139, 0.11140465, 0.59627575,
            0.49184018, 0.8395536, 0.13370071, 0.25792846, 0.54400545, 0.8792363, 0.58678144,
            0.03434712, 0.8123595,
        ],
    )
    .unwrap();
    let conv_layer33 = TransposedConvolutionLayer::new(kernel33, 2, Padding::Valid);
    let target_output33: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.05035005, 0.06333154, 0.09934676, 0.02125266, 0.11917283, 0.12681748, 0.17427976,
            0.01415289, 0.03442462, 0.01188011, 0.07124785, 0.05509346, 0.08221891, 0.03516338,
            0.12572835, 0.10370748, 0.35775778, 0.3516421, 0.8487136, 0.5165773, 0.95856225,
            0.3331575, 0.395217, 0.14238504, 0.2771504, 0.12586248, 0.590079, 0.45824042,
            0.73826325, 0.5345093, 0.2531237, 0.37410706, 0.4857213, 0.08699112, 0.8738632,
            0.55782545, 0.96891874, 0.7411615, 0.50502974, 0.25670224, 0.50548965, 0.33541852,
            0.73182666, 0.9117192, 0.6966129, 0.99366176, 0.3017706, 0.5722199, 0.01560154,
            0.00248458, 0.22192219, 0.0446876, 0.4716562, 0.2051822, 0.12440901, 0.26239514,
            0.01633896, 0.01090424, 0.22803026, 0.1668522, 0.43297312, 0.4931237, 0.01656696,
            0.39183283,
        ],
    )
    .unwrap();
    let current_output33: Array3<f32> = conv_layer33.transposed_convolve(&test_input33);

    assert!(
        arr_allclose(&current_output33, &target_output33),
        "{:?} was not equal to {:?}",
        current_output33,
        target_output33
    );
}
