// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_torch_transpose() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637, 0.14352316, 0.8997107, 0.64410555,
            0.04471071, 0.767672, 0.43464628, 0.16569944, 0.18875164, 0.12285258, 0.2781115,
            0.5390728, 0.5066572, 0.97435564, 0.39133722,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(kernel1, 1, Padding::Valid);
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.502705, 0.9429496, 1.2797613, 1.9176188, 1.5595503, 1.048703, 0.68886304, 1.0313098,
            2.269095, 3.740393, 4.6934915, 3.951138, 2.713698, 1.6001914, 0.8498012, 2.1968966,
            3.9940155, 5.545063, 4.0846105, 3.0748034, 1.3273236, 1.877612, 3.0732944, 5.274679,
            7.072177, 5.3057566, 4.2879295, 1.4235954, 2.297185, 3.7321212, 6.783723, 7.271183,
            6.0375457, 4.682065, 1.7877847, 1.1684452, 2.017402, 4.105599, 4.5629334, 3.5949254,
            2.758629, 0.6369324, 1.1169262, 1.4684255, 2.7736907, 2.9664128, 2.6813393, 1.4310664,
            0.4190872, 0.5252309, 0.9249735, 1.6928465, 2.0780373, 1.7369382, 1.3046416, 0.3887366,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.7964828, 0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183,
            0.81628793, 0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133,
            0.0067116, 0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715,
            0.7567798, 0.23972042, 0.38848338, 0.00744711, 0.8715701, 0.07988323, 0.6283005,
            0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194, 0.34163022, 0.03235205,
            0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.97700953, 0.18019113, 0.775954, 0.14120784, 0.3426181, 0.5417864, 0.7768226,
            0.34603763, 0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802, 0.629322,
            0.60627973, 0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678, 0.89887625,
            0.6572328, 0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983, 0.6908677,
            0.5511301, 0.36253917, 0.36786652, 0.88718724,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(kernel2, 1, Padding::Valid);
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.80761784, 1.4047898, 1.7932408, 1.2941029, 0.8047526, 0.10153412, 0.04166387,
            0.8912326, 2.7170906, 4.153331, 4.297767, 2.8265631, 1.282428, 0.32442036, 1.8795388,
            4.420615, 6.301212, 6.9407735, 4.938551, 2.7627223, 0.9171338, 2.853494, 5.9678917,
            7.847625, 8.509516, 6.6973267, 3.4506176, 1.659546, 2.9398742, 5.697431, 7.437649,
            8.574824, 6.400357, 3.328308, 1.7446139, 2.5361488, 4.877659, 5.9356246, 7.020297,
            4.644166, 2.7666767, 1.2419925, 1.4844711, 3.0892892, 3.1519656, 4.1183887, 2.9307432,
            1.2566776, 1.0967124, 0.81183, 1.1914632, 1.3408532, 1.9339681, 1.50156, 0.6850412,
            0.84211254,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.69587743, 0.4870034, 0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529,
            0.5566727, 0.7035832, 0.92333794, 0.85647196, 0.36252776, 0.9373231, 0.01684272,
            0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754, 0.31284246, 0.4031665,
            0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259, 0.23846498, 0.82509995,
            0.97324103, 0.96826524, 0.77620417, 0.8427075, 0.42989048, 0.76771307, 0.54514444,
            0.7878393, 0.21897991, 0.975659, 0.73295325, 0.69994044,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.86701024, 0.76087946, 0.623545, 0.14890751, 0.8610666, 0.21943341, 0.1644093,
            0.6089244, 0.8612485, 0.02602104, 0.30423534, 0.5087405, 0.16869895, 0.3329467,
            0.179494, 0.33126613, 0.11996287, 0.21606164, 0.87119263, 0.33579683, 0.2313126,
            0.2576527, 0.3748985, 0.30113342, 0.8142977, 0.423247, 0.8179498, 0.92175007,
            0.21606776, 0.19149332, 0.4240341, 0.14780204,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(kernel3, 1, Padding::Valid);
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.6516979, 1.1273124, 2.028801, 2.798158, 2.284626, 1.3040509, 0.2689164, 0.99201345,
            1.8634316, 3.3373132, 4.0776305, 2.5280683, 2.2012532, 1.0699694, 2.0465374, 3.798849,
            6.22866, 7.448679, 5.091766, 3.8540993, 1.7611845, 2.7837794, 3.932057, 5.714086,
            8.113128, 5.6842246, 4.660744, 2.300539, 2.8676977, 3.9839854, 6.4955125, 9.24818,
            6.2704988, 4.605478, 2.3478477, 1.8503224, 2.6360874, 4.4229307, 6.3736625, 4.2340827,
            3.417551, 1.841166, 0.7427548, 2.1024165, 2.648695, 3.8283474, 3.2823966, 2.421556,
            1.2261951, 0.10870812, 0.49979305, 0.8793051, 1.2965395, 1.0760272, 0.7116136,
            0.20708674,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.46443272, 0.00207204, 0.359202, 0.9019851, 0.21363449, 0.6390296, 0.5977058,
            0.81350476, 0.3685356, 0.90738845, 0.7828945, 0.9812083, 0.6726924, 0.46724817,
            0.17302093, 0.39839587, 0.78055173, 0.8576361, 0.7335981, 0.52934057, 0.9529279,
            0.78965247, 0.46750203, 0.08403921, 0.73126566, 0.34934825, 0.3459232, 0.54770446,
            0.68714255, 0.29283327, 0.53392637, 0.8850151, 0.6909357, 0.44388366, 0.9043074,
            0.9949724, 0.64743847, 0.36691284, 0.5396585, 0.5372604,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.47547424, 0.44373918, 0.34716287, 0.21774843, 0.9437953, 0.51856595, 0.15765554,
            0.9350713, 0.86233217, 0.81734437, 0.6566154, 0.3879487, 0.28848994, 0.5814131,
            0.06870039, 0.78543746, 0.47194287, 0.12733267,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(kernel4, 1, Padding::Valid);
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.999696, 1.4781973, 1.6032398, 1.2709846, 0.76149595, 0.34573865, 1.0753132,
            2.3849704, 2.418202, 2.5710032, 2.1808553, 0.96841216, 1.8160284, 3.6567876, 4.31555,
            4.639324, 4.1677446, 1.9319746, 1.7711062, 3.2865639, 4.816927, 5.892727, 4.7029104,
            1.8651805, 1.8439273, 3.7875152, 5.2622237, 5.8000474, 4.2363214, 1.6259652, 1.0054839,
            2.7831144, 3.8394492, 3.6386466, 2.3359013, 0.78165007, 0.6315807, 1.4588236,
            2.2701714, 2.2323794, 1.4498489, 0.5248782,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6111727, 0.25675833, 0.74741316, 0.45714313, 0.9649919, 0.57969916, 0.5208711,
            0.93666834, 0.13247305, 0.7087714, 0.17877895, 0.40767, 0.6906785, 0.9675369, 0.224454,
            0.28950995, 0.75431514, 0.99582964, 0.8120864, 0.9536324, 0.7703749, 0.683158,
            0.16371861, 0.42877796, 0.7300311, 0.9456737, 0.05700503, 0.19623296, 0.44457257,
            0.5512328, 0.15101007, 0.25140873, 0.2031063, 0.5537751, 0.3641559, 0.701937,
            0.27669305, 0.85076064, 0.00186597, 0.3316532,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.15485734, 0.35000807, 0.42372492, 0.03995521, 0.5067197, 0.38907993, 0.37287286,
            0.21294773, 0.8646356, 0.10154326, 0.75313085, 0.7910046, 0.15368015, 0.25977603,
            0.40315583, 0.635939, 0.25689796, 0.13678746,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(kernel5, 1, Padding::Valid);
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.17287096, 0.9032394, 1.605081, 1.1484096, 0.9291295, 0.53286827, 0.3663767,
            1.6984262, 2.8988857, 2.2646203, 1.4412652, 0.9028405, 0.93420666, 2.2522793,
            3.5995948, 2.9142466, 2.1546159, 1.2690704, 1.0252702, 2.1070008, 3.5753164, 3.2298799,
            2.1234958, 1.7746001, 0.5358338, 1.9967597, 3.3339782, 3.5663772, 1.8189571, 1.4489251,
            0.4593595, 1.5368297, 2.4519267, 2.8395061, 1.3719581, 0.85108393, 0.45722353,
            1.1440613, 1.4246658, 1.7173092, 0.9906889, 0.86991054,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.43744904, 0.6658951, 0.564682, 0.70429957, 0.67241764, 0.15790685, 0.25059524,
            0.6432024, 0.60438925, 0.45131883, 0.96080875, 0.40131757, 0.60942906, 0.7035094,
            0.6473561, 0.05433872, 0.7478619, 0.24740443, 0.35665986, 0.00020906, 0.23741227,
            0.57013196, 0.6398819, 0.7132858, 0.90739846, 0.8246988, 0.1319153, 0.6876462,
            0.846729, 0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465, 0.05539654,
            0.5554673, 0.9149804, 0.9791666, 0.9000323, 0.6329186,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.30872977, 0.30553624, 0.04431259, 0.5287215, 0.3358437, 0.72178566, 0.72704846,
            0.85191244, 0.07464863, 0.867838, 0.5849202, 0.14913943, 0.18325551, 0.40498126,
            0.75359416, 0.01821492, 0.5917236, 0.91982275,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(kernel6, 1, Padding::Valid);
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.34108895, 0.9728876, 1.3213769, 1.4978021, 0.75285846, 0.13758838, 1.269866,
            2.2002742, 2.2526097, 2.9412181, 2.0447106, 1.1769385, 1.7655951, 2.8122463, 4.767697,
            4.764971, 3.047207, 1.7904596, 1.4558735, 3.3807273, 4.693439, 3.8900793, 3.2032518,
            1.4674815, 1.8627332, 3.9013562, 5.3570285, 4.7053084, 2.8398862, 1.0851057, 1.0122067,
            2.1739597, 3.9788904, 2.9729002, 1.6663357, 0.9921024, 0.56039816, 1.3762388,
            1.9633126, 1.7672219, 1.2291853, 0.58218855,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.5287654, 0.7151285, 0.38420153, 0.517026, 0.5150141, 0.26934662, 0.7356045,
            0.97902703, 0.6362754, 0.27803296, 0.32063982, 0.83432084, 0.78711736, 0.28247103,
            0.7812688, 0.5270146, 0.4719829, 0.47535485, 0.23715672, 0.4404677, 0.90286416,
            0.66611385, 0.02649495, 0.3193976, 0.16608049, 0.5121102, 0.17436478, 0.313714,
            0.47244504, 0.9906781, 0.9064671, 0.29454133, 0.99321055, 0.12515199, 0.17643407,
            0.16320723, 0.48754972, 0.53866875, 0.6358971, 0.8935865,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.82249755, 0.92702305, 0.10556214, 0.28283548, 0.14977625, 0.53714937, 0.06378802,
            0.4497216, 0.79292244, 0.5300166, 0.687625, 0.4744624, 0.73655206, 0.42605233,
            0.6592577, 0.3237799, 0.42867732, 0.87574345, 0.70010746, 0.01496939, 0.78416556,
            0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122, 0.68573385,
            0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448, 0.48578474,
            0.2764571, 0.9192946, 0.8920509, 0.34320405, 0.4283556, 0.3897719, 0.06360459,
            0.729173, 0.19460331, 0.8634254, 0.6576018, 0.9657459, 0.22873744, 0.47843248,
            0.22157177,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(kernel7, 1, Padding::Valid);
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            1.0748228, 2.0210752, 2.019858, 2.078642, 2.0541008, 1.0842016, 0.35973656, 0.35737422,
            1.4874725, 2.5470176, 2.4701917, 4.3240085, 3.8211813, 2.407897, 1.4741503, 0.8507805,
            1.8698196, 4.1673245, 5.574336, 6.680498, 6.1478553, 4.838703, 3.2205455, 1.5320793,
            2.96277, 4.2414827, 6.9214425, 8.706452, 7.944889, 5.752358, 3.461167, 1.8705927,
            3.6929343, 6.2133827, 8.499721, 11.766299, 10.557781, 7.8828077, 4.7216554, 2.2670197,
            2.3301337, 4.2641764, 6.9666834, 8.776084, 8.503266, 6.738866, 4.7192216, 1.4718803,
            1.9109381, 3.403982, 6.4146104, 7.3478737, 7.008766, 5.113108, 2.623524, 0.9304048,
            1.6132191, 2.3420005, 3.3550618, 4.5514994, 3.655266, 3.2094803, 1.6834911, 0.84157753,
            0.6907263, 1.4867396, 1.9909134, 2.9559002, 2.3442762, 1.3066247, 0.9910673,
            0.22079077,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.9162307, 0.02157675, 0.44649428, 0.2792192, 0.685827, 0.75294507, 0.7919586,
            0.22560763, 0.88778716, 0.80092114, 0.00003577, 0.9737877, 0.9146247, 0.13869576,
            0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946, 0.17754778, 0.41998118,
            0.02919354, 0.82382417, 0.4156855, 0.49590722, 0.69720376, 0.7155315, 0.40795937,
            0.15397236, 0.02265206, 0.7090415, 0.75877124, 0.67035425, 0.39483562, 0.86222315,
            0.9993058, 0.84902793, 0.26427644, 0.86764544, 0.24274233,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.69865257, 0.5739991, 0.7620597, 0.29289714, 0.88402116, 0.8942853, 0.7757528,
            0.16431308, 0.48939565, 0.56055367, 0.46453193, 0.9573795, 0.8899508, 0.16098963,
            0.63514715, 0.810474, 0.29953358, 0.46075395, 0.02808736, 0.59781086, 0.8855644,
            0.61877847, 0.9537467, 0.6197168, 0.3379795, 0.13108306, 0.30692965, 0.33537498,
            0.01351478, 0.45529485, 0.6626128, 0.9497022, 0.7403127, 0.06039312, 0.08292098,
            0.80679554, 0.1354166, 0.2560622, 0.80891573, 0.97702754, 0.4124968, 0.4359102,
            0.8733311, 0.1396195, 0.52047473, 0.88564533, 0.29781443, 0.21130918, 0.83071965,
            0.3337948,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(kernel8, 1, Padding::Valid);
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.69517934, 0.6737217, 1.2803528, 1.0589807, 1.9122999, 0.5264689, 0.85719365,
            0.43609515, 1.6418164, 2.3115768, 3.4333353, 4.05331, 4.015611, 2.1698291, 1.5778288,
            0.57617015, 2.3468146, 4.2253323, 6.015864, 6.16696, 6.129225, 4.109701, 2.7263403,
            1.9500887, 3.2573423, 4.568659, 7.109013, 7.680183, 9.977668, 4.961047, 3.968812,
            2.071727, 4.0387697, 5.860053, 9.831539, 10.102599, 9.189205, 6.974545, 4.3697295,
            2.343017, 3.5946555, 5.8493185, 7.9798665, 9.000931, 8.646035, 5.789946, 3.7938602,
            2.3449905, 2.7483442, 2.9893327, 5.8602257, 6.4833274, 6.091354, 4.8168774, 3.577113,
            1.5084448, 1.9684695, 2.2181706, 4.1254177, 4.229648, 3.741595, 2.497373, 1.924855,
            0.59770596, 0.98641264, 1.1114597, 1.6302938, 2.0725095, 1.311897, 1.2259567, 0.612481,
            0.14103363,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.9783562, 0.42070097, 0.55396014, 0.16172563, 0.7634967, 0.36205766, 0.48491392,
            0.4980414, 0.6001484, 0.65126085, 0.3691911, 0.11615072, 0.26983073, 0.8690525,
            0.7446416, 0.471613, 0.72900707, 0.842964, 0.21457537, 0.938401, 0.41665936,
            0.05351101, 0.43856344, 0.7253113, 0.8520324, 0.4151233, 0.35101932, 0.7388761,
            0.3592986, 0.6741479, 0.9965808, 0.3117034, 0.8605703, 0.94308543, 0.8192489,
            0.31478795, 0.750324, 0.36604244, 0.78454614, 0.039194,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.23696694, 0.2418382, 0.24788351, 0.5622223, 0.15428482, 0.50688076, 0.37682602,
            0.44385925, 0.00051633, 0.53422695, 0.5675659, 0.53845215, 0.2130759, 0.86445093,
            0.432881, 0.6255918, 0.3942565, 0.07226853, 0.09869356, 0.32627374, 0.8543963,
            0.85603166, 0.25422713, 0.24929269, 0.36793318, 0.39957172, 0.9079535, 0.865758,
            0.82237726, 0.60374194, 0.7658025, 0.0215734, 0.473204, 0.6594781, 0.86392707,
            0.8566667, 0.48541847, 0.54855824, 0.5860555, 0.158874, 0.10558709, 0.19664533,
            0.39609066, 0.27843866, 0.49128443, 0.75033015, 0.35650545, 0.4687038, 0.6159849,
            0.2547001,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(kernel9, 1, Padding::Valid);
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 9, 8),
        vec![
            0.39832336, 0.7359849, 1.0600793, 1.9036187, 1.8977017, 1.4373611, 1.037652,
            0.46285266, 1.3363602, 1.8417987, 3.0542974, 3.7712896, 3.8406932, 2.6064231,
            2.3276227, 1.235945, 2.2374911, 2.716241, 4.496823, 6.8854303, 6.1808867, 4.5466166,
            2.9044693, 1.295752, 2.8064437, 4.631966, 6.4363065, 7.9142375, 7.8262954, 5.97042,
            4.1407046, 1.336235, 3.6329176, 6.055794, 8.259712, 10.085062, 9.544321, 6.8034267,
            4.3694086, 1.5618845, 3.5395079, 5.2267, 6.9337854, 7.8645277, 7.647032, 5.680614,
            3.4188535, 1.3518136, 2.0985634, 4.1717367, 5.615197, 5.855365, 5.5251956, 3.789894,
            2.4419634, 0.8430948, 1.4115396, 2.9888868, 3.7743082, 4.145815, 3.7008047, 2.2955093,
            1.3530883, 0.5791296, 1.1858517, 1.8864257, 2.1611142, 2.3243473, 2.1344993, 1.1970835,
            0.5368528, 0.35525158,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.17250927, 0.07203952, 0.8724657, 0.14018923, 0.12091745, 0.4770398, 0.43290496,
            0.6356798, 0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513,
            0.06810815, 0.79673207, 0.29373887, 0.55241185, 0.23906927, 0.18915932, 0.02753429,
            0.1438574, 0.5419741, 0.71984386,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286, 0.21388301,
            0.30016333, 0.49605927, 0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258,
            0.26911622, 0.92149794, 0.7165893, 0.04745785, 0.55642486, 0.34654748, 0.83168656,
            0.8410765, 0.7668131, 0.84094906, 0.6012723, 0.9256995, 0.66010624, 0.43380973,
            0.62281454, 0.45852852, 0.61445725, 0.524579,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(kernel10, 1, Padding::Valid);
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.5284884, 0.21519642, 0.62388366, 0.8208543, 0.20747805, 0.11281832, 1.3276374,
            1.1964138, 2.5360355, 2.1120934, 0.84017336, 0.5593752, 1.5226955, 2.4740155, 3.69295,
            3.7866263, 1.5998048, 1.3212417, 1.7498101, 3.4252782, 5.1644077, 4.617186, 2.4809923,
            1.9575791, 1.2233391, 3.2185202, 4.9025936, 4.449624, 3.0137727, 2.0166142, 0.47807103,
            1.7571783, 3.0770762, 3.2988117, 2.4948807, 1.3682457, 0.15811212, 0.7979012,
            1.4724689, 1.4649091, 1.7400758, 0.8350608,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.06486581, 0.14233574, 0.13930365, 0.5838787, 0.45914945, 0.30819193, 0.70949817,
            0.8803759, 0.6927248, 0.50569826, 0.7358748, 0.58652496, 0.85065925, 0.3247378,
            0.6760192, 0.4483504, 0.59195757, 0.37883574, 0.7796499, 0.32748002, 0.44507304,
            0.7488422, 0.14428215, 0.8785777,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.15468395, 0.6638725, 0.30651525, 0.9492515, 0.55669755, 0.08302987, 0.45890567,
            0.05946975, 0.9099885, 0.30235246, 0.24214035, 0.42138377, 0.38782486, 0.21880285,
            0.9182205, 0.85290706, 0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431, 0.2624427,
            0.6557088, 0.00633, 0.6603214, 0.45500925, 0.6523986, 0.14666249, 0.32440838,
            0.2805719, 0.42671442, 0.74477625,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(kernel11, 1, Padding::Valid);
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.44134566, 0.6782198, 1.2603378, 1.2642683, 0.84507596, 0.5114161, 0.5420016,
            1.3749024, 2.2691178, 2.2520685, 1.6519207, 0.51760566, 1.5500528, 2.4876642, 4.212328,
            3.8197482, 2.5543618, 1.0857865, 2.1539147, 3.3462622, 5.4639554, 5.1749496, 3.635584,
            1.9012951, 1.9795816, 2.8903995, 4.599309, 3.6783276, 3.0441637, 0.9426273, 1.4827422,
            2.0801964, 3.694727, 3.5826983, 2.867222, 1.2983162, 0.43905303, 0.65294915, 1.4978642,
            2.1011336, 1.6485517, 1.1545951,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.9118973, 0.5335283, 0.36968935, 0.5693756, 0.36426732, 0.11819325, 0.95361024,
            0.13343851, 0.5940242, 0.7282295, 0.9320007, 0.46956548, 0.5087874, 0.7952918,
            0.73709416, 0.3358689, 0.03185032, 0.27057356, 0.26166973, 0.5843129, 0.5337139,
            0.19571388, 0.1192536, 0.75616854,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.97167397, 0.71154076, 0.26672947, 0.07128377, 0.3383284, 0.8008563, 0.9504947,
            0.5971434, 0.7847773, 0.92326206, 0.24163638, 0.12968542, 0.5954836, 0.6734995,
            0.08627631, 0.7485715, 0.8782484, 0.6863155, 0.7264353, 0.08944888, 0.68172634,
            0.4284322, 0.48237634, 0.6856524, 0.04009921, 0.0687674, 0.9063645, 0.42620143,
            0.61030614, 0.10040135, 0.50107217, 0.763057,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(kernel12, 1, Padding::Valid);
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            1.3329085, 2.21492, 2.5448484, 1.5994778, 0.7432281, 0.0922851, 1.5035982, 2.6885262,
            3.5371442, 2.85672, 1.8277264, 0.7587757, 2.314054, 3.5732908, 4.767815, 4.0597315,
            2.2557006, 0.70827603, 2.6943445, 5.2863717, 6.4833364, 5.419641, 3.796126, 1.7916012,
            1.6827052, 2.743804, 4.078462, 4.4312983, 2.7857568, 1.3983117, 1.3069038, 2.5265987,
            2.662249, 2.668149, 1.8349531, 1.2350996, 0.5530941, 1.1378845, 1.5416838, 1.2268095,
            1.2080739, 0.92850304,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.25769317, 0.8816114, 0.7770131, 0.23345616, 0.62762326, 0.15315741, 0.73589575,
            0.2752067, 0.85641515, 0.7439484, 0.6581306, 0.4056261, 0.13899311, 0.26460668,
            0.9179794, 0.96651816, 0.89336777, 0.18948041, 0.9371178, 0.7124811, 0.9657549,
            0.6203675, 0.32684848, 0.11439406,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.07654371, 0.95680344, 0.9728639, 0.6055871, 0.00439729, 0.8525613, 0.3167563,
            0.13499211, 0.68338645, 0.7955047, 0.21689218, 0.2826704, 0.12328367, 0.6890043,
            0.5906649, 0.41700745, 0.30266365, 0.5716598,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(kernel13, 1, Padding::Valid);
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.13029447, 0.5546859, 1.980642, 1.8750359, 1.0154136, 0.9599306, 1.855135, 2.52877,
            2.594589, 1.4072315, 1.2019308, 3.118842, 4.8204026, 3.8284924, 2.4044335, 1.5886242,
            2.955553, 5.2271914, 3.4878566, 1.9405229, 1.1508915, 1.6368128, 3.4539382, 1.8380338,
            1.5507355, 0.49434823, 0.63295513, 1.2269988, 0.7259829, 0.34259385,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.12726787, 0.35587692, 0.16889893, 0.3114892, 0.1309899, 0.24026695, 0.55435276,
            0.34375766, 0.4225387, 0.37165096, 0.6202945, 0.6069533, 0.05756181, 0.0153275,
            0.8497578, 0.79796964, 0.4071996, 0.19325097, 0.04944435, 0.59729165, 0.39304134,
            0.679002, 0.6126854, 0.67232877,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.7156292, 0.09058711, 0.33372015, 0.8941644, 0.30899736, 0.3348802, 0.6412177,
            0.26750943, 0.03709449, 0.56803024, 0.8756273, 0.5771133, 0.56024176, 0.5868575,
            0.75167763, 0.36936092, 0.37185487, 0.35425207,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(kernel14, 1, Padding::Valid);
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.12377346, 0.32531393, 0.7249077, 0.8869802, 0.54677147, 0.8222286, 1.4518883,
            2.0465453, 1.1512687, 0.88701445, 1.2532429, 1.8779013, 3.1481762, 1.7592589,
            0.9008558, 1.6695124, 2.8769097, 3.9085302, 2.4148417, 1.1048748, 1.0864459, 2.0189342,
            2.873717, 1.7339051, 0.8635407, 0.48910597, 0.9759562, 1.28561, 0.65242904, 0.26068848,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.24336162, 0.01027582, 0.2671537, 0.83992416, 0.49819484, 0.7831867, 0.70054483,
            0.8701863, 0.49413827, 0.84670645, 0.8069649, 0.093459, 0.93408287, 0.8206956,
            0.70209366, 0.32817394, 0.744203, 0.39091238, 0.43911496, 0.92919487, 0.29325068,
            0.62813336, 0.8131431, 0.19520658,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.47931832, 0.42483747, 0.47526902, 0.28184402, 0.09741595, 0.45691565, 0.44086096,
            0.9638409, 0.33859608, 0.26381832, 0.29839757, 0.68755937, 0.09156765, 0.58584654,
            0.04617033, 0.14705709, 0.81179595, 0.16751295,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(kernel15, 1, Padding::Valid);
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.36307585, 0.6035571, 1.3204355, 0.89216065, 0.609701, 0.6432911, 1.5388677, 2.312785,
            1.6777657, 0.79548246, 0.96306044, 2.691589, 3.8720548, 2.8855925, 1.0204417,
            1.2277582, 3.2093387, 4.4781313, 3.0665624, 0.74862003, 0.66957366, 2.3043296,
            3.1798463, 1.6943476, 0.26815218, 0.46565127, 1.8013442, 1.899713, 0.6579946,
            0.06434448,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.06864621, 0.6308731, 0.38993102, 0.3644169, 0.68174505, 0.272409, 0.23609333,
            0.21866773, 0.80119157, 0.01742986, 0.49270406, 0.37920174, 0.90869635, 0.8191268,
            0.7636344, 0.7827788, 0.9694966, 0.79533535, 0.00732174, 0.8372113, 0.9449071,
            0.7670253, 0.50964797, 0.7843069,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.7365313, 0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833,
            0.5585159, 0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028,
            0.52249014, 0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726,
            0.25884646, 0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234,
            0.32747796, 0.9097073, 0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446,
            0.9843364, 0.4038572, 0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686,
            0.5288406, 0.92906404, 0.87780553, 0.9090181, 0.82569945, 0.20383635, 0.7166643,
            0.17061436,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(kernel16, 1, Padding::Valid);
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.89422953, 1.7001375, 2.1010332, 1.7541044, 2.2351935, 1.4734894, 0.7602386,
            1.7378807, 3.297077, 3.8373866, 3.3379266, 3.6651232, 2.6279008, 1.0849056, 2.0313237,
            4.0049453, 5.8351912, 5.2136006, 5.52735, 4.6594076, 1.9894286, 2.767497, 5.09015,
            7.6584835, 6.3204126, 8.120188, 6.0912404, 2.928585, 2.5016224, 5.4453883, 7.072837,
            6.5233755, 7.16344, 6.2558813, 2.667637, 1.8661498, 4.09828, 5.8073745, 4.8841915,
            5.4443474, 4.6148067, 2.4382741, 0.94117236, 1.8929582, 4.0150204, 2.8455844,
            3.4725115, 2.8479173, 1.6735775, 0.7098303, 1.4570267, 1.7054721, 1.7988372, 1.1493273,
            1.1335591, 0.40101156,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.91526777, 0.08598401, 0.70100874, 0.40537685, 0.5971982, 0.92796123, 0.15859716,
            0.7859081, 0.8564488, 0.35816404, 0.79062706, 0.9644883, 0.13154314, 0.31929043,
            0.80048305, 0.07180241, 0.52815664, 0.45786336, 0.91537887, 0.9783313, 0.25753945,
            0.42799363, 0.07738555, 0.9294206,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.07022415, 0.60058224, 0.6196278, 0.9008346, 0.04155485, 0.82207745, 0.41282526,
            0.9949608, 0.3109271, 0.47614527, 0.7615821, 0.35893062, 0.07713356, 0.6123928,
            0.62511915, 0.88098776, 0.21521498, 0.89468116, 0.1842307, 0.10784956, 0.8354833,
            0.2630701, 0.7184675, 0.06132602, 0.06056971, 0.71349823, 0.00944792, 0.07349233,
            0.35231608, 0.8533961, 0.17608605, 0.18067755, 0.51991457, 0.19053963, 0.5045173,
            0.7456122, 0.27621788, 0.48649722, 0.39297876, 0.54849166, 0.3746991, 0.8194284,
            0.34880427, 0.79505837, 0.41293454, 0.890512, 0.12076204, 0.20799449, 0.88948244,
            0.24437675,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(kernel17, 1, Padding::Valid);
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.1581297, 0.7847877, 1.2518208, 1.3761694, 0.83343464, 1.1895702, 0.7122594,
            0.85528207, 1.1914378, 2.8014355, 2.356197, 3.1142137, 2.0453103, 1.1669396, 1.8052847,
            2.2897964, 3.9011714, 4.262249, 5.3328676, 3.6291473, 1.8054893, 1.8399823, 2.8932042,
            6.881122, 5.7788033, 6.2292, 4.79626, 2.6083415, 2.4389727, 4.0094695, 7.71273,
            4.9654436, 6.388458, 4.201786, 2.1320133, 1.4772289, 3.8343701, 5.9616385, 4.212865,
            4.9840336, 2.9732702, 1.4795116, 1.4235681, 2.8334155, 3.4753764, 3.9582658, 3.4302464,
            1.602139, 0.602621, 0.68037355, 0.8753761, 2.1971593, 1.35276, 1.1298724, 0.9526508,
            0.28554755,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.7731474, 0.65954226, 0.4922565, 0.5211581, 0.97382414, 0.9779564, 0.1754263,
            0.4551989, 0.81067127, 0.7095975, 0.5087082, 0.78796804, 0.03310984, 0.20805901,
            0.45704818, 0.9133983, 0.5689028, 0.04247752, 0.55938286, 0.9835293, 0.04525762,
            0.7176199, 0.82096803, 0.5575717,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.5744108, 0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355, 0.1134909,
            0.5645703, 0.30096474, 0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894,
            0.681929, 0.24701218, 0.74485576, 0.61556435, 0.63869125, 0.05875124, 0.3210932,
            0.96946657, 0.09463912, 0.6275637, 0.34162354, 0.74390864, 0.8736778, 0.9513908,
            0.24045336, 0.7003475, 0.87750345, 0.16564246, 0.6314963, 0.21785556, 0.7654987,
            0.13988015, 0.03287261, 0.82226163, 0.60896695, 0.13331373, 0.62307173, 0.23316076,
            0.9600204, 0.55291533, 0.29808274, 0.8765127, 0.98263544, 0.27148733, 0.11101003,
            0.2754741,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(kernel18, 1, Padding::Valid);
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.46873492, 1.3187438, 1.7483418, 1.5717082, 1.5776644, 0.9995207, 0.7531583,
            1.1233468, 2.6646183, 4.13327, 3.1395922, 3.0896602, 2.2677326, 1.4416535, 1.841797,
            3.6009212, 5.10239, 5.1561613, 5.019273, 3.6456628, 1.574677, 2.0950973, 5.2711406,
            7.814619, 8.272186, 7.1920924, 4.8045526, 2.2881987, 1.8890871, 3.9393947, 6.9372544,
            7.9038367, 6.4218135, 3.8110056, 1.6726841, 1.8648888, 4.2587047, 5.6323085, 6.623008,
            5.1868095, 3.378073, 1.018583, 1.1690423, 3.0610242, 4.114298, 3.980886, 2.7526395,
            2.0263774, 0.5019083, 0.8568499, 2.2760215, 2.3035982, 2.1078053, 1.0764296, 0.9563383,
            0.422785,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969,
            0.5836321, 0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643,
            0.91682273, 0.6142979, 0.19277428, 0.28408903, 0.25507236, 0.9800453, 0.36125833,
            0.96792, 0.33258557, 0.9508625, 0.8424581, 0.8130291, 0.7774976, 0.17691322, 0.9389267,
            0.22419459, 0.33442205, 0.7614585, 0.37563834, 0.70754576, 0.1499497, 0.9873837,
            0.7166968, 0.40278858, 0.22288306, 0.3279577, 0.07722609, 0.598755, 0.8143903,
            0.87905455, 0.83061284, 0.9923988, 0.6196494, 0.536406, 0.06662867, 0.83588266,
            0.28182983, 0.662181, 0.99850965, 0.60448396, 0.12318801, 0.91713256, 0.8540598,
            0.19103892, 0.5929614, 0.9118344, 0.9381113, 0.3421722, 0.8149188, 0.9595595,
            0.02717085, 0.8916309, 0.9755575, 0.27588442, 0.59208006, 0.00008138, 0.9552037,
            0.12578069,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.01249961, 0.05413999, 0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439,
            0.34315115, 0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794,
            0.6930413, 0.90735817, 0.91156703, 0.45996496, 0.9045769, 0.17170428, 0.43418503,
            0.69308424, 0.42869946, 0.9244341, 0.41451567, 0.6224708, 0.00536506, 0.33826837,
            0.47926104, 0.0032256, 0.02230139, 0.35960108,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(kernel19, 1, Padding::Valid);
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.6589925, 0.7238686, 1.2824643, 1.189525, 0.6800282, 1.5162439, 1.3340378, 1.2708699,
            0.3540583, 1.4508398, 2.3299847, 3.3135967, 4.9865465, 4.6640787, 5.094415, 4.1656876,
            2.334754, 0.97400606, 1.1149118, 3.408052, 3.8919933, 7.1374674, 7.9297795, 8.235734,
            7.2041416, 3.7964435, 1.5456476, 1.569778, 4.027313, 5.8724265, 8.931633, 10.533197,
            10.002502, 8.385851, 5.708188, 2.3999405, 1.87866, 4.215269, 7.4605055, 10.059592,
            10.9128065, 11.045897, 7.0094576, 5.270068, 2.3081238, 2.5110795, 5.000003, 8.261803,
            9.824825, 10.498115, 9.07532, 7.5271516, 3.940207, 2.9114282, 1.8064483, 4.8479376,
            6.1160684, 8.607414, 7.849432, 8.03902, 5.702817, 4.088083, 2.1380467, 1.7011273,
            2.9533575, 3.8373759, 5.3618884, 4.40716, 5.1122065, 2.859549, 2.4570699, 1.4063358,
            0.7344123, 1.0588589, 1.557113, 2.1094732, 2.309374, 2.0370216, 1.7002198, 1.1666532,
            0.94114155,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.48593593, 0.86064774, 0.28908366, 0.4153976, 0.3468706, 0.2242362, 0.93169004,
            0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496, 0.11111139, 0.19382912,
            0.9307082, 0.9188555, 0.10532705, 0.88550454, 0.20754221, 0.97926295, 0.3472928,
            0.71126235, 0.03633394, 0.7482733, 0.28782296, 0.7382309, 0.60003114, 0.3259743,
            0.85578996, 0.14142898, 0.39191914, 0.05517358, 0.6050927, 0.968827, 0.47373444,
            0.76571184, 0.50472075, 0.53850234, 0.05837096, 0.56728834, 0.3979838, 0.2393961,
            0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945, 0.66457146, 0.8425775,
            0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123, 0.48163053, 0.437191,
            0.43973154, 0.29997745, 0.21913478, 0.6611514, 0.209788, 0.176356, 0.88925517,
            0.14793599, 0.36509594, 0.5616029, 0.6617385, 0.30053073, 0.36820948, 0.62227124,
            0.4957459, 0.69923055,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.3227648, 0.9702412, 0.5679234, 0.13432135, 0.7430913, 0.19231908, 0.26170298,
            0.10480803, 0.00958306, 0.20726651, 0.20851518, 0.17973869, 0.23704103, 0.1163867,
            0.2735905, 0.8537909, 0.40303, 0.75797635, 0.34342998, 0.74670875, 0.82946825,
            0.91931367, 0.9654975, 0.18782942, 0.10021565, 0.05109123, 0.3069365, 0.10895161,
            0.9891213, 0.62504834, 0.507994, 0.47125,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(kernel20, 1, Padding::Valid);
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.36026064, 1.3488609, 1.8093499, 1.8033055, 1.8073156, 1.3202239, 1.2120912,
            0.5533349, 0.20887887, 1.2275975, 2.9342217, 2.807355, 3.4241726, 3.2264943, 4.0301642,
            3.455145, 1.9254148, 0.6830142, 1.4258332, 1.9372594, 3.2299933, 4.750205, 5.6083083,
            5.9591966, 4.577907, 2.6268234, 0.82090753, 1.7024875, 3.6806738, 5.7457786, 7.106648,
            6.677708, 6.3681197, 5.14675, 3.0292623, 1.3272406, 1.3986263, 2.8604047, 4.6854563,
            6.6791105, 5.915898, 7.5196, 4.7611303, 3.6133113, 1.9263418, 1.6910946, 3.095683,
            4.9493146, 6.516703, 7.580612, 7.385207, 5.8529425, 3.212092, 1.9719241, 1.389492,
            2.0588791, 3.3706748, 4.3060837, 4.6237397, 5.077791, 3.4045691, 2.0885942, 1.2486331,
            0.34580398, 0.6597423, 1.7576032, 1.9475852, 2.592357, 2.7553375, 1.8224282, 1.7401443,
            0.59921646, 0.7474406, 0.7695725, 1.1452879, 1.9599509, 1.6456832, 2.5094438,
            2.0280378, 1.2027868, 0.9832702,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.84314245, 0.6054993, 0.92367506, 0.6953895, 0.37023902, 0.67128026, 0.43450755,
            0.28869846, 0.27641538, 0.8369712, 0.6856483, 0.26890948, 0.65425915, 0.84581685,
            0.51146317, 0.48995435, 0.52071315, 0.80564773, 0.670521, 0.3835857, 0.47078377,
            0.5100531, 0.82525116, 0.02126783, 0.9583153, 0.23316967, 0.9487504, 0.9609589,
            0.95734006, 0.00943314, 0.7521432, 0.46106157, 0.84370506, 0.16933449, 0.71423984,
            0.5316646, 0.6400151, 0.9638914, 0.69432026, 0.8581641, 0.70813745, 0.2836983,
            0.33953485, 0.8950543, 0.20262088, 0.81930757, 0.09556881, 0.22266188, 0.63842744,
            0.8304186, 0.12425002, 0.7582065, 0.09737789, 0.84872884, 0.17490041, 0.37569723,
            0.6669188, 0.8970669, 0.22398192, 0.29424527, 0.56277037, 0.41113177, 0.7882464,
            0.24159203, 0.5460915, 0.29690132, 0.3142075, 0.7648111, 0.04421633, 0.9636684,
            0.98529965, 0.26998708,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.13811645, 0.9724998, 0.41856614, 0.13321315, 0.0937838, 0.4742414, 0.79873264,
            0.1621314, 0.5493846, 0.6481355, 0.05176858, 0.17029643, 0.955536, 0.089831,
            0.05664136, 0.9231865, 0.98567015, 0.01680515, 0.54690886, 0.8593988, 0.6496963,
            0.8382851, 0.2400014, 0.36792266, 0.01756373, 0.6596718, 0.5680892, 0.19350345,
            0.4854058, 0.7869872, 0.12335967, 0.14544043,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(kernel21, 1, Padding::Valid);
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.7472957, 1.8644197, 2.1199327, 3.2948015, 3.1151905, 2.2244532, 2.0299838, 1.0940255,
            0.33323333, 0.8895706, 2.9697576, 3.361202, 4.8854046, 4.951982, 4.1174603, 2.8704479,
            1.3326299, 0.44039226, 1.4554377, 3.999865, 5.081147, 6.6111765, 5.5856943, 5.7062483,
            4.435905, 1.7649939, 1.1314536, 2.1021423, 4.848426, 6.6874475, 8.315708, 7.728256,
            7.819539, 5.0943737, 2.2331762, 1.4484528, 1.8142341, 4.4645658, 6.33744, 7.628584,
            8.141168, 6.6504383, 4.967912, 2.38794, 0.9501895, 2.175603, 5.3092895, 5.3600726,
            8.03063, 8.637991, 7.5354223, 5.586621, 2.7443793, 1.3413793, 1.5366509, 3.034684,
            4.133793, 6.2558265, 6.7366076, 4.486489, 3.3487856, 2.2375662, 0.30702108, 1.6076113,
            1.9128449, 3.2424743, 4.104741, 3.332795, 3.8618271, 2.6130943, 1.4935789, 0.19467402,
            0.8712181, 1.1266477, 1.5523305, 1.6006929, 2.5244818, 2.3924541, 0.71872175,
            0.86609864, 0.53009266,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.25711668, 0.05608724, 0.18204254, 0.9562488, 0.44598028, 0.3229758, 0.8930679,
            0.24216229, 0.21437034, 0.38366762, 0.64894366, 0.8650639, 0.7790032, 0.3529938,
            0.37360683, 0.26240814, 0.554433, 0.90017563, 0.6817857, 0.95833224, 0.28551313,
            0.85106283, 0.70093375, 0.4791875, 0.5805011, 0.9803199, 0.97033703, 0.48236644,
            0.66855663, 0.35855147, 0.25242767, 0.6717967, 0.26290378, 0.53677225, 0.18097793,
            0.07985484, 0.79416144, 0.7215235, 0.42313012, 0.6529702, 0.00384528, 0.08442257,
            0.7838985, 0.980683, 0.36212954, 0.61172485, 0.5263662, 0.8496614, 0.13177402,
            0.9175598, 0.04323238, 0.03087392, 0.03482862, 0.36226457, 0.6059544, 0.29194582,
            0.34645593, 0.9409913, 0.60953087, 0.8610255, 0.1627552, 0.8939359, 0.66327935,
            0.48094535, 0.06551108, 0.86129206, 0.65446067, 0.9592776, 0.8000413, 0.21450381,
            0.6442533, 0.46971878,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.84573215, 0.34651902, 0.18830031, 0.57119006, 0.27269888, 0.7915957, 0.21737069,
            0.04463017, 0.393406, 0.8441482, 0.77705365, 0.6315176, 0.8522896, 0.16809769,
            0.22305161, 0.773223, 0.9678148, 0.2237789,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(kernel22, 1, Padding::Valid);
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.8878418, 1.3627094, 1.6411836, 2.218026, 1.5206699, 1.0943689, 0.26392472,
            0.11413078, 2.2407408, 2.8018382, 2.9780219, 3.2902868, 2.7375433, 3.8226047,
            1.8707596, 0.9739648, 2.6182384, 4.145053, 4.307871, 3.641167, 2.928937, 3.9605067,
            2.0020893, 1.4185315, 2.445647, 4.591738, 4.564003, 4.2476845, 4.4571004, 5.4689445,
            3.339065, 1.9578203, 1.8054391, 3.9438295, 5.424985, 5.146288, 3.7222848, 4.536544,
            2.5436902, 1.618014, 1.852977, 4.532389, 5.428803, 5.8200436, 4.9326925, 4.821739,
            2.8868513, 1.1688073, 0.95400417, 2.4678853, 3.4197805, 3.1890326, 2.4345999,
            2.2108917, 1.5149457, 0.50177956, 0.5609144, 1.5324271, 1.8799044, 1.547518, 1.0515072,
            1.2713213, 0.67353284, 0.13652852,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.8982615, 0.271913, 0.34780893, 0.49277794, 0.14560463, 0.33638617, 0.1585067,
            0.18610527, 0.6963084, 0.9429821, 0.40789625, 0.20056698, 0.37306353, 0.9367061,
            0.7103306, 0.06833509, 0.48335183, 0.45182207, 0.96346164, 0.00378525, 0.33689302,
            0.28288215, 0.75004077, 0.1607512, 0.514175, 0.35879079, 0.36688787, 0.00774159,
            0.15532039, 0.01133456, 0.94680935, 0.052598, 0.73530346, 0.8096563, 0.7097644,
            0.37942106, 0.38656324, 0.13763146, 0.99930644, 0.67476803, 0.06055127, 0.8463604,
            0.4460729, 0.33209085, 0.94373864, 0.5397614, 0.05766413, 0.64256257, 0.7357459,
            0.09256811, 0.8832945, 0.03911254, 0.782554, 0.4004812, 0.80732703, 0.8010379,
            0.28867772, 0.7802926, 0.9490529, 0.5395702, 0.1369102, 0.4513485, 0.1162144,
            0.9589836, 0.24819064, 0.3149064, 0.22322156, 0.39812055, 0.45308354, 0.5711523,
            0.97817534, 0.06805564,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.5386646, 0.6699801, 0.1879456, 0.8407316, 0.64728755, 0.53731096, 0.63207716,
            0.00916763, 0.46754488, 0.8670982, 0.1932068, 0.43971533, 0.10441232, 0.46486124,
            0.22910197, 0.7679019, 0.23872072, 0.03931138,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(kernel23, 1, Padding::Valid);
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.81904995, 0.94231385, 1.601419, 1.3882536, 1.0962367, 1.4136493, 0.4428857,
            0.43537992, 1.2677298, 1.5846925, 2.816123, 3.1578827, 2.728833, 2.27714, 1.0638275,
            0.6948871, 1.8833703, 1.8561058, 4.79151, 4.0526094, 3.8207805, 3.3878465, 1.7515221,
            0.70654213, 2.0522106, 3.3593676, 4.1703916, 4.2621, 3.694259, 3.8804107, 2.036059,
            0.72102386, 2.0907755, 2.8835342, 3.5349615, 2.959169, 3.4152977, 3.1210742, 1.5385709,
            0.57758, 2.379076, 2.6153195, 3.3555698, 3.274085, 4.612377, 2.725724, 1.6431766,
            0.27584115, 1.2494515, 1.4131862, 2.122449, 2.5042832, 2.681197, 2.1570961, 1.0403515,
            0.23713759, 0.7698688, 0.40093112, 1.359665, 1.1054982, 1.7051358, 0.9331045,
            0.39002484, 0.18007173,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.8551502, 0.19610135, 0.8555064, 0.08035298, 0.05671094, 0.9091975, 0.27582648,
            0.33816597, 0.42012835, 0.7745094, 0.14011143, 0.47505257, 0.98297566, 0.5085966,
            0.22395916, 0.01153891, 0.669607, 0.12918296, 0.55476546, 0.528783, 0.5067741,
            0.14234911, 0.5152856, 0.6446142, 0.9118427, 0.8193508, 0.989135, 0.7842302,
            0.59264964, 0.35247177, 0.48483032, 0.22649786, 0.04158387, 0.5814206, 0.8653732,
            0.4524277, 0.44947338, 0.5519129, 0.79122764, 0.7513198, 0.9315116, 0.03313805,
            0.41213843, 0.45310238, 0.01799934, 0.4328227, 0.23842481, 0.20688592, 0.57869387,
            0.9324833, 0.43915927, 0.53123087, 0.5324186, 0.4149537, 0.22217223, 0.0080786,
            0.65063345, 0.7681623, 0.8421627, 0.27179125, 0.68530315, 0.9955617, 0.77906156,
            0.18006648, 0.5975193, 0.6555531, 0.9498266, 0.9690994, 0.5122471, 0.3840358,
            0.8757204, 0.7260429,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.04691354, 0.40678895, 0.35535267, 0.19270384, 0.23519029, 0.6665529, 0.26402712,
            0.55168146, 0.08576613, 0.9567203, 0.57141143, 0.20602623, 0.75538653, 0.96776,
            0.44755465, 0.82362133, 0.29203537, 0.30861592,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(kernel24, 1, Padding::Valid);
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.47013843, 1.141926, 1.5887427, 1.7060933, 1.8228761, 0.8130485, 0.6008552,
            0.32991305, 0.91155803, 1.887863, 2.7302763, 2.7728028, 3.3349957, 2.2827213,
            1.1109811, 0.83229446, 1.5602185, 3.6270537, 3.9787736, 3.7744946, 3.4788055,
            3.1241264, 1.9529498, 0.62884253, 1.277415, 2.7137744, 4.015492, 4.1134634, 3.8633602,
            3.0892286, 2.2988095, 0.66147494, 1.7093093, 3.8205013, 4.5863104, 4.289265, 4.6062365,
            4.312116, 2.4008825, 0.95076466, 1.9543068, 3.9825423, 5.43557, 4.4375796, 4.763735,
            4.911616, 3.2057102, 0.97785735, 1.6160964, 3.5483994, 4.0696187, 2.9984317, 3.0527446,
            3.5033388, 2.398922, 0.8590551, 0.9103058, 1.4028274, 1.1755564, 0.96085155, 1.5443091,
            1.618975, 0.80610716, 0.26287138,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.39762703, 0.26186082, 0.9658112, 0.27424002, 0.50570756, 0.8114843, 0.5536027,
            0.59788686, 0.05054026, 0.28394443, 0.6402348, 0.02258505, 0.60607, 0.6834324,
            0.8004999, 0.3349493, 0.4295082, 0.37033585, 0.0394791, 0.50698835, 0.29841292,
            0.9388161, 0.84357476, 0.29760668, 0.25654384, 0.71037215, 0.14646496, 0.9906275,
            0.9552909, 0.7966291, 0.6094893, 0.7271988, 0.09518696, 0.3957746, 0.6157527,
            0.31079137, 0.46793708, 0.8514491, 0.86081386, 0.8208274, 0.2372746, 0.6977758,
            0.79387194, 0.9463199, 0.99063903, 0.29514915, 0.8795419, 0.741553, 0.03520088,
            0.83411527, 0.47134155, 0.26704508, 0.2872401, 0.04289522, 0.583651, 0.94414073,
            0.5729697, 0.72244126, 0.7707775, 0.02079507, 0.22973806, 0.18128674, 0.05054512,
            0.6523751, 0.27093726, 0.32479268, 0.53774405, 0.08921466, 0.18494032, 0.78120434,
            0.15868789, 0.81183356,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.21792394, 0.6620494, 0.6886836, 0.39724785, 0.59319293, 0.02472531, 0.21891202,
            0.5342134, 0.4041879, 0.53426075, 0.20461221, 0.29362342, 0.7835011, 0.47930118,
            0.2895624, 0.7320774, 0.55179524, 0.37774232, 0.04187773, 0.23883641, 0.63051957,
            0.97746944, 0.6415133, 0.4162999, 0.04763152, 0.75958186, 0.13098118, 0.6238241,
            0.4102024, 0.5710282, 0.59153587, 0.66274744, 0.6454271, 0.8120847, 0.22876394,
            0.6206928, 0.19057496, 0.4622738, 0.9772445, 0.17967562, 0.27354005, 0.48198408,
            0.09082693, 0.6217685, 0.0965838, 0.8904992, 0.5337058, 0.17222154, 0.62424076,
            0.95776683,
        ],
    )
    .unwrap();
    let conv_layer25 = TransposedConvolutionLayer::new(kernel25, 1, Padding::Valid);
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.44208896, 1.0283507, 1.7149702, 2.4968135, 2.7380085, 3.151968, 2.6350365, 1.92376,
            1.0440624, 0.87981635, 1.010287, 2.2269025, 3.828899, 4.501359, 6.0396614, 5.6095843,
            4.484947, 3.0454955, 2.4142895, 1.030015, 1.0139114, 3.1982641, 5.1858997, 7.021474,
            8.154041, 8.010985, 5.971649, 4.2638884, 2.9980159, 0.7862305, 1.5128598, 3.4896402,
            6.170319, 8.299019, 10.375965, 9.555091, 7.352769, 5.056609, 3.2374516, 0.7970661,
            2.0123417, 5.247559, 7.4690804, 10.386487, 12.3805895, 13.219763, 9.804331, 7.4942036,
            4.05529, 1.7206945, 2.563189, 5.110368, 7.2718916, 8.969924, 11.405497, 12.054579,
            9.087503, 7.133023, 4.133883, 2.0416632, 1.1302924, 3.6549587, 5.224881, 7.699438,
            8.241358, 8.799864, 6.941946, 5.1565995, 2.9525232, 0.77260405, 1.2537684, 2.818046,
            3.6327806, 6.206316, 7.4517727, 7.4697456, 5.6649437, 3.9259386, 2.5540476, 0.49158624,
            0.95962536, 2.1349826, 1.9762316, 3.4006002, 4.329181, 4.3053083, 3.8392332, 2.291376,
            1.5195608, 0.50165856, 0.8631556, 1.420713, 1.466742, 2.208236, 2.3287492, 2.2690623,
            1.9934965, 1.4616523, 0.8174772, 0.7923507,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.transposed_convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.998361, 0.150883, 0.28713444, 0.35105017, 0.1765902, 0.9674033, 0.65025777,
            0.1959308, 0.3119046, 0.55247456, 0.38556734, 0.18145509, 0.94255227, 0.7036003,
            0.3402552, 0.16401337, 0.28418577, 0.5504918, 0.6148071, 0.7740251, 0.37459207,
            0.25677747, 0.80441076, 0.17314304, 0.5946227, 0.30094627, 0.06480476, 0.5798754,
            0.62549657, 0.6065069, 0.9259787, 0.3677915, 0.69532603, 0.8356569, 0.39276573,
            0.18570696, 0.61698794, 0.9064707, 0.01547038, 0.2551995, 0.11438051, 0.03861368,
            0.6524532, 0.36442748, 0.08230381, 0.79969245, 0.27816203, 0.3741886, 0.44356522,
            0.27386904, 0.4171807, 0.14990133, 0.4750283, 0.6358263, 0.77572674, 0.7072159,
            0.34310365, 0.36999545, 0.8200852, 0.46510443, 0.9230857, 0.86201537, 0.04691705,
            0.12260284, 0.89921826, 0.47400048, 0.7492544, 0.05440097, 0.28273952, 0.9184355,
            0.9064988, 0.7027802,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.19125043, 0.8670149, 0.08634489, 0.722654, 0.77540857, 0.00211577, 0.6443405,
            0.2344423, 0.9849179, 0.9893316, 0.87634915, 0.48734385, 0.8760625, 0.53053117,
            0.01152504, 0.6788874, 0.76156837, 0.4680538, 0.07214947, 0.549209, 0.8383253,
            0.00365476, 0.9782156, 0.7419056, 0.40790308, 0.00302504, 0.80174476, 0.7689671,
            0.50054824, 0.16478458, 0.89107823, 0.7763043, 0.73042727, 0.41667554, 0.7348974,
            0.71259016, 0.93557405, 0.37013116, 0.14954911, 0.33766475, 0.39673004, 0.03940821,
            0.2414454, 0.9373305, 0.84819096, 0.9272432, 0.8604789, 0.92845494, 0.8023847,
            0.06647868,
        ],
    )
    .unwrap();
    let conv_layer26 = TransposedConvolutionLayer::new(kernel26, 1, Padding::Valid);
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.19280338, 1.3918593, 1.4731841, 2.0696397, 2.0183547, 1.1381056, 1.579537,
            0.61234987, 0.87420356, 0.7564957, 0.67823255, 3.0557687, 2.5798478, 3.901178,
            4.7933526, 3.3467827, 3.2852569, 2.2928839, 1.8909042, 1.1878221, 2.0789404, 4.4008145,
            4.717831, 5.7724004, 6.283013, 6.157115, 4.787968, 4.140077, 2.4948921, 1.0103277,
            2.4745111, 5.1077476, 6.0912967, 7.779299, 10.342147, 9.410012, 6.6771812, 4.779567,
            3.1047766, 1.9152846, 4.060482, 6.932132, 9.430189, 10.882794, 11.9354925, 11.147186,
            8.352124, 7.6316657, 5.2622623, 2.0967531, 4.0606937, 7.937773, 8.693852, 10.481528,
            13.567764, 12.521215, 10.75472, 7.6442814, 5.267348, 2.307758, 3.7750795, 5.7926974,
            6.9299297, 9.103963, 12.286992, 11.744349, 8.74672, 7.3169217, 4.885914, 1.6236455,
            3.3499854, 4.523241, 5.5216455, 8.033759, 10.529274, 8.362243, 5.9465265, 4.780645,
            2.9928226, 1.0761315, 2.2802992, 2.854052, 3.7601628, 5.3437285, 5.705783, 4.586808,
            4.529674, 4.8362336, 2.801953, 0.9769907, 1.4710125, 1.0068736, 2.4946885, 3.4964652,
            3.6498847, 4.1553397, 3.490598, 2.2548404, 0.92215025, 0.12247033,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.transposed_convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.12827316, 0.02774826, 0.8982795, 0.1193029, 0.37523487, 0.28379655, 0.0638791,
            0.08446726, 0.68760884, 0.2630593, 0.01052708, 0.45302406, 0.10402057, 0.5539082,
            0.39986408, 0.53770447, 0.24856173, 0.12796782, 0.80071914, 0.38390577, 0.6908975,
            0.5850918, 0.71101063, 0.17578217, 0.55867785, 0.71616316, 0.3247584, 0.9196999,
            0.46712968, 0.08430128, 0.83232373, 0.49657014, 0.24024557, 0.60874844, 0.47418702,
            0.9770886, 0.99522823, 0.7749884, 0.7253688, 0.26021662, 0.8869578, 0.5181486,
            0.5871326, 0.76900613, 0.5745777, 0.81429285, 0.78002185, 0.7069771, 0.33134556,
            0.7407027, 0.58577555, 0.40479863, 0.7506117, 0.11343616, 0.8795398, 0.83064,
            0.8858372, 0.3898591, 0.9350765, 0.9673369, 0.64465624, 0.0283905, 0.22112074,
            0.1391855, 0.34128338, 0.65248054, 0.291874, 0.70765275, 0.32796225, 0.22921298,
            0.59572685, 0.5726663,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.72872376, 0.8248998, 0.29288608, 0.92347336, 0.25887516, 0.91578674, 0.800785,
            0.7670362, 0.8990461, 0.8424308, 0.7045559, 0.43518323, 0.48451254, 0.31151697,
            0.10086012, 0.5242353, 0.19001916, 0.01069371, 0.01020448, 0.12606935, 0.04778918,
            0.8456499, 0.57045126, 0.46361542, 0.7532553, 0.62787765, 0.3127784, 0.9686197,
            0.96754897, 0.5766132, 0.6463905, 0.6347338, 0.52757853, 0.55145216, 0.08155768,
            0.13378453, 0.2262157, 0.73179847, 0.5428326, 0.9094368, 0.2528448, 0.24383228,
            0.7446406, 0.5544842, 0.01949351, 0.13375893, 0.04438103, 0.8489, 0.6848837, 0.9220802,
        ],
    )
    .unwrap();
    let conv_layer27 = TransposedConvolutionLayer::new(kernel27, 1, Padding::Valid);
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (1, 10, 10),
        vec![
            0.71835726, 0.9239171, 2.3768969, 3.0583782, 3.3583794, 3.3915076, 2.3779402,
            1.9706323, 1.3719833, 0.3722392, 1.1759746, 2.041512, 4.188551, 5.398079, 5.7951064,
            6.5299406, 5.2721233, 3.5587804, 2.4842145, 0.8062669, 0.94538504, 2.46061, 5.3225875,
            6.8243623, 8.8341255, 7.9987135, 6.8134766, 4.287591, 2.8088813, 1.0376844, 1.8876251,
            3.8171272, 7.4594345, 9.835806, 11.350726, 10.682975, 8.187626, 7.0427084, 3.8598683,
            1.454862, 2.5525103, 4.5513983, 8.205984, 11.836169, 13.768068, 12.245629, 11.037193,
            7.8395824, 5.2028356, 1.50354, 2.619842, 4.8090568, 6.9723635, 11.21761, 13.429382,
            12.378876, 11.260203, 8.810773, 5.8131557, 2.6163213, 2.122204, 3.6673899, 5.8546815,
            8.054354, 9.901357, 8.938647, 7.542823, 6.3125916, 4.0426455, 1.7137345, 1.2372556,
            2.3643532, 3.7777991, 5.440807, 6.7675104, 6.654116, 5.689535, 5.1245723, 3.7748346,
            1.6670711, 0.6230596, 1.2076504, 2.2199442, 2.6854694, 3.9172115, 3.342186, 2.5706284,
            2.7266493, 1.5514135, 0.799484, 0.07881682, 0.8351937, 1.2292519, 1.7472432, 2.653722,
            2.4551232, 2.5504866, 2.3412576, 1.7516949, 1.2640414,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.transposed_convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.00185038, 0.44556108, 0.00844186, 0.8082305, 0.33159012, 0.5138473, 0.65069795,
            0.9300001, 0.58097035, 0.5413155, 0.5714561, 0.21683556, 0.8548128, 0.02262598,
            0.62476623, 0.33444464, 0.98826236, 0.03221937, 0.12669064, 0.50246465,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.42635268, 0.91064155, 0.7792924, 0.07601635, 0.6067355, 0.3940292, 0.30074376,
            0.1328066, 0.72018456, 0.34319454, 0.6295161, 0.03357495, 0.03066352, 0.51702976,
            0.9283114, 0.36689135,
        ],
    )
    .unwrap();
    let conv_layer28 = TransposedConvolutionLayer::new(kernel28, 1, Padding::Valid);
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.00078891, 0.1916512, 0.4107876, 0.6996418, 0.91783124, 0.93244934, 0.3198444,
            0.02520627, 0.22020285, 1.0164243, 1.5707405, 2.2686942, 2.115419, 1.391233,
            0.67306834, 0.08518618, 0.55674386, 1.5316336, 2.1425958, 2.848894, 2.4295306,
            1.7859552, 0.9644271, 0.13051584, 0.8594357, 1.7422311, 3.3991745, 2.9784784,
            2.8995757, 2.4328094, 1.5567213, 0.2610008, 0.63022965, 1.3693041, 2.4012733, 2.187772,
            2.9178739, 1.6581328, 1.277661, 0.2863111, 0.2583847, 1.1286197, 1.2417196, 1.589265,
            1.3627536, 0.9109288, 0.9088421, 0.24609156, 0.01025525, 0.20322144, 0.82241774,
            1.0606632, 0.4734047, 0.38921854, 0.5129254, 0.18434994,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.transposed_convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.6327302, 0.37459058, 0.93406814, 0.33968034, 0.59511477, 0.4350908, 0.7094508,
            0.29612544, 0.80898666, 0.7905302, 0.4748418, 0.6989706, 0.85952836, 0.70326394,
            0.38940284, 0.37933362, 0.22292, 0.3949557, 0.27719194, 0.8619771,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.9255003, 0.30563155, 0.5844432, 0.36121982, 0.09087573, 0.23811613, 0.17829578,
            0.9398569, 0.04807154, 0.7588201, 0.05337733, 0.19222781, 0.98696715, 0.32119673,
            0.3872288, 0.74463385,
        ],
    )
    .unwrap();
    let conv_layer29 = TransposedConvolutionLayer::new(kernel29, 1, Padding::Valid);
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.585592, 0.540066, 1.3487619, 1.0473366, 1.3358153, 0.7178136, 0.47051007, 0.21496725,
            0.4601765, 0.9742788, 1.0320739, 2.325769, 2.0617907, 1.9015445, 1.1795994, 0.8448779,
            0.5094217, 1.4582337, 1.9229789, 3.0397873, 2.7224417, 2.100573, 1.4799583, 0.9980429,
            1.0396243, 1.4360354, 2.8475986, 3.120621, 4.348013, 3.3122592, 2.0153894, 1.2724507,
            0.48671892, 1.344458, 1.4422829, 2.8223827, 2.8399, 1.9118085, 1.4786947, 1.4736447,
            0.4868884, 1.1409408, 1.465096, 1.9922638, 1.7792337, 1.7822356, 0.77375615, 0.4556585,
            0.37438983, 0.34185544, 0.60829836, 0.76922345, 1.2587082, 0.67829835, 0.54018885,
            0.6418573,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.transposed_convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.6260977, 0.0084233, 0.31085488, 0.10247751, 0.60939455, 0.00353958, 0.22236562,
            0.31823838, 0.9627444, 0.866447, 0.8205645, 0.7792785, 0.61566937, 0.59327537,
            0.33567885, 0.96525836, 0.47292593, 0.2669342, 0.705448, 0.28257245,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.02662205, 0.05098573, 0.8293213, 0.9416077, 0.9101412, 0.07020015, 0.8425068,
            0.9708137, 0.3117258, 0.11623824, 0.19467542, 0.09732427, 0.43287596, 0.20617688,
            0.8857049, 0.9601851,
        ],
    )
    .unwrap();
    let conv_layer30 = TransposedConvolutionLayer::new(kernel30, 1, Padding::Valid);
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.016668, 0.03214629, 0.5279412, 0.61510134, 0.28717825, 0.40876058, 0.6018775,
            0.57381064, 0.56993157, 0.05771884, 0.8337498, 0.95961326, 1.3773596, 1.5731564,
            2.2379963, 1.4074618, 0.22023742, 0.34061795, 1.2646346, 2.686114, 2.8869262,
            2.3907819, 2.630259, 1.2165452, 1.0446528, 1.0311236, 2.9546864, 4.4676585, 3.3665094,
            2.8058963, 2.6578858, 1.2614119, 1.1358448, 0.93347937, 1.7183694, 3.1671078,
            2.4289567, 2.4246757, 2.7378454, 1.1389444, 0.6560986, 0.7661355, 1.4800501, 2.2988005,
            1.8292577, 1.3819909, 0.99063367, 0.34981498, 0.41783714, 0.4037322, 1.0679898,
            1.7061067, 0.95828724, 0.9393848, 0.92763644, 0.27132186,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.transposed_convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );

    let test_input31 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.09430943, 0.28105715, 0.6942895, 0.07089514, 0.7148581, 0.00085336, 0.23516753,
            0.04615124, 0.59699446,
        ],
    )
    .unwrap();

    let kernel31: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.53420085, 0.75324225, 0.38793716, 0.2669936, 0.29911962, 0.7380972, 0.17850904,
            0.65695775, 0.8119258, 0.26960826, 0.12972821, 0.6597052, 0.7345929, 0.6485681,
            0.22981846, 0.24392553,
        ],
    )
    .unwrap();
    let conv_layer31 = TransposedConvolutionLayer::new(kernel31, 1, Padding::Valid);
    let target_output31: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.05038017, 0.22117881, 0.61918026, 0.6571807, 0.34438115, 0.18537086, 0.06608205,
            0.58895826, 0.9983783, 0.9214731, 0.4997732, 0.45634672, 0.2234051, 0.7215719,
            1.6371752, 0.9910507, 0.9891861, 0.6179807, 0.19718388, 1.0545356, 1.1712168,
            1.2810013, 0.83671224, 0.56211805, 0.24301766, 0.67198455, 1.00822, 0.5042172,
            0.2824615, 0.39404854, 0.17275241, 0.18642454, 0.52252597, 0.45516133, 0.14845783,
            0.1456222,
        ],
    )
    .unwrap();
    let current_output31: Array3<f32> = conv_layer31.transposed_convolve(&test_input31);

    assert!(
        arr_allclose(&current_output31, &target_output31),
        "{:?} was not equal to {:?}",
        current_output31,
        target_output31
    );

    let test_input32 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.26706976, 0.32711208, 0.9581323, 0.31259444, 0.91530424, 0.17250775, 0.715259,
            0.5014661, 0.7273789,
        ],
    )
    .unwrap();

    let kernel32: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.23862323, 0.4093651, 0.04974006, 0.8688277, 0.46409306, 0.20740515, 0.19872624,
            0.27135858, 0.02647329, 0.90772045, 0.97377276, 0.47016057, 0.06899374, 0.47393376,
            0.49847803, 0.02369655,
        ],
    )
    .unwrap();
    let conv_layer32 = TransposedConvolutionLayer::new(kernel32, 1, Padding::Valid);
    let target_output32: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.06372905, 0.18738559, 0.37582496, 0.6405341, 0.3318616, 0.8324519, 0.19853753,
            0.5535802, 0.9969875, 0.72393566, 1.0829929, 0.40987694, 0.32282054, 1.153168,
            1.328805, 2.5604575, 1.8413234, 1.1292545, 0.35864827, 0.8381969, 2.077785, 2.262943,
            1.3643091, 0.30119127, 0.04050232, 0.87383, 1.7724638, 2.030281, 1.0517522, 0.34607273,
            0.0493484, 0.3735834, 0.6443872, 0.61164844, 0.3744654, 0.01723637,
        ],
    )
    .unwrap();
    let current_output32: Array3<f32> = conv_layer32.transposed_convolve(&test_input32);

    assert!(
        arr_allclose(&current_output32, &target_output32),
        "{:?} was not equal to {:?}",
        current_output32,
        target_output32
    );

    let test_input33 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.10663922, 0.02373338, 0.21085607, 0.56809616, 0.70259374, 0.4123619, 0.01858313,
            0.25862443, 0.4823392,
        ],
    )
    .unwrap();

    let kernel33: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.47215322, 0.593886, 0.8265343, 0.06712108, 0.3228139, 0.11140465, 0.59627575,
            0.49184018, 0.8395536, 0.13370071, 0.25792846, 0.54400545, 0.8792363, 0.58678144,
            0.03434712, 0.8123595,
        ],
    )
    .unwrap();
    let conv_layer33 = TransposedConvolutionLayer::new(kernel33, 1, Padding::Valid);
    let target_output33: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.05035005, 0.07453734, 0.20179227, 0.15199867, 0.17587277, 0.01415289, 0.30265307,
            0.6886578, 1.2158072, 0.95383644, 0.52539146, 0.13138565, 0.28169277, 0.4574254,
            1.1545247, 1.3380804, 1.074771, 0.34989813, 0.5767071, 0.8348189, 0.9852452, 0.9736566,
            0.9299061, 0.63285184, 0.5150923, 1.1707078, 1.2386659, 0.8689017, 0.8500242,
            0.59738123, 0.01633896, 0.23829623, 0.57648444, 0.30700687, 0.22666298, 0.39183283,
        ],
    )
    .unwrap();
    let current_output33: Array3<f32> = conv_layer33.transposed_convolve(&test_input33);

    assert!(
        arr_allclose(&current_output33, &target_output33),
        "{:?} was not equal to {:?}",
        current_output33,
        target_output33
    );
}
