// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_torch_transpose() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637, 0.14352316, 0.8997107, 0.64410555,
            0.04471071, 0.767672, 0.43464628, 0.16569944, 0.18875164, 0.12285258, 0.2781115,
            0.5390728, 0.5066572, 0.97435564, 0.39133722,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(kernel1, 1, Padding::Valid);
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.502705, 0.9429496, 1.2797613, 1.9176188, 1.5595503, 1.048703, 0.68886304, 1.0313098,
            2.269095, 3.740393, 4.6934915, 3.951138, 2.713698, 1.6001914, 0.8498012, 2.1968966,
            3.9940155, 5.545063, 4.0846105, 3.0748034, 1.3273236, 1.877612, 3.0732944, 5.274679,
            7.072177, 5.3057566, 4.2879295, 1.4235954, 2.297185, 3.7321212, 6.783723, 7.271183,
            6.0375457, 4.682065, 1.7877847, 1.1684452, 2.017402, 4.105599, 4.5629334, 3.5949254,
            2.758629, 0.6369324, 1.1169262, 1.4684255, 2.7736907, 2.9664128, 2.6813393, 1.4310664,
            0.4190872, 0.5252309, 0.9249735, 1.6928465, 2.0780373, 1.7369382, 1.3046416, 0.3887366,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.7964828, 0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183,
            0.81628793, 0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133,
            0.0067116, 0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715,
            0.7567798, 0.23972042, 0.38848338, 0.00744711, 0.8715701, 0.07988323, 0.6283005,
            0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194, 0.34163022, 0.03235205,
            0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.97700953, 0.18019113, 0.775954, 0.14120784, 0.3426181, 0.5417864, 0.7768226,
            0.34603763, 0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802, 0.629322,
            0.60627973, 0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678, 0.89887625,
            0.6572328, 0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983, 0.6908677,
            0.5511301, 0.36253917, 0.36786652, 0.88718724,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(kernel2, 1, Padding::Valid);
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.80761784, 1.4047898, 1.7932408, 1.2941029, 0.8047526, 0.10153412, 0.04166387,
            0.8912326, 2.7170906, 4.153331, 4.297767, 2.8265631, 1.282428, 0.32442036, 1.8795388,
            4.420615, 6.301212, 6.9407735, 4.938551, 2.7627223, 0.9171338, 2.853494, 5.9678917,
            7.847625, 8.509516, 6.6973267, 3.4506176, 1.659546, 2.9398742, 5.697431, 7.437649,
            8.574824, 6.400357, 3.328308, 1.7446139, 2.5361488, 4.877659, 5.9356246, 7.020297,
            4.644166, 2.7666767, 1.2419925, 1.4844711, 3.0892892, 3.1519656, 4.1183887, 2.9307432,
            1.2566776, 1.0967124, 0.81183, 1.1914632, 1.3408532, 1.9339681, 1.50156, 0.6850412,
            0.84211254,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.69587743, 0.4870034, 0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529,
            0.5566727, 0.7035832, 0.92333794, 0.85647196, 0.36252776, 0.9373231, 0.01684272,
            0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754, 0.31284246, 0.4031665,
            0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259, 0.23846498, 0.82509995,
            0.97324103, 0.96826524, 0.77620417, 0.8427075, 0.42989048, 0.76771307, 0.54514444,
            0.7878393, 0.21897991, 0.975659, 0.73295325, 0.69994044,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.86701024, 0.76087946, 0.623545, 0.14890751, 0.8610666, 0.21943341, 0.1644093,
            0.6089244, 0.8612485, 0.02602104, 0.30423534, 0.5087405, 0.16869895, 0.3329467,
            0.179494, 0.33126613, 0.11996287, 0.21606164, 0.87119263, 0.33579683, 0.2313126,
            0.2576527, 0.3748985, 0.30113342, 0.8142977, 0.423247, 0.8179498, 0.92175007,
            0.21606776, 0.19149332, 0.4240341, 0.14780204,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(kernel3, 1, Padding::Valid);
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 8, 7),
        vec![
            0.6516979, 1.1273124, 2.028801, 2.798158, 2.284626, 1.3040509, 0.2689164, 0.99201345,
            1.8634316, 3.3373132, 4.0776305, 2.5280683, 2.2012532, 1.0699694, 2.0465374, 3.798849,
            6.22866, 7.448679, 5.091766, 3.8540993, 1.7611845, 2.7837794, 3.932057, 5.714086,
            8.113128, 5.6842246, 4.660744, 2.300539, 2.8676977, 3.9839854, 6.4955125, 9.24818,
            6.2704988, 4.605478, 2.3478477, 1.8503224, 2.6360874, 4.4229307, 6.3736625, 4.2340827,
            3.417551, 1.841166, 0.7427548, 2.1024165, 2.648695, 3.8283474, 3.2823966, 2.421556,
            1.2261951, 0.10870812, 0.49979305, 0.8793051, 1.2965395, 1.0760272, 0.7116136,
            0.20708674,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.46443272, 0.00207204, 0.359202, 0.9019851, 0.21363449, 0.6390296, 0.5977058,
            0.81350476, 0.3685356, 0.90738845, 0.7828945, 0.9812083, 0.6726924, 0.46724817,
            0.17302093, 0.39839587, 0.78055173, 0.8576361, 0.7335981, 0.52934057, 0.9529279,
            0.78965247, 0.46750203, 0.08403921, 0.73126566, 0.34934825, 0.3459232, 0.54770446,
            0.68714255, 0.29283327, 0.53392637, 0.8850151, 0.6909357, 0.44388366, 0.9043074,
            0.9949724, 0.64743847, 0.36691284, 0.5396585, 0.5372604,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.47547424, 0.44373918, 0.34716287, 0.21774843, 0.9437953, 0.51856595, 0.15765554,
            0.9350713, 0.86233217, 0.81734437, 0.6566154, 0.3879487, 0.28848994, 0.5814131,
            0.06870039, 0.78543746, 0.47194287, 0.12733267,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(kernel4, 1, Padding::Valid);
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.999696, 1.4781973, 1.6032398, 1.2709846, 0.76149595, 0.34573865, 1.0753132,
            2.3849704, 2.418202, 2.5710032, 2.1808553, 0.96841216, 1.8160284, 3.6567876, 4.31555,
            4.639324, 4.1677446, 1.9319746, 1.7711062, 3.2865639, 4.816927, 5.892727, 4.7029104,
            1.8651805, 1.8439273, 3.7875152, 5.2622237, 5.8000474, 4.2363214, 1.6259652, 1.0054839,
            2.7831144, 3.8394492, 3.6386466, 2.3359013, 0.78165007, 0.6315807, 1.4588236,
            2.2701714, 2.2323794, 1.4498489, 0.5248782,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6111727, 0.25675833, 0.74741316, 0.45714313, 0.9649919, 0.57969916, 0.5208711,
            0.93666834, 0.13247305, 0.7087714, 0.17877895, 0.40767, 0.6906785, 0.9675369, 0.224454,
            0.28950995, 0.75431514, 0.99582964, 0.8120864, 0.9536324, 0.7703749, 0.683158,
            0.16371861, 0.42877796, 0.7300311, 0.9456737, 0.05700503, 0.19623296, 0.44457257,
            0.5512328, 0.15101007, 0.25140873, 0.2031063, 0.5537751, 0.3641559, 0.701937,
            0.27669305, 0.85076064, 0.00186597, 0.3316532,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.15485734, 0.35000807, 0.42372492, 0.03995521, 0.5067197, 0.38907993, 0.37287286,
            0.21294773, 0.8646356, 0.10154326, 0.75313085, 0.7910046, 0.15368015, 0.25977603,
            0.40315583, 0.635939, 0.25689796, 0.13678746,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(kernel5, 1, Padding::Valid);
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.17287096, 0.9032394, 1.605081, 1.1484096, 0.9291295, 0.53286827, 0.3663767,
            1.6984262, 2.8988857, 2.2646203, 1.4412652, 0.9028405, 0.93420666, 2.2522793,
            3.5995948, 2.9142466, 2.1546159, 1.2690704, 1.0252702, 2.1070008, 3.5753164, 3.2298799,
            2.1234958, 1.7746001, 0.5358338, 1.9967597, 3.3339782, 3.5663772, 1.8189571, 1.4489251,
            0.4593595, 1.5368297, 2.4519267, 2.8395061, 1.3719581, 0.85108393, 0.45722353,
            1.1440613, 1.4246658, 1.7173092, 0.9906889, 0.86991054,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.43744904, 0.6658951, 0.564682, 0.70429957, 0.67241764, 0.15790685, 0.25059524,
            0.6432024, 0.60438925, 0.45131883, 0.96080875, 0.40131757, 0.60942906, 0.7035094,
            0.6473561, 0.05433872, 0.7478619, 0.24740443, 0.35665986, 0.00020906, 0.23741227,
            0.57013196, 0.6398819, 0.7132858, 0.90739846, 0.8246988, 0.1319153, 0.6876462,
            0.846729, 0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465, 0.05539654,
            0.5554673, 0.9149804, 0.9791666, 0.9000323, 0.6329186,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.30872977, 0.30553624, 0.04431259, 0.5287215, 0.3358437, 0.72178566, 0.72704846,
            0.85191244, 0.07464863, 0.867838, 0.5849202, 0.14913943, 0.18325551, 0.40498126,
            0.75359416, 0.01821492, 0.5917236, 0.91982275,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(kernel6, 1, Padding::Valid);
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.34108895, 0.9728876, 1.3213769, 1.4978021, 0.75285846, 0.13758838, 1.269866,
            2.2002742, 2.2526097, 2.9412181, 2.0447106, 1.1769385, 1.7655951, 2.8122463, 4.767697,
            4.764971, 3.047207, 1.7904596, 1.4558735, 3.3807273, 4.693439, 3.8900793, 3.2032518,
            1.4674815, 1.8627332, 3.9013562, 5.3570285, 4.7053084, 2.8398862, 1.0851057, 1.0122067,
            2.1739597, 3.9788904, 2.9729002, 1.6663357, 0.9921024, 0.56039816, 1.3762388,
            1.9633126, 1.7672219, 1.2291853, 0.58218855,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.5287654, 0.7151285, 0.38420153, 0.517026, 0.5150141, 0.26934662, 0.7356045,
            0.97902703, 0.6362754, 0.27803296, 0.32063982, 0.83432084, 0.78711736, 0.28247103,
            0.7812688, 0.5270146, 0.4719829, 0.47535485, 0.23715672, 0.4404677, 0.90286416,
            0.66611385, 0.02649495, 0.3193976,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.16608049, 0.5121102, 0.17436478, 0.313714, 0.47244504, 0.9906781, 0.9064671,
            0.29454133, 0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972, 0.53866875,
            0.6358971, 0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548, 0.14977625,
            0.53714937, 0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625, 0.4744624,
            0.73655206, 0.42605233, 0.6592577, 0.3237799,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(kernel7, 1, Padding::Valid);
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.7352197, 1.3515627, 1.5097696, 1.464025, 0.45370227, 0.34149992, 0.88704026,
            2.5538697, 2.9710164, 3.0057445, 1.1279745, 0.68346167, 1.7897294, 3.6483529,
            5.2505655, 4.3286195, 2.1321385, 1.1814687, 2.7460556, 4.626269, 6.569229, 6.3555098,
            3.5803194, 1.8112957, 1.79003, 3.4298694, 4.7012773, 4.5571704, 3.0825636, 1.3161967,
            1.3376439, 2.026359, 3.9575484, 3.0843801, 2.4490156, 1.1486058, 0.62618244, 0.6094098,
            1.4419737, 1.2709844, 1.0362055, 0.8489524,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.42867732, 0.87574345, 0.70010746, 0.01496939, 0.78416556, 0.61210716, 0.98323476,
            0.9316805, 0.05175687, 0.70876056, 0.52122, 0.68573385, 0.415587, 0.87644994,
            0.73337436, 0.5451011, 0.20423086, 0.5554448, 0.48578474, 0.2764571, 0.9192946,
            0.8920509, 0.34320405, 0.4283556,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.3897719, 0.06360459, 0.729173, 0.19460331, 0.8634254, 0.6576018, 0.9657459,
            0.22873744, 0.47843248, 0.22157177, 0.9162307, 0.02157675, 0.44649428, 0.2792192,
            0.685827, 0.75294507, 0.7919586, 0.22560763, 0.88778716, 0.80092114, 0.00003577,
            0.9737877, 0.9146247, 0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946,
            0.17754778, 0.41998118, 0.02919354,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(kernel8, 1, Padding::Valid);
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            0.49621406, 1.1564777, 1.7886522, 2.042929, 2.0339696, 0.72361827, 0.80767787,
            2.0340822, 4.0972557, 4.334453, 2.924386, 0.82584226, 1.279386, 3.1435945, 5.4058027,
            5.166163, 3.8739715, 1.3600483, 2.4288292, 3.8326018, 6.5877733, 6.9249496, 4.7030644,
            1.4665959, 1.4500757, 3.146923, 5.4911084, 4.189834, 2.9250813, 1.1727424, 1.4239361,
            1.5181937, 2.9048104, 2.9271312, 2.062664, 0.30345547, 0.3459796, 0.60036117,
            1.3875539, 1.3288295, 1.0526655, 0.52882516,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.82382417, 0.4156855, 0.49590722, 0.69720376, 0.7155315, 0.40795937, 0.15397236,
            0.02265206, 0.7090415, 0.75877124, 0.67035425, 0.39483562, 0.86222315, 0.9993058,
            0.84902793, 0.26427644, 0.86764544, 0.24274233, 0.69865257, 0.5739991, 0.7620597,
            0.29289714, 0.88402116, 0.8942853,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.7757528, 0.16431308, 0.48939565, 0.56055367, 0.46453193, 0.9573795, 0.8899508,
            0.16098963, 0.63514715, 0.810474, 0.29953358, 0.46075395, 0.02808736, 0.59781086,
            0.8855644, 0.61877847, 0.9537467, 0.6197168, 0.3379795, 0.13108306, 0.30692965,
            0.33537498, 0.01351478, 0.45529485, 0.6626128, 0.9497022, 0.7403127, 0.06039312,
            0.08292098, 0.80679554, 0.1354166, 0.2560622,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(kernel9, 1, Padding::Valid);
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 7, 6),
        vec![
            1.4614264, 1.9452529, 2.5766377, 1.7236409, 0.893655, 0.3892758, 1.4402449, 3.2386222,
            3.6026678, 2.9545033, 1.7712301, 0.7268965, 2.2853394, 4.7908196, 6.860435, 4.8290114,
            2.5980406, 0.95331216, 1.8665061, 5.365869, 7.4252152, 6.9853153, 3.6446462, 1.526552,
            1.0446001, 3.312481, 5.9700685, 5.0751724, 2.7546, 1.1580384, 0.7382664, 2.6086156,
            3.4610271, 3.8025112, 2.0346682, 0.86980504, 0.0455992, 0.7820422, 1.9108183,
            2.2154067, 1.1119187, 0.47330844,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.80891573, 0.97702754, 0.4124968, 0.4359102, 0.8733311, 0.1396195, 0.52047473,
            0.88564533, 0.29781443, 0.21130918, 0.83071965, 0.3337948, 0.9783562, 0.42070097,
            0.55396014, 0.16172563, 0.7634967, 0.36205766, 0.48491392, 0.4980414, 0.6001484,
            0.65126085, 0.3691911, 0.11615072,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.26983073, 0.8690525, 0.7446416, 0.471613, 0.72900707, 0.842964, 0.21457537, 0.938401,
            0.41665936, 0.05351101, 0.43856344, 0.7253113, 0.8520324, 0.4151233, 0.35101932,
            0.7388761, 0.3592986, 0.6741479,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(kernel10, 1, Padding::Valid);
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.27062315, 1.4182057, 2.4865046, 1.6341026, 0.7089558, 1.3413624, 2.5413365,
            4.1715007, 2.9861615, 0.9087417, 1.4062221, 4.0090275, 6.1544356, 4.0758405, 1.4471645,
            0.96352315, 3.3546166, 5.4049835, 3.7547224, 1.0967677, 1.1245239, 2.3514118,
            3.4831169, 2.3212833, 0.85082406, 0.52654284, 0.8833283, 1.5967331, 0.9499827,
            0.21738149,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.9965808, 0.3117034, 0.8605703, 0.94308543, 0.8192489, 0.31478795, 0.750324,
            0.36604244, 0.78454614, 0.039194, 0.23696694, 0.2418382, 0.24788351, 0.5622223,
            0.15428482, 0.50688076, 0.37682602, 0.44385925, 0.00051633, 0.53422695, 0.5675659,
            0.53845215, 0.2130759, 0.86445093,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.432881, 0.6255918, 0.3942565, 0.07226853, 0.09869356, 0.32627374, 0.8543963,
            0.85603166, 0.25422713, 0.24929269, 0.36793318, 0.39957172, 0.9079535, 0.865758,
            0.82237726, 0.60374194, 0.7658025, 0.0215734,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(kernel11, 1, Padding::Valid);
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.49319643, 0.98974574, 1.3048017, 0.9426714, 0.4009333, 0.8316936, 2.0710235,
            2.7212307, 1.6163682, 0.70912266, 1.8544419, 3.3431668, 4.5445843, 2.996143, 1.2259312,
            1.3176861, 3.0872867, 3.8708282, 2.6012692, 1.2530897, 1.1331078, 1.9586028, 3.3920135,
            2.2356408, 1.0015075, 0.35857335, 0.77700585, 1.1161367, 0.93386006, 0.08013098,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.473204, 0.6594781, 0.86392707, 0.8566667, 0.48541847, 0.54855824, 0.5860555,
            0.158874, 0.10558709, 0.19664533, 0.39609066, 0.27843866, 0.49128443, 0.75033015,
            0.35650545, 0.4687038, 0.6159849, 0.2547001, 0.17250927, 0.07203952, 0.8724657,
            0.14018923, 0.12091745, 0.4770398,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.43290496, 0.6356798, 0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018,
            0.10666513, 0.06810815, 0.79673207, 0.29373887, 0.55241185, 0.23906927, 0.18915932,
            0.02753429, 0.1438574, 0.5419741, 0.71984386,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(kernel12, 1, Padding::Valid);
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 6, 5),
        vec![
            0.59627444, 1.328419, 1.9296021, 1.5708776, 0.85520226, 0.9745261, 2.264479, 3.1527526,
            2.3740244, 0.9973531, 1.1124315, 2.6096385, 4.1392536, 2.1845303, 1.1572064, 1.0504992,
            1.8583012, 2.9155536, 1.7054474, 0.7728206, 0.5193101, 0.61622566, 1.1031592,
            1.1028433, 0.78658664, 0.1591172, 0.3942274, 0.4874617, 0.4022616, 0.36235812,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286, 0.21388301,
            0.30016333, 0.49605927, 0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258,
            0.26911622, 0.92149794, 0.7165893, 0.04745785, 0.55642486, 0.34654748, 0.83168656,
            0.8410765, 0.7668131, 0.84094906, 0.6012723, 0.9256995, 0.66010624, 0.43380973,
            0.62281454, 0.45852852, 0.61445725, 0.524579, 0.06486581, 0.14233574, 0.13930365,
            0.5838787, 0.45914945, 0.30819193, 0.70949817, 0.8803759, 0.6927248, 0.50569826,
            0.7358748, 0.58652496, 0.85065925, 0.3247378, 0.6760192, 0.4483504, 0.59195757,
            0.37883574, 0.7796499, 0.32748002, 0.44507304, 0.7488422, 0.14428215, 0.8785777,
            0.15468395, 0.6638725, 0.30651525, 0.9492515, 0.55669755, 0.08302987, 0.45890567,
            0.05946975, 0.9099885, 0.30235246, 0.24214035, 0.42138377, 0.38782486, 0.21880285,
            0.9182205, 0.85290706,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431, 0.2624427, 0.6557088, 0.00633,
            0.6603214, 0.45500925, 0.6523986, 0.14666249, 0.32440838, 0.2805719, 0.42671442,
            0.74477625, 0.9118973, 0.5335283, 0.36968935, 0.5693756, 0.36426732, 0.11819325,
            0.95361024, 0.13343851, 0.5940242, 0.7282295, 0.9320007, 0.46956548, 0.5087874,
            0.7952918, 0.73709416, 0.3358689,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(kernel13, 1, Padding::Valid);
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.4837853, 0.8757887, 1.4394039, 2.155512, 2.4521062, 2.4945824, 2.0444198, 1.5238137,
            0.6407144, 0.9751487, 1.5157624, 2.9186244, 3.5864058, 4.0191603, 4.466482, 3.3995945,
            2.2879326, 0.71022743, 1.3584528, 2.43436, 4.6551576, 5.7673793, 6.885384, 7.0397177,
            5.3289013, 3.2705052, 0.84684896, 1.5465524, 3.6602557, 6.364115, 8.280497, 9.605082,
            9.834179, 7.1791716, 5.1418233, 2.061477, 1.9734471, 3.879078, 6.523394, 8.678526,
            8.797651, 9.066004, 6.3867407, 5.040209, 1.5797093, 1.7157623, 3.5784514, 6.3309793,
            7.339995, 8.17547, 8.068235, 7.1835804, 4.9947453, 1.712302, 1.2058223, 2.6293263,
            4.5664253, 5.1686244, 5.3168144, 5.7526197, 5.4193134, 4.1517677, 1.2718728, 1.027875,
            2.0066066, 2.8856058, 3.2868457, 3.7114153, 4.188407, 3.6057487, 2.8154442, 0.92918074,
            0.32253304, 0.74954426, 1.1413466, 1.557538, 1.5720842, 1.7932853, 1.7578851, 1.289974,
            0.7213239,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.03185032, 0.27057356, 0.26166973, 0.5843129, 0.5337139, 0.19571388, 0.1192536,
            0.75616854, 0.97167397, 0.71154076, 0.26672947, 0.07128377, 0.3383284, 0.8008563,
            0.9504947, 0.5971434, 0.7847773, 0.92326206, 0.24163638, 0.12968542, 0.5954836,
            0.6734995, 0.08627631, 0.7485715, 0.8782484, 0.6863155, 0.7264353, 0.08944888,
            0.68172634, 0.4284322, 0.48237634, 0.6856524, 0.04009921, 0.0687674, 0.9063645,
            0.42620143, 0.61030614, 0.10040135, 0.50107217, 0.763057, 0.25769317, 0.8816114,
            0.7770131, 0.23345616, 0.62762326, 0.15315741, 0.73589575, 0.2752067, 0.85641515,
            0.7439484, 0.6581306, 0.4056261, 0.13899311, 0.26460668, 0.9179794, 0.96651816,
            0.89336777, 0.18948041, 0.9371178, 0.7124811, 0.9657549, 0.6203675, 0.32684848,
            0.11439406, 0.07654371, 0.95680344, 0.9728639, 0.6055871, 0.00439729, 0.8525613,
            0.3167563, 0.13499211,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.68338645, 0.7955047, 0.21689218, 0.2826704, 0.12328367, 0.6890043, 0.5906649,
            0.41700745, 0.30266365, 0.5716598, 0.12726787, 0.35587692, 0.16889893, 0.3114892,
            0.1309899, 0.24026695, 0.55435276, 0.34375766, 0.4225387, 0.37165096, 0.6202945,
            0.6069533, 0.05756181, 0.0153275, 0.8497578, 0.79796964, 0.4071996, 0.19325097,
            0.04944435, 0.59729165, 0.39304134, 0.679002,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(kernel14, 1, Padding::Valid);
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.36009097, 0.47569853, 0.97113454, 1.5396539, 1.6169901, 1.844972, 1.1321545,
            0.66160077, 0.38297424, 0.8947318, 1.4961514, 2.692305, 3.3630295, 3.3745122,
            2.9943738, 2.0335422, 0.87350017, 0.2175577, 1.7308965, 2.98748, 4.6217837, 5.8514256,
            5.892939, 5.811888, 3.4326758, 1.3896348, 0.6332866, 1.9788778, 3.985883, 5.7906017,
            7.0416117, 6.9006824, 6.5008397, 5.3334236, 2.7596626, 1.589648, 2.623465, 5.574608,
            6.715853, 7.0701604, 5.929167, 6.7513065, 4.2266293, 2.4645295, 1.3834788, 2.5289683,
            5.7033176, 6.472336, 7.0203514, 6.2579827, 6.6999, 5.0615244, 2.2220635, 1.1695541,
            1.8356041, 4.083863, 4.233476, 4.783486, 3.69611, 4.493311, 3.4800467, 2.3789911,
            1.1808037, 1.1687828, 2.7711892, 2.5664124, 3.1080046, 2.6559181, 2.2165222, 1.7084192,
            1.1409314, 0.9303722, 0.12957546, 0.8770873, 1.0278378, 1.173196, 1.2823093, 0.9068981,
            1.052023, 0.54173315, 0.19406202,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.6126854, 0.67232877, 0.7156292, 0.09058711, 0.33372015, 0.8941644, 0.30899736,
            0.3348802, 0.6412177, 0.26750943, 0.03709449, 0.56803024, 0.8756273, 0.5771133,
            0.56024176, 0.5868575, 0.75167763, 0.36936092, 0.37185487, 0.35425207, 0.24336162,
            0.01027582, 0.2671537, 0.83992416, 0.49819484, 0.7831867, 0.70054483, 0.8701863,
            0.49413827, 0.84670645, 0.8069649, 0.093459, 0.93408287, 0.8206956, 0.70209366,
            0.32817394, 0.744203, 0.39091238, 0.43911496, 0.92919487, 0.29325068, 0.62813336,
            0.8131431, 0.19520658, 0.47931832, 0.42483747, 0.47526902, 0.28184402, 0.09741595,
            0.45691565, 0.44086096, 0.9638409, 0.33859608, 0.26381832, 0.29839757, 0.68755937,
            0.09156765, 0.58584654, 0.04617033, 0.14705709, 0.81179595, 0.16751295, 0.06864621,
            0.6308731, 0.38993102, 0.3644169, 0.68174505, 0.272409, 0.23609333, 0.21866773,
            0.80119157, 0.01742986,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.49270406, 0.37920174, 0.90869635, 0.8191268, 0.7636344, 0.7827788, 0.9694966,
            0.79533535, 0.00732174, 0.8372113, 0.9449071, 0.7670253, 0.50964797, 0.7843069,
            0.7365313, 0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833,
            0.5585159, 0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028,
            0.52249014, 0.5252596, 0.33191478, 0.3388958,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(kernel15, 1, Padding::Valid);
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 9, 9),
        vec![
            0.96938276, 1.6245587, 2.0563893, 3.4691186, 3.0028152, 2.661161, 2.2668674, 1.4759921,
            1.3418406, 1.5384467, 2.7413342, 3.860046, 5.3698206, 4.62476, 4.903781, 3.2330096,
            2.641601, 1.7236232, 1.1846845, 3.1389244, 5.9216523, 8.363903, 7.6064186, 6.9292607,
            6.1938143, 4.075899, 2.2705812, 2.086835, 4.6717877, 7.0264673, 9.499325, 9.157389,
            7.9497967, 6.818104, 4.63001, 2.726581, 1.9507482, 4.267089, 6.038251, 9.346359,
            8.780865, 8.937352, 7.4794383, 4.818042, 2.7517314, 2.1833463, 4.6726556, 7.1383467,
            10.159309, 9.782708, 9.512116, 7.6496673, 5.385999, 2.2200356, 1.3772514, 3.0338087,
            5.21172, 6.776279, 6.5082684, 6.798432, 6.065506, 3.8609576, 1.8272834, 0.8845324,
            2.4134095, 3.3390555, 5.0121307, 5.0036283, 5.4344096, 4.561091, 2.6668954, 0.9899533,
            0.76747304, 1.1809634, 1.636432, 2.3533666, 2.460103, 2.5692575, 1.7073956, 1.018367,
            0.23931447,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.18619475, 0.6839338, 0.72234726, 0.25884646, 0.7980101, 0.36219832, 0.7046317,
            0.9284394, 0.468965, 0.23158234, 0.32747796, 0.9097073, 0.7440483, 0.03255624,
            0.30697423, 0.6246821, 0.1907446, 0.9843364, 0.4038572, 0.5747709, 0.65160054,
            0.6822517, 0.9840877, 0.18341686, 0.5288406, 0.92906404, 0.87780553, 0.9090181,
            0.82569945, 0.20383635, 0.7166643, 0.17061436, 0.91526777, 0.08598401, 0.70100874,
            0.40537685, 0.5971982, 0.92796123, 0.15859716, 0.7859081, 0.8564488, 0.35816404,
            0.79062706, 0.9644883, 0.13154314, 0.31929043, 0.80048305, 0.07180241, 0.52815664,
            0.45786336, 0.91537887, 0.9783313, 0.25753945, 0.42799363, 0.07738555, 0.9294206,
            0.07022415, 0.60058224, 0.6196278, 0.9008346, 0.04155485, 0.82207745, 0.41282526,
            0.9949608, 0.3109271, 0.47614527, 0.7615821, 0.35893062, 0.07713356, 0.6123928,
            0.62511915, 0.88098776,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.21521498, 0.89468116, 0.1842307, 0.10784956, 0.8354833, 0.2630701, 0.7184675,
            0.06132602, 0.06056971, 0.71349823, 0.00944792, 0.07349233, 0.35231608, 0.8533961,
            0.17608605, 0.18067755, 0.51991457, 0.19053963,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(kernel16, 1, Padding::Valid);
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.46617174, 0.9815187, 0.96748096, 1.4584202, 1.1665629, 1.1610017, 0.5373963,
            0.09305036, 0.94624186, 2.591772, 2.873729, 2.327383, 2.4406087, 2.3830411, 1.902745,
            0.3312242, 1.1331892, 3.6886864, 4.1459355, 2.8839972, 3.0731423, 3.05916, 2.4071534,
            0.55494213, 1.0575575, 3.6816702, 2.9681504, 3.4333057, 3.718822, 3.8887475, 1.9480996,
            0.50309056, 0.8442843, 2.4792728, 3.6828806, 4.3402743, 3.9285963, 4.493621, 1.9953499,
            0.42059258, 1.0734401, 2.4542074, 3.498899, 4.1433606, 4.1905975, 3.8018346, 2.0519793,
            0.45964873, 0.7330724, 2.26362, 2.1269777, 2.4778764, 2.4989417, 2.293124, 1.754318,
            0.36484304, 0.6525008, 0.62733936, 1.0571225, 0.3473795, 1.0103965, 0.9403165,
            0.6444684, 0.19241664,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.5045173, 0.7456122, 0.27621788, 0.48649722, 0.39297876, 0.54849166, 0.3746991,
            0.8194284, 0.34880427, 0.79505837, 0.41293454, 0.890512, 0.12076204, 0.20799449,
            0.88948244, 0.24437675, 0.7731474, 0.65954226, 0.4922565, 0.5211581, 0.97382414,
            0.9779564, 0.1754263, 0.4551989, 0.81067127, 0.7095975, 0.5087082, 0.78796804,
            0.03310984, 0.20805901, 0.45704818, 0.9133983, 0.5689028, 0.04247752, 0.55938286,
            0.9835293, 0.04525762, 0.7176199, 0.82096803, 0.5575717, 0.5744108, 0.9780689,
            0.34563604, 0.3324931, 0.8797563, 0.14932355, 0.1134909, 0.5645703, 0.30096474,
            0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894, 0.681929, 0.24701218,
            0.74485576, 0.61556435, 0.63869125, 0.05875124, 0.3210932, 0.96946657, 0.09463912,
            0.6275637, 0.34162354, 0.74390864, 0.8736778, 0.9513908, 0.24045336, 0.7003475,
            0.87750345, 0.16564246,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.6314963, 0.21785556, 0.7654987, 0.13988015, 0.03287261, 0.82226163, 0.60896695,
            0.13331373, 0.62307173, 0.23316076, 0.9600204, 0.55291533, 0.29808274, 0.8765127,
            0.98263544, 0.27148733, 0.11101003, 0.2754741,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(kernel17, 1, Padding::Valid);
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.32915312, 0.7915323, 1.6284447, 2.2530951, 1.6887313, 1.8921795, 1.6768833,
            0.96065897, 0.40127236, 1.3828984, 2.7972336, 4.5497475, 3.1219683, 3.4166665,
            2.8777416, 2.405934, 0.6213963, 1.7922767, 3.5662603, 4.664923, 4.855339, 4.4217176,
            3.3858283, 2.8322394, 0.898477, 2.245188, 3.8746567, 4.896302, 5.457396, 5.3103566,
            3.064108, 2.3963628, 1.0141786, 2.206842, 4.821314, 4.415333, 5.118421, 4.827436,
            2.639816, 1.6273787, 1.1863438, 2.959039, 5.701863, 5.071146, 4.2924995, 5.0260577,
            2.660933, 2.0463526, 0.905205, 2.031211, 3.3807635, 3.5678265, 2.2897942, 2.7324352,
            1.7248006, 1.3060479, 0.5155197, 0.97243774, 1.1645548, 1.1497344, 1.0829911, 1.035286,
            0.7397711, 0.6584395,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969,
            0.5836321, 0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643,
            0.91682273, 0.6142979, 0.19277428, 0.28408903, 0.25507236, 0.9800453, 0.36125833,
            0.96792, 0.33258557, 0.9508625, 0.8424581, 0.8130291, 0.7774976, 0.17691322, 0.9389267,
            0.22419459, 0.33442205, 0.7614585, 0.37563834, 0.70754576, 0.1499497, 0.9873837,
            0.7166968, 0.40278858, 0.22288306, 0.3279577, 0.07722609, 0.598755, 0.8143903,
            0.87905455, 0.83061284, 0.9923988, 0.6196494, 0.536406, 0.06662867, 0.83588266,
            0.28182983, 0.662181, 0.99850965, 0.60448396, 0.12318801, 0.91713256, 0.8540598,
            0.19103892, 0.5929614, 0.9118344, 0.9381113, 0.3421722, 0.8149188, 0.9595595,
            0.02717085, 0.8916309, 0.9755575, 0.27588442, 0.59208006, 0.00008138, 0.9552037,
            0.12578069,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.01249961, 0.05413999, 0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439,
            0.34315115, 0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794,
            0.6930413, 0.90735817, 0.91156703, 0.45996496,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(kernel18, 1, Padding::Valid);
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.48162568, 0.9977244, 1.3984518, 0.89739656, 0.67153275, 1.318335, 1.192123,
            0.8317557, 1.2973466, 2.8725724, 3.7905424, 3.8881643, 4.066704, 4.7979684, 3.3533397,
            1.4218719, 1.8246634, 3.8597286, 5.3059373, 6.45571, 6.989967, 7.6048717, 4.659522,
            1.8180112, 1.1730818, 4.0778785, 6.1933575, 8.149513, 7.430545, 6.950018, 4.622121,
            2.2629454, 1.1839198, 4.0112906, 7.14848, 7.466683, 7.0291524, 6.6986666, 4.916982,
            2.5474505, 2.0761154, 5.284709, 7.356443, 7.148855, 5.8183055, 6.7459, 4.3339896,
            2.2954032, 2.5087118, 3.9116092, 5.3283386, 4.473075, 4.6628275, 3.8751693, 3.1298742,
            1.2532284, 1.1808238, 1.9275321, 2.005684, 1.8192613, 1.7109011, 2.27922, 0.9712485,
            0.5741586,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.9045769, 0.17170428, 0.43418503, 0.69308424, 0.42869946, 0.9244341, 0.41451567,
            0.6224708, 0.00536506, 0.33826837, 0.47926104, 0.0032256, 0.02230139, 0.35960108,
            0.48593593, 0.86064774, 0.28908366, 0.4153976, 0.3468706, 0.2242362,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.93169004, 0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496, 0.11111139,
            0.19382912, 0.9307082, 0.9188555, 0.10532705, 0.88550454, 0.20754221, 0.97926295,
            0.3472928, 0.71126235,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(kernel19, 1, Padding::Valid);
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.8427853, 0.44931865, 0.96385014, 1.0374374, 0.89303046, 0.5989905, 0.35939604,
            0.07444026, 1.4891341, 1.5977912, 1.7811126, 1.653647, 1.7254711, 0.75803006,
            0.37152702, 0.14183205, 1.9300504, 2.2492025, 1.8460484, 3.0675073, 2.2033956,
            1.6303946, 1.0309132, 0.5295605, 2.1826184, 3.1256526, 2.6609623, 3.8404284, 3.0517814,
            2.6414664, 0.99119055, 0.7375813, 1.235269, 2.3933427, 1.5689186, 2.9976149, 1.9376963,
            1.5965424, 0.5830535, 0.7143595, 0.90047884, 1.5298555, 0.9171206, 1.9355533,
            1.2901956, 1.22702, 0.75530636, 0.5441901, 0.17862074, 0.9027975, 0.6681982, 1.1913168,
            0.73609495, 0.63550854, 0.3245916, 0.15949076,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.03633394, 0.7482733, 0.28782296, 0.7382309, 0.60003114, 0.3259743, 0.85578996,
            0.14142898, 0.39191914, 0.05517358, 0.6050927, 0.968827, 0.47373444, 0.76571184,
            0.50472075, 0.53850234, 0.05837096, 0.56728834, 0.3979838, 0.2393961,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945, 0.66457146, 0.8425775,
            0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123, 0.48163053, 0.437191,
            0.43973154, 0.29997745,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(kernel20, 1, Padding::Valid);
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.01326461, 0.27377403, 0.1274733, 0.5045103, 0.7797918, 0.39490515, 0.6288656,
            0.37589717, 0.15320322, 1.0462306, 0.9549173, 2.1191585, 2.221704, 1.3427837,
            1.0839629, 0.29268193, 0.5525015, 1.9182047, 2.0106843, 3.5284717, 3.2304153,
            2.0332813, 1.7062223, 0.67616916, 1.005971, 2.5017385, 3.3024714, 4.630278, 3.9130447,
            2.73907, 1.8173878, 0.5780045, 1.0765924, 1.995022, 2.9839475, 3.6447508, 3.2223606,
            2.1328695, 1.328912, 0.40236884, 0.65875304, 1.0972893, 1.7509891, 2.1449728, 1.946783,
            1.4660859, 0.8573098, 0.28555793, 0.25935918, 0.2635416, 0.5355391, 0.6269006, 0.55626,
            0.44984156, 0.22465618, 0.07181343,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.21913478, 0.6611514, 0.209788, 0.176356, 0.88925517, 0.14793599, 0.36509594,
            0.5616029, 0.6617385, 0.30053073, 0.36820948, 0.62227124, 0.4957459, 0.69923055,
            0.3227648, 0.9702412, 0.5679234, 0.13432135, 0.7430913, 0.19231908,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.26170298, 0.10480803, 0.00958306, 0.20726651, 0.20851518, 0.17973869, 0.23704103,
            0.1163867, 0.2735905, 0.8537909, 0.40303, 0.75797635, 0.34342998, 0.74670875,
            0.82946825, 0.91931367,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(kernel21, 1, Padding::Valid);
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (1, 7, 8),
        vec![
            0.05734823, 0.19599238, 0.1262961, 0.11989552, 0.3902492, 0.13837314, 0.04507448,
            0.18431282, 0.08440822, 0.28829867, 0.4011782, 0.52290463, 0.57285815, 0.38029468,
            0.3713517, 0.16578743, 0.18716161, 0.6721394, 1.1264762, 1.3198416, 1.6282516,
            1.408849, 0.78834605, 0.77591056, 0.44642362, 1.0631331, 1.6789584, 2.7272391,
            2.9993143, 2.2887058, 1.8361909, 1.1227264, 0.3538543, 1.013282, 1.763593, 2.656537,
            3.0271783, 2.449081, 1.6497836, 0.5433135, 0.39190295, 1.4724134, 1.8530006, 2.747264,
            2.787906, 1.8422476, 1.5512912, 0.44249544, 0.3332099, 0.91952956, 1.2749876,
            1.7185292, 1.254436, 0.8834604, 0.84265655, 0.17680156,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9654975, 0.18782942, 0.10021565, 0.05109123, 0.3069365, 0.10895161, 0.9891213,
            0.62504834, 0.507994,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.47125, 0.84314245, 0.6054993, 0.92367506, 0.6953895, 0.37023902, 0.67128026,
            0.43450755, 0.28869846, 0.27641538, 0.8369712, 0.6856483, 0.26890948, 0.65425915,
            0.84581685, 0.51146317,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(kernel22, 1, Padding::Valid);
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.45499068, 0.90256655, 0.79020166, 1.0900326, 0.23417386, 0.0925667, 0.6954736,
            0.67580044, 1.1284205, 0.9076091, 0.4983658, 0.14418034, 0.7803894, 1.681985,
            2.4779541, 2.8358831, 1.3040973, 0.5852744, 0.962206, 1.5857925, 2.374179, 2.0777385,
            1.0950664, 0.34668633, 0.29929674, 0.56982386, 1.4206241, 1.6987802, 1.1028795,
            0.40402997, 0.26598412, 0.8152231, 1.3821635, 1.3669353, 0.74935913, 0.25982022,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.48995435, 0.52071315, 0.80564773, 0.670521, 0.3835857, 0.47078377, 0.5100531,
            0.82525116, 0.02126783,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.9583153, 0.23316967, 0.9487504, 0.9609589, 0.95734006, 0.00943314, 0.7521432,
            0.46106157, 0.84370506, 0.16933449, 0.71423984, 0.5316646, 0.6400151, 0.9638914,
            0.69432026, 0.8581641,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(kernel23, 1, Padding::Valid);
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.46953076, 0.6132499, 1.3583235, 1.1527054, 1.2647425, 0.77419436, 1.1116235,
            1.0270627, 2.3214636, 1.7431926, 1.6613097, 0.82385707, 1.5440853, 1.8056213,
            2.7732127, 2.64899, 2.1964343, 0.66583216, 1.3675945, 2.03756, 2.7105708, 3.1248178,
            1.9429144, 0.9514828, 0.859478, 1.6744483, 1.6585875, 2.1597385, 1.1100013, 0.4153171,
            0.3264417, 1.019809, 1.1632044, 1.0311978, 0.72296757, 0.01825129,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.70813745, 0.2836983, 0.33953485, 0.8950543, 0.20262088, 0.81930757, 0.09556881,
            0.22266188, 0.63842744,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.8304186, 0.12425002, 0.7582065, 0.09737789, 0.84872884, 0.17490041, 0.37569723,
            0.6669188, 0.8970669, 0.22398192, 0.29424527, 0.56277037, 0.41113177, 0.7882464,
            0.24159203, 0.5460915,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(kernel24, 1, Padding::Valid);
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (1, 6, 6),
        vec![
            0.5880505, 0.32357442, 0.85411996, 0.32624602, 0.28506348, 0.03306319, 1.3442864,
            0.6441071, 1.9880171, 0.9808256, 0.95770115, 0.3062246, 1.4742671, 0.93839884,
            2.2738612, 1.6318499, 1.2082489, 0.7996605, 1.1751734, 1.2627592, 2.1947212, 1.728776,
            0.9804134, 1.0722784, 0.45371687, 1.0099754, 1.3635015, 1.445846, 0.6217495,
            0.80670494, 0.03929137, 0.16687515, 0.4610789, 0.60922074, 0.27583274, 0.3486398,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );
}
