// This file has been automatically generated by Jinja2 via the
// script /Users/almico/projects/convolutions-rs/scripts/generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_torch() {
    let test_input1 = Array::from_shape_vec(
        (1, 5, 12),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553, 0.9034325, 0.2795916,
            0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666, 0.0474241, 0.23985276,
            0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692, 0.38484824, 0.775336,
            0.52113837, 0.4364637, 0.14352316, 0.8997107,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 4),
        vec![
            0.64410555, 0.04471071, 0.767672, 0.43464628, 0.16569944, 0.18875164, 0.12285258,
            0.2781115, 0.5390728, 0.5066572, 0.97435564, 0.39133722, 0.7964828, 0.988919,
            0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183, 0.81628793, 0.9480399,
            0.45711017, 0.89837223, 0.8462714,
        ],
    )
    .unwrap();
    let conv_layer1 = ConvolutionLayer::new(kernel1, 1, Padding::Valid);
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (2, 3, 9),
        vec![
            2.610403, 2.4953601, 2.1905198, 2.599674, 2.7904801, 3.0581555, 2.961478, 2.4943085,
            2.4935708, 2.4932637, 2.6347635, 2.6393704, 2.5595438, 3.073281, 3.1748111, 3.5728471,
            3.1205158, 3.140948, 2.5487566, 2.7550416, 2.266786, 2.316585, 2.771159, 2.9743018,
            3.1830044, 2.813585, 2.853707, 4.325645, 4.215521, 3.0686502, 3.8516722, 4.4572263,
            5.5346217, 4.948892, 4.074801, 4.218193, 5.1460752, 4.801564, 3.837761, 4.094041,
            5.1911564, 5.663174, 5.52573, 5.5966535, 4.765667, 4.18805, 4.6580243, 4.62209,
            3.8454208, 4.535684, 5.010015, 5.7046785, 5.554207, 4.576646,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (1, 5, 12),
        vec![
            0.70536447, 0.9289133, 0.0067116, 0.65220493, 0.72789615, 0.00785976, 0.32536873,
            0.09833383, 0.1022715, 0.7567798, 0.23972042, 0.38848338, 0.00744711, 0.8715701,
            0.07988323, 0.6283005, 0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194,
            0.34163022, 0.03235205, 0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297,
            0.97700953, 0.18019113, 0.775954, 0.14120784, 0.3426181, 0.5417864, 0.7768226,
            0.34603763, 0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802, 0.629322,
            0.60627973, 0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678, 0.89887625,
            0.6572328, 0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983, 0.6908677,
            0.5511301, 0.36253917, 0.36786652, 0.88718724,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 4),
        vec![
            0.69587743, 0.4870034, 0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529,
            0.5566727, 0.7035832, 0.92333794, 0.85647196, 0.36252776, 0.9373231, 0.01684272,
            0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754, 0.31284246, 0.4031665,
            0.7376267, 0.7926341, 0.36348057,
        ],
    )
    .unwrap();
    let conv_layer2 = ConvolutionLayer::new(kernel2, 1, Padding::Valid);
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (2, 3, 9),
        vec![
            4.4468555, 4.904662, 3.804248, 4.340278, 3.167806, 2.3832436, 3.0608237, 2.774675,
            3.0908246, 4.535148, 5.1828823, 4.1378646, 4.810068, 3.8042352, 3.3993318, 3.2907946,
            2.838282, 2.9809828, 5.3439035, 5.194476, 4.1841807, 4.858328, 4.2956176, 3.6722953,
            3.8419654, 3.5909402, 3.4809105, 3.6256964, 4.4968247, 3.0534244, 3.6138248, 3.036902,
            1.8725148, 2.85071, 2.3859847, 2.4175763, 3.5501175, 4.713961, 3.420515, 4.1149707,
            3.5665936, 2.6812232, 2.9107368, 2.1944456, 2.8205285, 4.520949, 4.624674, 3.173178,
            4.3024297, 3.9736187, 2.944067, 3.4690015, 3.049394, 2.7587736,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (1, 5, 12),
        vec![
            0.84374106, 0.03665259, 0.23846498, 0.82509995, 0.97324103, 0.96826524, 0.77620417,
            0.8427075, 0.42989048, 0.76771307, 0.54514444, 0.7878393, 0.21897991, 0.975659,
            0.73295325, 0.69994044, 0.86701024, 0.76087946, 0.623545, 0.14890751, 0.8610666,
            0.21943341, 0.1644093, 0.6089244, 0.8612485, 0.02602104, 0.30423534, 0.5087405,
            0.16869895, 0.3329467, 0.179494, 0.33126613, 0.11996287, 0.21606164, 0.87119263,
            0.33579683, 0.2313126, 0.2576527, 0.3748985, 0.30113342, 0.8142977, 0.423247,
            0.8179498, 0.92175007, 0.21606776, 0.19149332, 0.4240341, 0.14780204, 0.46443272,
            0.00207204, 0.359202, 0.9019851, 0.21363449, 0.6390296, 0.5977058, 0.81350476,
            0.3685356, 0.90738845, 0.7828945, 0.9812083,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 4),
        vec![
            0.6726924, 0.46724817, 0.17302093, 0.39839587, 0.78055173, 0.8576361, 0.7335981,
            0.52934057, 0.9529279, 0.78965247, 0.46750203, 0.08403921, 0.73126566, 0.34934825,
            0.3459232, 0.54770446, 0.68714255, 0.29283327, 0.53392637, 0.8850151, 0.6909357,
            0.44388366, 0.9043074, 0.9949724,
        ],
    )
    .unwrap();
    let conv_layer3 = ConvolutionLayer::new(kernel3, 1, Padding::Valid);
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (2, 3, 9),
        vec![
            3.8968055, 3.546202, 4.109778, 4.453461, 3.9781244, 3.6487749, 3.1652539, 2.8051038,
            3.0797634, 2.8203528, 2.9598289, 3.2583225, 3.3336418, 3.4002569, 3.3906357, 2.9764342,
            2.7612212, 2.6163657, 2.3707204, 2.2147315, 3.184624, 3.6042573, 3.5746267, 3.7276003,
            3.531716, 3.4893005, 2.704533, 3.999104, 3.7355957, 4.0943937, 4.3024592, 3.8195722,
            3.781825, 3.1517377, 3.29204, 3.7859948, 3.2628188, 3.6413682, 3.790121, 3.9211574,
            4.2068067, 3.5657823, 2.7618806, 3.0526435, 2.769556, 3.2679353, 2.7510781, 3.2736335,
            3.930321, 4.2003593, 3.5093803, 3.5338006, 4.3353972, 3.5519054,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (1, 5, 12),
        vec![
            0.64743847, 0.36691284, 0.5396585, 0.5372604, 0.47547424, 0.44373918, 0.34716287,
            0.21774843, 0.9437953, 0.51856595, 0.15765554, 0.9350713, 0.86233217, 0.81734437,
            0.6566154, 0.3879487, 0.28848994, 0.5814131, 0.06870039, 0.78543746, 0.47194287,
            0.12733267, 0.6111727, 0.25675833, 0.74741316, 0.45714313, 0.9649919, 0.57969916,
            0.5208711, 0.93666834, 0.13247305, 0.7087714, 0.17877895, 0.40767, 0.6906785,
            0.9675369, 0.224454, 0.28950995, 0.75431514, 0.99582964, 0.8120864, 0.9536324,
            0.7703749, 0.683158, 0.16371861, 0.42877796, 0.7300311, 0.9456737, 0.05700503,
            0.19623296, 0.44457257, 0.5512328, 0.15101007, 0.25140873, 0.2031063, 0.5537751,
            0.3641559, 0.701937, 0.27669305, 0.85076064,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.00186597, 0.3316532, 0.15485734, 0.35000807, 0.42372492, 0.03995521, 0.5067197,
            0.38907993, 0.37287286, 0.21294773, 0.8646356, 0.10154326, 0.75313085, 0.7910046,
            0.15368015, 0.25977603, 0.40315583, 0.635939, 0.25689796, 0.13678746, 0.43744904,
            0.6658951, 0.564682, 0.70429957, 0.67241764, 0.15790685, 0.25059524, 0.6432024,
            0.60438925, 0.45131883, 0.96080875, 0.40131757, 0.60942906, 0.7035094, 0.6473561,
            0.05433872, 0.7478619, 0.24740443, 0.35665986, 0.00020906, 0.23741227, 0.57013196,
            0.6398819, 0.7132858, 0.90739846, 0.8246988, 0.1319153, 0.6876462, 0.846729,
            0.18134636,
        ],
    )
    .unwrap();
    let conv_layer4 = ConvolutionLayer::new(kernel4, 1, Padding::Valid);
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (2, 1, 8),
        vec![
            5.3822412, 5.171035, 5.593185, 4.978197, 4.903819, 5.207545, 4.112418, 5.5618815,
            6.946043, 7.320447, 6.7540064, 6.2961373, 6.0895905, 5.62924, 5.76301, 6.543895,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (1, 5, 12),
        vec![
            0.9026019, 0.54676574, 0.33139232, 0.83673465, 0.05539654, 0.5554673, 0.9149804,
            0.9791666, 0.9000323, 0.6329186, 0.30872977, 0.30553624, 0.04431259, 0.5287215,
            0.3358437, 0.72178566, 0.72704846, 0.85191244, 0.07464863, 0.867838, 0.5849202,
            0.14913943, 0.18325551, 0.40498126, 0.75359416, 0.01821492, 0.5917236, 0.91982275,
            0.5287654, 0.7151285, 0.38420153, 0.517026, 0.5150141, 0.26934662, 0.7356045,
            0.97902703, 0.6362754, 0.27803296, 0.32063982, 0.83432084, 0.78711736, 0.28247103,
            0.7812688, 0.5270146, 0.4719829, 0.47535485, 0.23715672, 0.4404677, 0.90286416,
            0.66611385, 0.02649495, 0.3193976, 0.16608049, 0.5121102, 0.17436478, 0.313714,
            0.47244504, 0.9906781, 0.9064671, 0.29454133,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972, 0.53866875, 0.6358971,
            0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548, 0.14977625, 0.53714937,
            0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625, 0.4744624, 0.73655206,
            0.42605233, 0.6592577, 0.3237799, 0.42867732, 0.87574345, 0.70010746, 0.01496939,
            0.78416556, 0.61210716, 0.98323476, 0.9316805, 0.05175687, 0.70876056, 0.52122,
            0.68573385, 0.415587, 0.87644994, 0.73337436, 0.5451011, 0.20423086, 0.5554448,
            0.48578474, 0.2764571, 0.9192946, 0.8920509, 0.34320405, 0.4283556, 0.3897719,
            0.06360459,
        ],
    )
    .unwrap();
    let conv_layer5 = ConvolutionLayer::new(kernel5, 1, Padding::Valid);
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (2, 1, 8),
        vec![
            6.580516, 6.662325, 6.14381, 7.405002, 6.104826, 6.562942, 6.0484242, 6.333678,
            7.892889, 6.7333217, 7.663545, 8.168465, 7.6863637, 7.52034, 6.7676144, 7.8605323,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (1, 5, 12),
        vec![
            0.729173, 0.19460331, 0.8634254, 0.6576018, 0.9657459, 0.22873744, 0.47843248,
            0.22157177, 0.9162307, 0.02157675, 0.44649428, 0.2792192, 0.685827, 0.75294507,
            0.7919586, 0.22560763, 0.88778716, 0.80092114, 0.00003577, 0.9737877, 0.9146247,
            0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946, 0.17754778,
            0.41998118, 0.02919354, 0.82382417, 0.4156855, 0.49590722, 0.69720376, 0.7155315,
            0.40795937, 0.15397236, 0.02265206, 0.7090415, 0.75877124, 0.67035425, 0.39483562,
            0.86222315, 0.9993058, 0.84902793, 0.26427644, 0.86764544, 0.24274233, 0.69865257,
            0.5739991, 0.7620597, 0.29289714, 0.88402116, 0.8942853, 0.7757528, 0.16431308,
            0.48939565, 0.56055367, 0.46453193, 0.9573795,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.8899508, 0.16098963, 0.63514715, 0.810474, 0.29953358, 0.46075395, 0.02808736,
            0.59781086, 0.8855644, 0.61877847, 0.9537467, 0.6197168, 0.3379795, 0.13108306,
            0.30692965, 0.33537498, 0.01351478, 0.45529485, 0.6626128, 0.9497022, 0.7403127,
            0.06039312, 0.08292098, 0.80679554, 0.1354166, 0.2560622, 0.80891573, 0.97702754,
            0.4124968, 0.4359102, 0.8733311, 0.1396195, 0.52047473, 0.88564533, 0.29781443,
            0.21130918, 0.83071965, 0.3337948, 0.9783562, 0.42070097, 0.55396014, 0.16172563,
            0.7634967, 0.36205766, 0.48491392, 0.4980414, 0.6001484, 0.65126085, 0.3691911,
            0.11615072,
        ],
    )
    .unwrap();
    let conv_layer6 = ConvolutionLayer::new(kernel6, 1, Padding::Valid);
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (2, 1, 8),
        vec![
            6.8341947, 6.5190096, 7.0832767, 6.181604, 7.480662, 6.5810714, 6.6786747, 5.1772513,
            6.9396563, 6.9239874, 7.7035537, 7.0631847, 7.8825793, 7.5352745, 6.8821344, 6.780336,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (1, 10, 15),
        vec![
            0.26983073, 0.8690525, 0.7446416, 0.471613, 0.72900707, 0.842964, 0.21457537, 0.938401,
            0.41665936, 0.05351101, 0.43856344, 0.7253113, 0.8520324, 0.4151233, 0.35101932,
            0.7388761, 0.3592986, 0.6741479, 0.9965808, 0.3117034, 0.8605703, 0.94308543,
            0.8192489, 0.31478795, 0.750324, 0.36604244, 0.78454614, 0.039194, 0.23696694,
            0.2418382, 0.24788351, 0.5622223, 0.15428482, 0.50688076, 0.37682602, 0.44385925,
            0.00051633, 0.53422695, 0.5675659, 0.53845215, 0.2130759, 0.86445093, 0.432881,
            0.6255918, 0.3942565, 0.07226853, 0.09869356, 0.32627374, 0.8543963, 0.85603166,
            0.25422713, 0.24929269, 0.36793318, 0.39957172, 0.9079535, 0.865758, 0.82237726,
            0.60374194, 0.7658025, 0.0215734, 0.473204, 0.6594781, 0.86392707, 0.8566667,
            0.48541847, 0.54855824, 0.5860555, 0.158874, 0.10558709, 0.19664533, 0.39609066,
            0.27843866, 0.49128443, 0.75033015, 0.35650545, 0.4687038, 0.6159849, 0.2547001,
            0.17250927, 0.07203952, 0.8724657, 0.14018923, 0.12091745, 0.4770398, 0.43290496,
            0.6356798, 0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018, 0.10666513,
            0.06810815, 0.79673207, 0.29373887, 0.55241185, 0.23906927, 0.18915932, 0.02753429,
            0.1438574, 0.5419741, 0.71984386, 0.12837073, 0.55637455, 0.14355855, 0.10225686,
            0.8755492, 0.62895286, 0.21388301, 0.30016333, 0.49605927, 0.8245107, 0.4528765,
            0.6836941, 0.28745723, 0.5031258, 0.26911622, 0.92149794, 0.7165893, 0.04745785,
            0.55642486, 0.34654748, 0.83168656, 0.8410765, 0.7668131, 0.84094906, 0.6012723,
            0.9256995, 0.66010624, 0.43380973, 0.62281454, 0.45852852, 0.61445725, 0.524579,
            0.06486581, 0.14233574, 0.13930365, 0.5838787, 0.45914945, 0.30819193, 0.70949817,
            0.8803759, 0.6927248, 0.50569826, 0.7358748, 0.58652496, 0.85065925, 0.3247378,
            0.6760192, 0.4483504,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 4),
        vec![
            0.59195757, 0.37883574, 0.7796499, 0.32748002, 0.44507304, 0.7488422, 0.14428215,
            0.8785777, 0.15468395, 0.6638725, 0.30651525, 0.9492515, 0.55669755, 0.08302987,
            0.45890567, 0.05946975, 0.9099885, 0.30235246, 0.24214035, 0.42138377, 0.38782486,
            0.21880285, 0.9182205, 0.85290706,
        ],
    )
    .unwrap();
    let conv_layer7 = ConvolutionLayer::new(kernel7, 1, Padding::Valid);
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (2, 8, 12),
        vec![
            3.7347486, 3.1878178, 4.208469, 3.377652, 3.7247229, 3.7038794, 3.6025903, 2.7556212,
            3.6215928, 2.6986458, 3.6322553, 2.8030272, 3.4121382, 3.423457, 3.3154142, 3.275103,
            3.2104857, 3.0790708, 3.5821848, 3.659057, 4.1695366, 3.6519644, 3.5681827, 2.6719894,
            3.1388128, 3.4723842, 3.2262552, 3.2452595, 2.2668707, 2.1921346, 2.4785163, 2.9063826,
            3.2269592, 3.7617705, 3.8660183, 3.1777546, 2.9193592, 3.004662, 3.849675, 2.9237401,
            2.5169678, 2.1792622, 2.1227458, 2.958234, 3.3001304, 3.5090423, 4.2440147, 3.272935,
            3.2995338, 2.6823618, 3.5673847, 2.4048893, 2.480977, 1.963317, 1.4634914, 2.0551758,
            2.7838326, 2.3570256, 3.824675, 2.6475742, 2.8629453, 1.9941843, 2.5148323, 2.8869205,
            2.3255208, 2.7083514, 1.9315249, 2.489357, 2.7284, 3.191407, 3.670229, 2.9893174,
            3.1219714, 3.5529952, 3.3916228, 3.6755157, 3.393322, 3.517896, 2.6607363, 2.9146957,
            2.5739307, 3.4512722, 3.1508443, 2.6116714, 3.048047, 3.4361644, 3.8623743, 3.8240397,
            4.473932, 4.1076107, 4.173605, 3.6572614, 3.6593926, 3.2100294, 3.9197009, 2.8594947,
            2.7494645, 2.747481, 3.0865886, 3.0166104, 2.4469035, 3.4886532, 2.9875455, 2.7917738,
            2.684212, 2.8680792, 2.6025403, 2.9116313, 2.5342438, 3.1959624, 2.5405362, 2.6792827,
            2.3591685, 2.5564268, 2.626917, 3.528454, 3.3973122, 3.5682127, 2.8479197, 2.9708884,
            2.6720088, 2.982297, 2.6330252, 3.162104, 2.3318052, 1.6671458, 1.6812949, 2.2477036,
            2.3893163, 3.1190386, 3.2372203, 3.1616473, 2.1467073, 2.3128052, 3.0012097, 2.9876652,
            1.9010723, 2.0011122, 1.9845426, 2.1881256, 2.6261046, 2.7736855, 3.199087, 3.242267,
            2.5521731, 2.608912, 2.4180925, 2.337296, 1.6240579, 1.9635669, 1.143741, 1.5116969,
            2.4671865, 2.115266, 2.7426953, 2.7077148, 2.4578557, 1.8114488, 1.8372644, 2.8664129,
            2.1242826, 2.585333, 1.9665859, 1.8053596, 2.1612182, 2.4354138, 3.271007, 2.805192,
            2.853708, 3.3559966, 3.118373, 3.267565, 2.9669893, 3.384985, 2.755746, 2.5392601,
            2.5769799, 2.579853, 2.8712738, 2.2415552, 2.6113157, 2.6154778, 3.3013375, 3.5227377,
            3.775288, 3.5776355, 3.5821059, 3.435417, 3.3484738, 2.8049111, 3.1315126, 2.7194872,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (1, 10, 15),
        vec![
            0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431, 0.2624427, 0.6557088, 0.00633,
            0.6603214, 0.45500925, 0.6523986, 0.14666249, 0.32440838, 0.2805719, 0.42671442,
            0.74477625, 0.9118973, 0.5335283, 0.36968935, 0.5693756, 0.36426732, 0.11819325,
            0.95361024, 0.13343851, 0.5940242, 0.7282295, 0.9320007, 0.46956548, 0.5087874,
            0.7952918, 0.73709416, 0.3358689, 0.03185032, 0.27057356, 0.26166973, 0.5843129,
            0.5337139, 0.19571388, 0.1192536, 0.75616854, 0.97167397, 0.71154076, 0.26672947,
            0.07128377, 0.3383284, 0.8008563, 0.9504947, 0.5971434, 0.7847773, 0.92326206,
            0.24163638, 0.12968542, 0.5954836, 0.6734995, 0.08627631, 0.7485715, 0.8782484,
            0.6863155, 0.7264353, 0.08944888, 0.68172634, 0.4284322, 0.48237634, 0.6856524,
            0.04009921, 0.0687674, 0.9063645, 0.42620143, 0.61030614, 0.10040135, 0.50107217,
            0.763057, 0.25769317, 0.8816114, 0.7770131, 0.23345616, 0.62762326, 0.15315741,
            0.73589575, 0.2752067, 0.85641515, 0.7439484, 0.6581306, 0.4056261, 0.13899311,
            0.26460668, 0.9179794, 0.96651816, 0.89336777, 0.18948041, 0.9371178, 0.7124811,
            0.9657549, 0.6203675, 0.32684848, 0.11439406, 0.07654371, 0.95680344, 0.9728639,
            0.6055871, 0.00439729, 0.8525613, 0.3167563, 0.13499211, 0.68338645, 0.7955047,
            0.21689218, 0.2826704, 0.12328367, 0.6890043, 0.5906649, 0.41700745, 0.30266365,
            0.5716598, 0.12726787, 0.35587692, 0.16889893, 0.3114892, 0.1309899, 0.24026695,
            0.55435276, 0.34375766, 0.4225387, 0.37165096, 0.6202945, 0.6069533, 0.05756181,
            0.0153275, 0.8497578, 0.79796964, 0.4071996, 0.19325097, 0.04944435, 0.59729165,
            0.39304134, 0.679002, 0.6126854, 0.67232877, 0.7156292, 0.09058711, 0.33372015,
            0.8941644, 0.30899736, 0.3348802, 0.6412177, 0.26750943, 0.03709449, 0.56803024,
            0.8756273, 0.5771133,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 4),
        vec![
            0.56024176, 0.5868575, 0.75167763, 0.36936092, 0.37185487, 0.35425207, 0.24336162,
            0.01027582, 0.2671537, 0.83992416, 0.49819484, 0.7831867, 0.70054483, 0.8701863,
            0.49413827, 0.84670645, 0.8069649, 0.093459, 0.93408287, 0.8206956, 0.70209366,
            0.32817394, 0.744203, 0.39091238,
        ],
    )
    .unwrap();
    let conv_layer8 = ConvolutionLayer::new(kernel8, 1, Padding::Valid);
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (2, 8, 12),
        vec![
            2.780482, 2.299995, 2.2899082, 2.3137786, 2.1324034, 1.9865441, 2.41443, 2.818144,
            3.33672, 3.1598835, 2.5654533, 2.000575, 3.8180203, 3.386436, 2.7236657, 2.4067965,
            2.390617, 2.492361, 2.188062, 2.991114, 3.1841636, 4.062317, 4.023354, 3.096853,
            2.841129, 2.1649618, 2.0949745, 2.581493, 2.283389, 2.5893295, 2.1895702, 2.6645606,
            3.0706038, 3.1749477, 3.5463593, 2.9491866, 3.517088, 3.1898026, 3.4779296, 2.9433012,
            2.9196286, 2.863716, 2.660283, 2.2674775, 2.7832081, 3.2781644, 4.270317, 3.721968,
            3.4189706, 3.0894203, 2.1530824, 1.9385324, 2.4659636, 3.196022, 3.6467226, 2.660342,
            2.7716858, 2.2361164, 2.896639, 3.527804, 2.3603997, 2.7541053, 2.685394, 3.0999274,
            2.7745743, 2.9799705, 2.519744, 2.559954, 2.0020998, 2.378667, 2.6202905, 2.8523064,
            3.279325, 2.8885326, 2.72502, 2.059335, 1.9474268, 2.518105, 3.0386198, 3.3477764,
            2.8161087, 2.007602, 1.8235978, 1.9234661, 2.8569665, 2.1647487, 2.49995, 2.7114978,
            2.6097033, 2.5292451, 2.2972322, 2.1300516, 2.2149596, 1.8700228, 1.8904599, 2.0786378,
            3.888703, 3.6065857, 3.1525645, 2.9785013, 2.948479, 3.39959, 2.796358, 4.409916,
            4.24655, 4.520543, 3.6555367, 3.5813098, 4.3953123, 4.3176174, 3.5185378, 3.345632,
            3.5634167, 2.662969, 3.4838965, 4.3630853, 4.8194356, 4.720632, 4.750768, 4.3470993,
            4.2366624, 3.9168963, 3.1181464, 3.1096337, 3.3905315, 3.289015, 3.3732553, 3.4457855,
            4.928343, 4.379439, 4.5540643, 4.157226, 4.7226806, 4.565338, 3.1979022, 4.4826665,
            3.945718, 3.679594, 3.5331018, 3.3877273, 4.1427407, 4.024427, 5.2383127, 5.4488153,
            4.516348, 3.9332976, 3.3345013, 4.0045834, 3.1318347, 4.470298, 3.8756964, 3.6629496,
            3.9677901, 4.074111, 4.395517, 4.7435637, 4.5307555, 3.2886627, 3.8278546, 3.4241946,
            4.100321, 4.7078743, 3.8362014, 3.1729856, 3.6325798, 3.5986192, 3.296392, 3.9027672,
            4.268158, 3.7039468, 3.9602454, 2.8368926, 3.109111, 3.499375, 3.8726983, 3.5710952,
            4.113853, 2.523942, 2.33681, 2.753233, 3.6271434, 3.4341264, 3.5038836, 3.4330103,
            3.041971, 3.5057364, 3.6713316, 3.1536472, 2.788471, 2.4367566, 2.5091598, 2.7882943,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (1, 10, 15),
        vec![
            0.43911496, 0.92919487, 0.29325068, 0.62813336, 0.8131431, 0.19520658, 0.47931832,
            0.42483747, 0.47526902, 0.28184402, 0.09741595, 0.45691565, 0.44086096, 0.9638409,
            0.33859608, 0.26381832, 0.29839757, 0.68755937, 0.09156765, 0.58584654, 0.04617033,
            0.14705709, 0.81179595, 0.16751295, 0.06864621, 0.6308731, 0.38993102, 0.3644169,
            0.68174505, 0.272409, 0.23609333, 0.21866773, 0.80119157, 0.01742986, 0.49270406,
            0.37920174, 0.90869635, 0.8191268, 0.7636344, 0.7827788, 0.9694966, 0.79533535,
            0.00732174, 0.8372113, 0.9449071, 0.7670253, 0.50964797, 0.7843069, 0.7365313,
            0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833, 0.5585159,
            0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028, 0.52249014,
            0.5252596, 0.33191478, 0.3388958, 0.18619475, 0.6839338, 0.72234726, 0.25884646,
            0.7980101, 0.36219832, 0.7046317, 0.9284394, 0.468965, 0.23158234, 0.32747796,
            0.9097073, 0.7440483, 0.03255624, 0.30697423, 0.6246821, 0.1907446, 0.9843364,
            0.4038572, 0.5747709, 0.65160054, 0.6822517, 0.9840877, 0.18341686, 0.5288406,
            0.92906404, 0.87780553, 0.9090181, 0.82569945, 0.20383635, 0.7166643, 0.17061436,
            0.91526777, 0.08598401, 0.70100874, 0.40537685, 0.5971982, 0.92796123, 0.15859716,
            0.7859081, 0.8564488, 0.35816404, 0.79062706, 0.9644883, 0.13154314, 0.31929043,
            0.80048305, 0.07180241, 0.52815664, 0.45786336, 0.91537887, 0.9783313, 0.25753945,
            0.42799363, 0.07738555, 0.9294206, 0.07022415, 0.60058224, 0.6196278, 0.9008346,
            0.04155485, 0.82207745, 0.41282526, 0.9949608, 0.3109271, 0.47614527, 0.7615821,
            0.35893062, 0.07713356, 0.6123928, 0.62511915, 0.88098776, 0.21521498, 0.89468116,
            0.1842307, 0.10784956, 0.8354833, 0.2630701, 0.7184675, 0.06132602, 0.06056971,
            0.71349823, 0.00944792, 0.07349233,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 4),
        vec![
            0.35231608, 0.8533961, 0.17608605, 0.18067755, 0.51991457, 0.19053963, 0.5045173,
            0.7456122, 0.27621788, 0.48649722, 0.39297876, 0.54849166, 0.3746991, 0.8194284,
            0.34880427, 0.79505837, 0.41293454, 0.890512, 0.12076204, 0.20799449, 0.88948244,
            0.24437675, 0.7731474, 0.65954226,
        ],
    )
    .unwrap();
    let conv_layer9 = ConvolutionLayer::new(kernel9, 1, Padding::Valid);
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (2, 8, 12),
        vec![
            2.2179904, 2.3315828, 2.1541247, 2.2203295, 2.7340539, 2.512558, 2.4118114, 3.0186412,
            2.6258488, 1.9713206, 2.8872962, 2.6578612, 2.2388425, 2.6582534, 2.729497, 2.9641812,
            2.9161203, 2.9782305, 3.2499208, 3.168777, 2.823537, 2.48063, 2.7656431, 2.9147782,
            2.9205782, 3.010434, 2.744308, 2.8820946, 2.657655, 3.496858, 3.3122025, 3.1498587,
            3.3112946, 3.058663, 3.1842663, 2.5574625, 3.1764307, 2.9362128, 2.778469, 2.5276165,
            2.5639496, 3.434347, 2.3547146, 3.2571626, 2.899968, 2.7525597, 3.5855064, 2.8402884,
            3.7225473, 3.0887113, 2.7330477, 2.7012925, 1.797764, 2.6120567, 2.6698918, 2.8768954,
            2.8383691, 2.971882, 3.5175285, 2.9333403, 3.436442, 4.0036983, 3.1495614, 2.6384044,
            2.2697525, 2.4093556, 2.3556871, 2.6260817, 3.017344, 2.963837, 3.5889342, 2.9939575,
            3.4705276, 3.8839982, 3.2379615, 2.9336932, 2.982973, 2.2839806, 2.4427242, 3.0101597,
            2.625431, 3.3918586, 2.7775025, 2.64129, 2.8517764, 3.3590496, 2.9304218, 2.7245376,
            2.618022, 2.2475631, 2.96577, 2.4336388, 2.1176558, 2.9428108, 2.397508, 2.3192177,
            2.89875, 3.051196, 2.8571675, 2.9749374, 3.2129648, 2.9711723, 3.850851, 3.5081346,
            3.2385323, 2.9612794, 3.7390985, 3.7420976, 2.9475493, 3.7648108, 3.077527, 3.4800906,
            3.4759872, 3.5786202, 4.000705, 3.2327545, 3.6436205, 3.304195, 3.663421, 2.6695902,
            3.2223113, 3.6742647, 3.113282, 3.442488, 3.6793137, 4.5741587, 3.6762118, 4.5680532,
            4.2620196, 3.2966332, 4.445911, 3.614744, 4.1896424, 3.6610048, 3.8713243, 3.8417614,
            2.7844195, 3.7092028, 3.4923837, 3.6150825, 3.728529, 3.5418448, 3.7983494, 3.6811655,
            4.118481, 4.474904, 3.8931804, 2.8788784, 2.8635738, 3.0952556, 3.1621428, 3.6008327,
            3.6646063, 3.2917466, 4.480778, 3.7719898, 4.311499, 4.6971273, 3.864298, 3.4447777,
            2.9426508, 3.270667, 2.514562, 3.9574933, 3.192455, 4.159601, 4.24249, 3.6712387,
            4.0296326, 4.726534, 3.802086, 4.3352757, 2.9281216, 3.620382, 2.9724143, 3.7611914,
            2.8906631, 3.994116, 3.9353366, 3.3983698, 4.2633686, 3.8325293, 3.698533, 2.9271684,
            3.9263043, 2.2510393, 3.2039206, 3.2023075, 3.0371885, 3.7453103, 2.8139057, 2.792992,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (1, 10, 15),
        vec![
            0.4922565, 0.5211581, 0.97382414, 0.9779564, 0.1754263, 0.4551989, 0.81067127,
            0.7095975, 0.5087082, 0.78796804, 0.03310984, 0.20805901, 0.45704818, 0.9133983,
            0.5689028, 0.04247752, 0.55938286, 0.9835293, 0.04525762, 0.7176199, 0.82096803,
            0.5575717, 0.5744108, 0.9780689, 0.34563604, 0.3324931, 0.8797563, 0.14932355,
            0.1134909, 0.5645703, 0.30096474, 0.4096875, 0.5703153, 0.88738924, 0.6242374,
            0.77620894, 0.681929, 0.24701218, 0.74485576, 0.61556435, 0.63869125, 0.05875124,
            0.3210932, 0.96946657, 0.09463912, 0.6275637, 0.34162354, 0.74390864, 0.8736778,
            0.9513908, 0.24045336, 0.7003475, 0.87750345, 0.16564246, 0.6314963, 0.21785556,
            0.7654987, 0.13988015, 0.03287261, 0.82226163, 0.60896695, 0.13331373, 0.62307173,
            0.23316076, 0.9600204, 0.55291533, 0.29808274, 0.8765127, 0.98263544, 0.27148733,
            0.11101003, 0.2754741, 0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813,
            0.62585706, 0.18621969, 0.5836321, 0.17965508, 0.81336415, 0.94554824, 0.28304926,
            0.32718146, 0.46701643, 0.91682273, 0.6142979, 0.19277428, 0.28408903, 0.25507236,
            0.9800453, 0.36125833, 0.96792, 0.33258557, 0.9508625, 0.8424581, 0.8130291, 0.7774976,
            0.17691322, 0.9389267, 0.22419459, 0.33442205, 0.7614585, 0.37563834, 0.70754576,
            0.1499497, 0.9873837, 0.7166968, 0.40278858, 0.22288306, 0.3279577, 0.07722609,
            0.598755, 0.8143903, 0.87905455, 0.83061284, 0.9923988, 0.6196494, 0.536406,
            0.06662867, 0.83588266, 0.28182983, 0.662181, 0.99850965, 0.60448396, 0.12318801,
            0.91713256, 0.8540598, 0.19103892, 0.5929614, 0.9118344, 0.9381113, 0.3421722,
            0.8149188, 0.9595595, 0.02717085, 0.8916309, 0.9755575, 0.27588442, 0.59208006,
            0.00008138, 0.9552037, 0.12578069, 0.01249961, 0.05413999, 0.5153533, 0.40144867,
            0.8698811, 0.6468678,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.8840439, 0.34315115, 0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905,
            0.9444794, 0.6930413, 0.90735817, 0.91156703, 0.45996496, 0.9045769, 0.17170428,
            0.43418503, 0.69308424, 0.42869946, 0.9244341, 0.41451567, 0.6224708, 0.00536506,
            0.33826837, 0.47926104, 0.0032256, 0.02230139, 0.35960108, 0.48593593, 0.86064774,
            0.28908366, 0.4153976, 0.3468706, 0.2242362, 0.93169004, 0.3198661, 0.5576108,
            0.17364207, 0.69407916, 0.88076496, 0.11111139, 0.19382912, 0.9307082, 0.9188555,
            0.10532705, 0.88550454, 0.20754221, 0.97926295, 0.3472928, 0.71126235, 0.03633394,
            0.7482733,
        ],
    )
    .unwrap();
    let conv_layer10 = ConvolutionLayer::new(kernel10, 1, Padding::Valid);
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (2, 6, 11),
        vec![
            8.033428, 8.543707, 9.789215, 9.397728, 8.928415, 8.752485, 8.155999, 7.627435,
            6.3328834, 6.491287, 5.776259, 8.1459, 8.25724, 9.776707, 8.34656, 9.640185, 8.99126,
            7.782528, 7.5838423, 6.428096, 6.094316, 5.357272, 9.156363, 7.8959517, 9.262684,
            8.762065, 9.015499, 8.503002, 8.1895, 7.4369364, 6.483993, 6.3236303, 5.688987,
            9.09409, 8.550843, 8.486354, 8.987477, 9.195248, 8.061927, 8.147293, 8.141501,
            6.6464286, 5.8249335, 6.253682, 8.650627, 8.044335, 7.860739, 8.202483, 8.413835,
            7.9693823, 8.447446, 7.962065, 8.523188, 7.3739343, 7.5536585, 8.456281, 9.162608,
            8.63003, 8.836363, 8.238938, 7.52404, 8.43978, 8.298083, 8.480743, 8.0151, 8.740099,
            7.9137034, 7.301816, 8.092043, 8.329255, 8.602493, 6.8657255, 7.4513383, 6.788501,
            6.0729456, 4.6042304, 4.0885506, 7.4365363, 7.644456, 7.9597054, 7.1230593, 8.179664,
            7.3555117, 7.224636, 7.3629746, 5.812419, 5.2729974, 4.7235622, 7.366258, 8.661767,
            7.45816, 8.464425, 7.636144, 7.2892885, 8.355993, 6.927382, 5.8689938, 5.2323437,
            5.4647465, 8.523498, 6.5168314, 8.340091, 7.1063957, 7.3587723, 8.044722, 7.0575233,
            7.0493197, 6.1084633, 6.6692348, 7.036621, 6.974544, 6.8951864, 7.2729564, 7.5973134,
            7.4482226, 7.1573057, 7.0634828, 7.207251, 7.6652083, 7.0349994, 7.1199536, 7.5363293,
            8.049603, 6.712283, 7.8877916, 6.9251184, 6.515132, 5.7637935, 7.474823, 6.8735166,
            6.9006615, 7.2263155,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (1, 10, 15),
        vec![
            0.28782296, 0.7382309, 0.60003114, 0.3259743, 0.85578996, 0.14142898, 0.39191914,
            0.05517358, 0.6050927, 0.968827, 0.47373444, 0.76571184, 0.50472075, 0.53850234,
            0.05837096, 0.56728834, 0.3979838, 0.2393961, 0.36507484, 0.01646563, 0.27730468,
            0.62646276, 0.94121945, 0.66457146, 0.8425775, 0.4301739, 0.68211764, 0.6059688,
            0.7629583, 0.56038123, 0.48163053, 0.437191, 0.43973154, 0.29997745, 0.21913478,
            0.6611514, 0.209788, 0.176356, 0.88925517, 0.14793599, 0.36509594, 0.5616029,
            0.6617385, 0.30053073, 0.36820948, 0.62227124, 0.4957459, 0.69923055, 0.3227648,
            0.9702412, 0.5679234, 0.13432135, 0.7430913, 0.19231908, 0.26170298, 0.10480803,
            0.00958306, 0.20726651, 0.20851518, 0.17973869, 0.23704103, 0.1163867, 0.2735905,
            0.8537909, 0.40303, 0.75797635, 0.34342998, 0.74670875, 0.82946825, 0.91931367,
            0.9654975, 0.18782942, 0.10021565, 0.05109123, 0.3069365, 0.10895161, 0.9891213,
            0.62504834, 0.507994, 0.47125, 0.84314245, 0.6054993, 0.92367506, 0.6953895,
            0.37023902, 0.67128026, 0.43450755, 0.28869846, 0.27641538, 0.8369712, 0.6856483,
            0.26890948, 0.65425915, 0.84581685, 0.51146317, 0.48995435, 0.52071315, 0.80564773,
            0.670521, 0.3835857, 0.47078377, 0.5100531, 0.82525116, 0.02126783, 0.9583153,
            0.23316967, 0.9487504, 0.9609589, 0.95734006, 0.00943314, 0.7521432, 0.46106157,
            0.84370506, 0.16933449, 0.71423984, 0.5316646, 0.6400151, 0.9638914, 0.69432026,
            0.8581641, 0.70813745, 0.2836983, 0.33953485, 0.8950543, 0.20262088, 0.81930757,
            0.09556881, 0.22266188, 0.63842744, 0.8304186, 0.12425002, 0.7582065, 0.09737789,
            0.84872884, 0.17490041, 0.37569723, 0.6669188, 0.8970669, 0.22398192, 0.29424527,
            0.56277037, 0.41113177, 0.7882464, 0.24159203, 0.5460915, 0.29690132, 0.3142075,
            0.7648111, 0.04421633, 0.9636684,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.98529965, 0.26998708, 0.13811645, 0.9724998, 0.41856614, 0.13321315, 0.0937838,
            0.4742414, 0.79873264, 0.1621314, 0.5493846, 0.6481355, 0.05176858, 0.17029643,
            0.955536, 0.089831, 0.05664136, 0.9231865, 0.98567015, 0.01680515, 0.54690886,
            0.8593988, 0.6496963, 0.8382851, 0.2400014, 0.36792266, 0.01756373, 0.6596718,
            0.5680892, 0.19350345, 0.4854058, 0.7869872, 0.12335967, 0.14544043, 0.25711668,
            0.05608724, 0.18204254, 0.9562488, 0.44598028, 0.3229758, 0.8930679, 0.24216229,
            0.21437034, 0.38366762, 0.64894366, 0.8650639, 0.7790032, 0.3529938, 0.37360683,
            0.26240814,
        ],
    )
    .unwrap();
    let conv_layer11 = ConvolutionLayer::new(kernel11, 1, Padding::Valid);
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (2, 6, 11),
        vec![
            4.876691, 6.063603, 5.658302, 4.881967, 6.7657723, 6.306745, 6.3666105, 6.449594,
            6.4192977, 5.5320272, 4.683007, 6.3151245, 5.8431144, 5.6245685, 6.654567, 6.5282884,
            7.080645, 7.1257606, 6.988107, 5.973315, 5.073843, 4.2709937, 5.6776314, 6.1879625,
            6.8299417, 6.2098475, 6.934838, 7.540652, 5.845576, 5.606403, 5.9242344, 4.950541,
            4.435086, 7.648298, 8.16425, 7.0727067, 6.3137293, 7.666835, 6.8233275, 6.640697,
            6.4552374, 5.0510654, 5.5247912, 5.3341565, 6.9614744, 5.571265, 6.7724195, 7.1054587,
            6.9259214, 6.9466925, 6.5552835, 7.3149304, 6.7758327, 5.5938854, 6.577787, 6.200744,
            7.6723228, 7.0159955, 6.335934, 5.913667, 6.948632, 6.8866963, 6.3826785, 6.1338553,
            5.9015036, 5.9882298, 4.668734, 4.600444, 4.8386235, 4.6816044, 5.034402, 5.0524244,
            5.902385, 5.9059043, 5.535446, 5.5213118, 4.3753266, 4.853888, 5.250426, 4.9610415,
            5.5804358, 5.921758, 6.605887, 5.6381974, 6.0615, 4.795136, 4.407713, 4.79993,
            5.024999, 6.266167, 5.7869515, 6.434239, 5.730167, 6.021018, 6.3032904, 5.896043,
            5.298701, 3.6969898, 4.0604415, 5.8151317, 6.039066, 6.861375, 6.4880137, 6.014522,
            6.220093, 5.624697, 5.7565165, 5.4301543, 4.9925966, 4.964553, 5.55009, 6.529348,
            6.0581536, 6.367696, 5.2656145, 6.749188, 5.964731, 6.4353576, 5.846209, 5.456548,
            5.4544716, 5.834826, 6.23103, 5.431202, 5.8705387, 5.339422, 6.484441, 5.0282025,
            5.7597694, 5.433616, 5.434558, 5.1956854,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (1, 10, 15),
        vec![
            0.554433, 0.90017563, 0.6817857, 0.95833224, 0.28551313, 0.85106283, 0.70093375,
            0.4791875, 0.5805011, 0.9803199, 0.97033703, 0.48236644, 0.66855663, 0.35855147,
            0.25242767, 0.6717967, 0.26290378, 0.53677225, 0.18097793, 0.07985484, 0.79416144,
            0.7215235, 0.42313012, 0.6529702, 0.00384528, 0.08442257, 0.7838985, 0.980683,
            0.36212954, 0.61172485, 0.5263662, 0.8496614, 0.13177402, 0.9175598, 0.04323238,
            0.03087392, 0.03482862, 0.36226457, 0.6059544, 0.29194582, 0.34645593, 0.9409913,
            0.60953087, 0.8610255, 0.1627552, 0.8939359, 0.66327935, 0.48094535, 0.06551108,
            0.86129206, 0.65446067, 0.9592776, 0.8000413, 0.21450381, 0.6442533, 0.46971878,
            0.84573215, 0.34651902, 0.18830031, 0.57119006, 0.27269888, 0.7915957, 0.21737069,
            0.04463017, 0.393406, 0.8441482, 0.77705365, 0.6315176, 0.8522896, 0.16809769,
            0.22305161, 0.773223, 0.9678148, 0.2237789, 0.8982615, 0.271913, 0.34780893,
            0.49277794, 0.14560463, 0.33638617, 0.1585067, 0.18610527, 0.6963084, 0.9429821,
            0.40789625, 0.20056698, 0.37306353, 0.9367061, 0.7103306, 0.06833509, 0.48335183,
            0.45182207, 0.96346164, 0.00378525, 0.33689302, 0.28288215, 0.75004077, 0.1607512,
            0.514175, 0.35879079, 0.36688787, 0.00774159, 0.15532039, 0.01133456, 0.94680935,
            0.052598, 0.73530346, 0.8096563, 0.7097644, 0.37942106, 0.38656324, 0.13763146,
            0.99930644, 0.67476803, 0.06055127, 0.8463604, 0.4460729, 0.33209085, 0.94373864,
            0.5397614, 0.05766413, 0.64256257, 0.7357459, 0.09256811, 0.8832945, 0.03911254,
            0.782554, 0.4004812, 0.80732703, 0.8010379, 0.28867772, 0.7802926, 0.9490529,
            0.5395702, 0.1369102, 0.4513485, 0.1162144, 0.9589836, 0.24819064, 0.3149064,
            0.22322156, 0.39812055, 0.45308354, 0.5711523, 0.97817534, 0.06805564, 0.5386646,
            0.6699801, 0.1879456, 0.8407316,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.64728755, 0.53731096, 0.63207716, 0.00916763, 0.46754488, 0.8670982, 0.1932068,
            0.43971533, 0.10441232, 0.46486124, 0.22910197, 0.7679019, 0.23872072, 0.03931138,
            0.8551502, 0.19610135, 0.8555064, 0.08035298, 0.05671094, 0.9091975, 0.27582648,
            0.33816597, 0.42012835, 0.7745094, 0.14011143, 0.47505257, 0.98297566, 0.5085966,
            0.22395916, 0.01153891, 0.669607, 0.12918296, 0.55476546, 0.528783, 0.5067741,
            0.14234911, 0.5152856, 0.6446142, 0.9118427, 0.8193508, 0.989135, 0.7842302,
            0.59264964, 0.35247177, 0.48483032, 0.22649786, 0.04158387, 0.5814206, 0.8653732,
            0.4524277,
        ],
    )
    .unwrap();
    let conv_layer12 = ConvolutionLayer::new(kernel12, 1, Padding::Valid);
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (2, 6, 11),
        vec![
            5.3107734, 5.211261, 5.3340254, 5.672054, 5.198199, 6.2276707, 5.614281, 5.7822795,
            6.0926485, 5.6020665, 5.9319825, 4.984781, 5.0010657, 3.7240176, 4.9041433, 5.3341436,
            5.474585, 5.017594, 5.743192, 5.2002625, 4.5105696, 6.3836064, 4.9371448, 4.8201246,
            3.9797196, 4.683807, 5.322674, 4.4726214, 4.9149485, 6.138464, 4.931557, 4.475506,
            4.706891, 5.126686, 5.178453, 4.4939103, 4.3280463, 6.0147824, 5.9756956, 5.1984053,
            5.6922336, 5.2778244, 4.2936263, 5.3808746, 4.4181623, 5.146116, 4.1361694, 4.5884233,
            5.533588, 4.771683, 6.1394634, 5.319159, 5.2471733, 5.3026633, 5.5924444, 5.273891,
            4.294843, 4.7323437, 4.2804728, 4.619966, 4.4839277, 6.128765, 5.4228005, 5.653771,
            5.021068, 4.605705, 6.668212, 5.924083, 6.493813, 6.330224, 7.2528296, 7.3989253,
            6.5095673, 6.706409, 7.9608, 8.213059, 7.329239, 5.3455086, 5.6857734, 4.6566463,
            6.0274324, 7.1898594, 7.618757, 6.487721, 6.399234, 6.648927, 6.276092, 7.158944,
            5.6226516, 5.2197323, 6.293778, 5.7222533, 6.3138127, 5.702213, 5.9970894, 6.585789,
            6.30763, 5.7443027, 6.5349135, 5.785467, 5.6509705, 5.206588, 5.5014853, 7.6061397,
            7.6335173, 6.684392, 5.6378546, 6.6334887, 6.0412946, 6.555758, 5.472704, 5.564082,
            5.344794, 5.571376, 6.8111634, 6.878884, 6.9059553, 6.5125804, 5.987538, 5.944148,
            6.630199, 6.193547, 5.3752866, 5.6399174, 4.727279, 6.27019, 5.922508, 7.5554466,
            6.7334037, 6.385823, 6.266476, 6.470974,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (1, 15, 10),
        vec![
            0.44947338, 0.5519129, 0.79122764, 0.7513198, 0.9315116, 0.03313805, 0.41213843,
            0.45310238, 0.01799934, 0.4328227, 0.23842481, 0.20688592, 0.57869387, 0.9324833,
            0.43915927, 0.53123087, 0.5324186, 0.4149537, 0.22217223, 0.0080786, 0.65063345,
            0.7681623, 0.8421627, 0.27179125, 0.68530315, 0.9955617, 0.77906156, 0.18006648,
            0.5975193, 0.6555531, 0.9498266, 0.9690994, 0.5122471, 0.3840358, 0.8757204, 0.7260429,
            0.04691354, 0.40678895, 0.35535267, 0.19270384, 0.23519029, 0.6665529, 0.26402712,
            0.55168146, 0.08576613, 0.9567203, 0.57141143, 0.20602623, 0.75538653, 0.96776,
            0.44755465, 0.82362133, 0.29203537, 0.30861592, 0.39762703, 0.26186082, 0.9658112,
            0.27424002, 0.50570756, 0.8114843, 0.5536027, 0.59788686, 0.05054026, 0.28394443,
            0.6402348, 0.02258505, 0.60607, 0.6834324, 0.8004999, 0.3349493, 0.4295082, 0.37033585,
            0.0394791, 0.50698835, 0.29841292, 0.9388161, 0.84357476, 0.29760668, 0.25654384,
            0.71037215, 0.14646496, 0.9906275, 0.9552909, 0.7966291, 0.6094893, 0.7271988,
            0.09518696, 0.3957746, 0.6157527, 0.31079137, 0.46793708, 0.8514491, 0.86081386,
            0.8208274, 0.2372746, 0.6977758, 0.79387194, 0.9463199, 0.99063903, 0.29514915,
            0.8795419, 0.741553, 0.03520088, 0.83411527, 0.47134155, 0.26704508, 0.2872401,
            0.04289522, 0.583651, 0.94414073, 0.5729697, 0.72244126, 0.7707775, 0.02079507,
            0.22973806, 0.18128674, 0.05054512, 0.6523751, 0.27093726, 0.32479268, 0.53774405,
            0.08921466, 0.18494032, 0.78120434, 0.15868789, 0.81183356, 0.21792394, 0.6620494,
            0.6886836, 0.39724785, 0.59319293, 0.02472531, 0.21891202, 0.5342134, 0.4041879,
            0.53426075, 0.20461221, 0.29362342, 0.7835011, 0.47930118, 0.2895624, 0.7320774,
            0.55179524, 0.37774232, 0.04187773, 0.23883641, 0.63051957, 0.97746944, 0.6415133,
            0.4162999,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 4),
        vec![
            0.04763152, 0.75958186, 0.13098118, 0.6238241, 0.4102024, 0.5710282, 0.59153587,
            0.66274744, 0.6454271, 0.8120847, 0.22876394, 0.6206928, 0.19057496, 0.4622738,
            0.9772445, 0.17967562, 0.27354005, 0.48198408, 0.09082693, 0.6217685, 0.0965838,
            0.8904992, 0.5337058, 0.17222154,
        ],
    )
    .unwrap();
    let conv_layer13 = ConvolutionLayer::new(kernel13, 1, Padding::Valid);
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (2, 13, 7),
        vec![
            3.5943234, 4.2320023, 3.671748, 3.748421, 3.0204058, 2.987145, 2.4209332, 3.9654257,
            3.929351, 3.9840934, 3.5419953, 3.6008596, 2.7987635, 2.1465354, 3.4907858, 3.461038,
            3.6178737, 3.2673066, 3.1652787, 3.4337883, 2.5601487, 3.3029976, 2.9253688, 2.6844673,
            3.2092214, 2.7696137, 3.0163777, 3.3836784, 2.9580705, 2.198038, 2.1681504, 2.8063767,
            2.9942763, 3.2940845, 3.6132998, 2.5659535, 1.9882077, 2.1285088, 3.158552, 2.9351068,
            3.905938, 3.446913, 3.0232842, 3.1512842, 3.2747502, 3.6082265, 3.1594765, 3.2825878,
            2.7169278, 4.0418835, 3.710871, 4.4105244, 3.4429388, 3.4961178, 3.805778, 3.2689455,
            4.8085403, 3.7315598, 3.5823824, 3.227131, 3.046729, 3.2764804, 3.1670864, 3.7974315,
            3.3195953, 2.756844, 2.0384316, 2.491803, 2.539396, 3.0097797, 3.194128, 1.8513657,
            2.7416475, 1.8464317, 2.172175, 2.5491755, 2.5628812, 2.3732457, 2.0422208, 2.348748,
            2.1887476, 2.582385, 2.671473, 2.721384, 2.4880214, 2.0980854, 2.9381716, 2.025416,
            2.8242023, 3.0374591, 3.4898944, 3.2894583, 3.1530182, 3.2528775, 2.8282826, 2.759086,
            2.2095377, 1.4215928, 2.9620929, 3.2694654, 3.092455, 3.1874886, 2.600366, 2.218693,
            1.8632407, 3.2153466, 2.6245, 2.7182271, 2.8424008, 3.431876, 2.1536016, 2.1028888,
            2.9368677, 1.9399426, 2.7625105, 2.5203714, 2.120322, 2.7657368, 2.2519627, 2.1096647,
            1.8094885, 1.5919424, 2.796751, 2.0703664, 2.704516, 3.2151213, 1.9072664, 1.6696724,
            1.6330581, 2.3982382, 3.2222486, 2.7582238, 2.3327475, 2.6404374, 2.3582423, 2.8887959,
            2.3975282, 2.4687114, 2.4183931, 2.8568685, 2.8865352, 3.148358, 2.9158697, 2.7401981,
            3.3716116, 3.0194077, 2.6415572, 3.5972168, 3.017609, 3.4068213, 2.7494793, 2.1221845,
            2.3603854, 2.3454773, 3.704941, 2.8004315, 1.7680516, 2.0608954, 1.9469761, 2.638386,
            3.135532, 1.6471884, 2.3888373, 2.1933737, 1.5413147, 2.0307121, 1.3765441, 2.4159653,
            2.1809025, 1.3908049, 2.1644778, 1.5277203, 1.8348981, 2.085016, 2.1045318, 2.03047,
            2.0774384, 1.8367369, 1.8812716, 2.0282488, 3.0014746, 3.0040445,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (1, 15, 10),
        vec![
            0.62424076, 0.95776683, 0.998361, 0.150883, 0.28713444, 0.35105017, 0.1765902,
            0.9674033, 0.65025777, 0.1959308, 0.3119046, 0.55247456, 0.38556734, 0.18145509,
            0.94255227, 0.7036003, 0.3402552, 0.16401337, 0.28418577, 0.5504918, 0.6148071,
            0.7740251, 0.37459207, 0.25677747, 0.80441076, 0.17314304, 0.5946227, 0.30094627,
            0.06480476, 0.5798754, 0.62549657, 0.6065069, 0.9259787, 0.3677915, 0.69532603,
            0.8356569, 0.39276573, 0.18570696, 0.61698794, 0.9064707, 0.01547038, 0.2551995,
            0.11438051, 0.03861368, 0.6524532, 0.36442748, 0.08230381, 0.79969245, 0.27816203,
            0.3741886, 0.44356522, 0.27386904, 0.4171807, 0.14990133, 0.4750283, 0.6358263,
            0.77572674, 0.7072159, 0.34310365, 0.36999545, 0.8200852, 0.46510443, 0.9230857,
            0.86201537, 0.04691705, 0.12260284, 0.89921826, 0.47400048, 0.7492544, 0.05440097,
            0.28273952, 0.9184355, 0.9064988, 0.7027802, 0.19125043, 0.8670149, 0.08634489,
            0.722654, 0.77540857, 0.00211577, 0.6443405, 0.2344423, 0.9849179, 0.9893316,
            0.87634915, 0.48734385, 0.8760625, 0.53053117, 0.01152504, 0.6788874, 0.76156837,
            0.4680538, 0.07214947, 0.549209, 0.8383253, 0.00365476, 0.9782156, 0.7419056,
            0.40790308, 0.00302504, 0.80174476, 0.7689671, 0.50054824, 0.16478458, 0.89107823,
            0.7763043, 0.73042727, 0.41667554, 0.7348974, 0.71259016, 0.93557405, 0.37013116,
            0.14954911, 0.33766475, 0.39673004, 0.03940821, 0.2414454, 0.9373305, 0.84819096,
            0.9272432, 0.8604789, 0.92845494, 0.8023847, 0.06647868, 0.12827316, 0.02774826,
            0.8982795, 0.1193029, 0.37523487, 0.28379655, 0.0638791, 0.08446726, 0.68760884,
            0.2630593, 0.01052708, 0.45302406, 0.10402057, 0.5539082, 0.39986408, 0.53770447,
            0.24856173, 0.12796782, 0.80071914, 0.38390577, 0.6908975, 0.5850918, 0.71101063,
            0.17578217, 0.55867785, 0.71616316,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 4),
        vec![
            0.3247584, 0.9196999, 0.46712968, 0.08430128, 0.83232373, 0.49657014, 0.24024557,
            0.60874844, 0.47418702, 0.9770886, 0.99522823, 0.7749884, 0.7253688, 0.26021662,
            0.8869578, 0.5181486, 0.5871326, 0.76900613, 0.5745777, 0.81429285, 0.78002185,
            0.7069771, 0.33134556, 0.7407027,
        ],
    )
    .unwrap();
    let conv_layer14 = ConvolutionLayer::new(kernel14, 1, Padding::Valid);
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (2, 13, 7),
        vec![
            3.9193375, 4.2045965, 3.0557752, 3.0280735, 3.2712696, 2.762956, 3.1252797, 4.0430017,
            4.1771393, 3.66774, 4.289747, 3.8885741, 2.6361432, 3.137674, 2.7767558, 3.0367522,
            3.4010065, 3.1277606, 3.291849, 3.3246005, 3.055436, 2.4243724, 3.0094924, 2.8370094,
            3.4453852, 4.5907154, 3.5062165, 3.1102602, 3.4231348, 3.0381525, 2.7526982, 3.048903,
            3.38522, 3.8733952, 3.9055667, 4.7417784, 3.8327248, 3.8099039, 3.6155112, 3.3493547,
            4.2133975, 3.8111408, 4.8165, 5.643769, 5.485602, 3.8862975, 3.8131485, 4.1855807,
            3.172237, 4.22669, 4.420482, 4.3294168, 4.5666995, 4.415205, 3.7510726, 4.06078,
            3.9437063, 4.293951, 4.103418, 5.1860237, 4.8039064, 4.1941566, 4.154619, 3.243331,
            2.9813511, 2.9317708, 3.0184212, 3.544742, 4.6829176, 5.209109, 4.5845695, 2.9569733,
            1.8018535, 2.812378, 3.4324534, 3.3750918, 3.5943418, 3.1540658, 2.6960647, 2.2409806,
            1.852318, 1.7462995, 2.6480644, 3.8898814, 3.2715352, 3.3232672, 3.261069, 2.6150239,
            2.8358977, 3.307804, 3.0056167, 3.9840934, 4.2792783, 3.5489514, 3.3665376, 3.5508513,
            3.1991408, 3.1231194, 3.6824698, 4.4601173, 4.3797245, 3.8765755, 3.8465757, 3.1242914,
            3.2302806, 3.036854, 3.9251847, 3.65086, 3.080984, 4.1258326, 2.7960794, 3.3325217,
            2.7147832, 3.0687485, 3.6453311, 3.431268, 4.129125, 3.6888695, 3.970781, 2.944752,
            2.8775167, 3.4472568, 3.426215, 3.6172328, 4.2381663, 3.5312037, 4.6029625, 3.9345367,
            4.333569, 3.5777364, 3.9149985, 4.6651955, 3.446767, 5.674187, 5.0184474, 5.006641,
            4.5419755, 4.2375574, 3.937471, 4.087123, 4.898022, 5.0206604, 4.4237843, 5.3683114,
            4.1701975, 4.210552, 3.8462489, 4.6672735, 4.754734, 4.328239, 5.1544065, 5.27017,
            4.3751693, 4.1528673, 3.7977402, 3.7366598, 3.0214598, 3.6852133, 4.85185, 4.1221967,
            4.83664, 4.1485276, 3.5538154, 2.9419973, 2.9581075, 3.3830366, 3.915767, 4.8838415,
            3.3491516, 2.7642412, 2.2485442, 1.833096, 2.4810266, 3.3500738, 3.7211654, 3.1576734,
            3.0506463, 3.266725, 2.5876198, 3.142543, 2.975078, 3.7115867,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (1, 15, 10),
        vec![
            0.58577555, 0.40479863, 0.7506117, 0.11343616, 0.8795398, 0.83064, 0.8858372,
            0.3898591, 0.9350765, 0.9673369, 0.64465624, 0.0283905, 0.22112074, 0.1391855,
            0.34128338, 0.65248054, 0.291874, 0.70765275, 0.32796225, 0.22921298, 0.59572685,
            0.5726663, 0.72872376, 0.8248998, 0.29288608, 0.92347336, 0.25887516, 0.91578674,
            0.800785, 0.7670362, 0.8990461, 0.8424308, 0.7045559, 0.43518323, 0.48451254,
            0.31151697, 0.10086012, 0.5242353, 0.19001916, 0.01069371, 0.01020448, 0.12606935,
            0.04778918, 0.8456499, 0.57045126, 0.46361542, 0.7532553, 0.62787765, 0.3127784,
            0.9686197, 0.96754897, 0.5766132, 0.6463905, 0.6347338, 0.52757853, 0.55145216,
            0.08155768, 0.13378453, 0.2262157, 0.73179847, 0.5428326, 0.9094368, 0.2528448,
            0.24383228, 0.7446406, 0.5544842, 0.01949351, 0.13375893, 0.04438103, 0.8489,
            0.6848837, 0.9220802, 0.00185038, 0.44556108, 0.00844186, 0.8082305, 0.33159012,
            0.5138473, 0.65069795, 0.9300001, 0.58097035, 0.5413155, 0.5714561, 0.21683556,
            0.8548128, 0.02262598, 0.62476623, 0.33444464, 0.98826236, 0.03221937, 0.12669064,
            0.50246465, 0.42635268, 0.91064155, 0.7792924, 0.07601635, 0.6067355, 0.3940292,
            0.30074376, 0.1328066, 0.72018456, 0.34319454, 0.6295161, 0.03357495, 0.03066352,
            0.51702976, 0.9283114, 0.36689135, 0.6327302, 0.37459058, 0.93406814, 0.33968034,
            0.59511477, 0.4350908, 0.7094508, 0.29612544, 0.80898666, 0.7905302, 0.4748418,
            0.6989706, 0.85952836, 0.70326394, 0.38940284, 0.37933362, 0.22292, 0.3949557,
            0.27719194, 0.8619771, 0.9255003, 0.30563155, 0.5844432, 0.36121982, 0.09087573,
            0.23811613, 0.17829578, 0.9398569, 0.04807154, 0.7588201, 0.05337733, 0.19222781,
            0.98696715, 0.32119673, 0.3872288, 0.74463385, 0.6260977, 0.0084233, 0.31085488,
            0.10247751, 0.60939455, 0.00353958,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 4),
        vec![
            0.22236562, 0.31823838, 0.9627444, 0.866447, 0.8205645, 0.7792785, 0.61566937,
            0.59327537, 0.33567885, 0.96525836, 0.47292593, 0.2669342, 0.705448, 0.28257245,
            0.02662205, 0.05098573, 0.8293213, 0.9416077, 0.9101412, 0.07020015, 0.8425068,
            0.9708137, 0.3117258, 0.11623824,
        ],
    )
    .unwrap();
    let conv_layer15 = ConvolutionLayer::new(kernel15, 1, Padding::Valid);
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (2, 13, 7),
        vec![
            3.167401, 3.0478861, 4.082493, 3.8928413, 4.395178, 4.251976, 4.742626, 3.9233305,
            3.5238092, 3.9252207, 3.4358954, 3.4913185, 3.7024114, 3.3112075, 4.190639, 3.8435302,
            4.1328993, 3.631128, 3.5780017, 3.8960888, 3.6645665, 3.5176167, 3.508585, 3.5823762,
            3.5139167, 3.2075114, 2.697755, 2.7149165, 4.083645, 3.8957283, 3.7280643, 3.856504,
            3.365939, 2.2309816, 2.6355522, 4.2651415, 3.4615953, 3.1668012, 2.672378, 2.6986918,
            2.0603266, 2.7270339, 3.4565117, 3.2640638, 2.9760165, 2.9838011, 2.315995, 2.9533653,
            3.45856, 3.184853, 3.3909428, 3.4391809, 3.6516523, 3.0527613, 3.5191975, 3.8320446,
            3.2174683, 3.76609, 3.0192642, 3.1778324, 3.440883, 3.7503512, 3.3585792, 3.6924734,
            3.6939933, 3.1033795, 3.1567397, 3.4578836, 3.9797523, 3.7701294, 3.8129802, 2.6176515,
            2.7757466, 3.494758, 3.9802067, 4.0085163, 4.688155, 3.6352546, 2.9140053, 2.792641,
            2.9105053, 4.0808887, 3.8506737, 3.96969, 3.1000257, 2.4591336, 2.8387196, 2.6584635,
            2.9401453, 3.6293375, 2.7618787, 2.7066703, 2.409038, 2.911618, 2.7442422, 3.4418104,
            3.7852829, 3.478208, 4.0757113, 3.621772, 3.1534662, 2.99128, 2.6843357, 3.0235295,
            2.9403458, 3.0983462, 2.9214766, 3.3519156, 3.308547, 2.5833755, 2.9875605, 2.7070565,
            2.7934806, 3.1614382, 3.4257765, 3.398966, 3.1193354, 2.570854, 2.1476378, 3.512823,
            3.029851, 2.7104282, 3.442749, 2.8131893, 1.7772741, 1.4761746, 3.9733732, 2.818241,
            2.3641462, 2.699165, 2.6586287, 2.2688851, 1.4699306, 3.3466043, 3.1078186, 1.7419231,
            2.6267495, 2.771011, 2.7430782, 2.6752272, 3.1266103, 3.1193583, 3.121355, 3.0222964,
            2.5569813, 2.5023937, 3.1815205, 2.7593117, 3.208701, 3.0465915, 2.3548825, 2.8006406,
            2.7906127, 3.0995107, 3.137673, 2.5310235, 2.3799589, 2.729687, 3.219664, 3.2686121,
            3.9499478, 3.8625479, 2.8250155, 2.862206, 2.1399496, 2.6279764, 3.4073737, 4.085396,
            3.4480934, 2.2538426, 1.9600471, 2.1322243, 2.6813908, 3.0020494, 3.5638323, 3.10964,
            2.1934228, 2.1810877, 2.8533173, 2.0945344, 2.3578296, 1.8475493,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (1, 15, 10),
        vec![
            0.19467542, 0.09732427, 0.43287596, 0.20617688, 0.8857049, 0.9601851, 0.09430943,
            0.28105715, 0.6942895, 0.07089514, 0.7148581, 0.00085336, 0.23516753, 0.04615124,
            0.59699446, 0.53420085, 0.75324225, 0.38793716, 0.2669936, 0.29911962, 0.7380972,
            0.17850904, 0.65695775, 0.8119258, 0.26960826, 0.12972821, 0.6597052, 0.7345929,
            0.6485681, 0.22981846, 0.24392553, 0.26706976, 0.32711208, 0.9581323, 0.31259444,
            0.91530424, 0.17250775, 0.715259, 0.5014661, 0.7273789, 0.23862323, 0.4093651,
            0.04974006, 0.8688277, 0.46409306, 0.20740515, 0.19872624, 0.27135858, 0.02647329,
            0.90772045, 0.97377276, 0.47016057, 0.06899374, 0.47393376, 0.49847803, 0.02369655,
            0.10663922, 0.02373338, 0.21085607, 0.56809616, 0.70259374, 0.4123619, 0.01858313,
            0.25862443, 0.4823392, 0.47215322, 0.593886, 0.8265343, 0.06712108, 0.3228139,
            0.11140465, 0.59627575, 0.49184018, 0.8395536, 0.13370071, 0.25792846, 0.54400545,
            0.8792363, 0.58678144, 0.03434712, 0.8123595, 0.67917913, 0.02545591, 0.2468276,
            0.9191908, 0.02958322, 0.20474248, 0.76555794, 0.82307637, 0.24628638, 0.17773865,
            0.17740512, 0.4937253, 0.9466453, 0.13741271, 0.728613, 0.5338591, 0.7898385,
            0.47936276, 0.23633894, 0.8572216, 0.06004518, 0.3347224, 0.50485814, 0.09635731,
            0.18004768, 0.24514198, 0.228041, 0.05106571, 0.30884218, 0.38737774, 0.7948706,
            0.5052517, 0.23866583, 0.5068071, 0.15044466, 0.09537497, 0.13518302, 0.7257979,
            0.86458087, 0.7176047, 0.09527912, 0.72005635, 0.7382226, 0.41232714, 0.5491061,
            0.7183669, 0.07962471, 0.04476061, 0.19437055, 0.79608136, 0.6295519, 0.98047,
            0.56819236, 0.10505454, 0.9480506, 0.10080674, 0.9538371, 0.2355401, 0.94827145,
            0.46488547, 0.60260093, 0.76637876, 0.3219317, 0.4168223, 0.25562465, 0.8997145,
            0.59076214, 0.22263806, 0.6840723,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.24348243, 0.94946456, 0.34627816, 0.9748906, 0.7407666, 0.9677088, 0.13005458,
            0.69001645, 0.14445187, 0.9216249, 0.03732051, 0.44508553, 0.666532, 0.9382296,
            0.80578685, 0.976145, 0.6098745, 0.04455515, 0.5690737, 0.6428197, 0.21377262,
            0.6692434, 0.86947584, 0.12576632, 0.8154824, 0.3646563, 0.32867205, 0.00950876,
            0.02384425, 0.68798536, 0.6243543, 0.061506, 0.4878141, 0.24558064, 0.15653013,
            0.40195072, 0.52372193, 0.62839466, 0.67610437, 0.6370576, 0.74306166, 0.8282889,
            0.39436254, 0.45260343, 0.6606655, 0.7309763, 0.40489906, 0.9551375, 0.4431474,
            0.6631732,
        ],
    )
    .unwrap();
    let conv_layer16 = ConvolutionLayer::new(kernel16, 1, Padding::Valid);
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (2, 11, 6),
        vec![
            6.0994325, 6.2932587, 6.9826646, 6.5762653, 7.2036185, 6.8689795, 6.1233892, 5.525983,
            6.285628, 6.9067044, 5.685272, 5.650616, 6.603003, 5.9694085, 5.2408004, 7.1327405,
            4.986911, 6.9558425, 6.0620027, 6.218527, 5.573247, 5.9581847, 5.6049075, 6.027093,
            6.57619, 4.6455655, 5.9151354, 6.5891194, 5.224654, 4.886594, 7.0165234, 6.100872,
            4.653298, 6.736966, 6.6200743, 5.8366737, 4.8567934, 5.490131, 5.9885497, 7.417022,
            6.1828837, 6.0420847, 7.604429, 5.1463976, 5.8507714, 5.9246707, 6.7522244, 5.4149647,
            6.0246305, 6.6202636, 5.169838, 6.303436, 5.5940123, 5.6340823, 7.0516667, 6.377449,
            6.389647, 6.386001, 5.162242, 6.801947, 6.9926467, 6.6809587, 7.0751033, 5.0353446,
            5.330836, 5.9082656, 5.1630564, 5.4059973, 5.121797, 5.7775273, 5.9989347, 5.492364,
            5.743825, 4.8654327, 4.88721, 5.0779805, 4.2513843, 4.6342926, 5.192893, 4.3586946,
            4.5705237, 5.6401157, 3.9250026, 4.7717605, 4.7811956, 5.1763816, 3.970269, 5.6052547,
            4.5815873, 4.8608503, 5.2702346, 4.529596, 4.666383, 5.454817, 5.161119, 4.8546023,
            5.8747473, 4.920009, 4.2605467, 6.308726, 5.920353, 5.5020485, 5.0050845, 4.7437005,
            4.627309, 5.7028227, 4.7333837, 5.029678, 4.9616723, 4.847374, 4.9973474, 4.582893,
            4.6855617, 4.334113, 6.2035604, 4.793104, 4.5170274, 5.202313, 4.4195457, 3.9383538,
            6.057308, 5.8521953, 5.6221266, 5.589762, 4.0402565, 5.7204065, 6.202733, 6.152954,
            6.390062, 5.070138, 4.810692, 5.207409,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (1, 15, 10),
        vec![
            0.18731794, 0.43634078, 0.4686375, 0.7620647, 0.57885796, 0.26523942, 0.13030814,
            0.7995473, 0.951001, 0.58605653, 0.82163817, 0.21192186, 0.12197074, 0.06249312,
            0.3968833, 0.23130116, 0.670139, 0.89535373, 0.9697048, 0.7154457, 0.8203782,
            0.21395262, 0.7457981, 0.7147152, 0.05275504, 0.93545914, 0.8986874, 0.8690856,
            0.63580817, 0.15263815, 0.7466949, 0.6235891, 0.62486136, 0.7352324, 0.23342584,
            0.9827126, 0.93357897, 0.96423954, 0.02081718, 0.47192466, 0.50718915, 0.9034243,
            0.678573, 0.48106775, 0.27722874, 0.0061415, 0.2891619, 0.9937529, 0.02278532,
            0.7661429, 0.23943478, 0.7568481, 0.1846646, 0.05945846, 0.7522374, 0.723256,
            0.5690188, 0.80126184, 0.13196982, 0.2549996, 0.9684265, 0.09975351, 0.6575368,
            0.01221572, 0.5690517, 0.8633032, 0.5916843, 0.7327984, 0.38392547, 0.45234743,
            0.88714564, 0.48625886, 0.4974664, 0.280569, 0.3272779, 0.7308698, 0.16297498,
            0.8690239, 0.5834708, 0.33016786, 0.2406453, 0.599151, 0.8538999, 0.30761606,
            0.3641591, 0.11430372, 0.45364544, 0.6984523, 0.7053654, 0.4003387, 0.38632825,
            0.91106904, 0.5180514, 0.1837249, 0.38816592, 0.16589011, 0.91154295, 0.93466866,
            0.9079338, 0.6218017, 0.7199313, 0.5790186, 0.5812801, 0.5897581, 0.00632351,
            0.51240736, 0.3697457, 0.13892107, 0.9900367, 0.47229373, 0.56468743, 0.59834725,
            0.6383385, 0.03793695, 0.9450343, 0.96132326, 0.6061949, 0.63035446, 0.5111371,
            0.03746503, 0.558335, 0.30164844, 0.68653256, 0.99669343, 0.5127781, 0.25915265,
            0.34361982, 0.6647127, 0.42920145, 0.22015804, 0.22396304, 0.553291, 0.21043801,
            0.03016802, 0.13123624, 0.4177692, 0.15363416, 0.26550946, 0.9799374, 0.6468661,
            0.22700246, 0.28266105, 0.7568015, 0.49555436, 0.7577122, 0.20788053, 0.91674453,
            0.56273526, 0.45675126, 0.48490578,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.82385767, 0.42006218, 0.8251126, 0.35886785, 0.09741933, 0.50827706, 0.09494945,
            0.9338919, 0.41674572, 0.12654002, 0.47637334, 0.72644436, 0.22123201, 0.29542014,
            0.46568522, 0.6850643, 0.6808416, 0.3779981, 0.805789, 0.2891591, 0.6993045,
            0.33186397, 0.9734199, 0.9644196, 0.09362596, 0.0414281, 0.27610767, 0.43870836,
            0.34610718, 0.3848816, 0.24301769, 0.23232727, 0.32100558, 0.22719596, 0.85453415,
            0.76819396, 0.8545096, 0.653471, 0.6439924, 0.61992764, 0.5419032, 0.42076096,
            0.7094996, 0.8802664, 0.30416232, 0.00992903, 0.07512625, 0.21167818, 0.9575676,
            0.33277866,
        ],
    )
    .unwrap();
    let conv_layer17 = ConvolutionLayer::new(kernel17, 1, Padding::Valid);
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (2, 11, 6),
        vec![
            6.266185, 6.2400446, 6.5082126, 6.0199537, 7.279895, 7.380876, 6.05182, 5.7995067,
            5.8284135, 6.5852513, 7.3323994, 7.3131523, 6.750216, 5.999844, 6.489496, 7.7882953,
            7.4544506, 7.753541, 6.686248, 6.1095686, 5.945014, 6.4080477, 7.2853985, 7.9249644,
            5.967415, 6.1037784, 5.6722465, 4.984335, 6.712053, 6.747654, 5.6152973, 5.4660053,
            5.4210186, 5.890499, 7.6883163, 7.5472293, 6.733236, 5.209685, 5.4111295, 5.915444,
            5.83584, 7.7773323, 6.7487226, 5.748986, 6.6085954, 5.6603804, 6.4027143, 7.806131,
            6.7695065, 7.00971, 6.43881, 5.304279, 7.2166944, 6.818936, 6.123942, 5.917749,
            5.050416, 5.4532394, 5.897833, 6.460524, 5.983851, 5.75244, 6.353759, 5.918098,
            6.0481763, 6.1465726, 5.8531704, 5.1106963, 5.9664373, 7.025986, 7.656565, 7.122259,
            5.1991744, 6.172578, 6.2591896, 6.788897, 6.812916, 6.191041, 4.8857765, 6.400066,
            6.2564125, 6.7398205, 5.969451, 5.630925, 4.920029, 5.051742, 5.702142, 6.5723467,
            6.5769525, 6.350677, 5.4391923, 4.82139, 4.8387403, 5.6497235, 6.147204, 6.49416,
            5.2312527, 5.112213, 4.930376, 6.0849996, 6.538855, 6.4230623, 5.070312, 5.024325,
            4.636716, 5.5113344, 6.086649, 6.6634464, 5.341706, 5.3387136, 5.310021, 5.5758004,
            5.9231057, 6.3699923, 6.0834017, 5.43173, 5.7336, 5.3797965, 6.493811, 6.193023,
            5.426586, 5.58048, 5.469801, 5.399284, 6.909898, 6.5534225, 5.5239596, 5.5569363,
            5.1507335, 5.407637, 5.2904534, 5.1011667,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (1, 15, 10),
        vec![
            0.5804159, 0.14874539, 0.84465176, 0.33960778, 0.03217437, 0.23459853, 0.86872333,
            0.05481404, 0.4075119, 0.13763186, 0.38947833, 0.19455469, 0.2231027, 0.710135,
            0.38075933, 0.36192992, 0.5788371, 0.45671245, 0.02821646, 0.65663046, 0.6821529,
            0.13092387, 0.04243296, 0.40237483, 0.96532, 0.08922233, 0.65666056, 0.07955468,
            0.30693734, 0.61528814, 0.8301079, 0.9080613, 0.10633651, 0.95870477, 0.24841434,
            0.49642795, 0.02807361, 0.67816275, 0.14359485, 0.96717685, 0.970054, 0.53526694,
            0.789418, 0.44380167, 0.1696324, 0.22258878, 0.54548246, 0.33204898, 0.6242531,
            0.39491078, 0.95525235, 0.17685722, 0.4390062, 0.25685027, 0.9619644, 0.7054154,
            0.25693816, 0.06693318, 0.71142703, 0.30001205, 0.24983038, 0.04385825, 0.83179814,
            0.9035203, 0.99454165, 0.4820838, 0.2207663, 0.6613494, 0.6531026, 0.941437,
            0.02962555, 0.00604056, 0.6749602, 0.09254023, 0.16296797, 0.7694261, 0.49170363,
            0.04446485, 0.8114944, 0.29030007, 0.1919063, 0.18254054, 0.13724734, 0.00911832,
            0.20514874, 0.59104544, 0.815183, 0.26495343, 0.62743604, 0.94401777, 0.54503894,
            0.6431647, 0.52856827, 0.51207054, 0.03335644, 0.28076503, 0.07791043, 0.86478263,
            0.980501, 0.54355013, 0.03467919, 0.886572, 0.36146563, 0.13580918, 0.8819829,
            0.48148784, 0.09721047, 0.7819647, 0.49357224, 0.6708243, 0.72222507, 0.366483,
            0.37231642, 0.11044633, 0.88196933, 0.7812372, 0.2546282, 0.8222847, 0.328725,
            0.78940445, 0.46583235, 0.3009351, 0.90517753, 0.7002328, 0.750793, 0.75040495,
            0.53337294, 0.51972127, 0.72387767, 0.9831707, 0.20632543, 0.16955712, 0.76152086,
            0.05444199, 0.2814817, 0.15761587, 0.95890856, 0.90069485, 0.01261302, 0.21181779,
            0.78206104, 0.92161584, 0.74544144, 0.8816592, 0.9976662, 0.2966056, 0.2162454,
            0.06208929, 0.50320554, 0.6565798,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 5, 5),
        vec![
            0.5351854, 0.10227188, 0.28489798, 0.20003575, 0.1822242, 0.05310873, 0.13790856,
            0.78958035, 0.5917116, 0.38009274, 0.2742251, 0.9041115, 0.99974847, 0.9090851,
            0.4171188, 0.48332873, 0.169661, 0.15740211, 0.04401799, 0.33348852, 0.42292982,
            0.4798304, 0.90991354, 0.54084134, 0.4826352, 0.5674032, 0.6246967, 0.70394504,
            0.12639284, 0.16602974, 0.4649844, 0.36747122, 0.75747913, 0.91581804, 0.02039539,
            0.51063865, 0.6296097, 0.55201155, 0.25472447, 0.48130554, 0.324559, 0.66492975,
            0.01730853, 0.77949584, 0.13672462, 0.73892075, 0.02376527, 0.8798877, 0.6356067,
            0.22369854,
        ],
    )
    .unwrap();
    let conv_layer18 = ConvolutionLayer::new(kernel18, 1, Padding::Valid);
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (2, 11, 6),
        vec![
            4.9495325, 4.6604047, 4.6104765, 4.7681375, 3.8265111, 4.1624675, 5.577771, 5.0675893,
            5.5730014, 4.453457, 4.2565007, 3.8790543, 6.3204584, 5.5935354, 4.9134703, 4.537454,
            5.0906916, 5.1934075, 4.7645373, 4.8329787, 4.907358, 5.4041257, 4.9191136, 4.698053,
            4.611416, 5.394104, 6.090703, 4.912939, 5.030848, 5.378489, 4.8375444, 4.773574,
            4.4697843, 4.059742, 5.056516, 6.0449376, 3.5954282, 3.782002, 4.6191845, 5.398414,
            5.436422, 5.695607, 4.052563, 3.965734, 4.368317, 4.624658, 5.435349, 6.2804465,
            5.38911, 5.1332583, 4.824382, 5.2543693, 5.7854323, 6.738322, 4.538313, 4.593734,
            5.4091597, 5.6131444, 5.7469616, 6.1479664, 6.192296, 6.9047446, 7.0588827, 5.702117,
            5.349491, 5.534145, 6.566582, 4.171021, 5.104689, 4.3969316, 5.018612, 3.8225856,
            5.3845983, 5.4924045, 5.3940907, 5.253428, 4.37898, 4.8721952, 6.3372126, 5.898883,
            5.9977145, 5.046412, 5.4250526, 5.118972, 5.977179, 5.300202, 5.5326953, 5.6294127,
            4.9408436, 5.1277027, 4.382807, 5.1247497, 6.2039714, 5.2608395, 5.0681963, 5.894678,
            4.6945724, 5.0299525, 5.3165174, 5.0649467, 5.5956287, 6.316275, 3.7048864, 4.478496,
            5.8683124, 4.6971107, 5.6606364, 6.519021, 3.899749, 4.4641867, 4.4534, 4.8756285,
            5.949755, 5.879192, 5.401141, 5.1167235, 4.878065, 5.1375413, 6.460968, 6.6835265,
            5.1087055, 5.460093, 5.6453795, 5.245856, 6.2453585, 6.118429, 5.6430273, 6.871193,
            6.5843506, 6.1224666, 6.33445, 5.6072836,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (3, 6, 6),
        vec![
            0.584571, 0.96449506, 0.7977554, 0.32541806, 0.10196066, 0.8232674, 0.8543414,
            0.9710584, 0.505133, 0.04858193, 0.16233306, 0.651015, 0.62667716, 0.04012987,
            0.8986551, 0.5988572, 0.7548613, 0.9230523, 0.8094736, 0.41193417, 0.11411006,
            0.29621908, 0.8657136, 0.3099813, 0.7817938, 0.5514695, 0.9309671, 0.35345063,
            0.04673942, 0.2836077, 0.4491099, 0.16020048, 0.0033604, 0.7036799, 0.09309967,
            0.8027366, 0.66168624, 0.75922126, 0.98626304, 0.41794768, 0.85175455, 0.6952307,
            0.8909816, 0.77955645, 0.25186005, 0.6967979, 0.44887283, 0.443149, 0.75464064,
            0.81323266, 0.85127234, 0.15431848, 0.56885445, 0.29611066, 0.87579244, 0.9531821,
            0.5536974, 0.53754663, 0.23263316, 0.527793, 0.6797737, 0.74194604, 0.01885639,
            0.08134871, 0.6701397, 0.42471457, 0.93320847, 0.6966494, 0.5644708, 0.03809474,
            0.09368633, 0.5213245, 0.7867202, 0.5103296, 0.05583452, 0.7863488, 0.5674216,
            0.06023929, 0.39982173, 0.32429224, 0.11995548, 0.8987073, 0.1602559, 0.33672985,
            0.742261, 0.14132027, 0.06929818, 0.4782574, 0.5697997, 0.11632108, 0.49556065,
            0.47647962, 0.7417032, 0.34966558, 0.47131556, 0.9838283, 0.6777289, 0.90295655,
            0.67075133, 0.0573609, 0.8237337, 0.36602104, 0.15022676, 0.66375136, 0.17951131,
            0.7120909, 0.48833874, 0.85454535,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (2, 3, 3, 3),
        vec![
            0.18296848, 0.10698621, 0.61914563, 0.5212063, 0.922373, 0.6521379, 0.45965454,
            0.3666493, 0.99957263, 0.63527644, 0.17045999, 0.32906872, 0.39238515, 0.8330784,
            0.24240606, 0.16471672, 0.39931872, 0.18019378, 0.04206449, 0.4967664, 0.8137173,
            0.2356948, 0.4160782, 0.9648439, 0.08041501, 0.65951824, 0.8111227, 0.5044555,
            0.5347742, 0.6593625, 0.2873256, 0.93752426, 0.7753997, 0.7233747, 0.5849598,
            0.73156756, 0.514743, 0.9262702, 0.2988856, 0.6292863, 0.3348592, 0.68505603,
            0.09462127, 0.39446756, 0.7353366, 0.06431016, 0.30438656, 0.65234166, 0.58759433,
            0.62632954, 0.4344534, 0.21980144, 0.00100083, 0.6921164,
        ],
    )
    .unwrap();
    let conv_layer19 = ConvolutionLayer::new(kernel19, 1, Padding::Valid);
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (2, 4, 4),
        vec![
            6.9983883, 6.5153556, 6.310286, 5.8306293, 6.278054, 6.4767513, 6.131841, 6.341292,
            8.008063, 5.5073586, 6.068592, 6.032971, 7.017821, 5.9458756, 5.110848, 6.127889,
            8.313281, 7.499593, 6.6474466, 6.767022, 7.9404044, 6.466429, 6.4669557, 6.7845483,
            7.8851295, 6.5744195, 7.2320113, 6.4738674, 7.6288223, 6.5108542, 5.019711, 6.238037,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (3, 6, 6),
        vec![
            0.8472264, 0.3598078, 0.8860002, 0.3531883, 0.25727805, 0.25435162, 0.7503538,
            0.4171089, 0.7314984, 0.4653744, 0.71255463, 0.95627284, 0.9875905, 0.22617352,
            0.7417731, 0.37862286, 0.5094745, 0.18060002, 0.9620671, 0.49016726, 0.45882288,
            0.75507283, 0.45673513, 0.9690947, 0.10567724, 0.2728893, 0.70271283, 0.8472397,
            0.55496895, 0.91851914, 0.9672113, 0.64802116, 0.21997769, 0.3842727, 0.94689554,
            0.74909705, 0.3282922, 0.2643334, 0.3491095, 0.3052412, 0.5038705, 0.37622157,
            0.04119791, 0.7131295, 0.14328648, 0.13365868, 0.36297327, 0.68727154, 0.93408334,
            0.21441843, 0.91439056, 0.40976977, 0.9953925, 0.3781238, 0.28116077, 0.97598535,
            0.36442432, 0.14792818, 0.83921397, 0.625257, 0.09807894, 0.3419448, 0.9480976,
            0.12152596, 0.29696485, 0.41873357, 0.95614773, 0.47523478, 0.25687808, 0.7602087,
            0.78506595, 0.43647116, 0.97631705, 0.26839125, 0.08090039, 0.48662946, 0.70590997,
            0.99664134, 0.77797663, 0.2436962, 0.6407154, 0.34835714, 0.8761795, 0.19121103,
            0.5305259, 0.6565131, 0.5287279, 0.29444507, 0.775589, 0.24550702, 0.9532204,
            0.8754091, 0.341333, 0.6382999, 0.5125449, 0.5005919, 0.937352, 0.6224484, 0.14624618,
            0.8417525, 0.9414587, 0.44898897, 0.6993321, 0.36183158, 0.24969168, 0.9671642,
            0.20102102, 0.799053,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (2, 3, 3, 3),
        vec![
            0.29777643, 0.05473179, 0.82243276, 0.49220118, 0.959262, 0.60974807, 0.82510734,
            0.77621484, 0.31383017, 0.20135997, 0.40562743, 0.25492424, 0.5874371, 0.69954115,
            0.11803117, 0.95850575, 0.9031762, 0.8240507, 0.7735656, 0.5868046, 0.50450677,
            0.31319898, 0.23300357, 0.8095447, 0.34135282, 0.24274388, 0.6729072, 0.57593447,
            0.8085596, 0.7018395, 0.76145005, 0.58241343, 0.3309161, 0.67546684, 0.32411024,
            0.3949699, 0.412044, 0.8408538, 0.76511306, 0.8994237, 0.8364367, 0.38108206,
            0.69459295, 0.8441607, 0.40802577, 0.95296425, 0.72987187, 0.07076582, 0.8826578,
            0.44925806, 0.8213124, 0.6112075, 0.96117723, 0.3876701,
        ],
    )
    .unwrap();
    let conv_layer20 = ConvolutionLayer::new(kernel20, 1, Padding::Valid);
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (2, 4, 4),
        vec![
            8.553058, 6.253518, 7.880664, 7.1828513, 8.496301, 7.1531835, 7.888157, 7.8078485,
            7.653477, 7.897603, 8.116202, 7.5174546, 7.789369, 8.462489, 7.7881603, 9.309164,
            9.620787, 7.310013, 8.248179, 7.8984437, 10.382416, 8.2361555, 8.884365, 9.370408,
            9.861098, 9.459994, 9.182264, 9.570011, 9.486213, 8.838298, 9.447385, 10.396689,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (3, 6, 6),
        vec![
            0.88056743, 0.9483631, 0.8974017, 0.4120727, 0.27696642, 0.69025475, 0.42224765,
            0.96611446, 0.04551166, 0.40275672, 0.19091433, 0.4437527, 0.31289253, 0.2396215,
            0.6389319, 0.85605, 0.27247688, 0.19161025, 0.50402254, 0.5852498, 0.97299683,
            0.594723, 0.38096267, 0.29591832, 0.28942943, 0.4529504, 0.19683413, 0.1757779,
            0.88774997, 0.5229589, 0.7137983, 0.82603574, 0.8461087, 0.9091735, 0.80568945,
            0.79286724, 0.3410004, 0.32917508, 0.17503856, 0.7846004, 0.7272445, 0.48829708,
            0.9584728, 0.7469263, 0.66009414, 0.59341496, 0.42636782, 0.9874962, 0.85196227,
            0.43363968, 0.02657376, 0.11542477, 0.13354255, 0.5618466, 0.070237, 0.35689688,
            0.27853093, 0.8144841, 0.99201185, 0.6685596, 0.5670808, 0.68718493, 0.73198694,
            0.84016347, 0.55920875, 0.27009216, 0.10123584, 0.2636, 0.9657689, 0.005051, 0.5576874,
            0.9025137, 0.55897933, 0.35369453, 0.9429427, 0.5162179, 0.5906877, 0.05157892,
            0.76241785, 0.07249359, 0.45541912, 0.01278013, 0.4782056, 0.76319754, 0.5541978,
            0.04795831, 0.5815242, 0.27330735, 0.8815459, 0.29006037, 0.23429064, 0.18781203,
            0.94584274, 0.4523076, 0.29750833, 0.17197818, 0.06818328, 0.6987018, 0.6090657,
            0.24505253, 0.8169458, 0.03939039, 0.5665328, 0.8011893, 0.75747067, 0.1555473,
            0.18986696, 0.13435428,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (2, 3, 3, 3),
        vec![
            0.38600448, 0.19166702, 0.46490034, 0.18260308, 0.82895696, 0.03558233, 0.14173116,
            0.8877225, 0.12655611, 0.4754852, 0.7843472, 0.8912908, 0.15408872, 0.45979473,
            0.18853948, 0.826404, 0.8497178, 0.36331993, 0.98673576, 0.43612492, 0.03541405,
            0.783278, 0.24658875, 0.74658084, 0.34663445, 0.03917093, 0.3931895, 0.30789322,
            0.68702215, 0.44194368, 0.33855647, 0.9119313, 0.31810585, 0.16017109, 0.00698695,
            0.293519, 0.14280626, 0.48469457, 0.1767692, 0.42322084, 0.46112144, 0.9255381,
            0.5532242, 0.9853486, 0.24325794, 0.63504064, 0.15406865, 0.11709648, 0.1119092,
            0.21574858, 0.62332, 0.8729103, 0.52609015, 0.06899712,
        ],
    )
    .unwrap();
    let conv_layer21 = ConvolutionLayer::new(kernel21, 1, Padding::Valid);
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (2, 4, 4),
        vec![
            6.5474095, 4.7181077, 6.210687, 5.143296, 5.9306254, 5.4604573, 6.373408, 5.820328,
            5.6732264, 5.3614197, 6.207198, 5.77442, 5.4500036, 6.542346, 7.8057203, 6.2950253,
            6.556172, 4.527217, 4.7674494, 5.241317, 4.723054, 4.333703, 5.6786666, 5.0583606,
            5.1748776, 6.331853, 6.6757755, 5.2609253, 5.741457, 6.52883, 6.355396, 5.1719947,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (3, 6, 6),
        vec![
            0.6168495, 0.3181057, 0.10088859, 0.28579375, 0.08647749, 0.8464018, 0.5181164,
            0.47873196, 0.83375126, 0.9057766, 0.00922728, 0.36432305, 0.53910846, 0.47707382,
            0.23459193, 0.6104503, 0.99977493, 0.2879088, 0.9237121, 0.24345838, 0.00414109,
            0.03638967, 0.30595168, 0.16491044, 0.7087876, 0.79154646, 0.6065011, 0.46475387,
            0.6585233, 0.93920064, 0.09687401, 0.5544905, 0.56360936, 0.10987341, 0.79093266,
            0.6827511, 0.93982804, 0.14053226, 0.49555323, 0.4556152, 0.66896224, 0.46089745,
            0.33559954, 0.3038908, 0.7388162, 0.5641086, 0.07862057, 0.46463865, 0.07132971,
            0.5696929, 0.89171886, 0.97521317, 0.86021405, 0.61829454, 0.4099887, 0.3409378,
            0.49427044, 0.10122171, 0.23691536, 0.70967704, 0.4641384, 0.8326181, 0.38735756,
            0.9489551, 0.07998312, 0.5111061, 0.02956773, 0.17711017, 0.11328588, 0.74999446,
            0.8589006, 0.07875007, 0.73433584, 0.4188041, 0.48477763, 0.00624699, 0.6286288,
            0.21567076, 0.81573004, 0.70090973, 0.8734742, 0.6482149, 0.5717835, 0.16271727,
            0.53025377, 0.0984337, 0.82271063, 0.12299971, 0.06295575, 0.7953895, 0.5933358,
            0.27819812, 0.70772564, 0.8846656, 0.33805057, 0.66772455, 0.9335431, 0.0900248,
            0.08626243, 0.0064692, 0.9791513, 0.52760124, 0.61633664, 0.9759571, 0.5431996,
            0.11189567, 0.662313, 0.47249612,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (2, 3, 5, 5),
        vec![
            0.88115114, 0.93577164, 0.61019063, 0.4513792, 0.21412608, 0.21063799, 0.59758914,
            0.26163143, 0.57292384, 0.3575447, 0.41482434, 0.5686212, 0.43116546, 0.8888871,
            0.5989078, 0.96428144, 0.67385226, 0.18009396, 0.650084, 0.1288117, 0.6034601,
            0.23165825, 0.01380609, 0.45430455, 0.3510245, 0.375879, 0.7931324, 0.20369534,
            0.9617992, 0.17212614, 0.8661392, 0.818001, 0.04731771, 0.6331485, 0.83272296,
            0.58803684, 0.6773803, 0.966571, 0.59957683, 0.85136724, 0.03105091, 0.388052,
            0.55736136, 0.02805966, 0.80824125, 0.57193863, 0.9242484, 0.43400672, 0.95459735,
            0.19825369, 0.3165235, 0.34878272, 0.04700416, 0.89200944, 0.8226108, 0.49845085,
            0.02590412, 0.3321073, 0.9764468, 0.5381227, 0.92109436, 0.7710321, 0.8660679,
            0.3895538, 0.854895, 0.07690383, 0.03470363, 0.623576, 0.7447061, 0.23551573,
            0.09116793, 0.13018292, 0.29478395, 0.694041, 0.0967541, 0.8266735, 0.00767931,
            0.24422543, 0.47754803, 0.05508777, 0.30187264, 0.58673537, 0.38990366, 0.6169217,
            0.5919785, 0.35687554, 0.9651153, 0.31502706, 0.15851368, 0.90410787, 0.24201743,
            0.99100995, 0.46153438, 0.5230941, 0.05274187, 0.85842836, 0.8584512, 0.30464408,
            0.00721753, 0.18392335, 0.8556412, 0.1809689, 0.5768042, 0.3628767, 0.69780505,
            0.11757887, 0.08762363, 0.36607084, 0.24363868, 0.7472844, 0.08178072, 0.8810783,
            0.3569205, 0.451316, 0.0383365, 0.8465622, 0.9883213, 0.56150496, 0.52739674,
            0.47732064, 0.43933925, 0.21088907, 0.5524299, 0.8005311, 0.17473145, 0.40513718,
            0.82864845, 0.4856008, 0.41349155, 0.8595507, 0.77320266, 0.9890798, 0.24298015,
            0.27266598, 0.4846638, 0.87975013, 0.4469587, 0.10110632, 0.5594282, 0.9304254,
            0.09035328, 0.76902574, 0.2852155, 0.07585676, 0.24124639, 0.06790887, 0.14329627,
            0.6381789, 0.9543389, 0.6581925,
        ],
    )
    .unwrap();
    let conv_layer22 = ConvolutionLayer::new(kernel22, 1, Padding::Valid);
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (2, 2, 2),
        vec![
            18.980623, 18.461094, 17.059132, 19.076921, 17.440098, 16.503302, 17.383461, 16.702227,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (3, 6, 6),
        vec![
            0.1983508, 0.44280005, 0.15768081, 0.7742759, 0.90144795, 0.8614371, 0.28797778,
            0.37103122, 0.0877872, 0.45872805, 0.76575243, 0.6829663, 0.2304093, 0.5233105,
            0.6974145, 0.8921432, 0.22412036, 0.0491925, 0.5368815, 0.19189753, 0.45287937,
            0.6024187, 0.37045264, 0.23233427, 0.42484194, 0.98901117, 0.36564678, 0.8630159,
            0.8116843, 0.39872772, 0.6879206, 0.7998495, 0.594579, 0.7541534, 0.80124223,
            0.59222096, 0.05390601, 0.82877624, 0.29753333, 0.82358676, 0.29054287, 0.26042402,
            0.88391197, 0.8143526, 0.579024, 0.05703124, 0.6139959, 0.10031959, 0.78280455,
            0.24171719, 0.4721017, 0.53194064, 0.6437402, 0.09277638, 0.8693754, 0.60042983,
            0.8875286, 0.86002535, 0.69702214, 0.12023476, 0.9464669, 0.9782188, 0.38164645,
            0.7172452, 0.9105007, 0.41190186, 0.29969904, 0.43725935, 0.7022435, 0.7566894,
            0.5551452, 0.88240683, 0.10910437, 0.51675713, 0.33856305, 0.4310923, 0.43717158,
            0.2241604, 0.7074267, 0.04574655, 0.62335473, 0.6056931, 0.19430637, 0.9464095,
            0.43765876, 0.47719213, 0.45312902, 0.417855, 0.8179389, 0.03511541, 0.5549018,
            0.6715673, 0.61512816, 0.655004, 0.09111205, 0.49298653, 0.3268639, 0.77552783,
            0.77209026, 0.47542888, 0.31814525, 0.52555007, 0.81072354, 0.00102462, 0.5109687,
            0.48937833, 0.122188, 0.22519495,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (2, 3, 5, 5),
        vec![
            0.40227205, 0.84508294, 0.43985215, 0.05504967, 0.02137936, 0.26612982, 0.12310848,
            0.00158825, 0.75761557, 0.88188004, 0.12094665, 0.13906257, 0.9157668, 0.91879827,
            0.8513396, 0.28533912, 0.30878848, 0.12668495, 0.24235713, 0.45707443, 0.7712829,
            0.6903243, 0.09853197, 0.43307763, 0.05488254, 0.70532215, 0.34688666, 0.9355463,
            0.38260135, 0.4838589, 0.17318112, 0.21472165, 0.77769446, 0.356957, 0.22671694,
            0.18250434, 0.41477197, 0.18007399, 0.9827863, 0.58704966, 0.2950183, 0.46143153,
            0.19057809, 0.3653109, 0.93977064, 0.26191843, 0.3693467, 0.1444909, 0.9363978,
            0.42698747, 0.1281546, 0.30951205, 0.1389484, 0.7072368, 0.44510987, 0.68366706,
            0.60059834, 0.09438256, 0.36583102, 0.60821444, 0.03161661, 0.8738241, 0.29876906,
            0.33316013, 0.562216, 0.3353904, 0.10716959, 0.9334109, 0.8606402, 0.42792627,
            0.48052302, 0.6958078, 0.4525564, 0.99052715, 0.04395659, 0.71055365, 0.9117777,
            0.93380785, 0.90260816, 0.01515595, 0.88177705, 0.43487665, 0.56912595, 0.05581366,
            0.02638636, 0.50119185, 0.31323937, 0.05636088, 0.31307653, 0.3326902, 0.3734779,
            0.4210294, 0.08686391, 0.3808534, 0.36317897, 0.19031978, 0.46563995, 0.41320488,
            0.94399136, 0.28572702, 0.6142756, 0.8158052, 0.26794037, 0.12281225, 0.32823455,
            0.14740174, 0.70965314, 0.19252698, 0.79887706, 0.02814319, 0.39099365, 0.7551387,
            0.5038018, 0.15413615, 0.82638884, 0.2631662, 0.7053773, 0.6478343, 0.32534242,
            0.6635084, 0.8839653, 0.59479696, 0.68739474, 0.903793, 0.9826564, 0.56865096,
            0.33996934, 0.63317853, 0.7065151, 0.82775307, 0.22001709, 0.37304193, 0.20307006,
            0.59174454, 0.3759951, 0.673529, 0.42676452, 0.6453951, 0.93520576, 0.59322685,
            0.5885291, 0.23145947, 0.15739693, 0.8825847, 0.17851174, 0.5603199, 0.14435844,
            0.10347797, 0.37213182, 0.14642915,
        ],
    )
    .unwrap();
    let conv_layer23 = ConvolutionLayer::new(kernel23, 1, Padding::Valid);
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (2, 2, 2),
        vec![
            17.914461, 16.328453, 18.750475, 15.326975, 18.701403, 18.114893, 19.846033, 19.030308,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (3, 6, 6),
        vec![
            0.21561022, 0.3830422, 0.90021485, 0.32565016, 0.82000726, 0.72865623, 0.48349917,
            0.41356984, 0.03333719, 0.08149401, 0.85722613, 0.04374503, 0.88704216, 0.09240989,
            0.8528545, 0.7946653, 0.54765993, 0.74729836, 0.72924787, 0.21080038, 0.12833528,
            0.06738389, 0.9163098, 0.2233036, 0.09597177, 0.4226413, 0.73019654, 0.8065446,
            0.13412596, 0.9296237, 0.88961375, 0.8097079, 0.92300737, 0.8407575, 0.5467569,
            0.90232325, 0.40697718, 0.7049378, 0.17525117, 0.60480595, 0.01006908, 0.09306768,
            0.04155758, 0.00396548, 0.29594678, 0.24183853, 0.23543635, 0.10814751, 0.366542,
            0.58264214, 0.1795904, 0.47117367, 0.7827338, 0.22905576, 0.3444951, 0.83183694,
            0.12226541, 0.8971257, 0.27640048, 0.37137195, 0.2710384, 0.27672654, 0.33046693,
            0.4244338, 0.8525934, 0.79606473, 0.24516417, 0.5116681, 0.32966596, 0.36674044,
            0.40403318, 0.31310067, 0.7258184, 0.01080465, 0.05479572, 0.52210695, 0.6023438,
            0.20002392, 0.6150934, 0.23236814, 0.28950065, 0.33898464, 0.5701668, 0.51984864,
            0.45874897, 0.78067493, 0.8138102, 0.9551208, 0.5881804, 0.47504795, 0.19136074,
            0.8406687, 0.04588939, 0.30594054, 0.8511978, 0.8773192, 0.8241661, 0.44152674,
            0.38872027, 0.07202522, 0.9640743, 0.5195077, 0.19128811, 0.25130445, 0.39854062,
            0.8797602, 0.7229711, 0.62001854,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (2, 3, 5, 5),
        vec![
            0.69522935, 0.91174835, 0.65982074, 0.10557687, 0.23464549, 0.5982146, 0.28930026,
            0.45670658, 0.47519284, 0.96985734, 0.13737752, 0.33859882, 0.8539295, 0.74257755,
            0.9444382, 0.24404159, 0.7431825, 0.0306461, 0.32723787, 0.8498817, 0.780418,
            0.7744034, 0.47136632, 0.2987932, 0.90784407, 0.6841086, 0.38890767, 0.05255083,
            0.16184397, 0.90099066, 0.498845, 0.29081446, 0.96019644, 0.79299563, 0.47393435,
            0.72834367, 0.6158064, 0.6794256, 0.47645757, 0.3335043, 0.756347, 0.11874896,
            0.36077332, 0.3897357, 0.37567437, 0.98458624, 0.5517178, 0.29212236, 0.9600367,
            0.6615687, 0.06723779, 0.2025786, 0.02713268, 0.80878776, 0.733241, 0.04588867,
            0.02181397, 0.7670707, 0.45551613, 0.6842329, 0.6831582, 0.6664801, 0.3131931,
            0.29468352, 0.85157114, 0.8392736, 0.14075516, 0.85626125, 0.52595836, 0.98014617,
            0.27240536, 0.44448686, 0.82414293, 0.9190075, 0.22366077, 0.8532558, 0.701437,
            0.40568367, 0.37661108, 0.67640066, 0.56091106, 0.04301855, 0.12136482, 0.6737573,
            0.2752744, 0.0267396, 0.94759494, 0.6303967, 0.12444576, 0.72837055, 0.7281102,
            0.2626654, 0.09959164, 0.2171505, 0.30699563, 0.74566257, 0.7291574, 0.75221896,
            0.98712695, 0.14437845, 0.29435056, 0.9106491, 0.34656417, 0.99010134, 0.6754568,
            0.9541668, 0.84239453, 0.3434271, 0.74494994, 0.99503726, 0.16594417, 0.31254604,
            0.43238705, 0.5073427, 0.14618637, 0.09028576, 0.8893203, 0.91551375, 0.49814487,
            0.7052375, 0.65795493, 0.83047026, 0.17178877, 0.10943547, 0.9565582, 0.9222505,
            0.71428937, 0.5576436, 0.4350043, 0.43690363, 0.04750107, 0.6443613, 0.03292517,
            0.5884901, 0.27200705, 0.9026258, 0.826362, 0.0902301, 0.29801482, 0.74622726,
            0.5126913, 0.22947553, 0.6898572, 0.89290726, 0.11439011, 0.2553315, 0.5261063,
            0.96802235, 0.3207074, 0.16912474,
        ],
    )
    .unwrap();
    let conv_layer24 = ConvolutionLayer::new(kernel24, 1, Padding::Valid);
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (2, 2, 2),
        vec![
            17.630993, 20.004028, 19.593887, 20.411974, 16.673708, 17.341614, 18.891315, 17.885439,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );

    let test_input25 = Array::from_shape_vec(
        (3, 10, 15),
        vec![
            0.4287567, 0.69673246, 0.5962988, 0.6583277, 0.95566136, 0.3090088, 0.04040552,
            0.36515298, 0.7484168, 0.38902923, 0.57477367, 0.02147577, 0.12675387, 0.8958077,
            0.57611835, 0.8050715, 0.18574312, 0.9103308, 0.49352488, 0.04084096, 0.32406485,
            0.9127804, 0.32315838, 0.5274155, 0.3541732, 0.43012723, 0.5261415, 0.8519433,
            0.34473136, 0.22837397, 0.16551489, 0.251939, 0.9573879, 0.3333164, 0.45628268,
            0.6485293, 0.03959658, 0.7774604, 0.72181726, 0.25632858, 0.40238795, 0.29511455,
            0.18771167, 0.4778858, 0.88639265, 0.03075815, 0.38190666, 0.5188661, 0.43225557,
            0.443126, 0.7846497, 0.69072247, 0.70348734, 0.48298272, 0.5568704, 0.68944603,
            0.03431003, 0.38795924, 0.6902452, 0.85404575, 0.52294713, 0.14189826, 0.48577386,
            0.0789768, 0.29317725, 0.34614396, 0.42246845, 0.71652186, 0.03888219, 0.95906556,
            0.15285546, 0.94362164, 0.15887408, 0.13075079, 0.15117891, 0.03306201, 0.16711909,
            0.58509, 0.26331437, 0.15727986, 0.39590272, 0.2304746, 0.8428172, 0.32108444,
            0.6584057, 0.22742087, 0.03719785, 0.4095963, 0.6715706, 0.9103236, 0.37286273,
            0.2795822, 0.23605917, 0.16103324, 0.48898628, 0.7769166, 0.63719285, 0.5339775,
            0.5013731, 0.23002648, 0.726385, 0.64956135, 0.10749894, 0.7930301, 0.25076696,
            0.01513924, 0.2581999, 0.03015263, 0.5023638, 0.8415604, 0.43133247, 0.5533162,
            0.562384, 0.6384559, 0.52681637, 0.13921387, 0.09313619, 0.75766635, 0.78449273,
            0.8692138, 0.79183036, 0.72191995, 0.91970456, 0.26611277, 0.45631656, 0.8316374,
            0.60754436, 0.86304337, 0.8193103, 0.47772342, 0.73805946, 0.01831975, 0.71567196,
            0.27518228, 0.09057815, 0.5942683, 0.9828262, 0.6877077, 0.01671847, 0.59191656,
            0.11799596, 0.3565012, 0.5271378, 0.42855334, 0.7159743, 0.33997726, 0.13702092,
            0.30294093, 0.60102206, 0.31660682, 0.47319987, 0.81581175, 0.32806376, 0.2910204,
            0.7040396, 0.7646719, 0.16295868, 0.5199952, 0.10952926, 0.25027466, 0.01479205,
            0.20828883, 0.6572299, 0.16784889, 0.49984223, 0.73934627, 0.7692465, 0.45089912,
            0.42323235, 0.3092633, 0.94342923, 0.5813263, 0.17081867, 0.45052946, 0.5468596,
            0.32220426, 0.97337824, 0.15655027, 0.0631674, 0.9276395, 0.7337421, 0.6282157,
            0.44235066, 0.70144874, 0.2581846, 0.37731636, 0.74292475, 0.7893134, 0.9682662,
            0.07253607, 0.61240184, 0.5712741, 0.7101941, 0.42240703, 0.3144015, 0.23257384,
            0.355786, 0.774386, 0.7575536, 0.44447815, 0.76916295, 0.43969592, 0.09476027,
            0.89676636, 0.25122383, 0.3878751, 0.5271335, 0.21266471, 0.64234614, 0.23638117,
            0.12251099, 0.11175825, 0.6929939, 0.06464646, 0.15909617, 0.64519554, 0.325024,
            0.95026743, 0.57768893, 0.556819, 0.2965687, 0.68271434, 0.17499126, 0.28795037,
            0.6223563, 0.28275678, 0.62251085, 0.05298517, 0.9586377, 0.8305602, 0.53959036,
            0.7768914, 0.3662946, 0.53110784, 0.87225235, 0.14521246, 0.7490009, 0.55172807,
            0.9621208, 0.2896578, 0.23772797, 0.38020673, 0.41068247, 0.15089212, 0.3510485,
            0.28178045, 0.0740529, 0.28524187, 0.20798713, 0.7328364, 0.24482581, 0.13728051,
            0.9986837, 0.6677257, 0.30110443, 0.59491575, 0.33922875, 0.78129905, 0.45983207,
            0.39850447, 0.29452822, 0.3990066, 0.71123666, 0.9245769, 0.80979043, 0.12899092,
            0.03675647, 0.98098063, 0.12195553, 0.5954175, 0.9923433, 0.4660024, 0.42390975,
            0.41920665, 0.63552475, 0.6557143, 0.47023433, 0.57522744, 0.8106476, 0.4967516,
            0.7960696, 0.35081705, 0.5810784, 0.47564268, 0.5950288, 0.23334436, 0.35525572,
            0.65956026, 0.98428434, 0.9814129, 0.8474201, 0.8124901, 0.4688829, 0.6571122,
            0.44344074, 0.72268397, 0.50578433, 0.89210486, 0.29161337, 0.30685803, 0.7015651,
            0.76217693, 0.53040797, 0.23608343, 0.3370403, 0.5153227, 0.12298316, 0.38562468,
            0.39561588, 0.21013618, 0.00794073, 0.21312988, 0.09544598, 0.16640656, 0.39524126,
            0.70305294, 0.6951719, 0.76970625, 0.01947077, 0.72122115, 0.43079308, 0.654422,
            0.33095863, 0.37373173, 0.58761567, 0.49653715, 0.6094103, 0.37502283, 0.7990719,
            0.94719636, 0.90727985, 0.43818596, 0.15018035, 0.26554954, 0.2760564, 0.15040922,
            0.2605517, 0.5976553, 0.6584785, 0.23161498, 0.6921513, 0.64733315, 0.854641,
            0.03501531, 0.919175, 0.9064802, 0.96888334, 0.3072559, 0.23253885, 0.44027686,
            0.44643322, 0.46258068, 0.5722288, 0.78549147, 0.13830437, 0.6860908, 0.06808019,
            0.9976838, 0.354391, 0.21689764, 0.20947075, 0.3030436, 0.6783678, 0.34793916,
            0.91172963, 0.3608854, 0.42308012, 0.8522385, 0.80487376, 0.80669975, 0.20780124,
            0.6568672, 0.9909294, 0.6851016, 0.89588594, 0.5385484, 0.81079435, 0.4669414,
            0.6860896, 0.6578895, 0.45783395, 0.41847235, 0.20630272, 0.4953162, 0.01959337,
            0.8371248, 0.5716346, 0.18082424, 0.03656635, 0.75915194, 0.77819145, 0.18088074,
            0.97228986, 0.45446303, 0.15876009, 0.15172002, 0.21870646, 0.67578596, 0.17699589,
            0.16891658, 0.8514548, 0.8860516, 0.82196736, 0.29569438, 0.6795675, 0.5676109,
            0.51335657, 0.48570013, 0.05080688, 0.14092551, 0.35189822, 0.2716982, 0.43087652,
            0.8219524, 0.58699363, 0.18927561, 0.15438259, 0.48444232, 0.3548947, 0.13443872,
            0.05775462, 0.01398679, 0.3553907, 0.48720175, 0.39191842, 0.7353281, 0.9867899,
            0.39567924, 0.6681931, 0.8741793, 0.41219148, 0.43805563, 0.24787006, 0.4657539,
            0.85423166, 0.0098169, 0.03120668, 0.20878878, 0.54290944, 0.55167097, 0.4212191,
            0.76660496, 0.5203346, 0.55199236, 0.24225757, 0.926732, 0.29546982, 0.90794486,
            0.11640227, 0.303067,
        ],
    )
    .unwrap();

    let kernel25: Array4<f32> = Array::from_shape_vec(
        (2, 3, 3, 3),
        vec![
            0.60486084, 0.67949796, 0.26091522, 0.60724497, 0.814399, 0.1684874, 0.39451823,
            0.42586836, 0.31500933, 0.7739118, 0.26620805, 0.4912706, 0.5582184, 0.14920756,
            0.2643653, 0.33135027, 0.44614497, 0.70298517, 0.4382807, 0.8829611, 0.02333054,
            0.8527415, 0.9057288, 0.2235733, 0.4187059, 0.45508063, 0.9389992, 0.20756939,
            0.20021324, 0.47618693, 0.5130793, 0.5888296, 0.59889996, 0.712934, 0.8516371,
            0.85897654, 0.02912598, 0.49246776, 0.9397661, 0.63142025, 0.5599716, 0.44621915,
            0.24492879, 0.19181061, 0.10366015, 0.23688388, 0.49670485, 0.67701244, 0.45396152,
            0.42133403, 0.6850384, 0.85629207, 0.76669574, 0.8534153,
        ],
    )
    .unwrap();
    let conv_layer25 = ConvolutionLayer::new(kernel25, 1, Padding::Valid);
    let target_output25: Array3<f32> = Array::from_shape_vec(
        (2, 8, 13),
        vec![
            7.4960613, 7.520022, 6.1241846, 5.536114, 5.967259, 6.502649, 6.359076, 5.8601413,
            5.7815905, 5.4713645, 5.9254284, 5.468686, 6.704946, 7.3078437, 7.195328, 5.7446957,
            5.9761467, 5.9574738, 6.506517, 7.426062, 6.5146914, 6.735643, 5.711289, 6.865677,
            6.6456017, 6.4779, 6.6455307, 6.009202, 5.849343, 5.6969285, 5.947377, 7.127538,
            8.059928, 8.224421, 6.766089, 6.3170986, 6.450321, 6.655516, 6.70977, 5.4266915,
            6.3780437, 6.584589, 6.5090995, 6.587246, 6.598739, 7.268816, 7.288707, 7.2103934,
            6.637893, 5.4512396, 6.909529, 6.6881256, 5.3959413, 5.5998297, 5.3654923, 5.4784765,
            5.340443, 6.0579457, 6.1612296, 6.7245183, 6.4308248, 6.8718877, 6.787669, 7.0265827,
            6.052986, 5.446805, 5.697744, 5.675485, 5.538573, 5.6192307, 5.832427, 6.856041,
            7.193828, 5.1354833, 5.9661994, 6.536518, 6.430675, 6.7024503, 5.467424, 5.403739,
            5.545085, 5.548196, 6.3933105, 6.3759117, 7.160047, 7.7906184, 7.0318027, 6.2248216,
            5.7924347, 5.990775, 7.5072885, 5.724515, 6.1760325, 6.5792656, 6.3896093, 7.575648,
            7.5652504, 7.9927435, 8.090205, 8.575911, 6.240385, 5.960195, 5.169037, 6.716258,
            8.187933, 6.457015, 6.4855638, 6.072847, 5.6456943, 6.1935287, 6.608317, 6.1382136,
            5.8045864, 5.4728017, 6.5261374, 6.185129, 7.0380716, 7.7929325, 6.6156363, 5.9337716,
            6.52226, 7.062013, 7.20475, 7.9073586, 7.324489, 7.3282123, 6.2337604, 7.1622133,
            5.963258, 8.264218, 6.119497, 5.967707, 6.364537, 5.9148393, 6.648462, 7.8970346,
            8.379339, 7.7641597, 7.2651606, 6.9727345, 7.325581, 6.8412037, 7.045717, 6.2670016,
            6.3309646, 6.3468995, 6.313865, 6.3981795, 6.892461, 7.5143223, 7.518241, 6.5574064,
            6.41718, 6.195509, 6.3879757, 6.7063413, 6.1752887, 5.7015705, 6.0584702, 6.3568163,
            6.1883554, 7.2927365, 6.9846773, 6.8954782, 6.360342, 7.5702558, 7.201036, 7.184146,
            7.7110023, 5.5115542, 5.6074014, 6.219097, 5.7653575, 5.9569306, 6.153994, 6.371038,
            7.113239, 6.5295005, 6.0269594, 6.229104, 7.0255165, 7.846359, 6.3663063, 5.616705,
            5.9128866, 6.143087, 6.677331, 7.5240006, 8.151494, 8.4031725, 7.9568763, 6.0302305,
            6.525584, 6.65192, 6.9452076, 6.6961107, 6.0691366, 6.2208123, 6.373224, 7.4433856,
            7.7526207, 8.915569, 8.668535, 7.686132, 5.5055175, 6.9002733, 5.883586, 6.5660515,
        ],
    )
    .unwrap();
    let current_output25: Array3<f32> = conv_layer25.convolve(&test_input25);

    assert!(
        arr_allclose(&current_output25, &target_output25),
        "{:?} was not equal to {:?}",
        current_output25,
        target_output25
    );

    let test_input26 = Array::from_shape_vec(
        (3, 10, 15),
        vec![
            0.09939361, 0.82822984, 0.0080629, 0.6076978, 0.6677539, 0.97007126, 0.6953572,
            0.23404987, 0.7702405, 0.4813676, 0.6708753, 0.9848203, 0.11385565, 0.8758087,
            0.7094253, 0.9717235, 0.75492734, 0.5238351, 0.39455086, 0.31395626, 0.9446217,
            0.89547807, 0.2690143, 0.7254593, 0.50680614, 0.67623514, 0.03957006, 0.55472255,
            0.6921552, 0.50038505, 0.52786833, 0.31035745, 0.81599206, 0.6554322, 0.03603773,
            0.5390226, 0.13498625, 0.9852127, 0.16336593, 0.99620885, 0.19921382, 0.10756692,
            0.44649956, 0.9498278, 0.7139447, 0.35815725, 0.02897831, 0.9721884, 0.0504973,
            0.86107606, 0.0762892, 0.7412536, 0.00293741, 0.5842812, 0.80308986, 0.35674444,
            0.5351153, 0.7371504, 0.4191397, 0.79290223, 0.5041107, 0.55641156, 0.04526648,
            0.7861993, 0.6335109, 0.24217102, 0.909113, 0.80903274, 0.83993906, 0.81976044,
            0.7214805, 0.4007092, 0.57626015, 0.95258534, 0.49337667, 0.10905766, 0.94602233,
            0.3964408, 0.50362575, 0.07761287, 0.9322157, 0.31622592, 0.17759776, 0.6427077,
            0.1279444, 0.15542968, 0.97430724, 0.6300257, 0.08167998, 0.75798357, 0.09109604,
            0.76193047, 0.753834, 0.99397695, 0.34140688, 0.5777924, 0.45099398, 0.34813985,
            0.49516845, 0.39270082, 0.56429654, 0.26018232, 0.8857335, 0.69079584, 0.55985487,
            0.84918076, 0.651287, 0.31415004, 0.78383875, 0.24776831, 0.09454908, 0.72278243,
            0.9236739, 0.3642707, 0.08929764, 0.09322322, 0.8198366, 0.618867, 0.8466656,
            0.10928579, 0.07829133, 0.38427126, 0.9209781, 0.05534032, 0.33815342, 0.21587123,
            0.12900938, 0.838805, 0.70533997, 0.33450192, 0.38096663, 0.80549437, 0.5303596,
            0.28034258, 0.09335517, 0.9028811, 0.78340423, 0.99226147, 0.01493673, 0.46203193,
            0.7521283, 0.6052495, 0.06838121, 0.6306182, 0.68300223, 0.1979319, 0.9812565,
            0.35303903, 0.01351135, 0.13854095, 0.8103337, 0.02116127, 0.74512017, 0.52984565,
            0.99872667, 0.5559971, 0.15128084, 0.7154567, 0.5549817, 0.43051603, 0.23737086,
            0.6562062, 0.28059772, 0.39736098, 0.4673331, 0.00891489, 0.33884785, 0.6193884,
            0.18607458, 0.4431885, 0.01808522, 0.11024449, 0.5957428, 0.257344, 0.57106304,
            0.996507, 0.02719511, 0.34088475, 0.31276718, 0.19508527, 0.51521796, 0.55529255,
            0.534297, 0.4551737, 0.03822044, 0.6844804, 0.538391, 0.19699456, 0.41928288,
            0.12089491, 0.15296015, 0.34004238, 0.08433874, 0.59906757, 0.32895055, 0.40649992,
            0.1499156, 0.2017956, 0.29841897, 0.9981424, 0.42835027, 0.58305657, 0.8831124,
            0.58563495, 0.10433917, 0.49506864, 0.40216792, 0.66390544, 0.44003266, 0.67188007,
            0.731435, 0.22884977, 0.45354384, 0.29792643, 0.5272041, 0.7485446, 0.28624305,
            0.9282255, 0.22695023, 0.43092483, 0.95730776, 0.9923889, 0.1289603, 0.71256125,
            0.9421077, 0.22165331, 0.8957009, 0.01525365, 0.46406323, 0.38429326, 0.29330772,
            0.68809766, 0.82745576, 0.3258292, 0.9536923, 0.92134255, 0.80696934, 0.17606957,
            0.53414553, 0.8541269, 0.55071187, 0.25444788, 0.6592291, 0.53072673, 0.77232087,
            0.41289273, 0.10455144, 0.6597538, 0.91647804, 0.9571631, 0.5645497, 0.86060405,
            0.55495816, 0.99726844, 0.39086932, 0.13288063, 0.43203548, 0.02057635, 0.44437656,
            0.00600106, 0.86474377, 0.96837336, 0.52825713, 0.5756082, 0.5063528, 0.616231,
            0.03237247, 0.7064923, 0.24617034, 0.19121489, 0.8937895, 0.5221176, 0.920404,
            0.45497388, 0.84028614, 0.69197804, 0.92198044, 0.00114695, 0.6866234, 0.7426373,
            0.16886179, 0.28282914, 0.7157508, 0.9215918, 0.6186801, 0.02047214, 0.46281454,
            0.6887593, 0.01173675, 0.59077984, 0.3787974, 0.13223803, 0.20979705, 0.2962676,
            0.82381725, 0.62355626, 0.19442007, 0.15597425, 0.44047666, 0.02631165, 0.79910344,
            0.68305826, 0.13235328, 0.36176983, 0.98954594, 0.10666531, 0.8560913, 0.24844927,
            0.94089866, 0.611323, 0.2604722, 0.62072504, 0.52674735, 0.04456268, 0.12730101,
            0.5831064, 0.7618813, 0.99088573, 0.3498497, 0.9893213, 0.9229839, 0.968473, 0.3473291,
            0.54743403, 0.01200672, 0.04459461, 0.11107332, 0.79086024, 0.427044, 0.28423595,
            0.5638385, 0.55078715, 0.5209626, 0.9690265, 0.40990627, 0.76069826, 0.19991861,
            0.05412404, 0.96710503, 0.9513363, 0.08358769, 0.18445559, 0.15507828, 0.55250907,
            0.7522076, 0.41979295, 0.90154666, 0.06932273, 0.98834366, 0.9326744, 0.95973784,
            0.01301026, 0.94750315, 0.19795854, 0.28899273, 0.23282553, 0.28506085, 0.8682599,
            0.8220057, 0.13914691, 0.97130793, 0.03333057, 0.8087165, 0.8024787, 0.3590328,
            0.3778757, 0.29034188, 0.13700394, 0.39205238, 0.24718882, 0.48470175, 0.7902731,
            0.5366342, 0.15042725, 0.83978635, 0.4692924, 0.90220386, 0.14340296, 0.15322222,
            0.34881374, 0.6232285, 0.83594126, 0.16714397, 0.4264953, 0.04108659, 0.89079213,
            0.67103004, 0.61967033, 0.67488444, 0.6248762, 0.07340664, 0.29599693, 0.9083485,
            0.06401163, 0.25583467, 0.43448448, 0.12822089, 0.16394943, 0.70240456, 0.7238483,
            0.549147, 0.33882853, 0.30244493, 0.7881106, 0.18323863, 0.9491711, 0.49022144,
            0.52859294, 0.44141734, 0.6618432, 0.13727196, 0.67812914, 0.7189277, 0.41655356,
            0.22713542, 0.18293881, 0.19180061, 0.53551257, 0.17122072, 0.2234552, 0.44359767,
            0.71808743, 0.22415204, 0.39959106, 0.2637363, 0.9748111, 0.66883224, 0.2623765,
            0.8298644, 0.47769547, 0.64253336, 0.4279932, 0.05377042, 0.8601327, 0.49268875,
            0.61688894, 0.5893039, 0.61891294, 0.22768961, 0.6413237, 0.64964074, 0.28283465,
            0.42210525, 0.9995373, 0.3990037, 0.3180952, 0.26837257, 0.9196311, 0.7323518,
            0.6665136,
        ],
    )
    .unwrap();

    let kernel26: Array4<f32> = Array::from_shape_vec(
        (2, 3, 3, 3),
        vec![
            0.3261171, 0.19029295, 0.3486188, 0.6853804, 0.73598146, 0.53857046, 0.808091,
            0.5484634, 0.1735309, 0.08409429, 0.19677189, 0.31993368, 0.35334954, 0.93418276,
            0.7082613, 0.548942, 0.8944676, 0.9037912, 0.09672975, 0.7584863, 0.50249976,
            0.6728813, 0.9159213, 0.34614602, 0.3804167, 0.17313573, 0.04152302, 0.9053351,
            0.13061608, 0.9456902, 0.08379908, 0.9247798, 0.48921642, 0.9617579, 0.37667143,
            0.7197943, 0.53935903, 0.9792834, 0.86110634, 0.8655558, 0.29825523, 0.10902967,
            0.8346855, 0.7259802, 0.21941453, 0.9845792, 0.46687177, 0.35792756, 0.8629179,
            0.5301964, 0.7178425, 0.50557286, 0.14295319, 0.49131492,
        ],
    )
    .unwrap();
    let conv_layer26 = ConvolutionLayer::new(kernel26, 1, Padding::Valid);
    let target_output26: Array3<f32> = Array::from_shape_vec(
        (2, 8, 13),
        vec![
            7.192999, 6.982718, 6.619751, 6.902206, 6.747887, 7.273383, 6.4084854, 6.2071857,
            6.154577, 5.4226375, 4.093225, 5.092444, 5.6537027, 6.5463667, 6.5554857, 7.0050817,
            7.1599517, 7.3688107, 6.8120947, 6.0513444, 6.2430143, 5.950756, 4.70884, 4.3873115,
            5.7635756, 7.0725446, 6.067881, 5.542929, 7.071627, 8.081983, 7.14532, 6.470763,
            6.935873, 7.259711, 6.4354463, 6.5174036, 6.124279, 7.0908093, 8.263511, 5.838739,
            5.9593077, 6.8895645, 6.733283, 6.6111474, 7.077475, 7.173484, 6.263198, 7.125052,
            7.6733036, 7.8123116, 7.749138, 7.6715045, 6.0303884, 7.033283, 6.386245, 6.1756134,
            5.9583926, 6.7039804, 6.3787556, 6.7401714, 7.468759, 8.311662, 8.154746, 7.6244173,
            7.9001927, 5.9624705, 6.5947948, 5.685267, 6.2827716, 6.1321034, 6.3729367, 6.799776,
            7.189136, 7.0846114, 6.604521, 6.6543303, 7.316294, 7.5815086, 6.9249015, 7.0372,
            6.2376356, 5.9667068, 6.531589, 6.61841, 7.3299055, 7.4472823, 6.2404294, 4.9296227,
            5.786872, 7.4777017, 6.583002, 7.405726, 6.9639196, 6.0694017, 5.449253, 6.7401853,
            6.753256, 5.9908624, 6.759545, 6.871241, 5.6204643, 5.5542316, 6.486207, 5.3551397,
            8.070921, 8.917615, 8.551057, 9.235487, 9.106031, 8.283364, 8.2239, 8.019645,
            7.3108497, 7.0062447, 5.6196294, 7.2332635, 7.275674, 8.103749, 8.369338, 8.578245,
            8.009779, 8.399377, 7.852155, 8.806408, 7.3920875, 8.376381, 5.615701, 5.748501,
            6.6018324, 8.4065075, 7.907961, 8.257768, 7.1187778, 9.482198, 7.8784766, 8.708382,
            6.7615256, 9.300951, 7.238197, 7.300984, 7.239347, 8.026235, 8.505357, 7.434296,
            6.7168345, 8.112482, 8.259521, 8.486857, 8.2770815, 8.559132, 7.5812078, 7.2606807,
            8.401284, 9.283913, 9.196587, 9.492295, 7.5992136, 8.112713, 7.2626004, 8.198039,
            8.20496, 7.1108284, 8.093192, 7.8758163, 8.880297, 9.587186, 10.707557, 9.624898,
            8.979207, 7.6463346, 8.119454, 6.3655257, 6.5483313, 6.9683347, 8.40673, 8.397644,
            7.58655, 8.378958, 8.620756, 8.0322075, 8.999869, 8.626148, 7.7230678, 8.435314,
            8.612946, 7.0753813, 6.690515, 8.392467, 8.9368925, 8.185126, 8.694849, 7.5200114,
            8.114859, 8.3017645, 8.550072, 8.864709, 8.1327, 6.614428, 6.719138, 8.628942,
            8.473183, 9.207858, 7.3369946, 7.874966, 7.7087526, 6.536274, 7.3998876, 6.212691,
        ],
    )
    .unwrap();
    let current_output26: Array3<f32> = conv_layer26.convolve(&test_input26);

    assert!(
        arr_allclose(&current_output26, &target_output26),
        "{:?} was not equal to {:?}",
        current_output26,
        target_output26
    );

    let test_input27 = Array::from_shape_vec(
        (3, 10, 15),
        vec![
            0.69113374, 0.5921124, 0.4342134, 0.9615546, 0.34359774, 0.8039146, 0.11799753,
            0.26661384, 0.15955769, 0.24098068, 0.04284242, 0.72233695, 0.5201091, 0.8670922,
            0.22291587, 0.01988209, 0.19314824, 0.6377711, 0.93071467, 0.23294576, 0.33839074,
            0.21783541, 0.541387, 0.78856933, 0.6345836, 0.9847154, 0.7037668, 0.5997897,
            0.48499247, 0.524876, 0.3821681, 0.09907741, 0.30532846, 0.08845946, 0.5006215,
            0.2398776, 0.6696186, 0.5578283, 0.9853742, 0.30976853, 0.1141604, 0.94015056,
            0.86896497, 0.12097415, 0.7002529, 0.16485341, 0.46633622, 0.67187446, 0.22297226,
            0.20250201, 0.8218346, 0.61939573, 0.53496593, 0.92597115, 0.787276, 0.7033518,
            0.12606671, 0.06126022, 0.68214494, 0.6032527, 0.6562995, 0.49284568, 0.34271526,
            0.9216594, 0.6940483, 0.47624904, 0.2457454, 0.5552098, 0.32579103, 0.48232093,
            0.6059211, 0.6722847, 0.6767117, 0.378767, 0.3613456, 0.7042522, 0.2238173, 0.74746865,
            0.36677414, 0.2613474, 0.28857794, 0.48979157, 0.67423475, 0.899909, 0.27360517,
            0.3954447, 0.2689032, 0.5869422, 0.4054549, 0.7236747, 0.27611768, 0.6796681,
            0.5965492, 0.26442292, 0.72399604, 0.43040073, 0.20080982, 0.28246298, 0.6599278,
            0.91767025, 0.7645698, 0.5936739, 0.36463642, 0.96831554, 0.21878308, 0.11189529,
            0.5395196, 0.29627025, 0.11818971, 0.10945795, 0.6594448, 0.13544263, 0.499514,
            0.4529453, 0.7131112, 0.07966255, 0.29142585, 0.68724895, 0.04232477, 0.13420771,
            0.33155695, 0.18794546, 0.46529654, 0.69078076, 0.02903101, 0.8734327, 0.80222553,
            0.87264, 0.45615637, 0.5333259, 0.2464628, 0.38038793, 0.32190928, 0.21625711,
            0.5803451, 0.77878344, 0.5063043, 0.7617363, 0.08551037, 0.49260572, 0.83634585,
            0.85251176, 0.26562026, 0.11365525, 0.29192793, 0.5136638, 0.52510726, 0.9699456,
            0.38765427, 0.00939824, 0.45361686, 0.995697, 0.92569697, 0.11329727, 0.26731393,
            0.503521, 0.8463833, 0.9085028, 0.3704941, 0.9285037, 0.12043773, 0.67069006,
            0.8701852, 0.46525767, 0.6889376, 0.46818328, 0.5472589, 0.6721221, 0.90702206,
            0.09271611, 0.28051263, 0.18856683, 0.93896073, 0.90126437, 0.45777324, 0.82003325,
            0.74227345, 0.35982916, 0.26917773, 0.20851454, 0.02530834, 0.20598832, 0.9827812,
            0.9133796, 0.15525481, 0.5416497, 0.9737615, 0.05620801, 0.5500161, 0.07101188,
            0.06457912, 0.01951568, 0.7752038, 0.58928204, 0.4893268, 0.37889206, 0.08488933,
            0.6984468, 0.13838367, 0.45322236, 0.2854609, 0.91733086, 0.7673163, 0.47535938,
            0.430336, 0.4033134, 0.22314279, 0.9198305, 0.15463823, 0.52706516, 0.5380625,
            0.67769825, 0.29269645, 0.5224842, 0.9161704, 0.8363249, 0.9655628, 0.6265972,
            0.62550986, 0.10147168, 0.37210664, 0.38499138, 0.57677186, 0.04776173, 0.13979574,
            0.34796357, 0.9293805, 0.02366208, 0.61658883, 0.4602623, 0.80627346, 0.68917644,
            0.03279204, 0.61764413, 0.84899485, 0.07298613, 0.5107428, 0.15994577, 0.23598829,
            0.42557174, 0.54054207, 0.9973023, 0.7787232, 0.34836137, 0.25666964, 0.21393713,
            0.13617612, 0.29511, 0.47935697, 0.6027421, 0.26824012, 0.09325973, 0.9999695,
            0.66342247, 0.30268312, 0.4703405, 0.5264845, 0.41914597, 0.93084306, 0.3860588,
            0.3112818, 0.5403318, 0.7544129, 0.23385784, 0.4532712, 0.01928642, 0.31058535,
            0.9231324, 0.5111338, 0.85251105, 0.22631837, 0.6079196, 0.8465506, 0.15559341,
            0.47655347, 0.9317292, 0.73171294, 0.4252797, 0.8793211, 0.8085952, 0.8205566,
            0.8826353, 0.87073565, 0.9907962, 0.2437348, 0.04408429, 0.9780975, 0.83518285,
            0.442418, 0.9607086, 0.09084356, 0.68804723, 0.78929913, 0.7980087, 0.09648526,
            0.31804043, 0.9619224, 0.99013287, 0.8503088, 0.7815283, 0.39002457, 0.42641845,
            0.6908657, 0.8910958, 0.29640055, 0.17727828, 0.2089261, 0.49979007, 0.5642379,
            0.7030672, 0.27845028, 0.94389766, 0.20636925, 0.6667202, 0.76393694, 0.48988733,
            0.7356281, 0.5468075, 0.6818526, 0.6987177, 0.40215194, 0.33184996, 0.23738323,
            0.42945445, 0.64908034, 0.5833552, 0.97156674, 0.30805972, 0.8751756, 0.29061684,
            0.32266703, 0.7455838, 0.39886904, 0.45468414, 0.77469295, 0.7965488, 0.7646959,
            0.2791718, 0.26557565, 0.51671654, 0.14463307, 0.49024066, 0.5644179, 0.11350685,
            0.04281154, 0.57114464, 0.39833462, 0.2126663, 0.1499708, 0.73064125, 0.4591814,
            0.0285126, 0.9280576, 0.72670996, 0.34472197, 0.18288209, 0.8307759, 0.43013144,
            0.35543966, 0.7593779, 0.45248675, 0.78150374, 0.98412323, 0.8635111, 0.6667131,
            0.5340124, 0.13950849, 0.5753187, 0.22581473, 0.31055018, 0.3559486, 0.94544613,
            0.8794452, 0.2699716, 0.45676422, 0.20421512, 0.9916458, 0.83325416, 0.89352185,
            0.35738185, 0.944354, 0.84149826, 0.31955966, 0.0488622, 0.17070445, 0.6034462,
            0.36290234, 0.8472129, 0.49671844, 0.19694914, 0.80763394, 0.21147081, 0.22211874,
            0.43805566, 0.43717724, 0.89430046, 0.9283719, 0.8128758, 0.7373128, 0.42566535,
            0.44624192, 0.23623948, 0.8063544, 0.26903114, 0.20805733, 0.03382581, 0.48451242,
            0.56668675, 0.22873266, 0.299916, 0.9879018, 0.10301294, 0.24334253, 0.44374004,
            0.6423686, 0.8110261, 0.78476405, 0.6695578, 0.93565845, 0.371802, 0.9326136,
            0.8960472, 0.2305824, 0.10865664, 0.7400156, 0.52640325, 0.5962613, 0.49422848,
            0.8606839, 0.99988186, 0.56603134, 0.48357183, 0.35112807, 0.57117814, 0.8400437,
            0.13524966, 0.9466828, 0.39311504, 0.9012402, 0.75557137, 0.5037727, 0.4219725,
            0.47999805, 0.22245023, 0.7799652, 0.29572076, 0.7884574, 0.87387353, 0.88842475,
            0.46210247,
        ],
    )
    .unwrap();

    let kernel27: Array4<f32> = Array::from_shape_vec(
        (2, 3, 3, 3),
        vec![
            0.9100606, 0.6943571, 0.28570879, 0.49740204, 0.7628443, 0.69361484, 0.16655016,
            0.26878476, 0.5833351, 0.987483, 0.6433668, 0.26489744, 0.33358738, 0.00685212,
            0.658877, 0.97735417, 0.72935826, 0.9653691, 0.4197044, 0.03449651, 0.8037367,
            0.88689566, 0.19757593, 0.33775258, 0.9949134, 0.35532916, 0.9893505, 0.08079711,
            0.9904894, 0.34009922, 0.9768461, 0.44599372, 0.09269939, 0.15401787, 0.9979789,
            0.43281078, 0.7613341, 0.94856584, 0.74674773, 0.33150923, 0.81601155, 0.5795955,
            0.6268428, 0.08034612, 0.86004764, 0.23814383, 0.23848392, 0.10764247, 0.15689476,
            0.7057333, 0.01841728, 0.17239508, 0.5349574, 0.27755457,
        ],
    )
    .unwrap();
    let conv_layer27 = ConvolutionLayer::new(kernel27, 1, Padding::Valid);
    let target_output27: Array3<f32> = Array::from_shape_vec(
        (2, 8, 13),
        vec![
            7.571168, 9.929994, 8.581801, 7.863032, 7.344236, 7.761, 8.115382, 6.9911036,
            6.4709363, 7.7287765, 7.037992, 8.755014, 7.929541, 6.2717867, 6.6222606, 7.586645,
            7.02431, 7.172257, 7.514618, 9.053203, 9.10583, 7.901812, 7.848451, 8.324053, 8.356944,
            7.5136757, 6.9973497, 7.6402006, 8.736449, 8.233407, 9.019209, 8.935539, 8.354139,
            7.9824224, 7.015673, 6.0423136, 6.9579496, 7.069241, 7.5385685, 6.943337, 8.856563,
            8.525792, 8.633766, 8.35564, 8.999252, 8.257744, 7.3431644, 7.147656, 7.354768,
            7.2179637, 6.671339, 7.383324, 8.6086445, 9.029496, 7.846073, 8.802218, 7.7951756,
            8.366515, 8.576991, 8.024639, 6.745002, 6.428739, 7.824383, 7.455045, 8.025267,
            7.7015047, 7.877399, 6.630463, 8.117988, 6.627183, 7.931352, 7.1622314, 8.035651,
            7.9604087, 7.0372453, 8.03113, 7.8711214, 8.092486, 7.5600247, 8.124037, 6.4984164,
            6.9868927, 8.109597, 8.360254, 7.5492454, 8.810068, 9.159963, 8.972775, 8.801173,
            8.515307, 8.963357, 7.444936, 8.593333, 7.7991614, 8.102214, 8.231705, 8.306848,
            8.321987, 8.4207115, 7.4597077, 8.403162, 8.245604, 10.1555395, 8.920879, 6.5348825,
            7.0367856, 6.8833556, 6.2819, 5.8363867, 5.8902497, 6.975468, 6.60845, 5.958031,
            5.8094068, 8.272049, 7.0429244, 6.5490055, 5.9114857, 6.413248, 6.3769994, 4.994327,
            6.212245, 6.223331, 7.493389, 7.824472, 7.150369, 5.8249655, 6.376439, 6.2920084,
            6.3329997, 5.0385838, 6.7181387, 6.937295, 6.5384655, 6.897341, 7.2043085, 7.5534916,
            5.950342, 5.403566, 4.5929728, 6.944055, 5.979914, 5.1448083, 6.04799, 7.0089674,
            5.926513, 6.947769, 7.858082, 7.1015368, 7.559522, 6.830007, 5.164758, 5.560041,
            5.5026207, 6.185266, 5.6668, 7.202328, 6.499787, 7.3548856, 7.1261864, 7.236363,
            6.5372815, 6.4254723, 6.5759716, 6.250139, 5.4295983, 6.220609, 5.98645, 5.6634927,
            6.2281537, 6.9695168, 4.9039783, 5.5273194, 6.5515995, 5.8227797, 5.579306, 6.7159653,
            5.941651, 5.60782, 5.6974845, 6.685227, 6.1550803, 6.7305956, 6.533818, 5.6360564,
            5.16458, 6.1262703, 6.19678, 6.3267703, 7.0324454, 7.3202243, 6.276346, 6.1672044,
            7.269972, 7.6011744, 6.7131047, 6.4484367, 6.026784, 6.178889, 7.3497534, 7.244504,
            6.88216, 6.575766, 6.5732675, 6.152131, 7.2200556, 8.586991, 7.2223973,
        ],
    )
    .unwrap();
    let current_output27: Array3<f32> = conv_layer27.convolve(&test_input27);

    assert!(
        arr_allclose(&current_output27, &target_output27),
        "{:?} was not equal to {:?}",
        current_output27,
        target_output27
    );

    let test_input28 = Array::from_shape_vec(
        (3, 10, 15),
        vec![
            0.5322748, 0.07772017, 0.11139348, 0.8153644, 0.89346814, 0.08395886, 0.40988755,
            0.9683522, 0.71043, 0.24133632, 0.66086763, 0.45239362, 0.7648658, 0.7839022,
            0.11525997, 0.11204641, 0.9365747, 0.28355595, 0.94687665, 0.03193681, 0.95543647,
            0.31404087, 0.45478263, 0.4682662, 0.14600264, 0.11851353, 0.6869693, 0.8751561,
            0.24598803, 0.51128346, 0.21171108, 0.07832938, 0.5420683, 0.16797651, 0.97511005,
            0.46346098, 0.9251605, 0.8355728, 0.9399698, 0.63095194, 0.01171468, 0.31194556,
            0.8929391, 0.8565048, 0.4575972, 0.12795849, 0.10912379, 0.02952798, 0.10989773,
            0.4077279, 0.05740095, 0.90538734, 0.35906726, 0.558365, 0.3003097, 0.26236704,
            0.63975835, 0.6486522, 0.65862477, 0.799062, 0.69226533, 0.11245026, 0.44999343,
            0.19131283, 0.5685218, 0.58138865, 0.8676397, 0.6949583, 0.9890714, 0.9169408,
            0.6733708, 0.11409238, 0.9313712, 0.8991999, 0.4750676, 0.14831749, 0.6030878,
            0.1869184, 0.89142025, 0.73000854, 0.8760484, 0.10900346, 0.48400247, 0.0823018,
            0.06097801, 0.19118872, 0.33851793, 0.8297556, 0.25460038, 0.6896478, 0.46926925,
            0.9184611, 0.61307687, 0.6560135, 0.2807583, 0.12817004, 0.35788414, 0.73211795,
            0.766394, 0.8459047, 0.6683304, 0.87622136, 0.6872295, 0.33361897, 0.32000798,
            0.79336315, 0.51849383, 0.38584012, 0.69625896, 0.6791682, 0.20234333, 0.6032861,
            0.48042777, 0.29644713, 0.21245298, 0.6937536, 0.08710819, 0.7783868, 0.9167911,
            0.5954896, 0.33385372, 0.6801258, 0.89744276, 0.18934485, 0.0564688, 0.82598114,
            0.98988926, 0.7848688, 0.3775057, 0.835442, 0.3418887, 0.80864924, 0.8285267,
            0.9124181, 0.28085634, 0.48125055, 0.07043128, 0.47305906, 0.21471797, 0.37207896,
            0.10534421, 0.6173871, 0.49574846, 0.8706143, 0.62692714, 0.12505583, 0.32882455,
            0.13899311, 0.3103582, 0.88731766, 0.09477642, 0.6096313, 0.97063476, 0.33909172,
            0.24199934, 0.32436553, 0.50521874, 0.40645203, 0.72868264, 0.1845745, 0.67775714,
            0.80771196, 0.20815027, 0.76091385, 0.4281172, 0.04814293, 0.2477421, 0.7363536,
            0.82568175, 0.23572317, 0.8921248, 0.00548277, 0.49046424, 0.6364155, 0.9520912,
            0.5670339, 0.6343222, 0.43334082, 0.30917186, 0.22897069, 0.4161656, 0.06782987,
            0.68388855, 0.13053188, 0.19831854, 0.2792772, 0.82981783, 0.38844034, 0.6897695,
            0.43391317, 0.23881091, 0.4751435, 0.1526219, 0.7832937, 0.6972274, 0.76765394,
            0.48872954, 0.97543496, 0.8414392, 0.5716796, 0.5746593, 0.22662647, 0.72878736,
            0.8178856, 0.75768614, 0.44170135, 0.74363214, 0.03670884, 0.54763687, 0.20077299,
            0.569372, 0.13181128, 0.1308109, 0.4016911, 0.02235833, 0.55760676, 0.83430797,
            0.360836, 0.5673803, 0.9199618, 0.7916734, 0.33047372, 0.5523309, 0.7768597,
            0.49729654, 0.60879946, 0.85824955, 0.18380235, 0.8484274, 0.9645565, 0.12606913,
            0.62333465, 0.40896285, 0.6054057, 0.72344357, 0.6434178, 0.35723293, 0.93422616,
            0.2303441, 0.89859825, 0.4833327, 0.8840179, 0.7071074, 0.38079956, 0.89847404,
            0.76911914, 0.69664335, 0.9301381, 0.5279102, 0.6375929, 0.41758484, 0.05990019,
            0.05685853, 0.2730421, 0.86265, 0.8684104, 0.48180395, 0.6010754, 0.88915735,
            0.63210744, 0.07892385, 0.7639226, 0.6205975, 0.3002219, 0.89278924, 0.9059564,
            0.22659945, 0.14760193, 0.00599372, 0.30542406, 0.72884977, 0.8716085, 0.50342596,
            0.41313493, 0.8858185, 0.6434107, 0.457201, 0.5369807, 0.17925061, 0.61535144,
            0.64973146, 0.41555944, 0.61887467, 0.17343594, 0.544464, 0.19735774, 0.6933606,
            0.5880696, 0.80442405, 0.22769123, 0.53898126, 0.87782377, 0.3336502, 0.02226985,
            0.09958417, 0.27681005, 0.18543234, 0.21413611, 0.26165754, 0.027802, 0.9319044,
            0.92774296, 0.18005316, 0.81092876, 0.6219011, 0.7795068, 0.727294, 0.5608989,
            0.5227581, 0.16359355, 0.11108088, 0.88981736, 0.20012106, 0.7049294, 0.54065806,
            0.43730915, 0.60061646, 0.7395392, 0.7470405, 0.68801785, 0.95084524, 0.81441253,
            0.09777608, 0.89484024, 0.82783866, 0.06093569, 0.91676915, 0.46885744, 0.43228298,
            0.4377543, 0.16224979, 0.06134897, 0.2022184, 0.07522171, 0.7521909, 0.03596852,
            0.28626588, 0.75235975, 0.64913374, 0.92554736, 0.6520992, 0.83952224, 0.42260578,
            0.20702457, 0.30891684, 0.2664503, 0.9631269, 0.31632707, 0.41035688, 0.83820975,
            0.8525341, 0.94491214, 0.3128124, 0.94421536, 0.29261506, 0.43404636, 0.16094153,
            0.66423815, 0.06268399, 0.9579144, 0.7502819, 0.09143817, 0.5871392, 0.09202226,
            0.05626365, 0.9499455, 0.29447657, 0.79507726, 0.7507363, 0.89040357, 0.25231564,
            0.70364726, 0.9338168, 0.16046774, 0.06850108, 0.14086206, 0.18575045, 0.94590175,
            0.778617, 0.01911113, 0.3645535, 0.18393157, 0.711382, 0.29766196, 0.9409139,
            0.66175574, 0.06250098, 0.8391969, 0.1826374, 0.27238533, 0.66940516, 0.02453929,
            0.21670069, 0.7854602, 0.2715362, 0.31696305, 0.45880696, 0.12966864, 0.9414358,
            0.5301901, 0.6730583, 0.19911295, 0.61133265, 0.9958221, 0.8324337, 0.81940347,
            0.52347237, 0.30397218, 0.23559988, 0.7169752, 0.83921856, 0.00453156, 0.07645657,
            0.6461333, 0.31977177, 0.44444507, 0.51352835, 0.82848716, 0.12873596, 0.19493581,
            0.12292414, 0.52158403, 0.06434184, 0.2047097, 0.32419515, 0.11837589, 0.95561635,
            0.8962471, 0.7274973, 0.8625563, 0.16951792, 0.89949924, 0.30796447, 0.48415482,
            0.50550425, 0.24823008, 0.4232015, 0.24034186, 0.5031169, 0.2196024, 0.4342684,
            0.98074585, 0.94563127, 0.44097564, 0.03213529, 0.49693355, 0.6025867, 0.2574467,
            0.45553604, 0.44379726,
        ],
    )
    .unwrap();

    let kernel28: Array4<f32> = Array::from_shape_vec(
        (2, 3, 5, 5),
        vec![
            0.9732424, 0.3627867, 0.2487736, 0.21001962, 0.91017437, 0.39797536, 0.26517463,
            0.41195875, 0.38203195, 0.0038282, 0.68331534, 0.45850393, 0.08282983, 0.7426654,
            0.7270585, 0.7993262, 0.18561168, 0.73794276, 0.13075382, 0.92822397, 0.64137435,
            0.43831322, 0.28829068, 0.4976225, 0.2610342, 0.17956546, 0.9744765, 0.5678443,
            0.12135573, 0.63540924, 0.03319374, 0.29163483, 0.8615789, 0.13130435, 0.4782706,
            0.47632742, 0.84865195, 0.28834382, 0.99329984, 0.23911464, 0.05297824, 0.39004716,
            0.4614755, 0.71394044, 0.36967713, 0.72813416, 0.32832128, 0.7320835, 0.8497422,
            0.4687296, 0.5392427, 0.0656543, 0.10209152, 0.1913664, 0.26282084, 0.36334252,
            0.24959058, 0.68387175, 0.02750501, 0.24431834, 0.15333544, 0.79784447, 0.98453826,
            0.3191993, 0.7073291, 0.6451119, 0.6700582, 0.6492628, 0.6315665, 0.00915827,
            0.5234909, 0.88483644, 0.7887491, 0.08833914, 0.5141419, 0.07875764, 0.22806701,
            0.7883233, 0.30477428, 0.2533327, 0.6694263, 0.43796757, 0.97122884, 0.6450341,
            0.5453457, 0.6860607, 0.9949823, 0.46345225, 0.65992147, 0.9109329, 0.5078866,
            0.35286993, 0.81354123, 0.47349572, 0.69897413, 0.5385581, 0.93777996, 0.29683718,
            0.08466158, 0.00917824, 0.36412132, 0.31364414, 0.89281446, 0.2942369, 0.58694243,
            0.14618948, 0.6854037, 0.9551381, 0.21801536, 0.02948874, 0.7533694, 0.6179016,
            0.0048431, 0.8363674, 0.7436905, 0.43101177, 0.47684282, 0.8383103, 0.19812581,
            0.05256698, 0.0566386, 0.72115874, 0.5015921, 0.30938643, 0.0141753, 0.52415645,
            0.96125233, 0.78953046, 0.92893124, 0.80651444, 0.80715597, 0.2586318, 0.7037131,
            0.19224383, 0.6862902, 0.58040166, 0.43242833, 0.34644595, 0.54378766, 0.4958622,
            0.6951301, 0.64524394, 0.73673743, 0.73902684, 0.3842309, 0.29721686, 0.4160744,
            0.6445482, 0.6938951, 0.5561245,
        ],
    )
    .unwrap();
    let conv_layer28 = ConvolutionLayer::new(kernel28, 1, Padding::Valid);
    let target_output28: Array3<f32> = Array::from_shape_vec(
        (2, 6, 11),
        vec![
            15.104526, 15.1358595, 15.346091, 18.906687, 19.798492, 20.289413, 21.264915,
            21.112602, 19.602695, 18.927656, 17.490812, 15.290315, 17.344318, 17.996645, 17.757742,
            19.813417, 19.704372, 19.772362, 19.336216, 20.544607, 17.635363, 17.724537, 15.197325,
            16.635454, 16.633667, 17.846743, 19.71405, 20.100096, 20.388405, 20.2485, 19.519524,
            18.76002, 17.211538, 18.251194, 18.00555, 15.883455, 18.59063, 17.761435, 17.391407,
            19.264294, 19.858694, 18.994324, 16.877083, 17.09143, 16.647469, 17.108015, 18.538637,
            16.685413, 18.910294, 20.122688, 20.176601, 19.60112, 20.478422, 18.796186, 17.500238,
            17.5186, 17.061108, 17.154362, 19.54517, 16.455885, 17.32841, 18.934975, 17.474516,
            16.898832, 16.43411, 15.649134, 16.921124, 19.176418, 20.243298, 21.163141, 22.692764,
            22.979229, 21.681833, 21.625086, 22.062315, 20.797106, 19.053425, 17.39196, 17.55824,
            19.80514, 20.639996, 22.861818, 23.978003, 22.195444, 22.386118, 21.71707, 20.19235,
            19.74541, 16.57707, 17.496126, 19.342607, 18.812098, 20.741144, 22.1924, 24.097525,
            21.660166, 22.402048, 21.458826, 20.66625, 20.23794, 19.286272, 19.54842, 21.086206,
            20.9738, 22.274326, 21.418234, 21.570053, 21.736855, 20.266533, 18.288588, 18.312172,
            19.766916, 19.392237, 19.946848, 20.687574, 22.164442, 21.4979, 21.387959, 22.519617,
            20.367973, 20.825447, 19.840343, 18.763859, 19.202637, 20.307875, 19.761421, 20.631811,
            21.912178, 19.95978, 20.796644, 19.969812, 18.425827,
        ],
    )
    .unwrap();
    let current_output28: Array3<f32> = conv_layer28.convolve(&test_input28);

    assert!(
        arr_allclose(&current_output28, &target_output28),
        "{:?} was not equal to {:?}",
        current_output28,
        target_output28
    );

    let test_input29 = Array::from_shape_vec(
        (3, 10, 15),
        vec![
            0.6222151, 0.75789964, 0.8944672, 0.92868453, 0.969901, 0.12573825, 0.04893699,
            0.9834889, 0.1309708, 0.10405056, 0.8907584, 0.19249535, 0.7266609, 0.97847944,
            0.88732064, 0.04145219, 0.40886414, 0.94225925, 0.48782048, 0.3212815, 0.33589965,
            0.548731, 0.39472353, 0.20935446, 0.45881256, 0.878493, 0.11820386, 0.33547178,
            0.7895801, 0.6146396, 0.540371, 0.75543076, 0.9328607, 0.7910178, 0.23345572,
            0.08010992, 0.78839546, 0.5435443, 0.8130077, 0.84049743, 0.16837756, 0.35681823,
            0.9842876, 0.7681288, 0.33871782, 0.3631438, 0.8542315, 0.69573396, 0.04040196,
            0.5103013, 0.87327087, 0.37753972, 0.5957757, 0.19604516, 0.4733552, 0.8233244,
            0.9322211, 0.9590118, 0.8555658, 0.8988257, 0.69483554, 0.25473273, 0.5802638,
            0.46147576, 0.8721091, 0.29316396, 0.5244579, 0.3030269, 0.43613002, 0.26899648,
            0.55013156, 0.377008, 0.41173777, 0.36448047, 0.6758455, 0.53783196, 0.5878724,
            0.99191517, 0.95134264, 0.49309427, 0.87526673, 0.6049057, 0.9610754, 0.25857434,
            0.15807904, 0.8105548, 0.5614543, 0.523342, 0.00024235, 0.24716882, 0.62018555,
            0.20580722, 0.5964632, 0.4590641, 0.42482692, 0.4591073, 0.28503576, 0.02397736,
            0.7026854, 0.38717398, 0.7226435, 0.05888641, 0.19813369, 0.2862437, 0.86936975,
            0.98584664, 0.33910662, 0.04178984, 0.8388797, 0.8752055, 0.19628692, 0.32806987,
            0.19625323, 0.48324484, 0.26547596, 0.29169068, 0.34818614, 0.54155624, 0.55841756,
            0.43203035, 0.90635383, 0.6221619, 0.13312028, 0.58438164, 0.24158852, 0.59230626,
            0.80972457, 0.78276193, 0.18394487, 0.59019595, 0.94054115, 0.44074106, 0.6780788,
            0.5855126, 0.8341198, 0.0958912, 0.42005202, 0.5426904, 0.47856295, 0.6827206,
            0.02972909, 0.85674536, 0.7115263, 0.7810133, 0.7028763, 0.61693937, 0.9954068,
            0.53743315, 0.6575606, 0.96492666, 0.31929258, 0.02934249, 0.562458, 0.09922413,
            0.8669238, 0.3993404, 0.07765451, 0.7353419, 0.00198996, 0.446601, 0.49630404,
            0.79839313, 0.58093804, 0.21345796, 0.7230826, 0.4849385, 0.820553, 0.6282394,
            0.20790926, 0.17480347, 0.10601443, 0.8150346, 0.12723699, 0.27046126, 0.28842458,
            0.7203788, 0.6991658, 0.2606844, 0.5244236, 0.32585683, 0.7152744, 0.68926454,
            0.38133958, 0.8642892, 0.5063956, 0.5213885, 0.59597003, 0.8505795, 0.77488744,
            0.32738405, 0.52149975, 0.34216303, 0.22714303, 0.76833695, 0.36691627, 0.14223123,
            0.67387354, 0.09267096, 0.4985312, 0.5844687, 0.7644656, 0.28446305, 0.3201185,
            0.2696341, 0.8578446, 0.09514732, 0.59979403, 0.5093849, 0.71366805, 0.8897497,
            0.5639982, 0.4865683, 0.57541674, 0.6326081, 0.5130441, 0.49034655, 0.7037209,
            0.33208346, 0.63787574, 0.6291706, 0.47421247, 0.23486345, 0.869952, 0.65361416,
            0.03662743, 0.51462924, 0.9196911, 0.8793221, 0.78186774, 0.48471546, 0.5383869,
            0.62534815, 0.3553714, 0.9968118, 0.49688724, 0.37583, 0.19825909, 0.93685853,
            0.68677646, 0.24576978, 0.36799955, 0.66436833, 0.40309098, 0.40307763, 0.6084176,
            0.90556717, 0.6977219, 0.19649448, 0.12604196, 0.43395323, 0.05938564, 0.06919543,
            0.6597403, 0.9080266, 0.5624922, 0.28784844, 0.02659295, 0.47776845, 0.761984,
            0.79841346, 0.79470664, 0.02110602, 0.5436528, 0.7113907, 0.18104874, 0.24870853,
            0.57747316, 0.61245716, 0.03752139, 0.94574445, 0.4681282, 0.969797, 0.12823386,
            0.15993103, 0.42355734, 0.72048515, 0.48144373, 0.858121, 0.33813378, 0.9778505,
            0.46431798, 0.22258297, 0.6278271, 0.25811204, 0.72843254, 0.27373013, 0.27433896,
            0.732491, 0.686285, 0.9107763, 0.52486306, 0.02864541, 0.6327045, 0.38749784,
            0.44100302, 0.78058934, 0.14124234, 0.28628784, 0.76789916, 0.37555936, 0.43971175,
            0.04331319, 0.09780997, 0.40862006, 0.70528007, 0.09185711, 0.823536, 0.81429756,
            0.07302681, 0.6152849, 0.9356227, 0.77982754, 0.72116077, 0.7105842, 0.4034548,
            0.80509216, 0.09783126, 0.21926212, 0.13207655, 0.7015808, 0.17238653, 0.18460116,
            0.5575821, 0.5780929, 0.04024655, 0.60567653, 0.67101526, 0.11163998, 0.9730741,
            0.7957075, 0.13753681, 0.4249914, 0.959029, 0.64616, 0.01944306, 0.0451069, 0.60988927,
            0.5702975, 0.9154141, 0.298369, 0.47126326, 0.56598395, 0.57679987, 0.28650796,
            0.35120928, 0.22292198, 0.76072216, 0.83723956, 0.61290085, 0.14372927, 0.35133615,
            0.2495688, 0.98542094, 0.44534236, 0.26395977, 0.6413618, 0.29018158, 0.7026515,
            0.46130356, 0.83116454, 0.38838807, 0.7658825, 0.2515203, 0.15498321, 0.32756808,
            0.10193888, 0.37098822, 0.16565025, 0.6440687, 0.39290613, 0.8382721, 0.4127133,
            0.66124403, 0.8694313, 0.91799986, 0.7149846, 0.17257373, 0.72377336, 0.43520793,
            0.32025692, 0.2293873, 0.20685975, 0.5618886, 0.03298171, 0.04516815, 0.28889108,
            0.37819353, 0.35941374, 0.22646557, 0.4865611, 0.06850646, 0.36713555, 0.97507524,
            0.9856017, 0.13691914, 0.25587377, 0.23198135, 0.63168263, 0.90634483, 0.62659276,
            0.00830113, 0.57375854, 0.66081995, 0.4511592, 0.7095235, 0.3701531, 0.44504768,
            0.49891138, 0.54966915, 0.5332531, 0.02767666, 0.48693478, 0.61392415, 0.8851657,
            0.26826328, 0.40765005, 0.27840444, 0.89372283, 0.997754, 0.46338457, 0.78445923,
            0.582613, 0.74148726, 0.58712804, 0.25544515, 0.38590935, 0.6811402, 0.50827444,
            0.666266, 0.23000365, 0.408603, 0.913767, 0.06065572, 0.15407899, 0.6195248, 0.8449633,
            0.7626016, 0.18244016, 0.17815381, 0.26175067, 0.04169152, 0.30446777, 0.9487898,
            0.73767346, 0.88644, 0.420784, 0.0778392, 0.8826608, 0.6492047, 0.38854632,
        ],
    )
    .unwrap();

    let kernel29: Array4<f32> = Array::from_shape_vec(
        (2, 3, 5, 5),
        vec![
            0.68384963, 0.6266061, 0.54694176, 0.02779119, 0.5851739, 0.89240646, 0.86535263,
            0.20996386, 0.13090512, 0.7281471, 0.39318708, 0.32672238, 0.6848633, 0.84961617,
            0.45679867, 0.6759397, 0.64456964, 0.96701485, 0.16086549, 0.7087405, 0.8894942,
            0.6475722, 0.18771772, 0.2012408, 0.94878227, 0.58967286, 0.80090123, 0.5799347,
            0.9178668, 0.16573429, 0.58338785, 0.47667617, 0.9532117, 0.21564776, 0.89133877,
            0.17446654, 0.0107795, 0.29889566, 0.39913234, 0.5302894, 0.07816543, 0.7402852,
            0.98573536, 0.30748606, 0.993621, 0.03758357, 0.13146874, 0.86146384, 0.6949514,
            0.24558839, 0.7706656, 0.63164335, 0.81027585, 0.4823058, 0.00178706, 0.4582198,
            0.65619093, 0.28412482, 0.03629474, 0.45011836, 0.35812908, 0.02914437, 0.6919308,
            0.10555214, 0.27197847, 0.08190992, 0.74310327, 0.79646134, 0.6624408, 0.15210663,
            0.20802912, 0.5044609, 0.86376214, 0.9537763, 0.6020873, 0.8303515, 0.9588753,
            0.73197967, 0.43450552, 0.6544757, 0.13750179, 0.45277232, 0.91661334, 0.7614271,
            0.42497006, 0.14067934, 0.44368562, 0.79865277, 0.64449096, 0.92738414, 0.8958137,
            0.12830848, 0.04963119, 0.81917155, 0.42274445, 0.05446685, 0.04101894, 0.09930792,
            0.52868897, 0.25766373, 0.46413782, 0.83290285, 0.2857464, 0.93483084, 0.7527259,
            0.6627151, 0.9741788, 0.8654456, 0.03159403, 0.08091403, 0.14496519, 0.9354205,
            0.9959894, 0.7941408, 0.7423276, 0.02799125, 0.03848875, 0.8054729, 0.99117136,
            0.6498168, 0.32092866, 0.3983662, 0.14606105, 0.5199574, 0.4899074, 0.5360965,
            0.44993454, 0.03084684, 0.408017, 0.5713909, 0.7360495, 0.6618847, 0.9357826,
            0.8706936, 0.21162367, 0.21231653, 0.5704002, 0.7295462, 0.39067075, 0.23692593,
            0.02214848, 0.4187255, 0.4807955, 0.39574632, 0.6238521, 0.27060798, 0.93228406,
            0.65184224, 0.71227604, 0.09648224,
        ],
    )
    .unwrap();
    let conv_layer29 = ConvolutionLayer::new(kernel29, 1, Padding::Valid);
    let target_output29: Array3<f32> = Array::from_shape_vec(
        (2, 6, 11),
        vec![
            18.94963, 17.42115, 17.24955, 17.022156, 17.761238, 16.316248, 19.299774, 17.969398,
            18.371588, 22.296583, 23.792938, 19.2227, 19.660896, 19.766476, 17.677996, 16.433859,
            17.482044, 18.524246, 18.005713, 19.407972, 18.755781, 20.172482, 21.314653, 22.456263,
            19.725996, 17.841064, 18.446249, 18.805672, 19.00181, 17.451015, 18.285587, 18.221941,
            20.867449, 22.242767, 20.07005, 19.265364, 17.770485, 18.504986, 17.344938, 17.000181,
            15.471671, 18.157248, 18.317808, 20.187065, 20.041824, 20.291113, 19.927713, 19.378258,
            17.484655, 17.44329, 19.759537, 17.43413, 16.73364, 16.92076, 20.383276, 19.971516,
            19.967075, 19.336164, 18.909721, 18.619324, 20.396246, 19.00263, 17.94013, 18.551346,
            17.23518, 20.370188, 20.011868, 19.450335, 17.387375, 16.870554, 17.114243, 17.294075,
            19.299145, 18.834475, 18.813671, 21.103506, 22.580276, 20.534487, 19.031105, 17.737423,
            17.045614, 17.100788, 17.740604, 19.273754, 18.795937, 18.905334, 20.158348, 21.390461,
            21.336525, 20.130829, 20.734426, 18.729094, 18.294617, 18.847391, 18.804544, 19.493778,
            18.928158, 19.126476, 20.263859, 20.886457, 21.50975, 19.178932, 17.86777, 17.717876,
            17.55197, 17.091555, 17.203413, 18.268856, 18.745243, 22.375399, 22.81792, 21.270727,
            19.4549, 18.479559, 18.6709, 17.554605, 17.278416, 15.805639, 17.227327, 17.261139,
            18.24352, 20.670288, 20.694622, 19.809734, 19.648314, 18.983255, 18.973658, 20.184095,
            19.132532, 16.32797, 16.814007, 18.602396,
        ],
    )
    .unwrap();
    let current_output29: Array3<f32> = conv_layer29.convolve(&test_input29);

    assert!(
        arr_allclose(&current_output29, &target_output29),
        "{:?} was not equal to {:?}",
        current_output29,
        target_output29
    );

    let test_input30 = Array::from_shape_vec(
        (3, 10, 15),
        vec![
            0.52886575, 0.38637865, 0.5918471, 0.01740899, 0.7394339, 0.56132907, 0.19255765,
            0.89828086, 0.18568946, 0.6458292, 0.9000991, 0.14083895, 0.19123401, 0.29393503,
            0.9709682, 0.8210748, 0.37299708, 0.6932929, 0.78315556, 0.7116838, 0.9060589,
            0.3958118, 0.9729085, 0.37787062, 0.3110578, 0.51860094, 0.82105917, 0.47715545,
            0.8672759, 0.86623365, 0.29922554, 0.03071198, 0.03382622, 0.45532396, 0.62365896,
            0.149902, 0.42382213, 0.6566605, 0.45536265, 0.42575222, 0.9792835, 0.01637395,
            0.56597984, 0.7201858, 0.13000993, 0.38580757, 0.46124813, 0.7345686, 0.45498174,
            0.01468375, 0.3311825, 0.68482727, 0.04436485, 0.5904201, 0.9714122, 0.5436191,
            0.94970685, 0.9165496, 0.8299819, 0.68421304, 0.89789516, 0.18899626, 0.59009004,
            0.9988615, 0.02270102, 0.8618434, 0.749954, 0.4278886, 0.6528449, 0.2109633, 0.6254018,
            0.8017509, 0.25951192, 0.02546183, 0.02745248, 0.64143604, 0.7372767, 0.22952433,
            0.6979411, 0.6756809, 0.7017341, 0.918334, 0.03686747, 0.21967116, 0.65583056,
            0.16345957, 0.50405574, 0.5254386, 0.2864706, 0.8577092, 0.17987564, 0.12798376,
            0.37675846, 0.04420354, 0.97041535, 0.407479, 0.07644754, 0.14767134, 0.6243532,
            0.6770185, 0.19173194, 0.46982294, 0.02457761, 0.7269523, 0.23975594, 0.19219191,
            0.3308745, 0.396583, 0.8623231, 0.48967764, 0.19221619, 0.08402257, 0.7331613,
            0.19351119, 0.31468204, 0.7701771, 0.68409836, 0.40743572, 0.9474348, 0.16978115,
            0.98625356, 0.6862598, 0.11779778, 0.5906839, 0.22131853, 0.04202804, 0.6265308,
            0.98268986, 0.6135814, 0.59731364, 0.4896969, 0.5199412, 0.21510182, 0.6619162,
            0.8715136, 0.57183194, 0.2885029, 0.50771165, 0.901779, 0.08790161, 0.4924265,
            0.9705775, 0.63548344, 0.45100802, 0.03424489, 0.7871616, 0.08637597, 0.78139436,
            0.56886005, 0.40288508, 0.55354595, 0.3848688, 0.6487766, 0.70381683, 0.5216492,
            0.7941249, 0.47117358, 0.61789876, 0.6924839, 0.95235467, 0.99155945, 0.7086247,
            0.33689418, 0.1660726, 0.68587416, 0.47262585, 0.45400557, 0.4621445, 0.33963647,
            0.7927198, 0.7496024, 0.530577, 0.519493, 0.91085595, 0.0421344, 0.1856097, 0.162838,
            0.59682316, 0.94973904, 0.45783094, 0.93284744, 0.55421734, 0.4387137, 0.05644235,
            0.44071785, 0.14814438, 0.5569182, 0.20264524, 0.04074387, 0.6096802, 0.4809522,
            0.47096238, 0.00810335, 0.2299158, 0.21848392, 0.7324421, 0.72079855, 0.6820497,
            0.7327517, 0.33685237, 0.93032444, 0.38904786, 0.7066437, 0.6656503, 0.841237,
            0.41910258, 0.5914259, 0.9108226, 0.53551847, 0.4931909, 0.5435749, 0.68504053,
            0.3623532, 0.7924024, 0.75572896, 0.3925273, 0.03436404, 0.22152406, 0.7389564,
            0.649227, 0.3867441, 0.334363, 0.5530898, 0.5252634, 0.77226716, 0.5538213, 0.6835575,
            0.3882179, 0.8170877, 0.00781578, 0.97707474, 0.9940746, 0.7451846, 0.52904606,
            0.30411443, 0.59167516, 0.80317616, 0.43357348, 0.64922994, 0.6601235, 0.907485,
            0.53241575, 0.6945486, 0.67047435, 0.7195878, 0.9020445, 0.9518084, 0.787326,
            0.96140546, 0.327034, 0.41490155, 0.72119236, 0.09215528, 0.57506335, 0.42119923,
            0.03004104, 0.17358404, 0.00080285, 0.28787526, 0.6447292, 0.906, 0.16794387,
            0.5467595, 0.75012404, 0.8576224, 0.77786934, 0.33486333, 0.88640976, 0.47692633,
            0.7414227, 0.04009474, 0.542522, 0.35029164, 0.63763183, 0.29794613, 0.03641145,
            0.16722608, 0.12909189, 0.1589417, 0.5954703, 0.85711455, 0.24522811, 0.974773,
            0.8507247, 0.67588323, 0.83975345, 0.863551, 0.1023455, 0.51589406, 0.85847044,
            0.86474276, 0.8149961, 0.38785052, 0.7663677, 0.9410913, 0.08583226, 0.8406605,
            0.71259856, 0.20553346, 0.24283217, 0.57682234, 0.47941732, 0.926685, 0.39005476,
            0.54092985, 0.88133335, 0.0324995, 0.59161955, 0.22166131, 0.7692697, 0.01657799,
            0.10074908, 0.5621936, 0.00591142, 0.45705855, 0.40678144, 0.6293653, 0.4260665,
            0.48859268, 0.9232842, 0.2502391, 0.80427086, 0.03818879, 0.36219996, 0.17138262,
            0.42277342, 0.94081557, 0.7445628, 0.21179068, 0.71635485, 0.83644694, 0.19754058,
            0.82449114, 0.42324457, 0.26319242, 0.7948271, 0.72855157, 0.42772555, 0.89472646,
            0.9749447, 0.95646167, 0.6503069, 0.15980154, 0.62844396, 0.6528909, 0.6028544,
            0.13638273, 0.39407018, 0.06674533, 0.83398765, 0.7112734, 0.9988898, 0.45113885,
            0.37628287, 0.12467484, 0.23401077, 0.5302998, 0.03754441, 0.8939974, 0.16035181,
            0.69940186, 0.7832372, 0.22348203, 0.9558617, 0.08868469, 0.38749498, 0.14952931,
            0.13567366, 0.07900955, 0.4838307, 0.8551138, 0.88709897, 0.36363718, 0.20012486,
            0.18496908, 0.26352006, 0.21221249, 0.04832328, 0.45603734, 0.48977068, 0.9727279,
            0.2223024, 0.7580914, 0.9952911, 0.78135294, 0.34888557, 0.42161968, 0.88537115,
            0.24929681, 0.24824439, 0.75166476, 0.51153195, 0.5740834, 0.31640235, 0.7000697,
            0.9271626, 0.3866544, 0.90997946, 0.52299017, 0.48876184, 0.43697715, 0.4668421,
            0.8870456, 0.13939072, 0.15193757, 0.10377176, 0.03825287, 0.83194524, 0.71169674,
            0.12412303, 0.22000751, 0.65762943, 0.80387026, 0.9246838, 0.2840905, 0.03209783,
            0.19625777, 0.11980431, 0.30807668, 0.13390501, 0.05043373, 0.12723272, 0.9824148,
            0.44856635, 0.2624294, 0.00958934, 0.0995127, 0.08031525, 0.38621363, 0.66721714,
            0.17361915, 0.21235856, 0.99523526, 0.6581009, 0.6043816, 0.38974792, 0.8524115,
            0.36282185, 0.0062347, 0.9864116, 0.53632265, 0.25642252, 0.35544556, 0.8767314,
            0.7978388, 0.9968594, 0.93126136, 0.6872969, 0.01807762, 0.53289115,
        ],
    )
    .unwrap();

    let kernel30: Array4<f32> = Array::from_shape_vec(
        (2, 3, 5, 5),
        vec![
            0.29115057, 0.09607173, 0.9291924, 0.7955641, 0.685791, 0.24262014, 0.7705071,
            0.86541873, 0.17621124, 0.6904003, 0.34976122, 0.21581873, 0.5532616, 0.95970744,
            0.55223054, 0.16051039, 0.01258456, 0.97428215, 0.09648368, 0.16584113, 0.13684596,
            0.98106205, 0.68078685, 0.0038069, 0.82000685, 0.7718611, 0.00677892, 0.48767114,
            0.70951277, 0.4362493, 0.9016004, 0.7881427, 0.20579426, 0.11782064, 0.05957514,
            0.8304564, 0.02350398, 0.7684956, 0.91710156, 0.85411555, 0.02124477, 0.11364035,
            0.54948294, 0.02591292, 0.42192397, 0.86921203, 0.4866433, 0.9635667, 0.5469399,
            0.37939194, 0.2165768, 0.38010216, 0.95164126, 0.97265726, 0.8991906, 0.6288754,
            0.94870436, 0.30023637, 0.71587545, 0.308687, 0.1237447, 0.70287865, 0.5642258,
            0.4909772, 0.00513179, 0.96346223, 0.72805625, 0.97035193, 0.34751764, 0.9530135,
            0.07550302, 0.14497681, 0.5457807, 0.43179563, 0.24281646, 0.7374898, 0.5303815,
            0.89710975, 0.02905989, 0.84309703, 0.25471458, 0.8896496, 0.04810897, 0.92559075,
            0.809669, 0.03910594, 0.50459677, 0.14540058, 0.90726244, 0.52693003, 0.8414026,
            0.11982161, 0.10823907, 0.26861846, 0.60190606, 0.6963788, 0.25325528, 0.13881885,
            0.0617022, 0.97593206, 0.5218702, 0.79595083, 0.7466225, 0.8505226, 0.9156915,
            0.42966273, 0.338509, 0.5958763, 0.01035187, 0.3031956, 0.8194214, 0.8856615,
            0.05187115, 0.5123032, 0.23396358, 0.25060338, 0.22599821, 0.35538375, 0.73213947,
            0.68476427, 0.43052003, 0.84957284, 0.67671156, 0.2562911, 0.9386545, 0.7209084,
            0.43928608, 0.6592098, 0.19666669, 0.6909486, 0.61787504, 0.46187317, 0.15833755,
            0.8886515, 0.6841967, 0.06233076, 0.41375995, 0.10668167, 0.36822248, 0.15206665,
            0.46758506, 0.04919559, 0.6929648, 0.85146296, 0.93492836, 0.8471453, 0.49949893,
            0.96549, 0.10857984, 0.04954484,
        ],
    )
    .unwrap();
    let conv_layer30 = ConvolutionLayer::new(kernel30, 1, Padding::Valid);
    let target_output30: Array3<f32> = Array::from_shape_vec(
        (2, 6, 11),
        vec![
            19.142725, 20.122826, 18.983324, 19.44492, 19.511105, 18.699615, 19.153101, 20.38319,
            17.281569, 17.47797, 17.448887, 19.137678, 20.327435, 19.708841, 20.606186, 18.661045,
            20.9668, 18.833752, 18.598799, 21.489555, 21.666664, 21.283125, 18.58982, 19.371218,
            18.856369, 20.219296, 21.58117, 20.897858, 20.061409, 21.585632, 20.564587, 19.118141,
            18.00788, 18.06283, 19.136517, 21.37478, 22.370844, 19.422073, 19.502232, 19.821527,
            20.056648, 19.549635, 21.389853, 18.623539, 17.9031, 18.974548, 18.732084, 17.89015,
            17.991522, 19.918715, 19.51068, 19.536242, 19.547262, 17.823347, 17.39394, 16.648397,
            19.857506, 19.392733, 18.788357, 20.14931, 21.616688, 21.17852, 20.502941, 20.678862,
            19.658854, 18.326433, 20.086739, 20.687788, 20.09284, 20.335867, 18.149338, 18.534899,
            18.68606, 18.939415, 19.207832, 19.132248, 19.21862, 18.876423, 19.035788, 19.786469,
            19.781015, 18.854855, 21.193798, 20.359676, 20.432236, 19.323471, 20.23899, 20.294598,
            18.867426, 18.068949, 20.244516, 19.545206, 20.376442, 21.797585, 19.211243, 19.802382,
            20.083946, 19.513887, 17.850792, 18.969208, 18.649487, 21.140224, 19.351534, 20.261774,
            20.762695, 19.800318, 20.964504, 20.15277, 19.112625, 17.552183, 18.000723, 19.258389,
            17.754482, 18.917631, 17.564844, 18.89842, 18.29688, 18.240635, 18.814283, 18.121021,
            18.666586, 17.558743, 17.938618, 17.871258, 19.057268, 20.975336, 19.84367, 19.607725,
            20.494164, 21.179203, 20.764017, 20.50243,
        ],
    )
    .unwrap();
    let current_output30: Array3<f32> = conv_layer30.convolve(&test_input30);

    assert!(
        arr_allclose(&current_output30, &target_output30),
        "{:?} was not equal to {:?}",
        current_output30,
        target_output30
    );

    let test_input31 = Array::from_shape_vec(
        (3, 15, 10),
        vec![
            0.8648635, 0.3216597, 0.5967798, 0.24502176, 0.40264118, 0.7135809, 0.9563036,
            0.99361944, 0.27493003, 0.8091006, 0.03882129, 0.4241894, 0.21886946, 0.60990226,
            0.74957037, 0.0567609, 0.6618832, 0.31648433, 0.07057995, 0.7937507, 0.35538703,
            0.16586034, 0.53550744, 0.9107666, 0.08248742, 0.7804362, 0.07774146, 0.28810686,
            0.5908287, 0.07081332, 0.24666145, 0.5222477, 0.15884496, 0.7280006, 0.171798,
            0.16601218, 0.21720299, 0.75876254, 0.40750048, 0.2797197, 0.32153466, 0.24065089,
            0.1429008, 0.90698326, 0.4561631, 0.12540661, 0.1332323, 0.0730514, 0.16514674,
            0.6010551, 0.20042138, 0.79326254, 0.81028926, 0.61555564, 0.21495369, 0.6555247,
            0.59598464, 0.20266142, 0.51127625, 0.8523459, 0.5993377, 0.7477862, 0.39690518,
            0.5696813, 0.87416846, 0.9011878, 0.6916412, 0.62494177, 0.6454708, 0.32460627,
            0.70959914, 0.92651147, 0.9414587, 0.6630958, 0.21866481, 0.0734322, 0.37875828,
            0.2656954, 0.8068955, 0.4726575, 0.6983828, 0.07320249, 0.12168032, 0.6426804,
            0.9129043, 0.84286946, 0.43912458, 0.860546, 0.60123307, 0.0920186, 0.14726785,
            0.7902299, 0.24951272, 0.5177399, 0.33639956, 0.39910504, 0.26826426, 0.1295481,
            0.04226355, 0.36311296, 0.33253834, 0.03372582, 0.6151039, 0.16333707, 0.35070628,
            0.6325487, 0.45462114, 0.8023284, 0.8320421, 0.9793079, 0.34594545, 0.48682922,
            0.875736, 0.59496605, 0.21009445, 0.00543618, 0.68560296, 0.04975929, 0.45436794,
            0.49572426, 0.80676097, 0.268819, 0.4114992, 0.7848971, 0.6777965, 0.17057472,
            0.70026565, 0.8685083, 0.7508676, 0.9457111, 0.24649319, 0.9665724, 0.85440516,
            0.35102448, 0.07823556, 0.7180487, 0.8317649, 0.6794208, 0.5517275, 0.10098601,
            0.03686264, 0.8578678, 0.12133782, 0.2815227, 0.23224549, 0.50588506, 0.8644135,
            0.02310899, 0.45685568, 0.40417364, 0.2598548, 0.09913059, 0.7969972, 0.9800414,
            0.2510396, 0.11597095, 0.72586274, 0.09967189, 0.29483116, 0.22645572, 0.16055934,
            0.43114743, 0.90784466, 0.96178347, 0.6382897, 0.534928, 0.6883946, 0.5840903,
            0.75128937, 0.66844714, 0.66343355, 0.46953654, 0.46234563, 0.26003668, 0.7742914,
            0.328285, 0.83035487, 0.49730703, 0.99242496, 0.83261126, 0.8848362, 0.11227968,
            0.83485615, 0.38707262, 0.42852715, 0.3326272, 0.9234643, 0.7350134, 0.24397685,
            0.79674083, 0.95016545, 0.21724485, 0.86324733, 0.1932244, 0.5176914, 0.32076064,
            0.9673775, 0.00598922, 0.3920287, 0.24141203, 0.8279213, 0.6946018, 0.75072336,
            0.9753633, 0.24372894, 0.49899355, 0.31899843, 0.4939616, 0.11416891, 0.68334943,
            0.5965326, 0.12978615, 0.10638801, 0.11160661, 0.80415183, 0.28193727, 0.09670109,
            0.17522074, 0.30331546, 0.39188403, 0.9932483, 0.44458252, 0.5604396, 0.07845373,
            0.09437273, 0.2022228, 0.30105925, 0.18510874, 0.5031573, 0.87208086, 0.6317367,
            0.9767708, 0.21871181, 0.7000181, 0.39591292, 0.73465174, 0.00274565, 0.9079947,
            0.22369012, 0.68718666, 0.65592414, 0.6682944, 0.578825, 0.5572757, 0.17275229,
            0.35462692, 0.07000257, 0.3533166, 0.616583, 0.30442452, 0.5472081, 0.2751976,
            0.77393323, 0.43991742, 0.05888736, 0.2155859, 0.3237903, 0.42484936, 0.8007856,
            0.16511486, 0.9651604, 0.6095338, 0.780079, 0.213527, 0.68177587, 0.20005976,
            0.5214844, 0.5637177, 0.8187329, 0.34419012, 0.70609355, 0.46725455, 0.23119006,
            0.96067435, 0.29916614, 0.6806969, 0.91396964, 0.972841, 0.01715484, 0.04093061,
            0.4275515, 0.19486532, 0.25447014, 0.08197373, 0.6507138, 0.21445233, 0.11806071,
            0.17637333, 0.32952574, 0.5958368, 0.17714995, 0.7740049, 0.6388251, 0.25830767,
            0.21258484, 0.3401532, 0.96206266, 0.6204497, 0.28326756, 0.20731905, 0.8391098,
            0.63256073, 0.05410179, 0.97274446, 0.7486978, 0.12974854, 0.7944709, 0.53723675,
            0.69576323, 0.82454914, 0.37664893, 0.6722372, 0.50744605, 0.7913009, 0.78958917,
            0.6451747, 0.35058063, 0.22394986, 0.14626299, 0.05523287, 0.4686973, 0.7351389,
            0.07301666, 0.27983865, 0.10655332, 0.97564507, 0.05932388, 0.77344525, 0.61317027,
            0.08217912, 0.553476, 0.21154444, 0.19400315, 0.16894332, 0.9486215, 0.92018247,
            0.89767647, 0.5222088, 0.21455717, 0.203828, 0.13832045, 0.5881519, 0.75384825,
            0.9633764, 0.5959824, 0.758624, 0.01639629, 0.3016201, 0.17905368, 0.19411111,
            0.82684654, 0.2860684, 0.04715753, 0.06193527, 0.6444675, 0.31424382, 0.10932652,
            0.5231733, 0.44769424, 0.39186087, 0.02075461, 0.10706459, 0.5791381, 0.45745206,
            0.44355088, 0.519928, 0.01996619, 0.71309346, 0.68690145, 0.39505485, 0.5469934,
            0.31554794, 0.39265913, 0.6052618, 0.9284058, 0.1213429, 0.38917127, 0.7799773,
            0.825869, 0.88367033, 0.57404125, 0.85618263, 0.4407754, 0.633255, 0.7577091,
            0.73792094, 0.23396462, 0.3459607, 0.14433429, 0.5666275, 0.9557201, 0.85192674,
            0.6193624, 0.9293787, 0.02097251, 0.23979846, 0.07907034, 0.9563302, 0.01872301,
            0.41537428, 0.45995143, 0.64512044, 0.85995775, 0.10583407, 0.4484315, 0.9160312,
            0.5678417, 0.57392234, 0.26174, 0.10541193, 0.6379088, 0.31216502, 0.87573344,
            0.15632313, 0.7373654, 0.12863557, 0.9590727, 0.2825182, 0.79587996, 0.8191361,
            0.9381195, 0.53403527, 0.79628325, 0.62593824, 0.2113896, 0.1876398, 0.29817143,
            0.6925418, 0.1792817, 0.2641736, 0.43096247, 0.76093376, 0.6251491, 0.6965461,
            0.04901551, 0.06003402, 0.6987717, 0.12188532, 0.06863046, 0.9816463, 0.75263584,
            0.66786885, 0.6430677, 0.56340057, 0.73104405, 0.65803695, 0.07880943, 0.23246141,
            0.7858138, 0.55886114,
        ],
    )
    .unwrap();

    let kernel31: Array4<f32> = Array::from_shape_vec(
        (2, 3, 3, 3),
        vec![
            0.4816245, 0.7489411, 0.64294606, 0.7781154, 0.66253483, 0.9903388, 0.41137746,
            0.4890013, 0.06506247, 0.9972559, 0.8323405, 0.18129697, 0.49030396, 0.48294267,
            0.12433387, 0.9647698, 0.7292857, 0.73773444, 0.3909372, 0.92350286, 0.25497472,
            0.13691516, 0.34584802, 0.5884459, 0.20412357, 0.00624331, 0.56834316, 0.22074686,
            0.69736785, 0.08598603, 0.05624962, 0.29992157, 0.25001067, 0.6889985, 0.89269227,
            0.30140767, 0.6338539, 0.948173, 0.464108, 0.89087915, 0.31388247, 0.5700806,
            0.76289177, 0.00432913, 0.9234758, 0.9616415, 0.29734898, 0.811496, 0.8376677,
            0.406034, 0.9758267, 0.03124781, 0.5678819, 0.12168682,
        ],
    )
    .unwrap();
    let conv_layer31 = ConvolutionLayer::new(kernel31, 1, Padding::Valid);
    let target_output31: Array3<f32> = Array::from_shape_vec(
        (2, 13, 8),
        vec![
            5.691259, 6.5072, 8.564858, 7.9610925, 6.988726, 7.4689445, 7.41772, 7.016751,
            6.0889864, 6.6987634, 8.132203, 8.298849, 6.9289737, 6.9998093, 6.9371395, 6.388262,
            6.6384726, 6.209203, 6.580178, 6.634027, 6.589058, 6.297384, 6.7271047, 5.7623167,
            6.675291, 7.449941, 7.610271, 6.9500937, 5.5982823, 6.47132, 5.8630066, 5.3715806,
            6.780651, 6.7374015, 7.670218, 7.02034, 6.152077, 5.4093223, 5.0452, 5.081585, 8.29383,
            7.263317, 7.095555, 6.6359863, 6.043485, 5.839494, 6.260886, 6.932245, 7.552801,
            7.2773094, 6.7707415, 7.2044497, 6.4550734, 5.946526, 6.3357334, 7.662901, 8.426541,
            7.89471, 6.939606, 6.8519526, 4.923275, 5.790952, 5.729583, 6.8631635, 7.550644,
            7.2499995, 6.7107744, 6.9800715, 5.942333, 6.0805187, 5.574731, 6.027342, 8.655022,
            7.0382934, 7.528959, 5.2392817, 5.4096255, 5.4481525, 6.7550426, 6.9353924, 7.855063,
            7.5023665, 6.8310246, 5.9307113, 6.5303698, 7.138517, 7.871375, 7.6534386, 7.8821955,
            7.8029613, 6.80569, 5.3548746, 6.0471296, 6.436442, 7.184242, 7.944942, 7.9286633,
            7.7976165, 6.539426, 5.7894263, 6.263484, 7.981365, 8.453042, 6.603524, 6.128194,
            7.76171, 8.660959, 7.450359, 7.9975896, 6.288144, 7.5661087, 6.2788725, 6.4885216,
            6.651586, 7.286178, 7.772576, 6.9711466, 7.31811, 7.1298475, 6.7325783, 6.730037,
            5.0417566, 7.2621293, 6.673776, 7.575412, 6.5267544, 6.7198925, 6.0038686, 7.475133,
            7.258488, 7.872005, 7.2437263, 6.742989, 6.8696184, 6.120631, 5.438411, 6.9557004,
            6.6510878, 7.461928, 7.2465906, 6.411095, 6.058461, 4.686206, 5.4789944, 7.8544645,
            6.423854, 7.1213384, 5.5141344, 4.914495, 5.2353067, 5.334812, 6.8091264, 6.4559326,
            5.6029778, 6.458065, 7.3749146, 6.2478056, 6.585549, 5.85124, 8.10059, 7.986719,
            8.174029, 6.7959833, 6.3412294, 4.942797, 5.6054583, 5.0252676, 6.678653, 8.054048,
            7.753959, 6.189406, 6.968455, 5.508215, 6.419325, 5.8664393, 6.815943, 8.982177,
            7.828745, 7.172154, 5.5188046, 4.5106497, 6.1272526, 5.608345, 6.1560616, 7.948263,
            7.221642, 7.4360113, 5.6427016, 6.927149, 7.022018, 8.236177, 7.7289853, 8.749814,
            7.658123, 7.502216, 4.896489, 5.9810343, 7.0258765, 7.2856064, 6.9930234, 7.527712,
            6.9734874, 6.1854672, 5.549083, 6.308774, 6.48008, 6.3935914, 6.0324006,
        ],
    )
    .unwrap();
    let current_output31: Array3<f32> = conv_layer31.convolve(&test_input31);

    assert!(
        arr_allclose(&current_output31, &target_output31),
        "{:?} was not equal to {:?}",
        current_output31,
        target_output31
    );

    let test_input32 = Array::from_shape_vec(
        (3, 15, 10),
        vec![
            0.8672895, 0.7089132, 0.81502956, 0.45569643, 0.9420309, 0.03257992, 0.41169244,
            0.10524429, 0.29636487, 0.230716, 0.89597744, 0.23406821, 0.6527877, 0.3581413,
            0.6885466, 0.9535316, 0.8442464, 0.40710646, 0.16538836, 0.6326036, 0.68527246,
            0.31145656, 0.49300048, 0.49084947, 0.02828005, 0.88413817, 0.08669137, 0.14747888,
            0.9037477, 0.6970686, 0.30263218, 0.00271136, 0.49293855, 0.9998127, 0.98342794,
            0.9118095, 0.9264461, 0.04954946, 0.40840417, 0.46344218, 0.787193, 0.20486033,
            0.4029006, 0.7686151, 0.24171825, 0.36729267, 0.19857672, 0.32654667, 0.36346474,
            0.17108533, 0.3027954, 0.36422956, 0.58195865, 0.58513415, 0.7725577, 0.8838584,
            0.80932313, 0.89565295, 0.16141163, 0.06084506, 0.5492495, 0.60231775, 0.91577756,
            0.12382696, 0.294304, 0.36349937, 0.7948714, 0.14176327, 0.49541315, 0.2934778,
            0.37438837, 0.7306092, 0.28533515, 0.10216843, 0.55541974, 0.4650447, 0.17332368,
            0.3212567, 0.36790222, 0.11517226, 0.08391169, 0.66567504, 0.3817901, 0.47639692,
            0.81930286, 0.32803875, 0.5654139, 0.37452427, 0.6643417, 0.24304809, 0.06236777,
            0.7733252, 0.78207755, 0.61082655, 0.947744, 0.08051699, 0.94621384, 0.00787854,
            0.84173137, 0.1944808, 0.13019027, 0.66277754, 0.09286012, 0.58464366, 0.6512211,
            0.7080163, 0.70387626, 0.44558695, 0.44260016, 0.697838, 0.32629654, 0.2740555,
            0.99696946, 0.17646311, 0.37098762, 0.8761452, 0.69403934, 0.21528777, 0.5237107,
            0.44565287, 0.19037104, 0.8381286, 0.70450526, 0.7929086, 0.45777786, 0.96684873,
            0.48885155, 0.15208961, 0.8550647, 0.11583171, 0.56539786, 0.6370797, 0.2444331,
            0.26558962, 0.7020013, 0.31950995, 0.00088664, 0.4422912, 0.82152086, 0.05462804,
            0.8638695, 0.92018557, 0.43966386, 0.13879521, 0.6324256, 0.47845423, 0.52424467,
            0.8988874, 0.34291574, 0.5377849, 0.7919196, 0.69536626, 0.72673947, 0.63617104,
            0.1036236, 0.5688153, 0.642465, 0.68493664, 0.6256276, 0.5914831, 0.841703, 0.26191136,
            0.63586736, 0.14973171, 0.17741989, 0.8462637, 0.51744187, 0.89845973, 0.44348246,
            0.2674213, 0.5524051, 0.4584158, 0.05020873, 0.9414409, 0.87631005, 0.8967645,
            0.9048843, 0.6688897, 0.28862262, 0.01719667, 0.89464474, 0.738402, 0.43135417,
            0.36634243, 0.99305737, 0.5723982, 0.33335868, 0.6317803, 0.86594313, 0.16760358,
            0.08334628, 0.14621608, 0.6169529, 0.5971739, 0.95570713, 0.19301598, 0.05311463,
            0.8926391, 0.06703918, 0.3840044, 0.12217854, 0.11021607, 0.05716072, 0.03542557,
            0.46326014, 0.9456335, 0.8012088, 0.9099846, 0.31587508, 0.9948361, 0.19569385,
            0.6932092, 0.287212, 0.22239834, 0.91989446, 0.645167, 0.16384327, 0.26697785,
            0.34233773, 0.9711869, 0.1736736, 0.49766174, 0.11606233, 0.20744501, 0.47700465,
            0.49665624, 0.9865482, 0.67733943, 0.48572266, 0.94583005, 0.3003492, 0.8352311,
            0.80740196, 0.39818338, 0.8049802, 0.3352269, 0.8549322, 0.32960874, 0.01231102,
            0.21975358, 0.79986304, 0.06471063, 0.77274996, 0.8312853, 0.7702817, 0.82208914,
            0.11399209, 0.04418208, 0.41363552, 0.37213323, 0.05123908, 0.16918235, 0.56118464,
            0.31676802, 0.91666114, 0.99523085, 0.02213015, 0.558943, 0.3857257, 0.9998762,
            0.5093269, 0.49142754, 0.34928933, 0.6983236, 0.63120776, 0.7523395, 0.96101004,
            0.9997972, 0.42995888, 0.86614877, 0.0841737, 0.895856, 0.11358444, 0.10170663,
            0.68170774, 0.69930184, 0.31476194, 0.37262207, 0.11822087, 0.5850524, 0.7072854,
            0.35515, 0.20403187, 0.682487, 0.44291237, 0.2778266, 0.69825464, 0.9029227, 0.6240293,
            0.41573936, 0.16815847, 0.33923522, 0.80277765, 0.07096831, 0.8554102, 0.7722144,
            0.53853285, 0.94955045, 0.5328812, 0.73666346, 0.11740076, 0.37460858, 0.674916,
            0.9220868, 0.9811295, 0.38428995, 0.8472775, 0.5904251, 0.4929124, 0.49100837,
            0.11250915, 0.43514693, 0.49978712, 0.58982396, 0.32562396, 0.08288938, 0.12515384,
            0.60863686, 0.49698648, 0.2545693, 0.17941345, 0.24435802, 0.9257646, 0.3601743,
            0.51685953, 0.14790155, 0.31631762, 0.6813218, 0.86361974, 0.8700462, 0.5406228,
            0.00816071, 0.81253463, 0.8402446, 0.16182604, 0.9968952, 0.57455206, 0.71637905,
            0.8596117, 0.21274436, 0.5098158, 0.02886825, 0.21751188, 0.23436014, 0.3830526,
            0.6327846, 0.27748674, 0.84223384, 0.9325366, 0.0989435, 0.6051626, 0.08400947,
            0.49678063, 0.97340894, 0.8396681, 0.3482415, 0.10386568, 0.7454953, 0.40149435,
            0.4452185, 0.8714838, 0.44752908, 0.90387195, 0.46964037, 0.4844109, 0.88147926,
            0.5946748, 0.58768094, 0.34565842, 0.46486276, 0.8322659, 0.64309967, 0.46776876,
            0.2263038, 0.70366824, 0.7749035, 0.9106096, 0.48822477, 0.5702429, 0.10668962,
            0.92969257, 0.00275485, 0.9503608, 0.14900696, 0.5455553, 0.00645077, 0.21402211,
            0.7504094, 0.01176434, 0.07800543, 0.0516187, 0.36804476, 0.8195282, 0.7427081,
            0.185258, 0.2418856, 0.5231299, 0.23739757, 0.92642605, 0.8063814, 0.09321253,
            0.3954864, 0.27779007, 0.6142842, 0.71764106, 0.33038312, 0.9766592, 0.42897722,
            0.94963986, 0.37697607, 0.8851262, 0.73109215, 0.6303855, 0.24837622, 0.21866089,
            0.6886716, 0.69469833, 0.0114934, 0.7045316, 0.35201788, 0.0989068, 0.9038667,
            0.51265216, 0.926821, 0.7685541, 0.4955361, 0.48527932, 0.09102922, 0.6430718,
            0.16351804, 0.3052067, 0.49957812, 0.3116739, 0.2785308, 0.13845451, 0.5386763,
            0.85340834, 0.9765559, 0.3653472, 0.02803171, 0.6471354, 0.8093628, 0.38585195,
            0.5898562, 0.17813227, 0.76870936, 0.8990035, 0.4354284, 0.15628383, 0.1745854,
        ],
    )
    .unwrap();

    let kernel32: Array4<f32> = Array::from_shape_vec(
        (2, 3, 3, 3),
        vec![
            0.86026084, 0.93176335, 0.5679988, 0.47061768, 0.53949803, 0.05189181, 0.07629808,
            0.8465009, 0.5065825, 0.7161806, 0.02412173, 0.9533139, 0.94789124, 0.11517583,
            0.85233843, 0.73321646, 0.07861274, 0.33750752, 0.5816211, 0.64147437, 0.7184982,
            0.897314, 0.09359702, 0.19160785, 0.85125345, 0.8526771, 0.4098685, 0.5046985,
            0.18144442, 0.47525635, 0.98244303, 0.1424162, 0.9882022, 0.06972428, 0.20421812,
            0.5577621, 0.30822515, 0.39205092, 0.06246058, 0.02439791, 0.42704046, 0.32884195,
            0.18523273, 0.6523331, 0.8833122, 0.53135425, 0.2849727, 0.68437326, 0.4664868,
            0.6945481, 0.27290356, 0.9941263, 0.01063524, 0.06917533,
        ],
    )
    .unwrap();
    let conv_layer32 = ConvolutionLayer::new(kernel32, 1, Padding::Valid);
    let target_output32: Array3<f32> = Array::from_shape_vec(
        (2, 13, 8),
        vec![
            7.89329, 8.036312, 8.038871, 8.158259, 7.6224694, 7.338921, 7.3882356, 7.9866424,
            6.710104, 7.0789423, 8.7190275, 8.643095, 9.096922, 9.336964, 7.0541205, 7.3645515,
            5.918462, 6.2626004, 8.05878, 7.9193454, 7.817957, 8.070839, 7.2082934, 8.077151,
            5.675693, 6.0193334, 9.41122, 9.369565, 9.118606, 9.1214, 7.1271935, 7.265289,
            6.2166295, 5.8011637, 7.130747, 7.2861867, 8.071121, 8.803245, 6.259851, 8.048187,
            6.421789, 6.440901, 7.5591307, 7.9375086, 8.824083, 9.46798, 7.7926526, 7.886357,
            7.735554, 7.4632564, 7.56992, 6.0242314, 7.987685, 7.148834, 7.372324, 6.8564835,
            7.7503, 6.9698563, 8.425193, 6.994516, 8.383707, 6.6875014, 6.4812493, 6.872014,
            6.677515, 6.6659565, 9.33722, 8.400432, 8.01244, 7.0527387, 6.5189157, 6.223205,
            7.4554915, 8.097079, 8.136594, 8.442582, 8.362028, 7.775638, 7.3246336, 7.5663776,
            6.3556476, 8.163408, 8.33304, 8.793838, 9.271238, 9.150941, 7.4700956, 7.937488,
            6.513491, 7.802344, 6.4735284, 7.4283333, 8.404276, 8.542116, 7.793821, 7.5301104,
            7.316403, 8.115965, 7.318732, 7.7603064, 8.143089, 8.4037485, 7.528921, 7.4493995,
            5.6151586, 5.6218624, 7.4644766, 6.440093, 6.9235864, 5.4553165, 5.8194523, 5.204276,
            5.5879207, 5.0573525, 6.5516596, 6.916142, 4.8287926, 6.1822257, 6.135949, 5.8169694,
            5.031167, 5.0504136, 6.7508373, 6.7169113, 5.70106, 6.1378355, 6.180088, 5.682827,
            4.8126097, 4.222325, 5.311578, 7.8522625, 6.661615, 6.55959, 5.636504, 5.5800815,
            4.9928727, 4.1086044, 6.311712, 7.059823, 6.0616574, 6.127797, 5.487327, 5.6392984,
            5.8154144, 4.677711, 5.880994, 5.485563, 6.8786016, 6.569044, 6.401136, 5.343286,
            7.0106745, 4.8082705, 6.1481156, 4.998745, 6.6204963, 5.616002, 4.6233172, 4.288784,
            5.1209993, 5.9187455, 6.6798797, 5.7499213, 5.8529105, 4.3487496, 5.528109, 3.5939457,
            4.636965, 6.135133, 7.3540277, 5.964233, 6.50068, 3.8317401, 6.1176586, 4.8065133,
            4.8124523, 6.277377, 6.397292, 6.788731, 7.0776887, 6.0253015, 6.842026, 5.694848,
            4.895379, 5.39648, 5.771, 6.8407, 7.3727303, 5.9515443, 6.0095053, 4.6108336,
            5.5872073, 5.8783703, 5.9676175, 6.4890985, 5.53503, 6.135971, 6.9277387, 4.712733,
            5.459949, 6.01433, 5.4518576, 5.9829707, 5.6107264, 6.717319, 6.825099, 4.6293964,
        ],
    )
    .unwrap();
    let current_output32: Array3<f32> = conv_layer32.convolve(&test_input32);

    assert!(
        arr_allclose(&current_output32, &target_output32),
        "{:?} was not equal to {:?}",
        current_output32,
        target_output32
    );

    let test_input33 = Array::from_shape_vec(
        (3, 15, 10),
        vec![
            0.19982047, 0.2942452, 0.41777328, 0.90395254, 0.4888085, 0.9895415, 0.5478458,
            0.52514094, 0.7139765, 0.96795374, 0.703604, 0.11441413, 0.22741623, 0.14197119,
            0.14224136, 0.00554162, 0.08584995, 0.08854763, 0.55170393, 0.34441712, 0.01855595,
            0.5601068, 0.56593883, 0.16720486, 0.75972295, 0.4493232, 0.38319588, 0.7179427,
            0.19173315, 0.267287, 0.5663951, 0.07816565, 0.67903227, 0.00826331, 0.5425498,
            0.89380723, 0.11534049, 0.7132138, 0.4683366, 0.42596257, 0.4862424, 0.93492687,
            0.6817369, 0.0525712, 0.28192636, 0.4604141, 0.96248484, 0.43289438, 0.34953818,
            0.6902671, 0.5126539, 0.69908696, 0.2879344, 0.06127732, 0.7361598, 0.8519083,
            0.04873959, 0.88632005, 0.55267817, 0.35348675, 0.68609756, 0.07016034, 0.602,
            0.6732832, 0.82135326, 0.18075775, 0.37878716, 0.62920415, 0.3706305, 0.32302734,
            0.90577847, 0.54883826, 0.5766481, 0.9347623, 0.2624883, 0.27476153, 0.09443506,
            0.74253213, 0.01185389, 0.23280993, 0.17598268, 0.19381721, 0.65946394, 0.6743594,
            0.9255945, 0.8947401, 0.9869322, 0.08145659, 0.03987844, 0.7629663, 0.2965461,
            0.38589397, 0.86821306, 0.9996797, 0.77658385, 0.97871965, 0.12471338, 0.48183945,
            0.7989542, 0.61783546, 0.94045246, 0.71905494, 0.43614203, 0.11011575, 0.34765512,
            0.39178115, 0.7308709, 0.34274808, 0.35493043, 0.8328545, 0.06045034, 0.49653238,
            0.29012534, 0.55789274, 0.5755102, 0.4569207, 0.2188389, 0.51010305, 0.9529406,
            0.6924317, 0.91676563, 0.5358466, 0.6751086, 0.5230349, 0.9687458, 0.5856843, 0.700519,
            0.4472085, 0.44401753, 0.76227057, 0.18282856, 0.360823, 0.06306251, 0.769097,
            0.11797103, 0.5069124, 0.8386977, 0.9353965, 0.9456902, 0.21557523, 0.28468877,
            0.00299157, 0.94424677, 0.2590096, 0.12880772, 0.50224614, 0.6319564, 0.05983794,
            0.21579173, 0.9091785, 0.77259356, 0.9772731, 0.90224165, 0.5264099, 0.47108477,
            0.0492401, 0.25460967, 0.99656236, 0.5070151, 0.28755966, 0.36141592, 0.02703854,
            0.16006812, 0.7001516, 0.30561775, 0.8973991, 0.57343286, 0.7367476, 0.2606863,
            0.61278397, 0.9649247, 0.26253387, 0.27807143, 0.7962459, 0.67275447, 0.6407772,
            0.12578371, 0.84160686, 0.3605408, 0.96801484, 0.1393529, 0.72915196, 0.9006433,
            0.49849266, 0.5104628, 0.89867175, 0.955501, 0.59073764, 0.86861897, 0.9176197,
            0.5717296, 0.86013335, 0.39986315, 0.29667476, 0.9421052, 0.89406526, 0.92121494,
            0.05097519, 0.08086525, 0.9667328, 0.5984821, 0.37690058, 0.47047687, 0.24334699,
            0.9472316, 0.71601814, 0.6616385, 0.90634656, 0.49495855, 0.28245237, 0.41918305,
            0.27396587, 0.42253864, 0.94620466, 0.04238893, 0.61110425, 0.9539543, 0.3999544,
            0.66795814, 0.7064477, 0.99121827, 0.9024756, 0.85239345, 0.70719117, 0.7763093,
            0.10098496, 0.23122132, 0.86239356, 0.34863842, 0.10337279, 0.44741336, 0.02051973,
            0.33192208, 0.76970786, 0.37064746, 0.27677527, 0.4141578, 0.34976023, 0.20377244,
            0.15038556, 0.63522565, 0.39588144, 0.29719463, 0.5822416, 0.3832173, 0.7443069,
            0.31255615, 0.26080993, 0.93509567, 0.7061453, 0.4803283, 0.33021635, 0.13239637,
            0.35350803, 0.38336864, 0.51017934, 0.6332842, 0.07322941, 0.8859752, 0.41102257,
            0.2794688, 0.9154152, 0.2293425, 0.81592786, 0.0093977, 0.63983893, 0.7104612,
            0.8665582, 0.9376581, 0.35742825, 0.6020712, 0.42087105, 0.6417253, 0.08560265,
            0.02744765, 0.39207277, 0.21459882, 0.11062973, 0.87420404, 0.69151706, 0.1787167,
            0.85303366, 0.8576095, 0.5125019, 0.4814232, 0.3410254, 0.1897166, 0.5530291,
            0.8993465, 0.99207646, 0.31536198, 0.46590054, 0.01530014, 0.69832444, 0.990704,
            0.02463103, 0.01077096, 0.6721973, 0.6676321, 0.73046064, 0.7690768, 0.53152925,
            0.06813734, 0.47991776, 0.8400259, 0.13388659, 0.6923757, 0.56391525, 0.5064835,
            0.98023206, 0.8316277, 0.45037648, 0.8744264, 0.3228065, 0.77707547, 0.65587145,
            0.15356176, 0.8831219, 0.18077046, 0.81715685, 0.01058917, 0.54235333, 0.9747539,
            0.5249456, 0.14190416, 0.90132594, 0.29823583, 0.59148335, 0.5194669, 0.74204314,
            0.11199604, 0.32003468, 0.50086904, 0.22239625, 0.97291625, 0.86974585, 0.49535275,
            0.5424355, 0.10466193, 0.10202583, 0.25952706, 0.6287949, 0.5330766, 0.2682298,
            0.508476, 0.1925287, 0.09730922, 0.31764308, 0.14314991, 0.9460035, 0.65402883,
            0.71126366, 0.9785876, 0.32067546, 0.7039669, 0.7371736, 0.90192676, 0.7503396,
            0.9941749, 0.78996, 0.61614865, 0.35973564, 0.96392447, 0.5901891, 0.06196258,
            0.83785075, 0.37142363, 0.79140055, 0.07532936, 0.9428474, 0.43666556, 0.02624486,
            0.4253642, 0.78015715, 0.85766184, 0.7146162, 0.33209485, 0.80531436, 0.9730212,
            0.6855751, 0.69086134, 0.61613715, 0.67111015, 0.12122969, 0.50159, 0.74436355,
            0.7383121, 0.23079261, 0.04572792, 0.19533794, 0.4925117, 0.6131918, 0.44526327,
            0.20337714, 0.781168, 0.7058163, 0.46196786, 0.01862379, 0.90610075, 0.8073715,
            0.7148674, 0.5032462, 0.5038819, 0.85626405, 0.24466415, 0.09893908, 0.05245275,
            0.11470018, 0.90349656, 0.31138107, 0.8247195, 0.01722594, 0.5932752, 0.7054897,
            0.5784551, 0.26923984, 0.6289111, 0.11725764, 0.40164033, 0.6951812, 0.8073887,
            0.6793183, 0.7176144, 0.50780314, 0.9401547, 0.35663, 0.00467546, 0.84130347,
            0.34600323, 0.40760243, 0.47107708, 0.98480684, 0.13988449, 0.4022033, 0.558168,
            0.8453326, 0.42742896, 0.4576909, 0.8307157, 0.04634837, 0.39555076, 0.60654116,
            0.9779148, 0.3486375, 0.18171401, 0.93737435, 0.01817268, 0.31007424, 0.4095396,
            0.5559114,
        ],
    )
    .unwrap();

    let kernel33: Array4<f32> = Array::from_shape_vec(
        (2, 3, 3, 3),
        vec![
            0.20362668, 0.3899614, 0.26285827, 0.9031745, 0.95724046, 0.52430856, 0.5576659,
            0.6577067, 0.7514403, 0.533389, 0.94846255, 0.6964576, 0.96843016, 0.66096354,
            0.17514281, 0.83987904, 0.40466377, 0.13681252, 0.5367513, 0.5569262, 0.5836484,
            0.26183346, 0.24014333, 0.45519072, 0.36609647, 0.66722494, 0.40931305, 0.7678357,
            0.71030915, 0.8799919, 0.10468024, 0.23255506, 0.38094538, 0.4090506, 0.59137547,
            0.6625547, 0.6464879, 0.59517515, 0.5136288, 0.05843278, 0.51399225, 0.38453335,
            0.6970278, 0.5047524, 0.06902273, 0.09784848, 0.3510309, 0.9961713, 0.6529659,
            0.4457503, 0.25736928, 0.9593906, 0.07333596, 0.80891675,
        ],
    )
    .unwrap();
    let conv_layer33 = ConvolutionLayer::new(kernel33, 1, Padding::Valid);
    let target_output33: Array3<f32> = Array::from_shape_vec(
        (2, 13, 8),
        vec![
            7.4887285, 6.2483273, 6.8256507, 6.68944, 6.257571, 6.940286, 6.8354836, 8.0171385,
            6.2405667, 6.1319647, 7.182615, 8.254482, 8.182298, 8.326971, 7.026513, 7.5639205,
            7.270226, 7.526091, 7.268412, 7.334811, 8.40471, 8.573675, 7.3211484, 7.429284,
            8.389681, 7.752369, 6.7886295, 7.6312923, 9.965505, 9.8819895, 8.555902, 7.919549,
            8.086448, 7.0185513, 7.1685967, 7.7853985, 8.711976, 8.288569, 7.3958607, 7.8156133,
            8.090578, 7.698854, 8.884641, 9.108748, 7.616188, 8.101504, 8.503835, 8.456485,
            7.951813, 8.2978525, 8.986514, 8.68171, 7.585279, 7.257439, 6.432088, 6.594543,
            7.43284, 7.657317, 9.316401, 9.790535, 8.161291, 7.4275723, 6.6536446, 6.5201726,
            7.0639205, 6.877351, 7.6748157, 7.759752, 7.6588407, 6.6208754, 5.706783, 6.3877745,
            7.0075665, 7.061818, 6.526092, 7.127021, 6.5846844, 6.4377203, 7.4416585, 8.462118,
            7.4715624, 7.3077645, 7.2472677, 6.935799, 6.1398597, 5.9661374, 7.073392, 8.401555,
            7.513568, 7.791603, 7.5898376, 7.028405, 7.2882295, 7.7047615, 8.175156, 8.484478,
            7.1006293, 7.537631, 6.64099, 6.788922, 6.5717783, 5.8606043, 6.6979494, 8.631285,
            6.2331185, 6.6196303, 7.620484, 7.349687, 6.506543, 7.352319, 6.498407, 8.239708,
            5.2009583, 5.1213374, 6.870109, 6.4820194, 6.0925536, 7.5152826, 5.916372, 6.6851635,
            7.1955953, 6.499108, 6.036154, 6.9017863, 7.843702, 7.628494, 5.923781, 6.8294234,
            7.3661127, 5.632666, 7.2594447, 7.7164087, 8.581096, 8.121885, 7.0411973, 7.393781,
            7.8108215, 6.408314, 7.167295, 7.0980377, 6.73007, 8.30625, 6.7418613, 7.5805426,
            7.788345, 6.9741974, 7.852134, 7.6931934, 7.3673415, 8.138193, 7.4476523, 7.973346,
            6.821796, 6.5574703, 7.8061266, 7.85674, 7.0425467, 7.127106, 5.9749527, 5.9694858,
            7.527242, 8.252872, 8.69798, 7.6599097, 6.4979644, 6.3723598, 6.2100883, 5.9365416,
            6.5332646, 6.0664053, 6.451652, 7.4951906, 7.4138165, 5.609177, 5.180595, 5.1397004,
            6.7287393, 6.3441763, 7.494071, 7.9396024, 6.3009477, 5.0755477, 6.914454, 8.341613,
            7.6670136, 6.489417, 6.6779575, 5.2359724, 6.0586605, 5.8858547, 6.345834, 6.9947386,
            5.7478023, 7.86995, 6.300125, 6.6113224, 6.420385, 6.529797, 7.659451, 8.325523,
            7.7835145, 6.7630806, 6.7177, 6.661178, 5.6667576, 6.2875867, 5.7451925, 7.2311144,
        ],
    )
    .unwrap();
    let current_output33: Array3<f32> = conv_layer33.convolve(&test_input33);

    assert!(
        arr_allclose(&current_output33, &target_output33),
        "{:?} was not equal to {:?}",
        current_output33,
        target_output33
    );

    let test_input34 = Array::from_shape_vec(
        (3, 15, 10),
        vec![
            0.5196752, 0.25790986, 0.9833442, 0.63378453, 0.69324833, 0.7669788, 0.6144302,
            0.8679245, 0.25625056, 0.35837704, 0.59633005, 0.8309169, 0.23309404, 0.65488356,
            0.26520997, 0.34644812, 0.87685895, 0.5645692, 0.50217426, 0.967748, 0.969097,
            0.00554681, 0.48245648, 0.05388465, 0.2207341, 0.9374606, 0.7587759, 0.9855095,
            0.38765016, 0.7075585, 0.35234872, 0.86497676, 0.36315936, 0.05972259, 0.400054,
            0.3090082, 0.1404125, 0.32328948, 0.77128536, 0.7420292, 0.0151671, 0.3440802,
            0.36001205, 0.32235637, 0.1375511, 0.39828563, 0.7305659, 0.7766764, 0.86437464,
            0.9027017, 0.4454178, 0.34967113, 0.75469947, 0.3584414, 0.8001929, 0.2543982,
            0.72871476, 0.9618047, 0.34620103, 0.9426159, 0.50686455, 0.6152326, 0.12266664,
            0.559009, 0.21047816, 0.16580608, 0.2582814, 0.15493484, 0.20253018, 0.21612453,
            0.5038661, 0.91294247, 0.8080103, 0.838882, 0.7180022, 0.20993726, 0.58702785,
            0.5285052, 0.00845493, 0.9090709, 0.63151246, 0.8139426, 0.25651568, 0.02755868,
            0.03389508, 0.30576277, 0.37300143, 0.13004215, 0.608248, 0.16874252, 0.27251562,
            0.19374174, 0.22429508, 0.5501398, 0.49685606, 0.46965292, 0.11797722, 0.7302286,
            0.38946074, 0.3407683, 0.72125804, 0.86716634, 0.98185354, 0.15272117, 0.02051388,
            0.27791747, 0.7587074, 0.23504323, 0.02695821, 0.39229694, 0.15247433, 0.48075756,
            0.7610872, 0.22628488, 0.9413573, 0.30246893, 0.01136111, 0.9598438, 0.8383011,
            0.9723616, 0.47197652, 0.94492614, 0.21735138, 0.31927556, 0.39669687, 0.05186762,
            0.79388624, 0.17953911, 0.6036967, 0.9663948, 0.48956135, 0.4727555, 0.41221553,
            0.17531991, 0.84556717, 0.04869543, 0.81426054, 0.8781844, 0.956683, 0.51194495,
            0.7431968, 0.02038087, 0.00589341, 0.4704734, 0.10196105, 0.4856146, 0.2972315,
            0.14647067, 0.2117447, 0.8261646, 0.95831466, 0.9185463, 0.98925644, 0.5729306,
            0.1967555, 0.33214343, 0.24979122, 0.6015046, 0.26777977, 0.9183129, 0.25964326,
            0.38164377, 0.45220876, 0.09959481, 0.9193449, 0.8044326, 0.44542107, 0.30965453,
            0.42501828, 0.6194622, 0.89371026, 0.08402323, 0.5293358, 0.816318, 0.57557297,
            0.08988074, 0.9184309, 0.84704405, 0.9194768, 0.4946111, 0.24117838, 0.97676104,
            0.9935074, 0.9232175, 0.5854387, 0.3386878, 0.5352726, 0.08310746, 0.6829108,
            0.66831505, 0.7869529, 0.42882872, 0.84581494, 0.11308007, 0.07337865, 0.02265424,
            0.6603618, 0.6904631, 0.47793466, 0.58312225, 0.33399308, 0.1441583, 0.03236333,
            0.31139955, 0.23037143, 0.23011816, 0.81936634, 0.9375789, 0.1625122, 0.11950397,
            0.71464306, 0.6463952, 0.5489697, 0.8545862, 0.9213473, 0.52128464, 0.1224625,
            0.6615045, 0.7931158, 0.4731851, 0.48125225, 0.4718432, 0.33050996, 0.32576007,
            0.4363914, 0.01891187, 0.8601632, 0.02397078, 0.53442717, 0.5216071, 0.40344155,
            0.063399, 0.19041517, 0.02668436, 0.07788111, 0.15599571, 0.4338736, 0.8760362,
            0.9668574, 0.7971797, 0.13885641, 0.52926344, 0.32682723, 0.9537846, 0.6078623,
            0.27223235, 0.09553351, 0.8403314, 0.12087691, 0.60492355, 0.03379478, 0.13423896,
            0.23765405, 0.31380126, 0.70387655, 0.79063565, 0.92111635, 0.65776235, 0.38434002,
            0.7584332, 0.2882407, 0.711263, 0.61748165, 0.1864088, 0.6243588, 0.20176977,
            0.02156927, 0.06738149, 0.8982146, 0.2390027, 0.07549326, 0.65994954, 0.01747457,
            0.12387726, 0.06532437, 0.08151705, 0.19784369, 0.64356047, 0.42640674, 0.68663126,
            0.22805685, 0.023332, 0.59032553, 0.8226498, 0.7051767, 0.62274987, 0.63475907,
            0.7238778, 0.5970565, 0.88734704, 0.07542202, 0.71210676, 0.6989102, 0.5070594,
            0.12374777, 0.22591083, 0.26892266, 0.7791601, 0.76115644, 0.91088, 0.5503317,
            0.9804811, 0.03202334, 0.46311814, 0.09919641, 0.26757732, 0.28902137, 0.7140448,
            0.5040979, 0.37557426, 0.5246399, 0.66929567, 0.7025585, 0.66615474, 0.30578545,
            0.35601366, 0.7942114, 0.20677379, 0.15500914, 0.7926027, 0.29064912, 0.8273933,
            0.99714524, 0.5301375, 0.63807166, 0.15588701, 0.53650105, 0.883448, 0.28218988,
            0.3352366, 0.1015854, 0.21515913, 0.0677837, 0.46811357, 0.2523892, 0.1536621,
            0.3143135, 0.53114694, 0.79320407, 0.75357485, 0.07968733, 0.6287965, 0.2200977,
            0.590361, 0.8816608, 0.92466223, 0.23308377, 0.7569012, 0.1372336, 0.72369504,
            0.01938523, 0.989562, 0.82807124, 0.978318, 0.90013695, 0.10934412, 0.31143916,
            0.60268074, 0.89117837, 0.27851093, 0.29225165, 0.16005383, 0.7666568, 0.8990756,
            0.45873183, 0.03297786, 0.4354277, 0.20520075, 0.67032087, 0.70261323, 0.62342596,
            0.4962149, 0.4153414, 0.5587902, 0.40878415, 0.5055576, 0.81622064, 0.5339488,
            0.6388459, 0.304105, 0.82015866, 0.2952592, 0.71163654, 0.9769518, 0.13750617,
            0.10509957, 0.6421733, 0.01179794, 0.86186355, 0.06657688, 0.22622024, 0.97906446,
            0.01797699, 0.04377225, 0.15706603, 0.6343292, 0.5594078, 0.11903284, 0.8178364,
            0.9288911, 0.15461008, 0.9943553, 0.8165832, 0.13425252, 0.9562293, 0.17169783,
            0.05023352, 0.6767696, 0.66343135, 0.32775852, 0.14548539, 0.66260463, 0.9435393,
            0.56790006, 0.22986317, 0.76032287, 0.8746105, 0.2665503, 0.82373565, 0.28121006,
            0.29389632, 0.3074064, 0.40319064, 0.29072547, 0.22278658, 0.21566778, 0.04191615,
            0.35444143, 0.594935, 0.5280909, 0.6227668, 0.9995037, 0.34129518, 0.07482269,
            0.9538717, 0.57593834, 0.6352265, 0.32445627, 0.25140822, 0.93379414, 0.82740843,
            0.18509477, 0.6084598, 0.7941346, 0.13568091, 0.81633985, 0.7832342, 0.7269978,
            0.7938294, 0.24875638,
        ],
    )
    .unwrap();

    let kernel34: Array4<f32> = Array::from_shape_vec(
        (2, 3, 5, 5),
        vec![
            0.53098685, 0.97634184, 0.3654985, 0.6197924, 0.1958822, 0.91466755, 0.82326293,
            0.05417962, 0.2876998, 0.34076488, 0.22490515, 0.34424198, 0.8024984, 0.86761755,
            0.2457382, 0.94153976, 0.42271057, 0.8497308, 0.13301279, 0.01450239, 0.12739219,
            0.2980205, 0.1089614, 0.4534563, 0.20752071, 0.44084755, 0.32884085, 0.78595555,
            0.29699826, 0.8696194, 0.87364227, 0.1825079, 0.8653281, 0.11152316, 0.10165259,
            0.30172202, 0.5634873, 0.79023945, 0.12142149, 0.89489484, 0.32732126, 0.16754848,
            0.14866899, 0.72059697, 0.48512897, 0.1768624, 0.36138168, 0.34082386, 0.24096294,
            0.5398071, 0.52981263, 0.8495612, 0.45151472, 0.01440341, 0.92154115, 0.32281688,
            0.9658324, 0.11643393, 0.02498931, 0.74842566, 0.71275234, 0.38320434, 0.3124743,
            0.99616134, 0.10025226, 0.60567856, 0.8189058, 0.44458553, 0.2570787, 0.15552202,
            0.5807619, 0.05135555, 0.30162072, 0.84052527, 0.06775604, 0.61146617, 0.77579254,
            0.7554349, 0.9041999, 0.5885413, 0.43739402, 0.9121548, 0.704337, 0.71699256,
            0.41252124, 0.49857914, 0.77542007, 0.62377745, 0.58095855, 0.35906684, 0.62711567,
            0.6132724, 0.54546535, 0.83928454, 0.8303008, 0.1890054, 0.23060308, 0.5893513,
            0.16549692, 0.61116034, 0.2488159, 0.99599046, 0.39940432, 0.11897708, 0.15867555,
            0.76753354, 0.31943667, 0.56480473, 0.5548302, 0.409648, 0.16849968, 0.04038839,
            0.7188009, 0.05252765, 0.41155177, 0.6754611, 0.5676015, 0.26794127, 0.53823626,
            0.615944, 0.17735237, 0.6197911, 0.5388062, 0.47061965, 0.87098825, 0.0603164,
            0.68002754, 0.23997463, 0.3244519, 0.17411815, 0.42630666, 0.2310866, 0.984915,
            0.023685, 0.17943048, 0.63610965, 0.66366726, 0.30550992, 0.5162294, 0.4861491,
            0.7804716, 0.16118859, 0.13860539, 0.24022588, 0.27965236, 0.00709001, 0.99179137,
            0.451131, 0.7894441, 0.71554166,
        ],
    )
    .unwrap();
    let conv_layer34 = ConvolutionLayer::new(kernel34, 1, Padding::Valid);
    let target_output34: Array3<f32> = Array::from_shape_vec(
        (2, 11, 6),
        vec![
            15.893309, 16.003056, 17.091692, 15.946317, 16.766329, 18.311186, 16.113644, 15.650959,
            15.961646, 15.65655, 16.59108, 18.487652, 16.647049, 15.845856, 16.939508, 16.709852,
            18.02757, 16.659975, 16.590378, 16.25814, 15.12102, 15.104687, 15.489513, 15.900293,
            16.767342, 14.636034, 14.598309, 17.105003, 15.084599, 16.486755, 15.883568, 15.312074,
            16.093092, 15.713956, 14.439006, 14.99601, 15.44511, 14.429862, 14.457103, 14.391803,
            14.475582, 15.090251, 16.22143, 16.090479, 15.855927, 13.194719, 13.84052, 15.345637,
            13.174303, 14.026248, 13.47183, 12.037113, 15.543908, 16.463213, 14.99754, 16.303585,
            13.83361, 14.131294, 15.598161, 15.956799, 16.036808, 15.103044, 14.744986, 14.501427,
            16.584175, 16.515768, 18.721403, 18.364408, 18.204378, 17.662432, 19.603834, 19.538958,
            17.52644, 15.485604, 16.787117, 18.310207, 19.325739, 21.000582, 16.556007, 17.222261,
            16.993446, 17.992277, 18.153837, 19.395884, 17.710718, 16.569962, 17.432863, 16.981127,
            16.889582, 18.342737, 16.461243, 15.8470745, 16.309359, 16.021738, 16.162868,
            17.995436, 17.771074, 15.604953, 16.16788, 15.85995, 15.998639, 16.92095, 17.947412,
            16.86713, 15.377628, 16.184195, 14.780607, 15.223765, 17.128359, 16.795134, 15.300153,
            14.4403105, 16.26448, 17.594881, 14.438286, 15.0616865, 12.790247, 12.840883,
            15.588263, 16.25769, 17.017687, 15.740665, 17.170694, 16.349045, 16.93339, 18.493858,
            16.227297, 16.925367, 15.220495, 16.235558, 18.660019, 19.244967,
        ],
    )
    .unwrap();
    let current_output34: Array3<f32> = conv_layer34.convolve(&test_input34);

    assert!(
        arr_allclose(&current_output34, &target_output34),
        "{:?} was not equal to {:?}",
        current_output34,
        target_output34
    );

    let test_input35 = Array::from_shape_vec(
        (3, 15, 10),
        vec![
            0.9964236, 0.85572857, 0.08051511, 0.48360798, 0.39250162, 0.6405559, 0.65542877,
            0.00926249, 0.49451137, 0.92131656, 0.2670481, 0.4149794, 0.62419057, 0.6299236,
            0.72737783, 0.28075695, 0.6380664, 0.72403, 0.95138586, 0.15112722, 0.04702903,
            0.03742034, 0.12904108, 0.40806046, 0.24292202, 0.9610627, 0.152939, 0.5112613,
            0.7121952, 0.44103095, 0.09925622, 0.4587128, 0.2244921, 0.3738838, 0.44769827,
            0.68232304, 0.3501035, 0.90325624, 0.18933062, 0.683113, 0.37947366, 0.83893037,
            0.00036895, 0.8030902, 0.15520981, 0.31636, 0.03485033, 0.21666723, 0.5258305,
            0.4617171, 0.45026395, 0.20907213, 0.6479722, 0.9916083, 0.31935102, 0.53539133,
            0.29856464, 0.46920267, 0.2788216, 0.2287987, 0.9548321, 0.2423434, 0.12699115,
            0.22725932, 0.5864343, 0.4539676, 0.72710156, 0.67460907, 0.7224578, 0.9838608,
            0.46925062, 0.7267446, 0.7348552, 0.07147343, 0.03087187, 0.95043266, 0.7644256,
            0.6736655, 0.1939531, 0.8566437, 0.8916521, 0.8495752, 0.29966143, 0.22144382,
            0.84936816, 0.05329819, 0.5158916, 0.31214204, 0.60962343, 0.2085157, 0.020407,
            0.9285702, 0.39927888, 0.29198912, 0.32679623, 0.95807105, 0.5470224, 0.3903264,
            0.2943695, 0.7187741, 0.64249885, 0.90529513, 0.9696485, 0.96716243, 0.7952436,
            0.8560521, 0.897583, 0.26358747, 0.4610603, 0.24524814, 0.4270144, 0.36576656,
            0.52139103, 0.49643677, 0.02449073, 0.32803342, 0.52485585, 0.59270257, 0.5181942,
            0.10436007, 0.5402461, 0.51220167, 0.9574334, 0.12048424, 0.18159197, 0.12942687,
            0.54154533, 0.8665665, 0.2244735, 0.6322593, 0.9785378, 0.00970959, 0.5571932,
            0.7287427, 0.6722845, 0.08840237, 0.7786622, 0.55595505, 0.49039194, 0.29876545,
            0.9639111, 0.6217684, 0.75457317, 0.07906571, 0.24218307, 0.20196797, 0.6608763,
            0.6632383, 0.17440334, 0.51526874, 0.8816509, 0.39972377, 0.00945449, 0.15960339,
            0.9031067, 0.92360485, 0.6093835, 0.0279216, 0.57159376, 0.739127, 0.07560094,
            0.5449533, 0.31076494, 0.4063533, 0.61592543, 0.6617724, 0.89307874, 0.14274225,
            0.7946265, 0.26793155, 0.01026518, 0.35911655, 0.54531777, 0.46913606, 0.69393593,
            0.76704943, 0.17376864, 0.15214977, 0.24446122, 0.38009068, 0.18737185, 0.5655409,
            0.26423022, 0.74053663, 0.855276, 0.57912683, 0.7191395, 0.46456698, 0.73671806,
            0.43812937, 0.6747385, 0.7878329, 0.6957145, 0.25479087, 0.9675421, 0.9952376,
            0.7553026, 0.39445186, 0.16850758, 0.47348526, 0.3428721, 0.7345647, 0.4810381,
            0.06958814, 0.4049107, 0.01440958, 0.5659006, 0.4767252, 0.89691705, 0.71229553,
            0.6637993, 0.378025, 0.6954722, 0.42989764, 0.4112019, 0.9774286, 0.3272699, 0.3518699,
            0.87228006, 0.7196134, 0.38309374, 0.38645524, 0.96709275, 0.97874445, 0.05056721,
            0.5945655, 0.25838065, 0.280568, 0.12965602, 0.16904165, 0.7337121, 0.5255171,
            0.53067166, 0.79937047, 0.92811966, 0.42017522, 0.9749549, 0.86373013, 0.45530656,
            0.49178642, 0.7708463, 0.4978779, 0.6229996, 0.8937434, 0.14543204, 0.46538925,
            0.25468576, 0.55258465, 0.7953501, 0.34347492, 0.947921, 0.7406703, 0.530338,
            0.23003381, 0.51276684, 0.6199976, 0.7165106, 0.31285286, 0.01742517, 0.79403925,
            0.44514382, 0.47107297, 0.11938072, 0.53394765, 0.07118031, 0.26642635, 0.608863,
            0.6127199, 0.57685304, 0.63766026, 0.09857575, 0.9238777, 0.58972347, 0.81341505,
            0.23035105, 0.14867568, 0.2806283, 0.4781139, 0.9134012, 0.32021993, 0.82838976,
            0.8087745, 0.3820947, 0.15508978, 0.8816074, 0.9581791, 0.95054454, 0.7201289,
            0.2628233, 0.42030758, 0.08099908, 0.9801681, 0.9285927, 0.23243731, 0.01609867,
            0.95514953, 0.2603031, 0.5272288, 0.1027505, 0.5149132, 0.8630202, 0.9967142,
            0.83670455, 0.8208894, 0.39562112, 0.5423381, 0.3541803, 0.7045485, 0.17121983,
            0.07215097, 0.7547516, 0.43495062, 0.05219934, 0.32704812, 0.8069043, 0.3644227,
            0.3185606, 0.8381945, 0.18509601, 0.78284556, 0.14064422, 0.0866156, 0.76108783,
            0.20690504, 0.81923145, 0.86893994, 0.08369987, 0.8462739, 0.19355603, 0.45527726,
            0.07187212, 0.165468, 0.19925202, 0.19391125, 0.98580116, 0.11626041, 0.9640388,
            0.83806276, 0.68621, 0.20116507, 0.6458135, 0.7946413, 0.5135085, 0.96608514,
            0.2866232, 0.04018129, 0.4744012, 0.56197965, 0.44840696, 0.51113236, 0.34871954,
            0.3864388, 0.7972437, 0.418459, 0.6831303, 0.5827626, 0.24505354, 0.45846483,
            0.35040325, 0.81632674, 0.45164114, 0.34192115, 0.01926605, 0.60945815, 0.00720319,
            0.16734742, 0.14712231, 0.5927163, 0.54784405, 0.10600431, 0.8042268, 0.9593917,
            0.54439926, 0.09722981, 0.538895, 0.96085125, 0.12880406, 0.82884103, 0.89940333,
            0.896239, 0.00895003, 0.6723138, 0.5635491, 0.5774044, 0.8294056, 0.7330833, 0.7182023,
            0.2400944, 0.08234657, 0.8326292, 0.81366646, 0.56454206, 0.41107583, 0.1530087,
            0.10750511, 0.6369332, 0.55479336, 0.8068582, 0.87786776, 0.0768621, 0.5117609,
            0.02565966, 0.81959426, 0.8734937, 0.9121203, 0.14144829, 0.6808026, 0.56961155,
            0.09299238, 0.07851031, 0.09498502, 0.39703202, 0.3460928, 0.7413816, 0.50219774,
            0.09790236, 0.7560407, 0.5504823, 0.0988896, 0.3634248, 0.7626221, 0.36921418,
            0.69651574, 0.02017781, 0.69639486, 0.1327469, 0.20396212, 0.37377915, 0.8627079,
            0.2315043, 0.9150178, 0.05492407, 0.28059694, 0.77607256, 0.6814465, 0.0384257,
            0.41136658, 0.07444459, 0.92572653, 0.19929981, 0.60906744, 0.85304475, 0.435523,
            0.34991544, 0.9227076, 0.24557048, 0.7524436, 0.61218125, 0.02676343, 0.68666,
        ],
    )
    .unwrap();

    let kernel35: Array4<f32> = Array::from_shape_vec(
        (2, 3, 5, 5),
        vec![
            0.01549418, 0.47552216, 0.6233486, 0.5846968, 0.5351139, 0.7165851, 0.95146346,
            0.3654481, 0.58597034, 0.28302717, 0.684635, 0.33453104, 0.21812607, 0.02301173,
            0.1716157, 0.21556447, 0.9240008, 0.87333375, 0.97975385, 0.80055225, 0.38515112,
            0.96327585, 0.7670258, 0.89840883, 0.27143422, 0.04667937, 0.8971626, 0.66015846,
            0.30812186, 0.9944557, 0.32269347, 0.906517, 0.42958102, 0.19323848, 0.894492,
            0.41707778, 0.047074, 0.15186748, 0.42941824, 0.06797581, 0.7101957, 0.21114524,
            0.90267074, 0.18382856, 0.3805317, 0.7464236, 0.54372054, 0.98692304, 0.43391776,
            0.21931884, 0.6479137, 0.46971908, 0.41600463, 0.03177308, 0.36561352, 0.897173,
            0.02432681, 0.76844287, 0.93577814, 0.47288647, 0.7132774, 0.16475675, 0.4621884,
            0.682621, 0.05393951, 0.04056123, 0.3831229, 0.25017264, 0.5441924, 0.18582676,
            0.5847652, 0.44094405, 0.9492341, 0.40716594, 0.70403796, 0.6190288, 0.27133584,
            0.49946982, 0.49807012, 0.13783294, 0.75838685, 0.7099942, 0.4189943, 0.948784,
            0.46828213, 0.5418886, 0.28150013, 0.44120148, 0.5618839, 0.16930467, 0.879468,
            0.02054715, 0.36957732, 0.24645625, 0.14384301, 0.44379708, 0.07697041, 0.8383886,
            0.2855142, 0.53293884, 0.32704464, 0.48172623, 0.8055037, 0.3063715, 0.26814866,
            0.34428266, 0.46858206, 0.08870029, 0.17744416, 0.601813, 0.5264963, 0.11456152,
            0.59114003, 0.5420228, 0.35435796, 0.77906114, 0.23198476, 0.61676294, 0.9468379,
            0.8001697, 0.2724277, 0.01428977, 0.39779025, 0.28065884, 0.00778698, 0.09425906,
            0.5519918, 0.08802161, 0.92948604, 0.7061356, 0.7931947, 0.5900978, 0.06217905,
            0.47630212, 0.30325878, 0.18036312, 0.6808438, 0.8025547, 0.65311456, 0.64131045,
            0.73011106, 0.6758199, 0.88006234, 0.6694761, 0.03111337, 0.33597425, 0.11015231,
            0.11921299, 0.25126496, 0.69373703,
        ],
    )
    .unwrap();
    let conv_layer35 = ConvolutionLayer::new(kernel35, 1, Padding::Valid);
    let target_output35: Array3<f32> = Array::from_shape_vec(
        (2, 11, 6),
        vec![
            17.27292, 18.784842, 19.676777, 19.113552, 20.360174, 18.939444, 17.405758, 17.389105,
            18.45941, 16.617695, 19.417091, 18.185917, 16.039427, 17.78068, 17.013344, 18.193108,
            19.345692, 17.10235, 19.199465, 17.926794, 18.2739, 19.767048, 19.265072, 19.766031,
            20.068638, 18.929289, 19.105217, 18.77092, 17.776253, 18.782309, 19.11523, 17.73529,
            16.839767, 17.610546, 18.745533, 20.113972, 19.763647, 21.63889, 20.401625, 19.574804,
            20.366535, 19.266876, 20.516191, 20.859545, 19.24283, 19.225113, 18.292704, 18.806465,
            18.776686, 18.266636, 17.907005, 17.532906, 18.735786, 18.31633, 19.881731, 19.489159,
            17.976177, 18.808737, 19.19052, 17.526848, 19.58763, 18.201628, 19.104244, 17.548704,
            17.211184, 18.060762, 14.5727005, 16.838531, 16.043135, 18.201363, 18.07946, 16.366594,
            14.756787, 18.024687, 16.602003, 17.400785, 17.977703, 16.802114, 14.379009, 15.46246,
            15.7021, 16.834332, 16.855526, 15.949021, 17.031002, 16.484316, 15.160456, 16.775589,
            15.628432, 17.60931, 17.596888, 15.735805, 16.810812, 15.371896, 15.161644, 16.434444,
            17.157297, 17.257315, 16.168814, 17.752602, 17.949049, 17.093105, 18.048903, 17.503012,
            17.35249, 16.81256, 17.938528, 17.436775, 17.38502, 18.254187, 17.16899, 18.169151,
            17.30289, 16.787792, 17.669197, 17.540163, 17.30292, 16.687859, 16.336985, 16.154402,
            17.439009, 16.196356, 17.237253, 16.287111, 16.709097, 15.72603, 18.215199, 15.638898,
            16.785082, 17.2102, 15.2935295, 14.531208,
        ],
    )
    .unwrap();
    let current_output35: Array3<f32> = conv_layer35.convolve(&test_input35);

    assert!(
        arr_allclose(&current_output35, &target_output35),
        "{:?} was not equal to {:?}",
        current_output35,
        target_output35
    );

    let test_input36 = Array::from_shape_vec(
        (3, 15, 10),
        vec![
            0.76781565, 0.11956753, 0.23382041, 0.8918218, 0.5422157, 0.69890016, 0.7473441,
            0.1025933, 0.24523091, 0.5532268, 0.29599845, 0.33235383, 0.6964844, 0.34388152,
            0.44655514, 0.10984504, 0.6096152, 0.6824109, 0.59089476, 0.74966764, 0.4055674,
            0.6066833, 0.03922287, 0.5139047, 0.27276048, 0.22169068, 0.16944607, 0.1006932,
            0.54000634, 0.38137078, 0.0453749, 0.7720287, 0.3950377, 0.47227803, 0.08456346,
            0.99505395, 0.5079503, 0.09107142, 0.49050683, 0.9648078, 0.49166626, 0.12798251,
            0.8570686, 0.6969486, 0.550415, 0.72912633, 0.30650783, 0.0107817, 0.53507906,
            0.33481097, 0.9804115, 0.00238096, 0.6885192, 0.01554713, 0.11027454, 0.92016417,
            0.5638509, 0.1789127, 0.78164, 0.73606557, 0.59824157, 0.56275487, 0.02244601,
            0.17319581, 0.5161816, 0.71388936, 0.37650406, 0.85731035, 0.8822338, 0.59797186,
            0.47906098, 0.41637895, 0.40831715, 0.7001218, 0.5204471, 0.54864365, 0.8242743,
            0.31435138, 0.02069527, 0.43211794, 0.7621477, 0.6553853, 0.8650503, 0.5980359,
            0.80163413, 0.69807684, 0.9225537, 0.8177609, 0.70200926, 0.43390045, 0.7971179,
            0.6481248, 0.18671374, 0.08406905, 0.7281945, 0.14004932, 0.508026, 0.01313858,
            0.37515613, 0.11442149, 0.7139359, 0.11509855, 0.04620427, 0.00338423, 0.58042264,
            0.3497844, 0.3701509, 0.11006287, 0.45462498, 0.6825711, 0.05430869, 0.07369657,
            0.29473898, 0.7133292, 0.52332807, 0.34203872, 0.24697433, 0.74098635, 0.6492484,
            0.58181113, 0.46049482, 0.78417206, 0.8818306, 0.33960003, 0.35578284, 0.24270806,
            0.93051934, 0.92984384, 0.16793567, 0.71563727, 0.5067316, 0.7600932, 0.7999726,
            0.14365989, 0.5092142, 0.00534251, 0.80710125, 0.2787269, 0.8396754, 0.30427325,
            0.936621, 0.9142885, 0.8632821, 0.55376446, 0.625111, 0.4412164, 0.3195551, 0.6029102,
            0.9898425, 0.9381164, 0.6333335, 0.13985266, 0.8077021, 0.7700269, 0.50355774,
            0.10565319, 0.23793669, 0.71038556, 0.67167306, 0.8206902, 0.75199634, 0.76066047,
            0.3374138, 0.20438518, 0.09583076, 0.26670292, 0.302565, 0.96722347, 0.08686233,
            0.32253316, 0.6016514, 0.1029643, 0.24522461, 0.7150578, 0.4008225, 0.38874564,
            0.6595543, 0.95465165, 0.01596426, 0.76611406, 0.8181969, 0.03268935, 0.7153868,
            0.66963005, 0.5199071, 0.2819424, 0.7306344, 0.9730751, 0.6738613, 0.0549346,
            0.25791696, 0.5304246, 0.8426447, 0.72531515, 0.13520858, 0.96914834, 0.8901288,
            0.7469712, 0.6678507, 0.3369298, 0.81467754, 0.57052803, 0.7706615, 0.3061074,
            0.34104946, 0.58939576, 0.35754028, 0.2814671, 0.24533354, 0.47058627, 0.61166996,
            0.45030525, 0.36717632, 0.41391012, 0.09461671, 0.23220702, 0.12344587, 0.6565849,
            0.26958194, 0.6252355, 0.66725403, 0.28030816, 0.94266546, 0.36014387, 0.18757097,
            0.5703369, 0.16459827, 0.30671576, 0.21797805, 0.7206875, 0.6050165, 0.8809775,
            0.66180915, 0.75661963, 0.29241282, 0.1968727, 0.4542289, 0.02982224, 0.2568436,
            0.9907141, 0.44230437, 0.69032484, 0.03288648, 0.11709308, 0.47962424, 0.00421954,
            0.10283989, 0.3329353, 0.63708895, 0.4274258, 0.31321532, 0.22448166, 0.66300994,
            0.61263674, 0.2107704, 0.11320372, 0.15715665, 0.80958194, 0.08474967, 0.04113929,
            0.32154062, 0.849806, 0.31686947, 0.7765318, 0.8935719, 0.54813904, 0.01871248,
            0.21038549, 0.5478772, 0.82956314, 0.55810463, 0.7496332, 0.09080196, 0.33296862,
            0.8914651, 0.01912449, 0.12571159, 0.70726824, 0.46620196, 0.23451181, 0.7185725,
            0.6916267, 0.9052224, 0.10002703, 0.20822853, 0.1988695, 0.57364607, 0.4514327,
            0.55767894, 0.21136971, 0.11364792, 0.9546512, 0.6512276, 0.5546642, 0.12630945,
            0.51929957, 0.7541355, 0.6958903, 0.40889722, 0.6899308, 0.5024765, 0.99110264,
            0.9034433, 0.05693591, 0.5522474, 0.694196, 0.0815046, 0.30395797, 0.5063144,
            0.00728971, 0.00863769, 0.94890165, 0.6072152, 0.1212473, 0.61905736, 0.04567454,
            0.1666415, 0.40940228, 0.29845986, 0.5887852, 0.7602986, 0.11050353, 0.6696046,
            0.07813971, 0.38485697, 0.10532968, 0.61089563, 0.09593545, 0.5708666, 0.6752682,
            0.43946478, 0.41972712, 0.7528657, 0.8565683, 0.0050115, 0.02211638, 0.18553229,
            0.9416627, 0.964609, 0.06604452, 0.2743094, 0.2357167, 0.5574499, 0.5644317,
            0.94941133, 0.6237617, 0.6896496, 0.23183365, 0.04779868, 0.58043236, 0.6772494,
            0.13355136, 0.593486, 0.30506894, 0.44111732, 0.45790267, 0.6058327, 0.66940916,
            0.30341497, 0.23764269, 0.255508, 0.18811014, 0.63789237, 0.8048158, 0.9402614,
            0.2806987, 0.21831155, 0.7669063, 0.8436678, 0.2923272, 0.634105, 0.92047054,
            0.9146937, 0.7982995, 0.04169853, 0.87467635, 0.41619235, 0.840219, 0.76187396,
            0.12894545, 0.43775168, 0.5403959, 0.52092886, 0.24986073, 0.89598167, 0.521647,
            0.81967235, 0.43917, 0.15041436, 0.51197404, 0.96864545, 0.6379747, 0.3724083,
            0.08220442, 0.24152991, 0.34628263, 0.9865399, 0.01694399, 0.63907087, 0.9424468,
            0.08953476, 0.25998822, 0.2556481, 0.18014309, 0.8692504, 0.81214136, 0.27443436,
            0.84424555, 0.9677495, 0.07064668, 0.99396145, 0.74180704, 0.9068687, 0.49582243,
            0.1071836, 0.15657824, 0.18524589, 0.25940374, 0.74904203, 0.26350108, 0.99580127,
            0.41392356, 0.7190492, 0.5932102, 0.36214927, 0.7134346, 0.04343178, 0.01264012,
            0.30633783, 0.7311494, 0.06306978, 0.63444036, 0.04783731, 0.13794519, 0.38289404,
            0.72769856, 0.43036366, 0.43202257, 0.6176036, 0.55465347, 0.26971525, 0.37383646,
            0.5103922, 0.60774666, 0.3769874, 0.5617109, 0.51972485, 0.35903165, 0.83329135,
            0.38157287,
        ],
    )
    .unwrap();

    let kernel36: Array4<f32> = Array::from_shape_vec(
        (2, 3, 5, 5),
        vec![
            0.19452758, 0.9900095, 0.5688352, 0.38870603, 0.93941313, 0.54574215, 0.8724074,
            0.06244482, 0.7421376, 0.39895928, 0.45440432, 0.7743095, 0.6971712, 0.03544521,
            0.69407845, 0.26511827, 0.5651197, 0.48221946, 0.7607782, 0.8649758, 0.2564574,
            0.93321526, 0.784176, 0.86321056, 0.9557799, 0.7198472, 0.54026544, 0.15434536,
            0.09155878, 0.715203, 0.502141, 0.49909648, 0.6098034, 0.9002247, 0.95214695, 0.250633,
            0.793483, 0.31241128, 0.16839387, 0.8495973, 0.77755684, 0.67304164, 0.62291604,
            0.5917267, 0.5918919, 0.70248216, 0.7110755, 0.545842, 0.21467632, 0.26781648,
            0.05703689, 0.8860448, 0.97129184, 0.67114294, 0.53076035, 0.73335916, 0.86454815,
            0.8135725, 0.7166568, 0.7596735, 0.2597569, 0.6837008, 0.49211782, 0.6234512,
            0.26292253, 0.7031715, 0.51520824, 0.34538904, 0.9509948, 0.77339244, 0.3037366,
            0.00554333, 0.00499232, 0.56012625, 0.04692093, 0.95133615, 0.4318458, 0.58763003,
            0.0488642, 0.02556094, 0.17130233, 0.1298894, 0.5945981, 0.00256654, 0.8014985,
            0.8908257, 0.2149228, 0.42144233, 0.49002212, 0.61149436, 0.47333992, 0.30657023,
            0.46667865, 0.9132112, 0.40754157, 0.6353514, 0.5068442, 0.90569776, 0.14007695,
            0.7795671, 0.5276461, 0.1113743, 0.85458857, 0.05200182, 0.762922, 0.6828541,
            0.79006946, 0.99515516, 0.07048018, 0.7193077, 0.1785365, 0.8050948, 0.5620368,
            0.53197616, 0.12924373, 0.6227516, 0.92304647, 0.35233787, 0.04703298, 0.89363664,
            0.8008906, 0.4826988, 0.24232654, 0.9236824, 0.53568405, 0.99749255, 0.00387712,
            0.27529702, 0.75773144, 0.68179756, 0.28086394, 0.14250895, 0.6985803, 0.00022103,
            0.21589486, 0.17350982, 0.5402848, 0.9610416, 0.96504945, 0.0072373, 0.43020758,
            0.8641754, 0.04885763, 0.94388, 0.6947651, 0.87142104, 0.6279961, 0.5023904, 0.7267018,
            0.34156242,
        ],
    )
    .unwrap();
    let conv_layer36 = ConvolutionLayer::new(kernel36, 1, Padding::Valid);
    let target_output36: Array3<f32> = Array::from_shape_vec(
        (2, 11, 6),
        vec![
            19.101576, 19.345135, 19.558159, 19.446009, 18.231838, 18.673357, 19.7326, 19.604666,
            19.447618, 18.734535, 18.455605, 20.417843, 18.432116, 19.09667, 20.027222, 19.324257,
            20.592884, 20.540459, 20.32846, 21.437262, 21.764565, 20.339413, 21.883532, 21.298628,
            21.01145, 23.644705, 23.63851, 21.394691, 20.445374, 20.748802, 20.53731, 21.090965,
            19.311222, 19.1536, 20.050312, 19.864845, 19.9944, 19.63015, 19.402035, 18.756098,
            18.07466, 20.497116, 20.946598, 19.707878, 19.689205, 19.374563, 19.7084, 19.835207,
            21.070362, 18.793709, 18.294827, 19.271982, 18.7931, 19.89778, 20.290407, 16.961155,
            15.955151, 17.224833, 18.136656, 18.064486, 21.541525, 19.645739, 18.681503, 18.468288,
            18.40802, 20.229301, 17.398643, 16.893852, 19.07305, 17.977009, 17.211117, 18.213045,
            16.599903, 18.804314, 18.022469, 15.687531, 16.696148, 19.994768, 17.215195, 17.982296,
            18.527016, 18.556719, 18.103813, 18.948189, 18.780155, 18.861765, 19.243036, 19.120264,
            19.5281, 19.743433, 20.764118, 21.564404, 20.83372, 19.170534, 19.535053, 19.266424,
            20.740562, 17.392946, 17.315348, 16.780436, 16.579699, 18.019958, 18.18324, 16.742842,
            15.671848, 17.20887, 17.370146, 17.600807, 18.610413, 18.153397, 17.004349, 17.09019,
            16.378122, 16.569153, 19.709843, 17.280457, 17.127306, 14.529609, 17.944008, 16.545633,
            18.445284, 15.153116, 15.956688, 14.361277, 15.66325, 15.214996, 18.960775, 18.436451,
            17.690685, 17.257172, 17.224373, 17.596334,
        ],
    )
    .unwrap();
    let current_output36: Array3<f32> = conv_layer36.convolve(&test_input36);

    assert!(
        arr_allclose(&current_output36, &target_output36),
        "{:?} was not equal to {:?}",
        current_output36,
        target_output36
    );
}
