// This file has been automatically generated by Jinja2 via the
// script generate_tests.py.
// Please do not change this file by hand.
#[allow(unused_imports)]
use convolutions_rs::convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::transposed_convolutions::*;
#[allow(unused_imports)]
use convolutions_rs::Padding;
#[allow(unused_imports)]
use ndarray::{array, Array, Array3, Array4, Dimension};

fn arr_allclose<D: Dimension>(current: &Array<f32, D>, target: &Array<f32, D>) -> bool {
    assert_eq!(
        current.shape(),
        target.shape(),
        "\ngiven array had shape {:?}, but target had shape {:?}",
        current.shape(),
        target.shape()
    );
    (current - target).map(|x| (*x as f32).abs()).sum() < 1e-3
}

#[test]
fn test_py_implementation_random_arrays_conv2d_torch_transpose_stride2() {
    let test_input1 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.17014849, 0.4305688, 0.5715329, 0.06520256, 0.12669589, 0.7501565, 0.9837982,
            0.55574155, 0.04181346, 0.23677547, 0.51154923, 0.02844254, 0.60484785, 0.72306335,
            0.22177844, 0.16487044, 0.46672952, 0.54035133, 0.6922357, 0.27845532, 0.66966337,
            0.41083884, 0.4583148, 0.70402896, 0.6177326, 0.9269775, 0.56033564, 0.9098013,
            0.2697065, 0.24242379, 0.7944849, 0.75231165, 0.9692583, 0.12854727, 0.9148518,
            0.3356524, 0.37189406, 0.55898565, 0.5888119, 0.44166553,
        ],
    )
    .unwrap();

    let kernel1: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.9034325, 0.2795916, 0.7567664, 0.85028297, 0.96145767, 0.5566679, 0.84558666,
            0.0474241, 0.23985276, 0.07658575, 0.7197864, 0.13313323, 0.69580543, 0.12692,
            0.38484824, 0.775336, 0.52113837, 0.4364637, 0.14352316, 0.8997107, 0.64410555,
            0.04471071, 0.767672, 0.43464628, 0.16569944, 0.18875164, 0.12285258, 0.2781115,
            0.5390728, 0.5066572, 0.97435564, 0.39133722,
        ],
    )
    .unwrap();
    let conv_layer1 = TransposedConvolutionLayer::new(kernel1, 2, Padding::Valid);
    let target_output1: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            0.502705, 0.33985585, 0.8279686, 1.0468774, 1.1399916, 1.095575, 0.92409825, 1.2238286,
            0.15038757, 0.68886304, 0.59492445, 0.12465733, 1.3365544, 0.5571886, 1.5241804,
            0.5376345, 1.3512745, 0.29408306, 0.59559774, 0.30909574, 0.5881587, 0.44447196,
            1.7214268, 1.597253, 2.45496, 2.2933457, 2.4011168, 2.2345557, 0.68456775, 1.4955748,
            0.9990853, 0.4590318, 3.1386993, 1.3903263, 3.86348, 1.8105443, 3.473777, 1.6277075,
            1.8794243, 0.74786395, 0.31107634, 0.25570893, 0.91120994, 0.87130654, 2.072812,
            1.4480093, 1.9799176, 1.9871776, 0.6412851, 1.0280609, 0.63507986, 0.36439386,
            2.2985206, 1.1666975, 3.568377, 1.7900283, 3.356094, 1.9325955, 1.7019255, 1.1152639,
            1.1062762, 0.64626634, 1.477261, 1.7890793, 1.6973181, 1.479852, 1.2202978, 1.6375108,
            0.28583828, 0.65518975, 1.3803257, 0.5219913, 2.607832, 1.1490655, 2.6241403,
            1.0004312, 2.6608715, 1.6072481, 1.1410483, 0.47016898, 0.92114687, 0.52208376,
            1.9352266, 1.556231, 2.162416, 1.7345943, 1.4572903, 1.7489198, 0.43402213, 0.74943554,
            1.631637, 0.84429, 3.3093083, 1.5147332, 2.9818506, 1.782845, 2.8619628, 1.1844623,
            0.9650073, 0.46435708, 0.173569, 0.10594045, 0.6038621, 0.3124579, 0.72121084,
            0.39155364, 0.71057093, 0.36060572, 0.2546881, 0.15990391, 0.5252309, 0.24766012,
            1.2192905, 0.8592037, 1.551678, 1.02389, 1.2719585, 1.0262538, 0.53750235, 0.3887366,
        ],
    )
    .unwrap();
    let current_output1: Array3<f32> = conv_layer1.transposed_convolve(&test_input1);

    assert!(
        arr_allclose(&current_output1, &target_output1),
        "{:?} was not equal to {:?}",
        current_output1,
        target_output1
    );

    let test_input2 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.7964828, 0.988919, 0.35985747, 0.00756764, 0.53660643, 0.8659267, 0.8576183,
            0.81628793, 0.9480399, 0.45711017, 0.89837223, 0.8462714, 0.70536447, 0.9289133,
            0.0067116, 0.65220493, 0.72789615, 0.00785976, 0.32536873, 0.09833383, 0.1022715,
            0.7567798, 0.23972042, 0.38848338, 0.00744711, 0.8715701, 0.07988323, 0.6283005,
            0.8241853, 0.16570753, 0.6487234, 0.14438818, 0.6286194, 0.34163022, 0.03235205,
            0.25922647, 0.59344524, 0.9308157, 0.22162326, 0.91818297,
        ],
    )
    .unwrap();

    let kernel2: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.97700953, 0.18019113, 0.775954, 0.14120784, 0.3426181, 0.5417864, 0.7768226,
            0.34603763, 0.6114103, 0.9716041, 0.5157695, 0.50755495, 0.6659802, 0.629322,
            0.60627973, 0.27978492, 0.28792506, 0.7547703, 0.0509604, 0.10449678, 0.89887625,
            0.6572328, 0.695583, 0.3626411, 0.37613922, 0.9241278, 0.39898983, 0.6908677,
            0.5511301, 0.36253917, 0.36786652, 0.88718724,
        ],
    )
    .unwrap();
    let conv_layer2 = TransposedConvolutionLayer::new(kernel2, 2, Padding::Valid);
    let target_output2: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            0.80761784, 0.22071062, 1.8073249, 0.872546, 1.2265272, 0.46450114, 0.41069686,
            0.37044403, 0.02566941, 0.04166387, 0.36481884, 0.49873972, 1.708937, 1.3458643,
            1.6333904, 0.9691607, 0.7980822, 0.47088075, 0.27610114, 0.14349873, 1.0518599,
            0.9706904, 2.8546236, 3.0255325, 2.699427, 2.0241175, 2.079968, 1.4653839, 0.82432437,
            0.45315325, 0.77735186, 0.8339421, 3.098342, 2.4406471, 2.8942919, 2.3943224,
            2.0917263, 1.639893, 1.2186441, 0.85708874, 1.4944355, 1.3211501, 2.4089532, 2.351716,
            2.776413, 2.6821122, 2.8081641, 2.320333, 1.3357277, 0.9829718, 1.4271297, 1.3957148,
            3.0004244, 2.0011718, 2.8220756, 2.7155557, 3.0081017, 2.151831, 1.4838662, 1.131008,
            1.7597928, 2.2843356, 2.7449088, 2.2383766, 1.8492393, 2.011353, 2.012621, 2.1773357,
            1.0133817, 0.6484671, 1.8923308, 1.690728, 2.8842661, 2.5440478, 2.284537, 1.5456864,
            1.9106722, 1.9495964, 1.2531538, 0.684567, 1.5497447, 1.845335, 2.181806, 2.879316,
            1.0669173, 1.0681946, 1.1368461, 1.6788406, 0.5629096, 0.6199537, 1.5990341, 1.4561964,
            3.2834344, 2.5466013, 1.6754099, 1.2411487, 1.8591284, 1.3847023, 1.2058398,
            0.77945757, 0.66826123, 1.2556461, 0.9671271, 1.6472688, 0.6577348, 1.1679976,
            0.66172767, 1.2623148, 0.41706327, 0.6842528, 0.81183, 0.6732282, 1.1778523, 1.0725548,
            0.6860135, 1.1131157, 0.8503189, 0.6824155, 0.39738658, 0.84211254,
        ],
    )
    .unwrap();
    let current_output2: Array3<f32> = conv_layer2.transposed_convolve(&test_input2);

    assert!(
        arr_allclose(&current_output2, &target_output2),
        "{:?} was not equal to {:?}",
        current_output2,
        target_output2
    );

    let test_input3 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.69587743, 0.4870034, 0.7135373, 0.9862549, 0.22876498, 0.75677496, 0.5617529,
            0.5566727, 0.7035832, 0.92333794, 0.85647196, 0.36252776, 0.9373231, 0.01684272,
            0.34317794, 0.921993, 0.36392415, 0.7462054, 0.7556754, 0.31284246, 0.4031665,
            0.7376267, 0.7926341, 0.36348057, 0.84374106, 0.03665259, 0.23846498, 0.82509995,
            0.97324103, 0.96826524, 0.77620417, 0.8427075, 0.42989048, 0.76771307, 0.54514444,
            0.7878393, 0.21897991, 0.975659, 0.73295325, 0.69994044,
        ],
    )
    .unwrap();

    let kernel3: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.86701024, 0.76087946, 0.623545, 0.14890751, 0.8610666, 0.21943341, 0.1644093,
            0.6089244, 0.8612485, 0.02602104, 0.30423534, 0.5087405, 0.16869895, 0.3329467,
            0.179494, 0.33126613, 0.11996287, 0.21606164, 0.87119263, 0.33579683, 0.2313126,
            0.2576527, 0.3748985, 0.30113342, 0.8142977, 0.423247, 0.8179498, 0.92175007,
            0.21606776, 0.19149332, 0.4240341, 0.14780204,
        ],
    )
    .unwrap();
    let conv_layer3 = TransposedConvolutionLayer::new(kernel3, 2, Padding::Valid);
    let target_output3: Array3<f32> = Array::from_shape_vec(
        (1, 12, 10),
        vec![
            0.6516979, 0.61658764, 1.2958713, 0.7689271, 1.6600143, 1.034385, 2.0341568, 1.2013704,
            0.93163586, 0.2689164, 0.6924543, 0.2565757, 0.8555199, 0.84205997, 1.1543524,
            0.8794705, 1.3477783, 0.98324794, 0.29841778, 0.71001077, 1.2271801, 0.5451091,
            3.099794, 1.9516344, 3.0309453, 1.8856595, 3.1504595, 2.0386796, 1.6632938, 1.1967447,
            0.5966549, 0.5764847, 1.5514368, 1.1623907, 1.3688571, 1.316269, 1.561042, 1.5001147,
            0.73200583, 0.96787274, 1.6108465, 1.1086856, 3.644649, 2.2726395, 3.193182, 1.8163457,
            3.142949, 1.7153966, 1.8044628, 1.3806995, 1.0518526, 0.64288515, 2.033993, 1.6330647,
            1.729502, 1.7305591, 1.4130353, 1.616623, 0.8253226, 0.7808777, 2.2627075, 1.236302,
            3.6594772, 2.1514869, 3.484865, 2.3522558, 3.476708, 2.6232018, 2.0608501, 1.3630439,
            1.2355164, 0.7370673, 1.4113077, 1.7714713, 1.6006912, 1.3399823, 1.9630387, 1.4589555,
            0.8693522, 1.0433158, 1.4991224, 0.53055555, 2.4581556, 2.104775, 3.430931, 2.1279485,
            3.4508543, 1.7824321, 1.7297702, 1.4768685, 0.6150266, 0.5306777, 1.5293939, 1.2293298,
            1.8129259, 1.4405545, 1.4488305, 1.5819527, 0.8134037, 0.8231422, 0.49174395,
            0.10215227, 1.7269783, 0.8193495, 2.2727284, 1.6088223, 1.668817, 1.3644305,
            0.66769385, 0.80432576, 0.10870812, 0.16310053, 0.49486965, 0.5882002, 0.8335013,
            0.78335226, 0.65044713, 0.5968554, 0.35295194, 0.20708674,
        ],
    )
    .unwrap();
    let current_output3: Array3<f32> = conv_layer3.transposed_convolve(&test_input3);

    assert!(
        arr_allclose(&current_output3, &target_output3),
        "{:?} was not equal to {:?}",
        current_output3,
        target_output3
    );

    let test_input4 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.46443272, 0.00207204, 0.359202, 0.9019851, 0.21363449, 0.6390296, 0.5977058,
            0.81350476, 0.3685356, 0.90738845, 0.7828945, 0.9812083, 0.6726924, 0.46724817,
            0.17302093, 0.39839587, 0.78055173, 0.8576361, 0.7335981, 0.52934057, 0.9529279,
            0.78965247, 0.46750203, 0.08403921, 0.73126566, 0.34934825, 0.3459232, 0.54770446,
            0.68714255, 0.29283327, 0.53392637, 0.8850151, 0.6909357, 0.44388366, 0.9043074,
            0.9949724, 0.64743847, 0.36691284, 0.5396585, 0.5372604,
        ],
    )
    .unwrap();

    let kernel4: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.47547424, 0.44373918, 0.34716287, 0.21774843, 0.9437953, 0.51856595, 0.15765554,
            0.9350713, 0.86233217, 0.81734437, 0.6566154, 0.3879487, 0.28848994, 0.5814131,
            0.06870039, 0.78543746, 0.47194287, 0.12733267,
        ],
    )
    .unwrap();
    let conv_layer4 = TransposedConvolutionLayer::new(kernel4, 2, Padding::Valid);
    let target_output4: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.999696, 0.8317941, 1.177324, 0.5194174, 0.85996544, 0.46636102, 0.8036281, 0.4554276,
            0.34573865, 0.3760396, 0.9923742, 0.5345635, 0.46106985, 0.26840922, 0.61082494,
            0.4390378, 0.90015084, 0.4735123, 1.5209591, 1.4589635, 2.089623, 0.8875582, 1.4504678,
            1.0488777, 1.7536557, 1.6036972, 1.2834115, 0.25748137, 0.6267947, 0.40095297,
            0.8062288, 0.58532417, 0.7652362, 0.6688615, 1.0862246, 0.45948339, 1.3449054,
            1.1596012, 1.717779, 1.3573332, 2.1987357, 1.4201387, 2.7867389, 2.0356853, 1.4552315,
            0.27848175, 0.74733585, 0.5203788, 1.0266461, 0.8151649, 1.0493239, 0.9116379,
            1.4406192, 0.5696221, 1.4823895, 1.421078, 1.8649044, 1.4854707, 2.518364, 1.6546032,
            3.0064716, 2.1652741, 1.4831253, 0.3458057, 1.036603, 0.6261015, 0.6990664, 0.5713526,
            0.6890725, 0.52563864, 0.9544941, 0.27494952, 1.549053, 1.726577, 2.3201997, 1.2678854,
            2.4269753, 1.2684426, 2.2634997, 1.4297612, 0.8624389, 0.3567434, 1.1131103,
            0.74184644, 1.0227609, 0.7853738, 1.0061309, 0.68775105, 0.8119594, 0.31140798,
            0.63158077, 1.0354254, 1.1789331, 0.9751128, 1.3258109, 0.9406545, 1.2067593,
            0.7485274, 0.5248782,
        ],
    )
    .unwrap();
    let current_output4: Array3<f32> = conv_layer4.transposed_convolve(&test_input4);

    assert!(
        arr_allclose(&current_output4, &target_output4),
        "{:?} was not equal to {:?}",
        current_output4,
        target_output4
    );

    let test_input5 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.6111727, 0.25675833, 0.74741316, 0.45714313, 0.9649919, 0.57969916, 0.5208711,
            0.93666834, 0.13247305, 0.7087714, 0.17877895, 0.40767, 0.6906785, 0.9675369, 0.224454,
            0.28950995, 0.75431514, 0.99582964, 0.8120864, 0.9536324, 0.7703749, 0.683158,
            0.16371861, 0.42877796, 0.7300311, 0.9456737, 0.05700503, 0.19623296, 0.44457257,
            0.5512328, 0.15101007, 0.25140873, 0.2031063, 0.5537751, 0.3641559, 0.701937,
            0.27669305, 0.85076064, 0.00186597, 0.3316532,
        ],
    )
    .unwrap();

    let kernel5: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.15485734, 0.35000807, 0.42372492, 0.03995521, 0.5067197, 0.38907993, 0.37287286,
            0.21294773, 0.8646356, 0.10154326, 0.75313085, 0.7910046, 0.15368015, 0.25977603,
            0.40315583, 0.635939, 0.25689796, 0.13678746,
        ],
    )
    .unwrap();
    let conv_layer5 = TransposedConvolutionLayer::new(kernel5, 2, Padding::Valid);
    let target_output5: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.17287096, 0.79410845, 0.97747016, 0.6043748, 0.78154296, 0.38490218, 0.56053126,
            0.4829297, 0.53286827, 0.14281087, 0.5098182, 0.6636228, 0.30757257, 0.430342,
            0.42125916, 0.4409675, 0.34302968, 0.35072955, 0.941367, 1.2156194, 2.336151,
            1.1452934, 1.7783693, 0.42646024, 1.5425409, 0.6831304, 1.0060246, 0.15074775,
            0.678625, 0.8382685, 0.5394083, 0.63637525, 0.2787442, 0.29322428, 0.5256049,
            0.44355133, 0.8897323, 0.7742243, 2.325294, 1.0296134, 1.6404263, 0.30186722, 1.216074,
            0.5819047, 1.2083244, 0.07361496, 0.182616, 0.34380728, 0.5023455, 0.52835184,
            0.1298196, 0.18536496, 0.27188438, 0.2599731, 0.45969737, 0.53712827, 1.4495628,
            1.0482527, 1.7706697, 0.4296825, 0.98639, 0.78138, 1.0647836, 0.05880961, 0.40274253,
            0.47437498, 0.6341275, 0.66463846, 0.20833424, 0.35358334, 0.32904682, 0.3956325,
            0.531606, 0.67165846, 2.116991, 1.3375809, 2.4484506, 0.42698997, 1.3251538, 0.825534,
            1.0127537, 0.07266105, 0.45410457, 0.5755729, 0.7256137, 0.7631803, 0.41198492,
            0.40578988, 0.56937987, 0.50474715, 0.45722353, 0.23171157, 1.6024055, 0.43061835,
            1.2813947, 0.17341132, 1.2689089, 0.28827488, 0.86991054,
        ],
    )
    .unwrap();
    let current_output5: Array3<f32> = conv_layer5.transposed_convolve(&test_input5);

    assert!(
        arr_allclose(&current_output5, &target_output5),
        "{:?} was not equal to {:?}",
        current_output5,
        target_output5
    );

    let test_input6 = Array::from_shape_vec(
        (2, 5, 4),
        vec![
            0.43744904, 0.6658951, 0.564682, 0.70429957, 0.67241764, 0.15790685, 0.25059524,
            0.6432024, 0.60438925, 0.45131883, 0.96080875, 0.40131757, 0.60942906, 0.7035094,
            0.6473561, 0.05433872, 0.7478619, 0.24740443, 0.35665986, 0.00020906, 0.23741227,
            0.57013196, 0.6398819, 0.7132858, 0.90739846, 0.8246988, 0.1319153, 0.6876462,
            0.846729, 0.18134636, 0.9026019, 0.54676574, 0.33139232, 0.83673465, 0.05539654,
            0.5554673, 0.9149804, 0.9791666, 0.9000323, 0.6329186,
        ],
    )
    .unwrap();

    let kernel6: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.30872977, 0.30553624, 0.04431259, 0.5287215, 0.3358437, 0.72178566, 0.72704846,
            0.85191244, 0.07464863, 0.867838, 0.5849202, 0.14913943, 0.18325551, 0.40498126,
            0.75359416, 0.01821492, 0.5917236, 0.91982275,
        ],
    )
    .unwrap();
    let conv_layer6 = TransposedConvolutionLayer::new(kernel6, 2, Padding::Valid);
    let target_output6: Array3<f32> = Array::from_shape_vec(
        (1, 11, 9),
        vec![
            0.34108895, 0.27252376, 0.75515586, 0.5369368, 0.8441847, 0.5468107, 0.95690894,
            0.6324043, 0.13758838, 0.27479583, 0.24306203, 0.9512098, 0.45452943, 1.3261031,
            0.4487851, 1.3928826, 0.52540195, 1.0458814, 1.3174413, 1.2493544, 1.6751361,
            1.4352741, 1.3181748, 1.0134187, 1.9819026, 1.6208096, 0.83972865, 0.52180743,
            0.5933066, 1.4037709, 0.38701957, 0.8921324, 0.13758406, 0.7463765, 0.49449933,
            0.98246044, 1.426825, 1.7897017, 1.4644461, 0.866484, 2.0819495, 1.1130545, 1.3958023,
            1.39728, 0.77985454, 0.47472134, 0.5458897, 1.3461843, 0.22501446, 1.135824, 0.6882184,
            1.6860765, 0.35620984, 0.70170474, 0.9305872, 1.3959571, 2.1751647, 1.1961616,
            1.3193899, 1.5828091, 1.7394729, 1.0069281, 0.6181354, 0.38294774, 0.3388806,
            1.2149093, 0.57513106, 1.4907641, 0.23984504, 0.63952136, 0.24320316, 0.45781782,
            1.4740628, 1.4789623, 1.9727801, 1.7427695, 2.3420212, 1.2196897, 0.84827405,
            0.7452457, 0.6093902, 0.5630859, 0.62171465, 1.5395656, 0.47963333, 1.2699769,
            0.48427817, 1.0517874, 0.2563904, 0.47711465, 0.56039816, 1.1785283, 1.0951571,
            0.7901629, 1.1948311, 0.8364133, 0.8661749, 0.37469098, 0.58218855,
        ],
    )
    .unwrap();
    let current_output6: Array3<f32> = conv_layer6.transposed_convolve(&test_input6);

    assert!(
        arr_allclose(&current_output6, &target_output6),
        "{:?} was not equal to {:?}",
        current_output6,
        target_output6
    );

    let test_input7 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.5287654, 0.7151285, 0.38420153, 0.517026, 0.5150141, 0.26934662, 0.7356045,
            0.97902703, 0.6362754, 0.27803296, 0.32063982, 0.83432084, 0.78711736, 0.28247103,
            0.7812688, 0.5270146, 0.4719829, 0.47535485, 0.23715672, 0.4404677, 0.90286416,
            0.66611385, 0.02649495, 0.3193976,
        ],
    )
    .unwrap();

    let kernel7: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.16608049, 0.5121102, 0.17436478, 0.313714, 0.47244504, 0.9906781, 0.9064671,
            0.29454133, 0.99321055, 0.12515199, 0.17643407, 0.16320723, 0.48754972, 0.53866875,
            0.6358971, 0.8935865, 0.82249755, 0.92702305, 0.10556214, 0.28283548, 0.14977625,
            0.53714937, 0.06378802, 0.4497216, 0.79292244, 0.5300166, 0.687625, 0.4744624,
            0.73655206, 0.42605233, 0.6592577, 0.3237799,
        ],
    )
    .unwrap();
    let conv_layer7 = TransposedConvolutionLayer::new(kernel7, 2, Padding::Valid);
    let target_output7: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.7352197, 1.000462, 0.52638847, 1.0165875, 0.8609115, 1.2252463, 0.14946361,
            0.34149992, 0.36770406, 0.94663584, 0.90968347, 1.3699181, 0.9647883, 1.1379462,
            0.39810163, 0.46451667, 1.6686344, 1.2366903, 2.188307, 1.7115097, 1.896821, 1.5865657,
            0.7021502, 0.6523322, 1.160753, 1.4154744, 2.2281609, 2.3859491, 2.0991304, 2.1564326,
            1.0338459, 0.8893875, 1.2486278, 0.9405936, 2.017552, 1.8565841, 2.1253319, 2.188181,
            0.5806401, 0.7244679, 1.0233027, 1.3591774, 2.485386, 2.6409736, 2.4714828, 2.5624115,
            1.1190127, 0.98804176, 1.5127099, 0.97764575, 1.8083369, 1.0529481, 2.2834404,
            1.7583698, 0.9122851, 0.8842949, 0.76444536, 1.1305321, 1.8758388, 2.162487, 2.6225128,
            2.8493335, 1.776484, 1.2502784, 0.8043219, 0.38784778, 0.8465623, 0.41559443,
            1.1567042, 0.33860454, 0.36682838, 0.28770936, 0.62618244, 0.43356702, 0.7917838,
            0.6481277, 0.86338675, 0.88060063, 0.7411075, 0.8489524,
        ],
    )
    .unwrap();
    let current_output7: Array3<f32> = conv_layer7.transposed_convolve(&test_input7);

    assert!(
        arr_allclose(&current_output7, &target_output7),
        "{:?} was not equal to {:?}",
        current_output7,
        target_output7
    );

    let test_input8 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.42867732, 0.87574345, 0.70010746, 0.01496939, 0.78416556, 0.61210716, 0.98323476,
            0.9316805, 0.05175687, 0.70876056, 0.52122, 0.68573385, 0.415587, 0.87644994,
            0.73337436, 0.5451011, 0.20423086, 0.5554448, 0.48578474, 0.2764571, 0.9192946,
            0.8920509, 0.34320405, 0.4283556,
        ],
    )
    .unwrap();

    let kernel8: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.3897719, 0.06360459, 0.729173, 0.19460331, 0.8634254, 0.6576018, 0.9657459,
            0.22873744, 0.47843248, 0.22157177, 0.9162307, 0.02157675, 0.44649428, 0.2792192,
            0.685827, 0.75294507, 0.7919586, 0.22560763, 0.88778716, 0.80092114, 0.00003577,
            0.9737877, 0.9146247, 0.13869576, 0.7059647, 0.0936791, 0.2647747, 0.52025, 0.0330946,
            0.17754778, 0.41998118, 0.02919354,
        ],
    )
    .unwrap();
    let conv_layer8 = TransposedConvolutionLayer::new(kernel8, 2, Padding::Valid);
    let target_output8: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            0.49621406, 0.12102545, 1.716985, 0.66970956, 2.2703538, 1.0823748, 1.1615798,
            0.72361827, 0.37014574, 0.6865925, 1.55027, 1.5850613, 2.2518852, 1.4964181, 1.3468882,
            0.2618567, 0.936015, 0.2578457, 2.5027683, 1.0370524, 3.3187127, 1.1791141, 1.7750877,
            0.9606296, 0.21810012, 0.7341382, 2.0786529, 1.5286126, 2.7781935, 2.161768, 1.8873196,
            0.76560193, 1.1599426, 0.22651637, 2.4077015, 1.178839, 3.130536, 0.9242504, 1.5617768,
            1.048532, 0.8736909, 1.2205894, 2.7943954, 1.4565636, 2.1126018, 2.0466127, 1.5438695,
            0.61643946, 1.7960806, 0.50969887, 3.4541292, 1.4692479, 2.8918562, 0.77808267,
            1.1711344, 0.9559049, 1.0670793, 1.6955385, 3.25391, 2.026538, 2.2179756, 1.9221358,
            1.475612, 0.28207165, 0.9688505, 0.24060787, 1.3772392, 0.62702096, 1.1989108,
            0.38186538, 0.74170816, 0.23764792, 0.3459796, 0.35628122, 1.1048117, 0.76616967,
            0.82195854, 0.66999304, 0.6501961, 0.52882516,
        ],
    )
    .unwrap();
    let current_output8: Array3<f32> = conv_layer8.transposed_convolve(&test_input8);

    assert!(
        arr_allclose(&current_output8, &target_output8),
        "{:?} was not equal to {:?}",
        current_output8,
        target_output8
    );

    let test_input9 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.82382417, 0.4156855, 0.49590722, 0.69720376, 0.7155315, 0.40795937, 0.15397236,
            0.02265206, 0.7090415, 0.75877124, 0.67035425, 0.39483562, 0.86222315, 0.9993058,
            0.84902793, 0.26427644, 0.86764544, 0.24274233, 0.69865257, 0.5739991, 0.7620597,
            0.29289714, 0.88402116, 0.8942853,
        ],
    )
    .unwrap();

    let kernel9: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.7757528, 0.16431308, 0.48939565, 0.56055367, 0.46453193, 0.9573795, 0.8899508,
            0.16098963, 0.63514715, 0.810474, 0.29953358, 0.46075395, 0.02808736, 0.59781086,
            0.8855644, 0.61877847, 0.9537467, 0.6197168, 0.3379795, 0.13108306, 0.30692965,
            0.33537498, 0.01351478, 0.45529485, 0.6626128, 0.9497022, 0.7403127, 0.06039312,
            0.08292098, 0.80679554, 0.1354166, 0.2560622,
        ],
    )
    .unwrap();
    let conv_layer9 = TransposedConvolutionLayer::new(kernel9, 2, Padding::Valid);
    let target_output9: Array3<f32> = Array::from_shape_vec(
        (1, 10, 8),
        vec![
            1.4614264, 0.66969925, 1.9701433, 1.2624097, 1.7356385, 0.971647, 0.5296489, 0.3892758,
            0.64733446, 1.0778805, 1.2446315, 1.2583039, 0.8744016, 1.281414, 0.45280746,
            0.46639398, 1.8874803, 1.7648796, 3.62437, 2.7983255, 2.933276, 2.1924155, 1.0587825,
            0.5402692, 0.4996231, 1.9442492, 2.1635897, 2.9938722, 1.5002987, 2.4767618,
            0.92047465, 0.7004573, 1.403722, 1.2743158, 2.3103697, 2.2784545, 2.7585516, 1.6199623,
            0.9064651, 0.6999778, 0.32745892, 1.0117337, 1.0784196, 2.1839232, 1.3739176, 2.304036,
            1.0354568, 0.7757038, 1.4286997, 1.0944918, 2.7915616, 1.7983409, 3.173086, 2.4542222,
            1.2720251, 0.711269, 0.5046299, 1.4803785, 1.5411551, 1.9445857, 1.2473207, 2.388034,
            1.0945678, 1.1046022, 0.67600876, 0.8931294, 1.4556502, 1.7501574, 1.6985893,
            1.5315659, 0.7803173, 0.23593076, 0.0455992, 0.6899098, 0.8037363, 1.6584806,
            0.79859793, 1.5987077, 0.47075343, 0.47330844,
        ],
    )
    .unwrap();
    let current_output9: Array3<f32> = conv_layer9.transposed_convolve(&test_input9);

    assert!(
        arr_allclose(&current_output9, &target_output9),
        "{:?} was not equal to {:?}",
        current_output9,
        target_output9
    );

    let test_input10 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.80891573, 0.97702754, 0.4124968, 0.4359102, 0.8733311, 0.1396195, 0.52047473,
            0.88564533, 0.29781443, 0.21130918, 0.83071965, 0.3337948, 0.9783562, 0.42070097,
            0.55396014, 0.16172563, 0.7634967, 0.36205766, 0.48491392, 0.4980414, 0.6001484,
            0.65126085, 0.3691911, 0.11615072,
        ],
    )
    .unwrap();

    let kernel10: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.26983073, 0.8690525, 0.7446416, 0.471613, 0.72900707, 0.842964, 0.21457537, 0.938401,
            0.41665936, 0.05351101, 0.43856344, 0.7253113, 0.8520324, 0.4151233, 0.35101932,
            0.7388761, 0.3592986, 0.6741479,
        ],
    )
    .unwrap();
    let conv_layer10 = TransposedConvolutionLayer::new(kernel10, 2, Padding::Valid);
    let target_output10: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.27062315, 1.1320616, 1.5981092, 1.0335923, 1.1736219, 0.60142803, 0.7089558,
            1.2150863, 0.99584377, 1.8445385, 0.88690275, 1.637804, 0.5306749, 0.5421707,
            1.0227334, 1.5603651, 2.2354965, 2.1618133, 2.449661, 0.8662464, 0.91189265,
            0.34337637, 0.38491768, 1.4866235, 0.9536098, 1.37852, 0.25208217, 0.24478345,
            0.3794191, 1.1321517, 2.0470836, 2.081953, 2.3092635, 0.7831254, 0.9593135, 0.658625,
            0.5807288, 1.450985, 0.8523903, 1.5731883, 0.4662444, 0.4617105, 0.5618397, 1.1319009,
            1.9754188, 1.8938887, 2.1947553, 0.8361265, 0.8614788, 0.6545515, 0.42439944,
            1.1130722, 0.7588603, 1.0862461, 0.29155564, 0.32214814, 0.52654284, 0.43228984,
            0.97812855, 0.91219795, 0.7524617, 0.35496616, 0.21738148,
        ],
    )
    .unwrap();
    let current_output10: Array3<f32> = conv_layer10.transposed_convolve(&test_input10);

    assert!(
        arr_allclose(&current_output10, &target_output10),
        "{:?} was not equal to {:?}",
        current_output10,
        target_output10
    );

    let test_input11 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.9965808, 0.3117034, 0.8605703, 0.94308543, 0.8192489, 0.31478795, 0.750324,
            0.36604244, 0.78454614, 0.039194, 0.23696694, 0.2418382, 0.24788351, 0.5622223,
            0.15428482, 0.50688076, 0.37682602, 0.44385925, 0.00051633, 0.53422695, 0.5675659,
            0.53845215, 0.2130759, 0.86445093,
        ],
    )
    .unwrap();

    let kernel11: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.432881, 0.6255918, 0.3942565, 0.07226853, 0.09869356, 0.32627374, 0.8543963,
            0.85603166, 0.25422713, 0.24929269, 0.36793318, 0.39957172, 0.9079535, 0.865758,
            0.82237726, 0.60374194, 0.7658025, 0.0215734,
        ],
    )
    .unwrap();
    let conv_layer11 = TransposedConvolutionLayer::new(kernel11, 2, Padding::Valid);
    let target_output11: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.49319643, 0.71465737, 0.76704407, 0.40185934, 0.75852585, 0.59513223, 0.4009333,
            0.29708815, 0.31296325, 1.06201, 0.51751155, 0.76633507, 0.21850607, 0.40766183,
            1.535738, 1.8194193, 1.8873911, 1.3485415, 1.6402686, 1.2150664, 0.5235696, 0.52837956,
            0.5319125, 1.1258976, 0.40709472, 1.0029454, 0.41534224, 0.4677268, 1.4367236,
            1.665068, 1.76582, 1.4154303, 1.5922165, 1.309009, 0.62569886, 0.05469362, 0.07449916,
            0.7567422, 0.4986373, 1.1307876, 0.5688044, 0.7227301, 0.7925843, 0.86533034,
            1.2123438, 0.94909847, 1.616313, 1.575592, 0.65245366, 0.49172202, 0.47003746,
            0.66618705, 0.20785928, 1.0549035, 0.7722732, 0.78981024, 0.35857335, 0.4458993,
            0.35268697, 0.36602527, 0.79337114, 0.86901987, 0.08013098,
        ],
    )
    .unwrap();
    let current_output11: Array3<f32> = conv_layer11.transposed_convolve(&test_input11);

    assert!(
        arr_allclose(&current_output11, &target_output11),
        "{:?} was not equal to {:?}",
        current_output11,
        target_output11
    );

    let test_input12 = Array::from_shape_vec(
        (2, 4, 3),
        vec![
            0.473204, 0.6594781, 0.86392707, 0.8566667, 0.48541847, 0.54855824, 0.5860555,
            0.158874, 0.10558709, 0.19664533, 0.39609066, 0.27843866, 0.49128443, 0.75033015,
            0.35650545, 0.4687038, 0.6159849, 0.2547001, 0.17250927, 0.07203952, 0.8724657,
            0.14018923, 0.12091745, 0.4770398,
        ],
    )
    .unwrap();

    let kernel12: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.43290496, 0.6356798, 0.7619444, 0.2383507, 0.95481586, 0.49641547, 0.7066018,
            0.10666513, 0.06810815, 0.79673207, 0.29373887, 0.55241185, 0.23906927, 0.18915932,
            0.02753429, 0.1438574, 0.5419741, 0.71984386,
        ],
    )
    .unwrap();
    let conv_layer12 = TransposedConvolutionLayer::new(kernel12, 2, Padding::Valid);
    let target_output12: Array3<f32> = Array::from_shape_vec(
        (1, 9, 7),
        vec![
            0.59627444, 0.44511554, 1.51525, 0.63961804, 1.5750146, 0.6539005, 0.85520226,
            0.23023951, 0.5447537, 0.58500093, 0.7716121, 0.6391821, 0.8923276, 0.43868285,
            1.1493282, 0.99898005, 2.572371, 0.96651226, 2.3973155, 0.7088903, 0.87413895,
            0.31623977, 0.90661865, 0.7011309, 0.5800045, 0.44957018, 0.57195103, 0.27932578,
            1.0638988, 0.7686181, 1.4953625, 0.5077789, 1.802406, 0.51994956, 0.78311753,
            0.18092841, 0.59220684, 0.3507671, 0.16532236, 0.31459758, 0.26585126, 0.07643779,
            0.6357466, 0.32218975, 0.7818024, 0.34329486, 1.1320022, 0.80123925, 1.1109077,
            0.08038549, 0.21427819, 0.22479394, 0.4010663, 0.3803665, 0.35609415, 0.1513562,
            0.1591172, 0.09695414, 0.41158074, 0.1077832, 0.37938964, 0.2882429, 0.36235812,
        ],
    )
    .unwrap();
    let current_output12: Array3<f32> = conv_layer12.transposed_convolve(&test_input12);

    assert!(
        arr_allclose(&current_output12, &target_output12),
        "{:?} was not equal to {:?}",
        current_output12,
        target_output12
    );

    let test_input13 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.12837073, 0.55637455, 0.14355855, 0.10225686, 0.8755492, 0.62895286, 0.21388301,
            0.30016333, 0.49605927, 0.8245107, 0.4528765, 0.6836941, 0.28745723, 0.5031258,
            0.26911622, 0.92149794, 0.7165893, 0.04745785, 0.55642486, 0.34654748, 0.83168656,
            0.8410765, 0.7668131, 0.84094906, 0.6012723, 0.9256995, 0.66010624, 0.43380973,
            0.62281454, 0.45852852, 0.61445725, 0.524579, 0.06486581, 0.14233574, 0.13930365,
            0.5838787, 0.45914945, 0.30819193, 0.70949817, 0.8803759, 0.6927248, 0.50569826,
            0.7358748, 0.58652496, 0.85065925, 0.3247378, 0.6760192, 0.4483504, 0.59195757,
            0.37883574, 0.7796499, 0.32748002, 0.44507304, 0.7488422, 0.14428215, 0.8785777,
            0.15468395, 0.6638725, 0.30651525, 0.9492515, 0.55669755, 0.08302987, 0.45890567,
            0.05946975, 0.9099885, 0.30235246, 0.24214035, 0.42138377, 0.38782486, 0.21880285,
            0.9182205, 0.85290706,
        ],
    )
    .unwrap();

    let kernel13: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.5070326, 0.5272234, 0.71761, 0.560904, 0.22129431, 0.2624427, 0.6557088, 0.00633,
            0.6603214, 0.45500925, 0.6523986, 0.14666249, 0.32440838, 0.2805719, 0.42671442,
            0.74477625, 0.9118973, 0.5335283, 0.36968935, 0.5693756, 0.36426732, 0.11819325,
            0.95361024, 0.13343851, 0.5940242, 0.7282295, 0.9320007, 0.46956548, 0.5087874,
            0.7952918, 0.73709416, 0.3358689,
        ],
    )
    .unwrap();
    let conv_layer13 = TransposedConvolutionLayer::new(kernel13, 2, Padding::Valid);
    let target_output13: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            0.4837853, 0.31264928, 0.8250022, 0.7911949, 1.2329736, 0.9417745, 1.219973, 1.0081112,
            1.474472, 1.3898191, 1.6644404, 1.4869227, 0.6382941, 0.6407144, 0.19566086,
            0.08795833, 0.7574102, 0.24452347, 0.9489304, 0.16618031, 1.1140383, 0.22647417,
            1.3526773, 0.42978024, 1.5580878, 0.32281262, 0.89464897, 0.0714609, 1.1369996,
            0.8981502, 2.1747088, 1.7221558, 2.6259313, 2.0260143, 2.7300353, 2.4123983, 3.4346747,
            2.5780487, 3.2629457, 2.3467298, 1.5380152, 0.9684688, 0.5906402, 0.54428244,
            1.8525698, 0.89867395, 2.0479133, 1.4333175, 2.5025413, 1.4454829, 2.5258226, 1.415729,
            2.6017742, 1.7888932, 1.5169863, 0.70243245, 1.2639136, 1.1005847, 2.39767, 1.9062732,
            2.9238496, 2.220376, 3.100994, 2.3392544, 3.0927184, 2.2903633, 3.0289953, 2.1013455,
            1.1747992, 0.76379395, 0.7230327, 0.79065114, 2.0317895, 1.2147554, 2.1888592,
            1.4527656, 2.5145488, 1.5310442, 2.3192852, 1.6780419, 2.3190308, 1.2776291, 1.3674407,
            0.7600109, 0.95514727, 0.93221545, 2.726023, 1.870634, 2.4583826, 2.1575255, 3.3910694,
            2.4155362, 3.1612601, 2.356665, 3.3140745, 2.4354618, 1.6832845, 1.3707631, 0.570125,
            0.71451426, 1.8141234, 1.0729251, 2.283357, 1.5534933, 2.2758756, 1.3063852, 2.5594368,
            1.6827006, 2.3572173, 1.6706991, 2.028852, 0.41884816, 1.2656419, 0.97226775,
            2.4305696, 2.1334202, 3.134145, 2.1138122, 2.5540314, 1.9527498, 3.334762, 2.0982597,
            3.1966693, 2.6008294, 1.8741581, 0.99841404, 0.5897627, 0.494461, 2.0634453, 1.5896767,
            2.1433883, 1.1539726, 2.0676486, 1.621622, 2.063416, 1.5899924, 2.7966852, 1.9463751,
            1.6475204, 0.98839086, 1.2600818, 1.132133, 2.7523875, 1.8151675, 2.308562, 1.5845748,
            1.6417508, 1.0019759, 2.3812408, 1.805374, 3.2500453, 2.3112924, 1.315244, 1.0223477,
            0.7024782, 0.80131626, 1.9128546, 1.184226, 1.8052728, 1.3899086, 1.3144902, 0.9301516,
            1.5612729, 1.4167004, 2.645957, 1.5160533, 1.6147183, 0.56055856, 0.5495765,
            0.45591748, 1.223249, 0.74937093, 1.0081742, 0.5867434, 0.627733, 0.41572532,
            0.9342144, 0.85567737, 1.8388586, 1.3383776, 1.1758316, 0.4861288, 0.32253304,
            0.36497167, 0.82525057, 1.0212657, 0.75280833, 0.8588571, 0.47104165, 0.39251634,
            0.7343853, 0.94883525, 1.3596213, 1.2542818, 0.8778223, 0.72132397,
        ],
    )
    .unwrap();
    let current_output13: Array3<f32> = conv_layer13.transposed_convolve(&test_input13);

    assert!(
        arr_allclose(&current_output13, &target_output13),
        "{:?} was not equal to {:?}",
        current_output13,
        target_output13
    );

    let test_input14 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.03185032, 0.27057356, 0.26166973, 0.5843129, 0.5337139, 0.19571388, 0.1192536,
            0.75616854, 0.97167397, 0.71154076, 0.26672947, 0.07128377, 0.3383284, 0.8008563,
            0.9504947, 0.5971434, 0.7847773, 0.92326206, 0.24163638, 0.12968542, 0.5954836,
            0.6734995, 0.08627631, 0.7485715, 0.8782484, 0.6863155, 0.7264353, 0.08944888,
            0.68172634, 0.4284322, 0.48237634, 0.6856524, 0.04009921, 0.0687674, 0.9063645,
            0.42620143, 0.61030614, 0.10040135, 0.50107217, 0.763057, 0.25769317, 0.8816114,
            0.7770131, 0.23345616, 0.62762326, 0.15315741, 0.73589575, 0.2752067, 0.85641515,
            0.7439484, 0.6581306, 0.4056261, 0.13899311, 0.26460668, 0.9179794, 0.96651816,
            0.89336777, 0.18948041, 0.9371178, 0.7124811, 0.9657549, 0.6203675, 0.32684848,
            0.11439406, 0.07654371, 0.95680344, 0.9728639, 0.6055871, 0.00439729, 0.8525613,
            0.3167563, 0.13499211,
        ],
    )
    .unwrap();

    let kernel14: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.68338645, 0.7955047, 0.21689218, 0.2826704, 0.12328367, 0.6890043, 0.5906649,
            0.41700745, 0.30266365, 0.5716598, 0.12726787, 0.35587692, 0.16889893, 0.3114892,
            0.1309899, 0.24026695, 0.55435276, 0.34375766, 0.4225387, 0.37165096, 0.6202945,
            0.6069533, 0.05756181, 0.0153275, 0.8497578, 0.79796964, 0.4071996, 0.19325097,
            0.04944435, 0.59729165, 0.39304134, 0.679002,
        ],
    )
    .unwrap();
    let conv_layer14 = TransposedConvolutionLayer::new(kernel14, 2, Padding::Valid);
    let target_output14: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            0.36009097, 0.23513448, 0.5053501, 0.48558027, 0.55770105, 0.49420428, 1.0907907,
            0.9873206, 0.9567398, 0.9619147, 0.84711564, 0.705389, 0.41496375, 0.38297424,
            0.38249618, 0.39237234, 0.1495789, 0.27000156, 0.5086695, 0.5987891, 0.7287581,
            0.9825325, 0.61469996, 0.77949744, 0.9010664, 0.8964571, 0.16634847, 0.09512704,
            1.040488, 0.86718434, 1.4201353, 1.3683453, 1.8549114, 1.9543521, 2.1097066, 2.2594829,
            1.574861, 1.589346, 1.5513207, 1.5553207, 0.5156463, 0.36245298, 0.53223467,
            0.92822874, 0.6479115, 1.290641, 1.1130584, 1.8833078, 1.1604218, 2.0389035, 1.3977909,
            1.9081699, 0.6272464, 1.2294099, 0.4300925, 0.67958355, 1.4023318, 1.2517464, 2.153776,
            2.117906, 2.5211554, 2.8557377, 1.8419151, 2.1237984, 1.7732502, 2.01414, 1.5956088,
            1.5964022, 0.4331911, 0.4378724, 0.6315007, 1.2541634, 1.2696135, 2.0887733, 1.4272316,
            2.417455, 1.4262453, 2.0368168, 0.7938652, 1.6778893, 1.0993218, 1.8764675, 0.67807484,
            0.59305596, 1.5041606, 1.3845873, 2.3310642, 2.1822567, 2.5904958, 2.6739805,
            1.9863131, 2.2317376, 1.4013954, 1.5020087, 1.9819748, 2.258166, 0.6886595, 0.8560965,
            0.6986956, 1.3405745, 1.3640527, 2.1474288, 1.3501847, 2.4081438, 1.1078109, 1.9445893,
            1.377713, 1.6583539, 0.96558654, 1.7271194, 0.70810604, 0.72457826, 1.9887466,
            1.9012899, 2.676586, 2.475183, 2.4380593, 2.4010277, 1.2246283, 1.3580714, 1.5613586,
            1.7098407, 2.227971, 2.099149, 0.8826012, 0.88078904, 0.7935272, 1.8148535, 1.5059117,
            2.529503, 1.2750094, 2.401121, 1.0821344, 1.5116377, 0.41454682, 1.4323092, 1.594685,
            2.47715, 0.68622506, 0.85695785, 1.955431, 1.9908644, 2.5598834, 2.6380892, 1.2720044,
            1.4925109, 0.8799942, 0.82485104, 1.4994898, 1.670933, 1.7571712, 2.0251954, 0.5936148,
            0.5080168, 0.8590176, 1.7732446, 1.4423096, 2.5071304, 0.9201062, 1.333132, 0.8056399,
            1.0742931, 0.57352155, 1.2157242, 0.92892367, 1.6791167, 0.6916962, 0.9324078,
            0.9726965, 1.052071, 1.1796652, 1.2348735, 0.34972954, 0.38747016, 0.75217795,
            0.7347498, 0.89940417, 0.9601251, 0.4880404, 0.7351295, 0.10921048, 0.17776261,
            0.12957546, 0.7313385, 0.591311, 1.3517611, 0.33482444, 0.5910514, 0.06074999,
            0.5432683, 0.51284546, 1.066932, 0.3218825, 0.6462344, 0.10888556, 0.19406202,
        ],
    )
    .unwrap();
    let current_output14: Array3<f32> = conv_layer14.transposed_convolve(&test_input14);

    assert!(
        arr_allclose(&current_output14, &target_output14),
        "{:?} was not equal to {:?}",
        current_output14,
        target_output14
    );

    let test_input15 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.6126854, 0.67232877, 0.7156292, 0.09058711, 0.33372015, 0.8941644, 0.30899736,
            0.3348802, 0.6412177, 0.26750943, 0.03709449, 0.56803024, 0.8756273, 0.5771133,
            0.56024176, 0.5868575, 0.75167763, 0.36936092, 0.37185487, 0.35425207, 0.24336162,
            0.01027582, 0.2671537, 0.83992416, 0.49819484, 0.7831867, 0.70054483, 0.8701863,
            0.49413827, 0.84670645, 0.8069649, 0.093459, 0.93408287, 0.8206956, 0.70209366,
            0.32817394, 0.744203, 0.39091238, 0.43911496, 0.92919487, 0.29325068, 0.62813336,
            0.8131431, 0.19520658, 0.47931832, 0.42483747, 0.47526902, 0.28184402, 0.09741595,
            0.45691565, 0.44086096, 0.9638409, 0.33859608, 0.26381832, 0.29839757, 0.68755937,
            0.09156765, 0.58584654, 0.04617033, 0.14705709, 0.81179595, 0.16751295, 0.06864621,
            0.6308731, 0.38993102, 0.3644169, 0.68174505, 0.272409, 0.23609333, 0.21866773,
            0.80119157, 0.01742986,
        ],
    )
    .unwrap();

    let kernel15: Array4<f32> = Array::from_shape_vec(
        (2, 1, 4, 4),
        vec![
            0.49270406, 0.37920174, 0.90869635, 0.8191268, 0.7636344, 0.7827788, 0.9694966,
            0.79533535, 0.00732174, 0.8372113, 0.9449071, 0.7670253, 0.50964797, 0.7843069,
            0.7365313, 0.71123123, 0.89694643, 0.9544987, 0.16811895, 0.97018677, 0.25394833,
            0.5585159, 0.51973414, 0.4357872, 0.29419306, 0.5180376, 0.80581653, 0.7190028,
            0.52249014, 0.5252596, 0.33191478, 0.3388958,
        ],
    )
    .unwrap();
    let conv_layer15 = TransposedConvolutionLayer::new(kernel15, 2, Padding::Valid);
    let target_output15: Array3<f32> = Array::from_shape_vec(
        (1, 14, 14),
        vec![
            0.96938276, 0.94267213, 1.3637462, 1.8519565, 1.4231186, 1.620483, 1.6021838,
            1.9334806, 0.6659869, 1.3821496, 1.3565116, 1.4964882, 0.91812503, 1.3418406,
            0.6568567, 0.8952463, 1.593469, 1.55622, 1.5129826, 1.5105135, 1.227166, 1.3504057,
            0.9000689, 0.90199256, 1.3182809, 1.4439697, 1.1933517, 0.984893, 1.1050153, 1.7917886,
            2.0561244, 3.125738, 2.1676917, 2.787727, 2.4801893, 2.9190426, 1.6821482, 2.2678912,
            1.3892593, 2.5167236, 1.9146128, 1.8762064, 1.1435499, 1.567463, 2.2726614, 2.391888,
            2.2565918, 2.5236313, 2.3874373, 2.3824518, 1.3276066, 1.4874809, 1.91535, 2.206641,
            1.5642542, 1.4234279, 0.76028544, 1.1049576, 2.51333, 2.66988, 1.8921374, 2.7316236,
            2.8559442, 3.3096538, 2.1045775, 2.8119524, 1.6636937, 2.3278365, 1.1438402, 1.1968467,
            1.2757368, 1.4092908, 2.2264295, 2.306339, 2.225436, 2.4018998, 2.4548721, 2.6868544,
            2.3351576, 2.2772563, 1.875608, 1.962867, 1.0071298, 0.90825105, 0.48593125, 1.2093782,
            2.2238474, 2.846241, 1.6868446, 2.6055303, 1.9395536, 2.5885975, 1.7171905, 2.6700299,
            1.85969, 1.9884014, 1.34956, 1.3036726, 0.85689926, 1.195669, 2.1708422, 2.4355216,
            2.0024776, 2.059295, 1.8018029, 2.0831168, 1.8423355, 2.0098162, 1.9538465, 2.0498366,
            1.2503452, 1.0842149, 1.0641092, 1.4296768, 1.9220065, 2.8050914, 2.0640767, 2.1524768,
            2.118895, 2.137174, 1.9873416, 2.5611138, 1.5976677, 2.4694612, 1.7428157, 1.7970898,
            0.9320178, 1.2917619, 2.4582362, 2.4612129, 2.0597525, 2.0065408, 2.0605392, 2.1404984,
            2.0101898, 2.0112314, 2.1378365, 2.3709056, 1.6777198, 1.4794412, 1.251556, 1.7943625,
            2.318206, 3.3261628, 1.7030604, 2.2636306, 2.3982186, 3.1561522, 3.2960217, 3.6521251,
            1.8445477, 3.0505219, 1.3948529, 1.1971883, 1.4674134, 1.8295817, 2.4002786, 2.4958985,
            2.0307815, 2.255381, 3.0224094, 3.1457264, 2.954802, 3.170158, 2.467414, 2.5132551,
            1.0718036, 0.99430746, 0.20647305, 1.0287697, 1.3926934, 1.3285022, 0.3841179,
            1.1718782, 1.143209, 1.6865907, 1.1925328, 1.7895651, 1.3165573, 1.3983628, 0.32413915,
            0.26424983, 0.76747304, 0.99100125, 1.0105984, 1.0213652, 0.7586619, 1.0154071,
            1.2988617, 1.5028944, 1.4534823, 1.6293004, 0.9594014, 1.0374157, 0.2474956,
            0.23931447,
        ],
    )
    .unwrap();
    let current_output15: Array3<f32> = conv_layer15.transposed_convolve(&test_input15);

    assert!(
        arr_allclose(&current_output15, &target_output15),
        "{:?} was not equal to {:?}",
        current_output15,
        target_output15
    );

    let test_input16 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.18619475, 0.6839338, 0.72234726, 0.25884646, 0.7980101, 0.36219832, 0.7046317,
            0.9284394, 0.468965, 0.23158234, 0.32747796, 0.9097073, 0.7440483, 0.03255624,
            0.30697423, 0.6246821, 0.1907446, 0.9843364, 0.4038572, 0.5747709, 0.65160054,
            0.6822517, 0.9840877, 0.18341686, 0.5288406, 0.92906404, 0.87780553, 0.9090181,
            0.82569945, 0.20383635, 0.7166643, 0.17061436, 0.91526777, 0.08598401, 0.70100874,
            0.40537685, 0.5971982, 0.92796123, 0.15859716, 0.7859081, 0.8564488, 0.35816404,
            0.79062706, 0.9644883, 0.13154314, 0.31929043, 0.80048305, 0.07180241, 0.52815664,
            0.45786336, 0.91537887, 0.9783313, 0.25753945, 0.42799363, 0.07738555, 0.9294206,
            0.07022415, 0.60058224, 0.6196278, 0.9008346, 0.04155485, 0.82207745, 0.41282526,
            0.9949608, 0.3109271, 0.47614527, 0.7615821, 0.35893062, 0.07713356, 0.6123928,
            0.62511915, 0.88098776,
        ],
    )
    .unwrap();

    let kernel16: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.21521498, 0.89468116, 0.1842307, 0.10784956, 0.8354833, 0.2630701, 0.7184675,
            0.06132602, 0.06056971, 0.71349823, 0.00944792, 0.07349233, 0.35231608, 0.8533961,
            0.17608605, 0.18067755, 0.51991457, 0.19053963,
        ],
    )
    .unwrap();
    let conv_layer16 = TransposedConvolutionLayer::new(kernel16, 2, Padding::Valid);
    let target_output16: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.46617174, 0.17222722, 0.8874838, 0.62066996, 0.46281838, 0.64776886, 0.7611859,
            0.23901024, 0.8882641, 0.7220562, 0.54346025, 0.3274359, 0.09305036, 0.23048355,
            0.66520923, 0.5548382, 1.3633337, 0.47710472, 0.73885524, 0.52275926, 0.8869528,
            0.59428793, 1.3976142, 0.5259912, 0.6082665, 0.15835124, 0.9574335, 0.9598011,
            1.8600082, 1.3641732, 1.2025907, 0.5475726, 0.7756584, 0.6346881, 1.6012617,
            0.79477024, 0.902637, 1.0230032, 0.26305562, 0.35454485, 1.2634261, 0.76452243,
            1.5987862, 0.51100004, 0.5040708, 0.28400078, 0.4659644, 0.4344864, 0.9567315,
            0.35051224, 0.8213212, 0.2519602, 1.1860727, 1.1249468, 1.5442234, 0.59184235,
            1.3595455, 0.38044342, 1.2338483, 0.7483403, 0.8665664, 0.6093545, 1.410212, 0.9778307,
            0.28158116, 0.26632336, 1.0723667, 0.4535617, 0.417939, 0.44479766, 1.0376526,
            0.65399474, 1.3568157, 0.4479127, 0.37914708, 0.35247758, 1.1876447, 0.33431318,
            0.7721311, 0.6822804, 1.1187472, 0.76306415, 0.83968717, 1.0783825, 1.5191365,
            1.1630299, 1.2315466, 1.031895, 1.7542224, 0.45549616, 0.24116617, 0.07082, 0.40345648,
            0.50930786, 1.2733754, 0.40987897, 0.60433036, 0.46895742, 1.0825444, 0.6096724,
            1.3509768, 0.70515186, 0.9220105, 0.2068759, 0.44760382, 0.53853714, 1.5070682,
            1.3574507, 1.4077923, 0.865727, 1.7491305, 1.1767728, 1.6148862, 1.1241791, 1.0307766,
            0.66647243, 0.25530013, 0.07167567, 0.47730023, 0.53626966, 1.4777752, 0.6292813,
            1.0856954, 0.75219506, 1.6085651, 0.6129302, 0.9552021, 0.46170408, 0.5766424,
            0.13746579, 1.0850872, 0.7024181, 1.3368, 0.64042246, 1.2279994, 1.0880678, 1.5944303,
            0.65575516, 1.5517902, 0.84537774, 1.23265, 0.63106185, 0.24249956, 0.34560955,
            1.2486923, 0.46749467, 0.44885543, 0.23397283, 0.8305164, 0.47939092, 0.59445184,
            0.42629665, 1.1191554, 0.6485951, 1.0905172, 0.2617722, 0.6525008, 0.4399078,
            0.3759513, 0.19707637, 0.75025094, 0.09623259, 0.24255684, 0.32366496, 0.7384901,
            0.3679986, 0.6119946, 0.4828985, 0.19241664,
        ],
    )
    .unwrap();
    let current_output16: Array3<f32> = conv_layer16.transposed_convolve(&test_input16);

    assert!(
        arr_allclose(&current_output16, &target_output16),
        "{:?} was not equal to {:?}",
        current_output16,
        target_output16
    );

    let test_input17 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.5045173, 0.7456122, 0.27621788, 0.48649722, 0.39297876, 0.54849166, 0.3746991,
            0.8194284, 0.34880427, 0.79505837, 0.41293454, 0.890512, 0.12076204, 0.20799449,
            0.88948244, 0.24437675, 0.7731474, 0.65954226, 0.4922565, 0.5211581, 0.97382414,
            0.9779564, 0.1754263, 0.4551989, 0.81067127, 0.7095975, 0.5087082, 0.78796804,
            0.03310984, 0.20805901, 0.45704818, 0.9133983, 0.5689028, 0.04247752, 0.55938286,
            0.9835293, 0.04525762, 0.7176199, 0.82096803, 0.5575717, 0.5744108, 0.9780689,
            0.34563604, 0.3324931, 0.8797563, 0.14932355, 0.1134909, 0.5645703, 0.30096474,
            0.4096875, 0.5703153, 0.88738924, 0.6242374, 0.77620894, 0.681929, 0.24701218,
            0.74485576, 0.61556435, 0.63869125, 0.05875124, 0.3210932, 0.96946657, 0.09463912,
            0.6275637, 0.34162354, 0.74390864, 0.8736778, 0.9513908, 0.24045336, 0.7003475,
            0.87750345, 0.16564246,
        ],
    )
    .unwrap();

    let kernel17: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.6314963, 0.21785556, 0.7654987, 0.13988015, 0.03287261, 0.82226163, 0.60896695,
            0.13331373, 0.62307173, 0.23316076, 0.9600204, 0.55291533, 0.29808274, 0.8765127,
            0.98263544, 0.27148733, 0.11101003, 0.2754741,
        ],
    )
    .unwrap();
    let conv_layer17 = TransposedConvolutionLayer::new(kernel17, 2, Padding::Valid);
    let target_output17: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.32915312, 0.15336014, 1.0494032, 0.8513655, 1.3333963, 0.8483217, 1.1025953,
            0.64126635, 1.0627977, 0.63705873, 1.192843, 1.0584581, 0.96065897, 0.08406247,
            0.05625368, 0.7775234, 0.6535132, 1.6016009, 0.7286689, 1.2680894, 0.5047111,
            1.1741096, 0.5163966, 1.2558362, 0.87532014, 1.4120888, 0.63673115, 0.4857311,
            2.0486252, 0.6767806, 2.2898507, 1.0485322, 2.1362262, 0.44331437, 1.8303833,
            0.31506848, 2.075478, 0.917699, 1.6050277, 0.1554411, 0.3152717, 0.8614671, 0.31837118,
            1.311535, 0.78258365, 1.3070117, 0.15701963, 0.8920676, 0.11305045, 0.743914,
            0.5241265, 1.2870007, 0.46844912, 0.40356258, 1.4036727, 0.5847722, 2.133831,
            0.8854552, 2.341845, 1.0277193, 2.1302967, 0.83536357, 2.5185914, 1.0702518, 1.644434,
            0.10660461, 0.2677692, 0.54625165, 0.3659336, 0.8680214, 0.5291282, 1.5904982,
            0.7858412, 1.3671441, 0.5725674, 1.5727587, 0.7020379, 1.3050467, 0.62510544,
            0.8114159, 1.5366118, 0.42388186, 2.2631128, 1.1091207, 3.0194554, 0.9350955,
            2.3856888, 0.82374203, 2.0546434, 0.329663, 1.0057063, 0.27212816, 0.6139012,
            1.2213811, 0.23364115, 1.0294986, 0.6848877, 1.8529457, 0.57169795, 1.6239328,
            0.5655877, 0.85303295, 0.06645978, 0.43202367, 1.0717053, 0.6261908, 2.3512487,
            1.1821958, 2.6105523, 0.41419098, 2.660277, 0.97284603, 2.1098745, 0.4294666,
            1.0974706, 0.82670057, 0.8703934, 0.20910916, 0.30809116, 1.3703413, 0.8730761,
            1.6354755, 0.09967496, 0.80857396, 0.5759701, 1.3710458, 0.30052578, 0.613766,
            0.6588848, 0.9020699, 1.0731764, 1.0820372, 2.920453, 1.3145632, 2.6852412, 0.43310243,
            1.751817, 0.8563147, 1.7543445, 1.0066235, 2.0165095, 0.48360592, 1.17904, 0.32436022,
            0.78081405, 1.6456794, 0.8639319, 1.837176, 0.22946174, 0.9187682, 0.6152598, 1.062929,
            0.7875313, 1.5091765, 0.1775189, 0.9714846, 0.5155197, 0.1579178, 1.3399694,
            0.22738247, 1.2429192, 0.10253529, 0.6367088, 0.08340843, 0.7982709, 0.17198509,
            1.2341719, 0.14950594, 0.6584395,
        ],
    )
    .unwrap();
    let current_output17: Array3<f32> = conv_layer17.transposed_convolve(&test_input17);

    assert!(
        arr_allclose(&current_output17, &target_output17),
        "{:?} was not equal to {:?}",
        current_output17,
        target_output17
    );

    let test_input18 = Array::from_shape_vec(
        (2, 6, 6),
        vec![
            0.4540411, 0.19701396, 0.08459944, 0.98017716, 0.9800813, 0.62585706, 0.18621969,
            0.5836321, 0.17965508, 0.81336415, 0.94554824, 0.28304926, 0.32718146, 0.46701643,
            0.91682273, 0.6142979, 0.19277428, 0.28408903, 0.25507236, 0.9800453, 0.36125833,
            0.96792, 0.33258557, 0.9508625, 0.8424581, 0.8130291, 0.7774976, 0.17691322, 0.9389267,
            0.22419459, 0.33442205, 0.7614585, 0.37563834, 0.70754576, 0.1499497, 0.9873837,
            0.7166968, 0.40278858, 0.22288306, 0.3279577, 0.07722609, 0.598755, 0.8143903,
            0.87905455, 0.83061284, 0.9923988, 0.6196494, 0.536406, 0.06662867, 0.83588266,
            0.28182983, 0.662181, 0.99850965, 0.60448396, 0.12318801, 0.91713256, 0.8540598,
            0.19103892, 0.5929614, 0.9118344, 0.9381113, 0.3421722, 0.8149188, 0.9595595,
            0.02717085, 0.8916309, 0.9755575, 0.27588442, 0.59208006, 0.00008138, 0.9552037,
            0.12578069,
        ],
    )
    .unwrap();

    let kernel18: Array4<f32> = Array::from_shape_vec(
        (2, 1, 3, 3),
        vec![
            0.01249961, 0.05413999, 0.5153533, 0.40144867, 0.8698811, 0.6468678, 0.8840439,
            0.34315115, 0.52290094, 0.66408885, 0.98115784, 0.85046166, 0.7979905, 0.9444794,
            0.6930413, 0.90735817, 0.91156703, 0.45996496,
        ],
    )
    .unwrap();
    let conv_layer18 = TransposedConvolutionLayer::new(kernel18, 2, Padding::Valid);
    let target_output18: Array3<f32> = Array::from_shape_vec(
        (1, 13, 13),
        vec![
            0.48162568, 0.72777444, 1.1134647, 0.40586552, 0.5931597, 0.22326368, 0.46319696,
            0.37484503, 0.84758866, 0.12883258, 0.9762155, 0.6213571, 0.8317557, 0.75419146,
            1.0718671, 1.1909175, 0.55180424, 0.618412, 0.2840999, 0.8643898, 1.1623869, 1.3164114,
            0.92549264, 1.4165542, 1.109933, 0.8198087, 1.5948482, 1.6182492, 2.4863586, 1.3288634,
            2.1675372, 1.056892, 2.779048, 1.6530397, 3.2863796, 1.0658786, 3.018616, 1.3021922,
            1.2047307, 0.7246334, 0.93116385, 1.6206412, 1.3379395, 1.7216973, 0.9407753,
            1.8103108, 1.6448303, 2.087976, 1.4077606, 1.582764, 0.7528436, 0.55484694, 0.95190704,
            0.88935965, 2.5717564, 1.8470082, 2.772187, 1.1449645, 3.2551038, 1.8667071, 3.8251765,
            1.8794503, 2.8699083, 1.1945734, 1.0552313, 0.1845156, 0.34753838, 1.1123291,
            1.1957227, 1.4743538, 1.0637093, 1.563406, 1.1597824, 1.7304785, 1.1107625, 1.4131275,
            0.81804633, 0.6027004, 0.43469495, 0.30768567, 2.230565, 1.8751317, 3.5516553,
            1.4290416, 2.8044271, 1.0542619, 2.761452, 1.576154, 2.6528263, 1.5946463, 1.6921023,
            0.20070131, 0.33823118, 1.3756735, 1.7187357, 2.096129, 1.1208937, 1.3666025,
            1.0224077, 1.3652077, 0.8493497, 1.7354434, 1.6883461, 1.2470213, 0.97079045,
            1.1658684, 3.357997, 1.5520737, 3.2895203, 1.7441566, 3.3439517, 1.457345, 2.3630676,
            0.7321435, 3.2165267, 2.0444562, 1.790456, 1.0868076, 1.6188653, 1.7945486, 1.0304133,
            1.7254846, 1.4460045, 1.9044514, 1.0601777, 1.1780668, 0.8424169, 1.4277076, 1.0371497,
            0.7629613, 2.24801, 2.1195233, 3.0959961, 0.9028163, 3.0342245, 1.6109133, 2.5144775,
            0.97379714, 2.3894975, 1.2922857, 2.4962025, 1.0665816, 1.1431737, 0.9127389,
            1.2123014, 1.4182682, 0.9229455, 1.307036, 0.8859681, 0.9374325, 0.61555755, 1.2801856,
            1.0326086, 1.255749, 0.9777037, 0.72587794, 1.1808238, 1.0040433, 1.5470806, 0.5127825,
            1.394374, 0.66862136, 1.094333, 0.24286932, 1.3692877, 0.9221876, 1.5047877,
            0.45347938, 0.5741586,
        ],
    )
    .unwrap();
    let current_output18: Array3<f32> = conv_layer18.transposed_convolve(&test_input18);

    assert!(
        arr_allclose(&current_output18, &target_output18),
        "{:?} was not equal to {:?}",
        current_output18,
        target_output18
    );

    let test_input19 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.9045769, 0.17170428, 0.43418503, 0.69308424, 0.42869946, 0.9244341, 0.41451567,
            0.6224708, 0.00536506, 0.33826837, 0.47926104, 0.0032256, 0.02230139, 0.35960108,
            0.48593593, 0.86064774, 0.28908366, 0.4153976, 0.3468706, 0.2242362,
        ],
    )
    .unwrap();

    let kernel19: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.93169004, 0.3198661, 0.5576108, 0.17364207, 0.69407916, 0.88076496, 0.11111139,
            0.19382912, 0.9307082, 0.9188555, 0.10532705, 0.88550454, 0.20754221, 0.97926295,
            0.3472928, 0.71126235,
        ],
    )
    .unwrap();
    let conv_layer19 = TransposedConvolutionLayer::new(kernel19, 2, Padding::Valid);
    let target_output19: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.8427853, 0.28934348, 0.66437703, 0.21199498, 0.50027, 0.16869617, 0.88784593,
            0.29708692, 0.7858863, 0.257475, 0.23904745, 0.07444026, 0.62784797, 0.7967196,
            0.21968515, 0.32656443, 0.3204371, 0.41569626, 0.52929825, 0.694602, 0.37456092,
            0.5119234, 0.04763339, 0.08309444, 1.7031832, 1.1268706, 1.1567576, 1.2518885,
            1.2332729, 0.8220829, 1.0428857, 1.1311203, 0.7901475, 1.1167743, 0.23377575,
            0.43835294, 0.82936835, 1.7000278, 0.7402108, 1.3558083, 0.62784475, 1.1759038,
            0.36752093, 1.1129096, 0.5650576, 1.2117491, 0.1864697, 0.37048405, 1.3069012,
            1.0027207, 0.75340754, 1.2837223, 0.645575, 0.94670975, 0.4180286, 0.67502713,
            0.9686534, 0.53344685, 0.30659193, 0.3839171, 0.5245042, 1.3273804, 0.462569,
            1.1591707, 0.2889846, 0.9246595, 0.46936268, 0.7690405, 0.449302, 0.8327661,
            0.17147118, 0.3347861, 1.2479091, 0.7156637, 0.8027241, 0.66926444, 0.5693138,
            0.20641673, 0.8918387, 0.533252, 0.8924777, 0.89689016, 0.17621873, 0.4692353,
            0.69682455, 1.227351, 0.46338806, 0.7654724, 0.32618803, 0.4460337, 0.3692886,
            0.7540338, 0.41991803, 0.9963628, 0.19367725, 0.38909143, 0.8010119, 0.7908109,
            0.35970202, 1.0277336, 0.41706228, 0.6376753, 0.36658794, 0.6865604, 0.24523334,
            0.5131962, 0.02361814, 0.19856218, 0.17862074, 0.84280044, 0.3588938, 0.89523524,
            0.18660921, 0.6123978, 0.21625489, 0.6351342, 0.16700414, 0.46630222, 0.07787562,
            0.15949076,
        ],
    )
    .unwrap();
    let current_output19: Array3<f32> = conv_layer19.transposed_convolve(&test_input19);

    assert!(
        arr_allclose(&current_output19, &target_output19),
        "{:?} was not equal to {:?}",
        current_output19,
        target_output19
    );

    let test_input20 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.03633394, 0.7482733, 0.28782296, 0.7382309, 0.60003114, 0.3259743, 0.85578996,
            0.14142898, 0.39191914, 0.05517358, 0.6050927, 0.968827, 0.47373444, 0.76571184,
            0.50472075, 0.53850234, 0.05837096, 0.56728834, 0.3979838, 0.2393961,
        ],
    )
    .unwrap();

    let kernel20: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.36507484, 0.01646563, 0.27730468, 0.62646276, 0.94121945, 0.66457146, 0.8425775,
            0.4301739, 0.68211764, 0.6059688, 0.7629583, 0.56038123, 0.48163053, 0.437191,
            0.43973154, 0.29997745,
        ],
    )
    .unwrap();
    let conv_layer20 = TransposedConvolutionLayer::new(kernel20, 2, Padding::Valid);
    let target_output20: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.01326461, 0.00059826, 0.28325135, 0.03508265, 0.31257662, 0.47350457, 0.34932417,
            0.19246581, 0.42377114, 0.47235405, 0.16639145, 0.37589717, 0.03419821, 0.0241465,
            0.7349035, 0.512911, 0.9013828, 0.51316655, 0.9373504, 0.6144211, 1.1867777,
            0.71633124, 0.50557274, 0.25811774, 0.14378902, 0.0273846, 0.94095325, 0.692093,
            1.0561771, 1.1321793, 0.90545595, 0.7036886, 1.1013547, 1.0237222, 0.4730986,
            0.3708104, 0.32431287, 0.23251809, 1.4565132, 1.0469968, 1.3218488, 0.8124269,
            0.9701662, 0.73038566, 0.99576944, 0.689041, 0.31034064, 0.20373005, 0.44325694,
            0.20749347, 1.3539436, 1.0962722, 1.191012, 1.1800045, 0.78615034, 0.6261298,
            0.7332492, 0.7410581, 0.18205656, 0.347107, 0.7265242, 0.54464036, 1.9772321,
            1.3760786, 1.7066343, 1.0501437, 1.3708119, 0.9264274, 1.3191371, 0.8065005,
            0.44952792, 0.23366854, 0.60933805, 0.37553406, 1.2931535, 1.2644743, 1.2856064,
            0.87588876, 1.1863507, 1.0914073, 1.1262454, 0.9881994, 0.45146653, 0.4328088, 0.79828,
            0.62241435, 1.2413648, 0.87551796, 1.2373136, 0.89985204, 1.4296807, 0.9853933,
            1.140453, 0.7806537, 0.4236514, 0.25438678, 0.36732194, 0.3263156, 0.4506707,
            0.33713758, 0.43149197, 0.37646902, 0.7042891, 0.5590635, 0.46694136, 0.3680892,
            0.18264924, 0.13415308, 0.25935918, 0.23542838, 0.26490968, 0.18705782, 0.29889095,
            0.26552334, 0.4411357, 0.34416863, 0.29030648, 0.22404799, 0.10527001, 0.07181343,
        ],
    )
    .unwrap();
    let current_output20: Array3<f32> = conv_layer20.transposed_convolve(&test_input20);

    assert!(
        arr_allclose(&current_output20, &target_output20),
        "{:?} was not equal to {:?}",
        current_output20,
        target_output20
    );

    let test_input21 = Array::from_shape_vec(
        (1, 4, 5),
        vec![
            0.21913478, 0.6611514, 0.209788, 0.176356, 0.88925517, 0.14793599, 0.36509594,
            0.5616029, 0.6617385, 0.30053073, 0.36820948, 0.62227124, 0.4957459, 0.69923055,
            0.3227648, 0.9702412, 0.5679234, 0.13432135, 0.7430913, 0.19231908,
        ],
    )
    .unwrap();

    let kernel21: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.26170298, 0.10480803, 0.00958306, 0.20726651, 0.20851518, 0.17973869, 0.23704103,
            0.1163867, 0.2735905, 0.8537909, 0.40303, 0.75797635, 0.34342998, 0.74670875,
            0.82946825, 0.91931367,
        ],
    )
    .unwrap();
    let conv_layer21 = TransposedConvolutionLayer::new(kernel21, 2, Padding::Valid);
    let target_output21: Array3<f32> = Array::from_shape_vec(
        (1, 10, 12),
        vec![
            0.05734823, 0.02296708, 0.17512527, 0.11471328, 0.061238, 0.15902202, 0.04816331,
            0.06196555, 0.23441076, 0.12975377, 0.00852179, 0.18431282, 0.04569293, 0.039387,
            0.18980403, 0.14433886, 0.200464, 0.11465625, 0.08650126, 0.05611453, 0.22722682,
            0.18035905, 0.21078996, 0.10349748, 0.09866849, 0.20260015, 0.36616704, 0.7995112,
            0.47433174, 0.8147849, 0.311361, 0.4953425, 0.3993598, 1.0615659, 0.36127654,
            0.73632437, 0.10610435, 0.19021969, 0.52001953, 0.7779808, 0.82409704, 0.90789014,
            0.5056839, 0.50885063, 0.671203, 0.9571757, 0.808847, 0.8524822, 0.1368354, 0.16489771,
            0.32588825, 0.56538403, 0.4364953, 0.93715966, 0.59512967, 1.1667045, 0.44009212,
            0.936928, 0.12421598, 0.29469353, 0.12758292, 0.17664659, 0.46512684, 0.5633208,
            0.7465811, 0.9165203, 0.9564049, 1.1937921, 0.88515, 0.97214866, 0.3257892, 0.31384754,
            0.35465363, 0.41606298, 0.4765721, 1.071005, 0.4270201, 1.0267196, 0.58685976,
            1.0784826, 0.42756787, 0.97974837, 0.13192691, 0.2845094, 0.3287642, 0.4493351,
            0.8675323, 1.0181564, 0.8490374, 1.0324817, 0.83812773, 1.1270629, 0.90708125,
            1.0048766, 0.31331068, 0.3191055, 0.26544878, 0.8283831, 0.54641473, 1.2203077,
            0.26563922, 0.54515487, 0.25743827, 0.73625696, 0.35210478, 0.72744584, 0.07751036,
            0.14577332, 0.3332099, 0.7244876, 0.9998262, 1.3160293, 0.51720446, 0.62239873,
            0.36661512, 0.6783562, 0.68241876, 0.82674026, 0.15952258, 0.17680156,
        ],
    )
    .unwrap();
    let current_output21: Array3<f32> = conv_layer21.transposed_convolve(&test_input21);

    assert!(
        arr_allclose(&current_output21, &target_output21),
        "{:?} was not equal to {:?}",
        current_output21,
        target_output21
    );

    let test_input22 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.9654975, 0.18782942, 0.10021565, 0.05109123, 0.3069365, 0.10895161, 0.9891213,
            0.62504834, 0.507994,
        ],
    )
    .unwrap();

    let kernel22: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.47125, 0.84314245, 0.6054993, 0.92367506, 0.6953895, 0.37023902, 0.67128026,
            0.43450755, 0.28869846, 0.27641538, 0.8369712, 0.6856483, 0.26890948, 0.65425915,
            0.84581685, 0.51146317,
        ],
    )
    .unwrap();
    let conv_layer22 = TransposedConvolutionLayer::new(kernel22, 2, Padding::Valid);
    let target_output22: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.45499068, 0.8140519, 0.6731227, 1.0501729, 0.16095722, 0.2579894, 0.06068051,
            0.0925667, 0.67139685, 0.35746485, 0.77873397, 0.48905772, 0.19577509, 0.11871704,
            0.06727279, 0.04354446, 0.30281436, 0.30995554, 1.0378993, 1.0198936, 0.4233332,
            0.5318574, 0.14984775, 0.16934858, 0.29515973, 0.6506015, 1.1148801, 0.7525449,
            0.4676224, 0.3353392, 0.15790115, 0.09859692, 0.4808734, 0.8480926, 1.0248404,
            1.560504, 0.9062097, 1.2462193, 0.3987794, 0.54392385, 0.70156354, 0.3996382,
            1.2243817, 0.88814527, 1.0617465, 0.6879367, 0.43315944, 0.27645195, 0.2855578,
            0.27340835, 1.0083165, 0.8509624, 0.6698046, 0.5689807, 0.42517635, 0.34830523,
            0.26598412, 0.6471417, 1.004697, 0.9148427, 0.6652808, 0.65204895, 0.4296699,
            0.25982022,
        ],
    )
    .unwrap();
    let current_output22: Array3<f32> = conv_layer22.transposed_convolve(&test_input22);

    assert!(
        arr_allclose(&current_output22, &target_output22),
        "{:?} was not equal to {:?}",
        current_output22,
        target_output22
    );

    let test_input23 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.48995435, 0.52071315, 0.80564773, 0.670521, 0.3835857, 0.47078377, 0.5100531,
            0.82525116, 0.02126783,
        ],
    )
    .unwrap();

    let kernel23: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.9583153, 0.23316967, 0.9487504, 0.9609589, 0.95734006, 0.00943314, 0.7521432,
            0.46106157, 0.84370506, 0.16933449, 0.71423984, 0.5316646, 0.6400151, 0.9638914,
            0.69432026, 0.8581641,
        ],
    )
    .unwrap();
    let conv_layer23 = TransposedConvolutionLayer::new(kernel23, 2, Padding::Valid);
    let target_output23: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.46953076, 0.11424249, 0.96385175, 0.5922405, 1.2660913, 0.68823653, 0.7643586,
            0.77419436, 0.46905294, 0.00462181, 0.8670154, 0.23081107, 1.1629298, 0.2476806,
            0.60596246, 0.3714532, 1.0559475, 0.23931134, 1.7930264, 1.0824498, 1.8667295,
            0.8916513, 1.022082, 0.88073826, 0.9554948, 0.4785879, 1.5449994, 1.235142, 1.61638,
            1.4047118, 0.9134743, 0.9084382, 1.0545137, 0.23247126, 2.0773098, 1.1040102,
            1.4745134, 1.0816504, 0.35643038, 0.27073658, 0.9174379, 0.65112084, 1.8847358,
            1.1881026, 1.2087076, 1.1636561, 0.34287116, 0.4138155, 0.4303344, 0.08636958,
            1.0605688, 0.41092065, 0.60737103, 0.4423582, 0.01519033, 0.01130735, 0.3264417,
            0.4916358, 0.8823134, 1.2331617, 0.58660036, 0.72870076, 0.01476669, 0.01825129,
        ],
    )
    .unwrap();
    let current_output23: Array3<f32> = conv_layer23.transposed_convolve(&test_input23);

    assert!(
        arr_allclose(&current_output23, &target_output23),
        "{:?} was not equal to {:?}",
        current_output23,
        target_output23
    );

    let test_input24 = Array::from_shape_vec(
        (1, 3, 3),
        vec![
            0.70813745, 0.2836983, 0.33953485, 0.8950543, 0.20262088, 0.81930757, 0.09556881,
            0.22266188, 0.63842744,
        ],
    )
    .unwrap();

    let kernel24: Array4<f32> = Array::from_shape_vec(
        (1, 1, 4, 4),
        vec![
            0.8304186, 0.12425002, 0.7582065, 0.09737789, 0.84872884, 0.17490041, 0.37569723,
            0.6669188, 0.8970669, 0.22398192, 0.29424527, 0.56277037, 0.41113177, 0.7882464,
            0.24159203, 0.5460915,
        ],
    )
    .unwrap();
    let conv_layer24 = TransposedConvolutionLayer::new(kernel24, 2, Padding::Valid);
    let target_output24: Array3<f32> = Array::from_shape_vec(
        (1, 8, 8),
        vec![
            0.5880505, 0.08798609, 0.7725027, 0.10420644, 0.4970579, 0.06981315, 0.25743753,
            0.03306319, 0.6010167, 0.12385353, 0.5068282, 0.52188915, 0.3947577, 0.2485885,
            0.1275623, 0.22644217, 1.3785163, 0.2698205, 1.3097587, 0.5743962, 1.2220591,
            0.35723644, 0.7211108, 0.27086258, 1.0507963, 0.7147321, 0.7959573, 1.242699,
            0.97962683, 0.7009913, 0.3898405, 0.73182875, 0.88228565, 0.2123504, 0.7024934,
            0.5860655, 1.4935796, 0.39854607, 0.7251372, 0.5232507, 0.44909725, 0.72223836,
            0.52442634, 0.751177, 1.0113002, 1.0166245, 0.4377936, 0.8731962, 0.08573161,
            0.02140568, 0.22786327, 0.10365553, 0.6382293, 0.26830372, 0.18785426, 0.35928804,
            0.03929137, 0.07533177, 0.11463204, 0.22770175, 0.31627116, 0.6248319, 0.15423898,
            0.3486398,
        ],
    )
    .unwrap();
    let current_output24: Array3<f32> = conv_layer24.transposed_convolve(&test_input24);

    assert!(
        arr_allclose(&current_output24, &target_output24),
        "{:?} was not equal to {:?}",
        current_output24,
        target_output24
    );
}
