use convert_base::Convert;

#[test]
fn long_aligned () {
  assert_eq![
    Convert::new(256,16).convert::<u8,u8>(
      &vec![
        0xff,0xee,0xdd,0xcc,0xbb,0xaa,0x99,0x88,0x77,0x66,0x55,0x44,0x33,
        0x22,0x11,0x00,0x12,0x34,0x56,0x78,0x9a,0xbc,0xde,0xf0
      ]
    ),
    vec![
      0xf,0xf,0xe,0xe,0xd,0xd,0xc,0xc,0xb,0xb,0xa,0xa,0x9,0x9,0x8,0x8,0x7,0x7,
      0x6,0x6,0x5,0x5,0x4,0x4,0x3,0x3,0x2,0x2,0x1,0x1,0x0,0x0,0x2,0x1,0x4,0x3,
      0x6,0x5,0x8,0x7,0xa,0x9,0xc,0xb,0xe,0xd,0x0,0xf
    ]
  ];
  assert_eq![
    Convert::new(16,256).convert::<u8,u8>(
      &vec![
        0xf,0xf,0xe,0xe,0xd,0xd,0xc,0xc,0xb,0xb,0xa,0xa,0x9,0x9,0x8,0x8,0x7,
        0x7,0x6,0x6,0x5,0x5,0x4,0x4,0x3,0x3,0x2,0x2,0x1,0x1,0x0,0x0,0x2,0x1,
        0x4,0x3,0x6,0x5,0x8,0x7,0xa,0x9,0xc,0xb,0xe,0xd,0x0,0xf
      ]
    ),
    vec![
      0xff,0xee,0xdd,0xcc,0xbb,0xaa,0x99,0x88,0x77,0x66,0x55,0x44,0x33,
      0x22,0x11,0x00,0x12,0x34,0x56,0x78,0x9a,0xbc,0xde,0xf0
    ]
  ];
  assert_eq![
    Convert::new(256,2).convert::<u8,u8>(
      &vec![0xa7,0xec,0xb1,0xca,0x1e,0xbb,0xca,0x37,0x13,0x1e,0x66,0xb0,0xff,
        0x00,0xff]
    ),
    vec![1,1,1,0,0,1,0,1,0,0,1,1,0,1,1,1,1,0,0,0,1,1,0,1,0,1,0,1,0,0,1,1,0,1,1,
      1,1,0,0,0,1,1,0,1,1,1,0,1,0,1,0,1,0,0,1,1,1,1,1,0,1,1,0,0,1,1,0,0,1,0,0,
      0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,0,0,0,
      0,0,0,0,0,1,1,1,1,1,1,1,1]
  ];
}

#[test]
fn long_unaligned () {
  assert_eq![
    Convert::new(256,10).convert::<u8,u8>(
      &vec![
        0xff,0xee,0xdd,0xcc,0xbb,0xaa,0x99,0x88,0x77,0x66,0x55,0x44,0x33,
        0x22,0x11,0x00,0x12,0x34,0x56,0x78,0x9a,0xbc,0xde,0xf0
      ]
    ),
    vec![5,5,0,9,4,3,4,9,2,1,9,9,3,9,9,1,1,0,9,8,1,4,4,4,4,6,1,8,8,8,4,5,7,5,4,
      4,0,1,2,7,2,3,2,8,5,3,6,4,7,1,8,6,1,1,6,0,9,5]
  ];
  assert_eq![
    Convert::new(10,256).convert::<u8,u8>(
      &vec![5,5,0,9,4,3,4,9,2,1,9,9,3,9,9,1,1,0,9,8,1,4,4,4,4,6,1,8,8,8,4,5,7,
        5,4,4,0,1,2,7,2,3,2,8,5,3,6,4,7,1,8,6,1,1,6,0,9,5]
    ),
    vec![
      0xff,0xee,0xdd,0xcc,0xbb,0xaa,0x99,0x88,0x77,0x66,0x55,0x44,0x33,
      0x22,0x11,0x00,0x12,0x34,0x56,0x78,0x9a,0xbc,0xde,0xf0
    ]
  ];
  assert_eq![
    Convert::new(256,3).convert::<u8,u8>(
      &vec![0xa7,0xec,0xb1,0xca,0x1e,0xbb,0xca,0x37,0x13,0x1e,0x66,0xb0,0xff,
        0x00,0xff]
    ),
    vec![2,0,0,2,0,1,1,1,2,0,2,2,1,2,1,0,1,2,2,0,1,2,0,2,0,2,2,2,1,0,0,1,1,2,0,
      2,0,0,0,1,0,2,2,0,1,2,1,0,2,0,0,0,0,1,0,2,2,0,1,0,0,0,0,0,0,1,2,1,2,2,0,
      2,1,1,0,2]
  ];
  assert_eq![
    Convert::new(3,256).convert::<u8,u8>(&vec![
      2,0,0,2,0,1,1,1,2,0,2,2,1,2,1,0,1,2,2,0,1,2,0,2,0,2,2,2,1,0,0,1,1,2,0,
      2,0,0,0,1,0,2,2,0,1,2,1,0,2,0,0,0,0,1,0,2,2,0,1,0,0,0,0,0,0,1,2,1,2,2,0,
      2,1,1,0,2
    ]),
    vec![0xa7,0xec,0xb1,0xca,0x1e,0xbb,0xca,
      0x37,0x13,0x1e,0x66,0xb0,0xff,0x00,0xff]
  ];
}
