use std::fmt;

#[derive(Debug, Eq, PartialEq)]
pub enum FromComponentError {
    InvalidRegex,
    NotEnoughValues,
    ParseIntError(std::num::ParseIntError),
    ParseFloatError(std::num::ParseFloatError),
    Base64DecodeError(base64::DecodeError),
}

impl fmt::Display for FromComponentError {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match self {
            Self::InvalidRegex => write!(
                f,
                "Error when parsing from vcard component: InvalidRegexError"
            ),
            Self::NotEnoughValues => write!(
                f,
                "Error when parsing from vcard component: NotEnoughValuesError"
            ),
            Self::ParseIntError(e) => {
                write!(f, "Error when parsing from vcard component: {}", e)
            }
            Self::ParseFloatError(e) => {
                write!(f, "Error when parsing from vcard component: {}", e)
            }
            Self::Base64DecodeError(e) => {
                write!(f, "Error when parsing from vcard from component: {}", e,)
            }
        }
    }
}

impl std::error::Error for FromComponentError {}
