use std::error::Error;
use std::fmt;

#[derive(Eq, PartialEq, Clone, Hash, Debug)]
pub enum ComponentParseError  {
    /// A component has no name
    NoName,
    /// A component has no value
    NoValue,
    /// A component is invalid
    Invalid(String),
}

impl fmt::Display for ComponentParseError {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match self {
            Self::NoName => write!(f, "The VCard component contained no name"),
            Self::NoValue => {
                write!(f, "The VCard component contained no value")
            }
            Self::Invalid(s) => {
                write!(f, "The VCard component contained invalid formatting.\n{}", s)
            }
        }
    }
}

impl Error for ComponentParseError {}
