use std::fmt;

/// This type is an error type for when converting between `SqlContact`
/// and `Contact`.
///
/// Its variants are as follows:
///  * `InvalidProperty`, this can be for either Uri or Address.geo, namely when
///    incompatable fields are given.
#[derive(Debug, Clone)]
pub enum SqlConversionError {
    InvalidProperty(String),
}

impl fmt::Display for SqlConversionError {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match self {
            Self::InvalidProperty(x) => write!(f, "Invalid Property: {}", x),
        }
    }
}

impl std::error::Error for SqlConversionError {}
