use std::fmt;

#[derive(Debug, Eq, PartialEq)]
pub enum FromComponentError {
    InvalidRegex,
    NotEnoughValues,
}

impl fmt::Display for FromComponentError {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match self {
            Self::InvalidRegex => write!(
                f,
                "Error when parsing from vcard component: InvalidRegexError"
            ),
            Self::NotEnoughValues => write!(
                f,
                "Error when parsing from vcard component: NotEnoughValuesError"
            ),
        }
    }
}

impl std::error::Error for FromComponentError {}
