use contack::{
    address::{Address, Geo},
    contact_information::{ContactInformation, Type},
    contact_platform::ContactPlatform,
    date_time::DateTime,
    name::Name,
    org::Org,
    schema,
    uri::Uri,
    Contact, NewContact,
};
#[macro_use]
extern crate diesel;
extern crate dotenv;

use diesel::pg::PgConnection;
use diesel::prelude::*;
use dotenv::dotenv;
use std::env;

fn create_a_contack() -> contack::Contact {
    // Create a contact
    let mut contact = Contact::new(Name::new(
        Some(String::from(String::from("John"))),
        None,
        Some(String::from(String::from("Doe"))),
        None,
        None,
    ));

    // Give it a nickname
    contact.nickname = Some(String::from("Johnny"));

    // And an aniversary.
    contact.anniversary = Some(DateTime::new(2020, 01, 01, 0, 0, 0));

    // And a birthday
    contact.bday = Some(DateTime::new(2020, 02, 02, 0, 0, 0));

    // Photo
    contact.photo = Some(Uri::new_url(String::from("example.com/example.png")));

    contact.title = Some(String::from("Example Project Manager"));

    contact.org = Some(Org::new(
        String::from("Org"),
        String::from("Unit"),
        String::from("Office"),
    ));

    contact.logo =
        Some(Uri::new_url(String::from("example.com/example_logo.png")));

    contact.contact_information.push({
        let mut ci = ContactInformation::new(
            String::from("johndoe@example.com"),
            ContactPlatform::Email,
        );

        ci.typ = Some(Type::Work);

        ci.pref = 2;

        ci.pid = String::from("1234");

        ci
    });

    contact.home_address = Some(Address::new(
        Some(String::from("Home Street")),
        Some(String::from("Home Locality")),
        Some(String::from("Home Region")),
        Some(String::from("Home Code")),
        Some(String::from("Home Country")),
    ));
    contact.home_address.as_mut().unwrap().geo = Some(Geo::new(1_f64, 2_f64));
    contact.work_address = Some(Address::new(
        Some(String::from("Work Street")),
        Some(String::from("Work Locality")),
        Some(String::from("Work Region")),
        Some(String::from("Work Code")),
        Some(String::from("Work Country")),
    ));

    contact
}

#[test]
fn add_to_db() -> Result<(), Box<dyn std::error::Error>> {
    // Connect to the database
    use schema::contacts;
    dotenv()?;

    let db_url = env::var("DATABASE_URL").expect("DATABASE_URL MUST BE SET");

    let connection = PgConnection::establish(&db_url)?;

    // Create a UUID for the contact.
    let uid = uuid::Uuid::new_v4().to_string();

    // Create a `NewContact`, so that we can insert it into the database.
    let new_contact: NewContact = NewContact::new(Name::new(
        Some(String::from(String::from("John"))),
        None,
        Some(String::from(String::from("Doe"))),
        None,
        None,
    ));

    // Create the proper contact
    let mut contact = create_a_contack();
    contact.uid = uid;

    // Insert it into the database
    diesel::insert_into(contacts::table)
        .values(&contact)
        .execute(&connection)?;

    Ok(())
}
