extern crate vcard;
use vcard::VCard;
use contack::*;
use std::convert::TryInto;
fn main() -> Result<(), Box<dyn std::error::Error>> {
    // Creates a Contact
    let mut contact = Contact::new (
        crate::name::Name {
            given :         Some("John".to_string()),
            additional :    None,
            family :        Some("Toohey".to_string()),
            prefixes :      None,
            suffixes :      None,
        }
    );
    // Sets the email
    contact.contact_information.push (
        ContactInformation::new (
            "john_t@mailo.com".to_string(),
            ContactPlatform::Email
        )
    );
    // Turns it to a vCard
    let vcontact: VCard = contact.try_into()?;

    // Prints it out
    println!("{}", vcontact);
    Ok(())
}
