//! These tests test for reading and writing to sql.

#[macro_use]
extern crate diesel;
extern crate dotenv;

use diesel::prelude::*;
use diesel::pg::PgConnection;
use dotenv::dotenv;
use std::env;
use contack::diesel_contact::*;
use contack::*;
use std::convert::TryInto;

pub fn establish_connection() -> PgConnection {
    dotenv().ok();

    let database_url = env::var("DATABASE_URL")
        .expect("DATABASE_URL must be set");
    PgConnection::establish(&database_url)
        .expect(&format!("Error connecting to {}", database_url))
}

#[test]
fn create_contact() -> Result<(), Box<dyn std::error::Error>> {
    use contack::schema;

    // Grab a connection
    let conn = establish_connection();

    // Create a contact.
    let new_contact = NewDieselContact::new(
        Name::new(
            Some(String::from("John")),
            Some(String::from("M")),
            Some(String::from("Doe")),
            Some(String::from("Mr")),
            None
        )
    );

    // Inserts it into the database.
    let diesel_contact: DieselContact = diesel::insert_into(schema::contacts::table)
        .values(new_contact.clone())
        .get_result(&conn)?;

    // Checks the contact equals the correct thing.
    assert_eq!(DieselContact::from(new_contact), diesel_contact);

    // Get a normal contact.
    let mut contact: Contact = diesel_contact.try_into()?;

    Ok(())
}
