Packaging
=========

This file contains quick reminders and notes on how to package Constellation.

We consider here the packaging flow of Constellation version `1.0.0` for Linux.

1. **How to bump Constellation version before a release:**
    1. Bump version in `Cargo.toml` to `1.0.0`
    2. Execute `cargo update` to bump `Cargo.lock`

2. **How to update Constellation on Crates:**
    1. Publish package on Crates: `cargo publish --no-verify`

3. **How to build Constellation, package it and release it on GitHub (multiple architectures):**
    1. Install the cross-compilation utility: `cargo install cross`
    2. Release all binaries: `./scripts/release_binaries.sh --version=1.0.0`
    3. Publish all the built archives on the [releases](https://github.com/valeriansaliou/constellation/releases) page on GitHub

4. **How to update Docker image:**
    1. `docker build .`
    2. `docker tag [DOCKER_IMAGE_ID] valeriansaliou/constellation:v1.0.0` (insert the built image identifier)
    3. `docker push valeriansaliou/constellation:v1.0.0`
