#![allow(non_upper_case_globals)]

use crate::{units, Quantity};

// base

/// 1 meter
pub const m: Quantity<{ units::m }> = Quantity { raw_value: 1.0 };

/// 1 kilogram
pub const kg: Quantity<{ units::kg }> = Quantity { raw_value: 1.0 };

/// 1 second
pub const s: Quantity<{ units::s }> = Quantity { raw_value: 1.0 };

/// 1 ampere
pub const A: Quantity<{ units::A }> = Quantity { raw_value: 1.0 };

/// 1 kelvin
pub const K: Quantity<{ units::K }> = Quantity { raw_value: 1.0 };

/// 1 mole
pub const mol: Quantity<{ units::mol }> = Quantity { raw_value: 1.0 };

/// 1 candela
pub const cd: Quantity<{ units::cd }> = Quantity { raw_value: 1.0 };

// random selection of scaled values

/// 1 centimeter
pub const cm: Quantity<{ units::m }> = Quantity { raw_value: 0.01 };

/// 1 millimeter
pub const mm: Quantity<{ units::m }> = Quantity { raw_value: 0.001 };

/// 1 kilomet
pub const km: Quantity<{ units::m }> = Quantity { raw_value: 1000.0 };

/// 1 gram
pub const g: Quantity<{ units::kg }> = Quantity { raw_value: 0.001 };

/// 1 millisecond
pub const ms: Quantity<{ units::s }> = Quantity { raw_value: 0.001 };

/// 1 minute
pub const min: Quantity<{ units::s }> = Quantity { raw_value: 60.0 };

/// 1 hour
pub const h: Quantity<{ units::s }> = Quantity { raw_value: 3600.0 };

// random selection of derived values

/// 1 newton
pub const N: Quantity<{ units::N }> = Quantity { raw_value: 1.0 };

/// 1 pascal
pub const Pa: Quantity<{ units::Pa }> = Quantity { raw_value: 1.0 };

/// 1 joule
pub const J: Quantity<{ units::J }> = Quantity { raw_value: 1.0 };

/// 1 watt
pub const W: Quantity<{ units::W }> = Quantity { raw_value: 1.0 };

/// 1 coulomb
pub const C: Quantity<{ units::C }> = Quantity { raw_value: 1.0 };

/// 1 volt
pub const V: Quantity<{ units::V }> = Quantity { raw_value: 1.0 };

/// 1 farad
pub const F: Quantity<{ units::F }> = Quantity { raw_value: 1.0 };

/// 1 ohm
pub const ohm: Quantity<{ units::ohm }> = Quantity { raw_value: 1.0 };

/// 1 ohm
#[cfg(feature = "non_ascii")]
#[doc(cfg(feature = "non_ascii"))]
pub const Ω: Quantity<{ units::Ω }> = Quantity { raw_value: 1.0 };

/// 1 siemens
pub const S: Quantity<{ units::S }> = Quantity { raw_value: 1.0 };

/// 1 weber
pub const Wb: Quantity<{ units::Wb }> = Quantity { raw_value: 1.0 };

/// 1 tesla
pub const T: Quantity<{ units::T }> = Quantity { raw_value: 1.0 };

/// 1 henry
pub const H: Quantity<{ units::H }> = Quantity { raw_value: 1.0 };

/// 1 lux
pub const lx: Quantity<{ units::lx }> = Quantity { raw_value: 1.0 };

/// 1 square meter
pub const sq_m: Quantity<{ units::sq_m }> = Quantity { raw_value: 1.0 };

/// 1 cubic meter
pub const cu_m: Quantity<{ units::cu_m }> = Quantity { raw_value: 1.0 };
