#![allow(non_upper_case_globals)]

use super::SiUnit;

const NONE: SiUnit = SiUnit { m: 0, kg: 0, s: 0, A: 0, K: 0, mol: 0, cd: 0 };

// base units

/// meter
pub const m: SiUnit = SiUnit { m: 1, ..NONE };

/// kilogram
pub const kg: SiUnit = SiUnit { kg: 1, ..NONE };

/// second
pub const s: SiUnit = SiUnit { s: 1, ..NONE };

/// ampere
pub const A: SiUnit = SiUnit { A: 1, ..NONE };

/// kelvin
pub const K: SiUnit = SiUnit { K: 1, ..NONE };

/// mole
pub const mol: SiUnit = SiUnit { mol: 1, ..NONE };

/// candela
pub const cd: SiUnit = SiUnit { cd: 1, ..NONE };

/// hertz
pub const Hz: SiUnit = SiUnit { s: -1, ..NONE };

// random selection of derived units

/// newton
pub const N: SiUnit = SiUnit { m: 1, kg: 1, s: -2, ..NONE };

/// pascal
pub const Pa: SiUnit = SiUnit { m: -1, kg: 1, s: -1, ..NONE };

/// joule
pub const J: SiUnit = SiUnit { m: 2, kg: 1, s: -2, ..NONE };

/// watt
pub const W: SiUnit = SiUnit { m: 2, kg: 1, s: -3, ..NONE };

/// coulomb
pub const C: SiUnit = SiUnit { s: 1, A: 1, ..NONE };

/// volt
pub const V: SiUnit = SiUnit { m: 2, kg: 1, s: -3, A: -1, ..NONE };

/// farad
pub const F: SiUnit = SiUnit { m: -2, kg: -1, s: 4, A: 2, ..NONE };

/// ohm
pub const ohm: SiUnit = SiUnit { m: 2, kg: 1, s: -3, A: -2, ..NONE };

/// ohm
#[cfg(feature = "non_ascii")]
#[doc(cfg(feature = "non_ascii"))]
pub const Ω: SiUnit = SiUnit { m: 2, kg: 1, s: -3, A: -2, ..NONE };

/// siemens
pub const S: SiUnit = SiUnit { m: -2, kg: -1, s: 3, A: 2, ..NONE };

/// weber
pub const Wb: SiUnit = SiUnit { m: 2, kg: 1, s: -2, A: -1, ..NONE };

/// tesla
pub const T: SiUnit = SiUnit { kg: 1, s: -2, A: -1, ..NONE };

/// henry
pub const H: SiUnit = SiUnit { m: 2, kg: 1, s: -2, A: -2, ..NONE };

/// lux
pub const lx: SiUnit = SiUnit { m: -2, cd: 1, ..NONE };

/// square meter
pub const sq_m: SiUnit = SiUnit { m: 2, ..NONE };

/// cubic meter
pub const cu_m: SiUnit = SiUnit { m: 3, ..NONE };
