# Proof of Concept: Physical units through const generics

Like a tiny [uom](https://crates.io/crates/uom) with somewhat better error messages!

Correct usage:

```rust
#![feature(const_generics, const_evaluatable_checked)]
use const_unit_poc::values::{cm, kg, m, s, N};

let distance = 1.0 * m;
let mass = 18.0 * kg;
let force = distance * mass / (1.8 * s * 2.0 * s);
assert_eq!(force, 5.0 * N);

let mut mutable_distance = 3.2 * m;
mutable_distance -= 20.0 * cm;
mutable_distance += 2.0 * m;

assert_eq!(mutable_distance, 5.0 * m);
```

Wrong usage:

```rust
#![feature(const_generics, const_evaluatable_checked)]
use const_unit_poc::values::{kg, m};

let mut distance = 15.0 * m;
distance = 2.0 * kg;
```

```
error[E0308]: mismatched types
 --> src/some_module.rs:8:16
  |
8 |     distance = 2.0 * kg;
  |                ^^^^^^^^ expected `1_i8`, found `0_i8`
  |
  = note: expected struct `Quantity<SiUnit { m: 1_i8, kg: 0_i8, s: 0_i8, A: 0_i8, K: 0_i8, mol: 0_i8, cd: 0_i8 }>`
             found struct `Quantity<SiUnit { m: 0_i8, kg: 1_i8, s: 0_i8, A: 0_i8, K: 0_i8, mol: 0_i8, cd: 0_i8 }>`
```
