//! const
//!
//! ```
//!     use const_num_bigint::{ConstBigUint,ConstBigInt,from_slice};
//!     use num_bigint::{BigUint,BigInt,Sign};
//!     const TEST_UINT : &'static ConstBigUint = &ConstBigUint::new(
//!         &from_slice![1,2,3,4,5]
//!     );
//!     let biguint = BigUint::from_slice(&[1,2,3,4,5]);
//!     assert!(&biguint==TEST_UINT.to_biguint());
//!     const TEST_INT : &'static ConstBigInt = &ConstBigInt::new(
//!         Sign::Plus,
//!         &from_slice![1,2,3,4,5]
//!     );
//!     let bigint = BigInt::from_biguint(Sign::Plus,biguint);
//!     assert!(&bigint==TEST_INT.to_bigint());
//! ```
//!
//!

use const_std_vec::ConstVec;
use num_bigint::{BigInt, BigUint, Sign};
use std::{fmt::Debug, mem::transmute};

#[derive(Debug)]
pub struct ConstBigInt {
    _sign: Sign,
    _data: ConstBigUint,
}

#[derive(Debug)]
pub struct ConstBigUint {
    _data: Vec<usize>,
}

impl ConstBigUint {
    #[inline]
    pub const fn new<const N: usize>(arr: &'static [usize; N]) -> Self {
        ConstBigUint {
            _data: ConstVec::new(arr).as_vec(),
        }
    }
    #[inline]
    pub const fn to_biguint(&'static self) -> &'static BigUint {
        unsafe { transmute(self) }
    }
}

impl ConstBigInt {
    #[inline]
    pub const fn new<const N: usize>(sign: Sign, arr: &'static [usize; N]) -> Self {
        ConstBigInt {
            _sign: sign,
            _data: ConstBigUint::new(arr),
        }
    }
    #[inline]
    pub const fn to_bigint(&'static self) -> &'static BigInt {
        unsafe { transmute(self) }
    }
}

#[cfg(target_pointer_width = "64")]
#[macro_export]
macro_rules! from_slice {
    ($($lo:expr,$hi:expr),*) => {
        {
            [ $( ($lo) + (($hi)<<32) ),* ]
        }
    };
    ( $firstlo:expr $(,$hi:expr,$lo:expr)* ) => {
        {
            [ ($firstlo) $( + (($hi)<<32) , ($lo) )* ]
        }
    };
}

#[cfg(target_pointer_width = "32")]
#[macro_export]
macro_rules! from_slice {
    ( $firstlo:expr $(,$hi:expr,$lo:expr)* ) => {
        {
            [ ($firstlo) $( , ($hi) , ($lo) )* ]
        }
    };
    ($($lo:expr,$hi:expr),*) => {
        {
            [ $( ($lo) , ($hi) ),* ]
        }
    };
}
