//! This module tests for errors that happen in the expanded code,
//! errors detectable by the macro itself are tested in the proc macro crate.

#![allow(non_camel_case_types)]

///
/// ```rust
///
/// struct Foo<T>(T);
///
/// const_format::impl_fmt!{
///     impl[T,] Foo<T>
///     where[T: 'static,];
///
///     fn foo(){}
///
/// }
/// ```
///
/// ```compile_fail
///
/// struct Foo<T>(T);
///
/// const_format::impl_fmt!{
///     impl[T,] Foo<T>
///     where[asodkaspodaoskd,];
///
///     fn foo(){}
/// }
/// ```
///
/// ```compile_fail
///
/// struct Foo<T>(T);
///
/// const_format::impl_fmt!{
///     impl[T,] Foo<T>
///     where[T: T];
///
///     fn foo(){}
/// }
/// ```
///
pub struct ImplFmtWhereClause;

///
/// ```rust
/// #![feature(const_mut_refs)]
///
/// #[derive(const_format::ConstDebug)]
/// struct Foo<T>(*const T)
/// where T: 'static;
///
/// fn main(){}
/// ```
///
/// ```compile_fail
/// #![feature(const_mut_refs)]
///
/// #[derive(const_format::ConstDebug)]
/// struct Foo<T>(*const T)
/// where AAAA: AAAA;
///
/// fn main(){}
/// ```
///
#[cfg(feature = "derive")]
pub struct ConstDebugWhereClause;

/// ```rust
/// #![feature(const_mut_refs)]
///
/// use const_format::StrWriterMut;
///
/// let mut len = 0;
/// let mut buffer = [0; 128];
///
/// let mut writer = StrWriterMut::from_custom(&mut buffer, &mut len);
///
/// writer.write_str("hello").unwrap();
///
/// assert_eq!(writer.as_bytes(), b"hello")
///
/// ```
///
/// ```compile_fail
/// #![feature(const_mut_refs)]
///
/// use const_format::StrWriterMut;
///
/// let mut len = 0;
/// let mut buffer = [0; 128];
///
/// let mut writer = StrWriterMut::from_custom(&mut buffer, &mut len);
///
/// writer.write_str("hello").unwrap();
///
/// assert_eq!(writer.as_str(), "hello")
///
/// ```
///
pub struct AsStr_For_StrWriterMut_NoEncoding;

/// ```rust
/// #![feature(const_mut_refs)]
///
/// const_format::assertc!(true, "foo");
///
/// ```
///
/// ```compile_fail
/// #![feature(const_mut_refs)]
///
/// const_format::assertc!(false, "foo");
///
/// ```
///
/// # With a Formatting argument
///
/// ```rust
/// #![feature(const_mut_refs)]
///
/// const_format::assertc!(
///     true,
///     "{foo}\n{foo:#?}\n{}",
///     |fmt| { const_format::call_debug_fmt!(array, [100u8], fmt ) },
///     foo = |fmt| { const_format::call_debug_fmt!(array, [(), ()], fmt ) },
/// );
///
/// const_format::assertc!(
///     true,
///     "{foo}\n{foo:#?}\n{}",
///     |fmt| const_format::call_debug_fmt!(array, [100u8], fmt ),
///     foo = |fmt| const_format::call_debug_fmt!(array, [(), ()], fmt ),
/// );
///
/// ```
///
/// ```compile_fail
/// #![feature(const_mut_refs)]
///
/// const_format::assertc!(
///     false,
///     "{foo}\n{foo:#?}\n{}",
///     |fmt| { const_format::call_debug_fmt!(array, [100u8], fmt ) },
///     foo = |fmt| { const_format::call_debug_fmt!(array, [(), ()], fmt ) },
/// );
///
/// const_format::assertc!(
///     false,
///     "{foo}\n{foo:#?}\n{}",
///     |fmt| const_format::call_debug_fmt!(array, [100u8], fmt ),
///     foo = |fmt| const_format::call_debug_fmt!(array, [(), ()], fmt ),
/// );
///
/// ```
///
#[cfg(feature = "assert")]
pub struct Assert;

/// # assert_eq
///
/// ```rust
/// #![feature(const_mut_refs)]
///
/// const_format::assertc_eq!(0u8, 0u8, "foo");
///
/// ```
///
/// ```compile_fail
/// #![feature(const_mut_refs)]
///
/// const_format::assertc_eq!(0u8, 10u8, "foo");
///
/// ```
///
/// # assert_ne
///
/// ```rust
/// #![feature(const_mut_refs)]
///
/// const_format::assertc_ne!(0u8, 10u8, "foo");
///
/// ```
///
/// ```compile_fail
/// #![feature(const_mut_refs)]
///
/// const_format::assertc_ne!(0u8, 0u8, "foo");
///
/// ```
///
#[cfg(feature = "assert")]
pub struct AssertCmp;
