use core::fmt:: { self, Debug, Display };
#[cfg(feature = "std")]
use std::error::Error;

#[derive(Clone, Copy, Debug)]
pub enum ConversionError {
    NotF64,
    NotI32,
    ZeroDivide,
    Overflow,
}

impl Display for ConversionError {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> Result<(), fmt::Error> {
        Debug::fmt(self, f)
    }
}

#[cfg(feature = "std")]
impl Error for ConversionError {}