# Description
Utilities for calculating floating point constants in const context.

This package is not intented heavy numerial calculation but just evaluating floating point constants in const contest.

# Badges
[![Latest Release](https://gitlab.com/fton/const-frac/-/badges/release.svg)](https://gitlab.com/fton/const-frac/-/releases)
[![pipeline status](https://gitlab.com/fton/const-frac/badges/main/pipeline.svg)](https://gitlab.com/fton/const-frac/-/commits/main)
[![coverage report](https://gitlab.com/fton/const-frac/badges/main/coverage.svg)](https://gitlab.com/fton/const-frac/-/commits/main)

# Usage
```
use ::const_frac::Frac;

const RAD2DEG: f64 = Frac::from_ratio(360, 2, 0).mul(Frac::from_exp_pi(-1)).to_f64();

assert_eq!(RAD2DEG * std::f64::consts::PI, 180f64);
```
## Project status
This package is in the very early stage.