#![doc = include_str!("../README.md")]
use proc_macro::TokenStream;
use syn::parse_macro_input;
use quote::quote;

mod sorted;
mod keywords;

use keywords:: { TransitionTableInfo, TransitionTableBody };
use sorted::SortedTable;

#[proc_macro_attribute]
pub fn sorted(_args: TokenStream, input: TokenStream) -> TokenStream {
    let result = parse_macro_input!(input as SortedTable);

    quote! { #result }.into()
}

#[proc_macro_attribute]
pub fn keywords(args: TokenStream, input: TokenStream) -> TokenStream {
    let mut result = input.clone();
    let info = parse_macro_input!(args as TransitionTableInfo);
    let body = parse_macro_input!(input as TransitionTableBody);

    result.extend(Into::<TokenStream>::into(quote! { #info #body }));
    result
}