use crate::elem::{use_element, HtmlProps, UseElementArgs};
use consecuit::prelude::{ComponentBuilder, ContainerReturn};
use web_sys::HtmlObjectElement;
pub fn object(cc: ComponentBuilder, props: HtmlProps<HtmlObjectElement>) -> impl ContainerReturn {
    let cc = cc.init();
    let parent = cc.get_parent_node();
    let (cc, elem) = cc.hook(
        use_element::<HtmlObjectElement>,
        UseElementArgs {
            tag_name: "object",
            props,
            parent,
        },
    );
    cc.bare_container_node(elem.into())
}
