use crate::elem::{use_element, HtmlProps, UseElementArgs};
use consecuit::prelude::{ComponentBuilder, ContainerReturn};
use web_sys::HtmlHrElement;
pub fn hr(cc: ComponentBuilder, props: HtmlProps<HtmlHrElement>) -> impl ContainerReturn {
    let cc = cc.init();
    let parent = cc.get_parent_node();
    let (cc, elem) = cc.hook(
        use_element::<HtmlHrElement>,
        UseElementArgs {
            tag_name: "hr",
            props,
            parent,
        },
    );
    cc.bare_container_node(elem.into())
}
