use crate::elem::{use_element, HtmlProps, UseElementArgs};
use consecuit::prelude::{ComponentBuilder, ContainerReturn};
use web_sys::HtmlButtonElement;
pub fn button(cc: ComponentBuilder, props: HtmlProps<HtmlButtonElement>) -> impl ContainerReturn {
    let cc = cc.init();
    let parent = cc.get_parent_node();
    let (cc, elem) = cc.hook(
        use_element::<HtmlButtonElement>,
        UseElementArgs {
            tag_name: "button",
            props,
            parent,
        },
    );
    cc.bare_container_node(elem.into())
}
