//! This module contains transport definitions for the sources and destinations implemented in ConnectorX.

#[cfg(all(feature = "src_csv", feature = "dst_arrow"))]
mod csv_arrow;
#[cfg(all(feature = "src_dummy", feature = "dst_arrow"))]
mod dummy_arrow;
#[cfg(all(feature = "src_mssql", feature = "dst_arrow"))]
mod mssql_arrow;
#[cfg(all(feature = "src_mysql", feature = "dst_arrow"))]
mod mysql_arrow;
#[cfg(all(feature = "src_postgres", feature = "dst_arrow"))]
mod postgres_arrow;
#[cfg(all(feature = "src_sqlite", feature = "dst_arrow"))]
mod sqlite_arrow;

#[cfg(all(feature = "src_csv", feature = "dst_arrow"))]
pub use csv_arrow::CSVArrowTransport;
#[cfg(all(feature = "src_dummy", feature = "dst_arrow"))]
pub use dummy_arrow::DummyArrowTransport;
#[cfg(all(feature = "src_mssql", feature = "dst_arrow"))]
pub use mssql_arrow::{MsSQLArrowTransport, MsSQLArrowTransportError};
#[cfg(all(feature = "src_mysql", feature = "dst_arrow"))]
pub use mysql_arrow::{MySQLArrowTransport, MySQLArrowTransportError};
#[cfg(all(feature = "src_postgres", feature = "dst_arrow"))]
pub use postgres_arrow::{PostgresArrowTransport, PostgresArrowTransportError};
#[cfg(all(feature = "src_sqlite", feature = "dst_arrow"))]
pub use sqlite_arrow::{SQLiteArrowTransport, SQLiteArrowTransportError};
