use crate::ckey::CKey;

use std::cmp::Ordering;

#[derive(Debug, PartialEq, Eq)]
struct CKeyCmp {
    start: CKey,
    key: CKey,
    diff: CKey,
}

impl CKeyCmp {
    fn new(start: CKey, key: CKey) -> CKeyCmp {
        CKeyCmp {
            start,
            key,
            diff: key - start,
        }
    }
}

impl std::cmp::PartialOrd for CKeyCmp {
    fn partial_cmp(&self, other: &Self) -> Option<Ordering> {
        if *self == *other {
            return Some(Ordering::Equal);
        }
        // [TODO] implement this
        None
    }
}
