use std::collections::HashMap;
// Request keys: [ 'cf',  'fetcher',  'redirect',  'headers',  'url',  'method',  'bodyUsed',  'body' ]
#[derive(Deserialize, Serialize)]
pub struct Request {
    pub url: String,
    pub method: String,
    pub body: String,
    pub cf: HashMap<String, String>,
    pub headers: HashMap<String, String>,
}

#[derive(Deserialize, Serialize)]
pub struct Response {
    pub status: u16,
    pub headers: HashMap<String, String>,
    pub body: String,
}

#[derive(Clone, PartialEq)]
pub enum Method {
    Get,
    Head,
    Post,
    Put,
    Delete,
    Connect,
    Options,
    Trace,
    Patch,
}
