# Confetti 🎉

## Fun with CloudFlare Workers

### 🐑 Use `wrangler generate` to Clone this Template

[Learn more about `wrangler generate` here.](https://github.com/cloudflare/wrangler)

```
wrangler generate wasm-worker https://github.com/pinatasoftware/confetti-template.git
cd wasm-worker
```

### 🎉 Confeti helps with requests


#### Routes

Each route has a pattern a list of middlewares:

```rust
Route {
    pattern: (Method::Get, "/"),
    middlewares: vec![fetch_session, validate_user, home],
},
```

Each middleware is run one after the other. If any middleware halts then the response is sent immediately and all remaining middlewares will not run

#### Middlewares

Middlewares are async functions that receive and return a Conn

```rust
pub async fn hello(conn: Conn) -> Conn {
    let mut headers = conn.resp_headers;
    headers.insert("Content-Type".to_string(), "text/html".to_string());
    let content = "<h1>Hello World from Confetti</h1>";
    return Conn {
        resp_headers: headers,
        resp_body: content.to_string(),
        status: 200,
        ..conn
    };
}
```

#### The Conn struct

```rust
pub struct Conn {
    // Request
    pub host: String,
    pub method: Method,
    pub port: u16,
    pub scheme: String,
    pub path: String,
    pub query_string: String,
    pub req_body: String,
    pub req_headers: HashMap<String, String>,
    pub cf: HashMap<String, String>,
    // Response
    pub resp_body: String,
    pub resp_headers: HashMap<String, String>,
    pub status: u16,
    // Connection
    pub assigns: HashMap<String, String>,
    pub halted: bool,
}
```

### 🛠️ Build with `wasm-pack build`

```
wasm-pack build
```

### 🔬 Test in Headless Browsers with `wasm-pack test`

```
wasm-pack test --headless --firefox
```

