use std::io::{self, Read};
use structopt::StructOpt;
use colored::*;
use failure::ResultExt;
use exitfailure::ExitFailure;

const CONEMAN : &str = 
"
                                      _L/L
                                    _LT/l_L_
                                  _LLl/L_T_lL_
              _T/L              _LT|L/_|__L_|_L_
            _Ll/l_L_          _TL|_T/_L_|__T__|_l_
          _TLl/T_l|_L_      _LL|_Tl/_|__l___L__L_|L_
        _LT_L/L_|_L_l_L_  _'|_|_|T/_L_l__T _ l__|__|L_
      _Tl_L|/_|__|_|__T _LlT_|_Ll/_l_ _|__[ ]__|__|_l_L_
   _ _LT_l_l/|__|__l_T _T_L|_|_|l/___|__ | _l__|_ |__|_T_L_  __
   .  .:::.:::..:::.;;;;:;;:.;.;;;;,;;:,;;;.;:,;;,;::;:.'
   . ,::.:::.:..:.: ::.::::;..:,:::,::::.::::.:;:.:..
      . .:.:::.:::.:::: .::.::. :::.::::..::..:.::. . .
        . ::.:.: :. .:::  ::::.::.:::.::...:. .:::. .
            .:. ..   . ::.. .: ::. ::::.:: ::::::.   .
            .  :.         .. :::.::: ::.::::. ::. .
              . .           .:. :.. :::. ::..: :.


  _____                                       
 / ____|                                      
| |     ___  _ __   ___ _ __ ___   __ _ _ __  
| |    / _ \\| '_ \\ / _ \\ '_ ` _ \\ / _` | '_ \\ 
| |___| (_) | | | |  __/ | | | | | (_| | | | |
 \\_____\\___/|_| |_|\\___|_| |_| |_|\\__,_|_| |_|

 -------------------------
 | Created by the Conemen! |
  -------------------------
   \\  /
    \\/

";

const POKEBALL : &str = 
"                        /\
   ___                  /  \\                  ___
  /   \\     __         /    \\         __     /
 /     \\   /  \\   _   / <()> \\   _   /  \\   /
        \\_/    \\_/ \\_/________\\_/ \\_/    \\_/
  __________________/__I___I___\\________________
                   /_I___I___I__\
                  /I___I___I___I_\
                 /___I___I___I___I\
                /__I___I___I___I___\
               /_I___I___I___I___I__\
              /I___I___I___I___I___I_\
             /___I___I___I___I___I___I\
            /__I___I___I___I___I___I___\
           /_I___I___I___I___I___I___I__\\";

#[derive(StructOpt)]
struct Options {
    #[structopt(default_value = "Created by the Conemen!")]
    /// Pika Pika?
    message: String,

    #[structopt(short = "p", long = "pokeball")]
    /// Pika...
    pokeball: bool,


    #[structopt(short = "f", long = "file", parse(from_os_str))]
    /// Use your own ASCII CONEMAN from a file.
    file: Option<std::path::PathBuf>,

    #[structopt(short = "i", long = "stdin")]
    /// Read the message from STDIN
    stdin: bool,
}

fn main() -> Result<(), ExitFailure> {
    let options = Options::from_args();
    let mut message = "".to_string();
    if options.stdin {
        io::stdin().read_to_string(&mut message)?;
        message.pop();
    } else {
        message = options.message;
    }
    if options.pokeball {
        println!("{}", POKEBALL.to_string().red());
    }
    else {
        match &options.file {
            Some(path) => {
                let alt = std::fs::read_to_string(path)
                    .with_context(|_| format!("could not read file {:?}", path))?;
                println!("{}", alt.bright_yellow());
            }
            None => {
                println!("{}", CONEMAN.to_string().bright_green());
            }
        }
    }
    Ok(())
}
