use compute::timeseries::{acf, acovf};
use criterion::{black_box, criterion_group, criterion_main, Criterion};

pub fn criterion_tsfuncs(c: &mut Criterion) {
    let data: Vec<f64> = vec![
        -213.0, -564.0, -35.0, -15.0, 141.0, 115.0, -420.0, -360.0, 203.0, -338.0, -431.0, 194.0,
        -220.0, -513.0, 154.0, -125.0, -559.0, 92.0, -21.0, -579.0, -52.0, 99.0, -543.0, -175.0,
        162.0, -457.0, -346.0, 204.0, -300.0, -474.0, 164.0, -107.0, -572.0, -8.0, 83.0, -541.0,
        -224.0, 180.0, -420.0, -374.0, 201.0, -236.0, -531.0, 83.0, 27.0, -564.0, -112.0, 131.0,
        -507.0, -254.0, 199.0, -311.0, -495.0, 143.0, -46.0, -579.0, -90.0, 136.0, -472.0, -338.0,
        202.0, -287.0, -477.0, 169.0, -124.0, -568.0, 17.0, 48.0, -568.0, -135.0, 162.0, -430.0,
        -422.0, 172.0, -74.0, -577.0, -13.0, 92.0, -534.0, -243.0, 194.0, -355.0, -465.0, 156.0,
        -81.0, -578.0, -64.0, 139.0, -449.0, -384.0, 193.0, -198.0, -538.0, 110.0, -44.0, -577.0,
        -6.0, 66.0, -552.0, -164.0, 161.0, -460.0, -344.0, 205.0, -281.0, -504.0, 134.0, -28.0,
        -576.0, -118.0, 156.0, -437.0, -381.0, 200.0, -220.0, -540.0, 83.0, 11.0, -568.0, -160.0,
        172.0, -414.0, -408.0, 188.0, -125.0, -572.0, -32.0, 139.0, -492.0, -321.0, 205.0, -262.0,
        -504.0, 142.0, -83.0, -574.0, 0.0, 48.0, -571.0, -106.0, 137.0, -501.0, -266.0, 190.0,
        -391.0, -406.0, 194.0, -186.0, -553.0, 83.0, -13.0, -577.0, -49.0, 103.0, -515.0, -280.0,
        201.0, 300.0, -506.0, 131.0, -45.0, -578.0, -80.0, 138.0, -462.0, -361.0, 201.0, -211.0,
        -554.0, 32.0, 74.0, -533.0, -235.0, 187.0, -372.0, -442.0, 182.0, -147.0, -566.0, 25.0,
        68.0, -535.0, -244.0, 194.0, -351.0, -463.0, 174.0, -125.0, -570.0, 15.0, 72.0, -550.0,
        -190.0, 172.0, -424.0, -385.0, 198.0, -218.0, -536.0, 96.0,
    ];
    c.bench_function("autocorrelation function up to lag 50", |b| {
        b.iter(|| {
            (0..50)
                .into_iter()
                .map(|i| acf(black_box(&data), i))
                .collect::<Vec<_>>()
        });
    });
    c.bench_function("autocovariance function up to lag 50", |b| {
        b.iter(|| {
            (0..50)
                .into_iter()
                .map(|i| acovf(black_box(&data), i))
                .collect::<Vec<_>>()
        });
    });
}

criterion_group!(benches, criterion_tsfuncs);
criterion_main!(benches);
