# Competitive Programming Snippets in Rust

[![Continuous integration](https://github.com/kenkoooo/competitive-programming-rs/actions/workflows/ci.yml/badge.svg)](https://github.com/kenkoooo/competitive-programming-rs/actions/workflows/ci.yml)
[![Latest version](https://img.shields.io/crates/v/competitive-programming-rs.svg)](https://crates.io/crates/competitive-programming-rs)

This is a repository of a set of algorithms implemented in Rust. 

- Designed to solve problems quickly in programming competitions.
- Well-tested.

## [Data Structures](./src/data_structure)
- [BitSet](./src/data_structure/bitset.rs)
- [Fenwick Tree](./src/data_structure/fenwick_tree.rs)
- [Fibonacci Heap](./src/data_structure/fibonacci_heap.rs)
- [Lazy Segment Tree](./src/data_structure/lazy_segment_tree.rs)
- [Persistent Array](./src/data_structure/persistent_array.rs)
- [Segment Tree](./src/data_structure/segment_tree.rs)
- [Sparse Table](./src/data_structure/sparse_table.rs)
- [Suffix Array](./src/data_structure/suffix_array.rs)
- [Treap](./src/data_structure/treap.rs)
- [Union-Find tree](./src/data_structure/union_find.rs)

## [Geometry](./src/geometry)
- [Algorithms for circles](./src/geometry/circle.rs)
- [Convex Hull](./src/geometry/convex_hull.rs)
- [Minimum Bounding Circle](./src/geometry/minimum_bounding_circle.rs)

## [Graph](./src/graph)
- [Bridge Detection](./src/graph/bridge_detection.rs)
- [Lowest Common Ancestors](./src/graph/lca.rs)
- [Maximum Flow](./src/graph/maximum_flow.rs)
- [Minimum Cost Flow (Primal-Dual)](./src/graph/min_cost_flow.rs)
- [Minimum Cost Flow (cost-scaling)](./src/graph/cost_scaling_push_relabel.rs)
- [Shortest Path (Bellman-Ford)](./src/graph/shortest_path.rs)
- [Strongly Connected Components](./src/graph/strongly_connected_components.rs)

## [Mathematics](./src/math)
- [Chinese Remainder Theorem](./src/math/chinese_remainder_theorem.rs)
- [Combination](./src/math/combination.rs)
- [Cumulative Sum](./src/math/cumulative_sum.rs)
- [Fast Fourier Transform](./src/math/fast_fourier_transform.rs)
- [Floor Sum](./src/math/floor_sum.rs)
- [Lagrange Interpolation](./src/math/lagrange_interpolation.rs)
- [Max Rectangle](./src/math/max_rectangle.rs)
- [Mod Integer](./src/math/mod_int.rs)
- [Next Permutation](./src/math/next_permutation.rs)

## [String](./src/string)
- [Rolling Hash](./src/string/rolling_hash.rs)
- [Z Algorithm](./src/string/z_algorithm.rs)

## [Others](./src/utils)
- [Scanner](./src/utils/scanner.rs)

## Resources
- [Documentation](https://docs.rs/competitive-programming-rs) 
