Compact SQL
===========

A simple macros allows to write SQL queries for Postgres which will be compacted
(and optionally checked) at compile-time.

## Dependency

```toml
[dependencies]
compact_sql = { git = "https://gitlab.com/vitaly.burovoy/compact_sql", branch = "PoC" }
```

### Pretty error

Use `pretty-errors` feature (requires unstable Rust version) if you can get better errors with pointing to a concrete error span.

```toml
[dependencies]
compact_sql = { version = "0.0.1", features = ["pretty-errors"] }
```

## Using Compact SQL

### Generate just an SQL string
```rust
use compact_sql::pg_sql;

fn main() {
    let sql = pg_sql! {
        SELECT
            relname,
            relnamespace,
            format("%I", oid),
        FROM
            pg_catalog.pg_class
        WHERE
            oid = {var_oid}::oid
    };
    assert_eq!(
        sql,
        "SELECT relname,relnamespace,format('%I',oid)FROM pg_catalog.pg_class WHERE oid=$1::oid"
    );
}
```

Note! There are allowed commas between keywords (more convenient for VCS), named parameters in curly
braces are replaced with "$x" Postgres numbered parameters (the same number for the same names).

Common keywords like "SELECT", "AS", etc. are required (as warnings) to be uppercase.

### Test SQL queries

If you want to check queries (via "prepare") you can define ENVs for the DBMS:
* `TEST_PG_HOST`
* `TEST_PG_PORT` (optional; default: 5432)
* `TEST_PG_USER` (optional; default: "postgres")
* `TEST_PG_PASS` (optional; default: "")
* `TEST_PG_DATB`

## License

Licensed under either of

* Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
* MIT license ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally
submitted for inclusion in the work by you, as defined in the Apache-2.0
license, shall be dual licensed as above, without any additional terms or
conditions.
