#[macro_use]
extern crate comn;
use comn::flags;

static V1: flags::optv = option!(None, "x", "exec", None, 8, "help");
static V2: flags::optv = option!("fi", "x", "exec", None, "nice", "help");
static V3: flags::optv = option!("s2", "x", "exec", "file", "ls", "help");

fn main() {
    option_parse!("clap", "v0.1.0");
    let s1: i32 = V1.parse().unwrap();
    println!("{}", s1);

    match V2.parse::<String>() {
        Ok(n) => println!("fi -x {}", n),
        Err(s) => println!("{}", s),
    }

    match V3.str() {
        Ok(n) => println!("s2 -x {}", n),
        Err(s) => println!("{}", s),
    }
}
