#![allow(non_camel_case_types)]

use std::{
    future::{Future, Ready},
    pin::Pin,
    task::{Context, Poll, Waker},
};

mod autex;
mod cond;
mod leadlock;

pub use autex::*;
pub use cond::*;
pub use leadlock::*;

struct context;
impl Future for context {
    type Output = Waker;
    fn poll(self: Pin<&mut Self>, ctx: &mut Context<'_>) -> Poll<Waker> {
        Poll::Ready(ctx.waker().clone())
    }
}

struct sb<T>(pub T);
unsafe impl<T> Send for sb<T> {}
