//! # My Crate
//!
//! `comments` is a collection of utilities to make performing certain
//! calculations more convenient.

/// Adds one to the number given.
///
/// # Examples
///
/// ```
/// let arg = 5;
/// let answer = comments::add_one(arg);
///
/// assert_eq!(6, answer);
/// ```
pub fn add_one(x: i32) -> i32 {
  x + 1
}

pub use self::kinds::{PrimaryColor, SecondaryColor};
pub use self::utils::mix;

pub mod kinds {
  /// The primary colors
  #[derive(Debug, PartialEq)]
  pub enum PrimaryColor {
    Red,
    Yellow,
    Blue,
  }

  /// The secondary colors
  #[derive(Debug, PartialEq)]
  pub enum SecondaryColor {
    Orange,
    Green,
    Purple,
  }
}

pub mod utils {
  use crate::kinds::*;

  /// Combines two primary to make a secondary
  pub fn mix(c1: PrimaryColor, c2: PrimaryColor) -> SecondaryColor {
    let result = match (c1, c2) {
      (PrimaryColor::Red, PrimaryColor::Blue) | (PrimaryColor::Blue, PrimaryColor::Red) => {
        SecondaryColor::Purple
      }
      (PrimaryColor::Red, PrimaryColor::Yellow) | (PrimaryColor::Yellow, PrimaryColor::Red) => {
        SecondaryColor::Orange
      }
      (PrimaryColor::Blue, PrimaryColor::Yellow) | (PrimaryColor::Yellow, PrimaryColor::Blue) => {
        SecondaryColor::Green
      }
      _ => SecondaryColor::Green,
    };
    result
  }
}

#[cfg(test)]
mod tests {
  use super::kinds::*;
  use super::utils::*;

  #[test]
  fn test_mox() {
    let c1 = PrimaryColor::Blue;
    let c2 = PrimaryColor::Red;

    let c3 = mix(c1, c2);

    assert_eq!(c3, SecondaryColor::Purple);
  }
}
