/****** Object:  Schema [acumaticaManufacturing]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [acumaticaManufacturing]
GO
/****** Object:  Schema [acumaticaSandboxManufacturing]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [acumaticaSandboxManufacturing]
GO
/****** Object:  Schema [Fabu\Ilandau]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [Fabu\Ilandau]
GO
/****** Object:  Schema [FABU\jbuchinger]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [FABU\jbuchinger]
GO
/****** Object:  Schema [HangFire]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [HangFire]
GO
/****** Object:  Schema [hangfiresandbox]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [hangfiresandbox]
GO
/****** Object:  Schema [inspection]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [inspection]
GO
/****** Object:  Schema [inventory]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [inventory]
GO
/****** Object:  Schema [manufacturing]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [manufacturing]
GO
/****** Object:  Schema [picking]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [picking]
GO
/****** Object:  Schema [reports]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [reports]
GO
/****** Object:  Schema [uploads]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE SCHEMA [uploads]
GO
/****** Object:  UserDefinedTableType [dbo].[BypassedBlocks]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[BypassedBlocks] AS TABLE(
	[TranEntryId] [int] NOT NULL,
	[BlockId] [int] NULL,
	[BlockType] [int] NULL,
	[LoginId] [nvarchar](128) NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[DoubleVarchar]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[DoubleVarchar] AS TABLE(
	[Value1] [varchar](500) NULL,
	[Value2] [varchar](500) NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[IDList]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[IDList] AS TABLE(
	[ID] [int] NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[InventoryItem]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[InventoryItem] AS TABLE(
	[Itemcode] [varchar](50) NULL,
	[PONumber] [varchar](50) NULL,
	[Qty] [int] NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[ItemCodeStockAndPlanning]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[ItemCodeStockAndPlanning] AS TABLE(
	[StockItemCode] [nvarchar](150) NULL,
	[PlanningItemCode] [nvarchar](150) NOT NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[ItemGroup]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[ItemGroup] AS TABLE(
	[PO] [varchar](50) NULL,
	[ItemCode] [varchar](50) NULL,
	[Qty] [int] NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[ItemHistory]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[ItemHistory] AS TABLE(
	[UserID] [int] NULL,
	[ItemID] [int] NULL,
	[StatusId] [int] NULL,
	[Memo] [nvarchar](255) NULL,
	[LoginId] [nvarchar](128) NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[ItemMemo]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[ItemMemo] AS TABLE(
	[LoginId] [nvarchar](128) NULL,
	[StatusId] [int] NULL,
	[Memo] [nvarchar](255) NULL,
	[AdditionalInfo] [int] NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[KeyValueList]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[KeyValueList] AS TABLE(
	[ID] [int] NULL,
	[Value] [varchar](500) NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[NVARCHARList]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[NVARCHARList] AS TABLE(
	[Value] [nvarchar](500) NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[OrderMaterialDetail]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[OrderMaterialDetail] AS TABLE(
	[InventoryID] [varchar](50) NULL,
	[Quantity] [int] NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[PIList]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[PIList] AS TABLE(
	[Amount] [money] NULL,
	[Description] [nvarchar](500) NULL,
	[Item] [nvarchar](100) NULL,
	[ItemAmountPI] [nvarchar](2) NULL,
	[ItemAmountPO] [nvarchar](2) NULL,
	[PONumber] [int] NULL,
	[Qty] [int] NULL,
	[Rate] [money] NULL,
	[Type] [nvarchar](50) NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[POStages]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[POStages] AS TABLE(
	[Stage] [varchar](100) NULL,
	[ProjectedCompleteDate] [datetime] NULL,
	[IsCompleteed] [bit] NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[QuestionAnswers]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[QuestionAnswers] AS TABLE(
	[InspectionAnswerId] [int] NULL,
	[QuestionId] [int] NULL,
	[AnswerId] [int] NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[SerialList]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[SerialList] AS TABLE(
	[Serial] [varchar](50) NULL
)
GO
/****** Object:  UserDefinedTableType [dbo].[ShortItemCodeList]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[ShortItemCodeList] AS TABLE(
	[Value] [nvarchar](150) NULL,
	INDEX [IX_ShortItemCodeList_Value] NONCLUSTERED 
(
	[Value] ASC
)
)
GO
/****** Object:  UserDefinedTableType [dbo].[StringList]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [dbo].[StringList] AS TABLE(
	[Value] [varchar](500) NULL
)
GO
/****** Object:  UserDefinedTableType [inventory].[ActionOverride]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [inventory].[ActionOverride] AS TABLE(
	[ActionId] [int] NOT NULL,
	[LoginId] [nvarchar](128) NOT NULL,
	[SnAbn] [varchar](50) NULL,
	[OrderItemId] [int] NULL,
	[ItemCode] [varchar](50) NULL,
	[PONumber] [varchar](50) NULL,
	[PalletId] [int] NULL,
	[ApnId] [int] NULL,
	[BlockedPOID] [int] NULL,
	[BlockedSNID] [int] NULL,
	[BlockedABNID] [int] NULL
)
GO
/****** Object:  UserDefinedTableType [inventory].[EtaForComponent]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [inventory].[EtaForComponent] AS TABLE(
	[ETA] [date] NULL,
	[Qty] [int] NOT NULL DEFAULT ((0)),
	[AcumaticaID] [int] NOT NULL,
	[IsContainer] [bit] NOT NULL DEFAULT ((0)),
	[IsMSOrder] [bit] NOT NULL DEFAULT ((0))
)
GO
/****** Object:  UserDefinedTableType [inventory].[ItemsToRefill]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [inventory].[ItemsToRefill] AS TABLE(
	[ItemCode] [nvarchar](150) NOT NULL,
	[Quantity] [int] NOT NULL,
	[LocationTypeId] [int] NULL
)
GO
/****** Object:  UserDefinedTableType [inventory].[SnABNMoveSummary]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [inventory].[SnABNMoveSummary] AS TABLE(
	[ItemCode] [nvarchar](150) NULL,
	[Quantity] [int] NULL,
	[LocationTypeId] [int] NULL,
	[PalletID] [int] NULL,
	[PoNumber] [varchar](50) NULL,
	[DestinationLocationId] [int] NULL,
	[Location] [varchar](50) NULL
)
GO
/****** Object:  UserDefinedTableType [inventory].[StockComponent]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [inventory].[StockComponent] AS TABLE(
	[TranentryId] [int] NOT NULL,
	[RownumAll] [int] NOT NULL,
	[AcumaticaId] [int] NOT NULL,
	[StockAcumaticaId] [int] NOT NULL,
	[Quantity] [int] NOT NULL DEFAULT ((0)),
	[ComponentPartTypeId] [int] NULL,
	[QtyRequired] [int] NOT NULL,
	[SortComponent] [int] NOT NULL,
	[PickingDate] [date] NOT NULL,
	[Revision] [varchar](50) NULL,
	[Eta] [date] NULL,
	[ONContainer] [bit] NOT NULL DEFAULT ((0)),
	[ONINhousePO] [bit] NOT NULL DEFAULT ((0)),
	[Updated] [bit] NOT NULL DEFAULT ((0))
)
GO
/****** Object:  UserDefinedTableType [inventory].[StockRefillInventoryLocationNeedUpdate]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [inventory].[StockRefillInventoryLocationNeedUpdate] AS TABLE(
	[PickDays] [int] NOT NULL,
	[HasFrameTask] [bit] NOT NULL,
	[DoorAtBelt] [bit] NOT NULL,
	[HasPickingTask] [bit] NOT NULL,
	[QuantityNeeded] [int] NOT NULL,
	[DestinationLocationId] [int] NULL,
	[InventoryLocationTypeId] [int] NULL,
	[ItemCode] [nvarchar](150) NOT NULL
)
GO
/****** Object:  UserDefinedTableType [picking].[PickingTaskCreation]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [picking].[PickingTaskCreation] AS TABLE(
	[OrderID] [int] NOT NULL,
	[ItemId] [int] NOT NULL,
	[BucketId] [int] NOT NULL,
	[Active] [bit] NOT NULL,
	[AddTime] [datetime] NOT NULL,
	[UniqKey] [varchar](500) NOT NULL,
	[EstimatedCompleteDate] [date] NOT NULL,
	[Style] [varchar](50) NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[ItemNumber] [varchar](150) NOT NULL,
	[Cubicft] [float] NOT NULL,
	[EZProdID] [varchar](25) NULL,
	[EZParentProdID] [varchar](25) NULL,
	[SOnumber] [nvarchar](50) NULL,
	[CustomerName] [nvarchar](250) NOT NULL,
	[ItemType] [int] NOT NULL,
	[ItemTypeCode] [int] NULL,
	[PickDropLocationID] [int] NULL,
	[PickingDate] [date] NULL,
	[RushOrder] [bit] NOT NULL,
	[Hinge] [varchar](50) NULL,
	[ItemKD] [bit] NOT NULL,
	[Updated] [bit] NULL
)
GO
/****** Object:  UserDefinedTableType [picking].[PickingTaskCreationTemp]    Script Date: 6/17/2021 11:37:56 AM ******/
CREATE TYPE [picking].[PickingTaskCreationTemp] AS TABLE(
	[OrderID] [int] NOT NULL,
	[ItemId] [int] NOT NULL,
	[BucketId] [int] NOT NULL,
	[Active] [bit] NOT NULL,
	[AddTime] [datetime] NOT NULL,
	[UniqKey] [varchar](500) NOT NULL,
	[EstimatedCompleteDate] [date] NOT NULL,
	[Style] [varchar](50) NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[ItemNumber] [varchar](150) NOT NULL,
	[Cubicft] [float] NOT NULL,
	[EZProdID] [varchar](25) NULL,
	[EZParentProdID] [varchar](25) NULL,
	[SOnumber] [nvarchar](50) NULL,
	[CustomerName] [nvarchar](250) NOT NULL,
	[ItemType] [int] NOT NULL,
	[ItemTypeCode] [int] NULL,
	[PickDropLocationID] [int] NULL,
	[PickingDate] [date] NULL,
	[RushOrder] [bit] NOT NULL,
	[Hinge] [varchar](50) NULL,
	[ItemKD] [bit] NOT NULL,
	[Updated] [bit] NULL
)
GO
/****** Object:  UserDefinedFunction [acumaticaManufacturing].[GetCountOfAvailableFGItemsForOrderId]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [acumaticaManufacturing].[GetCountOfAvailableFGItemsForOrderId]
(
	@OrderId INT, 
	@Sandbox BIT = 0
)
RETURNS @ReturnVal TABLE (ShortItemCode NVARCHAR(150), Quantity INT, Hinge VARCHAR(10))
AS
BEGIN

	DECLARE @localOrderId INT = @OrderId
	DECLARE @CountReserved TABLE(ShortItemCode NVARCHAR(150), Quantity INT, Hinge VARCHAR(10))
	DECLARE @CountAvailable TABLE(ShortItemCode NVARCHAR(150), Quantity INT, Hinge VARCHAR(10))
	DECLARE @CountAvailableAbn TABLE(ShortItemCode NVARCHAR(150), Quantity INT)
	DECLARE @OrderItems TABLE (ItemCode VARCHAR(150) NOT NULL , Hinge VARCHAR(10) NOT NULL)

	INSERT @OrderItems(ItemCode,Hinge)
	SELECT te.ItemNumber , ISNULL(te.Hinge,'N') FROM dbo.TranEntry AS te
		WHERE  te.OrderID = @localOrderId AND te.ItemType IN(1,2,3,12)
		GROUP BY ISNULL(te.Hinge, 'N'),te.ItemNumber



	INSERT @CountReserved(ShortItemCode, Quantity, Hinge)
	SELECT til.ShortItemCode, COUNT(*), ISNULL(te.Hinge, 'N')
	FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
	JOIN dbo.[Order] o ON o.ID = te.OrderID
    JOIN dbo.Departmentstatus AS d ON d.ID = o.Departmentstatusid
	JOIN dbo.QuotesStatus AS qs ON o.SOnumber = qs.QuoteNumber
	JOIN picking.OrderItemProductionItemIRelease AS oipiir ON oipiir.OrderItemId = te.ID AND oipiir.Sandbox =@Sandbox
	WHERE
	-- EXISTS
	--(
	--	SELECT * FROM picking.OrderItemProductionItemIRelease AS oipiir
	--	WHERE oipiir.OrderItemId = te.ID
	--	AND oipiir.Revision = 'FG'
	--	--AND oipiir.Completed = 0
	--) 
	--AND 
	--(
	--	(
	--		o.CustomerName <> 'TEST ORDERS' 
	--		AND @Sandbox = 0
	--	)
	--	OR
 --       (
	--		o.CustomerName = 'TEST ORDERS' 
	--		AND @Sandbox <> 0
	--	)
	--)
	--AND 
	te.isActive = 1 
	AND te.isDeleted = 0   
    AND o.isActive = 1 
    AND qs.QuoteStatus = 'SALES ORDER'
    AND d.isShipped = 0 
	AND te.FWPONumber IS NULL
	AND oipiir.Revision = 'FG'
	AND EXISTS
	(
		SELECT * FROM @OrderItems AS oi WHERE oi.ItemCode = te.ItemNumber
		AND 
		(
			ISNULL(te.Hinge, 'N') = oi.Hinge
			OR NOT EXISTS
			(
				SELECT 1 FROM dbo.tb_itemClassDetail icd 
				WHERE icd.ItemCode = til.ShortItemCode 
				AND icd.ClassID = 115
				AND icd.IsActive = 1
			)
		)
	)
	GROUP BY til.ShortItemCode, ISNULL(te.Hinge, 'N')

	INSERT @CountAvailable(ShortItemCode, Quantity, Hinge)
	SELECT til.ShortItemCode, COUNT(*) , ISNULL(tis.Hinge, 'N')
	FROM dbo.tb_ItemSeriel AS tis
	JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = tis.ItemCode
	JOIN dbo.InventoryLocation AS il ON tis.ReceivedLocation = il.Location
	WHERE EXISTS
	(
		SELECT * FROM @OrderItems AS oi WHERE oi.ItemCode = til.ItemCode
		AND 
		(
			oi.Hinge = ISNULL(tis.Hinge, 'N') 
			OR NOT EXISTS
			(
				SELECT 1 FROM dbo.tb_itemClassDetail icd 
				WHERE icd.ItemCode = til.ShortItemCode 
				AND icd.ClassID = 115
			)
		)
	)
	AND 
	(
			tis.Assembled = 1
			OR til.ItemTypeCode IN(12, 3)
	)
	AND tis.Received = 1
	AND il.ExcludeFrmStock = 0		
	AND il.LocationType <> 13
	--AND ( il.Location LIKE 'ASC-%' OR il.Location LIKE 'AST-%' ) AND il.Location NOT IN('ASC-1-1')
	--AND il.ExcludeFrmStock = @Sandbox	
	GROUP BY til.ShortItemCode, ISNULL(tis.Hinge, 'N')

	--INSERT @CountAvailableAbn
	--(
	--    ShortItemCode, Quantity
	--)
	--SELECT til.ItemCode, SUM(tabn.Qty) 
	--FROM dbo.tb_AccBoxNumber AS tabn
	--JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = tabn.ItemCode
	--JOIN dbo.InventoryLocation AS il ON tabn.ReceivedLocation = il.Location
	--WHERE EXISTS
	--(
	--	SELECT * FROM @OrderItems AS oi WHERE oi.ItemCode = til.ItemCode
	--)
	--AND tabn.Received = 1
	--AND il.ExcludeFrmStock = 0
	--AND il.LocationType <> 13
	--GROUP BY til.ItemCode

	--MERGE @CountAvailable AS ca USING @CountAvailableAbn AS caAbn
	--ON ca.ShortItemCode = caAbn.ShortItemCode 
	--	AND ca.Hinge = 'N'
	--WHEN MATCHED 
	--THEN UPDATE SET ca.Quantity = ca.Quantity + caAbn.Quantity
	--WHEN NOT MATCHED BY TARGET
	--THEN INSERT (ShortItemCode, Hinge, Quantity)
	--VALUES(caAbn.ShortItemCode, 'N', caAbn.Quantity);



	INSERT @ReturnVal(ShortItemCode, Quantity, Hinge)
	SELECT ca.ShortItemCode, dbo.NegativeIntToZero(ISNULL(ca.Quantity, 0) - ISNULL(cr.Quantity, 0)), ca.Hinge
	FROM @CountAvailable AS ca
	LEFT JOIN @CountReserved AS cr ON cr.ShortItemCode = ca.ShortItemCode AND cr.Hinge = ca.Hinge

	RETURN 
END
GO
/****** Object:  UserDefinedFunction [acumaticaManufacturing].[GetCountOfAvailableFGItemsForOrderIdFast]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [acumaticaManufacturing].[GetCountOfAvailableFGItemsForOrderIdFast]
(

	@OrderId INT , 
	@ShortItemCodes StringList READONLY,
	@Sandbox BIT = 0
)

RETURNS @ReturnVal TABLE (ShortItemCode NVARCHAR(150), Quantity INT, Hinge VARCHAR(10))
AS
BEGIN


	DECLARE @DistinctShortItemCodes StringList
	INSERT @DistinctShortItemCodes(Value)
	SELECT DISTINCT Value FROM @ShortItemCodes AS sic
	DECLARE @localOrderId INT = @OrderId
	DECLARE @CountReserved TABLE(ShortItemCode NVARCHAR(150), Quantity INT, Hinge VARCHAR(10))
	DECLARE @CountAvailable TABLE(ShortItemCode NVARCHAR(150), Quantity INT, Hinge VARCHAR(10))
	DECLARE @CountAvailableAbn TABLE(ShortItemCode NVARCHAR(150), Quantity INT)
	DECLARE @OrderItems TABLE (ItemCode VARCHAR(150) NOT NULL , Hinge VARCHAR(10) NOT NULL, ShortItemCode VARCHAR(50), ItemListId INT, INDEX ix_ic  (ItemCode))
	DECLARE @ItemClass115 TABLE(ItemCode NVARCHAR(150) PRIMARY KEY(ItemCode ASC))

	INSERT @ItemClass115(ItemCode)
	SELECT DISTINCT icd.ItemCode FROM dbo.tb_itemClassDetail icd 
	WHERE icd.ClassID = 115
	AND icd.IsActive = 1

	INSERT @OrderItems(ItemCode, Hinge, ShortItemCode, ItemListId)
	SELECT te.ItemNumber , COALESCE(num.NeedsHingeMatch, te.Hinge,'N' ), til.ShortItemCode, til.ID
	FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
	OUTER APPLY
	(
		SELECT 'NA' WHERE NOT EXISTS
		(
			SELECT * FROM @ItemClass115 AS ic
			WHERE ic.ItemCode = til.ShortItemCode
		)
	)AS num(NeedsHingeMatch)
	WHERE te.OrderID = @localOrderId 
	AND te.ItemType IN(1,2,3,12)
	AND EXISTS
	(
		SELECT * FROM @DistinctShortItemCodes AS sic
		WHERE sic.Value = til.ShortItemCode
	)
	GROUP BY COALESCE(num.NeedsHingeMatch, te.Hinge, 'N'), te.ItemNumber, til.ShortItemCode, til.ID
	
	INSERT @CountReserved(ShortItemCode, Quantity, Hinge)
	SELECT til.ShortItemCode, COUNT(*), ISNULL(te.Hinge, 'N')
	FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
	JOIN dbo.[Order] o ON o.ID = te.OrderID
    JOIN dbo.Departmentstatus AS d ON d.ID = o.Departmentstatusid
	JOIN dbo.QuotesStatus AS qs ON o.SOnumber = qs.QuoteNumber
	JOIN picking.OrderItemProductionItemIRelease AS oipiir ON oipiir.OrderItemId = te.ID AND oipiir.Sandbox =@Sandbox
	WHERE te.isActive = 1 
	AND te.isDeleted = 0   
    AND o.isActive = 1 
    AND qs.QuoteStatus = 'SALES ORDER'
    AND d.isShipped = 0 
	AND te.FWPONumber IS NULL
	AND oipiir.Revision = 'FG'
	AND EXISTS
	(
		SELECT * FROM @OrderItems AS oi WHERE oi.ItemCode = te.ItemNumber
		AND	oi.Hinge IN (ISNULL(te.Hinge, 'N'), 'NA')
	)
	GROUP BY til.ShortItemCode, ISNULL(te.Hinge, 'N')
	
	INSERT @CountAvailable(ShortItemCode, Quantity, Hinge)
	SELECT tis.ItemCode, COUNT(*) , ISNULL(tis.Hinge, 'N')
	FROM dbo.tb_ItemSeriel AS tis
	JOIN @OrderItems AS oi ON oi.ShortItemCode = tis.ItemCode
	JOIN dbo.InventoryLocation AS il ON tis.ReceivedLocation = il.Location
	LEFT JOIN dbo.ItemReleaseRulesForPlanning AS irrfp ON irrfp.ItemId = oi.ItemListId AND irrfp.Include = 1
	WHERE oi.Hinge IN (ISNULL(tis.Hinge, 'N'), 'NA')	
	AND COALESCE(CASE WHEN tis.Assembled = 1 THEN 1 ELSE NULL END, irrfp.FG_WithoutAssembled, 0) = 1
	AND tis.Received = 1
	AND il.ExcludeFrmStock = 0		
	AND il.LocationType <> 13
	--AND ( il.Location LIKE 'ASC-%' OR il.Location LIKE 'AST-%' ) AND il.Location NOT IN('ASC-1-1')
	GROUP BY tis.ItemCode, ISNULL(tis.Hinge, 'N')

	INSERT @CountAvailableAbn
	(
	    ShortItemCode, Quantity
	)
	SELECT tabn.ItemCode, SUM(tabn.Qty)
	FROM dbo.tb_AccBoxNumber AS tabn
	JOIN dbo.InventoryLocation AS il ON tabn.ReceivedLocation = il.Location
	JOIN @OrderItems AS oi ON oi.ShortItemCode = tabn.ItemCode
	LEFT JOIN dbo.ItemReleaseRulesForPlanning AS irrfp ON irrfp.ItemId = oi.ItemListId AND irrfp.Include = 1
	WHERE tabn.Received = 1
	AND tabn.Qty > 0
	AND il.ExcludeFrmStock = 0
	AND il.LocationType <> 13
	AND COALESCE(CASE WHEN tabn.Assembled = 1 THEN 1 ELSE NULL END, irrfp.FG_WithoutAssembled, 0) = 1
	GROUP BY tabn.ItemCode 
	

	MERGE @CountAvailable AS ca USING @CountAvailableAbn AS caAbn
	ON ca.ShortItemCode = caAbn.ShortItemCode 
		AND ca.Hinge IN('N', 'NA')
	WHEN MATCHED 
	THEN UPDATE SET ca.Quantity = ca.Quantity + caAbn.Quantity
	WHEN NOT MATCHED BY TARGET
	THEN INSERT (ShortItemCode, Hinge, Quantity)
	VALUES(caAbn.ShortItemCode, 'N', caAbn.Quantity);



	INSERT @ReturnVal(ShortItemCode, Quantity, Hinge)
	SELECT ca.ShortItemCode, dbo.NegativeIntToZero(ISNULL(ca.Quantity, 0) - ISNULL(cr.Quantity, 0)), ca.Hinge
	FROM @CountAvailable AS ca
	LEFT JOIN @CountReserved AS cr ON cr.ShortItemCode = ca.ShortItemCode AND cr.Hinge = ca.Hinge

	RETURN 
END
GO
/****** Object:  UserDefinedFunction [acumaticaManufacturing].[GetCountOfAvailableFGItemsForOrderItemId]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [acumaticaManufacturing].[GetCountOfAvailableFGItemsForOrderItemId]
(
	@OrderItemId INT,
	@Sandbox BIT = 0
)
RETURNS INT
AS
BEGIN
	DECLARE @CountReserved INT, @CountAvailable INT
	SELECT @CountReserved = COUNT(*) 
	FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
	JOIN dbo.[Order] o ON o.ID = te.OrderID
    JOIN dbo.Departmentstatus AS d ON d.ID = o.Departmentstatusid
	JOIN dbo.QuotesStatus AS qs ON o.SOnumber = qs.QuoteNumber
	WHERE EXISTS
	(
		SELECT * FROM picking.OrderItemProductionItemIRelease AS oipiir
		WHERE oipiir.OrderItemId = te.ID
		AND oipiir.Revision = 'FG'
		AND oipiir.Completed = 0
	) 
	AND 
	(
		(
			o.CustomerName <> 'TEST ORDERS' 
			AND @Sandbox = 0
		)
		OR
        (
			o.CustomerName = 'TEST ORDERS' 
			AND @Sandbox <> 0
		)
	)
	AND te.isActive = 1 
	AND te.isDeleted = 0   
    AND o.isActive = 1 
    AND qs.QuoteStatus = 'SALES ORDER'
    AND d.isShipped = 0 
	AND te.FWPONumber IS NULL
	AND EXISTS
	(
		SELECT * FROM 
		dbo.TranEntry AS te2 
		WHERE te2.ItemNumber = te.ItemNumber
		AND te2.ID = @OrderItemId
		AND 
		(
			ISNULL(te.Hinge, '') = ISNULL(te2.Hinge, '') 
			OR NOT EXISTS
			(
				SELECT 1 FROM dbo.tb_itemClassDetail icd 
				WHERE icd.ItemCode = til.ShortItemCode 
				AND icd.ClassID = 115
				AND icd.IsActive = 1
			)
		)
	)

	SELECT @CountAvailable = COUNT(*) FROM
	dbo.tb_ItemSeriel AS tis
	JOIN dbo.tb_ItemList AS til ON til.ItemCode = tis.ItemCode
	JOIN dbo.InventoryLocation AS il ON tis.ReceivedLocation = il.Location
	WHERE EXISTS
	(
		SELECT * FROM 
		dbo.TranEntry AS te 
		WHERE te.ItemNumber = til.ItemCode
		AND te.ID = @OrderItemId
		AND 
		(
			ISNULL(te.Hinge, '') = ISNULL(tis.Hinge, '') 
			OR NOT EXISTS
			(
				SELECT 1 FROM dbo.tb_itemClassDetail icd 
				WHERE icd.ItemCode = til.ShortItemCode 
				AND icd.ClassID = 115
			)
		)
	)
	AND tis.Assembled = 1
	AND tis.Received = 1
	AND il.ExcludeFrmStock = 0		
	--AND ( il.Location LIKE 'ASC-%' OR il.Location LIKE 'AST-%' ) AND il.Location NOT IN('ASC-1-1')
	--AND il.ExcludeFrmStock = @Sandbox	

	RETURN CASE WHEN @CountAvailable > @CountReserved THEN @CountAvailable - @CountReserved ELSE 0 END
END
GO
/****** Object:  UserDefinedFunction [acumaticaManufacturing].[GetOrdersForPlanning]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [acumaticaManufacturing].[GetOrdersForPlanning]()
RETURNS 
@OrdersForPlanning TABLE (OrderId INT NOT NULL, MinPickingDate DATE NULL)
AS
BEGIN
	DECLARE @HighestOrderId INT
	SELECT @HighestOrderId = MAX(o.OrderID) FROM dbo.[Order] AS o 
	DECLARE @result TABLE (OrderID INT NOT NULL,PickingDate DATE NULL, DepartmentstatusID INT NOT NULL, FWPONumber VARCHAR(50) NULL, isDeleted BIT NOT NULL, KD BIT NOT NULL, CustomerName NVARCHAR(250) NOT NULL, ItemTypeCode INT NOT NULL);	
	
	WITH items as
	(
	SELECT il.ShortItemCode , il.AcumaticaName FROM dbo.tb_ItemList il 
	
	WHERE 
	--begin 10/26/2020 commented out
	--(
	--	(
	--		il.ItemTypeCode IN(1,2) 
	--		AND NOT EXISTS
	--		(
	--			SELECT * FROM dbo.ItemReleaseRulesForPlanning IRRFP 
	--			WHERE IRRFP.ItemId = il.id 
	--			AND IRRFP.Exclude = 1 
	--			AND IRRFP.Active = 1
	--			AND IRRFP.EffectiveDate IS NULL
	--		)
	--	)
	--	OR 
	--	(
	--		EXISTS 
	--		(
	--			SELECT * FROM dbo.ItemReleaseRulesForPlanning IRRFP2 
	--			WHERE IRRFP2.ItemId = il.ID 
	--			AND IRRFP2.Include = 1 
	--			AND IRRFP2.Active = 1
	--			AND IRRFP2.EffectiveDate IS NULL
	--		)
	--	)
	--)
	--AND 
	--end 10/26/2020 commented out
	EXISTS (SELECT * FROM acumaticaManufacturing.BillOfMaterials bom WHERE bom.InventoryID=il.AcumaticaName AND bom.DeleteFlag =0 
		AND  ( bom.Revision ='A' OR EXISTS (SELECT * FROM dbo.ItemsQ13Process iqp WHERE iqp.DoorStyleId=il.DoorStyleID OR il.DoorStyleID IS NULL ) ) )

	--SELECT il.ShortItemCode , il.AcumaticaName FROM dbo.tb_ItemList il 
	--WHERE 
	----il.ItemTypeCode IN(1,2) --AND il.DoorStyleID=20
	  
	--((il.ItemTypeCode IN(1,2) AND NOT EXISTS(SELECT * FROM dbo.ItemReleaseRulesForPlanning IRRFP WHERE IRRFP.ItemId = il.id AND IRRFP.Exclude = 1 AND IRRFP.Active = 1))
	--OR 
	--(EXISTS (SELECT * FROM dbo.ItemReleaseRulesForPlanning IRRFP2 WHERE IRRFP2.ItemId = il.ID AND IRRFP2.Include = 1 AND IRRFP2.Active = 1)))
	--AND EXISTS (SELECT * FROM acumaticaSandboxManufacturing.BillOfMaterials bom WHERE bom.InventoryID=il.AcumaticaName AND bom.DeleteFlag =0 
	--	AND  ( bom.Revision ='A' OR EXISTS (SELECT * FROM dbo.ItemsQ13Process iqp WHERE iqp.DoorStyleId=il.DoorStyleID OR il.DoorStyleID IS NULL ) ) )
	) 
	--, AllowedPickDates AS (SELECT TOP (
	--SELECT MAX(do.DaysOpen) DaysOpen FROM (
	--SELECT MAX(COALESCE(b.DaysOpen,1)) DaysOpen FROM picking.Buckets b 
	----UNION
	----SELECT MAX(COALESCE(bpi.AllowedPickDates,1)) FROM picking.BucketProductionItems bpi
	--) do ) apd.PickingDate FROM picking.AvailablePickingDates apd WHERE apd.PickingDate > GETDATE())
	,OrdersToPlan AS 
	(
		SELECT o.OrderID, te.pickingDate, te.DepartmentstatusID,te.FWPONumber,te.isDeleted, te.KD, o.CustomerName, il.ItemTypeCode
		FROM dbo.TranEntry te 
		JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1 
		JOIN dbo.Departmentstatus d ON d.ID = o.DepartmentstatusID AND d.isShipped =0  AND d.StatusStageId NOT IN(5,6)
		JOIN dbo.QuotesStatus AS qs ON o.SOnumber=qs.QuoteNumber AND qs.QuoteStatus IN('SALES ORDER')
		JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber 
		JOIN items i ON i.ShortItemCode = il.ShortItemCode
		LEFT JOIN dbo.OrderShippingDetail OSD ON OSD.OrderId = o.OrderID
		--JOIN AllowedPickDates apd ON  te.PickingDate <= apd.PickingDate 
		WHERE --te.Addtime > GETDATE() -180 AND
		 te.isActive =1 --AND te.isDeleted =0
		AND o.CustomerName NOT IN('TEST ORDERS')
		AND ISNULL(OSD.ShipWithQuickShip,0) = 0
		--AND  te.FWPONumber IS  NULL 
		AND NOT EXISTS (SELECT 1 FROM picking.OrderItemProductionItemIRelease oipiir WHERE oipiir.OrderItemId=te.ID)
		--AND te.DepartmentstatusID IN(6,865)  
		AND te.DepartmentstatusID NOT IN(981)
		AND ( te.EZParentProdID IS NULL OR EXISTS (SELECT * FROM dbo.TranEntry AS te2 
			JOIN picking.OrderItemProductionItemIRelease oipir ON oipir.OrderItemId = te2.ID AND oipir.Revision='A'
		WHERE te2.OrderID =te.OrderID AND te2.EZProdID=te.EZParentProdID ))
		--begin 10/26/2020
		AND 
		(
			(
				il.ItemTypeCode IN(1,2) 
				AND NOT EXISTS
				(
					SELECT * FROM dbo.ItemReleaseRulesForPlanning IRRFP 
					WHERE IRRFP.ItemId = il.id 
					AND IRRFP.Exclude = 1 
					AND IRRFP.Active = 1
					AND (IRRFP.EffectiveDate IS NULL
					OR te.Addtime >= IRRFP.EffectiveDate)
				)
			)
			OR 
			(
				EXISTS 
				(
					SELECT * FROM dbo.ItemReleaseRulesForPlanning IRRFP2 
					WHERE IRRFP2.ItemId = il.ID 
					AND IRRFP2.Include = 1 
					AND IRRFP2.Active = 1
					AND ( IRRFP2.EffectiveDate IS NULL
					OR te.Addtime >= IRRFP2.EffectiveDate)
				)
			)
		)
		--end 10/26/2020
		AND o.OrderID <= @HighestOrderId
	)
	

	INSERT @result(OrderID,PickingDate,DepartmentstatusID,FWPONumber,isDeleted,KD,CustomerName,ItemTypeCode)
	SELECT OrdersToPlan.OrderID,OrdersToPlan.PickingDate, OrdersToPlan.DepartmentstatusID, OrdersToPlan.FWPONumber, OrdersToPlan.isDeleted, OrdersToPlan.KD, OrdersToPlan.CustomerName, OrdersToPlan.ItemTypeCode FROM OrdersToPlan

	INSERT @OrdersForPlanning(OrderId,MinPickingDate)
	SELECT r.OrderID, MIN(r.PickingDate) FROM @result AS r WHERE r.isDeleted =0 AND r.FWPONumber IS NULL AND r.DepartmentstatusID NOT IN(684) AND (r.KD =0 OR r.ItemTypeCode = 3 OR (r.KD = 1 AND r.CustomerName IN ('Star Cabinets','Wholesale')))  GROUP BY r.OrderID

	RETURN

END







GO
/****** Object:  UserDefinedFunction [acumaticaManufacturing].[GetProductionOrderToReleaseMappingToComplete]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [acumaticaManufacturing].[GetProductionOrderToReleaseMappingToComplete]()
RETURNS 
@ProductionOrderToReleaseMappingToComplete TABLE
(
	ProductionNumber VARCHAR(50) NOT NULL,
	OrderItemProductionItemIReleaseId INT NULL
)
AS 
BEGIN

	INSERT @ProductionOrderToReleaseMappingToComplete
	 SELECT po.ProductionNumber , oipiir.OrderItemProductionItemIReleaseId
	 --, te.FWPONumber ,o.IsActive, te.isActive,o.CustomerName, te.DepartmentstatusID, po.ProductionOrderDate,te.LastUpdate
	 FROM picking.OrderItemProductionItemIRelease AS oipiir WITH(NOLOCK) 
	 JOIN dbo.TranEntry AS te WITH(NOLOCK) ON te.ID = oipiir.OrderItemId
	 JOIN dbo.[Order] AS o WITH(NOLOCK) ON o.ID = te.OrderID
	 JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
	 JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	 JOIN acumaticaManufacturing.ProductionOrders AS po WITH(NOLOCK) ON te.FWPONumber=po.ProductionNumber AND po.DeleteFlag =0
	 WHERE oipiir.Released=1 AND oipiir.Planned=1 AND oipiir.Completed=0 AND oipiir.Processing = 0 AND oipiir.Sandbox=0
	 AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId IN(3,4,5,6) OR te.DepartmentstatusID IN(330,773) )
	 AND oipiir.Revision <> 'A' AND oipiir.Processing=0
	 AND po.ProductionStatus IN('Released')
	 AND (te.isActive=1 OR te.DepartmentstatusID =330 ) AND te.isDeleted=0
	 AND te.FWPONumber IS NOT NULL

	 --Revision a that have PO (But not a po from a different WO, then we will close the po that it got and cancel it's own po)
	 INSERT @ProductionOrderToReleaseMappingToComplete  
	  SELECT po.ProductionNumber, oipiir.OrderItemProductionItemIReleaseId
	  --,te.FWPONumber ,o.IsActive, te.isActive, o.CustomerName , te.DepartmentstatusID, po.ProductionOrderDate,te.LastUpdate
		 FROM picking.OrderItemProductionItemIRelease AS oipiir WITH(NOLOCK)
	 JOIN dbo.TranEntry AS te WITH(NOLOCK) ON te.ID = oipiir.OrderItemId
	 JOIN dbo.[Order] AS o WITH(NOLOCK) ON o.ID = te.OrderID
	 JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
	 JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	 LEFT JOIN picking.ProductionItem AS pi WITH(NOLOCK) ON pi.OrderItemId = te.ID AND pi.Deleted =0 AND oipiir.Sandbox = pi.Sandbox
	 JOIN acumaticaManufacturing.ProductionOrders AS po WITH(NOLOCK) ON po.ProductionNumber=CASE WHEN pi.ProductionItemId IS NULL THEN te.FWPONumber ELSE pi.ProductionNbr END AND po.DeleteFlag =0
	 LEFT  JOIN acumaticaManufacturing.ProductionOrders AS po2 ON te.FWPONumber=po2.ProductionNumber AND PO2.ProductionOrderType <> 'RO' AND PO2.DeleteFlag =0
	 WHERE oipiir.Released=1 AND oipiir.Planned=1 AND oipiir.Completed=0 AND oipiir.Processing = 0 AND oipiir.Sandbox=0
	 AND oipiir.Revision='A'
	 AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId IN(3,4,5,6) OR te.DepartmentstatusID  IN(330,773) )
	 AND po.ProductionStatus IN('Released')
	 AND (te.isActive=1 OR ( te.DepartmentstatusID =330)  )  AND te.isDeleted=0
	 AND te.FWPONumber IS NOT NULL AND (te.FWPONumber = po.ProductionNumber OR te.FWPONumber NOT LIKE 'W%' OR po2.AcumaticaProductionOrderId IS NOT NULL )
	 AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToComplete AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber AND potrmtr.OrderItemProductionItemIReleaseId=oipiir.OrderItemProductionItemIReleaseId)


	 INSERT @ProductionOrderToReleaseMappingToComplete
	 SELECT pi.ProductionNbr, oipiir.OrderItemProductionItemIReleaseId FROM dbo.TranEntry AS te WITH(NOLOCK) 
		JOIN picking.OrderItemProductionItemIRelease AS oipiir WITH(NOLOCK) ON oipiir.OrderItemId = te.ID
		JOIN dbo.[Order] AS o WITH(NOLOCK) ON o.ID = te.OrderID
		JOIN picking.ProductionItem AS pi WITH(NOLOCK) ON pi.OrderItemId = te.ID AND pi.Deleted=0
		JOIN acumaticaManufacturing.ProductionOrders AS po WITH(NOLOCK) ON po.ProductionNumber=pi.ProductionNbr AND po.DeleteFlag=0
		JOIN dbo.Departmentstatus AS d WITH(NOLOCK) ON d.ID = te.DepartmentstatusID
		LEFT JOIN dbo.tb_ItemSeriel AS tis WITH(NOLOCK) ON tis.TranEntryID = te.ID
		WHERE te.FWPONumber IN('00100','10','9') AND (  d.isShipped=1 OR  d.Departmentid = 27 OR d.StatusStageId IN(3,4,5,6) OR te.DepartmentstatusID  = 773) AND o.IsActive=1 AND te.isActive=1
		AND oipiir.Completed=0 AND oipiir.Sandbox=0 AND oipiir.Released =1 AND oipiir.Processing=0 AND oipiir.Planned=1
		AND po.ProductionStatus IN('Released')
	AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToComplete AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber AND potrmtr.OrderItemProductionItemIReleaseId=oipiir.OrderItemProductionItemIReleaseId)

	--production orders that were completed and used but not for their original tran entry and is now in shipping stage
	 INSERT @ProductionOrderToReleaseMappingToComplete
	 SELECT PO.ProductionNumber, OIPIIR.OrderItemProductionItemIReleaseId FROM acumaticaManufacturing.ProductionOrders PO WITH(NOLOCK)
		JOIN picking.ProductionItem PI WITH(NOLOCK) ON PO.ProductionNumber = pi.ProductionNbr
		JOIN dbo.tb_ItemSeriel TIS WITH(NOLOCK) ON TIS.PONumber = PO.ProductionNumber
		JOIN dbo.TranEntry TE WITH(NOLOCK) ON TIS.TranEntryID = TE.ID
		LEFT JOIN picking.OrderItemProductionItemIRelease OIPIIR WITH(NOLOCK) ON OIPIIR.OrderItemId = te.ID
		JOIN dbo.Departmentstatus D ON D.ID = TE.DepartmentstatusID
		WHERE pi.Deleted = 0 AND te.isActive = 1 AND TE.isDeleted = 0 
		AND PI.Sandbox = 0
		AND PO.ProductionStatus IN ('Released')
		AND D.StatusStageId IN(3,4,5,6)
		AND ISNULL(oipiir.Processing,0) = 0
		AND NOT EXISTS (SELECT * FROM dbo.TranEntry TE2 WITH(NOLOCK) WHERE pi.OrderItemId = te2.ID)
		AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToComplete AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber AND potrmtr.OrderItemProductionItemIReleaseId=oipiir.OrderItemProductionItemIReleaseId)

		--production orders that were completed but are not linked to a tran entry
		INSERT @ProductionOrderToReleaseMappingToComplete(ProductionNumber)
		SELECT po.ProductionNumber FROM acumaticaManufacturing.ProductionOrders PO WITH(NOLOCK)
		JOIN picking.ProductionItem PI WITH(NOLOCK) ON PO.ProductionNumber = PI.ProductionNbr
		JOIN dbo.tb_ItemSeriel TIS WITH(NOLOCK) ON TIS.PONumber = PO.ProductionNumber
		WHERE TIS.TranEntryID IS NULL 
		AND NOT EXISTS(SELECT * FROM dbo.TranEntry TE WITH(NOLOCK) WHERE TE.FWPONumber = PO.ProductionNumber AND TE.isActive = 1 AND TE.isDeleted = 0)
		AND PO.ProductionStatus IN ('Released')
		AND tis.DeleteFlag = 0
		AND pi.Deleted = 0
		AND (TIS.ReceivedLocation LIKE 'asc%' OR TIS.ReceivedLocation LIKE 'ast%')
		AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToComplete AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber)

		--production orders created when using pick / modify - skip
		INSERT @ProductionOrderToReleaseMappingToComplete(ProductionNumber)
		SELECT  po.ProductionNumber FROM acumaticaManufacturing.ProductionOrders PO
		JOIN picking.ProductionItem PI ON PI.ProductionNbr = PO.ProductionNumber
		JOIN dbo.TranEntry TE ON TE.ID = PI.OrderItemId
		JOIN dbo.[Order] AS o WITH(NOLOCK) ON o.ID = te.OrderID
		JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
		JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	
		WHERE po.DeleteFlag = 0 AND pi.Deleted = 0 AND PI.Sandbox = 0
		AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId IN(3,4,5,6))
		AND EXISTS (SELECT * FROM acumaticaManufacturing.ProductionOrderToCreate POTC
					WHERE POTC.ProductionNumber = po.ProductionNumber AND POTC.Deleted = 0 AND POTC.OrderSourceTypeId = 4)
		AND PO.ProductionStatus IN ('Released') AND TE.FWPONumber = po.ProductionNumber



 RETURN
 END







GO
/****** Object:  UserDefinedFunction [acumaticaManufacturing].[GetProductionOrderToReleaseMappingToDelete]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [acumaticaManufacturing].[GetProductionOrderToReleaseMappingToDelete]()
RETURNS 
@ProductionOrderToReleaseMappingToDelete TABLE
(
	ProductionNumber VARCHAR(50) NOT NULL,
	OrderItemProductionItemIReleaseId INT NULL
)
AS 
BEGIN

	DECLARE @lastHour DATETIME = GETDATE() - 1.0 /24

	--InActive tran entries
	INSERT @ProductionOrderToReleaseMappingToDelete
	--DECLARE @lastHour DATETIME = GETDATE() - 1.0 /24
	 SELECT po.ProductionNumber, oipiir.OrderItemProductionItemIReleaseId
  FROM acumaticaManufacturing.ProductionOrders AS po WITH(NOLOCK)
  LEFT JOIN acumaticaManufacturing.BillOfMaterials AS bom WITH(NOLOCK) ON bom.BOMID = po.BOMID AND bom.DeleteFlag =0
 JOIN picking.ProductionItem AS pi  WITH(NOLOCK) ON pi.ProductionNbr =po.ProductionNumber AND pi.Deleted =0 AND pi.Sandbox=0
 LEFT JOIN picking.OrderItemProductionItemIRelease AS oipiir WITH(NOLOCK) ON oipiir.OrderItemId = pi.OrderItemId AND oipiir.Sandbox=pi.Sandbox
 CROSS APPLY (SELECT COUNT(*) Picked FROM picking.ProductionItemDetail AS pid2  WITH(NOLOCK) WHERE pid2.ProductionItemId=pi.ProductionItemId and pid2.picked =1 AND pid2.PickingTypeId NOT IN(5,3,8)) pid
 WHERE po.DeleteFlag=0 AND po.ProductionStatus IN('Released','Planned') AND (oipiir.OrderItemProductionItemIReleaseId IS NULL OR oipiir.Processing =0 )
 AND po.LastModifiedDateAcumatica < @lastHour
 AND (
	( pi.OrderItemId IS NULL AND NOT EXISTS (SELECT 1 FROM dbo.TranEntry AS te WITH(NOLOCK) WHERE te.FWPONumber=po.ProductionNumber AND EXISTS (SELECT * FROM dbo.[Order] AS o  WITH(NOLOCK) WHERE o.CustomerName NOT IN('TEST ORDERS'))))
 OR ( pi.OrderItemId IS NOT NULL  AND pid.Picked =0 
 AND EXISTS (SELECT * FROM dbo.TranEntry AS te  WITH(NOLOCK) WHERE pi.OrderItemId=te.ID AND te.isActive = 0 AND ( te.FWPONumber IS NULL OR (te.FWPONumber <> po.ProductionNumber AND ISNULL(bom.Revision, 'A') <>'A')) )
)
)
AND NOT EXISTS (SELECT * FROM dbo.tb_ItemSeriel AS tis  WITH(NOLOCK) WHERE po.ProductionNumber=tis.PONumber AND tis.DeleteFlag=0
AND NOT EXISTS (SELECT * FROM dbo.InventoryLocation AS il WITH(NOLOCK) WHERE il.Location=tis.ReceivedLocation AND il.ExcludeFrmStock=1 AND il.LocationType=13 )
AND NOT EXISTS (SELECT * FROM dbo.InventoryLocation AS il WITH(NOLOCK) WHERE il.ID=tis.PickedFromLocation AND (il.Location LIKE 'T1%' OR il.LocationType IN(8))) )

	--Items that have a different FWPO that original work order and nothing picked on original Work Order
	--For revision A only if it has a FWPO like W%
	INSERT @ProductionOrderToReleaseMappingToDelete(ProductionNumber, OrderItemProductionItemIReleaseId)
		SELECT PO.ProductionNumber, OIPIIR.OrderItemProductionItemIReleaseId FROM acumaticaManufacturing.ProductionOrders PO WITH(NOLOCK)
			JOIN picking.ProductionItem PI WITH(NOLOCK) ON PO.ProductionNumber = PI.ProductionNbr
			CROSS APPLY (SELECT COUNT(*) qty FROM picking.ProductionItemDetail AS pid2 WITH(NOLOCK) WHERE pid2.ProductionItemId=pi.ProductionItemId and pid2.picked =1 AND pid2.PickingTypeId NOT IN(5,3,8) ) pid
			JOIN dbo.TranEntry TE WITH(NOLOCK) ON TE.ID = PI.OrderItemId
			JOIN picking.OrderItemProductionItemIRelease OIPIIR WITH(NOLOCK) ON OIPIIR.OrderItemId = te.ID
			LEFT JOIN acumaticaManufacturing.ProductionOrders PO2 ON TE.FWPONumber = PO2.ProductionNumber
		WHERE PI.Deleted = 0 AND TE.isActive = 1 AND TE.isDeleted = 0
			AND TE.FWPONumber IS NOT NULL AND ((OIPIIR.Revision = 'A' AND TE.FWPONumber LIKE 'W%' AND ISNULL(po2.ProductionOrderType,'')='RO') OR (OIPIIR.Revision NOT IN ('A','FG') AND TE.FWPONumber <> PO.ProductionNumber))
			AND po.ProductionStatus IN ('planned', 'released')
			AND po.DeleteFlag = 0 AND pid.qty = 0
		AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToDelete AS potrmtd WHERE potrmtd.ProductionNumber=po.ProductionNumber)


 RETURN
 END








GO
/****** Object:  UserDefinedFunction [acumaticaManufacturing].[GetProductionOrderToReleaseMappingToRelease]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [acumaticaManufacturing].[GetProductionOrderToReleaseMappingToRelease]()
RETURNS 
@ProductionOrderToReleaseMappingToRelease TABLE
(
	ProductionNumber VARCHAR(50) NOT NULL,
	OrderItemProductionItemIReleaseId INT NULL
)
AS 
BEGIN

	INSERT @ProductionOrderToReleaseMappingToRelease
	 SELECT po.ProductionNumber , oipiir.OrderItemProductionItemIReleaseId
	 --, te.FWPONumber ,o.IsActive, te.isActive,o.CustomerName, te.DepartmentstatusID, po.ProductionOrderDate,te.LastUpdate
	 FROM picking.OrderItemProductionItemIRelease AS oipiir WITH(NOLOCK)
	 JOIN dbo.TranEntry AS te WITH(NOLOCK) ON te.ID = oipiir.OrderItemId
	 JOIN dbo.[Order] AS o WITH(NOLOCK) ON o.ID = te.OrderID
	 JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
	 JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	 JOIN acumaticaManufacturing.ProductionOrders AS po WITH(NOLOCK) ON te.FWPONumber=po.ProductionNumber AND po.DeleteFlag =0
	 JOIN acumaticaManufacturing.BillOfMaterials AS bom ON bom.BOMID = po.BOMID 
	 WHERE oipiir.Released=0 AND oipiir.Planned=1 AND oipiir.Completed=0 AND oipiir.Processing = 0 AND oipiir.Sandbox=0
	 AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId IN(3,4,5,6)  OR te.DepartmentstatusID IN(330,773) OR  te.PickingDate < GETDATE() )
	 AND oipiir.Revision <> 'A' AND oipiir.Processing=0
	 AND po.ProductionStatus IN('Planned')
	 AND (te.isActive=1 OR te.DepartmentstatusID =330 ) AND te.isDeleted=0

	 INSERT @ProductionOrderToReleaseMappingToRelease  
	  SELECT po.ProductionNumber, oipiir.OrderItemProductionItemIReleaseId
	  --,te.FWPONumber ,o.IsActive, te.isActive, o.CustomerName , te.DepartmentstatusID, po.ProductionOrderDate,te.LastUpdate
		 FROM picking.OrderItemProductionItemIRelease AS oipiir WITH(NOLOCK)
	 JOIN dbo.TranEntry AS te WITH(NOLOCK) ON te.ID = oipiir.OrderItemId
	 JOIN dbo.[Order] AS o WITH(NOLOCK) ON o.ID = te.OrderID
	 JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
	 JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	 JOIN picking.ProductionItem AS pi WITH(NOLOCK) ON pi.OrderItemId = te.ID AND pi.Deleted =0
	 JOIN acumaticaManufacturing.ProductionOrders AS po WITH(NOLOCK) ON pi.ProductionNbr=po.ProductionNumber AND po.DeleteFlag =0
	 WHERE oipiir.Released=0 AND oipiir.Planned=1 AND oipiir.Completed=0 AND oipiir.Processing = 0 AND oipiir.Sandbox=0
	 AND oipiir.Revision='A'
	 AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId IN(3,4,5,6) OR te.DepartmentstatusID IN(330,773) OR te.PickingDate < GETDATE())
	 AND po.ProductionStatus IN('Planned')
	 AND (te.isActive=1 OR ( te.DepartmentstatusID =330)  )  AND te.isDeleted=0
	 AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToRelease AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber AND potrmtr.OrderItemProductionItemIReleaseId=oipiir.OrderItemProductionItemIReleaseId)

	 INSERT @ProductionOrderToReleaseMappingToRelease
	 SELECT pi.ProductionNbr, oipiir.OrderItemProductionItemIReleaseId FROM dbo.TranEntry AS te WITH(NOLOCK)
		JOIN picking.OrderItemProductionItemIRelease AS oipiir WITH(NOLOCK) ON oipiir.OrderItemId = te.ID
		JOIN dbo.[Order] AS o WITH(NOLOCK) ON o.ID = te.OrderID
		JOIN picking.ProductionItem AS pi WITH(NOLOCK) ON pi.OrderItemId = te.ID AND pi.Deleted=0
		JOIN acumaticaManufacturing.ProductionOrders AS po WITH(NOLOCK) ON po.ProductionNumber=pi.ProductionNbr AND po.DeleteFlag=0
		JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		LEFT JOIN dbo.tb_ItemSeriel AS tis WITH(NOLOCK) ON tis.TranEntryID = te.ID
		WHERE te.FWPONumber IN('00100','10','9') AND (  d.isShipped=1 OR d.Departmentid = 27 OR d.StatusStageId IN(3,4,5,6) OR te.DepartmentstatusID IN(773) ) AND o.IsActive=1 AND te.isActive=1
		AND oipiir.Completed=0 AND oipiir.Sandbox=0 AND oipiir.Released =0 AND oipiir.Processing=0
	--	AND po.ProductionStatus NOT IN('Completed', 'Closed')
		AND po.ProductionStatus = 'Planned'
	AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToRelease AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber AND potrmtr.OrderItemProductionItemIReleaseId=oipiir.OrderItemProductionItemIReleaseId)

	--production orders that were completed and used but not for their original tran entry and is now in shipping stage
	 INSERT @ProductionOrderToReleaseMappingToRelease(ProductionNumber, OrderItemProductionItemIReleaseId)
	 SELECT PO.ProductionNumber, OIPIIR.OrderItemProductionItemIReleaseId FROM acumaticaManufacturing.ProductionOrders PO WITH(NOLOCK)
		JOIN picking.ProductionItem PI WITH(NOLOCK) ON PO.ProductionNumber = pi.ProductionNbr
		JOIN dbo.tb_ItemSeriel TIS WITH(NOLOCK) ON TIS.PONumber = PO.ProductionNumber
		JOIN dbo.TranEntry TE WITH(NOLOCK) ON TIS.TranEntryID = TE.ID
		LEFT JOIN picking.OrderItemProductionItemIRelease OIPIIR WITH(NOLOCK) ON OIPIIR.OrderItemId = te.ID
		JOIN dbo.Departmentstatus D ON D.ID = TE.DepartmentstatusID
		WHERE pi.Deleted = 0 AND te.isActive = 1 AND TE.isDeleted = 0 
		AND PI.Sandbox = 0
		AND PO.ProductionStatus IN ('Planned')
		AND D.StatusStageId IN(3,4,5,6)
		AND ISNULL(oipiir.Processing,0)=0
		AND NOT EXISTS (SELECT * FROM dbo.TranEntry TE2 WITH(NOLOCK) WHERE pi.OrderItemId = te2.ID)
		AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToRelease AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber AND potrmtr.OrderItemProductionItemIReleaseId=oipiir.OrderItemProductionItemIReleaseId)


		--production orders that were completed but are not linked to a tran entry
		INSERT @ProductionOrderToReleaseMappingToRelease(ProductionNumber)
		SELECT po.ProductionNumber FROM acumaticaManufacturing.ProductionOrders PO  WITH(NOLOCK)
		JOIN picking.ProductionItem PI WITH(NOLOCK) ON PO.ProductionNumber = PI.ProductionNbr
		JOIN dbo.tb_ItemSeriel TIS WITH(NOLOCK) ON TIS.PONumber = PO.ProductionNumber
		WHERE TIS.TranEntryID IS NULL 
		AND NOT EXISTS(SELECT * FROM dbo.TranEntry TE WITH(NOLOCK) WHERE TE.FWPONumber = PO.ProductionNumber AND TE.isActive = 1 AND TE.isDeleted = 0)
		AND PO.ProductionStatus IN ('Planned')
		AND tis.DeleteFlag = 0
		AND pi.Deleted = 0
		AND (TIS.ReceivedLocation LIKE 'asc%' OR TIS.ReceivedLocation LIKE 'ast%')
		AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToRelease AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber)


		--production orders created when using pick / modify - skip
		INSERT @ProductionOrderToReleaseMappingToRelease(ProductionNumber)
		SELECT  po.ProductionNumber FROM acumaticaManufacturing.ProductionOrders PO
		JOIN picking.ProductionItem PI ON PI.ProductionNbr = PO.ProductionNumber
		JOIN dbo.TranEntry TE ON TE.ID = PI.OrderItemId
		JOIN dbo.[Order] AS o WITH(NOLOCK) ON o.ID = te.OrderID
		JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
		JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	
		WHERE po.DeleteFlag = 0 AND pi.Deleted = 0 AND PI.Sandbox = 0
		AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId IN(3,4,5,6) OR te.PickingDate < GETDATE())
		AND EXISTS (SELECT * FROM acumaticaManufacturing.ProductionOrderToCreate POTC
					WHERE POTC.ProductionNumber = po.ProductionNumber AND POTC.Deleted = 0 AND POTC.OrderSourceTypeId = 4)
		AND PO.ProductionStatus IN ('Planned') AND TE.FWPONumber = po.ProductionNumber


 RETURN
 END






GO
/****** Object:  UserDefinedFunction [acumaticaSandboxManufacturing].[GetProductionOrderToReleaseMappingToComplete]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [acumaticaSandboxManufacturing].[GetProductionOrderToReleaseMappingToComplete]()
RETURNS 
@ProductionOrderToReleaseMappingToComplete TABLE
(
	ProductionNumber VARCHAR(50) NOT NULL,
	OrderItemProductionItemIReleaseId INT NULL
)
AS 
BEGIN

	INSERT @ProductionOrderToReleaseMappingToComplete
	 SELECT po.ProductionNumber , oipiir.OrderItemProductionItemIReleaseId
	 --, te.FWPONumber ,o.IsActive, te.isActive,o.CustomerName, te.DepartmentstatusID, po.ProductionOrderDate,te.LastUpdate
	 FROM picking.OrderItemProductionItemIRelease AS oipiir 
	 JOIN dbo.TranEntry AS te ON te.ID = oipiir.OrderItemId
	 JOIN dbo.[Order] AS o ON o.ID = te.OrderID
	 JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
	 JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	 JOIN acumaticaSandboxManufacturing.ProductionOrders AS po ON te.FWPONumber=po.ProductionNumber AND po.DeleteFlag=0 
	 WHERE oipiir.Released=1 AND oipiir.Planned=1 AND oipiir.Completed=0 AND oipiir.Processing = 0 AND oipiir.Sandbox=1
	 AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId =4 OR te.DepartmentstatusID =330 )
	 AND oipiir.Revision <> 'A' AND oipiir.Processing=0
	 AND po.ProductionStatus IN('Released')
	 AND (te.isActive=1 OR te.DepartmentstatusID =330 ) AND te.isDeleted=0
	 AND te.FWPONumber IS NOT NULL

	 INSERT @ProductionOrderToReleaseMappingToComplete  
	  SELECT po.ProductionNumber, oipiir.OrderItemProductionItemIReleaseId
	  --,te.FWPONumber ,o.IsActive, te.isActive, o.CustomerName , te.DepartmentstatusID, po.ProductionOrderDate,te.LastUpdate
		 FROM picking.OrderItemProductionItemIRelease AS oipiir 
	 JOIN dbo.TranEntry AS te ON te.ID = oipiir.OrderItemId
	 JOIN dbo.[Order] AS o ON o.ID = te.OrderID
	 JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
	 JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	 LEFT JOIN picking.ProductionItem AS pi ON pi.OrderItemId = te.ID AND pi.Deleted =0 AND oipiir.Sandbox = pi.Sandbox
	 JOIN acumaticaSandboxManufacturing.ProductionOrders AS po ON po.ProductionNumber=CASE WHEN pi.ProductionItemId IS NULL THEN te.FWPONumber ELSE pi.ProductionNbr END AND po.DeleteFlag =0
	 WHERE oipiir.Released=1 AND oipiir.Planned=1 AND oipiir.Completed=0 AND oipiir.Processing = 0 AND oipiir.Sandbox=1
	 AND oipiir.Revision='A'
	 AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId =4 OR te.DepartmentstatusID =330 )
	 AND po.ProductionStatus IN('Released')
	 AND (te.isActive=1 OR ( te.DepartmentstatusID =330)  )  AND te.isDeleted=0
	 AND te.FWPONumber IS NOT NULL
	 AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToComplete AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber AND potrmtr.OrderItemProductionItemIReleaseId=oipiir.OrderItemProductionItemIReleaseId)

	 
	 INSERT @ProductionOrderToReleaseMappingToComplete  
	  SELECT pi.ProductionNbr, oipiir.OrderItemProductionItemIReleaseId FROM dbo.TranEntry AS te 
		JOIN picking.OrderItemProductionItemIRelease AS oipiir ON oipiir.OrderItemId = te.ID
		JOIN dbo.[Order] AS o ON o.ID = te.OrderID
		JOIN picking.ProductionItem AS pi ON pi.OrderItemId = te.ID AND pi.Deleted=0
		JOIN acumaticaSandboxManufacturing.ProductionOrders AS po ON po.ProductionNumber=pi.ProductionNbr AND po.DeleteFlag=0
		JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		LEFT JOIN dbo.tb_ItemSeriel AS tis ON tis.TranEntryID = te.ID
		WHERE te.FWPONumber IN('00100','10','9') AND (  d.isShipped=1 OR  d.Departmentid = 27 OR d.StatusStageId =4  OR te.DepartmentstatusID  = 773) AND o.IsActive=1 AND te.isActive=1
		AND oipiir.Completed=0 AND oipiir.Sandbox=1 AND oipiir.Released =1 AND oipiir.Processing=0 AND oipiir.Planned=1
		AND po.ProductionStatus IN('Released')
	AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToComplete AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber AND potrmtr.OrderItemProductionItemIReleaseId=oipiir.OrderItemProductionItemIReleaseId)

	--production orders created when using pick / modify - skip
		INSERT @ProductionOrderToReleaseMappingToComplete(ProductionNumber)
		SELECT  po.ProductionNumber FROM acumaticaSandboxManufacturing.ProductionOrders PO
		JOIN picking.ProductionItem PI ON PI.ProductionNbr = PO.ProductionNumber
		JOIN dbo.TranEntry TE ON TE.ID = PI.OrderItemId
		JOIN dbo.[Order] AS o WITH(NOLOCK) ON o.ID = te.OrderID
		JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
		JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	
		WHERE po.DeleteFlag = 0 AND pi.Deleted = 0 AND PI.Sandbox = 1
		AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId IN(3,4,5,6))
		AND EXISTS (SELECT * FROM acumaticaManufacturing.ProductionOrderToCreate POTC
					WHERE POTC.ProductionNumber = po.ProductionNumber AND POTC.Deleted = 0 AND POTC.OrderSourceTypeId = 4)
		AND PO.ProductionStatus IN ('Released') AND TE.FWPONumber = po.ProductionNumber


 RETURN
 END

GO
/****** Object:  UserDefinedFunction [acumaticaSandboxManufacturing].[GetProductionOrderToReleaseMappingToDelete]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [acumaticaSandboxManufacturing].[GetProductionOrderToReleaseMappingToDelete]()
RETURNS 
@ProductionOrderToReleaseMappingToDelete TABLE
(
	ProductionNumber VARCHAR(50) NOT NULL,
	OrderItemProductionItemIReleaseId INT NULL
)
AS 
BEGIN
	DECLARE @lastHour DATETIME = GETDATE() - 1.0 /24
	INSERT @ProductionOrderToReleaseMappingToDelete
	 SELECT po.ProductionNumber, oipiir.OrderItemProductionItemIReleaseId
  FROM acumaticaSandboxManufacturing.ProductionOrders AS po WITH(NOLOCK)
  JOIN acumaticaSandboxManufacturing.BillOfMaterials AS bom WITH(NOLOCK) ON bom.BOMID = po.BOMID AND bom.DeleteFlag =0
 JOIN picking.ProductionItem AS pi  WITH(NOLOCK) ON pi.ProductionNbr =po.ProductionNumber AND pi.Deleted =0 AND pi.Sandbox=1
 LEFT JOIN picking.OrderItemProductionItemIRelease AS oipiir WITH(NOLOCK) ON oipiir.OrderItemId = pi.OrderItemId AND oipiir.Sandbox=pi.Sandbox
 CROSS APPLY (SELECT COUNT(*) Picked FROM picking.ProductionItemDetail AS pid2  WITH(NOLOCK) WHERE pid2.ProductionItemId=pi.ProductionItemId and pid2.picked =1 AND pid2.PickingTypeId NOT IN(5,3,8)) pid
 WHERE po.DeleteFlag=0 AND po.ProductionStatus IN('Released','Planned') AND (oipiir.OrderItemProductionItemIReleaseId IS NULL OR oipiir.Processing =0 )
 AND po.LastModifiedDateAcumatica < @lastHour
 AND (
	( pi.OrderItemId IS NULL AND NOT EXISTS (SELECT 1 FROM dbo.TranEntry AS te WITH(NOLOCK) WHERE te.FWPONumber=po.ProductionNumber AND EXISTS (SELECT * FROM dbo.[Order] AS o  WITH(NOLOCK) WHERE o.CustomerName IN('TEST ORDERS'))))
 OR ( pi.OrderItemId IS NOT NULL  AND pid.Picked =0 
 AND EXISTS (SELECT * FROM dbo.TranEntry AS te  WITH(NOLOCK) WHERE pi.OrderItemId=te.ID AND te.isActive = 0 AND ( te.FWPONumber IS NULL OR (te.FWPONumber <> po.ProductionNumber AND bom.Revision <>'A')) )
)
)
AND NOT EXISTS (SELECT * FROM dbo.tb_ItemSeriel AS tis  WITH(NOLOCK) WHERE po.ProductionNumber=tis.PONumber AND tis.DeleteFlag=0
AND NOT EXISTS (SELECT * FROM dbo.InventoryLocation AS il WITH(NOLOCK) WHERE il.Location=tis.ReceivedLocation AND il.ExcludeFrmStock=1 AND il.LocationType=13 )
--AND NOT EXISTS (SELECT * FROM dbo.InventoryLocation AS il WITH(NOLOCK) WHERE il.ID=tis.PickedFromLocation AND (il.Location LIKE 'T1%' OR il.LocationType IN(8)))
 )

 /*
 
	INSERT @ProductionOrderToReleaseMappingToDelete
	 SELECT po.ProductionNumber, oipiir.OrderItemProductionItemIReleaseId
  FROM acumaticaSandboxManufacturing.ProductionOrders AS po
  JOIN acumaticaSandboxManufacturing.BillOfMaterials AS bom ON bom.BOMID = po.BOMID AND bom.DeleteFlag =0
 JOIN picking.ProductionItem AS pi ON pi.ProductionNbr =po.ProductionNumber AND pi.Deleted =0 AND pi.Sandbox=1
 LEFT JOIN picking.OrderItemProductionItemIRelease AS oipiir ON oipiir.OrderItemId = pi.OrderItemId AND oipiir.Sandbox=pi.Sandbox
 CROSS APPLY (SELECT COUNT(*) Picked FROM picking.ProductionItemDetail AS pid2 WHERE pid2.ProductionItemId=pi.ProductionItemId and pid2.picked =1 AND pid2.PickingTypeId NOT IN(5,3)) pid
 WHERE po.DeleteFlag=0 AND po.ProductionStatus IN('Released','Planned')
 AND (
	( pi.OrderItemId IS NULL AND NOT EXISTS (SELECT 1 FROM dbo.TranEntry AS te WHERE te.FWPONumber=po.ProductionNumber AND EXISTS (SELECT * FROM dbo.[Order] AS o WHERE o.CustomerName IN('TEST ORDERS'))))
 OR ( pi.OrderItemId IS NOT NULL  AND pid.Picked =0 
 AND EXISTS (SELECT * FROM dbo.TranEntry AS te WHERE pi.OrderItemId=te.ID AND te.isActive = 0 AND ( te.FWPONumber IS NULL OR (te.FWPONumber <> po.ProductionNumber AND bom.Revision <>'A')) )
)
)
AND NOT EXISTS (SELECT * FROM dbo.tb_ItemSeriel AS tis WHERE po.ProductionNumber=tis.PONumber AND tis.DeleteFlag=0
AND NOT EXISTS (SELECT * FROM dbo.InventoryLocation AS il WHERE il.Location=tis.ReceivedLocation AND il.ExcludeFrmStock=1 AND il.LocationType=13 )
--AND EXISTS (SELECT * FROM dbo.InventoryLocation AS il WHERE il.ID=tis.PickedFromLocation AND (il.Location LIKE 'T1%' OR il.LocationType IN(8))) 
)


 */
 RETURN
 END
GO
/****** Object:  UserDefinedFunction [acumaticaSandboxManufacturing].[GetProductionOrderToReleaseMappingToRelease]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [acumaticaSandboxManufacturing].[GetProductionOrderToReleaseMappingToRelease]()
RETURNS 
@ProductionOrderToReleaseMappingToComplete TABLE
(
	ProductionNumber VARCHAR(50) NOT NULL,
	OrderItemProductionItemIReleaseId INT NOT NULL
)
AS 
BEGIN

	INSERT @ProductionOrderToReleaseMappingToComplete
	 SELECT po.ProductionNumber , oipiir.OrderItemProductionItemIReleaseId
	 --, te.FWPONumber ,o.IsActive, te.isActive,o.CustomerName, te.DepartmentstatusID, po.ProductionOrderDate,te.LastUpdate
	 FROM picking.OrderItemProductionItemIRelease AS oipiir 
	 JOIN dbo.TranEntry AS te ON te.ID = oipiir.OrderItemId
	 JOIN dbo.[Order] AS o ON o.ID = te.OrderID
	 JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
	 JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	 JOIN acumaticaSandboxManufacturing.ProductionOrders AS po ON te.FWPONumber=po.ProductionNumber AND po.DeleteFlag =0
	 WHERE oipiir.Released=0 AND oipiir.Planned=1 AND oipiir.Completed=0 AND oipiir.Processing = 0 AND oipiir.Sandbox=1
	 AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId =4 OR te.DepartmentstatusID =330 OR  te.PickingDate < GETDATE() )
	 AND oipiir.Revision <> 'A' AND oipiir.Processing=0
	 AND po.ProductionStatus IN('Planned')
	 AND (te.isActive=1 OR te.DepartmentstatusID =330 ) AND te.isDeleted=0

	 INSERT @ProductionOrderToReleaseMappingToComplete  
	  SELECT po.ProductionNumber, oipiir.OrderItemProductionItemIReleaseId
	  --,te.FWPONumber ,o.IsActive, te.isActive, o.CustomerName , te.DepartmentstatusID, po.ProductionOrderDate,te.LastUpdate
		 FROM picking.OrderItemProductionItemIRelease AS oipiir 
	 JOIN dbo.TranEntry AS te ON te.ID = oipiir.OrderItemId
	 JOIN dbo.[Order] AS o ON o.ID = te.OrderID
	 JOIN dbo.Departmentstatus AS do ON do.ID = o.Departmentstatusid
	 JOIN dbo.Departmentstatus AS di ON di.ID = te.DepartmentstatusID
	 JOIN picking.ProductionItem AS pi ON pi.OrderItemId = te.ID AND pi.Deleted =0 AND pi.Sandbox = oipiir.Sandbox
	 JOIN acumaticaSandboxManufacturing.ProductionOrders AS po ON pi.ProductionNbr=po.ProductionNumber AND po.DeleteFlag= 0
	 WHERE oipiir.Released=0 AND oipiir.Planned=1 AND oipiir.Completed=0 AND oipiir.Processing = 0 AND oipiir.Sandbox=1
	 AND oipiir.Revision='A'
	 AND (do.isShipped =1 OR di.Departmentid =27 OR di.StatusStageId =4 OR te.DepartmentstatusID =330  OR te.PickingDate < GETDATE())
	 AND po.ProductionStatus IN('Planned')
	 AND (te.isActive=1 OR ( te.DepartmentstatusID =330)  ) AND te.isDeleted=0
	 AND NOT EXISTS (SELECT * FROM @ProductionOrderToReleaseMappingToComplete AS potrmtr WHERE potrmtr.ProductionNumber=po.ProductionNumber AND potrmtr.OrderItemProductionItemIReleaseId=oipiir.OrderItemProductionItemIReleaseId)


 RETURN
 END
GO
/****** Object:  UserDefinedFunction [dbo].[AllAddOnsUsedForParts]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[AllAddOnsUsedForParts]( @te INT = NULL)
  
RETURNS BIT


AS
BEGIN

DECLARE @usedforparts bit;


SELECT @usedforparts = CASE WHEN EXISTS (SELECT 1 FROM dbo.TranEntry c 
							 JOIN dbo.TranEntry p ON p.OrderID = c.OrderID AND c.EZParentProdID = p.EZProdID
							 WHERE p.ID = @te AND c.ItemType NOT IN (4,9,10) AND c.DepartmentstatusID NOT IN (330) 
							 AND NOT EXISTS(SELECT 1 FROM dbo.tb_itemClassDetail ticd JOIN dbo.tb_ItemList il ON il.ShortItemCode = ticd.ItemCode WHERE ticd.ClassID = 131 AND ticd.IsActive = 1 AND il.ItemCode = c.ItemNumber))
                                         THEN 0 ELSE 1 END

return @usedforparts
			
           
END



GO
/****** Object:  UserDefinedFunction [dbo].[AllPiFromWagonHaveHistoryDroppedOff]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aro Steinmetz>
-- Create date: <3-24-2020>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[AllPiFromWagonHaveHistoryDroppedOff]
(	
	@PiWagonName VARCHAR(50)
)
RETURNS BIT
AS
BEGIN 
	
	DECLARE @returnVal BIT
	SELECT @returnVal = CAST(CASE WHEN EXISTS(
	SELECT 1 FROM picking.ProductionItemWagons AS piw
	JOIN picking.ProductionItemLocationsWagons AS pilw ON pilw.ProductionItemWagonId = piw.ProductionItemWagonId
	JOIN picking.ProductionItemLocation AS pil ON pil.ProductionItemLocationId = pilw.ProductionItemLocationId
		AND pil.Active = 1
	JOIN picking.ProductionItemLocationActivity AS pila ON pila.ProductionItemLocationId = pil.ProductionItemLocationId 
		AND pila.Active = 1
	JOIN picking.ProductionItem AS pi ON pi.ProductionItemId = pila.ProductionItemId
	WHERE piw.WagonName = @PiWagonName
	AND NOT EXISTS(
		SELECT * FROM dbo.History AS h 
		WHERE h.TranentryID = pi.OrderItemId AND h.DepartmentstatusID IN (SELECT ID FROM  picking.GetDroppedOffStatuses())))
		THEN 0 ELSE 1 END AS BIT) 
		RETURN @returnVal
END 
GO
/****** Object:  UserDefinedFunction [dbo].[BusDaysDateAdd]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[BusDaysDateAdd] 
(
   @FromDate datetime,
   @DaysToAdd int
)
RETURNS datetime
AS
BEGIN
   DECLARE @Result datetime
 
   SET @Result = DATEADD(day, (@DaysToAdd % 5) + CASE ((@@DATEFIRST + DATEPART(weekday, @FromDate) + (@DaysToAdd % 5)) % 7)
                                                 WHEN 0 THEN 2
                                                 WHEN 1 THEN 1
                                                 ELSE 0 END, DATEADD(week, (@DaysToAdd / 5), @FromDate))
 
   RETURN @Result
END
GO
/****** Object:  UserDefinedFunction [dbo].[businessHours_WorkTime]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[businessHours_WorkTime] 
(
	@StartDate DATETIME,
    @FinishDate DATETIME 
)
RETURNS BIGINT
AS
BEGIN

    DECLARE @Temp BIGINT
		
	IF @StartDate is null 
		Return @Temp 
	IF @FinishDate is null
		Return @Temp
	
    SET @Temp=0
	
    DECLARE @FirstDay DATE
    SET @FirstDay = CONVERT(DATE, @StartDate, 112)

    DECLARE @LastDay DATE
    SET @LastDay = CONVERT(DATE, @FinishDate, 112)

    DECLARE @StartTime TIME
    SET @StartTime = CONVERT(TIME, @StartDate)

    DECLARE @FinishTime TIME
    SET @FinishTime = CONVERT(TIME, @FinishDate)

    DECLARE @from1 TIME,
			@to1 TIME,
			@from2 TIME,
			@to2 TIME,
			@from3 TIME,
			@to3 TIME

	--DECLARE @DailyWorkTime BIGINT,
	--		@DailyBreakTime BIGINT,
	--		@DailyLunchTime BIGINT
	

    --SET @DailyWorkTime = DATEDIFF(MINUTE, @WorkStart, @WorkFinish)

    --IF (@StartTime<@WorkStart)
    --BEGIN
    --    SET @StartTime = @WorkStart
    --END
    --IF (@FinishTime>@WorkFinish)
    --BEGIN
    --    SET @FinishTime=@WorkFinish
    --END

    DECLARE @CurrentDate DATE
    SET @CurrentDate = @FirstDay
    DECLARE @LastDate DATE
    SET @LastDate = @LastDay


    WHILE(@CurrentDate<=@LastDate)
    BEGIN 
	  
        IF (DATEPART(dw, @CurrentDate)!=1 AND DATEPART(dw, @CurrentDate)!=7)
		BEGIN
			
			SELECT @from1 = from1, @from2 = from2, @from3 = from3, @to1 = to1, @to2 = to2, @to3 = to3
			FROM [dbo].[tb_ItemWorkingTimeInterval_TimeType] 
			WHERE DayWeek = (DATEPART(dw, @CurrentDate))
		
			IF (@CurrentDate!=@FirstDay) AND (@CurrentDate!=@LastDay)
			BEGIN
				SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @from1, @to1),0) + ISNULL(DATEDIFF(MINUTE, @from2, @to2),0) + ISNULL(DATEDIFF(MINUTE, @from3, @to3),0)   
			END

			--IF it starts at startdate and it finishes not this date find diff between work finish and start as minutes
			ELSE IF (@CurrentDate=@FirstDay) AND (@CurrentDate!=@LastDay)
			BEGIN
				IF (@StartTime > @from3)  
					SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @StartTime, @to3),0)
				ELSE IF (@StartTime > @from2)  
					SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @StartTime, @to2),0) + ISNULL(DATEDIFF(MINUTE, @from3, @to3),0)
				ELSE
					SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @StartTime, @to1),0) + ISNULL(DATEDIFF(MINUTE, @from2, @to2),0) + ISNULL(DATEDIFF(MINUTE, @from3, @to3),0)	
			END

			ELSE IF (@CurrentDate!=@FirstDay) AND (@CurrentDate=@LastDay)
			BEGIN
				IF (@FinishTime < @to1)  
					SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @from1, @FinishTime),0)
				ELSE IF (@FinishTime < @to2)  
					SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @from1, @to1),0) + ISNULL(DATEDIFF(MINUTE, @from2, @FinishTime),0)
				ELSE 
					SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @from1, @to1),0) + ISNULL(DATEDIFF(MINUTE, @from2, @to2),0) + ISNULL(DATEDIFF(MINUTE, @from3, @FinishTime),0)	
			END

			--IF it starts and finishes in the same date
			ELSE IF (@CurrentDate=@FirstDay) AND (@CurrentDate=@LastDay)
			BEGIN
				IF(@StartTime > @from3)
					BEGIN
						SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @StartTime, @FinishTime),0)
					END
				ELSE IF(@StartTime > @from2)
					BEGIN
						IF(@FinishTime < @to2)
							SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @StartTime, @FinishTime),0)
						ELSE IF (@FinishTime < @to3)
							SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @StartTime, @to2),0) + ISNULL(DATEDIFF(MINUTE, @from3, @FinishTime),0)
					END
				ELSE
					BEGIN
						IF(@FinishTime < @to1)
							SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @StartTime, @FinishTime),0)
						ELSE IF (@FinishTime < @to2)
							SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @StartTime, @to1),0) + ISNULL(DATEDIFF(MINUTE, @from2, @FinishTime),0)
						ELSE IF (@FinishTime < @to3)
							SET @Temp = @Temp + ISNULL(DATEDIFF(MINUTE, @StartTime, @to1),0) + ISNULL(DATEDIFF(MINUTE, @from2, @to2),0) + ISNULL(DATEDIFF(MINUTE, @from3, @FinishTime),0)
					END
			END
		END
        SET @CurrentDate = DATEADD(day, 1, @CurrentDate)
    END

--    -- Return the result of the function
    IF @Temp<0
    BEGIN
        SET @Temp=0
    END
   RETURN @Temp
END
GO
/****** Object:  UserDefinedFunction [dbo].[CalculateCubicFt]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[CalculateCubicFt](@width AS DECIMAL(18,2), @depth AS DECIMAL(18,2), @height AS DECIMAL(18,2))
RETURNS DECIMAL
AS
BEGIN
    RETURN (@width * @depth * @height) / 1728
END
GO
/****** Object:  UserDefinedFunction [dbo].[CalculateCubicFtNew]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[CalculateCubicFtNew](@width AS DECIMAL(18,2), @depth AS DECIMAL(18,2), @height AS DECIMAL(18,2))
RETURNS DECIMAL(18,2)
AS
BEGIN
    RETURN (@width * @depth * @height) / 1728
END
GO
/****** Object:  UserDefinedFunction [dbo].[CalTimeInStatus]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[CalTimeInStatus] (@lastUpdate datetime)
RETURNS INT
AS
BEGIN
DECLARE
@v_TimeInStatus INT,
@v_TotalHrs INT,
@v_dateTime datetime

set @v_TimeInStatus = 0
set @v_dateTime = @lastUpdate
set @v_TotalHrs = DATEDIFF(hh, @lastUpdate , getdate())
    while (@v_TotalHrs > 0)
    	begin
        	set @v_dateTime = DATEADD(hh , 1, @v_dateTime) 
        	if(datepart(weekday, @v_dateTime) != 1) AND (datepart(weekday, @v_dateTime) != 7)
            	BEGIN
                	if(convert(int, datepart(hh, @v_dateTime)) > 8 and convert(int, datepart(hh, @v_dateTime)) < 17)
                    	BEGIN        
        					set @v_TimeInStatus = @v_TimeInStatus + 1 
                        END
                END
            set @v_TotalHrs = @v_TotalHrs -1 
		END
		
 return @v_TimeInStatus

END

GO
/****** Object:  UserDefinedFunction [dbo].[CanCreateSbnWithoutSerial]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<David Edel>
-- Create date: <5/4/2020>
-- Description:	<Get rules for PI i you can create a SBN without it having a SN
--				 SN will be generated when creating the SBN>
-- =============================================
CREATE FUNCTION [dbo].[CanCreateSbnWithoutSerial]
(
	-- Add the parameters for the function here
	@orderItemId INT
)
RETURNS bit
AS
BEGIN
	-- Declare the return variable here
	DECLARE @result bit

	-- Add the T-SQL statements to compute the return value here
	SELECT @result = CAST( 
	   CASE WHEN EXISTS ( 
			SELECT 1 FROM picking.ProductionItem PI
			WHERE pi.Deleted = 0 AND PI.DestinationLocationId IN (39,48) --Glass Doors
			AND PI.OrderItemId = @orderItemId
			)
	   THEN 1 ELSE 0 END AS BIT )


	-- Return the result of the function
	RETURN @result

END



GO
/****** Object:  UserDefinedFunction [dbo].[CanDetachBin]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		David Edel
-- Create date: 3/26/2020
-- Description:	Check if we can detach a Bin from ProductionItem
--				Based on rules amd statuses
-- =============================================
CREATE FUNCTION [dbo].[CanDetachBin] 
(
	-- Add the parameters for the function here
	@binName VARCHAR(50)
)
RETURNS BIT 
AS
BEGIN
	DECLARE @orderItemId INT = (SELECT pi.OrderItemId FROM picking.ProductionItemBin PIB 
	JOIN picking.Bin B ON B.BinId = PIB.BinId AND PIB.Active = 1
	JOIN picking.ProductionItem PI ON PI.ProductionItemId = PIB.ProductionItemId
	WHERE B.BinName = @binName)

	DECLARE @result BIT

	SELECT @result =  CAST(
	CASE WHEN 
	EXISTS(
	SELECT * FROM inspection.InspectionMaster IM WHERE IM.TranEntryId = @orderItemId) 
	OR EXISTS(
	SELECT * FROM dbo.tb_ItemSeriel TIS WHERE TIS.TranEntryID = @orderItemId AND TIS.Assembled = 1)
	OR EXISTS(
	SELECT * FROM dbo.History H WHERE H.TranentryID = @orderItemId 
	AND H.DepartmentstatusID IN (SELECT TSCD.StatusID FROM dbo.tb_StatusClassDetail TSCD WHERE TSCD.ClassMasterID = 74))

	THEN 1
	ELSE 0 END AS BIT )

	RETURN @result

END
GO
/****** Object:  UserDefinedFunction [dbo].[ConvertResultSetToCommaDelimetedList]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[ConvertResultSetToCommaDelimetedList] 
(
   @List StringList READONLY  
)
RETURNS NVARCHAR(MAX)
AS
BEGIN
DECLARE @result VARCHAR(max)

SELECT @result = COALESCE(@result + ', ' , '') + l.Value FROM @List l

return @result

END
GO
/****** Object:  UserDefinedFunction [dbo].[f_ItemValues]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[f_ItemValues] ( @QBListID VARCHAR(255) )
RETURNS @T TABLE
    (
      ID INT,
      ItemType INT,
      DefaultStatus INT,
      ItemComplete BIT,
      ItemCodeDefaultValue VARCHAR(150),
	 ItemCode VARCHAR(150),
	 ShortItemCode VARCHAR(150)
    )
AS
BEGIN
    DECLARE @DefItemType INT,
            @ItemCode VARCHAR(150),
		  @ShortItemCode VARCHAR(150)

    -- set the default item type
    SELECT  @DefItemType = ISNULL(ItemTypeCode, DefaultValue),
            @ShortItemCode = ShortItemCode,
		  @ItemCode = ItemCode
    FROM    dbo.tb_ItemList
            LEFT JOIN dbo.GPSVariables
            ON VariableCode = 'DFLTITEMTYPE'
    WHERE   dbo.tb_ItemList.QBListID = @QBListID AND IsItemActive = 1;
    -- set the default item type
    
    INSERT INTO @T
            SELECT TOP 1
                    ID, @DefItemType, DefaultStatus, ItemComplete, ItemCodeDefaultValue, @ItemCode, @ShortItemCode
            FROM    dbo.tb_ItemDefaultValues
            WHERE   ItemType = @DefItemType OR
                    ItemCodeDefaultValue = @ItemCode
            ORDER BY ItemCodeDefaultValue DESC

    RETURN

END    
GO
/****** Object:  UserDefinedFunction [dbo].[f_ItemValuesWithStyle]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[f_ItemValuesWithStyle] ( @QBListID VARCHAR(255) , @style VARCHAR(50) , @standAlone BIT, @AcumaticaID INT = NULL)
RETURNS @T TABLE
    (
      ID INT,
      ItemType INT,
      DefaultStatus INT,
      ItemComplete BIT,
      ItemCodeDefaultValue VARCHAR(150),
	 ItemCode VARCHAR(150),
	 ShortItemCode VARCHAR(150)
    )
AS
BEGIN
    DECLARE @DefItemType INT = NULL,
            @ItemCode VARCHAR(150) = NULL,
		  @ShortItemCode VARCHAR(150) = NULL

    -- set the default item type

	SELECT  @DefItemType = ISNULL(ItemTypeCode, DefaultValue),
            @ShortItemCode = ShortItemCode,
		  @ItemCode = ItemCode
    FROM    dbo.tb_ItemList
            LEFT JOIN dbo.GPSVariables
            ON VariableCode = 'DFLTITEMTYPE'
    WHERE   dbo.tb_ItemList.AcumaticaID = @AcumaticaID AND IsItemActive = 1 ;

	IF @ShortItemCode IS NULL
	BEGIN
		SELECT  @DefItemType = ISNULL(ItemTypeCode, DefaultValue),
				@ShortItemCode = ShortItemCode,
			  @ItemCode = ItemCode
		FROM    dbo.tb_ItemList
				LEFT JOIN dbo.GPSVariables
				ON VariableCode = 'DFLTITEMTYPE'
		WHERE   dbo.tb_ItemList.QBListID = @QBListID AND IsItemActive = 1 ;
	END
    -- set the default item type
    
    INSERT INTO @T
            SELECT TOP 1
                    ID, @DefItemType, DefaultStatus, ItemComplete, ItemCodeDefaultValue, @ItemCode, @ShortItemCode
            FROM    dbo.tb_ItemDefaultValues dv
            WHERE   (ItemType = @DefItemType OR
                    ItemCodeDefaultValue = @ItemCode)
					 AND (StandAlone IS NULL OR StandAlone = @standAlone )
					 AND ( NOT EXISTS (SELECT 1 FROM ItemDefaultRules dr WHERE dv.ID = dr.ItemDefaultRuleID ) 
					 OR  (
					  EXISTS (  SELECT 1 FROM ItemDefaultRules dr WHERE dv.ID = dr.ItemDefaultRuleID AND dr.exclude = 1  ) AND 
					  NOT EXISTS ( SELECT 1 FROM ItemDefaultRules dr WHERE dv.ID = dr.ItemDefaultRuleID AND dr.exclude = 1 AND dr.Style = @style) 
					  )
					  OR  (
					  EXISTS (  SELECT 1 FROM ItemDefaultRules dr WHERE dv.ID = dr.ItemDefaultRuleID AND dr.exclude = 0  ) AND 
					  EXISTS ( SELECT 1 FROM ItemDefaultRules dr WHERE dv.ID = dr.ItemDefaultRuleID AND dr.exclude = 0 AND dr.Style = @style) 
					  )
					  )
            ORDER BY ItemCodeDefaultValue DESC


	--DE-718
	UPDATE t SET t.DefaultStatus = 6 
	FROM @t t
	JOIN dbo.tb_ItemList TIL ON TIL.ShortItemCode = t.ShortItemCode
	WHERE TIL.ComponentPartTypeId = 9
    RETURN

END    

GO
/****** Object:  UserDefinedFunction [dbo].[fc_GetOrderNumberFromRMA]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[fc_GetOrderNumberFromRMA]
(
	@RmaOrderNumber VARCHAR(20)
)
RETURNS @returnVal
TABLE 
(
	soNumber VARCHAR(50) NOT NULL
)
AS
BEGIN	
    INSERT INTO @returnVal
    (
        soNumber
    )
	SELECT o.LinkedQuoteNumber FROM dbo.[Order] AS o WHERE o.SOnumber = @RmaOrderNumber
	RETURN
END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_AllAccessoriesReady]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO

CREATE FUNCTION [dbo].[fn_AllAccessoriesReady]
    (
      @ORDERID INT
    )


returns bit
as
begin

declare @allReady bit = 1;

select @allReady = 
case 
when exists
(SELECT 1 FROM TRANENTRY T 
INNER JOIN tb_ItemList I ON I.ItemCode = T.ITEMNUMBER 
WHERE 
T.ORDERID = @ORDERID AND
((I.SubTypeCode NOT IN ('P','PRT','BSP','K')
AND I.ItemTypeCode = 3 AND 
DepartmentstatusID  IN (270) AND DEPARTMENTSTATUSID IN 
(SELECT STATUSID FROM tb_StatusClassMaster SCM INNER JOIN tb_StatusClassDetail SCD ON SCD.ClassMasterID = SCM.ID)
) OR I.SubTypeCode <>'3')


 ) then 1 else 0 end


return @allReady

end
--RETURNS 1 MEANS THAT NO ACCESSORIES LEFT IN PRODUCTION AND ATLEAST 1 IS STILL ON MEZANINE

--SELECT * FROM DEPARTMENTSTATUS WHERE ID = 270
GO
/****** Object:  UserDefinedFunction [dbo].[fn_AllCabinetsReady]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO

CREATE FUNCTION [dbo].[fn_AllCabinetsReady]
    (
      @ORDERID INT
    )


returns bit
as
begin

declare @allReady bit = 1;

select @allReady = 
case 
--no more items left in an order - so it's the last box in an order
(SELECT COUNT(1) 
FROM TranEntry t 
WHERE orderid = @orderid 
and itemtype =1 			
AND t.isActive = 1 AND t.isDeleted = 0  AND  t.DepartmentstatusID NOT IN(330, 23, 31)
				--NO ITEMS NOT IN A BOX YET
AND NOT EXISTS ( SELECT 1 FROM   tb_ItemGroupLablesDetail iglm WITH ( NOLOCK ) 
JOIN dbo.tb_ItemGroupLablesMaster iglh ON iglh.ID = iglm.HeaderID AND iglh.GroupType IN(1,2) AND iglh.isActive=1
										where iglm.isActive=1  and iglm.TranEntryID = t.id)
				--NO ITEMS WAITING ON ACTIVE TRACK
--AND 
--NOT 
--EXISTS(SELECT 1 FROM CABINETTRACK C WHERE C.TranEntryID = T.ID AND ACTIVE = 1)

) when 0 then 0 else 1 end

return @allReady

end
--RETURNS 1 MEANS THAT ALL ACCESSORIES ARE READY

--GROUP BY ORDERID
--having count(1)<=3 AND SUM(dbo.GetCubicftTranEntry(t.ID)) <= 25


--not shipped --order.departmentstatusid = id (is shipped)

--select * from departmentstatus where status like '%shipped%' --29
GO
/****** Object:  UserDefinedFunction [dbo].[fn_Check_itemsPassStatus]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[fn_Check_itemsPassStatus]
(		
		@p_order NVARCHAR(50),
		@p_status NVARCHAR(500),
		@p_itemType NVARCHAR(500)
)
RETURNS int
AS
BEGIN
		
		DECLARE @v_tCount int, @v_hCount int, @v_Return int

		SELECT
			@v_tCount = COUNT(ID)
		FROM TranEntry 
		WHERE
			isActive = 1 AND
			OrderIdentity = @p_order AND
			ItemType in (SELECT value from fn_MultiValueParameter(@p_itemType))

		SELECT 
			@v_hCount = COUNT(DISTINCT h.TranentryID)
		FROM 
			History h join TranEntry t
				on h.TranentryID = t.ID	
		WHERE 
			isActive = 1 AND
			t.OrderIdentity = @p_order AND
			h.DepartmentstatusID in (SELECT value FROM fn_MultiValueParameter(@p_status)) AND 
			ItemType in (SELECT value from fn_MultiValueParameter(@p_itemType))
	
		IF @v_hCount = @v_tCount
			BEGIN SET @v_Return = 1 END
		ELSE 
			BEGIN SET @v_Return = 0 END

	RETURN @v_Return
END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_CheckIfAllPartsPicked]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[fn_CheckIfAllPartsPicked]( @te INT = NULL, @type varchar(10) = 'main')
  
RETURNS bit	


AS
BEGIN

declare @ispicked bit;

	IF @type = 'main'
	BEGIN



	SELECT @ispicked = CASE WHEN  
				(SELECT count(1) FROM tb_ItemPickPrint ipp   
				JOIN  	(
						SELECT  teParts.ID as PartsID, 
						teMain.ID as MainID  
						FROM  TranEntry teMain
						JOIN TranEntry teParts
							 ON teParts.EZParentProdID = teMain.EZProdID 
							 AND teMain.ORDERID = teParts.ORDERID											   								   
						WHERE   teMain.ID = @te--5239639
						and teMain.isactive = 1 and teParts.isActive = 1 AND teParts.ItemType NOT IN (4,9)
						) parts
	 on PartsID = ipp.TranEntryID 
				WHERE IsActive = 1)
				=
				 (SELECT count(1)  FROM  
				 	(
					SELECT  teParts.ID as PartsID, 
					teMain.ID as MainID  
					FROM  TranEntry teMain
					JOIN TranEntry teParts
						 ON teParts.EZParentProdID = teMain.EZProdID 
						 AND teMain.ORDERID = teParts.ORDERID											   								   
					WHERE   teMain.ID = @te--5239639
					and teMain.isactive = 1 and teParts.isActive = 1 AND teParts.ItemType NOT IN (4,9)
					) parts
				 )
                                         THEN 1 ELSE 0 END

	END
	--if checking for just the accessory was picked
	ELSE
	BEGIN
	SET @ispicked = cASE WHEN (SELECT COUNT(1) FROM tb_ItemPickPrint where tranentryid = @te and isactive = 1) >0 THEN 0 ELSE 1 END
	END


return @ispicked
			
           
END



--select fn_CheckIfAllPartsPicked(5364711,'part')
GO
/****** Object:  UserDefinedFunction [dbo].[fn_DefaultItemStatus]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[fn_DefaultItemStatus] (@ItemCode NVARCHAR(50))
RETURNS INT
AS
  BEGIN
      /* Function body */
      DECLARE @r_itemtype INT
      DECLARE @DefaultStatus INT

      --change
      IF( Charindex('*', @ItemCode) > 0 )
        SET @itemcode = Substring(@ItemCode, 1, Charindex('*', @ItemCode) - 1)

      SET @r_itemtype = (SELECT [ItemTypeCode]
                         FROM   [dbo].[ItemList]
                         WHERE  ItemCode = @itemcode)
      SET @DefaultStatus = ( CASE @r_itemtype
                               WHEN 3 THEN 24
                               WHEN 4 THEN 57
                               WHEN 7 THEN 58
                               ELSE 6
                             END )
      RETURN @DefaultStatus
  END 
GO
-- /****** Object:  UserDefinedFunction [dbo].[fn_EZ_QuantityAnyStatus]    Script Date: 6/17/2021 11:37:56 AM ******/
-- SET ANSI_NULLS ON
-- GO
-- SET QUOTED_IDENTIFIER ON
-- GO
-- 
-- -- =============================================
-- -- Author:		Leah Wolfe
-- -- Create date: 2/11/2016
-- -- Description: 
-- -- =============================================
-- create FUNCTION [dbo].[fn_EZ_QuantityAnyStatus]
-- (	
-- 	@largeOrderSoNumbers nvarchar(500) = null,
-- 	@ListId varchar(255)
-- )
-- RETURNS int 
-- AS
-- 
-- BEGIN
-- declare @return int;
-- 
-- SELECT @return = 
-- 	--si.QBID, 
-- 	--max(si.QBFullName) QBFullName,
-- 	ISNULL(SUM(qp.Quantity),0) 
-- 
-- FROM 
-- 	fabusql02.[eFabuwood].[dbo].stockitems si WITH (nolock)  LEFT JOIN 
-- 	(
-- 		fabusql02.[eFabuwood].[dbo].Quotes q  WITH (nolock) 
-- 		JOIN fabusql02.[eFabuwood].[dbo].QuoteProducts qp WITH (nolock) 
-- 			ON q.QuoteID = qp.QuoteID AND qp.DeleteFlag = 0 and @largeOrderSoNumbers is not null 
-- 					and exists(select 1 from fabuwoodgps.dbo.fn_MultiValueParameter(@largeOrderSoNumbers) 
-- 					where LEFT(Value, CHARINDEX('/',Value)-1) = q.quotenumber)
-- 					--AND q.AccountID <> 6873 --Test Orders
-- 	) ON si.StockItemID = qp.StockItemID
-- 
-- WHERE si.qbid = @listid		
-- GROUP BY 
-- 	si.QBID --,si.QBFullName
-- 	
-- 
-- 
-- RETURN @return
-- 
-- END
-- 
-- 
-- GO
/****** Object:  UserDefinedFunction [dbo].[fn_Get_LastIGL]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO

CREATE FUNCTION [dbo].[fn_Get_LastIGL]
    (
      @ORDERID INT,
	  @waitForAccessories bit = 0
    )


returns int
as
begin

declare @lastIGL int = NULL;



--select * from departmentstatus  where status = 'ready to ship'


--no more items left in an order - so it's the last box in an order
if (select count(1) from TranEntry t where orderid = @ORDERID 
and itemtype =1 			
AND t.isActive = 1 AND t.isDeleted = 0  AND  t.DepartmentstatusID NOT IN(330, 23, 31)
				--NO ITEMS NOT IN A BOX YET
AND NOT EXISTS ( SELECT 1 FROM   tb_ItemGroupLablesDetail iglm WITH ( NOLOCK ) JOIN dbo.tb_ItemGroupLablesMaster iglh ON iglh.ID = iglm.HeaderID AND iglh.GroupType IN(1,2) AND iglh.isActive=1
										where iglm.isActive=1  and iglm.TranEntryID = t.id)

				--NO ITEMS WAITING ON ACTIVE TRACK
AND NOT EXISTS(SELECT 1 FROM CABINETTRACK C WHERE C.TranEntryID = T.ID AND ACTIVE = 1)

				--NO MORE ITEMS GOING TO Z TRACK
AND NOT EXISTS(
		SELECT 1 FROM tranentry t1 where t1 .id = t.id 
		and
		dbo.GetCubicftTranEntry(t1.id) < 21
				AND EXISTS ( 
                      SELECT 1
                           FROM  v_tranentry_noIGL  te1 ( NOLOCK )    						                                    
                           WHERE  
						   te1.OrderID = @ORDERID
                                         AND te1.isActive = 1 AND te1.isDeleted = 0 
                                         AND EXISTS 
										(SELECT 1 FROM dbo.tb_ItemList il WHERE il.ItemCode = te1.ItemNumber AND il.ItemTypeCode=1)
										 and not exists(select 1 from tb_ItemList IL WHERE te1.ItemNumber = il.itemcode AND 
											(il.itemtypecode=12 or (il.itemtypecode = 7 and il.SubTypeCode = 'pk') ) )
										 --AND NOT EXISTS (SELECT 1 FROM dbo.CabinetTrack ct1 WHERE ct1.TranEntryID=te1.ID AND ct1.Active=1)
                           GROUP BY te1.OrderID
                           HAVING COUNT(*) <= 3 AND SUM(dbo.GetCubicftTranEntry(te1.ID)) <= 25	
						   )
		)
----GROUP BY ORDERID
----having count(1)<=3 AND SUM(dbo.GetCubicftTranEntry(t.ID)) <= 25
) =0 
and case when @waitForAccessories=0 then 1 else 
--0 means not waiting for accessories
(			SELECT  count(1) --+ case when @waitForAccessories = 0 then 1 else 0 end
			FROM    dbo.TranEntry TE
        JOIN dbo.tb_ItemList IL ON TE.ItemNumber = IL.ItemCode
        JOIN dbo.Departmentstatus DS ON TE.DepartmentstatusID = DS.ID
		WHERE   TE.OrderID = @ORDERID
        AND IL.ItemTypeCode = 3 and te.isactive = 1 and te.isdeleted = 0
              AND(IL.SubTypeCode NOT LIKE 'P'
              AND IL.SubTypeCode NOT LIKE 'PRT'
              AND IL.SubTypeCode NOT LIKE 'BSP'
              AND IL.SubTypeCode NOT LIKE 'K'
			  AND IL.SubTypeCode NOT LIKE 'MM'
            )
        AND ( DS.ID <> 270 and DS.Departmentid <> 27) 
) end
>0
begin
--if count islastigl = 0 then it is waiting
select top 1  @lastigl = id from tb_ItemGroupLablesMaster where orderid = @orderid and tb_ItemGroupLablesMaster.GroupType in (1,2)
order by dateprinted desc

end

return @lastIGL

end
GO
/****** Object:  UserDefinedFunction [dbo].[fn_Get_LastIGL_old]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO

create FUNCTION [dbo].[fn_Get_LastIGL_old]
    (
      @ORDERID INT,
	  @waitForAccessories bit = 0
    )


returns int
as
begin

declare @lastIGL int = NULL;



--select * from departmentstatus  where status = 'ready to ship'


--no more items left in an order - so it's the last box in an order
if (select count(1) from TranEntry t where orderid = @ORDERID 
and itemtype =1 			
AND t.isActive = 1 AND t.isDeleted = 0  AND  t.DepartmentstatusID NOT IN(330, 23, 31)
				--NO ITEMS NOT IN A BOX YET
AND NOT EXISTS ( SELECT 1 FROM   tb_ItemGroupLablesDetail iglm WITH ( NOLOCK ) JOIN dbo.tb_ItemGroupLablesMaster iglh ON iglh.ID = iglm.HeaderID AND iglh.GroupType IN(1,2) AND iglh.isActive=1
										where iglm.isActive=1  and iglm.TranEntryID = t.id)

				--NO ITEMS WAITING ON ACTIVE TRACK
AND NOT EXISTS(SELECT 1 FROM CABINETTRACK C WHERE C.TranEntryID = T.ID AND ACTIVE = 1)

				--NO MORE ITEMS GOING TO Z TRACK
--AND NOT EXISTS(
--		SELECT 1 FROM tranentry t1 where t1 .id = t.id 
--		and
--		dbo.GetCubicftTranEntry(t1.id) < 21
--				AND EXISTS ( 
--                      SELECT 1
--                           FROM  v_tranentry_noIGL  te1 ( NOLOCK )    						                                    
--                           WHERE  
--						   te1.OrderID = @ORDERID
--                                         AND te1.isActive = 1 AND te1.isDeleted = 0 
--                                         AND EXISTS 
--										(SELECT 1 FROM dbo.tb_ItemList il WHERE il.ItemCode = te1.ItemNumber AND il.ItemTypeCode=1)
--										 and not exists(select 1 from tb_ItemList IL WHERE te1.ItemNumber = il.itemcode AND 
--											(il.itemtypecode=12 or (il.itemtypecode = 7 and il.SubTypeCode = 'pk') ) )
--										 --AND NOT EXISTS (SELECT 1 FROM dbo.CabinetTrack ct1 WHERE ct1.TranEntryID=te1.ID AND ct1.Active=1)
--                           GROUP BY te1.OrderID
--                           HAVING COUNT(*) <= 3 AND SUM(dbo.GetCubicftTranEntry(te1.ID)) <= 25	
--						   )
--		)
----GROUP BY ORDERID
----having count(1)<=3 AND SUM(dbo.GetCubicftTranEntry(t.ID)) <= 25
) =0 
and case when @waitForAccessories=0 then 1 else 
--0 means not waiting for accessories
(			SELECT  count(1) --+ case when @waitForAccessories = 0 then 1 else 0 end
			FROM    dbo.TranEntry TE
        JOIN dbo.tb_ItemList IL ON TE.ItemNumber = IL.ItemCode
        JOIN dbo.Departmentstatus DS ON TE.DepartmentstatusID = DS.ID
		WHERE   TE.OrderID = @ORDERID
        AND IL.ItemTypeCode = 3 and te.isactive = 1 and te.isdeleted = 0
              AND(IL.SubTypeCode NOT LIKE 'P'
              AND IL.SubTypeCode NOT LIKE 'PRT'
              AND IL.SubTypeCode NOT LIKE 'BSP'
              AND IL.SubTypeCode NOT LIKE 'K'
			  AND IL.SubTypeCode NOT LIKE 'MM'
            )
        AND ( DS.ID <> 270 and DS.Departmentid <> 27) 
) end
>0
begin
--if count islastigl = 0 then it is waiting
select top 1  @lastigl = id from tb_ItemGroupLablesMaster where orderid = @orderid and tb_ItemGroupLablesMaster.GroupType in (1,2)
order by dateprinted desc

end

return @lastIGL

end
GO
/****** Object:  UserDefinedFunction [dbo].[fn_GetCabinetMinutes]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Abe Perl
-- Create date: 6/18/2012
-- Description:	Function that gets the expected time in minutes for a give cabinet.
-- =============================================
CREATE FUNCTION [dbo].[fn_GetCabinetMinutes]
(
	@ItemCode NVARCHAR(50)
)
RETURNS int
AS
BEGIN
	DECLARE @Result int

	SELECT @Result = itemlist.minutes
	FROM   tranentry INNER JOIN itemlist
		   ON tranentry.itemnumber = itemcode
	WHERE tranentry.itemnumber = @ItemCode

	RETURN @Result
END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_getHingetype]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/****** Script for SelectTopNRows command from SSMS  ******/


CREATE FUNCTION [dbo].[fn_getHingetype] ( @TranID INT )
RETURNS NVARCHAR(10)
AS
    BEGIN 	
        DECLARE @Hinge NVARCHAR(10)
			
        SELECT  @Hinge = il.HingeType
        FROM    dbo.TranEntry t1
                JOIN dbo.TranEntry t2 ON t1.EZProdID = t2.EZParentProdID
                                         AND t2.OrderID = t1.OrderID
                JOIN dbo.tb_ItemList il ON t2.ItemNumber = il.ItemCode
        WHERE   t1.ID = @TranID
                AND t2.isActive = 1
                AND il.HingeType IN ( 'BLUM', 'SALICE','NEXUS' )
	RETURN @Hinge
    END 
GO
/****** Object:  UserDefinedFunction [dbo].[fn_GetItemLine]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Abe Perl
-- Create date: 6/18/2012
-- Description:	Function that extracts the line from the item code
-- =============================================
CREATE FUNCTION [dbo].[fn_GetItemLine]
(
	@ItemCode NVARCHAR(50)
)
RETURNS nvarchar(50)
AS
BEGIN
	DECLARE @Result nvarchar(50)
	DECLARE @index int

	SELECT @index = CHARINDEX(':', @ItemCode)

	IF @index > 0
		SELECT @Result = substring(@ItemCode, 1, @index - 1) 
	ELSE
		SELECT @Result = @ItemCode

	RETURN @Result
END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_GetLabelHardware_PageSize]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[fn_GetLabelHardware_PageSize](@htran INT)
RETURNS DECIMAL(18,5)
AS 

BEGIN
	DECLARE @rc DECIMAL(18,5),
			@HederFooter DECIMAL(18,5) = 4.57,
			@RowSize DECIMAL(18,5) = 0.55976,
			@rv decimal(18,5)

		SELECT @rc = Count(*)
		FROM ( 
		   SELECT 
			h.ItemId,
			COUNT (*) Count
		  FROM 
			dbo.CabinetHardware h INNER JOIN 
				dbo.tb_ItemList i
		ON i.ID = h.ItemId JOIN 
			dbo.v_TranEntryItems v
				ON h.TranEntryId = v.ID
		  WHERE
				h.TranEntryId = @htran
		  GROUP BY 
				h.ItemId
				) AS s

	SET @rv = (@rc * @RowSize) + @HederFooter
	RETURN @rv
END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_GetLabelSBN_PageSize]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[fn_GetLabelSBN_PageSize](@SBN NVARCHAR(50))
RETURNS DECIMAL(18,5)
AS 

BEGIN
	DECLARE @rc DECIMAL(18,5),
			@HederFooter DECIMAL(18,5) = 5.25 ,
			--@HederFooter DECIMAL(18,5) = 4.57,
			@RowSize DECIMAL(18,5) = 0.55976,
			@rv decimal(18,5)

		DECLARE @numericSBN INT;

	    SET @numericSBN =  stuff(@SBN, 1, patindex('%[0-9]%', @SBN)-1, '')

		SELECT @rc = Count(*)
		FROM ( 
		  SELECT 
			te.ItemNumber
		  FROM 
			[dbo].[AccessoriesBoxDetail] d JOIN 
			[dbo].[AccessoriesBoxHeader] h
				ON h.id = d.HeaderId JOIN 
			dbo.TranEntry AS te
				ON d.TranEntryId = te.ID
		  WHERE
				d.HeaderId = @numericSBN
				AND d.IsActive=1
				AND h.IsActive=1
		  GROUP BY 
				te.ItemNumber
				) AS s

	SET @rv = (@rc * @RowSize) + @HederFooter
	RETURN @rv
END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_GetLabelSBN_PageSizeNew]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE  FUNCTION [dbo].[fn_GetLabelSBN_PageSizeNew](@SBN NVARCHAR(50))
RETURNS DECIMAL(18,5)
AS 

BEGIN
	DECLARE @rc DECIMAL(18,5),
			@HederFooter DECIMAL(18,5) = 4.57,
			@RowSize DECIMAL(18,5) = 0.55976,
			@rv decimal(18,5)

		DECLARE @numericSBN INT;

	    SET @numericSBN =  stuff(@SBN, 1, patindex('%[0-9]%', @SBN)-1, '')

		SELECT @rc = Count(*)
		FROM ( 
		  SELECT 
			te.ItemNumber
		  FROM 
			[dbo].[AccessoriesBoxDetail] d JOIN 
			[dbo].[AccessoriesBoxHeader] h
				ON h.id = d.HeaderId JOIN 
			dbo.TranEntry AS te
				ON d.TranEntryId = te.ID
		  WHERE
				d.HeaderId = @numericSBN
				AND d.IsActive=1
				AND h.IsActive=1
		  GROUP BY 
				te.ItemNumber
				) AS s

	SET @rv = (@rc * @RowSize) + @HederFooter
	RETURN @rv
END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_GetNextAvailableTrack]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[fn_GetNextAvailableTrack]()
RETURNS INT
AS 
BEGIN
DECLARE @rt INT;
WITH  MinTtrack AS
(
SELECT t.id, t.Name, t.Isle , MIN(ct.DateCreated) DateCreated
 FROM dbo.Tracks t 
JOIN dbo.CabinetTrack ct ON ct.TrackID = t.ID AND ct.Active=1 -- gives back min date created
WHERE t.Isle IS NOT NULL AND t.Active =1
GROUP BY t.ID, t.Name, t.Isle
), LastIsle AS
(
SELECT TOP 1  MinTtrack.Isle, MAX(MinTtrack.DateCreated) Last 
  FROM MinTtrack 
  GROUP BY MinTtrack.Isle
  ORDER BY MAX(MinTtrack.DateCreated) DESC
 )
,AvailibleTracks AS
(SELECT *
 FROM dbo.Tracks t 
 WHERE t.Active = 1
 AND NOT EXISTS (SELECT 1 FROM dbo.CabinetTrack ct WHERE ct.Active=1 AND ct.TrackID=t.ID)
 AND t.Section='M'
)

SELECT TOP 1 @rt= AvailibleTracks.ID FROM AvailibleTracks JOIN LastIsle ON 1=1  
ORDER BY CASE WHEN AvailibleTracks.Isle IS NOT NULL AND AvailibleTracks.Isle > LastIsle.Isle THEN 0 ELSE 1 END , ISNULL(AvailibleTracks.Isle, 1000), AvailibleTracks.ID

RETURN @rt;
END
   
GO
/****** Object:  UserDefinedFunction [dbo].[fn_GetOrderPLocations]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Abe Perl
-- Create date: 4/30/2014
-- Description:	Produces comma delimited list of order pallete locations
-- =============================================
CREATE FUNCTION [dbo].[fn_GetOrderPLocations] ( @OrderID INT )
RETURNS VARCHAR(MAX)
AS
BEGIN
	-- Declare the return variable here
    DECLARE @rsltplocs VARCHAR(MAX) = ''

    SELECT  @rsltplocs = @rsltplocs + CONVERT(VARCHAR, Name) + ','
    FROM    (
              SELECT DISTINCT Location Name
			  FROM dbo.tb_ShippingLocationItems INNER JOIN [dbo].[tb_ShippingLocations]
			  ON dbo.tb_ShippingLocationItems.LocationId = dbo.tb_ShippingLocations.Id
			  WHERE OrderID = @OrderID
            ) AS ordTracks

	-- Remove last comma
    IF @rsltplocs IS NOT NULL AND
        @rsltplocs <> ''
        BEGIN
            SELECT  @rsltplocs = LEFT(@rsltplocs, LEN(@rsltplocs) - 1)
        END
    ELSE
        BEGIN
            SELECT  @rsltplocs = NULL
        END

	-- Return the result of the function
    RETURN @rsltplocs
END
GO
/****** Object:  UserDefinedFunction [dbo].[FN_GetOrderServiceTeam]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Aron Steinmetz
-- Create date: 01/13/2020
-- Description:	Get Order Service Team
-- =============================================
CREATE FUNCTION [dbo].[FN_GetOrderServiceTeam]
 (
	@orderID INT 
 )

RETURNS VARCHAR(50)
BEGIN
	DECLARE @TeamName VARCHAR(50)
	DECLARE @OrderNumber VARCHAR(50)
	SELECT @OrderNumber = o.SOnumber FROM dbo.[Order] o WHERE o.ID = @orderID
	
	SELECT  @TeamName = CASE
			   WHEN o.Modification LIKE '%\[%\]%' ESCAPE '\' THEN
				   SUBSTRING(
								o.Modification,
								CHARINDEX('[', o.Modification) + 1,
								CHARINDEX(']', o.Modification) - CHARINDEX('[', o.Modification) - 1
							)
			   ELSE
				   ''
		   END
	FROM dbo.[Order] AS o
	WHERE o.ID = @orderID
		  AND o.Modification LIKE '%\[%\]%' ESCAPE '\'

RETURN @TeamName

END;

GO
/****** Object:  UserDefinedFunction [dbo].[fn_GetOrderTracks]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Abe Perl
-- Create date: 4/30/2014
-- Description:	Produces comma delimited list of order tracks
-- =============================================
CREATE FUNCTION [dbo].[fn_GetOrderTracks] ( @OrderID INT )
RETURNS VARCHAR(MAX)
AS
BEGIN
	-- Declare the return variable here
    DECLARE @rsltTracks VARCHAR(MAX) = ''

    SELECT  @rsltTracks = @rsltTracks + CONVERT(VARCHAR(255), Name) + ','
    FROM    (
              SELECT DISTINCT
                        Name
              FROM      dbo.CabinetTrack
                        INNER JOIN dbo.Tracks
                        ON dbo.CabinetTrack.TrackID = dbo.Tracks.ID
                        INNER JOIN dbo.TranEntry
                        ON dbo.CabinetTrack.TranEntryID = dbo.TranEntry.ID
                        INNER JOIN dbo.[Order]
                        ON dbo.TranEntry.OrderID = dbo.[Order].ID
              WHERE     dbo.TranEntry.OrderID = @OrderID AND
                        dbo.CabinetTrack.Active = 1
            ) AS ordTracks

	-- Remove last comma
    IF @rsltTracks IS NOT NULL AND
        @rsltTracks <> ''
        BEGIN
            SELECT  @rsltTracks = LEFT(@rsltTracks, LEN(@rsltTracks) - 1)
        END
    ELSE
        BEGIN
            SELECT  @rsltTracks = NULL
        END

	-- Return the result of the function
    RETURN @rsltTracks
END
GO
/****** Object:  UserDefinedFunction [dbo].[FN_ITEMCODE_FULLtoSHORT]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Bryan
-- Create date: 1/16/2014
-- Modified Data 3/26/2014 
-- Description:	Convert Item Full Name to Shourt Name
-- =============================================
CREATE FUNCTION [dbo].[FN_ITEMCODE_FULLtoSHORT]
(@fullName VARCHAR(200))
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @shortName varchar(50)
	
	IF charindex(':',@fullName)=0
		set @shortName=@fullName
	else
		--set @shortName=substring(@fullName,charindex(':',@fullName)+1,len(@fullName))
		begin
		set @shortName=LEFT(REVERSE(@fullName),CHARINDEX(':',REVERSE(@fullName))-1)
		set @shortName=REVERSE(@shortName)  
		end
	RETURN @shortName
END
 
GO
/****** Object:  UserDefinedFunction [dbo].[fn_LastIgl_WaitForAcc]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Leah Wolfe
-- Create date: 2/15/2016
-- Description: 
-- =============================================
CREATE FUNCTION [dbo].[fn_LastIgl_WaitForAcc]
(	
	@batchid int
)
RETURNS @T TABLE
    (
	 BatchId int,
     ORDERID INT,
	 headerid INT,
	 IsLastIGL VARCHAR(1),
	 lastIGL int
    )
AS
BEGIN

		--return table with orderid and igl that is last for that order and field stating it's last
    INSERT INTO @T
   select distinct @batchid, orderid,id as headerid, 'O','' AS IsLastIGL from tb_ItemGroupLablesMaster where BatchPrintID = @BatchID;

   while exists(select 1 from @T where IsLastIGL = 'O')
   begin
	declare @orderid int;
	select top 1 @orderid =orderid from @T where IsLastIGL = 'O'
	update @T set lastIGL = [dbo].[fn_Get_LastIGL] (@orderid,1)  where orderid = @orderid and batchid = @batchid

	update @T set islastigl = 'Y' where headerid =  [dbo].[fn_Get_LastIGL] (@orderid,1) 
    update @T set IsLastIGL = 'N' WHERE ORDERID = @orderid AND IsLastIGL<>'y'
   end

RETURN

END
GO
/****** Object:  UserDefinedFunction [dbo].[FN_LONGtoSHORT]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Bryan
-- Create date: 4/8/2016

-- Description:	Convert long to short
-- =============================================
CREATE FUNCTION [dbo].[FN_LONGtoSHORT]
(@fullName VARCHAR(200),@char varchar(5))
RETURNS VARCHAR(150)
AS
BEGIN
	DECLARE @shortName varchar(50)
	
	IF charindex(@char,@fullName)=0
		set @shortName=@fullName
	else
		--set @shortName=substring(@fullName,charindex(':',@fullName)+1,len(@fullName))
		begin
		set @shortName=LEFT(REVERSE(@fullName),CHARINDEX(@char,REVERSE(@fullName))-1)
		set @shortName=REVERSE(@shortName)  
		end
	RETURN @shortName
END
 
GO
/****** Object:  UserDefinedFunction [dbo].[fn_MsgBoxID]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Abe Perl
-- Create date: 8/28/2013
-- Description:	Return MsgBoxID By ID
-- =============================================
CREATE FUNCTION [dbo].[fn_MsgBoxID]
(
	@MsgID int 
)
RETURNS int
AS
BEGIN
	DECLARE @ResultVar int

	SELECT @ResultVar = defaultmsgtype  
	FROM tb_msgs
	WHERE msgid = @MsgID

	RETURN @ResultVar
END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_Msgs]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Abe Perl
-- Create date: 8/20/2013
-- Description:	Return Text Msg By ID
-- =============================================
CREATE FUNCTION [dbo].[fn_Msgs]
(
	@MsgID int 
)
RETURNS varchar(4000)
AS
BEGIN
	DECLARE @ResultVar varchar(4000)

	SELECT @ResultVar = msgtext
	FROM tb_msgs
	WHERE msgid = @MsgID

	RETURN @ResultVar
END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_MultiValueParameter]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[fn_MultiValueParameter] 
	(@Parameter NVARCHAR(MAX))
RETURNS @Table TABLE (Value NVARCHAR(250))
AS
BEGIN

WHILE CHARINDEX(',',@Parameter) > 0
	BEGIN
		INSERT @Table VALUES (LEFT(@Parameter,charindex(',',@Parameter)-1))
		set @Parameter = LTRIM(SUBSTRING(@Parameter,charindex(',',@Parameter) + 1,LEN(@Parameter)))
	END

	INSERT INTO @Table VALUES (@Parameter)

RETURN
END
GO
/****** Object:  UserDefinedFunction [dbo].[FN_OrderSummary]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Abe Perl
-- Create date: 8/15/2012
-- Description:	counts per order
-- =============================================
CREATE FUNCTION [dbo].[FN_OrderSummary](@OrderID INT)
RETURNS @SumTable TABLE
   (
    OrderID     int,
    Cabinets	int,
    TallCabinets	int,
    [Services]	int,
    [AddOn]		int,
	Ready		int,
	NotReady	int,
	TCReady		int,
	TCNotReady	int,
	AccReady	int,
	AccNotReady	int
   )
AS
	BEGIN
		-- ItemType =  N'1 = cabinet, 2 = tallcabinet, 3 = accessory, 4 = service, 5 = others'
		INSERT INTO @SumTable
		SELECT TE.OrderID
			 , SUM(CASE WHEN TE.ItemType = 1 THEN 1 ELSE 0 END) Cabinets
			 , SUM(CASE WHEN TE.ItemType = 2 THEN 1 ELSE 0 END) TallCabinets
			 , SUM(CASE WHEN TE.ItemType = 4 THEN 1 ELSE 0 END) [Services]
   			 , SUM(CASE WHEN TE.DepartmentstatusID = 58 THEN 1 ELSE 0 END) [AddOn]
			 , SUM(CASE
				   WHEN TE.DepartmentstatusID IN (23, 29, 30, 31) AND ItemType = 1 THEN
					   1
				   ELSE
					   0
			   END) Ready
			 , SUM(CASE
				   WHEN TE.DepartmentstatusID NOT IN (23, 29, 30, 31) AND ItemType = 1 THEN
					   1
				   ELSE
					   0
			   END) NotReady
			 , SUM(CASE WHEN TE.DepartmentstatusID IN (23, 29, 30, 31) AND ItemType = 2 THEN 1 ELSE 0 END) TCReady
			 , SUM(CASE WHEN TE.DepartmentstatusID NOT IN (23, 29, 30, 31) AND ItemType = 2 THEN 1 ELSE 0 END) TCNotReady
			 , SUM(CASE
				   WHEN TE.DepartmentstatusID IN (23, 29, 30, 31) AND ItemType = 3 THEN
					   1
				   ELSE
					   0
			   END) AccReady
			 , SUM(CASE
				   WHEN TE.DepartmentstatusID NOT IN (23, 29, 30, 31) AND ItemType = 3 THEN
					   1
				   ELSE
					   0
			   END) AccNotReady
			FROM
				TranEntry TE
			WHERE
				TE.OrderID = @OrderID
			GROUP BY
				TE.OrderID
		RETURN
	END;
GO
/****** Object:  UserDefinedFunction [dbo].[fn_ShippingWarehouse]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[fn_ShippingWarehouse] (@OrderID INT)
	RETURNS NVARCHAR(25)
AS 
BEGIN 
	
	DECLARE @wh NVARCHAR(25)
		
	IF EXISTS ( SELECT '' FROM dbo.[Order] o WHERE o.OrderID = @OrderID AND o.TruckRouteID IN (5,6,10) AND o.ShipVia ='Delivery')
		BEGIN SET @wh = '' END 
	ELSE
		BEGIN SET @wh = '' END  
	RETURN @wh
END 
	


GO
/****** Object:  UserDefinedFunction [dbo].[fn_StatusDuration]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Abe Perl
-- Create date: 6/18/2012
-- Description:	Calculates the durations of each status
-- =============================================
CREATE FUNCTION [dbo].[fn_StatusDuration]
(
	@ItemNumber int,
	@DeptStatusID int
)
RETURNS int
AS
BEGIN
	-- Declare the return variable here
	DECLARE @StartTime datetime
	DECLARE @Duration int

	-- Add the T-SQL statements to compute the return value here
	SELECT @StartTime = MAX(Addtime)
	FROM [dbo].[History]
	WHERE TranentryID = @ItemNumber AND
	      DepartmentstatusID = @DeptStatusID


	IF EXISTS(SELECT Addtime FROM [dbo].[History]
			  WHERE TranentryID = @ItemNumber AND
	                Addtime > @StartTime)
	BEGIN
		SELECT @Duration = dbo.[HoursInStatus](@StartTime, ISNULL(MIN(Addtime), GETDATE()))
		FROM [dbo].[History]
		WHERE TranentryID = @ItemNumber AND
			  Addtime > @StartTime
	END
	ELSE
	BEGIN
		IF EXISTS(SELECT Departmentstatus.ID FROM Departmentstatus 
		          WHERE ID = @DeptStatusID AND [StopsDuration] = 1)
		BEGIN
			SELECT @Duration = 0
		END
		ELSE
		BEGIN
			SELECT @Duration = dbo.[HoursInStatus](@StartTime, ISNULL(MIN(Addtime), GETDATE()))
			FROM [dbo].[History]
			WHERE TranentryID = @ItemNumber AND
					Addtime > @StartTime
		END
	END

	-- Return the result of the function
	RETURN @Duration

END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_TranIdPreviousStatus]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[fn_TranIdPreviousStatus]
(
	-- Add the parameters for the function here
	@tranId INT
)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @StatusName VARCHAR(50)

SELECT TOP 1 @StatusName=  #temp.Status
            FROM (SELECT TOP 2 dbo.History.ID
                       ,ds.Status
                    FROM dbo.History
                       LEFT	 JOIN dbo.Departmentstatus ds ON ds.SecondID = DepartmentstatusID
                    WHERE TranentryID = @tranId
                        --AND ds.HistFlag = 0
						AND ds.ActualStatus = 1 --Changed By Lazer
                    ORDER BY dbo.History.ID DESC) AS #temp
            ORDER BY #temp.ID

	RETURN @StatusName

END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_TranIdPreviousStatus2]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[fn_TranIdPreviousStatus2]
(
		-- Add the parameters for the function here
	@tranId INT,
	@histId INT
)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @StatusName VARCHAR(50)

SELECT TOP 1 @StatusName=  #temp.Status
            FROM (SELECT TOP 2 dbo.History.ID
                       ,ds.Status
                    FROM dbo.History
                       LEFT	 JOIN dbo.Departmentstatus ds ON ds.SecondID = DepartmentstatusID
                    WHERE TranentryID = @tranId
                        --AND ds.HistFlag = 0
						AND ds.ActualStatus = 1 --Changed By Lazer
						AND History.ID <= @histId
                    ORDER BY dbo.History.ID DESC) AS #temp
            ORDER BY #temp.ID

	RETURN @StatusName

END
GO
/****** Object:  UserDefinedFunction [dbo].[fn_TranIdPreviousStatusIgnoreStatus]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE  FUNCTION [dbo].[fn_TranIdPreviousStatusIgnoreStatus]
(
	-- Add the parameters for the function here
	@tranId INT,
	@statusId IDList READONLY 
)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @StatusName VARCHAR(50)
	DECLARE @PrevStatusId VARCHAR(50)

SELECT TOP 1 @PrevStatusId=  #temp.DepartmentstatusID , @StatusName=#temp.Status
            FROM (SELECT TOP 1 dbo.History.ID
                       ,ds.Status
					   ,ds.ID AS DepartmentstatusID
                    FROM dbo.History
                       LEFT	 JOIN dbo.Departmentstatus ds ON ds.SecondID = DepartmentstatusID
                    WHERE TranentryID = @tranId
                        --AND ds.HistFlag = 0
						AND NOT EXISTS(SELECT si.ID FROM @statusId AS si WHERE si.ID=ds.ID)
					--	AND ds.ActualStatus = 1 --Changed By Lazer
                    ORDER BY dbo.History.ID DESC) AS #temp
            ORDER BY #temp.ID

	RETURN @PrevStatusId
	--RETURN @StatusName

END
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_GET_NUM]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create FUNCTION [dbo].[FNC_GET_NUM]
(@strAlphaNumeric varchar(50))
RETURNS varchar(50)
AS
BEGIN
	DECLARE @intAlpha INT
	SET @intAlpha = PATINDEX('%[^0-9]%', @strAlphaNumeric)
	BEGIN
		WHILE @intAlpha > 0
		BEGIN
			SET @strAlphaNumeric = STUFF(@strAlphaNumeric, @intAlpha, 1, '' )
			SET @intAlpha = PATINDEX('%[^0-9]%', @strAlphaNumeric )
		END
	END
	RETURN ISNULL(@strAlphaNumeric,0)
END
GO
/****** Object:  UserDefinedFunction [dbo].[fnRemoveNonNumericCharacters]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Function [dbo].[fnRemoveNonNumericCharacters](@strText VARCHAR(1000))
RETURNS VARCHAR(1000)
AS
BEGIN
    WHILE PATINDEX('%[^0-9]%', @strText) > 0
    BEGIN
        SET @strText = STUFF(@strText, PATINDEX('%[^0-9]%', @strText), 1, '')
    END
    RETURN @strText
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetAllStyleCodes]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE Function [dbo].[GetAllStyleCodes] (@OrderId as int)
returns Varchar(max)
begin
DECLARE @str as varchar(max)

--select ID,  StyleCode from tb_ItemList

select  @str = COALESCE(@str + ', ' , '') + StyleCode  
	from tb_ItemList WHERE ItemCode in
	 (SELECT ItemNumber from TranEntry where OrderID = @OrderId )
	 and ItemTypeCode  in (1, 10) AND StyleCode != 'IS'  GROUP BY StyleCode
return @str	
 
end
GO
/****** Object:  UserDefinedFunction [dbo].[GetAvailableRevisionsToMovePi]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <4-24-2020>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetAvailableRevisionsToMovePi] 
(
	@NewItemListId INT,
	@PickedItemListIds IDList READONLY
)
RETURNS 
@Revision TABLE 
(
	Revision VARCHAR(1) NOT NULL 
)
AS
BEGIN
	
	INSERT @Revision(Revision)
	
	SELECT bom.Revision FROM acumaticaManufacturing.BillOfMaterials AS bom
	JOIN dbo.tb_ItemList AS til ON bom.InventoryID = til.AcumaticaName
	WHERE til.ID = @NewItemListId
	AND NOT EXISTS(SELECT * FROM @PickedItemListIds AS pili
		WHERE NOT EXISTS(SELECT * FROM acumaticaManufacturing.BillOfMaterialDetails AS bomd
			JOIN dbo.tb_ItemList AS tild ON bomd.InventoryID = tild.AcumaticaName
			WHERE bomd.BOMID = bom.BOMID AND tild.ID = pili.ID))
	RETURN 
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetBlumSlideOnLabelDesc]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[GetBlumSlideOnLabelDesc]
    (@ItemID AS INT , @PONumber NVARCHAR(10))
RETURNS NVARCHAR(150)
AS
BEGIN
	DECLARE @rv NVARCHAR(150),
			@BlumSlide NVARCHAR(10) = NULL 

	IF @ponumber IS NULL OR EXISTS(SELECT '' FROM inventory.Po AS p WHERE @PONumber = p.PoNumber AND p.VendorID = 1310) --FAB R LIST
	BEGIN 
		SET @rv = '' 
		RETURN @rv
	END

	SELECT @BlumSlide = BlumSlide FROM  inventory.Po AS p 
	WHERE p.PoNumber = @PONumber --AND VendorListID <> '80001011-1400159930' --FAB R LIST

	SELECT 
	 @Rv = CASE 
				WHEN @BlumSlide = 'F' THEN REPLACE(il.ShortItemCode,'H','F') 
		   ELSE il.ShortItemCode END 
	FROM 
		dbo.tb_ItemParts_Detail d JOIN dbo.tb_ItemParts p
			ON d.PartID = p.ID LEFT JOIN 
		dbo.tb_ItemList il ON il.ID = d.PartItemID 

	WHERE 
		PartType = 'Slide' AND 
	--	il.Series IN ('Allure','Classic') AND
		d.ItemID = @ItemID 
	
	IF @rv IS  NULL 
		BEGIN SET @rv = '' END
		ELSE SET @rv = ' *' + @rv + '* '
			
    RETURN @rv
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetCabinetReadyCountForOrder]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetCabinetReadyCountForOrder]
(
	-- Add the parameters for the function here
	@OrderId int
)
RETURNS @ret TABLE 
(
	-- Add the column definitions for the TABLE variable here
	OrderID INT NOT NULL,
	ItemType INT NOT NULL,
	ReadyCount INT NOT NULL,
	ItemsOnOrder INT NOT NULL,
	TypeName varchar(50) NULL
)
AS
BEGIN
	-- Fill the table variable with the rows for your result set
	
	DECLARE @localOrderid  INT = @OrderId
	INSERT INTO @ret ( OrderID, ItemType, ItemsOnOrder, ReadyCount, TypeName)
	SELECT @localOrderid, te.ItemType, COUNT(*) AS ItemsOnOrder, MAX(itemsReadyOnOrder.itemsCount) ReadyCount,it.TypeName  FROM dbo.TranEntry AS te
	JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID

	JOIN dbo.ItemType AS it ON te.ItemType = it.TypeID
	OUTER APPLY
	(SELECT COUNT(*) itemsCount FROM dbo.TranEntry AS te2 
	JOIN dbo.Departmentstatus AS d2 ON d2.ID = te2.DepartmentstatusID
	LEFT JOIN dbo.tb_StatusClassDetail AS tscd ON tscd.StatusID = d2.ID AND tscd.ClassMasterID = 76
	WHERE te2.OrderID = te.OrderID AND te2.ItemType = te.ItemType AND te2.isActive = 1
	AND (tscd.ID IS NOT NULL OR ((d.Departmentid = 27 OR d.StatusStageId = 3) AND EXISTS(SELECT * FROM dbo.History AS h
	JOIN dbo.tb_StatusClassDetail sd ON sd.ClassMasterID = 76 AND sd.StatusID = h.DepartmentstatusID WHERE h.TranentryID = te2.ID )))) itemsReadyOnOrder
	WHERE te.OrderID = @localOrderid AND te.isActive = 1
	GROUP BY te.ItemType ,it.TypeName

	DECLARE @type INT = 1
	WHILE @type < 4 
	BEGIN
	  IF NOT EXISTS (SELECT * FROM @ret AS r WHERE r.ItemType = @type)
		BEGIN 
		 INSERT INTO @ret ( OrderID, ItemType, ReadyCount, ItemsOnOrder, TypeName)
		 VALUES (   @OrderId, @type, 0, 0, CASE WHEN @type = 1 THEN  'Cabinet' WHEN @type = 2 THEN 'Tall Pantry' WHEN @type = 3 THEN  'Accessory' end)
		END	
		SET @type =  @type + 1
    END	

	
	RETURN 
END


GO
/****** Object:  UserDefinedFunction [dbo].[GetCalanderDates]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetCalanderDates]
(
	@BeginDate DATETIME,
	@EndDate DATETIME
)
RETURNS
@CalanderDates TABLE 
( [Date] DATE NOT NULL)
AS
BEGIN
	INSERT @CalanderDates(date)
	SELECT d 
	FROM(SELECT d = DATEADD(DAY, rn - 1, @BeginDate) 
		FROM(SELECT TOP (DATEDIFF(DAY, @BeginDate, @EndDate + 1)) 
			rn = ROW_NUMBER() OVER (ORDER BY s1.[object_id])
	FROM sys.all_objects AS s1
    CROSS JOIN sys.all_objects AS s2
    ORDER BY s1.[object_id]
  ) AS x
) AS y;
	RETURN 
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetCountDown_2]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- Batch submitted through debugger: SQLQuery2.sql|9|0|C:\Users\JBUCHI~1\AppData\Local\Temp\~vsAA20.sql

CREATE FUNCTION [dbo].[GetCountDown_2] ( @v_orderid INT )
RETURNS INT
AS
BEGIN
  /* Function body */  

    DECLARE @v_countdown INT
  
    SELECT  @v_countdown = COUNT(itemcomplete)
    FROM    tranentry (NOLOCK) --LEFT JOIN dbo.tb_OELineDetail (NOLOCK)
	--ON dbo.TranEntry.ID = dbo.tb_OELineDetail.EntryID
    WHERE   orderid = @v_orderid AND
            itemcomplete = 'YES' AND
            DepartmentstatusID != 34 AND
            (itemtype = 1 OR StandAlone = 1) AND
            tranentry.isActive = 1
                                    
    RETURN @v_countdown
END

GO
/****** Object:  UserDefinedFunction [dbo].[GetCountDown1]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GetCountDown1] ( @v_orderid INT )
RETURNS INT
AS
BEGIN
      /* Function body */
    DECLARE @v_countdown INT

    SELECT  @v_countdown = COUNT(*)
    FROM    TranEntry
            INNER JOIN Departmentstatus
            ON Departmentstatus.ID = DepartmentstatusID
            INNER JOIN Department
            ON Department.ID = Departmentid
    WHERE   OrderID = @v_orderid AND
            Department.ID <> 27 AND
            DepartmentstatusID != 34 AND
            ItemType IN ( 1, 2 ) AND
            isActive = 'true' AND
            itemcomplete = 'YES' AND
            isIgnoreable = 0

    RETURN @v_countdown
END 
GO
/****** Object:  UserDefinedFunction [dbo].[GetCountDown-1]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GetCountDown-1] (@v_orderid INT)
RETURNS INT
AS
  BEGIN
    DECLARE @v_countdown INT

    SELECT  @v_countdown = COUNT(*)
    FROM    tranentry(NOLOCK)
            INNER JOIN departmentstatus
            ON departmentstatus.id = departmentstatusid
            INNER JOIN department
            ON department.id = departmentid
            LEFT JOIN dbo.tb_OELineDetail
            ON dbo.TranEntry.ID = dbo.tb_OELineDetail.EntryID
    WHERE   orderid = @v_orderid AND
            department.id <> 27 AND
            DepartmentstatusID != 34 AND
            (
              itemtype IN ( 1, 2 ) OR
              dbo.tb_OELineDetail.isStandAlone = 1
            ) AND
            dbo.TranEntry.isActive = 1 AND
            itemcomplete = 'YES'

    RETURN @v_countdown
  END 
GO
/****** Object:  UserDefinedFunction [dbo].[GetCountDown2]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[GetCountDown2] ( @v_orderid INT )
RETURNS INT
AS
BEGIN
  /* Function body */  

    DECLARE @v_countdown INT
  
    SELECT  @v_countdown = COUNT(itemcomplete)
    FROM    TranEntry (NOLOCK) INNER JOIN dbo.Departmentstatus AS D
		  ON TranEntry.DepartmentstatusID = D.ID
            LEFT JOIN dbo.tb_OELineDetail
            ON dbo.TranEntry.ID = dbo.tb_OELineDetail.EntryID
    WHERE   OrderID = @v_orderid AND
            itemcomplete = 'YES' AND
            DepartmentstatusID != 34 AND
            (
              ItemType = 1 OR
              dbo.tb_OELineDetail.isStandAlone = 1
            ) AND
            TranEntry.isActive = 1  AND
            d.isIgnoreable = 0
                                    
    RETURN @v_countdown
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetCubicftOrder]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GetCubicftOrder] ( @OrderID INT )
RETURNS DECIMAL(18, 2)
AS
    BEGIN

        DECLARE @rt DECIMAL(18, 2)

        DECLARE @ABC TABLE ( Cubicft DECIMAL(18,2) )


        INSERT  INTO @ABC
                SELECT  ROUND(CASE WHEN dbo.TranEntry.KD = 1 OR ItemTypeCode IN(3,12)
                                   THEN CASE WHEN ISNULL(dbo.tb_ItemList.[CubicFtKD],
                                                         0) <> 0
                                             THEN tb_ItemList.[CubicFtKD]
                                             ELSE BI.CubicFtAssemble
                                        END
                                   WHEN EXISTS ( SELECT *
                                                 FROM   tb_AdjustedBoxDimensions
                                                 WHERE  TranEntryID = TranEntry.ID )
                                   THEN dbo.GetCustomCF(TranEntry.ID)
                                   ELSE BI.CubicFtAssemble
                              END, 2) AS CubicFt
                FROM    dbo.TranEntry
                        JOIN dbo.tb_ItemList ON tb_ItemList.ItemCode = TranEntry.ItemNumber AND isActive = 1 AND DepartmentstatusID NOT IN(34)
                        LEFT OUTER JOIN ( SELECT    ItemCode ,
                                                    SUM(CubicFtAssemble) AS CubicFtAssemble
                                          FROM      dbo.ItemList AS ItemList_1
                                                    WITH ( NOLOCK )
                                          GROUP BY  ItemCode
                                        ) AS BI ON dbo.TranEntry.ItemNumber = BI.ItemCode
                WHERE   OrderID = @OrderID
        
        SELECT  @rt = SUM(Cubicft)
        FROM    @ABC
        RETURN	COALESCE(@rt,0)
    END


GO
/****** Object:  UserDefinedFunction [dbo].[GetCubicftTranEntry]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GetCubicftTranEntry] ( @TranEntryID INT )
RETURNS DECIMAL(18, 2)
AS
    BEGIN

        DECLARE @rt DECIMAL(18, 2)

        SELECT @rt= ROUND(CASE  WHEN dbo.TranEntry.KD = 1 OR ItemTypeCode IN(3,12)
                                   THEN CASE WHEN ISNULL(il.[CubicFtKD],
                                                         0) <> 0
                                             THEN il.[CubicFtKD]
                                             ELSE il.CubicFtAssemble
                                        END
									WHEN EXISTS ( SELECT 1
                                                 FROM   tb_AdjustedBoxDimensions with(NOLOCK)
                                                 WHERE  TranEntryID = TranEntry.ID 	AND ( AdjustDepth <> 0 AND AdjustWidth <> 0 OR AdjustHeight <> 0)  )
                                   THEN dbo.GetCustomCF(TranEntry.ID)                                  
                                   ELSE il.CubicFtAssemble
                              END, 2)  
                FROM    dbo.TranEntry with(NOLOCK)
                        JOIN dbo.tb_ItemList il with(NOLOCK) ON il.ItemCode = TranEntry.ItemNumber
                        --LEFT OUTER JOIN ( SELECT    ItemCode ,
                        --                            SUM(CubicFtAssemble) AS CubicFtAssemble
                        --                  FROM      dbo.ItemList AS ItemList_1
                        --                            WITH ( NOLOCK )
                        --                  GROUP BY  ItemCode
                        --                ) AS BI ON dbo.TranEntry.ItemNumber = BI.ItemCode
                WHERE   TranEntry.ID = @TranEntryID
        RETURN	@rt
    END

GO
/****** Object:  UserDefinedFunction [dbo].[GetCustomCF]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE function [dbo].[GetCustomCF] (@TranEntry as Int)
returns decimal(5,2) 
as
begin
declare @InitalW as decimal
declare @InitialL as decimal
declare @InitalH as Decimal

select @InitalW  = (isnull(bl.Width,0) + isnull(ad.AdjustWidth,0)),
@InitialL  = (isnull(bl.Length,0) + isnull(ad.AdjustDepth,0)),
@InitalH  = (isnull(bl.Height,0) + isnull(ad.AdjustHeight,0))
 from TranEntry te WITH(NOLOCK)
LEFT OUTER join dbo.tb_BoxlinkItemsNew bl WITH(NOLOCK) ON te.ItemNumber = bl.ItemCode and bl.Sort = 2
left OUTER JOIN tb_AdjustedBoxDimensions ad WITH(NOLOCK) on ad.TranEntryID = te.ID WHERE te.ID = @TranEntry 


IF @InitalW < 0 OR @InitialL < 0
BEGIN
	select @InitalW  = (isnull(bl.Width,0)  + isnull(ad.AdjustDepth,0)),
	@InitialL  = (isnull(bl.Length,0) + isnull(ad.AdjustWidth,0)),
	@InitalH  = (isnull(bl.Height,0) + isnull(ad.AdjustHeight,0))
	 from TranEntry te WITH(NOLOCK)
	LEFT OUTER join tb_BoxlinkItemsNew bl WITH(NOLOCK) ON te.ItemNumber = bl.ItemCode and bl.Sort = 2
	left OUTER JOIN tb_AdjustedBoxDimensions ad WITH(NOLOCK) on ad.TranEntryID = te.ID WHERE te.ID = @TranEntry 
END

return @InitalH * (@InitalW * @InitialL) / 1728


end

GO
/****** Object:  UserDefinedFunction [dbo].[GetDefaultItemCodesFromLocation]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[GetDefaultItemCodesFromLocation] 
(
   @locationId INT
  
)
RETURNS NVARCHAR(MAX)
AS
BEGIN
DECLARE @list VARCHAR(max)

SELECT @list = COALESCE(@list + ',' , '') + itemcode
FROM dbo.InventoryLocationDefaultItemCode WHERE LocationID = @locationid


return @list

END

GO
/****** Object:  UserDefinedFunction [dbo].[GetDetailInfoFromItemidentifier]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetDetailInfoFromItemidentifier]

(@Itemidentifier VARCHAR(50))

RETURNS @DetailInfo TABLE
		(ItemCode VARCHAR(50),
		OrderNUmber VARCHAR(50),
		Status NVARCHAR(150))
AS

BEGIN

	IF ISNUMERIC(@Itemidentifier)=1 
	BEGIN

		INSERT @DetailInfo(ItemCode, OrderNUmber, Status)
		SELECT til.ShortItemCode, te.OrderIdentity, d.Status
		FROM dbo.TranEntry AS te
			 JOIN dbo.Departmentstatus AS d ON d.ID=te.DepartmentstatusID
			 JOIN dbo.tb_ItemList AS til ON til.ItemCode=te.ItemNumber
		WHERE CAST(@Itemidentifier AS INT)=te.ID
	END

	ELSE IF @Itemidentifier LIKE 'SN%' BEGIN
			 INSERT @DetailInfo(ItemCode)
			 SELECT tis.ItemCode
			 FROM dbo.tb_ItemSeriel AS tis
			 WHERE @Itemidentifier=tis.SerielID
	END
	ELSE IF @Itemidentifier LIKE 'APN%'

	BEGIN
	    INSERT @DetailInfo(ItemCode, OrderNUmber, Status)
	    SELECT til.ShortItemCode,te.OrderIdentity,d.Status FROM dbo.tb_AccPickNumber AS tapn
		JOIN dbo.TranEntry AS te ON te.ID = tapn.TranEntryID
		JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
		JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		WHERE tapn.APN = @Itemidentifier
	END

	ELSE IF @Itemidentifier LIKE 'ABN%' BEGIN
			 INSERT @DetailInfo(ItemCode)
			 SELECT tabn.ItemCode
			 FROM dbo.tb_AccBoxNumber AS tabn
			 WHERE @Itemidentifier=tabn.ABNNumber
	END

	ELSE IF @Itemidentifier LIKE 'SBN%' BEGIN
			 INSERT @DetailInfo(OrderNUmber, Status)
			 SELECT o.SOnumber, Status.Status
			 FROM dbo.AccessoriesBoxHeader AS abh
				  JOIN dbo.[Order] AS o ON o.ID=abh.OrderId
										   AND @Itemidentifier=abh.BoxNumber
										   OUTER APPLY (
			SELECT MIN(d.Status) Status
			FROM dbo.TranEntry AS te
				JOIN dbo.AccessoriesBoxDetail AS abd2 ON abd2.TranEntryId = te.ID AND abd2.IsActive = 1
				JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
			WHERE abd2.HeaderId = abh.Id
			GROUP BY abd2.HeaderId
			HAVING COUNT(DISTINCT te.DepartmentstatusID) = 1
		) Status
	END

	RETURN
END



GO
/****** Object:  UserDefinedFunction [dbo].[GetDetailsForIGLItem]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GetDetailsForIGLItem]
(	
	@entity VARCHAR(20)
)
RETURNS @DetailsForIGLItem TABLE
(
    Entity VARCHAR(20),
    Status NVARCHAR(150),
    ItemCode VARCHAR(50),
	OrderId INT,
    OrderNumber NVARCHAR(50),
    ItemActive BIT
) 
AS
BEGIN 

IF @entity LIKE 'SBN%'
BEGIN
INSERT @DetailsForIGLItem ( Entity, Status, ItemCode,OrderId, OrderNumber, ItemActive )
SELECT  CAST(abh.BoxNumber as varchar(20)) AS Entity, Status,'' as ItemCode ,o.ID AS OrderId,o.SOnumber AS OrderNumber
, abh.IsActive AS ItemActive
FROM dbo.AccessoriesBoxHeader AS abh
 JOIN dbo.[Order] AS o ON o.ID = abh.OrderId
 OUTER APPLY(
	 SELECT d.Status  FROM dbo.TranEntry AS te
	 JOIN dbo.AccessoriesBoxDetail AS abd2 ON abd2.TranEntryId = te.ID
	 JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
	 WHERE abd2.HeaderId = abh.id
	 GROUP BY abd2.HeaderId,d.Status--,te.DepartmentstatusID
	 HAVING COUNT(DISTINCT te.DepartmentstatusID)=1
	 ) Status
 WHERE abh.BoxNumber = @entity
 END;

 ELSE IF ISNUMERIC(@entity) =1
 BEGIN
INSERT @DetailsForIGLItem ( Entity, Status, ItemCode, OrderId, OrderNumber, ItemActive ) 
SELECT CAST(te.ID AS VARCHAR(20)) AS Entity,d.Status,til.ShortItemCode AS ItemCode, o.ID AS OrderId, o.SOnumber AS OrderNumber,
te.isActive AS  ItemActive
 FROM dbo.TranEntry AS te
 JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
JOIN dbo.[Order] AS o ON o.ID = te.OrderID
JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
WHERE te.isActive = 1 AND  te.ID = CAST( @entity AS INT)
 END;

 RETURN 
END 

GO
/****** Object:  UserDefinedFunction [dbo].[GetFramesNeededForStockRefillTask]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[GetFramesNeededForStockRefillTask](	
	
)

RETURNS @StockRefillTasks TABLE
(
    ProductionItemDetailId INT,
	WagonType INT
) 
AS
BEGIN

	INSERT INTO @StockRefillTasks( ProductionItemDetailId, WagonType)
		SELECT pid.ProductionItemDetailId, CASE WHEN il.ComponentPartTypeId = 8 THEN 2 ELSE 3 END AS WagonType FROM picking.ProductionItemDetail AS pid 
		JOIN dbo.tb_ItemList AS il ON  il.ComponentPartTypeId IN(6,8) AND pid.ItemlistId = il.ID		
		JOIN picking.ProductionItem pi ON pi.ProductionItemId = pid.ProductionItemId AND pi.Deleted =0
		WHERE pid.Picked =0 AND pid.Deleted = 0
		AND 
		(
			EXISTS
			(
				SELECT * FROM picking.PickingTaskProductionItems ptpi 
				JOIN picking.PickingTaskProductionItemsDetail ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId
				WHERE ptpid.ProductionItemId=pid.ProductionItemId AND  ptpi.Active=1 AND ptpid.Active = 1 AND (ptpi.ProductionItemsPickingTaskStatusId IN(1,2) OR ptpid.Picked =1)
			)
			OR EXISTS(SELECT * FROM picking.ProductionItemDetail pid2 WHERE pid2.ProductionItemId=pi.ProductionItemId AND pid2.PickingTypeId=1 AND pid2.Picked =1)
		OR EXISTS(SELECT * FROM picking.ProductionItemBin AS pib WHERE pib.ProductionItemId = pi.ProductionItemId AND pib.Active =1)
		)
		AND pid.Picked = 0 --AND pi.Sandbox =0
		AND (pi.DestinationLocationId <> 24 OR  il.ComponentPartTypeId =8 )
		AND NOT EXISTS(SELECT * FROM picking.StockRefillTaskProductionItems AS srtpi WHERE pid.ProductionItemDetailId = srtpi.ProductionItemDetailId
			AND srtpi.Deleted = 0
		--	 AND srtpi.Picked = 0 AND srtpi.ABNSN IS NULL AND srtpi.PlacedInWagon =0 
			 )

	RETURN

END






GO
/****** Object:  UserDefinedFunction [dbo].[GetItemArrivalTime]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


CREATE function [dbo].[GetItemArrivalTime] (@itemId  varchar(255))
returns date
as
begin
declare @date as date
 

 select @date = Min(ETA) from QBDB.dbo.tb_ContainerETA where ContainerID IN (SELECT ContainerID from QBDB.dbo.tb_ItemsOnContainer where ItemCode = @itemId)
 and Received = 0
 RETURN @date
 
end

GO
/****** Object:  UserDefinedFunction [dbo].[GetItemDropLocation]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[GetItemDropLocation]
(
	@ItemId INT 
)
RETURNS INT
AS
BEGIN
	DECLARE @PickDropLocation int
	--SD-3363 Empire ROD assembled should also ggo to empire drop off even if its not KD
	SELECT @PickDropLocation = 
	CASE WHEN QuickShip.ID IS NOT NULL THEN QuickShip.ID ELSE
	dbo.GetPickDropLocation(CASE WHEN o.CustomerName IN (N'EMPIRE STATE SUPPLY CORP.' )AND ISNULL(te.PickDropLoc, 'A') NOT IN ('C','F') 
                                          AND (te.KD = 1 OR (il.ItemTypeCode = 7 AND te.ItemType = 1 AND il.ShortItemCode LIKE '%ROD%'))AND ( il.ItemTypeCode != 12 OR il.StyleCode != 'Door' )
									 THEN 'Empire'
									 WHEN o.CustomerName = N'FABU99'
									 THEN 'FABU99'
                                     WHEN o.CustomerName IN (N'Quality Control Picking' )
                                     THEN 'QC PICKING'
                                     WHEN o.CustomerName IN (N'QUALITY CONTROL ASSEMBLY' )
                                     THEN 'QC ASSEMBLY'
                                     WHEN o.CustomerName IN (N'QUALITY CONTROL RECEIVING DOCK' )
                                     THEN 'QC RECEIVING DOCK'
                                     WHEN o.CustomerName IN (N'QUALITY CONTROL PURCHASING' )
                                     THEN 'QC PURCHASING'
									 WHEN o.CustomerName IN (N'FABUWOOD QUALITY CONTROL KD' )
									 THEN 'QC KD-Inspection'
									 WHEN o.CustomerName IN (N'Quality Control 100' )
									 --THEN 'QC 100'
									  THEN 'QC PICKING'
                                     --WHEN te.ItemType = 1 AND ItemTypeCode = 7 AND il.ShortItemCode NOT LIKE 'PB ROD%' AND ISNULL(te.PickDropLoc, 'A') <> 'C' AND ISNULL(te.PickDropLoc, 'A') <> 'F'
                                     --THEN 'ROD'
									 WHEN o.CustomerName = N'Fabuwood Shop - DS Make to Stock'
									 THEN 'DS Make to Stock'
									  WHEN o.CustomerName = N'Fabuwood Shop - R Section'
									 THEN 'A'
									 WHEN o.CustomerName = 'Fabuwood Shop' AND ISNULL(te.PickDropLoc, 'A') = 'C'
									THEN 'Fabuwood-Shop'
                                     WHEN te.ItemType = 12 AND il.StyleCode = 'Drawer'
                                     THEN 'Drawer'
									 WHEN il.ComponentPartTypeId = 29 AND te.PickDropLoc NOT IN ('C', 'F') --IL-2528
									 THEN 'Inspecting Accessories'
									 WHEN il.ComponentPartTypeId = 29 AND te.PickDropLoc IN ('C', 'F') --IL-2528
									 THEN te.PickDropLoc                                   
									 WHEN te.KD =1 AND il.ItemTypeCode = 1 AND ISNULL(te.PickDropLoc, 'A') = 'A' AND il.ItemSubTypeID <> 18 AND il.ShortItemCode NOT LIKE 'FSC[2-3]'
										AND EXISTS (SELECT 1 FROM dbo.TranEntry te2 
										JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te2.ItemNumber 
										WHERE te2.OrderID= te.OrderID AND te.Style=te2.Style AND te2.isActive=1 AND il2.ItemTypeCode=1  AND te2.KD=1  HAVING COUNT(*) <=4 )
									 THEN 'KD-Shelves'
									 WHEN te.ItemType =1 AND il.ItemTypeCode = 7 AND ISNULL(te.PickDropLoc, 'A') = 'A' AND il.ShortItemCode NOT LIKE 'PB ROD%' AND il.ItemSubTypeID <> 18
										AND EXISTS (SELECT 1 FROM dbo.TranEntry te2 
										JOIN dbo.tb_ItemList il ON il.ItemCode = te2.ItemNumber AND il.ItemTypeCode=7  AND te2.ItemType =1
										WHERE te2.OrderID= te.OrderID AND te2.isActive=1 AND ISNULL(te.PickDropLoc, 'A') = 'A' AND il.ShortItemCode NOT LIKE 'PB ROD%'
											HAVING COUNT(*) <=7 )
									 THEN 'KD-Shelves'
									 WHEN te.ItemType =1 AND il.ItemTypeCode = 7 AND ISNULL(te.PickDropLoc, 'A') = 'A' AND il.ShortItemCode NOT LIKE 'PB ROD%'
									 THEN 'KD'
									 WHEN te.ItemType = 12 AND il.SubTypeCode IN ('RD','RF','DD') AND o.CustomerName IN ('Fabuwood Shop - Missing Pantry Parts') THEN 'Door Tall'
                                     WHEN te.ItemType = 12 AND o.CustomerName NOT IN( N'FABUWOOD SHOP',N'Fabuwood shop - missing parts',N'Fabuwood Shop - Missing Pantry Parts') THEN 'Door'
									 WHEN te.ItemType = 12 AND o.CustomerName IN( N'FABUWOOD SHOP' ,N'Fabuwood shop - missing parts',N'Fabuwood Shop - Missing Pantry Parts') THEN 'Shop-Doors'
									 WHEN te.PartsOnly = 1 THEN 'Item for Parts'
									 WHEN te.ItemType = 3 AND il.ShortItemCode LIKE 'PB HGS%' THEN 'Prima-HGS'
                                     WHEN te.ItemType = 3 AND il.StyleCode = 'ACC'
                                     THEN ISNULL(te.PickDropLoc, 'A')
                                     WHEN te.ItemType = 2 AND te.KD = 1 AND ( il.ShortItemCode NOT LIKE 'PB ROD%' OR il.ItemTypeCode NOT IN ( 7 ) ) AND il.ShortItemCode NOT IN ('FSC1','FSC2','FSC3','FSC4','FSC5','FSC6') AND ISNULL(te.PickDropLoc, 'A') = 'A'
                                     THEN 'KD Tall'
									 WHEN il.ItemSubTypeID = 18 AND te.KD = 1 AND ISNULL(te.PickDropLoc, 'A') = 'A' THEN 'KD Tall'
                                     WHEN (il.StyleCode = 'TP' OR EXISTS(SELECT 1 FROM dbo.tb_ItemDimensions tid
										JOIN dbo.tb_ItemList til ON til.ShortItemCode = tid.ItemCode
											WHERE til.ItemCode = te.ItemNumber AND til.ItemTypeCode = 1 AND til.IsItemActive = 1 AND (ISNULL(tid.Height,0) >= 60 OR isnull(tid.Width,0) >= 60 OR isnull(tid.Length,0) >= 60))) AND te.KD <> 1 AND ISNULL(te.PickDropLoc, 'A') = 'A'
                                     THEN 'Unpacking Tall'
                                     WHEN te.KD = 1 AND ISNULL(te.PickDropLoc, 'A') = 'A' AND ( il.ShortItemCode NOT LIKE 'PB ROD%' OR il.ItemTypeCode NOT IN ( 7 ) )
									 THEN 'KD'
									 WHEN ISNULL(te.PickDropLoc, 'A') NOT IN ('C','F','D') AND (SELECT dbo.IsInQ13Rules(te.ID)) = 1 AND te.ItemType = 1 AND (SELECT dbo.IsInProductsForQ13WallDropLocation(te.ID)) = 1
									 THEN 'Q13 Wall'
									 WHEN ISNULL(te.PickDropLoc, 'A') NOT IN ('C','F','D') AND (SELECT dbo.IsInQ13Rules(te.ID)) = 1 AND te.ItemType = 1
									 THEN 'Q13 Base'
									 WHEN  ISNULL(te.PickDropLoc, 'A') NOT IN ('C','F','D') AND EXISTS (SELECT 1 FROM dbo.tb_itemClassDetail AS ticd WHERE ticd.ItemCode = il.ShortItemCode AND ticd.ClassID = 125)
									 THEN 'Wall Unpacking'
                                     ELSE ISNULL(te.PickDropLoc, 'A') END,
		o.ShipVia, il.ItemTypeCode) END
FROM    dbo.TranEntry te
        JOIN dbo.[Order] o ON o.ID = te.OrderID
		OUTER APPLY (SELECT TPDL.ID FROM dbo.OrderShippingDetail OSD 
					JOIN dbo.tb_Warehouse TW ON TW.ID = OSD.ShipWarehouseId
					JOIN dbo.tb_PickDropLocations TPDL ON TPDL.WarehouseId = TW.ID
					WHERE osd.OrderId = o.ID AND OSD.ShipWithQuickShip = 1) QuickShip
		 JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
		 WHERE te.ID = @ItemId

	 --FF-352
IF @PickDropLocation = 19
BEGIN
	IF EXISTS
	(
		SELECT * FROM picking.OrderItemProductionItemIRelease AS oipiir
		WHERE oipiir.OrderItemId = @ItemId
		AND oipiir.Revision = 'A'
	)
	BEGIN
	    IF EXISTS
		(
			SELECT * FROM dbo.TranEntry AS te
			JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
			JOIN inventory.ProductToProductTags AS ptpt ON ptpt.ProductId = til.ProductID
			WHERE te.ID = @ItemId
			AND ptpt.DeleteFlag = 0
			AND ptpt.ProductTagId IN (77, 24)
		)
		AND NOT EXISTS
		(
			SELECT * FROM dbo.TranEntry AS te
			JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
			JOIN inventory.ProductToProductTags AS ptpt ON ptpt.ProductId = til.ProductID
			WHERE te.ID = @ItemId
			AND ptpt.DeleteFlag = 0
			AND ptpt.ProductTagId = (83)
		)
		BEGIN
			SET @PickDropLocation = 4
		END		     
	END
END

RETURN @PickDropLocation
END















GO
/****** Object:  UserDefinedFunction [dbo].[GetItemSpecs_CountOfItemsRequiredToMeasure]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 2/27/2019
-- Description:	Get Item Specs Count Of Items Required To Measure
-- =============================================
CREATE FUNCTION [dbo].[GetItemSpecs_CountOfItemsRequiredToMeasure]
(
)
RETURNS INT
AS
BEGIN
	RETURN 2
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetItemsPickedFromPo]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		David Edel
-- Create date: 5/19/21
-- Description:	https://support.fabuwood.com/requests/show/index/id/115731
-- =============================================
CREATE FUNCTION [dbo].[GetItemsPickedFromPo] 
(
	-- Add the parameters for the function here
	@poNUmber varchar(50),
	@shortItemCode varchar(50)
)
RETURNS 
@results TABLE 
(
	-- Add the column definitions for the TABLE variable here
	AbnNumber VARCHAR(50),
	PoNumber VARCHAR(50),
	ItemCode VARCHAR(50),
	PickedFromLocation VARCHAR(255),
	[OrderNumber/WoNumber] VARCHAR(50),
	[ItemNumber/FiNumber] VARCHAR(50),
	Qty INT,
	PickedTime DATETIME,
	PickedBy VARCHAR(150),
	[Item/Wo Status] VARCHAR(150)
)
AS
BEGIN
	-- Fill the table variable with the rows for your result set
	INSERT @results(AbnNumber, PoNumber, ItemCode, PickedFromLocation, [OrderNumber/WoNumber], [ItemNumber/FiNumber], Qty, PickedTime, PickedBy, [Item/Wo Status])	
	SELECT TABN.ABNNumber,TABN.PONumber, TABN.ItemCode, il.Location,O.SOnumber,te.ID,1 PickQty,TABNI.PickedTime, u.FirstName, d.Status FROM dbo.tb_AccBoxNumber TABN
	JOIN dbo.tb_AccBoxNumberItems TABNI ON TABNI.ABNID = TABN.ID
	JOIN dbo.InventoryLocation IL ON TABNI.PickedFromLocation = il.ID
	JOIN dbo.[User] U ON U.ID = TABNI.PickerUserID
	JOIN dbo.TranEntry TE ON TABNI.TranEntryID = te.ID
	JOIN dbo.Departmentstatus D ON D.ID = TE.DepartmentstatusID
	JOIN dbo.[Order] O ON O.ID = TE.OrderID
	WHERE TABNI.Picked = 1
	AND TABN.PONumber = @poNUmber AND TABN.ItemCode = @shortItemCode

	INSERT @results(AbnNumber, PoNumber, ItemCode, PickedFromLocation, [OrderNumber/WoNumber], [ItemNumber/FiNumber], Qty, PickedTime, PickedBy, [Item/Wo Status])	
	SELECT TABN.ABNNumber,TABN.PONumber, TABN.ItemCode, il.Location,O.SOnumber,te.ID,1 PickQty,TABNI.PickedTime, U.FirstName, d.Status FROM dbo.tb_AccBoxNumber TABN
	JOIN dbo.tb_AccBoxNumberItems TABNI ON TABNI.ABNID = TABN.ID
	JOIN dbo.InventoryLocation IL ON TABNI.PickedFromLocation = il.ID
	JOIN dbo.[User] U ON U.ID = TABNI.PickerUserID
	JOIN picking.ProductionItemDetail PID ON PID.ProductionItemDetailId = TABNI.ProductionItemDetailId
	JOIN picking.ProductionItem PI ON PI.ProductionItemId = PID.ProductionItemId
	JOIN dbo.TranEntry TE ON pi.OrderItemId = te.ID
	JOIN dbo.Departmentstatus D ON D.ID = TE.DepartmentstatusID
	JOIN dbo.[Order] O ON O.ID = TE.OrderID
	WHERE TABNI.Picked = 1	
	AND TABN.PONumber = @poNUmber AND TABN.ItemCode = @shortItemCode

	INSERT @results(AbnNumber, PoNumber, ItemCode, PickedFromLocation, [OrderNumber/WoNumber], [ItemNumber/FiNumber], Qty, PickedTime, PickedBy, [Item/Wo Status])	
	SELECT TABN.ABNNumber, TABN.PONumber,TABN.ItemCode, il.Location, WO.ProductionOrderNumber, WOFI.FIID, FIG.PickQty  , WOFI.FulFilledOn, ANU.FirstName + ' ' + ANU.LastName, wos.Name
	FROM manufacturing.FulfillmentItemsGroup FIG
	JOIN dbo.tb_AccBoxNumber TABN ON TABN.ID = FIG.AbnId
	JOIN manufacturing.WorkOrderFulfillmentItems WOFI ON WOFI.WorkOrderFulfillmentItemsID = FIG.FulfillmentItemId
	JOIN dbo.AspNetUsers ANU ON ANU.Id = WOFI.FulFilledBy
	JOIN dbo.InventoryLocation IL ON WOFI.PickedFromLocationId = il.ID
	LEFT JOIN manufacturing.WorkOrderMaterial WOM ON WOM.WorkOrderMaterialID = WOFI.WorkOrderMaterialId
	LEFT JOIN manufacturing.WorkOrderOperation WOO ON WOO.WorkOrderOperationID = wom.WorkOrderOperationID
	JOIN manufacturing.WorkOrder WO ON WO.WorkOrderID = WOO.WorkOrderID OR WO.WorkOrderID = WOFI.WorkOrderId
	JOIN manufacturing.WorkOrderStatus WOS ON WOS.WorkOrderStatusID = WO.WorkOrderStatusID
	WHERE TABN.PONumber = @poNUmber AND TABN.ItemCode = @shortItemCode

	RETURN 
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetItemsToRevise]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetItemsToRevise]
(
	
)
RETURNS 
@Items TABLE 
(
	-- Add the column definitions for the TABLE variable here
	OrderItemId INT, Replan BIT, ReviseRecord INT, ItemRevision VARCHAR(5)
)
AS
BEGIN
	
	INSERT @Items(OrderItemId, Replan, ReviseRecord,ItemRevision)
	SELECT te.ID, 1, ITR.ItemsToReviseId, OIPIIR.Revision FROM dbo.ItemsToRevise ITR
	JOIN dbo.TranEntry TE ON 'I-'+ CAST(ITR.QuoteProductID AS VARCHAR(25)) = te.EZProdID
	LEFT JOIN picking.OrderItemProductionItemIRelease OIPIIR ON OIPIIR.OrderItemId = TE.ID
	WHERE ITR.Processed = 0
	AND EXISTS 
	(SELECT 1 FROM dbo.EZImportChanges EIC
	WHERE EIC.QuoteProductID = te.EZProdID
	AND EIC.ChangeTime > itr.ModifiedOn
	AND EIC.Change IN ('AddedAddon','AddMod','BoxOnly', 'ChangedAddOn','ChangedMod','RemovedAddon','RemovedMod','Finish','KD'))


	INSERT @Items(OrderItemId, Replan, ReviseRecord, ItemRevision)
	SELECT te.ID, 0, ITR.ItemsToReviseId, OIPIIR.Revision FROM dbo.ItemsToRevise ITR
	JOIN dbo.TranEntry TE ON 'I-'+  CAST(ITR.QuoteProductID AS VARCHAR(25)) = te.EZProdID
	LEFT JOIN picking.OrderItemProductionItemIRelease OIPIIR ON OIPIIR.OrderItemId = TE.ID
	WHERE ITR.Processed = 0
	AND EXISTS 
	(SELECT 1 FROM dbo.EZImportChanges EIC
	WHERE EIC.QuoteProductID = te.EZProdID
	AND EIC.ChangeTime > itr.ModifiedOn)
	AND NOT EXISTS 
	(SELECT 1 FROM dbo.EZImportChanges EIC
	WHERE EIC.QuoteProductID = te.EZProdID
	AND EIC.ChangeTime > itr.ModifiedOn
	AND EIC.Change IN ('AddedAddon','AddMod','BoxOnly', 'ChangedAddOn','ChangedMod','RemovedAddon','RemovedMod','Finish','KD'))
	
	RETURN 
END






GO
/****** Object:  UserDefinedFunction [dbo].[GetItemsToReviseFromOrderId]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetItemsToReviseFromOrderId]
(
	@OrderId INT
)
RETURNS 
@Items TABLE 
(
	-- Add the column definitions for the TABLE variable here
	OrderItemId INT, Replan BIT, ReviseRecord INT, ItemRevision VARCHAR(5)
)
AS
BEGIN
	
	INSERT @Items(OrderItemId, Replan, ReviseRecord,ItemRevision)
	SELECT te.ID, 1, ITR.ItemsToReviseId, OIPIIR.Revision FROM dbo.ItemsToRevise ITR
	JOIN dbo.TranEntry TE ON 'I-'+ CAST(ITR.QuoteProductID AS VARCHAR(25)) = te.EZProdID
	LEFT JOIN picking.OrderItemProductionItemIRelease OIPIIR ON OIPIIR.OrderItemId = TE.ID
	WHERE ITR.Processed = 0
	AND EXISTS 
	(SELECT 1 FROM dbo.EZImportChanges EIC
	WHERE EIC.QuoteProductID = te.EZProdID
	AND EIC.ChangeTime > itr.ModifiedOn
	AND EIC.Change IN ('AddedAddon','AddMod','BoxOnly', 'ChangedAddOn','ChangedMod','RemovedAddon','RemovedMod','Finish','KD'))
	AND TE.OrderID = @OrderId

	INSERT @Items(OrderItemId, Replan, ReviseRecord, ItemRevision)
	SELECT te.ID, 0, ITR.ItemsToReviseId, OIPIIR.Revision FROM dbo.ItemsToRevise ITR
	JOIN dbo.TranEntry TE ON 'I-'+  CAST(ITR.QuoteProductID AS VARCHAR(25)) = te.EZProdID
	LEFT JOIN picking.OrderItemProductionItemIRelease OIPIIR ON OIPIIR.OrderItemId = TE.ID
	WHERE ITR.Processed = 0
	AND EXISTS 
	(SELECT 1 FROM dbo.EZImportChanges EIC
	WHERE EIC.QuoteProductID = te.EZProdID
	AND EIC.ChangeTime > itr.ModifiedOn)
	AND NOT EXISTS 
	(SELECT 1 FROM dbo.EZImportChanges EIC
	WHERE EIC.QuoteProductID = te.EZProdID
	AND EIC.ChangeTime > itr.ModifiedOn
	AND EIC.Change IN ('AddedAddon','AddMod','BoxOnly', 'ChangedAddOn','ChangedMod','RemovedAddon','RemovedMod','Finish','KD'))
	AND TE.OrderID = @OrderId

	RETURN 
END






GO
/****** Object:  UserDefinedFunction [dbo].[GetMaxValue]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[GetMaxValue](
@a INT,
@b int
 )
 RETURNS INT
 AS
 BEGIN
     IF @a > @b
	 BEGIN
	     RETURN @a
	 END
	 
	RETURN @b
	 
 END
GO
/****** Object:  UserDefinedFunction [dbo].[GetMinValue]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[GetMinValue](
@a INT,
@b int
 )
 RETURNS INT
 AS
 BEGIN
     IF @a < @b
	 BEGIN
	     RETURN @a
	 END
	 
	RETURN @b
	 
 END
GO
/****** Object:  UserDefinedFunction [dbo].[GetNewEtaForBackorder]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron Steinmetz>
-- Create date: <1/30/2020>
-- Description:	<Retuns a new ETA for a backorder>
-- =============================================
CREATE FUNCTION [dbo].[GetNewEtaForBackorder]
(
	@OriginalPickdate DATE,
	@OriginalETA DATE,
	@NewPickDate DATE
)
RETURNS 
DATE 
AS
BEGIN
	IF @OriginalPickdate IS NULL OR @OriginalETA IS NULL OR @NewPickDate IS NULL OR @OriginalPickdate > @OriginalETA
	BEGIN
	    RETURN NULL
	END
	DECLARE	@LeadTime INT, @NewETA DATE	

	SELECT @LeadTime = COUNT(*) 
	FROM dbo.GetCalanderDates(@OriginalPickdate, @OriginalETA) AS gcd
	WHERE EXISTS (SELECT * FROM dbo.WorkingDays AS wd WHERE wd.Date =  gcd.date);
	IF @LeadTime < 1 OR @LeadTime IS NULL
	BEGIN
		RETURN NULL	    
	END
	SELECT @NewETA = wd.Date FROM dbo.WorkingDays AS wd WHERE wd.Date >= @NewPickDate ORDER BY wd.Date
	OFFSET @LeadTime - 1 ROWS FETCH NEXT 1 ROWS ONLY
	RETURN @NewETA
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetNextBussinessDay]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 7/30/2018
-- Description:	Get Next Bussiness Day
-- =============================================
CREATE FUNCTION [dbo].[GetNextBussinessDay]
(
)
RETURNS DATETIME
AS
BEGIN
	DECLARE @date DATE= GETDATE() 

	RETURN DATEADD(dd,CASE WHEN DATEDIFF(dd,0,@date)%7 > 3 THEN 7-DATEDIFF(dd,0,@date)%7 ELSE 1 END,@date)

END
GO
/****** Object:  UserDefinedFunction [dbo].[GetNextGroupOfAssignedTasks]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetNextGroupOfAssignedTasks] 
(
	@LoginId NVARCHAR(128),
	@WagonTypeId INT
)
RETURNS 
@usersTasksGroup TABLE
(
	StockRefillTaskProductionItemId INT,
	PIId VARCHAR(50),
	ProductionItemDetailId INT,
	ItemCode NVARCHAR(150),
	IsleNumeric INT,
	RackNumeric INT,
	DestinationLocationId INT,
	DestinationLocationName VARCHAR(50),
	Location NVARCHAR(255),
	Wagon NVARCHAR(255),
	Isle NVARCHAR(255)
)
AS
BEGIN
DECLARE @wagons StringList
INSERT @wagons 
SELECT rw.WagonName FROM inventory.RackWagon AS rw WHERE rw.IsleNumeric IS NOT NULL

DECLARE @closestTask TABLE(ItemCode NVARCHAR(150), DestinationLocationId INT)
DECLARE @usersTasks TABLE
(
	StockRefillTaskProductionItemId INT,
	PIId VARCHAR(50),
	ProductionItemDetailId INT,
	ItemCode NVARCHAR(150),
	IsleNumeric INT,
	RackNumeric INT,
	DestinationLocationId INT,
	DestinationLocationName VARCHAR(50),
	Location NVARCHAR(255),
	Wagon NVARCHAR(255),
	Isle NVARCHAR(255)
)
INSERT @usersTasks(StockRefillTaskProductionItemId, PIId, ProductionItemDetailId, ItemCode, IsleNumeric, RackNumeric,
DestinationLocationId, DestinationLocationName, Location, Wagon, Isle)
SELECT srtpi.StockRefillTaskProductionItemId, pi.PIId, pid.ProductionItemDetailId, til.ShortItemCode AS ItemCode, COALESCE(wagon.IsleNumeric, loc.IsleNumeric) AS IsleNumeric,
 COALESCE(wagon.RackNumeric, loc.RackNumeric) AS RackNumeric, dl.DestinationLocationId, dl.DestinationLocationName,  COALESCE(wagon.Location, loc.Location), wagon.WagonName AS Wagon, wagon.Isle AS Isle
FROM Picking.StockRefillTaskProductionItems AS srtpi
JOIN Picking.ProductionItemDetail AS pid ON srtpi.ProductionItemDetailId = pid.ProductionItemDetailId AND pid.Deleted = 0
JOIN dbo.tb_ItemList AS til ON pid.ItemlistId = til.ID
JOIN Picking.ProductionItem AS pi ON pid.ProductionItemId = pi.ProductionItemId
JOIN Picking.DestinationLocation AS dl ON pi.DestinationLocationId = dl.DestinationLocationId
JOIN inventory.RackWagonTypes AS rwt ON srtpi.WagonTypeId = rwt.RackWagonTypeId
OUTER APPLY(SELECT TOP (1) il.Location, il.IsleNumeric, il.RackNumeric 
	FROM  dbo.ItemLocationsUpdate AS ilu 
	JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
	WHERE  ilu.ItemCode = til.ShortItemCode AND ilu.Quantity > 0 AND il.ExcludeFrmStock=0
	AND EXISTS (SELECT * FROM dbo.InventoryLocationDefaultItemCode AS ildic 
		WHERE ildic.LocationID=il.ID AND ildic.ItemCode=ilu.ItemCode ))loc

OUTER APPLY(SELECT TOP (1)il.Location, rw.WagonName, rw.IsleNumeric, rw.RackNumeric, rw.Isle FROM dbo.InventoryLocation AS il 
 JOIN dbo.ItemLocationsUpdate AS ilu ON ilu.Location = il.Location
JOIN inventory.RackWagonLocations AS rwl ON rwl.LocationId = il.ID
JOIN inventory.RackWagon AS rw ON rw.WagonId = rwl.WagonId                       
WHERE rw.WagonName IN(SELECT Value FROM @wagons)
AND rwl.Active = 1 AND il.IsActive = 1 AND ilu.ItemCode = til.ShortItemCode AND ilu.Quantity > 0 --AND il.ExcludeFrmStock = 0
GROUP BY il.Location,
         rw.WagonName,
         rw.IsleNumeric,
         rw.RackNumeric,
         rw.Isle) wagon
WHERE @LoginId = srtpi.Assigned AND srtpi.Deleted = 0 AND srtpi.ABNSN IS NULL AND srtpi.PlacedInWagon <> 1 AND @WagonTypeId = srtpi.WagonTypeId
INSERT @closestTask(ItemCode, DestinationLocationId)
SELECT TOP (1) t.ItemCode, t.DestinationLocationId FROM @usersTasks AS t
ORDER BY CASE WHEN t.Wagon IS NOT NULL THEN 0 ELSE 1 END,
t.IsleNumeric, t.RackNumeric
INSERT @usersTasksGroup
(
    StockRefillTaskProductionItemId,
    PIId,
    ProductionItemDetailId,
    ItemCode,
    IsleNumeric,
    RackNumeric,
    DestinationLocationId,
    DestinationLocationName,
    Location,
	Wagon,
	Isle
)
SELECT t.StockRefillTaskProductionItemId,
       t.PIId,
       t.ProductionItemDetailId,
       t.ItemCode,
       t.IsleNumeric,
       t.RackNumeric,
       t.DestinationLocationId,
       t.DestinationLocationName,
       t.Location,
	   t.Wagon,
	   t.Isle 
FROM @usersTasks AS t WHERE EXISTS(SELECT * FROM @closestTask AS ct 
WHERE ct.ItemCode = t.ItemCode AND ct.DestinationLocationId = t.DestinationLocationId)
	
	RETURN 
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetNextGroupOfAssignedTasksTest]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE  FUNCTION [dbo].[GetNextGroupOfAssignedTasksTest] 
(
	@LoginId NVARCHAR(128),
	@WagonTypeId INT
)
RETURNS 
@usersTasksGroup TABLE
(
	StockRefillTaskProductionItemId INT,
	PIId VARCHAR(50),
	ProductionItemDetailId INT,
	ItemCode NVARCHAR(150),
	IsleNumeric INT,
	RackNumeric INT,
	DestinationLocationId INT,
	DestinationLocationName VARCHAR(50),
	Location NVARCHAR(255),
	Wagon NVARCHAR(255)
)
AS
BEGIN
DECLARE @wagons StringList
INSERT @wagons 
SELECT rw.WagonName FROM inventory.RackWagon AS rw WHERE rw.IsleNumeric IS NOT NULL AND rw.RackNumeric IS NOT NULL

DECLARE @closestTask TABLE(ItemCode NVARCHAR(150), DestinationLocationId INT)
DECLARE @usersTasks TABLE
(
	StockRefillTaskProductionItemId INT,
	PIId VARCHAR(50),
	ProductionItemDetailId INT,
	ItemCode NVARCHAR(150),
	IsleNumeric INT,
	RackNumeric INT,
	DestinationLocationId INT,
	DestinationLocationName VARCHAR(50),
	Location NVARCHAR(255),
	Wagon NVARCHAR(255)
)
INSERT @usersTasks(StockRefillTaskProductionItemId, PIId, ProductionItemDetailId, ItemCode, IsleNumeric, RackNumeric,
DestinationLocationId, DestinationLocationName, Location, Wagon)
SELECT srtpi.StockRefillTaskProductionItemId, pi.PIId, pid.ProductionItemDetailId, til.ShortItemCode AS ItemCode, loc.IsleNumeric,
loc.RackNumeric, dl.DestinationLocationId, dl.DestinationLocationName,  COALESCE(wagon.WagonName, loc.Location), wagon.WagonName AS Wagon
FROM Picking.StockRefillTaskProductionItems AS srtpi
JOIN Picking.ProductionItemDetail AS pid ON srtpi.ProductionItemDetailId = pid.ProductionItemDetailId AND pid.Deleted = 0
JOIN dbo.tb_ItemList AS til ON pid.ItemlistId = til.ID
JOIN Picking.ProductionItem AS pi ON pid.ProductionItemId = pi.ProductionItemId
JOIN Picking.DestinationLocation AS dl ON pi.DestinationLocationId = dl.DestinationLocationId
JOIN inventory.RackWagonTypes AS rwt ON srtpi.WagonTypeId = rwt.RackWagonTypeId
OUTER APPLY(SELECT TOP (1) il.Location, il.IsleNumeric, il.RackNumeric 
	FROM  dbo.ItemLocationsUpdate AS ilu 
	JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
	WHERE  ilu.ItemCode = til.ShortItemCode AND ilu.Quantity > 0 AND il.ExcludeFrmStock=0
	AND EXISTS (SELECT * FROM dbo.InventoryLocationDefaultItemCode AS ildic 
		WHERE ildic.LocationID=il.ID AND ildic.ItemCode=ilu.ItemCode ))loc

OUTER APPLY(SELECT TOP (1) rw.WagonName, rw.IsleNumeric, rw.RackNumeric FROM dbo.InventoryLocation AS il 
 JOIN dbo.ItemLocationsUpdate AS ilu ON ilu.Location = il.Location
JOIN inventory.RackWagonLocations AS rwl ON rwl.LocationId = il.ID
JOIN inventory.RackWagon AS rw ON rw.WagonId = rwl.WagonId                       
WHERE rw.WagonName IN(SELECT Value FROM @wagons)
AND rwl.Active = 1 AND il.IsActive = 1 AND ilu.ItemCode = til.ShortItemCode AND ilu.Quantity > 0 --AND il.ExcludeFrmStock = 0
GROUP BY rw.WagonName,
         rw.IsleNumeric,
         rw.RackNumeric) wagon
WHERE @LoginId = srtpi.Assigned AND srtpi.Deleted = 0 AND srtpi.ABNSN IS NULL AND srtpi.PlacedInWagon <> 1 AND @WagonTypeId = srtpi.WagonTypeId
INSERT @closestTask(ItemCode, DestinationLocationId)
SELECT TOP (1) t.ItemCode, t.DestinationLocationId FROM @usersTasks AS t
ORDER BY CASE WHEN t.Wagon IS NOT NULL THEN 0 ELSE 1 END,
t.IsleNumeric, t.RackNumeric
INSERT @usersTasksGroup
(
    StockRefillTaskProductionItemId,
    PIId,
    ProductionItemDetailId,
    ItemCode,
    IsleNumeric,
    RackNumeric,
    DestinationLocationId,
    DestinationLocationName,
    Location,
	Wagon
)
SELECT t.StockRefillTaskProductionItemId,
       t.PIId,
       t.ProductionItemDetailId,
       t.ItemCode,
       t.IsleNumeric,
       t.RackNumeric,
       t.DestinationLocationId,
       t.DestinationLocationName,
       t.Location,
	   t.Wagon 
FROM @usersTasks AS t WHERE EXISTS(SELECT * FROM @closestTask AS ct 
WHERE ct.ItemCode = t.ItemCode AND ct.DestinationLocationId = t.DestinationLocationId)
	
	RETURN 
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetNumericCharacters]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
 CREATE Function [dbo].[GetNumericCharacters](@Input VARCHAR(1000))
    Returns VarChar(1000)
    AS
    Begin

        While PatIndex('%[^0-9]%', @Input) > 0
            Set @Input = Stuff(@Input, PatIndex('%[^0-9]%', @Input), 1, '')

        Return @Input
    End
GO
/****** Object:  UserDefinedFunction [dbo].[GetOrderBoxCount]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GetOrderBoxCount] ( @OrderID INT )
RETURNS INT
AS
    BEGIN
  
  	  DECLARE @BoxCount INT

              
SELECT @BoxCount = (   SELECT   
         COUNT(*)
              
                                                              
                           FROM dbo.TranEntry te
                           WHERE OrderID = @OrderID
                           AND te.isActive = 1  
                           AND te.ItemType NOT IN (4, 0, 11, 9)
                                            AND NOT EXISTS (SELECT 1 FROM dbo.AccessoriesBoxHeader abh
                                        JOIN dbo.AccessoriesBoxDetail abd2 ON abh.Id = abd2.HeaderId
                                        WHERE abh.OrderId = te.OrderID 
                                        AND abd2.TranEntryId = te.ID
                                        AND abh.isActive = 1 AND abd2.IsActive=1) 
                                                                     ) + 


  ( SELECT COUNT(DISTINCT abh.Id) FROM dbo.AccessoriesBoxHeader abh
                                        JOIN dbo.AccessoriesBoxDetail abd2 ON abh.Id = abd2.HeaderId
                                         JOIN dbo.TranEntry te2 ON te2.ID = abd2.TranEntryId AND te2.isActive=1
                                        WHERE abh.OrderId = @OrderID
                                        AND abh.isActive = 1 AND abd2.IsActive=1)
										RETURN @BoxCount
										 END
GO
/****** Object:  UserDefinedFunction [dbo].[GetOrderEarliestEtaByItemTypeNew]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		David Edel
-- Create date: 6/1/2020
-- Description:	IL-3672
-- =============================================

CREATE  FUNCTION [dbo].[GetOrderEarliestEtaByItemTypeNew](
-- Add the parameters for the function here
@orderId INT)
RETURNS @EarliestEtaByItemType TABLE
(
	ItemType INT NOT NULL,
	TypeName VARCHAR(50) NOT NULL,
	EarliestEta DATE NULL
)
AS
BEGIN
 DECLARE @NewEtaOrderIds TABLE (OrderItemId INT NOT NULL , ItemType INT NOT NULL, EarliestEta DATE NULL)
      INSERT @NewEtaOrderIds(OrderItemId,ItemType,EarliestEta)
     
      SELECT  te.ID, TE.ItemType,
	  dbo.GetNewEtaForBackorder(TE.PickingDate, O.EstimatedCompleteDate,
	   CASE
	    
		--eta of the item is before or after picking date, give eta as new picking date
	    WHEN ASITOI.Eta IS NOT NULL AND ASITOI.Eta <> TE.PickingDate THEN ASITOI.Eta 

		--We have stock
		WHEN ASITOI.Eta IS NULL AND ASITOI.Action <> 'NoStock' THEN GETDATE()

		--We have no current or future stock
		WHEN ASITOI.Eta IS NULL AND ASITOI.Action = 'NoStock' THEN NULL
		

	   ELSE te.PickingDate END) EarliestEta
      FROM dbo.TranEntry TE
           JOIN dbo.[Order] O ON O.ID=TE.OrderID
		   LEFT JOIN dbo.AssignStockItemToOrderItem ASITOI ON ASITOI.TranentryId=TE.ID
     --      JOIN dbo.ItemType IT ON TE.ItemType=IT.TypeID
	--	   JOIN dbo.Departmentstatus D ON D.ID = O.Departmentstatusid
      WHERE O.OrderID=@orderId
	  -- AND d.isShipped = 0
	  AND TE.ItemType IN (1,2,3,7,12) AND te.isDeleted = 0 AND te.isActive = 1 AND o.IsActive = 1 
  --    GROUP BY TE.ItemType, IT.TypeName;

  INSERT @EarliestEtaByItemType(ItemType,TypeName,EarliestEta)
  SELECT neoi.ItemType, it.TypeName, MAX(neoi.EarliestEta) FROM @NewEtaOrderIds AS neoi 
  JOIN dbo.ItemType AS it ON it.TypeID=neoi.ItemType
  GROUP BY neoi.ItemType , it.TypeName 
	  RETURN

END








GO
/****** Object:  UserDefinedFunction [dbo].[GetOrderItemConfigTabulated]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <11-17-2020>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetOrderItemConfigTabulated] 
(
	@OrderItemId INT
)
RETURNS 
@ReturnVal TABLE 
(
	ConfigType VARCHAR(4000), ConfigKey VARCHAR(4000), ConfigValue VARCHAR(4000), AddTime DATETIME, LastUpdatedTime DATETIME, OrderItemId INT
)
AS
BEGIN
	
	DECLARE @string VARCHAR(8000)
	DECLARE @configs TABLE(Rownum BIGINT, ConfigType VARCHAR(50), ConfigValue VARCHAR(8000), AddTime DATETIME, LastUpdatedTime DATETIME, Updated BIT,  OrderItemId INT)
	INSERT @configs(Rownum,  ConfigType, ConfigValue, AddTime, LastUpdatedTime, Updated, OrderItemId)
	SELECT ROW_NUMBER() OVER(ORDER BY oic.ConfigType,oic.ConfigValue), oic.ConfigType, 
	--TRIM(REPLACE(oic.ConfigValue, '*', '')), 
	TRIM
	(
	CASE 
		WHEN oic.ConfigValue LIKE '%** Location % **%' 
			THEN REPLACE(REPLACE(oic.ConfigValue, '** Location ', 'Location ['), ' **', ']') 
		WHEN oic.ConfigValue LIKE '%Cut%to%' AND oic.ConfigValue LIKE '%"%'
			THEN REPLACE(REPLACE(REPLACE(oic.ConfigValue, 'to', '['), '"', ']'), '*', '')
		ELSE 
			REPLACE(oic.ConfigValue, '*', '') 
	END
	), 
	oic.AddTime, oic.LastUpdateTime, 0, oic.TranentryId 
	FROM dbo.OrderItemConfig AS oic
	WHERE EXISTS
	(
		SELECT te.ID, te.ItemNumber, te2.* FROM dbo.TranEntry AS te
		LEFT JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID AND te.EZProdID = te2.EZParentProdID AND te2.isDeleted = 0
		WHERE te.ID = @OrderItemId
		AND oic.TranentryId IN (te.ID, te2.ID)
	)	
	AND oic.DeleteFlag = 0
	AND 
	(
		(
			CHARINDEX('[', oic.ConfigValue) > 0 
			AND CHARINDEX(']', oic.ConfigValue) > CHARINDEX('[', oic.ConfigValue)
		)
		OR
        (
			oic.ConfigValue LIKE '%Cut%to%'
			AND oic.ConfigValue LIKE '%"%'
		)
		OR
        (
			oic.ConfigValue LIKE '%Location%'
		)
	)


	WHILE EXISTS (SELECT * FROM @configs AS c WHERE c.Updated = 0)
	BEGIN
	    DECLARE @config TABLE(Rownum BIGINT, ConfigType VARCHAR(50), ConfigValue VARCHAR(8000), AddTime DATETIME, LastUpdatedOn DATETIME, OrderItemId INT)
		INSERT @config(Rownum, ConfigType, ConfigValue, AddTime, LastUpdatedOn, OrderItemId)
		SELECT TOP (1) c.Rownum, c.ConfigType, c.ConfigValue, c.AddTime, c.LastUpdatedTime, c.OrderItemId
		FROM @configs AS c
		WHERE c.Updated = 0
		SELECT @string =  c.ConfigValue FROM @config AS c
		
		DECLARE @char CHAR(1)
		DECLARE @ConfigKey VARCHAR(4000) = '', @ConfigValue VARCHAR(4000) = ''
		DECLARE @ToKey BIT = 1
		WHILE EXISTS(SELECT 1 WHERE LEN(@string) > 0)
		BEGIN

			SET @char = LEFT(@string, 1)
			IF @char = '['
			BEGIN
				SET @ToKey = 0
			END
			ELSE IF @char = ']'
			BEGIN
				INSERT @ReturnVal(ConfigType, ConfigKey, ConfigValue, AddTime, LastUpdatedTime, OrderItemId)
				SELECT c.ConfigType, TRIM(@ConfigKey), TRIM(@ConfigValue), c.AddTime, c.LastUpdatedOn, c.OrderItemId
				FROM @config AS c
				SET @ToKey = 1
				SET @ConfigKey = ''
				SET @ConfigValue = ''
			END
			ELSE IF @char = ','
			BEGIN
				INSERT @ReturnVal(ConfigType, ConfigKey, ConfigValue, AddTime, LastUpdatedTime, OrderItemId)
				SELECT c.ConfigType, TRIM(@ConfigKey), TRIM(@ConfigValue), c.AddTime, c.LastUpdatedOn, c.OrderItemId
				FROM @config AS c
				SET @ConfigValue = ''
			END

			IF @char NOT IN ('[', ']', ',')
			BEGIN
				IF @ToKey = 1
				BEGIN
					SET @ConfigKey = @ConfigKey + @char
				END
				ELSE
				BEGIN
					SET @ConfigValue = @ConfigValue + @char
				END
			END
	
			SET @string = RIGHT(@string, LEN(@string) - 1)



		END
		UPDATE @configs SET Updated = 1 WHERE Rownum IN (SELECT c.Rownum FROM @config AS c)
		DELETE @config
	
	END
		RETURN 
	END
GO
/****** Object:  UserDefinedFunction [dbo].[GetOrderItemDetails]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:      Yakov Muller
-- Create date: 5/20/2019
-- Description: Get OrderItem Details
-- =============================================
CREATE FUNCTION [dbo].[GetOrderItemDetails]
(
    @orderId INT
)
RETURNS @OrderItemDetails TABLE(
    ItemNumber INT NOT NULL,
    ItemCode VARCHAR(50) NOT NULL,
    ItemDescription VARCHAR(2000),
    ItemType INT,
    SubstitutedItemCode VARCHAR(50) NULL,
    PONumber VARCHAR(50) NULL,
    Status VARCHAR(150),
    StatusId INT NOT NULL,
    KD BIT NOT NULL,
    UpdateBy VARCHAR(150),
    LastUpdatedTime DATETIME,
    SnApn VARCHAR(50) NULL,
    Abn VARCHAR(50) NULL,
    PGLLabelID VARCHAR(50)NULL,
    Igl_OP VARCHAR(50) NULL,
    Igl_Ship VARCHAR(50) NULL,
    CGL VARCHAR(50) NULL,
    CCOPL VARCHAR(50) NULL,
    ShippingLocation VARCHAR(50) NULL,
    ShippingLocationTypeName VARCHAR(50) NULL,
    PickingTaskId INT NULL,
    SBN VARCHAR(50) NULL,
    Active BIT NOT NULL,
    Deleted BIT NOT NULL,
    OnHold BIT NULL,
    Customizing BIT NULL,
    Finishing BIT NULL,
    CubicFt DECIMAL(18,2) NULL, 
    Weight DECIMAL(18,2) NULL,
    Hinge VARCHAR(50) NULL,
    ExposedSide VARCHAR(50) NULL,
    PickingDate DATE NULL,
    BackOrdered BIT NULL,
    PreviousStatus VARCHAR(150) NULL,
    ColorHex NVARCHAR(25) NULL,
    Sort INT NOT NULL,
    HasComments BIT NULL,
    ProductionItemId INT NULL,
    PIId NVARCHAR(50) NULL,
    Picked BIT NOT NULL,
    ClassificationCode VARCHAR(10) NULL,
    ConstructionClassification VARCHAR(1000) NULL,
    ProductionItemLocationTypeName VARCHAR(50) NULL,
    Revision VARCHAR(50) NULL,
    RevisionChange VARCHAR(50) NULL,
    ItemTypeName VARCHAR(150),
    DestinationLocationName VARCHAR(150),
    BinName VARCHAR(50) NULL,
    PIStatus VARCHAR(50) NULL,  
    PIStatusColor VARCHAR(50) NULL,
    PickDropLocation VARCHAR(150) NULL,
    DoorStyleID INT NULL,
    AssemblerName VARCHAR(50) NULL,
    HelperName VARCHAR(50) NULL,
    TrackingLocationName NVARCHAR(50),
    ParentItemNumber INT NULL
)
--AS 
BEGIN
    DECLARE @localOrderId INT = @orderId
    INSERT @OrderItemDetails ( ItemNumber, ItemCode, ItemDescription, ItemType, SubstitutedItemCode, PONumber, Status, StatusId,
                                     KD, UpdateBy, LastUpdatedTime, SnApn, Abn, PGLLabelID, Igl_OP, Igl_Ship, CGL,SBN, ShippingLocation, ShippingLocationTypeName, PickingTaskId, CCOPL,
                                      Active, Deleted, OnHold, Customizing, Finishing, CubicFt,
                                     Weight, Hinge, ExposedSide, PickingDate, BackOrdered, PreviousStatus, ColorHex, Sort, HasComments, ProductionItemId, PIId, Picked, ClassificationCode,
                                      ConstructionClassification, ProductionItemLocationTypeName, Revision, RevisionChange,
                                     ItemTypeName, DestinationLocationName, BinName, PIStatus, PIStatusColor, PickDropLocation, DoorStyleID, AssemblerName, HelperName, TrackingLocationName,ParentItemNumber )
        SELECT te.ID AS ItemNumber, il.ShortItemCode , te.Description, te.ItemType, COALESCE(sn.SubstitueItemCode,abn.SubstitueItemCode) AS  SubstitueItemCode , te.FWPONumber AS PoNumber, d.Status, te.DepartmentstatusID AS StatusId,te.KD ,
             u.FirstName AS UpdateBy , te.LastUpdate,COALESCE(sn.SerielID, abn.APN)  AS SnApn , abn.ABNNumber, PGL.PGLLabelID, Igl_OP.Igl Igl_OP , Igl_Ship.igl Igl_Ship ,  CGL.Track CGL, sbn.BoxNumber AS SBN, ShippingLocation.Location ShippingLocation, ShippingLocation.ShippingLocationTypeName, PickingTask.PickingTaskId, 
             pallet.PalletNum,  te.isActive,ISNULL(te.isDeleted,0), te.onHold, te.HasCustomizing, te.HasFinishing, dbo.GetCubicftTranEntry(te.ID) Cubicft , ISNULL(il.Weight,0) AS Weight, te.Hinge , te.Finish, te.PickingDate , te.IsBackOrdered ,  dbo.fn_TranIdPreviousStatus(te.id ) PreviousStatus,
             CASE WHEN te.isActive = 0 THEN '#000000' WHEN d.ColorHex IS NOT NULL AND d.ColorHex <> '' THEN d.ColorHex 
             ELSE ISNULL(it.ColorHex, '#000000') END AS ColorHex,
             CASE WHEN te.isActive = 0 THEN 200 
                 WHEN Datediff(SECOND, mat.MinAddTime, te.Addtime) > 30
                 AND  COALESCE(d.SortNumber, it.SortNumber , 155) <= 74
                    THEN 10 + RIGHT(Replicate('0', 3) + CONVERT(VARCHAR(25), COALESCE(d.SortNumber, it.SortNumber , 155)), 3)   
             ELSE COALESCE(d.SortNumber, it.SortNumber , 155) END Sort,
             ISNULL(hasComments.HasComments, CAST(0 AS bit)), productionItem.ProductionItemId, productionItem.PIId, 
             COALESCE(sn.Picked, abn.Picked, 0),ConstructionClassification.ClassificationCode, ConstructionClassification.ClassificationDescription,
             productionItem.ProductionItemLocationTypeName, productionItem.Revision, productionItem.RevisionChange, it.TypeName, productionItem.DestinationLocationName, productionItem.BinName, productionItem.Status,ISNULL( productionItem.ColorDisplay,''), PickDropLocation.PickDropLocation, il.DoorStyleID,
             assembler.FirstName, helper.FirstName, 
             --COALESCE(tetrac.TrackingLocationName, pitrac.TrackingLocationName, igltrac.TrackingLocationName, wagtrac.TrackingLocationName) 
             '' AS TrackingLocationName,  CASE WHEN te.ParentID NOT IN(0) THEN te.ParentID ELSE ParenItemNumber.ID END
         FROM  dbo.TranEntry te
        JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
        JOIN dbo.Departmentstatus d ON d.ID = te.DepartmentstatusID
        JOIN dbo.[User] u ON te.UserID = u.ID
        JOIN dbo.ItemType AS it ON te.ItemType = it.TypeID
        OUTER APPLY (SELECT ise.Picked, ise.SerielID, CASE WHEN ise.SubstitueItemCode IS NOT NULL AND ise.ItemCode<> ise.SubstitueItemCode THEN  ise.ItemCode ELSE NULL END AS SubstitueItemCode  FROM dbo.tb_ItemSeriel ise WHERE  ise.TranEntryID = te.ID) sn
        OUTER APPLY (SELECT ABn.ABNNumber, CASE WHEN  abni.SubstitueItemCode IS NOT NULL AND abn.ItemCode<>abni.SubstitueItemCode THEN  abn.ItemCode ELSE NULL END AS SubstitueItemCode , apn.APN,
            abni.Picked
            FROM dbo.tb_AccBoxNumber abn JOIN dbo.tb_AccBoxNumberItems abni ON abni.ABNID = abn.ID AND abni.CreatedABNID IS NULL
            LEFT JOIN dbo.tb_AccPickNumber apn ON apn.AbnItemID=abni.ID  AND apn.TranEntryID = te.ID AND apn.isActive = 1 
            WHERE abni.TranEntryID = te.ID
             ) abn       
        OUTER APPLY (SELECT TOP 1 iglm.ID AS iglOpId,  'IGL' + CAST(igld.HeaderID AS VARCHAR(50)) Igl FROM dbo.tb_ItemGroupLablesMaster iglm JOIN dbo.tb_ItemGroupLablesDetail igld ON igld.HeaderID = iglm.ID WHERE igld.TranEntryID = te.ID AND igld.isActive =1 AND iglm.isActive =1 AND iglm.GroupType IN(3)) Igl_OP
        OUTER APPLY (SELECT TOP 1  'IGL' + CAST(igld.HeaderID AS VARCHAR(50)) Igl FROM dbo.tb_ItemGroupLablesMaster iglm JOIN dbo.tb_ItemGroupLablesDetail igld ON igld.HeaderID = iglm.ID WHERE igld.TranEntryID = te.ID AND igld.isActive =1 AND iglm.isActive =1 AND iglm.GroupType IN(1,2,4)) Igl_Ship
        OUTER APPLY (SELECT TOP 1 abh.BoxNumber  FROM dbo.AccessoriesBoxHeader abh JOIN dbo.AccessoriesBoxDetail abd ON abd.HeaderId = abh.Id WHERE abd.TranEntryId = te.id AND abd.IsActive=1 AND abh.IsActive=1 ) Sbn
        OUTER APPLY (SELECT t.Name AS Track FROM dbo.CabinetTrack ct JOIN dbo.Tracks t ON t.ID = ct.TrackID WHERE ct.TranEntryID = te.id AND ct.Active=1 ) CGL 
        OUTER APPLY (SELECT sl.Location, tslt.LocationName AS ShippingLocationTypeName FROM dbo.tb_ShippingLocationItemsTE slit JOIN dbo.tb_ShippingLocations sl ON sl.Id = slit.LocationId JOIN dbo.tb_shippingLocationType AS tslt ON  tslt.Id = sl.Type WHERE slit.TranEntryID=te.id AND slit.IsActive =1 ) ShippingLocation
        OUTER APPLY (SELECT TOP (1) ptd.PickingTaskId FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId WHERE ptd.ItemId=te.ID AND pt.Active =1 AND ptd.Active =1 ORDER BY ptd.PickingTaskDetailId DESC) PickingTask
        OUTER APPLY (SELECT p.PalletNum FROM dbo.tb_Pallet p WHERE p.ID = te.PalletID) pallet
        OUTER APPLY (SELECT CAST(1 AS BIT) AS HasComments WHERE EXISTS(SELECT 1 FROM dbo.Comments AS c WHERE te.ID = c.itemID AND c.type IN(3, 4))) hasComments
        OUTER APPLY (SELECT TOP (1) t.ID FROM dbo.TranEntry t WHERE  te.EZParentProdID = t.EZProdID AND t.OrderID = te.OrderID)ParenItemNumber
        OUTER APPLY (SELECT pi.ProductionItemId, pi.PIId,dl.DestinationLocationName,pis.Status,pis.ColorDisplay , bin.BinName, pilt.TypeName AS ProductionItemLocationTypeName , oipiir.Revision, oipiir.RevisionChange FROM Picking.ProductionItem AS pi 
            JOIN picking.DestinationLocation AS dl ON dl.DestinationLocationId = pi.DestinationLocationId
            JOIN picking.ProductionItemStatus AS pis ON pis.ProductionItemStatusId = pi.ProductionItemStatusId 
            JOIN picking.ProductionItemLocationType AS pilt ON pilt.ProductionItemLocationTypeId = pi.ProductionItemLocationTypeId 
            LEFT JOIN picking.OrderItemProductionItemIRelease AS oipiir ON oipiir.OrderItemId = pi.OrderItemId
            OUTER APPLY (SELECT TOP (1) b.BinName FROM picking.ProductionItemBin AS pib JOIN picking.Bin AS b ON b.BinId = pib.BinId 
                WHERE pib.ProductionItemId = pi.ProductionItemId AND pib.Active =1
                    ORDER BY pib.ForMissingParts, pib.AddedOn ) bin
            WHERE pi.OrderItemId = te.ID AND pi.Deleted = 0)productionItem
            OUTER APPLY(SELECT TOP (1) ph.PGLLabelID FROM dbo.PGLDetail AS pd JOIN dbo.PGLHeader AS ph ON ph.PGLHeaderID = pd.PGLHeaderID WHERE ph.Deleted = 0 AND pd.Active = 1 AND pd.ProductionItemId = productionItem.ProductionItemId) PGL
        CROSS APPLY (SELECT MIN(te2.Addtime) AS MinAddTime FROM dbo.TranEntry AS te2 WHERE te2.OrderID = te.OrderID) mat
        OUTER APPLY (SELECT TOP (1) pic.ClassificationCode, pic.ClassificationDescription FROM inventory.PoItemsClassifications AS pic WHERE pic.ItemCode = il.ShortItemCode AND pic.PoNumber = te.FWPONumber) ConstructionClassification
        --OUTER APPLY (SELECT TOP (1) tpdl.PickDropLocation FROM dbo.tb_PickDropLocations AS tpdl JOIN picking.BucketItems AS bi ON bi.DropLocation = tpdl.ID WHERE bi.ItemId = te.ID AND bi.Active =1 ORDER BY bi.ID DESC ) PickDropLocation
        OUTER APPLY (SELECT TOP (1) tpdl.PickDropLocation FROM dbo.tb_PickDropLocations AS tpdl JOIN picking.DropLocationOrderItem AS dloi ON  dloi.DropLocation = tpdl.ID WHERE dloi.ItemId = te.ID ) PickDropLocation
        OUTER APPLY(SELECT TOP (1) u.FirstName FROM dbo.History AS h JOIN dbo.[User] AS u ON h.UserID = u.ID WHERE h.DepartmentstatusID = 37 AND h.TranentryID = te.ID)assembler
        OUTER APPLY(SELECT TOP (1) u.FirstName FROM dbo.History AS h JOIN dbo.[User] AS u ON h.UserID = u.ID WHERE h.DepartmentstatusID = 39 AND h.TranentryID = te.ID)helper
        --OUTER APPLY
        --(
        --  SELECT TOP (1) tl.TrackingLocationName FROM dbo.TrackingLocation AS tl
        --  JOIN dbo.TrackingLocationsRecords AS tlr ON tlr.TrackingLocationId = tl.TrackingLocationId
        --  WHERE tl.Active = 1
        --  AND tlr.Active = 1
        --  AND tlr.TranEntry = te.ID
        --)tetrac
        --OUTER APPLY
        --(
        --  SELECT TOP (1) tl.TrackingLocationName FROM dbo.TrackingLocation AS tl
        --  JOIN dbo.TrackingLocationsRecords AS tlr ON tlr.TrackingLocationId = tl.TrackingLocationId
        --  WHERE tl.Active = 1
        --  AND tlr.Active = 1
        --  AND tlr.ProductionItem = productionItem.ProductionItemId
        --)pitrac
        --OUTER APPLY
        --(
        --  SELECT TOP (1) tl.TrackingLocationName FROM dbo.TrackingLocation AS tl
        --  JOIN dbo.TrackingLocationsRecords AS tlr ON tlr.TrackingLocationId = tl.TrackingLocationId
        --  WHERE tl.Active = 1
        --  AND tlr.Active = 1
        --  AND tlr.IGL = Igl_OP.iglOpId
        --)igltrac
        --OUTER APPLY
        --(
        --  SELECT TOP (1) tl.TrackingLocationName FROM dbo.TrackingLocation AS tl
        --  JOIN dbo.TrackingLocationsRecords AS tlr ON tlr.TrackingLocationId = tl.TrackingLocationId
        --  JOIN picking.ProductionItemWagons AS piw ON piw.ProductionItemWagonId = tlr.PIW
        --  JOIN picking.ProductionItemLocationsWagons AS pilw ON pilw.ProductionItemWagonId = piw.ProductionItemWagonId
        --  JOIN picking.ProductionItemLocationActivity AS pila ON pila.ProductionItemLocationId = pilw.ProductionItemLocationId
        --  WHERE tl.Active = 1
        --  AND tlr.Active = 1
        --  AND pila.Active = 1
        --  AND pila.ProductionItemId = productionItem.ProductionItemId
        --)wagtrac
        WHERE te.OrderID = @localOrderId 
    RETURN
END

GO
/****** Object:  UserDefinedFunction [dbo].[GetOrderItemDetailsortInfo]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:      Yakov Muller
-- Create date: 5/20/2019
-- Description: Get OrderItem Details
-- =============================================
CREATE FUNCTION [dbo].[GetOrderItemDetailsortInfo]
(
    @orderId INT
)
RETURNS @OrderItemDetails TABLE(
    ItemNumber INT NOT NULL,   
     Sort INT NOT NULL
)
--AS 
BEGIN
    DECLARE @localOrderId INT = @orderId
    INSERT @OrderItemDetails ( ItemNumber, Sort)
        SELECT te.ID AS ItemNumber, CASE WHEN te.isActive = 0 THEN 200 
                 WHEN Datediff(SECOND, mat.MinAddTime, te.Addtime) > 30
                 AND  COALESCE(d.SortNumber, it.SortNumber , 155) <= 74
                    THEN 10 + RIGHT(Replicate('0', 3) + CONVERT(VARCHAR(25), COALESCE(d.SortNumber, it.SortNumber , 155)), 3)   
             ELSE COALESCE(d.SortNumber, it.SortNumber , 155) END Sort
         FROM  dbo.TranEntry te
        JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
        JOIN dbo.Departmentstatus d ON d.ID = te.DepartmentstatusID
        JOIN dbo.[User] u ON te.UserID = u.ID
        JOIN dbo.ItemType AS it ON te.ItemType = it.TypeID     
        CROSS APPLY (SELECT MIN(te2.Addtime) AS MinAddTime FROM dbo.TranEntry AS te2 WHERE te2.OrderID = te.OrderID) mat     
  
        WHERE te.OrderID = @localOrderId 
    RETURN
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetOrderItemListState]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[GetOrderItemListState]
(
	@entry VARCHAR(50)
)
RETURNS @OrderItemsState TABLE
(
    OrderItemId INT,
    StatusId INT,
    Active BIT
)
 AS
 BEGIN

	IF @entry LIKE 'IGL%' AND ISNUMERIC(SUBSTRING(@entry,4, 50)) =1
	BEGIN
		INSERT INTO @OrderItemsState ( OrderItemId, StatusId, Active )
		SELECT te.id AS OrderItemId , te.DepartmentstatusID AS StatusId, te.isActive  AS Active FROM dbo.TranEntry te
		JOIN dbo.tb_ItemGroupLablesDetail igld ON igld.TranEntryID = te.ID AND igld.isActive = 1
		JOIN dbo.tb_ItemGroupLablesMaster iglm ON iglm.ID = igld.HeaderID
		WHERE iglm.ID  = CAST(SUBSTRING(@entry,4, 50) AS INT )
		RETURN 
	END
	IF @entry LIKE 'SBN%' AND ISNUMERIC(SUBSTRING(@entry,4, 50)) =1
	BEGIN
		INSERT INTO @OrderItemsState ( OrderItemId, StatusId, Active )
		SELECT te.id AS OrderItemId , te.DepartmentstatusID AS StatusId, te.isActive AS Active FROM dbo.TranEntry te
		JOIN dbo.AccessoriesBoxDetail abd ON abd.TranEntryID = te.ID AND abd.isActive = 1
		JOIN dbo.AccessoriesBoxHeader abh ON abh.ID = abd.HeaderID
		WHERE abh.BoxNumber = @entry
		RETURN
	END

	ELSE IF  @entry LIKE 'APN%' AND ISNUMERIC(SUBSTRING(@entry,4, 50)) =1
    BEGIN   
        INSERT INTO @OrderItemsState ( OrderItemId, StatusId, Active )
        SELECT te.id AS OrderItemId , te.DepartmentstatusID AS StatusId, CASE WHEN te.isActive > apn.isActive THEN apn.isActive ELSE te.isActive END AS Active FROM  dbo.TranEntry te 
          JOIN dbo.tb_AccPickNumber apn ON apn.TranEntryID = te.ID
        WHERE apn.APN =   @entry
        RETURN
    END

	ELSE IF ISNUMERIC(@entry) = 1
	BEGIN	
		INSERT INTO @OrderItemsState ( OrderItemId, StatusId, Active )
		SELECT te.id AS OrderItemId , te.DepartmentstatusID AS StatusId, te.isActive AS Active FROM  dbo.TranEntry te 
	--	JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1
		WHERE te.id = CAST(@entry AS INT ) 
		RETURN
	END
	ELSE
	BEGIN
		DECLARE @palletID INT = NULL
		SELECT @palletID = p.ID FROM dbo.tb_Pallet p WHERE p.PalletNum = @entry
		IF @palletID IS NOT NULL
		BEGIN
			INSERT INTO @OrderItemsState ( OrderItemId, StatusId, Active )
			SELECT te.id AS OrderItemId , te.DepartmentstatusID AS StatusId, te.isActive AS Active FROM  dbo.TranEntry te 			
			WHERE te.PalletID  = @palletID
			RETURN
		END
	END
	RETURN
END



GO
/****** Object:  UserDefinedFunction [dbo].[GetOrderItemProductionStatus]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<David, Edel>
-- Create date: <3/12/2020>
-- Description:	<IL-2919 check production status of tran entry for EZ revisions>
-- =============================================
CREATE FUNCTION [dbo].[GetOrderItemProductionStatus]
(
	-- Add the parameters for the function here
	@orderItemId INT
)
RETURNS int
AS
BEGIN
	-- Declare the return variable here
	DECLARE @result INT;

	SELECT @result = 
	--Not planned yet
		CASE WHEN NOT EXISTS(SELECT * FROM picking.OrderItemProductionItemIRelease OIPIIR WHERE OIPIIR.OrderItemId = @orderItemId)
	THEN 0 

	-- Planned and has no task or has task but is not assigned
		WHEN NOT EXISTS(SELECT * FROM picking.PickingTaskProductionItems PTPI
		JOIN picking.PickingTaskProductionItemsDetail PTPID ON PTPID.PickingTaskProductionItemsId = PTPI.PickingTaskProductionItemsId
		JOIN picking.ProductionItem PI ON PI.ProductionItemId = PTPID.ProductionItemId AND PI.Deleted = 0 AND PI.OrderItemId = @orderItemId)

		OR EXISTS (SELECT * FROM picking.PickingTaskProductionItems PTPI
		JOIN picking.PickingTaskProductionItemsDetail PTPID ON PTPID.PickingTaskProductionItemsId = PTPI.PickingTaskProductionItemsId
		JOIN picking.ProductionItem PI ON PI.ProductionItemId = PTPID.ProductionItemId AND PI.Deleted = 0 AND PI.OrderItemId = @orderItemId
		AND PTPI.Picker IS NULL)
	THEN 1

	-- Any item is picked but not PO yet
		WHEN EXISTS(SELECT 1 FROM picking.ProductionItem PI
		JOIN picking.ProductionItemDetail PID ON PID.ProductionItemId = PI.ProductionItemId AND	PID.Deleted = 0
		JOIN dbo.TranEntry TE ON TE.ID = PI.OrderItemId
		WHERE PI.Deleted = 0 AND PI.OrderItemId = @orderItemId
		AND pid.Picked = 1 AND TE.POnumber IS NULL AND TE.FWPONumber IS NULL) 
	THEN 2

	ELSE 3
		END
	

	-- Return the result of the function
	RETURN @result

END
GO
/****** Object:  UserDefinedFunction [dbo].[GetOrderNumberFromIGL]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[GetOrderNumberFromIGL]( @igl varchar(20))
  
RETURNS int	


AS
BEGIN

declare @orderid int;



SELECT top 1  @orderid = o.OrderID FROM  dbo.[Order] O 
WHERE EXISTS (SELECT 1 FROM dbo.TranEntry TE 
JOIN dbo.tb_ItemGroupLablesDetail IGLD ON TE.ID = IGLD.TranEntryID 
WHERE TE.OrderID = O.id AND IGLD.HeaderID =  CONVERT(INT,SUBSTRING(@igl,4,LEN(@igl))))

return isnull(@orderid,0)
			
           
END


GO
/****** Object:  UserDefinedFunction [dbo].[GetOrderNumberFromSN_APN]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[GetOrderNumberFromSN_APN]
(
	-- Add the parameters for the function here
	@SN_APN varchar(50)
)
RETURNS int
AS
BEGIN
	-- Declare the return variable here
	declare @orderid int;
	-- Add the T-SQL statements to compute the return value here
	IF @SN_APN LIKE 'APN%'
	BEGIN
		SELECT top 1  @orderid = o.OrderID FROM  dbo.[Order] O  
		WHERE EXISTS (SELECT 1 FROM dbo.TranEntry te 
		JOIN dbo.tb_AccPickNumber apn ON te.ID = apn.TranEntryID AND apn.isActive = 1
		WHERE te.OrderID = O.id AND apn.APN = @SN_APN )
	END
	ELSE IF @SN_APN LIKE 'SN%'
	BEGIN
	 SET @orderid = 0;
	END
	ELSE
	BEGIN
	 SET @orderid = 0;
	END

	return isnull(@orderid,0)
			

END
GO
/****** Object:  UserDefinedFunction [dbo].[GetPickDropLocation]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 1/12/2017
-- Description:	GetPickDropLocation
-- =============================================
CREATE FUNCTION [dbo].[GetPickDropLocation]
    (
      @ModType VARCHAR(150) ,
      @ShipVia VARCHAR(150) ,
	  @itemType INT
    )
RETURNS INT
AS
    BEGIN
        DECLARE @PickDropLocation INT = NULL;



        SET @PickDropLocation = CASE WHEN @ModType IN ( 'A', 'Drawer' ) AND  @itemType<>3  THEN 1 --'Unpacking'
                                     WHEN @ModType = 'F' THEN 2--'Finishing'
                                     WHEN @ModType = 'C' THEN 3 --'Custom shop'
                                     WHEN @ModType IN ( 'Door', 'D' ) THEN 4 --'Doors'									 
                                     WHEN @ModType IN ( 'Shop-Doors' ) THEN 35 --'Shop-Doors'
                                     WHEN @ModType = 'Empire' THEN 7--'Empire'
									 WHEN @ModType = 'FABU99' THEN 40
									 WHEN @ModType = 'Fabuwood-Shop' THEN 52
									 WHEN @ModType = 'DS Make to Stock' THEN 51
                                     WHEN @ModType = 'Unpacking Tall' THEN 14--'Unpacking Tall'
                                     WHEN @ModType = 'ROD' THEN 15
									 WHEN @ModType = 'Prima-HGS' THEN 37--'Prima-HGS'
                                     WHEN @ModType = 'Inspecting Accessories' OR ( @itemType = 3 AND  @ModType NOT IN('C','F') ) THEN 19  
--									 WHEN @ModType  = 'Drawer' 13 --THEN 'Drawer'
                                     WHEN @ModType = 'KD' THEN 7
                                     --THEN CASE WHEN @ShipVia = 'Pickup' THEN 8 --'KD-Pick up'
                                     --          WHEN @ShipVia = 'Common Carrier'
                                     --               OR @ShipVia = 'CC DIRECT TRUCK'
                                     --          THEN 6--'KD-Common carrier'
                                     --          WHEN @ShipVia = 'Delivery'
                                     --          THEN 7-- 'KD-Shipping'
                                     --          WHEN @ShipVia = 'UPS' THEN 12-- 'KD-UPS'
                                     --     END
									 WHEN @ModType = 'KD TALL'
                                     THEN CASE WHEN @ShipVia = 'Pickup' THEN 32 --'KD TALL-Pick up'
                                               WHEN @ShipVia = 'Common Carrier'
                                                    OR @ShipVia = 'CC DIRECT TRUCK'
													OR @ShipVia = 'CC LOOSE TRAILER'
													OR @ShipVia = 'Delivery'
													OR @ShipVia = 'UPS'
                                               THEN 31-- 'KD TALL-Shipping'
                                               --WHEN @ShipVia = 'UPS' THEN 33-- 'KD TALL-UPS'
                                          END
                                     WHEN @ModType = 'QC PICKING' THEN 22--'QC Picking'
                                     WHEN @ModType = 'QC ASSEMBLY' THEN 23--'QC Assembly'
                                     WHEN @ModType = 'QC RECEIVING DOCK' THEN 25--'QC Receiving Dock'
                                     WHEN @ModType = 'QC PURCHASING' THEN 26--'QC Purchasing'
									 WHEN @ModType = 'QC KD-Inspection' THEN 27--'QC KD-Inspection'
									 WHEN @ModType = 'KD-Shelves' THEN 29--'KD-Shelves'
									 WHEN @ModType = 'Item for Parts' THEN 36
									 WHEN @ModType = 'Wall Unpacking' THEN 46 -- HB-2744
									 WHEN @ModType = 'Door Tall' THEN 43 -- HB-2744
									 WHEN @ModType = 'Q13 Base' THEN 47
									 WHEN @ModType = 'Q13 Wall' THEN 48
                                END;	
        RETURN @PickDropLocation;
    END;

GO
/****** Object:  UserDefinedFunction [dbo].[GetPickedAndOnTaskQuantityForMaterial]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<David Edel>
-- Create date: <3/19/2020>
-- Description:	<Get Quantity Picked or on task for work order material>
-- =============================================
CREATE FUNCTION [dbo].[GetPickedAndOnTaskQuantityForMaterial]
(
	-- Add the parameters for the function here
	@workOrderMaterialId INT
)
RETURNS INT
AS
BEGIN
	-- Declare the return variable here
	DECLARE @qty INT  = 

		(
		SELECT SUM(CASE
		 WHEN taskInfo.StatusId IN (1,2) THEN taskInfo.TaskQuantity 
		 ELSE taskInfo.QtyPicked END ) 

		FROM (

			SELECT WOFT.WorkOrderFulfillmentTaskID,woft.Quantity TaskQuantity, woft.WorkOrderOrderMaterialId, woft.StatusId, SUM(TABN.Qty) QtyPicked FROM manufacturing.WorkOrderFulfillmentTask WOFT 
			LEFT JOIN manufacturing.WorkOrderFulfillmentItems WOFI ON WOFI.TaskId = WOFT.WorkOrderFulfillmentTaskID
			LEFT JOIN dbo.tb_AccBoxNumber TABN ON TABN.WorkOrderFulfillmentItemsID = WOFI.WorkOrderFulfillmentItemsID
			WHERE WOFT.WorkOrderOrderMaterialId = @workOrderMaterialId 
			GROUP BY WOFT.WorkOrderFulfillmentTaskID, WOFT.Quantity, WOFT.WorkOrderOrderMaterialId,WOFT.StatusId
			) taskInfo)

	-- Return the result of the function
	RETURN @qty

END
GO
/****** Object:  UserDefinedFunction [dbo].[GetPlyOnlySBN]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GetPlyOnlySBN](@SBN NVARCHAR(50))
RETURNS INT
AS 

BEGIN
	DECLARE @numericSBN INT, @plyOnly INT;

	    SET @numericSBN =  stuff(@SBN, 1, patindex('%[0-9]%', @SBN)-1, '')

		SELECT @plyOnly = Count(abd.TranEntryId) FROM dbo.AccessoriesBoxDetail abd
		JOIN dbo.AccessoriesBoxHeader abh ON abh.Id = abd.HeaderId AND abh.IsActive =1 
		JOIN dbo.TranEntry te ON te.ID = abd.TranEntryId AND te.isActive = 1
		JOIN dbo.tb_ItemList til ON til.ItemCode = te.ItemNumber 
		WHERE abd.HeaderId = @numericSBN AND abd.IsActive = 1 
		AND til.SubTypeCode NOT IN ('P','K') AND til.ShortItemCode NOT IN('DIGITAL BROCHURE QR')
		--AND EXISTS (SELECT * FROM inventory.AcumaticaStockItems AS asi WHERE asi.AcumaticaID=til.AcumaticaID AND asi.DeleteFlag=0 AND asi.ItemStatus='Active')
	 RETURN @plyOnly
END

GO
/****** Object:  UserDefinedFunction [dbo].[GetPoLineItems]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		David Edel
-- Create date: 9/1/2020
-- Description:	Get po line items summary for Createing a local vendor shipment
--				DE-243
-- =============================================
CREATE FUNCTION [dbo].[GetPoLineItems] 
(
	-- Add the parameters for the function here
	@poIds IDList READONLY
)
RETURNS 
@items TABLE
(
	-- Add the column definitions for the TABLE variable here
	PurchaseOrderId INT,
	PoNumber VARCHAR(50) NOT NULL,
	PoDate DATETIME NOT NULL,
	ItemListId INT NULL,
	ItemCode VARCHAR(255) NOT NULL,
	PoQty INT NOT NULL,
	ReceivedQty INT NOT NULL,
	PromiseDate DATE NULL
)
AS
BEGIN
	-- Fill the table variable with the rows for your result set

		DECLARE @recieved TABLE (PoNumber VARCHAR(50),ItemCode VARCHAR(255), Qty int)

		INSERT @recieved(PoNumber, ItemCode, Qty)
		SELECT P.PoNumber, TABN.ItemCode, TABN.CreatedQty
		FROM dbo.tb_AccBoxNumber TABN
		JOIN inventory.Po P ON P.PoNumber = TABN.PONumber AND TABN.ContainerID IS NULL
		WHERE P.ID IN (SELECT * FROM @poIds)

		INSERT @recieved(PoNumber, ItemCode, Qty)
		SELECT P.PoNumber, TIS.ItemCode, 1 FROM dbo.tb_ItemSeriel TIS
		JOIN inventory.Po P ON P.PoNumber = TIS.PONumber AND TIS.ContainerID IS NULL
		WHERE P.ID IN (SELECT * FROM @poIds)

		-- Container in open - use ContainerList.Qty
		INSERT @recieved(PoNumber, ItemCode, Qty)
		SELECT CL.PONumber,CL.ItemCode,CL.Qty FROM inventory.ContainerList CL
		JOIN inventory.Containers C ON C.ContainerID = CL.ContainerID
		LEFT JOIN inventory.ContainerBay CB ON CB.ContainerID = C.ContainerID AND CB.Deleted = 0
		JOIN inventory.Po P ON P.PoNumber = CL.PONumber
		WHERE p.ID IN (SELECT * FROM @poIds) 
		AND CL.Deleted = 0 AND (cb.ContainerBayID IS NULL OR cb.ContainerStatusID <> 2)

		-- Container in closed - use ContainerList.QtyReceived
		INSERT @recieved(PoNumber, ItemCode, Qty)
		SELECT CL.PONumber,CL.ItemCode,CL.QtyReceived FROM inventory.ContainerList CL
		JOIN inventory.Containers C ON C.ContainerID = CL.ContainerID
		JOIN inventory.ContainerBay CB ON CB.ContainerID = C.ContainerID AND CB.Deleted = 0
		JOIN inventory.Po P ON P.PoNumber = CL.PONumber
		WHERE p.ID IN (SELECT * FROM @poIds) 
		AND CL.Deleted = 0 AND cb.ContainerStatusID = 2


		INSERT @items(PurchaseOrderId, PoNumber, PoDate, ItemListId, ItemCode, PoQty, ReceivedQty, PromiseDate)
		SELECT p.ID, P.PoNumber, p.AddDate, til.ID, TIL.AcumaticaName, PD.Quantity PoQty, ISNULL(Recieved.Qty,0) - ISNULL(Returned.qty,0) RecievedQty, P.PromisedOn
		FROM inventory.PoDetail PD
		JOIN inventory.Po P ON P.PoNumber = PD.PoNumber
		JOIN dbo.tb_ItemList TIL ON TIL.ShortItemCode = PD.ItemCode
		OUTER APPLY ( 
					  SELECT SUM(R.Qty) qty 
					  FROM @recieved R 
					  WHERE R.PoNumber = p.PoNumber AND R.ItemCode = Pd.ItemCode

					) Recieved
		OUTER APPLY(
					 SELECT SUM(rpi.ReturnedQty) qty
					 FROM inventory.ReturnPoItems rpi
					 JOIN inventory.ReturnContainer rc ON rc.ReturnId = rpi.ReturnContainerId
					 WHERE rc.status = 3 AND rpi.ItemCode = PD.ItemCode  AND p.ID = rpi.PoId
					) Returned

		WHERE P.Deleted = 0  AND TIL.AcumaticaName IS NOT NULL
		AND P.ID IN (SELECT * FROM @poIds)
		AND NOT EXISTS (SELECT 1 FROM inventory.Containers C
						JOIN inventory.ContainerList cl ON cl.ContainerID = C.ContainerID
						WHERE cl.PONumber = p.PoNumber AND c.Vendor = p.VendorName
						AND cl.Deleted = 0 AND c.ContainerTypeId = 1)


	
	RETURN 
END











GO
/****** Object:  UserDefinedFunction [dbo].[GetSbnItemRules]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		David Edel
-- Create date: 12/8/2020
-- Description:	Get rules for item when scanning for SBN
-- =============================================
CREATE FUNCTION [dbo].[GetSbnItemRules]
(
	-- Add the parameters for the function here
	@OrderItemId INT
)
RETURNS 
@rules TABLE
(
	-- Add the column definitions for the TABLE variable here
	CanScanWithoutSn BIT,
	CreateSn BIT,
	ValidatePassedStatusClassId INT NULL
)
AS
BEGIN
	-- Fill the table variable with the rows for your result set
		INSERT @rules(CanScanWithoutSn, CreateSn, ValidatePassedStatusCLassId)
		SELECT 1,1,82 FROM dbo.TranEntry TE
		JOIN picking.ProductionItem PI ON PI.OrderItemId = TE.ID
		WHERE PI.Deleted = 0 
		AND PI.DestinationLocationId IN (39,48)
		AND TE.ID = @OrderItemId

		-- Item type 4
		INSERT @rules(CanScanWithoutSn, CreateSn, ValidatePassedStatusCLassId)
		SELECT 1,0,82 FROM dbo.TranEntry TE
		WHERE te.ID = @OrderItemId
		AND TE.ItemType = 4
		AND NOT EXISTS (SELECT * FROM @rules R)

		-- Explicit items in item class 138
		INSERT @rules(CanScanWithoutSn, CreateSn)
		SELECT 1,0 FROM dbo.TranEntry TE
		JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
		WHERE TE.ID = @OrderItemId
		AND TIL.ShortItemCode IN (SELECT TICD.ItemCode FROM dbo.tb_itemClassDetail TICD WHERE TICD.ClassID = 138)
		AND NOT EXISTS (SELECT * FROM @rules R)

		INSERT @rules(CanScanWithoutSn, CreateSn)
		SELECT 1, 1 FROM picking.ProductionItem PI 
		JOIN picking.DestinationLocation AS dl ON dl.DestinationLocationId = PI.DestinationLocationId
		WHERE PI.OrderItemId = @OrderItemId
		AND dl.DestinationLocationGroupId = 8

		IF NOT EXISTS (SELECT * FROM @rules R)
		INSERT @rules(CanScanWithoutSn, CreateSn)
		SELECT 0,0
	RETURN 
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetShippingLoadSummary]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetShippingLoadSummary]
(
	@page INT,
	@pageSize INT = 10, 
	@current BIT =1,
	@statuses IDList READONLY,
	@shipVia IDList READONLY,
	@date DATE = NULL
)
RETURNS 
@ShippingSummary TABLE
(
ShipmentLoadId INT, 
ShipmentStatus VARCHAR(50), 
ShipVia VARCHAR(50),
ShippingTruckId int, 
TruckName VARCHAR(50), 
Carrier_Customer VARCHAR(50),
DriverName VARCHAR(50),
CustomerName VARCHAR(50), 
AmmountOfStops INT, 
DockLocationId INT
)
AS
BEGIN
	WITH ShippingLoads AS
	(
	SELECT CAST(ROW_NUMBER() OVER(ORDER BY CASE WHEN @current = 1 THEN ISNULL(MIN(o.EstShipTime), GETDATE() + 330)  END ASC, CASE @current WHEN 0 THEN MAX(o.EstShipTime) END DESC, ss.Sort , sl.ShipmentLoadId ) AS INT ) AS ShippingSummaryID, 
	sl.ShipmentLoadId, ss.ShipmentStatus, sv.Name AS ShipVia, 
	st.ShippingTruckId, st.TruckName, CASE sl.ShipViaId WHEN 5 THEN scd.CustomerName ELSE st.Carrier END AS Carrier_Customer, scd.Name AS DriverName, 
	scd.CustomerName, (SELECT COUNT(*) FROM dbo.Shipment AS s2 WHERE s2.ShipmentLoadId = sl.ShipmentLoadId) AS AmmountOfStops, sl.DockLocationId
	FROM dbo.ShipmentLoad AS sl
	JOIN dbo.ShipmentStatus AS ss ON ss.ShipmentStatusId = sl.ShipmentStatusId
	JOIN dbo.ShipVia AS sv ON sv.ShipViaId = sl.ShipViaId
	LEFT JOIN dbo.ShippingTruck AS st ON st.ShippingTruckId = sl.ShippingTruckId
	LEFT JOIN dbo.ShippingCarrierDriver AS scd ON scd.ShippingCarrierDriverId = sl.ShippingCarrierDriverId
	LEFT JOIN dbo.Shipment AS s ON s.ShipmentLoadId = sl.ShipmentLoadId
	LEFT JOIN dbo.ShipmentDetail AS sd ON sd.ShipmentId = s.ShipmentId
	LEFT JOIN dbo.[Order] AS o ON sd.OrderNumber = o.SOnumber
	WHERE ((@current = 1 AND ((sl.DockLocationAssignedTime >= CAST(GETDATE() as date) AND sl.ShipmentLoadId = 3 ) OR ss.ShipmentStatusId <> 3)) OR (@current = 0 AND sl.ShipmentStatusLastUpdated < CAST(GETDATE() as date) AND ss.ShipmentStatusId = 3))
	AND (@date IS NULL  OR ( o.EstShipTime IS NOT NULL AND  CAST(o.EstShipTime AS DATE) = @date))
	AND ( NOT EXISTS (SELECT 1 FROM @statuses AS s2) OR ss.ShipmentStatusId IN (SELECT s3.ID FROM @statuses AS s3) )
	AND ( NOT EXISTS (SELECT 1 FROM @shipVia AS sv2) OR sv.ShipViaId IN (SELECT sv3.ID FROM @shipVia AS sv3 ) )

	GROUP BY 
	 CASE sl.ShipViaId
			 WHEN 5 THEN
			 scd.CustomerName
			 ELSE
			 st.Carrier
			 END,
			 sl.ShipmentLoadId,
			 ss.ShipmentStatus,
			 sv.Name,
			 st.ShippingTruckId,
			 st.TruckName,
			 scd.Name,
			 scd.CustomerName,
			 sl.DockLocationId,
			 ss.Sort
	),
	filteredShippments AS
	(
	SELECT * FROM ShippingLoads  WHERE ShippingLoads.ShippingSummaryID > ((@page -1) * @pageSize) AND ShippingLoads.ShippingSummaryID <= ( (@page -1) * @pageSize ) + @pageSize
	)
	INSERT INTO @ShippingSummary
	(
		ShipmentLoadId,
		ShipmentStatus,
		ShipVia,
		ShippingTruckId,
		TruckName,
		Carrier_Customer,
		DriverName,
		CustomerName,
		AmmountOfStops,
		DockLocationId
	)
	SELECT
	ShipmentLoadId,
	ShipmentStatus,
	ShipVia,
	ShippingTruckId,
	TruckName,
	Carrier_Customer,
	DriverName,
	CustomerName,
	AmmountOfStops,
	DockLocationId
	FROM filteredShippments
--ORDER BY CASE @current WHEN 1 THEN filteredShippments.EstShipTime END ASC,
--         CASE @current WHEN 0 THEN filteredShippments.EstShipTime END DESC  

	
	RETURN 
END

GO
/****** Object:  UserDefinedFunction [dbo].[GetSnApnForItem]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[GetSnApnForItem]
(
	@ItemId INT
)
RETURNS VARCHAR(50)
AS
BEGIN
	
	DECLARE @SnApn VARCHAR(50)
	SELECT @SnApn = COALESCE(tis.SerielID,tapn.APN) FROM dbo.TranEntry AS te
	LEFT JOIN dbo.tb_ItemSeriel AS tis ON tis.TranEntryID =te.ID
	LEFT JOIN dbo.tb_AccPickNumber AS tapn ON tapn.TranEntryID = te.ID
		WHERE te.ID = @ItemId

	RETURN @SnApn

END

GO
/****** Object:  UserDefinedFunction [dbo].[GetStatusNotOnGroup_test]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetStatusNotOnGroup_test]
(	
@GroupId INT
)
RETURNS 
@ret TABLE 
(
	-- Add the column definitions for the TABLE variable here
	StatusId INT,
	StatusName VARCHAR(50),
	StatusTypeId INT,
	PdaStatus BIT,
	AutomateStatus BIT

)
AS
BEGIN
	-- Fill the table variable with the rows for your result set
	DECLARE @result TABLE (StatusId INT,
	StatusName VARCHAR(50),
	StatusTypeId INT,
	PdaStatus BIT,
	AutomateStatus BIT)

	INSERT INTO @result
	(
	    StatusId,
	    StatusName,
	    StatusTypeId,
	    PdaStatus,
	    AutomateStatus
	)
	SELECT d.ID AS StatusId, d.Status AS StatusName, d.StatusTypeId,1 AS PdaStatus ,
	CASE WHEN tscd.ID IS NOT NULL THEN 1 ELSE 0 END AS AutomateStatus  FROM dbo.Departmentstatus AS d
	LEFT JOIN dbo.tb_StatusClassDetail AS tscd ON tscd.StatusID = d.ID AND tscd.ClassMasterID = 79
    WHERE d.ActualStatus = 1 AND d.HistFlag = 0 
	AND d.StatusTypeId IN (1,2,5)
	AND (@groupid = 1 OR NOT EXISTS (SELECT 1 FROM dbo.StatusGroupDetail AS sgd
	WHERE sgd.DepartmentStatusId = d.ID AND sgd.Active =1 AND sgd.StatusGroupMasterId = @GroupId))
	
	INSERT INTO @result
	(
	    StatusId,
	    StatusName,
	    StatusTypeId,
		PdaStatus,
		AutomateStatus
	)
	SELECT d.ID,d.Status,d.StatusTypeId,0,1 FROM dbo.Departmentstatus AS d
	JOIN dbo.tb_StatusClassDetail AS tscd ON tscd.StatusID = d.ID AND tscd.ClassMasterID = 79
	AND NOT EXISTS(SELECT * FROM @result t WHERE t.StatusId = d.ID)



	INSERT INTO @ret
	(
	    StatusId,
	    StatusName,
	    StatusTypeId,
	    PdaStatus,
	    AutomateStatus
	)
	SELECT r.StatusId,
           r.StatusName,
           r.StatusTypeId,
           r.PdaStatus,
           r.AutomateStatus FROM @result AS r
	

	RETURN 
END
GO
/****** Object:  UserDefinedFunction [dbo].[GetSwapMoveEntry]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 10/17/2018
-- Description:	Get Swap Move Entry
-- =============================================
CREATE FUNCTION [dbo].[GetSwapMoveEntry]
(
	@entry VARCHAR(50) 
)
RETURNS @SwapMoveEntry TABLE
(
    OrderNumber VARCHAR(50),
    ItemId INT,
    ItemCode VARCHAR(50),
    Status VARCHAR(150),
    SerialAbn VARCHAR(50),
    PONumber VARCHAR(50),
    APN VARCHAR(150),
    SubstituteItemCode VARCHAR(50),
    OrderId INT,
	AbnItemId INT,
	ProductionItemId INT NULL,
	IsActive BIT NULL,
	DepartmentstatusID INT NULL
)
AS 
BEGIN
	IF (@entry LIKE 'APN%')
	BEGIN
	   INSERT @SwapMoveEntry ( OrderNumber, ItemId, ItemCode, Status, SerialAbn, PONumber, APN, SubstituteItemCode, OrderId, AbnItemId, ProductionItemId , IsActive, DepartmentstatusID)
		SELECT te.OrderIdentity AS OrderNumber, te.ID AS ItemId , il.ShortItemCode AS ItemCode, d.Status, ISNULL(SN.SerielID,abn.ABNNumber) AS SerialAbn, COALESCE(SN.PONumber,abn.PONumber,te.FWPONumber) AS PONumber ,
			apn.APN, CASE WHEN COALESCE(SN.ItemCode,abn.ItemCode,'') <> il.ShortItemCode THEN COALESCE(SN.ItemCode,abn.ItemCode,'') ELSE NULL END AS SubstituteItemCode , te.OrderID , abn.AbnItemId, pi.ProductionItemId, te.isActive, te.DepartmentstatusID
		FROM dbo.tb_AccPickNumber apn
			JOIN dbo.TranEntry te ON te.ID = apn.TranEntryID
			OUTER APPLY
			 (
				 SELECT ise.SerielID, ise.ItemCode, ise.PONumber, ise.SubstitueItemCode
				 FROM dbo.tb_ItemSeriel ise
				 WHERE ise.SerielID = apn.ApnIndentifier AND apn.ApnType = 'SN'
			 ) SN
			OUTER APPLY
			 (
				 SELECT abn.ABNNumber, abn.ItemCode, abn.PONumber, abni.SubstitueItemCode, abni.ID AS AbnItemId
				 FROM dbo.tb_AccBoxNumber abn
					 JOIN dbo.tb_AccBoxNumberItems abni ON abni.ABNID = abn.ID
				 WHERE apn.ApnType = 'ABN' AND abn.ABNNumber = apn.ApnIndentifier AND apn.AbnItemID = abni.ID AND apn.NotYetActivated = 0 AND abni.TranEntryID=te.ID
			 ) abn
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
			JOIN dbo.Departmentstatus d ON d.ID = te.DepartmentstatusID
			LEFT JOIN picking.ProductionItem AS pi ON pi.OrderItemId = te.ID
		WHERE apn.APN = @entry

	END;
	ELSE IF ISNUMERIC(@entry) = 1
	BEGIN
	   INSERT @SwapMoveEntry ( OrderNumber, ItemId, ItemCode, Status, SerialAbn, PONumber, APN, SubstituteItemCode, OrderId, AbnItemId, ProductionItemId, IsActive, DepartmentstatusID )
		SELECT te.OrderIdentity AS OrderNumber, te.ID AS ItemId , il.ShortItemCode AS ItemCode, d.Status, ISNULL(SN.SerielID,abn.ABNNumber) AS SerialAbn, COALESCE(SN.PONumber,abn.PONumber,te.FWPONumber) AS PONumber ,
			 ISNULL(SN.APN, abn.APN) APN ,CASE WHEN COALESCE(SN.ItemCode,abn.ItemCode,'') <> il.ShortItemCode THEN COALESCE(SN.ItemCode,abn.ItemCode,'') ELSE NULL END AS SubstituteItemCode, te.OrderID, abn.AbnItemId, pi.ProductionItemId, te.isActive, te.DepartmentstatusID
		FROM dbo.TranEntry te 
			OUTER APPLY
			 (
				 SELECT ise.SerielID, ise.ItemCode, ise.PONumber, ise.SubstitueItemCode, apn.APN
				 FROM dbo.tb_ItemSeriel ise
				 LEFT OUTER JOIN dbo.tb_AccPickNumber apn ON apn.TranEntryID = ise.TranEntryID AND apn.NotYetActivated =0 AND apn.isActive =1 AND ise.SerielID=apn.ApnIndentifier AND apn.ApnType = 'SN'
				 WHERE ise.TranEntryID = te.ID
			 ) SN
			OUTER APPLY
			 (
				 SELECT TOP 1 abn.ABNNumber, abn.ItemCode, abn.PONumber, abni.SubstitueItemCode , apn.APN, abni.ID AS AbnItemId
				 FROM dbo.tb_AccBoxNumber abn
					 JOIN dbo.tb_AccBoxNumberItems abni ON abni.ABNID = abn.ID
					 JOIN dbo.tb_AccPickNumber apn ON apn.TranEntryID = abni.TranEntryID AND apn.NotYetActivated =0 AND abni.ID=apn.AbnItemID
				 WHERE abni.TranEntryID = te.ID AND abni.Picked =1 ORDER BY CAST(apn.isActive AS INT) DESC , apn.id DESC
			 ) abn
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
			JOIN dbo.Departmentstatus d ON d.ID = te.DepartmentstatusID
			LEFT JOIN picking.ProductionItem AS pi ON pi.OrderItemId = te.ID AND pi.Deleted = 0
		WHERE te.ID = @entry;
	END;

	RETURN
END




GO
/****** Object:  UserDefinedFunction [dbo].[GetTaskIDfromSN_APN]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[GetTaskIDfromSN_APN]
(
	-- Add the parameters for the function here
	@SN_APN varchar(50)
)
RETURNS int
AS
BEGIN
	-- Declare the return variable here
	declare @taskid int;

	-- Add the T-SQL statements to compute the return value here
	IF @SN_APN LIKE 'APN%'
	BEGIN
		SELECT TOP 1 @taskid = ptd.PickingTaskId 
		FROM dbo.tb_AccPickNumber AS tapn 
		INNER JOIN picking.PickingTaskDetail AS ptd 
			ON tapn.TranEntryID = ptd.ItemId 
		WHERE tapn.APN = @SN_APN AND ptd.Picked = 1
	END
	ELSE IF @SN_APN LIKE 'SN%'
	BEGIN
	 SET @taskid = 0;
	END
	ELSE
	BEGIN
	 SET @taskid = 0;
	END
	-- Return the result of the function
	return isnull(@taskid,0)

END
GO
/****** Object:  UserDefinedFunction [dbo].[GetTracksForSpecialItems]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Isaac Drezdner
-- Create date: 12/3/2018
-- Description:	Defines Tracks for Special Items
-- =============================================
CREATE FUNCTION [dbo].[GetTracksForSpecialItems] 
(	
	@orderId INT, @itemId INT
)
RETURNS @specialTracks TABLE(trackId INT, newTrack BIT)
BEGIN
	DECLARE @trackId INT, @newTrack BIT, @hasSpecialItems BIT = 0, @isSpecialItem BIT = 0, @itemCode VARCHAR(50), @isNonSpecialItem BIT = 0;

	/* ========== Check if any applicable items on the order : Start ========== */

	SELECT TOP (1) @hasSpecialItems = 1 FROM dbo.TranEntry te 
	JOIN dbo.tb_ItemList til ON til.ItemCode = te.ItemNumber
	WHERE te.OrderID = @orderId AND te.isActive = 1 AND te.isDeleted = 0 
	AND EXISTS (SELECT ticd.ItemCode FROM dbo.tb_itemClassDetail ticd WHERE ticd.ClassID = 120 AND ticd.IsActive = 1 AND til.ShortItemCode = ticd.ItemCode)

	IF @hasSpecialItems = 0
	BEGIN
		SET @trackId= NULL;
		SET @newTrack = 0;
	END

	/* ========== Check if any applicable items on the order : End ========== */

	/* ========== Check if tran entry is special Item : Start ========== */
	ELSE
		BEGIN
	    SELECT @isSpecialItem = CASE WHEN ticd.ItemCode IS NOT NULL THEN 1 ELSE 0 END, @itemCode = til.ShortItemCode FROM dbo.TranEntry te 
		JOIN dbo.tb_ItemList til ON til.ItemCode = te.ItemNumber
		LEFT JOIN dbo.tb_itemClassDetail ticd ON ticd.ItemCode = til.ShortItemCode AND ticd.ClassID = 120 AND ticd.IsActive = 1
		WHERE te.OrderID = @orderId AND te.ID = @itemId AND te.isActive = 1 AND te.isDeleted = 0 
		
		/* ========== Check if tran entry is special Item : End ========== */

		/* ========== Check if tran entry is Non special Item : Start ========== */

		SELECT @isNonSpecialItem = CASE WHEN til2.ShortItemCode IS NOT NULL THEN 1 ELSE 0 END, @itemCode = til.ShortItemCode FROM dbo.TranEntry te 
		JOIN dbo.tb_ItemList til ON til.ItemCode = te.ItemNumber
		LEFT JOIN dbo.tb_ItemList til2 ON til2.ShortItemCode = til.ShortItemCode AND til.ProductID IN (32,33,34,36,38)
		WHERE te.OrderID = @orderId AND te.ID = @itemId AND te.isActive = 1 AND te.isDeleted = 0 

		/* ========== Check if tran entry is Non special Item : End ========== */

		/* ========== Get available track for special Item : Start ========== */

		IF @isSpecialItem = 1
		BEGIN
			DECLARE @trackItems1 TABLE(TrackID INT, ItemCount INT, AcceptableItemCount INT, SpecialItemsCount INT, SpecialItemsPreferred INT, NonSpecialItemsCount INT, NonSpecialItemsPreferred INT)
			INSERT INTO @trackItems1 (TrackID, ItemCount, AcceptableItemCount, SpecialItemsCount, SpecialItemsPreferred, NonSpecialItemsCount, NonSpecialItemsPreferred)
			SELECT ct.TrackID,
			COUNT(*) ItemCount,
			SUM(specialItems.ItemCount) + SUM(specialItemsPreferred.ItemCount) + SUM(nonSpecialItems.ItemCount) + SUM(nonSpecialItemsPreferred.ItemCount) AcceptableItemCount,
			SUM(specialItems.ItemCount) SpecialItemsCount,
			SUM(specialItemsPreferred.ItemCount) SpecialItemsPreferred,
			SUM(nonSpecialItems.ItemCount) NonSpecialItemsCount,
			SUM(nonSpecialItemsPreferred.ItemCount) NonSpecialItemsPreferred
			FROM dbo.TranEntry te
			JOIN dbo.tb_ItemList til ON te.ItemNumber = til.ItemCode
			LEFT JOIN dbo.CabinetTrack ct ON ct.TranEntryID = te.ID AND ct.Active = 1
			OUTER APPLY (SELECT COUNT(*) ItemCount FROM dbo.TranEntry te2 WHERE te2.ID = te.ID AND te2.isActive =1 AND te2.isDeleted = 0 AND EXISTS (SELECT ticd.ItemCode FROM dbo.tb_itemClassDetail ticd WHERE ticd.ClassID = 120 AND ticd.IsActive = 1 AND til.ShortItemCode = ticd.ItemCode AND til.ShortItemCode NOT LIKE '%B33')) specialItems
			OUTER APPLY (SELECT COUNT(*) ItemCount FROM dbo.TranEntry te2 WHERE te2.ID = te.ID AND te2.isActive =1 AND te2.isDeleted = 0 AND EXISTS (SELECT ticd.ItemCode FROM dbo.tb_itemClassDetail ticd WHERE ticd.ClassID = 120 AND ticd.IsActive = 1 AND til.ShortItemCode = ticd.ItemCode AND til.ShortItemCode LIKE '%B33')) specialItemsPreferred
			OUTER APPLY (SELECT COUNT(*) ItemCount FROM dbo.TranEntry te2 WHERE te2.ID = te.ID AND te2.isActive =1 AND te2.isDeleted = 0 AND til.ProductID IN (32,33,34,36)) nonSpecialItems
			OUTER APPLY (SELECT COUNT(*) ItemCount FROM dbo.TranEntry te2 WHERE te2.ID = te.ID AND te2.isActive =1 AND te2.isDeleted = 0 AND til.ProductID IN (38)) nonSpecialItemsPreferred
			WHERE te.OrderID = @orderId AND te.isActive = 1 AND te.isDeleted = 0 AND til.ItemTypeCode IN (1,2,7,12)
			GROUP BY ct.TrackID

			IF EXISTS (SELECT TOP(1) 1 FROM @trackItems1 ti WHERE ti.TrackID IS NOT NULL
						 AND ti.ItemCount < 4 AND (ti.SpecialItemsCount + ti.SpecialItemsPreferred) < 2 
						 AND ((@itemCode LIKE '%B33' AND (ti.NonSpecialItemsPreferred + ti.NonSpecialItemsCount) <= 2) OR (ti.NonSpecialItemsCount <= 2 AND ti.NonSpecialItemsPreferred = 0)))
				BEGIN
				  SELECT TOP(1) @trackId = ti.TrackID, @newTrack = 0 FROM @trackItems1 ti WHERE ti.TrackID IS NOT NULL
						 AND ti.ItemCount < 4 AND (ti.SpecialItemsCount + ti.SpecialItemsPreferred) < 2 
						 AND ((@itemCode LIKE '%B33' AND (ti.NonSpecialItemsPreferred + ti.NonSpecialItemsCount) <= 2) OR (ti.NonSpecialItemsCount <= 2 AND ti.NonSpecialItemsPreferred = 0))
						 ORDER BY ti.NonSpecialItemsPreferred, ti.TrackID
				END

			ELSE
			BEGIN
				SET @newTrack = 1;
				SET @trackId = NULL;
			END
		END

		/* ========== Get available track for special Item : END ========== */

		/* ========== Get available track for Non special Item : Start ========== */
		ELSE
			IF @isNonSpecialItem = 1
			BEGIN
				DECLARE @trackItems2 TABLE(TrackID INT, ItemCount INT, AcceptableItemCount INT, SpecialItemsCount INT, SpecialItemsPreferred INT, NonSpecialItemsCount INT, NonSpecialItemsPreferred INT)
				INSERT INTO @trackItems2 (TrackID, ItemCount, AcceptableItemCount, SpecialItemsCount, SpecialItemsPreferred, NonSpecialItemsCount, NonSpecialItemsPreferred)
				SELECT ct.TrackID,
				COUNT(*) ItemCount,
				SUM(specialItems.ItemCount) + SUM(specialItemsPreferred.ItemCount) + SUM(nonSpecialItems.ItemCount) + SUM(nonSpecialItemsPreferred.ItemCount) AcceptableItemCount,
				SUM(specialItems.ItemCount) SpecialItemsCount,
				SUM(specialItemsPreferred.ItemCount) SpecialItemsPreferred,
				SUM(nonSpecialItems.ItemCount) NonSpecialItemsCount,
				SUM(nonSpecialItemsPreferred.ItemCount) NonSpecialItemsPreferred
				FROM dbo.TranEntry te
				JOIN dbo.tb_ItemList til ON te.ItemNumber = til.ItemCode
				LEFT JOIN dbo.CabinetTrack ct ON ct.TranEntryID = te.ID AND ct.Active = 1
				OUTER APPLY (SELECT COUNT(*) ItemCount FROM dbo.TranEntry te2 WHERE te2.ID = te.ID AND te2.isActive =1 AND te2.isDeleted = 0 AND EXISTS (SELECT ticd.ItemCode FROM dbo.tb_itemClassDetail ticd WHERE ticd.ClassID = 120 AND ticd.IsActive = 1 AND til.ShortItemCode = ticd.ItemCode AND til.ShortItemCode NOT LIKE '%B33')) specialItems
				OUTER APPLY (SELECT COUNT(*) ItemCount FROM dbo.TranEntry te2 WHERE te2.ID = te.ID AND te2.isActive =1 AND te2.isDeleted = 0 AND EXISTS (SELECT ticd.ItemCode FROM dbo.tb_itemClassDetail ticd WHERE ticd.ClassID = 120 AND ticd.IsActive = 1 AND til.ShortItemCode = ticd.ItemCode AND til.ShortItemCode LIKE '%B33')) specialItemsPreferred
				OUTER APPLY (SELECT COUNT(*) ItemCount FROM dbo.TranEntry te2 WHERE te2.ID = te.ID AND te2.isActive =1 AND te2.isDeleted = 0 AND til.ProductID IN (32,33,34,36)) nonSpecialItems
				OUTER APPLY (SELECT COUNT(*) ItemCount FROM dbo.TranEntry te2 WHERE te2.ID = te.ID AND te2.isActive =1 AND te2.isDeleted = 0 AND til.ProductID IN (38)) nonSpecialItemsPreferred
				WHERE te.OrderID = @orderId AND te.isActive = 1 AND te.isDeleted = 0 AND til.ItemTypeCode IN (1,2,7,12)
				GROUP BY ct.TrackID

				SELECT @trackId = tin.TrackID, @newTrack = 0 FROM @trackItems2 tin
						OUTER APPLY (SELECT nti.TrackID,
								nti.ItemCount,
								nti.AcceptableItemCount,
								nti.SpecialItemsCount,
								nti.SpecialItemsPreferred,
								nti.NonSpecialItemsCount,
								nti.NonSpecialItemsPreferred FROM @trackItems2 nti WHERE nti.TrackID IS NULL) notAssignedToTrack
						WHERE 
						--tin.ItemCount <= tin.AcceptableItemCount AND
						tin.ItemCount < 4 AND 
						(tin.NonSpecialItemsCount + tin.NonSpecialItemsPreferred < 2) AND (tin.SpecialItemsCount + tin.SpecialItemsPreferred < 2) AND
						((tin.SpecialItemsCount + tin.SpecialItemsPreferred BETWEEN 1 AND 2) OR (notAssignedToTrack.SpecialItemsCount + notAssignedToTrack.SpecialItemsPreferred > 0)) AND
						((@itemCode NOT LIKE '%B18' OR @itemCode LIKE '%B18' AND tin.SpecialItemsCount < 2))
						AND tin.TrackID IS NOT NULL
						ORDER BY tin.NonSpecialItemsPreferred, tin.TrackID
				IF	@trackId IS NOT NULL
				BEGIN
				    SET @newTrack = 0;
				END
				ELSE
				BEGIN
					IF @itemCode LIKE '%B18' AND NOT EXISTS (SELECT 1 FROM @trackItems2 ti WHERE ti.SpecialItemsPreferred > 0 AND ti.TrackID IS NULL)
					OR NOT EXISTS(SELECT 1 FROM @trackItems2 ti WHERE ti.SpecialItemsCount + ti.SpecialItemsPreferred > 0 AND ti.TrackID IS NULL)
					BEGIN
					    SET @newTrack = 0;
					END
					ELSE
					BEGIN
					    SET @newTrack = 1;
						SET @trackId = NULL;
					END
				END

			END
		ELSE
        BEGIN
            SET @trackId= NULL;
			SET @newTrack = 0;
        END
		
		INSERT INTO @specialTracks
		(
			trackId,
			newTrack
		)
		VALUES
		(   @trackId,   -- TrackId - int
			@newTrack -- newTrack - bit
		)
	END
	
		/* ========== Get available track for Non special Item : END ========== */
RETURN
END
















GO
/****** Object:  UserDefinedFunction [dbo].[GetTransportSummary]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		David Samet
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetTransportSummary]
(	
	@page INT= 1 ,
	@pageSize INT= 10,
	@department IDList READONLY,
	@status IDList READONLY,
	@inBound BIT = NULL
)
RETURNs @TransportSummary TABLE
(
TransportSummaryID int ,
TransportId int ,
TransportStatusId int ,
TransportStatusName VARCHAR(50) ,
TransportSourceLocationId int ,
TransportSourceLocation VARCHAR(50) ,
TransportDestinationLocationId int ,
TransportDestinationLocation VARCHAR(50) ,
TransportWagonId int ,
TransportWagonLabel VARCHAR(50) ,
CreatedOn DATETIME,
CreatedUser VARCHAR(150),
AssignedUser VARCHAR(150),
AssignedUserId INT,
AssignedOn DATETIME,
LastUpdated DATETIME,
Urgent BIT
 )
AS BEGIN

;WITH transports AS (
SELECT cast (ROW_NUMBER() OVER(ORDER BY ts.Sort, t.CreatedOn , t.TransportId) AS INT ) AS TransportSummaryID,t.TransportId, t.TransportStatusId, ts.TransportStatusName, 
																	 t.TransportSourceLocationId,tl.TransportLocationName TransportSourceLocation ,
																	 t.TransportDestinationLocationId,tl2.TransportLocationName TransportDestinationLocation, 
																	 t.TransportWagonId, tw.TransportWagonLabel, t.CreatedOn, anu2.FirstName + ' ' + anu2.LastName CreatedUser ,
																	 anu.FirstName + ' ' + anu.LastName AssignedUser, tu.TransportUserId AssignedUserId , t.AssignedOn, t.LastUpdated, t.Urgent FROM dbo.Transport AS t
																	 JOIN dbo.TransportStatus AS ts ON ts.TransportStatusID = t.TransportStatusId
																	 JOIN dbo.TransportLocation AS tl ON tl.TransportLocationID = t.TransportSourceLocationId
																	 JOIN dbo.TransportLocation AS tl2 ON tl2.TransportLocationID = t.TransportDestinationLocationId
																	 JOIN dbo.TransportWagon AS tw ON tw.TransportWagonId = t.TransportWagonId
																	 JOIN dbo.AspNetUsers AS anu2 ON anu2.Id = t.CreatedBy
																	 LEFT JOIN dbo.TransportUser AS tu ON tu.TransportUserId = t.AssignedTransportUserId
																	 LEFT JOIN dbo.AspNetUsers AS anu ON tu.UserId = anu.Id

WHERE ISNULL(t.Deleted,0) = 0 AND  (NOT EXISTS (SELECT 1 FROM @department AS d) OR ((@inBound = 0 AND t.TransportSourceLocationId IN (SELECT d2.ID FROM @department AS d2)) 
OR (@inBound = 1 AND t.TransportDestinationLocationId IN (SELECT d3.ID FROM @department AS d3)) 
OR (@inBound IS NULL AND (t.TransportSourceLocationId IN(SELECT d4.ID FROM @department AS d4) OR t.TransportDestinationLocationId IN (SELECT d5.ID FROM @department AS d5))))) 
AND ( NOT EXISTS (SELECT s.ID FROM @status AS s) OR  t.TransportStatusId IN (SELECT s.ID FROM @status AS s))
)
, filteredTransports AS (
SELECT * FROM transports  WHERE transports.TransportSummaryID > ((@page -1) * @pageSize) AND transports.TransportSummaryID <= ( (@page -1) * @pageSize ) + @pageSize

)
INSERT INTO @TransportSummary ( TransportSummaryID, TransportId, TransportStatusId, TransportStatusName,
                                 TransportSourceLocationId, TransportSourceLocation, TransportDestinationLocationId,
                                 TransportDestinationLocation, TransportWagonId, TransportWagonLabel, CreatedOn,
                                 CreatedUser, AssignedUser, AssignedUserId, AssignedOn, LastUpdated, Urgent )
SELECT ft.TransportSummaryID, ft.TransportId, ft.TransportStatusId, ft.TransportStatusName,
       ft.TransportSourceLocationId, ft.TransportSourceLocation, ft.TransportDestinationLocationId,
       ft.TransportDestinationLocation, ft.TransportWagonId, ft.TransportWagonLabel, ft.CreatedOn, ft.CreatedUser,
       ft.AssignedUser, ft.AssignedUserId, ft.AssignedOn, ft.LastUpdated, ft.Urgent FROM filteredTransports ft


	   RETURN

END 






GO
/****** Object:  UserDefinedFunction [dbo].[getWorkingMinutes]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[getWorkingMinutes] ( @StartTime time , @endTime time , @Break1Start  time , @break1End  time, @Break2Start  time, @break2End  time , @hour int )
RETURNS INT
AS
BEGIN
	DECLARE  @minutes int 

--	SELECT @StartTime = StartTime, @endTime =endTime ,@Break1Start = Break1Start , @break1End = break1End,@Break2Start = Break2Start, @break2End = break2End FROM fn_schedule ( @Start,@end  ,'USER') where userid = @userid 

	if @hour between   datepart(hour, @StartTime) and  datepart(hour, @endTime) 
	begin
		SET @minutes = 60
		IF @hour = datepart(hour, @StartTime)  AND datepart(MINUTE, @StartTime) > 0
			SET @minutes = @minutes - datepart(MINUTE, @StartTime)
		IF @hour = datepart(hour, @endTime)  AND datepart(MINUTE, @endTime) = 0
			SET @minutes = 0
		if  (( @hour between datepart(hour, @Break1Start) and datepart(hour, @break1End)  and ( @hour = datepart(hour, @Break1Start)  or  datepart(minute, @break1End) > 0 ) ) 
			or ( @hour between datepart(hour, @Break2Start) and datepart(hour, @break2End)  and ( @hour = datepart(hour, @Break2Start)  or  datepart(minute, @break2End) > 0 ) ) )
		begin
		 if @hour = datepart(hour, @Break1Start) and @hour <> datepart(hour, @break1End )
			set @minutes = @minutes - (60 - datepart(minute, @Break1Start)) 
		 else if @hour = datepart(hour, @Break1Start) and @hour = datepart(hour, @break1End )
			set @minutes = @minutes - (  datepart(minute, @break1End) - DATEPART(minute, @Break1Start) ) 
			--set @minutes = 60 
		 else if  datepart(minute, @break1End) > 0 and  @hour <> datepart(hour, @Break1Start) and @hour = datepart(hour, @break1End )
			set @minutes = @minutes - (60 - datepart(minute, @break1End))
		 else if @hour = datepart(hour, @Break2Start) and @hour <> datepart(hour, @break2End ) 
			set @minutes = @minutes - (60 - datepart(minute, @Break2Start))
		 else if @hour = datepart(hour, @Break2Start) and @hour = datepart(hour, @break2End ) 
			set @minutes = @minutes - (  datepart(minute, @break2End) - DATEPART(minute, @Break2Start) ) 
			--set @minutes = 60 
		 else if  datepart(minute, @break2End) > 0 and  @hour <> datepart(hour, @Break2Start) and @hour = datepart(hour, @break2End ) 
			set @minutes = @minutes - (60 - datepart(minute, @break2End))
		end
		--else
		--	set @minutes = 60
	end
	else
		set @minutes = 0


	return @minutes

END
GO
/****** Object:  UserDefinedFunction [dbo].[getWorkingMinutesForDate]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[getWorkingMinutesForDate] ( @StartTime time , @endTime time , @Break1Start  time , @break1End  time, @Break2Start  time, @break2End  time , @hour INT , @date DATE)
RETURNS INT
AS
BEGIN
	DECLARE  @minutes int = 60;
	DECLARE @currDate DATE = GETDATE();
	DECLARE @currHour INT = DATEPART(HOUR,GETDATE());
	DECLARE @currMinute INT = DATEPART(MINUTE,GETDATE());
	DECLARE @InCurrHour BIT = 0;
	IF @date = @currDate AND @hour = @currHour
	BEGIN
		SET @minutes = @currMinute;
		SET @InCurrHour = 1;
	END
	IF @date > @currDate OR  (@date = @currDate AND @hour > @currHour)
		RETURN 0 
--	SELECT @StartTime = StartTime, @endTime =endTime ,@Break1Start = Break1Start , @break1End = break1End,@Break2Start = Break2Start, @break2End = break2End FROM fn_schedule ( @Start,@end  ,'USER') where userid = @userid 

	if @hour between   datepart(hour, @StartTime) and  datepart(hour, @endTime) 
	begin		
		IF @hour = datepart(hour, @StartTime)  AND datepart(MINUTE, @StartTime) > 0
			SET @minutes = @minutes - datepart(MINUTE, @StartTime)
		IF @hour = datepart(hour, @endTime)  AND datepart(MINUTE, @endTime) = 0
			SET @minutes = 0
		ELSE IF  (( @hour between datepart(hour, @Break1Start) and datepart(hour, @break1End)  and ( @hour = datepart(hour, @Break1Start)  or  datepart(minute, @break1End) > 0 ) ) 
			or ( @hour between datepart(hour, @Break2Start) and datepart(hour, @break2End)  and ( @hour = datepart(hour, @Break2Start)  or  datepart(minute, @break2End) > 0 ) ) )
		begin
		 if @hour = datepart(hour, @Break1Start) and @hour <> datepart(hour, @break1End )
		 BEGIN
			IF @InCurrHour = 0
				set @minutes = @minutes - (60 - datepart(minute, @Break1Start)) 
			ELSE IF @currMinute < datepart(minute, @Break1Start)
				set @minutes = datepart(minute, @Break1Start)
		 END
		 else if @hour = datepart(hour, @Break1Start) and @hour = datepart(hour, @break1End )
		 BEGIN
			IF @InCurrHour = 0 OR ( @InCurrHour = 1 AND @currMinute > datepart(minute, @break1End))
				SET @minutes = @minutes - (  datepart(minute, @break1End) - DATEPART(minute, @Break1Start) ) 
			ELSE IF @currMinute <= datepart(minute, @break1End) 
				set @minutes = datepart(minute, @Break1Start)
		 END
		 else if  datepart(minute, @break1End) > 0 and  @hour <> datepart(hour, @Break1Start) and @hour = datepart(hour, @break1End )
		 BEGIN
			set @minutes = @minutes - (60 - datepart(minute, @break1End))
		 END
		 else if @hour = datepart(hour, @Break2Start) and @hour <> datepart(hour, @break2End ) 
		 BEGIN
			IF @InCurrHour = 0
				SET @minutes = @minutes - (60 - datepart(minute, @Break2Start))
			ELSE IF @currMinute < datepart(minute, @Break2Start)
				set @minutes = datepart(minute, @Break2Start)
		 END
		 else if @hour = datepart(hour, @Break2Start) and @hour = datepart(hour, @break2End ) 
		 BEGIN
			IF @InCurrHour = 0 OR ( @InCurrHour = 1 AND @currMinute > datepart(minute, @break2End))
				SET @minutes = @minutes - (  datepart(minute, @break2End) - DATEPART(minute, @Break2Start) ) 
			ELSE IF @currMinute <= datepart(minute, @break2End) 
				set @minutes = datepart(minute, @Break2Start)
			--set @minutes = 60 
		 END
		 else if  datepart(minute, @break2End) > 0 and  @hour <> datepart(hour, @Break2Start) and @hour = datepart(hour, @break2End ) 
		 BEGIN
			set @minutes = @minutes - (60 - datepart(minute, @break2End))
		 END
		end
		--else
		--	set @minutes = 60
	end
	else
		set @minutes = 0


	return @minutes

END
GO
/****** Object:  UserDefinedFunction [dbo].[getWorkingMinutesForDate3Breaks]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[getWorkingMinutesForDate3Breaks] ( @StartTime time , @endTime time , @Break1Start  time , @break1End  time, @Break2Start  time, @break2End  TIME , @Break3Start  time, @break3End  time , @hour INT , @date DATE)
RETURNS INT
AS
BEGIN
	DECLARE  @minutes int = 60;
	DECLARE @currDate DATE = GETDATE();
	DECLARE @currHour INT = DATEPART(HOUR,GETDATE());
	DECLARE @currMinute INT = DATEPART(MINUTE,GETDATE());
	DECLARE @InCurrHour BIT = 0;
	IF @date = @currDate AND @hour = @currHour
	BEGIN
		SET @minutes = @currMinute;
		SET @InCurrHour = 1;
	END
	IF @date > @currDate OR  (@date = @currDate AND @hour > @currHour)
		RETURN 0 
--	SELECT @StartTime = StartTime, @endTime =endTime ,@Break1Start = Break1Start , @break1End = break1End,@Break2Start = Break2Start, @break2End = break2End FROM fn_schedule ( @Start,@end  ,'USER') where userid = @userid 

	if @hour between   datepart(hour, @StartTime) and  datepart(hour, @endTime) 
	begin		
		IF @hour = datepart(hour, @StartTime)  AND datepart(MINUTE, @StartTime) > 0
			SET @minutes = @minutes - datepart(MINUTE, @StartTime)
		IF @hour = datepart(hour, @endTime)  AND datepart(MINUTE, @endTime) = 0
			SET @minutes = 0
		ELSE IF  (( @hour between datepart(hour, @Break1Start) and datepart(hour, @break1End)  and ( @hour = datepart(hour, @Break1Start)  or  datepart(minute, @break1End) > 0 ) ) 
			or ( @hour between datepart(hour, @Break2Start) and datepart(hour, @break2End)  and ( @hour = datepart(hour, @Break2Start)  or  datepart(minute, @break2End) > 0 ) )
			or ( @hour between datepart(hour, @Break3Start) and datepart(hour, @break3End)  and ( @hour = datepart(hour, @Break3Start)  or  datepart(minute, @break3End) > 0 ) ) )
		begin
		 if @hour = datepart(hour, @Break1Start) and @hour <> datepart(hour, @break1End )
		 BEGIN
			IF @InCurrHour = 0
				set @minutes = @minutes - (60 - datepart(minute, @Break1Start)) 
			ELSE IF @currMinute < datepart(minute, @Break1Start)
				set @minutes = datepart(minute, @Break1Start)
		 END
		 else if @hour = datepart(hour, @Break1Start) and @hour = datepart(hour, @break1End )
		 BEGIN
			IF @InCurrHour = 0 OR ( @InCurrHour = 1 AND @currMinute > datepart(minute, @break1End))
				SET @minutes = @minutes - (  datepart(minute, @break1End) - DATEPART(minute, @Break1Start) ) 
			ELSE IF @currMinute <= datepart(minute, @break1End) 
				set @minutes = datepart(minute, @Break1Start)
		 END
		 else if  datepart(minute, @break1End) > 0 and  @hour <> datepart(hour, @Break1Start) and @hour = datepart(hour, @break1End )
		 BEGIN
			set @minutes = @minutes - (60 - datepart(minute, @break1End))
		 END
		 else if @hour = datepart(hour, @Break2Start) and @hour <> datepart(hour, @break2End ) 
		 BEGIN
			IF @InCurrHour = 0
				SET @minutes = @minutes - (60 - datepart(minute, @Break2Start))
			ELSE IF @currMinute < datepart(minute, @Break2Start)
				set @minutes = datepart(minute, @Break2Start)
		 END
		 else if @hour = datepart(hour, @Break2Start) and @hour = datepart(hour, @break2End ) 
		 BEGIN
			IF @InCurrHour = 0 OR ( @InCurrHour = 1 AND @currMinute > datepart(minute, @break2End))
				SET @minutes = @minutes - (  datepart(minute, @break2End) - DATEPART(minute, @Break2Start) ) 
			ELSE IF @currMinute <= datepart(minute, @break2End) 
				set @minutes = datepart(minute, @Break2Start)
			--set @minutes = 60 
		 END
		 else if  datepart(minute, @break2End) > 0 and  @hour <> datepart(hour, @Break2Start) and @hour = datepart(hour, @break2End ) 
		 BEGIN
			set @minutes = @minutes - (60 - datepart(minute, @break2End))
		 END

		  else if @hour = datepart(hour, @Break3Start) and @hour <> datepart(hour, @break3End ) 
		 BEGIN
			IF @InCurrHour = 0
				SET @minutes = @minutes - (60 - datepart(minute, @Break3Start))
			ELSE IF @currMinute < datepart(minute, @Break3Start)
				set @minutes = datepart(minute, @Break3Start)
		 END
		 else if @hour = datepart(hour, @Break3Start) and @hour = datepart(hour, @break3End ) 
		 BEGIN
			IF @InCurrHour = 0 OR ( @InCurrHour = 1 AND @currMinute > datepart(minute, @break3End))
				SET @minutes = @minutes - (  datepart(minute, @break3End) - DATEPART(minute, @Break3Start) ) 
			ELSE IF @currMinute <= datepart(minute, @break3End) 
				set @minutes = datepart(minute, @Break3Start)
			--set @minutes = 60 
		 END
		 else if  datepart(minute, @break3End) > 0 and  @hour <> datepart(hour, @Break3Start) and @hour = datepart(hour, @break3End ) 
		 BEGIN
			set @minutes = @minutes - (60 - datepart(minute, @break3End))
		 END


		end
		--else
		--	set @minutes = 60
	end
	else
		set @minutes = 0


	return @minutes

END
GO
-- /****** Object:  UserDefinedFunction [dbo].[HasCutDoorsOnAllDoors]    Script Date: 6/17/2021 11:37:56 AM ******/
-- SET ANSI_NULLS ON
-- GO
-- SET QUOTED_IDENTIFIER ON
-- GO
-- CREATE FUNCTION [dbo].[HasCutDoorsOnAllDoors]
-- (
-- 	@QuoteProductID INT
-- )
-- RETURNS BIT
-- AS
-- BEGIN
-- RETURN CAST
-- (
-- 	CASE WHEN EXISTS
-- 	(
-- 		SELECT TOP 100 * FROM FABUSQL02.eFabuwood.dbo.QuoteProductMods AS qpm
-- 		JOIN FABUSQL02.eFabuwood.dbo.QuoteProducts QP ON QP.QuoteProductID = qpm.QuoteProductID
-- 		JOIN FABUSQL02.eFabuwood.dbo.Products P ON P.ProductID = QP.ProductID
-- 		WHERE qpm.Quantity = P.BaseDoors 
-- 		AND qpm.ModificationCode = 'CUT-DOOR'
-- 		AND qpm.QuoteProductID = @QuoteProductID
-- 	)
-- 	THEN 1 ELSE 0 END AS BIT
-- ) 
-- 
-- END
-- 
-- GO
/****** Object:  UserDefinedFunction [dbo].[HingeSlideColor]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[HingeSlideColor] 
(	
	-- Add the parameters for the function here
	@ID INT
)

RETURNS @Color TABLE 
(
hColor VARCHAR(25),
sColor VARCHAR(25)
)
AS
BEGIN

	
	INSERT INTO @Color(hColor, sColor)
	(SELECT hColor = CASE WHEN te.ProductDescriptionAdditions LIKE '%*BLUM-CORNER HINGE*%' THEN 'Gray' 
					  WHEN te.ProductDescriptionAdditions LIKE '%*BLUM-HINGE*%' THEN 'Green'
					  WHEN te.ProductDescriptionAdditions LIKE '%*VALUE HINGE 1 1/4"*%' THEN 'Black'
					  WHEN te.ProductDescriptionAdditions LIKE '%*VALUE HINGE 3/8"*%' THEN 'Orange'
					  ELSE '' END,
					sColor = CASE WHEN te.ProductDescriptionAdditions LIKE '%*BLUM SLIDE 21" E*%' THEN 'Red' 
					  WHEN te.ProductDescriptionAdditions LIKE '%*BLUM SLIDE 21" H*%' THEN 'Blue'
					  WHEN te.ProductDescriptionAdditions LIKE '%*BLUM SLIDE 18" E*%' THEN 'Red' 
					  WHEN te.ProductDescriptionAdditions LIKE '%*BLUM SLIDE 18" H*%' THEN 'Blue'
					  WHEN te.ProductDescriptionAdditions LIKE '%*EPOXY SLIDE 18"*%' THEN 'Yellow' 
					  WHEN te.ProductDescriptionAdditions LIKE '%*EPOXY SLIDE 21"*%' THEN 'Yellow'
					  ELSE '' END 
					  FROM dbo.TranEntry te WHERE te.ID = @ID)

		
		
return
end
		

GO
/****** Object:  UserDefinedFunction [dbo].[HingeSlideColor1]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[HingeSlideColor1] 
(	
	-- Add the parameters for the function here
	@ProductDescriptionAdditions VARCHAR(500)
)

RETURNS @Color TABLE 
(
hColor VARCHAR(25),
sColor VARCHAR(25)
)
AS
BEGIN

	
	INSERT INTO @Color(hColor, sColor)
	(SELECT hColor = CASE WHEN @ProductDescriptionAdditions LIKE '%*BLUM-CORNER HINGE*%' THEN 'Gray' 
					  WHEN @ProductDescriptionAdditions LIKE '%*BLUM-HINGE*%' THEN 'Green'
					  WHEN @ProductDescriptionAdditions LIKE '%*VALUE HINGE 1 1/4"*%' THEN 'Black'
					  WHEN @ProductDescriptionAdditions LIKE '%*VALUE HINGE 3/8"*%' THEN 'Orange'
					  ELSE '' END,
					sColor = CASE WHEN @ProductDescriptionAdditions LIKE '%*BLUM SLIDE 21" E*%' THEN 'Red' 
					  WHEN @ProductDescriptionAdditions LIKE '%*BLUM SLIDE 21" H*%' THEN 'Blue'
					  WHEN @ProductDescriptionAdditions LIKE '%*BLUM SLIDE 18" E*%' THEN 'Red' 
					  WHEN @ProductDescriptionAdditions LIKE '%*BLUM SLIDE 18" H*%' THEN 'Blue'
					  WHEN @ProductDescriptionAdditions LIKE '%*EPOXY SLIDE 18"*%' THEN 'Yellow' 
					  WHEN @ProductDescriptionAdditions LIKE '%*EPOXY SLIDE 21"*%' THEN 'Yellow'
					  ELSE '' END)

		
		
return
end
		

GO
/****** Object:  UserDefinedFunction [dbo].[HoursInStatus]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[HoursInStatus] 
(
	@StartTime datetime,
	@EndTime datetime
)
RETURNS INT
AS
BEGIN
DECLARE
@v_TimeInStatus INT,
@v_TotalHrs INT,
@v_dateTime datetime

set @v_TimeInStatus = 0
set @v_dateTime = @StartTime
set @v_TotalHrs = DATEDIFF(hh, @StartTime , @EndTime)
    while (@v_TotalHrs > 0)
    	begin
        	set @v_dateTime = DATEADD(hh , 1, @v_dateTime) 
        	if(datepart(weekday, @v_dateTime) != 1) AND (datepart(weekday, @v_dateTime) != 7)
            	BEGIN
                	if(convert(int, datepart(hh, @v_dateTime)) > 8 and convert(int, datepart(hh, @v_dateTime)) < 17)
                    	BEGIN        
        					set @v_TimeInStatus = @v_TimeInStatus + 1 
                        END
                END
            set @v_TotalHrs = @v_TotalHrs -1 
		END
		
 return @v_TimeInStatus

END

GO
/****** Object:  UserDefinedFunction [dbo].[IsAddOn]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[IsAddOn] ( @id AS INT )
RETURNS BIT
AS
    BEGIN
        DECLARE @isAddon AS BIT	= 0;
        SELECT  @isAddon = CASE WHEN EXISTS ( SELECT    1
                                              FROM      dbo.TranEntry te
                                                        JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
                                              WHERE     te.ID = @id
                                                        AND te.EZParentProdID IS NOT NULL
                                                        AND NOT EXISTS ( SELECT
                                                              1
                                                              FROM
                                                              dbo.tb_itemClassDetail ic
                                                              WHERE
                                                              ic.ItemCode = il.ShortItemCode
                                                              AND ic.ClassID = 52 ) )
                                THEN 1
                                ELSE 0
                           END;
        RETURN @isAddon
    END	
GO
/****** Object:  UserDefinedFunction [dbo].[IsInProductsForQ13WallDropLocation]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[IsInProductsForQ13WallDropLocation](
@OrderItemId int 
) 
RETURNS bit 
AS 
BEGIN
   RETURN CAST(CASE WHEN EXISTS(SELECT * FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
	JOIN inventory.Products AS p ON p.ProductID = til.ProductID
	WHERE te.ID = @OrderItemId AND p.ProductCode IN
(
'MWS',
'NDW1230',
'NDW1236',
'NDW1242',
'NDW1530',
'NDW1536',
'NDW1542',
'NDW1830',
'NDW1836',
'NDW1842',
'NDW2430',
'NDW2436',
'NDW2442',
'NDW3030',
'NDW3036',
'NDW3042',
'NDW3630',
'NDW3636',
'NDW3642',
'W0930',
'W0936',
'W0942',
'W1230',
'W1236',
'W1242',
'W1530',
'W1536',
'W1542',
'W1830',
'W1836',
'W1842',
'W2115',
'W2118',
'W2130',
'W2136',
'W2142',
'W2415',
'W2418',
'W2424',
'W2430',
'W2436',
'W2442',
'W2730',
'W2736',
'W2742',
'W3012',
'W3015',
'W301524',
'W3018',
'W301824',
'W3021',
'W3024',
'W302424',
'W3027',
'W3030',
'W3036',
'W3042',
'W3312',
'W331224',
'W3315',
'W331524',
'W3318',
'W331824',
'W3324',
'W332424',
'W3330',
'W3336',
'W3342',
'W3612',
'W361224',
'W3615',
'W361524',
'W3618',
'W361824',
'W3624',
'W362424',
'W3630',
'W3636',
'W3642',
'W3930',
'W3936',
'W3942',
'W4212',
'W4230',
'W4236',
'W4242',
'W4812',
'W481224',
'W4830',
'WBC2430',
'WBC2436',
'WBC2442',
'WBC2730',
'WBC2742',
'WBC3030',
'WBC3036',
'WBC3042',
'WBC3630',
'WBC3636',
'WBC3642',
'WBC3930',
'WBC3936',
'WBC3942',
'WBC4230',
'WBC4236',
'WBC4242',
'WOS1330',
'WOS1336',
'WOS1342',
'WOS1830',
'WOS1836',
'WOS1842',
'WOS3030',
'WOS3036',
'WOS3042'
))THEN 1 ELSE 0 END  AS BIT)
	
END
GO
/****** Object:  UserDefinedFunction [dbo].[IsInQ13Rules]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <10/24/2019>
-- Description:	<Returns whether an old item should be processed with q13 rules or not>
-- =============================================
CREATE FUNCTION [dbo].[IsInQ13Rules] 
(
	@orderItemId INT
)
RETURNS BIT
AS
BEGIN
	DECLARE @OrigOrderNumber NVARCHAR(50) = ''
	SELECT @OrigOrderNumber  = SUBSTRING(te.OrderIdentity,0, LEN(te.OrderIdentity)-1) FROM dbo.TranEntry AS te WHERE te.ID = @orderItemId
 
	RETURN CAST(CASE WHEN EXISTS(SELECT * FROM dbo.TranEntry AS te
		JOIN dbo.[Order] AS o ON o.ID = te.OrderID
		JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
		LEFT JOIN dbo.ItemsQ13Process AS iqp ON iqp.DoorStyleId = til.DoorStyleID
		WHERE te.ID = @orderItemId
		AND (GETDATE() > iqp.EffectiveDatetime OR te.Addtime > '2020-01-05 16:30:00.000')
		--OR EXISTS( SELECT * FROM dbo.ItemsQ13Process AS iqp WHERE iqp.DoorStyleId = til.DoorStyleID AND BaseRulesOnOrderDate = 0 )

		AND NOT EXISTS(SELECT * FROM dbo.TranEntry AS te2 
			JOIN dbo.tb_ItemSeriel AS tis ON tis.TranEntryID = te2.ID
			JOIN dbo.tb_ItemList til2  ON til2.ItemCode = te2.ItemNumber AND til2.ItemTypeCode IN(1,2) AND til.DoorStyleID = til2.DoorStyleID
			JOIN dbo.ItemsQ13Process iqp ON iqp.DoorStyleId = til2.DoorStyleID
			WHERE (te2.OrderID = o.ID AND tis.Picked = 1 AND tis.PickedTime < iqp.EffectiveDatetime))

		AND NOT EXISTS(SELECT * FROM dbo.[Order] AS o2 
			JOIN dbo.TranEntry AS te2 ON  te2.OrderID = o2.OrderID
			JOIN dbo.tb_ItemSeriel AS tis ON tis.TranEntryID = te2.ID
			JOIN dbo.tb_ItemList til2  ON til2.ItemCode = te2.ItemNumber AND til2.ItemTypeCode IN(1,2) AND til.DoorStyleID = til2.DoorStyleID
			JOIN dbo.ItemsQ13Process iqp ON iqp.DoorStyleId = til2.DoorStyleID
			WHERE o2.isBackOrder = 1 
			AND 
			--LEFT(o.SOnumber, CASE WHEN CHARINDEX('-', o.SOnumber) > 0 THEN  CHARINDEX('-', o.SOnumber) - 1 ELSE NULL END) =
			  o2.SOnumber = @OrigOrderNumber
			AND (tis.Picked = 1 AND tis.PickedTime < iqp.EffectiveDatetime OR (o2.Addtime > iqp.EffectiveDatetime AND iqp.BaseRulesOnOrderDate = 1)))

	AND NOT EXISTS(
				SELECT * FROM  [dbo].[fc_GetOrderNumberFromRMA](o.SOnumber) gon
				JOIN dbo.[Order] o2 ON o2.SOnumber = gon.soNumber
				JOIN dbo.TranEntry te2 ON te2.OrderID = o2.ID
				JOIN dbo.tb_ItemList AS til2 ON til2.ItemCode = te2.ItemNumber
				JOIN dbo.tb_ItemSeriel AS tis ON tis.TranEntryID = te2.ID AND til2.ItemTypeCode IN (1,2) AND til.DoorStyleID = til2.DoorStyleID
				JOIN dbo.ItemsQ13Process iqp ON iqp.DoorStyleId = til2.DoorStyleID
				WHERE o.SOnumber LIKE 'RMA%' AND (tis.Picked = 1 AND tis.PickedTime < iqp.EffectiveDatetime OR (o2.Addtime > iqp.EffectiveDatetime AND iqp.BaseRulesOnOrderDate = 1))
			)) THEN 1
		ELSE 0 END AS bit)
END

GO
/****** Object:  UserDefinedFunction [dbo].[IsNullVarchar]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[IsNullVarchar](@First VARCHAR(MAX), @Second VARCHAR(MAX))
RETURNS VARCHAR(MAX)
AS
BEGIN
    RETURN CASE WHEN @First IS NOT NULL THEN @First ELSE @Second END 
END
GO
/****** Object:  UserDefinedFunction [dbo].[IsQpOrderPreQ13]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[IsQpOrderPreQ13] 
(
	-- Add the parameters for the function here
	@QuoteProductID int
)
RETURNS BIT
AS
BEGIN
	-- Declare the return variable here
	
	DECLARE @PreQ13 bit = 0, @EzProd VARCHAR(50) = 'I-' + CAST(@QuoteProductID AS VARCHAR(50))

	SELECT @PreQ13 = 1 FROM 
	dbo.TranEntry AS te 
	JOIN dbo.TranEntry AS te2 ON te2.OrderID = te.OrderID 
	JOIN dbo.tb_ItemSeriel AS tis ON tis.TranEntryID = te2.ID
	JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
	JOIN dbo.tb_ItemList AS til2 ON til2.ItemCode = te2.ItemNumber AND til2.ItemTypeCode IN(1,2)
	JOIN inventory.DoorStyles AS ds ON ds.DoorStyleCode = LEFT(til.ShortItemCode,2)
	JOIN dbo.ItemsQ13Process AS iqp ON iqp.DoorStyleId = ds.DoorStyleID AND iqp.EffectiveDatetime < GETDATE()
	WHERE te.EZProdID = @EzProd
	AND tis.PickedTime < iqp.EffectiveDatetime


	RETURN @PreQ13

END



GO
/****** Object:  UserDefinedFunction [dbo].[IsRevisionAInMixedOrder]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[IsRevisionAInMixedOrder]
    (@orderItemId AS INT)
RETURNS BIT

AS
BEGIN
DECLARE @ReturnValue BIT = 0
--SELECT @ReturnValue = CAST(CASE WHEN EXISTS(SELECT 1 FROM dbo.TranEntry te 
--	JOIN dbo.TranEntry te2 ON te2.OrderID = te.OrderID AND te2.isDeleted = 0
--	WHERE te.ID = @orderItemId
--	AND EXISTS(SELECT * FROM picking.OrderItemProductionItemIRelease AS oipir WHERE oipir.OrderItemId = te.ID AND oipir.Revision = 'A')
--	AND EXISTS(SELECT * FROM picking.OrderItemProductionItemIRelease AS oipir WHERE oipir.OrderItemId = te2.ID AND oipir.Revision <> 'A'))
--THEN 1
--ELSE 0 END AS BIT)
RETURN @ReturnValue
END


GO
/****** Object:  UserDefinedFunction [dbo].[IsSameShippingAddress]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
--Used in: BOGPS, Common Carrier Pallet Label, CCOPL, Validate Matching Orders Ship to Addresses
-- =============================================
CREATE FUNCTION [dbo].[IsSameShippingAddress]

    (@_existingOrder AS INT, @_newOrder AS INT)
RETURNS BIT	

AS
BEGIN
DECLARE @ExistingOrder AS INT = @_existingOrder;
DECLARE @NewOrder AS INT =	@_newOrder;		
DECLARE  @isSame AS BIT	 = 0;
DECLARE @ExistingShipLocation INT;
DECLARE @NewShipLocation INT;



			IF EXISTS (SELECT  1 FROM dbo.[Order] AS o WHERE o.ID IN (@ExistingOrder, @NewOrder) AND (o.ShipAddr1 LIKE '%pick%' ))--OR ISNULL(o.ShipAddr1, '') = '')) LR 3/8/2017 SDT-25701
				SET @isSame = 1
			ELSE				
			
		--	SELECT @ExistingShipLocation = ServiceLocationID FROM dbo.OrderShipLocation AS osl WHERE osl.OrderId = 355650
		--	SELECT @NewShipLocation = ServiceLocationID FROM dbo.OrderShipLocation AS osl WHERE osl.OrderId = @NewOrder

           SELECT @isSame =  1 FROM dbo.OrderShipLocation AS osl WHERE osl.OrderId = @ExistingOrder AND osl.ServiceLocationID =
            (SELECT osl2.ServiceLocationID  FROM dbo.OrderShipLocation AS osl2 WHERE osl2.OrderId = @NewOrder) 
			 
			-- IF ISNULL(@ExistingShipLocation,0) = ISNULL(@NewShipLocation,0)
			-- SET @isSame = 1 
			-- ELSE SET @isSame = 0
			 
			
			   
			RETURN @isSame;
			
           
END



GO
/****** Object:  UserDefinedFunction [dbo].[IsSmallOrder]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<BKalish>
-- Create date: <7/16/2019>
-- Description:	<small orders that usually go to a z location>
-- =============================================
CREATE FUNCTION [dbo].[IsSmallOrder]
(
	-- Add the parameters for the function here
	@OrderID int
)
RETURNS bit 
AS
BEGIN
	-- Declare the return variable here
	DECLARE @smallOrder BIT = 0
  SELECT @smallOrder = 1  FROM dbo.TranEntry AS te WHERE te.OrderID = @OrderID
  AND te.ItemType IN (1,2) AND te.KD = 0  AND te.isActive = 1 GROUP BY te.OrderID HAVING COUNT(*) < 4

  RETURN @smallOrder

END

GO
/****** Object:  UserDefinedFunction [dbo].[isZlocation]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/****** Script for SelectTopNRows command from SSMS  ******/


CREATE FUNCTION [dbo].[isZlocation] ( @teid2 INT, @orderid int )
RETURNS bit
AS
    BEGIN 	
        DECLARE @isZ bit
		declare @teid int
		set @teid = @teid2
			
        SELECT  @isZ=case when 
		
		
				dbo.GetCubicftTranEntry(@teid)
					 < 21 AND EXISTS ( 
                      SELECT 1
                           FROM   dbo.TranEntry te1 ( NOLOCK )    						                                    
                           WHERE  
						   te1.OrderID = @orderid
                                         AND te1.isActive = 1 AND te1.isDeleted = 0 
                                         AND EXISTS 
										 (SELECT 1 FROM dbo.tb_ItemList il WHERE il.ItemCode = te1.ItemNumber AND il.ItemTypeCode=1)
										 and not exists(select 1 from tb_ItemList IL WHERE te1.ItemNumber = il.itemcode AND 
											(il.itemtypecode=12 or (il.itemtypecode = 7 and il.SubTypeCode = 'pk') ) )
										 AND NOT EXISTS (SELECT 1 FROM dbo.CabinetTrack ct1 WHERE ct1.TranEntryID=te1.ID AND ct1.Active=1)
                           GROUP BY te1.OrderID
                           HAVING COUNT(*) <= 3 AND SUM(dbo.GetCubicftTranEntry(te1.ID)) <= 25	

						   )
		
			 then 1 else 0 end
			-- OPTION(RECOMPILE)
	RETURN @isZ
    END 





	 --dbo.GetCubicftTranEntry(@teid) < 21 
		
		--AND EXISTS ( 
		--	SELECT COUNT(*)
		--		 FROM   dbo.TranEntry te1 ( NOLOCK )
		--		 WHERE  te1.orderid = @orderid and 				 
		--				 te1.isActive = 1 AND te1.isDeleted = 0 --AND te.ItemType = 1 
		--				AND not EXISTS (SELECT 1 FROM dbo.tb_ItemList il WHERE te1.ItemNumber = il.ItemCode AND (il.ItemTypeCode = 12 or 
		--				(il.itemtypecode = 7 and il.SubTypeCode = 'pk')))
		--		 GROUP BY te1.OrderID
		--		 HAVING COUNT(*) <= 3 AND SUM(dbo.GetCubicftTranEntry(te1.ID)) <= 25
		--	)




GO
/****** Object:  UserDefinedFunction [dbo].[ItemCodeWithoutStyleAlias]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[ItemCodeWithoutStyleAlias]
(	
	-- Add the parameters for the function here
	@itemCode AS VARCHAR(MAX) 
)
RETURNS varchar(max)
AS
BEGIN
--DECLARE @refinedItemCode VARCHAR(MAX);
    select @itemCode = REPLACE(@itemCode, fln.LineName + ' ', '') 
      FROM dbo.FabuLineNames fln
    RETURN @itemCode
END

GO
/****** Object:  UserDefinedFunction [dbo].[ItemHistoryHasStatusClass]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<David Edel>
-- Create date: <4/27/2020>
-- Description:	<Check on tran-entry if it has in history any status from status class master >
-- =============================================
CREATE FUNCTION [dbo].[ItemHistoryHasStatusClass]
(
	-- Add the parameters for the function here
	@orderItemId INT, @statusClassId INT
)
RETURNS BIT
AS
BEGIN
	-- Declare the return variable here
	DECLARE @result BIT;

	-- Add the T-SQL statements to compute the return value here
	SELECT @result =  CAST(CASE WHEN EXISTS(
	SELECT * FROM dbo.History H 
	JOIN dbo.Departmentstatus D ON D.ID = H.DepartmentstatusID
	WHERE H.TranentryID = @orderItemId
	AND (H.DepartmentstatusID IN (
		SELECT TSCD.StatusID FROM dbo.tb_StatusClassDetail TSCD
		WHERE TSCD.ClassMasterID = @statusClassId AND TSCD.IsActive = 1
		)
	OR D.Departmentid IN (
		SELECT TSCD2.DepartmentID FROM dbo.tb_StatusClassDetail TSCD2
		WHERE TSCD2.ClassMasterID = @statusClassId AND TSCD2.IsActive = 1
		))
	) 
	THEN 1 ELSE 0 END 
	AS BIT)

	-- Return the result of the function
	RETURN @result

END
GO
/****** Object:  UserDefinedFunction [dbo].[ItemNeedsUnderwallSkin]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <9/9/2019>
-- Description:	<Returns if an old construction item need an under wall skin>
-- =============================================
CREATE FUNCTION [dbo].[ItemNeedsUnderwallSkin]
(
	@tranEntry int
)
RETURNS BIT
AS
BEGIN
	DECLARE @returnValue BIT = 0
	SELECT @returnValue = 1 WHERE (SELECT dbo.IsInQ13Rules(@tranEntry)) = 1
	AND EXISTS(SELECT * FROM dbo.tb_ItemList AS til
		JOIN dbo.TranEntry te ON te.ItemNumber = til.ItemCode
		WHERE te.ID = @tranEntry
		AND EXISTS(SELECT * FROM picking.ProductionItemConfigRule AS picr
			JOIN picking.ProductionItemConfigRuleDetail AS picrd ON picrd.ProductionItemConfigRuleId = picr.ProductionItemConfigRuleId AND picr.ProductionItemConfigRuleId=picrd.ProductionItemConfigRuleId AND picrd.Active=1
			WHERE picr.Active=1
			AND EXISTS (SELECT * FROM picking.ProductionItemConfigRuleCondition AS picrc 
				WHERE picrc.ProductionItemConfigRuleId = picr.ProductionItemConfigRuleId AND picrc.Active=1 
				AND picrc.ConditionName = 'UnderWallSkinRequired')
				AND picrd.ProductId = til.ProductID)
		AND EXISTS(SELECT * FROM picking.OrderItemProductionItemIRelease AS oipiir WHERE oipiir.OrderItemId = te.ID AND oipiir.Revision = 'A'))
	RETURN @returnValue	
END



GO
/****** Object:  UserDefinedFunction [dbo].[JobRunning]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[JobRunning]
	(
		@name nvarchar(128) 
	)
	RETURNS BIT
	AS 
	BEGIN
		DECLARE @Running BIT = 0
		SELECT @Running = 1  FROM msdb.dbo.sysjobs_view job
		 JOIN msdb.dbo.sysjobactivity activity ON  job.job_id = activity.job_id
		 JOIN msdb.dbo.syssessions sess ON sess.session_id = activity.session_id
		 JOIN(SELECT MAX( agent_start_date ) AS max_agent_start_date FROM msdb.dbo.syssessions ) sess_max ON sess.agent_start_date = sess_max.max_agent_start_date
		 WHERE activity.run_requested_date IS NOT NULL AND  activity.stop_execution_date IS NULL
		 AND job.name=@name
		RETURN @Running
	END
GO
/****** Object:  UserDefinedFunction [dbo].[NeedsToCutToeKick]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[NeedsToCutToeKick]
    (@orderItemId AS INT)
RETURNS BIT 

AS
BEGIN
DECLARE @needsCutToeKick BIT = 0
SELECT @needsCutToeKick = CAST(CASE WHEN EXISTS(
	SELECT 1 FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS til ON te.ItemNumber = til.ItemCode
	WHERE te.ID = @orderItemId
	AND EXISTS(SELECT * FROM inventory.ProductTags AS pt
		JOIN inventory.ProductToProductTags AS ptpt ON ptpt.ProductTagId = pt.ProductTagId AND ptpt.DeleteFlag=0
		JOIN inventory.Products p ON p.ProductID = ptpt.ProductId
		WHERE pt.ProductTagId IN(2,5,6,7,11,20,21,27)
		AND pt.ProductTagId NOT IN (4, 18)
		AND til.ProductID = p.ProductID AND ptpt.DeleteFlag = 0
		AND p.ProductID NOT IN (96,99,100,317,318,319,323,324,412,413,535)
	AND (SELECT dbo.IsInQ13Rules(@orderItemId)) = 1
	AND EXISTS(SELECT * FROM picking.OrderItemProductionItemIRelease AS oipiir WHERE oipiir.OrderItemId = te.ID AND oipiir.Revision = 'A')
))THEN 1 ELSE 0 END AS BIT)

RETURN @needsCutToeKick
END




GO
/****** Object:  UserDefinedFunction [dbo].[NeedsToCutToeKickForLabel]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[NeedsToCutToeKickForLabel]
    (@orderItemId AS INT)
RETURNS BIT 

AS
BEGIN
DECLARE @needsCutToeKick BIT = 0
SELECT @needsCutToeKick = CAST(CASE WHEN EXISTS(
	SELECT 1 FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS til ON te.ItemNumber = til.ItemCode
	WHERE te.ID = @orderItemId
	AND EXISTS(SELECT * FROM inventory.ProductTags AS pt
		JOIN inventory.ProductToProductTags AS ptpt ON ptpt.ProductTagId = pt.ProductTagId and ptpt.DeleteFlag=0
		JOIN inventory.Products p ON p.ProductID = ptpt.ProductId
		WHERE pt.ProductTagId IN(2,5,6,7,11,20,21,27)
		AND pt.ProductTagId NOT IN (4, 18)
		AND til.ProductID = p.ProductID AND ptpt.DeleteFlag = 0
		AND p.ProductID NOT IN (319,535)
	AND (SELECT dbo.IsInQ13Rules(@orderItemId)) = 1
	AND EXISTS(SELECT * FROM picking.OrderItemProductionItemIRelease AS oipiir WHERE oipiir.OrderItemId = te.ID AND oipiir.Revision = 'A')
	
	--remove from here when going live
			--AND EXISTS(
			--SELECT * FROM dbo.[Order] AS o WHERE o.CustomerName = 'test orders' AND o.OrderID = te.OrderID)
	--remove till here
))THEN 1 ELSE 0 END AS BIT)

RETURN @needsCutToeKick
END



GO
/****** Object:  UserDefinedFunction [dbo].[NegativeIntToZero]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[NegativeIntToZero]
(
	@Number INT
)
RETURNS INT
AS
BEGIN
    RETURN CASE WHEN @Number < 0 THEN 0 ELSE @Number END
END
GO
/****** Object:  UserDefinedFunction [dbo].[OrderItemHasCutDoorsOnAllDoors]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[OrderItemHasCutDoorsOnAllDoors]
(
	@OrderItemId INT
)
RETURNS BIT
AS
BEGIN
RETURN CAST
(
	CASE WHEN EXISTS
	(
		   SELECT 1 FROM dbo.TranEntry AS te 
			 JOIN dbo.TranEntry AS te2 ON te.OrderID=te2.OrderID AND te2.EZProdID=te.EZParentProdID  AND te2.isDeleted=0
			 JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = te2.AcumaticaID
			 JOIN inventory.AcumaticaProducts AS ap ON ap.AcumaticaID = asi.AcumaticaProductID 
			 WHERE te2.ID = @OrderItemId AND te.ItemNumber = 'UP CHARGE:CUT-DOOR' AND COALESCE(ap.BaseDoors,1) = te.qbQuantity
	)
	THEN 1 ELSE 0 END AS BIT
) 

END

GO
/****** Object:  UserDefinedFunction [dbo].[OrderStatusBlocksItemStatus]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[OrderStatusBlocksItemStatus] 
(
   @ItemStatus  int,
   @OrderStatus  int,
   @customername varchar(200) = null
)
RETURNS bit
AS
BEGIN
   DECLARE @Result INT
 
 if @customername = 'Empire State Supply Corp.'
 begin
 set @result = 0
 end

 else

 begin

   SELECT @Result = 				
    SUM(NUM) FROM
				(
				SELECT count(1) AS NUM FROM ItemStatusBlocks
				where BlockItemStatus = @ItemStatus and OrderStatusIn = @OrderStatus
				union
				SELECT COUNT(1) AS NUM FROM  ItemstatusBlocks I where blockitemstatus = @ItemStatus 
				AND  NOT EXISTS(SELECT 1 FROM ItemstatusBlocks I2 WHERE I2.OrderStatusNotIn is not null
				 and orderstatusnotin = @OrderStatus AND I2.BlockItemStatus = @ItemStatus)					
				)V
end

   RETURN CAST(@Result AS BIT)
END



--select * from departmentstatus where id in (172,67)
--select dbo.[OrderStatusBlocksItemStatus](172, 67)
--select * from ItemstatusBlocks

--implement a block when trying to scan an Item with the status 172
--if the order is not currently in the status 67


--SELECT 1 FROM ItemstatusBlocks I2 WHERE I2.OrderStatusNotIn is not null and orderstatusnotin = 67 AND I2.BlockItemStatus = 172
GO
/****** Object:  UserDefinedFunction [dbo].[PickDaysAheadToBringFromOverstock]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Aron Steinmetz
-- Create date: 9/5/2019
-- Description:	Get how many pick days ahead to bring down stock from overstock locations
-- =============================================
CREATE FUNCTION [dbo].[PickDaysAheadToBringFromOverstock]
(
)
RETURNS INT
AS
BEGIN
	DECLARE @PickDaysAheadToBringFromOverstock INT = 3
	SELECT @PickDaysAheadToBringFromOverstock = CAST(gv.DefaultValue AS NUMERIC) FROM dbo.GPSVariables gv WHERE gv.VariableName='PickDaysAheadToBringFromOverstock' AND ISNUMERIC(gv.DefaultValue) = 1
	RETURN @PickDaysAheadToBringFromOverstock
END

GO
/****** Object:  UserDefinedFunction [dbo].[ProperCase]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create function [dbo].[ProperCase](@Text as varchar(8000))
returns varchar(8000)
as
begin
   declare @Reset bit;
   declare @Ret varchar(8000);
   declare @i int;
   declare @c char(1);

   select @Reset = 1, @i=1, @Ret = '';

   while (@i <= len(@Text))
    select @c= substring(@Text,@i,1),
               @Ret = @Ret + case when @Reset=1 then UPPER(@c) else LOWER(@c) end,
               @Reset = case when @c like '[a-zA-Z]' then 0 else 1 end,
               @i = @i +1
   return @Ret
end
GO
/****** Object:  UserDefinedFunction [dbo].[RelatedOrders]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE  FUNCTION [dbo].[RelatedOrders] ( @orderID AS INT )
RETURNS 
@orders TABLE
(
	OrderNumber VARCHAR(50)
) 
BEGIN	
	DECLARE @SoNumber VARCHAR(50)
	SELECT @SoNumber = SoNumber FROM [order] WHERE orderid = @orderID
	INSERT @orders ( OrderNumber )

	SELECT SOnumber FROM dbo.[Order] WHERE linkedQuoteNumber =@SoNumber
	UNION  
	SELECT linkedQuoteNumber FROM dbo.[Order] WHERE SOnumber = @SoNumber AND linkedQuoteNumber IS NOT NULL

	INSERT @orders ( OrderNumber )
	SELECT SOnumber FROM dbo.[Order] WHERE EXISTS(SELECT o.OrderNumber FROM @orders AS o WHERE LinkedQuoteNumber=o.OrderNumber) AND SOnumber <> @SoNumber

	INSERT @orders ( OrderNumber )
	SELECT LinkedQuoteNumber FROM dbo.[Order] WHERE EXISTS(SELECT o.OrderNumber FROM @orders AS o WHERE SOnumber=o.OrderNumber) 
	AND LinkedQuoteNumber <> @SoNumber
	AND NOT EXISTS (SELECT * FROM @orders AS o2 WHERE LinkedQuoteNumber=o2.OrderNumber)

	INSERT @orders ( OrderNumber )
	SELECT SOnumber FROM dbo.[Order] WHERE EXISTS(SELECT o.OrderNumber FROM @orders AS o WHERE LinkedQuoteNumber=o.OrderNumber) 
	AND SOnumber <> @SoNumber
	AND NOT EXISTS (SELECT * FROM @orders AS o2 WHERE SOnumber=o2.OrderNumber)

	INSERT @orders ( OrderNumber )
	SELECT SOnumber FROM dbo.[Order] WHERE EXISTS(SELECT o.OrderNumber FROM @orders AS o WHERE LinkedQuoteNumber=o.OrderNumber) 
	AND SOnumber <> @SoNumber
	AND NOT EXISTS (SELECT * FROM @orders AS o2 WHERE SOnumber=o2.OrderNumber)

	RETURN 
END 
GO
/****** Object:  UserDefinedFunction [dbo].[RemoveNonAlphaCharacters]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[RemoveNonAlphaCharacters] ( @Temp VARCHAR(MAX) )
RETURNS VARCHAR(MAX)
AS
BEGIN

    DECLARE @KeepValues AS VARCHAR(MAX)
    SET @KeepValues = '%[^a-z0-9]%'
    WHILE PATINDEX(@KeepValues, @Temp) > 0
        SET @Temp = STUFF(@Temp, PATINDEX(@KeepValues, @Temp), 1, '')

    RETURN @Temp
END
GO
/****** Object:  UserDefinedFunction [dbo].[RemoveNonNumericChar]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create function [dbo].[RemoveNonNumericChar](@str varchar(500))  
returns varchar(500)  
begin  
declare @startingIndex int  
set @startingIndex=0  
while 1=1  
begin  
    set @startingIndex= patindex('%[^0-9]%',@str)  
    if @startingIndex <> 0  
    begin  
        set @str = replace(@str,substring(@str,@startingIndex,1),'')  
    end  
    else    break;   
end  
return @str  
end
GO
/****** Object:  UserDefinedFunction [dbo].[ReplaceNonNumericChars]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[ReplaceNonNumericChars] (@string VARCHAR(5000))
RETURNS VARCHAR(1000)
AS 
    BEGIN
        SET @string = REPLACE(@string, ',', '.')
        SET @string = (SELECT   SUBSTRING(@string, v.number, 1)
                       FROM     master..spt_values v
                       WHERE    v.type = 'P'
                                AND v.number BETWEEN 1 AND LEN(@string)
                                AND (SUBSTRING(@string, v.number, 1) LIKE '[0-9]'
                                     OR SUBSTRING(@string, v.number, 1) LIKE '[.]')
                       ORDER BY v.number
                      FOR
                       XML PATH('')
                      )
        RETURN @string
    END
GO
/****** Object:  UserDefinedFunction [dbo].[SearchTransportSummary]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		David Samet
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[SearchTransportSummary]
(	
	@page INT= 1 ,
	@pageSize INT= 10,
	@department IDList READONLY,
	@status IDList READONLY,
	@inBound BIT = NULL,
	@searchType INT = NULL,
	@searchTerm VARCHAR(50) = NULL,
	@fromDate DATETIME = NULL,
    @toDate DATETIME =NULL
)
RETURNs @TransportSummary TABLE
(
TransportSummaryID int ,
TransportId int ,
TransportStatusId int ,
TransportStatusName VARCHAR(50) ,
TransportSourceLocationId int ,
TransportSourceLocation VARCHAR(50) ,
TransportDestinationLocationId int ,
TransportDestinationLocation VARCHAR(50) ,
TransportWagonId int ,
TransportWagonLabel VARCHAR(50) ,
CreatedOn DATETIME,
CreatedUser VARCHAR(150),
AssignedUser VARCHAR(150),
AssignedUserId INT,
AssignedOn DATETIME,
LastUpdated DATETIME,
Urgent BIT,
NumberOfItems INT 
 )
AS BEGIN

;WITH transports AS (
SELECT cast (ROW_NUMBER() OVER(ORDER BY ts.Sort, t.CreatedOn , t.TransportId) AS INT ) AS TransportSummaryID,t.TransportId, t.TransportStatusId, ts.TransportStatusName, 
																	 t.TransportSourceLocationId,tl.TransportLocationName TransportSourceLocation ,
																	 t.TransportDestinationLocationId,tl2.TransportLocationName TransportDestinationLocation, 
																	 t.TransportWagonId, tw.TransportWagonLabel, t.CreatedOn, anu2.FirstName + ' ' + anu2.LastName CreatedUser ,
																	 anu.FirstName + ' ' + anu.LastName AssignedUser, tu.TransportUserId AssignedUserId , t.AssignedOn, t.LastUpdated, t.Urgent FROM dbo.Transport AS t
																	 JOIN dbo.TransportStatus AS ts ON ts.TransportStatusID = t.TransportStatusId
																	 JOIN dbo.TransportLocation AS tl ON tl.TransportLocationID = t.TransportSourceLocationId
																	 JOIN dbo.TransportLocation AS tl2 ON tl2.TransportLocationID = t.TransportDestinationLocationId
																	 JOIN dbo.TransportWagon AS tw ON tw.TransportWagonId = t.TransportWagonId
																	 JOIN dbo.AspNetUsers AS anu2 ON anu2.Id = t.CreatedBy
																	 LEFT JOIN dbo.TransportUser AS tu ON tu.TransportUserId = t.AssignedTransportUserId
																	 LEFT JOIN dbo.AspNetUsers AS anu ON tu.UserId = anu.Id																 

WHERE ISNULL(t.Deleted,0) = 0 AND  (NOT EXISTS (SELECT 1 FROM @department AS d) OR ((@inBound = 0 AND t.TransportSourceLocationId IN (SELECT d2.ID FROM @department AS d2)) 
OR (@inBound = 1 AND t.TransportDestinationLocationId IN (SELECT d3.ID FROM @department AS d3)) 
OR (@inBound IS NULL AND (t.TransportSourceLocationId IN(SELECT d4.ID FROM @department AS d4) OR t.TransportDestinationLocationId IN (SELECT d5.ID FROM @department AS d5))))) 
AND ( NOT EXISTS (SELECT s.ID FROM @status AS s) OR  t.TransportStatusId IN (SELECT s.ID FROM @status AS s))
AND(ISNULL(@searchType,0) NOT IN(2,3,4) OR EXISTS (SELECT * FROM dbo.TransportDetail AS td WHERE td.TransportId=t.TransportId AND td.Detail LIKE ('%'+ @searchTerm+'%')) )
AND(ISNULL(@searchType,0) <> 5 OR CAST( t.TransportId AS VARCHAR(50))  =  @searchTerm ) 
AND (ISNULL(@searchType,0) <> 1 OR  EXISTS(SELECT detail.ItemCode FROM dbo.TransportDetail AS tdl                                     
                                    OUTER APPLY (SELECT * FROM dbo.GetDetailInfoFromItemidentifier(tdl.Detail) AS gdifi WHERE tdl.IsInventoryItem = 1) detail WHERE detail.ItemCode = @searchTerm))
AND (( @fromDate IS NULL OR @toDate IS NULL) OR (t.CreatedOn BETWEEN @fromDate AND  @toDate + 1 )) )

, filteredTransports AS (
SELECT * FROM transports  WHERE transports.TransportSummaryID > ((@page -1) * @pageSize) AND transports.TransportSummaryID <= ( (@page -1) * @pageSize ) + @pageSize

)
INSERT INTO @TransportSummary ( TransportSummaryID, TransportId, TransportStatusId, TransportStatusName,
                                 TransportSourceLocationId, TransportSourceLocation, TransportDestinationLocationId,
                                 TransportDestinationLocation, TransportWagonId, TransportWagonLabel, CreatedOn,
                                 CreatedUser, AssignedUser, AssignedUserId, AssignedOn, LastUpdated, Urgent, NumberOfItems )
SELECT ft.TransportSummaryID, ft.TransportId, ft.TransportStatusId, ft.TransportStatusName,
       ft.TransportSourceLocationId, ft.TransportSourceLocation, ft.TransportDestinationLocationId,
       ft.TransportDestinationLocation, ft.TransportWagonId, ft.TransportWagonLabel, ft.CreatedOn, ft.CreatedUser,
       ft.AssignedUser, ft.AssignedUserId, ft.AssignedOn, ft.LastUpdated, ft.Urgent, COALESCE(td.NumberOfItems, 0) FROM filteredTransports ft
	   OUTER APPLY (SELECT COUNT(*) AS NumberOfItems FROM dbo.TransportDetail AS td WHERE td.TransportId = ft.TransportId AND td.Deleted = 0) td

	   RETURN

END 




GO
/****** Object:  UserDefinedFunction [dbo].[Settings]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

--	select * from dbo.Settings(null, null); -- all rows
--	select * from dbo.Settings(1, 0); -- errors
--	select * from dbo.Settings(null, 0); -- caution

CREATE FUNCTION [dbo].[Settings] 
(
	@IsRequiredMatch bit,
	@IsMatched bit
)
returns @s TABLE 
(
SettingLevel varchar(50) not null,
SettingName varchar(50) not null,
PropertyValue varchar(300)  null,
ExpectedValue varchar(300)  null,
IsRequiredMatch bit not null,
IsMatched bit not null
)
AS
BEGIN

DECLARE @ServerConnectionDefaults int;
SET @ServerConnectionDefaults = (select cast(value_in_use as int) from sys.configurations where name = 'user options');

--insert into @s select 'UserSessionSetting', 'DISABLE_DEF_CNST_CHK', cast((@@options & 1) as varchar(300)), '1', 1, 0; --deprecated
insert into @s select 'ServerConnectionDefaults', 'IMPLICIT_TRANSACTIONS', cast((@ServerConnectionDefaults & 2) as varchar(300)), '0', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'CURSOR_CLOSE_ON_COMMIT', cast((@ServerConnectionDefaults & 4) as varchar(300)), '0', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'ANSI_WARNINGS', cast((@ServerConnectionDefaults & 8) as varchar(300)), '8', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'ANSI_PADDING', cast((@ServerConnectionDefaults & 16) as varchar(300)), '16', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'ANSI_NULLS', cast((@ServerConnectionDefaults & 32) as varchar(300)), '32', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'ARITHABORT', cast((@ServerConnectionDefaults & 64) as varchar(300)), '64', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'ARITHIGNORE', cast((@ServerConnectionDefaults & 128) as varchar(300)), '0', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'QUOTED_IDENTIFIER', cast((@ServerConnectionDefaults & 256) as varchar(300)), '256', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'NOCOUNT', cast((@ServerConnectionDefaults & 512) as varchar(300)), '0', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'ANSI_NULL_DFLT_ON', cast((@ServerConnectionDefaults & 1024) as varchar(300)), '1024', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'ANSI_NULL_DFLT_OFF', cast((@ServerConnectionDefaults & 2048) as varchar(300)), '0', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'CONCAT_NULL_YIELDS_NULL', cast((@ServerConnectionDefaults & 4096) as varchar(300)), '4096', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'NUMERIC_ROUNDABORT', cast((@ServerConnectionDefaults & 8192) as varchar(300)), '0', 1, 0;
insert into @s select 'ServerConnectionDefaults', 'XACT_ABORT', cast((@ServerConnectionDefaults & 16384) as varchar(300)), '0', 1, 0;


insert into @s select 'ServerSetting', 'DateFirst', @@DATEFIRST, '7', 1, 0;
insert into @s select 'ServerSetting', 'DefaultLangID', @@DEFAULT_LANGID, '0', 1, 0;
insert into @s select 'ServerSetting', 'DefSortOrderID', @@DEF_SORTORDER_ID, '52', 1, 0;
insert into @s select 'ServerSetting', 'LangID', @@LANGID, '0', 1, 0;
insert into @s select 'ServerSetting', 'Language', @@LANGUAGE, 'us_english', 1, 0;
insert into @s select 'ServerSetting', 'LockTimeOut', @@LOCK_TIMEOUT, '-1', 1, 0;
insert into @s select 'ServerSetting', 'MaxConnections', @@MAX_CONNECTIONS, '32767', 1, 0;
insert into @s select 'ServerSetting', 'MaxPrecision', @@MAX_PRECISION, '38', 1, 0;
insert into @s select 'ServerSetting', 'MicrosoftVersion', @@MICROSOFTVERSION, '171052960', 1, 0;
insert into @s select 'ServerSetting', 'NestLevel', @@NESTLEVEL, '1', 1, 0; -- inside fn
--insert into @s select 'ServerSetting', 'Options', @@OPTIONS, '5497', 1, 0;
insert into @s select 'ServerSetting', 'RemServer', isnull(@@REMSERVER,''), '', 1, 0;
insert into @s select 'ServerSetting', 'ServerName', @@SERVERNAME, 'TALADAW\SS2008R2', 0, 0;
insert into @s select 'ServerSetting', 'ServiceName', @@SERVICENAME, 'SS2008R2', 1, 0;
insert into @s select 'ServerSetting', 'TextSizes', @@TEXTSIZE, '2147483647', 1, 0;
insert into @s select 'ServerSetting', 'TimeTicks', @@TIMETICKS, '31250', 1, 0;
insert into @s select 'ServerSetting', 'Version', @@VERSION, 'Microsoft SQL Server 2008 R2 (SP2) - 10.50.4000.0 (X64) 
	Jun 28 2012 08:36:30 
	Copyright (c) Microsoft Corporation
	Standard Edition (64-bit) on Windows NT 6.1 <X64> (Build 7601: Service Pack 1)
', 0, 0;

insert into @s select 'ServerProperty', 'Collation', cast(SERVERPROPERTY('Collation') as varchar(300)), 'SQL_Latin1_General_CP1_CI_AS', 1, 0;
insert into @s select 'ServerProperty', 'ComputerNamePhysicalNetBIOS', cast(SERVERPROPERTY('ComputerNamePhysicalNetBIOS') as varchar(300)), 'TALADAW', 0, 0;
insert into @s select 'ServerProperty', 'Edition', cast(SERVERPROPERTY('Edition') as varchar(300)), 'Standard Edition (64-bit)', 0, 0;
insert into @s select 'ServerProperty', 'InstanceName', cast(isnull(SERVERPROPERTY('InstanceName'),'') as varchar(300)), 'SS2008R2', 0, 0;
insert into @s select 'ServerProperty', 'IsFullTextInstalled', cast(SERVERPROPERTY('IsFullTextInstalled') as varchar(300)), '0', 1, 0;
insert into @s select 'ServerProperty', 'IsIntegratedSecurityOnly', cast(SERVERPROPERTY('IsIntegratedSecurityOnly') as varchar(300)), '0', 1, 0;
insert into @s select 'ServerProperty', 'IsSingleUser', cast(SERVERPROPERTY('IsSingleUser') as varchar(300)), '0', 1, 0;
insert into @s select 'ServerProperty', 'LCID', cast(SERVERPROPERTY('LCID') as varchar(300)), '1033', 1, 0;
insert into @s select 'ServerProperty', 'MachineName', cast(SERVERPROPERTY('MachineName') as varchar(300)), 'TALADAW', 0, 0;
insert into @s select 'ServerProperty', 'ProductVersion', cast(SERVERPROPERTY('ProductVersion') as varchar(300)), '10.50.4000.0', 1, 0;
insert into @s select 'ServerProperty', 'ProductLevel', cast(SERVERPROPERTY('ProductLevel') as varchar(300)), 'SP2', 1, 0;
insert into @s select 'ServerProperty', 'ServerName', cast(SERVERPROPERTY('ServerName') as varchar(300)), 'TALADAW\SS2008R2', 0, 0;
insert into @s select 'ServerProperty', 'SqlCharSet', cast(SERVERPROPERTY('SqlCharSet') as varchar(300)), '1', 1, 0;
insert into @s select 'ServerProperty', 'SqlCharSetName', cast(SERVERPROPERTY('SqlCharSetName') as varchar(300)), 'iso_1', 1, 0;
insert into @s select 'ServerProperty', 'SqlSortOrder', cast(SERVERPROPERTY('SqlSortOrder') as varchar(300)), '52', 1, 0;
insert into @s select 'ServerProperty', 'SqlSortOrderName', cast(SERVERPROPERTY('SqlSortOrderName') as varchar(300)), 'nocase_iso', 1, 0;

insert into @s select 'DatabaseProperty', 'Version', cast(DATABASEPROPERTYEX(db_name(), 'Version') as varchar(300)), '661', 1, 0;
insert into @s select 'DatabaseProperty', 'IsAnsiNullDefault', cast(DATABASEPROPERTYEX(db_name(), 'IsAnsiNullDefault') as varchar(300)), '1', 1, 0;
insert into @s select 'DatabaseProperty', 'IsAnsiNullsEnabled', cast(DATABASEPROPERTYEX(db_name(), 'IsAnsiNullsEnabled') as varchar(300)), '1', 1, 0;
insert into @s select 'DatabaseProperty', 'IsAnsiWarningsEnabled', cast(DATABASEPROPERTYEX(db_name(), 'IsAnsiWarningsEnabled') as varchar(300)), '1', 1, 0;
insert into @s select 'DatabaseProperty', 'IsLocalCursorsDefault', cast(DATABASEPROPERTYEX(db_name(), 'IsLocalCursorsDefault') as varchar(300)), '1', 1, 0;
insert into @s select 'DatabaseProperty', 'IsFulltextEnabled', cast(DATABASEPROPERTYEX(db_name(), 'IsFulltextEnabled') as varchar(300)), '1', 1, 0;
insert into @s select 'DatabaseProperty', 'IsQuotedIdentifiersEnabled', cast(DATABASEPROPERTYEX(db_name(), 'IsQuotedIdentifiersEnabled') as varchar(300)), '1', 1, 0;
insert into @s select 'DatabaseProperty', 'IsAutoCreateStatistics', cast(DATABASEPROPERTYEX(db_name(), 'IsAutoCreateStatistics') as varchar(300)), '1', 1, 0;
insert into @s select 'DatabaseProperty', 'IsAutoUpdateStatistics', cast(DATABASEPROPERTYEX(db_name(), 'IsAutoUpdateStatistics') as varchar(300)), '1', 1, 0;
insert into @s select 'DatabaseProperty', 'IsNullConcat', cast(DATABASEPROPERTYEX(db_name(), 'IsNullConcat') as varchar(300)), '1', 1, 0;
insert into @s select 'DatabaseProperty', 'IsTruncLog', cast(DATABASEPROPERTYEX(db_name(), 'IsTruncLog') as varchar(300)), null, 1, 0;

insert into @s select 'DatabaseProperty', 'IsDboOnly', cast(DATABASEPROPERTYEX(db_name(), 'IsDboOnly') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsOffline', cast(DATABASEPROPERTYEX(db_name(), 'IsOffline') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsDetached', cast(DATABASEPROPERTYEX(db_name(), 'IsDetached') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsEmergencyMode', cast(DATABASEPROPERTYEX(db_name(), 'IsEmergencyMode') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsInLoad', cast(DATABASEPROPERTYEX(db_name(), 'IsInLoad') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsInRecovery', cast(DATABASEPROPERTYEX(db_name(), 'IsInRecovery') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsInStandBy', cast(DATABASEPROPERTYEX(db_name(), 'IsInStandBy') as varchar(300)), '0', 1, 0;
insert into @s select 'DatabaseProperty', 'IsNotRecovered', cast(DATABASEPROPERTYEX(db_name(), 'IsNotRecovered') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsShutDown', cast(DATABASEPROPERTYEX(db_name(), 'IsShutDown') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsSuspect', cast(DATABASEPROPERTYEX(db_name(), 'IsSuspect') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsReadOnly', cast(DATABASEPROPERTYEX(db_name(), 'IsReadOnly') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsSingleUser', cast(DATABASEPROPERTYEX(db_name(), 'IsSingleUser') as varchar(300)), null, 1, 0;

insert into @s select 'DatabaseProperty', 'IsParameterizationForced', cast(DATABASEPROPERTYEX(db_name(), 'IsParameterizationForced') as varchar(300)), '0', 1, 0;
insert into @s select 'DatabaseProperty', 'IsRecursiveTriggersEnabled', cast(DATABASEPROPERTYEX(db_name(), 'IsRecursiveTriggersEnabled') as varchar(300)), '0', 1, 0;
insert into @s select 'DatabaseProperty', 'IsAutoClose', cast(DATABASEPROPERTYEX(db_name(), 'IsAutoClose') as varchar(300)), '0', 1, 0;
insert into @s select 'DatabaseProperty', 'IsAutoShrink', cast(DATABASEPROPERTYEX(db_name(), 'IsAutoShrink') as varchar(300)), '0', 1, 0;
insert into @s select 'DatabaseProperty', 'IsBulkCopy', cast(DATABASEPROPERTYEX(db_name(), 'IsBulkCopy') as varchar(300)), null, 1, 0;
insert into @s select 'DatabaseProperty', 'IsCloseCursorsOnCommitEnabled', cast(DATABASEPROPERTYEX(db_name(), 'IsCloseCursorsOnCommitEnabled') as varchar(300)), '0', 1, 0;


-- Database settings
insert into @s select 'sys.databases', 'collation_name', collation_name, 'SQL_Latin1_General_CP1_CI_AS', 1, 0 from sys.databases where name = DB_NAME();
insert into @s select 'sys.databases', 'compatibility_level', compatibility_level, '100', 1, 0 from sys.databases where name = DB_NAME();
insert into @s select 'sys.databases', 'recovery_model_desc', recovery_model_desc, 'SIMPLE', 0, 0 from sys.databases where name = DB_NAME();
insert into @s select 'sys.databases', 'is_trustworthy_on', is_trustworthy_on, '0', 1, 0 from sys.databases where name = DB_NAME();
insert into @s select 'sys.databases', 'is_broker_enabled', is_broker_enabled, '0', 1, 0 from sys.databases where name = DB_NAME();


--insert into @s select 'UserSessionSetting', 'DISABLE_DEF_CNST_CHK', cast((@@options & 1) as varchar(300)), '1', 1, 0; --deprecated
insert into @s select 'UserSessionSetting', 'IMPLICIT_TRANSACTIONS', cast((@@options & 2) as varchar(300)), '0', 1, 0;
insert into @s select 'UserSessionSetting', 'CURSOR_CLOSE_ON_COMMIT', cast((@@options & 4) as varchar(300)), '0', 1, 0;
insert into @s select 'UserSessionSetting', 'ANSI_WARNINGS', cast((@@options & 8) as varchar(300)), '8', 1, 0;
insert into @s select 'UserSessionSetting', 'ANSI_PADDING', cast((@@options & 16) as varchar(300)), '16', 1, 0;
insert into @s select 'UserSessionSetting', 'ANSI_NULLS', cast((@@options & 32) as varchar(300)), '32', 1, 0;
insert into @s select 'UserSessionSetting', 'ARITHABORT', cast((@@options & 64) as varchar(300)), '64', 1, 0;
insert into @s select 'UserSessionSetting', 'ARITHIGNORE', cast((@@options & 128) as varchar(300)), '0', 1, 0;
insert into @s select 'UserSessionSetting', 'QUOTED_IDENTIFIER', cast((@@options & 256) as varchar(300)), '256', 1, 0;
insert into @s select 'UserSessionSetting', 'NOCOUNT', cast((@@options & 512) as varchar(300)), '0', 1, 0;
insert into @s select 'UserSessionSetting', 'ANSI_NULL_DFLT_ON', cast((@@options & 1024) as varchar(300)), '1024', 1, 0;
insert into @s select 'UserSessionSetting', 'ANSI_NULL_DFLT_OFF', cast((@@options & 2048) as varchar(300)), '0', 1, 0;
insert into @s select 'UserSessionSetting', 'CONCAT_NULL_YIELDS_NULL', cast((@@options & 4096) as varchar(300)), '4096', 1, 0;
insert into @s select 'UserSessionSetting', 'NUMERIC_ROUNDABORT', cast((@@options & 8192) as varchar(300)), '0', 1, 0;
insert into @s select 'UserSessionSetting', 'XACT_ABORT', cast((@@options & 16384) as varchar(300)), '0', 1, 0;

update @s 
set IsMatched = 
	CASE
	when PropertyValue = ExpectedValue then 1
	when PropertyValue IS NULL AND ExpectedValue IS NULL then 1
	else 0
	end
;

delete from @s where IsRequiredMatch <> @IsRequiredMatch;
delete from @s where IsMatched <> @IsMatched;

RETURN
END
GO
/****** Object:  UserDefinedFunction [dbo].[SideSkinsNeeded]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <9/9/2019>
-- Description:	<Returns on which side an old construction item needs aside skin. r for right, l for left, b for both, none for no skin>
-- =============================================
CREATE FUNCTION [dbo].[SideSkinsNeeded]
(
	@tranEntry int
)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @returnValue VARCHAR(50) = 'none'
	SELECT @returnValue = CASE te.Finish WHEN 'Both' THEN 'b' WHEN 'Right' THEN 'r' WHEN 'Left' THEN 'l' ELSE 'none' END FROM dbo.TranEntry AS te
	WHERE te.ID = @tranEntry
	AND dbo.IsInQ13Rules(te.ID) = 1
	--AND EXISTS(
	--	SELECT * FROM dbo.tb_ItemList AS til
	--	JOIN dbo.ItemsQ13Process iqp ON iqp.DoorStyleId = til.DoorStyleID
	--	WHERE til.ItemCode = te.ItemNumber AND iqp.GetsSideSkin = 1)
	AND EXISTS(
		SELECT * FROM picking.ProductionItem AS pi
		JOIN Picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi.ProductionItemId AND pid.Deleted = 0
		WHERE pi.OrderItemId = te.ID AND pid.PickingTypeId = 5)
	RETURN @returnValue	
END



GO
/****** Object:  UserDefinedFunction [dbo].[SortSeq]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[SortSeq]
(
	@IsActive BIT,
	@ItemType INT,
	@minAddTime DATETIME,
	@addTime DATETIME,
	@SortNumber INT = NULL
)
RETURNS DECIMAL(9, 2)
AS
BEGIN
	DECLARE @retSortNumber DECIMAL(9, 2) = NULL

	IF @IsActive = 0
	BEGIN
		SELECT @retSortNumber = defaultvalue
		FROM [GPSVariables]
		WHERE variablecode = 'INACTSORTNUM'

		RETURN @retSortNumber
	END

	IF @SortNumber IS NOT NULL
	BEGIN
		SELECT @retSortNumber = @SortNumber
	END

	IF @retSortNumber IS NULL
	BEGIN
		SELECT @retSortNumber = SortNumber
		FROM [ItemType]
		WHERE typeid = @ItemType
	END

	IF @retSortNumber IS NULL
	BEGIN
		SELECT @retSortNumber = defaultvalue
		FROM [GPSVariables]
		WHERE variablecode = 'DFLTSORTNUM'
	END

	IF Datediff(s, @minAddTime, @addTime) > 30
	BEGIN
		IF @retSortNumber <= (SELECT defaultvalue FROM [GPSVariables] WHERE variablecode = 'REVSORTRANGE')
		BEGIN
			SELECT @retSortNumber = CONVERT(DECIMAL(9, 2), (SELECT defaultvalue FROM [GPSVariables] WHERE variablecode = 'REVSORTNUM') + RIGHT(Replicate('0', 3) + CONVERT(VARCHAR, @retSortNumber), 3))
		END
	END

 RETURN @retSortNumber

END
GO
/****** Object:  UserDefinedFunction [dbo].[StatusColor]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[StatusColor]
(
	@IsActive BIT,
	@ItemType INT,
	@minAddTime DATETIME,
	@addTime DATETIME,
	@DeptDefaultColor varchar(25) = NULL
)
RETURNS VARCHAR(25)
AS
BEGIN
	DECLARE @retStatusColor Varchar(25) = NULL

	IF @IsActive = 0
	BEGIN
		SELECT @retStatusColor = defaultvalue
		FROM [GPSVariables]
		WHERE variablecode = 'INACTCOLOR'

		RETURN @retStatusColor
	END

	IF @DeptDefaultColor IS NOT NULL
	BEGIN
		SELECT @retStatusColor = @DeptDefaultColor
	END

	IF @retStatusColor IS NULL
	BEGIN
		SELECT @retStatusColor = colorhex
		FROM [ItemType]
		WHERE typeid = @ItemType
	END

	IF @retStatusColor IS NULL
	BEGIN
		SELECT @retStatusColor = defaultvalue
		FROM [GPSVariables]
		WHERE variablecode = 'DFLTCOLOR'
	END

	--IF Datediff(s, @minAddTime, @addTime) > 30
	--BEGIN
	--	  SELECT @retStatusColor = (SELECT defaultvalue FROM [GPSVariables] WHERE variablecode = 'REVCOLOR')
	--END

 RETURN @retStatusColor

END
GO
-- /****** Object:  UserDefinedFunction [dbo].[StockQtyUsed]    Script Date: 6/17/2021 11:37:56 AM ******/
-- SET ANSI_NULLS ON
-- GO
-- SET QUOTED_IDENTIFIER ON
-- GO
-- /****** Script for SelectTopNRows command from SSMS  ******/
-- 
-- 
-- create FUNCTION [dbo].[StockQtyUsed] (@FROMDATE DATETIME, @TODATE DATETIME, @listid varchar(500))
-- RETURNS int
-- AS
--     BEGIN 	
-- 	DECLARE @QTY INT;
--     SELECT @QTY = 
-- 	SUM(qp.Quantity) 
-- 						
-- 						FROM 
-- 						[FABUSQL02].[eFabuwood].[dbo].[QuoteProducts] qp WITH ( NOLOCK )
-- 						JOIN fabusql02.[eFabuwood].[dbo].[StockItems] si WITH ( NOLOCK )
-- 							ON qp.StockItemID = si.StockItemID 
-- 						JOIN FABUSQL02.eFabuwood.dbo.QuoteFulfillmentDetails fd WITH ( NOLOCK )
-- 				ON qp.QuoteID = fd.QuoteID
-- 					WHERE  ShowToCustomer = 0 
-- 					AND fd.InvoiceDate >= isnull(@FROMDATE ,fd.invoicedate)
-- 						  AND  fd.InvoiceDate <= isnull(@TODATE,fd.invoicedate)
-- 						  AND QBID = @listid
-- 						  GROUP BY SI.QBID
-- 
-- 
-- 	RETURN @QTY
--     END 
-- 
-- 
-- 
-- 				--LEFT JOIN 	
-- 				--		(SELECT si.QBID,SUM(qp.Quantity) AS qty
-- 						
-- 				--		FROM 
-- 				--		[FABUSQL02].[eFabuwood].[dbo].[QuoteProducts] qp WITH ( NOLOCK )
-- 				--		JOIN fabusql02.[eFabuwood].[dbo].[StockItems] si WITH ( NOLOCK )
-- 				--			ON qp.StockItemID = si.StockItemID 
-- 				--		JOIN FABUSQL02.eFabuwood.dbo.QuoteFulfillmentDetails fd WITH ( NOLOCK )
-- 				--ON qp.QuoteID = fd.QuoteID
-- 				--	WHERE  ShowToCustomer = 0 
-- 				--	--filter here
-- 				--	AND 
-- 				--		  fd.InvoiceDate >= isnull('6/2/2015' ,fd.invoicedate)
-- 				--		  AND  fd.InvoiceDate <= isnull(null,fd.invoicedate)
-- 				--		  -- isnull(@fromdate,fd.InvoiceDate) >= @FromDate AND
-- 				--		  --isnull(@todate,fd.InvoiceDate) <= @ToDate) 
-- 
-- 				--	GROUP BY si.QBID) AS ai 
-- 
-- 				--				ON ai.QBID = iit.ListID 
-- GO
/****** Object:  UserDefinedFunction [dbo].[StringSplit]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[StringSplit]
(
	@string VARCHAR(MAX),
	@delimiter VARCHAR(5)
)
RETURNS @values TABLE (value VARCHAR(50))
AS 
BEGIN

	IF @delimiter = ''
	BEGIN
	    RETURN
	END

	WHILE LEN(@string) > 0
	BEGIN
		DECLARE @record VARCHAR(50)
		
		IF CHARINDEX(@delimiter, @string) > 0 
		BEGIN
			SET @record = LEFT(@string, CHARINDEX(@delimiter, @string))
		END
		ELSE
		BEGIN
		    SET @record = @string
		END
		IF LEN(@record) < 1 
		BEGIN
			SET @string = RIGHT(@string, LEN(@string) - 1) 
		    CONTINUE
		END
        SET @string = RIGHT(@string, LEN(@string) - LEN(@record))

		 INSERT INTO @values
	    (
	        value
	    )
	    VALUES
		(
			TRIM(REPLACE(@record, @delimiter, ''))
		)
	END

   RETURN 
END
GO
/****** Object:  UserDefinedFunction [dbo].[udf_GetItemType]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[udf_GetItemType] (@ItemCode NVARCHAR(50))
RETURNS INT
AS
  BEGIN
      /* Function body */
      DECLARE @r_itemtype INT

      --change
      IF( Charindex('*', @ItemCode) > 0 )
        SET @itemcode = Substring(@ItemCode, 1, Charindex('*', @ItemCode) - 1)

      SET @r_itemtype = (SELECT [ItemTypeCode]
                         FROM   [dbo].[ItemList]
                         WHERE  ItemCode = @itemcode)

      IF ( @r_itemtype IS NULL )
        SET @r_itemtype = (SELECT [DefaultValue]
                           FROM   [dbo].[GPSVariables]
                           WHERE  [VariableCode] = 'DFLTITEMTYPE')

      --SET @r_itemtype =( CASE
      --                     WHEN EXISTS(SELECT itemnumber
      --                                 FROM   itemservice
      --                                 WHERE  itemnumber = @itemcode) THEN 4
      --                     WHEN EXISTS(SELECT itemcode
      --                                 FROM   accessories
      --                                 WHERE  itemcode = @itemcode) THEN 3
      --                     WHEN EXISTS(SELECT item
      --                                 FROM   itemtallcabinet
      --                                 WHERE  item = @ItemCode) THEN 2
      --                     WHEN EXISTS(SELECT itemcode
      --                                 FROM   cabinetitems
      --                                 WHERE  itemcode = @itemcode) THEN 1
      --                     ELSE 5
      --                   END )
      RETURN @r_itemtype
  END 
GO
/****** Object:  UserDefinedFunction [dbo].[udf_GetStringBetween2Chars]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[udf_GetStringBetween2Chars] (@String VARCHAR(50) , @SpecialChar CHAR(1))
RETURNS VARCHAR(50)
AS
BEGIN
   /*Declaring Local Variables*/
   DECLARE @FirstIndexOfChar INT,
         @LastIndexOfChar INT,
         @LengthOfStringBetweenChars INT 


   SET @FirstIndexOfChar   = CHARINDEX(@SpecialChar,@String,0) 
   SET @LastIndexOfChar   = CHARINDEX(@SpecialChar,@String,@FirstIndexOfChar+1)
   SET @LengthOfStringBetweenChars = @LastIndexOfChar - @FirstIndexOfChar -1

   SET @String = SUBSTRING(@String,@FirstIndexOfChar+1,@LengthOfStringBetweenChars)

   RETURN @String

END
GO
/****** Object:  UserDefinedFunction [dbo].[Udf_ItemType]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[Udf_ItemType] (@ItemCode NVARCHAR(50))
RETURNS INT
AS
  BEGIN
      /* Function body */
      DECLARE @r_itemtype INT

      --change
      IF( Charindex('*', @ItemCode) > 0 )
        SET @itemcode = Substring(@ItemCode, 1, Charindex('*', @ItemCode) - 1)

      SET @r_itemtype = (SELECT [ItemTypeCode] FROM [dbo].[ItemList] (NOLOCK)
	                     WHERE ItemCode = @itemcode)

      --SET @r_itemtype =( CASE
      --                     WHEN EXISTS(SELECT itemnumber
      --                                 FROM   itemservice
      --                                 WHERE  itemnumber = @itemcode) THEN 4
      --                     WHEN EXISTS(SELECT itemcode
      --                                 FROM   accessories
      --                                 WHERE  itemcode = @itemcode) THEN 3
      --                     WHEN EXISTS(SELECT item
      --                                 FROM   itemtallcabinet
      --                                 WHERE  item = @ItemCode) THEN 2
      --                     WHEN EXISTS(SELECT itemcode
      --                                 FROM   cabinetitems
      --                                 WHERE  itemcode = @itemcode) THEN 1
      --                     ELSE 5
      --                   END )

      RETURN @r_itemtype
  END 
GO
/****** Object:  UserDefinedFunction [dbo].[ValidateTruckStopNumber]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Isaac Drezdner
-- Create date: 1/16/2018
-- Description:	Validate if stop# user entered is valid and available
-- =============================================
CREATE FUNCTION [dbo].[ValidateTruckStopNumber]
(
	-- Add the parameters for the function here
	 @stopNum INT  = NULL
)
RETURNS BIT
AS
BEGIN
	-- Declare the return variable here
	DECLARE @valid BIT = 0, @min INT = 1, @max INT = 20;

	-- Add the T-SQL statements to compute the return value here
	IF (@stopNum BETWEEN @min AND @max)
	BEGIN
		SET @valid = 1;
	END

	-- Return the result of the function
	RETURN @valid

END
GO
/****** Object:  UserDefinedFunction [dbo].[WHThresholdStockReplenish]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[WHThresholdStockReplenish] 
(
)

RETURNS @T TABLE
    (
	[From/to] VARCHAR(150)
	,FromWH VARCHAR(50)
	,ItemCode varchar(150)
	,FROMPO VARCHAR(100)
	,FromQty INT
	,Location  VARCHAR(100)
	,PalletID INT
	,ToWH VARCHAR(100)
	,WHThreshhold INT
	,QtyFromLessPO INT
	,ItemType VARCHAR(150)
    )
AS
BEGIN
DECLARE @BUILDINGS TABLE
(
qty int
,po VARCHAR(100)
,ItemCode varchar(150)
,Warehouse varchar(10)
)
DECLARE @DEFAULTWH TABLE
(
ItemCode VARCHAR(150)
,Warehouse VARCHAR(10) 
,WHThreshhold int
)
DECLARE @LESSPO TABLE
(
ItemCode VARCHAR(150)
,QtyFromLessPO INT
,WHThreshhold INT
,Warehouse VARCHAR(10)
)

INSERT INTO @BUILDINGS
SELECT SUM(ISNULL(ilu.Quantity,0))qty,
MIN(ilu.PoNumber)po
,ilu.ItemCode
,il.Warehouse 
FROM dbo.ItemLocationsUpdate AS ilu  
JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location AND il.IsActive =1 AND il.ExcludeFrmStock =0  AND il.Location NOT LIKE 'as[c,t]%'  
--JOIN dbo.tb_Warehouse AS tw ON tw.ID = il.Warehouse  
WHERE NOT EXISTS (SELECT 1 FROM dbo.InventoryLocationDefaultItemCode AS ildic   JOIN dbo.InventoryLocation il2 ON il2.ID = ildic.LocationID  WHERE ildic.ItemCode = ilu.ItemCode AND il2.Warehouse =il.Warehouse )  AND ilu.Quantity>0  GROUP BY ilu.ItemCode,il.Warehouse  HAVING SUM(ISNULL(ilu.Quantity,0))>0    

INSERT INTO @DEFAULTWH
SELECT DISTINCT ildic.ItemCode,il.Warehouse,til.WHThreshhold 
FROM dbo.InventoryLocationDefaultItemCode AS ildic  JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID AND il.IsActive =1  JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = ildic.ItemCode  

   INSERT INTO @LESSPO
   SELECT dw.ItemCode,
   SUM(CASE WHEN ISNULL(ilu.PoNumber,'0')<= po.po THEN ISNULL(ilu.Quantity,0) ELSE 0 END) QtyFromLessPO,
   dw.WHThreshhold
   ,dw.Warehouse
FROM dbo.ItemLocationsUpdate AS ilu  JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location AND il.IsActive =1 AND il.ExcludeFrmStock =0  AND il.Location NOT LIKE 'as[c,t]%'  RIGHT JOIN  @defaultWh AS dw ON dw.ItemCode = ilu.ItemCode AND dw.Warehouse = il.Warehouse  
OUTER APPLY (SELECT MIN(b.po) AS po FROM @buIldings AS b WHERE b.ItemCode = dw.ItemCode) po 
 --WHERE dw.ItemCode ='fc ply-1/4' 
  GROUP BY dw.ItemCode, dw.WHThreshhold,dw.Warehouse    
   HAVING SUM(CASE WHEN ISNULL(ilu.PoNumber,'0')<= po.po THEN ISNULL(ilu.Quantity,0) ELSE 0 END) <dw.WHThreshhold   
   
    INSERT INTO @T
           SELECT 'From '+ CONVERT(VARCHAR(25),tw.Description) +'  to '+CONVERT(VARCHAR(25),tw2.Description) AS [From/to],
		   tw.Description AS FromWH 
		   ,bul.ItemCode
		   ,bul.po AS FromPO
		   ,WHFrom.locQty AS FromQty
		   ,WHFrom.Location 
		   ,WHFrom.PalletID
		   ,tw2.Description AS ToWH
		   ,lp.WHThreshhold
		   ,lp.QtyFromLessPO
		   ,it.TypeName AS ItemType
	 FROM @lessPO AS lp  
	CROSS APPLY (SELECT TOP 1 b.ItemCode,MIN(b.po) po, SUM(b.qty) WHqty,b.Warehouse
	 FROM @buIldings AS b WHERE b.ItemCode = lp.ItemCode   
	 GROUP BY b.ItemCode,b.Warehouse ORDER BY po) bul  
	  OUTER APPLY (SELECT TOP 1 b2.ItemCode,b2.po,b2.warehouse,b2.qty FROM @buIldings AS b2 WHERE b2.ItemCode = bul.ItemCode AND b2.po = bul.po) bulding 
	  
	   OUTER APPLY (SELECT TOP 1 ilu.Location,ilu.PalletID,ilu.Quantity AS locQty FROM dbo.ItemLocationsUpdate AS ilu   JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location WHERE ilu.ItemCode = bul.ItemCode AND ilu.PoNumber = bul.po AND il.Warehouse =bul.Warehouse   AND il.ExcludeFrmStock =0 AND ilu.Quantity>0  AND il.Location NOT LIKE 'as[c,t]%'  ORDER BY ilu.PalletID) WHFrom  JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = lp.ItemCode  JOIN dbo.ItemType AS it ON it.TypeID =til.ItemTypeCode  JOIN dbo.tb_Warehouse AS tw ON tw.ID = bul.Warehouse  JOIN dbo.tb_Warehouse AS tw2 ON tw2.ID = lp.Warehouse   

    RETURN

END    
GO
/****** Object:  UserDefinedFunction [inventory].[AllPosOpen]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create FUNCTION [inventory].[AllPosOpen]
(
	@containerId int	
)
RETURNS bit
AS
BEGIN
	DECLARE @return bit;

	set @return = 1;

	return @return

END
GO
/****** Object:  UserDefinedFunction [inventory].[ComponentEta]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[ComponentEta]
(
	 @StockComponent inventory.StockComponent READONLY
)
RETURNS 
@EtaComponent TABLE 
(
	ETA DATE NULL,
	Qty INT NOT NULL DEFAULT(0),
	AcumaticaID INT NOT NULL,
	IsContainer BIT NOT NULL DEFAULT(0),
	IsMSOrder BIT NOT NULL DEFAULT(0)
)
AS
BEGIN
	DECLARE @EtaContainerComponent TABLE (ETA DATE NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @EtaMSComponent TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @EtaMSComponentDetail TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL, ProductionNumber VARCHAR(50) NOT NULL, ItemCode VARCHAR(50) NOT NULL )
	DECLARE @snAbnQty TABLE (ItemCode VARCHAR(50) NOT NULL, PoNumber VARCHAR(50) NOT NULL , Qty INT NOT NULL DEFAULT (0) )
	
	DECLARE @nextPickDate DATE = GETDATE() + 1
	SELECT @nextPickDate =MIN(apd.PickingDate) FROM picking.AvailablePickingDates AS apd WHERE apd.PickingDate > GETDATE()

	INSERT @EtaContainerComponent(ETA,Qty,AcumaticaID)
	SELECT  CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END ETA,SUM(cl.Qty + ISNULL(cl.ApprovedAmount, 0)) Qty,til.AcumaticaID
	FROM inventory.ContainerList AS cl
		JOIN inventory.Containers AS c ON c.ContainerID = cl.ContainerID
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = cl.ItemCode
	WHERE cl.Deleted = 0 AND c.Received = 0 AND c.AcumaticaID IS NOT NULL AND ISNULL(c.Arrived, 0) = 0
		  AND EXISTS(SELECT 1 FROM @StockComponent AS c2 WHERE c2.StockAcumaticaID = til.AcumaticaID AND c2.SortComponent > c2.Quantity )
	GROUP BY cl.ItemCode,CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END, til.AcumaticaID
	UNION ALL
	SELECT CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END ETA, SUM(cd.PoQty + ISNULL(cd.ApprovedAmount, 0) - cd.TotalReceived) QtyOnContainer, til.AcumaticaID
	FROM inventory.ContainerDetail AS cd
		JOIN inventory.Containers AS c ON c.Container = cd.Container
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = cd.ItemCode
	WHERE c.Arrived = 1 AND c.Received = 0 AND c.AcumaticaID IS NOT NULL
		  AND EXISTS(SELECT 1 FROM @StockComponent AS c2 WHERE c2.StockAcumaticaID = til.AcumaticaID AND c2.SortComponent > c2.Quantity)
	GROUP BY cd.ItemCode,CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END, til.AcumaticaID;
	
	DECLARE @EtaLocalPo TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @LocalPodetail TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL, Ponumber VARCHAR(50) NOT NULL, ItemCode VARCHAR(50) NOT NULL )

	INSERT @LocalPodetail(ETA,Qty,AcumaticaID,Ponumber,ItemCode)

	SELECT p.PromisedOn , pli.Quantity, til.AcumaticaID,p.PoNumber, til.ShortItemCode FROM inventory.Po AS p
	JOIN inventory.PoLineItems AS pli ON pli.PoID = p.ID AND p.Deleted=0 AND pli.Deleted=0 AND p.Closed=0 AND pli.ReceivedQuantity< pli.Quantity AND p.AcumaticaID IS NOT NULL
	JOIN dbo.tb_ItemList AS til ON til.AcumaticaName = pli.AcumaticaName AND til.AcumaticaID IS NOT NULL AND til.ItemTypeCode =7
	JOIN inventory.Vendor AS v ON v.VendorId = p.VendorID AND v.IsLocal=1
	WHERE EXISTS(SELECT 1 FROM @StockComponent AS c2 WHERE c2.StockAcumaticaID = til.AcumaticaID AND c2.SortComponent > c2.Quantity )

	INSERT @snAbnQty(ItemCode,PoNumber,Qty	)
	SELECT tis.ItemCode, tis.PONumber, COUNT(*) AS Qty FROM dbo.tb_ItemSeriel AS tis  
	WHERE EXISTS (SELECT * FROM @LocalPodetail AS lp WHERE lp.ItemCode=tis.ItemCode AND tis.PONumber=lp.Ponumber)
	GROUP BY tis.ItemCode,tis.PONumber
	UNION all
	SELECT abn.ItemCode, abn.PONumber, COUNT(*) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @LocalPodetail AS lp WHERE lp.ItemCode=abn.ItemCode AND abn.PONumber=lp.Ponumber)
	GROUP BY abn.ItemCode,abn.PONumber

	INSERT @EtaLocalPo(ETA,Qty,AcumaticaID)
	SELECT CASE WHEN lp.ETA < GETDATE() THEN @nextPickDate ELSE lp.ETA END AS ProductionEndDate,SUM(lp.Qty- CASE WHEN ISNULL(snAbn.Qty,0) > 0 THEN snAbn.Qty ELSE 0 END ) AS Qty,lp.AcumaticaID
	 FROM @LocalPodetail AS lp 
	OUTER APPLY (SELECT  SUM(saq.Qty) AS Qty FROM @snAbnQty AS saq WHERE saq.PONumber=lp.Ponumber AND saq.ItemCode=lp.ItemCode GROUP BY  saq.ItemCode, saq.PONumber) snAbn	
	GROUP BY CASE WHEN lp.ETA < GETDATE() THEN @nextPickDate ELSE lp.ETA END, lp.ItemCode, lp.AcumaticaID
	 HAVING  SUM( CASE WHEN lp.qty- ISNULL(snAbn.Qty,0) > 0 THEN lp.qty- ISNULL(snAbn.Qty,0)  ELSE 0 END ) > 0

	DELETE @snAbnQty


	INSERT @EtaMSComponentDetail(ETA,ItemCode,Qty,ProductionNumber,AcumaticaID)

	SELECT  po.ProductionEndDate , po.ItemCode, po.QtyToProduce AS qty, po.ProductionNumber, til.AcumaticaID
	FROM acumaticaManufacturing.ProductionOrders AS po
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = po.ItemCode
	WHERE po.ProductionOrderType='MS' AND po.ProductionStatus NOT IN('Closed','Canceled') AND po.DeleteFlag = 0
		AND EXISTS (SELECT * FROM @StockComponent AS c WHERE c.StockAcumaticaID=til.AcumaticaID AND c.SortComponent> c.Quantity)
	GROUP BY po.ProductionEndDate,po.ItemCode,po.QtyToProduce,po.ProductionNumber,til.AcumaticaID
	HAVING po.QtyToProduce> 0	

	INSERT @snAbnQty(ItemCode,PoNumber,Qty	)
	SELECT tis.ItemCode, tis.PONumber, COUNT(*) AS Qty FROM dbo.tb_ItemSeriel AS tis  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod WHERE mod.ItemCode=tis.ItemCode AND tis.PONumber=mod.ProductionNumber)
	GROUP BY tis.ItemCode,tis.PONumber
	UNION all
	SELECT abn.ItemCode, abn.PONumber, COUNT(*) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod WHERE mod.ItemCode=abn.ItemCode AND abn.PONumber=mod.ProductionNumber)
	GROUP BY abn.ItemCode,abn.PONumber
	UNION all	
	SELECT abn.ItemCode, abn.PONumber, COUNT(*) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod 
	JOIN acumaticaManufacturing.ProductionOrdersPoMapping popm ON popm.ProductionNumber = mod.ProductionNumber
	WHERE mod.ItemCode=abn.ItemCode AND abn.PONumber=popm.PoNumber)
	GROUP BY abn.ItemCode,abn.PONumber


	INSERT @EtaMSComponent(ETA,Qty,AcumaticaID)
	SELECT CASE WHEN cd.ETA < GETDATE() THEN @nextPickDate ELSE cd.ETA END AS ProductionEndDate,SUM(cd.qty- CASE WHEN ISNULL(snAbn.Qty,0) > 0 THEN snAbn.Qty ELSE 0 END ) AS Qty,cd.AcumaticaID
	 FROM @EtaMSComponentDetail AS cd 
	OUTER APPLY (SELECT  SUM(saq.Qty) AS Qty FROM @snAbnQty AS saq WHERE saq.PONumber=cd.ProductionNumber AND saq.ItemCode=cd.ItemCode GROUP BY  saq.ItemCode, saq.PONumber) snAbn	
	GROUP BY CASE WHEN cd.ETA < GETDATE() THEN @nextPickDate ELSE cd.ETA END, cd.ItemCode, cd.AcumaticaID
	 HAVING  SUM( CASE WHEN cd.qty- ISNULL(snAbn.Qty,0) > 0 THEN cd.qty- ISNULL(snAbn.Qty,0)  ELSE 0 END ) > 0

	 INSERT @EtaComponent(ETA,Qty,AcumaticaID,IsContainer,IsMSOrder	 )
	 	SELECT cu.ETA,cu.Qty,cu.AcumaticaID ,1,  0 FROM @EtaContainerComponent AS cu
	UNION ALL
	SELECT ih.ETA,ih.Qty, ih.AcumaticaID, 0 ,1 FROM (
	SELECT mo.eta,mo.qty,mo.AcumaticaID  FROM @EtaMSComponent AS mo
	UNION ALL
	SELECT elp.ETA,elp.Qty,elp.AcumaticaID FROM @EtaLocalPo AS elp
	) ih GROUP BY ih.ETA,ih.Qty, ih.AcumaticaID
	--SELECT mo.eta,mo.qty,mo.AcumaticaID , 0,  1 FROM @EtaMSComponent AS mo
	
	RETURN 
END

GO
/****** Object:  UserDefinedFunction [inventory].[EtaItems]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[EtaItems]
(
)
RETURNS 
@EtaComponent TABLE 
(
	ETA DATE NULL,
	Qty INT NOT NULL DEFAULT(0),
	AcumaticaID INT NOT NULL,
	IsContainer BIT NOT NULL DEFAULT(0),
	IsMSOrder BIT NOT NULL DEFAULT(0),
	IsDOOrder BIT NOT NULL DEFAULT(0),
	IsLocalVendorOrder BIT NOT NULL DEFAULT(0)
)
AS
BEGIN
	DECLARE @EtaContainerComponent TABLE (ETA DATE NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @EtaMSComponent TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @EtaMSComponentDetail TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL, ProductionNumber VARCHAR(50) NOT NULL, ItemCode VARCHAR(50) NOT NULL )
	DECLARE @snAbnQty TABLE (ItemCode VARCHAR(50) NOT NULL, PoNumber VARCHAR(50) NOT NULL , Qty INT NOT NULL DEFAULT (0) )
	
	DECLARE @nextPickDate DATE = GETDATE() + 1
	SELECT @nextPickDate =MIN(apd.PickingDate) FROM picking.AvailablePickingDates AS apd WHERE apd.PickingDate > GETDATE()

	INSERT @EtaContainerComponent(ETA,Qty,AcumaticaID)
	SELECT  CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END ETA,SUM(cl.Qty + ISNULL(cl.ApprovedAmount, 0)) Qty,til.AcumaticaID
	FROM inventory.ContainerList AS cl
		JOIN inventory.Containers AS c ON c.ContainerID = cl.ContainerID
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = cl.ItemCode
	WHERE cl.Deleted = 0 AND c.Received = 0 AND c.AcumaticaID IS NOT NULL AND ISNULL(c.Arrived, 0) = 0
	AND NOT EXISTS(SELECT * FROM inventory.Po AS p WHERE p.PoNumber=cl.PONumber AND EXISTS (SELECT 1 FROM inventory.Vendor AS v WHERE v.VendorId=p.VendorID AND v.IsLocal=1))
	GROUP BY cl.ItemCode,CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END, til.AcumaticaID
	UNION ALL
	SELECT CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END ETA, SUM(cd.PoQty + ISNULL(cd.ApprovedAmount, 0) - cd.TotalReceived) QtyOnContainer, til.AcumaticaID
	FROM inventory.ContainerDetail AS cd
		JOIN inventory.Containers AS c ON c.Container = cd.Container
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = cd.ItemCode
	WHERE c.Arrived = 1 AND c.Received = 0 AND c.AcumaticaID IS NOT NULL
	AND NOT EXISTS(SELECT * FROM inventory.Po AS p WHERE p.PoNumber=cd.PONumber AND EXISTS (SELECT 1 FROM inventory.Vendor AS v WHERE v.VendorId=p.VendorID AND v.IsLocal=1))
	GROUP BY cd.ItemCode,CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END, til.AcumaticaID;
	
	DECLARE @EtaLocalPo TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @LocalPodetail TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL, Ponumber VARCHAR(50) NOT NULL, ItemCode VARCHAR(50) NOT NULL )

	INSERT @LocalPodetail(ETA,Qty,AcumaticaID,Ponumber,ItemCode)

	SELECT p.PromisedOn , pli.Quantity, til.AcumaticaID,p.PoNumber, til.ShortItemCode FROM inventory.Po AS p
	JOIN inventory.PoLineItems AS pli ON pli.PoID = p.ID AND p.Deleted=0 AND pli.Deleted=0 AND p.Closed=0 AND pli.ReceivedQuantity< pli.Quantity AND p.AcumaticaID IS NOT NULL
	JOIN dbo.tb_ItemList AS til ON til.AcumaticaName = pli.AcumaticaName AND til.AcumaticaID IS NOT NULL 
	JOIN inventory.Vendor AS v ON v.VendorId = p.VendorID AND v.IsLocal=1
	WHERE p.Status NOT IN ('Canceled', 'On Hold') AND (til.ItemTypeCode IN(3,7) OR  til.ComponentPartTypeId IN(19))

	INSERT @snAbnQty(ItemCode,PoNumber,Qty	)
	SELECT tis.ItemCode, tis.PONumber, COUNT(*) AS Qty FROM dbo.tb_ItemSeriel AS tis  
	WHERE EXISTS (SELECT * FROM @LocalPodetail AS lp WHERE lp.ItemCode=tis.ItemCode AND tis.PONumber=lp.Ponumber)
	GROUP BY tis.ItemCode,tis.PONumber
	UNION All
	SELECT abn.ItemCode, abn.PONumber, SUM(abn.CreatedQty) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @LocalPodetail AS lp WHERE lp.ItemCode=abn.ItemCode AND abn.PONumber=lp.Ponumber)
	GROUP BY abn.ItemCode,abn.PONumber

	INSERT @EtaLocalPo(ETA,Qty,AcumaticaID)
	SELECT CASE WHEN lp.ETA < GETDATE() THEN @nextPickDate ELSE lp.ETA END AS ProductionEndDate,SUM(lp.Qty- CASE WHEN ISNULL(snAbn.Qty,0) > 0 THEN snAbn.Qty ELSE 0 END ) AS Qty,lp.AcumaticaID
	 FROM @LocalPodetail AS lp 
	OUTER APPLY (SELECT  SUM(saq.Qty) AS Qty FROM @snAbnQty AS saq WHERE saq.PONumber=lp.Ponumber AND saq.ItemCode=lp.ItemCode GROUP BY  saq.ItemCode, saq.PONumber) snAbn	
	GROUP BY CASE WHEN lp.ETA < GETDATE() THEN @nextPickDate ELSE lp.ETA END, lp.ItemCode, lp.AcumaticaID
	 HAVING  SUM( CASE WHEN lp.qty- ISNULL(snAbn.Qty,0) > 0 THEN lp.qty- ISNULL(snAbn.Qty,0)  ELSE 0 END ) > 0

	DELETE @snAbnQty


	INSERT @EtaMSComponentDetail(ETA,ItemCode,Qty,ProductionNumber,AcumaticaID)

	SELECT  po.ProductionEndDate , po.ItemCode, po.QtyToProduce AS qty, po.ProductionNumber, til.AcumaticaID
	FROM acumaticaManufacturing.ProductionOrders AS po
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = po.ItemCode
	WHERE po.ProductionOrderType='MS' AND po.ProductionStatus NOT IN('Closed','Canceled') AND po.DeleteFlag = 0 AND ISNULL(po.OnHold,0) = 0
	GROUP BY po.ProductionEndDate,po.ItemCode,po.QtyToProduce,po.ProductionNumber,til.AcumaticaID
	HAVING po.QtyToProduce> 0	

	INSERT @snAbnQty(ItemCode,PoNumber,Qty	)
	SELECT tis.ItemCode, tis.PONumber, COUNT(*) AS Qty FROM dbo.tb_ItemSeriel AS tis  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod WHERE mod.ItemCode=tis.ItemCode AND tis.PONumber=mod.ProductionNumber)
	GROUP BY tis.ItemCode,tis.PONumber
	UNION all
	SELECT abn.ItemCode, abn.PONumber, SUM(abn.CreatedQty) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod WHERE mod.ItemCode=abn.ItemCode AND abn.PONumber=mod.ProductionNumber)
	GROUP BY abn.ItemCode,abn.PONumber
	UNION all	
	SELECT abn.ItemCode, abn.PONumber, SUM(abn.CreatedQty) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod 
	JOIN acumaticaManufacturing.ProductionOrdersPoMapping popm ON popm.ProductionNumber = mod.ProductionNumber
	WHERE mod.ItemCode=abn.ItemCode AND abn.PONumber=popm.PoNumber)
	GROUP BY abn.ItemCode,abn.PONumber


	INSERT @EtaMSComponent(ETA,Qty,AcumaticaID)
	SELECT CASE WHEN cd.ETA < GETDATE() THEN @nextPickDate ELSE cd.ETA END AS ProductionEndDate,SUM(cd.qty- CASE WHEN ISNULL(snAbn.Qty,0) > 0 THEN snAbn.Qty ELSE 0 END ) AS Qty,cd.AcumaticaID
	 FROM @EtaMSComponentDetail AS cd 
	OUTER APPLY (SELECT  SUM(saq.Qty) AS Qty FROM @snAbnQty AS saq WHERE saq.PONumber=cd.ProductionNumber AND saq.ItemCode=cd.ItemCode GROUP BY  saq.ItemCode, saq.PONumber) snAbn	
	GROUP BY CASE WHEN cd.ETA < GETDATE() THEN @nextPickDate ELSE cd.ETA END, cd.ItemCode, cd.AcumaticaID
	 HAVING  SUM( CASE WHEN cd.qty- ISNULL(snAbn.Qty,0) > 0 THEN cd.qty- ISNULL(snAbn.Qty,0)  ELSE 0 END ) > 0

	 INSERT @EtaComponent(ETA,Qty,AcumaticaID,IsContainer	 )
	 	SELECT cu.ETA,cu.Qty,cu.AcumaticaID ,1 FROM @EtaContainerComponent AS cu
	--UNION ALL
	--SELECT ih.ETA,ih.Qty, ih.AcumaticaID, 0 ,1 FROM (
	--SELECT mo.eta,mo.qty,mo.AcumaticaID  FROM @EtaMSComponent AS mo
	--UNION ALL
	--SELECT elp.ETA,elp.Qty,elp.AcumaticaID FROM @EtaLocalPo AS elp
	--) ih GROUP BY ih.ETA,ih.Qty, ih.AcumaticaID
	----SELECT mo.eta,mo.qty,mo.AcumaticaID , 0,  1 FROM @EtaMSComponent AS mo
	
	INSERT @EtaComponent(ETA,Qty,AcumaticaID,IsMSOrder	 )
	SELECT mo.eta,SUM(mo.qty),mo.AcumaticaID,1  FROM @EtaMSComponent AS mo
	GROUP BY mo.ETA, mo.AcumaticaID

	INSERT @EtaComponent(ETA,Qty,AcumaticaID,IsLocalVendorOrder	 )
	SELECT elp.eta,SUM(elp.qty),elp.AcumaticaID,1  FROM @EtaLocalPo AS elp
	GROUP BY elp.ETA, elp.AcumaticaID
	 

	INSERT @EtaComponent(ETA,Qty,AcumaticaID,IsDOOrder	 )
	SELECT DoOrder.ProductionEndDate,SUM(DoOrder.qty) AS Qty,DoOrder.AcumaticaID,1 FROM (
    SELECT  po.ProductionEndDate , pod.TotalRequired AS qty, til.AcumaticaID
    FROM acumaticaManufacturing.ProductionOrders AS po
        JOIN acumaticaManufacturing.ProductionOrderDetails POD ON POD.ProductionNumber = po.ProductionNumber
        JOIN dbo.tb_ItemList til ON til.AcumaticaName = pod.Itemcode
    WHERE po.ProductionOrderType='DO' AND po.ProductionStatus NOT IN('Closed','Canceled') AND po.DeleteFlag = 0	
    UNION ALL
    SELECT CI.WorkOrderEndDate, ci.WorkOrderQty, til.AcumaticaID
    FROM acumaticaManufacturing.ItemToCreate ITC
    JOIN acumaticaManufacturing.CreatedItemLink CIL ON CIL.ItemToCreateId = ITC.ItemToCreateId
    JOIN acumaticaManufacturing.CreatedItem CI ON CI.CreatedItemId = CIL.CreatedItemId
    JOIN dbo.tb_ItemList til ON til.AcumaticaName = ci.InventoryId
    WHERE  NOT EXISTS (SELECT * FROM acumaticaManufacturing.ProductionOrders PO WHERE PO.ProductionNumber = CI.WorkOrderNumber)
	AND ITC.Sandbox=0
	UNION ALL
	 SELECT ITC.DueDate, ITC.Quantity, til.AcumaticaID
    FROM acumaticaManufacturing.ItemToCreate ITC
	 JOIN dbo.tb_ItemList til ON til.AcumaticaName = ITC.InventoryId
	 WHERE NOT EXISTS(SELECT * FROM acumaticaManufacturing.CreatedItemLink CIL WHERE CIL.ItemToCreateId=ITC.ItemToCreateId)
	 AND ITC.Sandbox=0 AND ITC.Processed = 0
	) DoOrder 
	GROUP BY DoOrder.ProductionEndDate,DoOrder.AcumaticaID

	RETURN 
END






GO
/****** Object:  UserDefinedFunction [inventory].[EtaItemsNew]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[EtaItemsNew]
(
)
RETURNS 
@EtaComponent TABLE 
(
	ETA DATE NULL,
	Qty INT NOT NULL DEFAULT(0),
	AcumaticaID INT NOT NULL,
	IsContainer BIT NOT NULL DEFAULT(0),
	IsMSOrder BIT NOT NULL DEFAULT(0),
	IsDOOrder BIT NOT NULL DEFAULT(0),
	IsLocalVendorOrder BIT NOT NULL DEFAULT(0)
)
AS
BEGIN
	DECLARE @EtaContainerComponent TABLE (ETA DATE NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @EtaMSComponent TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @EtaMSComponentDetail TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL, ProductionNumber VARCHAR(50) NOT NULL, ItemCode VARCHAR(50) NOT NULL )
	DECLARE @snAbnQty TABLE (ItemCode VARCHAR(50) NOT NULL, PoNumber VARCHAR(50) NOT NULL , Qty INT NOT NULL DEFAULT (0) )
	
	DECLARE @nextPickDate DATE = GETDATE() + 1
	SELECT @nextPickDate =MIN(apd.PickingDate) FROM picking.AvailablePickingDates AS apd WHERE apd.PickingDate > GETDATE()

	INSERT @EtaContainerComponent(ETA,Qty,AcumaticaID)
	SELECT  CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END ETA,SUM(cl.Qty + ISNULL(cl.ApprovedAmount, 0)) Qty,til.AcumaticaID
	FROM inventory.ContainerList AS cl
		JOIN inventory.Containers AS c ON c.ContainerID = cl.ContainerID
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = cl.ItemCode
	WHERE cl.Deleted = 0 AND c.Received = 0 AND c.AcumaticaID IS NOT NULL AND ISNULL(c.Arrived, 0) = 0
	AND NOT EXISTS(SELECT * FROM inventory.Po AS p WHERE p.PoNumber=cl.PONumber AND EXISTS (SELECT 1 FROM inventory.Vendor AS v WHERE v.VendorId=p.VendorID AND v.IsLocal=1))
	GROUP BY cl.ItemCode,CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END, til.AcumaticaID
	UNION ALL
	SELECT CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END ETA, SUM(cd.PoQty + ISNULL(cd.ApprovedAmount, 0) - cd.TotalReceived) QtyOnContainer, til.AcumaticaID
	FROM inventory.ContainerDetail AS cd
		JOIN inventory.Containers AS c ON c.Container = cd.Container
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = cd.ItemCode
	WHERE c.Arrived = 1 AND c.Received = 0 AND c.AcumaticaID IS NOT NULL
	AND NOT EXISTS(SELECT * FROM inventory.Po AS p WHERE p.PoNumber=cd.PONumber AND EXISTS (SELECT 1 FROM inventory.Vendor AS v WHERE v.VendorId=p.VendorID AND v.IsLocal=1))
	GROUP BY cd.ItemCode,CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END, til.AcumaticaID;
	
	DECLARE @EtaLocalPo TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @LocalPodetail TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL, Ponumber VARCHAR(50) NOT NULL, ItemCode VARCHAR(50) NOT NULL )

	INSERT @LocalPodetail(ETA,Qty,AcumaticaID,Ponumber,ItemCode)

	SELECT p.PromisedOn , pli.Quantity, til.AcumaticaID,p.PoNumber, til.ShortItemCode FROM inventory.Po AS p
	JOIN inventory.PoLineItems AS pli ON pli.PoID = p.ID AND p.Deleted=0 AND pli.Deleted=0 AND p.Closed=0 AND pli.ReceivedQuantity< pli.Quantity AND p.AcumaticaID IS NOT NULL
	JOIN dbo.tb_ItemList AS til ON til.AcumaticaName = pli.AcumaticaName AND til.AcumaticaID IS NOT NULL 
	JOIN inventory.Vendor AS v ON v.VendorId = p.VendorID AND v.IsLocal=1
	WHERE p.Status NOT IN ('Canceled', 'On Hold') AND (til.ItemTypeCode IN(3,7) OR  til.ComponentPartTypeId IN(19))

	INSERT @snAbnQty(ItemCode,PoNumber,Qty	)
	SELECT tis.ItemCode, tis.PONumber, COUNT(*) AS Qty FROM dbo.tb_ItemSeriel AS tis  
	WHERE EXISTS (SELECT * FROM @LocalPodetail AS lp WHERE lp.ItemCode=tis.ItemCode AND tis.PONumber=lp.Ponumber)
	GROUP BY tis.ItemCode,tis.PONumber
	UNION All
	SELECT abn.ItemCode, abn.PONumber, SUM(abn.CreatedQty) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @LocalPodetail AS lp WHERE lp.ItemCode=abn.ItemCode AND abn.PONumber=lp.Ponumber)
	GROUP BY abn.ItemCode,abn.PONumber

	INSERT @EtaLocalPo(ETA,Qty,AcumaticaID)
	SELECT CASE WHEN lp.ETA < GETDATE() THEN @nextPickDate ELSE lp.ETA END AS ProductionEndDate,SUM(lp.Qty- CASE WHEN ISNULL(snAbn.Qty,0) > 0 THEN snAbn.Qty ELSE 0 END ) AS Qty,lp.AcumaticaID
	 FROM @LocalPodetail AS lp 
	OUTER APPLY (SELECT  SUM(saq.Qty) AS Qty FROM @snAbnQty AS saq WHERE saq.PONumber=lp.Ponumber AND saq.ItemCode=lp.ItemCode GROUP BY  saq.ItemCode, saq.PONumber) snAbn	
	GROUP BY CASE WHEN lp.ETA < GETDATE() THEN @nextPickDate ELSE lp.ETA END, lp.ItemCode, lp.AcumaticaID
	 HAVING  SUM( CASE WHEN lp.qty- ISNULL(snAbn.Qty,0) > 0 THEN lp.qty- ISNULL(snAbn.Qty,0)  ELSE 0 END ) > 0

	DELETE @snAbnQty


	INSERT @EtaMSComponentDetail(ETA,ItemCode,Qty,ProductionNumber,AcumaticaID)

	SELECT  po.ProductionEndDate , po.ItemCode, po.QtyToProduce AS qty, po.ProductionNumber, til.AcumaticaID
	FROM acumaticaManufacturing.ProductionOrders AS po
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = po.ItemCode
	WHERE po.ProductionOrderType='MS' AND po.ProductionStatus NOT IN('Closed','Canceled') AND po.DeleteFlag = 0 AND ISNULL(po.OnHold,0) = 0
	GROUP BY po.ProductionEndDate,po.ItemCode,po.QtyToProduce,po.ProductionNumber,til.AcumaticaID
	HAVING po.QtyToProduce> 0	

	INSERT @snAbnQty(ItemCode,PoNumber,Qty	)
	SELECT tis.ItemCode, tis.PONumber, COUNT(*) AS Qty FROM dbo.tb_ItemSeriel AS tis  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod WHERE mod.ItemCode=tis.ItemCode AND tis.PONumber=mod.ProductionNumber)
	GROUP BY tis.ItemCode,tis.PONumber
	UNION all
	SELECT abn.ItemCode, abn.PONumber, SUM(abn.CreatedQty) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod WHERE mod.ItemCode=abn.ItemCode AND abn.PONumber=mod.ProductionNumber)
	GROUP BY abn.ItemCode,abn.PONumber
	UNION all	
	SELECT abn.ItemCode, abn.PONumber, SUM(abn.CreatedQty) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod 
	JOIN acumaticaManufacturing.ProductionOrdersPoMapping popm ON popm.ProductionNumber = mod.ProductionNumber
	WHERE mod.ItemCode=abn.ItemCode AND abn.PONumber=popm.PoNumber)
	GROUP BY abn.ItemCode,abn.PONumber


	INSERT @EtaMSComponent(ETA,Qty,AcumaticaID)
	SELECT CASE WHEN cd.ETA < GETDATE() THEN @nextPickDate ELSE cd.ETA END AS ProductionEndDate,SUM(cd.qty- CASE WHEN ISNULL(snAbn.Qty,0) > 0 THEN snAbn.Qty ELSE 0 END ) AS Qty,cd.AcumaticaID
	 FROM @EtaMSComponentDetail AS cd 
	OUTER APPLY (SELECT  SUM(saq.Qty) AS Qty FROM @snAbnQty AS saq WHERE saq.PONumber=cd.ProductionNumber AND saq.ItemCode=cd.ItemCode GROUP BY  saq.ItemCode, saq.PONumber) snAbn	
	GROUP BY CASE WHEN cd.ETA < GETDATE() THEN @nextPickDate ELSE cd.ETA END, cd.ItemCode, cd.AcumaticaID
	 HAVING  SUM( CASE WHEN cd.qty- ISNULL(snAbn.Qty,0) > 0 THEN cd.qty- ISNULL(snAbn.Qty,0)  ELSE 0 END ) > 0

	 INSERT @EtaComponent(ETA,Qty,AcumaticaID,IsContainer	 )
	 	SELECT cu.ETA,cu.Qty,cu.AcumaticaID ,1 FROM @EtaContainerComponent AS cu
	--UNION ALL
	--SELECT ih.ETA,ih.Qty, ih.AcumaticaID, 0 ,1 FROM (
	--SELECT mo.eta,mo.qty,mo.AcumaticaID  FROM @EtaMSComponent AS mo
	--UNION ALL
	--SELECT elp.ETA,elp.Qty,elp.AcumaticaID FROM @EtaLocalPo AS elp
	--) ih GROUP BY ih.ETA,ih.Qty, ih.AcumaticaID
	----SELECT mo.eta,mo.qty,mo.AcumaticaID , 0,  1 FROM @EtaMSComponent AS mo
	
	INSERT @EtaComponent(ETA,Qty,AcumaticaID,IsMSOrder	 )
	SELECT mo.eta,SUM(mo.qty),mo.AcumaticaID,1  FROM @EtaMSComponent AS mo
	GROUP BY mo.ETA, mo.AcumaticaID

	INSERT @EtaComponent(ETA,Qty,AcumaticaID,IsLocalVendorOrder	 )
	SELECT elp.eta,SUM(elp.qty),elp.AcumaticaID,1  FROM @EtaLocalPo AS elp
	GROUP BY elp.ETA, elp.AcumaticaID
	 

	INSERT @EtaComponent(ETA,Qty,AcumaticaID,IsDOOrder	 )
	SELECT DoOrder.ProductionEndDate,SUM(DoOrder.qty) AS Qty,DoOrder.AcumaticaID,1 FROM (
    SELECT  po.ProductionEndDate , pod.QtyRequired AS qty, til.AcumaticaID
    FROM acumaticaManufacturing.ProductionOrders AS po
        JOIN acumaticaManufacturing.ProductionOrderDetails POD ON POD.ProductionNumber = po.ProductionNumber
        JOIN dbo.tb_ItemList til ON til.ShortItemCode = pod.Itemcode
    WHERE po.ProductionOrderType='DO' AND po.ProductionStatus NOT IN('Closed','Canceled') AND po.DeleteFlag = 0	
    UNION ALL
    SELECT CI.WorkOrderEndDate, ci.WorkOrderQty, til.AcumaticaID
    FROM acumaticaManufacturing.ItemToCreate ITC
    JOIN acumaticaManufacturing.CreatedItemLink CIL ON CIL.ItemToCreateId = ITC.ItemToCreateId
    JOIN acumaticaManufacturing.CreatedItem CI ON CI.CreatedItemId = CIL.CreatedItemId
    JOIN dbo.tb_ItemList til ON til.AcumaticaName = ci.InventoryId
    WHERE  NOT EXISTS (SELECT * FROM acumaticaManufacturing.ProductionOrders PO WHERE PO.ProductionNumber = CI.WorkOrderNumber)
	AND ITC.Sandbox=0
	UNION ALL
	 SELECT ITC.DueDate, ITC.Quantity, til.AcumaticaID
    FROM acumaticaManufacturing.ItemToCreate ITC
	 JOIN dbo.tb_ItemList til ON til.AcumaticaName = ITC.InventoryId
	 WHERE NOT EXISTS(SELECT * FROM acumaticaManufacturing.CreatedItemLink CIL WHERE CIL.ItemToCreateId=ITC.ItemToCreateId)
	 AND ITC.Sandbox=0
	) DoOrder 
	GROUP BY DoOrder.ProductionEndDate,DoOrder.AcumaticaID

	RETURN 
END



GO
/****** Object:  UserDefinedFunction [inventory].[EtaItemsOld]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[EtaItemsOld]
(
)
RETURNS 
@EtaComponent TABLE 
(
	ETA DATE NULL,
	Qty INT NOT NULL DEFAULT(0),
	AcumaticaID INT NOT NULL,
	IsContainer BIT NOT NULL DEFAULT(0),
	IsMSOrder BIT NOT NULL DEFAULT(0)
)
AS
BEGIN
	DECLARE @EtaContainerComponent TABLE (ETA DATE NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @EtaMSComponent TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @EtaMSComponentDetail TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL, ProductionNumber VARCHAR(50) NOT NULL, ItemCode VARCHAR(50) NOT NULL )
	DECLARE @snAbnQty TABLE (ItemCode VARCHAR(50) NOT NULL, PoNumber VARCHAR(50) NOT NULL , Qty INT NOT NULL DEFAULT (0) )
	
	DECLARE @nextPickDate DATE = GETDATE() + 1
	SELECT @nextPickDate =MIN(apd.PickingDate) FROM picking.AvailablePickingDates AS apd WHERE apd.PickingDate > GETDATE()

	INSERT @EtaContainerComponent(ETA,Qty,AcumaticaID)
	SELECT  CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END ETA,SUM(cl.Qty + ISNULL(cl.ApprovedAmount, 0)) Qty,til.AcumaticaID
	FROM inventory.ContainerList AS cl
		JOIN inventory.Containers AS c ON c.ContainerID = cl.ContainerID
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = cl.ItemCode
	WHERE cl.Deleted = 0 AND c.Received = 0 AND c.AcumaticaID IS NOT NULL AND ISNULL(c.Arrived, 0) = 0
	AND NOT EXISTS(SELECT * FROM inventory.Po AS p WHERE p.PoNumber=cl.PONumber AND EXISTS (SELECT 1 FROM inventory.Vendor AS v WHERE v.VendorId=p.VendorID AND v.IsLocal=1))
	GROUP BY cl.ItemCode,CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END, til.AcumaticaID
	UNION ALL
	SELECT CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END ETA, SUM(cd.PoQty + ISNULL(cd.ApprovedAmount, 0) - cd.TotalReceived) QtyOnContainer, til.AcumaticaID
	FROM inventory.ContainerDetail AS cd
		JOIN inventory.Containers AS c ON c.Container = cd.Container
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = cd.ItemCode
	WHERE c.Arrived = 1 AND c.Received = 0 AND c.AcumaticaID IS NOT NULL
	AND NOT EXISTS(SELECT * FROM inventory.Po AS p WHERE p.PoNumber=cd.PONumber AND EXISTS (SELECT 1 FROM inventory.Vendor AS v WHERE v.VendorId=p.VendorID AND v.IsLocal=1))
	GROUP BY cd.ItemCode,CASE WHEN c.ETA < GETDATE() THEN @nextPickDate ELSE c.ETA END, til.AcumaticaID;
	
	DECLARE @EtaLocalPo TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL)
	DECLARE @LocalPodetail TABLE (ETA DATE NOT NULL,Qty INT NOT NULL DEFAULT(0),AcumaticaID INT NOT NULL, Ponumber VARCHAR(50) NOT NULL, ItemCode VARCHAR(50) NOT NULL )

	INSERT @LocalPodetail(ETA,Qty,AcumaticaID,Ponumber,ItemCode)

	SELECT p.PromisedOn , pli.Quantity, til.AcumaticaID,p.PoNumber, til.ShortItemCode FROM inventory.Po AS p
	JOIN inventory.PoLineItems AS pli ON pli.PoID = p.ID AND p.Deleted=0 AND pli.Deleted=0 AND p.Closed=0 AND pli.ReceivedQuantity< pli.Quantity AND p.AcumaticaID IS NOT NULL
	JOIN dbo.tb_ItemList AS til ON til.AcumaticaName = pli.AcumaticaName AND til.AcumaticaID IS NOT NULL 
	JOIN inventory.Vendor AS v ON v.VendorId = p.VendorID AND v.IsLocal=1
	WHERE p.Status NOT IN ('Canceled', 'On Hold') AND (til.ItemTypeCode IN(3,7) OR  til.ComponentPartTypeId IN(19))

	INSERT @snAbnQty(ItemCode,PoNumber,Qty	)
	SELECT tis.ItemCode, tis.PONumber, COUNT(*) AS Qty FROM dbo.tb_ItemSeriel AS tis  
	WHERE EXISTS (SELECT * FROM @LocalPodetail AS lp WHERE lp.ItemCode=tis.ItemCode AND tis.PONumber=lp.Ponumber)
	GROUP BY tis.ItemCode,tis.PONumber
	UNION All
	SELECT abn.ItemCode, abn.PONumber, SUM(abn.CreatedQty) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @LocalPodetail AS lp WHERE lp.ItemCode=abn.ItemCode AND abn.PONumber=lp.Ponumber)
	GROUP BY abn.ItemCode,abn.PONumber

	INSERT @EtaLocalPo(ETA,Qty,AcumaticaID)
	SELECT CASE WHEN lp.ETA < GETDATE() THEN @nextPickDate ELSE lp.ETA END AS ProductionEndDate,SUM(lp.Qty- CASE WHEN ISNULL(snAbn.Qty,0) > 0 THEN snAbn.Qty ELSE 0 END ) AS Qty,lp.AcumaticaID
	 FROM @LocalPodetail AS lp 
	OUTER APPLY (SELECT  SUM(saq.Qty) AS Qty FROM @snAbnQty AS saq WHERE saq.PONumber=lp.Ponumber AND saq.ItemCode=lp.ItemCode GROUP BY  saq.ItemCode, saq.PONumber) snAbn	
	GROUP BY CASE WHEN lp.ETA < GETDATE() THEN @nextPickDate ELSE lp.ETA END, lp.ItemCode, lp.AcumaticaID
	 HAVING  SUM( CASE WHEN lp.qty- ISNULL(snAbn.Qty,0) > 0 THEN lp.qty- ISNULL(snAbn.Qty,0)  ELSE 0 END ) > 0

	DELETE @snAbnQty


	INSERT @EtaMSComponentDetail(ETA,ItemCode,Qty,ProductionNumber,AcumaticaID)

	SELECT  po.ProductionEndDate , po.ItemCode, po.QtyToProduce AS qty, po.ProductionNumber, til.AcumaticaID
	FROM acumaticaManufacturing.ProductionOrders AS po
		JOIN dbo.tb_ItemList AS til ON til.ShortItemCode = po.ItemCode
	WHERE po.ProductionOrderType='MS' AND po.ProductionStatus NOT IN('Closed','Canceled') AND po.DeleteFlag = 0 AND ISNULL(po.OnHold,0) = 0
	GROUP BY po.ProductionEndDate,po.ItemCode,po.QtyToProduce,po.ProductionNumber,til.AcumaticaID
	HAVING po.QtyToProduce> 0	

	INSERT @snAbnQty(ItemCode,PoNumber,Qty	)
	SELECT tis.ItemCode, tis.PONumber, COUNT(*) AS Qty FROM dbo.tb_ItemSeriel AS tis  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod WHERE mod.ItemCode=tis.ItemCode AND tis.PONumber=mod.ProductionNumber)
	GROUP BY tis.ItemCode,tis.PONumber
	UNION all
	SELECT abn.ItemCode, abn.PONumber, SUM(abn.CreatedQty) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod WHERE mod.ItemCode=abn.ItemCode AND abn.PONumber=mod.ProductionNumber)
	GROUP BY abn.ItemCode,abn.PONumber
	UNION all	
	SELECT abn.ItemCode, abn.PONumber, SUM(abn.CreatedQty) AS Qty  FROM dbo.tb_AccBoxNumber AS abn  
	WHERE EXISTS (SELECT * FROM @EtaMSComponentDetail AS mod 
	JOIN acumaticaManufacturing.ProductionOrdersPoMapping popm ON popm.ProductionNumber = mod.ProductionNumber
	WHERE mod.ItemCode=abn.ItemCode AND abn.PONumber=popm.PoNumber)
	GROUP BY abn.ItemCode,abn.PONumber


	INSERT @EtaMSComponent(ETA,Qty,AcumaticaID)
	SELECT CASE WHEN cd.ETA < GETDATE() THEN @nextPickDate ELSE cd.ETA END AS ProductionEndDate,SUM(cd.qty- CASE WHEN ISNULL(snAbn.Qty,0) > 0 THEN snAbn.Qty ELSE 0 END ) AS Qty,cd.AcumaticaID
	 FROM @EtaMSComponentDetail AS cd 
	OUTER APPLY (SELECT  SUM(saq.Qty) AS Qty FROM @snAbnQty AS saq WHERE saq.PONumber=cd.ProductionNumber AND saq.ItemCode=cd.ItemCode GROUP BY  saq.ItemCode, saq.PONumber) snAbn	
	GROUP BY CASE WHEN cd.ETA < GETDATE() THEN @nextPickDate ELSE cd.ETA END, cd.ItemCode, cd.AcumaticaID
	 HAVING  SUM( CASE WHEN cd.qty- ISNULL(snAbn.Qty,0) > 0 THEN cd.qty- ISNULL(snAbn.Qty,0)  ELSE 0 END ) > 0

	 INSERT @EtaComponent(ETA,Qty,AcumaticaID,IsContainer,IsMSOrder	 )
	 	SELECT cu.ETA,cu.Qty,cu.AcumaticaID ,1,  0 FROM @EtaContainerComponent AS cu
	UNION ALL
	SELECT ih.ETA,ih.Qty, ih.AcumaticaID, 0 ,1 FROM (
	SELECT mo.eta,mo.qty,mo.AcumaticaID  FROM @EtaMSComponent AS mo
	UNION ALL
	SELECT elp.ETA,elp.Qty,elp.AcumaticaID FROM @EtaLocalPo AS elp
	) ih GROUP BY ih.ETA,ih.Qty, ih.AcumaticaID
	--SELECT mo.eta,mo.qty,mo.AcumaticaID , 0,  1 FROM @EtaMSComponent AS mo
	
	RETURN 
END



GO
/****** Object:  UserDefinedFunction [inventory].[GetAllowedToDisturbStockRefillerInMinutes]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 7/24/2019
-- Description:	Get allowed to disturb stock refiller in minutes
-- =============================================
CREATE FUNCTION [inventory].[GetAllowedToDisturbStockRefillerInMinutes] 
(
)
RETURNS INT
AS
BEGIN
	DECLARE @AllowedToDisturbStockRefillerInMinutes INT = 60
	SELECT @AllowedToDisturbStockRefillerInMinutes = CAST(gv.DefaultValue AS NUMERIC) FROM dbo.GPSVariables gv WHERE gv.VariableName='GetAllowedToDisturbStockRefillerInMinutes' AND ISNUMERIC(gv.DefaultValue) = 1
	RETURN @AllowedToDisturbStockRefillerInMinutes
END
GO
/****** Object:  UserDefinedFunction [inventory].[GetApnInfoSharingPickingTask]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION  [inventory].[GetApnInfoSharingPickingTask] 
(
	@scan VARCHAR(150) 
)
RETURNS 
 @table TABLE 
(
	ItemCode VARCHAR(150)NULL,
	Description VARCHAR(2000) NULL,
	ID INT,
	SN VARCHAR(50) ,
	APN VARCHAR(150),
	PONumber VARCHAR(50),
	Status VARCHAR(150),
	UserName VARCHAR(150),
	ProductionItemDetailId INT NULL,
	ItemTypeCode VARCHAR(50),
	InSBN BIT
)
AS
BEGIN
DECLARE @tranEntry INT
IF (LEFT(@scan, 2) = 'sn')
BEGIN
    SELECT @tranEntry = tis.TranEntryID
    FROM dbo.tb_ItemSeriel AS tis
    WHERE tis.SerielID = @scan;
END;
ELSE
BEGIN
    SELECT @tranEntry = tapn.TranEntryID
    FROM dbo.tb_AccPickNumber AS tapn
    WHERE tapn.APN = @scan;
END;

INSERT INTO @table
	(
	   ItemCode,Description,ID,SN,APN,PONumber,Status,UserName,ProductionItemDetailId,ItemTypeCode,InSBN
	)

SELECT til.ShortItemCode AS ItemCode, otherTe.Description ,otherTe.ID , tis.SerielID AS SN, otherApns.APN, 
					otherTe.FWPONumber AS PONumber, d.Status, u.FirstName AS UserName,  
                    COALESCE(tis.ProductionItemDetailId,tabni.ProductionItemDetailId) ProductionItemDetailId, it.TypeName AS ItemTypeCode, 
					CAST(CASE WHEN sbn.Id IS NOT NULL THEN 1 ELSE 0 END AS BIT) AS InSBN
                    FROM --dbo.tb_AccPickNumber AS tapn

					dbo.TranEntry AS input --ON te.ID = ptd.ItemId
					CROSS APPLY (SELECT TOP (1) ptd.PickingTaskId FROM  picking.PickingTaskDetail AS ptd
						JOIN dbo.TranEntry AS te2 ON te2.ID = ptd.ItemId
						WHERE  ptd.ItemId = input.ID AND ptd.Picked=1 ORDER BY ptd.PickedTime DESC) pt
					JOIN picking.PickingTaskDetail AS ptd ON ptd.PickingTaskId = pt.PickingTaskId AND ptd.Picked =1
					JOIN dbo.TranEntry AS otherTe ON ptd.ItemId = otherTe.ID
					JOIN dbo.ItemType AS it ON it.TypeID = otherTe.ItemType
					JOIN dbo.tb_ItemList AS til ON til.ItemCode = otherTe.ItemNumber
					JOIN dbo.Departmentstatus AS d ON d.ID = otherTe.DepartmentstatusID
				LEFT JOIN dbo.tb_AccPickNumber AS otherApns ON ptd.ItemId = otherApns.TranEntryID AND otherApns.isActive = 1
				LEFT JOIN dbo.[User] AS u ON u.ID = otherApns.UserID
					LEFT JOIN dbo.tb_ItemSeriel AS tis ON tis.TranEntryID = otherTe.ID
					LEFT JOIN dbo.tb_AccBoxNumberItems AS tabni ON tabni.ID = otherTe.ID
					OUTER APPLY (SELECT TOP (1) abh.Id FROM dbo.AccessoriesBoxHeader AS abh WHERE abh.IsActive = 1 
							AND EXISTS (SELECT 1 FROM dbo.AccessoriesBoxDetail AS abd WHERE abd.HeaderId = abh.Id AND abd.IsActive = 1 AND abd.TranEntryId = otherTe.ID) ORDER BY abh.Id) sbn
                    WHERE input.ID = @tranEntry
	RETURN 
END
GO
/****** Object:  UserDefinedFunction [inventory].[GetIsNeededHereForOrders]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [inventory].[GetIsNeededHereForOrders]
(
	@PalletId INT,
	@test BIT = 0
)
RETURNS BIT
AS 
BEGIN
RETURN
	CAST( CASE WHEN EXISTS (SELECT 1 FROM dbo.ItemLocationsUpdate ILU
	JOIN dbo.InventoryLocation IL ON IL.Location = ILU.Location
	JOIN inventory.StockRefillItemsConfigResult SRICR ON SRICR.ItemCode = ILU.ItemCode-- AND IL.LocationType = SRICR.InventoryLocationTypeId
	JOIN inventory.StockRefillLocationTypeConfig SRLTC ON SRLTC.LocationTypeId = SRICR.InventoryLocationTypeId
	WHERE (IL.LocationType = SRLTC.LocationTypeId OR il.LocationType = SRLTC.StagingLocationTypeId)
	AND ILU.PalletID = @palletId AND SRICR.StockRefillReasonId = 1 AND SRICR.Test = @test) THEN 1 ELSE 0 END AS bit)

END
GO
/****** Object:  UserDefinedFunction [inventory].[GetItemsToBringFromOverstock]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <02-18-2020>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[GetItemsToBringFromOverstock]()
RETURNS 
@ReturnVal TABLE 
(
	ItemCode NVARCHAR(150) NOT NULL,
	Quantity INT NOT NULL
)
AS
BEGIN
	DECLARE @PickDatesToFulfill INT, @BasedOnMin BIT, @LatestPickDateToFulfill DATE
	DECLARE @BelowMinFulfillmentItems TABLE(ItemCode NVARCHAR(150) NOT NULL, Quantity INT NOT NULL 
	INDEX IX_PickDatesToFulfill_ItemCode CLUSTERED(ItemCode))
	DECLARE @PickDateFulfillmentItems TABLE(ItemCode NVARCHAR(150) NOT NULL, DestinationLocationId INT NULL, Quantity INT NOT NULL
	INDEX IX_PickDateFulfillmentItems_ItemCode CLUSTERED(ItemCode))
	SELECT TOP (1) @PickDatesToFulfill = CAST(gv.DefaultValue AS INT) FROM dbo.GPSVariables AS gv WHERE gv.VariableName = 'PickDaysAheadToBringFromOverstock' ORDER BY gv.DefaultValue
	SELECT TOP (1) @BasedOnMin = CAST(gv.DefaultValue AS BIT) FROM dbo.GPSVariables AS gv WHERE gv.VariableName = 'BaseOverstockRefillItemsOnMin' ORDER BY gv.DefaultValue
	SELECT @LatestPickDateToFulfill = apd.PickingDate FROM picking.AvailablePickingDates AS apd WHERE apd.PickingDate >= GETDATE()
	ORDER BY apd.PickingDate OFFSET @PickDatesToFulfill ROWS FETCH NEXT 1 ROWS ONLY

	
	IF @PickDatesToFulfill > 0
	BEGIN

	--non belt items
	    INSERT @PickDateFulfillmentItems(ItemCode, Quantity)
		SELECT til.ShortItemCode, COUNT(*) - ISNULL(ItemsInLocation.Quantity, 0)
		FROM dbo.TranEntry AS te 
		JOIN dbo.[Order] AS o ON o.ID = te.OrderID 
		JOIN dbo.Departmentstatus AS d ON d.ID = o.Departmentstatusid
		JOIN dbo.QuotesStatus AS qs ON o.SOnumber=qs.QuoteNumber 
		JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
		OUTER APPLY(SELECT SUM(ilu.Quantity)Quantity 
			FROM dbo.ItemLocationsUpdate AS ilu 
			JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
			WHERE il.ExcludeFrmStock = 0
			AND ilu.ItemCode IS NOT NULL
			AND il.IsPickable = 1 
			AND ilu.ItemCode = til.ShortItemCode
			AND NOT EXISTS (SELECT * FROM inventory.LocationTypeRuleMapping AS ltrm 
				WHERE ltrm.LocationRuleId = 4 AND ltrm.LocationTypeId = il.LocationType AND ltrm.Active = 1))ItemsInLocation
		WHERE 
		--NOT EXISTS(SELECT * FROM dbo.tb_ItemSeriel AS tis WHERE tis.TranEntryID = te.ID)
		--AND NOT EXISTS(SELECT * FROM dbo.tb_AccBoxNumberItems AS tabni WHERE tabni.TranEntryID = te.ID)
		--AND 
		te.FWPONumber IS NULL
		AND te.isActive = 1 AND te.isDeleted = 0
		AND te.ItemType IN(1,2,3,7,12)
		AND NOT EXISTS(SELECT * FROM picking.OrderItemProductionItemIRelease AS oipiir WHERE oipiir.OrderItemId = te.ID AND oipiir.Revision <> 'A')
		AND o.isActive=1 AND o.CustomerName <> 'TEST ORDERS'
		AND qs.QuoteStatus ='SALES ORDER'
		AND d.isShipped = 0
		AND te.PickingDate <= @LatestPickDateToFulfill
		GROUP BY til.ShortItemCode, ItemsInLocation.Quantity

	--belt items
		INSERT @PickDateFulfillmentItems(ItemCode, DestinationLocationId, Quantity)
		
		SELECT til.ShortItemCode, pi.DestinationLocationId, COUNT(*) - ISNULL(ItemsInBelt.Quantity, 0) 
		FROM Picking.ProductionItem AS pi
		JOIN Picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi.ProductionItemId AND pid.Deleted = 0
		JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
		OUTER APPLY(SELECT SUM(ilu.Quantity)Quantity
			FROM picking.RackLane AS rl 
			JOIN picking.Rack AS r ON r.RackLaneId = rl.RackLaneId
			JOIN picking.RackLocation AS rl2 ON rl2.RackId = r.RackId
			JOIN dbo.InventoryLocation AS il ON il.ID = rl2.LocationId
			JOIN dbo.ItemLocationsUpdate AS ilu ON ilu.Location = il.Location
			WHERE il.ExcludeFrmStock = 0
			AND rl.DestinationLocationId = pi.DestinationLocationId
			AND ilu.ItemCode = til.ShortItemCode)ItemsInBelt
		WHERE pid.Picked = 0 
		AND pi.Deleted = 0
		AND pi.Sandbox = 0
		AND (
				pi.OrderItemId IS NULL
				OR EXISTS(SELECT 1 FROM dbo.TranEntry AS te
				JOIN dbo.[Order] AS o ON o.ID = te.OrderID
				JOIN dbo.Departmentstatus AS d ON d.ID = o.Departmentstatusid
				JOIN dbo.QuotesStatus AS qs ON o.SOnumber=qs.QuoteNumber
				JOIN dbo.Departmentstatus dsi ON dsi.ID = te.DepartmentstatusID  AND dsi.Departmentid <> 27
				WHERE o.isActive=1 AND o.CustomerName <> 'TEST ORDERS'
				AND qs.QuoteStatus ='SALES ORDER'
				AND d.isShipped = 0 AND te.isActive =1 AND te.isDeleted =0)
			)
		AND pi.PickingDate <= @LatestPickDateToFulfill
		GROUP BY til.ShortItemCode, pi.DestinationLocationId, ItemsInBelt.Quantity
		
	END
	IF @BasedOnMin = 1
	BEGIN
	    INSERT @BelowMinFulfillmentItems(ItemCode, Quantity)
	    SELECT ildic.ItemCode, ISNULL(ildic.MaxCapacity, 0) - Qty.Qty FROM dbo.InventoryLocation AS il 
		JOIN dbo.InventoryLocationDefaultItemCode AS ildic ON ildic.LocationID = il.ID
		OUTER APPLY(SELECT ilu.ItemCode, ISNULL(SUM(ilu.Quantity), 0) Qty 
			FROM dbo.ItemLocationsUpdate AS ilu 
			WHERE ilu.Location = il.Location AND ilu.ItemCode = ildic.ItemCode
			GROUP BY ilu.ItemCode
			)Qty
		WHERE Qty.Qty < ildic.MinThreshold

	END	    

	INSERT @ReturnVal(ItemCode, Quantity)
	SELECT Needed.ItemCode, MIN(Needed.Quantity) - ISNULL(ItemsOnOsTasks.Quantity, 0) FROM
		(SELECT pdfi.ItemCode, SUM(pdfi.Quantity) AS Quantity
		FROM @PickDateFulfillmentItems AS pdfi
		GROUP BY pdfi.ItemCode
		UNION 
		SELECT bmfi.ItemCode, bmfi.Quantity 
		FROM @BelowMinFulfillmentItems AS bmfi)AS Needed
		OUTER APPLY(SELECT SUM(pri.Pcs) AS Quantity
		FROM inventory.StockRefillTask AS srt
		JOIN dbo.PalletReceivingItems AS pri ON pri.PalletID = srt.PalletId
		WHERE srt.StockRefillTaskTypeId = 1
		AND srt.Active = 1 AND srt.Completed = 0
		AND pri.ItemCode = Needed.ItemCode)ItemsOnOsTasks
		GROUP BY Needed.ItemCode, ItemsOnOsTasks.Quantity
		HAVING 
		MIN(Needed.Quantity) - ISNULL(ItemsOnOsTasks.Quantity, 0) > 0 AND
		 (COUNT(Needed.ItemCode) = 2 OR @BasedOnMin = 0 OR @PickDatesToFulfill = 0)

	RETURN 
END
GO
/****** Object:  UserDefinedFunction [inventory].[GetMainItemFromSubstitutionOrSelf]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <6-24-2020>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [inventory].[GetMainItemFromSubstitutionOrSelf]
(
	@ItemCode NVARCHAR(150)
)
RETURNS NVARCHAR(150)
AS
BEGIN
	
	DECLARE @returnVal NVARCHAR(150) = @ItemCode

	SELECT TOP (1) @returnVal = tilm.ShortItemCode FROM picking.AutomaticItemSubstitutionDetail AS aisd
	JOIN picking.AutomaticItemSubstitutionMaster AS aism ON aism.AutomaticItemSubstitutionMasterId = aisd.AutomaticItemSubstitutionMasterId
	JOIN dbo.tb_ItemList AS tild ON tild.ID = aisd.ItemlistId
	JOIN dbo.tb_ItemList AS tilm ON tilm.ID = aism.MainItemListId
	WHERE aisd.Active = 1
	AND aism.Active = 1
	AND tild.ShortItemCode = @ItemCode
	
	--IF @returnVal IS NULL
	--BEGIN
	--    RETURN @ItemCode
	--END

	RETURN @returnVal

END
GO
/****** Object:  UserDefinedFunction [inventory].[GetNewStockComponent]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[GetNewStockComponent]
(
	@componentIn  inventory.StockComponent READONLY
)
RETURNS 
@componentOut TABLE(
	[TranentryId] [INT] NOT NULL,
	[RownumAll] [INT] NOT NULL,
	[AcumaticaId] [INT] NOT NULL,
	[StockAcumaticaId] [INT] NOT NULL,
	[Quantity] [INT] NOT NULL DEFAULT ((0)),
	[ComponentPartTypeId] INT NULL,
	[QtyRequired] [INT] NOT NULL,
	[SortComponent] [INT] NOT NULL,
	[PickingDate] [DATE] NOT NULL,
	[Revision] [VARCHAR](50) NULL,
	[Eta] [DATE] NULL,
	[ONContainer] [BIT] NOT NULL DEFAULT ((0)),
	[ONINhousePO] [BIT] NOT NULL DEFAULT ((0)),
	[Updated] [BIT] NOT NULL DEFAULT ((0))
)
AS
BEGIN
	DECLARE @StockAcumaticaID INT = NULL;
    DECLARE @sort INT = 0;
    DECLARE @QtyRequired INT = 0;	
	DECLARE @doubles TABLE (StockAcumaticaID INT NOT NULL, Updated BIT NOT NULL DEFAULT(0))

	DECLARE @LocalComponent inventory.StockComponent

	INSERT @LocalComponent
	SELECT * FROM @componentIn AS ci


	INSERT @doubles	(StockAcumaticaID)
	SELECT DISTINCT c.StockAcumaticaID  FROM @LocalComponent AS c WHERE c.QtyRequired > 1
	

	WHILE EXISTS (SELECT * FROM @doubles AS d WHERE d.updated = 0)
	BEGIN
		SELECT @StockAcumaticaID = d.StockAcumaticaID FROM @doubles AS d WHERE d.updated = 0 ORDER BY d.StockAcumaticaID;
		WHILE EXISTS
			  (SELECT 1 FROM @LocalComponent AS c WHERE c.StockAcumaticaID = @StockAcumaticaID AND c.SortComponent > @sort AND c.QtyRequired > 1 )
		BEGIN
			SELECT TOP (1) @sort = c.SortComponent, @QtyRequired = c.QtyRequired FROM @LocalComponent AS c
			WHERE c.StockAcumaticaID = @StockAcumaticaID AND c.SortComponent >= @sort AND c.QtyRequired > 1
			ORDER BY c.SortComponent ASC;

			UPDATE c SET c.SortComponent = c.SortComponent + (@QtyRequired - 1) FROM @LocalComponent c WHERE c.StockAcumaticaID = @StockAcumaticaID AND c.SortComponent >= @sort;

			SET @sort = @sort + @QtyRequired;
		END;
		SET @sort = 0;
		UPDATE @doubles SET updated = 1 WHERE StockAcumaticaID = @StockAcumaticaID;
	END;
	
	INSERT @componentOut
	SELECT * FROM @LocalComponent AS ci
	
	RETURN
END
GO
/****** Object:  UserDefinedFunction [inventory].[GetPalletForOsStockRefilTask]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <2-24-2020>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[GetPalletForOsStockRefilTask]
(
	@ItemCode NVARCHAR(150),
	@Quantity INT
)
RETURNS 
@returnVal TABLE(PalletId INT NOT NULL, ItemCode NVARCHAR(150) NOT NULL, Quantity INT NOT NULL)
AS
BEGIN
	
	INSERT @returnVal(PalletId, ItemCode, Quantity)
	SELECT TOP (1) pr.ID, pri.ItemCode, SUM(pri.Pcs) 
	FROM dbo.PalletReceiving AS pr
	JOIN dbo.PalletReceivingItems AS pri ON pri.PalletID = pr.ID
	JOIN dbo.InventoryLocation AS il ON il.Location = pr.Location
	OUTER APPLY(SELECT TOP (1) pw.PoDate, pri2.Pcs 
		FROM dbo.PalletReceivingItems AS pri2 
		JOIN inventory.PoWo AS pw ON pw.PoNumber = pri2.POnumber
		WHERE pri2.ItemCode = @ItemCode AND pri2.PalletId = pri.PalletID)ic
	WHERE EXISTS(SELECT * FROM dbo.PalletReceivingItems AS pri2 WHERE pri2.ItemCode = @ItemCode AND pri2.PalletID = pr.ID)
	AND EXISTS(SELECT * FROM inventory.LocationTypeRuleMapping AS ltrm WHERE ltrm.LocationTypeId = il.LocationType 
		AND ltrm.LocationRuleId = 5
		AND ltrm.Active = 1) 
	GROUP BY pr.ID, pri.ItemCode, ic.Pcs, ic.PoDate
	ORDER BY ic.PoDate,
	CASE WHEN ic.Pcs = @Quantity THEN 0 ELSE 1 END,
	CASE WHEN ic.Pcs > @Quantity THEN 0 ELSE 1 END
	RETURN 
END
GO
/****** Object:  UserDefinedFunction [inventory].[GetPalletGridLine]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [inventory].[GetPalletGridLine]
(
	@SnAbn SerialList READONLY
)
RETURNS VARCHAR(250)
AS
BEGIN
	DECLARE @GrigLine VARCHAR(150) =''

	IF EXISTS(SELECT 1 FROM @SnAbn s HAVING COUNT(*)>=4 )
	BEGIN
		SELECT @GrigLine= STUFF((SELECT TOP 2 ',' + s.Serial FROM @SnAbn s ORDER BY s.Serial FOR XML PATH('')),1,1,'') 
		SELECT @GrigLine+= '...'+ STUFF((SELECT TOP 2 ',' + s.Serial FROM (SELECT TOP 2 * FROM @SnAbn ORDER BY Serial DESC) s ORDER BY s.Serial  FOR XML PATH('')),1,1,'') 
	END
	ELSE
	BEGIN 
		SELECT @GrigLine =(SELECT STUFF((SELECT',' + s.Serial FROM @SnAbn s ORDER BY s.Serial FOR XML PATH('')),1,1,'') as Serial )
	END

	RETURN @GrigLine

END

GO
/****** Object:  UserDefinedFunction [inventory].[GetPalletInstructionsForStockRefillShelvesRefiller]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <5-13-2020>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[GetPalletInstructionsForStockRefillShelvesRefiller]
(
	@palletId INT
)
RETURNS 
@returnVal TABLE 
(
	 ItemCode NVARCHAR(150),
     ImmediateQuantity INT,
	 TotalQuantity INT,
     LocationId INT,
     LocationName NVARCHAR(255),
     RackName VARCHAR(50),
     AisleName VARCHAR(50),
	 BeltId INT,
     BeltName VARCHAR(50),
     EnforceDestinationLocation BIT,
	 StagingLocationTypeId INT,
     StagingLocationTypeName NVARCHAR(50)
)
AS
BEGIN

	IF NOT EXISTS(SELECT * FROM dbo.PalletReceiving AS pr WHERE pr.ID = @palletId)
	BEGIN
	    RETURN;
	END
	DECLARE @ItemCodes NVARCHARList, @ToLocationTypeId INT
	DECLARE @PalletDetails TABLE(ItemCode NVARCHAR(150), Quantity INT)

	INSERT @PalletDetails(ItemCode, Quantity)
	SELECT pri.ItemCode, SUM(pri.Pcs)
	FROM dbo.PalletReceivingItems AS pri
	WHERE pri.PalletID = @palletId
	AND pri.Pcs > 0
	GROUP BY pri.ItemCode

	IF NOT EXISTS(SELECT * FROM @PalletDetails AS pd)
	BEGIN
	    RETURN
	END

	INSERT @ItemCodes(Value)
	SELECT DISTINCT pd.ItemCode FROM @PalletDetails AS pd
	
	SELECT TOP (1) @ToLocationTypeId = srt.ToLocationType FROM inventory.StockRefillTask AS srt
	WHERE srt.PalletId = @palletId
	AND srt.StockRefillTaskTypeId = 1
	ORDER BY srt.CompletedOn DESC
	
	INSERT @returnVal
	(
	    ItemCode,
	    ImmediateQuantity,
		TotalQuantity,
	    LocationId,
	    LocationName,
	    RackName,
	    AisleName,
		BeltId,
	    BeltName,
	    EnforceDestinationLocation,
        StagingLocationTypeId,
		StagingLocationTypeName
	)
	SELECT gintr.ItemCode, ic.ImmediateQuantity,
	dbo.GetMinValue(gintr.Quantity, pd.Quantity),
	loc.LocationID, loc.Location, loc.RackName,
	loc.RackLaneName,  gintr.DestinationLocationId, gintr.DestinationLocationName, gintr.EnforceDestinationLocation,
	gintr.StagingLocationTypeId, ilt.TypeName
	FROM inventory.GetItemsNeededToRefill(@ItemCodes, @ToLocationTypeId) AS gintr
	JOIN dbo.InventoryLocationType AS ilt ON gintr.StagingLocationTypeId = ilt.ID
	JOIN @PalletDetails AS pd ON pd.ItemCode = gintr.ItemCode
	CROSS APPLY
	(
		SELECT ildic.MaxCapacity, ilu.Quantity, ildic.MinThreshold, il.Location, il.ID AS LocationId,
		beltInfo.RackName, beltInfo.RackLaneName, beltInfo.DestinationLocationName, beltInfo.DestinationLocationId
		FROM dbo.InventoryLocation AS il 
		JOIN dbo.InventoryLocationDefaultItemCode AS ildic ON ildic.LocationID = il.ID
		OUTER APPLY
		(
			SELECT SUM(ilu.Quantity)AS Quantity 
			FROM dbo.ItemLocationsUpdate AS ilu
			WHERE ilu.ItemCode = ildic.ItemCode
			AND ilu.Location = il.LocationType
		)
		AS ilu
		OUTER APPLY
		(
			SELECT TOP (1) dl.DestinationLocationName, r.RackName, rl2.RackLaneName, dl.DestinationLocationId 
			FROM picking.RackLocation AS rl
			JOIN picking.Rack AS r ON r.RackId = rl.RackId
			JOIN picking.RackLane AS rl2 ON rl2.RackLaneId = r.RackLaneId
			JOIN picking.DestinationLocation AS dl ON dl.DestinationLocationId = rl2.DestinationLocationId
			WHERE rl.LocationId = il.ID
			AND rl.Active = 1
		)
		AS beltInfo
		WHERE il.LocationType = gintr.LocationTypeId
		AND ildic.ItemCode = gintr.ItemCode
	)
	AS loc
	OUTER APPLY
	(
		SELECT CASE WHEN loc.Quantity >= loc.MinThreshold THEN 0 ELSE MIN(X.quantity) END AS ImmediateQuantity 
		FROM (VALUES(gintr.Quantity), (pd.Quantity), (loc.MaxCapacity - loc.Quantity)) AS X(quantity)  
	)
	AS ic
	RETURN 
END
GO
/****** Object:  UserDefinedFunction [inventory].[GetPalletsForManualOSTasks]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Shulem, Neuwirth>
-- Create date: <5-24-2021>
-- Description:	<Description,,modified from GetPalletsForOsStockRefillTask created by Aron Steimetz>
-- =============================================
CREATE FUNCTION [inventory].[GetPalletsForManualOSTasks]
(
	@Test BIT,
	@ItemCodes StringList READONLY
)
RETURNS 
@returnVal TABLE(PalletId INT NOT NULL, ItemCode NVARCHAR(150) NOT NULL, PoDate DATETIME NULL, Quantity INT NOT NULL, IsInAGroup BIT NOT NULL, HasAssembled BIT NOT NULL)
AS
BEGIN

	DECLARE @InternalTest BIT, 
	@InternalItemCodes NVARCHARList
	SET @InternalTest = @Test
	INSERT @InternalItemCodes(Value)
	SELECT ic.Value FROM @ItemCodes AS ic

	INSERT @returnVal(PalletId, ItemCode, PoDate, Quantity, IsInAGroup, HasAssembled)
	SELECT ilu.PalletID, cics.NewItemCode AS MainItem, MIN(poDate.poDate)AS poDate, SUM(ilu.Quantity),  0 AS IsInAGroup,  CAST(CASE WHEN COALESCE(aa.Assembled, sa.Assembled, 0) = 1 THEN 1 ELSE 0 END AS BIT) HasAssembled 
	FROM dbo.ItemLocationsUpdate AS ilu
	OUTER  APPLY( SELECT TOP 1 tis.Assembled FROM  dbo.tb_AccBoxNumber  AS tis WHERE tis.PalletID = ilu.PalletID  AND tis.ItemCode = ilu.ItemCode AND tis.Assembled = 1 AND tis.Qty>0 ORDER BY tis.Assembled) aa
	OUTER  APPLY( SELECT TOP 1 tis.Assembled FROM  dbo.tb_ItemSeriel AS  tis WHERE tis.PalletID = ilu.PalletID AND tis.Received = 1 AND tis.ItemCode = ilu.ItemCode AND tis.Assembled = 1 AND tis.DeleteFlag = 0 ORDER BY tis.Assembled) sa
	CROSS APPLY( SELECT  cics.NewItemCode FROM  inventory.CachedItemCodeSubstitutions AS cics WHERE ilu.ItemCode = cics.OldItemCode 
				UNION SELECT ItemCode FROM dbo.tb_NonQBItemCodes WHERE ItemCode = ilu.ItemCode
				) cics
	--CROSS APPLY
	--(
	--	SELECT inventory.GetMainItemFromSubstitutionOrSelf(ilu.ItemCode)
	--)AS Substitute(MainItem)
	OUTER APPLY
	(
		SELECT TOP (1) COALESCE(p.PromisedOn, p.POCreated, p.AddDate)AS poDate FROM inventory.Po AS p
		WHERE p.PoNumber = ilu.POnumber
		AND ( p.Status <> 'Canceled' OR p.Status IS NULL ) AND p.Deleted = 0
		UNION ALL
		SELECT TOP (1) wo.ProductionEndDate FROM acumaticaManufacturing.ProductionOrders AS wo
		WHERE wo.ProductionNumber = ilu.POnumber AND wo.DeleteFlag = 0
	)AS poDate
	JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
	--OUTER APPLY
	--(
	--	SELECT CAST
	--	(
	--		CASE 
	--			WHEN EXISTS
	--			(
	--				SELECT * FROM inventory.StockRefillRackGroupingDetail AS srrgd
	--				JOIN inventory.StockRefillRackGroupingHeader AS srrgh ON srrgh.StockRefillRackGroupingHeaderId = srrgd.StockRefillRackGroupingHeaderId 
	--				JOIN picking.RackLocation AS rl ON srrgd.RackId = rl.RackId
	--				JOIN dbo.InventoryLocation AS il ON il.ID = rl.LocationId
	--				WHERE ilu.Location = il.Location
	--				AND rl.Active = 1 AND srrgd.Deleted = 0 AND srrgh.Deleted = 0
	--			)
	--			THEN 1
	--			ELSE 0 
	--		END AS BIT		
	--	) AS IsInAGroup 
	--)g
	WHERE EXISTS
	(
		SELECT * FROM dbo.ItemLocationsUpdate AS ilu2
		WHERE (EXISTS
		(
			SELECT 1 FROM @InternalItemCodes ic 
			JOIN inventory.CachedItemCodeSubstitutions AS cicsMain ON cicsMain.OldItemCode = ic.Value
			JOIN inventory.CachedItemCodeSubstitutions AS cicsChild ON cicsChild.NewItemCode = cicsMain.NewItemCode
			--CROSS APPLY
			--(
			--	SELECT gaisos.ItemCode FROM picking.GetAutomaticItemSubstitutionOrSelf(ic.Value) AS gaisos
			--)AS Substitute
			WHERE ilu2.ItemCode = cicsChild.NewItemCode--Substitute.ItemCode
		) OR EXISTS(SELECT * FROM dbo.tb_NonQBItemCodes AS tnqic WHERE ilu2.ItemCode = tnqic.ItemCode))
		AND ilu2.PalletID = ilu.PalletID 
		AND ilu2.Quantity > 0
	)
	AND EXISTS
	(
		SELECT * FROM inventory.LocationTypeRuleMapping AS ltrm WHERE ltrm.LocationTypeId = il.LocationType 
		AND ltrm.LocationRuleId = 5
		AND ltrm.Active = 1
	) 
	AND NOT EXISTS
	(
		SELECT * FROM inventory.StockRefillTask AS srt 
		WHERE srt.PalletId = ilu.PalletID AND srt.Active = 1 AND srt.Completed = 0
		AND srt.StockRefillTaskTypeId = 1
	)
	AND ilu.Quantity > 0
	AND il.ExcludeFrmStock = @InternalTest
	AND (@InternalTest = 0 OR il.Location LIKE 't1%') 
	AND il.IsActive = 1
	AND il.LocationType <> 13
	AND il.Warehouse = 5
	AND NOT EXISTS(SELECT 1 FROM inventory.PalletsSkippedForStockRefill AS psfsr WHERE psfsr.PalletId = ilu.PalletID AND psfsr.Active = 1)
	AND EXISTS
	(
		SELECT * FROM dbo.PalletReceiving AS pr
		WHERE ilu.PalletID = pr.ID
		AND pr.IsActive = 1
	)
	GROUP BY ilu.PalletID, cics.NewItemCode,  aa.Assembled, sa.Assembled
	RETURN 
END


GO
/****** Object:  UserDefinedFunction [inventory].[GetPalletsForOsStockRefillTask]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <2-24-2020>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[GetPalletsForOsStockRefillTask]
(
	@Test BIT,
	@ItemCodes StringList READONLY
)
RETURNS 
@returnVal TABLE(PalletId INT NOT NULL, ItemCode NVARCHAR(150) NOT NULL, PoDate DATETIME NULL, Quantity INT NOT NULL, IsInAGroup BIT NOT NULL, HasAssembled BIT NOT NULL)
AS
BEGIN

	DECLARE @InternalTest BIT, 
	@InternalItemCodes NVARCHARList
	SET @InternalTest = @Test
	INSERT @InternalItemCodes(Value)
	SELECT ic.Value FROM @ItemCodes AS ic

	INSERT @returnVal(PalletId, ItemCode, PoDate, Quantity, IsInAGroup, HasAssembled)
	SELECT ilu.PalletID, cics.NewItemCode AS MainItem, MIN(poDate.poDate)AS poDate, SUM(ilu.Quantity),  0 AS IsInAGroup,  CAST(CASE WHEN COALESCE(aa.Assembled, sa.Assembled, 0) = 1 THEN 1 ELSE 0 END AS BIT) HasAssembled 
	FROM dbo.ItemLocationsUpdate AS ilu
	OUTER  APPLY( SELECT TOP 1 tis.Assembled FROM  dbo.tb_AccBoxNumber  AS tis WHERE tis.PalletID = ilu.PalletID  AND tis.ItemCode = ilu.ItemCode AND tis.Assembled = 1 AND tis.Qty>0 ORDER BY tis.Assembled) aa
	OUTER  APPLY( SELECT TOP 1 tis.Assembled FROM  dbo.tb_ItemSeriel AS  tis WHERE tis.PalletID = ilu.PalletID AND tis.Received = 1 AND tis.ItemCode = ilu.ItemCode AND tis.Assembled = 1 AND tis.DeleteFlag = 0 ORDER BY tis.Assembled) sa
	JOIN inventory.CachedItemCodeSubstitutions AS cics ON ilu.ItemCode = cics.OldItemCode
	--CROSS APPLY
	--(
	--	SELECT inventory.GetMainItemFromSubstitutionOrSelf(ilu.ItemCode)
	--)AS Substitute(MainItem)
	OUTER APPLY
	(
		SELECT TOP (1) COALESCE(p.PromisedOn, p.POCreated, p.AddDate)AS poDate FROM inventory.Po AS p
		WHERE p.PoNumber = ilu.POnumber
		AND ( p.Status <> 'Canceled' OR p.Status IS NULL ) AND p.Deleted = 0
		UNION ALL
		SELECT TOP (1) wo.ProductionEndDate FROM acumaticaManufacturing.ProductionOrders AS wo
		WHERE wo.ProductionNumber = ilu.POnumber AND wo.DeleteFlag = 0
	)AS poDate
	JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
	--OUTER APPLY
	--(
	--	SELECT CAST
	--	(
	--		CASE 
	--			WHEN EXISTS
	--			(
	--				SELECT * FROM inventory.StockRefillRackGroupingDetail AS srrgd
	--				JOIN inventory.StockRefillRackGroupingHeader AS srrgh ON srrgh.StockRefillRackGroupingHeaderId = srrgd.StockRefillRackGroupingHeaderId 
	--				JOIN picking.RackLocation AS rl ON srrgd.RackId = rl.RackId
	--				JOIN dbo.InventoryLocation AS il ON il.ID = rl.LocationId
	--				WHERE ilu.Location = il.Location
	--				AND rl.Active = 1 AND srrgd.Deleted = 0 AND srrgh.Deleted = 0
	--			)
	--			THEN 1
	--			ELSE 0 
	--		END AS BIT		
	--	) AS IsInAGroup 
	--)g
	WHERE EXISTS
	(
		SELECT * FROM dbo.ItemLocationsUpdate AS ilu2
		WHERE EXISTS
		(
			SELECT 1 FROM @InternalItemCodes ic 
			JOIN inventory.CachedItemCodeSubstitutions AS cicsMain ON cicsMain.OldItemCode = ic.Value
			JOIN inventory.CachedItemCodeSubstitutions AS cicsChild ON cicsChild.NewItemCode = cicsMain.NewItemCode
			--CROSS APPLY
			--(
			--	SELECT gaisos.ItemCode FROM picking.GetAutomaticItemSubstitutionOrSelf(ic.Value) AS gaisos
			--)AS Substitute
			WHERE ilu2.ItemCode = cicsChild.NewItemCode--Substitute.ItemCode
		) 
		AND ilu2.PalletID = ilu.PalletID 
		AND ilu2.Quantity > 0
	)
	AND EXISTS
	(
		SELECT * FROM inventory.LocationTypeRuleMapping AS ltrm WHERE ltrm.LocationTypeId = il.LocationType 
		AND ltrm.LocationRuleId = 5
		AND ltrm.Active = 1
	) 
	AND NOT EXISTS
	(
		SELECT * FROM inventory.StockRefillTask AS srt 
		WHERE srt.PalletId = ilu.PalletID AND srt.Active = 1 AND srt.Completed = 0
		AND srt.StockRefillTaskTypeId = 1
	)
	AND ilu.Quantity > 0
	AND il.ExcludeFrmStock = @InternalTest
	AND (@InternalTest = 0 OR il.Location LIKE 't1%') 
	AND il.IsActive = 1
	AND il.LocationType <> 13
	AND il.Warehouse = 5
	AND NOT EXISTS(SELECT 1 FROM inventory.PalletsSkippedForStockRefill AS psfsr WHERE psfsr.PalletId = ilu.PalletID AND psfsr.Active = 1)
	AND EXISTS
	(
		SELECT * FROM dbo.PalletReceiving AS pr
		WHERE ilu.PalletID = pr.ID
		AND pr.IsActive = 1
	)
	GROUP BY ilu.PalletID, cics.NewItemCode,  aa.Assembled, sa.Assembled
	RETURN 
END


GO
/****** Object:  UserDefinedFunction [inventory].[GetPalletsForOsStockRefillTaskEmail]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <2-24-2020>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[GetPalletsForOsStockRefillTaskEmail]
(
	@ItemCodes StringList READONLY
)
RETURNS 
@returnVal TABLE(PalletId INT NOT NULL, ItemCode NVARCHAR(150) NOT NULL, PoDate DATETIME NOT NULL, Quantity INT NOT NULL, Sort INT)
AS
BEGIN
	
	INSERT @returnVal(PalletId, ItemCode, PoDate, Quantity, Sort)
	SELECT pr.ID, Substitute.MainItem, MIN(poDate.poDate)AS poDate, SUM(pri.Pcs),
	CASE WHEN il.LocationType IN (12, 4, 51) THEN 0 ELSE 1 END 
	FROM dbo.PalletReceiving AS pr
	JOIN dbo.PalletReceivingItems AS pri ON pri.PalletID = pr.ID
	CROSS APPLY
	(
		SELECT inventory.GetMainItemFromSubstitutionOrSelf(pri.ItemCode)
	)AS Substitute(MainItem)
	OUTER APPLY
	(
		SELECT TOP (1) COALESCE(p.PromisedOn, p.POCreated, p.AddDate)AS poDate FROM inventory.Po AS p
		WHERE p.PoNumber = pri.POnumber
		AND (p.Status <> 'Canceled' OR p.Status IS NULL) AND p.Deleted = 0
		UNION ALL
		SELECT TOP (1) wo.ProductionEndDate FROM acumaticaManufacturing.ProductionOrders AS wo
		WHERE wo.ProductionNumber = pri.POnumber AND wo.DeleteFlag = 0
	)AS poDate
	JOIN dbo.InventoryLocation AS il ON il.Location = pr.Location
	WHERE EXISTS
	(
		SELECT * FROM dbo.PalletReceivingItems AS pri2 
		WHERE EXISTS
		(
			SELECT 1 FROM @ItemCodes ic 
			CROSS APPLY
			(
				SELECT gaisos.ItemCode 
				FROM picking.GetAutomaticItemSubstitutionOrSelf(ic.Value) AS gaisos
			)AS Substitute
			WHERE pri2.ItemCode = Substitute.ItemCode
		) 
		AND pri2.PalletID = pr.ID 
		AND pri2.Pcs > 0
	)
	AND
	( 
		EXISTS	
		(
			SELECT * FROM inventory.LocationTypeRuleMapping AS ltrm WHERE ltrm.LocationTypeId = il.LocationType 
			AND ltrm.LocationRuleId = 5
			AND ltrm.Active = 1
		) 
		OR il.LocationType IN (12, 4, 51)
	)
	AND il.Warehouse = 5
	AND pri.Pcs > 0
	AND il.ExcludeFrmStock = 0
	GROUP BY pr.ID, Substitute.MainItem, CASE WHEN il.LocationType IN (12, 4, 51) THEN 0 ELSE 1 END
	RETURN 
END
GO
/****** Object:  UserDefinedFunction [inventory].[GetPalletsForOsStockRefilTask]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron, Steinmetz>
-- Create date: <2-24-2020>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[GetPalletsForOsStockRefilTask]
(
	@ItemCodes StringList READONLY
)
RETURNS 
@returnVal TABLE(PalletId INT NOT NULL, ItemCode NVARCHAR(150) NOT NULL, PoDate DATETIME NOT NULL, Quantity INT NOT NULL)
AS
BEGIN
	
	INSERT @returnVal(PalletId, ItemCode, PoDate, Quantity)
	SELECT pr.ID, pri.ItemCode, ic.PoDate, SUM(pri.Pcs) 
	FROM dbo.PalletReceiving AS pr
	JOIN dbo.PalletReceivingItems AS pri ON pri.PalletID = pr.ID
	JOIN dbo.InventoryLocation AS il ON il.Location = pr.Location
	OUTER APPLY(SELECT TOP (1) pw.PoDate, pri2.Pcs 
		FROM dbo.PalletReceivingItems AS pri2 
		JOIN inventory.PoWo AS pw ON pw.PoNumber = pri2.POnumber
		WHERE EXISTS(SELECT 1 FROM  @ItemCodes ic WHERE pri2.ItemCode = ic.Value) AND pri2.PalletId = pri.PalletID)ic
	WHERE EXISTS(SELECT * FROM dbo.PalletReceivingItems AS pri2 WHERE EXISTS(SELECT 1 FROM  @ItemCodes ic WHERE pri2.ItemCode = ic.Value) AND pri2.PalletID = pr.ID)
	AND EXISTS(SELECT * FROM inventory.LocationTypeRuleMapping AS ltrm WHERE ltrm.LocationTypeId = il.LocationType 
		AND ltrm.LocationRuleId = 5
		AND ltrm.Active = 1) 
	GROUP BY pr.ID, pri.ItemCode, ic.Pcs, ic.PoDate
	HAVING SUM(pri.Pcs) > 0
	RETURN 
END
GO
/****** Object:  UserDefinedFunction [inventory].[GetPalletsOnSRTaskInfo]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[GetPalletsOnSRTaskInfo]
(
	@Test BIT
)
RETURNS @tasks TABLE(PalletId INT, ItemCode NVARCHAR(150), Quantity INT, PoDate DATETIME,
	ToLocationType INT, CreatedBy NVARCHAR(128), Rush BIT, IsInOverstock BIT, OnHold BIT)  
AS
BEGIN 
	DECLARE @tasksBasic TABLE(PalletId INT,
	ToLocationType INT, CreatedBy NVARCHAR(128), Rush BIT, OnHold BIT )
	INSERT @tasksBasic(PalletId, ToLocationType, CreatedBy, Rush, OnHold)
	SELECT srt.PalletId, 
	srt.ToLocationType , srt.CreatedBy, srt.Rush,
	srt.OnHold
	FROM inventory.StockRefillTask AS srt
	WHERE srt.Completed = 0
	AND srt.Active = 1
	AND srt.StockRefillTaskTypeId = 1
	AND srt.Test = @Test

	INSERT @tasks
	(
	    PalletId, ItemCode, Quantity, ToLocationType, CreatedBy, Rush, IsInOverstock, OnHold, PoDate
	)
	SELECT tb.PalletId, items.MainItem, items.Quantity, tb.ToLocationType, tb.CreatedBy, tb.Rush, IsInOverstock, tb.OnHold, items.PoDate
	FROM @tasksBasic AS tb
	OUTER APPLY
	(
		SELECT Substitute.MainItem, SUM(ilu.Quantity) AS Quantity , MIN(poDate.PoDate) AS PoDate
		FROM dbo.ItemLocationsUpdate AS ilu
		CROSS APPLY
		(
			SELECT inventory.GetMainItemFromSubstitutionOrSelf(ilu.ItemCode)
		)AS Substitute(MainItem)
		OUTER APPLY
		(
			SELECT TOP (1) PoWo.PoDate FROM 
			(
				SELECT TOP (1) COALESCE(p.PromisedOn, p.POCreated, p.AddDate)AS poDate FROM inventory.Po AS p
				WHERE p.PoNumber = ilu.POnumber
				AND (p.Status <> 'Canceled' OR p.Status IS NULL) AND p.Deleted = 0
				UNION ALL
				SELECT TOP (1) wo.ProductionEndDate FROM acumaticaManufacturing.ProductionOrders AS wo
				WHERE wo.ProductionNumber = ilu.POnumber AND wo.DeleteFlag = 0
			)AS PoWo(PoDate)
		)poDate
		WHERE ilu.PalletID = tb.PalletId
		AND ilu.Quantity > 0
		GROUP BY Substitute.MainItem
	)AS items
	OUTER APPLY
	(
		SELECT CAST
		(
			CASE 
				WHEN EXISTS
				(
					SELECT * FROM inventory.LocationTypeRuleMapping AS ltrm
					JOIN dbo.InventoryLocation AS il ON ltrm.LocationTypeId = il.LocationType
					JOIN dbo.ItemLocationsUpdate AS ilu2 WITH(INDEX(IX_ItemLocationsUpdate_PalletID)) ON ilu2.Location = il.Location
					WHERE ltrm.Active = 1
					AND ilu2.PalletID = tb.PalletId
					AND ltrm.LocationRuleId = 5
				)
				THEN 1 
				ELSE 0 
			END 
			AS BIT		
		)AS IsInOverstock
	)AS IsInOverstock
	RETURN
END 
GO
/****** Object:  UserDefinedFunction [inventory].[GetPotentialShelfRefill]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--Shulem Neuwirth
CREATE FUNCTION [inventory].[GetPotentialShelfRefill] 
(
    @palletId INT
)
RETURNS @locationReffils TABLE( 
            [ItemCode] nvarchar(50), 
            [PalletID] int,
			[palletLocation] VARCHAR(255),
			[StagingType] VARCHAR(50),
			[LocationType] VARCHAR(50),
			[LocationTypeId] INT,
            [ItemsInStaging] int, 
            [qtyOnPallet] int, 
            [Quantity] int, 
            [DestinationLocationId] int,			
			[destinationName]VARCHAR(50) ,
            [Location] nvarchar(255),
			[locationId]INT, 
			[RackName] VARCHAR(50),
			[AisleName] VARCHAR(50),
            [MinThreshold] int, [MaxCapacity] int, 
            [defaultLocationQty] int, 
            [remainingSpace] int, 
            [canFill] INT,-- the less of pallet qty or location space
			[reserved] INT,-- the sum of the item needed in all destiation locations,
			[excess] int ) -- items in staging minus reserved (the above calculatino min)
AS
BEGIN
DECLARE @stagingType INT;
DECLARE @stagingTypeName VARCHAR(50);
DECLARE @targetType INT;
DECLARE @targetTypeName VARCHAR(50);
DECLARE @palletLocation VARCHAR(255);

 

SELECT @stagingType = srltc.StagingLocationTypeId, @targetType = srltc.LocationTypeId, @stagingTypeName = stagingT.TypeName, @targetTypeName = targetType.TypeName, @palletLocation = ilu.Location
FROM dbo.ItemLocationsUpdate AS ilu
JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
JOIN inventory.StockRefillLocationTypeConfig AS srltc ON il.LocationType IN(srltc.StagingLocationTypeId, srltc.DockingLocationTypeId)
JOIN dbo.InventoryLocationType AS stagingT ON srltc.StagingLocationTypeId = stagingT.ID
JOIN dbo.InventoryLocationType AS targetType ON srltc.LocationTypeId = targetType.ID
WHERE ilu.PalletID = @palletId

 

INSERT INTO @locationReffils
SELECT pallet.ItemCode, pallet.PalletID, @palletLocation AS palletLocation, @stagingTypeName AS StagingType, @targetTypeName AS LocationType, @targetType AS LocationTypeId, ISNULL(sricr.ItemsInStaging,0), 
ISNULL(pallet.qty,0) qty_on_pallet, dbo.NegativeIntToZero(ISNULL(sricr.Quantity,0)-ISNULL(sricr.ItemsInPickableLocation,0)) AS Quantity, dl.DestinationLocationId, dl.DestinationLocationName, 
il.Location, il.ID, COALESCE(dl.RackName,il.Rack), COALESCE(dl.RackLaneName, il.Isle), ISNULL(ildic.MinThreshold,0), ISNULL(ildic.MaxCapacity,0), 
ISNULL(dilu.Quantity,0) default_location_qty ,
dbo.NegativeIntToZero(ISNULL(ildic.MaxCapacity,0) - ISNULL(dilu.Quantity,0)) remaining_space, dbo.NegativeIntToZero(( SELECT MIN(v) FROM (VALUES(pallet.qty),(ISNULL(ildic.MaxCapacity,0) - ISNULL(dilu.Quantity,0))) AS t(v))) can_fill,
ISNULL(SUM(dbo.NegativeIntToZero(sricr.Quantity-sricr.ItemsInPickableLocation)) OVER(PARTITION BY pallet.ItemCode),0) AS reserved,
ISNULL(dbo.NegativeIntToZero(sricr.ItemsInStaging - SUM(dbo.NegativeIntToZero(sricr.Quantity-sricr.ItemsInPickableLocation)) OVER(PARTITION BY pallet.ItemCode)),0) AS excess 

FROM 
dbo.tb_ItemList AS til 
CROSS APPLY( 
    SELECT pilu.PalletID, pilu.ItemCode,SUM(pilu.Quantity) qty 
    FROM  dbo.ItemLocationsUpdate AS pilu 
    JOIN dbo.InventoryLocation AS pil ON pil.Location = pilu.Location
    WHERE  pilu.ItemCode = til.ShortItemCode AND ((@palletId IS NOT NULL AND pilu.PalletID = @palletId) OR (@palletId IS NULL AND pil.LocationType = @stagingType)) GROUP BY pilu.PalletID, pilu.ItemCode
    ) AS pallet

 

LEFT JOIN inventory.StockRefillItemsConfigResult AS sricr ON sricr.ItemCode = til.ShortItemCode AND sricr.InventoryLocationTypeId = @targetType
LEFT JOIN dbo.InventoryLocationDefaultItemCode AS ildic ON ildic.ItemCode = til.ShortItemCode AND EXISTS(SELECT * FROM dbo.InventoryLocation i WHERE i.ID  = ildic.LocationID AND i.LocationType = @targetType)
LEFT JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID AND il.LocationType = @targetType
OUTER APPLY
(
    SELECT rl.DestinationLocationId, dl2.DestinationLocationName, rloc.LocationId, r.RackName, rl.RackLaneName 
    FROM picking.RackLane AS rl
	JOIN picking.DestinationLocation AS dl2 ON dl2.DestinationLocationId = rl.DestinationLocationId 
    JOIN picking.Rack AS r ON r.RackLaneId = rl.RackLaneId
    JOIN picking.RackLocation AS rloc ON rloc.RackId = r.RackId
    WHERE rl.DestinationLocationId = sricr.DestinationLocationId AND ildic.LocationID = rloc.LocationId

 

) dl
OUTER APPLY
( 
	SELECT SUM(ilu.Quantity) Quantity FROM dbo.ItemLocationsUpdate AS ilu where ilu.Location = il.Location AND ilu.ItemCode = til.ShortItemCode
)  dilu
WHERE pallet.PalletID = @palletId AND ISNULL(dl.DestinationLocationId,0)=ISNULL(sricr.DestinationLocationId,0)
 GROUP BY
 pallet.ItemCode,
 pallet.PalletID,
 sricr.ItemsInStaging,
 pallet.qty,
ISNULL(sricr.Quantity,0)-ISNULL(sricr.ItemsInPickableLocation,0),
 il.Location,
 il.ID,
 dl.DestinationLocationId,
 dl.DestinationLocationName,
 ildic.MinThreshold,
 ildic.MaxCapacity,
 dilu.Quantity,
 dbo.NegativeIntToZero(sricr.Quantity-sricr.ItemsInPickableLocation),
COALESCE(dl.RackName,il.Rack), COALESCE(dl.RackLaneName, il.Isle)
ORDER BY pallet.PalletID,pallet.ItemCode,il.Location

 

 


RETURN;
END    
GO
/****** Object:  UserDefinedFunction [inventory].[GetQuantityNotReceivedOnPo]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 6/7/2018
-- Description:	Get Quantity Not Received On Po
-- =============================================
CREATE FUNCTION [inventory].[GetQuantityNotReceivedOnPo]
(
    @Itemcode VARCHAR(50),
    @PoNumber VARCHAR(50)
)
RETURNS INT
AS
BEGIN
    DECLARE @QuantityNotReceivedOnPo INT;
	IF EXISTS(SELECT 1 FROM inventory.Po p WHERE P.PoNumber = @PoNumber AND P.Closed = 1 AND P.Deleted = 0) RETURN 0
	IF EXISTS(SELECT 1 FROM acumaticaManufacturing.ProductionOrders AS po WHERE po.ProductionNumber = @PoNumber AND po.DeleteFlag = 0 AND po.ProductionStatus IN ('Closed','Completed')) RETURN 0

	IF @PoNumber IN('16016','16258') RETURN 10000

	IF @Itemcode LIKE '--- %'
	BEGIN
		SET @itemcode = SUBSTRING(@itemcode ,5,150) 
	END

	IF @PoNumber LIKE 'W%' OR EXISTS (SELECT 1 FROM acumaticaManufacturing.ProductionOrdersPoMapping popm WHERE popm.PoNumber = @PoNumber  AND popm.ItemCode = @Itemcode AND popm.Deleted =0)
	BEGIN
		DECLARE @ProductionNumber VARCHAR(50) = @PoNumber
		IF @PoNumber NOT LIKE 'W%'
		BEGIN
			SELECT @ProductionNumber = popm.PoNumber FROM acumaticaManufacturing.ProductionOrdersPoMapping popm WHERE popm.PoNumber = @PoNumber  AND popm.ItemCode = @Itemcode AND popm.Deleted =0
		END

		IF @PoNumber LIKE 'WT%'
		BEGIN
			SELECT @QuantityNotReceivedOnPo = pro.QtyToProduce - ISNULL(ihpo.ReceivedQuantity,0)
			FROM acumaticaSandboxManufacturing.ProductionOrdersItems pro
				 LEFT OUTER JOIN
				 (
					 SELECT SUM(Snabn.Qty) AS ReceivedQuantity, Snabn.ItemCode, Snabn.PONumber
					 FROM
						 (
							 SELECT SUM(abn.Qty) Qty, abn.ItemCode, abn.PONumber
							 FROM dbo.tb_AccBoxNumber abn
							 WHERE abn.ItemCode = @Itemcode AND abn.PONumber = @ProductionNumber
							 AND abn.CreatedFromAPN = 0 AND abn.ExcludeFromPo = 0
							 GROUP BY abn.ItemCode, abn.PONumber 
							 UNION
							 SELECT COUNT(*) Qty, ise.ItemCode, ise.PONumber
							 FROM dbo.tb_ItemSeriel ise
							 WHERE ise.ItemCode = @Itemcode AND ise.PONumber = @ProductionNumber AND ise.ExcludeFromPo = 0
							 GROUP BY ise.ItemCode, ise.PONumber
						 ) Snabn
					 GROUP BY Snabn.ItemCode, Snabn.PONumber
				 ) ihpo ON pro.ItemCode = ihpo.ItemCode AND pro.ProductionNumber = ihpo.PONumber

			WHERE pro.ItemCode = @Itemcode AND pro.ProductionNumber = @ProductionNumber;
		END

		ELSE 
		BEGIN	
			SELECT @QuantityNotReceivedOnPo = pro.QtyToProduce - ISNULL(ihpo.ReceivedQuantity,0)
			FROM acumaticaManufacturing.ProductionOrdersItems pro
				 LEFT OUTER JOIN
				 (
					 SELECT SUM(Snabn.Qty) AS ReceivedQuantity, Snabn.ItemCode, Snabn.PONumber
					 FROM
						 (
							 SELECT SUM(abn.Qty) Qty, abn.ItemCode, abn.PONumber
							 FROM dbo.tb_AccBoxNumber abn
							 WHERE abn.ItemCode = @Itemcode AND abn.PONumber = @ProductionNumber
							 AND abn.CreatedFromAPN = 0 AND abn.ExcludeFromPo = 0
							 GROUP BY abn.ItemCode, abn.PONumber
							 UNION
							 SELECT COUNT(*) Qty, ise.ItemCode, ise.PONumber
							 FROM dbo.tb_ItemSeriel ise
							 WHERE ise.ItemCode = @Itemcode AND ise.PONumber = @ProductionNumber AND ise.ExcludeFromPo = 0
							 GROUP BY ise.ItemCode, ise.PONumber
						 ) Snabn
					 GROUP BY Snabn.ItemCode, Snabn.PONumber
				 ) ihpo ON pro.ItemCode = ihpo.ItemCode AND pro.ProductionNumber = ihpo.PONumber

			WHERE pro.ItemCode = @Itemcode AND pro.ProductionNumber = @ProductionNumber;
		END	
	END

	ELSE IF EXISTS(SELECT 1 FROM inventory.Po p JOIN inventory.Vendor v ON v.VendorId = p.VendorID WHERE P.PoNumber = @PoNumber AND v.IsLocal = 1 ) 
	BEGIN
		SELECT @QuantityNotReceivedOnPo = pd.Quantity - CASE WHEN ISNULL(ihpo.ReceivedQuantity, 0) > ISNULL(pd.ReceivedQuantity,0) THEN  ISNULL(ihpo.ReceivedQuantity, 0)  ELSE ISNULL(pd.ReceivedQuantity,0) END
		FROM inventory.PoDetail pd
			 LEFT OUTER JOIN
			 (
				 SELECT SUM(Snabn.Qty) AS ReceivedQuantity, Snabn.ItemCode, Snabn.PONumber
				 FROM
					 (
						 SELECT SUM(abn.Qty) Qty, abn.ItemCode, abn.PONumber
						 FROM dbo.tb_AccBoxNumber abn
						 WHERE abn.ItemCode = @Itemcode AND abn.PONumber = @PoNumber
						 AND abn.CreatedFromAPN = 0 AND abn.ExcludeFromPo = 0
						 GROUP BY abn.ItemCode, abn.PONumber
						 UNION
						 SELECT COUNT(*) Qty, ise.ItemCode, ise.PONumber
						 FROM dbo.tb_ItemSeriel ise
						 WHERE ise.ItemCode = @Itemcode AND ise.PONumber = @PoNumber AND ise.ExcludeFromPo = 0
						 GROUP BY ise.ItemCode, ise.PONumber
					 ) Snabn
				 GROUP BY Snabn.ItemCode, Snabn.PONumber
			 ) ihpo ON pd.ItemCode = ihpo.ItemCode AND pd.PoNumber = ihpo.PONumber

		WHERE pd.ItemCode = @Itemcode AND pd.PoNumber = @PoNumber;    
	END
	ELSE
	BEGIN
		SELECT @QuantityNotReceivedOnPo = pd.Quantity - (ISNULL(pd.ReceivedQuantity, 0) + ISNULL(crq.ContainerReceivedQuantity, 0))
		FROM inventory.PoDetail pd
			LEFT OUTER JOIN
			 (
				 SELECT SUM(Snabn.Qty) AS ContainerReceivedQuantity, Snabn.ItemCode, Snabn.PONumber
				 FROM
					 (
						 SELECT SUM(abn.Qty) Qty, abn.ContainerID, abn.ItemCode, abn.PONumber
						 FROM dbo.tb_AccBoxNumber abn
						 WHERE abn.ItemCode = @Itemcode AND abn.PONumber = @PoNumber
						 AND abn.CreatedFromAPN = 0 AND abn.ExcludeFromPo = 0
						 GROUP BY abn.ContainerID, abn.ItemCode, abn.PONumber
						 UNION
						 SELECT COUNT(*) Qty, ise.ContainerID, ise.ItemCode, ise.PONumber
						 FROM dbo.tb_ItemSeriel ise
						 WHERE ise.ItemCode = @Itemcode AND ise.PONumber = @PoNumber AND ise.ExcludeFromPo = 0
						 GROUP BY ise.ContainerID, ise.ItemCode, ise.PONumber
					 ) Snabn
					 JOIN inventory.Containers c ON c.ContainerID = Snabn.ContainerID
					 JOIN inventory.ContainerBay cb ON cb.ContainerID = c.ContainerID AND cb.Deleted = 0 AND cb.ContainerStatusID IN ( 1, 3 )
				 GROUP BY Snabn.ItemCode, Snabn.PONumber
			 ) crq ON pd.ItemCode = crq.ItemCode AND pd.PoNumber = crq.PONumber

		WHERE pd.ItemCode = @Itemcode AND pd.PoNumber = @PoNumber;
	END
    RETURN ISNULL(@QuantityNotReceivedOnPo,0);

END;









GO
/****** Object:  UserDefinedFunction [inventory].[GetQuantityNotReceivedOnPoTmp]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 6/7/2018
-- Description:	Get Quantity Not Received On Po
-- =============================================
CREATE FUNCTION [inventory].[GetQuantityNotReceivedOnPoTmp]
(
    @Itemcode VARCHAR(50),
    @PoNumber VARCHAR(50)
)
RETURNS INT
AS
BEGIN
    DECLARE @QuantityNotReceivedOnPo INT;
	IF EXISTS(SELECT 1 FROM inventory.Po p WHERE P.PoNumber = @PoNumber AND P.Closed = 1 AND P.Deleted = 0) RETURN 0

	IF @Itemcode LIKE '--- %'
	BEGIN
		SET @itemcode = SUBSTRING(@itemcode ,5,150) 
	END

	IF @PoNumber LIKE 'W%' OR EXISTS (SELECT 1 FROM acumaticaManufacturing.ProductionOrdersPoMapping popm WHERE popm.PoNumber = @PoNumber  AND popm.ItemCode = @Itemcode AND popm.Deleted =0)
	BEGIN
		DECLARE @ProductionNumber VARCHAR(50) = @PoNumber
		IF @PoNumber NOT LIKE 'W%'
		BEGIN
			SELECT @ProductionNumber = popm.PoNumber FROM acumaticaManufacturing.ProductionOrdersPoMapping popm WHERE popm.PoNumber = @PoNumber  AND popm.ItemCode = @Itemcode AND popm.Deleted =0
		END

		SELECT @QuantityNotReceivedOnPo = pro.QtyToProduce - ISNULL(ihpo.ReceivedQuantity,0)
		FROM acumaticaManufacturing.ProductionOrdersItems pro
			 LEFT OUTER JOIN
			 (
				 SELECT SUM(Snabn.Qty) AS ReceivedQuantity, Snabn.ItemCode, Snabn.PONumber
				 FROM
					 (
						 SELECT SUM(abn.Qty) Qty, abn.ItemCode, abn.PONumber
						 FROM dbo.tb_AccBoxNumber abn
						 WHERE abn.ItemCode = @Itemcode AND abn.PONumber = @ProductionNumber
						 GROUP BY abn.ItemCode, abn.PONumber
						 UNION
						 SELECT COUNT(*) Qty, ise.ItemCode, ise.PONumber
						 FROM dbo.tb_ItemSeriel ise
						 WHERE ise.ItemCode = @Itemcode AND ise.PONumber = @ProductionNumber
						 GROUP BY ise.ItemCode, ise.PONumber
					 ) Snabn
				 GROUP BY Snabn.ItemCode, Snabn.PONumber
			 ) ihpo ON pro.ItemCode = ihpo.ItemCode AND pro.ProductionNumber = ihpo.PONumber

		WHERE pro.ItemCode = @Itemcode AND pro.ProductionNumber = @ProductionNumber;
	END

	ELSE IF EXISTS(SELECT 1 FROM inventory.Po p JOIN inventory.Vendor v ON v.VendorId = p.VendorID WHERE P.PoNumber = @PoNumber AND v.IsLocal = 1 ) 
	BEGIN
		SELECT @QuantityNotReceivedOnPo = pd.Quantity - CASE WHEN ISNULL(ihpo.ReceivedQuantity, 0) > ISNULL(pd.ReceivedQuantity,0) THEN  ISNULL(ihpo.ReceivedQuantity, 0)  ELSE ISNULL(pd.ReceivedQuantity,0) END
		FROM inventory.PoDetail pd
			 LEFT OUTER JOIN
			 (
				 SELECT SUM(Snabn.Qty) AS ReceivedQuantity, Snabn.ItemCode, Snabn.PONumber
				 FROM
					 (
						 SELECT SUM(abn.Qty) Qty, abn.ItemCode, abn.PONumber
						 FROM dbo.tb_AccBoxNumber abn
						 WHERE abn.ItemCode = @Itemcode AND abn.PONumber = @PoNumber
						 GROUP BY abn.ItemCode, abn.PONumber
						 UNION
						 SELECT COUNT(*) Qty, ise.ItemCode, ise.PONumber
						 FROM dbo.tb_ItemSeriel ise
						 WHERE ise.ItemCode = @Itemcode AND ise.PONumber = @PoNumber
						 GROUP BY ise.ItemCode, ise.PONumber
					 ) Snabn
				 GROUP BY Snabn.ItemCode, Snabn.PONumber
			 ) ihpo ON pd.ItemCode = ihpo.ItemCode AND pd.PoNumber = ihpo.PONumber

		WHERE pd.ItemCode = @Itemcode AND pd.PoNumber = @PoNumber;    
	END
	ELSE
	BEGIN
		SELECT @QuantityNotReceivedOnPo = pd.Quantity - (ISNULL(pd.ReceivedQuantity, 0) + ISNULL(crq.ContainerReceivedQuantity, 0))
		FROM inventory.PoDetail pd
			LEFT OUTER JOIN
			 (
				 SELECT SUM(Snabn.Qty) AS ContainerReceivedQuantity, Snabn.ItemCode, Snabn.PONumber
				 FROM
					 (
						 SELECT SUM(abn.Qty) Qty, abn.ContainerID, abn.ItemCode, abn.PONumber
						 FROM dbo.tb_AccBoxNumber abn
						 WHERE abn.ItemCode = @Itemcode AND abn.PONumber = @PoNumber
						 GROUP BY abn.ContainerID, abn.ItemCode, abn.PONumber
						 UNION
						 SELECT COUNT(*) Qty, ise.ContainerID, ise.ItemCode, ise.PONumber
						 FROM dbo.tb_ItemSeriel ise
						 WHERE ise.ItemCode = @Itemcode AND ise.PONumber = @PoNumber
						 GROUP BY ise.ContainerID, ise.ItemCode, ise.PONumber
					 ) Snabn
					 JOIN inventory.Containers c ON c.ContainerID = Snabn.ContainerID
					 JOIN inventory.ContainerBay cb ON cb.ContainerID = c.ContainerID AND cb.Deleted = 0 AND cb.ContainerStatusID IN ( 1, 3 )
				 GROUP BY Snabn.ItemCode, Snabn.PONumber
			 ) crq ON pd.ItemCode = crq.ItemCode AND pd.PoNumber = crq.PONumber

		WHERE pd.ItemCode = @Itemcode AND pd.PoNumber = @PoNumber;
	END
    RETURN ISNULL(@QuantityNotReceivedOnPo,0);

END;





GO
/****** Object:  UserDefinedFunction [inventory].[PalletsToReturnFomDockingToOS]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Kalish, Benjamin>
-- Create date: <02-24-2020>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [inventory].[PalletsToReturnFomDockingToOS](@Pallet int = null)
RETURNS 
@ReturnVal TABLE 
(
	PalletID INT NULL,
	LocationFrom NVARCHAR(50) NULL,
    LocationTo NVARCHAR(50) NULL,
	LocationIdTo INT null
)
AS
BEGIN
	
	
	DECLARE @ItemBelowMin TABLE(ItemCode NVARCHAR(150) NULL, Location NVARCHAR(255) NULL, Quantity INT NOT NULL)
	DECLARE @ItemsToReturn TABLE(Location NVARCHAR(50) NULL, PalletID INT NULL, ItemCode VARCHAR(50),Sequence int);
	DECLARE @StagingLocationID INT,@ToOSLocationID INT,@StagingLocation NVARCHAR(50),@ToOSLocation NVARCHAR(50) ;
	DECLARE @PickDatesToFulfill INT,  @LatestPickDateToFulfill DATE
	SELECT TOP (1) @PickDatesToFulfill = CAST(gv.DefaultValue AS INT) FROM dbo.GPSVariables AS gv WHERE gv.VariableName = 'PickDaysAheadToBringFromOverstock' ORDER BY gv.DefaultValue
	SELECT @LatestPickDateToFulfill = apd.PickingDate FROM picking.AvailablePickingDates AS apd WHERE apd.PickingDate >= GETDATE()
	ORDER BY apd.PickingDate OFFSET @PickDatesToFulfill ROWS FETCH NEXT 1 ROWS ONLY
	
	SELECT TOP 1 @StagingLocation = il.Location ,@StagingLocationID = il.ID  FROM dbo.InventoryLocation AS il WHERE il.LocationType = 57
	SELECT TOP 1 @ToOSLocation = il.Location ,@ToOSLocationID = il.ID  FROM dbo.InventoryLocation AS il WHERE il.LocationType = 58


	BEGIN
	INSERT @ItemBelowMin(ItemCode, Location, Quantity)
	SELECT ildic.ItemCode, il.Location,  ISNULL(ilu.Qty,0) AS Quantity 
	FROM dbo.InventoryLocationDefaultItemCode AS ildic
	JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID AND il.IsPickable = 1 AND il.IsActive = 1
	OUTER APPLY(
	SELECT ISNULL(SUM(ilu.Quantity),0) AS Qty 
		FROM dbo.ItemLocationsUpdate AS ilu 
		WHERE ilu.ItemCode = ildic.ItemCode AND ilu.Location = il.Location) AS ILU
	WHERE ISNULL(ildic.MinThreshold,0) > 0 AND ILU.Qty < ildic.MinThreshold



		INSERT @ItemsToReturn( Location, PalletID,ItemCode,Sequence)
		SELECT pr.Location, pr.ID,pri.ItemCode, CASE WHEN qtyInBelt.Quantity < UnpickedItems.qty THEN 2 ELSE 1 end FROM dbo.PalletReceivingItems AS pri
		JOIN dbo.PalletReceiving AS pr ON pr.ID = pri.PalletID
		JOIN dbo.InventoryLocation AS il ON il.Location = pr.Location	
		OUTER APPLY(
		SELECT  COUNT(*)  AS qty
		FROM Picking.ProductionItem AS pi
		JOIN Picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi.ProductionItemId AND	pid.Deleted = 0
		JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
		WHERE 
		til.ShortItemCode = pri.ItemCode 
		and pid.Picked = 0 
		AND pi.Deleted = 0
		AND pi.Sandbox = 0
		AND (
				pi.OrderItemId IS NULL 
				OR EXISTS(SELECT 1 FROM dbo.TranEntry AS te
				JOIN dbo.[Order] AS o ON o.ID = te.OrderID
				JOIN dbo.Departmentstatus AS d ON d.ID = o.Departmentstatusid
				JOIN dbo.QuotesStatus AS qs ON o.SOnumber=qs.QuoteNumber
				WHERE o.isActive=1 AND o.CustomerName <> 'TEST ORDERS'
				AND qs.QuoteStatus ='SALES ORDER'
				AND d.isShipped = 0)
			)
		AND pi.PickingDate <= @LatestPickDateToFulfill
		)	UnpickedItems
		OUTER APPLY 
		(
		SELECT SUM( ISNULL(ilu.Qty,0)) AS Quantity 
			FROM dbo.InventoryLocationDefaultItemCode AS ildic
			JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID AND il.IsPickable = 1 AND il.IsActive = 1
			OUTER APPLY(
			SELECT ISNULL(SUM(ilu.Quantity),0) AS Qty 
				FROM dbo.ItemLocationsUpdate AS ilu 
				WHERE ilu.ItemCode = ildic.ItemCode AND ilu.Location = il.Location) AS ILU
			WHERE 
			ildic.ItemCode = pri.ItemCode
		)	qtyInBelt	 
		WHERE il.LocationType = 67 AND  EXISTS(SELECT * FROM  @ItemBelowMin AS pdfi WHERE pri.ItemCode = pdfi.ItemCode) 
		AND NOT EXISTS(SELECT * FROM inventory.StockRefillTask AS srt WHERE srt.StockRefillTaskTypeId = 2 AND srt.PalletId = pr.ID AND srt.Completed = 0)
		AND (@Pallet IS NULL OR pri.PalletID = @Pallet)
		

		INSERT @ReturnVal(  PalletID, LocationFrom,LocationTo,LocationIdTo)
		SELECT 
               iisa.PalletID,
			   iisa.Location,
			   CASE WHEN MAX(iisa.Sequence) = 2 THEN @StagingLocation ELSE @ToOSLocation END,
			   CASE WHEN MAX(iisa.Sequence) = 2 THEN @StagingLocationID ELSE @ToOSLocationID end 
			   FROM  @ItemsToReturn AS iisa 
			   GROUP BY iisa.PalletID,iisa.Location

	END


	RETURN 
END



GO
/****** Object:  UserDefinedFunction [picking].[BeltHasAllFramesForItem]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [picking].[BeltHasAllFramesForItem]
(
	@ProductionItemId INT
)
RETURNS BIT
AS 
BEGIN
	RETURN CAST
	(
		CASE WHEN NOT EXISTS
		(
			SELECT * FROM Picking.ProductionItemDetail AS pid
			JOIN Picking.ProductionItem AS pi ON pi.ProductionItemId = pid.ProductionItemId
			JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
			WHERE pid.ProductionItemId = @ProductionItemId
			AND pi.DestinationLocationId NOT IN(32, 33, 34, 35)
			AND til.ComponentPartTypeId IN (6, 8)
			AND pid.Deleted = 0
			AND NOT EXISTS
			(
				SELECT * FROM picking.StockRefillTaskProductionItems AS srtpi
					--commented out as per FF-559
				--CROSS APPLY
				--(
				--	SELECT tabn.ReceivedLocation FROM dbo.tb_AccBoxNumber AS tabn
				--	WHERE srtpi.ABNSN = tabn.ABNNumber
				--	UNION
				--	SELECT tis.ReceivedLocation FROM dbo.tb_ItemSeriel AS tis
				--	WHERE srtpi.ABNSN = tis.SerielID
				--)AS SnAbn
				--JOIN dbo.InventoryLocation AS il ON SnAbn.ReceivedLocation = il.Location
				--WHERE EXISTS
				--(
				--	SELECT rl.DestinationLocationId FROM inventory.RackWagonLocations AS rwl
				--	JOIN inventory.RackWagon AS rw ON rw.WagonId = rwl.WagonId
				--	JOIN picking.Rack AS r ON r.RackId = rw.RackId
				--	JOIN picking.RackLane AS rl ON rl.RackLaneId = r.RackLaneId
				--	WHERE rwl.LocationId = il.ID
				--	AND rwl.Active = 1
				--	AND rw.InRack = 1
				--	AND rl.DestinationLocationId = pi.DestinationLocationId
				--)
				WHERE srtpi.ProductionItemDetailId = pid.ProductionItemDetailId
				AND srtpi.Deleted = 0
				AND srtpi.PlacedInWagon = 1
			)
		)
		THEN 1 
		ELSE 0
		END AS BIT
	) 
END

GO
/****** Object:  UserDefinedFunction [picking].[GetAddonRulesForOrderItemId]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 7/3/2019
-- Description:	Get Addon Rules For Order ItemId
-- =============================================
CREATE FUNCTION [picking].[GetAddonRulesForOrderItemId]
(
	@orderItemId INT,
	@MaterialList OrderMaterialDetail READONLY
)
RETURNS @AddonRule TABLE
(
	AddonId INT NOT NULL,
	InventoryID VARCHAR(450) NOT NULL,
	AddonQty INT NOT NULL,
	RemoveAll BIT NOT NULL DEFAULT(0),
	QtyToRemove INT NOT NULL DEFAULT(0),
	MaterialToRemove VARCHAR(450) NULL,
	WorkCenter VARCHAR(50),
	Backflush BIT ,
	AddonMinutes DECIMAL(10,2)
)
AS
BEGIN


WITH AddON
AS (SELECT te.OrderID, il.ID AS AddonId, COUNT(*) AS Qty
    FROM dbo.TranEntry te
        JOIN dbo.TranEntry te2 ON te2.OrderID = te.OrderID AND te.EZProdID = te2.EZParentProdID AND te2.isDeleted = 0 AND( te.EZProdSubID = te2.EZProdSubID OR te2.ItemNumber NOT IN ( 'ACCESSORIES:LST33', 'ACCESSORIES:LST36' ))
        JOIN dbo.tb_ItemList il ON il.ItemCode = te2.ItemNumber
    WHERE te.ID = @OrderItemId AND te2.ItemType IN ( 7 )
	AND ( te2.ItemNumber NOT IN ( 'ACCESSORIES:LST33', 'ACCESSORIES:LST36' ) OR EXISTS (SELECT * FROM picking.OrderItemProductionItemIRelease AS oipiir WHERE oipiir.OrderItemId=te.ID AND oipiir.Revision='A')	) 
    GROUP BY il.ID, te.OrderID
   )
   INSERT @AddonRule (AddonId,InventoryID, AddonQty, RemoveAll, QtyToRemove, MaterialToRemove, WorkCenter, Backflush,AddonMinutes )
SELECT il.ID, il.AcumaticaName AS InventoryId, AddON.Qty AS AddonQty, COALESCE(mtr.RemoveAll,0),
    CASE 
		WHEN mtr.RemoveComponentPartTypeId IS NULL THEN 0 
		WHEN mtr.RemoveAll = 1 THEN AddON.Qty 
		WHEN mtr.RemovePerUnit = 1 AND AddON.Qty >= mtr.AddonQtyAndAboveRemove THEN (AddON.Qty - (mtr.AddonQtyAndAboveRemove - 1)) * mtr.RemovePerUnit 
		ELSE 0 
	END QtyToRemove, mtr.MaterialToRemove , 'PICKING',
	CASE WHEN AddON.OrderID IS NOT NULL THEN 0 ELSE 1 END ,ISNULL(addOnMinutes.Minutes,0)
FROM AddON
    JOIN dbo.tb_ItemList il ON il.ID = AddON.AddonId
     
	LEFT JOIN dbo.ProductionWorkCenter pwc ON pwc.ProductionWorkcenterId = 7
	OUTER APPLY (
		SELECT ml.InventoryID AS MaterialToRemove , arm.RemoveAll, arm.RemovePerUnit, arm.RemoveComponentPartTypeId, arm.AddonQtyAndAboveRemove FROM @MaterialList ml JOIN dbo.tb_ItemList mii ON mii.AcumaticaName=ml.InventoryID
		JOIN inventory.ComponentPartType cpt ON cpt.ComponentPartTypeId = mii.ComponentPartTypeId 
		JOIN picking.ProductionItemAddonRule arm ON arm.AddonId = AddON.AddonId AND arm.RemoveComponentPartTypeId=cpt.ComponentPartTypeId-- AND 1=2
	) mtr
	OUTER APPLY 
	(
	   SELECT TOP 1 aom.Minutes FROM dbo.AddonOperationMinutes AS aom 
	   WHERE aom.ItemListID = AddON.AddonId AND aom.AddonQty = AddON.Qty AND aom.DeleteFlag = 0
	)addOnMinutes
	

	RETURN
END





GO
/****** Object:  UserDefinedFunction [picking].[GetAssembledPickingTaskDetailId]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 11/6/2018
-- Description:	GetAssembledPickingTaskDetailId
-- =============================================
CREATE FUNCTION [picking].[GetAssembledPickingTaskDetailId]
(
	@PickingTaskDetailIds IDList READONLY,
	@Serial VARCHAR(50) 
)
RETURNS INT
AS
BEGIN
	DECLARE @PickingTaskDetailId INT = NULL 
	
	SELECT TOP 1  @PickingTaskDetailId = ptd.PickingTaskDetailId
	FROM picking.PickingTaskDetail ptd
		JOIN dbo.TranEntry te ON te.ID = ptd.ItemId
		JOIN dbo.tb_ItemSeriel ise ON ise.SerielID = @Serial
	WHERE ptd.PickingTaskDetailId IN(SELECT ID FROM @PickingTaskDetailIds)
		  AND (ISNULL(ise.Hinge, 'N') = ISNULL(te.Hinge, 'N') OR NOT EXISTS(SELECT 1 FROM dbo.tb_itemClassDetail icd WHERE icd.ClassID = 115 AND icd.ItemCode = ise.ItemCode))
		  AND ise.Assembled = 1 AND ise.Received = 1 AND ise.DeleteFlag = 0 AND ptd.Picked = 0 AND ptd.Active = 1 AND ptd.AvailableToPick =1
	ORDER BY CASE WHEN ISNULL(ise.Hinge, 'N') = ISNULL(te.Hinge, 'N') THEN 0 ELSE 1 END, ptd.PickingTaskDetailId;

	RETURN @PickingTaskDetailId

END

GO
/****** Object:  UserDefinedFunction [picking].[GetBOMAdditionsForOrderItemId]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Yakov Muller
-- Create date: 6/26/2019
-- Description:	Get BOM Additions For Order ItemId
-- =============================================

CREATE FUNCTION [picking].[GetBOMAdditionsForOrderItemId]
(
    @orderItemId INT
)
RETURNS @BOMAdditions TABLE
(
    ProductionItemConfigRuleDetailId INT,
    PartItemlistId INT,
    InventoryID VARCHAR(450),
    Quantity INT,
    ProductionWorkcenterId INT,
    WorkCenter VARCHAR(50),
    OperationDescription VARCHAR(1000),
    OperationNumber VARCHAR(25),
	RunTime DECIMAL (18,2)
)
AS
BEGIN
    DECLARE @InQ13 BIT = 0;
    DECLARE @OrigOrderNumber NVARCHAR(50) = N'';

    SELECT @OrigOrderNumber = SUBSTRING(te.OrderIdentity, 0, LEN(te.OrderIdentity) - 1)
    FROM dbo.TranEntry AS te
    WHERE te.ID = @orderItemId;

    DECLARE @orderId INT = 0;

    SELECT TOP(1)@orderId = te.OrderID
    FROM dbo.TranEntry AS te
    WHERE te.ID = @orderItemId;

    SELECT @InQ13 = dbo.IsInQ13Rules(@orderItemId);

    DECLARE @Rmas TABLE
    (
        SoNumber VARCHAR(50)
    );

    INSERT @Rmas
    (
        SoNumber
    )
    SELECT gon.soNumber
    FROM [dbo].[fc_GetOrderNumberFromRMA](@orderId) AS gon;

    INSERT @BOMAdditions
    (
        ProductionItemConfigRuleDetailId,
        PartItemlistId,
        InventoryID,
        Quantity,
        ProductionWorkcenterId,
        WorkCenter,
        OperationDescription,
        OperationNumber,
		RunTime
    )
    SELECT 0,
    TILSkin.ID,
	TILSkin.AcumaticaName,
    Skins.Qty,
    Skins.ProductionWorkcenterId,
    Skins.WorkCenter,
    Skins.Description,
    Skins.OperationNumber,
	til.SkinMinutes
    FROM dbo.TranEntry AS TE
    JOIN dbo.tb_ItemList AS TIL ON TIL.ItemCode = TE.ItemNumber
    JOIN inventory.DoorStyles AS DS ON DS.DoorStyleID = TIL.DoorStyleID
    JOIN inventory.Products AS P2 ON P2.ProductID = TIL.ProductID
    LEFT JOIN picking.OrderItemProductionItemIRelease AS OIPIIR ON OIPIIR.OrderItemId = TE.ID
    OUTER APPLY
    (
        SELECT CAST(1 AS BIT) HasCustomFinish WHERE EXISTS(SELECT * 
        FROM dbo.TranEntry AS TEsub
        JOIN dbo.tb_ItemList AS til ON til.ItemCode = TEsub.ItemNumber
        WHERE TEsub.OrderID = TE.OrderID
        AND TEsub.EZParentProdID = TE.EZProdID
        AND TEsub.isDeleted = 0
        AND TEsub.isActive = 1
        AND til.ID IN (106973))
    ) AS CustomFinishMod
    CROSS APPLY
    (
        SELECT COALESCE(BARP.OverrideQty, CASE WHEN te.Finish = 'BOTH' AND barp.FinishBothOverrideProductId IS NOT NULL THEN 1 ELSE NULL END, BARC.QuantityToAdd) Qty,
        ASI.Name SkinItemId,
		AdjustedSideSkin.SkinName AS AdjustedSideSkinItemId,
		ISNULL(AdjustedSideSkin.SkinItemListId, TIL2.ID) AS PartItemlistId,
        pwc.ProductionWorkcenterId,
        pwc.WorkCenter,
        pwc.Description,
        BAR.OperationNumber
        FROM inventory.Products AS P
        JOIN picking.BomAdditionRuleProduct AS BARP ON BARP.ProductId = P.ProductID AND BARP.Active = 1
        JOIN picking.BomAdditionRuleCondition AS BARC ON BARC.BomAdditionRuleId = BARP.BomAdditionRuleId
        JOIN picking.BomAdditionRule AS BAR ON BAR.BomAdditionRuleId = BARP.BomAdditionRuleId AND BAR.Active = 1
        JOIN dbo.ProductionWorkCenter AS pwc ON pwc.ProductionWorkcenterId = BAR.ProductionWorkCenterId
		JOIN inventory.AcumaticaStockItems AS ASI ON 
				CASE WHEN te.Finish = 'BOTH' AND barp.FinishBothOverrideProductId IS NOT NULL 
					 THEN barp.FinishBothOverrideProductId 
				ELSE BAR.AddAcumaticaProductId END = ASI.AcumaticaProductID 
		JOIN dbo.tb_ItemList TIL2 ON til2.AcumaticaID = ASI.AcumaticaID
		LEFT JOIN dbo.tb_AdjustedBoxDimensions AS tabd ON tabd.TranEntryID = TE.ID
			AND 
			(
				tabd.AdjustHeight <> 0
				OR tabd.AdjustDepth <> 0
			)
		OUTER APPLY
		(
			SELECT * FROM dbo.GetAdjustedSkin(@orderItemId) AS gas
		)AS AdjustedSideSkin
        WHERE P.ProductID = P2.ProductID
        AND ASI.Color = CASE WHEN CustomFinishMod.HasCustomFinish = 1 THEN 'unfinished'
                             ELSE DS.Color
                        END
        AND TE.Finish = BARC.ConditionValue
		AND (tabd.ID IS NULL OR AdjustedSideSkin.SkinName IS NOT NULL)
    ) AS Skins
    JOIN dbo.tb_ItemList TILSkin ON ISNULL(Skins.AdjustedSideSkinItemId, Skins.SkinItemId) = TILSkin.AcumaticaName
    WHERE TE.ID = @orderItemId
    AND TE.KD = 0
    AND
    (
        OIPIIR.Revision NOT IN ('A', 'FG')
		OR
		(
			@InQ13 = 1
			AND EXISTS
			(
				SELECT *
				FROM dbo.ItemsQ13Process AS iqp
				WHERE TIL.DoorStyleID = iqp.DoorStyleId
				AND iqp.GetsSideSkin = 1
				AND GETDATE() > iqp.SideSkinAffectiveDate
				AND NOT EXISTS
				(
					SELECT *
					FROM dbo.[Order] AS o --linked orders
					WHERE(
							 o.SOnumber = @OrigOrderNumber
						 OR  EXISTS
					(
						SELECT *
						FROM @Rmas AS r
						WHERE r.SoNumber = o.SOnumber
					)
						 )
					AND o.Addtime < iqp.SideSkinAffectiveDate
					AND iqp.BaseRulesOnOrderDate = 1
				)
			)
		)
    );


	UPDATE BA SET BA.RunTime = 
	CASE WHEN Pantry.IsPantry = 1 AND ba.Quantity = 2 THEN ba.RunTime * 2
	WHEN ba.Quantity = 2 THEN BA.RunTime * 1.5 
	ELSE ba.RunTime
	END
	FROM @bomAdditions BA
	OUTER APPLY(
	SELECT 1 IsPantry FROM dbo.TranEntry TE
	JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
	JOIN inventory.ProductToProductTags PTPT ON PTPT.ProductId = til.ProductID 
	AND PTPT.ProductTagId = 97 AND PTPT.DeleteFlag = 0
	WHERE TE.ID = @orderItemId) Pantry

    RETURN;
END;






GO
/****** Object:  UserDefinedFunction [picking].[GetBOMAdditionsForOrderitemid_test]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 6/26/2019
-- Description:	Get BOM Additions For Order ItemId
-- =============================================
CREATE FUNCTION [picking].[GetBOMAdditionsForOrderitemid_test]
(
	@orderItemId INT
)
RETURNS @BOMAdditions TABLE
(
	ProductionItemConfigRuleDetailId INT,
	PartItemlistId INT,
	InventoryID VARCHAR(450),
	Quantity INT,
	ProductionWorkcenterId INT,
	WorkCenter VARCHAR(50),
	OperationDescription VARCHAR(1000),
	OperationNumber VARCHAR(25),
	RunTime DECIMAL(18,2)
)
AS
BEGIN
	
	DECLARE @InQ13 BIT = 0
	DECLARE @OrigOrderNumber NVARCHAR(50) = ''
	SELECT @OrigOrderNumber  = SUBSTRING(te.OrderIdentity,0, LEN(te.OrderIdentity)-1) FROM dbo.TranEntry AS te WHERE te.ID = @orderItemId
	DECLARE @orderId INT =  0
	SELECT  TOP (1) @orderId = te.OrderID FROM dbo.TranEntry AS te WHERE te.ID = @orderItemId
	SELECT @InQ13 = dbo.IsInQ13Rules(@orderItemId)
	DECLARE @Rmas TABLE(SoNumber VARCHAR(50))
	INSERT @Rmas(SoNumber)
	SELECT gon.soNumber FROM [dbo].[fc_GetOrderNumberFromRMA](@orderId) gon

	INSERT @BOMAdditions ( ProductionItemConfigRuleDetailId, PartItemlistId, InventoryID, Quantity, ProductionWorkcenterId, WorkCenter, OperationDescription, OperationNumber, RunTime )

	SELECT 0,TIL2.ID, TIL2.AcumaticaName,

	Skins.Qty, Skins.ProductionWorkcenterId, Skins.WorkCenter,Skins.Description,Skins.OperationNumber,TIL.SkinMinutes
	FROM dbo.TranEntry TE 
	JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
	JOIN inventory.DoorStyles DS ON DS.DoorStyleID = TIL.DoorStyleID
	JOIN inventory.Products P2 ON P2.ProductID = TIL.ProductID
	LEFT JOIN picking.OrderItemProductionItemIRelease OIPIIR ON oipiir.OrderItemId = TE.ID
	OUTER APPLY (SELECT cast (1 AS BIT) HasCustomFinish  FROM  dbo.TranEntry TEsub 
				 JOIN dbo.tb_ItemList AS til ON til.ItemCode = TEsub.ItemNumber
				 WHERE TEsub.OrderID = te.OrderID AND TEsub.EZParentProdID = te.EZProdID AND TEsub.isDeleted = 0 AND TEsub.isActive = 1
				 AND til.ID IN (106973)) CustomFinishMod

	OUTER APPLY (SELECT cast (1 AS BIT) HasTkRule  FROM  dbo.TranEntry TEsub 
			     JOIN dbo.tb_ItemList AS til ON til.ItemCode = TEsub.ItemNumber
				 WHERE TEsub.OrderID = te.OrderID AND TEsub.EZParentProdID = te.EZProdID AND TEsub.isDeleted = 0 AND TEsub.isActive = 1
				 AND til.ID IN (106894, 133843)) TkRule

	CROSS APPLY(SELECT COALESCE( BARP.OverrideQty, BARC.QuantityToAdd) Qty, ASI.Name SkinItemId, ASILrg.Name LargeSkinItemId, pwc.ProductionWorkcenterId, pwc.WorkCenter, pwc.Description, BAR.OperationNumber
				FROM  inventory.Products P 
				JOIN picking.BomAdditionRuleProduct BARP ON BARP.ProductId = p.ProductID
				JOIN picking.BomAdditionRuleCondition BARC ON BARC.BomAdditionRuleId = BARP.BomAdditionRuleId
				JOIN picking.BomAdditionRule BAR ON BAR.BomAdditionRuleId = BARP.BomAdditionRuleId
				JOIN dbo.ProductionWorkCenter pwc ON pwc.ProductionWorkcenterId = bar.ProductionWorkcenterId
				JOIN inventory.AcumaticaStockItems ASI ON asi.AcumaticaProductID = BAR.AddAcumaticaProductId
				LEFT JOIN inventory.AcumaticaStockItems ASILrg ON asilrg.AcumaticaProductID = BAR.LargeSkinAcumaticaProductId AND ASI.Color = ASILrg.Color
				WHERE p.ProductID = p2.ProductID AND ASI.Color = CASE WHEN CustomFinishMod.HasCustomFinish = 1 THEN 'unfinished' ELSE  ds.Color END AND te.Finish = BARC.ConditionValue
				) Skins

	JOIN dbo.tb_ItemList TIL2 ON til2.AcumaticaName = CASE WHEN TkRule.HasTkRule = 1 AND Skins.LargeSkinItemId IS NOT NULL THEN Skins.LargeSkinItemId ELSE Skins.SkinItemId end
	WHERE te.ID =  @orderItemId AND te.KD = 0 
	AND
	(
		OIPIIR.Revision NOT IN ('A','FG')
		OR 
		(
			@InQ13 = 1 
			AND EXISTS 
			(
				SELECT * FROM dbo.ItemsQ13Process AS iqp 
				WHERE TIL.DoorStyleID = iqp.DoorStyleId 
				AND iqp.GetsSideSkin = 1 
				AND GETDATE() > iqp.SideSkinAffectiveDate
				AND NOT EXISTS
				(
					SELECT * FROM dbo.[Order] AS o --linked orders
					WHERE  (
								o.SOnumber = @OrigOrderNumber 
								OR
								EXISTS(SELECT * FROM @Rmas AS r  WHERE r.soNumber = o.SOnumber)
							)
					AND o.Addtime < iqp.SideSkinAffectiveDate 
					AND iqp.BaseRulesOnOrderDate = 1
				)
			)
		)
	)
	
	UPDATE BA SET BA.RunTime = 
	CASE WHEN Pantry.IsPantry = 1 AND ba.Quantity = 2 THEN ba.RunTime * 2
	WHEN ba.Quantity = 2 THEN BA.RunTime * 1.5 
	ELSE ba.RunTime
	END
	FROM @bomAdditions BA
	OUTER APPLY(
	SELECT 1 IsPantry FROM dbo.TranEntry TE
	JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
	JOIN inventory.ProductToProductTags PTPT ON PTPT.ProductId = til.ProductID 
	AND PTPT.ProductTagId = 97 AND PTPT.DeleteFlag = 0
	WHERE TE.ID = @orderItemId) Pantry

	RETURN
END















GO
/****** Object:  UserDefinedFunction [picking].[GetBOMAdditionsForOrderItemIdStaging]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Yakov Muller
-- Create date: 6/26/2019
-- Description:	Get BOM Additions For Order ItemId
-- =============================================

CREATE FUNCTION [picking].[GetBOMAdditionsForOrderItemIdStaging]
(
    @orderItemId INT
)
RETURNS @BOMAdditions TABLE
(
    ProductionItemConfigRuleDetailId INT,
    PartItemlistId INT,
    InventoryID VARCHAR(450),
    Quantity INT,
    ProductionWorkcenterId INT,
    WorkCenter VARCHAR(50),
    OperationDescription VARCHAR(1000),
    OperationNumber VARCHAR(25),
	RunTime DECIMAL (18,2)
)
AS
BEGIN
    DECLARE @InQ13 BIT = 0;
    DECLARE @OrigOrderNumber NVARCHAR(50) = N'';

    SELECT @OrigOrderNumber = SUBSTRING(te.OrderIdentity, 0, LEN(te.OrderIdentity) - 1)
    FROM dbo.TranEntry AS te
    WHERE te.ID = @orderItemId;

    DECLARE @orderId INT = 0;

    SELECT TOP(1)@orderId = te.OrderID
    FROM dbo.TranEntry AS te
    WHERE te.ID = @orderItemId;

    SELECT @InQ13 = dbo.IsInQ13Rules(@orderItemId);

    DECLARE @Rmas TABLE
    (
        SoNumber VARCHAR(50)
    );

    INSERT @Rmas
    (
        SoNumber
    )
    SELECT gon.soNumber
    FROM [dbo].[fc_GetOrderNumberFromRMA](@orderId) AS gon;

    INSERT @BOMAdditions
    (
        ProductionItemConfigRuleDetailId,
        PartItemlistId,
        InventoryID,
        Quantity,
        ProductionWorkcenterId,
        WorkCenter,
        OperationDescription,
        OperationNumber,
		RunTime
    )
    SELECT 0,
    TILSkin.ID,
	TILSkin.AcumaticaName,
    Skins.Qty,
    Skins.ProductionWorkcenterId,
    Skins.WorkCenter,
    Skins.Description,
    Skins.OperationNumber,
	til.SkinMinutes
    FROM dbo.TranEntry AS TE
    JOIN dbo.tb_ItemList AS TIL ON TIL.ItemCode = TE.ItemNumber
    JOIN inventory.DoorStyles AS DS ON DS.DoorStyleID = TIL.DoorStyleID
    JOIN inventory.Products AS P2 ON P2.ProductID = TIL.ProductID
    LEFT JOIN picking.OrderItemProductionItemIRelease AS OIPIIR ON OIPIIR.OrderItemId = TE.ID
    OUTER APPLY
    (
        SELECT CAST(1 AS BIT) HasCustomFinish
        FROM dbo.TranEntry AS TEsub
        JOIN dbo.tb_ItemList AS til ON til.ItemCode = TEsub.ItemNumber
        WHERE TEsub.OrderID = TE.OrderID
        AND TEsub.EZParentProdID = TE.EZProdID
        AND TEsub.isDeleted = 0
        AND TEsub.isActive = 1
        AND til.ID IN (106973)
    ) AS CustomFinishMod
    CROSS APPLY
    (
        SELECT COALESCE(BARP.OverrideQty, CASE WHEN te.Finish = 'BOTH' AND barp.FinishBothOverrideProductId IS NOT NULL THEN 1 ELSE NULL END, BARC.QuantityToAdd) Qty,
        ASI.Name SkinItemId,
		AdjustedSideSkin.SkinName AS AdjustedSideSkinItemId,
		ISNULL(AdjustedSideSkin.SkinItemListId, TIL2.ID) AS PartItemlistId,
        pwc.ProductionWorkcenterId,
        pwc.WorkCenter,
        pwc.Description,
        BAR.OperationNumber
        FROM inventory.Products AS P
        JOIN picking.BomAdditionRuleProduct AS BARP ON BARP.ProductId = P.ProductID AND BARP.Active = 1
        JOIN picking.BomAdditionRuleCondition AS BARC ON BARC.BomAdditionRuleId = BARP.BomAdditionRuleId
        JOIN picking.BomAdditionRule AS BAR ON BAR.BomAdditionRuleId = BARP.BomAdditionRuleId AND BAR.Active = 1
        JOIN dbo.ProductionWorkCenter AS pwc ON pwc.ProductionWorkcenterId = BAR.ProductionWorkCenterId
		JOIN inventory.AcumaticaStockItems AS ASI ON 
				CASE WHEN te.Finish = 'BOTH' AND barp.FinishBothOverrideProductId IS NOT NULL 
					 THEN barp.FinishBothOverrideProductId 
				ELSE BAR.AddAcumaticaProductId END = ASI.AcumaticaProductID 
		JOIN dbo.tb_ItemList TIL2 ON til2.AcumaticaID = ASI.AcumaticaID
		LEFT JOIN dbo.tb_AdjustedBoxDimensions AS tabd ON tabd.TranEntryID = TE.ID
			AND 
			(
				tabd.AdjustHeight <> 0
				OR tabd.AdjustDepth <> 0
			)
		OUTER APPLY
		(
			SELECT * FROM dbo.GetAdjustedSkin(@orderItemId) AS gas
		)AS AdjustedSideSkin
        WHERE P.ProductID = P2.ProductID
        AND ASI.Color = CASE WHEN CustomFinishMod.HasCustomFinish = 1 THEN 'unfinished'
                             ELSE DS.Color
                        END
        AND TE.Finish = BARC.ConditionValue
		AND (tabd.ID IS NULL OR AdjustedSideSkin.SkinName IS NOT NULL)
    ) AS Skins
    JOIN dbo.tb_ItemList TILSkin ON ISNULL(Skins.AdjustedSideSkinItemId, Skins.SkinItemId) = TILSkin.AcumaticaName
    WHERE TE.ID = @orderItemId
    AND TE.KD = 0
    AND
    (
        OIPIIR.Revision NOT IN ('A', 'FG')
		OR
		(
			@InQ13 = 1
			AND EXISTS
			(
				SELECT *
				FROM dbo.ItemsQ13Process AS iqp
				WHERE TIL.DoorStyleID = iqp.DoorStyleId
				AND iqp.GetsSideSkin = 1
				AND GETDATE() > iqp.SideSkinAffectiveDate
				AND NOT EXISTS
				(
					SELECT *
					FROM dbo.[Order] AS o --linked orders
					WHERE(
							 o.SOnumber = @OrigOrderNumber
						 OR  EXISTS
					(
						SELECT *
						FROM @Rmas AS r
						WHERE r.SoNumber = o.SOnumber
					)
						 )
					AND o.Addtime < iqp.SideSkinAffectiveDate
					AND iqp.BaseRulesOnOrderDate = 1
				)
			)
		)
    );


	UPDATE BA SET BA.RunTime = 
	CASE WHEN Pantry.IsPantry = 1 AND ba.Quantity = 2 THEN ba.RunTime * 2
	WHEN ba.Quantity = 2 THEN BA.RunTime * 1.5 
	ELSE ba.RunTime
	END
	FROM @bomAdditions BA
	OUTER APPLY(
	SELECT 1 IsPantry FROM dbo.TranEntry TE
	JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
	JOIN inventory.ProductToProductTags PTPT ON PTPT.ProductId = til.ProductID 
	AND PTPT.ProductTagId = 97 AND PTPT.DeleteFlag = 0
	WHERE TE.ID = @orderItemId) Pantry

    RETURN;
END;





GO
/****** Object:  UserDefinedFunction [picking].[GetBOMAdjustmentsForMods]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
 --=============================================
 --Author:		Yakov Muller
 --Create date: 8/23/2019
 --Description:	Get Custom Finish Rules For OrderItemId
 --=============================================
CREATE FUNCTION [picking].[GetBOMAdjustmentsForMods]
(
	@orderItemId INT,
	@MaterialList OrderMaterialDetail READONLY,
	@bomRevision VARCHAR(1) = 'C'
)

--DECLARE @ProductionItemCode VARCHAR(50) = NULL,@MaterialList   dbo.OrderMaterialDetail  , @bomRevision VARCHAR(50), 
--@OrderItemId INT = 14517061
--SELECT @ProductionItemCode = il.AcumaticaName , @bomRevision= oipiir.revision FROM picking.OrderItemProductionItemIRelease oipiir
--JOIN dbo.TranEntry te ON te.ID = oipiir.OrderItemId
--JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
--WHERE te.ID = @OrderItemId
--INSERT @MaterialList ( InventoryID, Quantity )
--SELECT bomd.InventoryID, bomd.QtyRequired FROM acumaticaManufacturing.BillOfMaterials bom
--JOIN acumaticaManufacturing.BillOfMaterialDetails bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = bom.DeleteFlag AND bom.DeleteFlag=0  
--WHERE bom.InventoryID=@ProductionItemCode AND bom.Revision=@bomRevision

RETURNS @AddremoveRules TABLE 
(
	RuleId INT NULL,
	AddRemoveAction VARCHAR(10),
	InventoryId VARCHAR(50),
	Quantity INT DEFAULT(1),
	QuantityAll BIT DEFAULT(0),
	WorkCenter VARCHAR(50) DEFAULT ('PICKING'),
	OperationDescription VARCHAR(400),
	OperationNumber VARCHAR(10),
	Backflush BIT DEFAULT(1),
	PartType INT,
	FunctionPart VARCHAR(250),
	AddonMinutes DECIMAL(10, 2) NULL,
	GroupId INT NULL 
)

AS BEGIN
	DECLARE @SubItem TABLE(MainItemListId INT NOT NULL, SubItemListId INT NOT NULL, MainProductId INT NULL, SubProductId INT NULL, IsAddOn BIT NOT NULL, SubItemType INT NULL,
		MainProductCode VARCHAR(50) NULL, SubProductCode VARCHAR(50) NULL, MainDoorStyleId INT NULL, HasCustomizing BIT NULL, MainAcumaticaProductId INT NULL, 
		SubAcumaticaProductId INT NULL, SubShortItemCode NVARCHAR(150) NOT NULL
	)
	INSERT @SubItem	(MainItemListId, SubItemListId, MainProductId, SubProductId, IsAddOn, SubItemType, MainProductCode, SubProductCode, MainDoorStyleId, HasCustomizing, 
	MainAcumaticaProductId, SubAcumaticaProductId, SubShortItemCode)
	SELECT tilM.ID, tilS.ID, tilM.ProductID, tilS.ProductID, iao.IsAddOn, tilS.ItemTypeCode, pMain.ProductCode, pSub.ProductCode, tilM.DoorStyleID, te.HasCustomizing,
	asiM.AcumaticaProductID, asiS.AcumaticaProductID, tilS.ShortItemCode
	FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS tilM ON tilM.ItemCode = te.ItemNumber
	LEFT JOIN inventory.AcumaticaStockItems AS asiM ON asiM.AcumaticaID = tilM.AcumaticaID
	LEFT JOIN inventory.Products AS pMain ON pMain.ProductID = tilM.ProductID
	JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID AND te.EZProdID = te2.EZParentProdID
	JOIN dbo.tb_ItemList AS tilS ON tilS.ItemCode = te2.ItemNumber
	LEFT JOIN inventory.AcumaticaStockItems AS asiS ON asiS.AcumaticaID = tilS.AcumaticaID
	LEFT JOIN inventory.Products AS pSub ON pSub.ProductID = tilS.ProductID
	CROSS APPLY
	(
		SELECT CAST
		(
			CASE WHEN 
				tilS.ItemTypeCode = 7 
				AND te2.ItemNumber NOT IN ('ACCESSORIES:LST33', 'ACCESSORIES:LST36')
			THEN 1 
			ELSE 0 
			END AS BIT
		)
	)AS iao(IsAddOn)
	WHERE te.ID = @orderItemId
	AND te2.isDeleted = 0

	DECLARE @OrderItemConfig TABLE(ConfigKey VARCHAR(4000)NULL, ConfigValue VARCHAR(4000) NULL)
	INSERT @OrderItemConfig(ConfigKey, ConfigValue)
	SELECT goict.ConfigKey, goict.ConfigValue FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict

	DECLARE @AddonRule TABLE(AddonId INT NOT NULL, InventoryID VARCHAR(450) NOT NULL, AddonQty INT NOT NULL, RemoveAll BIT NOT NULL DEFAULT(0), QtyToRemove INT NOT NULL DEFAULT(0),
	MaterialToRemove VARCHAR(450) NULL, WorkCenter VARCHAR(50), Backflush BIT, AddonMinutes DECIMAL(10, 2), ComponentPartTypeId INT, RemoveComponentPartTypeId INT);
	WITH AddON AS
	(
		SELECT sim.SubItemListId AS AddonId, COUNT(*) AS Qty
		FROM @SubItem AS sim
		WHERE sim.IsAddOn = 1
		GROUP BY sim.SubItemListId
	)
	INSERT @AddonRule (AddonId, InventoryID, AddonQty, RemoveAll, QtyToRemove, MaterialToRemove, WorkCenter, Backflush, AddonMinutes, ComponentPartTypeId, RemoveComponentPartTypeId)
	SELECT il.ID,
	il.AcumaticaName AS InventoryId,
	AddON.Qty AS AddonQty,
	COALESCE(mtr.RemoveAll, 0),
	CASE 
			WHEN mtr.RemoveComponentPartTypeId IS NULL THEN 0
			WHEN mtr.RemoveAll = 1 THEN AddON.Qty
			WHEN mtr.RemovePerUnit = 1 AND AddON.Qty >= mtr.AddonQtyAndAboveRemove THEN (AddON.Qty - (mtr.AddonQtyAndAboveRemove - 1)) * mtr.RemovePerUnit 
			ELSE 0 
	END QtyToRemove,
	mtr.MaterialToRemove,
	'PICKING',
	0,
	ISNULL(addOnMinutes.Minutes, 0),
	il.ComponentPartTypeId,
	mtr.RemoveComponentPartTypeId
	FROM AddON
	JOIN dbo.tb_ItemList AS il ON il.ID = AddON.AddonId
	LEFT JOIN dbo.ProductionWorkCenter AS pwc ON pwc.ProductionWorkcenterId = 7
	OUTER APPLY
	(
		SELECT ml.InventoryID AS MaterialToRemove,
		arm.RemoveAll,
		arm.RemovePerUnit,
		arm.RemoveComponentPartTypeId,
		arm.AddonQtyAndAboveRemove
		FROM @MaterialList AS ml
		JOIN dbo.tb_ItemList AS mii ON mii.AcumaticaName = ml.InventoryID
		JOIN inventory.ComponentPartType AS cpt ON cpt.ComponentPartTypeId = mii.ComponentPartTypeId
		JOIN picking.ProductionItemAddonRule AS arm ON arm.AddonId = AddON.AddonId
			AND arm.RemoveComponentPartTypeId = cpt.ComponentPartTypeId
	) AS mtr
	OUTER APPLY
	(
		SELECT TOP 1 aom.Minutes
		FROM dbo.AddonOperationMinutes AS aom
		WHERE aom.ItemListID = AddON.AddonId
		AND aom.AddonQty = AddON.Qty
		AND aom.DeleteFlag = 0
	) AS addOnMinutes

	IF @bomRevision IN( 'A', 'FG')
		RETURN

	INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, AddonMinutes, Backflush, PartType, FunctionPart) --AddOns
	SELECT 'Add', ar.InventoryID, 0, ar.AddonQty, ar.WorkCenter, ar.AddonMinutes, ar.Backflush, ar.ComponentPartTypeId, 'AddOns'
	FROM @AddonRule AS ar
	UNION ALL
	SELECT 'Remove', ar.MaterialToRemove, ar.RemoveAll, ar.QtyToRemove, ar.WorkCenter, NULL, Backflush, ar.RemoveComponentPartTypeId, 'Addon Remove Shelves'  
	FROM @AddonRule AS ar
	WHERE ar.MaterialToRemove IS NOT NULL
	AND ar.QtyToRemove > 0

	DECLARE @BasicItemInfo TABLE(DoorStyleID INT NULL, ProductCode VARCHAR(50) NULL, ProductID INT NULL, HasCustomizing BIT NULL, 
		AcumeticaId INT NULL, ItemTypeId INT NULL, EZProdID VARCHAR(25) NULL)
	INSERT @BasicItemInfo(DoorStyleID, ProductCode, ProductID, HasCustomizing, AcumeticaId, ItemTypeId, EZProdID)
	SELECT til.DoorStyleID, p.ProductCode, til.ProductID, te.HasCustomizing, til.AcumaticaID, til.ItemTypeCode, te.EZProdID
	FROM dbo.TranEntry AS te 
	JOIN dbo.tb_ItemList AS til ON te.ItemNumber = til.ItemCode
	JOIN inventory.Products AS p ON p.ProductID = til.ProductID
	WHERE te.ID = @orderItemId

	DECLARE @Rules TABLE(RuleId INT NOT NULL, GroupId INT NULL, ComponentPartTypeId INT NULL, ActionType VARCHAR(50) NOT NULL, CausingSubItemType INT NULL);

	WITH Rules AS
	(
		SELECT pimarr.*, Cause.SubItemType AS CauseSubItemType, mtarrd.ModificationToAddRemoveRuleDetailId,
		mtarrd.ModificationToAddRemoveRuleHeaderId, mtarrd.ToCancelOtherInGroup, Cause.MainDoorStyleId, Cause.MainProductId, Cause.MainProductCode
		FROM picking.ProductionItemModifcationAddRemoveRules AS pimarr
		JOIN picking.ModificationToAddRemoveRuleHeader AS mtarrh ON mtarrh.ProductionItemModifcationAddRemoveRuleId = pimarr.ProductionItemModifcationAddRemoveRuleId
		JOIN picking.ModificationToAddRemoveRuleDetail AS mtarrd ON mtarrd.ModificationToAddRemoveRuleHeaderId = mtarrh.ModificationToAddRemoveRuleHeaderId
		CROSS APPLY
		(
			SELECT si.MainDoorStyleId, si.MainProductCode, si.MainProductId, si.HasCustomizing, si.SubItemType
			FROM @SubItem AS si 
			WHERE si.SubItemListId = mtarrd.ModificationId
			UNION ALL
			SELECT bii.DoorStyleID, bii.ProductCode, bii.ProductID, bii.HasCustomizing, NULL
			FROM @OrderItemConfig AS oic
			CROSS JOIN @BasicItemInfo AS bii
			WHERE oic.ConfigKey LIKE mtarrd.ConfigKey
			AND oic.ConfigValue = mtarrd.ConfigValue
		)AS Cause
	)
	INSERT @Rules (RuleId, ComponentPartTypeId, ActionType, CausingSubItemType, GroupId)
	SELECT r.ProductionItemModifcationAddRemoveRuleId, r.PartId, r.AddRemoveType, r.CauseSubItemType, r.ModificationToAddRemoveRuleHeaderId
	FROM Rules AS r
	WHERE r.ToCancelOtherInGroup = 0
	AND NOT EXISTS --Missing condition
	(
		SELECT * FROM picking.ModificationToAddRemoveRuleDetail AS mtarrd2
		WHERE mtarrd2.ModificationToAddRemoveRuleHeaderId = r.ModificationToAddRemoveRuleHeaderId
		AND NOT EXISTS
		(
			SELECT * FROM Rules AS r2
			WHERE mtarrd2.ModificationToAddRemoveRuleDetailId = r2.ModificationToAddRemoveRuleDetailId
		)
		AND mtarrd2.ToCancelOtherInGroup = 0
	)
	AND NOT EXISTS --Canceling condition
	(
		SELECT * FROM Rules AS r3
		WHERE r3.ToCancelOtherInGroup = 1
		AND r3.ModificationToAddRemoveRuleHeaderId = r.ModificationToAddRemoveRuleHeaderId
	)
	AND
	(
		r.ExcludeStyle IS NULL
		OR NOT EXISTS
		(
			SELECT * FROM inventory.DoorStyles AS ds
			WHERE ds.DoorStyleID = r.MainDoorStyleId
			AND EXISTS
			(
				SELECT * FROM dbo.FN_ListToTable( ' ', r.ExcludeStyle) AS fltt
				WHERE ds.Style LIKE '%' + fltt.ListValue + '%'
			)
		)
	) 
	AND 
	(
		r.OnlyWhenProductHasText IS NULL
		OR r.MainProductCode LIKE '%' + r.OnlyWhenProductHasText + '%'
	)
	AND 
	(
		r.ExcludeWhenProductHasText IS NULL 
		OR NOT EXISTS
		(
			SELECT * FROM dbo.FN_ListToTable(' ', r.ExcludeWhenProductHasText) AS fltt
			WHERE r.MainProductCode LIKE '%' +  fltt.ListValue  + '%'
		)	
	)	
	AND 
	( 
		r.ExcludeTag IS NULL 
		OR NOT EXISTS 
		(
			SELECT * FROM inventory.ProductToProductTags ptpt 
			WHERE r.ExcludeTag = ptpt.ProductTagId 
			AND ptpt.ProductId = r.MainProductId 
			AND ptpt.DeleteFlag = 0
		)
	)
	AND 
	( 
		r.HasCustomizing IS NULL 
		OR r.HasCustomizing = r.HasCustomizing  
	)
	--FF-525 https://jira.fabuwood.com/browse/FF-525?focusedCommentId=115098&page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel#comment-115098
	AND 
	(
		r.ExcludeWhenAnySubItemHasTag IS NULL
		OR NOT EXISTS
		(
			SELECT * FROM @SubItem AS si
			JOIN inventory.AcumaticaProductToProductTag AS aptpt ON si.SubAcumaticaProductId = aptpt.AcumaticaProductId
			AND aptpt.Deleted = 0
			AND aptpt.ProductTagId = r.ExcludeWhenAnySubItemHasTag
		)
	)
		
	DECLARE @itemAddRemove TABLE (ProductionItemModifcationAddRemoveRuleId INT NULL, ModifcationId INT, ActionType VARCHAR(10), PartTypeId INT, PartType VARCHAR(50), PartItemCode VARCHAR(50), 
	QuantityAll BIT DEFAULT(1), Quantity INT NULL, FunctionPart VARCHAR(50), OnlyRemoveWhenAdd BIT NULL, GroupId INT NULL)

	INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, QuantityAll, FunctionPart, OnlyRemoveWhenAdd, GroupId)
	SELECT cr.RuleId, cr.ActionType, 
	COALESCE(DrawerSelection.PartId, drawerBoxInMl.ComponentPartTypeId, cr.ComponentPartTypeId-- tilRemoveComponent.ComponentPartTypeId
	),  
	COALESCE(DrawerSelection.InventoryId, drawerBoxInMl.InventoryID, ml.InventoryID), 
	COALESCE(DrawerSelection.Quantity, pimarr.Quantity), 
	CASE WHEN COALESCE(DrawerSelection.Quantity, pimarr.Quantity) IS NOT NULL AND COALESCE(DrawerSelection.Quantity, pimarr.Quantity) > 0 THEN 0 ELSE 1 END, 
	'Remove',
	pimarr.OnlyRemoveWhenAdd, cr.GroupId
	FROM @Rules AS cr
	JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON cr.RuleId = pimarr.ProductionItemModifcationAddRemoveRuleId
	JOIN dbo.tb_ItemList AS tilRemoveComponent ON tilRemoveComponent.ComponentPartTypeId = cr.ComponentPartTypeId 
	--FF-621
	OR
	(
		cr.ComponentPartTypeId IN(9, 29) 
		AND tilRemoveComponent.ComponentPartTypeId IN(9, 29)
	)
	JOIN @MaterialList ml ON tilRemoveComponent.AcumaticaName = ml.InventoryID 
	CROSS JOIN @BasicItemInfo AS bii
	OUTER APPLY
	(
		SELECT Drawers.ComponentPartId AS PartId, Drawers.InventoryId, Drawers.ItemListId, COUNT(*) AS Quantity 
		FROM @OrderItemConfig AS oic
		CROSS APPLY
		(
			SELECT TOP (1) mcr.ComponentPartId, ml2.InventoryID, tildb.ID AS ItemListId
			FROM DrawerConfigModRules AS mcr
			JOIN dbo.tb_ItemList AS tildb ON tildb.ComponentPartTypeId = mcr.ComponentPartId 
			JOIN @MaterialList AS ml2 ON tildb.AcumaticaName = ml2.InventoryID
			WHERE mcr.Config = oic.ConfigValue
			ORDER BY CASE WHEN mcr.ProductId = bii.ProductID
			THEN 0 WHEN mcr.ProductId IS NULL THEN 1 ELSE 2 END
		)AS Drawers
		WHERE oic.ConfigKey = 'Remove Drawers'
		AND cr.RuleId = 31
		GROUP BY Drawers.ComponentPartId, Drawers.InventoryID, Drawers.ItemListId
	)AS DrawerSelection
	OUTER APPLY
	(
		SELECT TOP (1) tilDb.ComponentPartTypeId, ml2.InventoryID, tilDb.ID AS ItemListId
		FROM @MaterialList AS ml2
		JOIN dbo.tb_ItemList AS tilDb ON tilDb.AcumaticaName = ml2.InventoryID
		WHERE tilDb.ComponentPartTypeId IN(7, 17)
		AND cr.RuleId = 31
	)AS drawerBoxInMl
	OUTER APPLY
	(
		SELECT tilFinalRemove.ID AS ItemListId, p.ProductID, p.ProductCode
		FROM dbo.tb_ItemList AS tilFinalRemove
		JOIN inventory.Products AS p ON p.ProductID = tilFinalRemove.ProductID
		WHERE tilFinalRemove.ID = COALESCE(DrawerSelection.ItemListId, drawerBoxInMl.ItemListId, tilRemoveComponent.ID)
	)AS FinalRemove
	WHERE cr.ActionType = 'Remove'
	AND 
	(
		pimarr.PartExcludeTag IS NOT NULL
		OR NOT EXISTS
		(
			SELECT * FROM inventory.ProductToProductTags AS ptpt
			WHERE ptpt.DeleteFlag = 0
			AND FinalRemove.ProductID = ptpt.ProductId
			AND ptpt.ProductTagId = pimarr.PartExcludeTag
		)
	)
	AND 
	(
		pimarr.ExcludeWhenPartProductCodeHasText IS NULL
		OR FinalRemove.ProductCode NOT LIKE '%' + pimarr.ExcludeWhenPartProductCodeHasText + '%'
	)		
		
	INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, FunctionPart, GroupId)
	SELECT pimarr.ProductionItemModifcationAddRemoveRuleId, pimarr.AddRemoveType , COALESCE(pimarr.PartId, parts.ComponentPartTypeId), 
	parts.InventoryID, parts.QtyRequired, 'From Sub Item: ' + si.SubShortItemCode, r.GroupId
	FROM @Rules AS r
	JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON pimarr.ProductionItemModifcationAddRemoveRuleId = r.RuleId
	JOIN @SubItem AS si ON si.SubItemType = pimarr.SubItemType OR pimarr.SubItemType IS NULL OR (pimarr.PartId IS NULL AND si.SubItemType IN (1, 2))
	CROSS JOIN @BasicItemInfo AS bii
	CROSS APPLY
	(
		SELECT bomd.InventoryID, tilBomd.ComponentPartTypeId, bomd.QtyRequired, p.ProductID, p.ProductCode, tilBomd.ShortItemCode, tilBom.ProductID AS MainProductID
		FROM acumaticaManufacturing.BillOfMaterials AS bom
		JOIN dbo.tb_ItemList AS tilBom ON bom.InventoryID = tilBom.AcumaticaName 
		JOIN acumaticaManufacturing.BillOfMaterialOperations AS bomo ON bomo.BOMID = bom.BOMID AND bomo.DeleteFlag = 0
		JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = 0 AND bomd.OperationDbId = bomd.OperationDbId
		JOIN acumaticaManufacturing.BOMRevisions AS br ON br.AcumaticaName = bom.InventoryID AND bom.BOMID = COALESCE(br.BOMIDC, br.BOMIDB, br.BOMIDD, br.BOMIDE)
		JOIN dbo.tb_ItemList AS tilBomd ON tilBomd.AcumaticaName = bomd.InventoryID
		LEFT JOIN inventory.Products AS p ON p.ProductID = tilBomd.ProductID
		WHERE si.SubItemListId = tilBom.ID
		AND bom.DeleteFlag = 0  
		AND bomo.WorkCenter = 'PICKING' 
	)AS Parts
	WHERE r.ActionType = 'Add'
	AND 1 IN(pimarr.FromSubItem, pimarr.FromSubItemWhenPossible)
	AND
	(
		Parts.ComponentPartTypeId = r.ComponentPartTypeId
		OR r.ComponentPartTypeId IS NULL
		--FF-621
		OR
		(
			Parts.ComponentPartTypeId IN(9, 29) 
			AND  r.ComponentPartTypeId IN(9, 29)
		)
	)
	AND
	(
		Parts.ComponentPartTypeId <> 11
		OR NOT EXISTS
		(
			SELECT * FROM @SubItem AS si2
			WHERE si2.SubItemListId = 153925 --DOORS ON BO
		)
	)
	AND 
	(
		pimarr.OnlyFromTag IS NULL
		OR EXISTS 
		(
			SELECT * FROM inventory.ProductToProductTags ptpt 
			WHERE pimarr.OnlyFromTag = ptpt.ProductTagId 
			AND ptpt.ProductId = Parts.MainProductId 
			AND ptpt.DeleteFlag = 0
		)
	)
	AND 
	(
		pimarr.PartExcludeTag IS NULL 
		OR NOT EXISTS
		(
			SELECT * FROM inventory.ProductToProductTags AS ptpt 
			WHERE ptpt.ProductId = Parts.ProductID 
			AND ptpt.ProductTagId = pimarr.PartExcludeTag 
			AND ptpt.DeleteFlag=0
		)
	)
	AND 
	(
		pimarr.ExcludeWhenPartProductCodeHasText IS NULL 
		OR Parts.ProductCode NOT LIKE '%' + pimarr.ExcludeWhenPartProductCodeHasText + '%'
	)
	AND 
	(
		ISNULL(pimarr.OnlyAddWhenRemove, 0) = 0
		OR EXISTS
		(
			SELECT * FROM @itemAddRemove AS iar
			WHERE iar.ActionType = 'Remove'
			AND iar.PartTypeId = parts.ComponentPartTypeId
		)
	)
	AND NOT EXISTS
	(
		SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
		JOIN inventory.AcumaticaStockItems asi ON asi.AcumaticaID=asitoi.StockAcumaticaID AND asi.DeleteFlag=0
		JOIN inventory.ItemStatuses ist ON  asi.ItemStatus=ist.StatusName AND ist.ActiveStatus=1
		WHERE asi.Name = Parts.InventoryID
		AND asitoi.SortComponent >= asitoi.Quantity
		AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
	)	  
	AND NOT 
	(
		NOT EXISTS
		(
			SELECT * FROM dbo.ItemLocationsUpdate ilu
			JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
			WHERE il.ExcludeFrmStock = 0
			AND il.LocationType <> 13
			AND ilu.ItemCode = Parts.ShortItemCode
		)
		AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
	)
	AND --MatchOnTag
    (
		pimarr.MatchOnTag IS NULL
		OR --original and replacement have tag
		(
			EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt 
				WHERE bii.ProductID = ptpt.ProductTagId 
				AND ptpt.ProductTagId = pimarr.MatchOnTag 
				AND ptpt.DeleteFlag = 0
			)
			AND EXISTS 
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt 
				WHERE Parts.MainProductID = ptpt.ProductTagId 
				AND ptpt.ProductTagId = pimarr.MatchOnTag 
				AND ptpt.DeleteFlag = 0
			)
		)
		OR --original and replacement don't have tag
		(
			NOT EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt 
				WHERE bii.ProductID = ptpt.ProductTagId 
				AND ptpt.ProductTagId = MatchOnTag 
				AND ptpt.DeleteFlag=0
			)
			AND NOT EXISTS 
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt 
				WHERE Parts.MainProductID = ptpt.ProductTagId 
				AND ptpt.ProductTagId = MatchOnTag 
				AND ptpt.DeleteFlag = 0
			)	
		)	
	)
	AND r.CausingSubItemType = 4	
			
	INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, FunctionPart, GroupId)
	SELECT r.RuleId, 'Add', r.ComponentPartTypeId, prtsToAdd.InventoryID, pimarr.Quantity, 'Not from sub item', r.GroupId
	FROM @Rules AS r
	JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON pimarr.ProductionItemModifcationAddRemoveRuleId = r.RuleId
	CROSS JOIN @BasicItemInfo AS bii
	JOIN dbo.tb_AdjustedBoxDimensions abd ON abd.TranEntryID = @orderItemId
	JOIN inventory.AcumaticaStockItems asi ON asi.AcumaticaID = bii.AcumeticaId
	CROSS APPLY
	(
		SELECT TOP (1) bom.InventoryID item, bomd.InventoryID, tilBomd.ShortItemCode, asi2.Height, asi2.Width, asi2.Depth, tilBomd.AcumaticaDesc,
		tilBomd.ComponentPartTypeId
		FROM acumaticaManufacturing.BillOfMaterials bom
		JOIN dbo.tb_ItemList AS tilBom ON bom.InventoryID = tilBom.AcumaticaName 
		JOIN inventory.AcumaticaStockItems asi2 ON asi2.AcumaticaID = tilBom.AcumaticaID
		JOIN acumaticaManufacturing.BillOfMaterialDetails bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = 0 
		JOIN dbo.tb_ItemList AS tilBomd ON tilBomd.AcumaticaName = bomd.InventoryID 
		JOIN inventory.AcumaticaStockItems AS asiBomDetail ON asiBomDetail.AcumaticaID = tilBomd.AcumaticaID
		WHERE bom.Revision <> 'A'
		AND tilBom.DoorStyleID = bii.DoorStyleID 
		AND tilBom.ItemTypeCode = bii.ItemTypeId
		AND bom.DeleteFlag = 0
		AND 
		(
			tilBomd.ComponentPartTypeId = r.ComponentPartTypeId
			--FF-621
			OR 
			(
				r.ComponentPartTypeId IN(9, 29)
				AND tilBomd.ComponentPartTypeId  IN(9, 29)
			)
		)

		AND
		(
			(
				(
					(   
						EXISTS (SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Depth')
						AND EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Height')
						AND NOT EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Width')
						AND 
						(
							(
								asi2.Depth >= asi.Depth + abd.AdjustDepth 
								AND 
								(
									(
										asi2.Height >= asi.Height + abd.AdjustHeight 
										AND pimarr.SpecificHeight IS NULL
									) 
									OR pimarr.SpecificHeight = asi2.Height
								)
								AND ISNULL(pimarr.ExactMeasurementsOnly, 0) = 0
							)
							OR EXISTS
							(
								SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
								WHERE gab.Depth = asi.Depth + abd.AdjustDepth 
								AND 
								(
									(
										gab.Height = asi.Height + abd.AdjustHeight 
										AND pimarr.SpecificHeight IS NULL
									)
									OR gab.Height = pimarr.SpecificHeight
								)
							)
						)
					)
					OR
					(   
						EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Depth')
						AND EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Width')
						AND NOT EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Height')
						-- hard coded for full hight door add shelf, if it happens more, add column to table "ProductionItemModifcationAddRemoveRules" to indicate
						AND 
						(
							r.RuleId <> 45
   							OR 
							(
								EXISTS 
								(
									SELECT * FROM inventory.DoorStyles dsc WHERE bii.DoorStyleID = dsc.DoorStyleID
									AND EXISTS 
									(
										SELECT * FROM inventory.DoorStyles dsr WHERE tilBom.DoorStyleID = dsr.DoorStyleID 
										AND 
										(
											(
												dsr.SeriesName IN ('Allure', 'Classic') 
												AND dsc.SeriesName IN ('Allure', 'Classic')
											) 
											OR 
											(
												dsr.SeriesName NOT IN ('Allure', 'Classic') 
												AND dsc.SeriesName NOT IN ('Allure', 'Classic')
											)
										)
									)
								)
							)
						)
						AND 
						(
							(
								asi2.Depth >= asi.Depth + abd.AdjustDepth 
								AND asi2.Width >= asi.Width + abd.AdjustWidth 
								AND ISNULL(pimarr.ExactMeasurementsOnly, 0) = 0 
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 0
								--18 = FF-662, 2 = FF-678
								AND 
								(
									asiBomDetail.Depth >= asi.Depth + abd.AdjustDepth - 1.375
									OR pimarr.ProductionItemModifcationAddRemoveRuleId NOT IN(2, 18)
								)
							)
							OR 
							(
								EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
								WHERE gab.Depth = asi.Depth + abd.AdjustDepth AND gab.Width = asi.Width + abd.AdjustWidth)
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 1
							)
						)
					)
					OR
					(   EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Width')
						AND EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Height')
						AND NOT EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Depth')
						AND 
						(
							(
								asi2.Width >= asi.Width + abd.AdjustWidth 
								AND 
								(
									(
										asi2.Height >= asi.Height + abd.AdjustHeight 
										AND pimarr.SpecificHeight IS NULL
									) 
									OR pimarr.SpecificHeight = asi2.Height
								)
								AND ISNULL(pimarr.ExactMeasurementsOnly, 0) = 0
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 0
							)
							OR 
							(
								EXISTS
								(
									SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
									WHERE gab.Width = asi.Width + abd.AdjustWidth
									AND
									(
										(
											gab.Height = asi.Height + abd.AdjustHeight 
											AND pimarr.SpecificHeight IS NULL
										) 
										OR gab.Height = pimarr.SpecificHeight
									)
								)
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 1
							)
						)
					)
					OR
					(
						EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Width')
						AND EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Height')
						AND EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Depth')
						AND 
						(
							(
								asi2.Width >= asi.Width + abd.AdjustWidth 
								AND asi2.Depth >= asi.Depth + abd.AdjustDepth 
								AND 
								(
									(
										asi2.Height >= asi.Height + abd.AdjustHeight 
										AND pimarr.SpecificHeight IS NULL
									) 
									OR pimarr.SpecificHeight = asi2.Height
								)						
								AND ISNULL(pimarr.ExactMeasurementsOnly, 0) = 0
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 0
							)  
							OR 
							(
								EXISTS
								(
									SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
									WHERE gab.Width = asi.Width + abd.AdjustWidth
									AND
									(
										(
											gab.Height = asi.Height + abd.AdjustHeight 
											AND pimarr.SpecificHeight IS NULL
										) 
										OR gab.Height = pimarr.SpecificHeight
									)
									AND gab.Depth = asi.Depth + abd.AdjustDepth
								)
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 1
							)
						)
					)
					OR
					(
						EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Width')
						AND NOT EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Height')
						AND NOT EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Depth')
						AND 					
						(
							(
								asi2.Width >= asi.Width + abd.AdjustWidth 						
								AND ISNULL(pimarr.ExactMeasurementsOnly, 0) = 0
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 0
							)  
							OR 
							(
								EXISTS
								(
									SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
									WHERE gab.Width = asi.Width + abd.AdjustWidth
									AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 1
								)
							)	
						)
					)
				)
				AND pimarr.PartToAddFromProduct IS NULL
			)
			OR
			(
				pimarr.PartToAddFromProduct IS NOT NULL 
				AND EXISTS 
				(
					SELECT * FROM  inventory.Products p 
					WHERE p.ProductCode = pimarr.PartToAddFromProduct 
					AND tilBom.ProductID = p.ProductID
				)
			)
		)
			 AND --from same belt
		 (
			 ISNULL(pimarr.FromSameBelt, 0) = 0 
			 OR EXISTS
			 (
				SELECT * FROM picking.DestinationLocationItemRule AS dlir 
				JOIN Picking.ProductionItem AS pi ON pi.ItemlistId = dlir.ProductionItemItemlistId
				WHERE EXISTS 
				(
					SELECT * FROM picking.DestinationLocationItemRule dlir2 
					WHERE dlir2.ProductionItemItemlistId = tilBom.ID
					AND dlir.DestinationLocationId = dlir2.DestinationLocationId
				)
				AND pi.OrderItemId = @orderItemId
			)
		 )
		 AND 
		(
			pimarr.PartExcludeTag IS NULL 
			OR NOT EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt  
				WHERE ptpt.ProductId = tilBom.ProductID
				AND ptpt.DeleteFlag = 0
				AND ptpt.ProductTagId = pimarr.PartExcludeTag
			)
		)	
		AND 
		(
			pimarr.OnlyFromTag IS NULL
			OR EXISTS 
			(
				SELECT * FROM inventory.ProductToProductTags ptpt 
				WHERE pimarr.OnlyFromTag = ptpt.ProductTagId 
				AND ptpt.ProductId = tilBom.ProductID
				AND ptpt.DeleteFlag = 0
			)
		)
		 AND 
		(
			pimarr.ExcludeWhenPartProductCodeHasText IS NULL 
			OR EXISTS
			(
				SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
				WHERE gab.ProductCode NOT LIKE '%' + pimarr.ExcludeWhenPartProductCodeHasText + '%' 
			) 
		)
		 AND NOT EXISTS
		 (
			 SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
			 WHERE asitoi.StockAcumaticaID = tilBomd.AcumaticaID
			 AND asitoi.SortComponent >= asitoi.Quantity
			 AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
		 )
		AND NOT 
		(
			NOT EXISTS
			(
				SELECT * FROM dbo.ItemLocationsUpdate ilu
				JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
				WHERE il.ExcludeFrmStock = 0
				AND il.LocationType <> 13
				AND ilu.ItemCode = tilBomd.ShortItemCode
			)
			AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
		)
		AND --MatchOnTag
        (
			pimarr.MatchOnTag IS NULL
			OR
			(
				--original and replacement have tag
				EXISTS
				(
					SELECT * FROM inventory.ProductToProductTags AS ptpt 
					WHERE bii.ProductID = ptpt.ProductTagId 
					AND ptpt.ProductTagId = pimarr.MatchOnTag 
					AND ptpt.DeleteFlag=0
				)
				AND EXISTS 
				(
					SELECT * FROM inventory.ProductToProductTags AS ptpt 
					WHERE tilBom.ProductID = ptpt.ProductTagId 
					AND ptpt.ProductTagId = pimarr.MatchOnTag 
					AND ptpt.DeleteFlag=0
				)
			)		
			OR --original and replacement don't have tag
			(
				NOT EXISTS
				(
					SELECT * FROM inventory.ProductToProductTags AS ptpt 
					WHERE bii.ProductID = ptpt.ProductTagId 
					AND ptpt.ProductTagId = pimarr.MatchOnTag 
					AND ptpt.DeleteFlag=0
				)
				AND NOT EXISTS 
				(
					SELECT * FROM inventory.ProductToProductTags AS ptpt 
					WHERE tilBom.ProductID = ptpt.ProductTagId 
					AND ptpt.ProductTagId = pimarr.MatchOnTag 
					AND ptpt.DeleteFlag=0
				)							
			)
		)	
		ORDER BY CASE WHEN EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr2 WHERE cptmr2.ComponentPartTypeId = tilBomd.ComponentPartTypeId AND cptmr2.Dimension = 'Width') THEN asi2.Width ELSE 1000 END, 
				CASE WHEN EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr2 WHERE cptmr2.ComponentPartTypeId = tilBomd.ComponentPartTypeId AND cptmr2.Dimension = 'Height') THEN asi2.Height ELSE 1000 END,
				CASE WHEN EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr2 WHERE cptmr2.ComponentPartTypeId = tilBomd.ComponentPartTypeId AND cptmr2.Dimension = 'Depth') THEN asi2.Depth ELSE 1000 END
				,asi2.Height,asi2.Width,asi2.Depth
	) prtsToAdd
	WHERE r.ActionType = 'Add'
	AND
	(
		pimarr.FromSubItem = 0
		OR 
		(
			ISNULL(pimarr.FromSubItemWhenPossible, 0) = 1
			AND NOT EXISTS
			(
				SELECT * FROM @itemAddRemove AS iar
				WHERE iar.ActionType = 'Add'
				AND iar.ProductionItemModifcationAddRemoveRuleId = r.RuleId
			)
		)
	)
	AND 
	(
		ISNULL(pimarr.OnlyAddWhenRemove, 0) = 0
		OR EXISTS
		(
			SELECT * FROM @itemAddRemove AS iar
			WHERE iar.ActionType = 'Remove'
			AND iar.PartTypeId = r.ComponentPartTypeId
		)
	);

	--IL-3652 redone on --FF-264
	DECLARE @itemReplace TABLE(RuleId INT, AddPartAcumaticaName VARCHAR(50), Quantity INT, RemovePartAcumaticaName VARCHAR(50))

	INSERT @itemReplace(RuleId, AddPartAcumaticaName, Quantity, RemovePartAcumaticaName)
	SELECT pimarr.ProductionItemModifcationAddRemoveRuleId, ReplaceItem.AddAcumaticaName, COALESCE(maprd.QuantityToReplace, mlQty.Quantity, 0), tilRemove.AcumaticaName
	FROM @Rules AS r
	JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON pimarr.ProductionItemModifcationAddRemoveRuleId = r.RuleId
	CROSS JOIN @BasicItemInfo AS bii
	JOIN picking.ModificationAcuProductReplacementDetail AS maprd ON maprd.ModificationAcuProductReplacementHeaderId = pimarr.ModificationAcuProductReplacementHeaderId
	JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaProductID = maprd.OriginalAcuProductId
	JOIN dbo.tb_ItemList AS tilRemove ON asi.AcumaticaID = tilRemove.AcumaticaID
	CROSS APPLY
	(
		SELECT TOP (1) tilReplace.AcumaticaName AS AddAcumaticaName, tilReplace.ProductID, tilReplace.AcumaticaID, tilReplace.ShortItemCode AS AddShortItemCode 
		FROM dbo.tb_ItemList AS tilReplace 
		WHERE tilReplace.ProductID = maprd.ReplacementProductId
		AND ISNULL(tilReplace.DoorStyleID, bii.DoorStyleID) = bii.DoorStyleID		
	)AS ReplaceItem
	OUTER APPLY
	(
		SELECT ml.Quantity FROM @MaterialList AS ml
		WHERE ml.InventoryID = tilRemove.AcumaticaName
		AND maprd.QuantityToReplace IS NULL
	)mlQty
		
	WHERE pimarr.AddRemoveType = 'Replace'
	AND EXISTS
	(
		SELECT * FROM @MaterialList AS ml
		WHERE ml.InventoryID = asi.Name
	)
	AND 
	(
		pimarr.PartExcludeTag IS NULL
		OR NOT EXISTS
		(
			SELECT * FROM inventory.ProductToProductTags AS ptpt
			WHERE ReplaceItem.ProductID = ptpt.ProductId
			AND ptpt.DeleteFlag = 0
			AND pimarr.PartExcludeTag = ptpt.ProductTagId
		) 
	)
	AND 
	(
		pimarr.ExcludeWhenPartProductCodeHasText IS NULL
		OR NOT EXISTS
		(
			SELECT * FROM inventory.Products AS p2
			WHERE p2.ProductID = ReplaceItem.ProductID
			AND p2.ProductCode LIKE '%' + pimarr.ExcludeWhenPartProductCodeHasText + '%'
		)
	)
	AND NOT EXISTS
	(
		SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
		WHERE asitoi.StockAcumaticaID = ReplaceItem.AcumaticaID
		AND asitoi.SortComponent >= asitoi.Quantity
		AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
	)
	AND NOT 
	(
		NOT EXISTS
		(
			SELECT * FROM dbo.ItemLocationsUpdate ilu
			JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
			WHERE il.ExcludeFrmStock = 0
			AND il.LocationType <> 13
			AND ilu.ItemCode = ReplaceItem.AddShortItemCode
		)
		AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
	)
	AND
    (
			pimarr.ProductionItemModifcationAddRemoveRuleId <> 229
			OR dbo.OrderItemHasCutDoorsOnAllDoors(@orderItemId) = 1
	)
		
	INSERT INTO @AddremoveRules (RuleId, AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, PartType, FunctionPart, GroupId) --Remove
	SELECT iar.ProductionItemModifcationAddRemoveRuleId, iar.ActionType, iar.PartItemCode,  iar.QuantityAll, SUM(COALESCE(iar.Quantity, qty.Quantity,1)),'PICKING' , iar.PartTypeId, iar.FunctionPart, iar.GroupId
	FROM @itemAddRemove iar	
	OUTER APPLY 
	(
		SELECT TOP (1) ml.Quantity 
		FROM dbo.tb_ItemList il 
		JOIN @MaterialList ml ON ml.InventoryID = il.AcumaticaName 
		WHERE il.ComponentPartTypeId = iar.PartTypeId 
		AND iar.QuantityAll = 1
	) qty
	WHERE NOT EXISTS
	(
		SELECT * FROM @itemAddRemove iar2 
		WHERE iar.PartTypeId = iar2.PartTypeId AND iar2.PartItemCode = iar.PartItemCode 
		AND iar2.Quantity = iar.Quantity 
		AND iar2.ActionType <> iar.ActionType
	) 
	AND NOT EXISTS
	(
		SELECT * FROM picking.ProductionItemModifcationAddRemoveRules mr 
		WHERE mr.ProductionItemModifcationAddRemoveRuleId = iar.ProductionItemModifcationAddRemoveRuleId 
		AND 
		(
			(
				mr.OnlyRemoveWhenAdd = 1  
				AND NOT EXISTS
				(
					SELECT 1 FROM @itemAddRemove iar2 
					WHERE 
					(
						(
							iar.PartTypeId = iar2.PartTypeId 
							OR 
							(
								iar.PartTypeId IN(9, 29) 
								AND iar2.PartTypeId IN(9, 29)
							)
						)
					)
					AND ISNULL(iar2.Quantity, 1) >= ISNULL(iar.Quantity, 0)
					AND iar2.ActionType='Add' 
				)
			) 
			OR
			(
				mr.OnlyRemoveWhenAddPartId IS NOT NULL
				AND NOT EXISTS
				(
					SELECT * FROM @itemAddRemove AS iar3
					WHERE iar3.ActionType = 'Add'
					AND 
					(
						iar3.PartTypeId = OnlyRemoveWhenAddPartId
						OR
						(
							iar3.PartTypeId IN(9, 29)
							AND mr.OnlyRemoveWhenAddPartId IN(9, 29)
						)
					)
				)
			)
		)
	)
	AND iar.ActionType = 'Remove'
	GROUP BY iar.ProductionItemModifcationAddRemoveRuleId,
             iar.ActionType,
             iar.PartItemCode,
             iar.QuantityAll,
             iar.PartTypeId,
             iar.FunctionPart,
			 iar.GroupId

	INSERT INTO @AddremoveRules (RuleId, AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, PartType, FunctionPart , GroupId) --Add
	SELECT MAX(iar.ProductionItemModifcationAddRemoveRuleId), iar.ActionType, iar.PartItemCode,  iar.QuantityAll,
	MAX(COALESCE(iar.Quantity, remove.Quantity, 1)),
	'PICKING' , iar.PartTypeId, iar.FunctionPart, iar.GroupId
	FROM @itemAddRemove iar
	OUTER APPLY
	(
		SELECT ar.Quantity 
		FROM  @AddremoveRules AS ar WHERE ar.PartType = iar.PartTypeId AND ar.AddRemoveAction = 'remove'
	)remove	
	OUTER APPLY 
	(
		SELECT TOP (1) ml.Quantity 
		FROM dbo.tb_ItemList il 
		JOIN @MaterialList ml ON ml.InventoryID = il.AcumaticaName 
		WHERE il.ComponentPartTypeId = iar.PartTypeId 
		AND iar.QuantityAll = 1
	) qty
	WHERE NOT EXISTS
	(
		SELECT * FROM @itemAddRemove iar2 
		WHERE 
		(
			iar.PartTypeId = iar2.PartTypeId 
			OR
			(
				iar.PartTypeId IN(9, 29)
				AND  iar2.PartTypeId IN(9, 29)
			)
		)
		AND iar2.PartItemCode = iar.PartItemCode 
		AND iar2.Quantity = iar.Quantity 
		AND iar2.ActionType <> iar.ActionType
	) 
	--IL-3639
	AND NOT EXISTS
	(
		SELECT * FROM @itemAddRemove AS iar3
		WHERE iar3.ActionType = 'Remove'
		AND iar3.PartItemCode = iar.PartItemCode
		AND ISNULL(iar3.Quantity, 0) = ISNULL(iar.Quantity, 0)
		AND ISNULL(iar3.OnlyRemoveWhenAdd, 0) = 0
	)
	AND iar.ActionType = 'Add'
	GROUP BY iar.ActionType, iar.PartItemCode, iar.QuantityAll, iar.PartTypeId, iar.FunctionPart, iar.GroupId		

	--FF-320
	INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, Backflush, PartType, FunctionPart ) --explicit additions (from table AddonBomAdditions)
	SELECT aba.ActionType, tilAddition.AcumaticaName, 
	CASE WHEN aba.Quantity IS NULL 
		AND aba.QuantityFromSubItem = 0
		AND aba.QuantityForOriginalItem = 0
		AND aba.ActionType <> 'Replace'
		AND aba.ConfigKey IS NULL THEN 1 ELSE 0 END AS QuantityAll, 
	SUM(COALESCE(SubItemQuantity.QtyRequired, QuantityOfOriginalItem.Quantity, aba.Quantity, 0) + ISNULL(QuantityPerComponent.QuantityPerComponent, 0) + COALESCE(QuantityConfig.QuantityConfigMultiplied, aba.QuantityPerConfigKey,0)) AS Quantity, 
	'PICKING', 
	--BEGIN FF-444
	CASE WHEN tilAddition.ID = 128070 AND ds.SeriesName = 'Quest' AND tilSub.ShortItemCode LIKE 'DCD%' THEN 0 ELSE 1 END,
	--END FF-444
	tilAddition.ComponentPartTypeId,
	'Explicit additions (from table AddonBomAdditions)'
	FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS tilte ON tilte.ItemCode = te.ItemNumber
	JOIN inventory.DoorStyles AS ds ON ds.DoorStyleID = tilte.DoorStyleID
	JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID AND te.EZProdID = te2.EZParentProdID
	JOIN dbo.tb_ItemList AS tilSub ON tilSub.ItemCode = te2.ItemNumber
	JOIN picking.AddonBomAdditions AS aba ON aba.SubItemId = tilSub.ID
	JOIN dbo.tb_ItemList AS tilAddition ON tilAddition.ID = aba.AdditionalItemId
	OUTER APPLY
	(
		SELECT CAST(bomd.QtyRequired AS INT) AS QtyRequired
		FROM acumaticaManufacturing.BillOfMaterials AS bom
		JOIN dbo.tb_ItemList AS tilSubForParts ON bom.InventoryID = tilSubForParts.AcumaticaName
		JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
		WHERE bom.DeleteFlag = 0
		AND bomd.DeleteFlag = 0
		AND bom.Revision IN ('B', 'C', 'D')
		AND tilSubForParts.ItemTypeCode IN (1, 2)
		AND aba.QuantityFromSubItem = 1
		AND bomd.InventoryID = tilAddition.AcumaticaName
		AND EXISTS
		(
			SELECT * FROM dbo.TranEntry AS teSubForParts
			WHERE teSubForParts.isDeleted = 0
			AND teSubForParts.OrderID = te.OrderID 
			AND teSubForParts.EZParentProdID = te.EZProdID
			AND teSubForParts.ItemNumber = tilSubForParts.ItemCode
		)
	)AS SubItemQuantity
	OUTER APPLY
	(
		SELECT TOP (1) CAST(bomd.QtyRequired AS INT) * aba.QuantityPerComponentPartType AS QuantityPerComponent
		FROM acumaticaManufacturing.BillOfMaterials AS bom
		JOIN dbo.tb_ItemList AS tilSubForParts ON bom.InventoryID = tilSubForParts.AcumaticaName
		JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
		JOIN dbo.tb_ItemList AS tilBomD ON tilBomD.AcumaticaName = bomd.InventoryID
		WHERE bom.DeleteFlag = 0
		AND bomd.DeleteFlag = 0
		--AND bom.Revision IN ('B', 'C', 'D')
		--AND aba.ComponentPartTypeId IS NOT NULL
		AND tilBomD.ComponentPartTypeId = aba.ComponentPartTypeId
		AND bom.InventoryID = tilSubForParts.AcumaticaName
		AND tilSubForParts.ItemTypeCode IN (1, 2)
		AND EXISTS
		(
			SELECT * FROM dbo.TranEntry AS teSubForParts
			WHERE teSubForParts.isDeleted = 0
			AND teSubForParts.OrderID = te.OrderID 
			AND teSubForParts.EZParentProdID = te.EZProdID
			AND teSubForParts.ItemNumber = tilSubForParts.ItemCode
		)
	)AS QuantityPerComponent
	OUTER APPLY
	(
		SELECT ml.Quantity FROM @MaterialList AS ml
		WHERE ml.InventoryID = tilAddition.AcumaticaName
		AND aba.QuantityForOriginalItem = 1
	)AS QuantityOfOriginalItem
	OUTER APPLY
	(
		SELECT ISNULL(NULLIF(COUNT(*), 0), 1) * aba.QuantityPerConfigKey AS  QuantityConfigMultiplied
		FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
		WHERE goict.ConfigKey = aba.ConfigKey
		AND aba.ConfigKey IS NOT NULL
	)AS QuantityConfig
	WHERE te.ID = @OrderItemId
	AND te2.isDeleted = 0
	AND aba.SubItemId IS NOT NULL
	AND 
	(
		COALESCE(SubItemQuantity.QtyRequired, QuantityOfOriginalItem.Quantity, aba.Quantity, QuantityPerComponent.QuantityPerComponent, QuantityConfig.QuantityConfigMultiplied) > 0
		OR 
		(
			aba.Quantity IS NULL 
			AND aba.QuantityFromSubItem = 0
			AND aba.QuantityForOriginalItem = 0
			AND aba.ActionType <> 'Replace'
			AND ISNULL(QuantityConfig.QuantityConfigMultiplied, 0) = 0
		)
	)
	GROUP BY aba.ActionType, tilAddition.AcumaticaName,
			CASE WHEN aba.Quantity IS NULL
             AND aba.QuantityFromSubItem = 0
             AND aba.QuantityForOriginalItem = 0
             AND aba.ActionType <> 'Replace'
             AND aba.ConfigKey IS NULL THEN 1
             ELSE 0
             END,
             CASE WHEN tilAddition.ID = 128070
             AND ds.SeriesName = 'Quest'
             AND tilSub.ShortItemCode LIKE 'DCD%' THEN 0
             ELSE 1
             END,
			 tilAddition.ComponentPartTypeId

	DECLARE @ReplaceSlides TABLE(ToRemove VARCHAR(50), ToAdd VARCHAR(450), NeedsRemove BIT, QuantityToAdd INT, QuantityAll BIT)

	INSERT @ReplaceSlides (ToRemove, ToAdd, NeedsRemove, QuantityToAdd, QuantityAll)
		
	SELECT DISTINCT ToRemove.AcumaticaName AS ToRemove, ToAdd.AcumaticaName AS ToAdd, ToRemove.NeedsRemove, 
	CASE WHEN ISNULL(ToAdd.OrderItemId, te.ID) = te.ID THEN ToRemove.QuantityToAdd  ELSE ToAdd.ModConfigQuantity END,
	CASE WHEN ISNULL(ToAdd.OrderItemId, te.ID) = te.ID THEN 1 ELSE 0 END
	FROM dbo.TranEntry AS te
	JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID
		AND te2.EZParentProdID = te.EZProdID
	JOIN dbo.tb_ItemList AS til ON til.ItemCode = te2.ItemNumber
	JOIN picking.AddonBomAdditions AS aba ON aba.SubItemId = til.ID
	CROSS APPLY
	(
		SELECT ptpt.ProductTagId, til.AcumaticaName, CAST(replace.NeedsRemove AS BIT) AS NeedsRemove, replace.QuantityToAdd
		FROM dbo.tb_ItemList AS til 
		JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = til.AcumaticaID
		JOIN inventory.ProductToProductTags AS ptpt ON ptpt.ProductId = til.ProductID
		CROSS APPLY
		(
			SELECT 1 AS NeedsRemove, ml2.Quantity AS QuantityToAdd
			FROM @MaterialList AS ml2
			WHERE ml2.InventoryID = til.AcumaticaName
			UNION ALL
			SELECT 0, 0 
			FROM @AddremoveRules AS arr
			WHERE arr.InventoryId = til.AcumaticaName
		)AS replace
		WHERE aba.TagIdToReduceBy3Inches = ptpt.ProductTagId
		AND ptpt.DeleteFlag = 0
	)AS ToRemove
	CROSS APPLY
	(
		SELECT TOP (1) tilR.AcumaticaName, cz.OrderItemId, cz.ModConfigQuantity
		FROM dbo.tb_ItemList AS tilR
		JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = tilR.AcumaticaID
		JOIN inventory.ProductToProductTags AS ptpt2 ON ptpt2.ProductId = tilR.ProductID
		OUTER APPLY
		(
			SELECT asiMain.Depth + tabd.AdjustDepth  AS CabinetDepth
			FROM inventory.AcumaticaStockItems AS asiMain
			JOIN dbo.tb_ItemList AS tilMain ON te.ItemNumber = tilMain.ItemCode
			AND tilMain.AcumaticaID = asiMain.AcumaticaID
			JOIN dbo.tb_AdjustedBoxDimensions AS tabd ON tabd.TranEntryID = @orderItemId
		)AS cd
		OUTER APPLY
		(
			SELECT CAST(goict.ConfigValue AS NUMERIC) AS CofiguredSize, goict.OrderItemId, COUNT(*) AS ModConfigQuantity
			FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
			WHERE aba.ConfigKeyForResize = goict.ConfigKey
			AND ISNUMERIC(goict.ConfigValue) = 1
			GROUP BY CAST(goict.ConfigValue AS NUMERIC), goict.OrderItemId
		)AS cz
		WHERE ptpt2.DeleteFlag = 0
		AND ptpt2.ProductTagId = ToRemove.ProductTagId
		AND
		( 
			(
				(
					cd.CabinetDepth - asi.Depth >= 3
					OR 
					(
						NOT EXISTS 
						(
							SELECT * FROM dbo.tb_ItemList AS tilOtherOption
							JOIN inventory.AcumaticaStockItems AS asiOtherOption ON asiOtherOption.AcumaticaID = tilOtherOption.AcumaticaID
							WHERE EXISTS
							(
								SELECT * FROM inventory.ProductToProductTags AS ptpt3
								WHERE ptpt3.DeleteFlag = 0
								AND ptpt3.ProductId = tilOtherOption.ProductID
								AND ptpt3.ProductTagId = TagIdToReduceBy3Inches
							)
							AND cd.CabinetDepth - asiOtherOption.Depth >= 3 
						)
						AND cd.CabinetDepth > asi.Depth
						AND aba.TagIdToReduceBy3Inches = 87
					)
				)
				AND cz.CofiguredSize IS NULL
			)
			OR cz.CofiguredSize = asi.Depth
		)
		ORDER BY asi.Depth DESC
	)AS ToAdd
	WHERE te.ID = @orderItemId
	AND aba.ActionType = 'Replace'

	INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, Quantity, QuantityAll, WorkCenter, FunctionPart )
	SELECT 'Remove', ReplaceSlides.ToRemove, ReplaceSlides.QuantityToAdd, ReplaceSlides.QuantityAll, 'PICKING', 'ReplaceSlides'
	FROM @ReplaceSlides AS ReplaceSlides
	WHERE EXISTS
	(SELECT * FROM @MaterialList AS ml WHERE ml.InventoryID = ReplaceSlides.ToRemove)
	AND ReplaceSlides.NeedsRemove = 1
	AND ReplaceSlides.QuantityAll = 1
	UNION ALL
	SELECT 'Add', ReplaceSlides.ToAdd, ReplaceSlides.QuantityToAdd, ReplaceSlides.QuantityAll, 'PICKING', 'ReplaceSlides'
	FROM @ReplaceSlides AS ReplaceSlides
	WHERE EXISTS
	(SELECT * FROM @MaterialList AS ml WHERE ml.InventoryID = ReplaceSlides.ToRemove)
	AND ReplaceSlides.NeedsRemove = 1
	AND ReplaceSlides.QuantityAll = 1

	UPDATE ar SET ar.InventoryId = rs.ToAdd, ar.FunctionPart = ar.FunctionPart + ' Updated From ReplaceSlides'
	FROM @AddremoveRules AS ar
	JOIN @ReplaceSlides AS rs ON rs.ToRemove = ar.InventoryId
	WHERE ar.AddRemoveAction = 'Add'
	AND rs.NeedsRemove = 0
	AND rs.ToAdd <> ar.InventoryId

	INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, Backflush, PartType, FunctionPart ) --add slides calculated
	SELECT 'Add', Part.Name, 0, Part.Quantity, 'Picking', 1, Part.ComponentPartTypeId, 'add slides calculated' 
	FROM picking.AddonBomAdditions AS aba
	JOIN @SubItem AS si ON si.SubItemListId = aba.SubItemId
	CROSS JOIN @BasicItemInfo AS bii
	CROSS APPLY
	(
		SELECT asi.Depth + tabd.AdjustDepth AS Depth 
		FROM inventory.AcumaticaStockItems AS asi
		JOIN dbo.tb_AdjustedBoxDimensions AS tabd ON tabd.TranEntryID = @orderItemId
		WHERE asi.AcumaticaID = bii.AcumeticaId 
	)AS CabinetSize
	CROSS APPLY
	(
		SELECT TOP (1) asi2.Name, qty.Quantity, til.ComponentPartTypeId 
		FROM inventory.AcumaticaStockItems AS asi2
		JOIN dbo.tb_ItemList AS til ON til.AcumaticaID = asi2.AcumaticaID
		CROSS APPLY
		(
			SELECT COUNT(*) * aba.QuantityPerConfigKey AS Quantity 
			FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
			WHERE goict.ConfigKey = aba.ConfigKey
		)AS qty
		WHERE asi2.Depth <= CabinetSize.Depth - 3
		AND EXISTS
		(
			SELECT * FROM inventory.AcumaticaProductToProductTag AS aptpt
			WHERE Deleted = 0
			AND aptpt.ProductTagId = aba.TagIdToReduceBy3Inches
			AND aptpt.AcumaticaProductId = asi2.AcumaticaProductID
		)
		ORDER BY asi2.Depth DESC
	)AS Part
	WHERE aba.ActionType = 'Add'
	AND aba.AdditionalItemId IS NULL

	
	--FF-579
	IF EXISTS
	(
		SELECT * FROM @AddremoveRules AS ar 
		JOIN dbo.tb_ItemList AS til ON til.AcumaticaName = ar.InventoryId
		WHERE til.ComponentPartTypeId IN (7, 9, 17, 29)
	)
	BEGIN
		DECLARE @TotalLeft TABLE(InventoryID VARCHAR(50), Quantity INT)

		INSERT @TotalLeft(InventoryID, Quantity)
		SELECT Total.InventoryId, SUM(Total.Quantity) FROM 
		(
			SELECT ar.InventoryId, SUM(CASE WHEN ar.AddRemoveAction = 'Add' THEN ar.Quantity ELSE -ar.Quantity END) AS Quantity 
			FROM @AddremoveRules AS ar 
			JOIN dbo.tb_ItemList AS til ON til.AcumaticaName = ar.InventoryId
			WHERE til.ComponentPartTypeId IN (7, 9, 17, 29)
			GROUP BY ar.InventoryId
			UNION ALL
			SELECT ml.InventoryID, ml.Quantity 
			FROM @MaterialList AS ml
			JOIN dbo.tb_ItemList AS tilm ON tilm.AcumaticaName = ml.InventoryId
			WHERE tilm.ComponentPartTypeId IN (7, 9, 17, 29)
		)
		AS Total
		GROUP BY Total.InventoryId

		DECLARE @Harware TABLE(InventoryID VARCHAR(50), Quantity INT, OriginalQuantity INT);
		WITH HW AS 
		(
			SELECT bomd.InventoryID, bomd.QtyRequired * tl.Quantity AS Quantity, ml.Quantity AS OriginalQuantity
			FROM @TotalLeft AS tl
			JOIN dbo.tb_ItemList AS til ON tl.InventoryID = til.AcumaticaName
			CROSS JOIN @BasicItemInfo AS bii
			JOIN acumaticaManufacturing.BillOfMaterials AS bom ON bom.InventoryID = tl.InventoryID
			JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			LEFT JOIN @MaterialList AS ml ON ml.InventoryID = bomd.InventoryID
			WHERE bomd.DeleteFlag = 0
			AND bom.DeleteFlag = 0
			AND bom.Status = 'Active'
			AND 
			(
				(
					bom.Revision = 'HARDWARE' 
					AND 
					(
						bii.DoorStyleID <> 26
						OR til.ComponentPartTypeId NOT IN (7, 17)
					)
				)
				OR 
				(
					bom.Revision = 'HF HARDWAR' 
					AND 
					(
						bii.DoorStyleID = 26
						AND til.ComponentPartTypeId IN (7, 17)
					)
				)
			) 
			AND  bomd.QtyRequired * tl.Quantity <> ml.Quantity
			AND til.ComponentPartTypeId IN(7, 9, 17, 29)
		)
		INSERT @Harware(InventoryID, Quantity)
		SELECT HW.InventoryID, SUM(HW.Quantity) 
		FROM HW
		GROUP BY HW.InventoryID

		DELETE @TotalLeft
		INSERT @TotalLeft(InventoryID, Quantity)
		SELECT ar.InventoryId, SUM(ar.Quantity) FROM @AddremoveRules AS ar
		WHERE NOT EXISTS
		(
			SELECT * FROM @MaterialList AS ml
			WHERE ml.InventoryID = ar.InventoryId
		)
		AND ar.AddRemoveAction = 'Add'
		AND ar.PartType IN (7, 9, 17, 29)
		GROUP BY ar.InventoryId

		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart )--parts from bom of components
		SELECT CASE WHEN h.Quantity < ISNULL(ml.Quantity, 0) THEN 'Remove' ELSE 'Add' END, ISNULL(rs.ToAdd, h.InventoryID),
		CASE WHEN ISNULL(ml.Quantity, 0) > ISNULL(ml.Quantity, 0) - h.Quantity THEN 0 ELSE 1 END,
		dbo.GetMaxValue(ISNULL(ml.Quantity, 0) - h.Quantity, h.Quantity - ISNULL(ml.Quantity, 0)),
		'PICKING' , 'Parts from bom of components (Adjusted)'
		FROM @Harware AS h
		LEFT JOIN @MaterialList AS ml ON ml.InventoryID = h.InventoryID
		LEFT JOIN @ReplaceSlides AS rs ON h.InventoryID = rs.ToRemove

		MERGE @AddremoveRules AS arr USING 
		(
			SELECT bomd.InventoryID, bomd.QtyRequired * tl.Quantity AS Quantity 
			FROM @TotalLeft AS tl
			JOIN dbo.tb_ItemList AS til ON tl.InventoryID = til.AcumaticaName
			CROSS JOIN @BasicItemInfo AS bii
			JOIN acumaticaManufacturing.BillOfMaterials AS bom ON bom.InventoryID = tl.InventoryID
			JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			LEFT JOIN @MaterialList AS ml ON ml.InventoryID = bomd.InventoryID
			WHERE bomd.DeleteFlag = 0
			AND bom.DeleteFlag = 0
			AND bom.Status = 'Active'
			AND 
			(
				(
					bom.Revision = 'HARDWARE' 
					AND 
					(
						bii.DoorStyleID <> 26
						OR til.ComponentPartTypeId NOT IN (7, 17)
					)
				)
				OR 
				(
					bom.Revision = 'HF HARDWAR' 
					AND 
					(
						bii.DoorStyleID = 26
						AND til.ComponentPartTypeId IN (7, 17)
					)
				)
			) 
			AND  bomd.QtyRequired * tl.Quantity <> ml.Quantity
			AND til.ComponentPartTypeId IN(7, 9, 17, 29)
		) AS nh
		ON arr.InventoryId = nh.InventoryID
		AND arr.AddRemoveAction = 'Add'
		WHEN MATCHED 
		THEN UPDATE SET arr.Quantity = arr.Quantity + nh.Quantity
		WHEN NOT MATCHED BY TARGET
		THEN INSERT(AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart )
		VALUES ('Add', nh.InventoryID, 0, nh.Quantity, 'PICKING', 'Parts from bom of components (new)');
	END

	--FF-341
	IF EXISTS -- shelf ship loose
	(
		SELECT * FROM dbo.TranEntry AS te
		JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
		WHERE til.ProductID IN(497,498,499,606,607,608,610,611,612,613,614,615,616,617,618,660,661,749,777,778,779)
		AND te.ID = @orderItemId
	)
	--FF-414
	--OR 
	--(
	--	EXISTS
	--	(
	--		SELECT * FROM @SubItem AS si 
	--		WHERE si.SubItemListId = 106915
	--	) --MATCHING-INTERIOR
	--	AND NOT EXISTS
	--	(
	--		SELECT * FROM @SubItem AS si
	--		WHERE si.SubItemListId  NOT IN (106915, 106907) 
	--		OR
	--		(
	--			si.SubItemListId  = 106907 --cut door
	--			AND @bomRevision = 'D'
	--		)				
	--	)
	--)

	BEGIN
		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart )
		VALUES('Remove', 'PLASTIC SHELF HOLDER', 0, 1, 'PICKING', 'PLASTIC SHELF HOLDER for ship shelf loose')
	END

	--FF-264
	INSERT @AddremoveRules(RuleId, AddRemoveAction, InventoryId, Quantity, QuantityAll, WorkCenter, FunctionPart)--replacements
	SELECT ir.RuleId, 'Remove',  ir.RemovePartAcumaticaName, ir.Quantity, 0, 'PICKING' , 'Replacements'
	FROM @itemReplace AS ir
	UNION ALL
	SELECT ir.RuleId, 'Add', ir.AddPartAcumaticaName, ir.Quantity, 0, 'PICKING', 'Replacements'
	FROM @itemReplace AS ir

	--FF-509
	DELETE addRule FROM @AddremoveRules AS addRule
	WHERE addRule.AddRemoveAction = 'Add'
	AND InventoryId = 'BB SLIDES 20"'

	IF EXISTS(SELECT * FROM dbo.TranEntry AS te WHERE te.ID = @orderItemId AND te.BoxOnly = 1)
	BEGIN
		DELETE @AddremoveRules  WHERE InventoryId IN
		(
			SELECT ml.InventoryID 
			FROM @MaterialList ml
			JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
			OUTER APPLY
			(
				SELECT CAST( CASE WHEN EXISTS
				(
					SELECT * FROM dbo.TranEntry TE 
					JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
					WHERE TE.ID = @orderItemId 
					AND TIL.ProductID IN(413, 412)
				)THEN 1 ELSE 0 END AS BIT) AS IsLsb
			)AS IsLsb
			WHERE til.ComponentPartTypeId IN(11, 7, 17, 29) 
			OR 
			(
				til.ComponentPartTypeId IN (9) 
				AND IsLsb.IsLsb = 0
			)
			OR
			(
				til.ComponentPartTypeId IN (23, 25)
				AND 
				(
					IsLsb.IsLsb = 0
					OR ml.InventoryID NOT IN('CSC','PLASTIC SHELF HOLDER','VSC')
				)
					
			)
		)

		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity)
		SELECT 'Remove', ml.InventoryID, 1, ml.Quantity 
		FROM @MaterialList ml
		JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
		OUTER APPLY
		(
			SELECT CAST( CASE WHEN EXISTS
			(
				SELECT * FROM dbo.TranEntry TE 
				JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
				WHERE TE.ID = @orderItemId 
				AND TIL.ProductID IN(413, 412)
			)THEN 1 ELSE 0 END AS BIT) AS IsLsb
		)AS IsLsb
		WHERE til.ComponentPartTypeId IN( 11, 7, 17, 29) 
		OR 
		(
			til.ComponentPartTypeId IN (9) 
			AND IsLsb.IsLsb = 0
		)	
		OR
		(
			til.ComponentPartTypeId IN (23, 25)
			AND 
			(
				IsLsb.IsLsb = 0
				OR ml.InventoryID NOT IN('CSC','PLASTIC SHELF HOLDER','VSC')
			)
					
		)
	END


	RETURN
END
GO
/****** Object:  UserDefinedFunction [picking].[GetBOMAdjustmentsForModsStaging]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
 --=============================================
 --Author:		Yakov Muller
 --Create date: 8/23/2019
 --Description:	Get Custom Finish Rules For OrderItemId
 --=============================================
CREATE FUNCTION [picking].[GetBOMAdjustmentsForModsStaging]
(
	@orderItemId INT,
	@MaterialList OrderMaterialDetail READONLY,
	@bomRevision VARCHAR(1) = 'C'
)

--DECLARE @ProductionItemCode VARCHAR(50) = NULL,@MaterialList   dbo.OrderMaterialDetail  , @bomRevision VARCHAR(50), 
--@OrderItemId INT = 14517061
--SELECT @ProductionItemCode = il.AcumaticaName , @bomRevision= oipiir.revision FROM picking.OrderItemProductionItemIRelease oipiir
--JOIN dbo.TranEntry te ON te.ID = oipiir.OrderItemId
--JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
--WHERE te.ID = @OrderItemId
--INSERT @MaterialList ( InventoryID, Quantity )
--SELECT bomd.InventoryID, bomd.QtyRequired FROM acumaticaManufacturing.BillOfMaterials bom
--JOIN acumaticaManufacturing.BillOfMaterialDetails bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = bom.DeleteFlag AND bom.DeleteFlag=0  
--WHERE bom.InventoryID=@ProductionItemCode AND bom.Revision=@bomRevision

RETURNS @AddremoveRules TABLE 
(
	RuleId INT NULL,
	AddRemoveAction VARCHAR(10),
	InventoryId VARCHAR(50),
	Quantity INT DEFAULT(1),
	QuantityAll BIT DEFAULT(0),
	WorkCenter VARCHAR(50) DEFAULT ('PICKING'),
	OperationDescription VARCHAR(400),
	OperationNumber VARCHAR(10),
	Backflush BIT DEFAULT(1),
	PartType INT,
	FunctionPart VARCHAR(250),
	AddonMinutes DECIMAL(10, 2) NULL,
	GroupId INT NULL 
)

AS BEGIN
	DECLARE @SubItem TABLE(MainItemListId INT NOT NULL, SubItemListId INT NOT NULL, MainProductId INT NULL, SubProductId INT NULL, IsAddOn BIT NOT NULL, SubItemType INT NULL,
		MainProductCode VARCHAR(50) NULL, SubProductCode VARCHAR(50) NULL, MainDoorStyleId INT NULL, HasCustomizing BIT NULL, MainAcumaticaProductId INT NULL, 
		SubAcumaticaProductId INT NULL, SubShortItemCode NVARCHAR(150) NOT NULL
	)
	INSERT @SubItem	(MainItemListId, SubItemListId, MainProductId, SubProductId, IsAddOn, SubItemType, MainProductCode, SubProductCode, MainDoorStyleId, HasCustomizing, 
	MainAcumaticaProductId, SubAcumaticaProductId, SubShortItemCode)
	SELECT tilM.ID, tilS.ID, tilM.ProductID, tilS.ProductID, iao.IsAddOn, tilS.ItemTypeCode, pMain.ProductCode, pSub.ProductCode, tilM.DoorStyleID, te.HasCustomizing,
	asiM.AcumaticaProductID, asiS.AcumaticaProductID, tilS.ShortItemCode
	FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS tilM ON tilM.ItemCode = te.ItemNumber
	LEFT JOIN inventory.AcumaticaStockItems AS asiM ON asiM.AcumaticaID = tilM.AcumaticaID
	LEFT JOIN inventory.Products AS pMain ON pMain.ProductID = tilM.ProductID
	JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID AND te.EZProdID = te2.EZParentProdID
	JOIN dbo.tb_ItemList AS tilS ON tilS.ItemCode = te2.ItemNumber
	LEFT JOIN inventory.AcumaticaStockItems AS asiS ON asiS.AcumaticaID = tilS.AcumaticaID
	LEFT JOIN inventory.Products AS pSub ON pSub.ProductID = tilS.ProductID
	CROSS APPLY
	(
		SELECT CAST
		(
			CASE WHEN 
				tilS.ItemTypeCode = 7 
				AND te2.ItemNumber NOT IN ('ACCESSORIES:LST33', 'ACCESSORIES:LST36')
			THEN 1 
			ELSE 0 
			END AS BIT
		)
	)AS iao(IsAddOn)
	WHERE te.ID = @orderItemId
	AND te2.isDeleted = 0

	DECLARE @OrderItemConfig TABLE(ConfigKey VARCHAR(4000)NULL, ConfigValue VARCHAR(4000) NULL)
	INSERT @OrderItemConfig(ConfigKey, ConfigValue)
	SELECT goict.ConfigKey, goict.ConfigValue FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict

	DECLARE @AddonRule TABLE(AddonId INT NOT NULL, InventoryID VARCHAR(450) NOT NULL, AddonQty INT NOT NULL, RemoveAll BIT NOT NULL DEFAULT(0), QtyToRemove INT NOT NULL DEFAULT(0),
	MaterialToRemove VARCHAR(450) NULL, WorkCenter VARCHAR(50), Backflush BIT, AddonMinutes DECIMAL(10, 2), ComponentPartTypeId INT, RemoveComponentPartTypeId INT);
	WITH AddON AS
	(
		SELECT sim.SubItemListId AS AddonId, COUNT(*) AS Qty
		FROM @SubItem AS sim
		WHERE sim.IsAddOn = 1
		GROUP BY sim.SubItemListId
	)
	INSERT @AddonRule (AddonId, InventoryID, AddonQty, RemoveAll, QtyToRemove, MaterialToRemove, WorkCenter, Backflush, AddonMinutes, ComponentPartTypeId, RemoveComponentPartTypeId)
	SELECT il.ID,
	il.AcumaticaName AS InventoryId,
	AddON.Qty AS AddonQty,
	COALESCE(mtr.RemoveAll, 0),
	CASE 
			WHEN mtr.RemoveComponentPartTypeId IS NULL THEN 0
			WHEN mtr.RemoveAll = 1 THEN AddON.Qty
			WHEN mtr.RemovePerUnit = 1 AND AddON.Qty >= mtr.AddonQtyAndAboveRemove THEN (AddON.Qty - (mtr.AddonQtyAndAboveRemove - 1)) * mtr.RemovePerUnit 
			ELSE 0 
	END QtyToRemove,
	mtr.MaterialToRemove,
	'PICKING',
	0,
	ISNULL(addOnMinutes.Minutes, 0),
	il.ComponentPartTypeId,
	mtr.RemoveComponentPartTypeId
	FROM AddON
	JOIN dbo.tb_ItemList AS il ON il.ID = AddON.AddonId
	LEFT JOIN dbo.ProductionWorkCenter AS pwc ON pwc.ProductionWorkcenterId = 7
	OUTER APPLY
	(
		SELECT ml.InventoryID AS MaterialToRemove,
		arm.RemoveAll,
		arm.RemovePerUnit,
		arm.RemoveComponentPartTypeId,
		arm.AddonQtyAndAboveRemove
		FROM @MaterialList AS ml
		JOIN dbo.tb_ItemList AS mii ON mii.AcumaticaName = ml.InventoryID
		JOIN inventory.ComponentPartType AS cpt ON cpt.ComponentPartTypeId = mii.ComponentPartTypeId
		JOIN picking.ProductionItemAddonRule AS arm ON arm.AddonId = AddON.AddonId
			AND arm.RemoveComponentPartTypeId = cpt.ComponentPartTypeId
	) AS mtr
	OUTER APPLY
	(
		SELECT TOP 1 aom.Minutes
		FROM dbo.AddonOperationMinutes AS aom
		WHERE aom.ItemListID = AddON.AddonId
		AND aom.AddonQty = AddON.Qty
		AND aom.DeleteFlag = 0
	) AS addOnMinutes

	IF @bomRevision IN( 'A', 'FG')
		RETURN

	INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, AddonMinutes, Backflush, PartType, FunctionPart) --AddOns
	SELECT 'Add', ar.InventoryID, 0, ar.AddonQty, ar.WorkCenter, ar.AddonMinutes, ar.Backflush, ar.ComponentPartTypeId, 'AddOns'
	FROM @AddonRule AS ar
	UNION ALL
	SELECT 'Remove', ar.MaterialToRemove, ar.RemoveAll, ar.QtyToRemove, ar.WorkCenter, NULL, Backflush, ar.RemoveComponentPartTypeId, 'Addon Remove Shelves'  
	FROM @AddonRule AS ar
	WHERE ar.MaterialToRemove IS NOT NULL
	AND ar.QtyToRemove > 0

	DECLARE @BasicItemInfo TABLE(DoorStyleID INT NULL, ProductCode VARCHAR(50) NULL, ProductID INT NULL, HasCustomizing BIT NULL, 
		AcumeticaId INT NULL, ItemTypeId INT NULL, EZProdID VARCHAR(25) NULL)
	INSERT @BasicItemInfo(DoorStyleID, ProductCode, ProductID, HasCustomizing, AcumeticaId, ItemTypeId, EZProdID)
	SELECT til.DoorStyleID, p.ProductCode, til.ProductID, te.HasCustomizing, til.AcumaticaID, til.ItemTypeCode, te.EZProdID
	FROM dbo.TranEntry AS te 
	JOIN dbo.tb_ItemList AS til ON te.ItemNumber = til.ItemCode
	JOIN inventory.Products AS p ON p.ProductID = til.ProductID
	WHERE te.ID = @orderItemId

	DECLARE @Rules TABLE(RuleId INT NOT NULL, GroupId INT NULL, ComponentPartTypeId INT NULL, ActionType VARCHAR(50) NOT NULL, CausingSubItemType INT NULL);

	WITH Rules AS
	(
		SELECT pimarr.*, Cause.SubItemType AS CauseSubItemType, mtarrd.ModificationToAddRemoveRuleDetailId,
		mtarrd.ModificationToAddRemoveRuleHeaderId, mtarrd.ToCancelOtherInGroup, Cause.MainDoorStyleId, Cause.MainProductId, Cause.MainProductCode
		FROM picking.ProductionItemModifcationAddRemoveRules AS pimarr
		JOIN picking.ModificationToAddRemoveRuleHeader AS mtarrh ON mtarrh.ProductionItemModifcationAddRemoveRuleId = pimarr.ProductionItemModifcationAddRemoveRuleId
		JOIN picking.ModificationToAddRemoveRuleDetail AS mtarrd ON mtarrd.ModificationToAddRemoveRuleHeaderId = mtarrh.ModificationToAddRemoveRuleHeaderId
		CROSS APPLY
		(
			SELECT si.MainDoorStyleId, si.MainProductCode, si.MainProductId, si.HasCustomizing, si.SubItemType
			FROM @SubItem AS si 
			WHERE si.SubItemListId = mtarrd.ModificationId
			UNION ALL
			SELECT bii.DoorStyleID, bii.ProductCode, bii.ProductID, bii.HasCustomizing, NULL
			FROM @OrderItemConfig AS oic
			CROSS JOIN @BasicItemInfo AS bii
			WHERE oic.ConfigKey LIKE mtarrd.ConfigKey
			AND oic.ConfigValue = mtarrd.ConfigValue
		)AS Cause
	)
	INSERT @Rules (RuleId, ComponentPartTypeId, ActionType, CausingSubItemType, GroupId)
	SELECT r.ProductionItemModifcationAddRemoveRuleId, r.PartId, r.AddRemoveType, r.CauseSubItemType, r.ModificationToAddRemoveRuleHeaderId
	FROM Rules AS r
	WHERE r.ToCancelOtherInGroup = 0
	AND NOT EXISTS --Missing condition
	(
		SELECT * FROM picking.ModificationToAddRemoveRuleDetail AS mtarrd2
		WHERE mtarrd2.ModificationToAddRemoveRuleHeaderId = r.ModificationToAddRemoveRuleHeaderId
		AND NOT EXISTS
		(
			SELECT * FROM Rules AS r2
			WHERE mtarrd2.ModificationToAddRemoveRuleDetailId = r2.ModificationToAddRemoveRuleDetailId
		)
		AND mtarrd2.ToCancelOtherInGroup = 0
	)
	AND NOT EXISTS --Canceling condition
	(
		SELECT * FROM Rules AS r3
		WHERE r3.ToCancelOtherInGroup = 1
		AND r3.ModificationToAddRemoveRuleHeaderId = r.ModificationToAddRemoveRuleHeaderId
	)
	AND
	(
		r.ExcludeStyle IS NULL
		OR NOT EXISTS
		(
			SELECT * FROM inventory.DoorStyles AS ds
			WHERE ds.DoorStyleID = r.MainDoorStyleId
			AND EXISTS
			(
				SELECT * FROM dbo.FN_ListToTable( ' ', r.ExcludeStyle) AS fltt
				WHERE ds.Style LIKE '%' + fltt.ListValue + '%'
			)
		)
	) 
	AND 
	(
		r.OnlyWhenProductHasText IS NULL
		OR r.MainProductCode LIKE '%' + r.OnlyWhenProductHasText + '%'
	)
	AND 
	(
		r.ExcludeWhenProductHasText IS NULL 
		OR NOT EXISTS
		(
			SELECT * FROM dbo.FN_ListToTable(' ', r.ExcludeWhenProductHasText) AS fltt
			WHERE r.MainProductCode LIKE '%' +  fltt.ListValue  + '%'
		)	
	)	
	AND 
	( 
		r.ExcludeTag IS NULL 
		OR NOT EXISTS 
		(
			SELECT * FROM inventory.ProductToProductTags ptpt 
			WHERE r.ExcludeTag = ptpt.ProductTagId 
			AND ptpt.ProductId = r.MainProductId 
			AND ptpt.DeleteFlag = 0
		)
	)
	AND 
	( 
		r.HasCustomizing IS NULL 
		OR r.HasCustomizing = r.HasCustomizing  
	)
	--FF-525 https://jira.fabuwood.com/browse/FF-525?focusedCommentId=115098&page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel#comment-115098
	AND 
	(
		r.ExcludeWhenAnySubItemHasTag IS NULL
		OR NOT EXISTS
		(
			SELECT * FROM @SubItem AS si
			JOIN inventory.AcumaticaProductToProductTag AS aptpt ON si.SubAcumaticaProductId = aptpt.AcumaticaProductId
			AND aptpt.Deleted = 0
			AND aptpt.ProductTagId = r.ExcludeWhenAnySubItemHasTag
		)
	)
		
	DECLARE @itemAddRemove TABLE (ProductionItemModifcationAddRemoveRuleId INT NULL, ModifcationId INT, ActionType VARCHAR(10), PartTypeId INT, PartType VARCHAR(50), PartItemCode VARCHAR(50), 
	QuantityAll BIT DEFAULT(1), Quantity INT NULL, FunctionPart VARCHAR(50), OnlyRemoveWhenAdd BIT NULL, GroupId INT NULL)

	INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, QuantityAll, FunctionPart, OnlyRemoveWhenAdd, GroupId)
	SELECT cr.RuleId, cr.ActionType, 
	COALESCE(DrawerSelection.PartId, drawerBoxInMl.ComponentPartTypeId, cr.ComponentPartTypeId-- tilRemoveComponent.ComponentPartTypeId
	),  
	COALESCE(DrawerSelection.InventoryId, drawerBoxInMl.InventoryID, ml.InventoryID), 
	COALESCE(DrawerSelection.Quantity, pimarr.Quantity), 
	CASE WHEN COALESCE(DrawerSelection.Quantity, pimarr.Quantity) IS NOT NULL AND COALESCE(DrawerSelection.Quantity, pimarr.Quantity) > 0 THEN 0 ELSE 1 END, 
	'Remove',
	pimarr.OnlyRemoveWhenAdd, cr.GroupId
	FROM @Rules AS cr
	JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON cr.RuleId = pimarr.ProductionItemModifcationAddRemoveRuleId
	JOIN dbo.tb_ItemList AS tilRemoveComponent ON tilRemoveComponent.ComponentPartTypeId = cr.ComponentPartTypeId 
	--FF-621
	OR
	(
		cr.ComponentPartTypeId IN(9, 29) 
		AND tilRemoveComponent.ComponentPartTypeId IN(9, 29)
	)
	JOIN @MaterialList ml ON tilRemoveComponent.AcumaticaName = ml.InventoryID 
	CROSS JOIN @BasicItemInfo AS bii
	OUTER APPLY
	(
		SELECT Drawers.ComponentPartId AS PartId, Drawers.InventoryId, Drawers.ItemListId, COUNT(*) AS Quantity 
		FROM @OrderItemConfig AS oic
		CROSS APPLY
		(
			SELECT TOP (1) mcr.ComponentPartId, ml2.InventoryID, tildb.ID AS ItemListId
			FROM DrawerConfigModRules AS mcr
			JOIN dbo.tb_ItemList AS tildb ON tildb.ComponentPartTypeId = mcr.ComponentPartId 
			JOIN @MaterialList AS ml2 ON tildb.AcumaticaName = ml2.InventoryID
			WHERE mcr.Config = oic.ConfigValue
			ORDER BY CASE WHEN mcr.ProductId = bii.ProductID
			THEN 0 WHEN mcr.ProductId IS NULL THEN 1 ELSE 2 END
		)AS Drawers
		WHERE oic.ConfigKey = 'Remove Drawers'
		AND cr.RuleId = 31
		GROUP BY Drawers.ComponentPartId, Drawers.InventoryID, Drawers.ItemListId
	)AS DrawerSelection
	OUTER APPLY
	(
		SELECT TOP (1) tilDb.ComponentPartTypeId, ml2.InventoryID, tilDb.ID AS ItemListId
		FROM @MaterialList AS ml2
		JOIN dbo.tb_ItemList AS tilDb ON tilDb.AcumaticaName = ml2.InventoryID
		WHERE tilDb.ComponentPartTypeId IN(7, 17)
		AND cr.RuleId = 31
	)AS drawerBoxInMl
	OUTER APPLY
	(
		SELECT tilFinalRemove.ID AS ItemListId, p.ProductID, p.ProductCode
		FROM dbo.tb_ItemList AS tilFinalRemove
		JOIN inventory.Products AS p ON p.ProductID = tilFinalRemove.ProductID
		WHERE tilFinalRemove.ID = COALESCE(DrawerSelection.ItemListId, drawerBoxInMl.ItemListId, tilRemoveComponent.ID)
	)AS FinalRemove
	WHERE cr.ActionType = 'Remove'
	AND 
	(
		pimarr.PartExcludeTag IS NOT NULL
		OR NOT EXISTS
		(
			SELECT * FROM inventory.ProductToProductTags AS ptpt
			WHERE ptpt.DeleteFlag = 0
			AND FinalRemove.ProductID = ptpt.ProductId
			AND ptpt.ProductTagId = pimarr.PartExcludeTag
		)
	)
	AND 
	(
		pimarr.ExcludeWhenPartProductCodeHasText IS NULL
		OR FinalRemove.ProductCode NOT LIKE '%' + pimarr.ExcludeWhenPartProductCodeHasText + '%'
	)		
		
	INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, FunctionPart, GroupId)
	SELECT pimarr.ProductionItemModifcationAddRemoveRuleId, pimarr.AddRemoveType , COALESCE(pimarr.PartId, parts.ComponentPartTypeId), 
	parts.InventoryID, parts.QtyRequired, 'From Sub Item: ' + si.SubShortItemCode, r.GroupId
	FROM @Rules AS r
	JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON pimarr.ProductionItemModifcationAddRemoveRuleId = r.RuleId
	JOIN @SubItem AS si ON si.SubItemType = pimarr.SubItemType OR pimarr.SubItemType IS NULL OR (pimarr.PartId IS NULL AND si.SubItemType IN (1, 2))
	CROSS JOIN @BasicItemInfo AS bii
	CROSS APPLY
	(
		SELECT bomd.InventoryID, tilBomd.ComponentPartTypeId, bomd.QtyRequired, p.ProductID, p.ProductCode, tilBomd.ShortItemCode, tilBom.ProductID AS MainProductID
		FROM acumaticaManufacturing.BillOfMaterials AS bom
		JOIN dbo.tb_ItemList AS tilBom ON bom.InventoryID = tilBom.AcumaticaName 
		JOIN acumaticaManufacturing.BillOfMaterialOperations AS bomo ON bomo.BOMID = bom.BOMID AND bomo.DeleteFlag = 0
		JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = 0 AND bomd.OperationDbId = bomd.OperationDbId
		JOIN acumaticaManufacturing.BOMRevisions AS br ON br.AcumaticaName = bom.InventoryID AND bom.BOMID = COALESCE(br.BOMIDC, br.BOMIDB, br.BOMIDD, br.BOMIDE)
		JOIN dbo.tb_ItemList AS tilBomd ON tilBomd.AcumaticaName = bomd.InventoryID
		LEFT JOIN inventory.Products AS p ON p.ProductID = tilBomd.ProductID
		WHERE si.SubItemListId = tilBom.ID
		AND bom.DeleteFlag = 0  
		AND bomo.WorkCenter = 'PICKING' 
	)AS Parts
	WHERE r.ActionType = 'Add'
	AND 1 IN(pimarr.FromSubItem, pimarr.FromSubItemWhenPossible)
	AND
	(
		Parts.ComponentPartTypeId = r.ComponentPartTypeId
		OR r.ComponentPartTypeId IS NULL
		--FF-621
		OR
		(
			Parts.ComponentPartTypeId IN(9, 29) 
			AND  r.ComponentPartTypeId IN(9, 29)
		)
	)
	AND
	(
		Parts.ComponentPartTypeId <> 11
		OR NOT EXISTS
		(
			SELECT * FROM @SubItem AS si2
			WHERE si2.SubItemListId = 153925 --DOORS ON BO
		)
	)
	AND 
	(
		pimarr.OnlyFromTag IS NULL
		OR EXISTS 
		(
			SELECT * FROM inventory.ProductToProductTags ptpt 
			WHERE pimarr.OnlyFromTag = ptpt.ProductTagId 
			AND ptpt.ProductId = Parts.MainProductId 
			AND ptpt.DeleteFlag = 0
		)
	)
	AND 
	(
		pimarr.PartExcludeTag IS NULL 
		OR NOT EXISTS
		(
			SELECT * FROM inventory.ProductToProductTags AS ptpt 
			WHERE ptpt.ProductId = Parts.ProductID 
			AND ptpt.ProductTagId = pimarr.PartExcludeTag 
			AND ptpt.DeleteFlag=0
		)
	)
	AND 
	(
		pimarr.ExcludeWhenPartProductCodeHasText IS NULL 
		OR Parts.ProductCode NOT LIKE '%' + pimarr.ExcludeWhenPartProductCodeHasText + '%'
	)
	AND 
	(
		ISNULL(pimarr.OnlyAddWhenRemove, 0) = 0
		OR EXISTS
		(
			SELECT * FROM @itemAddRemove AS iar
			WHERE iar.ActionType = 'Remove'
			AND iar.PartTypeId = parts.ComponentPartTypeId
		)
	)
	AND NOT EXISTS
	(
		SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
		JOIN inventory.AcumaticaStockItems asi ON asi.AcumaticaID=asitoi.StockAcumaticaID AND asi.DeleteFlag=0
		JOIN inventory.ItemStatuses ist ON  asi.ItemStatus=ist.StatusName AND ist.ActiveStatus=1
		WHERE asi.Name = Parts.InventoryID
		AND asitoi.SortComponent >= asitoi.Quantity
		AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
	)	  
	AND NOT 
	(
		NOT EXISTS
		(
			SELECT * FROM dbo.ItemLocationsUpdate ilu
			JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
			WHERE il.ExcludeFrmStock = 0
			AND il.LocationType <> 13
			AND ilu.ItemCode = Parts.ShortItemCode
		)
		AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
	)
	AND --MatchOnTag
    (
		pimarr.MatchOnTag IS NULL
		OR --original and replacement have tag
		(
			EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt 
				WHERE bii.ProductID = ptpt.ProductTagId 
				AND ptpt.ProductTagId = pimarr.MatchOnTag 
				AND ptpt.DeleteFlag = 0
			)
			AND EXISTS 
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt 
				WHERE Parts.MainProductID = ptpt.ProductTagId 
				AND ptpt.ProductTagId = pimarr.MatchOnTag 
				AND ptpt.DeleteFlag = 0
			)
		)
		OR --original and replacement don't have tag
		(
			NOT EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt 
				WHERE bii.ProductID = ptpt.ProductTagId 
				AND ptpt.ProductTagId = MatchOnTag 
				AND ptpt.DeleteFlag=0
			)
			AND NOT EXISTS 
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt 
				WHERE Parts.MainProductID = ptpt.ProductTagId 
				AND ptpt.ProductTagId = MatchOnTag 
				AND ptpt.DeleteFlag = 0
			)	
		)	
	)
	AND r.CausingSubItemType = 4	
			
	INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, FunctionPart, GroupId)
	SELECT r.RuleId, 'Add', r.ComponentPartTypeId, prtsToAdd.InventoryID, pimarr.Quantity, 'Not from sub item', r.GroupId
	FROM @Rules AS r
	JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON pimarr.ProductionItemModifcationAddRemoveRuleId = r.RuleId
	CROSS JOIN @BasicItemInfo AS bii
	JOIN dbo.tb_AdjustedBoxDimensions abd ON abd.TranEntryID = @orderItemId
	JOIN inventory.AcumaticaStockItems asi ON asi.AcumaticaID = bii.AcumeticaId
	CROSS APPLY
	(
		SELECT TOP (1) bom.InventoryID item, bomd.InventoryID, tilBomd.ShortItemCode, asi2.Height, asi2.Width, asi2.Depth, tilBomd.AcumaticaDesc,
		tilBomd.ComponentPartTypeId
		FROM acumaticaManufacturing.BillOfMaterials bom
		JOIN dbo.tb_ItemList AS tilBom ON bom.InventoryID = tilBom.AcumaticaName 
		JOIN inventory.AcumaticaStockItems asi2 ON asi2.AcumaticaID = tilBom.AcumaticaID
		JOIN acumaticaManufacturing.BillOfMaterialDetails bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = 0 
		JOIN dbo.tb_ItemList AS tilBomd ON tilBomd.AcumaticaName = bomd.InventoryID 
		JOIN inventory.AcumaticaStockItems AS asiBomDetail ON asiBomDetail.AcumaticaID = tilBomd.AcumaticaID
		WHERE bom.Revision <> 'A'
		AND tilBom.DoorStyleID = bii.DoorStyleID 
		AND tilBom.ItemTypeCode = bii.ItemTypeId
		AND bom.DeleteFlag = 0
		AND 
		(
			tilBomd.ComponentPartTypeId = r.ComponentPartTypeId
			--FF-621
			OR 
			(
				r.ComponentPartTypeId IN(9, 29)
				AND tilBomd.ComponentPartTypeId  IN(9, 29)
			)
		)

		AND
		(
			(
				(
					(   
						EXISTS (SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Depth')
						AND EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Height')
						AND NOT EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Width')
						AND 
						(
							(
								asi2.Depth >= asi.Depth + abd.AdjustDepth 
								AND 
								(
									(
										asi2.Height >= asi.Height + abd.AdjustHeight 
										AND pimarr.SpecificHeight IS NULL
									) 
									OR pimarr.SpecificHeight = asi2.Height
								)
								AND ISNULL(pimarr.ExactMeasurementsOnly, 0) = 0
							)
							OR EXISTS
							(
								SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
								WHERE gab.Depth = asi.Depth + abd.AdjustDepth 
								AND 
								(
									(
										gab.Height = asi.Height + abd.AdjustHeight 
										AND pimarr.SpecificHeight IS NULL
									)
									OR gab.Height = pimarr.SpecificHeight
								)
							)
						)
					)
					OR
					(   
						EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Depth')
						AND EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Width')
						AND NOT EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Height')
						-- hard coded for full hight door add shelf, if it happens more, add column to table "ProductionItemModifcationAddRemoveRules" to indicate
						AND 
						(
							r.RuleId <> 45
   							OR 
							(
								EXISTS 
								(
									SELECT * FROM inventory.DoorStyles dsc WHERE bii.DoorStyleID = dsc.DoorStyleID
									AND EXISTS 
									(
										SELECT * FROM inventory.DoorStyles dsr WHERE tilBom.DoorStyleID = dsr.DoorStyleID 
										AND 
										(
											(
												dsr.SeriesName IN ('Allure', 'Classic') 
												AND dsc.SeriesName IN ('Allure', 'Classic')
											) 
											OR 
											(
												dsr.SeriesName NOT IN ('Allure', 'Classic') 
												AND dsc.SeriesName NOT IN ('Allure', 'Classic')
											)
										)
									)
								)
							)
						)
						AND 
						(
							(
								asi2.Depth >= asi.Depth + abd.AdjustDepth 
								AND asi2.Width >= asi.Width + abd.AdjustWidth 
								AND ISNULL(pimarr.ExactMeasurementsOnly, 0) = 0 
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 0
								--18 = FF-662, 2 = FF-678
								AND 
								(
									asiBomDetail.Depth >= asi.Depth + abd.AdjustDepth - 1.375
									OR pimarr.ProductionItemModifcationAddRemoveRuleId NOT IN(2, 18)
								)
							)
							OR 
							(
								EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
								WHERE gab.Depth = asi.Depth + abd.AdjustDepth AND gab.Width = asi.Width + abd.AdjustWidth)
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 1
							)
						)
					)
					OR
					(   EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Width')
						AND EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Height')
						AND NOT EXISTS(SELECT 1 FROM ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Depth')
						AND 
						(
							(
								asi2.Width >= asi.Width + abd.AdjustWidth 
								AND 
								(
									(
										asi2.Height >= asi.Height + abd.AdjustHeight 
										AND pimarr.SpecificHeight IS NULL
									) 
									OR pimarr.SpecificHeight = asi2.Height
								)
								AND ISNULL(pimarr.ExactMeasurementsOnly, 0) = 0
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 0
							)
							OR 
							(
								EXISTS
								(
									SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
									WHERE gab.Width = asi.Width + abd.AdjustWidth
									AND
									(
										(
											gab.Height = asi.Height + abd.AdjustHeight 
											AND pimarr.SpecificHeight IS NULL
										) 
										OR gab.Height = pimarr.SpecificHeight
									)
								)
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 1
							)
						)
					)
					OR
					(
						EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Width')
						AND EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Height')
						AND EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Depth')
						AND 
						(
							(
								asi2.Width >= asi.Width + abd.AdjustWidth 
								AND asi2.Depth >= asi.Depth + abd.AdjustDepth 
								AND 
								(
									(
										asi2.Height >= asi.Height + abd.AdjustHeight 
										AND pimarr.SpecificHeight IS NULL
									) 
									OR pimarr.SpecificHeight = asi2.Height
								)						
								AND ISNULL(pimarr.ExactMeasurementsOnly, 0) = 0
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 0
							)  
							OR 
							(
								EXISTS
								(
									SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
									WHERE gab.Width = asi.Width + abd.AdjustWidth
									AND
									(
										(
											gab.Height = asi.Height + abd.AdjustHeight 
											AND pimarr.SpecificHeight IS NULL
										) 
										OR gab.Height = pimarr.SpecificHeight
									)
									AND gab.Depth = asi.Depth + abd.AdjustDepth
								)
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 1
							)
						)
					)
					OR
					(
						EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Width')
						AND NOT EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Height')
						AND NOT EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr WHERE cptmr.ComponentPartTypeId = r.ComponentPartTypeId AND cptmr.Dimension = 'Depth')
						AND 					
						(
							(
								asi2.Width >= asi.Width + abd.AdjustWidth 						
								AND ISNULL(pimarr.ExactMeasurementsOnly, 0) = 0
								AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 0
							)  
							OR 
							(
								EXISTS
								(
									SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
									WHERE gab.Width = asi.Width + abd.AdjustWidth
									AND ISNULL(pimarr.BaseMesurementsOnWholeCabinet, 0) = 1
								)
							)	
						)
					)
				)
				AND pimarr.PartToAddFromProduct IS NULL
			)
			OR
			(
				pimarr.PartToAddFromProduct IS NOT NULL 
				AND EXISTS 
				(
					SELECT * FROM  inventory.Products p 
					WHERE p.ProductCode = pimarr.PartToAddFromProduct 
					AND tilBom.ProductID = p.ProductID
				)
			)
		)
			 AND --from same belt
		 (
			 ISNULL(pimarr.FromSameBelt, 0) = 0 
			 OR EXISTS
			 (
				SELECT * FROM picking.DestinationLocationItemRule AS dlir 
				JOIN Picking.ProductionItem AS pi ON pi.ItemlistId = dlir.ProductionItemItemlistId
				WHERE EXISTS 
				(
					SELECT * FROM picking.DestinationLocationItemRule dlir2 
					WHERE dlir2.ProductionItemItemlistId = tilBom.ID
					AND dlir.DestinationLocationId = dlir2.DestinationLocationId
				)
				AND pi.OrderItemId = @orderItemId
			)
		 )
		 AND 
		(
			pimarr.PartExcludeTag IS NULL 
			OR NOT EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt  
				WHERE ptpt.ProductId = tilBom.ProductID
				AND ptpt.DeleteFlag = 0
				AND ptpt.ProductTagId = pimarr.PartExcludeTag
			)
		)	
		AND 
		(
			pimarr.OnlyFromTag IS NULL
			OR EXISTS 
			(
				SELECT * FROM inventory.ProductToProductTags ptpt 
				WHERE pimarr.OnlyFromTag = ptpt.ProductTagId 
				AND ptpt.ProductId = tilBom.ProductID
				AND ptpt.DeleteFlag = 0
			)
		)
		 AND 
		(
			pimarr.ExcludeWhenPartProductCodeHasText IS NULL 
			OR EXISTS
			(
				SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(tilBomd.ID) AS gab
				WHERE gab.ProductCode NOT LIKE '%' + pimarr.ExcludeWhenPartProductCodeHasText + '%' 
			) 
		)
		 AND NOT EXISTS
		 (
			 SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
			 WHERE asitoi.StockAcumaticaID = tilBomd.AcumaticaID
			 AND asitoi.SortComponent >= asitoi.Quantity
			 AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
		 )
		AND NOT 
		(
			NOT EXISTS
			(
				SELECT * FROM dbo.ItemLocationsUpdate ilu
				JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
				WHERE il.ExcludeFrmStock = 0
				AND il.LocationType <> 13
				AND ilu.ItemCode = tilBomd.ShortItemCode
			)
			AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
		)
		AND --MatchOnTag
        (
			pimarr.MatchOnTag IS NULL
			OR
			(
				--original and replacement have tag
				EXISTS
				(
					SELECT * FROM inventory.ProductToProductTags AS ptpt 
					WHERE bii.ProductID = ptpt.ProductTagId 
					AND ptpt.ProductTagId = pimarr.MatchOnTag 
					AND ptpt.DeleteFlag=0
				)
				AND EXISTS 
				(
					SELECT * FROM inventory.ProductToProductTags AS ptpt 
					WHERE tilBom.ProductID = ptpt.ProductTagId 
					AND ptpt.ProductTagId = pimarr.MatchOnTag 
					AND ptpt.DeleteFlag=0
				)
			)		
			OR --original and replacement don't have tag
			(
				NOT EXISTS
				(
					SELECT * FROM inventory.ProductToProductTags AS ptpt 
					WHERE bii.ProductID = ptpt.ProductTagId 
					AND ptpt.ProductTagId = pimarr.MatchOnTag 
					AND ptpt.DeleteFlag=0
				)
				AND NOT EXISTS 
				(
					SELECT * FROM inventory.ProductToProductTags AS ptpt 
					WHERE tilBom.ProductID = ptpt.ProductTagId 
					AND ptpt.ProductTagId = pimarr.MatchOnTag 
					AND ptpt.DeleteFlag=0
				)							
			)
		)	
		ORDER BY CASE WHEN EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr2 WHERE cptmr2.ComponentPartTypeId = tilBomd.ComponentPartTypeId AND cptmr2.Dimension = 'Width') THEN asi2.Width ELSE 1000 END, 
				CASE WHEN EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr2 WHERE cptmr2.ComponentPartTypeId = tilBomd.ComponentPartTypeId AND cptmr2.Dimension = 'Height') THEN asi2.Height ELSE 1000 END,
				CASE WHEN EXISTS(SELECT 1 FROM dbo.ComponentPartTypeMatchDimensionRules cptmr2 WHERE cptmr2.ComponentPartTypeId = tilBomd.ComponentPartTypeId AND cptmr2.Dimension = 'Depth') THEN asi2.Depth ELSE 1000 END
				,asi2.Height,asi2.Width,asi2.Depth
	) prtsToAdd
	WHERE r.ActionType = 'Add'
	AND
	(
		pimarr.FromSubItem = 0
		OR 
		(
			ISNULL(pimarr.FromSubItemWhenPossible, 0) = 1
			AND NOT EXISTS
			(
				SELECT * FROM @itemAddRemove AS iar
				WHERE iar.ActionType = 'Add'
				AND iar.ProductionItemModifcationAddRemoveRuleId = r.RuleId
			)
		)
	)
	AND 
	(
		ISNULL(pimarr.OnlyAddWhenRemove, 0) = 0
		OR EXISTS
		(
			SELECT * FROM @itemAddRemove AS iar
			WHERE iar.ActionType = 'Remove'
			AND iar.PartTypeId = r.ComponentPartTypeId
		)
	);

	--IL-3652 redone on --FF-264
	DECLARE @itemReplace TABLE(RuleId INT, AddPartAcumaticaName VARCHAR(50), Quantity INT, RemovePartAcumaticaName VARCHAR(50))

	INSERT @itemReplace(RuleId, AddPartAcumaticaName, Quantity, RemovePartAcumaticaName)
	SELECT pimarr.ProductionItemModifcationAddRemoveRuleId, ReplaceItem.AddAcumaticaName, COALESCE(maprd.QuantityToReplace, mlQty.Quantity, 0), tilRemove.AcumaticaName
	FROM @Rules AS r
	JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON pimarr.ProductionItemModifcationAddRemoveRuleId = r.RuleId
	CROSS JOIN @BasicItemInfo AS bii
	JOIN picking.ModificationAcuProductReplacementDetail AS maprd ON maprd.ModificationAcuProductReplacementHeaderId = pimarr.ModificationAcuProductReplacementHeaderId
	JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaProductID = maprd.OriginalAcuProductId
	JOIN dbo.tb_ItemList AS tilRemove ON asi.AcumaticaID = tilRemove.AcumaticaID
	CROSS APPLY
	(
		SELECT TOP (1) tilReplace.AcumaticaName AS AddAcumaticaName, tilReplace.ProductID, tilReplace.AcumaticaID, tilReplace.ShortItemCode AS AddShortItemCode 
		FROM dbo.tb_ItemList AS tilReplace 
		WHERE tilReplace.ProductID = maprd.ReplacementProductId
		AND ISNULL(tilReplace.DoorStyleID, bii.DoorStyleID) = bii.DoorStyleID		
	)AS ReplaceItem
	OUTER APPLY
	(
		SELECT ml.Quantity FROM @MaterialList AS ml
		WHERE ml.InventoryID = tilRemove.AcumaticaName
		AND maprd.QuantityToReplace IS NULL
	)mlQty
		
	WHERE pimarr.AddRemoveType = 'Replace'
	AND EXISTS
	(
		SELECT * FROM @MaterialList AS ml
		WHERE ml.InventoryID = asi.Name
	)
	AND 
	(
		pimarr.PartExcludeTag IS NULL
		OR NOT EXISTS
		(
			SELECT * FROM inventory.ProductToProductTags AS ptpt
			WHERE ReplaceItem.ProductID = ptpt.ProductId
			AND ptpt.DeleteFlag = 0
			AND pimarr.PartExcludeTag = ptpt.ProductTagId
		) 
	)
	AND 
	(
		pimarr.ExcludeWhenPartProductCodeHasText IS NULL
		OR NOT EXISTS
		(
			SELECT * FROM inventory.Products AS p2
			WHERE p2.ProductID = ReplaceItem.ProductID
			AND p2.ProductCode LIKE '%' + pimarr.ExcludeWhenPartProductCodeHasText + '%'
		)
	)
	AND NOT EXISTS
	(
		SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
		WHERE asitoi.StockAcumaticaID = ReplaceItem.AcumaticaID
		AND asitoi.SortComponent >= asitoi.Quantity
		AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
	)
	AND NOT 
	(
		NOT EXISTS
		(
			SELECT * FROM dbo.ItemLocationsUpdate ilu
			JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
			WHERE il.ExcludeFrmStock = 0
			AND il.LocationType <> 13
			AND ilu.ItemCode = ReplaceItem.AddShortItemCode
		)
		AND ISNULL(pimarr.OnlyWhenInStock, 0) = 1
	)
	AND
    (
			pimarr.ProductionItemModifcationAddRemoveRuleId <> 229
			OR dbo.OrderItemHasCutDoorsOnAllDoors(@orderItemId) = 1
	)
		
	INSERT INTO @AddremoveRules (RuleId, AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, PartType, FunctionPart, GroupId) --Remove
	SELECT iar.ProductionItemModifcationAddRemoveRuleId, iar.ActionType, iar.PartItemCode,  iar.QuantityAll, SUM(COALESCE(iar.Quantity, qty.Quantity,1)),'PICKING' , iar.PartTypeId, iar.FunctionPart, iar.GroupId
	FROM @itemAddRemove iar	
	OUTER APPLY 
	(
		SELECT TOP (1) ml.Quantity 
		FROM dbo.tb_ItemList il 
		JOIN @MaterialList ml ON ml.InventoryID = il.AcumaticaName 
		WHERE il.ComponentPartTypeId = iar.PartTypeId 
		AND iar.QuantityAll = 1
	) qty
	WHERE NOT EXISTS
	(
		SELECT * FROM @itemAddRemove iar2 
		WHERE iar.PartTypeId = iar2.PartTypeId AND iar2.PartItemCode = iar.PartItemCode 
		AND iar2.Quantity = iar.Quantity 
		AND iar2.ActionType <> iar.ActionType
	) 
	AND NOT EXISTS
	(
		SELECT * FROM picking.ProductionItemModifcationAddRemoveRules mr 
		WHERE mr.ProductionItemModifcationAddRemoveRuleId = iar.ProductionItemModifcationAddRemoveRuleId 
		AND 
		(
			(
				mr.OnlyRemoveWhenAdd = 1  
				AND NOT EXISTS
				(
					SELECT 1 FROM @itemAddRemove iar2 
					WHERE 
					(
						(
							iar.PartTypeId = iar2.PartTypeId 
							OR 
							(
								iar.PartTypeId IN(9, 29) 
								AND iar2.PartTypeId IN(9, 29)
							)
						)
					)
					AND ISNULL(iar2.Quantity, 1) >= ISNULL(iar.Quantity, 0)
					AND iar2.ActionType='Add' 
				)
			) 
			OR
			(
				mr.OnlyRemoveWhenAddPartId IS NOT NULL
				AND NOT EXISTS
				(
					SELECT * FROM @itemAddRemove AS iar3
					WHERE iar3.ActionType = 'Add'
					AND 
					(
						iar3.PartTypeId = OnlyRemoveWhenAddPartId
						OR
						(
							iar3.PartTypeId IN(9, 29)
							AND mr.OnlyRemoveWhenAddPartId IN(9, 29)
						)
					)
				)
			)
		)
	)
	AND iar.ActionType = 'Remove'
	GROUP BY iar.ProductionItemModifcationAddRemoveRuleId,
             iar.ActionType,
             iar.PartItemCode,
             iar.QuantityAll,
             iar.PartTypeId,
             iar.FunctionPart,
			 iar.GroupId

	INSERT INTO @AddremoveRules (RuleId, AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, PartType, FunctionPart , GroupId) --Add
	SELECT MAX(iar.ProductionItemModifcationAddRemoveRuleId), iar.ActionType, iar.PartItemCode,  iar.QuantityAll,
	MAX(COALESCE(iar.Quantity, remove.Quantity, 1)),
	'PICKING' , iar.PartTypeId, iar.FunctionPart, iar.GroupId
	FROM @itemAddRemove iar
	OUTER APPLY
	(
		SELECT ar.Quantity 
		FROM  @AddremoveRules AS ar WHERE ar.PartType = iar.PartTypeId AND ar.AddRemoveAction = 'remove'
	)remove	
	OUTER APPLY 
	(
		SELECT TOP (1) ml.Quantity 
		FROM dbo.tb_ItemList il 
		JOIN @MaterialList ml ON ml.InventoryID = il.AcumaticaName 
		WHERE il.ComponentPartTypeId = iar.PartTypeId 
		AND iar.QuantityAll = 1
	) qty
	WHERE NOT EXISTS
	(
		SELECT * FROM @itemAddRemove iar2 
		WHERE 
		(
			iar.PartTypeId = iar2.PartTypeId 
			OR
			(
				iar.PartTypeId IN(9, 29)
				AND  iar2.PartTypeId IN(9, 29)
			)
		)
		AND iar2.PartItemCode = iar.PartItemCode 
		AND iar2.Quantity = iar.Quantity 
		AND iar2.ActionType <> iar.ActionType
	) 
	--IL-3639
	AND NOT EXISTS
	(
		SELECT * FROM @itemAddRemove AS iar3
		WHERE iar3.ActionType = 'Remove'
		AND iar3.PartItemCode = iar.PartItemCode
		AND ISNULL(iar3.Quantity, 0) = ISNULL(iar.Quantity, 0)
		AND ISNULL(iar3.OnlyRemoveWhenAdd, 0) = 0
	)
	AND iar.ActionType = 'Add'
	GROUP BY iar.ActionType, iar.PartItemCode, iar.QuantityAll, iar.PartTypeId, iar.FunctionPart, iar.GroupId		

	--FF-320
	INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, Backflush, PartType, FunctionPart ) --explicit additions (from table AddonBomAdditions)
	SELECT aba.ActionType, tilAddition.AcumaticaName, 
	CASE WHEN aba.Quantity IS NULL 
		AND aba.QuantityFromSubItem = 0
		AND aba.QuantityForOriginalItem = 0
		AND aba.ActionType <> 'Replace'
		AND aba.ConfigKey IS NULL THEN 1 ELSE 0 END AS QuantityAll, 
	SUM(COALESCE(SubItemQuantity.QtyRequired, QuantityOfOriginalItem.Quantity, aba.Quantity, 0) + ISNULL(QuantityPerComponent.QuantityPerComponent, 0) + COALESCE(QuantityConfig.QuantityConfigMultiplied, aba.QuantityPerConfigKey,0)) AS Quantity, 
	'PICKING', 
	--BEGIN FF-444
	CASE WHEN tilAddition.ID = 128070 AND ds.SeriesName = 'Quest' AND tilSub.ShortItemCode LIKE 'DCD%' THEN 0 ELSE 1 END,
	--END FF-444
	tilAddition.ComponentPartTypeId,
	'Explicit additions (from table AddonBomAdditions)'
	FROM dbo.TranEntry AS te
	JOIN dbo.tb_ItemList AS tilte ON tilte.ItemCode = te.ItemNumber
	JOIN inventory.DoorStyles AS ds ON ds.DoorStyleID = tilte.DoorStyleID
	JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID AND te.EZProdID = te2.EZParentProdID
	JOIN dbo.tb_ItemList AS tilSub ON tilSub.ItemCode = te2.ItemNumber
	JOIN picking.AddonBomAdditions AS aba ON aba.SubItemId = tilSub.ID
	JOIN dbo.tb_ItemList AS tilAddition ON tilAddition.ID = aba.AdditionalItemId
	OUTER APPLY
	(
		SELECT CAST(bomd.QtyRequired AS INT) AS QtyRequired
		FROM acumaticaManufacturing.BillOfMaterials AS bom
		JOIN dbo.tb_ItemList AS tilSubForParts ON bom.InventoryID = tilSubForParts.AcumaticaName
		JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
		WHERE bom.DeleteFlag = 0
		AND bomd.DeleteFlag = 0
		AND bom.Revision IN ('B', 'C', 'D')
		AND tilSubForParts.ItemTypeCode IN (1, 2)
		AND aba.QuantityFromSubItem = 1
		AND bomd.InventoryID = tilAddition.AcumaticaName
		AND EXISTS
		(
			SELECT * FROM dbo.TranEntry AS teSubForParts
			WHERE teSubForParts.isDeleted = 0
			AND teSubForParts.OrderID = te.OrderID 
			AND teSubForParts.EZParentProdID = te.EZProdID
			AND teSubForParts.ItemNumber = tilSubForParts.ItemCode
		)
	)AS SubItemQuantity
	OUTER APPLY
	(
		SELECT TOP (1) CAST(bomd.QtyRequired AS INT) * aba.QuantityPerComponentPartType AS QuantityPerComponent
		FROM acumaticaManufacturing.BillOfMaterials AS bom
		JOIN dbo.tb_ItemList AS tilSubForParts ON bom.InventoryID = tilSubForParts.AcumaticaName
		JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
		JOIN dbo.tb_ItemList AS tilBomD ON tilBomD.AcumaticaName = bomd.InventoryID
		WHERE bom.DeleteFlag = 0
		AND bomd.DeleteFlag = 0
		--AND bom.Revision IN ('B', 'C', 'D')
		--AND aba.ComponentPartTypeId IS NOT NULL
		AND tilBomD.ComponentPartTypeId = aba.ComponentPartTypeId
		AND bom.InventoryID = tilSubForParts.AcumaticaName
		AND tilSubForParts.ItemTypeCode IN (1, 2)
		AND EXISTS
		(
			SELECT * FROM dbo.TranEntry AS teSubForParts
			WHERE teSubForParts.isDeleted = 0
			AND teSubForParts.OrderID = te.OrderID 
			AND teSubForParts.EZParentProdID = te.EZProdID
			AND teSubForParts.ItemNumber = tilSubForParts.ItemCode
		)
	)AS QuantityPerComponent
	OUTER APPLY
	(
		SELECT ml.Quantity FROM @MaterialList AS ml
		WHERE ml.InventoryID = tilAddition.AcumaticaName
		AND aba.QuantityForOriginalItem = 1
	)AS QuantityOfOriginalItem
	OUTER APPLY
	(
		SELECT ISNULL(NULLIF(COUNT(*), 0), 1) * aba.QuantityPerConfigKey AS  QuantityConfigMultiplied
		FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
		WHERE goict.ConfigKey = aba.ConfigKey
		AND aba.ConfigKey IS NOT NULL
	)AS QuantityConfig
	WHERE te.ID = @OrderItemId
	AND te2.isDeleted = 0
	AND aba.SubItemId IS NOT NULL
	AND 
	(
		COALESCE(SubItemQuantity.QtyRequired, QuantityOfOriginalItem.Quantity, aba.Quantity, QuantityPerComponent.QuantityPerComponent, QuantityConfig.QuantityConfigMultiplied) > 0
		OR 
		(
			aba.Quantity IS NULL 
			AND aba.QuantityFromSubItem = 0
			AND aba.QuantityForOriginalItem = 0
			AND aba.ActionType <> 'Replace'
			AND ISNULL(QuantityConfig.QuantityConfigMultiplied, 0) = 0
		)
	)
	GROUP BY aba.ActionType, tilAddition.AcumaticaName,
			CASE WHEN aba.Quantity IS NULL
             AND aba.QuantityFromSubItem = 0
             AND aba.QuantityForOriginalItem = 0
             AND aba.ActionType <> 'Replace'
             AND aba.ConfigKey IS NULL THEN 1
             ELSE 0
             END,
             CASE WHEN tilAddition.ID = 128070
             AND ds.SeriesName = 'Quest'
             AND tilSub.ShortItemCode LIKE 'DCD%' THEN 0
             ELSE 1
             END,
			 tilAddition.ComponentPartTypeId

	DECLARE @ReplaceSlides TABLE(ToRemove VARCHAR(50), ToAdd VARCHAR(450), NeedsRemove BIT, QuantityToAdd INT, QuantityAll BIT)

	INSERT @ReplaceSlides (ToRemove, ToAdd, NeedsRemove, QuantityToAdd, QuantityAll)
		
	SELECT DISTINCT ToRemove.AcumaticaName AS ToRemove, ToAdd.AcumaticaName AS ToAdd, ToRemove.NeedsRemove, 
	CASE WHEN ISNULL(ToAdd.OrderItemId, te.ID) = te.ID THEN ToRemove.QuantityToAdd  ELSE ToAdd.ModConfigQuantity END,
	CASE WHEN ISNULL(ToAdd.OrderItemId, te.ID) = te.ID THEN 1 ELSE 0 END
	FROM dbo.TranEntry AS te
	JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID
		AND te2.EZParentProdID = te.EZProdID
	JOIN dbo.tb_ItemList AS til ON til.ItemCode = te2.ItemNumber
	JOIN picking.AddonBomAdditions AS aba ON aba.SubItemId = til.ID
	CROSS APPLY
	(
		SELECT ptpt.ProductTagId, til.AcumaticaName, CAST(replace.NeedsRemove AS BIT) AS NeedsRemove, replace.QuantityToAdd
		FROM dbo.tb_ItemList AS til 
		JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = til.AcumaticaID
		JOIN inventory.ProductToProductTags AS ptpt ON ptpt.ProductId = til.ProductID
		CROSS APPLY
		(
			SELECT 1 AS NeedsRemove, ml2.Quantity AS QuantityToAdd
			FROM @MaterialList AS ml2
			WHERE ml2.InventoryID = til.AcumaticaName
			UNION ALL
			SELECT 0, 0 
			FROM @AddremoveRules AS arr
			WHERE arr.InventoryId = til.AcumaticaName
		)AS replace
		WHERE aba.TagIdToReduceBy3Inches = ptpt.ProductTagId
		AND ptpt.DeleteFlag = 0
	)AS ToRemove
	CROSS APPLY
	(
		SELECT TOP (1) tilR.AcumaticaName, cz.OrderItemId, cz.ModConfigQuantity
		FROM dbo.tb_ItemList AS tilR
		JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = tilR.AcumaticaID
		JOIN inventory.ProductToProductTags AS ptpt2 ON ptpt2.ProductId = tilR.ProductID
		OUTER APPLY
		(
			SELECT asiMain.Depth + tabd.AdjustDepth  AS CabinetDepth
			FROM inventory.AcumaticaStockItems AS asiMain
			JOIN dbo.tb_ItemList AS tilMain ON te.ItemNumber = tilMain.ItemCode
			AND tilMain.AcumaticaID = asiMain.AcumaticaID
			JOIN dbo.tb_AdjustedBoxDimensions AS tabd ON tabd.TranEntryID = @orderItemId
		)AS cd
		OUTER APPLY
		(
			SELECT CAST(goict.ConfigValue AS NUMERIC) AS CofiguredSize, goict.OrderItemId, COUNT(*) AS ModConfigQuantity
			FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
			WHERE aba.ConfigKeyForResize = goict.ConfigKey
			AND ISNUMERIC(goict.ConfigValue) = 1
			GROUP BY CAST(goict.ConfigValue AS NUMERIC), goict.OrderItemId
		)AS cz
		WHERE ptpt2.DeleteFlag = 0
		AND ptpt2.ProductTagId = ToRemove.ProductTagId
		AND
		( 
			(
				(
					cd.CabinetDepth - asi.Depth >= 3
					OR 
					(
						NOT EXISTS 
						(
							SELECT * FROM dbo.tb_ItemList AS tilOtherOption
							JOIN inventory.AcumaticaStockItems AS asiOtherOption ON asiOtherOption.AcumaticaID = tilOtherOption.AcumaticaID
							WHERE EXISTS
							(
								SELECT * FROM inventory.ProductToProductTags AS ptpt3
								WHERE ptpt3.DeleteFlag = 0
								AND ptpt3.ProductId = tilOtherOption.ProductID
								AND ptpt3.ProductTagId = TagIdToReduceBy3Inches
							)
							AND cd.CabinetDepth - asiOtherOption.Depth >= 3 
						)
						AND cd.CabinetDepth > asi.Depth
						AND aba.TagIdToReduceBy3Inches = 87
					)
				)
				AND cz.CofiguredSize IS NULL
			)
			OR cz.CofiguredSize = asi.Depth
		)
		ORDER BY asi.Depth DESC
	)AS ToAdd
	WHERE te.ID = @orderItemId
	AND aba.ActionType = 'Replace'

	INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, Quantity, QuantityAll, WorkCenter, FunctionPart )
	SELECT 'Remove', ReplaceSlides.ToRemove, ReplaceSlides.QuantityToAdd, ReplaceSlides.QuantityAll, 'PICKING', 'ReplaceSlides'
	FROM @ReplaceSlides AS ReplaceSlides
	WHERE EXISTS
	(SELECT * FROM @MaterialList AS ml WHERE ml.InventoryID = ReplaceSlides.ToRemove)
	AND ReplaceSlides.NeedsRemove = 1
	AND ReplaceSlides.QuantityAll = 1
	UNION ALL
	SELECT 'Add', ReplaceSlides.ToAdd, ReplaceSlides.QuantityToAdd, ReplaceSlides.QuantityAll, 'PICKING', 'ReplaceSlides'
	FROM @ReplaceSlides AS ReplaceSlides
	WHERE EXISTS
	(SELECT * FROM @MaterialList AS ml WHERE ml.InventoryID = ReplaceSlides.ToRemove)
	AND ReplaceSlides.NeedsRemove = 1
	AND ReplaceSlides.QuantityAll = 1

	UPDATE ar SET ar.InventoryId = rs.ToAdd, ar.FunctionPart = ar.FunctionPart + ' Updated From ReplaceSlides'
	FROM @AddremoveRules AS ar
	JOIN @ReplaceSlides AS rs ON rs.ToRemove = ar.InventoryId
	WHERE ar.AddRemoveAction = 'Add'
	AND rs.NeedsRemove = 0
	AND rs.ToAdd <> ar.InventoryId

	INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, Backflush, PartType, FunctionPart ) --add slides calculated
	SELECT 'Add', Part.Name, 0, Part.Quantity, 'Picking', 1, Part.ComponentPartTypeId, 'add slides calculated' 
	FROM picking.AddonBomAdditions AS aba
	JOIN @SubItem AS si ON si.SubItemListId = aba.SubItemId
	CROSS JOIN @BasicItemInfo AS bii
	CROSS APPLY
	(
		SELECT asi.Depth + tabd.AdjustDepth AS Depth 
		FROM inventory.AcumaticaStockItems AS asi
		JOIN dbo.tb_AdjustedBoxDimensions AS tabd ON tabd.TranEntryID = @orderItemId
		WHERE asi.AcumaticaID = bii.AcumeticaId 
	)AS CabinetSize
	CROSS APPLY
	(
		SELECT TOP (1) asi2.Name, qty.Quantity, til.ComponentPartTypeId 
		FROM inventory.AcumaticaStockItems AS asi2
		JOIN dbo.tb_ItemList AS til ON til.AcumaticaID = asi2.AcumaticaID
		CROSS APPLY
		(
			SELECT COUNT(*) * aba.QuantityPerConfigKey AS Quantity 
			FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
			WHERE goict.ConfigKey = aba.ConfigKey
		)AS qty
		WHERE asi2.Depth <= CabinetSize.Depth - 3
		AND EXISTS
		(
			SELECT * FROM inventory.AcumaticaProductToProductTag AS aptpt
			WHERE Deleted = 0
			AND aptpt.ProductTagId = aba.TagIdToReduceBy3Inches
			AND aptpt.AcumaticaProductId = asi2.AcumaticaProductID
		)
		ORDER BY asi2.Depth DESC
	)AS Part
	WHERE aba.ActionType = 'Add'
	AND aba.AdditionalItemId IS NULL

	
	--FF-579
	IF EXISTS
	(
		SELECT * FROM @AddremoveRules AS ar 
		JOIN dbo.tb_ItemList AS til ON til.AcumaticaName = ar.InventoryId
		WHERE til.ComponentPartTypeId IN (7, 9, 17, 29)
	)
	BEGIN
		DECLARE @TotalLeft TABLE(InventoryID VARCHAR(50), Quantity INT)

		INSERT @TotalLeft(InventoryID, Quantity)
		SELECT Total.InventoryId, SUM(Total.Quantity) FROM 
		(
			SELECT ar.InventoryId, SUM(CASE WHEN ar.AddRemoveAction = 'Add' THEN ar.Quantity ELSE -ar.Quantity END) AS Quantity 
			FROM @AddremoveRules AS ar 
			JOIN dbo.tb_ItemList AS til ON til.AcumaticaName = ar.InventoryId
			WHERE til.ComponentPartTypeId IN (7, 9, 17, 29)
			GROUP BY ar.InventoryId
			UNION ALL
			SELECT ml.InventoryID, ml.Quantity 
			FROM @MaterialList AS ml
			JOIN dbo.tb_ItemList AS tilm ON tilm.AcumaticaName = ml.InventoryId
			WHERE tilm.ComponentPartTypeId IN (7, 9, 17, 29)
		)
		AS Total
		GROUP BY Total.InventoryId

		DECLARE @Harware TABLE(InventoryID VARCHAR(50), Quantity INT, OriginalQuantity INT);
		WITH HW AS 
		(
			SELECT bomd.InventoryID, bomd.QtyRequired * tl.Quantity AS Quantity, ml.Quantity AS OriginalQuantity
			FROM @TotalLeft AS tl
			JOIN dbo.tb_ItemList AS til ON tl.InventoryID = til.AcumaticaName
			CROSS JOIN @BasicItemInfo AS bii
			JOIN acumaticaManufacturing.BillOfMaterials AS bom ON bom.InventoryID = tl.InventoryID
			JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			LEFT JOIN @MaterialList AS ml ON ml.InventoryID = bomd.InventoryID
			WHERE bomd.DeleteFlag = 0
			AND bom.DeleteFlag = 0
			AND bom.Status = 'Active'
			AND 
			(
				(
					bom.Revision = 'HARDWARE' 
					AND 
					(
						bii.DoorStyleID <> 26
						OR til.ComponentPartTypeId NOT IN (7, 17)
					)
				)
				OR 
				(
					bom.Revision = 'HF HARDWAR' 
					AND 
					(
						bii.DoorStyleID = 26
						AND til.ComponentPartTypeId IN (7, 17)
					)
				)
			) 
			AND  bomd.QtyRequired * tl.Quantity <> ml.Quantity
			AND til.ComponentPartTypeId IN(7, 9, 17, 29)
		)
		INSERT @Harware(InventoryID, Quantity)
		SELECT HW.InventoryID, SUM(HW.Quantity) 
		FROM HW
		GROUP BY HW.InventoryID

		DELETE @TotalLeft
		INSERT @TotalLeft(InventoryID, Quantity)
		SELECT ar.InventoryId, SUM(ar.Quantity) FROM @AddremoveRules AS ar
		WHERE NOT EXISTS
		(
			SELECT * FROM @MaterialList AS ml
			WHERE ml.InventoryID = ar.InventoryId
		)
		AND ar.AddRemoveAction = 'Add'
		AND ar.PartType IN (7, 9, 17, 29)
		GROUP BY ar.InventoryId

		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart )--parts from bom of components
		SELECT CASE WHEN h.Quantity < ISNULL(ml.Quantity, 0) THEN 'Remove' ELSE 'Add' END, ISNULL(rs.ToAdd, h.InventoryID),
		CASE WHEN ISNULL(ml.Quantity, 0) > ISNULL(ml.Quantity, 0) - h.Quantity THEN 0 ELSE 1 END,
		dbo.GetMaxValue(ISNULL(ml.Quantity, 0) - h.Quantity, h.Quantity - ISNULL(ml.Quantity, 0)),
		'PICKING' , 'Parts from bom of components (Adjusted)'
		FROM @Harware AS h
		LEFT JOIN @MaterialList AS ml ON ml.InventoryID = h.InventoryID
		LEFT JOIN @ReplaceSlides AS rs ON h.InventoryID = rs.ToRemove

		MERGE @AddremoveRules AS arr USING 
		(
			SELECT bomd.InventoryID, bomd.QtyRequired * tl.Quantity AS Quantity 
			FROM @TotalLeft AS tl
			JOIN dbo.tb_ItemList AS til ON tl.InventoryID = til.AcumaticaName
			CROSS JOIN @BasicItemInfo AS bii
			JOIN acumaticaManufacturing.BillOfMaterials AS bom ON bom.InventoryID = tl.InventoryID
			JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			LEFT JOIN @MaterialList AS ml ON ml.InventoryID = bomd.InventoryID
			WHERE bomd.DeleteFlag = 0
			AND bom.DeleteFlag = 0
			AND bom.Status = 'Active'
			AND 
			(
				(
					bom.Revision = 'HARDWARE' 
					AND 
					(
						bii.DoorStyleID <> 26
						OR til.ComponentPartTypeId NOT IN (7, 17)
					)
				)
				OR 
				(
					bom.Revision = 'HF HARDWAR' 
					AND 
					(
						bii.DoorStyleID = 26
						AND til.ComponentPartTypeId IN (7, 17)
					)
				)
			) 
			AND  bomd.QtyRequired * tl.Quantity <> ml.Quantity
			AND til.ComponentPartTypeId IN(7, 9, 17, 29)
		) AS nh
		ON arr.InventoryId = nh.InventoryID
		AND arr.AddRemoveAction = 'Add'
		WHEN MATCHED 
		THEN UPDATE SET arr.Quantity = arr.Quantity + nh.Quantity
		WHEN NOT MATCHED BY TARGET
		THEN INSERT(AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart )
		VALUES ('Add', nh.InventoryID, 0, nh.Quantity, 'PICKING', 'Parts from bom of components (new)');
	END

	--FF-341
	IF EXISTS -- shelf ship loose
	(
		SELECT * FROM dbo.TranEntry AS te
		JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
		WHERE til.ProductID IN(497,498,499,606,607,608,610,611,612,613,614,615,616,617,618,660,661,749,777,778,779)
		AND te.ID = @orderItemId
	)
	--FF-414
	--OR 
	--(
	--	EXISTS
	--	(
	--		SELECT * FROM @SubItem AS si 
	--		WHERE si.SubItemListId = 106915
	--	) --MATCHING-INTERIOR
	--	AND NOT EXISTS
	--	(
	--		SELECT * FROM @SubItem AS si
	--		WHERE si.SubItemListId  NOT IN (106915, 106907) 
	--		OR
	--		(
	--			si.SubItemListId  = 106907 --cut door
	--			AND @bomRevision = 'D'
	--		)				
	--	)
	--)

	BEGIN
		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart )
		VALUES('Remove', 'PLASTIC SHELF HOLDER', 0, 1, 'PICKING', 'PLASTIC SHELF HOLDER for ship shelf loose')
	END

	--FF-264
	INSERT @AddremoveRules(RuleId, AddRemoveAction, InventoryId, Quantity, QuantityAll, WorkCenter, FunctionPart)--replacements
	SELECT ir.RuleId, 'Remove',  ir.RemovePartAcumaticaName, ir.Quantity, 0, 'PICKING' , 'Replacements'
	FROM @itemReplace AS ir
	UNION ALL
	SELECT ir.RuleId, 'Add', ir.AddPartAcumaticaName, ir.Quantity, 0, 'PICKING', 'Replacements'
	FROM @itemReplace AS ir

	--FF-509
	DELETE addRule FROM @AddremoveRules AS addRule
	WHERE addRule.AddRemoveAction = 'Add'
	AND InventoryId = 'BB SLIDES 20"'

	IF EXISTS(SELECT * FROM dbo.TranEntry AS te WHERE te.ID = @orderItemId AND te.BoxOnly = 1)
	BEGIN
		DELETE @AddremoveRules  WHERE InventoryId IN
		(
			SELECT ml.InventoryID 
			FROM @MaterialList ml
			JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
			OUTER APPLY
			(
				SELECT CAST( CASE WHEN EXISTS
				(
					SELECT * FROM dbo.TranEntry TE 
					JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
					WHERE TE.ID = @orderItemId 
					AND TIL.ProductID IN(413, 412)
				)THEN 1 ELSE 0 END AS BIT) AS IsLsb
			)AS IsLsb
			WHERE til.ComponentPartTypeId IN(11, 7, 17, 29) 
			OR 
			(
				til.ComponentPartTypeId IN (9) 
				AND IsLsb.IsLsb = 0
			)
			OR
			(
				til.ComponentPartTypeId IN (23, 25)
				AND 
				(
					IsLsb.IsLsb = 0
					OR ml.InventoryID NOT IN('CSC','PLASTIC SHELF HOLDER','VSC')
				)
					
			)
		)

		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity)
		SELECT 'Remove', ml.InventoryID, 1, ml.Quantity 
		FROM @MaterialList ml
		JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
		OUTER APPLY
		(
			SELECT CAST( CASE WHEN EXISTS
			(
				SELECT * FROM dbo.TranEntry TE 
				JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
				WHERE TE.ID = @orderItemId 
				AND TIL.ProductID IN(413, 412)
			)THEN 1 ELSE 0 END AS BIT) AS IsLsb
		)AS IsLsb
		WHERE til.ComponentPartTypeId IN( 11, 7, 17, 29) 
		OR 
		(
			til.ComponentPartTypeId IN (9) 
			AND IsLsb.IsLsb = 0
		)	
		OR
		(
			til.ComponentPartTypeId IN (23, 25)
			AND 
			(
				IsLsb.IsLsb = 0
				OR ml.InventoryID NOT IN('CSC','PLASTIC SHELF HOLDER','VSC')
			)
					
		)
	END


	RETURN
END
GO
/****** Object:  UserDefinedFunction [picking].[GetBucketItemsToPick]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[GetBucketItemsToPick] 
(
	@BucketIds IDList READONLY,
	@PickingTypeId INT,
	@Aisle INT = 0,
	@Rack INT = 0
)
RETURNS 
@BucketItemsToPick TABLE 
(
	ProductionItemId INT NOT NULL,
	ProductionItemDetailId INT NULL,
	BucketId INT NOT NULL,
	DestinationLocationId INT NOT NULL,
	Location NVARCHAR(255),
	Isle INT NOT NULL,
	Rack INT NOT NULL,
	PickingDate DATE NOT NULL,
	AllowedPickdate DATE NOT NULL,
	RegularPIItem BIT NOT NULL,
	PickingTypeId INT NOT NULL,
	ForMissingParts BIT NOT NULL,
	ComponentPartTypeId INT NOT NULL
)
AS
BEGIN	
	--DECLARE @LastUpdated DATETIME
	--SELECT TOP (1) @LastUpdated = UpdateDate FROM picking.ProductionItemDetailToPick
	--IF DATEDIFF(MINUTE, @LastUpdated, GETDATE()) > 5
	--BEGIN
	--    EXEC picking.UpdateProductionItemDetailToPick
	--END
	DECLARE @GreatestPickdate DATE = NULL

	SELECT @GreatestPickdate = MIN(pi.PickingDate) FROM picking.ProductionItemDetailToPick AS pidtp
	JOIN picking.ProductionItem AS pi ON pi.ProductionItemId = pidtp.ProductionItemId
	JOIN picking.BucketProductionItemsMaxPickdates bpimp ON bpimp.BucketProductionItemsId= pidtp.BucketId AND pi.PickingDate <=  bpimp.MaxPickdate
		   WHERE pidtp.BucketId IN(SELECT bi.ID FROM @BucketIds bi)
		   AND pidtp.PickingTypeId = @PickingTypeId
		   AND (@GreatestPickdate IS NULL OR pi.PickingDate <= @GreatestPickdate )
		   AND EXISTS(SELECT * FROM dbo.TranEntry AS te WHERE te.ID = pi.OrderItemId AND te.isActive = 1 AND te.DepartmentstatusID NOT IN(40,95,420, 439,840,916,929,752,1030,864,941,933,937,942) AND te.FWPONumber IS NULL)
		   AND NOT EXISTS
		   (
			   SELECT * FROM picking.PickingTaskProductionItems AS ptpi 
			   JOIN picking.PickingTaskProductionItemsDetail ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId 
			   WHERE ptpi.Active = 1 
			   AND ptpid.Active = 1 
			   AND ptpid.ProductionItemDetailId = pidtp.ProductionItemDetailId
			   AND 
			   (
					ptpi.ProductionItemsPickingTaskStatusId IN (1, 2) 
					OR (ptpid.Picked = 1  AND EXISTS(SELECT 1 FROM picking.ProductionItemDetail PID2 
													 WHERE PID2.ProductionItemId = pi.ProductionItemId
													 AND PID2.Deleted = 0 AND PID2.Picked = 1
													 )) --FF-494
					OR EXISTS 
					(
						SELECT 1 FROM picking.ProductionItemDetail PID 
						 WHERE ptpid.ProductionItemDetailId = pid.ProductionItemDetailId 
						 AND PID.Picked = 1 
						 AND PID.Deleted = 0
					)
				)
			   AND ptpi.PickingTypeId=@PickingTypeId
		   )
		   AND NOT EXISTS
		   (
			   SELECT * FROM picking.PickingTaskProductionItems AS ptpi 
			   JOIN picking.PickingTaskProductionItemsDetail ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId 
			   WHERE ptpi.Active = 1 
			   AND ptpid.Active = 1 
			   AND ptpid.ProductionItemDetailId IS NULL
			   AND ptpid.ProductionItemId = pidtp.ProductionItemId 
			   AND 
			   (
					ptpi.ProductionItemsPickingTaskStatusId IN (1, 2) 
					OR ptpid.Picked = 1 					
				)
			   AND ptpi.PickingTypeId=@PickingTypeId
		   )
		   AND NOT EXISTS (SELECT 1 FROM dbo.GetItemsToRevise() GITR WHERE GITR.OrderItemId = pi.OrderItemId)

	IF @GreatestPickdate IS NULL
		RETURN
	
	INSERT @BucketItemsToPick ( ProductionItemId, ProductionItemDetailId, BucketId, DestinationLocationId, Location,  Isle, Rack,
	                                  PickingDate, AllowedPickdate, RegularPIItem, PickingTypeId, ForMissingParts,ComponentPartTypeId )

	SELECT TOP (50) pidtp.ProductionItemId, pidtp.ProductionItemDetailId, pidtp.BucketId, pidtp.DestinationLocationId, pidtp.Location,
           pidtp.Isle, pidtp.Rack, pi.PickingDate, pidtp.AllowedPickdate, pidtp.RegularPIItem, pidtp.PickingTypeId,
           pidtp.ForMissingParts, COALESCE(pidtp.ComponentPartTypeId,0) FROM picking.ProductionItemDetailToPick AS pidtp 
		   JOIN picking.ProductionItem AS pi ON pi.ProductionItemId = pidtp.ProductionItemId
		   WHERE pidtp.BucketId IN(SELECT bi.ID FROM @BucketIds bi)
		   AND pidtp.PickingTypeId = @PickingTypeId
		   AND (@GreatestPickdate IS NULL OR pi.PickingDate <= @GreatestPickdate )
		   AND EXISTS(SELECT * FROM dbo.TranEntry AS te WHERE te.ID = pi.OrderItemId AND te.isActive = 1 AND te.DepartmentstatusID NOT IN(40,95,420, 439,840,916,929,752,1030,864,941,933,937,942) AND te.FWPONumber IS NULL)
		   AND NOT EXISTS
		   (
			   SELECT * FROM picking.PickingTaskProductionItems AS ptpi 
			   JOIN picking.PickingTaskProductionItemsDetail ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId 
			   WHERE ptpi.Active = 1 
			   AND ptpid.Active = 1 
			   AND ptpid.ProductionItemDetailId = pidtp.ProductionItemDetailId
			   AND 
			   (
					ptpi.ProductionItemsPickingTaskStatusId IN (1, 2) 
					OR (ptpid.Picked = 1  AND EXISTS(SELECT 1 FROM picking.ProductionItemDetail PID2 
													 WHERE PID2.ProductionItemId = pi.ProductionItemId
													 AND PID2.Deleted = 0 AND PID2.Picked = 1
													 )) --FF-494
					OR EXISTS 
					(
						SELECT 1 FROM picking.ProductionItemDetail PID 
						 WHERE ptpid.ProductionItemDetailId = pid.ProductionItemDetailId 
						 AND PID.Picked = 1 
						 AND PID.Deleted = 0
					)
				)
			   AND ptpi.PickingTypeId=@PickingTypeId
		   )
		   AND NOT EXISTS
		   (
			   SELECT * FROM picking.PickingTaskProductionItems AS ptpi 
			   JOIN picking.PickingTaskProductionItemsDetail ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId 
			   WHERE ptpi.Active = 1 
			   AND ptpid.Active = 1 
			   AND ptpid.ProductionItemDetailId IS NULL
			   AND ptpid.ProductionItemId = pidtp.ProductionItemId 
			   AND 
			   (
					ptpi.ProductionItemsPickingTaskStatusId IN (1, 2) 
					OR ptpid.Picked = 1 					
				)
			   AND ptpi.PickingTypeId=@PickingTypeId
		   )
		   AND NOT EXISTS (SELECT 1 FROM dbo.GetItemsToRevise() GITR WHERE GITR.OrderItemId = pi.OrderItemId)
	ORDER BY pi.PickingDate, 
	CASE WHEN pidtp.Isle = @Aisle AND  pidtp.Rack >= @Rack THEN 0  WHEN pidtp.Isle > @Aisle THEN 1 ELSE 2 END, pidtp.Isle , pidtp.Rack
	RETURN 
END











GO
/****** Object:  UserDefinedFunction [picking].[GetBucketItemsToPick_FF_56]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[GetBucketItemsToPick_FF_56] 
(
	@BucketIds IDList READONLY,
	@PickingTypeId INT,
	@Aisle INT = 0,
	@Rack INT = 0,
	@Sequence INT = 0
)
RETURNS 
@BucketItemsToPick TABLE 
(
	ProductionItemId INT NOT NULL,
	ProductionItemDetailId INT NULL,
	BucketId INT NOT NULL,
	DestinationLocationId INT NOT NULL,
	Location NVARCHAR(255),
	Isle INT NOT NULL,
	Rack INT NOT NULL,
	PickingDate DATE NOT NULL,
	AllowedPickdate DATE NOT NULL,
	RegularPIItem BIT NOT NULL,
	PickingTypeId INT NOT NULL,
	ForMissingParts BIT NOT NULL,
	ComponentPartTypeId INT NOT NULL,
	Sequence INT NOT NULL
)
AS
BEGIN	
	--DECLARE @LastUpdated DATETIME
	--SELECT TOP (1) @LastUpdated = UpdateDate FROM picking.ProductionItemDetailToPick
	--IF DATEDIFF(MINUTE, @LastUpdated, GETDATE()) > 5
	--BEGIN
	--    EXEC picking.UpdateProductionItemDetailToPick
	--END
	DECLARE @GreatestPickdate DATE = NULL

	SELECT @GreatestPickdate = MIN(pi.PickingDate) FROM picking.ProductionItemDetailToPick AS pidtp
	JOIN picking.ProductionItem AS pi ON pi.ProductionItemId = pidtp.ProductionItemId
	JOIN picking.BucketProductionItemsMaxPickdates bpimp ON bpimp.BucketProductionItemsId= pidtp.BucketId AND pi.PickingDate <=  bpimp.MaxPickdate
		   WHERE pidtp.BucketId IN(SELECT bi.ID FROM @BucketIds bi)
		   AND pidtp.PickingTypeId = @PickingTypeId
		   AND (@GreatestPickdate IS NULL OR pi.PickingDate <= @GreatestPickdate )
		   AND EXISTS(SELECT * FROM dbo.TranEntry AS te WHERE te.ID = pi.OrderItemId AND te.isActive = 1 AND te.DepartmentstatusID NOT IN(40,95,420, 439,840,916,929,752,1030,864,941,933,937,942) AND te.FWPONumber IS NULL)
		   AND NOT EXISTS
		   (
			   SELECT * FROM picking.PickingTaskProductionItems AS ptpi 
			   JOIN picking.PickingTaskProductionItemsDetail ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId 
			   WHERE ptpi.Active = 1 
			   AND ptpid.Active = 1 
			   AND ptpid.ProductionItemDetailId = pidtp.ProductionItemDetailId
			   AND 
			   (
					ptpi.ProductionItemsPickingTaskStatusId IN (1, 2) 
					OR (ptpid.Picked = 1  AND EXISTS(SELECT 1 FROM picking.ProductionItemDetail PID2 
													 WHERE PID2.ProductionItemId = pi.ProductionItemId
													 AND PID2.Deleted = 0 AND PID2.Picked = 1
													 )) --FF-494
					OR EXISTS 
					(
						SELECT 1 FROM picking.ProductionItemDetail PID 
						 WHERE ptpid.ProductionItemDetailId = pid.ProductionItemDetailId 
						 AND PID.Picked = 1 
						 AND PID.Deleted = 0
					)
				)
			   AND ptpi.PickingTypeId=@PickingTypeId
		   )
		   AND NOT EXISTS
		   (
			   SELECT * FROM picking.PickingTaskProductionItems AS ptpi 
			   JOIN picking.PickingTaskProductionItemsDetail ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId 
			   WHERE ptpi.Active = 1 
			   AND ptpid.Active = 1 
			   AND ptpid.ProductionItemDetailId IS NULL
			   AND ptpid.ProductionItemId = pidtp.ProductionItemId 
			   AND 
			   (
					ptpi.ProductionItemsPickingTaskStatusId IN (1, 2) 
					OR ptpid.Picked = 1 					
				)
			   AND ptpi.PickingTypeId=@PickingTypeId
		   )
		   AND NOT EXISTS (SELECT 1 FROM dbo.GetItemsToRevise() GITR WHERE GITR.OrderItemId = pi.OrderItemId)

	IF @GreatestPickdate IS NULL
		RETURN
	
	INSERT @BucketItemsToPick ( ProductionItemId, ProductionItemDetailId, BucketId, DestinationLocationId, Location,  Isle, Rack,
	                                  PickingDate, AllowedPickdate, RegularPIItem, PickingTypeId, ForMissingParts,ComponentPartTypeId, Sequence )

	SELECT TOP (50) pidtp.ProductionItemId, pidtp.ProductionItemDetailId, pidtp.BucketId, pidtp.DestinationLocationId, pidtp.Location,
           pidtp.Isle, pidtp.Rack, pi.PickingDate, pidtp.AllowedPickdate, pidtp.RegularPIItem, pidtp.PickingTypeId,
           pidtp.ForMissingParts, COALESCE(pidtp.ComponentPartTypeId,0), pidtp.Sequence
		   FROM picking.ProductionItemDetailToPick AS pidtp 
		   JOIN picking.ProductionItem AS pi ON pi.ProductionItemId = pidtp.ProductionItemId
		   WHERE pidtp.BucketId IN(SELECT bi.ID FROM @BucketIds bi)
		   AND pidtp.PickingTypeId = @PickingTypeId
		   AND (@GreatestPickdate IS NULL OR pi.PickingDate <= @GreatestPickdate )
		   AND EXISTS(SELECT * FROM dbo.TranEntry AS te WHERE te.ID = pi.OrderItemId AND te.isActive = 1 AND te.DepartmentstatusID NOT IN(40,95,420, 439,840,916,929,752,1030,864,941,933,937,942) AND te.FWPONumber IS NULL)
		   AND NOT EXISTS
		   (
			   SELECT * FROM picking.PickingTaskProductionItems AS ptpi 
			   JOIN picking.PickingTaskProductionItemsDetail ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId 
			   WHERE ptpi.Active = 1 
			   AND ptpid.Active = 1 
			   AND ptpid.ProductionItemDetailId = pidtp.ProductionItemDetailId
			   AND 
			   (
					ptpi.ProductionItemsPickingTaskStatusId IN (1, 2) 
					OR (ptpid.Picked = 1  AND EXISTS(SELECT 1 FROM picking.ProductionItemDetail PID2 
													 WHERE PID2.ProductionItemId = pi.ProductionItemId
													 AND PID2.Deleted = 0 AND PID2.Picked = 1
													 )) --FF-494
					OR EXISTS 
					(
						SELECT 1 FROM picking.ProductionItemDetail PID 
						 WHERE ptpid.ProductionItemDetailId = pid.ProductionItemDetailId 
						 AND PID.Picked = 1 
						 AND PID.Deleted = 0
					)
				)
			   AND ptpi.PickingTypeId=@PickingTypeId
		   )
		   AND NOT EXISTS
		   (
			   SELECT * FROM picking.PickingTaskProductionItems AS ptpi 
			   JOIN picking.PickingTaskProductionItemsDetail ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId 
			   WHERE ptpi.Active = 1 
			   AND ptpid.Active = 1 
			   AND ptpid.ProductionItemDetailId IS NULL
			   AND ptpid.ProductionItemId = pidtp.ProductionItemId 
			   AND 
			   (
					ptpi.ProductionItemsPickingTaskStatusId IN (1, 2) 
					OR ptpid.Picked = 1 					
				)
			   AND ptpi.PickingTypeId=@PickingTypeId
		   )
		   AND NOT EXISTS (SELECT 1 FROM dbo.GetItemsToRevise() GITR WHERE GITR.OrderItemId = pi.OrderItemId)
	ORDER BY pi.PickingDate,
	CASE WHEN pidtp.Sequence = @Sequence THEN 0 WHEN pidtp.Sequence > @Sequence THEN 1 ELSE 2 END,	 
	CASE WHEN pidtp.Isle = @Aisle AND  pidtp.Rack >= @Rack THEN 0  WHEN pidtp.Isle > @Aisle THEN 1 ELSE 2 END, pidtp.Isle , pidtp.Rack
	RETURN 
END











GO
/****** Object:  UserDefinedFunction [picking].[GetBucketsTasks]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 8/2/2018
-- Description:	Get Buckets Tasks summary
-- =============================================
CREATE FUNCTION [picking].[GetBucketsTasks]
(	
	@BucketId INT = NULL,
	@term VARCHAR(50) = NULL,
	@ShowInactive BIT =  0

)
RETURNS @BucketsTasks TABLE
(
    PickingTaskId INT,
    DropLocation VARCHAR(150),
    RushOrder BIT,
    CreatedTime DATETIME,
    AssignedTime DATETIME,
    PickingTaskStatus VARCHAR(15),
    Editable BIT,
    CompleteDate DATETIME,
    FirstName NVARCHAR(50),
	LastName NVARCHAR(50),
	PickerId INT,
	UpdateTime DATETIME,
	PickingTaskStatusId INT,
	Name VARCHAR(15),
	SortOrder INT,
	TotalItems INT,
	TotalPicked INT,
	PickingDate DATE,
	ETA DATETIME,
	BucketId INT,
	BucketName VARCHAR(30)
) 
AS 
BEGIN

DECLARE @PickingTaskIds IDList 
DECLARE @PickingTaskDetailIds TABLE (PickingTaskDetailId INT NOT NULL)
DECLARE @localBucketId INT = @BucketId
DECLARE @today DATE = GETDATE()
IF @term IS NOT NULL
BEGIN
	IF ISNUMERIC(@term) = 0
	BEGIN
		INSERT INTO @PickingTaskIds ( ID )
		SELECT ptd.PickingTaskId FROM picking.PickingTaskDetail AS ptd
		WHERE 
			EXISTS(SELECT * FROM dbo.TranEntry AS te JOIN dbo.[Order] o ON o.ID = te.OrderID WHERE te.ID = ptd.ItemId AND o.SOnumber = @term)
			AND EXISTS (SELECT * FROM picking.PickingTask AS pt
			WHERE pt.PickingTaskId=ptd.PickingTaskId AND ( pt.Active =1  OR @ShowInactive = 1 )
			AND (  @localBucketId IS NULL OR pt.BucketId=@localBucketId ) AND (pt.PickingTaskStatusId <> 4 OR pt.PickingCompleteDate > @today) )
			AND ( ptd.Active =1  OR @ShowInactive = 1 )
	END
	ELSE
	BEGIN
		INSERT INTO @PickingTaskIds ( ID )
		SELECT ptd.PickingTaskId  FROM  dbo.TranEntry te
		  JOIN picking.PickingTaskDetail ptd ON ptd.ItemId = te.ID AND ptd.Active =1
		  WHERE te.ID = CAST(@term AS  int)   
		  AND EXISTS (SELECT * FROM picking.PickingTask AS pt
			WHERE pt.PickingTaskId=ptd.PickingTaskId AND ( pt.Active =1  OR @ShowInactive = 1 )
			AND (  @localBucketId IS NULL OR pt.BucketId=@localBucketId ) AND (pt.PickingTaskStatusId <> 4 OR pt.PickingCompleteDate > @today) )
			AND ( ptd.Active =1  OR @ShowInactive = 1 )
	END
	INSERT INTO @PickingTaskDetailIds(PickingTaskDetailId)
	SELECT ptd.PickingTaskDetailId FROM picking.PickingTaskDetail AS ptd
	WHERE EXISTS (SELECT * FROM picking.PickingTask AS pt
	WHERE pt.PickingTaskId=ptd.PickingTaskId AND pt.Active=1 AND (pt.PickingTaskStatusId <> 4 OR pt.PickingCompleteDate > @today) )
	AND ( ptd.Active =1  OR @ShowInactive = 1 )
	AND EXISTS (SELECT * FROM @PickingTaskIds AS pti WHERE pti.ID=ptd.PickingTaskId)
END
ELSE IF @localBucketId IS NOT NULL 
BEGIN
	INSERT INTO @PickingTaskDetailIds(PickingTaskDetailId)
	SELECT ptd.PickingTaskDetailId FROM picking.PickingTaskDetail AS ptd
	WHERE EXISTS (SELECT * FROM picking.PickingTask AS pt
	WHERE pt.PickingTaskId=ptd.PickingTaskId AND pt.Active=1 AND pt.BucketId=@localBucketId AND (pt.PickingTaskStatusId <> 4 OR pt.PickingCompleteDate > @today) )
	AND ( ptd.Active =1  OR @ShowInactive = 1 )

	
END
	
	INSERT INTO @BucketsTasks( PickingTaskId, DropLocation, RushOrder, CreatedTime, AssignedTime, PickingTaskStatus,
								  Editable, CompleteDate, FirstName, LastName, PickerId, UpdateTime,
								  PickingTaskStatusId, Name, SortOrder, TotalItems, TotalPicked,PickingDate, ETA, BucketId, BucketName )
		SELECT pt.PickingTaskId , pdl.PickDropLocation AS DropLocation , pt.RushOrder, pt.AddTime AS CreatedTime, pt.AssignedTime , pts.Name AS PickingTaskStatus, ISNULL(e.Editable,1) AS Editable
		, pt.PickingCompleteDate AS CompleteDate , p.FirstName , p.LastName  , pt.PickerId , pt.UpdateTime AS LastUpdate , pts.PickingTaskStatusId, pts.Name, pts.SortOrder,
		COUNT(*) AS TotalItems, SUM( CAST(ptd.Picked AS INT)) AS TotalPicked , MIN(te.PickingDate) AS PickingDate, MIN(o.EstimatedCompleteDate) AS ETA , b.BucketId, b.Name AS BucketName
		   FROM picking.PickingTask pt 
		   JOIN picking.Buckets b ON b.BucketId = pt.BucketId
		   JOIN dbo.tb_PickDropLocations pdl ON pdl.ID = pt.DropLocationId
		   JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		   OUTER APPLY (SELECT anu.FirstName, anu.LastName FROM picking.Pickers p JOIN dbo.AspNetUsers anu ON anu.Id = p.UserId WHERE p.PickerId=pt.PickerId) p
		   OUTER APPLY (SELECT CAST( 0 AS BIT) AS Editable FROM picking.BucketRules br WHERE br.BucketId = pt.BucketId AND br.RuleId = 2) e
		   JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId 
		   CROSS APPLY (SELECT te.OrderID ,  te.PickingDate FROM dbo.TranEntry te  WHERE te.id=ptd.ItemId AND te.isActive =1 ) te
		   CROSS APPLY (SELECT o.EstimatedCompleteDate FROM dbo.[Order] o WHERE o.ID = te.OrderID) o
	WHERE EXISTS (SELECT * FROM @PickingTaskDetailIds AS ptdi WHERE ptdi.PickingTaskDetailId=ptd.PickingTaskDetailId)
	GROUP BY ISNULL(e.Editable, 1), pt.PickingTaskId, pdl.PickDropLocation, pt.RushOrder, pt.AddTime, pt.AssignedTime,
			 pts.Name, pt.PickingCompleteDate, p.FirstName, p.LastName, pt.PickerId, pt.UpdateTime,
			 pts.PickingTaskStatusId, pts.Name, pts.SortOrder, b.BucketId, b.Name
RETURN

END




GO
/****** Object:  UserDefinedFunction [picking].[GetBucketsTasks1]    Script Date: 6/17/2021 11:37:56 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 8/2/2018
-- Description:	Get Buckets Tasks summary
-- =============================================
CREATE FUNCTION [picking].[GetBucketsTasks1]
(	
	@BucketId INT = NULL,
	@term VARCHAR(50) = NULL,
	@ShowInactive BIT =  0

)
RETURNS @BucketsTasks TABLE
(
    PickingTaskId INT,
    DropLocation VARCHAR(150),
    RushOrder BIT,
    CreatedTime DATETIME,
    AssignedTime DATETIME,
    PickingTaskStatus VARCHAR(15),
    Editable BIT,
    PickingCompleteDate DATETIME,
    FirstName NVARCHAR(50),
	LastName NVARCHAR(50),
	PickerId INT,
	UpdateTime DATETIME,
	PickingTaskStatusId INT,
	Name VARCHAR(15),
	SortOrder INT,
	TotalItems INT,
	TotalPicked INT,
	PickingDate DATE,
	ETA DATETIME,
	BucketId INT,
	BucketName VARCHAR(30)
) 
AS 
BEGIN

DECLARE @PickingTaskIds IDList 

IF @term IS NOT NULL
BEGIN
	IF ISNUMERIC(@term) = 0
	BEGIN
		INSERT INTO @PickingTaskIds ( ID )
			 SELECT ptd1.PickingTaskId FROM dbo.[Order] o 
		  JOIN dbo.TranEntry te1 ON te1.OrderID = o.OrderID 
		  JOIN picking.PickingTaskDetail ptd1 ON ptd1.ItemId = te1.ID AND ptd1.Active =1
		  WHERE o.SOnumber = @term
	END
	ELSE
	BEGIN
		INSERT INTO @PickingTaskIds ( ID )
		SELECT ptd1.PickingTaskId  FROM  dbo.TranEntry te1
		  JOIN picking.PickingTaskDetail ptd1 ON ptd1.ItemId = te1.ID AND ptd1.Active =1
		  WHERE te1.ID = CAST(@term AS  int)   
	END
		INSERT INTO @BucketsTasks( PickingTaskId, DropLocation, RushOrder, CreatedTime, AssignedTime, PickingTaskStatus,
								  Editable, PickingCompleteDate, FirstName, LastName, PickerId, UpdateTime,
								  PickingTaskStatusId, Name, SortOrder, TotalItems, TotalPicked,PickingDate, ETA, BucketId, BucketName )
		SELECT pt.PickingTaskId , pdl.PickDropLocation AS DropLocation , pt.RushOrder, pt.AddTime AS CreatedTime, pt.AssignedTime , pts.Name AS PickingTaskStatus, ISNULL(e.Editable,1) AS Editable
		, pt.PickingCompleteDate AS CompleteDate , p.FirstName , p.LastName  , pt.PickerId , pt.UpdateTime AS LastUpdate , pts.PickingTaskStatusId, pts.Name, pts.SortOrder,
		COUNT(*) AS TotalItems, SUM( CAST(ptd.Picked AS INT)) AS TotalPicked , MIN(te.PickingDate) AS PickingDate, MIN(o.EstimatedCompleteDate) AS ETA , b.BucketId, b.Name AS BucketName
		   FROM picking.PickingTask pt 
		   JOIN picking.Buckets b ON b.BucketId = pt.BucketId
		   JOIN dbo.tb_PickDropLocations pdl ON pdl.ID = pt.DropLocationId
		   JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		   OUTER APPLY (SELECT anu.FirstName, anu.LastName FROM picking.Pickers p JOIN dbo.AspNetUsers anu ON anu.Id = p.UserId WHERE p.PickerId=pt.PickerId) p
		   OUTER APPLY (SELECT CAST( 0 AS BIT) AS Editable FROM picking.BucketRules br WHERE br.BucketId = pt.BucketId AND br.RuleId = 2) e
		   JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId AND ( ptd.Active =1 OR @ShowInactive = 1 )
		   JOIN dbo.TranEntry te ON te.ID = ptd.ItemId
		   JOIN dbo.[Order] AS o ON o.ID = te.OrderID
	WHERE ( pt.BucketId = @bucketId OR @BucketId IS NULL) AND ( pt.Active =1  OR @ShowInactive = 1 ) AND ( pt.PickingTaskStatusId   <> 4 OR pt.PickingCompleteDate > CAST(GETDATE() AS DATE))
	AND pt.PickingTaskId IN(SELECT pti.ID FROM @PickingTaskIds pti)  
	GROUP BY ISNULL(e.Editable, 1), pt.PickingTaskId, pdl.PickDropLocation, pt.RushOrder, pt.AddTime, pt.AssignedTime,
			 pts.Name, pt.PickingCompleteDate, p.FirstName, p.LastName, pt.PickerId, pt.UpdateTime,
			 pts.PickingTaskStatusId, pts.Name, pts.SortOrder, b.BucketId, b.Name
END
ELSE IF @BucketId IS NOT NULL
BEGIN

	INSERT INTO @BucketsTasks( PickingTaskId, DropLocation, RushOrder, CreatedTime, AssignedTime, PickingTaskStatus,
								  Editable, PickingCompleteDate, FirstName, LastName, PickerId, UpdateTime,
								  PickingTaskStatusId, Name, SortOrder, TotalItems, TotalPicked,PickingDate, ETA, BucketId, BucketName )
		SELECT pt.PickingTaskId , pdl.PickDropLocation AS DropLocation , pt.RushOrder, pt.AddTime AS CreatedTime, pt.AssignedTime , pts.Name AS PickingTaskStatus, ISNULL(e.Editable,1) AS Editable
		, pt.PickingCompleteDate AS CompleteDate , p.FirstName , p.LastName  , pt.PickerId , pt.UpdateTime AS LastUpdate , pts.PickingTaskStatusId, pts.Name, pts.SortOrder,
		COUNT(*) AS TotalItems, SUM( CAST(ptd.Picked AS INT)) AS TotalPicked , MIN(te.PickingDate) AS PickingDate, MIN(o.EstimatedCompleteDate) AS ETA , b.BucketId, b.Name AS BucketName
		   FROM picking.PickingTask pt 
		   JOIN picking.Buckets b ON b.BucketId = pt.BucketId
		   JOIN dbo.tb_PickDropLocations pdl ON pdl.ID = pt.DropLocationId
		   JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		   OUTER APPLY (SELECT anu.FirstName, anu.LastName FROM picking.Pickers p JOIN dbo.AspNetUsers anu ON anu.Id = p.UserId WHERE p.PickerId=pt.PickerId) p
		   OUTER APPLY (SELECT CAST( 0 AS BIT) AS Editable FROM picking.BucketRules br WHERE br.BucketId = pt.BucketId AND br.RuleId = 2) e
		   JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId AND ( ptd.Active =1 OR @ShowInactive = 1 )
		   JOIN dbo.TranEntry te ON te.ID = ptd.ItemId
		   JOIN dbo.[Order] AS o ON o.ID = te.OrderID
	WHERE pt.BucketId = @bucketId AND ( pt.Active =1  OR @ShowInactive = 1 ) AND ( pt.PickingTaskStatusId   <> 4 OR pt.PickingCompleteDate > CAST(GETDATE() AS DATE))
	--AND (  pt.PickingTaskId IN(SELECT pti.ID FROM @PickingTaskIds pti) OR @term IS NULL )
	GROUP BY ISNULL(e.Editable, 1), pt.PickingTaskId, pdl.PickDropLocation, pt.RushOrder, pt.AddTime, pt.AssignedTime,
			 pts.Name, pt.PickingCompleteDate, p.FirstName, p.LastName, pt.PickerId, pt.UpdateTime,
			 pts.PickingTaskStatusId, pts.Name, pts.SortOrder, b.BucketId, b.Name
END
		 RETURN
END


GO
/****** Object:  UserDefinedFunction [picking].[GetBucketsTasksOld]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 8/2/2018
-- Description:	Get Buckets Tasks summary
-- =============================================
CREATE FUNCTION [picking].[GetBucketsTasksOld]
(	
	@BucketId INT = NULL,
	@term VARCHAR(50) = NULL,
	@ShowInactive BIT =  0

)
RETURNS @BucketsTasks TABLE
(
    PickingTaskId INT,
    DropLocation VARCHAR(150),
    RushOrder BIT,
    CreatedTime DATETIME,
    AssignedTime DATETIME,
    PickingTaskStatus VARCHAR(15),
    Editable BIT,
    CompleteDate DATETIME,
    FirstName NVARCHAR(50),
	LastName NVARCHAR(50),
	PickerId INT,
	UpdateTime DATETIME,
	PickingTaskStatusId INT,
	Name VARCHAR(15),
	SortOrder INT,
	TotalItems INT,
	TotalPicked INT,
	PickingDate DATE,
	ETA DATETIME,
	BucketId INT,
	BucketName VARCHAR(30)
) 
AS 
BEGIN

DECLARE @PickingTaskIds IDList 
DECLARE @localBucketId INT = @BucketId
IF @term IS NOT NULL
BEGIN
	IF ISNUMERIC(@term) = 0
	BEGIN
		INSERT INTO @PickingTaskIds ( ID )
			 SELECT ptd1.PickingTaskId FROM dbo.[Order] o 
		  JOIN dbo.TranEntry te1 ON te1.OrderID = o.OrderID 
		  JOIN picking.PickingTaskDetail ptd1 ON ptd1.ItemId = te1.ID AND ptd1.Active =1
		  WHERE o.SOnumber = @term
	END
	ELSE
	BEGIN
		INSERT INTO @PickingTaskIds ( ID )
		SELECT ptd1.PickingTaskId  FROM  dbo.TranEntry te1
		  JOIN picking.PickingTaskDetail ptd1 ON ptd1.ItemId = te1.ID AND ptd1.Active =1
		  WHERE te1.ID = CAST(@term AS  int)   
	END
		INSERT INTO @BucketsTasks( PickingTaskId, DropLocation, RushOrder, CreatedTime, AssignedTime, PickingTaskStatus,
								  Editable, CompleteDate, FirstName, LastName, PickerId, UpdateTime,
								  PickingTaskStatusId, Name, SortOrder, TotalItems, TotalPicked,PickingDate, ETA, BucketId, BucketName )
		SELECT pt.PickingTaskId , pdl.PickDropLocation AS DropLocation , pt.RushOrder, pt.AddTime AS CreatedTime, pt.AssignedTime , pts.Name AS PickingTaskStatus, ISNULL(e.Editable,1) AS Editable
		, pt.PickingCompleteDate AS CompleteDate , p.FirstName , p.LastName  , pt.PickerId , pt.UpdateTime AS LastUpdate , pts.PickingTaskStatusId, pts.Name, pts.SortOrder,
		COUNT(*) AS TotalItems, SUM( CAST(ptd.Picked AS INT)) AS TotalPicked , MIN(te.PickingDate) AS PickingDate, MIN(o.EstimatedCompleteDate) AS ETA , b.BucketId, b.Name AS BucketName
		   FROM picking.PickingTask pt 
		   JOIN picking.Buckets b ON b.BucketId = pt.BucketId
		   JOIN dbo.tb_PickDropLocations pdl ON pdl.ID = pt.DropLocationId
		   JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		   OUTER APPLY (SELECT anu.FirstName, anu.LastName FROM picking.Pickers p JOIN dbo.AspNetUsers anu ON anu.Id = p.UserId WHERE p.PickerId=pt.PickerId) p
		   OUTER APPLY (SELECT CAST( 0 AS BIT) AS Editable FROM picking.BucketRules br WHERE br.BucketId = pt.BucketId AND br.RuleId = 2) e
		   JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId AND ( ptd.Active =1 OR @ShowInactive = 1 )
		   CROSS APPLY (SELECT te.OrderID ,  te.PickingDate FROM dbo.TranEntry te  WHERE te.id=ptd.ItemId AND te.isActive =1 ) te
		   CROSS APPLY (SELECT o.EstimatedCompleteDate FROM dbo.[Order] o WHERE o.ID = te.OrderID) o
	WHERE ( pt.BucketId = @localBucketId OR @localBucketId IS NULL) AND ( pt.Active =1  OR @ShowInactive = 1 ) AND ( pt.PickingTaskStatusId   <> 4 OR pt.PickingCompleteDate > CAST(GETDATE() AS DATE))
	AND pt.PickingTaskId IN(SELECT pti.ID FROM @PickingTaskIds pti)  
	GROUP BY ISNULL(e.Editable, 1), pt.PickingTaskId, pdl.PickDropLocation, pt.RushOrder, pt.AddTime, pt.AssignedTime,
			 pts.Name, pt.PickingCompleteDate, p.FirstName, p.LastName, pt.PickerId, pt.UpdateTime,
			 pts.PickingTaskStatusId, pts.Name, pts.SortOrder, b.BucketId, b.Name
END
ELSE IF @localBucketId IS NOT NULL
BEGIN

	INSERT INTO @BucketsTasks( PickingTaskId, DropLocation, RushOrder, CreatedTime, AssignedTime, PickingTaskStatus,
								  Editable, CompleteDate, FirstName, LastName, PickerId, UpdateTime,
								  PickingTaskStatusId, Name, SortOrder, TotalItems, TotalPicked,PickingDate, ETA, BucketId, BucketName )
		SELECT pt.PickingTaskId , pdl.PickDropLocation AS DropLocation , pt.RushOrder, pt.AddTime AS CreatedTime, pt.AssignedTime , pts.Name AS PickingTaskStatus, ISNULL(e.Editable,1) AS Editable
		, pt.PickingCompleteDate AS CompleteDate , p.FirstName , p.LastName  , pt.PickerId , pt.UpdateTime AS LastUpdate , pts.PickingTaskStatusId, pts.Name, pts.SortOrder,
		COUNT(*) AS TotalItems, SUM( CAST(ptd.Picked AS INT)) AS TotalPicked , MIN(te.PickingDate) AS PickingDate, MIN(o.EstimatedCompleteDate) AS ETA , b.BucketId, b.Name AS BucketName
		   FROM picking.PickingTask pt 
		   JOIN picking.Buckets b ON b.BucketId = pt.BucketId
		   JOIN dbo.tb_PickDropLocations pdl ON pdl.ID = pt.DropLocationId
		   JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		   OUTER APPLY (SELECT anu.FirstName, anu.LastName FROM picking.Pickers p JOIN dbo.AspNetUsers anu ON anu.Id = p.UserId WHERE p.PickerId=pt.PickerId) p
		   OUTER APPLY (SELECT CAST( 0 AS BIT) AS Editable FROM picking.BucketRules br WHERE br.BucketId = pt.BucketId AND br.RuleId = 2) e
		   JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId AND ( ptd.Active =1 OR @ShowInactive = 1 )
		   CROSS APPLY (SELECT te.OrderID ,  te.PickingDate FROM dbo.TranEntry te  WHERE te.id=ptd.ItemId AND te.isActive =1 ) te
		   CROSS APPLY (SELECT o.EstimatedCompleteDate FROM dbo.[Order] o WHERE o.ID = te.OrderID) o
	WHERE pt.BucketId = @localBucketId AND ( pt.Active =1  OR @ShowInactive = 1 ) AND ( pt.PickingTaskStatusId   <> 4 OR pt.PickingCompleteDate > CAST(GETDATE() AS DATE))
	--AND (  pt.PickingTaskId IN(SELECT pti.ID FROM @PickingTaskIds pti) OR @term IS NULL )
	GROUP BY ISNULL(e.Editable, 1), pt.PickingTaskId, pdl.PickDropLocation, pt.RushOrder, pt.AddTime, pt.AssignedTime,
			 pts.Name, pt.PickingCompleteDate, p.FirstName, p.LastName, pt.PickerId, pt.UpdateTime,
			 pts.PickingTaskStatusId, pts.Name, pts.SortOrder, b.BucketId, b.Name
END

RETURN

END




GO
/****** Object:  UserDefinedFunction [picking].[GetBucketsTasksTest]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 8/2/2018
-- Description:	Get Buckets Tasks summary
-- =============================================
CREATE FUNCTION [picking].[GetBucketsTasksTest]
(	
	@BucketId INT = NULL,
	@term VARCHAR(50) = NULL,
	@ShowInactive BIT =  0

)
RETURNS @BucketsTasks TABLE
(
    PickingTaskId INT,
    DropLocation VARCHAR(150),
    RushOrder BIT,
    CreatedTime DATETIME,
    AssignedTime DATETIME,
    PickingTaskStatus VARCHAR(15),
    Editable BIT,
    CompleteDate DATETIME,
    FirstName NVARCHAR(50),
	LastName NVARCHAR(50),
	PickerId INT,
	UpdateTime DATETIME,
	PickingTaskStatusId INT,
	Name VARCHAR(15),
	SortOrder INT,
	TotalItems INT,
	TotalPicked INT,
	PickingDate DATE,
	ETA DATETIME,
	BucketId INT,
	BucketName VARCHAR(30)
) 
AS 
BEGIN

DECLARE @PickingTaskIds IDList 
DECLARE @PickingTaskDetailIds TABLE (PickingTaskDetailId INT NOT NULL)
DECLARE @localBucketId INT = @BucketId
DECLARE @today DATE = GETDATE()
IF @term IS NOT NULL
BEGIN
	IF ISNUMERIC(@term) = 0
	BEGIN
		INSERT INTO @PickingTaskIds ( ID )
		SELECT ptd.PickingTaskId FROM picking.PickingTaskDetail AS ptd
		WHERE 
			EXISTS(SELECT * FROM dbo.TranEntry AS te JOIN dbo.[Order] o ON o.ID = te.OrderID WHERE te.ID = ptd.ItemId AND o.SOnumber = @term)
			AND EXISTS (SELECT * FROM picking.PickingTask AS pt
			WHERE pt.PickingTaskId=ptd.PickingTaskId AND ( pt.Active =1  OR @ShowInactive = 1 )
			AND (  @localBucketId IS NULL OR pt.BucketId=@localBucketId ) AND (pt.PickingTaskStatusId <> 4 OR pt.PickingCompleteDate > @today) )
			AND ( ptd.Active =1  OR @ShowInactive = 1 )
	END
	ELSE
	BEGIN
		INSERT INTO @PickingTaskIds ( ID )
		SELECT ptd.PickingTaskId  FROM  dbo.TranEntry te
		  JOIN picking.PickingTaskDetail ptd ON ptd.ItemId = te.ID AND ptd.Active =1
		  WHERE te.ID = CAST(@term AS  int)   
		  AND EXISTS (SELECT * FROM picking.PickingTask AS pt
			WHERE pt.PickingTaskId=ptd.PickingTaskId AND ( pt.Active =1  OR @ShowInactive = 1 )
			AND (  @localBucketId IS NULL OR pt.BucketId=@localBucketId ) AND (pt.PickingTaskStatusId <> 4 OR pt.PickingCompleteDate > @today) )
			AND ( ptd.Active =1  OR @ShowInactive = 1 )
	END
	INSERT INTO @PickingTaskDetailIds(PickingTaskDetailId)
	SELECT ptd.PickingTaskDetailId FROM picking.PickingTaskDetail AS ptd
	WHERE EXISTS (SELECT * FROM picking.PickingTask AS pt
	WHERE pt.PickingTaskId=ptd.PickingTaskId AND pt.Active=1 AND (pt.PickingTaskStatusId <> 4 OR pt.PickingCompleteDate > @today) )
	AND ( ptd.Active =1  OR @ShowInactive = 1 )
	AND EXISTS (SELECT * FROM @PickingTaskIds AS pti WHERE pti.ID=ptd.PickingTaskId)
END
ELSE IF @localBucketId IS NOT NULL 
BEGIN
	INSERT INTO @PickingTaskDetailIds(PickingTaskDetailId)
	SELECT ptd.PickingTaskDetailId FROM picking.PickingTaskDetail AS ptd
	WHERE EXISTS (SELECT * FROM picking.PickingTask AS pt
	WHERE pt.PickingTaskId=ptd.PickingTaskId AND pt.Active=1 AND pt.BucketId=@localBucketId AND (pt.PickingTaskStatusId <> 4 OR pt.PickingCompleteDate > @today) )
	AND ( ptd.Active =1  OR @ShowInactive = 1 )

	
END
	
	INSERT INTO @BucketsTasks( PickingTaskId, DropLocation, RushOrder, CreatedTime, AssignedTime, PickingTaskStatus,
								  Editable, CompleteDate, FirstName, LastName, PickerId, UpdateTime,
								  PickingTaskStatusId, Name, SortOrder, TotalItems, TotalPicked,PickingDate, ETA, BucketId, BucketName )
		SELECT pt.PickingTaskId , pdl.PickDropLocation AS DropLocation , pt.RushOrder, pt.AddTime AS CreatedTime, pt.AssignedTime , pts.Name AS PickingTaskStatus, ISNULL(e.Editable,1) AS Editable
		, pt.PickingCompleteDate AS CompleteDate , p.FirstName , p.LastName  , pt.PickerId , pt.UpdateTime AS LastUpdate , pts.PickingTaskStatusId, pts.Name, pts.SortOrder,
		COUNT(*) AS TotalItems, SUM( CAST(ptd.Picked AS INT)) AS TotalPicked , MIN(te.PickingDate) AS PickingDate, MIN(o.EstimatedCompleteDate) AS ETA , b.BucketId, b.Name AS BucketName
		   FROM picking.PickingTask pt 
		   JOIN picking.Buckets b ON b.BucketId = pt.BucketId
		   JOIN dbo.tb_PickDropLocations pdl ON pdl.ID = pt.DropLocationId
		   JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		   OUTER APPLY (SELECT anu.FirstName, anu.LastName FROM picking.Pickers p JOIN dbo.AspNetUsers anu ON anu.Id = p.UserId WHERE p.PickerId=pt.PickerId) p
		   OUTER APPLY (SELECT CAST( 0 AS BIT) AS Editable FROM picking.BucketRules br WHERE br.BucketId = pt.BucketId AND br.RuleId = 2) e
		   JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId 
		   CROSS APPLY (SELECT te.OrderID ,  te.PickingDate FROM dbo.TranEntry te  WHERE te.id=ptd.ItemId AND te.isActive =1 ) te
		   CROSS APPLY (SELECT o.EstimatedCompleteDate FROM dbo.[Order] o WHERE o.ID = te.OrderID) o
	WHERE EXISTS (SELECT * FROM @PickingTaskDetailIds AS ptdi WHERE ptdi.PickingTaskDetailId=ptd.PickingTaskDetailId)
	GROUP BY ISNULL(e.Editable, 1), pt.PickingTaskId, pdl.PickDropLocation, pt.RushOrder, pt.AddTime, pt.AssignedTime,
			 pts.Name, pt.PickingCompleteDate, p.FirstName, p.LastName, pt.PickerId, pt.UpdateTime,
			 pts.PickingTaskStatusId, pts.Name, pts.SortOrder, b.BucketId, b.Name
RETURN

END




GO
/****** Object:  UserDefinedFunction [picking].[GetCustomFinishOperations]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[GetCustomFinishOperations]
(
	@OrderItemId AS INT
)
RETURNS @CustomFinishOperations TABLE 
(
	ProductionWorkcenterId INT NOT NULL,
	WorkCenter VARCHAR(255) NOT NULL, 
	OperationDescription VARCHAR(255),
	OperationId VARCHAR(50),
	Minutes INT NOT NULL DEFAULT 0, 
	CustomAssembly BIT NOT NULL DEFAULT 1 
)
AS
BEGIN

	INSERT @CustomFinishOperations ( ProductionWorkcenterId, WorkCenter,OperationDescription , OperationId, Minutes , CustomAssembly )

	SELECT  mods.ProductionWorkcenterId,mods.WorkCenter,mods.Description, mods.OperationId , COALESCE(mods.Minutes ,0) , CASE WHEN te.ItemType = 2 THEN 0 ELSE 1 END
	FROM dbo.TranEntry te 
	JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1 AND te.isActive =1
	JOIN dbo.Departmentstatus d ON d.ID = o.DepartmentstatusID AND d.isShipped =0
	JOIN dbo.Departmentstatus d2 ON d2.ID = te.DepartmentstatusID
	JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber AND il.ItemTypeCode IN(1,2)
	CROSS APPLY (
	SELECT SUM(il.Minutes) Minutes ,  pwc.ProductionWorkcenterId, pwc.WorkCenter, pwc.Description , CASE WHEN pwc.ProductionWorkcenterId = 5 THEN '0012' ELSE '0018' END AS OperationId FROM dbo.TranEntry te2
	JOIN dbo.tb_ItemList il ON il.ItemCode = te2.ItemNumber
	JOIN dbo.ProductionWorkCenter pwc ON pwc.ProductionWorkcenterId = CASE WHEN il.ServiceType = 'Finishing' THEN 5 ELSE 4  END
	 WHERE te2.OrderID=o.ID AND te2.EZParentProdID= te.EZProdID AND te2.isDeleted =0 AND te2.ItemType = 4
	 --AND te2.ItemNumber NOT IN('UP CHARGE:Finishing:MATCH-INTERIOR','UP CHARGE:Finishing')
	 GROUP BY CASE WHEN pwc.ProductionWorkcenterId = 5 THEN '0012'
              ELSE '0018'
              END, pwc.ProductionWorkcenterId, pwc.WorkCenter, pwc.Description-- pwc.ProductionWorkcenterId,pwc.WorkCenter,CASE WHEN pwc.ProductionWorkcenterId = 5 THEN '0012' ELSE '0018' END
	) mods
	WHERE  ( te.HasCustomizing=1 OR te.HasFinishing =1 )AND te.PickDropLoc IN('C','F')
	AND te.ID = @OrderItemId
    RETURN 
END
GO
/****** Object:  UserDefinedFunction [picking].[GetCustomFinishRulesForOrderItemId]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 8/23/2019
-- Description:	Get Custom Finish Rules For OrderItemId
-- =============================================
CREATE FUNCTION [picking].[GetCustomFinishRulesForOrderItemId]
(
	@orderItemId INT,
	@MaterialList OrderMaterialDetail READONLY,
	@bomRevision VARCHAR(1) = 'C'
)
RETURNS @AddremoveRules TABLE 
(
	RuleId INT NULL,
	AddRemoveAction VARCHAR(10),
	InventoryId VARCHAR(50),
	Quantity INT DEFAULT(1),
	QuantityAll BIT DEFAULT(0),
	WorkCenter VARCHAR(50) DEFAULT ('PICKING'),
	OperationDescription VARCHAR(400),
	OperationNumber VARCHAR(10),
	BackflushLabor BIT DEFAULT(1),
	PartType INT,
	FunctionPart VARCHAR(150)
)
AS 
BEGIN

	IF @bomRevision IN( 'A', 'FG')
		RETURN

	DECLARE @ComponentPartTypeMatchRules TABLE(ComponentPartTypeId INT,Dimension VARCHAR(50) );

	INSERT @ComponentPartTypeMatchRules(ComponentPartTypeId, Dimension) 
		SELECT 1, 'Height' UNION SELECT 1, 'Width' UNION 
		SELECT 2, 'Width' UNION SELECT 2, 'Depth' UNION 
		SELECT 3, 'Depth' UNION SELECT 3, 'Height' UNION 
		SELECT 4, 'Depth' UNION SELECT 4, 'Height' UNION 
		SELECT 5, 'Width' UNION SELECT 5, 'Depth' UNION 
		SELECT 8, 'Height' UNION SELECT 8, 'Width' UNION 
		SELECT 9, 'Width' UNION SELECT 9, 'Depth' UNION 
		SELECT 12, 'Depth' UNION SELECT 12, 'Height' UNION 
		SELECT 10, 'Width' UNION
		SELECT 6, 'Width' UNION SELECT 6, 'Height' UNION SELECT 6, 'Depth'; 

		DECLARE @ModConfigRules TABLE(Config VARCHAR(50) NOT NULL, ComponentPartId INT NOT NULL, ProductId INT NULL)
		INSERT @ModConfigRules(Config, ComponentPartId, ProductId)
		VALUES
		('LEFT DRAWER', 7, NULL),('LOWER DRAWER', 17, NULL),('LOWER DRAWER LEFT', 17, NULL),('LOWER DRAWER RIGHT', 17, NULL),('MIDDLE DRAWER', 17, NULL),('MIDDLE DRAWER LEFT', 17, NULL),
		('MIDDLE DRAWER RIGHT', 17, NULL),('MIDDLE LOWER', 7, NULL),('MIDDLE UPPER', 7, NULL),('RIGHT DRAWER', 7, NULL),('UPPER DRAWER', 7, NULL),('LOWER DRAWER', 7, 777 ),('LOWER DRAWER', 7, 778 ),
		('LOWER DRAWER', 7, 779 ),('UPPER DRAWER', 17, 153 ),('UPPER DRAWER', 17, 156 ),('UPPER DRAWER', 17, 158 ),('MIDDLE DRAWER', 7, 494 ),('MIDDLE DRAWER', 7, 495 ),('MIDDLE DRAWER', 7, 496)
		
		DECLARE @itemAddRemove TABLE (ProductionItemModifcationAddRemoveRuleId INT NULL, ModifcationId INT, ActionType VARCHAR(10), PartTypeId INT, PartType VARCHAR(50), PartItemCode VARCHAR(50), 
		QuantityAll BIT DEFAULT(1), Quantity INT NULL, FunctionPart VARCHAR(50))

		INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, QuantityAll, FunctionPart)

		SELECT mr.ProductionItemModifcationAddRemoveRuleId,  'Remove' ,mr.PartId , il3.ShortItemCode, mr.Quantity, CASE WHEN mr.Quantity IS NOT NULL THEN 0 ELSE 1 END, 'Remove'
		FROM dbo.TranEntry te
			JOIN dbo.TranEntry te2 ON te2.OrderID = te.OrderID 
				AND te2.EZParentProdID = te.EZProdID 
				--AND te2.isActive = te.isActive
				AND te2.isDeleted = 0
				AND te.isDeleted = 0 
				AND te.isActive = 1
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber 
			JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te2.ItemNumber
			JOIN @MaterialList ml ON 1=1
			JOIN dbo.tb_ItemList il3 ON il3.AcumaticaName = ml.InventoryID 
			CROSS APPLY
			(
				SELECT ISNULL(cr.Quantity, gpimarr.Quantity) AS Quantity, gpimarr.HasCustomizing, gpimarr.ExcludeTag, gpimarr.SubItemType, gpimarr.ExcludeWhenPartProductCodeHasText, gpimarr.ProductionItemModifcationAddRemoveRuleId,
                gpimarr.OnlyFromTag, gpimarr.ReplacementProductId, gpimarr.ComponentPartTypeToAdd, gpimarr.ExcludeWhenProductHasText, gpimarr.OnlyWhenProductHasText, gpimarr.OnlyRemoveWhenAdd, 
				--CASE WHEN gpimarr.ProductionItemModifcationAddRemoveRuleId = 31 THEN cr.PartId
				--ELSE 
				COALESCE(cr.PartId, drawerBoxInMl.ComponentPartTypeId, gpimarr.PartId)
				--END 
				AS PartId
				FROM dbo.GetProductionItemModifcationAddRemoveRules(il2.ID, te.OrderID, te.EZProdID) AS gpimarr
				OUTER APPLY
				(
					SELECT Drawers.ComponentPartId AS PartId, COUNT(*) AS Quantity 
					FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
					CROSS APPLY
					(
						SELECT TOP (1) mcr.ComponentPartId FROM @ModConfigRules AS mcr
						WHERE mcr.Config = goict.ConfigValue
						ORDER BY CASE WHEN mcr.ProductId = il.ProductID
						THEN 0 WHEN mcr.ProductId IS NULL THEN 1 ELSE 2 END

					)AS Drawers
					WHERE goict.ConfigKey = 'Remove Drawers'
					AND gpimarr.ProductionItemModifcationAddRemoveRuleId = 31
					GROUP BY Drawers.ComponentPartId
				)AS cr
				OUTER APPLY
				(
					SELECT TOP (1) tilDb.ComponentPartTypeId FROM @MaterialList AS ml2
					JOIN dbo.tb_ItemList AS tilDb ON tilDb.AcumaticaName = ml2.InventoryID
					WHERE tilDb.ComponentPartTypeId IN(7, 17)
					AND gpimarr.ProductionItemModifcationAddRemoveRuleId = 31
				)drawerBoxInMl
				WHERE gpimarr.AddRemoveType = 'Remove' 
				AND 
				--CASE WHEN gpimarr.ProductionItemModifcationAddRemoveRuleId <> 31 THEN cr.PartId
				--ELSE 
				COALESCE(cr.PartId, drawerBoxInMl.ComponentPartTypeId, gpimarr.PartId) 
				--END 
				= il3.ComponentPartTypeId
				AND gpimarr.ModificationProductReplacementHeaderId IS NULL
				AND
				(
					gpimarr.ExcludeStyle IS NULL
					OR NOT EXISTS
					(
						SELECT * FROM inventory.DoorStyles AS ds
						WHERE ds.DoorStyleID = il.DoorStyleID
						AND EXISTS
						(
							SELECT * FROM dbo.FN_ListToTable( ' ', gpimarr.ExcludeStyle) AS fltt
							WHERE ds.Style LIKE '%' + fltt.ListValue + '%'
						)
					)
				) 
			)mr
			JOIN inventory.ComponentPartType cpt ON cpt.ComponentPartTypeId = il3.ComponentPartTypeId
			JOIN dbo.tb_AdjustedBoxDimensions abd ON abd.TranEntryID = te.ID
			JOIN inventory.AcumaticaStockItems asi ON asi.AcumaticaID = il.AcumaticaID
		WHERE te.ID = @orderItemId
		AND --ExcludeWhenProductHasText
		(
			mr.ExcludeWhenProductHasText IS NULL 
			OR NOT EXISTS
			(
				SELECT * FROM inventory.Products AS p2
				WHERE p2.ProductID = il.ProductID
				AND EXISTS
				(
					SELECT * FROM dbo.FN_ListToTable(' ', mr.ExcludeWhenProductHasText) AS fltt
					WHERE p2.ProductCode LIKE '%' +  fltt.ListValue  + '%'
				)
				--AND p2.ProductCode LIKE '%' + mr.ExcludeWhenProductHasText + '%'
			)				 
		)
		AND ( mr.ExcludeTag IS NULL OR NOT EXISTS (SELECT * FROM inventory.ProductToProductTags ptpt WHERE mr.ExcludeTag = ptpt.ProductTagId AND ptpt.ProductId=il.ProductID AND ptpt.DeleteFlag=0))
		AND ( mr.HasCustomizing IS NULL OR mr.HasCustomizing=te.HasCustomizing  )
		--FF-58
		AND 
		(
			mr.OnlyWhenProductHasText IS NULL
			OR EXISTS
			(
				SELECT * FROM inventory.Products AS p2
				WHERE p2.ProductID = il.ProductID
				AND p2.ProductCode LIKE '%' + mr.OnlyWhenProductHasText + '%'
			)
		)


		INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, FunctionPart)
			SELECT pimarr.ProductionItemModifcationAddRemoveRuleId, pimarr.AddRemoveType , COALESCE(pimarr.PartId, parts.ComponentPartTypeId), parts.InventoryID, parts.QtyRequired, 'From Sub Item'
			FROM dbo.TranEntry AS te 
			JOIN dbo.tb_ItemList AS tilmain ON tilmain.ItemCode = te.ItemNumber 
			JOIN dbo.TranEntry AS te2 ON te2.OrderID=te.OrderID AND te.EZProdID = te2.EZParentProdID 
			--AND te2.isActive = 1 
			AND te2.isDeleted = 0 AND te2.ItemType = 4
			JOIN dbo.tb_ItemList AS til ON til.ItemCode = te2.ItemNumber
			LEFT JOIN inventory.Products AS p ON p.ProductID = til.ProductID
			CROSS APPLY
			(
				SELECT * FROM dbo.GetProductionItemModifcationAddRemoveRules(til.ID, te.OrderID, te.EZProdID) AS gpimarr
				WHERE gpimarr.AddRemoveType = 'Add' AND (gpimarr.FromSubItem = 1 OR gpimarr.FromSubItemWhenPossible = 1)
				AND gpimarr.ModificationProductReplacementHeaderId IS NULL
				AND
				(
					gpimarr.ExcludeStyle IS NULL
					OR NOT EXISTS
					(
						SELECT * FROM inventory.DoorStyles AS ds
						WHERE ds.DoorStyleID = tilmain.DoorStyleID
						AND EXISTS
						(
							SELECT * FROM dbo.FN_ListToTable( ' ', gpimarr.ExcludeStyle) AS fltt
							WHERE ds.Style LIKE '%' + fltt.ListValue + '%'
						)
					)
				) 
				AND 
				( 
					gpimarr.ExcludeTag IS NULL 
					OR NOT EXISTS (SELECT * FROM inventory.ProductToProductTags ptpt WHERE gpimarr.ExcludeTag = ptpt.ProductTagId AND ptpt.ProductId=tilmain.ProductID AND ptpt.DeleteFlag=0 )
				)
				AND 
				(
					gpimarr.PartExcludeTag IS NULL 
					OR NOT EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt2 WHERE ptpt2.ProductId = til.ProductID AND ptpt2.ProductTagId = gpimarr.PartExcludeTag AND ptpt2.DeleteFlag=0)
				)
				AND (gpimarr.ExcludeWhenPartProductCodeHasText IS NULL OR '%' + p.ProductCode + '%' NOT LIKE gpimarr.ExcludeWhenPartProductCodeHasText)
				--FF-58
				AND 
				(
					gpimarr.OnlyWhenProductHasText IS NULL
					OR EXISTS
					(
						SELECT * FROM inventory.Products AS p2
						WHERE p2.ProductID = tilmain.ProductID
						AND p2.ProductCode LIKE '%' + gpimarr.OnlyWhenProductHasText + '%'
					)
				)
			)pimarr
			JOIN dbo.TranEntry AS te3 ON te3.OrderID=te.OrderID AND te.EZProdID = te3.EZParentProdID  AND te3.isDeleted = 0 AND te3.ItemType = pimarr.SubItemType			
			JOIN dbo.tb_ItemList AS tilsub  ON tilsub.ItemCode = te3.ItemNumber
			CROSS APPLY 
			( 
				SELECT bomd.InventoryID, til2.ComponentPartTypeId, bomd.QtyRequired
				FROM acumaticaManufacturing.BillOfMaterials AS bom
				JOIN dbo.tb_ItemList AS tilBom ON bom.InventoryID = tilBom.AcumaticaName 
				JOIN acumaticaManufacturing.BillOfMaterialOperations AS bomo ON bomo.BOMID = bom.BOMID AND bomo.DeleteFlag = 0
				JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = 0 AND bomd.OperationDbId=bomd.OperationDbId
				JOIN acumaticaManufacturing.BOMRevisions AS br ON br.AcumaticaName = bom.InventoryID AND bom.BOMID = COALESCE(br.BOMIDC, br.BOMIDB, br.BOMIDD, br.BOMIDE)
				JOIN dbo.tb_ItemList AS til2 ON til2.AcumaticaName = bomd.InventoryID
				WHERE bom.DeleteFlag = 0  AND bomo.WorkCenter = 'PICKING' 
				AND 
				(
					til2.ComponentPartTypeId = pimarr.PartId
					--IL-3334
					OR 
					(
						pimarr.PartId IS NULL
						--IL-3856
						AND 
						(
							til2.ComponentPartTypeId <> 11
							OR NOT EXISTS
							(
								SELECT * FROM  dbo.TranEntry AS te3 
								WHERE te.OrderID = te3.OrderID AND te.EZProdID = te3.EZParentProdID
								AND te3.ItemNumber = 'UP CHARGE:DOORS ON BO'
							)
						)                        
					)
				)
				AND bom.InventoryID = tilsub.AcumaticaName	
				AND NOT EXISTS
				(
					SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
					WHERE asitoi.StockAcumaticaID = til2.AcumaticaID
					AND asitoi.SortComponent >= asitoi.Quantity
					AND pimarr.OnlyWhenInStock = 1
				)	  
				AND NOT 
				(
					NOT EXISTS
					(
						SELECT * FROM dbo.ItemLocationsUpdate ilu
						JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
						WHERE il.ExcludeFrmStock = 0
						AND il.LocationType <> 13
						AND ilu.ItemCode = til2.ShortItemCode
					)
					AND pimarr.OnlyWhenInStock = 1
				)
				 AND --ExcludeWhenProductHasText
				 (
					pimarr.ExcludeWhenProductHasText IS NULL 
					OR NOT EXISTS
					(
						SELECT * FROM inventory.Products AS p2
						WHERE p2.ProductID = tilmain.ProductID
						AND EXISTS
						(
							SELECT * FROM dbo.FN_ListToTable(' ', pimarr.ExcludeWhenProductHasText) AS fltt
							WHERE p2.ProductCode LIKE  '%' +  fltt.ListValue  + '%'
						)
					)				 
				 )
				 AND --MatchOnTag
                 (
					pimarr.MatchOnTag IS NULL
					OR --original and replacement have tag
                    (
						EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE tilmain.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = pimarr.MatchOnTag AND ptpt.DeleteFlag=0)
						AND EXISTS (SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE tilBom.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = pimarr.MatchOnTag AND ptpt.DeleteFlag=0)
					)
					OR --original and replacement don't have tag
					(
						NOT EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE tilmain.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = MatchOnTag AND ptpt.DeleteFlag=0)
						AND NOT EXISTS (SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE tilBom.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = MatchOnTag AND ptpt.DeleteFlag=0)	
					)	
				 )
			 ) parts
			WHERE te.ID = @orderItemId 
			
		INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, FunctionPart)
		SELECT mr.ProductionItemModifcationAddRemoveRuleId, 'Add', cpt.ComponentPartTypeId, prtsToAdd.ShortItemCode, mr.Quantity, 'Not from sub item'
		FROM dbo.TranEntry te
			JOIN dbo.TranEntry te2 ON te2.OrderID = te.OrderID 
			AND te2.EZParentProdID = te.EZProdID
			--AND te2.isActive = te.isActive 
			AND te.isActive = 1
			AND te.isDeleted = 0
			AND te2.isDeleted = 0
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber 
			JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te2.ItemNumber
			JOIN dbo.tb_AdjustedBoxDimensions abd ON abd.TranEntryID = te.ID
			JOIN inventory.AcumaticaStockItems asi ON asi.AcumaticaID = il.AcumaticaID
			CROSS APPLY
			(
				SELECT * FROM dbo.GetProductionItemModifcationAddRemoveRules(il2.ID, te.OrderID, te.EZProdID) AS gpimarr
				WHERE gpimarr.AddRemoveType = 'Add'  
				AND gpimarr.ModificationProductReplacementHeaderId IS NULL
				AND
				(
					gpimarr.ExcludeStyle IS NULL
					OR NOT EXISTS
					(
						SELECT * FROM inventory.DoorStyles AS ds
						WHERE ds.DoorStyleID = il.DoorStyleID
						AND EXISTS
						(
							SELECT * FROM dbo.FN_ListToTable( ' ', gpimarr.ExcludeStyle) AS fltt
							WHERE ds.Style LIKE '%' + fltt.ListValue + '%'
						)
					)
				) 
				AND 
				(
					gpimarr.FromSubItem = 0 
					OR (gpimarr.FromSubItemWhenPossible = 1 AND NOT EXISTS(SELECT * FROM @itemAddRemove AS iar WHERE iar.ProductionItemModifcationAddRemoveRuleId IS NOT NULL 
						AND iar.ProductionItemModifcationAddRemoveRuleId = gpimarr.ProductionItemModifcationAddRemoveRuleId))
					AND ( gpimarr.ExcludeTag IS NULL OR NOT EXISTS (SELECT * FROM inventory.ProductToProductTags ptpt WHERE gpimarr.ExcludeTag = ptpt.ProductTagId AND ptpt.ProductId=il.ProductID AND ptpt.DeleteFlag=0 ))									
				)
				AND 
				(
					gpimarr.OnlyWhenProductHasText IS NULL
					OR EXISTS
					(
						SELECT * FROM inventory.Products AS p2
						WHERE p2.ProductID = il.ProductID
						AND p2.ProductCode LIKE '%' + gpimarr.OnlyWhenProductHasText + '%'
					)
				)
			)mr
			JOIN inventory.ComponentPartType cpt ON cpt.ComponentPartTypeId = mr.PartId
			CROSS APPLY
			 (
				 SELECT TOP 1 bom.InventoryID item, bomd.InventoryID , il4.ShortItemCode, asi2.Height, asi2.Width, asi2.Depth, il4.AcumaticaDesc
				 FROM acumaticaManufacturing.BillOfMaterials bom
					 JOIN dbo.tb_ItemList il3 ON bom.InventoryID = il3.AcumaticaName AND il3.DoorStyleID = il.DoorStyleID AND il3.ItemTypeCode = il.ItemTypeCode
					 JOIN inventory.AcumaticaStockItems asi2 ON asi2.AcumaticaID = il3.AcumaticaID
					 JOIN acumaticaManufacturing.BillOfMaterialDetails bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = 0 AND bom.DeleteFlag = 0 AND bom.Revision <> 'A'
					 JOIN dbo.tb_ItemList il4 ON il4.AcumaticaName = bomd.InventoryID AND il4.ComponentPartTypeId = mr.PartId 
					
				 WHERE
				 (
					(   
					 EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
					 AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
					 AND 
					 (
						 (
							 asi2.Depth >= asi.Depth + abd.AdjustDepth 
							 AND ((asi2.Height >= asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL) OR mr.SpecificHeight = asi2.Height)
							 AND mr.ExactMeasurementsOnly = 0
						 )
						 OR EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
							WHERE gab.Depth = asi.Depth + abd.AdjustDepth AND ((gab.Height = asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL)OR gab.Height = mr.SpecificHeight))
					 )
					 AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (   EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width'  AND mr.AddRemoveType ='Add')
					 AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height'  AND mr.AddRemoveType ='Add')

					 -- hard coded for full hight door add shelf, if it happens more, add column to table "ProductionItemModifcationAddRemoveRules" to indicate
					 AND 
					 (
						 mr.ProductionItemModifcationAddRemoveRuleId <> 45
   						 OR 
						 (
							EXISTS (SELECT * FROM inventory.DoorStyles dsc WHERE il.DoorStyleID = dsc.DoorStyleID
							AND EXISTS (SELECT * FROM inventory.DoorStyles dsr WHERE il3.DoorStyleID=dsr.DoorStyleID 
								AND ((dsr.SeriesName IN ('Allure', 'Classic') AND dsc.SeriesName IN ('Allure', 'Classic')) OR (dsr.SeriesName NOT IN ('Allure', 'Classic') AND dsc.SeriesName NOT IN ('Allure', 'Classic')))))
						)
					 )
				 AND 
				 (
					(asi2.Depth >= asi.Depth + abd.AdjustDepth AND asi2.Width >= asi.Width + abd.AdjustWidth AND mr.ExactMeasurementsOnly = 0 AND mr.BaseMesurementsOnWholeCabinet = 0)
					OR (EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
						WHERE gab.Depth = asi.Depth + abd.AdjustDepth AND gab.Width = asi.Width + abd.AdjustWidth)
						AND mr.BaseMesurementsOnWholeCabinet = 1)
				 )
				 AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (   EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
					 AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
				 AND 
				 (
					(
						asi2.Width >= asi.Width + abd.AdjustWidth 
						AND ((asi2.Height >= asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL) OR mr.SpecificHeight = asi2.Height)
						AND mr.ExactMeasurementsOnly = 0
						AND mr.BaseMesurementsOnWholeCabinet = 0
					)
					OR (EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
						WHERE gab.Width = asi.Width + abd.AdjustWidth
						AND((gab.Height = asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL) OR gab.Height = mr.SpecificHeight))
						AND mr.BaseMesurementsOnWholeCabinet = 1)
				 )
				 AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (
					 EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
					AND 
					(
						(
						asi2.Width >= asi.Width + abd.AdjustWidth 
						AND asi2.Depth >= asi.Depth + abd.AdjustDepth 
						AND ((asi2.Height >= asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL) OR mr.SpecificHeight = asi2.Height)						
						AND mr.ExactMeasurementsOnly = 0
						AND mr.BaseMesurementsOnWholeCabinet = 0
						)  
						OR (EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
							WHERE gab.Width = asi.Width + abd.AdjustWidth
							AND((gab.Height = asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL) OR gab.Height = mr.SpecificHeight)
							AND gab.Depth = asi.Depth + abd.AdjustDepth)
							AND mr.BaseMesurementsOnWholeCabinet = 1
							)
					)
					AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (
						EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
						AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
						AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
						AND 					
						(
							(
								asi2.Width >= asi.Width + abd.AdjustWidth 						
								AND mr.ExactMeasurementsOnly = 0
								AND mr.BaseMesurementsOnWholeCabinet = 0
							)  
								OR (EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
								WHERE gab.Width = asi.Width + abd.AdjustWidth
								AND mr.BaseMesurementsOnWholeCabinet = 1)
							)	
						)
						AND mr.PartToAddFromProduct IS NULL				
				 )
				 OR
				 (
					mr.PartToAddFromProduct IS NOT NULL AND EXISTS (SELECT * FROM  inventory.Products p WHERE p.ProductCode=mr.PartToAddFromProduct AND il3.ProductID = p.ProductID)
				 )
				 )
				 AND --ExcludeWhenProductHasText
				 (
					mr.ExcludeWhenProductHasText IS NULL 
					OR NOT EXISTS
					(
						SELECT * FROM inventory.Products AS p
						WHERE p.ProductID = il.ProductID
						AND EXISTS
						(
							SELECT * FROM dbo.FN_ListToTable(' ', mr.ExcludeWhenProductHasText) AS fltt
							WHERE p.ProductCode LIKE '%' +  fltt.ListValue  + '%' 
						)
						--AND p.ProductCode LIKE '%' + mr.ExcludeWhenProductHasText + '%'
					)				 
				 )
				 AND --MatchOnTag
                 (
					mr.MatchOnTag IS NULL
					OR
                    (
						--original and replacement have tag
						EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE il.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = mr.MatchOnTag AND ptpt.DeleteFlag=0)
						AND EXISTS (SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE il3.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = mr.MatchOnTag AND ptpt.DeleteFlag=0)
					)		
					OR --original and replacement don't have tag
					(
						NOT EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE il.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = mr.MatchOnTag AND ptpt.DeleteFlag=0)
						AND NOT EXISTS (SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE il3.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = mr.MatchOnTag AND ptpt.DeleteFlag=0)							
					)
				 )
				 AND --from same belt
				 (
					 ISNULL(mr.FromSameBelt, 0) = 0 
					 OR EXISTS(SELECT * FROM picking.DestinationLocationItemRule AS dlir 
						JOIN Picking.ProductionItem AS pi ON pi.ItemlistId = dlir.ProductionItemItemlistId
						WHERE EXISTS (SELECT * FROM picking.DestinationLocationItemRule dlir2 
							WHERE dlir2.ProductionItemItemlistId = il3.ID
							AND dlir.DestinationLocationId = dlir2.DestinationLocationId)
						AND pi.OrderItemId = @orderItemId)
				 )
                 AND (mr.OnlyFromTag IS NULL OR EXISTS(SELECT * FROM inventory.ProductToProductTags ptpt WHERE mr.OnlyFromTag = ptpt.ProductTagId AND ptpt.ProductId = il3.ProductID  AND ptpt.DeleteFlag=0 ))
				 AND NOT EXISTS
				 (
					 SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
					 WHERE asitoi.StockAcumaticaID = il4.AcumaticaID
					 AND asitoi.SortComponent >= asitoi.Quantity
					 AND mr.OnlyWhenInStock = 1
				 )
				 AND NOT 
				(
					NOT EXISTS
					(
						SELECT * FROM dbo.ItemLocationsUpdate ilu
						JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
						WHERE il.ExcludeFrmStock = 0
						AND il.LocationType <> 13
						AND ilu.ItemCode = il4.ShortItemCode
					)
					AND mr.OnlyWhenInStock = 1
				)
				 AND 
				(
					mr.ExcludeWhenPartProductCodeHasText IS NULL 
					OR EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
						WHERE '%' + gab.ProductCode + '%' NOT LIKE mr.ExcludeWhenPartProductCodeHasText) 
				)
				AND 
				(
					mr.PartExcludeTag IS NULL 
					OR EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
						WHERE NOT EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
							WHERE ptpt.DeleteFlag = 0 AND ptpt.ProductId = gab.ProductID 
							AND ptpt.ProductTagId = mr.PartExcludeTag))
				)	
				 ORDER BY CASE WHEN EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr2 WHERE cptmr2.ComponentPartTypeId = il4.ComponentPartTypeId AND cptmr2.Dimension = 'Width') THEN asi2.Width ELSE 1000 END, 
						  CASE WHEN EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr2 WHERE cptmr2.ComponentPartTypeId = il4.ComponentPartTypeId AND cptmr2.Dimension = 'Height') THEN asi2.Height ELSE 1000 END,
						  CASE WHEN EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr2 WHERE cptmr2.ComponentPartTypeId = il4.ComponentPartTypeId AND cptmr2.Dimension = 'Depth') THEN asi2.Depth ELSE 1000 END
						  ,asi2.Height,asi2.Width,asi2.Depth
			 ) prtsToAdd
		WHERE te.ID = @orderItemId;

		--IL-3652 redone on --FF-264
		DECLARE @itemReplace TABLE(RuleId INT, AddPartAcumaticaName VARCHAR(50), Quantity INT, RemovePartAcumaticaName VARCHAR(50))

		INSERT @itemReplace(RuleId, AddPartAcumaticaName, Quantity, RemovePartAcumaticaName)
		SELECT pimarr.ProductionItemModifcationAddRemoveRuleId, ReplaceItem.AddAcumaticaName, COALESCE(maprd.QuantityToReplace, mlQty.Quantity, 0), tilRemove.AcumaticaName
		FROM dbo.TranEntry AS te
		JOIN dbo.tb_ItemList AS tilMain ON tilMain.ItemCode = te.ItemNumber
		JOIN dbo.TranEntry AS teMOd ON te.OrderID = teMOd.OrderID
			AND te.EZProdID = teMOd.EZParentProdID
		JOIN dbo.tb_ItemList AS tilMOd ON tilMOd.ItemCode = teMOd.ItemNumber
		JOIN picking.ModificationToAddRemoveRuleDetail AS mtarrd ON mtarrd.ModificationId = tilMOd.ID
		JOIN picking.ModificationToAddRemoveRuleHeader AS mtarrh ON mtarrh.ModificationToAddRemoveRuleHeaderId = mtarrd.ModificationToAddRemoveRuleHeaderId
		JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON pimarr.ProductionItemModifcationAddRemoveRuleId = mtarrh.ProductionItemModifcationAddRemoveRuleId
		JOIN picking.ModificationAcuProductReplacementDetail AS maprd ON maprd.ModificationAcuProductReplacementHeaderId = pimarr.ModificationAcuProductReplacementHeaderId
		JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaProductID = maprd.OriginalAcuProductId
		JOIN dbo.tb_ItemList AS tilRemove ON asi.AcumaticaID = tilRemove.AcumaticaID
		CROSS APPLY
		(
			SELECT TOP 1 tilReplace.AcumaticaName AS AddAcumaticaName, tilReplace.ProductID, tilReplace.AcumaticaID, tilReplace.ShortItemCode AS AddShortItemCode 
			FROM dbo.tb_ItemList AS tilReplace 
			WHERE tilReplace.ProductID = maprd.ReplacementProductId
			AND ISNULL(tilReplace.DoorStyleID, tilMain.DoorStyleID) = tilMain.DoorStyleID		)AS ReplaceItem
		OUTER APPLY
		(
			SELECT ml.Quantity FROM @MaterialList AS ml
			WHERE ml.InventoryID = tilRemove.AcumaticaName
			AND maprd.QuantityToReplace IS NULL
		)mlQty
		
		WHERE --teMOd.isActive = 1
		--AND 
		teMOd.isDeleted = 0
		AND pimarr.AddRemoveType = 'Replace'
		AND EXISTS
		(
			SELECT * FROM @MaterialList AS ml
			WHERE ml.InventoryID = asi.Name
		)
		AND mtarrd.ToCancelOtherInGroup = 0
		AND 
		(
			pimarr.ExcludeTag IS NULL
			OR NOT EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt
				WHERE tilMain.ProductID = ptpt.ProductId
				AND ptpt.DeleteFlag = 0
				AND pimarr.ExcludeTag = ptpt.ProductTagId
			)
		)
		AND 
		(
			pimarr.OnlyFromTag IS NULL 
			OR EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt
				WHERE tilMain.ProductID = ptpt.ProductId
				AND ptpt.DeleteFlag = 0
				AND pimarr.OnlyFromTag = ptpt.ProductTagId
			)
		)
		AND 
		(
			pimarr.PartExcludeTag IS NULL
			OR NOT EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt
				WHERE ReplaceItem.ProductID = ptpt.ProductId
				AND ptpt.DeleteFlag = 0
				AND pimarr.PartExcludeTag = ptpt.ProductTagId
			) 
		)
		AND 
		(
			pimarr.OnlyWhenProductHasText IS NULL
			OR EXISTS 
			(
				SELECT * FROM inventory.Products AS p
				WHERE tilMain.ProductID = p.ProductID
				AND p.ProductCode LIKE '%' + pimarr.OnlyWhenProductHasText + '%'
			)
		)
		AND 
		(
			pimarr.ExcludeWhenPartProductCodeHasText IS NULL
			OR NOT EXISTS
			(
				SELECT * FROM inventory.Products AS p2
				WHERE p2.ProductID = ReplaceItem.ProductID
				AND p2.ProductCode LIKE '%' + pimarr.ExcludeWhenPartProductCodeHasText + '%'
			)
		)
		AND 
		(
			pimarr.ExcludeWhenProductHasText IS NULL
			OR NOT EXISTS
			(
				SELECT * FROM inventory.Products AS p3
				WHERE tilMain.ProductID = p3.ProductID
				AND p3.ProductCode LIKE '%' + pimarr.ExcludeWhenProductHasText + '%'
			)
		)
		AND NOT EXISTS
		(
			SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
			WHERE asitoi.StockAcumaticaID = ReplaceItem.AcumaticaID
			AND asitoi.SortComponent >= asitoi.Quantity
			AND pimarr.OnlyWhenInStock = 1
		)
		AND NOT 
		(
			NOT EXISTS
			(
				SELECT * FROM dbo.ItemLocationsUpdate ilu
				JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
				WHERE il.ExcludeFrmStock = 0
				AND il.LocationType <> 13
				AND ilu.ItemCode = ReplaceItem.AddShortItemCode
			)
			AND pimarr.OnlyWhenInStock = 1
		)
		AND 
		(
			pimarr.ExcludeStyle IS NULL
			OR NOT EXISTS
			(
				SELECT * FROM inventory.DoorStyles AS ds
				WHERE ds.DoorStyleID = tilMain.DoorStyleID
				AND EXISTS
				(
					SELECT * FROM dbo.FN_ListToTable( ' ', pimarr.ExcludeStyle) AS fltt
					WHERE ds.Style LIKE '%' + fltt.ListValue + '%'
				)
			)
		)
		AND
        (
				pimarr.ProductionItemModifcationAddRemoveRuleId <> 229
				OR dbo.OrderItemHasCutDoorsOnAllDoors(@orderItemId) = 1
		)
		AND te.ID = @orderItemId
		
		INSERT INTO @AddremoveRules (RuleId, AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, PartType, FunctionPart) --Remove
		SELECT DISTINCT iar.ProductionItemModifcationAddRemoveRuleId, iar.ActionType, iar.PartItemCode,  iar.QuantityAll, COALESCE(iar.Quantity, qty.Quantity,1),'PICKING' , iar.PartTypeId, iar.FunctionPart
		FROM @itemAddRemove iar	
		OUTER APPLY 
		(
			SELECT TOP (1) ml.Quantity 
			FROM dbo.tb_ItemList il 
			JOIN @MaterialList ml ON ml.InventoryID = il.AcumaticaName 
			WHERE il.ComponentPartTypeId = iar.PartTypeId 
			AND iar.QuantityAll = 1
		) qty
		WHERE NOT EXISTS
		(
			SELECT * FROM @itemAddRemove iar2 
			WHERE iar.PartTypeId = iar2.PartTypeId AND iar2.PartItemCode = iar.PartItemCode 
			AND iar2.Quantity = iar.Quantity 
			AND iar2.ActionType <> iar.ActionType
		) 
		AND NOT EXISTS
		(
			SELECT * FROM picking.ProductionItemModifcationAddRemoveRules mr 
			WHERE mr.ProductionItemModifcationAddRemoveRuleId = iar.ProductionItemModifcationAddRemoveRuleId 
			AND mr.OnlyRemoveWhenAdd = 1  
			AND NOT EXISTS
			(
				SELECT 1 FROM @itemAddRemove iar2 
				WHERE 
				(
					(
						iar.PartTypeId = iar2.PartTypeId 
						AND mr.OnlyRemoveWhenAddPartId IS NULL
					) 
					OR 
					(
						mr.OnlyRemoveWhenAddPartId IS NOT NULL 
						AND iar2.PartTypeId = mr.OnlyRemoveWhenAddPartId
					)
				)
				AND ISNULL(iar2.Quantity, 1) >= ISNULL(iar.Quantity, 0)
				AND iar2.ActionType='Add' 
			) 
		)
		AND iar.ActionType = 'Remove'

		INSERT INTO @AddremoveRules (RuleId, AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart ) --Add
		SELECT DISTINCT iar.ProductionItemModifcationAddRemoveRuleId, iar.ActionType, iar.PartItemCode,  iar.QuantityAll,
		COALESCE(iar.Quantity, remove.Quantity, 1),
		'PICKING' , iar.FunctionPart
		FROM @itemAddRemove iar
		OUTER APPLY
		(
			SELECT ar.Quantity 
			FROM  @AddremoveRules AS ar WHERE ar.PartType = iar.PartTypeId AND ar.AddRemoveAction = 'remove'
		)remove	
		OUTER APPLY 
		(
			SELECT TOP (1) ml.Quantity 
			FROM dbo.tb_ItemList il 
			JOIN @MaterialList ml ON ml.InventoryID = il.AcumaticaName 
			WHERE il.ComponentPartTypeId = iar.PartTypeId 
			AND iar.QuantityAll = 1
		) qty
		WHERE NOT EXISTS
		(
			SELECT * FROM @itemAddRemove iar2 
			WHERE iar.PartTypeId = iar2.PartTypeId 
			AND iar2.PartItemCode = iar.PartItemCode 
			AND iar2.Quantity = iar.Quantity 
			AND iar2.ActionType <> iar.ActionType
		) 
		AND NOT EXISTS 
		(
			SELECT * FROM @itemAddRemove ar 
			WHERE ar.ActionType=iar.ActionType 
			AND ar.PartItemCode = iar.PartItemCode 
			AND ar.ProductionItemModifcationAddRemoveRuleId <> iar.ProductionItemModifcationAddRemoveRuleId 
		)
		--IL-3639
		AND NOT EXISTS
		(
			SELECT * FROM @AddremoveRules AS ar2 
			WHERE ar2.AddRemoveAction = 'Remove'
			AND ar2.InventoryId = iar.PartItemCode
			AND ar2.RuleId <> iar.ProductionItemModifcationAddRemoveRuleId
			AND ar2.Quantity = iar.Quantity
		)
		AND iar.ActionType = 'Add'

		--FF-320
		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart ) --explicit additions (from table AddonBomAdditions)
		SELECT aba.ActionType, tilAddition.AcumaticaName, 
		CASE WHEN aba.Quantity IS NULL 
			AND aba.QuantityFromSubItem = 0
			AND aba.QuantityForOriginalItem = 0
			AND aba.ActionType <> 'Replace'
			AND aba.ConfigKey IS NULL THEN 1 ELSE 0 END AS QuantityAll, 
		COALESCE(SubItemQuantity.QtyRequired, QuantityOfOriginalItem.Quantity, aba.Quantity, 0) + ISNULL(QuantityPerComponent.QuantityPerComponent, 0) + COALESCE(QuantityConfig.QuantityConfigMultiplied, aba.QuantityPerConfigKey,0) AS Quantity, 
		'PICKING', 'Explicit additions (from table AddonBomAdditions)'
		FROM dbo.TranEntry AS te
		JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID AND te.EZProdID = te2.EZParentProdID
		JOIN dbo.tb_ItemList AS tilSub ON tilSub.ItemCode = te2.ItemNumber
		JOIN picking.AddonBomAdditions AS aba ON aba.SubItemId = tilSub.ID
		JOIN dbo.tb_ItemList AS tilAddition ON tilAddition.ID = aba.AdditionalItemId
		OUTER APPLY
		(
			SELECT CAST(bomd.QtyRequired AS INT) AS QtyRequired
			FROM acumaticaManufacturing.BillOfMaterials AS bom
			JOIN dbo.tb_ItemList AS tilSubForParts ON bom.InventoryID = tilSubForParts.AcumaticaName
			JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			WHERE bom.DeleteFlag = 0
			AND bomd.DeleteFlag = 0
			AND bom.Revision IN ('B', 'C', 'D')
			AND tilSubForParts.ItemTypeCode IN (1, 2)
			AND aba.QuantityFromSubItem = 1
			AND bomd.InventoryID = tilAddition.AcumaticaName
			AND EXISTS
			(
				SELECT * FROM dbo.TranEntry AS teSubForParts
				WHERE teSubForParts.isDeleted = 0
				AND teSubForParts.OrderID = te.OrderID 
				AND teSubForParts.EZParentProdID = te.EZProdID
				AND teSubForParts.ItemNumber = tilSubForParts.ItemCode
			)
		)AS SubItemQuantity
		OUTER APPLY
		(
			SELECT TOP (1) CAST(bomd.QtyRequired AS INT) * aba.QuantityPerComponentPartType AS QuantityPerComponent
			FROM acumaticaManufacturing.BillOfMaterials AS bom
			JOIN dbo.tb_ItemList AS tilSubForParts ON bom.InventoryID = tilSubForParts.AcumaticaName
			JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			JOIN dbo.tb_ItemList AS tilBomD ON tilBomD.AcumaticaName = bomd.InventoryID
			WHERE bom.DeleteFlag = 0
			AND bomd.DeleteFlag = 0
			--AND bom.Revision IN ('B', 'C', 'D')
			--AND aba.ComponentPartTypeId IS NOT NULL
			AND tilBomD.ComponentPartTypeId = aba.ComponentPartTypeId
			AND bom.InventoryID = tilSubForParts.AcumaticaName
			AND tilSubForParts.ItemTypeCode IN (1, 2)
			AND EXISTS
			(
				SELECT * FROM dbo.TranEntry AS teSubForParts
				WHERE teSubForParts.isDeleted = 0
				AND teSubForParts.OrderID = te.OrderID 
				AND teSubForParts.EZParentProdID = te.EZProdID
				AND teSubForParts.ItemNumber = tilSubForParts.ItemCode
			)
		)AS QuantityPerComponent
		OUTER APPLY
		(
			SELECT ml.Quantity FROM @MaterialList AS ml
			WHERE ml.InventoryID = tilAddition.AcumaticaName
			AND aba.QuantityForOriginalItem = 1
		)AS QuantityOfOriginalItem
		OUTER APPLY
		(
			SELECT ISNULL(NULLIF(COUNT(*), 0), 1) * aba.QuantityPerConfigKey AS  QuantityConfigMultiplied
			FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
			WHERE goict.ConfigKey = aba.ConfigKey
			AND aba.ConfigKey IS NOT NULL
		)AS QuantityConfig
		WHERE te.ID = @OrderItemId
		AND te2.isDeleted = 0
		AND aba.SubItemId IS NOT NULL
		AND 
		(
			COALESCE(SubItemQuantity.QtyRequired, QuantityOfOriginalItem.Quantity, aba.Quantity, QuantityPerComponent.QuantityPerComponent, QuantityConfig.QuantityConfigMultiplied) > 0
			OR 
			(
				aba.Quantity IS NULL 
				AND aba.QuantityFromSubItem = 0
				AND aba.QuantityForOriginalItem = 0
				AND aba.ActionType <> 'Replace'
				AND ISNULL(QuantityConfig.QuantityConfigMultiplied, 0) = 0
			)
		)

		DECLARE @ReplaceSlides TABLE(ToRemove VARCHAR(50), ToAdd VARCHAR(450), NeedsRemove BIT, QuantityToAdd INT, QuantityAll BIT)

		INSERT @ReplaceSlides (ToRemove, ToAdd, NeedsRemove, QuantityToAdd, QuantityAll)
		
		SELECT DISTINCT ToRemove.AcumaticaName AS ToRemove, ToAdd.AcumaticaName AS ToAdd, ToRemove.NeedsRemove, 
		CASE WHEN ISNULL(ToAdd.OrderItemId, te.ID) = te.ID THEN ToRemove.QuantityToAdd  ELSE ToAdd.ModConfigQuantity END,
		CASE WHEN ISNULL(ToAdd.OrderItemId, te.ID) = te.ID THEN 1 ELSE 0 END
		FROM dbo.TranEntry AS te
		JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID
			AND te2.EZParentProdID = te.EZProdID
		JOIN dbo.tb_ItemList AS til ON til.ItemCode = te2.ItemNumber
		JOIN picking.AddonBomAdditions AS aba ON aba.SubItemId = til.ID
		CROSS APPLY
		(
			SELECT ptpt.ProductTagId, til.AcumaticaName, CAST(replace.NeedsRemove AS BIT) AS NeedsRemove, replace.QuantityToAdd
			FROM dbo.tb_ItemList AS til 
			JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = til.AcumaticaID
			JOIN inventory.ProductToProductTags AS ptpt ON ptpt.ProductId = til.ProductID
			CROSS APPLY
			(
				SELECT 1 AS NeedsRemove, ml2.Quantity AS QuantityToAdd
				FROM @MaterialList AS ml2
				WHERE ml2.InventoryID = til.AcumaticaName
				UNION ALL
				SELECT 0, 0 
				FROM @AddremoveRules AS arr
				WHERE arr.InventoryId = til.AcumaticaName
			)AS replace
			WHERE aba.TagIdToReduceBy3Inches = ptpt.ProductTagId
			AND ptpt.DeleteFlag = 0
		)AS ToRemove
		CROSS APPLY
		(
			SELECT TOP (1) tilR.AcumaticaName, cz.OrderItemId, cz.ModConfigQuantity
			FROM dbo.tb_ItemList AS tilR
			JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = tilR.AcumaticaID
			JOIN inventory.ProductToProductTags AS ptpt2 ON ptpt2.ProductId = tilR.ProductID
			OUTER APPLY
			(
				SELECT asiMain.Depth + tabd.AdjustDepth  AS CabinetDepth
				FROM inventory.AcumaticaStockItems AS asiMain
				JOIN dbo.tb_ItemList AS tilMain ON te.ItemNumber = tilMain.ItemCode
				AND tilMain.AcumaticaID = asiMain.AcumaticaID
				JOIN dbo.tb_AdjustedBoxDimensions AS tabd ON tabd.TranEntryID = @orderItemId
			)AS cd
			OUTER APPLY
			(
				SELECT CAST(goict.ConfigValue AS NUMERIC) AS CofiguredSize, goict.OrderItemId, COUNT(*) AS ModConfigQuantity
				FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
				WHERE aba.ConfigKeyForResize = goict.ConfigKey
				AND ISNUMERIC(goict.ConfigValue) = 1
				GROUP BY CAST(goict.ConfigValue AS NUMERIC), goict.OrderItemId
			)AS cz
			WHERE ptpt2.DeleteFlag = 0
			AND ptpt2.ProductTagId = ToRemove.ProductTagId
			AND
			( 
				(
					(
						cd.CabinetDepth - asi.Depth >= 3
						OR 
						(
							NOT EXISTS 
							(
								SELECT * FROM dbo.tb_ItemList AS tilOtherOption
								JOIN inventory.AcumaticaStockItems AS asiOtherOption ON asiOtherOption.AcumaticaID = tilOtherOption.AcumaticaID
								WHERE EXISTS
								(
									SELECT * FROM inventory.ProductToProductTags AS ptpt3
									WHERE ptpt3.DeleteFlag = 0
									AND ptpt3.ProductId = tilOtherOption.ProductID
									AND ptpt3.ProductTagId = TagIdToReduceBy3Inches
								)
								AND cd.CabinetDepth - asiOtherOption.Depth >= 3 
							)
							AND cd.CabinetDepth > asi.Depth
							AND aba.TagIdToReduceBy3Inches = 87
						)
					)
					AND cz.CofiguredSize IS NULL
				)
				OR cz.CofiguredSize = asi.Depth
			)
			ORDER BY asi.Depth DESC
		)AS ToAdd
		WHERE te.ID = @orderItemId
		

		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, Quantity, QuantityAll, WorkCenter, FunctionPart )
		SELECT 'Remove', ReplaceSlides.ToRemove, ReplaceSlides.QuantityToAdd, ReplaceSlides.QuantityAll, 'PICKING', 'ReplaceSlides'
		FROM @ReplaceSlides AS ReplaceSlides
		WHERE EXISTS
		(SELECT * FROM @MaterialList AS ml WHERE ml.InventoryID = ReplaceSlides.ToRemove)
		AND ReplaceSlides.NeedsRemove = 1
		AND ReplaceSlides.QuantityAll = 1
		UNION ALL
		SELECT 'Add', ReplaceSlides.ToAdd, ReplaceSlides.QuantityToAdd, ReplaceSlides.QuantityAll, 'PICKING', 'ReplaceSlides'
		FROM @ReplaceSlides AS ReplaceSlides
		WHERE EXISTS
		(SELECT * FROM @MaterialList AS ml WHERE ml.InventoryID = ReplaceSlides.ToRemove)
		AND ReplaceSlides.NeedsRemove = 1
		AND ReplaceSlides.QuantityAll = 1

		UPDATE ar SET ar.InventoryId = rs.ToAdd, ar.FunctionPart = ar.FunctionPart + ' Updated From ReplaceSlides'
		FROM @AddremoveRules AS ar
		JOIN @ReplaceSlides AS rs ON rs.ToRemove = ar.InventoryId
		WHERE ar.AddRemoveAction = 'Add'
		AND rs.NeedsRemove = 0
		AND rs.ToAdd <> ar.InventoryId

		--FF-336
		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart )--parts from bom of components
		SELECT ar.AddRemoveAction, 
		CASE WHEN tilTE.ProductID IN(497,498,499) AND ar.InventoryId = 'METAL COIN ADJUSTER' THEN 'METAL STRAIGHT ADJUSTER' ELSE BOM.InventoryID END, 
		0, BOM.Quantity, 'PICKING', 'Parts from bom of components'
		FROM @AddremoveRules AS ar
		JOIN dbo.tb_ItemList AS til ON til.AcumaticaName = ar.InventoryId
		JOIN dbo.TranEntry AS te ON te.ID = @orderItemId
		JOIN dbo.tb_ItemList AS tilTe ON tilTe.ItemCode = te.ItemNumber
		CROSS APPLY
		(
			SELECT bomd.InventoryID, CAST(bomd.QtyRequired AS INT) * ar.Quantity AS Quantity FROM  acumaticaManufacturing.BillOfMaterials AS bom 
			JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			JOIN dbo.tb_ItemList AS tild ON tild.AcumaticaName = bomd.InventoryID
			WHERE bom.InventoryID = ar.InventoryId
			AND bom.DeleteFlag = 0
			AND bomd.DeleteFlag = 0
			AND 
			(
				(
					bom.Revision = 'HARDWARE' 
					AND tilTe.DoorStyleID <> 26
				)
				OR 
				(
					bom.Revision = 'HF HARDWAR' 
					AND tilTe.DoorStyleID = 26
				)
			)
			--AND tild.ComponentPartTypeId IN (25)
		)AS BOM
		WHERE til.ComponentPartTypeId IN(7, 9, 17, 29);

		--FF-341
		IF EXISTS
		(
			SELECT * FROM dbo.TranEntry AS te
			JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
			WHERE til.ProductID IN(497,498,499,606,607,608,610,611,612,613,614,615,616,617,618,660,661,749,777,778,779)
			AND te.ID = @orderItemId
		)
		BEGIN
		    INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart )
			VALUES('Remove', 'PLASTIC SHELF HOLDER', 0, 1, 'PICKING', 'PLASTIC SHELF HOLDER for ship shelf loose')
		END

		--FF-264
		INSERT @AddremoveRules(RuleId, AddRemoveAction, InventoryId, Quantity, QuantityAll, WorkCenter, FunctionPart)--replacements
		SELECT ir.RuleId, 'Remove',  ir.RemovePartAcumaticaName, ir.Quantity, 0, 'PICKING' , 'Replacements'
		FROM @itemReplace AS ir
		UNION ALL
		SELECT ir.RuleId, 'Add', ir.AddPartAcumaticaName, ir.Quantity, 0, 'PICKING', 'Replacements'
		FROM @itemReplace AS ir


		IF EXISTS(SELECT * FROM dbo.TranEntry AS te WHERE te.ID = @orderItemId AND te.BoxOnly = 1)
		BEGIN
			DELETE @AddremoveRules  WHERE InventoryId IN
			(
				SELECT ml.InventoryID 
				FROM @MaterialList ml
				JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
				OUTER APPLY
				(
					SELECT CAST( CASE WHEN EXISTS
					(
						SELECT * FROM dbo.TranEntry TE 
						JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
						WHERE TE.ID = @orderItemId 
						AND TIL.ProductID IN(413, 412)
					)THEN 1 ELSE 0 END AS BIT) AS IsLsb
				)AS IsLsb
				WHERE til.ComponentPartTypeId IN(11, 7, 17) 
				OR 
				(
					til.ComponentPartTypeId IN (9) 
					AND IsLsb.IsLsb = 0
				)
				OR
				(
					til.ComponentPartTypeId IN (23, 25)
					AND 
					(
						IsLsb.IsLsb = 0
						OR ml.InventoryID NOT IN('CSC','PLASTIC SHELF HOLDER','VSC')
						--OR NOT EXISTS
						--(
						--	SELECT * FROM acumaticaManufacturing.BillOfMaterials AS bom
						--	JOIN dbo.tb_ItemList AS tilShelf ON tilShelf.AcumaticaName = bom.InventoryID
						--	JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
						--	WHERE bom.DeleteFlag = 0
						--	AND bomd.DeleteFlag = 0
						--	AND tilShelf.ComponentPartTypeId = 9
						--	AND bomd.InventoryID = ml.InventoryID
						--)
					)
					
				)
			)

			INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity)
			SELECT 'Remove', ml.InventoryID, 1, ml.Quantity 
			FROM @MaterialList ml
			JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
			OUTER APPLY
			(
				SELECT CAST( CASE WHEN EXISTS
				(
					SELECT * FROM dbo.TranEntry TE 
					JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
					WHERE TE.ID = @orderItemId 
					AND TIL.ProductID IN(413, 412)
				)THEN 1 ELSE 0 END AS BIT) AS IsLsb
			)AS IsLsb
			WHERE til.ComponentPartTypeId IN( 11, 7, 17) 
			OR 
			(
				til.ComponentPartTypeId IN (9) 
				AND IsLsb.IsLsb = 0
			)	
			OR
			(
				til.ComponentPartTypeId IN (23, 25)
				AND 
				(
					IsLsb.IsLsb = 0
					OR ml.InventoryID NOT IN('CSC','PLASTIC SHELF HOLDER','VSC')
					
					--NOT EXISTS
					--(
					--	SELECT * FROM acumaticaManufacturing.BillOfMaterials AS bom
					--	JOIN dbo.tb_ItemList AS tilShelf ON tilShelf.AcumaticaName = bom.InventoryID
					--	JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
					--	WHERE bom.DeleteFlag = 0
					--	AND bomd.DeleteFlag = 0
					--	AND tilShelf.ComponentPartTypeId = 9
					--	AND bomd.InventoryID = ml.InventoryID
					--)
				)
					
			)
				
			
		END
	RETURN
END

GO
/****** Object:  UserDefinedFunction [picking].[GetCustomFinishRulesForOrderItemIdOld]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 8/23/2019
-- Description:	Get Custom Finish Rules For OrderItemId
-- =============================================
CREATE FUNCTION [picking].[GetCustomFinishRulesForOrderItemIdOld]
(
	@orderItemId INT,
	@MaterialList OrderMaterialDetail READONLY,
	@bomRevision VARCHAR(1) = 'C'
)
RETURNS @AddremoveRules TABLE 
(
	AddRemoveAction VARCHAR(10),
	InventoryId VARCHAR(50),
	Quantity INT DEFAULT(1),
	QuantityAll BIT DEFAULT(0),
	WorkCenter VARCHAR(50) DEFAULT ('PICKING'),
	OperationDescription VARCHAR(400),
	OperationNumber VARCHAR(10),
	BackflushLabor BIT DEFAULT(1)
)
AS
BEGIN

	IF @bomRevision = 'A'
		RETURN

	DECLARE @ComponentPartTypeMatchRules TABLE(ComponentPartTypeId INT,Dimension VARCHAR(50) );
	
	INSERT @ComponentPartTypeMatchRules(ComponentPartTypeId, Dimension) 
		SELECT 1, 'Height' UNION SELECT 1, 'Width' UNION 
		SELECT 2, 'Width' UNION SELECT 2, 'Depth' UNION 
		SELECT 3, 'Depth' UNION SELECT 3, 'Height' UNION 
		SELECT 4, 'Depth' UNION SELECT 4, 'Height' UNION 
		SELECT 5, 'Width' UNION SELECT 5, 'Depth' UNION 
		SELECT 8, 'Height' UNION SELECT 8, 'Width' UNION 
		SELECT 9, 'Width' UNION SELECT 9, 'Depth' UNION 
		SELECT 12, 'Depth' UNION SELECT 12, 'Height' UNION 
		SELECT 10, 'Width' UNION
		SELECT 6, 'Width' UNION SELECT 6, 'Height' UNION SELECT 6, 'Depth'; 

		DECLARE @itemAddRemove TABLE (ModifcationId INT, ActionType VARCHAR(10), PartTypeId INT, PartType VARCHAR(50), PartItemCode VARCHAR(50), QuantityAll BIT DEFAULT(1), Quantity INT NULL)

		INSERT INTO @itemAddRemove (ModifcationId, ActionType, PartTypeId, PartItemCode)

		SELECT mr.ModifcationId, 'Remove' ,mr.PartId , il3.ShortItemCode 
		FROM dbo.TranEntry te
			JOIN dbo.TranEntry te2 ON te2.OrderID = te.OrderID AND te2.EZParentProdID = te.EZProdID AND te2.isActive = te.isActive AND te.isActive = 1
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te2.ItemNumber
			JOIN @MaterialList ml ON 1=1
			JOIN dbo.tb_ItemList il3 ON il3.AcumaticaName = ml.InventoryID 
			JOIN picking.ProductionItemModifcationAddRemoveRules mr ON mr.ModifcationId = il2.ID AND il3.ComponentPartTypeId = mr.PartId AND mr.AddRemoveType ='Remove'
			JOIN inventory.ComponentPartType cpt ON cpt.ComponentPartTypeId = il3.ComponentPartTypeId
			JOIN dbo.tb_AdjustedBoxDimensions abd ON abd.TranEntryID = te.ID
			JOIN inventory.AcumaticaStockItems asi ON asi.AcumaticaID = il.AcumaticaID
		WHERE te.ID = @orderItemId
		AND ( mr.ExcludeTag IS NULL OR NOT EXISTS (SELECT * FROM inventory.ProductToProductTags ptpt WHERE mr.ExcludeTag = ptpt.ProductTagId AND ptpt.ProductId=il.ProductID ))
		AND ( mr.HasCustomizing IS NULL OR mr.HasCustomizing=te.HasCustomizing  )

		INSERT INTO @itemAddRemove (ModifcationId, ActionType, PartTypeId, PartItemCode)
			SELECT pimarr.ModifcationId,pimarr.AddRemoveType , pimarr.PartId, parts.InventoryID FROM dbo.TranEntry AS te 
			JOIN dbo.tb_ItemList AS tilmain ON tilmain.ItemCode = te.ItemNumber 
			JOIN dbo.TranEntry AS te2 ON te2.OrderID=te.OrderID AND te.EZProdID = te2.EZParentProdID AND te2.isActive = 1 AND te2.isDeleted = 0 AND te2.ItemType = 4
			JOIN dbo.tb_ItemList AS til ON til.ItemCode = te2.ItemNumber AND te2.isActive =1 AND te2.isDeleted = 0
			JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON til.ID = pimarr.ModifcationId 
			JOIN dbo.TranEntry AS te3 ON te3.OrderID=te.OrderID AND te.EZProdID = te3.EZParentProdID  AND te3.isDeleted = 0 AND te3.ItemType = pimarr.SubItemType			
			JOIN dbo.tb_ItemList AS tilsub  ON tilsub.ItemCode = te3.ItemNumber
			CROSS APPLY ( SELECT bomd.InventoryID FROM acumaticaManufacturing.BillOfMaterials AS bom 
				JOIN acumaticaManufacturing.BillOfMaterialOperations AS bomo ON bomo.BOMID = bom.BOMID AND bomo.DeleteFlag = 0
				JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = 0 AND bomd.OperationDbId=bomd.OperationDbId
				JOIN acumaticaManufacturing.BOMRevisions AS br ON br.AcumaticaName = bom.InventoryID AND bom.BOMID = COALESCE(br.BOMIDC, br.BOMIDB, br.BOMIDD, br.BOMIDE)
				JOIN dbo.tb_ItemList AS til2 ON til2.AcumaticaName = bomd.InventoryID
				WHERE bom.DeleteFlag = 0  AND bomo.WorkCenter = 'PICKING' AND til2.ComponentPartTypeId = pimarr.PartId
				AND bom.InventoryID = tilsub.AcumaticaName		  
			 ) parts
			WHERE te.ID = @orderItemId AND pimarr.AddRemoveType ='Add' AND pimarr.FromSubItem = 1


		INSERT INTO @itemAddRemove (ModifcationId, ActionType, PartTypeId, PartItemCode, Quantity)
		SELECT mr.ModifcationId,'Add', cpt.ComponentPartTypeId, prtsToAdd.ShortItemCode, mr.Quantity
		FROM dbo.TranEntry te
			JOIN dbo.TranEntry te2 ON te2.OrderID = te.OrderID AND te2.EZParentProdID = te.EZProdID AND te2.isActive = te.isActive AND te.isActive = 1
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te2.ItemNumber 
			JOIN dbo.tb_AdjustedBoxDimensions abd ON abd.TranEntryID = te.ID
			JOIN inventory.AcumaticaStockItems asi ON asi.AcumaticaID = il.AcumaticaID
			JOIN picking.ProductionItemModifcationAddRemoveRules  mr ON mr.ModifcationId = il2.ID AND mr.AddRemoveType='Add' AND mr.FromSubItem = 0
			JOIN inventory.ComponentPartType cpt ON cpt.ComponentPartTypeId = mr.PartId
			CROSS APPLY
			 (
				 SELECT TOP 1 bom.InventoryID item, bomd.InventoryID , il4.ShortItemCode, asi2.Height, asi2.Width, asi2.Depth, il4.AcumaticaDesc
				 FROM acumaticaManufacturing.BillOfMaterials bom
					 JOIN dbo.tb_ItemList il3 ON bom.InventoryID = il3.AcumaticaName AND il3.DoorStyleID = il.DoorStyleID AND il3.ItemTypeCode = il.ItemTypeCode
					 JOIN inventory.AcumaticaStockItems asi2 ON asi2.AcumaticaID = il3.AcumaticaID
					 JOIN acumaticaManufacturing.BillOfMaterialDetails bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = 0 AND bom.DeleteFlag = 0 AND bom.Revision = 'C'
					 JOIN dbo.tb_ItemList il4 ON il4.AcumaticaName = bomd.InventoryID AND il4.ComponentPartTypeId = mr.PartId 
					
				 WHERE
				 (
				 (   EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
					 AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
					 AND asi2.Depth >= asi.Depth + abd.AdjustDepth AND asi2.Height >= asi.Height + abd.AdjustHeight AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (   EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width'  AND mr.AddRemoveType ='Add')
					 AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height'  AND mr.AddRemoveType ='Add')

					 -- hard coded for full hight door add shelf, if it happens more, add column to table "ProductionItemModifcationAddRemoveRules" to indicate
					 AND 
					 (
						 mr.ProductionItemModifcationAddRemoveRuleId <> 45
   						 OR 
						 (
							EXISTS (SELECT * FROM inventory.DoorStyles dsc WHERE il.DoorStyleID=dsc.DoorStyleID
							AND EXISTS (SELECT * FROM inventory.DoorStyles dsr WHERE il3.DoorStyleID=dsr.DoorStyleID 
								AND ((dsr.SeriesName IN ('Allure', 'Classic') AND dsc.SeriesName IN ('Allure', 'Classic')) OR (dsr.SeriesName NOT IN ('Allure', 'Classic') AND dsc.SeriesName NOT IN ('Allure', 'Classic')))))
						)
					 )
				 AND asi2.Depth >= asi.Depth + abd.AdjustDepth AND asi2.Width >= asi.Width + abd.AdjustWidth AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (   EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
					 AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
				 AND asi2.Width >= asi.Width + abd.AdjustWidth AND asi2.Height >= asi.Height + abd.AdjustHeight  AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (
					 EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
					AND asi2.Width >= asi.Width + abd.AdjustWidth AND asi2.Depth >= asi.Depth + abd.AdjustDepth 
					AND asi2.Height >= asi.Height + abd.AdjustHeight  AND mr.PartToAddFromProduct IS NULL
				 --hard coded for match interior
					AND  
					(
						mr.ProductionItemModifcationAddRemoveRuleId <> 219
						OR 
						(
							(--original and replacement are corner
								EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
								WHERE il.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = 16)
								AND EXISTS (SELECT * FROM inventory.ProductToProductTags AS ptpt 
								WHERE il3.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = 16)
							)
							OR 
							(--original and replacement are not corner
								NOT EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
								WHERE il.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = 16)
								AND NOT EXISTS (SELECT * FROM inventory.ProductToProductTags AS ptpt 
								WHERE il3.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = 16)
							)
						)
					) 
				 )
				 OR
				 (
					mr.PartToAddFromProduct IS NOT NULL AND EXISTS (SELECT * FROM  inventory.Products p WHERE p.ProductCode=mr.PartToAddFromProduct AND il3.ProductID = p.ProductID)
				 )
				 )
				 AND NOT EXISTS (SELECT 1 FROM inventory.ProductToProductTags pt WHERE pt.ProductTagId=16 AND pt.ProductId=il3.ProductID)
				 AND --from same belt
				 (
					 ISNULL(mr.FromSameBelt, 0) = 0 
					 OR EXISTS(SELECT * FROM picking.DestinationLocationItemRule AS dlir 
						JOIN Picking.ProductionItem AS pi ON pi.ItemlistId = dlir.ProductionItemItemlistId
						WHERE EXISTS (SELECT * FROM picking.DestinationLocationItemRule dlir2 
							WHERE dlir2.ProductionItemItemlistId = il3.ID
							AND dlir.DestinationLocationId = dlir2.DestinationLocationId)
						AND pi.OrderItemId = @orderItemId)
				 )
                 AND (mr.OnlyFromTag IS NULL OR EXISTS(SELECT * FROM inventory.ProductToProductTags ptpt WHERE mr.OnlyFromTag = ptpt.ProductTagId AND ptpt.ProductId = il3.ProductID ))
				 ORDER BY CASE WHEN EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr2 WHERE cptmr2.ComponentPartTypeId = il4.ComponentPartTypeId AND cptmr2.Dimension = 'Width') THEN asi2.Width ELSE 1000 END, 
						  CASE WHEN EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr2 WHERE cptmr2.ComponentPartTypeId = il4.ComponentPartTypeId AND cptmr2.Dimension = 'Height') THEN asi2.Height ELSE 1000 END,
						  CASE WHEN EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr2 WHERE cptmr2.ComponentPartTypeId = il4.ComponentPartTypeId AND cptmr2.Dimension = 'Depth') THEN asi2.Depth ELSE 1000 END
						  ,asi2.Height,asi2.Width,asi2.Depth
			 ) prtsToAdd
		WHERE te.ID = @orderItemId;

		INSERT INTO @AddremoveRules ( AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter )
		SELECT iar.ActionType, iar.PartItemCode,  iar.QuantityAll, COALESCE(iar.Quantity, qty.Quantity,1),'PICKING' FROM @itemAddRemove iar	
			OUTER APPLY (
				SELECT TOP (1) ml.Quantity FROM dbo.tb_ItemList il JOIN @MaterialList ml ON ml.InventoryID = il.AcumaticaName WHERE il.ComponentPartTypeId = iar.PartTypeId AND iar.QuantityAll = 1
			) qty
		WHERE NOT EXISTS(SELECT * FROM @itemAddRemove iar2 
			WHERE iar.PartTypeId = iar2.PartTypeId AND iar2.PartItemCode = iar.PartItemCode AND iar2.Quantity = iar.Quantity AND iar2.ActionType <> iar.ActionType) 
		AND 
		NOT EXISTS(SELECT * FROM picking.ProductionItemModifcationAddRemoveRules mr WHERE mr.ModifcationId = iar.ModifcationId AND iar.PartTypeId=mr.PartId AND mr.OnlyRemoveWhenAdd=1 AND iar.ActionType ='Remove'  
			AND NOT EXISTS( SELECT 1 FROM @itemAddRemove iar2 
				WHERE (
				(iar.PartTypeId=iar2.PartTypeId AND mr.OnlyRemoveWhenAddPartId IS NULL) 
				OR 
				(mr.OnlyRemoveWhenAddPartId IS NOT NULL AND iar2.PartTypeId = mr.OnlyRemoveWhenAddPartId)
				)
				AND iar2.ActionType='Add' ) )
		AND 
		NOT EXISTS (SELECT * FROM @itemAddRemove ar WHERE ar.ActionType=iar.ActionType AND ar.PartItemCode = iar.PartItemCode AND ar.ModifcationId<>iar.ModifcationId )
		AND iar.ActionType = 'Remove'

		INSERT INTO @AddremoveRules ( AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter )
		SELECT iar.ActionType, iar.PartItemCode,  iar.QuantityAll,
		CASE WHEN ISNULL(iar.Quantity, 0) + ISNULL(qty.Quantity, 0) - ISNULL(remove.Quantity, 0) > 0 
		THEN ISNULL(iar.Quantity, 0) + ISNULL(qty.Quantity, 0) - ISNULL(remove.Quantity, 0) ELSE 1 END, 'PICKING' 
		FROM @itemAddRemove iar
		OUTER APPLY(
			SELECT ar.Quantity 
			FROM  @AddremoveRules AS ar WHERE ar.InventoryId = iar.PartItemCode AND ar.AddRemoveAction = 'remove')remove	
		OUTER APPLY (
			SELECT TOP (1) ml.Quantity FROM dbo.tb_ItemList il JOIN @MaterialList ml ON ml.InventoryID = il.AcumaticaName WHERE il.ComponentPartTypeId = iar.PartTypeId AND iar.QuantityAll = 1
		) qty
		WHERE NOT EXISTS(SELECT * FROM @itemAddRemove iar2 
			WHERE iar.PartTypeId = iar2.PartTypeId AND iar2.PartItemCode = iar.PartItemCode AND iar2.Quantity = iar.Quantity AND iar2.ActionType <> iar.ActionType) 
		AND 
		NOT EXISTS (SELECT * FROM @itemAddRemove ar WHERE ar.ActionType=iar.ActionType AND ar.PartItemCode = iar.PartItemCode AND ar.ModifcationId<>iar.ModifcationId )
		AND iar.ActionType = 'Add'

		IF EXISTS(SELECT * FROM dbo.TranEntry AS te WHERE te.ID = @orderItemId AND te.BoxOnly = 1)
		BEGIN
		DELETE @AddremoveRules  WHERE InventoryId IN(SELECT ml.InventoryID FROM @MaterialList ml
			JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
			WHERE til.ComponentPartTypeId IN(9, 11, 7, 17))
		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity)
			SELECT 'Remove', ml.InventoryID, 1, ml.Quantity FROM @MaterialList ml
			JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
			WHERE til.ComponentPartTypeId IN(9, 11, 7, 17)
		END
	
		IF EXISTS(SELECT * FROM dbo.TranEntry AS te 
			JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID AND te.EZProdID = te2.EZParentProdID
			JOIN dbo.tb_ItemList AS til ON til.ItemCode = te2.ItemNumber
			WHERE te.ID = @orderItemId AND til.ID = 153925
		)
		BEGIN
		    DELETE @AddremoveRules 
			WHERE EXISTS(SELECT * FROM dbo.tb_ItemList AS til WHERE InventoryId = til.AcumaticaName
				AND AddRemoveAction = 'Add' AND til.ComponentPartTypeId = 11)
		END

		IF EXISTS(SELECT * FROM dbo.TranEntry AS te WHERE te.ID = @orderItemId AND te.BoxOnly = 1)
		BEGIN
			INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity)
			SELECT 'Remove', ml.InventoryID, 1, ml.Quantity FROM @MaterialList ml
			JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
			WHERE til.ComponentPartTypeId IN(7, 17)  
			AND NOT EXISTS(SELECT * FROM @AddremoveRules AS ar WHERE ar.AddRemoveAction = 'Remove' AND ar.InventoryId = ml.InventoryID AND ar.QuantityAll = 1 AND ar.Quantity = ml.Quantity)  
		END

		RETURN
END


GO
/****** Object:  UserDefinedFunction [picking].[GetCustomFinishRulesForOrderItemIdStaging]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 8/23/2019
-- Description:	Get Custom Finish Rules For OrderItemId
-- =============================================
CREATE FUNCTION [picking].[GetCustomFinishRulesForOrderItemIdStaging]
(
	@orderItemId INT,
	@MaterialList OrderMaterialDetail READONLY,
	@bomRevision VARCHAR(1) = 'C'
)
RETURNS @AddremoveRules TABLE 
(
	RuleId INT NULL,
	AddRemoveAction VARCHAR(10),
	InventoryId VARCHAR(50),
	Quantity INT DEFAULT(1),
	QuantityAll BIT DEFAULT(0),
	WorkCenter VARCHAR(50) DEFAULT ('PICKING'),
	OperationDescription VARCHAR(400),
	OperationNumber VARCHAR(10),
	BackflushLabor BIT DEFAULT(1),
	PartType INT,
	FunctionPart VARCHAR(150)
)
AS 
BEGIN

	IF @bomRevision IN( 'A', 'FG')
		RETURN

	DECLARE @ComponentPartTypeMatchRules TABLE(ComponentPartTypeId INT,Dimension VARCHAR(50) );

	INSERT @ComponentPartTypeMatchRules(ComponentPartTypeId, Dimension) 
		SELECT 1, 'Height' UNION SELECT 1, 'Width' UNION 
		SELECT 2, 'Width' UNION SELECT 2, 'Depth' UNION 
		SELECT 3, 'Depth' UNION SELECT 3, 'Height' UNION 
		SELECT 4, 'Depth' UNION SELECT 4, 'Height' UNION 
		SELECT 5, 'Width' UNION SELECT 5, 'Depth' UNION 
		SELECT 8, 'Height' UNION SELECT 8, 'Width' UNION 
		SELECT 9, 'Width' UNION SELECT 9, 'Depth' UNION 
		SELECT 12, 'Depth' UNION SELECT 12, 'Height' UNION 
		SELECT 10, 'Width' UNION
		SELECT 6, 'Width' UNION SELECT 6, 'Height' UNION SELECT 6, 'Depth'; 

		DECLARE @ModConfigRules TABLE(Config VARCHAR(50) NOT NULL, ComponentPartId INT NOT NULL, ProductId INT NULL)
		INSERT @ModConfigRules(Config, ComponentPartId, ProductId)
		VALUES
		('LEFT DRAWER', 7, NULL),('LOWER DRAWER', 17, NULL),('LOWER DRAWER LEFT', 17, NULL),('LOWER DRAWER RIGHT', 17, NULL),('MIDDLE DRAWER', 17, NULL),('MIDDLE DRAWER LEFT', 17, NULL),
		('MIDDLE DRAWER RIGHT', 17, NULL),('MIDDLE LOWER', 7, NULL),('MIDDLE UPPER', 7, NULL),('RIGHT DRAWER', 7, NULL),('UPPER DRAWER', 7, NULL),('LOWER DRAWER', 7, 777 ),('LOWER DRAWER', 7, 778 ),
		('LOWER DRAWER', 7, 779 ),('UPPER DRAWER', 17, 153 ),('UPPER DRAWER', 17, 156 ),('UPPER DRAWER', 17, 158 ),('MIDDLE DRAWER', 7, 494 ),('MIDDLE DRAWER', 7, 495 ),('MIDDLE DRAWER', 7, 496)
		
		DECLARE @itemAddRemove TABLE (ProductionItemModifcationAddRemoveRuleId INT NULL, ModifcationId INT, ActionType VARCHAR(10), PartTypeId INT, PartType VARCHAR(50), PartItemCode VARCHAR(50), 
		QuantityAll BIT DEFAULT(1), Quantity INT NULL, FunctionPart VARCHAR(50))

		INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, QuantityAll, FunctionPart)

		SELECT mr.ProductionItemModifcationAddRemoveRuleId,  'Remove' ,mr.PartId , il3.ShortItemCode, mr.Quantity, CASE WHEN mr.Quantity IS NOT NULL THEN 0 ELSE 1 END, 'Remove'
		FROM dbo.TranEntry te
			JOIN dbo.TranEntry te2 ON te2.OrderID = te.OrderID 
				AND te2.EZParentProdID = te.EZProdID 
				--AND te2.isActive = te.isActive
				AND te2.isDeleted = 0
				AND te.isDeleted = 0 
				AND te.isActive = 1
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber 
			JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te2.ItemNumber
			JOIN @MaterialList ml ON 1=1
			JOIN dbo.tb_ItemList il3 ON il3.AcumaticaName = ml.InventoryID 
			CROSS APPLY
			(
				SELECT ISNULL(cr.Quantity, gpimarr.Quantity) AS Quantity, gpimarr.HasCustomizing, gpimarr.ExcludeTag, gpimarr.SubItemType, gpimarr.ExcludeWhenPartProductCodeHasText, gpimarr.ProductionItemModifcationAddRemoveRuleId,
                gpimarr.OnlyFromTag, gpimarr.ReplacementProductId, gpimarr.ComponentPartTypeToAdd, gpimarr.ExcludeWhenProductHasText, gpimarr.OnlyWhenProductHasText, gpimarr.OnlyRemoveWhenAdd, 
				--CASE WHEN gpimarr.ProductionItemModifcationAddRemoveRuleId = 31 THEN cr.PartId
				--ELSE 
				COALESCE(cr.PartId, drawerBoxInMl.ComponentPartTypeId, gpimarr.PartId)
				--END 
				AS PartId
				FROM dbo.GetProductionItemModifcationAddRemoveRules(il2.ID, te.OrderID, te.EZProdID) AS gpimarr
				OUTER APPLY
				(
					SELECT Drawers.ComponentPartId AS PartId, COUNT(*) AS Quantity 
					FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
					CROSS APPLY
					(
						SELECT TOP (1) mcr.ComponentPartId FROM @ModConfigRules AS mcr
						WHERE mcr.Config = goict.ConfigValue
						ORDER BY CASE WHEN mcr.ProductId = il.ProductID
						THEN 0 WHEN mcr.ProductId IS NULL THEN 1 ELSE 2 END

					)AS Drawers
					WHERE goict.ConfigKey = 'Remove Drawers'
					AND gpimarr.ProductionItemModifcationAddRemoveRuleId = 31
					GROUP BY Drawers.ComponentPartId
				)AS cr
				OUTER APPLY
				(
					SELECT TOP (1) tilDb.ComponentPartTypeId FROM @MaterialList AS ml2
					JOIN dbo.tb_ItemList AS tilDb ON tilDb.AcumaticaName = ml2.InventoryID
					WHERE tilDb.ComponentPartTypeId IN(7, 17)
					AND gpimarr.ProductionItemModifcationAddRemoveRuleId = 31
				)drawerBoxInMl
				WHERE gpimarr.AddRemoveType = 'Remove' 
				AND 
				--CASE WHEN gpimarr.ProductionItemModifcationAddRemoveRuleId <> 31 THEN cr.PartId
				--ELSE 
				COALESCE(cr.PartId, drawerBoxInMl.ComponentPartTypeId, gpimarr.PartId) 
				--END 
				= il3.ComponentPartTypeId
				AND gpimarr.ModificationProductReplacementHeaderId IS NULL
				AND
				(
					gpimarr.ExcludeStyle IS NULL
					OR NOT EXISTS
					(
						SELECT * FROM inventory.DoorStyles AS ds
						WHERE ds.DoorStyleID = il.DoorStyleID
						AND EXISTS
						(
							SELECT * FROM dbo.FN_ListToTable( ' ', gpimarr.ExcludeStyle) AS fltt
							WHERE ds.Style LIKE '%' + fltt.ListValue + '%'
						)
					)
				) 
			)mr
			JOIN inventory.ComponentPartType cpt ON cpt.ComponentPartTypeId = il3.ComponentPartTypeId
			JOIN dbo.tb_AdjustedBoxDimensions abd ON abd.TranEntryID = te.ID
			JOIN inventory.AcumaticaStockItems asi ON asi.AcumaticaID = il.AcumaticaID
		WHERE te.ID = @orderItemId
		AND --ExcludeWhenProductHasText
		(
			mr.ExcludeWhenProductHasText IS NULL 
			OR NOT EXISTS
			(
				SELECT * FROM inventory.Products AS p2
				WHERE p2.ProductID = il.ProductID
				AND EXISTS
				(
					SELECT * FROM dbo.FN_ListToTable(' ', mr.ExcludeWhenProductHasText) AS fltt
					WHERE p2.ProductCode LIKE '%' +  fltt.ListValue  + '%'
				)
				--AND p2.ProductCode LIKE '%' + mr.ExcludeWhenProductHasText + '%'
			)				 
		)
		AND ( mr.ExcludeTag IS NULL OR NOT EXISTS (SELECT * FROM inventory.ProductToProductTags ptpt WHERE mr.ExcludeTag = ptpt.ProductTagId AND ptpt.ProductId=il.ProductID AND ptpt.DeleteFlag=0))
		AND ( mr.HasCustomizing IS NULL OR mr.HasCustomizing=te.HasCustomizing  )
		--FF-58
		AND 
		(
			mr.OnlyWhenProductHasText IS NULL
			OR EXISTS
			(
				SELECT * FROM inventory.Products AS p2
				WHERE p2.ProductID = il.ProductID
				AND p2.ProductCode LIKE '%' + mr.OnlyWhenProductHasText + '%'
			)
		)


		INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, FunctionPart)
			SELECT pimarr.ProductionItemModifcationAddRemoveRuleId, pimarr.AddRemoveType , COALESCE(pimarr.PartId, parts.ComponentPartTypeId), parts.InventoryID, parts.QtyRequired, 'From Sub Item'
			FROM dbo.TranEntry AS te 
			JOIN dbo.tb_ItemList AS tilmain ON tilmain.ItemCode = te.ItemNumber 
			JOIN dbo.TranEntry AS te2 ON te2.OrderID=te.OrderID AND te.EZProdID = te2.EZParentProdID 
			--AND te2.isActive = 1 
			AND te2.isDeleted = 0 AND te2.ItemType = 4
			JOIN dbo.tb_ItemList AS til ON til.ItemCode = te2.ItemNumber
			LEFT JOIN inventory.Products AS p ON p.ProductID = til.ProductID
			CROSS APPLY
			(
				SELECT * FROM dbo.GetProductionItemModifcationAddRemoveRules(til.ID, te.OrderID, te.EZProdID) AS gpimarr
				WHERE gpimarr.AddRemoveType = 'Add' AND (gpimarr.FromSubItem = 1 OR gpimarr.FromSubItemWhenPossible = 1)
				AND gpimarr.ModificationProductReplacementHeaderId IS NULL
				AND
				(
					gpimarr.ExcludeStyle IS NULL
					OR NOT EXISTS
					(
						SELECT * FROM inventory.DoorStyles AS ds
						WHERE ds.DoorStyleID = tilmain.DoorStyleID
						AND EXISTS
						(
							SELECT * FROM dbo.FN_ListToTable( ' ', gpimarr.ExcludeStyle) AS fltt
							WHERE ds.Style LIKE '%' + fltt.ListValue + '%'
						)
					)
				) 
				AND 
				( 
					gpimarr.ExcludeTag IS NULL 
					OR NOT EXISTS (SELECT * FROM inventory.ProductToProductTags ptpt WHERE gpimarr.ExcludeTag = ptpt.ProductTagId AND ptpt.ProductId=tilmain.ProductID AND ptpt.DeleteFlag=0 )
				)
				AND 
				(
					gpimarr.PartExcludeTag IS NULL 
					OR NOT EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt2 WHERE ptpt2.ProductId = til.ProductID AND ptpt2.ProductTagId = gpimarr.PartExcludeTag AND ptpt2.DeleteFlag=0)
				)
				AND (gpimarr.ExcludeWhenPartProductCodeHasText IS NULL OR '%' + p.ProductCode + '%' NOT LIKE gpimarr.ExcludeWhenPartProductCodeHasText)
				--FF-58
				AND 
				(
					gpimarr.OnlyWhenProductHasText IS NULL
					OR EXISTS
					(
						SELECT * FROM inventory.Products AS p2
						WHERE p2.ProductID = tilmain.ProductID
						AND p2.ProductCode LIKE '%' + gpimarr.OnlyWhenProductHasText + '%'
					)
				)
			)pimarr
			JOIN dbo.TranEntry AS te3 ON te3.OrderID=te.OrderID AND te.EZProdID = te3.EZParentProdID  AND te3.isDeleted = 0 AND te3.ItemType = pimarr.SubItemType			
			JOIN dbo.tb_ItemList AS tilsub  ON tilsub.ItemCode = te3.ItemNumber
			CROSS APPLY 
			( 
				SELECT bomd.InventoryID, til2.ComponentPartTypeId, bomd.QtyRequired
				FROM acumaticaManufacturing.BillOfMaterials AS bom
				JOIN dbo.tb_ItemList AS tilBom ON bom.InventoryID = tilBom.AcumaticaName 
				JOIN acumaticaManufacturing.BillOfMaterialOperations AS bomo ON bomo.BOMID = bom.BOMID AND bomo.DeleteFlag = 0
				JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = 0 AND bomd.OperationDbId=bomd.OperationDbId
				JOIN acumaticaManufacturing.BOMRevisions AS br ON br.AcumaticaName = bom.InventoryID AND bom.BOMID = COALESCE(br.BOMIDC, br.BOMIDB, br.BOMIDD, br.BOMIDE)
				JOIN dbo.tb_ItemList AS til2 ON til2.AcumaticaName = bomd.InventoryID
				WHERE bom.DeleteFlag = 0  AND bomo.WorkCenter = 'PICKING' 
				AND 
				(
					til2.ComponentPartTypeId = pimarr.PartId
					--IL-3334
					OR 
					(
						pimarr.PartId IS NULL
						--IL-3856
						AND 
						(
							til2.ComponentPartTypeId <> 11
							OR NOT EXISTS
							(
								SELECT * FROM  dbo.TranEntry AS te3 
								WHERE te.OrderID = te3.OrderID AND te.EZProdID = te3.EZParentProdID
								AND te3.ItemNumber = 'UP CHARGE:DOORS ON BO'
							)
						)                        
					)
				)
				AND bom.InventoryID = tilsub.AcumaticaName	
				AND NOT EXISTS
				(
					SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
					WHERE asitoi.StockAcumaticaID = til2.AcumaticaID
					AND asitoi.SortComponent >= asitoi.Quantity
					AND pimarr.OnlyWhenInStock = 1
				)	  
				AND NOT 
				(
					NOT EXISTS
					(
						SELECT * FROM dbo.ItemLocationsUpdate ilu
						JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
						WHERE il.ExcludeFrmStock = 0
						AND il.LocationType <> 13
						AND ilu.ItemCode = til2.ShortItemCode
					)
					AND pimarr.OnlyWhenInStock = 1
				)
				 AND --ExcludeWhenProductHasText
				 (
					pimarr.ExcludeWhenProductHasText IS NULL 
					OR NOT EXISTS
					(
						SELECT * FROM inventory.Products AS p2
						WHERE p2.ProductID = tilmain.ProductID
						AND EXISTS
						(
							SELECT * FROM dbo.FN_ListToTable(' ', pimarr.ExcludeWhenProductHasText) AS fltt
							WHERE p2.ProductCode LIKE  '%' +  fltt.ListValue  + '%'
						)
					)				 
				 )
				 AND --MatchOnTag
                 (
					pimarr.MatchOnTag IS NULL
					OR --original and replacement have tag
                    (
						EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE tilmain.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = pimarr.MatchOnTag AND ptpt.DeleteFlag=0)
						AND EXISTS (SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE tilBom.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = pimarr.MatchOnTag AND ptpt.DeleteFlag=0)
					)
					OR --original and replacement don't have tag
					(
						NOT EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE tilmain.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = MatchOnTag AND ptpt.DeleteFlag=0)
						AND NOT EXISTS (SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE tilBom.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = MatchOnTag AND ptpt.DeleteFlag=0)	
					)	
				 )
			 ) parts
			WHERE te.ID = @orderItemId 
			
		INSERT INTO @itemAddRemove (ProductionItemModifcationAddRemoveRuleId, ActionType, PartTypeId, PartItemCode, Quantity, FunctionPart)
		SELECT mr.ProductionItemModifcationAddRemoveRuleId, 'Add', cpt.ComponentPartTypeId, prtsToAdd.ShortItemCode, mr.Quantity, 'Not from sub item'
		FROM dbo.TranEntry te
			JOIN dbo.TranEntry te2 ON te2.OrderID = te.OrderID 
			AND te2.EZParentProdID = te.EZProdID
			--AND te2.isActive = te.isActive 
			AND te.isActive = 1
			AND te.isDeleted = 0
			AND te2.isDeleted = 0
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber 
			JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te2.ItemNumber
			JOIN dbo.tb_AdjustedBoxDimensions abd ON abd.TranEntryID = te.ID
			JOIN inventory.AcumaticaStockItems asi ON asi.AcumaticaID = il.AcumaticaID
			CROSS APPLY
			(
				SELECT * FROM dbo.GetProductionItemModifcationAddRemoveRules(il2.ID, te.OrderID, te.EZProdID) AS gpimarr
				WHERE gpimarr.AddRemoveType = 'Add'  
				AND gpimarr.ModificationProductReplacementHeaderId IS NULL
				AND
				(
					gpimarr.ExcludeStyle IS NULL
					OR NOT EXISTS
					(
						SELECT * FROM inventory.DoorStyles AS ds
						WHERE ds.DoorStyleID = il.DoorStyleID
						AND EXISTS
						(
							SELECT * FROM dbo.FN_ListToTable( ' ', gpimarr.ExcludeStyle) AS fltt
							WHERE ds.Style LIKE '%' + fltt.ListValue + '%'
						)
					)
				) 
				AND 
				(
					gpimarr.FromSubItem = 0 
					OR (gpimarr.FromSubItemWhenPossible = 1 AND NOT EXISTS(SELECT * FROM @itemAddRemove AS iar WHERE iar.ProductionItemModifcationAddRemoveRuleId IS NOT NULL 
						AND iar.ProductionItemModifcationAddRemoveRuleId = gpimarr.ProductionItemModifcationAddRemoveRuleId))
					AND ( gpimarr.ExcludeTag IS NULL OR NOT EXISTS (SELECT * FROM inventory.ProductToProductTags ptpt WHERE gpimarr.ExcludeTag = ptpt.ProductTagId AND ptpt.ProductId=il.ProductID AND ptpt.DeleteFlag=0 ))									
				)
				AND 
				(
					gpimarr.OnlyWhenProductHasText IS NULL
					OR EXISTS
					(
						SELECT * FROM inventory.Products AS p2
						WHERE p2.ProductID = il.ProductID
						AND p2.ProductCode LIKE '%' + gpimarr.OnlyWhenProductHasText + '%'
					)
				)
			)mr
			JOIN inventory.ComponentPartType cpt ON cpt.ComponentPartTypeId = mr.PartId
			CROSS APPLY
			 (
				 SELECT TOP 1 bom.InventoryID item, bomd.InventoryID , il4.ShortItemCode, asi2.Height, asi2.Width, asi2.Depth, il4.AcumaticaDesc
				 FROM acumaticaManufacturing.BillOfMaterials bom
					 JOIN dbo.tb_ItemList il3 ON bom.InventoryID = il3.AcumaticaName AND il3.DoorStyleID = il.DoorStyleID AND il3.ItemTypeCode = il.ItemTypeCode
					 JOIN inventory.AcumaticaStockItems asi2 ON asi2.AcumaticaID = il3.AcumaticaID
					 JOIN acumaticaManufacturing.BillOfMaterialDetails bomd ON bomd.BOMID = bom.BOMID AND bomd.DeleteFlag = 0 AND bom.DeleteFlag = 0 AND bom.Revision <> 'A'
					 JOIN dbo.tb_ItemList il4 ON il4.AcumaticaName = bomd.InventoryID AND il4.ComponentPartTypeId = mr.PartId 
					
				 WHERE
				 (
					(   
					 EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
					 AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
					 AND 
					 (
						 (
							 asi2.Depth >= asi.Depth + abd.AdjustDepth 
							 AND ((asi2.Height >= asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL) OR mr.SpecificHeight = asi2.Height)
							 AND mr.ExactMeasurementsOnly = 0
						 )
						 OR EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
							WHERE gab.Depth = asi.Depth + abd.AdjustDepth AND ((gab.Height = asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL)OR gab.Height = mr.SpecificHeight))
					 )
					 AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (   EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width'  AND mr.AddRemoveType ='Add')
					 AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height'  AND mr.AddRemoveType ='Add')

					 -- hard coded for full hight door add shelf, if it happens more, add column to table "ProductionItemModifcationAddRemoveRules" to indicate
					 AND 
					 (
						 mr.ProductionItemModifcationAddRemoveRuleId <> 45
   						 OR 
						 (
							EXISTS (SELECT * FROM inventory.DoorStyles dsc WHERE il.DoorStyleID = dsc.DoorStyleID
							AND EXISTS (SELECT * FROM inventory.DoorStyles dsr WHERE il3.DoorStyleID=dsr.DoorStyleID 
								AND ((dsr.SeriesName IN ('Allure', 'Classic') AND dsc.SeriesName IN ('Allure', 'Classic')) OR (dsr.SeriesName NOT IN ('Allure', 'Classic') AND dsc.SeriesName NOT IN ('Allure', 'Classic')))))
						)
					 )
				 AND 
				 (
					(asi2.Depth >= asi.Depth + abd.AdjustDepth AND asi2.Width >= asi.Width + abd.AdjustWidth AND mr.ExactMeasurementsOnly = 0 AND mr.BaseMesurementsOnWholeCabinet = 0)
					OR (EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
						WHERE gab.Depth = asi.Depth + abd.AdjustDepth AND gab.Width = asi.Width + abd.AdjustWidth)
						AND mr.BaseMesurementsOnWholeCabinet = 1)
				 )
				 AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (   EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
					 AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
				 AND 
				 (
					(
						asi2.Width >= asi.Width + abd.AdjustWidth 
						AND ((asi2.Height >= asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL) OR mr.SpecificHeight = asi2.Height)
						AND mr.ExactMeasurementsOnly = 0
						AND mr.BaseMesurementsOnWholeCabinet = 0
					)
					OR (EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
						WHERE gab.Width = asi.Width + abd.AdjustWidth
						AND((gab.Height = asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL) OR gab.Height = mr.SpecificHeight))
						AND mr.BaseMesurementsOnWholeCabinet = 1)
				 )
				 AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (
					 EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
					 AND EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
					AND 
					(
						(
						asi2.Width >= asi.Width + abd.AdjustWidth 
						AND asi2.Depth >= asi.Depth + abd.AdjustDepth 
						AND ((asi2.Height >= asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL) OR mr.SpecificHeight = asi2.Height)						
						AND mr.ExactMeasurementsOnly = 0
						AND mr.BaseMesurementsOnWholeCabinet = 0
						)  
						OR (EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
							WHERE gab.Width = asi.Width + abd.AdjustWidth
							AND((gab.Height = asi.Height + abd.AdjustHeight AND mr.SpecificHeight IS NULL) OR gab.Height = mr.SpecificHeight)
							AND gab.Depth = asi.Depth + abd.AdjustDepth)
							AND mr.BaseMesurementsOnWholeCabinet = 1
							)
					)
					AND mr.PartToAddFromProduct IS NULL
				 )
				 OR
				 (
						EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Width' AND mr.AddRemoveType ='Add')
						AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Height' AND mr.AddRemoveType ='Add')
						AND NOT EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr WHERE cptmr.ComponentPartTypeId = mr.PartId AND cptmr.Dimension = 'Depth' AND mr.AddRemoveType ='Add')
						AND 					
						(
							(
								asi2.Width >= asi.Width + abd.AdjustWidth 						
								AND mr.ExactMeasurementsOnly = 0
								AND mr.BaseMesurementsOnWholeCabinet = 0
							)  
								OR (EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
								WHERE gab.Width = asi.Width + abd.AdjustWidth
								AND mr.BaseMesurementsOnWholeCabinet = 1)
							)	
						)
						AND mr.PartToAddFromProduct IS NULL				
				 )
				 OR
				 (
					mr.PartToAddFromProduct IS NOT NULL AND EXISTS (SELECT * FROM  inventory.Products p WHERE p.ProductCode=mr.PartToAddFromProduct AND il3.ProductID = p.ProductID)
				 )
				 )
				 AND --ExcludeWhenProductHasText
				 (
					mr.ExcludeWhenProductHasText IS NULL 
					OR NOT EXISTS
					(
						SELECT * FROM inventory.Products AS p
						WHERE p.ProductID = il.ProductID
						AND EXISTS
						(
							SELECT * FROM dbo.FN_ListToTable(' ', mr.ExcludeWhenProductHasText) AS fltt
							WHERE p.ProductCode LIKE '%' +  fltt.ListValue  + '%' 
						)
						--AND p.ProductCode LIKE '%' + mr.ExcludeWhenProductHasText + '%'
					)				 
				 )
				 AND --MatchOnTag
                 (
					mr.MatchOnTag IS NULL
					OR
                    (
						--original and replacement have tag
						EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE il.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = mr.MatchOnTag AND ptpt.DeleteFlag=0)
						AND EXISTS (SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE il3.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = mr.MatchOnTag AND ptpt.DeleteFlag=0)
					)		
					OR --original and replacement don't have tag
					(
						NOT EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE il.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = mr.MatchOnTag AND ptpt.DeleteFlag=0)
						AND NOT EXISTS (SELECT * FROM inventory.ProductToProductTags AS ptpt 
						WHERE il3.ProductID = ptpt.ProductTagId AND ptpt.ProductTagId = mr.MatchOnTag AND ptpt.DeleteFlag=0)							
					)
				 )
				 AND --from same belt
				 (
					 ISNULL(mr.FromSameBelt, 0) = 0 
					 OR EXISTS(SELECT * FROM picking.DestinationLocationItemRule AS dlir 
						JOIN Picking.ProductionItem AS pi ON pi.ItemlistId = dlir.ProductionItemItemlistId
						WHERE EXISTS (SELECT * FROM picking.DestinationLocationItemRule dlir2 
							WHERE dlir2.ProductionItemItemlistId = il3.ID
							AND dlir.DestinationLocationId = dlir2.DestinationLocationId)
						AND pi.OrderItemId = @orderItemId)
				 )
                 AND (mr.OnlyFromTag IS NULL OR EXISTS(SELECT * FROM inventory.ProductToProductTags ptpt WHERE mr.OnlyFromTag = ptpt.ProductTagId AND ptpt.ProductId = il3.ProductID  AND ptpt.DeleteFlag=0 ))
				 AND NOT EXISTS
				 (
					 SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
					 WHERE asitoi.StockAcumaticaID = il4.AcumaticaID
					 AND asitoi.SortComponent >= asitoi.Quantity
					 AND mr.OnlyWhenInStock = 1
				 )
				 AND NOT 
				(
					NOT EXISTS
					(
						SELECT * FROM dbo.ItemLocationsUpdate ilu
						JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
						WHERE il.ExcludeFrmStock = 0
						AND il.LocationType <> 13
						AND ilu.ItemCode = il4.ShortItemCode
					)
					AND mr.OnlyWhenInStock = 1
				)
				 AND 
				(
					mr.ExcludeWhenPartProductCodeHasText IS NULL 
					OR EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
						WHERE '%' + gab.ProductCode + '%' NOT LIKE mr.ExcludeWhenPartProductCodeHasText) 
				)
				AND 
				(
					mr.PartExcludeTag IS NULL 
					OR EXISTS(SELECT * FROM dbo.GetAvailableBomHeaderFromComponentId(il4.ID) AS gab
						WHERE NOT EXISTS(SELECT * FROM inventory.ProductToProductTags AS ptpt 
							WHERE ptpt.DeleteFlag = 0 AND ptpt.ProductId = gab.ProductID 
							AND ptpt.ProductTagId = mr.PartExcludeTag))
				)	
				 ORDER BY CASE WHEN EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr2 WHERE cptmr2.ComponentPartTypeId = il4.ComponentPartTypeId AND cptmr2.Dimension = 'Width') THEN asi2.Width ELSE 1000 END, 
						  CASE WHEN EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr2 WHERE cptmr2.ComponentPartTypeId = il4.ComponentPartTypeId AND cptmr2.Dimension = 'Height') THEN asi2.Height ELSE 1000 END,
						  CASE WHEN EXISTS(SELECT 1 FROM @ComponentPartTypeMatchRules cptmr2 WHERE cptmr2.ComponentPartTypeId = il4.ComponentPartTypeId AND cptmr2.Dimension = 'Depth') THEN asi2.Depth ELSE 1000 END
						  ,asi2.Height,asi2.Width,asi2.Depth
			 ) prtsToAdd
		WHERE te.ID = @orderItemId;

		--IL-3652 redone on --FF-264
		DECLARE @itemReplace TABLE(RuleId INT, AddPartAcumaticaName VARCHAR(50), Quantity INT, RemovePartAcumaticaName VARCHAR(50))

		INSERT @itemReplace(RuleId, AddPartAcumaticaName, Quantity, RemovePartAcumaticaName)
		SELECT pimarr.ProductionItemModifcationAddRemoveRuleId, ReplaceItem.AddAcumaticaName, COALESCE(maprd.QuantityToReplace, mlQty.Quantity, 0), tilRemove.AcumaticaName
		FROM dbo.TranEntry AS te
		JOIN dbo.tb_ItemList AS tilMain ON tilMain.ItemCode = te.ItemNumber
		JOIN dbo.TranEntry AS teMOd ON te.OrderID = teMOd.OrderID
			AND te.EZProdID = teMOd.EZParentProdID
		JOIN dbo.tb_ItemList AS tilMOd ON tilMOd.ItemCode = teMOd.ItemNumber
		JOIN picking.ModificationToAddRemoveRuleDetail AS mtarrd ON mtarrd.ModificationId = tilMOd.ID
		JOIN picking.ModificationToAddRemoveRuleHeader AS mtarrh ON mtarrh.ModificationToAddRemoveRuleHeaderId = mtarrd.ModificationToAddRemoveRuleHeaderId
		JOIN picking.ProductionItemModifcationAddRemoveRules AS pimarr ON pimarr.ProductionItemModifcationAddRemoveRuleId = mtarrh.ProductionItemModifcationAddRemoveRuleId
		JOIN picking.ModificationAcuProductReplacementDetail AS maprd ON maprd.ModificationAcuProductReplacementHeaderId = pimarr.ModificationAcuProductReplacementHeaderId
		JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaProductID = maprd.OriginalAcuProductId
		JOIN dbo.tb_ItemList AS tilRemove ON asi.AcumaticaID = tilRemove.AcumaticaID
		CROSS APPLY
		(
			SELECT TOP 1 tilReplace.AcumaticaName AS AddAcumaticaName, tilReplace.ProductID, tilReplace.AcumaticaID, tilReplace.ShortItemCode AS AddShortItemCode 
			FROM dbo.tb_ItemList AS tilReplace 
			WHERE tilReplace.ProductID = maprd.ReplacementProductId
			AND ISNULL(tilReplace.DoorStyleID, tilMain.DoorStyleID) = tilMain.DoorStyleID		)AS ReplaceItem
		OUTER APPLY
		(
			SELECT ml.Quantity FROM @MaterialList AS ml
			WHERE ml.InventoryID = tilRemove.AcumaticaName
			AND maprd.QuantityToReplace IS NULL
		)mlQty
		
		WHERE --teMOd.isActive = 1
		--AND 
		teMOd.isDeleted = 0
		AND pimarr.AddRemoveType = 'Replace'
		AND EXISTS
		(
			SELECT * FROM @MaterialList AS ml
			WHERE ml.InventoryID = asi.Name
		)
		AND mtarrd.ToCancelOtherInGroup = 0
		AND 
		(
			pimarr.ExcludeTag IS NULL
			OR NOT EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt
				WHERE tilMain.ProductID = ptpt.ProductId
				AND ptpt.DeleteFlag = 0
				AND pimarr.ExcludeTag = ptpt.ProductTagId
			)
		)
		AND 
		(
			pimarr.OnlyFromTag IS NULL 
			OR EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt
				WHERE tilMain.ProductID = ptpt.ProductId
				AND ptpt.DeleteFlag = 0
				AND pimarr.OnlyFromTag = ptpt.ProductTagId
			)
		)
		AND 
		(
			pimarr.PartExcludeTag IS NULL
			OR NOT EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt
				WHERE ReplaceItem.ProductID = ptpt.ProductId
				AND ptpt.DeleteFlag = 0
				AND pimarr.PartExcludeTag = ptpt.ProductTagId
			) 
		)
		AND 
		(
			pimarr.OnlyWhenProductHasText IS NULL
			OR EXISTS 
			(
				SELECT * FROM inventory.Products AS p
				WHERE tilMain.ProductID = p.ProductID
				AND p.ProductCode LIKE '%' + pimarr.OnlyWhenProductHasText + '%'
			)
		)
		AND 
		(
			pimarr.ExcludeWhenPartProductCodeHasText IS NULL
			OR NOT EXISTS
			(
				SELECT * FROM inventory.Products AS p2
				WHERE p2.ProductID = ReplaceItem.ProductID
				AND p2.ProductCode LIKE '%' + pimarr.ExcludeWhenPartProductCodeHasText + '%'
			)
		)
		AND 
		(
			pimarr.ExcludeWhenProductHasText IS NULL
			OR NOT EXISTS
			(
				SELECT * FROM inventory.Products AS p3
				WHERE tilMain.ProductID = p3.ProductID
				AND p3.ProductCode LIKE '%' + pimarr.ExcludeWhenProductHasText + '%'
			)
		)
		AND NOT EXISTS
		(
			SELECT * FROM dbo.AssignStockItemToOrderItem AS asitoi 
			WHERE asitoi.StockAcumaticaID = ReplaceItem.AcumaticaID
			AND asitoi.SortComponent >= asitoi.Quantity
			AND pimarr.OnlyWhenInStock = 1
		)
		AND NOT 
		(
			NOT EXISTS
			(
				SELECT * FROM dbo.ItemLocationsUpdate ilu
				JOIN dbo.InventoryLocation AS il ON il.Location = ilu.Location
				WHERE il.ExcludeFrmStock = 0
				AND il.LocationType <> 13
				AND ilu.ItemCode = ReplaceItem.AddShortItemCode
			)
			AND pimarr.OnlyWhenInStock = 1
		)
		AND 
		(
			pimarr.ExcludeStyle IS NULL
			OR NOT EXISTS
			(
				SELECT * FROM inventory.DoorStyles AS ds
				WHERE ds.DoorStyleID = tilMain.DoorStyleID
				AND EXISTS
				(
					SELECT * FROM dbo.FN_ListToTable( ' ', pimarr.ExcludeStyle) AS fltt
					WHERE ds.Style LIKE '%' + fltt.ListValue + '%'
				)
			)
		)
		AND
        (
				pimarr.ProductionItemModifcationAddRemoveRuleId <> 229
				OR dbo.OrderItemHasCutDoorsOnAllDoors(@orderItemId) = 1
		)
		AND te.ID = @orderItemId
		
		INSERT INTO @AddremoveRules (RuleId, AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, PartType, FunctionPart) --Remove
		SELECT DISTINCT iar.ProductionItemModifcationAddRemoveRuleId, iar.ActionType, iar.PartItemCode,  iar.QuantityAll, COALESCE(iar.Quantity, qty.Quantity,1),'PICKING' , iar.PartTypeId, iar.FunctionPart
		FROM @itemAddRemove iar	
		OUTER APPLY 
		(
			SELECT TOP (1) ml.Quantity 
			FROM dbo.tb_ItemList il 
			JOIN @MaterialList ml ON ml.InventoryID = il.AcumaticaName 
			WHERE il.ComponentPartTypeId = iar.PartTypeId 
			AND iar.QuantityAll = 1
		) qty
		WHERE NOT EXISTS
		(
			SELECT * FROM @itemAddRemove iar2 
			WHERE iar.PartTypeId = iar2.PartTypeId AND iar2.PartItemCode = iar.PartItemCode 
			AND iar2.Quantity = iar.Quantity 
			AND iar2.ActionType <> iar.ActionType
		) 
		AND NOT EXISTS
		(
			SELECT * FROM picking.ProductionItemModifcationAddRemoveRules mr 
			WHERE mr.ProductionItemModifcationAddRemoveRuleId = iar.ProductionItemModifcationAddRemoveRuleId 
			AND mr.OnlyRemoveWhenAdd = 1  
			AND NOT EXISTS
			(
				SELECT 1 FROM @itemAddRemove iar2 
				WHERE 
				(
					(
						iar.PartTypeId = iar2.PartTypeId 
						AND mr.OnlyRemoveWhenAddPartId IS NULL
					) 
					OR 
					(
						mr.OnlyRemoveWhenAddPartId IS NOT NULL 
						AND iar2.PartTypeId = mr.OnlyRemoveWhenAddPartId
					)
				)
				AND ISNULL(iar2.Quantity, 1) >= ISNULL(iar.Quantity, 0)
				AND iar2.ActionType='Add' 
			) 
		)
		AND iar.ActionType = 'Remove'

		INSERT INTO @AddremoveRules (RuleId, AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart ) --Add
		SELECT DISTINCT iar.ProductionItemModifcationAddRemoveRuleId, iar.ActionType, iar.PartItemCode,  iar.QuantityAll,
		COALESCE(iar.Quantity, remove.Quantity, 1),
		'PICKING' , iar.FunctionPart
		FROM @itemAddRemove iar
		OUTER APPLY
		(
			SELECT ar.Quantity 
			FROM  @AddremoveRules AS ar WHERE ar.PartType = iar.PartTypeId AND ar.AddRemoveAction = 'remove'
		)remove	
		OUTER APPLY 
		(
			SELECT TOP (1) ml.Quantity 
			FROM dbo.tb_ItemList il 
			JOIN @MaterialList ml ON ml.InventoryID = il.AcumaticaName 
			WHERE il.ComponentPartTypeId = iar.PartTypeId 
			AND iar.QuantityAll = 1
		) qty
		WHERE NOT EXISTS
		(
			SELECT * FROM @itemAddRemove iar2 
			WHERE iar.PartTypeId = iar2.PartTypeId 
			AND iar2.PartItemCode = iar.PartItemCode 
			AND iar2.Quantity = iar.Quantity 
			AND iar2.ActionType <> iar.ActionType
		) 
		AND NOT EXISTS 
		(
			SELECT * FROM @itemAddRemove ar 
			WHERE ar.ActionType=iar.ActionType 
			AND ar.PartItemCode = iar.PartItemCode 
			AND ar.ProductionItemModifcationAddRemoveRuleId <> iar.ProductionItemModifcationAddRemoveRuleId 
		)
		--IL-3639
		AND NOT EXISTS
		(
			SELECT * FROM @AddremoveRules AS ar2 
			WHERE ar2.AddRemoveAction = 'Remove'
			AND ar2.InventoryId = iar.PartItemCode
			AND ar2.RuleId <> iar.ProductionItemModifcationAddRemoveRuleId
			AND ar2.Quantity = iar.Quantity
		)
		AND iar.ActionType = 'Add'

		--FF-320
		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart ) --explicit additions (from table AddonBomAdditions)
		SELECT aba.ActionType, tilAddition.AcumaticaName, 
		CASE WHEN aba.Quantity IS NULL 
			AND aba.QuantityFromSubItem = 0
			AND aba.QuantityForOriginalItem = 0
			AND aba.ActionType <> 'Replace'
			AND aba.ConfigKey IS NULL THEN 1 ELSE 0 END AS QuantityAll, 
		COALESCE(SubItemQuantity.QtyRequired, QuantityOfOriginalItem.Quantity, aba.Quantity, 0) + ISNULL(QuantityPerComponent.QuantityPerComponent, 0) + COALESCE(QuantityConfig.QuantityConfigMultiplied, aba.QuantityPerConfigKey,0) AS Quantity, 
		'PICKING', 'Explicit additions (from table AddonBomAdditions)'
		FROM dbo.TranEntry AS te
		JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID AND te.EZProdID = te2.EZParentProdID
		JOIN dbo.tb_ItemList AS tilSub ON tilSub.ItemCode = te2.ItemNumber
		JOIN picking.AddonBomAdditions AS aba ON aba.SubItemId = tilSub.ID
		JOIN dbo.tb_ItemList AS tilAddition ON tilAddition.ID = aba.AdditionalItemId
		OUTER APPLY
		(
			SELECT CAST(bomd.QtyRequired AS INT) AS QtyRequired
			FROM acumaticaManufacturing.BillOfMaterials AS bom
			JOIN dbo.tb_ItemList AS tilSubForParts ON bom.InventoryID = tilSubForParts.AcumaticaName
			JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			WHERE bom.DeleteFlag = 0
			AND bomd.DeleteFlag = 0
			AND bom.Revision IN ('B', 'C', 'D')
			AND tilSubForParts.ItemTypeCode IN (1, 2)
			AND aba.QuantityFromSubItem = 1
			AND bomd.InventoryID = tilAddition.AcumaticaName
			AND EXISTS
			(
				SELECT * FROM dbo.TranEntry AS teSubForParts
				WHERE teSubForParts.isDeleted = 0
				AND teSubForParts.OrderID = te.OrderID 
				AND teSubForParts.EZParentProdID = te.EZProdID
				AND teSubForParts.ItemNumber = tilSubForParts.ItemCode
			)
		)AS SubItemQuantity
		OUTER APPLY
		(
			SELECT TOP (1) CAST(bomd.QtyRequired AS INT) * aba.QuantityPerComponentPartType AS QuantityPerComponent
			FROM acumaticaManufacturing.BillOfMaterials AS bom
			JOIN dbo.tb_ItemList AS tilSubForParts ON bom.InventoryID = tilSubForParts.AcumaticaName
			JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			JOIN dbo.tb_ItemList AS tilBomD ON tilBomD.AcumaticaName = bomd.InventoryID
			WHERE bom.DeleteFlag = 0
			AND bomd.DeleteFlag = 0
			--AND bom.Revision IN ('B', 'C', 'D')
			--AND aba.ComponentPartTypeId IS NOT NULL
			AND tilBomD.ComponentPartTypeId = aba.ComponentPartTypeId
			AND bom.InventoryID = tilSubForParts.AcumaticaName
			AND tilSubForParts.ItemTypeCode IN (1, 2)
			AND EXISTS
			(
				SELECT * FROM dbo.TranEntry AS teSubForParts
				WHERE teSubForParts.isDeleted = 0
				AND teSubForParts.OrderID = te.OrderID 
				AND teSubForParts.EZParentProdID = te.EZProdID
				AND teSubForParts.ItemNumber = tilSubForParts.ItemCode
			)
		)AS QuantityPerComponent
		OUTER APPLY
		(
			SELECT ml.Quantity FROM @MaterialList AS ml
			WHERE ml.InventoryID = tilAddition.AcumaticaName
			AND aba.QuantityForOriginalItem = 1
		)AS QuantityOfOriginalItem
		OUTER APPLY
		(
			SELECT ISNULL(NULLIF(COUNT(*), 0), 1) * aba.QuantityPerConfigKey AS  QuantityConfigMultiplied
			FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
			WHERE goict.ConfigKey = aba.ConfigKey
			AND aba.ConfigKey IS NOT NULL
		)AS QuantityConfig
		WHERE te.ID = @OrderItemId
		AND te2.isDeleted = 0
		AND aba.SubItemId IS NOT NULL
		AND 
		(
			COALESCE(SubItemQuantity.QtyRequired, QuantityOfOriginalItem.Quantity, aba.Quantity, QuantityPerComponent.QuantityPerComponent, QuantityConfig.QuantityConfigMultiplied) > 0
			OR 
			(
				aba.Quantity IS NULL 
				AND aba.QuantityFromSubItem = 0
				AND aba.QuantityForOriginalItem = 0
				AND aba.ActionType <> 'Replace'
				AND ISNULL(QuantityConfig.QuantityConfigMultiplied, 0) = 0
			)
		)

		DECLARE @ReplaceSlides TABLE(ToRemove VARCHAR(50), ToAdd VARCHAR(450), NeedsRemove BIT, QuantityToAdd INT, QuantityAll BIT)

		INSERT @ReplaceSlides (ToRemove, ToAdd, NeedsRemove, QuantityToAdd, QuantityAll)
		
		SELECT DISTINCT ToRemove.AcumaticaName AS ToRemove, ToAdd.AcumaticaName AS ToAdd, ToRemove.NeedsRemove, 
		CASE WHEN ISNULL(ToAdd.OrderItemId, te.ID) = te.ID THEN ToRemove.QuantityToAdd  ELSE ToAdd.ModConfigQuantity END,
		CASE WHEN ISNULL(ToAdd.OrderItemId, te.ID) = te.ID THEN 1 ELSE 0 END
		FROM dbo.TranEntry AS te
		JOIN dbo.TranEntry AS te2 ON te.OrderID = te2.OrderID
			AND te2.EZParentProdID = te.EZProdID
		JOIN dbo.tb_ItemList AS til ON til.ItemCode = te2.ItemNumber
		JOIN picking.AddonBomAdditions AS aba ON aba.SubItemId = til.ID
		CROSS APPLY
		(
			SELECT ptpt.ProductTagId, til.AcumaticaName, CAST(replace.NeedsRemove AS BIT) AS NeedsRemove, replace.QuantityToAdd
			FROM dbo.tb_ItemList AS til 
			JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = til.AcumaticaID
			JOIN inventory.ProductToProductTags AS ptpt ON ptpt.ProductId = til.ProductID
			CROSS APPLY
			(
				SELECT 1 AS NeedsRemove, ml2.Quantity AS QuantityToAdd
				FROM @MaterialList AS ml2
				WHERE ml2.InventoryID = til.AcumaticaName
				UNION ALL
				SELECT 0, 0 
				FROM @AddremoveRules AS arr
				WHERE arr.InventoryId = til.AcumaticaName
			)AS replace
			WHERE aba.TagIdToReduceBy3Inches = ptpt.ProductTagId
			AND ptpt.DeleteFlag = 0
		)AS ToRemove
		CROSS APPLY
		(
			SELECT TOP (1) tilR.AcumaticaName, cz.OrderItemId, cz.ModConfigQuantity
			FROM dbo.tb_ItemList AS tilR
			JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = tilR.AcumaticaID
			JOIN inventory.ProductToProductTags AS ptpt2 ON ptpt2.ProductId = tilR.ProductID
			OUTER APPLY
			(
				SELECT asiMain.Depth + tabd.AdjustDepth  AS CabinetDepth
				FROM inventory.AcumaticaStockItems AS asiMain
				JOIN dbo.tb_ItemList AS tilMain ON te.ItemNumber = tilMain.ItemCode
				AND tilMain.AcumaticaID = asiMain.AcumaticaID
				JOIN dbo.tb_AdjustedBoxDimensions AS tabd ON tabd.TranEntryID = @orderItemId
			)AS cd
			OUTER APPLY
			(
				SELECT CAST(goict.ConfigValue AS NUMERIC) AS CofiguredSize, goict.OrderItemId, COUNT(*) AS ModConfigQuantity
				FROM dbo.GetOrderItemConfigTabulated(@orderItemId) AS goict
				WHERE aba.ConfigKeyForResize = goict.ConfigKey
				AND ISNUMERIC(goict.ConfigValue) = 1
				GROUP BY CAST(goict.ConfigValue AS NUMERIC), goict.OrderItemId
			)AS cz
			WHERE ptpt2.DeleteFlag = 0
			AND ptpt2.ProductTagId = ToRemove.ProductTagId
			AND
			( 
				(
					(
						cd.CabinetDepth - asi.Depth >= 3
						OR 
						(
							NOT EXISTS 
							(
								SELECT * FROM dbo.tb_ItemList AS tilOtherOption
								JOIN inventory.AcumaticaStockItems AS asiOtherOption ON asiOtherOption.AcumaticaID = tilOtherOption.AcumaticaID
								WHERE EXISTS
								(
									SELECT * FROM inventory.ProductToProductTags AS ptpt3
									WHERE ptpt3.DeleteFlag = 0
									AND ptpt3.ProductId = tilOtherOption.ProductID
									AND ptpt3.ProductTagId = TagIdToReduceBy3Inches
								)
								AND cd.CabinetDepth - asiOtherOption.Depth >= 3 
							)
							AND cd.CabinetDepth > asi.Depth
							AND aba.TagIdToReduceBy3Inches = 87
						)
					)
					AND cz.CofiguredSize IS NULL
				)
				OR cz.CofiguredSize = asi.Depth
			)
			ORDER BY asi.Depth DESC
		)AS ToAdd
		WHERE te.ID = @orderItemId
		

		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, Quantity, QuantityAll, WorkCenter, FunctionPart )
		SELECT 'Remove', ReplaceSlides.ToRemove, ReplaceSlides.QuantityToAdd, ReplaceSlides.QuantityAll, 'PICKING', 'ReplaceSlides'
		FROM @ReplaceSlides AS ReplaceSlides
		WHERE EXISTS
		(SELECT * FROM @MaterialList AS ml WHERE ml.InventoryID = ReplaceSlides.ToRemove)
		AND ReplaceSlides.NeedsRemove = 1
		AND ReplaceSlides.QuantityAll = 1
		UNION ALL
		SELECT 'Add', ReplaceSlides.ToAdd, ReplaceSlides.QuantityToAdd, ReplaceSlides.QuantityAll, 'PICKING', 'ReplaceSlides'
		FROM @ReplaceSlides AS ReplaceSlides
		WHERE EXISTS
		(SELECT * FROM @MaterialList AS ml WHERE ml.InventoryID = ReplaceSlides.ToRemove)
		AND ReplaceSlides.NeedsRemove = 1
		AND ReplaceSlides.QuantityAll = 1

		UPDATE ar SET ar.InventoryId = rs.ToAdd, ar.FunctionPart = ar.FunctionPart + ' Updated From ReplaceSlides'
		FROM @AddremoveRules AS ar
		JOIN @ReplaceSlides AS rs ON rs.ToRemove = ar.InventoryId
		WHERE ar.AddRemoveAction = 'Add'
		AND rs.NeedsRemove = 0
		AND rs.ToAdd <> ar.InventoryId

		--FF-336
		INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart )--parts from bom of components
		SELECT ar.AddRemoveAction, 
		CASE WHEN tilTE.ProductID IN(497,498,499) AND ar.InventoryId = 'METAL COIN ADJUSTER' THEN 'METAL STRAIGHT ADJUSTER' ELSE BOM.InventoryID END, 
		0, BOM.Quantity, 'PICKING', 'Parts from bom of components'
		FROM @AddremoveRules AS ar
		JOIN dbo.tb_ItemList AS til ON til.AcumaticaName = ar.InventoryId
		JOIN dbo.TranEntry AS te ON te.ID = @orderItemId
		JOIN dbo.tb_ItemList AS tilTe ON tilTe.ItemCode = te.ItemNumber
		CROSS APPLY
		(
			SELECT bomd.InventoryID, CAST(bomd.QtyRequired AS INT) * ar.Quantity AS Quantity FROM  acumaticaManufacturing.BillOfMaterials AS bom 
			JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			JOIN dbo.tb_ItemList AS tild ON tild.AcumaticaName = bomd.InventoryID
			WHERE bom.InventoryID = ar.InventoryId
			AND bom.DeleteFlag = 0
			AND bomd.DeleteFlag = 0
			AND 
			(
				(
					bom.Revision = 'HARDWARE' 
					AND tilTe.DoorStyleID <> 26
				)
				OR 
				(
					bom.Revision = 'HF HARDWAR' 
					AND tilTe.DoorStyleID = 26
				)
			)
			--AND tild.ComponentPartTypeId IN (25)
		)AS BOM
		WHERE til.ComponentPartTypeId IN(7, 9, 17, 29);

		--FF-341
		IF EXISTS
		(
			SELECT * FROM dbo.TranEntry AS te
			JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
			WHERE til.ProductID IN(497,498,499,606,607,608,610,611,612,613,614,615,616,617,618,660,661,749,777,778,779)
			AND te.ID = @orderItemId
		)
		BEGIN
		    INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity, WorkCenter, FunctionPart )
			VALUES('Remove', 'PLASTIC SHELF HOLDER', 0, 1, 'PICKING', 'PLASTIC SHELF HOLDER for ship shelf loose')
		END

		--FF-264
		INSERT @AddremoveRules(RuleId, AddRemoveAction, InventoryId, Quantity, QuantityAll, WorkCenter, FunctionPart)--replacements
		SELECT ir.RuleId, 'Remove',  ir.RemovePartAcumaticaName, ir.Quantity, 0, 'PICKING' , 'Replacements'
		FROM @itemReplace AS ir
		UNION ALL
		SELECT ir.RuleId, 'Add', ir.AddPartAcumaticaName, ir.Quantity, 0, 'PICKING', 'Replacements'
		FROM @itemReplace AS ir


		IF EXISTS(SELECT * FROM dbo.TranEntry AS te WHERE te.ID = @orderItemId AND te.BoxOnly = 1)
		BEGIN
			DELETE @AddremoveRules  WHERE InventoryId IN
			(
				SELECT ml.InventoryID 
				FROM @MaterialList ml
				JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
				OUTER APPLY
				(
					SELECT CAST( CASE WHEN EXISTS
					(
						SELECT * FROM dbo.TranEntry TE 
						JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
						WHERE TE.ID = @orderItemId 
						AND TIL.ProductID IN(413, 412)
					)THEN 1 ELSE 0 END AS BIT) AS IsLsb
				)AS IsLsb
				WHERE til.ComponentPartTypeId IN(11, 7, 17) 
				OR 
				(
					til.ComponentPartTypeId IN (9) 
					AND IsLsb.IsLsb = 0
				)
				OR
				(
					til.ComponentPartTypeId IN (23, 25)
					AND 
					(
						IsLsb.IsLsb = 0
						OR ml.InventoryID NOT IN('CSC','PLASTIC SHELF HOLDER','VSC')
						--OR NOT EXISTS
						--(
						--	SELECT * FROM acumaticaManufacturing.BillOfMaterials AS bom
						--	JOIN dbo.tb_ItemList AS tilShelf ON tilShelf.AcumaticaName = bom.InventoryID
						--	JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
						--	WHERE bom.DeleteFlag = 0
						--	AND bomd.DeleteFlag = 0
						--	AND tilShelf.ComponentPartTypeId = 9
						--	AND bomd.InventoryID = ml.InventoryID
						--)
					)
					
				)
			)

			INSERT INTO @AddremoveRules (AddRemoveAction, InventoryId, QuantityAll, Quantity)
			SELECT 'Remove', ml.InventoryID, 1, ml.Quantity 
			FROM @MaterialList ml
			JOIN dbo.tb_ItemList AS til ON ml.InventoryID = til.AcumaticaName
			OUTER APPLY
			(
				SELECT CAST( CASE WHEN EXISTS
				(
					SELECT * FROM dbo.TranEntry TE 
					JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = TE.ItemNumber
					WHERE TE.ID = @orderItemId 
					AND TIL.ProductID IN(413, 412)
				)THEN 1 ELSE 0 END AS BIT) AS IsLsb
			)AS IsLsb
			WHERE til.ComponentPartTypeId IN( 11, 7, 17) 
			OR 
			(
				til.ComponentPartTypeId IN (9) 
				AND IsLsb.IsLsb = 0
			)	
			OR
			(
				til.ComponentPartTypeId IN (23, 25)
				AND 
				(
					IsLsb.IsLsb = 0
					OR ml.InventoryID NOT IN('CSC','PLASTIC SHELF HOLDER','VSC')
					
					--NOT EXISTS
					--(
					--	SELECT * FROM acumaticaManufacturing.BillOfMaterials AS bom
					--	JOIN dbo.tb_ItemList AS tilShelf ON tilShelf.AcumaticaName = bom.InventoryID
					--	JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
					--	WHERE bom.DeleteFlag = 0
					--	AND bomd.DeleteFlag = 0
					--	AND tilShelf.ComponentPartTypeId = 9
					--	AND bomd.InventoryID = ml.InventoryID
					--)
				)
					
			)
				
			
		END
	RETURN
END

GO
/****** Object:  UserDefinedFunction [picking].[GetMaxPickDate]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 10/3/2019
-- Description:	Max Pick Date
-- =============================================
CREATE FUNCTION [picking].[GetMaxPickDate] ()
RETURNS DATE
AS
BEGIN
	DECLARE @dateForPlan DATE = GETDATE() +1

	SELECT  @dateForPlan = MAX(date.PickingDate) FROM (
	SELECT TOP (
		SELECT MAX(do.DaysOpen) DaysOpen FROM (
		SELECT MAX(COALESCE(b.DaysOpen,1)) DaysOpen FROM picking.Buckets b 

		) do ) apd.PickingDate FROM picking.AvailablePickingDates apd WHERE apd.PickingDate > GETDATE())  date


	RETURN @dateForPlan

END
GO
/****** Object:  UserDefinedFunction [picking].[GetNewPickingTasksItems]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Yakov Muller
-- Create date: 1/13/2017
-- Description:	Create PickingTasks
-- =============================================
CREATE FUNCTION [picking].[GetNewPickingTasksItems]
(
	@BucketID INT
)
RETURNS @PickingTaskCreation TABLE(

	[OrderID] [INT] NOT NULL,
	[ItemId] [INT] NOT NULL,
	[BucketId] [INT] NOT NULL,
	[Active] [BIT] NOT NULL,
	[AddTime] [DATETIME] NOT NULL,
	[UniqKey] [VARCHAR](500) NOT NULL,
	[EstimatedCompleteDate] [DATE] NOT NULL,
	[Style] [VARCHAR](50) NULL,
	[ItemCode] [NVARCHAR](150) NOT NULL,
	[ItemNumber] [VARCHAR](150) NOT NULL,
	[Cubicft] [FLOAT] NOT NULL,
	[EZProdID] [VARCHAR](25) NULL,
	[EZParentProdID] [VARCHAR](25) NULL,
	[SOnumber] [NVARCHAR](50) NULL,
	[CustomerName] [NVARCHAR](250) NOT NULL,
	[ItemType] [INT] NOT NULL,
	[ItemTypeCode] [INT] NULL,
	[PickDropLocationID] [INT] NULL,
	[PickingDate] [DATE] NULL,
	[RushOrder] [BIT] NOT NULL,
	[Hinge] [VARCHAR](50) NULL,
	[ItemKD] [BIT] NOT NULL,
	[Updated] [BIT] NULL,
	[AvailableToPick] BIT DEFAULT 1 NOT NULL,
	ParentItemId INT NULL
)
AS BEGIN
	
	DECLARE @localBucketID INT = @BucketID

	DECLARE @pickDate DATE;
	DECLARE @orderID INT;
	DECLARE @full BIT = 0;
	DECLARE @MaxBatchCubicFt INT = 100000;
	DECLARE @MaxBatchItems INT = 20000;
	DECLARE @timestamp DATETIME = GETDATE();	
	DECLARE @picktaskCount INT = 2;
	DECLARE @CurPicktaskCount INT = 0;
    DECLARE @MaxPickDate DATE = NULL;	
	DECLARE @itemcode VARCHAR(150);
	DECLARE @orderIDs IDList;
	DECLARE @DaysOpen INT;

	DECLARE @ordersForEta TABLE
	(
		OrderId INT,
		IsleNumeric INT,
		Section NVARCHAR(255),
		Location NVARCHAR(255),
		ShipVia NVARCHAR(50),
		SubUserDepartmentId INT,
		EstimatedCompleteDate DATE
	)

	DECLARE @batchItems TABLE
	(
		ItemCode NVARCHAR(255),
		CubicFtKD  [FLOAT],
		COUNT INT,
		Updated BIT,
		PickingDate DATE
	)

	SELECT @picktaskCount = COUNT(*) FROM picking.PickersBuckets pb JOIN picking.Pickers p ON p.PickerId = pb.PickerId AND p.Active =1  WHERE pb.BucketId = @localBucketID AND pb.Active =1 HAVING COUNT(*) > 0;	
	SELECT @CurPicktaskCount = COUNT(*) FROM picking.PickingTask pt WHERE pt.Active=1 AND pt.PickingTaskStatusId <>4 AND pt.BucketId =@localBucketID
	IF NOT @CurPicktaskCount > CASE WHEN @picktaskCount < 10 THEN 10 ELSE @picktaskCount END
			OR NOT EXISTS (SELECT 1 FROM picking.PickingTask pt WHERE pt.Active=1 AND pt.PickingTaskStatusId <>4 AND pt.BucketId =@localBucketID )
	BEGIN
	-- Every bucket has an OpenDays setting for how much picking days ahead are open including todays date (HB-1685)
	SELECT  @DaysOpen  = DaysOpen FROM picking.Buckets AS b WHERE b.BucketId = @localBucketID
	SELECT @MaxPickDate = MAX(d.PickingDate) FROM (SELECT TOP (@DaysOpen) apd.PickingDate FROM picking.AvailablePickingDates apd WHERE apd.PickingDate >=  CAST(GETDATE() AS DATE) ORDER BY apd.PickingDate) d


		SELECT  @pickDate = MIN(te.PickingDate)--, @Eta = MIN(o.EstimatedCompleteDate)
		FROM    picking.BucketItems bi
				JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1 AND te.PickingDate IS NOT NULL
				JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1 
				JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
				AND ( te.EZParentProdID IS NULL OR o.KD = 1  OR te.ItemType NOT IN(7) 
				OR EXISTS (SELECT * FROM dbo.TranEntry te2 WHERE te2.OrderID=o.OrderID AND te.EZParentProdID =te2.EZProdID AND te2.ItemNumber IN('CUSTOM ACCESSORY'))
				)
		WHERE   bi.BucketId = @localBucketID  AND (te.FWPONumber IS NULL OR te.FWPONumber ='')  AND bi.AssignedPickingTask IS NULL AND bi.Active = 1
		--sd-2983 sd pantry
				AND ( te.ItemType <> 2 OR te.KD =0 OR il.ItemSubTypeID = 18 OR DATEADD(HOUR,13,CAST(te.PickingDate AS datetime)) < GETDATE() )
				--sd-3331 Empire orders should only come in bet. 1 and 5 pm
				--AND (o.CustomerQbListID IS NULL OR o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE()) <= 16))
				AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
					WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))
				AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) 
				AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
		AND te.ItemType IN(1,2,3,7,12,14)
		AND (te.ItemType <> 2 OR te.KD = 0 OR o.ShipVia <> 'Pickup')
		AND te.PickingDate <= @MaxPickDate
		AND il.ItemCode = CASE WHEN il.ItemCode NOT LIKE 'PRIMA BIANCO:PB HGS%' THEN il.ItemCode 
				WHEN EXISTS(SELECT 1 FROM TranEntry tep WHERE tep.EZProdID = te.EZParentProdID AND te.orderid = tep.orderid AND ISNULL(tep.PickDropLoc ,'') <> 'C' ) 
				AND il.ItemCode LIKE 'PRIMA BIANCO:PB HGS%'  THEN  '' ELSE il.itemcode END
	
		IF EXISTS (SELECT 1 FROM picking.Buckets b WHERE b.BucketId = @localBucketID AND b.GroupByOrderNumber = 1 )
		BEGIN
			INSERT INTO @ordersForEta ( OrderId, IsleNumeric, Section, Location, ShipVia, SubUserDepartmentId,
			                             EstimatedCompleteDate )
			SELECT  o.ID OrderId, MIN(locations.IsleNumeric) IsleNumeric, MIN(locations.Section) Section, MIN(locations.Location) Location, MIN(o.ShipVia)  ShipVia , MIN(b.SubUserDepartmentId) SubUserDepartmentId
			,CAST( MIN(o.EstimatedCompleteDate) AS DATE) EstimatedCompleteDate
			--INTO    #ordersForEta
			FROM    picking.BucketItems bi
					JOIN picking.Buckets b ON b.BucketId = bi.BucketId
					JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
					JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1
					JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
					OUTER APPLY ( SELECT TOP 1 il2.IsleNumeric ,il2.Location ,il2.Warehouse ,
									CASE WHEN il2.Section IS NOT NULL AND ISNUMERIC(il2.Section) = 1 THEN CAST(il2.Section AS NUMERIC) ELSE 10000 END Section
						  FROM      dbo.InventoryLocationDefaultItemCode ildic
									JOIN dbo.InventoryLocation il2 ON il2.ID = ildic.LocationID AND il2.ExcludeFrmStock = 0 AND il2.IsPickable = 1 AND il2.IsActive =1
						  WHERE     ildic.ItemCode = il.ShortItemCode AND il.ItemTypeCode IN ( 1, 2, 3, 7 ) ORDER BY il2.Location
						) locations
			WHERE   bi.BucketId = @localBucketID
					AND bi.Active = 1  AND (te.FWPONumber IS NULL OR te.FWPONumber ='')
					AND te.PickingDate = @pickDate 
					AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
					--sd-2983 sd pantry
					AND ( te.ItemType <> 2 OR te.KD =0 OR il.ItemSubTypeID = 18 OR DATEADD(HOUR,13,CAST(te.PickingDate AS datetime)) < GETDATE() )
					--sd-3331 prime orders should only come in bet. 1 and 5 pm
					--AND (o.CustomerQbListID IS NULL OR o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE()) <= 16))
					AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14)  AND bi.AssignedPickingTask IS NULL
					AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
						WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))
					AND NOT EXISTS ( SELECT 1 FROM @pickingTaskCreation ti WHERE o.OrderID = ti.OrderID )
					AND (te.ItemType <> 2 OR te.KD = 0 OR o.ShipVia <> 'Pickup')
							AND il.ItemCode = CASE WHEN il.ItemCode NOT LIKE 'PRIMA BIANCO:PB HGS%' THEN il.ItemCode 
				WHEN EXISTS(SELECT 1 FROM TranEntry tep WHERE tep.EZProdID = te.EZParentProdID AND te.orderid = tep.orderid AND ISNULL(tep.PickDropLoc ,'') <> 'C' ) 
				AND il.ItemCode LIKE 'PRIMA BIANCO:PB HGS%'  THEN  '' ELSE il.itemcode END
					GROUP BY o.ID
					ORDER BY 2,3,4
                
			WHILE @full = 0
				AND EXISTS (SELECT TOP 1 1 FROM @ordersForEta o WHERE  NOT EXISTS ( SELECT 1 FROM @pickingTaskCreation ti WHERE  o.OrderId = ti.OrderID) )
			BEGIN
				SELECT TOP 1 @orderID = o.OrderId FROM @ordersForEta o WHERE NOT EXISTS ( SELECT 1 FROM   @pickingTaskCreation ti WHERE  o.OrderId = ti.OrderID ) 
					ORDER BY CASE WHEN o.SubUserDepartmentId = 13 AND o.ShipVia ='Pickup' THEN 0 ELSE 1 END,		
					 CASE WHEN o.SubUserDepartmentId = 13 AND o.ShipVia ='Common Carrier' THEN 0 ELSE 1 END,		
					 CASE WHEN o.SubUserDepartmentId = 13 AND o.ShipVia ='CC DIRECT TRUCK' THEN 0 ELSE 1 END,		
					 CASE WHEN o.SubUserDepartmentId = 13 AND o.ShipVia ='CC LOOSE TRAILER' THEN 0 ELSE 1 END,		
					 CASE WHEN o.SubUserDepartmentId = 13 AND o.ShipVia ='UPS' THEN 0 ELSE 1 END,		
					 CASE WHEN o.SubUserDepartmentId = 13 AND o.ShipVia ='Delivery' THEN 0 ELSE 1 END,
					 o.EstimatedCompleteDate ,
					  o.IsleNumeric, o.Section, o.OrderId;

				INSERT  INTO @pickingTaskCreation (OrderID ,ItemId ,BucketId ,Active ,AddTime ,UniqKey ,EstimatedCompleteDate ,
							Style, ItemCode,ItemNumber ,Cubicft ,EZProdID ,EZParentProdID ,SOnumber ,CustomerName ,ItemType ,
							ItemTypeCode ,PickDropLocationID ,PickingDate,RushOrder ,Hinge, ItemKD,Updated)
				SELECT  o.OrderID ,bi.ItemId ,bi.BucketId ,bi.Active ,bi.AddTime ,bi.UniqKey ,o.EstimatedCompleteDate ,te.Style ,il.ShortItemCode,
						te.ItemNumber ,il.CubicFtKD Cubicft ,te.EZProdID ,te.EZParentProdID ,o.SOnumber ,o.CustomerName ,
						te.ItemType ,il.ItemTypeCode ,bi.DropLocation,te.PickingDate, o.RushOrder, te.Hinge,te.KD ,0
				FROM    picking.BucketItems bi
						JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1						
						JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
						JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1
				WHERE   bi.BucketId = @localBucketID AND bi.Active = 1 AND te.PickingDate = @pickDate 
				--sd-2983 sd pantry
				AND ( te.ItemType <> 2 OR te.KD =0 OR il.ItemSubTypeID = 18 OR DATEADD(HOUR,13,CAST(te.PickingDate AS datetime)) < GETDATE() )
				--sd-3331 prime orders should only come in bet. 1 and 5 pm
				--AND (o.CustomerQbListID IS NULL OR o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE()) <= 16))
				AND o.OrderID = @orderID  AND (te.FWPONumber IS NULL OR te.FWPONumber ='')  AND bi.AssignedPickingTask IS NULL
				AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14) 
				AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
				AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
						WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))			
				AND (te.ItemType <> 2 OR te.KD = 0 OR o.ShipVia <> 'Pickup')
				--IL-253
				AND il.ItemCode = CASE WHEN il.ItemCode NOT LIKE 'PRIMA BIANCO:PB HGS%' THEN il.ItemCode 
				WHEN EXISTS(SELECT 1 FROM TranEntry tep WHERE tep.EZProdID = te.EZParentProdID AND te.orderid = tep.orderid AND ISNULL(tep.PickDropLoc ,'') <> 'C' ) 
				AND il.ItemCode LIKE 'PRIMA BIANCO:PB HGS%'  THEN  '' ELSE il.itemcode END

				IF @@ROWCOUNT = 0 OR EXISTS ( SELECT 1 FROM @pickingTaskCreation ti HAVING COUNT(*) > @MaxBatchItems OR SUM(ti.Cubicft) > @MaxBatchCubicFt )
				OR  ( EXISTS(SELECT 1 FROM picking.Buckets b WHERE b.BucketId = @localBucketID AND b.GroupByOrderNumber =1)
					 AND EXISTS(SELECT 1 FROM @pickingTaskCreation ti HAVING COUNT(DISTINCT ti.OrderID) + @CurPicktaskCount > CASE WHEN @picktaskCount < 10 THEN 10 ELSE @picktaskCount END ) )
				BEGIN
					SET @full = 1;
				END
			END
		END
		ELSE
		BEGIN
			INSERT INTO @orderIDs( ID )
			SELECT o.OrderID FROM picking.BucketItems bi
					JOIN picking.Buckets b ON b.BucketId = bi.BucketId
					JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
					JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1
					JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
			WHERE   bi.BucketId = @localBucketID
					AND bi.Active = 1  AND (te.FWPONumber IS NULL OR te.FWPONumber ='')
					AND te.PickingDate = @pickDate AND ISNULL(te.KDStyle,o.KD) =0
					AND te.DepartmentstatusID IN ( 6, 24, 57, 58  ) AND te.ItemType IN(1,2) AND il.ItemTypeCode IN(1,2) AND bi.AssignedPickingTask IS NULL 
					AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
					AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
						WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))	
						--sd-2983 sd pantry				
					AND ( te.ItemType <> 2 OR te.KD =0 OR il.ItemSubTypeID = 18 OR DATEADD(HOUR,13,CAST(te.PickingDate AS datetime)) < GETDATE() )
					--sd-3331 prime orders should only come in bet. 1 and 5 pm
					--AND (o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE()) <= 17))
					AND NOT EXISTS(SELECT 1 FROM @pickingTaskCreation ptc WHERE ptc.ItemId=bi.ItemId)
					AND (te.ItemType <> 2 OR te.KD = 0 OR o.ShipVia <> 'Pickup')
				GROUP BY o.OrderID HAVING COUNT(*)>=50

			IF EXISTS (SELECT 1 FROM @orderIDs)
			BEGIN
				INSERT  INTO @pickingTaskCreation ( OrderID ,ItemId ,BucketId ,Active ,AddTime ,UniqKey ,EstimatedCompleteDate ,
								Style, ItemCode,ItemNumber ,Cubicft ,EZProdID ,EZParentProdID ,SOnumber ,CustomerName ,ItemType ,
								ItemTypeCode ,PickDropLocationID ,PickingDate,RushOrder ,Hinge, ItemKD,Updated)
					SELECT  o.OrderID ,bi.ItemId ,bi.BucketId ,bi.Active ,bi.AddTime ,bi.UniqKey ,o.EstimatedCompleteDate ,te.Style ,il.ShortItemCode,
							te.ItemNumber ,il.CubicFtKD Cubicft ,te.EZProdID ,te.EZParentProdID ,o.SOnumber ,o.CustomerName ,
							te.ItemType ,il.ItemTypeCode ,bi.DropLocation,te.PickingDate, o.RushOrder, te.Hinge,te.KD ,0
					FROM    picking.BucketItems bi
							JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1							
							JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
							JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1
					WHERE   bi.BucketId = @localBucketID AND bi.Active = 1 AND te.PickingDate = @pickDate 
					AND o.OrderID IN(SELECT TOP 1 ID FROM @orderIDs)   
					AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
					AND (te.FWPONumber IS NULL OR te.FWPONumber ='')  AND bi.AssignedPickingTask IS NULL
					AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14)
					--sd-2983 sd pantry
					AND ( te.ItemType <> 2 OR te.KD =0 OR il.ItemSubTypeID = 18 OR DATEADD(HOUR,13,CAST(te.PickingDate AS datetime)) < GETDATE() )
					--sd-3331 prime orders should only come in bet. 1 and 5 pm
					--AND (o.CustomerQbListID IS NULL OR o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE()) <= 17))
					AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
							WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))	
					AND (te.ItemType <> 2 OR te.KD = 0 OR o.ShipVia <> 'Pickup')
					AND NOT EXISTS(SELECT * FROM @pickingTaskCreation ptc WHERE ptc.ItemId=bi.ItemId)
					--IL-253
					AND il.ItemCode = CASE WHEN il.ItemCode NOT LIKE 'PRIMA BIANCO:PB HGS%' THEN il.ItemCode 
					 WHEN EXISTS(SELECT 1 FROM TranEntry tep WHERE tep.EZProdID = te.EZParentProdID AND te.orderid = tep.orderid AND ISNULL(tep.PickDropLoc ,'') <> 'C')
					  AND il.ItemCode LIKE 'PRIMA BIANCO:PB HGS%'  THEN  '' ELSE il.itemcode END
				
			END
			ELSE
			BEGIN
			INSERT @batchItems ( ItemCode, CubicFtKD, COUNT, Updated, PickingDate )	
				SELECT il.ItemCode,SUM(il.CubicFtKD) CubicFtKD, COUNT(*) COUNT ,  CAST(0 AS BIT) AS updated , MIN(te.PickingDate)PickingDate
				FROM    picking.BucketItems bi
						JOIN picking.Buckets b ON b.BucketId = bi.BucketId
						JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
						JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1
						JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
				WHERE   bi.BucketId = @localBucketID
						AND bi.Active = 1  AND (te.FWPONumber IS NULL OR te.FWPONumber ='')
						AND te.PickingDate = @pickDate 
						AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
						AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14)  AND bi.AssignedPickingTask IS NULL
						--sd-2983 sd pantry
						AND ( te.ItemType <> 2 OR te.KD =0 OR il.ItemSubTypeID = 18 OR DATEADD(HOUR,13,CAST(te.PickingDate AS datetime)) < GETDATE() )
						--sd-3331 prime orders should only come in bet. 1 and 5 pm
						--AND (o.CustomerQbListID IS NULL OR o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE()) <= 16))
						AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
							WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))
						AND NOT EXISTS(SELECT 1 FROM @pickingTaskCreation ptc WHERE ptc.ItemId=bi.ItemId)
						AND (te.ItemType <> 2 OR te.KD = 0 OR o.ShipVia <> 'Pickup')
						GROUP BY il.ItemCode
						--ORDER BY  COUNT DESC,CubicFtKD DESC 
			
				WHILE @full =0 AND EXISTS( SELECT * FROM @batchItems ofe WHERE ofe.updated =0)
				BEGIN      
					SELECT TOP 1 @itemcode = itemcode FROM @batchItems bi WHERE bi.updated =0 ORDER BY bi.COUNT DESC , bi.CubicFtKD DESC

					UPDATE @batchItems SET updated =1 WHERE ItemCode =@itemcode

					INSERT INTO @orderIDs( ID )
					SELECT  DISTINCT o.OrderID 
						FROM    picking.BucketItems bi
								JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
								JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
								JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1
						WHERE   bi.BucketId = @localBucketID AND bi.Active = 1 AND te.PickingDate = @pickDate 
						AND te.ItemNumber = @itemcode  AND (te.FWPONumber IS NULL OR te.FWPONumber ='')  AND bi.AssignedPickingTask IS NULL
						AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14) 
						AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
						--sd-2983 sd pantry
						AND ( te.ItemType <> 2 OR te.KD =0 OR il.ItemSubTypeID = 18 OR DATEADD(HOUR,13,CAST(te.PickingDate AS datetime)) < GETDATE() )
						--sd-3331 prime orders should only come in bet. 1 and 5 pm
						--AND (o.CustomerQbListID IS NULL OR o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE()) <= 16))
						AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
								WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))			
						AND (te.ItemType <> 2 OR te.KD = 0 OR o.ShipVia <> 'Pickup')					
						AND NOT EXISTS(SELECT 1 FROM @pickingTaskCreation ptc WHERE ptc.ItemId=bi.ItemId)
					IF @@ROWCOUNT = 0
					BEGIN
						CONTINUE
					END

					INSERT  INTO @pickingTaskCreation ( OrderID ,ItemId ,BucketId ,Active ,AddTime ,UniqKey ,EstimatedCompleteDate ,
									Style, ItemCode,ItemNumber ,Cubicft ,EZProdID ,EZParentProdID ,SOnumber ,CustomerName ,ItemType ,
									ItemTypeCode ,PickDropLocationID ,PickingDate,RushOrder ,Hinge, ItemKD,Updated)
						SELECT  o.OrderID ,bi.ItemId ,bi.BucketId ,bi.Active ,bi.AddTime ,bi.UniqKey ,o.EstimatedCompleteDate ,te.Style ,il.ShortItemCode,
								te.ItemNumber ,il.CubicFtKD Cubicft ,te.EZProdID ,te.EZParentProdID ,o.SOnumber ,o.CustomerName ,
								te.ItemType ,il.ItemTypeCode ,bi.DropLocation,te.PickingDate, o.RushOrder, te.Hinge,te.KD ,0
						FROM    picking.BucketItems bi
								JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1								
								JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
								JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1
						WHERE   bi.BucketId = @localBucketID AND bi.Active = 1 AND te.PickingDate = @pickDate 
						AND o.OrderID IN(SELECT oid.ID FROM @orderIDs oid)  
						AND (te.FWPONumber IS NULL OR te.FWPONumber ='')  AND bi.AssignedPickingTask IS NULL 
						AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
						AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14)
						--sd-2983 sd pantry
						AND ( te.ItemType <> 2 OR te.KD =0 OR il.ItemSubTypeID = 18 OR DATEADD(HOUR,13,CAST(te.PickingDate AS datetime)) < GETDATE() )
						--sd-3331 prime orders should only come in bet. 1 and 5 pm
						--AND (o.CustomerQbListID IS NULL OR  o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE()) <= 16))
						AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
								WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))	
						AND (te.ItemType <> 2 OR te.KD = 0 OR o.ShipVia <> 'Pickup')
						AND NOT EXISTS(SELECT * FROM @pickingTaskCreation ptc WHERE ptc.ItemId=bi.ItemId)
						--IL-253
						AND il.ItemCode =  CASE WHEN il.ItemCode NOT LIKE 'PRIMA BIANCO:PB HGS%' THEN il.ItemCode 
						WHEN EXISTS(SELECT 1 FROM TranEntry tep WHERE tep.EZProdID = te.EZParentProdID AND te.orderid = tep.orderid AND ISNULL(tep.PickDropLoc ,'') <> 'C')
						 AND il.ItemCode LIKE 'PRIMA BIANCO:PB HGS%' THEN  '' ELSE il.itemcode END						
						

					IF @@ROWCOUNT = 0 OR EXISTS ( SELECT 1 FROM @pickingTaskCreation ti HAVING COUNT(*) > @MaxBatchItems OR SUM(ti.Cubicft) > @MaxBatchCubicFt )
					BEGIN
						SET @full = 1;
					END
					DELETE FROM @orderIDs		
				END
			END
		END
		INSERT INTO @PickingTaskCreation ( OrderID, ItemId, BucketId, Active, AddTime, UniqKey, EstimatedCompleteDate, Style,
	                                    ItemCode, ItemNumber, Cubicft, EZProdID, EZParentProdID, SOnumber, CustomerName,
	                                    ItemType, ItemTypeCode, PickDropLocationID, PickingDate, RushOrder, Hinge, ItemKD,
	                                    Updated, AvailableToPick, ParentItemId )	
			SELECT ti.OrderID, te.ID, ti.BucketId, ti.Active, ti.AddTime, ti.UniqKey, ti.EstimatedCompleteDate, ti.Style,
				il.ItemCode, te.ItemNumber, il.CubicFtKD, te.EZProdID, te.EZParentProdID, ti.SOnumber, ti.CustomerName,
				te.ItemType, il.ItemTypeCode, ti.PickDropLocationID, ti.PickingDate, ti.RushOrder, ti.Hinge, ti.ItemKD,
				ti.Updated, 0, ti.ItemId FROM @PickingTaskCreation  ti 
			JOIN dbo.TranEntry te2 ON te2.ID=ti.ItemId
			JOIN dbo.TranEntry te ON te.OrderID = ti.OrderID AND te.EZParentProdID = ti.EZProdID
			AND ( te.EZProdSubID = te2.EZProdSubID  OR te.ItemNumber NOT IN('ACCESSORIES:LST33','ACCESSORIES:LST36') )
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber 
			AND ( te.ItemType <> 4 AND ( te.ItemType <> 3 OR EXISTS ( SELECT 1 FROM dbo.tb_itemClassDetail ic  WHERE  ic.ItemCode = il.ShortItemCode AND  te.ItemNumber = il.ItemCode AND ic.ClassID = 50 ) ) )
					AND NOT EXISTS ( SELECT 1 FROM dbo.tb_itemClassDetail ic WHERE  ic.ItemCode = il.ShortItemCode AND  te.ItemNumber = il.ItemCode AND ic.ClassID = 45 )

			WHERE ( te.FWPONumber IS NULL OR te.FWPONumber ='' ) AND te.isDeleted =0 AND te.isActive =1  AND te.ItemType =7 
			AND NOT EXISTS (SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId AND pt.Active =1 WHERE ptd.ItemId=te.ID AND ptd.Active=1 AND pt.PickingTaskStatusId <> 4 )

	END
	RETURN
END




















GO
/****** Object:  UserDefinedFunction [picking].[GetPastDueforBucket]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [picking].[GetPastDueforBucket]
(	
	@bucketId INT,
	@date DATE,
	@period VARCHAR(50)
)
RETURNS 
@PastDueforBucket TABLE
(
	OrderNumber NVARCHAR(50) NOT NULL,
	ItemId INT NOT NULL,
	ItemCode NVARCHAR(150) NOT NULL,
	ItemStatus NVARCHAR(150) NOT NULL,
	AssignedPickingTask INT NULL,
	DefaultLocation NVARCHAR(255) NULL,
	PickingDate DATE NULL,
	StatusId INT NOT NULL,
	BucketId INT NOT NULL
)
AS
BEGIN

	DECLARE @items TABLE (OrderNumber NVARCHAR(50) NOT NULL, ItemId INT NOT NULL, ItemCode NVARCHAR(150) NOT NULL, ItemStatus NVARCHAR(150) NOT NULL, PickingDate DATE NULL, StatusId INT NOT NULL , ItemType INT NOT NULL ,
		 OrderStatusId INT NOT NULL, KD BIT NOT NULL, ShipVia NVARCHAR(50))

	INSERT @items( OrderNumber, itemId, ItemCode,ItemStatus, PickingDate, StatusId , ItemType , OrderStatusId, KD , ShipVia)
	SELECT o.SOnumber, te.ID,til.ShortItemCode,d2.Status, te.PickingDate , d2.ID , te.ItemType, d.ID , te.KD, o.ShipVia FROM dbo.TranEntry AS te 
	JOIN dbo.[Order] AS o ON o.ID = te.OrderID AND o.IsActive =1
	--JOIN picking.BucketItems AS bi ON bi.ItemId = te.ID AND bi.Active =1
	JOIN dbo.Departmentstatus AS d ON d.ID = o.Departmentstatusid AND d.isShipped =0 AND d.StatusStageId NOT IN(5,6)
	JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
	JOIN dbo.Departmentstatus AS d2 ON d2.ID = te.DepartmentstatusID 
	WHERE te.isActive =1 --AND o.IsActive =1 AND te.isDeleted =0 
	AND te.FWPONumber IS NULL AND (TE.EZParentProdID IS NULL OR TE.ItemType = 3)
	AND te.DepartmentstatusID NOT IN(244,95,420,40,381,10,11)
	AND EXISTS (SELECT * FROM picking.BucketItems AS bi WHERE bi.BucketId=@bucketId AND bi.Active=1 AND bi.ItemId=te.ID)


INSERT @PastDueforBucket(OrderNumber,ItemId,ItemCode,ItemStatus,AssignedPickingTask,DefaultLocation,PickingDate,StatusId,BucketId)
	SELECT i.OrderNumber,i.ItemId,i.ItemCode,i.ItemStatus,pt.PickingTaskId,loc.DefaultLocation,i.PickingDate,i.StatusId , @bucketId	FROM @items AS i
	
	OUTER APPLY(SELECT TOP 1 ptd.ItemId , pt.PickingTaskStatusId, pt.PickingTaskId
		FROM picking.PickingTask pt 
		JOIN picking.PickingTaskDetail ptd ON ptd.Active =1 AND ptd.Picked =0 AND pt.PickingTaskId = ptd.PickingTaskId 
		WHERE  pt.BucketId = @bucketId AND pt.Active=1 AND pt.PickingTaskStatusId <> 4  AND ptd.ItemId = i.ItemId  ORDER BY ptd.PickingTaskDetailId DESC
		) pt
	OUTER APPLY (SELECT TOP 1 il.Location AS DefaultLocation FROM dbo.InventoryLocationDefaultItemCode AS ildic 
	JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID
	WHERE i.ItemCode = ildic.ItemCode) loc
	WHERE
	 ( pt.ItemId IS NOT NULL OR EXISTS (SELECT * FROM picking.BucketItems bi WHERE bi.BucketId = @bucketId AND bi.ItemId = i.ItemId AND bi.Active =1 AND bi.AssignedPickingTask IS NULL) )
	AND ((@period = 'equal' AND i.PickingDate = @date)
	OR (@period = 'less than or equal' AND i.PickingDate <= @date)
	OR (@period = 'greater than or equal' AND i.PickingDate >= @date)
	OR (@period = 'less than' AND i.PickingDate < @date)
	OR (@period = 'greater than' AND i.PickingDate > @date)
	)


	RETURN



END





GO
/****** Object:  UserDefinedFunction [picking].[GetPiPickingTasks]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron Steinmetz>
-- Create date: <9-18-2019>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [picking].[GetPiPickingTasks]
(
	@page INT,
	@pageSize INT,
	@pickingType INT,
	@statusId INT = NULL,
	@createdDate DATETIME = NULL,
	@destinationLocationId INT = NULL,
	@bucketId INT = NULL,
	@searchText VARCHAR(50) = NULL
)
RETURNS @returnVal TABLE
(
	RowNumber INT NOT NULL,
	PickingTaskProductionItemsId INT NOT NULL,
	AddedOn DATETIME NOT NULL,	
	DestinationLocationId INT NOT NULL,
	DestinationLocationName VARCHAR(50) NOT NULL,
	FirstName VARCHAR(50) NULL,
	LastName VARCHAR(50) NULL,
	UserName VARCHAR(50) NULL,
	AddedBy VARCHAR(50) NULL,
	UserId NVARCHAR(128) NULL,
	AmountOfPieces INT NOT NULL,
	PickingTypeId INT NOT NULL,
	PickingTypeName VARCHAR(50) NOT NULL,
	ProductionItemsPickingTaskStatusId INT NOT NULL,
	StatusName VARCHAR(50) NOT NULL
)
AS   
BEGIN	 
 --   IF @searchText IS NOT NULL
	--BEGIN
	--	IF LEFT(@searchText, 2) = 'pi' AND ISNUMERIC(SUBSTRING(@searchText, 3, 100)) = 1
	--	BEGIN
	--	    SET @searchText = SUBSTRING(@searchText, 3, 100) + '%'
	--	END
	--	ELSE
	--	BEGIN
	--	    SET @searchText = @searchText
	--	END	   
	--END;
	DECLARE @date DATE = NULL;
	IF @createdDate IS NOT NULL 
	BEGIN
	    SET @date = CAST(@createdDate AS DATE)
	END;
	
	WITH Tasks AS 
	(SELECT ptpi.PickingTaskProductionItemsId, ptpi.AddedOn,CASE WHEN @pickingType NOT IN(4) THEN pi.DestinationLocationId ELSE 6 END AS DestinationLocationId,CASE WHEN @pickingType NOT IN(4) THEN pi.DestinationLocationName ELSE 'Pantries Addons' END AS DestinationLocationName, anu.FirstName, anu.LastName, 
	anu.UserName, anuAdded.UserName as AddedBy, anu.Id, details.AmountOfPieces, ptpi.PickingTypeId, pt.Name, ptpi.ProductionItemsPickingTaskStatusId, ptpis.Status
	, ROW_NUMBER() OVER (ORDER BY
		CASE WHEN ptpi.ProductionItemsPickingTaskStatusId NOT IN(4) THEN 0 ELSE 1 END, 
		ptpi.AddedOn DESC, 
		ptpi.PickingTaskProductionItemsId DESC) AS RowNumber
	FROM  picking.PickingTaskProductionItems AS ptpi
	JOIN picking.PickingType AS pt ON pt.PickingTypeId = ptpi.PickingTypeId
	LEFT JOIN dbo.AspNetUsers AS anuAdded ON anuAdded.Id = ptpi.AddedBy
	LEFT JOIN dbo.AspNetUsers AS anu ON anu.Id = ptpi.Picker
	JOIN picking.PickingTaskProductionItemsStatus AS ptpis ON ptpis.ProductionItemsPickingTaskStatusId = ptpi.ProductionItemsPickingTaskStatusId
	CROSS APPLY(SELECT TOP (1) pi.DestinationLocationId, dl.DestinationLocationName, pi.ItemlistId
		FROM picking.PickingTaskProductionItemsDetail AS ptpid 
		JOIN Picking.ProductionItem AS pi ON pi.ProductionItemId = ptpid.ProductionItemId
		JOIN picking.DestinationLocation AS dl ON dl.DestinationLocationId = pi.DestinationLocationId	
		WHERE ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId)pi
	CROSS APPLY(SELECT COUNT(*)AS AmountOfPieces FROM picking.PickingTaskProductionItemsDetail AS ptpid2
	WHERE ptpid2.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId AND ptpid2.Active = 1 HAVING COUNT(*) > 0)details
	WHERE ptpi.Active = 1
	AND 
	(
	(ptpi.ProductionItemsPickingTaskStatusId = @statusId OR @statusId IS NULL)
	AND(CAST(ptpi.AddedOn AS DATE) = @date OR @date IS NULL)
	AND(pi.DestinationLocationId = @destinationLocationId OR @destinationLocationId IS NULL)
	AND (ptpi.BucketProductionItemsId = @bucketId OR @bucketId IS NULL)
	AND(ptpi.PickingTypeId = @pickingType OR @pickingType IS NULL)
	AND
	(
		CAST(ptpi.PickingTaskProductionItemsId AS VARCHAR(20)) = @searchText
		OR anu.FirstName LIKE @searchText + '%'
		OR anu.LastName LIKE @searchText + '%'
		OR anu.UserName LIKE @searchText + '%'
				--OR EXISTS(SELECT * FROM dbo.tb_ItemList AS til WHERE pi.ItemlistId = til.ID AND til.ShortItemCode LIKE '%' + @searchText + '%')
			OR EXISTS(SELECT 1 FROM picking.PickingTaskProductionItemsDetail AS ptpid 
				JOIN Picking.ProductionItem AS pi2 ON pi2.ProductionItemId = ptpid.ProductionItemId	
				JOIN Picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi2.ProductionItemId AND pid.Deleted = 0
				WHERE ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId 
				AND (pi2.PIId = @searchText OR CAST(pi2.OrderItemId AS VARCHAR(50)) = @searchText))
		 OR @searchText IS NULL
	 )
	 )
	)
	
INSERT @returnVal
(
    RowNumber,
    PickingTaskProductionItemsId,
    AddedOn,
    DestinationLocationId,
    DestinationLocationName,
    FirstName,
    LastName,
    UserName,
	AddedBy,
	UserId,
    AmountOfPieces,
    PickingTypeId,
    PickingTypeName,
    ProductionItemsPickingTaskStatusId,
    StatusName
)
SELECT CAST(Tasks.RowNumber AS INT) RowNumber,
Tasks.PickingTaskProductionItemsId, Tasks.AddedOn, Tasks.DestinationLocationId, Tasks.DestinationLocationName, Tasks.FirstName, Tasks.LastName, Tasks.UserName, Tasks.AddedBy,
Tasks.Id, Tasks.AmountOfPieces, Tasks.PickingTypeId, Tasks.Name, Tasks.ProductionItemsPickingTaskStatusId, Tasks.Status
FROM Tasks 
WHERE Tasks.RowNumber > ((@page -1) * @pageSize) AND Tasks.RowNumber <= ( (@page -1) * @pageSize ) + @pageSize
 
RETURN
END





GO
/****** Object:  UserDefinedFunction [picking].[GetPiPickingTasksNew]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron Steinmetz>
-- Create date: <9-18-2019>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [picking].[GetPiPickingTasksNew]
(
	@page INT,
	@pageSize INT,
	@pickingType INT,
	@statusIds IDList READONLY,
	@createdDate DATETIME = NULL,
	@destinationLocationIds IDList READONLY,
	@bucketId INT = NULL,
	@searchText VARCHAR(50) = NULL,
	@DevMode BIT = NULL
)
RETURNS @returnVal TABLE
(
	RowNumber INT NOT NULL,
	PickingTaskProductionItemsId INT NOT NULL,
	AddedOn DATETIME NOT NULL,	
	DestinationLocationId INT NOT NULL,
	DestinationLocationName VARCHAR(50) NOT NULL,
	FirstName VARCHAR(50) NULL,
	LastName VARCHAR(50) NULL,
	UserName VARCHAR(50) NULL,
	AddedBy VARCHAR(50) NULL,
	UserId NVARCHAR(128) NULL,
	AmountOfPieces INT NOT NULL,
	PickingTypeId INT NOT NULL,
	PickingTypeName VARCHAR(50) NOT NULL,
	ProductionItemsPickingTaskStatusId INT NOT NULL,
	StatusName VARCHAR(50) NOT NULL
)
AS   
BEGIN	 

	DECLARE @date DATE = NULL;
	IF @createdDate IS NOT NULL 
	BEGIN
	    SET @date = CAST(@createdDate AS DATE)
	END;
	
	WITH Tasks AS 
	(
	SELECT ptpi.PickingTaskProductionItemsId, ptpi.AddedOn,CASE WHEN @pickingType NOT IN(4) THEN pi.DestinationLocationId ELSE 6 END AS DestinationLocationId,CASE WHEN @pickingType NOT IN(4) THEN pi.DestinationLocationName ELSE 'Pantries Addons' END AS DestinationLocationName, anu.FirstName, anu.LastName, 
	anu.UserName, anuAdded.UserName as AddedBy, anu.Id, details.AmountOfPieces, ptpi.PickingTypeId, pt.Name, ptpi.ProductionItemsPickingTaskStatusId, ptpis.Status
	, ROW_NUMBER() OVER (ORDER BY
		CASE WHEN ptpi.ProductionItemsPickingTaskStatusId NOT IN(4) THEN 0 ELSE 1 END, 
		ptpi.AddedOn DESC, 
		ptpi.PickingTaskProductionItemsId DESC) AS RowNumber
	FROM  picking.PickingTaskProductionItems AS ptpi
	JOIN picking.PickingType AS pt ON pt.PickingTypeId = ptpi.PickingTypeId
	LEFT JOIN dbo.AspNetUsers AS anuAdded ON anuAdded.Id = ptpi.AddedBy
	LEFT JOIN dbo.AspNetUsers AS anu ON anu.Id = ptpi.Picker
	JOIN picking.PickingTaskProductionItemsStatus AS ptpis ON ptpis.ProductionItemsPickingTaskStatusId = ptpi.ProductionItemsPickingTaskStatusId
	CROSS APPLY
	(
		SELECT TOP (1) pi.DestinationLocationId, dl.DestinationLocationName, pi.ItemlistId
		FROM picking.PickingTaskProductionItemsDetail AS ptpid 
		JOIN Picking.ProductionItem AS pi ON pi.ProductionItemId = ptpid.ProductionItemId
		JOIN picking.DestinationLocation AS dl ON dl.DestinationLocationId = pi.DestinationLocationId	
		WHERE ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId
		AND 
		(
			@DevMode IS NULL
			OR pi.Sandbox = @DevMode
			
		) 
	)pi
	CROSS APPLY(SELECT COUNT(*)AS AmountOfPieces FROM picking.PickingTaskProductionItemsDetail AS ptpid2
	WHERE ptpid2.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId AND ptpid2.Active = 1 HAVING COUNT(*) > 0)details
	WHERE ptpi.Active = 1
	AND 
	(
	(ptpi.ProductionItemsPickingTaskStatusId IN(SELECT ID FROM @statusIds) OR (NOT EXISTS (SELECT * FROM @statusIds AS i)))
	AND(CAST(ptpi.AddedOn AS DATE) = @date OR @date IS NULL)
	AND(pi.DestinationLocationId IN(SELECT ID FROM @destinationLocationIds) OR (NOT EXISTS (SELECT * FROM @destinationLocationIds AS i)))
	AND (ptpi.BucketProductionItemsId = @bucketId OR @bucketId IS NULL)
	AND(ptpi.PickingTypeId = @pickingType OR @pickingType IS NULL)
	AND
	(
		CAST(ptpi.PickingTaskProductionItemsId AS VARCHAR(20)) = @searchText
		OR anu.FirstName LIKE @searchText + '%'
		OR anu.LastName LIKE @searchText + '%'
		OR anu.UserName LIKE @searchText + '%'
				--OR EXISTS(SELECT * FROM dbo.tb_ItemList AS til WHERE pi.ItemlistId = til.ID AND til.ShortItemCode LIKE '%' + @searchText + '%')
			OR EXISTS(SELECT 1 FROM picking.PickingTaskProductionItemsDetail AS ptpid 
				JOIN Picking.ProductionItem AS pi2 ON pi2.ProductionItemId = ptpid.ProductionItemId	
				JOIN Picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi2.ProductionItemId AND pid.Deleted = 0
				WHERE ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId 
				AND (pi2.PIId = @searchText OR CAST(pi2.OrderItemId AS VARCHAR(50)) = @searchText))
		 OR @searchText IS NULL
		 OR @searchText = ''
	 )
	 )
	)
	
INSERT @returnVal
(
    RowNumber,
    PickingTaskProductionItemsId,
    AddedOn,
    DestinationLocationId,
    DestinationLocationName,
    FirstName,
    LastName,
    UserName,
	AddedBy,
	UserId,
    AmountOfPieces,
    PickingTypeId,
    PickingTypeName,
    ProductionItemsPickingTaskStatusId,
    StatusName
)
SELECT CAST(Tasks.RowNumber AS INT) RowNumber,
Tasks.PickingTaskProductionItemsId, Tasks.AddedOn, Tasks.DestinationLocationId, Tasks.DestinationLocationName, Tasks.FirstName, Tasks.LastName, Tasks.UserName, Tasks.AddedBy,
Tasks.Id, Tasks.AmountOfPieces, Tasks.PickingTypeId, Tasks.Name, Tasks.ProductionItemsPickingTaskStatusId, Tasks.Status
FROM Tasks 
WHERE Tasks.RowNumber > ((@page -1) * @pageSize) AND Tasks.RowNumber <= ( (@page -1) * @pageSize ) + @pageSize
 
RETURN
END







GO
/****** Object:  UserDefinedFunction [picking].[GetPIResetModel_FF_590]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [picking].[GetPIResetModel_FF_590]
(
	@piid INT
)
RETURNS @retVal TABLE(ProductionItemId INT, PIId VARCHAR(50), PIItemCode NVARCHAR(150), Status VARCHAR(50), SN VARCHAR(50), ProductionItemDetailId INT, PiDetailId VARCHAR(50),
	PIDItemCode NVARCHAR(150), AbnSn VARCHAR(50), CanExpand BIT, isInResetStatus BIT, HasPo BIT, TeStatus NVARCHAR(150)) 
AS
BEGIN
	INSERT @retVal(ProductionItemId, PIId, PIItemCode, Status, SN, ProductionItemDetailId, PiDetailId, PIDItemCode, AbnSn, CanExpand, isInResetStatus, HasPo, TeStatus)
		SELECT pi.ProductionItemId, pi.PIId, til2.ShortItemCode AS PIItemCode, pis.Status, tis2.SerielID as SN,
        pid.ProductionItemDetailId, pid.PiDetailId, til.ShortItemCode AS PIDItemCode, COALESCE(tabn.ABNNumber, tis3.SerielID) AS AbnSn, cbe.CanExpand,
		isInResetStatus.IsInResetStatus  ,
        CAST(CASE WHEN te.FWPONumber IS NULL then 0 ELSE 1 END AS BIT) HasPo,
        d.Status AS	TeStatus
        FROM  picking.ProductionItem AS pi
        JOIN picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi.ProductionItemId AND pid.Deleted = 0
        JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
        JOIN dbo.tb_ItemList AS til2 ON til2.ID = pi.ItemlistId
        JOIN picking.ProductionItemStatus AS pis ON pis.ProductionItemStatusId = pi.ProductionItemStatusId
        JOIN dbo.TranEntry AS te ON te.ID = pi.OrderItemId
        JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		CROSS APPLY
		(
			SELECT CAST
			(
				CASE WHEN EXISTS 
				(
					SELECT * FROM picking.PiResetItem AS pri
					WHERE pri.OrderItemId = te.ID
					AND pri.Deleted = 0
					AND pri.PiResetStatusId <> 2
				) THEN 1 ELSE 0 END AS BIT
			)
		)AS isInResetStatus(IsInResetStatus)
        LEFT JOIN dbo.tb_AccBoxNumberItems AS tabni ON tabni.ProductionItemDetailId = pid.ProductionItemDetailId
        LEFT JOIN dbo.tb_AccBoxNumber AS tabn ON tabni.ABNID = tabn.ID
        LEFT JOIN dbo.tb_ItemSeriel AS tis2 ON tis2.ProductionItemId = pi.ProductionItemId
        LEFT JOIN dbo.tb_ItemSeriel AS tis3 ON tis3.TranEntryID = te.ID
        CROSS APPLY
        (
        SELECT CAST( CASE WHEN EXISTS
        (
	        SELECT * FROM acumaticaManufacturing.BillOfMaterials AS bom 
	        JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
			JOIN dbo.Numbers AS n ON n.Number <=bomd.QtyRequired
	        WHERE til.AcumaticaName = bom.InventoryID
	        AND bom.Revision <> 'HARDWARE' AND bom.DeleteFlag  = 0 AND bom.Status = 'Active'
	        GROUP BY bom.BOMID HAVING COUNT(*) > 1
        )
        THEN 1 ELSE 0 END AS BIT
        )AS CanExpand
        )AS cbe
        WHERE pi.ProductionItemId = @piid 
        AND 
        (
	        pid.Picked =1 
	        OR
	        (
		        pid.PickingTypeId IN(7, 13)
		        AND te.FWPONumber IS NOT NULL
	        )
        )

		UPDATE t SET AbnSn = ISNULL(t.AbnSn, tis.SerielID)
		FROM @retVal AS t
		JOIN dbo.tb_ItemSeriel AS tis ON tis.ProductionItemDetailId = t.ProductionItemDetailId
       
	    RETURN             
END
GO
/****** Object:  UserDefinedFunction [picking].[GetProductionItemLocationFromOrderMaterialDetail]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[GetProductionItemLocationFromOrderMaterialDetail]
(
    @OrderItemProductionItemIReleaseId AS INT,
    @OrderMaterialDetail OrderMaterialDetail READONLY   
)
RETURNS @ProductionItemLocations TABLE
(
    DestinationLocationId INT,
    ProductionItemLocationId INT
)
AS
BEGIN
    DECLARE @OrderMaterialDetail2 OrderMaterialDetail
    IF NOT EXISTS (SELECT * FROM @OrderMaterialDetail AS omd)
    BEGIN
        INSERT @OrderMaterialDetail2
        (
            InventoryID, Quantity
        )
            SELECT asi.Name, COUNT(*) AS Quantity FROM Picking.ProductionItemDetail AS pid
            JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
            JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = til.AcumaticaID
            JOIN Picking.ProductionItem AS pi ON pid.ProductionItemId = pi.ProductionItemId
            JOIN picking.OrderItemProductionItemIRelease AS oipiir ON oipiir.OrderItemId = pi.OrderItemId
            WHERE oipiir.OrderItemProductionItemIReleaseId = @OrderItemProductionItemIReleaseId
            AND pi.Deleted = 0
            GROUP BY asi.Name
    END
    ELSE
    BEGIN
        INSERT @OrderMaterialDetail2
        (
            InventoryID, Quantity
        )
            SELECT omd.InventoryID, omd.Quantity 
            FROM @OrderMaterialDetail AS omd
    END

    INSERT @ProductionItemLocations ( DestinationLocationId, ProductionItemLocationId )
    SELECT
    CASE 
            WHEN  oipiir.Revision = 'A' THEN  19  
            WHEN oipiir.sandbox = 0 THEN COALESCE(detailDestinationRule.DestinationLocationId, dlir.DestinationLocationId, 1)
            ELSE COALESCE(detailDestinationRule.SandboxDestinationLocationId, dlir.SandboxDestinationLocationId, 1)
            --WHEN te.ItemType =2  THEN  5
            END,
        CASE 
			WHEN te.ItemType = 3 AND te.OrderIdentity LIKE 'RMA%' THEN 30
            WHEN oipiir.Revision = 'A' THEN  10    
            WHEN dlir.DestinationLocationId IN(32,33,34,35) AND te.PickDropLoc = 'C' THEN  23 
            WHEN dlir.DestinationLocationId IN(32,33,34,35) AND te.PickDropLoc = 'F' THEN  24  
			WHEN ctc.CarcassToCust = 1 THEN 27 --CustomShop FF-719
			-- commented out on 4/14/2021 as per Mendy Gruber WHEN ModsHandledWithBom.PiLocation IS NOT NULL THEN ModsHandledWithBom.PiLocation 
            --WHEN ctc.CarcassToCust = 1 THEN CASE WHEN otherMod.OtherMod = 1 THEN 27 ELSE 1 END --CustomShop
            WHEN mrule.ProductionItemLocationTypeId IS NOT NULL THEN  mrule.ProductionItemLocationTypeId			
            WHEN PILO.ProductionItemLocationType IS NOT NULL THEN PILO.ProductionItemLocationType
            WHEN te.KD = 1 THEN 26      
            WHEN te.PickDropLoc = 'F' THEN 28 --Finishing			
            WHEN te.PickDropLoc = 'C' OR fhd.fhdDol IS NOT NULL THEN 27 --CustomShop
            WHEN te.PickDropLoc = 'A' THEN 1 --Unpacking
            ELSE 1 END ProductionItemLocationTypeId
    FROM dbo.TranEntry te
        JOIN picking.OrderItemProductionItemIRelease oipiir ON oipiir.OrderItemId = te.ID
        JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
        LEFT JOIN picking.ProductionItemLocationOverides PILO ON PILO.ItemListId = il.ID AND PILO.Revision = oipiir.Revision
        CROSS APPLY
        (
            SELECT CAST(CASE WHEN EXISTS
            (
                SELECT * FROM dbo.TranEntry te2 
                WHERE te2.OrderID = te.OrderID 
                AND te2.EZParentProdID = te.EZProdID 
                AND te2.isDeleted = 0 
                AND te2.ItemNumber ='UP CHARGE:Finishing:MATCH-INTERIOR'
            )
            THEN 1
            ELSE 0 END AS BIT)
            AS MatchInterior
        )AS mi
		CROSS APPLY
        (
            SELECT CAST(CASE WHEN EXISTS
            (
                SELECT * FROM dbo.TranEntry te2 
                WHERE te2.OrderID = te.OrderID 
                AND te2.EZParentProdID = te.EZProdID 
                AND te2.isDeleted=0 
                AND te2.ItemNumber IN ('UP CHARGE:CUT-DOOR')
            )
            THEN 1
            ELSE 0 END AS BIT)
            AS CutDoor
        )AS cutDoor
		CROSS APPLY
        (
            SELECT CAST(CASE WHEN EXISTS
            (
                SELECT * FROM dbo.TranEntry te2 
                WHERE te2.OrderID = te.OrderID 
                AND te2.EZParentProdID = te.EZProdID 
                AND te2.isDeleted = 0 
                AND 
				(
					te2.ItemNumber NOT IN ('UP CHARGE:CUT-DOOR', 'UP CHARGE:Finishing:MATCH-INTERIOR')
					OR 
					(
						te2.ItemNumber = 'UP CHARGE:CUT-DOOR' AND NOT EXISTS
						(
							SELECT * FROM @OrderMaterialDetail2 AS omd2
							JOIN inventory.AcumaticaStockItems AS asi ON asi.Name = omd2.InventoryID 
							JOIN inventory.AcumaticaProductToProductTag AS aptpt ON aptpt.AcumaticaProductId = asi.AcumaticaProductID
							WHERE aptpt.ProductTagId = 112
							AND aptpt.Deleted = 0
						)
					)
					OR 
                    (
						te2.ItemNumber = 'UP CHARGE:Finishing:MATCH-INTERIOR'
						AND NOT EXISTS
						(
							SELECT * FROM @OrderMaterialDetail2 AS omd2
							JOIN dbo.tb_ItemList AS til ON omd2.InventoryID = til.AcumaticaName
							JOIN acumaticaManufacturing.BillOfMaterialDetails AS bd ON bd.InventoryID = omd2.InventoryID
							JOIN acumaticaManufacturing.BillOfMaterials AS bom ON bom.BOMID = bd.BOMID
							JOIN inventory.AcumaticaStockItems AS asi ON bom.InventoryID = asi.Name
							JOIN inventory.AcumaticaProductToProductTag AS aptpt ON aptpt.AcumaticaProductId = asi.AcumaticaProductID
							WHERE aptpt.ProductTagId = 72
							AND til.ComponentPartTypeId = 6
							AND aptpt.Deleted = 0
							AND bd.DeleteFlag = 0
							AND bom.DeleteFlag = 0
							AND bom.Status = 'Active'
						)
					)
				)
            )
            THEN 1
            ELSE 0 END AS BIT)
            AS OtherMod
        )AS otherMod
        LEFT JOIN picking.DestinationLocationItemRule dlir ON 
        --IL-2648
        (
			dlir.ProductionItemItemlistId = il.ID 
			AND NOT EXISTS 
			(
				SELECT 1 FROM picking.DestinationLocationItemRule dlir2 
				WHERE dlir2.ProductionItemItemlistId = il.ID 
				AND  dlir2.Revision = oipiir.Revision
			)
		)
        OR 
		(
			dlir.ProductionItemItemlistId = il.ID 
			AND dlir.Revision = oipiir.Revision 
		)
        --END IL-2648
        LEFT JOIN picking.DestinationLocationItemRule AS detailDestinationRule ON mi.MatchInterior = 1 
		AND dlir.DestinationLocationId NOT IN(32,33,34,35)
        AND EXISTS
        (
            SELECT * FROM @OrderMaterialDetail2 omd
            JOIN dbo.tb_ItemList AS til ON omd.InventoryID = til.AcumaticaName
            WHERE detailDestinationRule.ProductionItemDetailItemlistId = til.ID             
        )
		OUTER APPLY
        (
            SELECT TOP(1) 1 AS CarcassToCust
            FROM @OrderMaterialDetail2 AS omd2
            JOIN dbo.tb_ItemList AS til2 ON omd2.InventoryID = til2.AcumaticaName
            WHERE til2.ComponentPartTypeId = 6
            AND mi.MatchInterior = 1
        )ctc
		--FF-414
        OUTER APPLY
        (
			SELECT TOP (1) 
			CASE 
			WHEN otherMod.OtherMod = 1 THEN NULL
			WHEN cutDoor.CutDoor = 1 AND oipiir.Revision = 'A' THEN 27
			WHEN mi.MatchInterior = 1 
				AND NOT EXISTS
				(
					SELECT * FROM @OrderMaterialDetail2 AS omd2
					JOIN dbo.tb_ItemList AS til2 ON omd2.InventoryID = til2.AcumaticaName
					WHERE til2.ComponentPartTypeId = 6
				) THEN NULL
			WHEN 1 IN (cutDoor.CutDoor, mi.MatchInterior) THEN 1
			ELSE NULL END AS PiLocation		
        )AS ModsHandledWithBom
        OUTER APPLY 
		( 
			 SELECT TOP 1 mr.ProductionItemLocationTypeId , mr.ModificationCategoryPriority , ds.Color , mr.DoorStyleColor 
			 FROM dbo.TranEntry te2 
			 JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te2.ItemNumber       
			 JOIN inventory.DoorStyles ds ON ds.DoorStyleID = il.DoorStyleID
			 JOIN dbo.ModificationRules mr ON mr.ItemId = il2.ID AND mr.DeleteFlag = 0
			 AND 
			 ( 
				 ds.Color = mr.DoorStyleColor 
				 OR 
				 ( 
					 mr.DoorStyleColor IS NULL 
					 AND NOT EXISTS 
					 (
						 SELECT * FROM dbo.ModificationRules mr1 
						 WHERE  mr1.ItemId = il2.ID  
						 AND ds.Color = mr1.DoorStyleColor 
						 AND mr1.ModificationRulesId <> mr.ModificationRulesId 
					 ) 
				 )
			 )
			 WHERE te2.OrderID = te.OrderID 
			 AND te2.EZParentProdID = te.EZProdID 
			 AND te2.isActive = 1 
			 AND te2.isDeleted = 0  
			 AND te2.ItemType = 4
			 ORDER BY mr.ModificationCategoryPriority DESC
		 ) mrule
		 OUTER APPLY(
			SELECT CAST(1 AS BIT ) fhdDol FROM inventory.AcumaticaProductToProductTag AS aptpt 
			JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaProductID = aptpt.AcumaticaProductId AND asi.DeleteFlag=0
			JOIN inventory.AcumaticaDoorStyles AS ads ON ads.AcumaticaID = asi.AcumaticaDoorStyleID AND ads.DeleteFlag =0
			WHERE aptpt.ProductTagId IN(115) AND ads.ProductLineName='ALLURE' AND aptpt.Deleted=0  AND il.AcumaticaID=asi.AcumaticaID) AS fhd
        WHERE oipiir.OrderItemProductionItemIReleaseId = @OrderItemProductionItemIReleaseId 
    RETURN
END


GO
/****** Object:  UserDefinedFunction [picking].[GetProductionItemLocationFromOrderMaterialDetailStaging]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[GetProductionItemLocationFromOrderMaterialDetailStaging]
(
    @OrderItemProductionItemIReleaseId AS INT,
    @OrderMaterialDetail OrderMaterialDetail READONLY   
)
RETURNS @ProductionItemLocations TABLE
(
    DestinationLocationId INT,
    ProductionItemLocationId INT
)
AS
BEGIN
    DECLARE @OrderMaterialDetail2 OrderMaterialDetail
    IF NOT EXISTS (SELECT * FROM @OrderMaterialDetail AS omd)
    BEGIN
        INSERT @OrderMaterialDetail2
        (
            InventoryID, Quantity
        )
            SELECT asi.Name, COUNT(*) AS Quantity FROM Picking.ProductionItemDetail AS pid
            JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
            JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaID = til.AcumaticaID
            JOIN Picking.ProductionItem AS pi ON pid.ProductionItemId = pi.ProductionItemId
            JOIN picking.OrderItemProductionItemIRelease AS oipiir ON oipiir.OrderItemId = pi.OrderItemId
            WHERE oipiir.OrderItemProductionItemIReleaseId = @OrderItemProductionItemIReleaseId
            AND pi.Deleted = 0
            GROUP BY asi.Name
    END
    ELSE
    BEGIN
        INSERT @OrderMaterialDetail2
        (
            InventoryID, Quantity
        )
            SELECT omd.InventoryID, omd.Quantity 
            FROM @OrderMaterialDetail AS omd
    END

    INSERT @ProductionItemLocations ( DestinationLocationId, ProductionItemLocationId )
    SELECT
    CASE 
            WHEN  oipiir.Revision = 'A' THEN  19  
            WHEN oipiir.sandbox = 0 THEN COALESCE(CarcassBelt.DestinationLocationId, detailDestinationRule.DestinationLocationId, dlir.DestinationLocationId, 1)
            ELSE COALESCE(CarcassBelt.DestinationLocationId, detailDestinationRule.SandboxDestinationLocationId, dlir.SandboxDestinationLocationId, 1)
            --WHEN te.ItemType =2  THEN  5
            END,
        CASE 
			WHEN te.ItemType = 3 AND te.OrderIdentity LIKE 'RMA%' THEN 30
            WHEN oipiir.Revision = 'A' THEN  10    
            WHEN dlir.DestinationLocationId IN(32,33,34,35) AND te.PickDropLoc = 'C' THEN  23 
            WHEN dlir.DestinationLocationId IN(32,33,34,35) AND te.PickDropLoc = 'F' THEN  24  
			WHEN ctc.CarcassToCust = 1 THEN 27 --CustomShop FF-719
			-- commented out on 4/14/2021 as per Mendy Gruber WHEN ModsHandledWithBom.PiLocation IS NOT NULL THEN ModsHandledWithBom.PiLocation 
            --WHEN ctc.CarcassToCust = 1 THEN CASE WHEN otherMod.OtherMod = 1 THEN 27 ELSE 1 END --CustomShop
            WHEN mrule.ProductionItemLocationTypeId IS NOT NULL THEN  mrule.ProductionItemLocationTypeId			
            WHEN PILO.ProductionItemLocationType IS NOT NULL THEN PILO.ProductionItemLocationType
            WHEN te.KD = 1 THEN 26      
            WHEN te.PickDropLoc = 'F' THEN 28 --Finishing			
            WHEN te.PickDropLoc = 'C' OR fhd.fhdDol IS NOT NULL THEN 27 --CustomShop
            WHEN te.PickDropLoc = 'A' THEN 1 --Unpacking
            ELSE 1 END ProductionItemLocationTypeId
    FROM dbo.TranEntry te
        JOIN picking.OrderItemProductionItemIRelease oipiir ON oipiir.OrderItemId = te.ID
        JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
        LEFT JOIN picking.ProductionItemLocationOverides PILO ON PILO.ItemListId = il.ID AND PILO.Revision = oipiir.Revision
        CROSS APPLY
        (
            SELECT CAST(CASE WHEN EXISTS
            (
                SELECT * FROM dbo.TranEntry te2 
                WHERE te2.OrderID = te.OrderID 
                AND te2.EZParentProdID = te.EZProdID 
                AND te2.isDeleted = 0 
                AND te2.ItemNumber ='UP CHARGE:Finishing:MATCH-INTERIOR'
            )
            THEN 1
            ELSE 0 END AS BIT)
            AS MatchInterior
        )AS mi
		CROSS APPLY
        (
            SELECT CAST(CASE WHEN EXISTS
            (
                SELECT * FROM dbo.TranEntry te2 
                WHERE te2.OrderID = te.OrderID 
                AND te2.EZParentProdID = te.EZProdID 
                AND te2.isDeleted=0 
                AND te2.ItemNumber IN ('UP CHARGE:CUT-DOOR')
            )
            THEN 1
            ELSE 0 END AS BIT)
            AS CutDoor
        )AS cutDoor
		CROSS APPLY
        (
            SELECT CAST(CASE WHEN EXISTS
            (
                SELECT * FROM dbo.TranEntry te2 
                WHERE te2.OrderID = te.OrderID 
                AND te2.EZParentProdID = te.EZProdID 
                AND te2.isDeleted = 0 
                AND 
				(
					te2.ItemNumber NOT IN ('UP CHARGE:CUT-DOOR', 'UP CHARGE:Finishing:MATCH-INTERIOR')
					OR 
					(
						te2.ItemNumber = 'UP CHARGE:CUT-DOOR' AND NOT EXISTS
						(
							SELECT * FROM @OrderMaterialDetail2 AS omd2
							JOIN inventory.AcumaticaStockItems AS asi ON asi.Name = omd2.InventoryID 
							JOIN inventory.AcumaticaProductToProductTag AS aptpt ON aptpt.AcumaticaProductId = asi.AcumaticaProductID
							WHERE aptpt.ProductTagId = 112
							AND aptpt.Deleted = 0
						)
					)
					OR 
                    (
						te2.ItemNumber = 'UP CHARGE:Finishing:MATCH-INTERIOR'
						AND NOT EXISTS
						(
							SELECT * FROM @OrderMaterialDetail2 AS omd2
							JOIN dbo.tb_ItemList AS til ON omd2.InventoryID = til.AcumaticaName
							JOIN acumaticaManufacturing.BillOfMaterialDetails AS bd ON bd.InventoryID = omd2.InventoryID
							JOIN acumaticaManufacturing.BillOfMaterials AS bom ON bom.BOMID = bd.BOMID
							JOIN inventory.AcumaticaStockItems AS asi ON bom.InventoryID = asi.Name
							JOIN inventory.AcumaticaProductToProductTag AS aptpt ON aptpt.AcumaticaProductId = asi.AcumaticaProductID
							WHERE aptpt.ProductTagId = 72
							AND til.ComponentPartTypeId = 6
							AND aptpt.Deleted = 0
							AND bd.DeleteFlag = 0
							AND bom.DeleteFlag = 0
							AND bom.Status = 'Active'
						)
					)
				)
            )
            THEN 1
            ELSE 0 END AS BIT)
            AS OtherMod
        )AS otherMod
        LEFT JOIN picking.DestinationLocationItemRule dlir ON 
        --IL-2648
        (
			dlir.ProductionItemItemlistId = il.ID 
			AND NOT EXISTS 
			(
				SELECT 1 FROM picking.DestinationLocationItemRule dlir2 
				WHERE dlir2.ProductionItemItemlistId = il.ID 
				AND  dlir2.Revision = oipiir.Revision
			)
		)
        OR 
		(
			dlir.ProductionItemItemlistId = il.ID 
			AND dlir.Revision = oipiir.Revision 
		)
        --END IL-2648
        LEFT JOIN picking.DestinationLocationItemRule AS detailDestinationRule ON mi.MatchInterior = 1 
		AND dlir.DestinationLocationId NOT IN(32,33,34,35)
        AND EXISTS
        (
            SELECT * FROM @OrderMaterialDetail2 omd
            JOIN dbo.tb_ItemList AS til ON omd.InventoryID = til.AcumaticaName
            WHERE detailDestinationRule.ProductionItemDetailItemlistId = til.ID             
        )
		OUTER APPLY
		(
			SELECT TOP(1) 1 AS HasCarcass
            FROM @OrderMaterialDetail2 AS omd2
            JOIN dbo.tb_ItemList AS til2 ON omd2.InventoryID = til2.AcumaticaName 
            WHERE til2.ComponentPartTypeId = 6
		)AS HasCarcass
		OUTER APPLY
		(
			SELECT CASE WHEN oipiir.Sandbox = 1 THEN 30 ELSE 23 END AS DestinationLocationId
			WHERE HasCarcass = 1
			AND NOT EXISTS
			(
				SELECT * FROM @OrderMaterialDetail2 AS oimd2
				JOIN inventory.AcumaticaStockItems AS asi ON asi.Name IN(oimd2.InventoryID, il.AcumaticaName)
				JOIN inventory.AcumaticaProductToProductTag AS aptpt ON aptpt.AcumaticaProductId = asi.AcumaticaProductID
				WHERE aptpt.Deleted = 0
				AND aptpt.ProductTagId = 97
			)
		)AS CarcassBelt
		OUTER APPLY
        (
            SELECT TOP(1) 1 AS CarcassToCust
            WHERE HasCarcass.HasCarcass = 1
            AND mi.MatchInterior = 1
        )ctc
		--FF-414
        OUTER APPLY
        (
			SELECT TOP (1) 
			CASE 
			WHEN otherMod.OtherMod = 1 THEN NULL
			WHEN cutDoor.CutDoor = 1 AND oipiir.Revision = 'A' THEN 27
			WHEN mi.MatchInterior = 1 
				AND NOT EXISTS
				(
					SELECT * FROM @OrderMaterialDetail2 AS omd2
					JOIN dbo.tb_ItemList AS til2 ON omd2.InventoryID = til2.AcumaticaName
					WHERE til2.ComponentPartTypeId = 6
				) THEN NULL
			WHEN 1 IN (cutDoor.CutDoor, mi.MatchInterior) THEN 1
			ELSE NULL END AS PiLocation		
        )AS ModsHandledWithBom
        OUTER APPLY 
		( 
			 SELECT TOP 1 mr.ProductionItemLocationTypeId , mr.ModificationCategoryPriority , ds.Color , mr.DoorStyleColor 
			 FROM dbo.TranEntry te2 
			 JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te2.ItemNumber       
			 JOIN inventory.DoorStyles ds ON ds.DoorStyleID = il.DoorStyleID
			 JOIN dbo.ModificationRules mr ON mr.ItemId = il2.ID AND mr.DeleteFlag = 0
			 AND 
			 ( 
				 ds.Color = mr.DoorStyleColor 
				 OR 
				 ( 
					 mr.DoorStyleColor IS NULL 
					 AND NOT EXISTS 
					 (
						 SELECT * FROM dbo.ModificationRules mr1 
						 WHERE  mr1.ItemId = il2.ID  
						 AND ds.Color = mr1.DoorStyleColor 
						 AND mr1.ModificationRulesId <> mr.ModificationRulesId 
					 ) 
				 )
			 )
			 WHERE te2.OrderID = te.OrderID 
			 AND te2.EZParentProdID = te.EZProdID 
			 AND te2.isActive = 1 
			 AND te2.isDeleted = 0  
			 AND te2.ItemType = 4
			 ORDER BY mr.ModificationCategoryPriority DESC
		 ) mrule
		 OUTER APPLY(
			SELECT CAST(1 AS BIT ) fhdDol FROM inventory.AcumaticaProductToProductTag AS aptpt 
			JOIN inventory.AcumaticaStockItems AS asi ON asi.AcumaticaProductID = aptpt.AcumaticaProductId AND asi.DeleteFlag=0
			JOIN inventory.AcumaticaDoorStyles AS ads ON ads.AcumaticaID = asi.AcumaticaDoorStyleID AND ads.DeleteFlag =0
			WHERE aptpt.ProductTagId IN(115) AND ads.ProductLineName='ALLURE' AND aptpt.Deleted=0  AND il.AcumaticaID=asi.AcumaticaID) AS fhd
        WHERE oipiir.OrderItemProductionItemIReleaseId = @OrderItemProductionItemIReleaseId 
    RETURN
END


GO
/****** Object:  UserDefinedFunction [picking].[GetProductionOrderDetailSkusPickingType]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Yakov Muller
-- Create date: 7/31/2019
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [picking].[GetProductionOrderDetailSkusPickingType]
(	
	@ProductionItemCode VARCHAR(50),
	@materialDetails OrderMaterialDetail READONLY,
	@OrderItemId INT = NULL
)
RETURNS @ProductionOrderDetailSkus TABLE
(
	itemListId INT,
	AcumaticaName VARCHAR(30),
	PickingTypeId INT,
	Qty INT DEFAULT 0,
	PrintOrderItemLabel BIT DEFAULT(0),
	PrintItemLabel BIT DEFAULT(0),
	PrintDetailLabel BIT DEFAULT(0),	
	PrintDrawerLabel BIT DEFAULT(0),
	PrintOrderItemLabel4x6 BIT DEFAULT(0),
	AddonTranentryId INT NULL
)
AS
BEGIN 
	INSERT @ProductionOrderDetailSkus(itemListId, AcumaticaName, PickingTypeId, Qty , PrintOrderItemLabel , PrintOrderItemLabel4x6,  AddonTranentryId)
	SELECT il.ID, il.AcumaticaName, 
		CASE 
		    -- Always first PIcking tyoe 8&9&14 (Hardware & Pantry Self Clips & no picking)
			--WHEN dlir.DestinationLocationId IN(32,33,34,35) AND il.ID IN(152017,152018,152019,152020,152021,152022) THEN 9
			WHEN Gets7.Gets7 = 1 THEN 7
			WHEN Gets10.Ten IS NOT NULL THEN Gets10.Ten
			WHEN DefaultPickingType.PickingTypeId IN(8,9,14) THEN DefaultPickingType.PickingTypeId  
			WHEN cd.CutDoor = 1 THEN 2 --IL-3904
			WHEN il.ComponentPartTypeId IN (22) AND HoodRule.ParentIsTagHood = 1 THEN 4 -- DE-914
			--BEGIN FF-701
			WHEN il.ComponentPartTypeId = 14 AND HoodRule.ParentIsTagHood = 1 THEN 1
			WHEN il.ComponentPartTypeId = 14 AND oi.Revision = 'A' THEN 7
			WHEN il.ComponentPartTypeId = 14 AND oi.Revision = 'FG' THEN 13
			WHEN il.ComponentPartTypeId = 14 THEN 2
			--END FF-701
			WHEN Pantry.GoesToPantry = 1 AND ASI.Color <> 'Unfinished' THEN 4 --DE-1011
			WHEN (il.ItemTypeCode = 7  OR il.ComponentPartTypeId IN(7,17) ) AND dlir.DestinationLocationId IN(32,33,34,35) AND (ISNULL(CutRod.CutRod,0) = 0) 
				THEN CASE WHEN Adj.AdjustedDepth IS NULL THEN 4 ELSE 2 END
			WHEN il.ShortItemCode IN (SELECT TICD.ItemCode FROM dbo.tb_itemClassDetail TICD WHERE TICD.ClassID =133) AND dlir.DestinationLocationId IN(32,33,34,35) THEN 2
			ELSE COALESCE(piptProduct.PickingTypeId, pipt.PickingTypeId, DefaultPickingType.PickingTypeId, 2) 
		END PickingTypeId ,
		COALESCE(addons.AddonQty, md.Quantity) Quantity ,
		CASE WHEN backPanel.itemlistIdToPrint=il.ID THEN 1 ELSE 0 END,
		CASE WHEN il.ItemTypeCode = 7 OR  (oi.OrderItemId IS NOT NULL AND (oi.HasCustomizing = 1 OR  oi.HasFinishing =1 ) AND il.ComponentPartTypeId = 6) THEN 1 ELSE 0 END,		
		addons.AddonTranentry
		FROM @materialDetails md	
		JOIN dbo.tb_ItemList ilp ON ilp.AcumaticaName = @ProductionItemCode
		OUTER APPLY (SELECT TOP 1 dlir.DestinationLocationId FROM picking.DestinationLocationItemRule dlir WHERE  dlir.ProductionItemItemlistId = ilp.ID) dlir
		JOIN dbo.tb_ItemList il ON md.InventoryID = il.AcumaticaName
		JOIN inventory.AcumaticaStockItems ASI ON ASI.AcumaticaID = il.AcumaticaID
		OUTER APPLY (SELECT TOP (1) pipt1.PickingTypeId 
			FROM  picking.ProductionItemPickingType pipt1 
			WHERE pipt1.ItemListId = il.ID AND pipt1.Active=1 AND (pipt1.FinishGood_ItemListId=ilp.ID OR pipt1.FinishGood_ItemListId IS NULL AND pipt1.FinishGood_ProductId IS NULL) 
			ORDER BY CASE WHEN pipt1.FinishGood_ItemListId = ilp.ID  THEN 0 WHEN pipt1.FinishGood_ItemListId IS NULL THEN 1 ELSE 2 END
		) pipt
		OUTER APPLY (SELECT TOP (1) pipt1.PickingTypeId 
			FROM picking.ProductionItemPickingType pipt1 
			WHERE pipt1.ItemListId = il.ID AND pipt1.Active=1 AND (pipt1.FinishGood_ProductId=ilp.ProductID OR (pipt1.FinishGood_ProductId IS NULL AND pipt1.FinishGood_ItemListId IS NULL)) 
			ORDER BY CASE WHEN pipt1.FinishGood_ProductId = ilp.ProductID  THEN 0 WHEN pipt1.FinishGood_ProductId IS NULL THEN 1 ELSE 2 END
		) piptProduct
		OUTER APPLY (SELECT TOP 1 CPT.DefaultPickingTypeId PickingTypeId FROM inventory.ComponentPartType CPT WHERE CPT.ComponentPartTypeId = il.ComponentPartTypeId) DefaultPickingType
		OUTER APPLY 
		(
			SELECT te.ID OrderItemId,  te.HasCustomizing, te.HasFinishing , te.OrderID, te.EZProdID, te.EZProdSubID, oipiir.Revision
			FROM dbo.TranEntry te
			JOIN picking.OrderItemProductionItemIRelease AS oipiir ON oipiir.OrderItemId = te.ID 
			WHERE te.ID = @OrderItemId
		) oi	
		OUTER APPLY
		(
		SELECT il2.ShortItemCode AddonItemCode , te.ID AddonTranentry ,1  AddonQty FROM dbo.TranEntry te
		JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te.ItemNumber AND il2.ItemTypeCode = 7
		 WHERE te.OrderID = oi.OrderID AND te.isDeleted=0 AND te.EZParentProdID= oi.EZProdID AND( oi.EZProdSubID = te.EZProdSubID OR te.ItemNumber NOT IN ( 'ACCESSORIES:LST33', 'ACCESSORIES:LST36' ))
		 AND il2.AcumaticaName = md.InventoryID
		) addons
		OUTER APPLY
		(
			SELECT 1 AS CutDoor
			FROM dbo.TranEntry te
			JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te.ItemNumber
			WHERE te.OrderID = oi.OrderID AND te.isDeleted = 0 AND te.EZParentProdID = oi.EZProdID
			AND il2.ID = 106907 -- CUT-DOOR
			AND EXISTS
			(
				SELECT * FROM inventory.Products  AS p
				WHERE p.ProductCode LIKE 'DFG%'
				AND il.ProductID = p.ProductID
			)
		) AS cd
		OUTER APPLY
		(
			SELECT 1 CutRod FROM dbo.TranEntry te
			JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = te.ItemNumber
			WHERE te.EZParentProdID = oi.EZProdID AND te.isDeleted = 0 AND te.isActive = 1
			AND TIL.ID = 106910 		
		) AS CutRod
		OUTER APPLY
		(
			SELECT CAST( CASE WHEN EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt
				WHERE ptpt.ProductId = ilp.ProductID
				AND ptpt.DeleteFlag = 0
				AND ptpt.ProductTagId IN (25, 24)
			) 
			THEN 1 ELSE 0 END AS BIT)
		)AS Gets7(Gets7)
		OUTER APPLY
		(
			SELECT 10 AS Ten 
			FROM @materialDetails AS md2
			JOIN dbo.tb_ItemList AS til ON md2.InventoryID = til.AcumaticaName
			WHERE til.ComponentPartTypeId = 6
			AND EXISTS
			(
				SELECT * FROM dbo.TranEntry AS subItem 
				WHERE subItem.OrderID = oi.OrderId
				AND subItem.EZParentProdID = oi.EZProdID
				AND subItem.ItemNumber = 'UP CHARGE:Finishing:MATCH-INTERIOR'
				AND subItem.isDeleted = 0
			)
			AND NOT EXISTS
			(
				SELECT * FROM dbo.TranEntry AS subItem 
				WHERE subItem.OrderID = oi.OrderId
				AND subItem.EZParentProdID = oi.EZProdID
				AND subItem.ItemNumber NOT IN ('UP CHARGE:CUT-DOOR', 'UP CHARGE:Finishing:MATCH-INTERIOR')
				AND subItem.isDeleted = 0
			)
			AND il.ComponentPartTypeId = 9
		)AS Gets10
		OUTER APPLY
		( 
			 SELECT 1 AdjustedDepth FROM dbo.tb_AdjustedBoxDimensions TABD
			 WHERE TABD.TranEntryID = oi.OrderItemId
			 AND TABD.AdjustDepth < 0
		) Adj
		OUTER APPLY
		(
			SELECT CAST( CASE WHEN EXISTS
			(
				SELECT 1 FROM inventory.ProductToProductTags AS ptpt
				WHERE ptpt.ProductId = ilp.ProductID
				AND ptpt.DeleteFlag = 0
				AND ptpt.ProductTagId IN (19)
			) 
			THEN 1 ELSE 0 END AS BIT) ParentIsTagHood
		)AS HoodRule
		OUTER APPLY
		(
			SELECT CAST( CASE WHEN EXISTS
			(
				SELECT 1 FROM inventory.ProductToProductTags AS ptpt
				WHERE ptpt.ProductId = ilp.ProductID
				AND ptpt.DeleteFlag = 0
				AND ptpt.ProductTagId IN (97)
			)
			THEN 1 ELSE 0 END AS BIT) GoesToPantry
		)AS Pantry
		OUTER APPLY(SELECT TOP 1 ilbp.ID AS itemlistIdToPrint FROM dbo.tb_ItemList ilbp JOIN @materialDetails AS md ON  md.InventoryID = ilbp.AcumaticaName AND ilbp.ComponentPartTypeId=1 
		ORDER BY CASE WHEN  ilbp.ItemCode LIKE '%WDC%' AND  ilbp.ItemCode NOT LIKE '%C' THEN 1 ELSE 0 END  ) backPanel
			  
	DECLARE @countOfType1Items INT

	SELECT @countOfType1Items = COUNT(*) FROM @ProductionOrderDetailSkus AS pods 
	WHERE pods.PickingTypeId = 1

	IF @countOfType1Items > 1
	BEGIN	    
		UPDATE TOP (@countOfType1Items - 1) pods SET pods.PickingTypeId = 2 FROM @ProductionOrderDetailSkus AS pods
		WHERE PickingTypeId = 1
	END

  RETURN 

END

GO
/****** Object:  UserDefinedFunction [picking].[GetProductionOrderDetailSkusPickingTypeOnlyAdditions]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 7/31/2019
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [picking].[GetProductionOrderDetailSkusPickingTypeOnlyAdditions]
(	
	@ProductionItemCode VARCHAR(50),
	@materialDetails OrderMaterialDetail  READONLY,
	@OrderItemId int = null
)
RETURNS @ProductionOrderDetailSkus TABLE
(
	itemListId INT,
	AcumaticaName VARCHAR(30),
	PickingTypeId INT,
	Qty INT DEFAULT 0,
	PrintOrderItemLabel BIT DEFAULT(0),
	PrintItemLabel BIT DEFAULT(0),
	PrintDetailLabel BIT DEFAULT(0),	
	PrintDrawerLabel BIT DEFAULT(0),
	PrintOrderItemLabel4x6 BIT DEFAULT(0),
	AddonTranentryId INT NULL
)
AS
BEGIN 
	INSERT @ProductionOrderDetailSkus(itemListId, AcumaticaName, PickingTypeId, Qty , PrintOrderItemLabel , PrintOrderItemLabel4x6, PrintDrawerLabel, AddonTranentryId)
	
	SELECT gpodspt.itemListId, gpodspt.AcumaticaName, gpodspt.PickingTypeId, gpodspt.Qty, gpodspt.PrintOrderItemLabel,gpodspt.PrintOrderItemLabel4x6, gpodspt.PrintDrawerLabel, gpodspt.AddonTranentryId 
	FROM picking.GetProductionOrderDetailSkusPickingType(@ProductionItemCode,@materialDetails,@OrderItemId) gpodspt
		   WHERE EXISTS(SELECT 1 FROM picking.ProductionItem pi  JOIN picking.ProductionItemDetail pid ON pid.ProductionItemId = pi.ProductionItemId AND pid.Deleted = 0  WHERE pi.OrderItemId = @OrderItemId AND pi.Deleted=0  AND gpodspt.itemListId= pid.ItemlistId  )

  RETURN 

END

GO
/****** Object:  UserDefinedFunction [picking].[GetProductionOrderDetailSkusPickingTypeStaging]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Yakov Muller
-- Create date: 7/31/2019
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [picking].[GetProductionOrderDetailSkusPickingTypeStaging]
(	
	@ProductionItemCode VARCHAR(50),
	@materialDetails OrderMaterialDetail READONLY,
	@OrderItemId INT = NULL
)
RETURNS @ProductionOrderDetailSkus TABLE
(
	itemListId INT,
	AcumaticaName VARCHAR(30),
	PickingTypeId INT,
	Qty INT DEFAULT 0,
	PrintOrderItemLabel BIT DEFAULT(0),
	PrintItemLabel BIT DEFAULT(0),
	PrintDetailLabel BIT DEFAULT(0),	
	PrintDrawerLabel BIT DEFAULT(0),
	PrintOrderItemLabel4x6 BIT DEFAULT(0),
	AddonTranentryId INT NULL
)
AS
BEGIN 
	INSERT @ProductionOrderDetailSkus(itemListId, AcumaticaName, PickingTypeId, Qty , PrintOrderItemLabel , PrintOrderItemLabel4x6,  AddonTranentryId)
	SELECT il.ID, il.AcumaticaName, 
		CASE 
		    -- Always first PIcking tyoe 8&9&14 (Hardware & Pantry Self Clips & no picking)
			--WHEN dlir.DestinationLocationId IN(32,33,34,35) AND il.ID IN(152017,152018,152019,152020,152021,152022) THEN 9
			--WHEN NotInDefaultBom.PickingType IS NOT NULL THEN NotInDefaultBom.PickingType
			WHEN Gets7.Gets7 = 1 THEN 7
			WHEN Gets10.Ten IS NOT NULL THEN Gets10.Ten
			WHEN DefaultPickingType.PickingTypeId IN(8,9,14) THEN DefaultPickingType.PickingTypeId  
			WHEN cd.CutDoor = 1 THEN 2 --IL-3904
			WHEN il.ComponentPartTypeId IN (22) AND HoodRule.ParentIsTagHood = 1 THEN 4 -- DE-914
			--BEGIN FF-701
			WHEN il.ComponentPartTypeId = 14 AND HoodRule.ParentIsTagHood = 1 THEN 1
			WHEN il.ComponentPartTypeId = 14 AND oi.Revision = 'A' THEN 7
			WHEN il.ComponentPartTypeId = 14 AND oi.Revision = 'FG' THEN 13
			WHEN il.ComponentPartTypeId = 14 THEN 2
			--END FF-701
			WHEN Pantry.GoesToPantry = 1 AND ASI.Color <> 'Unfinished' THEN 4 --DE-1011
			WHEN (il.ItemTypeCode = 7  OR il.ComponentPartTypeId IN(7,17) ) AND dlir.DestinationLocationId IN(32,33,34,35) AND (ISNULL(CutRod.CutRod,0) = 0) 
				THEN CASE WHEN Adj.AdjustedDepth IS NULL THEN 4 ELSE ISNULL(NotInDefaultBom.PickingType, 2) END
			WHEN il.ShortItemCode IN (SELECT TICD.ItemCode FROM dbo.tb_itemClassDetail TICD WHERE TICD.ClassID =133) AND dlir.DestinationLocationId IN(32,33,34,35) THEN 2
			ELSE COALESCE(NotInDefaultBom.PickingType, piptProduct.PickingTypeId, pipt.PickingTypeId, DefaultPickingType.PickingTypeId, 2) 
		END PickingTypeId ,
		COALESCE(addons.AddonQty, md.Quantity) Quantity ,
		CASE WHEN backPanel.itemlistIdToPrint=il.ID THEN 1 ELSE 0 END,
		CASE WHEN il.ItemTypeCode = 7 OR  (oi.OrderItemId IS NOT NULL AND (oi.HasCustomizing = 1 OR  oi.HasFinishing =1 ) AND il.ComponentPartTypeId = 6) THEN 1 ELSE 0 END,		
		addons.AddonTranentry
		FROM @materialDetails md	
		JOIN dbo.tb_ItemList ilp ON ilp.AcumaticaName = @ProductionItemCode
		OUTER APPLY (SELECT TOP 1 dlir.DestinationLocationId FROM picking.DestinationLocationItemRule dlir WHERE  dlir.ProductionItemItemlistId = ilp.ID) dlir
		JOIN dbo.tb_ItemList il ON md.InventoryID = il.AcumaticaName
		JOIN inventory.AcumaticaStockItems ASI ON ASI.AcumaticaID = il.AcumaticaID
		OUTER APPLY (SELECT TOP (1) pipt1.PickingTypeId 
			FROM  picking.ProductionItemPickingType pipt1 
			WHERE pipt1.ItemListId = il.ID AND pipt1.Active=1 AND (pipt1.FinishGood_ItemListId=ilp.ID OR pipt1.FinishGood_ItemListId IS NULL AND pipt1.FinishGood_ProductId IS NULL) 
			ORDER BY CASE WHEN pipt1.FinishGood_ItemListId = ilp.ID  THEN 0 WHEN pipt1.FinishGood_ItemListId IS NULL THEN 1 ELSE 2 END
		) pipt
		OUTER APPLY (SELECT TOP (1) pipt1.PickingTypeId 
			FROM picking.ProductionItemPickingType pipt1 
			WHERE pipt1.ItemListId = il.ID AND pipt1.Active=1 AND (pipt1.FinishGood_ProductId=ilp.ProductID OR (pipt1.FinishGood_ProductId IS NULL AND pipt1.FinishGood_ItemListId IS NULL)) 
			ORDER BY CASE WHEN pipt1.FinishGood_ProductId = ilp.ProductID  THEN 0 WHEN pipt1.FinishGood_ProductId IS NULL THEN 1 ELSE 2 END
		) piptProduct
		OUTER APPLY (SELECT TOP 1 CPT.DefaultPickingTypeId PickingTypeId FROM inventory.ComponentPartType CPT WHERE CPT.ComponentPartTypeId = il.ComponentPartTypeId) DefaultPickingType
		OUTER APPLY 
		(
			SELECT te.ID OrderItemId,  te.HasCustomizing, te.HasFinishing , te.OrderID, te.EZProdID, te.EZProdSubID, oipiir.Revision
			FROM dbo.TranEntry te
			JOIN picking.OrderItemProductionItemIRelease AS oipiir ON oipiir.OrderItemId = te.ID 
			WHERE te.ID = @OrderItemId
		) oi	
		OUTER APPLY
		(
		SELECT il2.ShortItemCode AddonItemCode , te.ID AddonTranentry ,1  AddonQty FROM dbo.TranEntry te
		JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te.ItemNumber AND il2.ItemTypeCode = 7
		 WHERE te.OrderID = oi.OrderID AND te.isDeleted=0 AND te.EZParentProdID= oi.EZProdID AND( oi.EZProdSubID = te.EZProdSubID OR te.ItemNumber NOT IN ( 'ACCESSORIES:LST33', 'ACCESSORIES:LST36' ))
		 AND il2.AcumaticaName = md.InventoryID
		) addons
		OUTER APPLY
		(
			SELECT 1 AS CutDoor
			FROM dbo.TranEntry te
			JOIN dbo.tb_ItemList il2 ON il2.ItemCode = te.ItemNumber
			WHERE te.OrderID = oi.OrderID AND te.isDeleted = 0 AND te.EZParentProdID = oi.EZProdID
			AND il2.ID = 106907 -- CUT-DOOR
			AND EXISTS
			(
				SELECT * FROM inventory.Products  AS p
				WHERE p.ProductCode LIKE 'DFG%'
				AND il.ProductID = p.ProductID
			)
		) AS cd
		OUTER APPLY
		(
			SELECT 1 CutRod FROM dbo.TranEntry te
			JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = te.ItemNumber
			WHERE te.EZParentProdID = oi.EZProdID AND te.isDeleted = 0 AND te.isActive = 1
			AND TIL.ID = 106910 		
		) AS CutRod
		OUTER APPLY
		(
			SELECT CAST( CASE WHEN EXISTS
			(
				SELECT * FROM inventory.ProductToProductTags AS ptpt
				WHERE ptpt.ProductId = ilp.ProductID
				AND ptpt.DeleteFlag = 0
				AND ptpt.ProductTagId IN (25, 24)
			) 
			THEN 1 ELSE 0 END AS BIT)
		)AS Gets7(Gets7)
		OUTER APPLY
		(
			SELECT 10 AS Ten 
			FROM @materialDetails AS md2
			JOIN dbo.tb_ItemList AS til ON md2.InventoryID = til.AcumaticaName
			WHERE til.ComponentPartTypeId = 6
			AND EXISTS
			(
				SELECT * FROM dbo.TranEntry AS subItem 
				WHERE subItem.OrderID = oi.OrderId
				AND subItem.EZParentProdID = oi.EZProdID
				AND subItem.ItemNumber = 'UP CHARGE:Finishing:MATCH-INTERIOR'
				AND subItem.isDeleted = 0
			)
			AND NOT EXISTS
			(
				SELECT * FROM dbo.TranEntry AS subItem 
				WHERE subItem.OrderID = oi.OrderId
				AND subItem.EZParentProdID = oi.EZProdID
				AND subItem.ItemNumber NOT IN ('UP CHARGE:CUT-DOOR', 'UP CHARGE:Finishing:MATCH-INTERIOR')
				AND subItem.isDeleted = 0
			)
			AND il.ComponentPartTypeId = 9
		)AS Gets10
		OUTER APPLY
		( 
			 SELECT 1 AdjustedDepth FROM dbo.tb_AdjustedBoxDimensions TABD
			 WHERE TABD.TranEntryID = oi.OrderItemId
			 AND TABD.AdjustDepth < 0
		) Adj
		OUTER APPLY
		(
			SELECT CAST( CASE WHEN EXISTS
			(
				SELECT 1 FROM inventory.ProductToProductTags AS ptpt
				WHERE ptpt.ProductId = ilp.ProductID
				AND ptpt.DeleteFlag = 0
				AND ptpt.ProductTagId IN (19)
			) 
			THEN 1 ELSE 0 END AS BIT) ParentIsTagHood
		)AS HoodRule
		OUTER APPLY
		(
			SELECT CAST( CASE WHEN EXISTS
			(
				SELECT 1 FROM inventory.ProductToProductTags AS ptpt
				WHERE ptpt.ProductId = ilp.ProductID
				AND ptpt.DeleteFlag = 0
				AND ptpt.ProductTagId IN (97)
			)
			THEN 1 ELSE 0 END AS BIT) GoesToPantry
		)AS Pantry
		OUTER APPLY
		(
			SELECT TOP 1 ilbp.ID AS itemlistIdToPrint 
			FROM dbo.tb_ItemList ilbp 
			JOIN @materialDetails AS md ON  md.InventoryID = ilbp.AcumaticaName AND ilbp.ComponentPartTypeId=1 
			ORDER BY CASE WHEN  ilbp.ItemCode LIKE '%WDC%' AND  ilbp.ItemCode NOT LIKE '%C' THEN 1 ELSE 0 END  
		) backPanel
		OUTER APPLY --FF-705
		(
			SELECT 12 AS PickingType
			WHERE NOT EXISTS
			(
				SELECT * FROM acumaticaManufacturing.BillOfMaterials AS bom
				JOIN acumaticaManufacturing.BillOfMaterialDetails AS bomd ON bomd.BOMID = bom.BOMID
				WHERE bom.Status = 'Active'
				AND bom.DeleteFlag = 0
				AND bomd.DeleteFlag = 0
				AND md.InventoryID = bomd.InventoryID
				AND bom.InventoryID = @ProductionItemCode
				AND bom.Revision = oi.Revision
			)
			AND COALESCE(piptProduct.PickingTypeId, pipt.PickingTypeId, DefaultPickingType.PickingTypeId, 2) = 2
		)AS NotInDefaultBom
			  
	DECLARE @countOfType1Items INT

	SELECT @countOfType1Items = COUNT(*) FROM @ProductionOrderDetailSkus AS pods 
	WHERE pods.PickingTypeId = 1

	IF @countOfType1Items > 1
	BEGIN	    
		UPDATE TOP (@countOfType1Items - 1) pods SET pods.PickingTypeId = 2 FROM @ProductionOrderDetailSkus AS pods
		WHERE PickingTypeId = 1
	END

  RETURN 

END

GO
/****** Object:  UserDefinedFunction [picking].[GetReplacementProductionItems]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Aron Steinmetz>
-- Create date: <12-6-2019>
-- Description:	<Returns availabel production items, that picked items could be moved to them.>
-- =============================================
CREATE FUNCTION [picking].[GetReplacementProductionItems]
(
	@originalProductionItemId INT
)
RETURNS @returnVal TABLE
(
	ProductionItemId INT,
	PIId VARCHAR(50),
	PickingDate DATE,
	OrderItemId INT,
	IsExactMatch BIT,
	ItemCode VARCHAR(150)
)
AS BEGIN
	DECLARE @originalPid TABLE(amount INT, ItemlistId INT, Sandbox BIT)
	DECLARE @ReplacementPid TABLE (ProductionItemId INT, ItemlistId INT, Picked BIT, PickingDate DATE, ProductionItemDetailId INT, PIId VARCHAR(50), OrderItemId INT)
	DECLARE @otherItemsOnReplacement_Grouped TABLE(amount INT, ItemlistId INT, ProductionItemId INT)
	
	INSERT @originalPid	( amount, ItemlistId, Sandbox)
	SELECT COUNT(*) amount, originalPid.ItemlistId , originalPi.Sandbox FROM Picking.ProductionItem AS originalPi
	JOIN Picking.ProductionItemDetail AS originalPid ON originalPid.ProductionItemId = originalPi.ProductionItemId AND originalPi.Deleted = 0
	WHERE originalPid.ProductionItemId = @originalProductionItemId  AND originalPid.Picked = 1 AND originalPid.PickingTypeId IN (1, 2)
	GROUP BY originalPid.ItemlistId,
             originalPi.Sandbox

	INSERT @ReplacementPid(ProductionItemId, ItemlistId, Picked, PickingDate, ProductionItemDetailId, PIId, OrderItemId)
	SELECT ReplacementPid.ProductionItemId, op.ItemlistId, ReplacementPid.Picked, pi.PickingDate, ReplacementPid.ProductionItemDetailId, pi.PIId, te.ID AS OrderItemId
	FROM Picking.ProductionItemDetail AS ReplacementPid 
		JOIN @originalPid AS op ON op.ItemlistId = ReplacementPid.ItemlistId 
		JOIN Picking.ProductionItem AS pi ON pi.ProductionItemId = ReplacementPid.ProductionItemId AND pi.Sandbox = op.Sandbox
		JOIN dbo.TranEntry AS te ON te.ID = pi.OrderItemId
		AND ReplacementPid.ProductionItemId <> @originalProductionItemId
		WHERE NOT EXISTS(SELECT * FROM Picking.ProductionItemDetail AS pid WHERE ReplacementPid.ProductionItemId = pid.ProductionItemId AND pid.Picked = 1 AND pid.Deleted = 0)
		AND te.isDeleted = 0 
		AND te.isActive = 1
		AND pi.Deleted = 0
		AND	ReplacementPid.Deleted = 0
		AND NOT EXISTS (SELECT * FROM @originalPid AS opid2 WHERE 
		NOT EXISTS (SELECT * FROM Picking.ProductionItemDetail AS pid WHERE pid.ProductionItemId= ReplacementPid.ProductionItemId  AND pid.PickingTypeId IN(1,2) AND pid.Deleted = 0 AND pid.ItemlistId=opid2.itemlistid ) )
		AND ReplacementPid.PickingTypeId IN (1, 2)
		AND te.FWPONumber IS NULL
		AND NOT EXISTS(SELECT * FROM dbo.tb_ItemSeriel AS tis WHERE tis.TranEntryID = te.ID)
		AND NOT EXISTS(SELECT * FROM dbo.tb_AccBoxNumberItems AS tabni WHERE tabni.TranEntryID = te.ID)
	
	INSERT @otherItemsOnReplacement_Grouped	(amount, ItemlistId, ProductionItemId)
	SELECT COUNT(*)  amount, pid.ItemlistId, pid.ProductionItemId FROM Picking.ProductionItemDetail AS pid
	WHERE pid.PickingTypeId IN (1,2) AND pid.Deleted = 0
	AND EXISTS(SELECT * FROM @ReplacementPid AS rp WHERE rp.ProductionItemId = pid.ProductionItemId)
	GROUP BY pid.ItemlistId, pid.ProductionItemId
	
	INSERT @returnVal
	(ProductionItemId, PIId, PickingDate, OrderItemId, IsExactMatch, ItemCode)
	SELECT DISTINCT TOP(10) rp.ProductionItemId, rp.PIId, rp.PickingDate, rp.OrderItemId,
	CAST(CASE WHEN match.notExact IS NULL THEN 1 ELSE 0 END AS BIT) IsExactMatch, til.ShortItemCode AS ItemCode
	FROM @ReplacementPid rp
	JOIN picking.ProductionItem AS pi ON pi.ProductionItemId = rp.ProductionItemId
	JOIN dbo.tb_ItemList AS til ON til.ID = pi.ItemlistId
	OUTER APPLY(SELECT 1 notExact 
		WHERE EXISTS(SELECT * FROM @otherItemsOnReplacement_Grouped oiorg
			WHERE NOT EXISTS(SELECT * FROM @originalPid op WHERE op.ItemlistId = oiorg.ItemlistId))
		OR EXISTS (SELECT * FROM @otherItemsOnReplacement_Grouped oiorg
		JOIN @originalPid op ON op.ItemlistId = oiorg.ItemlistId 
			WHERE oiorg.amount <> op.amount)	
	)match
RETURN
END


GO
/****** Object:  UserDefinedFunction [picking].[GetResetProductionItemDetailsToPick]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Aron Steinmetz
-- Create date: 12/8/2020
-- =============================================
CREATE FUNCTION [picking].[GetResetProductionItemDetailsToPick]
(
	@resetDepartmentIds IDList READONLY
)
RETURNS @returnVal TABLE (ProductionItemId INT NOT NULL, ProductionItemDetailId INT NOT NULL, TrackingLocationsTypeName VARCHAR(50) NOT NULL, ResetPiStatusLocationId INT NOT NULL)
AS BEGIN

DECLARE @departmentStatusId INT
SELECT TOP (1) @departmentStatusId = te.DepartmentstatusID
FROM picking.ResetPiStatusLocation AS rpsl
JOIN dbo.TranEntry AS te ON te.DepartmentstatusID = rpsl.DepartmentStatusId
JOIN Picking.ProductionItem AS pi ON pi.OrderItemId = te.ID
JOIN picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi.ProductionItemId
WHERE pi.Deleted = 0
AND te.isDeleted = 0
AND te.isActive = 1
AND te.ItemType IN(1,2,3,7,12)
AND pid.Deleted = 0
AND pid.PickingTypeId = 18
AND pid.Picked = 0
AND NOT EXISTS
(
	SELECT * FROM picking.PickingTaskProductionItems AS ptpi
	JOIN picking.PickingTaskProductionItemsDetail AS ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId
	WHERE ptpi.Active = 1
	AND ptpid.Active = 1
	AND ptpid.ProductionItemDetailId = pid.ProductionItemDetailId
	AND ptpi.ProductionItemsPickingTaskStatusId IN (1, 2)
	AND ptpid.Picked IN (0,1)
	AND ptpid.ForMissingParts IN (0,1)
)
AND EXISTS
(
	SELECT * FROM @resetDepartmentIds AS rdi
	WHERE rdi.ID = rpsl.ResetPiStatusLocationId
)
ORDER BY pi.PickingDate, pi.AddDate, pi.ProductionItemId

INSERT @returnVal (ProductionItemId, ProductionItemDetailId, TrackingLocationsTypeName, ResetPiStatusLocationId)
SELECT TOP (20) pi.ProductionItemId, pid.ProductionItemDetailId, tlt.TrackingLocationsTypeName, rpsl.ResetPiStatusLocationId
FROM picking.ResetPiStatusLocation AS rpsl
JOIN dbo.TrackingLocationsType AS tlt ON tlt.TrackingLocationsTypeId = rpsl.TrackingLocationsTypeId
JOIN dbo.Departmentstatus AS d ON d.ID = rpsl.DepartmentStatusId
JOIN dbo.TranEntry AS te ON te.DepartmentstatusID = rpsl.DepartmentStatusId
JOIN Picking.ProductionItem AS pi ON pi.OrderItemId = te.ID
JOIN picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi.ProductionItemId
WHERE pi.Deleted = 0
AND te.isDeleted = 0
AND te.isActive = 1
AND te.ItemType IN(1,2,3,7,12)
AND pid.Deleted = 0
AND pid.PickingTypeId = 18
AND pid.Picked = 0
AND NOT EXISTS
(
	SELECT * FROM picking.PickingTaskProductionItems AS ptpi
	JOIN picking.PickingTaskProductionItemsDetail AS ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId
	WHERE ptpi.Active = 1
	AND ptpid.Active = 1
	AND ptpid.ProductionItemDetailId = pid.ProductionItemDetailId
	AND ptpi.ProductionItemsPickingTaskStatusId IN (1, 2)
	AND ptpid.Picked IN (0,1)
	AND ptpid.ForMissingParts IN (0,1)
)
AND te.DepartmentstatusID = @departmentStatusId
ORDER BY pi.PickingDate, pi.AddDate, pi.ProductionItemId


RETURN
END






GO
/****** Object:  UserDefinedFunction [picking].[GetResetProductionItemDetailsToPick_FF_507]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Aron Steinmetz
-- Create date: 12/8/2020
-- =============================================
CREATE FUNCTION [picking].[GetResetProductionItemDetailsToPick_FF_507]
(
	@ResetPiPickingBucketIds IDList READONLY
)
RETURNS @returnVal TABLE (ProductionItemId INT NOT NULL, ProductionItemDetailId INT NOT NULL, TrackingLocationsTypeName VARCHAR(50) NOT NULL, ResetPiStatusLocationId INT NOT NULL, 
ResetPiPickingBucketId INT NOT NULL)
AS BEGIN
DECLARE @ResetPiPickingBucketId INT

SELECT TOP (1) @ResetPiPickingBucketId = rppb.ID FROM @ResetPiPickingBucketIds AS rppb
JOIN picking.ResetPiPickingBucket AS rppb3 ON rppb.ID=rppb3.ResetPiPickingBucketId
JOIN picking.ResetPiStatusLocation AS rpsl ON rpsl.ResetPiStatusLocationId = rppb3.ResetPiStatusLocationId
JOIN Picking.ProductionItemDetail AS pid ON pid.PickingTypeId = 18
JOIN Picking.ProductionItem AS pi ON pi.ProductionItemId = pid.ProductionItemId
JOIN dbo.TranEntry AS te ON te.ID = pi.OrderItemId
JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
WHERE (NOT EXISTS
(
	SELECT * FROM picking.ResetPiPickingBucketLocationType AS rppblt
	WHERE rppb.ID = rppblt.ResetPiPickingBucketId
	AND rppblt.Active = 1
	AND NOT EXISTS
	(
		SELECT * FROM picking.ResetPiPickingBucket AS rppb2
		JOIN picking.ResetPiPickingBucketLocationType AS rppblt2 ON rppblt2.ResetPiPickingBucketId = rppb2.ResetPiPickingBucketId
		WHERE rppb2.Active = 1
		AND rppblt2.Active = 2
		AND rppb2.ResetPiStatusLocationId = rppb.ID
		AND EXISTS
		(
			SELECT * FROM dbo.InventoryLocationDefaultItemCode AS ildic
			JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID
			WHERE ildic.ItemCode = til.ShortItemCode
			AND il.LocationType = rppblt2.LocationTypeId
		)
	)
)
OR EXISTS
(
	SELECT * FROM picking.ResetPiPickingBucketLocationType AS rppblt
	WHERE rppb.ID = rppblt.ResetPiPickingBucketId
	AND rppblt.Active = 1
	AND EXISTS
	(
		SELECT * FROM dbo.InventoryLocationDefaultItemCode AS ildic
		JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID
		WHERE ildic.ItemCode = til.ShortItemCode
		AND il.LocationType = rppblt.LocationTypeId
	)
))
AND rpsl.DepartmentStatusId=te.DepartmentstatusID
AND pi.Deleted = 0
AND te.isDeleted = 0
AND te.isActive = 1
AND te.ItemType IN(1,2,3,7,12)
AND pid.Deleted = 0
AND pid.PickingTypeId = 18
AND pid.Picked = 0
AND NOT EXISTS
(
	SELECT * FROM picking.PickingTaskProductionItems AS ptpi
	JOIN picking.PickingTaskProductionItemsDetail AS ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId
	WHERE ptpi.Active = 1
	AND ptpid.Active = 1
	AND ptpid.ProductionItemDetailId = pid.ProductionItemDetailId
	AND ptpi.ProductionItemsPickingTaskStatusId IN (1, 2)
	AND ptpid.Picked IN (0,1)
	AND ptpid.ForMissingParts IN (0,1)
)
ORDER BY pi.PickingDate, pi.AddDate, pi.ProductionItemId


INSERT @returnVal (ProductionItemId, ProductionItemDetailId, TrackingLocationsTypeName, ResetPiStatusLocationId, ResetPiPickingBucketId)

SELECT TOP (20)  pi.ProductionItemId, pid.ProductionItemDetailId, rpsl.TrackingLocationsTypeId, rpsl.ResetPiStatusLocationId, rppb.ResetPiPickingBucketId
FROM picking.ResetPiPickingBucket AS rppb
JOIN picking.ResetPiStatusLocation AS rpsl ON rpsl.ResetPiStatusLocationId = rppb.ResetPiStatusLocationId
JOIN Picking.ProductionItemDetail AS pid ON pid.PickingTypeId = 18
JOIN Picking.ProductionItem AS pi ON pi.ProductionItemId = pid.ProductionItemId
JOIN dbo.TranEntry AS te ON te.ID = pi.OrderItemId
JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
WHERE 
(
	NOT EXISTS
	(
		SELECT * FROM picking.ResetPiPickingBucketLocationType AS rppblt
		WHERE rppb.ResetPiPickingBucketId = rppblt.ResetPiPickingBucketId
		AND rppblt.Active = 1
		AND NOT EXISTS
		(
			SELECT * FROM picking.ResetPiPickingBucket AS rppb2
			JOIN picking.ResetPiPickingBucketLocationType AS rppblt2 ON rppblt2.ResetPiPickingBucketId = rppb2.ResetPiPickingBucketId
			WHERE rppb2.Active = 1
			AND rppblt2.Active = 2
			AND rppb2.ResetPiStatusLocationId = rpsl.ResetPiStatusLocationId
			AND EXISTS
			(
				SELECT * FROM dbo.InventoryLocationDefaultItemCode AS ildic
				JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID
				WHERE ildic.ItemCode = til.ShortItemCode
				AND il.LocationType = rppblt2.LocationTypeId
			)
		)
	)
	OR EXISTS
	(
		SELECT * FROM picking.ResetPiPickingBucketLocationType AS rppblt
		WHERE rppb.ResetPiPickingBucketId = rppblt.ResetPiPickingBucketId
		AND rppblt.Active = 1
		AND EXISTS
		(
			SELECT * FROM dbo.InventoryLocationDefaultItemCode AS ildic
			JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID
			WHERE ildic.ItemCode = til.ShortItemCode
			AND il.LocationType = rppblt.LocationTypeId
		)
	)
)
AND pi.Deleted = 0
AND te.isDeleted = 0
AND te.isActive = 1
AND te.ItemType IN(1,2,3,7,12)
AND pid.Deleted = 0
AND pid.PickingTypeId = 18
AND pid.Picked = 0
AND NOT EXISTS
(
	SELECT * FROM picking.PickingTaskProductionItems AS ptpi
	JOIN picking.PickingTaskProductionItemsDetail AS ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId
	WHERE ptpi.Active = 1
	AND ptpid.Active = 1
	AND ptpid.ProductionItemDetailId = pid.ProductionItemDetailId
	AND ptpi.ProductionItemsPickingTaskStatusId IN (1, 2)
	AND ptpid.Picked IN (0,1)
	AND ptpid.ForMissingParts IN (0,1)
)
AND rppb.ResetPiPickingBucketId = @ResetPiPickingBucketId
AND te.DepartmentstatusID = rpsl.DepartmentStatusId
ORDER BY pi.PickingDate, pi.AddDate, pi.ProductionItemId

RETURN
END






GO
/****** Object:  UserDefinedFunction [picking].[GetResetProductionItemDetailsToPick_FF_590]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--SET QUOTED_IDENTIFIER ON
--SET ANSI_NULLS ON
--GO
-- =============================================
-- Author:		Aron Steinmetz
-- Create date: 2/11/2021
-- =============================================
CREATE FUNCTION [picking].[GetResetProductionItemDetailsToPick_FF_590]
(
	@ResetPiPickingBucketIds IDList READONLY
)
RETURNS @returnVal TABLE (ProductionItemId INT NOT NULL, ProductionItemDetailId INT NOT NULL, TrackingLocationsTypeName VARCHAR(50) NOT NULL, ResetPiStatusLocationId INT NOT NULL, 
ResetPiPickingBucketId INT NOT NULL)
AS BEGIN
DECLARE @ResetPiPickingBucketId INT

SELECT TOP (1) @ResetPiPickingBucketId = rppb.ID 
FROM @ResetPiPickingBucketIds AS rppb
JOIN picking.ResetPiPickingBucket AS rppb3 ON rppb.ID=rppb3.ResetPiPickingBucketId
JOIN picking.ResetPiStatusLocation AS rpsl ON rpsl.ResetPiStatusLocationId = rppb3.ResetPiStatusLocationId
JOIN Picking.ProductionItemDetail AS pid ON pid.PickingTypeId = 18
JOIN picking.PiDetailResetItem AS pdri ON pdri.ResetPiStatusLocationId = rpsl.ResetPiStatusLocationId AND pdri.ProductionItemDetailId = pid.ProductionItemDetailId
JOIN Picking.ProductionItem AS pi ON pi.ProductionItemId = pid.ProductionItemId
JOIN picking.PiResetItem AS pri ON pri.ResetPiStatusLocationId = rpsl.ResetPiStatusLocationId AND pri.ProductionItemId = pi.ProductionItemId
JOIN dbo.TranEntry AS te ON te.ID = pi.OrderItemId
JOIN dbo.Departmentstatus AS teStatus ON teStatus.ID = te.DepartmentstatusID
JOIN dbo.[Order] AS o ON o.ID = te.OrderID
JOIN dbo.Departmentstatus AS orderStatus ON o.Departmentstatusid = orderStatus.ID
JOIN dbo.QuotesStatus AS qs ON qs.QuoteNumber = o.SOnumber
JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
WHERE 
(
	NOT EXISTS
	(
		SELECT * FROM picking.ResetPiPickingBucketLocationType AS rppblt
		WHERE rppb.ID = rppblt.ResetPiPickingBucketId
		AND rppblt.Active = 1
		AND NOT EXISTS
		(
			SELECT * FROM picking.ResetPiPickingBucket AS rppb2
			JOIN picking.ResetPiPickingBucketLocationType AS rppblt2 ON rppblt2.ResetPiPickingBucketId = rppb2.ResetPiPickingBucketId
			WHERE rppb2.Active = 1
			AND rppblt2.Active = 2
			AND rppb2.ResetPiStatusLocationId = rppb.ID
			AND EXISTS
			(
				SELECT * FROM dbo.InventoryLocationDefaultItemCode AS ildic
				JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID
				WHERE ildic.ItemCode = til.ShortItemCode
				AND il.LocationType = rppblt2.LocationTypeId
			)
		)
	)
	OR EXISTS
	(
		SELECT * FROM picking.ResetPiPickingBucketLocationType AS rppblt
		WHERE rppb.ID = rppblt.ResetPiPickingBucketId
		AND rppblt.Active = 1
		AND EXISTS
		(
			SELECT * FROM dbo.InventoryLocationDefaultItemCode AS ildic
			JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID
			WHERE ildic.ItemCode = til.ShortItemCode
			AND il.LocationType = rppblt.LocationTypeId
		)
	)
)
AND pi.Deleted = 0
AND te.isDeleted = 0
AND te.isActive = 1
AND te.ItemType IN(1,2,3,7,12)
AND pid.Deleted = 0
AND pid.PickingTypeId = 18
AND pid.Picked = 0
AND qs.QuoteStatus = 'SALES ORDER'
AND orderStatus.isShipped = 0
AND pri.Deleted = 0
AND pri.PiResetStatusId <> 2
AND pdri.Deleted = 0
AND pdri.PiResetStatusId <> 2
AND NOT EXISTS
(
	SELECT * FROM picking.PickingTaskProductionItems AS ptpi
	JOIN picking.PickingTaskProductionItemsDetail AS ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId
	WHERE ptpi.Active = 1
	AND ptpid.Active = 1
	AND ptpid.ProductionItemDetailId = pid.ProductionItemDetailId
	AND ptpi.ProductionItemsPickingTaskStatusId IN (1, 2)
	AND ptpid.Picked IN (0,1)
	AND ptpid.ForMissingParts IN (0,1)
)
AND teStatus.isShipped = 0--FF-720
ORDER BY pi.PickingDate, pi.AddDate, pi.ProductionItemId


INSERT @returnVal (ProductionItemId, ProductionItemDetailId, TrackingLocationsTypeName, ResetPiStatusLocationId, ResetPiPickingBucketId)

SELECT TOP (20)  pi.ProductionItemId, pid.ProductionItemDetailId, rpsl.TrackingLocationsTypeId, rpsl.ResetPiStatusLocationId, rppb.ResetPiPickingBucketId
FROM picking.ResetPiPickingBucket AS rppb
JOIN picking.ResetPiStatusLocation AS rpsl ON rpsl.ResetPiStatusLocationId = rppb.ResetPiStatusLocationId
JOIN Picking.ProductionItemDetail AS pid ON pid.PickingTypeId = 18
JOIN picking.PiDetailResetItem AS pdri ON pdri.ResetPiStatusLocationId = rpsl.ResetPiStatusLocationId AND pdri.ProductionItemDetailId = pid.ProductionItemDetailId
JOIN Picking.ProductionItem AS pi ON pi.ProductionItemId = pid.ProductionItemId
JOIN picking.PiResetItem AS pri ON pri.ResetPiStatusLocationId = rpsl.ResetPiStatusLocationId AND pri.ProductionItemId = pi.ProductionItemId
JOIN dbo.TranEntry AS te ON te.ID = pi.OrderItemId
JOIN dbo.Departmentstatus AS teStatus ON teStatus.ID = te.DepartmentstatusID
JOIN dbo.[Order] AS o ON o.ID = te.OrderID
JOIN dbo.Departmentstatus AS orderStatus ON o.Departmentstatusid = orderStatus.ID
JOIN dbo.QuotesStatus AS qs ON qs.QuoteNumber = o.SOnumber
JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
WHERE 
(
	NOT EXISTS
	(
		SELECT * FROM picking.ResetPiPickingBucketLocationType AS rppblt
		WHERE rppb.ResetPiPickingBucketId = rppblt.ResetPiPickingBucketId
		AND rppblt.Active = 1
		AND NOT EXISTS
		(
			SELECT * FROM picking.ResetPiPickingBucket AS rppb2
			JOIN picking.ResetPiPickingBucketLocationType AS rppblt2 ON rppblt2.ResetPiPickingBucketId = rppb2.ResetPiPickingBucketId
			WHERE rppb2.Active = 1
			AND rppblt2.Active = 2
			AND rppb2.ResetPiStatusLocationId = rpsl.ResetPiStatusLocationId
			AND EXISTS
			(
				SELECT * FROM dbo.InventoryLocationDefaultItemCode AS ildic
				JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID
				WHERE ildic.ItemCode = til.ShortItemCode
				AND il.LocationType = rppblt2.LocationTypeId
			)
		)
	)
	OR EXISTS
	(
		SELECT * FROM picking.ResetPiPickingBucketLocationType AS rppblt
		WHERE rppb.ResetPiPickingBucketId = rppblt.ResetPiPickingBucketId
		AND rppblt.Active = 1
		AND EXISTS
		(
			SELECT * FROM dbo.InventoryLocationDefaultItemCode AS ildic
			JOIN dbo.InventoryLocation AS il ON il.ID = ildic.LocationID
			WHERE ildic.ItemCode = til.ShortItemCode
			AND il.LocationType = rppblt.LocationTypeId
		)
	)
)
AND pi.Deleted = 0
AND te.isDeleted = 0
AND te.isActive = 1
AND te.ItemType IN(1,2,3,7,12)
AND pid.Deleted = 0
AND pid.PickingTypeId = 18
AND pid.Picked = 0
AND qs.QuoteStatus = 'SALES ORDER'
AND orderStatus.isShipped = 0
AND pri.Deleted = 0
AND pri.PiResetStatusId <> 2
AND pdri.Deleted = 0
AND pdri.PiResetStatusId <> 2
AND NOT EXISTS
(
	SELECT * FROM picking.PickingTaskProductionItems AS ptpi
	JOIN picking.PickingTaskProductionItemsDetail AS ptpid ON ptpid.PickingTaskProductionItemsId = ptpi.PickingTaskProductionItemsId
	WHERE ptpi.Active = 1
	AND ptpid.Active = 1
	AND ptpid.ProductionItemDetailId = pid.ProductionItemDetailId
	AND ptpi.ProductionItemsPickingTaskStatusId IN (1, 2)
	AND ptpid.Picked IN (0,1)
	AND ptpid.ForMissingParts IN (0,1)
)
AND rppb.ResetPiPickingBucketId = @ResetPiPickingBucketId
AND teStatus.isShipped = 0--FF-720
ORDER BY pi.PickingDate, pi.AddDate, pi.ProductionItemId

RETURN
END
GO
/****** Object:  UserDefinedFunction [picking].[GetShelfClipItemCode]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[GetShelfClipItemCode]
(
	@OrderItemId INT
)
RETURNS 
@ShelfClipLocation TABLE 
(
	ItemCode VARCHAR(50) NOT NULL
)
AS
BEGIN		
		DECLARE @qty INT 
		DECLARE @itemlistid INT
		DECLARE @ItemCode VARCHAR(50)
		--DECLARE @Location  VARCHAR(150)


		SELECT @qty = COUNT(*) , @itemlistid = pid.ItemlistId 
		FROM picking.ProductionItemDetail AS pid 
		JOIN picking.ProductionItem AS pi ON pi.ProductionItemId = pid.ProductionItemId
		WHERE pi.OrderItemId = @OrderItemId AND pid.PickingTypeId =9 AND pid.Deleted = 0 GROUP BY pid.ItemlistId		

		SELECT  @ItemCode =
		CASE @qty   
			   WHEN 4  THEN CASE WHEN @itemlistid = 122889 THEN 'AS-CLIP-1' ELSE 'VS-CLIP-1' END
			   WHEN 8  THEN CASE WHEN @itemlistid = 122889 THEN 'AS-CLIP-2' ELSE 'VS-CLIP-2' END
			   WHEN 12 THEN CASE WHEN @itemlistid = 122889 THEN 'AS-CLIP-3' ELSE 'VS-CLIP-3' END
			   WHEN 16 THEN CASE WHEN @itemlistid = 122889 THEN 'AS-CLIP-4' ELSE 'VS-CLIP-4' END
			   WHEN 20 THEN CASE WHEN @itemlistid = 122889 THEN 'AS-CLIP-5' ELSE 'VS-CLIP-5' END
			   WHEN 24 THEN CASE WHEN @itemlistid = 122889 THEN 'AS-CLIP-6' ELSE 'VS-CLIP-6' END
		   ELSE NULL
		   END 
		   
		   IF @ItemCode IS NULL 
			RETURN

		   --SELECT TOP (1) @Location = ilu.Location FROM dbo.ItemLocationsUpdate AS ilu 
		   --WHERE ilu.ItemCode=@ItemCode AND ilu.Quantity > 0
		   --AND EXISTS (SELECT * FROM dbo.InventoryLocation AS il WHERE il.Location=ilu.Location AND  il.LocationType  NOT IN(13) AND il.ExcludeFrmStock=0 ) 
		   
		   INSERT @ShelfClipLocation(ItemCode)
		   VALUES(@ItemCode);

		   RETURN
END 
GO
/****** Object:  UserDefinedFunction [picking].[GetShelfClips]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [picking].[GetShelfClips]
(
	@MaterialList OrderMaterialDetail READONLY,
	@InventoryId VARCHAR(50)
)
RETURNS 
@AddremoveRules TABLE 
(
	AddRemoveAction VARCHAR(10) DEFAULT ('Add'),
	InventoryId VARCHAR(50),
	Quantity INT DEFAULT(1),
	QuantityAll BIT DEFAULT(0),
	WorkCenter VARCHAR(50) DEFAULT ( 'PICKING'),
	OperationDescription VARCHAR(400) DEFAULT ('Picking Dept.'),
	OperationNumber VARCHAR(10),
	BackflushLabor BIT DEFAULT(1)
)
AS
BEGIN
	IF NOT EXISTS (SELECT * FROM picking.DestinationLocationItemRule dlir JOIN dbo.tb_ItemList il ON il.ID = dlir.ProductionItemItemlistId WHERE il.AcumaticaName=@InventoryId AND dlir.DestinationLocationId IN(32,33,34,35)
 )
		RETURN

	INSERT @AddremoveRules (  InventoryId )
	SELECT s.itemcode FROM @MaterialList ml JOIN dbo.tb_ItemList il ON il.AcumaticaName = ml.InventoryID
	CROSS APPLY (SELECT TOP 1 ds.SeriesName FROM dbo.tb_ItemList il2 JOIN inventory.DoorStyles ds ON ds.DoorStyleID = il2.DoorStyleID  WHERE il2.AcumaticaName = @InventoryId) SeriesName
	CROSS APPLY (  SELECT 
			CASE ml.Quantity * 4
			   WHEN 4  THEN CASE WHEN SeriesName.SeriesName = 'Allure' THEN 'AS-CLIP-1' ELSE 'VS-CLIP-1' END
			   WHEN 8  THEN CASE WHEN SeriesName.SeriesName = 'Allure' THEN 'AS-CLIP-2' ELSE 'VS-CLIP-2' END
			   WHEN 12 THEN CASE WHEN SeriesName.SeriesName = 'Allure' THEN 'AS-CLIP-3' ELSE 'VS-CLIP-3' END
			   WHEN 16 THEN CASE WHEN SeriesName.SeriesName = 'Allure' THEN 'AS-CLIP-4' ELSE 'VS-CLIP-4' END
			   WHEN 20 THEN CASE WHEN SeriesName.SeriesName = 'Allure' THEN 'AS-CLIP-5' ELSE 'VS-CLIP-5' END
			   WHEN 24 THEN CASE WHEN SeriesName.SeriesName = 'Allure' THEN 'AS-CLIP-6' ELSE 'VS-CLIP-6' END
		   ELSE CASE WHEN SeriesName.SeriesName = 'Allure' THEN 'AS-CLIP-6' ELSE 'VS-CLIP-6' END
		   END AS itemcode 
	) s
	WHERE il.ComponentPartTypeId IN( 9,29)
	RETURN 
END

GO
/****** Object:  UserDefinedFunction [picking].[GetSkinBonus]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [picking].[GetSkinBonus] 
(
	@picker int
)
RETURNS @BonusInfo TABLE 
(
	[Date] DATE NOT NULL,
	Name NVARCHAR(150) NOT NULL,
	PID VARCHAR(50) NULL,
	WorkedMin DECIMAL(18,2),
	MinExtraPerDay DECIMAL (18,2),
	Bonus VARCHAR(25) NULL,
	WorkedMinFinal DECIMAL (18,2),
	TotalCabinets INT NULL,
	TotalSkin INT NULL
)
AS	
BEGIN
	DECLARE @datefrom DATE = GETDATE();

	DECLARE @WorkedMin TABLE([Date] DATE NOT NULL , WorkedMin INT NOT NULL)
	DECLARE @Scans TABLE (TranentryID INT NOT NULL,Addtime  DATETIME NOT NULL,DepartmentstatusID INT NOT NULL,UserID INT NOT NULL, Finish VARCHAR(50) NULL, SkinMinutes DECIMAL (18,2) ) 
	DECLARE @SkinMinutes DECIMAL(18,2) , @TotalCabinets INT , @TotalSkins INT
	INSERT @WorkedMin(Date,WorkedMin)
	SELECT DateValue,  CASE WHEN fsu.DayOfWeek = 'Friday' THEN fsu.minutes - 10 ELSE fsu.minutes -20 END FROM dbo.fn_schedule( @datefrom,@datefrom,'GLOBAL') fsu
	
	INSERT @Scans(TranentryID,Addtime,DepartmentstatusID,UserID,Finish,SkinMinutes)
	SELECT H.TranentryID,MIN(H.Addtime) AS AddTime,H.DepartmentstatusID,H.UserID , te.Finish, TIL.SkinMinutes 
	FROM dbo.History AS H 
	JOIN dbo.[User] AS U ON U.ID = H.UserID
	JOIN dbo.TranEntry AS TE ON TE.ID = H.TranentryID
	JOIN dbo.tb_ItemList AS TIL ON TIL.ItemCode = TE.ItemNumber
	JOIN @WorkedMin AS WM ON WM.Date = CAST(H.Addtime AS DATE)
	WHERE H.DepartmentstatusID = 932 AND H.Addtime >= @datefrom AND U.ID = @picker
	GROUP BY H.TranentryID,H.DepartmentstatusID,H.UserID,TE.Finish,TIL.SkinMinutes
	
	SELECT	@SkinMinutes = SUM(CASE WHEN s.Finish IN ('Right','Left') THEN s.SkinMinutes WHEN s.Finish = 'Both' THEN s.SkinMinutes + 1.5 ELSE 0 END ),
			@TotalCabinets = COUNT(s.TranentryID),
			@TotalSkins = SUM(CASE WHEN s.Finish IN ('Right','Left') THEN 1 WHEN s.Finish = 'Both' THEN 2 ELSE 0  END)
	FROM @Scans AS s



	INSERT @BonusInfo(Date,Name,PID,WorkedMin,MinExtraPerDay,Bonus,WorkedMinFinal,TotalCabinets,TotalSkin)
	SELECT wm.Date,  u.FirstName, u.PID, @SkinMinutes, @SkinMinutes - wm.WorkedMin, 
		'$'+ CAST(CAST((@SkinMinutes - wm.WorkedMin) * .10 AS DECIMAL(18,2)) AS VARCHAR(24)),
		 wm.WorkedMin, @TotalCabinets, @TotalSkins 
	FROM dbo.[User] AS u 
	JOIN @WorkedMin AS wm ON 1=1
	WHERE u.ID = @picker

   RETURN
END 


GO
/****** Object:  UserDefinedFunction [picking].[GetSkinBonusTest]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [picking].[GetSkinBonusTest] 
(
	@picker int
)
RETURNS @BonusInfo TABLE 
(
	[Date] DATE NOT NULL,
	Name NVARCHAR(150) NOT NULL,
	PID VARCHAR(50) NULL,
	WorkedMin DECIMAL(18,2),
	MinExtraPerDay DECIMAL (18,2),
	Bonus VARCHAR(25) NULL,
	WorkedMinFinal DECIMAL (18,2),
	TotalCabinets INT NULL,
	TotalSkin INT NULL
)
AS	
BEGIN
	DECLARE @datefrom DATE = GETDATE();

	DECLARE @WorkedMin TABLE([Date] DATE NOT NULL , WorkedMin DECIMAL(18,2) NOT NULL)
	DECLARE @Scans TABLE (TranentryID INT NOT NULL,Addtime  DATETIME NOT NULL,DepartmentstatusID INT NOT NULL,UserID INT NOT NULL, Finish VARCHAR(50) NULL, SkinMinutes DECIMAL (18,2) ) 
	DECLARE @SkinMinutes DECIMAL(18,2) , @TotalCabinets INT , @TotalSkins INT
	INSERT @WorkedMin(Date,WorkedMin)
	SELECT DateValue,  CASE WHEN fsu.DayOfWeek = 'Friday' THEN fsu.minutes - 10 ELSE fsu.minutes -20 END FROM dbo.fn_schedule( @datefrom,@datefrom,'GLOBAL') fsu

	
	INSERT @Scans(TranentryID,Addtime,DepartmentstatusID,UserID,Finish,SkinMinutes)
	SELECT H.TranentryID,MIN(H.Addtime) AS AddTime,H.DepartmentstatusID,H.UserID , te.Finish, TIL.SkinMinutes 
	FROM dbo.History AS H 
	JOIN dbo.[User] AS U ON U.ID = H.UserID
	JOIN dbo.TranEntry AS TE ON TE.ID = H.TranentryID
	JOIN dbo.tb_ItemList AS TIL ON TIL.ItemCode = TE.ItemNumber
	JOIN @WorkedMin AS WM ON WM.Date = CAST(H.Addtime AS DATE)
	WHERE H.DepartmentstatusID = 932 AND H.Addtime >= @datefrom AND U.ID = @picker
	GROUP BY H.TranentryID,H.DepartmentstatusID,H.UserID,TE.Finish,TIL.SkinMinutes
	
	SELECT	@SkinMinutes = SUM(CASE WHEN s.Finish IN ('Right','Left') THEN s.SkinMinutes WHEN s.Finish = 'Both' THEN s.SkinMinutes + 1.5 ELSE 0 END ),
			@TotalCabinets = COUNT(s.TranentryID),
			@TotalSkins = SUM(CASE WHEN s.Finish IN ('Right','Left') THEN 1 WHEN s.Finish = 'Both' THEN 2 ELSE 0  END)
	FROM @Scans AS s



	INSERT @BonusInfo(Date,Name,PID,WorkedMin,MinExtraPerDay,Bonus,WorkedMinFinal,TotalCabinets,TotalSkin)
	SELECT wm.Date,  u.FirstName, u.PID, @SkinMinutes, @SkinMinutes - wm.WorkedMin, 
		'$'+ CAST(CAST((@SkinMinutes - wm.WorkedMin) * .10 AS DECIMAL(18,2)) AS VARCHAR(24)),
		 wm.WorkedMin, @TotalCabinets, @TotalSkins 
	FROM dbo.[User] AS u 
	JOIN @WorkedMin AS wm ON 1=1
	WHERE u.ID = @picker

   RETURN
END 




GO
/****** Object:  UserDefinedFunction [picking].[GetSpecialPickingTasksItems]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Yakov Muller
-- Create date: 1/13/2017
-- Description:	Create Special PickingTasks (Rush and other non standard)
-- =============================================
CREATE FUNCTION  [picking].[GetSpecialPickingTasksItems]	
(
	@BucketID INT
)
RETURNS @PickingTaskCreation TABLE(

	[OrderID] [INT] NOT NULL,
	[ItemId] [INT] NOT NULL,
	[BucketId] [INT] NOT NULL,
	[Active] [BIT] NOT NULL,
	[AddTime] [DATETIME] NOT NULL,
	[UniqKey] [VARCHAR](500) NOT NULL,
	[EstimatedCompleteDate] [DATE] NOT NULL,
	[Style] [VARCHAR](50) NULL,
	[ItemCode] [NVARCHAR](150) NOT NULL,
	[ItemNumber] [VARCHAR](150) NOT NULL,
	[Cubicft] [FLOAT] NOT NULL,
	[EZProdID] [VARCHAR](25) NULL,
	[EZParentProdID] [VARCHAR](25) NULL,
	[SOnumber] [NVARCHAR](50) NULL,
	[CustomerName] [NVARCHAR](250) NOT NULL,
	[ItemType] [INT] NOT NULL,
	[ItemTypeCode] [INT] NULL,
	[PickDropLocationID] [INT] NULL,
	[PickingDate] [DATE] NULL,
	[RushOrder] [BIT] NOT NULL,
	[Hinge] [VARCHAR](50) NULL,
	[ItemKD] [BIT] NOT NULL,
	[Updated] [BIT] NULL,
	[AvailableToPick] BIT DEFAULT 1 NOT NULL,
	ParentItemId INT NULL
)
AS
BEGIN
	
	DECLARE @localBucketID INT = @BucketID

	INSERT INTO @pickingTaskCreation
	        ( OrderID ,ItemId ,BucketId ,Active ,AddTime ,UniqKey ,EstimatedCompleteDate ,Style ,ItemCode ,ItemNumber ,Cubicft ,EZProdID ,EZParentProdID ,
	          SOnumber ,CustomerName ,ItemType ,ItemTypeCode ,PickDropLocationID ,PickingDate ,RushOrder ,Hinge ,ItemKD ,Updated)
	SELECT  o.OrderID ,bi.ItemId ,bi.BucketId ,bi.Active ,bi.AddTime ,bi.UniqKey ,o.EstimatedCompleteDate ,te.Style ,il.ShortItemCode AS ItemCode,
						te.ItemNumber ,il.CubicFtKD Cubicft ,te.EZProdID ,te.EZParentProdID ,o.SOnumber ,o.CustomerName ,
						te.ItemType ,il.ItemTypeCode ,bi.DropLocation AS PickDropLocationID,te.PickingDate , o.RushOrder, te.Hinge, te.KD ItemKD, 0 Updated
	FROM    picking.BucketItems bi
			JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
			JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1 
	WHERE   bi.BucketId = @localBucketID AND bi.Active = 1 
	--SD-3331 Prime should only come in bet. 1 and 5 pm
	--AND (o.RushOrder =1 AND(o.CustomerQbListID IS NULL OR o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE())<=16)))
	AND ISNULL(te.FWPONumber,'') = ''  AND te.PickingDate IS NOT NULL 
	AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
	AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14)
	AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
					WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4));

	-- est and esd is from today or before (we might want to take this out)
	INSERT  INTO @pickingTaskCreation ( OrderID ,ItemId ,BucketId ,Active ,AddTime ,UniqKey ,EstimatedCompleteDate ,
					Style, ItemCode,ItemNumber ,Cubicft ,EZProdID ,EZParentProdID ,SOnumber ,CustomerName ,ItemType ,
					ItemTypeCode ,PickDropLocationID ,PickingDate,RushOrder ,Hinge, ItemKD,Updated)
	SELECT  o.OrderID ,bi.ItemId ,bi.BucketId ,bi.Active ,bi.AddTime ,bi.UniqKey ,o.EstimatedCompleteDate ,te.Style ,il.ShortItemCode AS ItemCode,
					te.ItemNumber ,il.CubicFtKD Cubicft ,te.EZProdID ,te.EZParentProdID ,o.SOnumber ,o.CustomerName ,
					te.ItemType ,il.ItemTypeCode ,bi.DropLocation AS PickDropLocationID,te.PickingDate , o.RushOrder, te.Hinge, te.KD ItemKD, 0 Updated
	FROM    picking.BucketItems bi
			JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
			JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1 
	WHERE   bi.BucketId = @localBucketID AND bi.Active = 1 AND bi.AssignedPickingTask IS NULL AND (te.FWPONumber IS NULL OR te.FWPONumber ='') AND te.PickingDate IS NOT NULL 
	AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14) 
	AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
	AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
					WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))
	AND NOT EXISTS ( SELECT 1 FROM @pickingTaskCreation ti WHERE o.OrderID = ti.OrderID )		
	AND CAST(ISNULL(EstShipTime, GETDATE()+30) AS DATE) <= CAST( GETDATE() AS DATE) AND CAST(o.EstimatedCompleteDate AS DATE) <= CAST( GETDATE() AS DATE) 
	--SD-3331 Prime should only come in bet. 1 and 5 pm
	--AND (o.CustomerQbListID IS NULL OR  o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE())<=16))

	---picking date is passed (not today)
	INSERT  INTO @pickingTaskCreation ( OrderID ,ItemId ,BucketId ,Active ,AddTime ,UniqKey ,EstimatedCompleteDate ,
				Style, ItemCode,ItemNumber ,Cubicft ,EZProdID ,EZParentProdID ,SOnumber ,CustomerName ,ItemType ,
				ItemTypeCode ,PickDropLocationID ,PickingDate,RushOrder ,Hinge, ItemKD,Updated)
	SELECT  o.OrderID ,bi.ItemId ,bi.BucketId ,bi.Active ,bi.AddTime ,bi.UniqKey ,o.EstimatedCompleteDate ,te.Style ,il.ShortItemCode AS ItemCode,
					te.ItemNumber ,il.CubicFtKD Cubicft ,te.EZProdID ,te.EZParentProdID ,o.SOnumber ,o.CustomerName ,
					te.ItemType ,il.ItemTypeCode ,bi.DropLocation AS PickDropLocationID,te.PickingDate , o.RushOrder, te.Hinge, te.KD ItemKD, 0 Updated
	FROM    picking.BucketItems bi
			JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
			JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1 
	WHERE   bi.BucketId = @localBucketID AND bi.Active = 1 AND bi.AssignedPickingTask IS NULL AND (te.FWPONumber IS NULL OR te.FWPONumber ='') 
	AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14) 
	AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
	AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
					WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))
	AND NOT EXISTS ( SELECT 1 FROM @pickingTaskCreation ti WHERE o.OrderID = ti.OrderID )		
	AND (te.ItemType <> 2 OR te.KD = 0 OR o.ShipVia <> 'Pickup')
	AND te.PickingDate IS NOT NULL AND te.PickingDate <CONVERT(DATE,GETDATE())
	--IL-253
	AND il.itemcode = CASE WHEN il.ItemCode NOT LIKE 'PRIMA BIANCO:PB HGS%' THEN il.ItemCode 
	 WHEN EXISTS(SELECT 1 FROM TranEntry tep WHERE tep.EZProdID = te.EZParentProdID AND te.orderid = tep.orderid AND ISNULL(tep.PickDropLoc ,'') <> 'C' )
	 AND il.ItemCode LIKE 'PRIMA BIANCO:PB HGS%'  THEN  '' ELSE il.itemcode END


		--picking date today and next day started already
	INSERT  INTO @pickingTaskCreation ( OrderID ,ItemId ,BucketId ,Active ,AddTime ,UniqKey ,EstimatedCompleteDate ,
				Style, ItemCode,ItemNumber ,Cubicft ,EZProdID ,EZParentProdID ,SOnumber ,CustomerName ,ItemType ,
				ItemTypeCode ,PickDropLocationID ,PickingDate,RushOrder ,Hinge, ItemKD,Updated)
	SELECT  o.OrderID ,bi.ItemId ,bi.BucketId ,bi.Active ,bi.AddTime ,bi.UniqKey ,o.EstimatedCompleteDate ,te.Style ,il.ShortItemCode AS ItemCode,
					te.ItemNumber ,il.CubicFtKD Cubicft ,te.EZProdID ,te.EZParentProdID ,o.SOnumber ,o.CustomerName ,
					te.ItemType ,il.ItemTypeCode ,bi.DropLocation AS PickDropLocationID,te.PickingDate , o.RushOrder, te.Hinge, te.KD ItemKD, 0 Updated
	FROM    picking.BucketItems bi
			JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
			JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
			JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1 
	WHERE   bi.BucketId = @localBucketID AND bi.Active = 1 AND bi.AssignedPickingTask IS NULL AND (te.FWPONumber IS NULL OR te.FWPONumber ='') 
	AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14) 
	AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
	AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
					WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))
	AND NOT EXISTS ( SELECT 1 FROM @pickingTaskCreation ti WHERE o.OrderID = ti.OrderID )		
	AND (te.ItemType <> 2 OR te.KD = 0 OR o.ShipVia <> 'Pickup')
	--AND (te.ItemType <> 2 OR te.KD =0 OR il.ItemSubTypeID = 18 OR DATEADD(HOUR,15,CAST(te.PickingDate AS datetime)) < GETDATE() ) 
		--SD-3331 Prime should only come in bet. 1 and 5 pm
	--AND ( o.CustomerQbListID IS NULL OR o.CustomerQbListID <> '8000003B-1247667314' OR (DATEPART(HOUR,GETDATE()) >= 13 AND DATEPART(HOUR,GETDATE())<=16))
		AND te.PickingDate IS NOT NULL AND te.PickingDate =CONVERT(DATE,GETDATE())
	AND EXISTS (SELECT 1 FROM picking.PickingTask AS pt2 JOIN picking.PickingTaskDetail AS ptd2 ON ptd2.PickingTaskId = pt2.PickingTaskId
	 JOIN dbo.TranEntry AS te2 ON te2.ID = ptd2.ItemId WHERE pt2.BucketId = @localBucketID AND pt2.CreatePickDate >CONVERT(DATE,GETDATE()) AND pt2.RushOrder =0
	 AND pt2.Active = 1 AND ptd2.Active =1)
	--IL-253
	AND il.itemcode =   CASE WHEN il.ItemCode NOT LIKE 'PRIMA BIANCO:PB HGS%' THEN il.ItemCode 
	WHEN EXISTS(SELECT 1 FROM TranEntry tep WHERE tep.EZProdID = te.EZParentProdID AND te.orderid = tep.orderid and ISNULL(tep.PickDropLoc ,'') <> 'C' )
	 AND il.ItemCode LIKE 'PRIMA BIANCO:PB HGS%'  THEN  '' ELSE il.itemcode END 

	 	 -- Prima HGS panel special task --IL-253   -- exclude it from here and last igl and 155, 89, 69 (like ship by/ pickup)
	INSERT  INTO @pickingTaskCreation ( OrderID ,ItemId ,BucketId ,Active ,AddTime ,UniqKey ,EstimatedCompleteDate ,
						Style, ItemCode,ItemNumber ,Cubicft ,EZProdID ,EZParentProdID ,SOnumber ,CustomerName ,ItemType ,
						ItemTypeCode ,PickDropLocationID ,PickingDate,RushOrder ,Hinge, ItemKD,Updated)
		
		SELECT  o.OrderID ,bi.ItemId ,bi.BucketId ,bi.Active ,bi.AddTime ,bi.UniqKey ,o.EstimatedCompleteDate ,te.Style ,il.ShortItemCode AS ItemCode,
						te.ItemNumber ,il.CubicFtKD Cubicft ,te.EZProdID ,te.EZParentProdID ,o.SOnumber ,o.CustomerName ,
						te.ItemType ,il.ItemTypeCode ,bi.DropLocation AS PickDropLocationID,te.PickingDate , o.RushOrder, te.Hinge, te.KD ItemKD, 0 Updated
		FROM    picking.BucketItems bi
				JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
				JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
				JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1 
		WHERE   
		bi.BucketId = @localBucketID AND bi.Active = 1 AND bi.AssignedPickingTask IS NULL AND (te.FWPONumber IS NULL OR te.FWPONumber ='') AND te.PickingDate IS NOT NULL 
		AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14) 
		AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
		AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
						WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))
		AND NOT EXISTS ( SELECT 1 FROM @pickingTaskCreation ti WHERE o.OrderID = ti.OrderID )		
		AND il.ItemCode LIKE 'PRIMA BIANCO:PB HGS%'   
		AND EXISTS(SELECT 1 FROM TranEntry tep  JOIN tb_StatusClassDetail scd ON scd.ClassMasterID=63 AND scd.StatusID = tep.DepartmentstatusID WHERE tep.EZProdID = te.EZParentProdID  AND te.orderid = tep.orderid 
		AND ISNULL(tep.PickDropLoc ,'') <> 'C')
		


	-- item type 2 'Customer Pickup' status when ship via is pickup should be like rush
	-- 7/30/2018 changed to EsdConfirmed  SD-2768
	INSERT  INTO @pickingTaskCreation ( OrderID ,ItemId ,BucketId ,Active ,AddTime ,UniqKey ,EstimatedCompleteDate ,
						Style, ItemCode,ItemNumber ,Cubicft ,EZProdID ,EZParentProdID ,SOnumber ,CustomerName ,ItemType ,
						ItemTypeCode ,PickDropLocationID ,PickingDate,RushOrder ,Hinge, ItemKD,Updated)
		SELECT  o.OrderID ,bi.ItemId ,bi.BucketId ,bi.Active ,bi.AddTime ,bi.UniqKey ,o.EstimatedCompleteDate ,te.Style ,il.ShortItemCode AS ItemCode,
						te.ItemNumber ,il.CubicFtKD Cubicft ,te.EZProdID ,te.EZParentProdID ,o.SOnumber ,o.CustomerName ,
						te.ItemType ,il.ItemTypeCode ,bi.DropLocation AS PickDropLocationID,te.PickingDate , o.RushOrder, te.Hinge, te.KD ItemKD, 0 Updated
		FROM    picking.BucketItems bi
				JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
				JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
				JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1 
		WHERE   bi.BucketId = @localBucketID AND bi.Active = 1 AND bi.AssignedPickingTask IS NULL AND (te.FWPONumber IS NULL OR te.FWPONumber ='') AND te.PickingDate IS NOT NULL 
		AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14) 
		AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
		AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
						WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))
		AND NOT EXISTS ( SELECT 1 FROM @pickingTaskCreation ti WHERE o.OrderID = ti.OrderID )
		AND il.ItemTypeCode =2 AND te.KD =1 AND o.ShipVia = 'Pickup' 
		--AND o.Departmentstatusid =67
		AND o.EsdConfirmed =1

-- last igl
	IF EXISTS (SELECT * FROM picking.Buckets b WHERE b.BucketId = @BucketID AND b.AccessoryPriority =1)		
	BEGIN
	INSERT  INTO @pickingTaskCreation ( OrderID ,ItemId ,BucketId ,Active ,AddTime ,UniqKey ,EstimatedCompleteDate ,
						Style, ItemCode,ItemNumber ,Cubicft ,EZProdID ,EZParentProdID ,SOnumber ,CustomerName ,ItemType ,
						ItemTypeCode ,PickDropLocationID ,PickingDate,RushOrder ,Hinge, ItemKD,Updated)
		SELECT  o.OrderID ,bi.ItemId ,bi.BucketId ,bi.Active ,bi.AddTime ,bi.UniqKey ,o.EstimatedCompleteDate ,te.Style ,il.ShortItemCode AS ItemCode,
						te.ItemNumber ,il.CubicFtKD Cubicft ,te.EZProdID ,te.EZParentProdID ,o.SOnumber ,o.CustomerName ,
						te.ItemType ,il.ItemTypeCode ,bi.DropLocation AS PickDropLocationID,te.PickingDate , o.RushOrder, te.Hinge, te.KD ItemKD, 0 Updated
		FROM    picking.BucketItems bi
				JOIN dbo.TranEntry te ON te.ID = bi.ItemId AND te.isActive = 1
				JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
				JOIN dbo.[Order] o ON o.ID = te.OrderID AND o.IsActive = 1 
				CROSS APPLY (						
                        SELECT  iglm.LastIGL FROM dbo.tb_ItemGroupLablesMaster iglm WHERE iglm.isActive = 1 AND iglm.LastIGL = 1 AND iglm.OrderID=te.OrderID AND iglm.GroupType IN(1,2)
						) LastIgl
		WHERE   bi.BucketId = @localBucketID AND bi.Active = 1 AND bi.AssignedPickingTask IS NULL AND (te.FWPONumber IS NULL OR te.FWPONumber ='') AND te.PickingDate IS NOT NULL 
		AND te.DepartmentstatusID IN ( 6, 24, 57, 58 ) AND te.ItemType IN(1,2,3,7,12,14) 
		AND ( ISNULL(te.PartsOnly,0) = 0 OR bi.PickForParts = 1 )
		AND NOT EXISTS ( SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId 
						WHERE  bi.ItemId = ptd.ItemId AND ptd.Active = 1 AND pt.Active =1 AND pt.PickingTaskStatusId not IN(4))
		AND NOT EXISTS ( SELECT 1 FROM @pickingTaskCreation ti WHERE o.OrderID = ti.OrderID )
	--IL-253
	AND il.itemcode =  CASE WHEN il.ItemCode NOT LIKE 'PRIMA BIANCO:PB HGS%' THEN il.ItemCode 
	 WHEN EXISTS(SELECT 1 FROM TranEntry tep WHERE tep.EZProdID = te.EZParentProdID AND te.orderid = tep.orderid AND ISNULL(tep.PickDropLoc ,'') <> 'C' )
	  AND il.ItemCode LIKE 'PRIMA BIANCO:PB HGS%'  THEN  '' ELSE il.itemcode END

	END

	
	INSERT INTO @PickingTaskCreation ( OrderID, ItemId, BucketId, Active, AddTime, UniqKey, EstimatedCompleteDate, Style,
	                                    ItemCode, ItemNumber, Cubicft, EZProdID, EZParentProdID, SOnumber, CustomerName,
	                                    ItemType, ItemTypeCode, PickDropLocationID, PickingDate, RushOrder, Hinge, ItemKD,
	                                    Updated, AvailableToPick, ParentItemId )	
	SELECT ti.OrderID, te.ID, ti.BucketId, ti.Active, ti.AddTime, ti.UniqKey, ti.EstimatedCompleteDate, ti.Style,
        il.ItemCode, te.ItemNumber, il.CubicFtKD, te.EZProdID, te.EZParentProdID, ti.SOnumber, ti.CustomerName,
        te.ItemType, il.ItemTypeCode, ti.PickDropLocationID, ti.PickingDate, ti.RushOrder, ti.Hinge, ti.ItemKD,
        ti.Updated, 0, ti.ItemId FROM @PickingTaskCreation  ti 
	JOIN dbo.TranEntry te2 ON te2.ID=ti.ItemId
	JOIN dbo.TranEntry te ON te.OrderID = ti.OrderID AND te.EZParentProdID = ti.EZProdID
	AND ( te.EZProdSubID = te2.EZProdSubID  OR te.ItemNumber NOT IN('ACCESSORIES:LST33','ACCESSORIES:LST36') )
	JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber 
	AND ( te.ItemType <> 4 AND ( te.ItemType <> 3 OR EXISTS ( SELECT 1 FROM dbo.tb_itemClassDetail ic  WHERE  ic.ItemCode = il.ShortItemCode AND  te.ItemNumber = il.ItemCode AND ic.ClassID = 50 ) ) )
			AND NOT EXISTS ( SELECT 1 FROM dbo.tb_itemClassDetail ic WHERE  ic.ItemCode = il.ShortItemCode AND  te.ItemNumber = il.ItemCode AND ic.ClassID = 45 )

	WHERE ( te.FWPONumber IS NULL OR te.FWPONumber ='' ) AND te.isDeleted =0 AND te.isActive =1  AND te.ItemType =7 
	AND NOT EXISTS (SELECT 1 FROM picking.PickingTaskDetail ptd JOIN picking.PickingTask pt ON pt.PickingTaskId = ptd.PickingTaskId AND pt.Active =1 WHERE ptd.ItemId=te.ID AND ptd.Active=1 AND pt.PickingTaskStatusId <> 4 )


	RETURN 

END

GO
/****** Object:  UserDefinedFunction [picking].[PickerStealsAFrame]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [picking].[PickerStealsAFrame]
(
	@ProductionItemDetailId INT,
	@Abn VARCHAR(50)
)
RETURNS BIT
AS 
BEGIN

	IF NOT EXISTS
	(
		SELECT * FROM Picking.ProductionItemDetail AS pid
		JOIN Picking.ProductionItem AS pi ON pi.ProductionItemId = pid.ProductionItemId
		JOIN dbo.tb_ItemList AS til ON til.ID = pid.ItemlistId
		WHERE pid.ProductionItemDetailId = @ProductionItemDetailId
		AND til.ComponentPartTypeId IN(6, 8)
		AND pi.DestinationLocationId NOT IN(32,33,34,35)
		AND pid.Deleted = 0
	)
	BEGIN
	    RETURN 0
	END
	IF NOT EXISTS
	(
		SELECT * FROM inventory.RackWagon AS rw
		JOIN inventory.RackWagonLocations AS rwl ON rwl.WagonId = rw.WagonId
		JOIN dbo.InventoryLocation AS il ON il.ID = rwl.LocationId
		JOIN dbo.tb_AccBoxNumber AS tabn ON tabn.ReceivedLocation = il.Location
		WHERE tabn.ABNNumber = @Abn
		AND rwl.Active = 1
		AND rw.RackWagonTypeId IN (2, 3)
	)
	BEGIN
	    RETURN 0
	END

	IF EXISTS
	(
		SELECT * FROM picking.StockRefillTaskProductionItems AS srtpi
		WHERE srtpi.ProductionItemDetailId = @ProductionItemDetailId
		AND srtpi.Deleted = 0
		AND srtpi.PlacedInWagon = 1
	)
	AND EXISTS
	(
		SELECT * FROM Picking.ProductionItem AS pi
		JOIN Picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi.ProductionItemId
		WHERE pid.ProductionItemDetailId = @ProductionItemDetailId
		AND EXISTS
		(
			SELECT * FROM picking.StockRefillTaskProductionItems AS srtpi
			JOIN picking.ProductionItemDetail AS pidAbn ON pidAbn.ProductionItemDetailId = srtpi.ProductionItemDetailId AND pidAbn.Deleted = 0
			JOIN Picking.ProductionItem AS piAbn ON piAbn.ProductionItemId = pidAbn.ProductionItemId
			WHERE piAbn.DestinationLocationId = pi.DestinationLocationId
		)
	)
	BEGIN
	    RETURN 0
	END

	RETURN 1

END

GO
/****** Object:  UserDefinedFunction [picking].[PickingTaskDetailsView]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[PickingTaskDetailsView] (@taskId INT)
RETURNS @RetVal TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [varchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL,
	[SBN][VARCHAR](20) NULL
) 
AS
BEGIN


DECLARE @Ret TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [varchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL,
	AssembledOnly BIT,
	BucketID INT,
	ItemListID INT,
	ItemTypeCode INT,
	ISEID INT,
	ABNID INT,
	SBN VARCHAR(20) NULL,
	INDEX IX_Ret_ItemCode CLUSTERED (ItemCode) 
) 

INSERT INTO @Ret ([TaskId], [PickingTaskDetailId], [ItemId], [STATUS], [ItemStatus], [Active], [ProductType], [ItemType], [KD], [Picked], 
[PickedTime],
[ItemCode], 
[PickItem], 
[Description], [OrderNumber], [EstimatedCompleteDate], [Serial], [Abn], [APN], [ApnId], 
[LocationToPick], 
--[Warehouse], 
[Section], [Isle], 
--[PoNumberToPick], 
[PrintApn], 
--[Quantity], [HasEnougeStock], [SectionN], [IsleNumeric], 
[SubstituteReasonId], 
[Hinge], [AvailableToPick], [ParentItemId], [ItemSubTypeID], [PickingDate], [FulfillmentType], [AssembledOnly], [BucketID], ItemListID,
ItemTypeCode, ISEID, ABNID, SBN)
		SELECT pt.PickingTaskId TaskId,
			ptd.PickingTaskDetailId,
			ptd.ItemId,
			pts.Name AS STATUS,
			d.STATUS AS ItemStatus,
			ptd.Active,
			it.TypeName AS ProductType,
			te.ItemType,
			te.KD,
			ptd.Picked,
			COALESCE(abn.PickedTime, ise.PickedTime) AS PickedTime,
			il.ShortItemCode AS ItemCode,
			COALESCE(abn.ItemCode, ise.ItemCode/*, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode, il.ShortItemCode*/) AS PickItem,
			te.Description,
			o.SOnumber AS OrderNumber,
			o.EstimatedCompleteDate,
			ise.SerielID AS Serial,
			abn.ABNNumber AS Abn,
			apn.APN,
			apn.ID AS ApnId,
			COALESCE(abn.PickedFromLocation, ise.PickedFromLocation/*, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location*/) AS LocationToPick,
			--COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(abn.SectionPicked, ise.SectionPicked/*, locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section*/) AS Section,
			COALESCE(abn.IslePicked, ise.IslePicked/*, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle*/) AS Isle,
			--COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			b.PrintApn,
			--CASE 
			--	WHEN b.AssembledOnly = 1
			--		THEN ISNULL(qtyAss.Quantity, 0)
			--	ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			--	END Quantity,
			--CAST(CASE 
			--		WHEN qty.Quantity IS NULL
			--			AND qtyAss.Quantity IS NULL
			--			AND qtyDoors.Quantity IS NULL
			--			AND qtyDoorsWag.Quantity IS NULL
			--			AND automaticSubstitute.Quantity IS NULL
			--			OR (
			--				ise.ID IS NULL
			--				AND abn.ID IS NULL
			--				AND ne.NotEnough = 1
			--				)
			--			THEN 0
			--		ELSE 1
			--		END AS BIT) HasEnougeStock,
			--COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			--COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			COALESCE(ise.SubstituteTypeID, abn.SubstituteTypeID, CASE 
					WHEN te.SubstituteItemCode IS NOT NULL
						THEN 41
					ELSE NULL
					END) AS SubstituteReasonId,
			te.Hinge,
			ptd.AvailableToPick,
			ptd.ParentItemId,
			il.ItemSubTypeID,
			te.PickingDate,
			te.FulfillmentType,
			b.AssembledOnly,
			b.BucketID,
			il.ID,
			il.ItemTypeCode, ise.ID, abn.ID, Sbn.BoxNumber
		FROM picking.PickingTask pt
		JOIN picking.Buckets b ON b.BucketID = pt.BucketId
		JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId
			AND pt.Active = 1
			AND ptd.Active = 1
		JOIN dbo.TranEntry te ON te.ID = ptd.ItemId
			AND te.isActive = 1
		JOIN dbo.[Order] o ON o.ID = te.OrderID
			AND o.IsActive = 1
		JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
		JOIN dbo.ItemType it ON il.ItemTypeCode = it.TypeID
		LEFT OUTER JOIN dbo.tb_AccPickNumber apn ON apn.TranEntryID = te.ID
			AND apn.isActive = 1

		LEFT OUTER JOIN (
			SELECT ise.ID,
				ise.SerielID,
				ise.ItemCode,
				ise.PONumber,
				ise.PickedTime,
				ise.SubstituteTypeID,
				il2.Location AS PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				TranEntryID
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2 ON il2.ID = ise.PickedFromLocation
			WHERE ise.Picked = 1
			) ise ON ise.TranEntryID = te.ID


		LEFT OUTER JOIN  (
			SELECT abni.ID,
				abni.ABNID,
				abn.ABNNumber,
				abn.ItemCode,
				abn.PONumber,
				abni.PickedTime,
				abni.SubstituteTypeID,
				il2.Location PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				abni.TranEntryID
			FROM dbo.tb_AccBoxNumberItems abni
			JOIN dbo.tb_AccBoxNumber abn ON abn.ID = abni.ABNID
			JOIN dbo.InventoryLocation il2 ON il2.ID = abni.PickedFromLocation
			JOIN dbo.tb_ItemList TIL ON TIL.ShortItemCode = abn.ItemCode
			WHERE abni.Picked = 1
				AND abni.CreatedABNID IS NULL
				AND (ISNULL(TIL.ComponentPartTypeId,0) <> 29 OR il2.LocationType = 41)
			) abn ON abn.TranEntryID = te.ID

			LEFT JOIN (SELECT ABH.BoxNumber, ABD.TranEntryId FROM dbo.AccessoriesBoxHeader ABH
						join dbo.AccessoriesBoxDetail ABD ON ABD.HeaderId = ABH.Id
						WHERE ABH.IsActive = 1 AND abd.IsActive = 1 )
						Sbn ON Sbn.TranEntryId = te.ID


		WHERE pt.PickingTaskId = @TaskID

INSERT INTO @RetVal
SELECT r.TaskId,
			r.PickingTaskDetailId,
			r.ItemId,
			r.STATUS,
			r.ItemStatus,
			r.Active,
			r.ProductType,
			r.ItemType,
			r.KD,
			r.Picked,
			r.PickedTime,
			r.ItemCode,
			COALESCE(r.PickItem, r.ItemCode, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode) AS PickItem,
			r.Description,
			r.OrderNumber,
			r.EstimatedCompleteDate,
			r.Serial,
			r.Abn,
			r.APN,
			r.ApnId,
			COALESCE(r.LocationToPick, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location) AS LocationToPick,
			COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(r.Section,locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section) AS Section,
			COALESCE(r.Isle, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle) AS Isle,
			COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			r.PrintApn,
			CASE 
				WHEN r.AssembledOnly = 1
					THEN ISNULL(qtyAss.Quantity, 0)
				ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
				END Quantity,
			CAST(CASE 
					WHEN qty.Quantity IS NULL
						AND ISNULL(qtyAss.Quantity, 0) = 0
						AND qtyDoors.Quantity IS NULL
						AND qtyDoorsWag.Quantity IS NULL
						AND automaticSubstitute.Quantity IS NULL
						OR (
							r.iseID IS NULL
							AND r.abnID IS NULL
							AND ne.NotEnough = 1
							)
						THEN 0
					ELSE 1
					END AS BIT) HasEnougeStock,
			COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			r.SubstituteReasonId,
			r.Hinge,
			r.AvailableToPick,
			r.ParentItemId,
			r.ItemSubTypeID,
			r.PickingDate,
			r.FulfillmentType,
			r.SBN
FROM @Ret AS r
JOIN dbo.TranEntry te ON te.ID = r.ItemId
		AND te.isActive = 1
JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = te.ItemNumber
LEFT JOIN dbo.tb_ItemList ilsub
			ON te.SubstituteItemCode = ilsub.ItemCode
OUTER APPLY (
	SELECT TOP 1 il2sl.Location,
		ilusl.PoNumber,
		il2sl.Isle,
		il2sl.Section,
		w.Description AS Warehouse,
		il2sl.IsleNumeric,
		CASE 
			WHEN il2sl.Section IS NOT NULL
				AND ISNUMERIC(il2sl.Section) = 1
				THEN CAST(il2sl.Section AS INT)
			ELSE CAST(10000 AS INT)
			END SectionN
	FROM dbo.InventoryLocation il2sl
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
		AND il2sl.ExcludeFrmStock = 0
		AND il2sl.IsPickable = 1
	JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
	LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
		AND ilusl.Quantity > 0
		AND ilusl.STATUS = N'Active'
	OUTER APPLY(SELECT TOP 1 p.PoNumber, COALESCE(p.PromisedOn, p.POCreated, p.AddDate) PoDate
		FROM inventory.Po AS p 
		WHERE p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0
		AND p.PoNumber = ilusl.PoNumber
		)po
	OUTER APPLY(SELECT TOP 1 po.ProductionNumber AS PoNumber, po.ProductionEndDate PoDate 
		FROM acumaticaManufacturing.ProductionOrders AS po
		WHERE po.DeleteFlag = 0
		AND po.ProductionNumber = ilusl.PoNumber)wo
	WHERE COALESCE(ilsub.ShortItemCode, r.ItemCode) = ildic.ItemCode
	AND (COALESCE(ilsub.ComponentPartTypeId,til.ComponentPartTypeId, 0) <> 29 OR il2sl.LocationType = 41)
	ORDER BY CASE 
			WHEN ilusl.Location IS NOT NULL
				THEN 0
			ELSE 1
			END,
		CASE 
			WHEN COALESCE(po.PoNumber, wo.PoNumber) IS NOT NULL
				THEN COALESCE(po.PoDate, wo.PoDate)
			ELSE 10000
			END,
		il2sl.AddTime
	) locations
OUTER APPLY (
	SELECT SUM(iq.Quantity) Quantity
	FROM dbo.ItemLocationsUpdate iq
	JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
		AND ilq.ExcludeFrmStock = 0
		AND ilq.IsPickable = 1
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
	JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
	WHERE iq.Quantity > 0
		AND iq.STATUS = N'Active'
		AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
		AND (COALESCE(ilsub.ComponentPartTypeId,til.ComponentPartTypeId, 0) <> 29 OR ilq.LocationType = 41)
	GROUP BY iq.ItemCode
) qty
		OUTER APPLY (
			SELECT TOP 1 ise.ReceivedLocation Location,
				ise.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(te.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219,
							271,272,273
							)
						THEN 5
					ELSE 0
					END
			) locationsAss
		OUTER APPLY (
			SELECT COUNT(*) AS Quantity
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(r.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219,
							271,272,273
							)
						THEN 5
					ELSE 0
					END
			) qtyAss
		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = N'Active'
			OUTER APPLY(SELECT TOP 1 COALESCE(p.PromisedOn, p.POCreated, p.AddDate) PoDate FROM inventory.Po AS p 
				WHERE p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0
				AND p.PoNumber = ilusl.PoNumber)po
			OUTER APPLY(SELECT TOP 1 po.ProductionEndDate PoDate 
			FROM acumaticaManufacturing.ProductionOrders AS po
			WHERE po.DeleteFlag = 0
			AND po.ProductionNumber = ilusl.PoNumber)wo
			WHERE COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND il2sl.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
				AND il2sl.Warehouse = 5
				AND il2sl.ExcludeFrmStock = 0
				AND locationsAss.Location IS NULL
			ORDER BY CASE 
					WHEN il2sl.Location LIKE 'WAG-DR-%'
						THEN 1
					ELSE 0
					END,
				CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				COALESCE(po.PoDate, wo.PoDate)
			) locationsDoors
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = 5
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND ISNULL(qtyAss.Quantity,0) = 0
				AND iq.Quantity > 0
				AND iq.STATUS = N'Active'
				AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND ilq.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoors

		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = N'Active'
			OUTER APPLY(SELECT TOP 1 COALESCE(p.PromisedOn, p.POCreated, p.AddDate) PoDate FROM inventory.Po AS p 
				WHERE p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0
				AND p.PoNumber = ilusl.PoNumber)po
			OUTER APPLY(SELECT TOP 1 po.ProductionEndDate PoDate 
			FROM acumaticaManufacturing.ProductionOrders AS po
			WHERE po.DeleteFlag = 0
			AND po.ProductionNumber = ilusl.PoNumber)wo
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND locationsAss.Location IS NULL
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					237,
					238
					)
				AND il2sl.Warehouse = 5
				AND il2sl.ExcludeFrmStock = 0
				AND il2sl.Location LIKE 'WAG-DR-%'
				AND il2sl.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			ORDER BY CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				COALESCE(po.PoDate, wo.PoDate)
			) locationsDoorsWag
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = 5
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND ISNULL(qtyAss.Quantity,0) = 0
				AND iq.Quantity > 0
				AND iq.STATUS = N'Active'
				AND iq.ItemCode = r.ItemCode
				AND r.BucketId IN (
					237,
					238
					)
				AND ilq.Location LIKE 'WAG-DR-%'
				AND ilq.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoorsWag
		OUTER APPLY (
			SELECT TOP (1) Sub.ShortItemCode,
				qty.Quantity,
				locations.Location,
				locations.Warehouse,
				locations.Section,
				locations.Isle,
				locations.PoNumber,
				locations.SectionN,
				locations.IsleNumeric
			FROM 
			(
				SELECT TOP (1) tilSub.ShortItemCode, tilSub.ID SubId, aism.MainItemListId MainId
				FROM picking.AutomaticItemSubstitutionDetail AS aisd
				JOIN picking.AutomaticItemSubstitutionMaster AS aism ON aism.AutomaticItemSubstitutionMasterId = aisd.AutomaticItemSubstitutionMasterId
				JOIN picking.AutomaticItemSubstitutionDetail AS aisd2 ON aisd2.AutomaticItemSubstitutionMasterId = aism.AutomaticItemSubstitutionMasterId
				JOIN dbo.tb_ItemList AS tilSub ON tilSub.ID = aisd2.ItemlistId
				JOIN dbo.ItemLocationsUpdate ILU ON tilSub.ShortItemCode = ILU.ItemCode AND ILU.Quantity > 0
				WHERE aisd.Active = 1
				AND aisd2.Active = 1
				AND aism.Active = 1
				AND r.ItemListID = aisd.ItemlistId
				ORDER BY CASE 
					WHEN tilSub.ID <> aism.MainItemListId
						THEN 0
					ELSE 1
					END

				UNION

				SELECT tilPid.ShortItemCode, tilPid.ID SubId, pi.ItemlistId MainId
				FROM Picking.ProductionItem AS pi
				JOIN picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi.ProductionItemId AND pid.Deleted = 0
				JOIN dbo.tb_ItemList AS tilPid ON tilPid.ID = pid.ItemlistId
				WHERE pi.OrderItemId = te.ID
				AND pid.Deleted = 0
				AND pi.Deleted = 0
				AND pid.Picked = 0
				AND pid.PickingTypeId = 7
			)AS Sub
			OUTER APPLY (
				SELECT TOP 1 il2sl.Location,
					ilusl.PoNumber,
					il2sl.Isle,
					il2sl.Section,
					w.Description AS Warehouse,
					il2sl.IsleNumeric,
					CASE 
						WHEN il2sl.Section IS NOT NULL
							AND ISNUMERIC(il2sl.Section) = 1
							THEN CAST(il2sl.Section AS INT)
						ELSE CAST(10000 AS INT)
						END SectionN
				FROM dbo.InventoryLocation il2sl
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
					AND il2sl.ExcludeFrmStock = 0
					AND il2sl.IsPickable = 1
				JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
					AND ilusl.Quantity > 0
					AND ilusl.STATUS = N'Active'
				OUTER APPLY(SELECT TOP 1 p.PoNumber, COALESCE(p.PromisedOn, p.POCreated, p.AddDate) PoDate FROM inventory.Po AS p 
					WHERE p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0
					AND p.PoNumber = ilusl.PoNumber)po
				OUTER APPLY(SELECT TOP 1 po.ProductionNumber AS PoNumber, po.ProductionEndDate PoDate 
					FROM acumaticaManufacturing.ProductionOrders AS po
					WHERE po.DeleteFlag = 0
					AND po.ProductionNumber = ilusl.PoNumber)wo
				WHERE Sub.ShortItemCode = ildic.ItemCode
				ORDER BY CASE 
						WHEN ilusl.Location IS NOT NULL
							THEN 0
						ELSE 1
						END,
					CASE 
						WHEN COALESCE(po.PoNumber, wo.PoNumber) IS NOT NULL
							THEN 0
						ELSE 10000
						END,
					COALESCE(po.PoDate, wo.PoDate),
					il2sl.AddTime
				) locations
			OUTER APPLY (
				SELECT SUM(iq.Quantity) Quantity
				FROM dbo.ItemLocationsUpdate iq
				JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
					AND ilq.ExcludeFrmStock = 0
					AND ilq.IsPickable = 1
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
				JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
				WHERE iq.Quantity > 0
					AND iq.STATUS = N'Active'
					AND iq.ItemCode = Sub.ShortItemCode
				GROUP BY iq.ItemCode
				) qty
			WHERE qty.Quantity > 0
			AND ISNULL(qtyAss.Quantity,0) = 0
			) automaticSubstitute
		OUTER APPLY (
			SELECT CAST(1 AS BIT) NotEnough
			FROM picking.PickingTask pt2
			JOIN picking.PickingTaskDetail ptd2 ON ptd2.PickingTaskId = pt2.PickingTaskId
			JOIN dbo.TranEntry te2 ON te2.ID = ptd2.ItemId
				AND te2.isActive = 1
			WHERE ptd2.PickingTaskId = r.TaskId
				AND te2.ItemNumber = te.ItemNumber
				AND pt2.Active = 1
				AND ptd2.Active = 1
				AND ptd2.Picked = 0
			GROUP BY te2.ItemNumber,
				pt2.PickingTaskId
			HAVING COUNT(*) > COALESCE( qtyDoorsWag.Quantity, qtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity,qtyAss.Quantity, 0)
			) ne
			ORDER BY PickingTaskDetailId
			--OPTION(RECOMPILE)
RETURN
END











GO
/****** Object:  UserDefinedFunction [picking].[PickingTaskDetailsViewTest]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[PickingTaskDetailsViewTest] (@taskId INT)
RETURNS @RetVal TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [nvarchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL
) 
AS
BEGIN


DECLARE @Ret TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [nvarchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL,
	AssembledOnly BIT,
	BucketID INT,
	ItemListID INT,
	ItemTypeCode INT,
	ISEID INT,
	ABNID INT,
	INDEX IX_Ret_ItemCode CLUSTERED (ItemCode) 
) 

INSERT INTO @Ret ([TaskId], [PickingTaskDetailId], [ItemId], [STATUS], [ItemStatus], [Active], [ProductType], [ItemType], [KD], [Picked], 
[PickedTime],
[ItemCode], 
[PickItem], 
[Description], [OrderNumber], [EstimatedCompleteDate], [Serial], [Abn], [APN], [ApnId], 
[LocationToPick], 
--[Warehouse], 
[Section], [Isle], 
--[PoNumberToPick], 
[PrintApn], 
--[Quantity], [HasEnougeStock], [SectionN], [IsleNumeric], 
[SubstituteReasonId], 
[Hinge], [AvailableToPick], [ParentItemId], [ItemSubTypeID], [PickingDate], [FulfillmentType], [AssembledOnly], [BucketID], ItemListID,
ItemTypeCode, ISEID, ABNID)
		SELECT pt.PickingTaskId TaskId,
			ptd.PickingTaskDetailId,
			ptd.ItemId,
			pts.Name AS STATUS,
			d.STATUS AS ItemStatus,
			ptd.Active,
			it.TypeName AS ProductType,
			te.ItemType,
			te.KD,
			ptd.Picked,
			COALESCE(abn.PickedTime, ise.PickedTime) AS PickedTime,
			il.ShortItemCode AS ItemCode,
			COALESCE(abn.ItemCode, ise.ItemCode/*, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode, il.ShortItemCode*/) AS PickItem,
			te.Description,
			o.SOnumber AS OrderNumber,
			o.EstimatedCompleteDate,
			ise.SerielID AS Serial,
			abn.ABNNumber AS Abn,
			apn.APN,
			apn.ID AS ApnId,
			COALESCE(abn.PickedFromLocation, ise.PickedFromLocation/*, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location*/) AS LocationToPick,
			--COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(abn.SectionPicked, ise.SectionPicked/*, locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section*/) AS Section,
			COALESCE(abn.IslePicked, ise.IslePicked/*, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle*/) AS Isle,
			--COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			b.PrintApn,
			--CASE 
			--	WHEN b.AssembledOnly = 1
			--		THEN ISNULL(qtyAss.Quantity, 0)
			--	ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			--	END Quantity,
			--CAST(CASE 
			--		WHEN qty.Quantity IS NULL
			--			AND qtyAss.Quantity IS NULL
			--			AND qtyDoors.Quantity IS NULL
			--			AND qtyDoorsWag.Quantity IS NULL
			--			AND automaticSubstitute.Quantity IS NULL
			--			OR (
			--				ise.ID IS NULL
			--				AND abn.ID IS NULL
			--				AND ne.NotEnough = 1
			--				)
			--			THEN 0
			--		ELSE 1
			--		END AS BIT) HasEnougeStock,
			--COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			--COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			COALESCE(ise.SubstituteTypeID, abn.SubstituteTypeID, CASE 
					WHEN te.SubstituteItemCode IS NOT NULL
						THEN 41
					ELSE NULL
					END) AS SubstituteReasonId,
			te.Hinge,
			ptd.AvailableToPick,
			ptd.ParentItemId,
			il.ItemSubTypeID,
			te.PickingDate,
			te.FulfillmentType,
			b.AssembledOnly,
			b.BucketID,
			il.ID,
			il.ItemTypeCode, ise.ID, abn.ID
		FROM picking.PickingTask pt
		JOIN picking.Buckets b ON b.BucketID = pt.BucketId
		JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId
			AND pt.Active = 1
			AND ptd.Active = 1
		JOIN dbo.TranEntry te ON te.ID = ptd.ItemId
			AND te.isActive = 1
		JOIN dbo.[Order] o ON o.ID = te.OrderID
			AND o.IsActive = 1
		JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
		JOIN dbo.ItemType it ON il.ItemTypeCode = it.TypeID
		LEFT OUTER JOIN dbo.tb_AccPickNumber apn ON apn.TranEntryID = te.ID
			AND apn.isActive = 1

		LEFT OUTER JOIN (
			SELECT ise.ID,
				ise.SerielID,
				ise.ItemCode,
				ise.PONumber,
				ise.PickedTime,
				ise.SubstituteTypeID,
				il2.Location AS PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				TranEntryID
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2 ON il2.ID = ise.PickedFromLocation
			WHERE ise.Picked = 1
			) ise ON ise.TranEntryID = te.ID


		LEFT OUTER JOIN  (
			SELECT abni.ID,
				abni.ABNID,
				abn.ABNNumber,
				abn.ItemCode,
				abn.PONumber,
				abni.PickedTime,
				abni.SubstituteTypeID,
				il2.Location PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				abni.TranEntryID
			FROM dbo.tb_AccBoxNumberItems abni
			JOIN dbo.tb_AccBoxNumber abn ON abn.ID = abni.ABNID
			JOIN dbo.InventoryLocation il2 ON il2.ID = abni.PickedFromLocation
			WHERE abni.Picked = 1
				AND abni.CreatedABNID IS NULL
			) abn ON abn.TranEntryID = te.ID


		WHERE pt.PickingTaskId = @TaskID

INSERT INTO @RetVal
SELECT r.TaskId,
			r.PickingTaskDetailId,
			r.ItemId,
			r.STATUS,
			r.ItemStatus,
			r.Active,
			r.ProductType,
			r.ItemType,
			r.KD,
			r.Picked,
			r.PickedTime,
			r.ItemCode,
			COALESCE(r.ItemCode, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode) AS PickItem,
			r.Description,
			r.OrderNumber,
			r.EstimatedCompleteDate,
			r.Serial,
			r.Abn,
			r.APN,
			r.ApnId,
			COALESCE(r.LocationToPick, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location) AS LocationToPick,
			COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(r.Section,locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section) AS Section,
			COALESCE(r.Isle, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle) AS Isle,
			COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			r.PrintApn,
			CASE 
				WHEN r.AssembledOnly = 1
					THEN ISNULL(qtyAss.Quantity, 0)
				ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
				END Quantity,
			CAST(CASE 
					WHEN qty.Quantity IS NULL
						AND qtyAss.Quantity IS NULL
						AND qtyDoors.Quantity IS NULL
						AND qtyDoorsWag.Quantity IS NULL
						AND automaticSubstitute.Quantity IS NULL
						OR (
							r.iseID IS NULL
							AND r.abnID IS NULL
							AND ne.NotEnough = 1
							)
						THEN 0
					ELSE 1
					END AS BIT) HasEnougeStock,
			COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			r.SubstituteReasonId,
			r.Hinge,
			r.AvailableToPick,
			r.ParentItemId,
			r.ItemSubTypeID,
			r.PickingDate,
			r.FulfillmentType
FROM @Ret AS r
JOIN dbo.TranEntry te ON te.ID = r.ItemId
		AND te.isActive = 1
LEFT JOIN dbo.tb_ItemList ilsub
			ON te.SubstituteItemCode = ilsub.ItemCode
OUTER APPLY (
	SELECT TOP 1 il2sl.Location,
		ilusl.PoNumber,
		il2sl.Isle,
		il2sl.Section,
		w.Description AS Warehouse,
		il2sl.IsleNumeric,
		CASE 
			WHEN il2sl.Section IS NOT NULL
				AND ISNUMERIC(il2sl.Section) = 1
				THEN CAST(il2sl.Section AS INT)
			ELSE CAST(10000 AS INT)
			END SectionN
	FROM dbo.InventoryLocation il2sl
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
		AND il2sl.ExcludeFrmStock = 0
		AND il2sl.IsPickable = 1
	JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
	LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
		AND ilusl.Quantity > 0
		AND ilusl.STATUS = 'Active'
	OUTER APPLY(SELECT po.ProductionEndDate PoDate FROM acumaticaManufacturing.ProductionOrders AS po
		WHERE po.DeleteFlag = 0 AND po.ProductionNumber = ilusl.PoNumber
		UNION ALL
		SELECT COALESCE(p.PromisedOn, p.POCreated, p.AddDate) FROM inventory.Po AS p 
		WHERE (p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0)
		AND p.PoNumber = ilusl.PoNumber)pw
	WHERE COALESCE(ilsub.ShortItemCode, r.ItemCode) = ildic.ItemCode
	ORDER BY CASE 
			WHEN ilusl.Location IS NOT NULL
				THEN 0
			ELSE 1
			END,
		CASE 
			WHEN pw.PoDate IS NOT NULL
				THEN pw.PoDate
			ELSE 10000
			END,
		il2sl.AddTime
	) locations
OUTER APPLY (
	SELECT SUM(iq.Quantity) Quantity
	FROM dbo.ItemLocationsUpdate iq
	JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
		AND ilq.ExcludeFrmStock = 0
		AND ilq.IsPickable = 1
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
	JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
	WHERE iq.Quantity > 0
		AND iq.STATUS = 'Active'
		AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
	GROUP BY iq.ItemCode
) qty
		OUTER APPLY (
			SELECT TOP 1 ise.ReceivedLocation Location,
				ise.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(te.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219
							)
						THEN 5
					ELSE 0
					END
			) locationsAss
		OUTER APPLY (
			SELECT COUNT(*) AS Quantity
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(r.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219
							)
						THEN 5
					ELSE 0
					END
			) qtyAss
		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = 'Active'
			OUTER APPLY(SELECT po.ProductionEndDate PoDate FROM acumaticaManufacturing.ProductionOrders AS po
				WHERE po.DeleteFlag = 0 AND po.ProductionNumber = ilusl.PoNumber
				UNION ALL
				SELECT COALESCE(p.PromisedOn, p.POCreated, p.AddDate) FROM inventory.Po AS p 
				WHERE (p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0)
				AND p.PoNumber = ilusl.PoNumber)pw
			WHERE COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND il2sl.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
				AND il2sl.Warehouse = 5
				AND il2sl.ExcludeFrmStock = 0
				AND locationsAss.Location IS NULL
			ORDER BY CASE 
					WHEN il2sl.Location LIKE 'WAG-DR-%'
						THEN 1
					ELSE 0
					END,
				CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				pw.PoDate
			) locationsDoors
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = 5
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND qtyAss.Quantity IS NULL
				AND iq.Quantity > 0
				AND iq.STATUS = 'Active'
				AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND ilq.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoors

		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = 'Active'
			OUTER APPLY(SELECT po.ProductionEndDate PoDate FROM acumaticaManufacturing.ProductionOrders AS po
				WHERE po.DeleteFlag = 0 AND po.ProductionNumber = ilusl.PoNumber
				UNION ALL
				SELECT COALESCE(p.PromisedOn, p.POCreated, p.AddDate) FROM inventory.Po AS p 
				WHERE (p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0)
				AND p.PoNumber = ilusl.PoNumber)pw
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND locationsAss.Location IS NULL
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					237,
					238
					)
				AND il2sl.Warehouse = 5
				AND il2sl.ExcludeFrmStock = 0
				AND il2sl.Location LIKE 'WAG-DR-%'
				AND il2sl.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			ORDER BY CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				pw.PoDate
			) locationsDoorsWag
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = 5
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND qtyAss.Quantity IS NULL
				AND iq.Quantity > 0
				AND iq.STATUS = 'Active'
				AND iq.ItemCode = r.ItemCode
				AND r.BucketId IN (
					237,
					238
					)
				AND ilq.Location LIKE 'WAG-DR-%'
				AND ilq.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoorsWag
		OUTER APPLY (
			SELECT TOP (1) til.ShortItemCode,
				qty.Quantity,
				locations.Location,
				locations.Warehouse,
				locations.Section,
				locations.Isle,
				locations.PoNumber,
				locations.SectionN,
				locations.IsleNumeric
			FROM picking.AutomaticItemSubstitutionDetail AS aisd
			JOIN picking.AutomaticItemSubstitutionMaster AS aism ON aism.AutomaticItemSubstitutionMasterId = aisd.AutomaticItemSubstitutionMasterId
			JOIN picking.AutomaticItemSubstitutionDetail AS aisd2 ON aisd2.AutomaticItemSubstitutionMasterId = aism.AutomaticItemSubstitutionMasterId
			JOIN dbo.tb_ItemList AS til ON til.ID = aisd2.ItemlistId
			OUTER APPLY (
				SELECT TOP 1 il2sl.Location,
					ilusl.PoNumber,
					il2sl.Isle,
					il2sl.Section,
					w.Description AS Warehouse,
					il2sl.IsleNumeric,
					CASE 
						WHEN il2sl.Section IS NOT NULL
							AND ISNUMERIC(il2sl.Section) = 1
							THEN CAST(il2sl.Section AS INT)
						ELSE CAST(10000 AS INT)
						END SectionN
				FROM dbo.InventoryLocation il2sl
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
					AND il2sl.ExcludeFrmStock = 0
					AND il2sl.IsPickable = 1
				JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
					AND ilusl.Quantity > 0
					AND ilusl.STATUS = 'Active'
				OUTER APPLY(SELECT po.ProductionEndDate PoDate FROM acumaticaManufacturing.ProductionOrders AS po
					WHERE po.DeleteFlag = 0 AND po.ProductionNumber = ilusl.PoNumber
					UNION ALL
					SELECT COALESCE(p.PromisedOn, p.POCreated, p.AddDate) FROM inventory.Po AS p 
					WHERE (p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0)
					AND p.PoNumber = ilusl.PoNumber)pw
				WHERE til.ShortItemCode = ildic.ItemCode
				ORDER BY CASE 
						WHEN ilusl.Location IS NOT NULL
							THEN 0
						ELSE 1
						END,
					CASE 
						WHEN pw.PoDate IS NOT NULL
							THEN 0
						ELSE 10000
						END,
					pw.PoDate,
					il2sl.AddTime
				) locations
			OUTER APPLY (
				SELECT SUM(iq.Quantity) Quantity
				FROM dbo.ItemLocationsUpdate iq
				JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
					AND ilq.ExcludeFrmStock = 0
					AND ilq.IsPickable = 1
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
				JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
				WHERE iq.Quantity > 0
					AND iq.STATUS = 'Active'
					AND iq.ItemCode = til.ShortItemCode
				GROUP BY iq.ItemCode
				) qty
			WHERE r.ItemListID = aisd.ItemlistId
				AND qty.Quantity > 0
				AND aisd.Active = 1
				AND aisd2.Active = 1
				AND aism.Active = 1
				AND qtyAss.Quantity IS NULL

			ORDER BY CASE 
					WHEN til.ID <> aism.MainItemListId
						THEN 0
					ELSE 1
					END
			) automaticSubstitute
		OUTER APPLY (
			SELECT CAST(1 AS BIT) NotEnough
			FROM picking.PickingTask pt2
			JOIN picking.PickingTaskDetail ptd2 ON ptd2.PickingTaskId = pt2.PickingTaskId
			JOIN dbo.TranEntry te2 ON te2.ID = ptd2.ItemId
				AND te2.isActive = 1
			WHERE ptd2.PickingTaskId = r.TaskId
				AND te2.ItemNumber = te.ItemNumber
				AND pt2.Active = 1
				AND ptd2.Active = 1
				AND ptd2.Picked = 0
			GROUP BY te2.ItemNumber,
				pt2.PickingTaskId
			HAVING COUNT(*) > COALESCE(qtyAss.Quantity, qtyDoorsWag.Quantity, qtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			) ne
			ORDER BY PickingTaskDetailId
			OPTION(RECOMPILE)
RETURN
END

GO
/****** Object:  UserDefinedFunction [picking].[PickingTaskDetailsViewtest1]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[PickingTaskDetailsViewtest1] (@taskId INT)
RETURNS @RetVal TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [nvarchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL
) 
AS
BEGIN


DECLARE @Ret TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [nvarchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL,
	AssembledOnly BIT,
	BucketID INT,
	ItemListID INT,
	ItemTypeCode INT,
	ISEID INT,
	ABNID INT,
	INDEX IX_Ret_ItemCode CLUSTERED (ItemCode) 
) 

INSERT INTO @Ret ([TaskId], [PickingTaskDetailId], [ItemId], [STATUS], [ItemStatus], [Active], [ProductType], [ItemType], [KD], [Picked], 
[PickedTime],
[ItemCode], 
[PickItem], 
[Description], [OrderNumber], [EstimatedCompleteDate], [Serial], [Abn], [APN], [ApnId], 
[LocationToPick], 
--[Warehouse], 
[Section], [Isle], 
--[PoNumberToPick], 
[PrintApn], 
--[Quantity], [HasEnougeStock], [SectionN], [IsleNumeric], 
[SubstituteReasonId], 
[Hinge], [AvailableToPick], [ParentItemId], [ItemSubTypeID], [PickingDate], [FulfillmentType], [AssembledOnly], [BucketID], ItemListID,
ItemTypeCode, ISEID, ABNID)
		SELECT pt.PickingTaskId TaskId,
			ptd.PickingTaskDetailId,
			ptd.ItemId,
			pts.Name AS STATUS,
			d.STATUS AS ItemStatus,
			ptd.Active,
			it.TypeName AS ProductType,
			te.ItemType,
			te.KD,
			ptd.Picked,
			COALESCE(abn.PickedTime, ise.PickedTime) AS PickedTime,
			il.ShortItemCode AS ItemCode,
			COALESCE(abn.ItemCode, ise.ItemCode/*, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode, il.ShortItemCode*/) AS PickItem,
			te.Description,
			o.SOnumber AS OrderNumber,
			o.EstimatedCompleteDate,
			ise.SerielID AS Serial,
			abn.ABNNumber AS Abn,
			apn.APN,
			apn.ID AS ApnId,
			COALESCE(abn.PickedFromLocation, ise.PickedFromLocation/*, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location*/) AS LocationToPick,
			--COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(abn.SectionPicked, ise.SectionPicked/*, locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section*/) AS Section,
			COALESCE(abn.IslePicked, ise.IslePicked/*, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle*/) AS Isle,
			--COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			b.PrintApn,
			--CASE 
			--	WHEN b.AssembledOnly = 1
			--		THEN ISNULL(qtyAss.Quantity, 0)
			--	ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			--	END Quantity,
			--CAST(CASE 
			--		WHEN qty.Quantity IS NULL
			--			AND qtyAss.Quantity IS NULL
			--			AND qtyDoors.Quantity IS NULL
			--			AND qtyDoorsWag.Quantity IS NULL
			--			AND automaticSubstitute.Quantity IS NULL
			--			OR (
			--				ise.ID IS NULL
			--				AND abn.ID IS NULL
			--				AND ne.NotEnough = 1
			--				)
			--			THEN 0
			--		ELSE 1
			--		END AS BIT) HasEnougeStock,
			--COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			--COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			COALESCE(ise.SubstituteTypeID, abn.SubstituteTypeID, CASE 
					WHEN te.SubstituteItemCode IS NOT NULL
						THEN 41
					ELSE NULL
					END) AS SubstituteReasonId,
			te.Hinge,
			ptd.AvailableToPick,
			ptd.ParentItemId,
			il.ItemSubTypeID,
			te.PickingDate,
			te.FulfillmentType,
			b.AssembledOnly,
			b.BucketID,
			il.ID,
			il.ItemTypeCode, ise.ID, abn.ID
		FROM picking.PickingTask pt
		JOIN picking.Buckets b ON b.BucketID = pt.BucketId
		JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId
			AND pt.Active = 1
			AND ptd.Active = 1
		JOIN dbo.TranEntry te ON te.ID = ptd.ItemId
			AND te.isActive = 1
		JOIN dbo.[Order] o ON o.ID = te.OrderID
			AND o.IsActive = 1
		JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
		JOIN dbo.ItemType it ON il.ItemTypeCode = it.TypeID
		LEFT OUTER JOIN dbo.tb_AccPickNumber apn ON apn.TranEntryID = te.ID
			AND apn.isActive = 1

		LEFT OUTER JOIN (
			SELECT ise.ID,
				ise.SerielID,
				ise.ItemCode,
				ise.PONumber,
				ise.PickedTime,
				ise.SubstituteTypeID,
				il2.Location AS PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				TranEntryID
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2 ON il2.ID = ise.PickedFromLocation
			WHERE ise.Picked = 1
			) ise ON ise.TranEntryID = te.ID


		LEFT OUTER JOIN  (
			SELECT abni.ID,
				abni.ABNID,
				abn.ABNNumber,
				abn.ItemCode,
				abn.PONumber,
				abni.PickedTime,
				abni.SubstituteTypeID,
				il2.Location PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				abni.TranEntryID
			FROM dbo.tb_AccBoxNumberItems abni
			JOIN dbo.tb_AccBoxNumber abn ON abn.ID = abni.ABNID
			JOIN dbo.InventoryLocation il2 ON il2.ID = abni.PickedFromLocation
			WHERE abni.Picked = 1
				AND abni.CreatedABNID IS NULL
			) abn ON abn.TranEntryID = te.ID


		WHERE pt.PickingTaskId = @TaskID

INSERT INTO @RetVal
SELECT r.TaskId,
			r.PickingTaskDetailId,
			r.ItemId,
			r.STATUS,
			r.ItemStatus,
			r.Active,
			r.ProductType,
			r.ItemType,
			r.KD,
			r.Picked,
			r.PickedTime,
			r.ItemCode,
			COALESCE(r.ItemCode, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode) AS PickItem,
			r.Description,
			r.OrderNumber,
			r.EstimatedCompleteDate,
			r.Serial,
			r.Abn,
			r.APN,
			r.ApnId,
			COALESCE(r.LocationToPick, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location) AS LocationToPick,
			COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(r.Section,locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section) AS Section,
			COALESCE(r.Isle, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle) AS Isle,
			COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			r.PrintApn,
			CASE 
				WHEN r.AssembledOnly = 1
					THEN ISNULL(qtyAss.Quantity, 0)
				ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
				END Quantity,
			CAST(CASE 
					WHEN qty.Quantity IS NULL
						AND qtyAss.Quantity IS NULL
						AND qtyDoors.Quantity IS NULL
						AND qtyDoorsWag.Quantity IS NULL
						AND automaticSubstitute.Quantity IS NULL
						OR (
							r.iseID IS NULL
							AND r.abnID IS NULL
							AND ne.NotEnough = 1
							)
						THEN 0
					ELSE 1
					END AS BIT) HasEnougeStock,
			COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			r.SubstituteReasonId,
			r.Hinge,
			r.AvailableToPick,
			r.ParentItemId,
			r.ItemSubTypeID,
			r.PickingDate,
			r.FulfillmentType
FROM @Ret AS r
JOIN dbo.TranEntry te ON te.ID = r.ItemId
		AND te.isActive = 1
LEFT JOIN dbo.tb_ItemList ilsub
			ON te.SubstituteItemCode = ilsub.ItemCode
OUTER APPLY (
	SELECT TOP 1 il2sl.Location,
		ilusl.PoNumber,
		il2sl.Isle,
		il2sl.Section,
		w.Description AS Warehouse,
		il2sl.IsleNumeric,
		CASE 
			WHEN il2sl.Section IS NOT NULL
				AND ISNUMERIC(il2sl.Section) = 1
				THEN CAST(il2sl.Section AS INT)
			ELSE CAST(10000 AS INT)
			END SectionN
	FROM dbo.InventoryLocation il2sl
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
		AND il2sl.ExcludeFrmStock = 0
		AND il2sl.IsPickable = 1
	JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
	LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
		AND ilusl.Quantity > 0
		AND ilusl.STATUS = 'Active'
	LEFT JOIN inventory.PoWo AS pw ON ilusl.PoNumber = pw.PoNumber
	WHERE COALESCE(ilsub.ShortItemCode, r.ItemCode) = ildic.ItemCode
	ORDER BY CASE 
			WHEN ilusl.Location IS NOT NULL
				THEN 0
			ELSE 1
			END
			--,
		--CASE 
		--	WHEN pw.PoNumber IS NOT NULL
		--		THEN pw.PoDate
		--	ELSE 10000
		--	END,
		--il2sl.AddTime
	) locations
OUTER APPLY (
	SELECT SUM(iq.Quantity) Quantity
	FROM dbo.ItemLocationsUpdate iq
	JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
		AND ilq.ExcludeFrmStock = 0
		AND ilq.IsPickable = 1
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
	JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
	WHERE iq.Quantity > 0
		AND iq.STATUS = 'Active'
		AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
	GROUP BY iq.ItemCode
) qty
		OUTER APPLY (
			SELECT TOP 1 ise.ReceivedLocation Location,
				ise.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(te.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219
							)
						THEN 5
					ELSE 0
					END
			) locationsAss
		OUTER APPLY (
			SELECT COUNT(*) AS Quantity
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(r.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219
							)
						THEN 5
					ELSE 0
					END
			) qtyAss
		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = 'Active'
			JOIN inventory.PoWo AS pw ON pw.PoNumber = ilusl.PoNumber
			WHERE COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND il2sl.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
				AND il2sl.Warehouse = 5
				AND il2sl.ExcludeFrmStock = 0
				AND locationsAss.Location IS NULL
			ORDER BY CASE 
					WHEN il2sl.Location LIKE 'WAG-DR-%'
						THEN 1
					ELSE 0
					END,
				CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END
				--	,
				--pw.PoDate
			) locationsDoors
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = 5
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND qtyAss.Quantity IS NULL
				AND iq.Quantity > 0
				AND iq.STATUS = 'Active'
				AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND ilq.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoors

		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = 'Active'
			JOIN inventory.PoWo AS pw ON pw.PoNumber = ilusl.PoNumber
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND locationsAss.Location IS NULL
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					237,
					238
					)
				AND il2sl.Warehouse = 5
				AND il2sl.ExcludeFrmStock = 0
				AND il2sl.Location LIKE 'WAG-DR-%'
				AND il2sl.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			ORDER BY CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				pw.PoDate
			) locationsDoorsWag
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = 5
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND qtyAss.Quantity IS NULL
				AND iq.Quantity > 0
				AND iq.STATUS = 'Active'
				AND iq.ItemCode = r.ItemCode
				AND r.BucketId IN (
					237,
					238
					)
				AND ilq.Location LIKE 'WAG-DR-%'
				AND ilq.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoorsWag
		OUTER APPLY (
			SELECT TOP (1) til.ShortItemCode,
				qty.Quantity,
				locations.Location,
				locations.Warehouse,
				locations.Section,
				locations.Isle,
				locations.PoNumber,
				locations.SectionN,
				locations.IsleNumeric
			FROM picking.AutomaticItemSubstitutionDetail AS aisd
			JOIN picking.AutomaticItemSubstitutionMaster AS aism ON aism.AutomaticItemSubstitutionMasterId = aisd.AutomaticItemSubstitutionMasterId
			JOIN picking.AutomaticItemSubstitutionDetail AS aisd2 ON aisd2.AutomaticItemSubstitutionMasterId = aism.AutomaticItemSubstitutionMasterId
			JOIN dbo.tb_ItemList AS til ON til.ID = aisd2.ItemlistId
			OUTER APPLY (
				SELECT TOP 1 il2sl.Location,
					ilusl.PoNumber,
					il2sl.Isle,
					il2sl.Section,
					w.Description AS Warehouse,
					il2sl.IsleNumeric,
					CASE 
						WHEN il2sl.Section IS NOT NULL
							AND ISNUMERIC(il2sl.Section) = 1
							THEN CAST(il2sl.Section AS INT)
						ELSE CAST(10000 AS INT)
						END SectionN
				FROM dbo.InventoryLocation il2sl
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
					AND il2sl.ExcludeFrmStock = 0
					AND il2sl.IsPickable = 1
				JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
					AND ilusl.Quantity > 0
					AND ilusl.STATUS = 'Active'
				LEFT JOIN inventory.PoWo AS pw ON pw.PoNumber = ilusl.PoNumber
				WHERE til.ShortItemCode = ildic.ItemCode
				ORDER BY CASE 
						WHEN ilusl.Location IS NOT NULL
							THEN 0
						ELSE 1
						END,
					CASE 
						WHEN pw.PoNumber IS NOT NULL
							THEN 0
						ELSE 10000
						END,
					pw.PoDate,
					il2sl.AddTime
				) locations
			OUTER APPLY (
				SELECT SUM(iq.Quantity) Quantity
				FROM dbo.ItemLocationsUpdate iq
				JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
					AND ilq.ExcludeFrmStock = 0
					AND ilq.IsPickable = 1
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
				JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
				WHERE iq.Quantity > 0
					AND iq.STATUS = 'Active'
					AND iq.ItemCode = til.ShortItemCode
				GROUP BY iq.ItemCode
				) qty
			WHERE r.ItemListID = aisd.ItemlistId
				AND qty.Quantity > 0
				AND aisd.Active = 1
				AND aisd2.Active = 1
				AND aism.Active = 1
				AND qtyAss.Quantity IS NULL

			ORDER BY CASE 
					WHEN til.ID <> aism.MainItemListId
						THEN 0
					ELSE 1
					END
			) automaticSubstitute
		OUTER APPLY (
			SELECT CAST(1 AS BIT) NotEnough
			FROM picking.PickingTask pt2
			JOIN picking.PickingTaskDetail ptd2 ON ptd2.PickingTaskId = pt2.PickingTaskId
			JOIN dbo.TranEntry te2 ON te2.ID = ptd2.ItemId
				AND te2.isActive = 1
			WHERE ptd2.PickingTaskId = r.TaskId
				AND te2.ItemNumber = te.ItemNumber
				AND pt2.Active = 1
				AND ptd2.Active = 1
				AND ptd2.Picked = 0
			GROUP BY te2.ItemNumber,
				pt2.PickingTaskId
			HAVING COUNT(*) > COALESCE(qtyAss.Quantity, qtyDoorsWag.Quantity, qtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			) ne
			ORDER BY PickingTaskDetailId
			OPTION(RECOMPILE)
RETURN
END

GO
/****** Object:  UserDefinedFunction [picking].[PickingTaskDetailsViewtest2]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE  FUNCTION [picking].[PickingTaskDetailsViewtest2] (@taskId INT)
RETURNS @RetVal TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [nvarchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL
) 
AS
BEGIN


DECLARE @Ret TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [nvarchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL,
	AssembledOnly BIT,
	BucketID INT,
	ItemListID INT,
	ItemTypeCode INT,
	ISEID INT,
	ABNID INT,
	INDEX IX_Ret_ItemCode CLUSTERED (ItemCode) 
) 

--RETURN
INSERT INTO @Ret ([TaskId], [PickingTaskDetailId], [ItemId], [STATUS], [ItemStatus], [Active], [ProductType], [ItemType], [KD], [Picked], 
[PickedTime],
[ItemCode], 
[PickItem], 
[Description], [OrderNumber], [EstimatedCompleteDate], [Serial], [Abn], [APN], [ApnId], 
[LocationToPick], 
--[Warehouse], 
[Section], [Isle], 
--[PoNumberToPick], 
[PrintApn], 
--[Quantity], [HasEnougeStock], [SectionN], [IsleNumeric], 
[SubstituteReasonId], 
[Hinge], [AvailableToPick], [ParentItemId], [ItemSubTypeID], [PickingDate], [FulfillmentType]
, [AssembledOnly], [BucketID], ItemListID,
ItemTypeCode, ISEID, ABNID
)
		SELECT pt.PickingTaskId TaskId,
			ptd.PickingTaskDetailId,
			ptd.ItemId,
			pts.Name AS STATUS,
			d.STATUS AS ItemStatus,
			ptd.Active,
			it.TypeName AS ProductType,
			te.ItemType,
			te.KD,
			ptd.Picked,
			--COALESCE(abn.PickedTime, ise.PickedTime)
			ptd.PickedTime AS PickedTime,
			il.ShortItemCode AS ItemCode,
			NULL AS PickItem,
			te.Description,
			o.SOnumber AS OrderNumber,
			o.EstimatedCompleteDate,
			--ise.SerielID 
			NULL 
			AS Serial,
			--abn.ABNNumber
			NULL  AS Abn,
			apn.APN,
			apn.ID AS ApnId,
			--COALESCE(abn.PickedFromLocation, ise.PickedFromLocation/*, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location*/)
			NULL  AS LocationToPick,
			--COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			--COALESCE(abn.SectionPicked, ise.SectionPicked/*, locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section*/)
			NULL  AS Section,
			--COALESCE(abn.IslePicked, ise.IslePicked/*, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle*/) 
			NULL AS Isle,
			--COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			b.PrintApn,
			--CASE 
			--	WHEN b.AssembledOnly = 1
			--		THEN ISNULL(qtyAss.Quantity, 0)
			--	ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			--	END Quantity,
			--CAST(CASE 
			--		WHEN qty.Quantity IS NULL
			--			AND qtyAss.Quantity IS NULL
			--			AND qtyDoors.Quantity IS NULL
			--			AND qtyDoorsWag.Quantity IS NULL
			--			AND automaticSubstitute.Quantity IS NULL
			--			OR (
			--				ise.ID IS NULL
			--				AND abn.ID IS NULL
			--				AND ne.NotEnough = 1
			--				)
			--			THEN 0
			--		ELSE 1
			--		END AS BIT) HasEnougeStock,
			--COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			--COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			--COALESCE(ise.SubstituteTypeID, abn.SubstituteTypeID, CASE 
			--		WHEN te.SubstituteItemCode IS NOT NULL
			--			THEN 41
			--		ELSE NULL
			--		END)
					NULL  AS SubstituteReasonId,
			te.Hinge,
			ptd.AvailableToPick,
			ptd.ParentItemId,
			il.ItemSubTypeID,
			te.PickingDate,
			te.FulfillmentType
			,
			b.AssembledOnly,
			b.BucketID,
			il.ID,
			il.ItemTypeCode, NULL , NULL 
		FROM picking.PickingTask pt
		JOIN picking.Buckets b ON b.BucketID = pt.BucketId
		JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId
			AND pt.Active = 1
			AND ptd.Active = 1
		JOIN dbo.TranEntry te ON te.ID = ptd.ItemId
			AND te.isActive = 1
		JOIN dbo.[Order] o ON o.ID = te.OrderID
			AND o.IsActive = 1
		JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
		JOIN dbo.ItemType it ON il.ItemTypeCode = it.TypeID
		LEFT OUTER JOIN dbo.tb_AccPickNumber apn ON apn.TranEntryID = te.ID
			AND apn.isActive = 1

		--OUTER APPLY (
		--	SELECT ise.ID,
		--		ise.SerielID,
		--		ise.ItemCode,
		--		ise.PONumber,
		--		ise.PickedTime,
		--		ise.SubstituteTypeID,
		--		il2.Location AS PickedFromLocation,
		--		il2.Isle IslePicked,
		--		il2.Section SectionPicked,
		--		ise.TranEntryID
		--	FROM dbo.tb_ItemSeriel ise
		--	JOIN dbo.InventoryLocation il2 ON il2.ID = ise.PickedFromLocation
		--	WHERE ise.Picked = 1
		--	AND ise.TranEntryID = te.ID AND ptd.Picked =1
		--	) ise 


		--OUTER APPLY  (
		--	SELECT abni.ID,
		--		abni.ABNID,
		--		abn.ABNNumber,
		--		abn.ItemCode,
		--		abn.PONumber,
		--		abni.PickedTime,
		--		abni.SubstituteTypeID,
		--		il2.Location PickedFromLocation,
		--		il2.Isle IslePicked,
		--		il2.Section SectionPicked,
		--		abni.TranEntryID
		--	FROM dbo.tb_AccBoxNumberItems abni
		--	JOIN dbo.tb_AccBoxNumber abn ON abn.ID = abni.ABNID
		--	JOIN dbo.InventoryLocation il2 ON il2.ID = abni.PickedFromLocation
		--	WHERE abni.Picked = 1
		--		AND abni.CreatedABNID IS NULL
		--		AND  abni.TranEntryID = te.ID AND ptd.Picked =1
		--	) abn 


		WHERE pt.PickingTaskId = @TaskID
		

INSERT INTO @RetVal
SELECT r.TaskId,
			r.PickingTaskDetailId,
			r.ItemId,
			r.STATUS,
			r.ItemStatus,
			r.Active,
			r.ProductType,
			r.ItemType,
			r.KD,
			r.Picked,
			r.PickedTime,
			r.ItemCode,
			r.ItemCode AS PickItem,
			r.Description,
			r.OrderNumber,
			r.EstimatedCompleteDate,
			r.Serial,
			r.Abn,
			r.APN,
			r.ApnId,
			COALESCE(r.LocationToPick, locations.Location) AS LocationToPick,
			--COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse)
			'69' AS Warehouse,
			COALESCE(r.Section, locations.Section) AS Section,
			COALESCE(r.Isle, locations.Isle) AS Isle,
			 locations.PoNumber AS PoNumberToPick,
			r.PrintApn,
			--CASE 
			--	WHEN r.AssembledOnly = 1
			--		THEN ISNULL(qtyAss.Quantity, 0)
			--	ELSE
				 --COALESCE( qty.Quantity, 0)
				--END
				0
				 Quantity,
			CAST(
			--CASE 
			--		WHEN qty.Quantity IS NULL
			--			AND qtyAss.Quantity IS NULL
			--			AND qtyDoors.Quantity IS NULL
			--			AND qtyDoorsWag.Quantity IS NULL
			--			AND automaticSubstitute.Quantity IS NULL
			--			OR (
			--				r.iseID IS NULL
			--				AND r.abnID IS NULL
			--				AND ne.NotEnough = 1
			--				)
			--			THEN 0
			--		ELSE 1
			--		END 
					1
					AS BIT)
					 HasEnougeStock,
			--COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000)
			0 AS SectionN,
			--COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) 
			0 AS IsleNumeric,
			r.SubstituteReasonId,
			r.Hinge,
			r.AvailableToPick,
			r.ParentItemId,
			r.ItemSubTypeID,
			r.PickingDate,
			r.FulfillmentType
FROM @Ret AS r
JOIN dbo.TranEntry te ON te.ID = r.ItemId
		AND te.isActive = 1
--LEFT JOIN dbo.tb_ItemList ilsub
--			ON te.SubstituteItemCode = ilsub.ItemCode
OUTER APPLY (
	SELECT TOP 1 il2sl.Location,
		ilusl.PoNumber,
		il2sl.Isle,
		il2sl.Section,
		--w.Description AS Warehouse,
		il2sl.IsleNumeric,
		CASE 
			WHEN il2sl.Section IS NOT NULL
				AND ISNUMERIC(il2sl.Section) = 1
				THEN CAST(il2sl.Section AS INT)
			ELSE CAST(10000 AS INT)
			END SectionN
	FROM dbo.InventoryLocation il2sl
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
		AND il2sl.ExcludeFrmStock = 0
		AND il2sl.IsPickable = 1
	--JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
	LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
		AND ilusl.Quantity > 0
		AND ilusl.STATUS = 'Active'
	LEFT JOIN inventory.PoWo AS pw ON ilusl.PoNumber = pw.PoNumber
	WHERE r.ItemCode = ildic.ItemCode
	ORDER BY CASE 
			WHEN ilusl.Location IS NOT NULL
				THEN 0
			ELSE 1
			END
		--	,
		--CASE 
		--	WHEN pw.PoNumber IS NOT NULL
		--		THEN pw.PoDate
		--	ELSE NULL
		--	END
		--	,
		--il2sl.AddTime
	) locations
--OUTER APPLY (
--	SELECT SUM(iq.Quantity) Quantity
--	FROM dbo.ItemLocationsUpdate iq
--	JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
--		AND ilq.ExcludeFrmStock = 0
--		AND ilq.IsPickable = 1
--	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
--	--JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
--	WHERE iq.Quantity > 0
--		--AND iq.STATUS = 'Active'
--		AND iq.ItemCode = r.ItemCode
--	GROUP BY iq.ItemCode
--) qty
		--OUTER APPLY (
		--	SELECT TOP 1 ise.ReceivedLocation Location,
		--		ise.PoNumber,
		--		il2sl.Isle,
		--		il2sl.Section,
		--		--w.Description AS Warehouse,
		--		il2sl.IsleNumeric,
		--		CASE 
		--			WHEN il2sl.Section IS NOT NULL
		--				AND ISNUMERIC(il2sl.Section) = 1
		--				THEN CAST(il2sl.Section AS INT)
		--			ELSE CAST(10000 AS INT)
		--			END SectionN
		--	FROM dbo.tb_ItemSeriel ise
		--	JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
		--		AND il2sl.ExcludeFrmStock = 0
		--		AND ise.Assembled = 1
		--		AND ise.Received = 1
		--	--JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
		--		AND (
		--			il2sl.Location LIKE 'ASC-%'
		--			OR il2sl.Location LIKE 'AST-%'
		--			AND il2sl.Location NOT IN ('ASC-1-1')
		--			)
		--	WHERE ise.ItemCode = r.ItemCode
		--		AND r.AssembledOnly = 1
		--		AND (
		--			ISNULL(ise.Hinge, 'N') = ISNULL(te.Hinge, 'N')
		--			OR NOT EXISTS (
		--				SELECT 1
		--				FROM dbo.tb_itemClassDetail icd
		--				WHERE icd.ItemCode = r.ItemCode
		--					AND icd.ClassID = 115
		--				)
		--			)
		--		AND il2sl.Warehouse = 5
		--		--CASE 
		--		--	WHEN r.BucketId IN (
		--		--			13,
		--		--			129
		--		--			)
		--		--		THEN 1
		--		--	WHEN r.BucketId = 14
		--		--		THEN 3
		--		--	WHEN r.BucketId = 15
		--		--		THEN 2
		--		--	WHEN r.BucketId IN (
		--		--			207,
		--		--			219
		--		--			)
		--		--		THEN 5
		--		--	ELSE 0
		--		--	END
		--	) locationsAss
		--OUTER APPLY (
		--	SELECT COUNT(*) AS Quantity
		--	FROM dbo.tb_ItemSeriel ise
		--	JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
		--		AND il2sl.ExcludeFrmStock = 0
		--		AND ise.Assembled = 1
		--		AND ise.Received = 1
		--	--JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
		--		AND (
		--			il2sl.Location LIKE 'ASC-%'
		--			OR il2sl.Location LIKE 'AST-%'
		--			AND il2sl.Location NOT IN ('ASC-1-1')
		--			)
		--	WHERE ise.ItemCode = r.ItemCode
		--		AND r.AssembledOnly = 1
		--		AND (
		--			ISNULL(ise.Hinge, 'N') = ISNULL(r.Hinge, 'N')
		--			OR NOT EXISTS (
		--				SELECT 1
		--				FROM dbo.tb_itemClassDetail icd
		--				WHERE icd.ItemCode = r.ItemCode
		--					AND icd.ClassID = 115
		--				)
		--			)
		--		AND il2sl.Warehouse = 5
		--		--CASE 
		--		--	WHEN r.BucketId IN (
		--		--			13,
		--		--			129
		--		--			)
		--		--		THEN 1
		--		--	WHEN r.BucketId = 14
		--		--		THEN 3
		--		--	WHEN r.BucketId = 15
		--		--		THEN 2
		--		--	WHEN r.BucketId IN (
		--		--			207,
		--		--			219
		--		--			)
		--		--		THEN 5
		--		--	ELSE 0
		--		--	END
		--	) qtyAss
		--OUTER APPLY (
		--	SELECT TOP 1 il2sl.Location,
		--		ilusl.PoNumber,
		--		il2sl.Isle,
		--		il2sl.Section,
		--		--w.Description AS Warehouse,
		--		il2sl.IsleNumeric,
		--		CASE 
		--			WHEN il2sl.Section IS NOT NULL
		--				AND ISNUMERIC(il2sl.Section) = 1
		--				THEN CAST(il2sl.Section AS INT)
		--			ELSE CAST(10000 AS INT)
		--			END SectionN
		--	FROM dbo.InventoryLocation il2sl
		--	--JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
		--	JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
		--		AND ilusl.Quantity > 0
		--		AND ilusl.STATUS = 'Active'
		--	JOIN inventory.PoWo AS pw ON pw.PoNumber = ilusl.PoNumber
		--	WHERE r.ItemTypeCode = 12
		--		AND  r.ItemCode = ilusl.ItemCode
		--		AND il2sl.IsPickable = 1
		--		AND r.BucketID IN (
		--			130,
		--			135,
		--			237,
		--			238
		--			)
		--		AND il2sl.Location NOT IN (
		--			'1-1-50',
		--			'1-2-50',
		--			'1-3-50',
		--			'1-4-50',
		--			'DMG-99-1',
		--			'WAG-DR-49',
		--			'WAG-DR-50',
		--			'WAG-DR-35',
		--			'WAG-DR-39',
		--			'WAG-DR-29',
		--			'WAG-DR-42',
		--			'WAG-DR-44',
		--			'WAG-DR-36',
		--			'WAG-DR-38',
		--			'WAG-DR-45',
		--			'WAG-DR-40'
		--			)
		--		AND il2sl.Warehouse = 5
		--		AND il2sl.ExcludeFrmStock = 0
		--		AND locationsAss.Location IS NULL
		--	ORDER BY CASE 
		--			WHEN il2sl.Location LIKE 'WAG-DR-%'
		--				THEN 1
		--			ELSE 0
		--			END,
		--		CASE 
		--			WHEN il2sl.LocationType IN (
		--					29,
		--					32,
		--					44,
		--					46
		--					)
		--				THEN 0
		--			ELSE 1
		--			END,
		--		pw.PoDate
		--	) locationsDoors
		--OUTER APPLY (
		--	SELECT SUM(iq.Quantity) Quantity
		--	FROM dbo.ItemLocationsUpdate iq
		--	JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
		--		AND ilq.ExcludeFrmStock = 0
		--		AND ilq.Warehouse = 5
		--	--JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
		--	WHERE 
		--		 r.ItemTypeCode = 12
		--		AND qtyAss.Quantity IS NULL
		--		AND iq.Quantity > 0
		--		AND iq.STATUS = 'Active'
		--		AND iq.ItemCode =r.ItemCode
		--		AND r.BucketID IN (
		--			130,
		--			135,
		--			237,
		--			238
		--			)
		--		AND ilq.Location NOT IN (
		--			'1-1-50',
		--			'1-2-50',
		--			'1-3-50',
		--			'1-4-50',
		--			'DMG-99-1',
		--			'WAG-DR-49',
		--			'WAG-DR-50',
		--			'WAG-DR-35',
		--			'WAG-DR-39',
		--			'WAG-DR-29',
		--			'WAG-DR-42',
		--			'WAG-DR-44',
		--			'WAG-DR-36',
		--			'WAG-DR-38',
		--			'WAG-DR-45',
		--			'WAG-DR-40'
		--			)
		--	GROUP BY iq.ItemCode
		--	) qtyDoors

		--OUTER APPLY (
		--	SELECT TOP 1 il2sl.Location,
		--		ilusl.PoNumber,
		--		il2sl.Isle,
		--		il2sl.Section,
		--		--w.Description AS Warehouse,
		--		il2sl.IsleNumeric,
		--		CASE 
		--			WHEN il2sl.Section IS NOT NULL
		--				AND ISNUMERIC(il2sl.Section) = 1
		--				THEN CAST(il2sl.Section AS INT)
		--			ELSE CAST(10000 AS INT)
		--			END SectionN
		--	FROM dbo.InventoryLocation il2sl
		--	--JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
		--	JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
		--		AND ilusl.Quantity > 0
		--		AND ilusl.STATUS = 'Active'
		--	JOIN inventory.PoWo AS pw ON pw.PoNumber = ilusl.PoNumber
		--	WHERE 
		--		r.ItemTypeCode = 12
		--		AND locationsAss.Location IS NULL
		--		AND r.ItemCode= ilusl.ItemCode
		--		AND il2sl.IsPickable = 1
		--		AND r.BucketID IN (
		--			237,
		--			238
		--			)
		--		AND il2sl.Warehouse = 5
		--		AND il2sl.ExcludeFrmStock = 0
		--		AND il2sl.Location LIKE 'WAG-DR-%'
		--		AND il2sl.Location NOT IN (
		--			'WAG-DR-49',
		--			'WAG-DR-50',
		--			'WAG-DR-35',
		--			'WAG-DR-39',
		--			'WAG-DR-29',
		--			'WAG-DR-42',
		--			'WAG-DR-44',
		--			'WAG-DR-36',
		--			'WAG-DR-38',
		--			'WAG-DR-45',
		--			'WAG-DR-40'
		--			)
		--	ORDER BY CASE 
		--			WHEN il2sl.LocationType IN (
		--					29,
		--					32,
		--					44,
		--					46
		--					)
		--				THEN 0
		--			ELSE 1
		--			END,
		--		pw.PoDate
		--	) locationsDoorsWag
		--OUTER APPLY (
		--	SELECT SUM(iq.Quantity) Quantity
		--	FROM dbo.ItemLocationsUpdate iq
		--	JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
		--		AND ilq.ExcludeFrmStock = 0
		--		AND ilq.Warehouse = 5
		--	--JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
		--	WHERE 
		--		r.ItemTypeCode = 12
		--		AND qtyAss.Quantity IS NULL
		--		AND iq.Quantity > 0
		--		AND iq.STATUS = 'Active'
		--		AND iq.ItemCode = r.ItemCode
		--		AND r.BucketId IN (
		--			237,
		--			238
		--			)
		--		AND ilq.Location LIKE 'WAG-DR-%'
		--		AND ilq.Location NOT IN (
		--			'WAG-DR-49',
		--			'WAG-DR-50',
		--			'WAG-DR-35',
		--			'WAG-DR-39',
		--			'WAG-DR-29',
		--			'WAG-DR-42',
		--			'WAG-DR-44',
		--			'WAG-DR-36',
		--			'WAG-DR-38',
		--			'WAG-DR-45',
		--			'WAG-DR-40'
		--			)
		--	GROUP BY iq.ItemCode
		--	) qtyDoorsWag
		--OUTER APPLY (
		--	SELECT TOP (1) til.ShortItemCode,
		--		qty.Quantity,
		--		locations.Location,
		--		--locations.Warehouse,
		--		locations.Section,
		--		locations.Isle,
		--		locations.PoNumber,
		--		locations.SectionN,
		--		locations.IsleNumeric
		--	FROM picking.AutomaticItemSubstitutionDetail AS aisd
		--	JOIN picking.AutomaticItemSubstitutionMaster AS aism ON aism.AutomaticItemSubstitutionMasterId = aisd.AutomaticItemSubstitutionMasterId
		--	JOIN picking.AutomaticItemSubstitutionDetail AS aisd2 ON aisd2.AutomaticItemSubstitutionMasterId = aism.AutomaticItemSubstitutionMasterId
		--	JOIN dbo.tb_ItemList AS til ON til.ID = aisd2.ItemlistId
		--	OUTER APPLY (
		--		SELECT TOP 1 il2sl.Location,
		--			ilusl.PoNumber,
		--			il2sl.Isle,
		--			il2sl.Section,
		--			--w.Description AS Warehouse,
		--			il2sl.IsleNumeric,
		--			CASE 
		--				WHEN il2sl.Section IS NOT NULL
		--					AND ISNUMERIC(il2sl.Section) = 1
		--					THEN CAST(il2sl.Section AS INT)
		--				ELSE CAST(10000 AS INT)
		--				END SectionN
		--		FROM dbo.InventoryLocation il2sl
		--		JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
		--			AND il2sl.ExcludeFrmStock = 0
		--			AND il2sl.IsPickable = 1
		--		--JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
		--		LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
		--			AND ilusl.Quantity > 0
		--			AND ilusl.STATUS = 'Active'
		--		LEFT JOIN inventory.PoWo AS pw ON pw.PoNumber = ilusl.PoNumber
		--		WHERE til.ShortItemCode = ildic.ItemCode
		--		ORDER BY CASE 
		--				WHEN ilusl.Location IS NOT NULL
		--					THEN 0
		--				ELSE 1
		--				END,
		--			CASE 
		--				WHEN pw.PoNumber IS NOT NULL
		--					THEN 0
		--				ELSE 10000
		--				END,
		--			pw.PoDate,
		--			il2sl.AddTime
		--		) locations
		--	OUTER APPLY (
		--		SELECT SUM(iq.Quantity) Quantity
		--		FROM dbo.ItemLocationsUpdate iq
		--		JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
		--			AND ilq.ExcludeFrmStock = 0
		--			AND ilq.IsPickable = 1
		--		JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
		--		--JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
		--		WHERE iq.Quantity > 0
		--			AND iq.STATUS = 'Active'
		--			AND iq.ItemCode = til.ShortItemCode
		--		GROUP BY iq.ItemCode
		--		) qty
		--	WHERE r.ItemListID = aisd.ItemlistId
		--		AND qty.Quantity > 0
		--		AND aisd.Active = 1
		--		AND aisd2.Active = 1
		--		AND aism.Active = 1
		--		AND qtyAss.Quantity IS NULL

		--	ORDER BY CASE 
		--			WHEN til.ID <> aism.MainItemListId
		--				THEN 0
		--			ELSE 1
		--			END
		--	) automaticSubstitute
		--OUTER APPLY (
		--	SELECT CAST(1 AS BIT) NotEnough
		--	FROM picking.PickingTask pt2
		--	JOIN picking.PickingTaskDetail ptd2 ON ptd2.PickingTaskId = pt2.PickingTaskId
		--	JOIN dbo.TranEntry te2 ON te2.ID = ptd2.ItemId
		--		AND te2.isActive = 1
		--	WHERE ptd2.PickingTaskId = r.TaskId
		--		AND te2.ItemNumber = te.ItemNumber
		--		AND pt2.Active = 1
		--		AND ptd2.Active = 1
		--		AND ptd2.Picked = 0
		--	GROUP BY te2.ItemNumber,
		--		pt2.PickingTaskId
		--	HAVING COUNT(*) > COALESCE(qtyAss.Quantity, qtyDoorsWag.Quantity, qtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
		--	) ne
		--	ORDER BY PickingTaskDetailId
			--OPTION(RECOMPILE)

RETURN
END

GO
/****** Object:  UserDefinedFunction [picking].[PickingTaskDetailsViewTestDI]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[PickingTaskDetailsViewTestDI] (@taskId INT)
RETURNS @RetVal TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [varchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL
) 
--AS
BEGIN


DECLARE @Ret TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [varchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL,
	AssembledOnly BIT,
	BucketID INT,
	ItemListID INT,
	ItemTypeCode INT,
	ISEID INT,
	ABNID INT,
	BucketWarhouseId INT NOT NULL,
	INDEX IX_Ret_ItemCode CLUSTERED (ItemCode) 
) 

INSERT INTO @Ret ([TaskId], [PickingTaskDetailId], [ItemId], [STATUS], [ItemStatus], [Active], [ProductType], [ItemType], [KD], [Picked], 
[PickedTime],
[ItemCode], 
[PickItem], 
[Description], [OrderNumber], [EstimatedCompleteDate], [Serial], [Abn], [APN], [ApnId], 
[LocationToPick], 
--[Warehouse], 
[Section], [Isle], 
--[PoNumberToPick], 
[PrintApn], 
--[Quantity], [HasEnougeStock], [SectionN], [IsleNumeric], 
[SubstituteReasonId], 
[Hinge], [AvailableToPick], [ParentItemId], [ItemSubTypeID], [PickingDate], [FulfillmentType], [AssembledOnly], [BucketID], ItemListID,
ItemTypeCode, ISEID, ABNID, BucketWarhouseId)
		SELECT pt.PickingTaskId TaskId,
			ptd.PickingTaskDetailId,
			ptd.ItemId,
			pts.Name AS STATUS,
			d.STATUS AS ItemStatus,
			ptd.Active,
			it.TypeName AS ProductType,
			te.ItemType,
			te.KD,
			ptd.Picked,
			COALESCE(abn.PickedTime, ise.PickedTime) AS PickedTime,
			il.ShortItemCode AS ItemCode,
			COALESCE(abn.ItemCode, ise.ItemCode/*, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode, il.ShortItemCode*/) AS PickItem,
			te.Description,
			o.SOnumber AS OrderNumber,
			o.EstimatedCompleteDate,
			ise.SerielID AS Serial,
			abn.ABNNumber AS Abn,
			apn.APN,
			apn.ID AS ApnId,
			COALESCE(abn.PickedFromLocation, ise.PickedFromLocation/*, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location*/) AS LocationToPick,
			--COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(abn.SectionPicked, ise.SectionPicked/*, locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section*/) AS Section,
			COALESCE(abn.IslePicked, ise.IslePicked/*, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle*/) AS Isle,
			--COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			b.PrintApn,
			--CASE 
			--	WHEN b.AssembledOnly = 1
			--		THEN ISNULL(qtyAss.Quantity, 0)
			--	ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			--	END Quantity,
			--CAST(CASE 
			--		WHEN qty.Quantity IS NULL
			--			AND qtyAss.Quantity IS NULL
			--			AND qtyDoors.Quantity IS NULL
			--			AND qtyDoorsWag.Quantity IS NULL
			--			AND automaticSubstitute.Quantity IS NULL
			--			OR (
			--				ise.ID IS NULL
			--				AND abn.ID IS NULL
			--				AND ne.NotEnough = 1
			--				)
			--			THEN 0
			--		ELSE 1
			--		END AS BIT) HasEnougeStock,
			--COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			--COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			COALESCE(ise.SubstituteTypeID, abn.SubstituteTypeID, CASE 
					WHEN te.SubstituteItemCode IS NOT NULL
						THEN 41
					ELSE NULL
					END) AS SubstituteReasonId,
			te.Hinge,
			ptd.AvailableToPick,
			ptd.ParentItemId,
			il.ItemSubTypeID,
			te.PickingDate,
			te.FulfillmentType,
			b.AssembledOnly,
			b.BucketID,
			il.ID,
			il.ItemTypeCode, ise.ID, abn.ID,
            b.WarehouseId
		FROM picking.PickingTask pt
		JOIN picking.Buckets b ON b.BucketID = pt.BucketId
		JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId
			AND pt.Active = 1
			AND ptd.Active = 1
		JOIN dbo.TranEntry te ON te.ID = ptd.ItemId
			AND te.isActive = 1
		JOIN dbo.[Order] o ON o.ID = te.OrderID
			AND o.IsActive = 1
		JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
		JOIN dbo.ItemType it ON il.ItemTypeCode = it.TypeID
		LEFT OUTER JOIN dbo.tb_AccPickNumber apn ON apn.TranEntryID = te.ID
			AND apn.isActive = 1

		LEFT OUTER JOIN (
			SELECT ise.ID,
				ise.SerielID,
				ise.ItemCode,
				ise.PONumber,
				ise.PickedTime,
				ise.SubstituteTypeID,
				il2.Location AS PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				TranEntryID
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2 ON il2.ID = ise.PickedFromLocation
			WHERE ise.Picked = 1
			) ise ON ise.TranEntryID = te.ID


		LEFT OUTER JOIN  (
			SELECT abni.ID,
				abni.ABNID,
				abn.ABNNumber,
				abn.ItemCode,
				abn.PONumber,
				abni.PickedTime,
				abni.SubstituteTypeID,
				il2.Location PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				abni.TranEntryID
			FROM dbo.tb_AccBoxNumberItems abni
			JOIN dbo.tb_AccBoxNumber abn ON abn.ID = abni.ABNID
			JOIN dbo.InventoryLocation il2 ON il2.ID = abni.PickedFromLocation
			JOIN dbo.tb_ItemList TIL ON TIL.ShortItemCode = abn.ItemCode
			WHERE abni.Picked = 1
				AND abni.CreatedABNID IS NULL
				AND (ISNULL(TIL.ComponentPartTypeId,0) <> 29 OR il2.LocationType = 41)
			) abn ON abn.TranEntryID = te.ID


		WHERE pt.PickingTaskId = @TaskID

INSERT INTO @RetVal
SELECT r.TaskId,
			r.PickingTaskDetailId,
			r.ItemId,
			r.STATUS,
			r.ItemStatus,
			r.Active,
			r.ProductType,
			r.ItemType,
			r.KD,
			r.Picked,
			r.PickedTime,
			r.ItemCode,
			COALESCE(r.PickItem, r.ItemCode, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode) AS PickItem,
			r.Description,
			r.OrderNumber,
			r.EstimatedCompleteDate,
			r.Serial,
			r.Abn,
			r.APN,
			r.ApnId,
			COALESCE(r.LocationToPick, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location) AS LocationToPick,
			COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(r.Section,locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section) AS Section,
			COALESCE(r.Isle, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle) AS Isle,
			COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			r.PrintApn,
			CASE 
				WHEN r.AssembledOnly = 1
					THEN ISNULL(qtyAss.Quantity, 0)
				ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
				END Quantity,
			CAST(CASE 
					WHEN qty.Quantity IS NULL
						AND ISNULL(qtyAss.Quantity, 0) = 0
						AND qtyDoors.Quantity IS NULL
						AND qtyDoorsWag.Quantity IS NULL
						AND automaticSubstitute.Quantity IS NULL
						OR (
							r.iseID IS NULL
							AND r.abnID IS NULL
							AND ne.NotEnough = 1
							)
						THEN 0
					ELSE 1
					END AS BIT) HasEnougeStock,
			COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			r.SubstituteReasonId,
			r.Hinge,
			r.AvailableToPick,
			r.ParentItemId,
			r.ItemSubTypeID,
			r.PickingDate,
			r.FulfillmentType
FROM @Ret AS r
JOIN dbo.TranEntry te ON te.ID = r.ItemId
		AND te.isActive = 1
JOIN dbo.tb_ItemList TIL ON TIL.ItemCode = te.ItemNumber
LEFT JOIN dbo.tb_ItemList ilsub
			ON te.SubstituteItemCode = ilsub.ItemCode
OUTER APPLY (
	SELECT TOP 1 il2sl.Location,
		ilusl.PoNumber,
		il2sl.Isle,
		il2sl.Section,
		w.Description AS Warehouse,
		il2sl.IsleNumeric,
		CASE 
			WHEN il2sl.Section IS NOT NULL
				AND ISNUMERIC(il2sl.Section) = 1
				THEN CAST(il2sl.Section AS INT)
			ELSE CAST(10000 AS INT)
			END SectionN
	FROM dbo.InventoryLocation il2sl
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
		AND il2sl.ExcludeFrmStock = 0
		AND il2sl.IsPickable = 1
	JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
	LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
		AND ilusl.Quantity > 0
		AND ilusl.STATUS = N'Active'
	OUTER APPLY(SELECT TOP 1 p.PoNumber, COALESCE(p.PromisedOn, p.POCreated, p.AddDate) PoDate
		FROM inventory.Po AS p 
		WHERE p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0
		AND p.PoNumber = ilusl.PoNumber
		)po
	OUTER APPLY(SELECT TOP 1 po.ProductionNumber AS PoNumber, po.ProductionEndDate PoDate 
		FROM acumaticaManufacturing.ProductionOrders AS po
		WHERE po.DeleteFlag = 0
		AND po.ProductionNumber = ilusl.PoNumber)wo
	WHERE COALESCE(ilsub.ShortItemCode, r.ItemCode) = ildic.ItemCode
	AND (COALESCE(ilsub.ComponentPartTypeId,til.ComponentPartTypeId, 0) <> 29 OR il2sl.LocationType = 41)
	ORDER BY CASE 
			WHEN ilusl.Location IS NOT NULL
				THEN 0
			ELSE 1
			END,
		CASE 
			WHEN COALESCE(po.PoNumber, wo.PoNumber) IS NOT NULL
				THEN COALESCE(po.PoDate, wo.PoDate)
			ELSE 10000
			END,
		il2sl.AddTime
	) locations
OUTER APPLY (
	SELECT SUM(iq.Quantity) Quantity
	FROM dbo.ItemLocationsUpdate iq
	JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
		AND ilq.ExcludeFrmStock = 0
		AND ilq.IsPickable = 1
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
	JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
	WHERE iq.Quantity > 0
		AND iq.STATUS = N'Active'
		AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
		AND (COALESCE(ilsub.ComponentPartTypeId,til.ComponentPartTypeId, 0) <> 29 OR ilq.LocationType = 41)
	GROUP BY iq.ItemCode
) qty
		OUTER APPLY (
			SELECT TOP 1 ise.ReceivedLocation Location,
				ise.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(te.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219,
							271,272,273
							)
						THEN 5
					ELSE 0
					END
			) locationsAss
		OUTER APPLY (
			SELECT COUNT(*) AS Quantity
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(r.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219,
							271,272,273
							)
						THEN 5
					ELSE 0
					END
			) qtyAss
		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = N'Active'
			OUTER APPLY(SELECT TOP 1 COALESCE(p.PromisedOn, p.POCreated, p.AddDate) PoDate FROM inventory.Po AS p 
				WHERE p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0
				AND p.PoNumber = ilusl.PoNumber)po
			OUTER APPLY(SELECT TOP 1 po.ProductionEndDate PoDate 
			FROM acumaticaManufacturing.ProductionOrders AS po
			WHERE po.DeleteFlag = 0
			AND po.ProductionNumber = ilusl.PoNumber)wo
			WHERE COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND il2sl.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
				AND il2sl.Warehouse = r.BucketWarhouseId
				AND il2sl.ExcludeFrmStock = 0
				AND locationsAss.Location IS NULL
			ORDER BY CASE 
					WHEN il2sl.Location LIKE 'WAG-DR-%'
						THEN 1
					ELSE 0
					END,
				CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				COALESCE(po.PoDate, wo.PoDate)
			) locationsDoors
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = r.BucketWarhouseId
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND ISNULL(qtyAss.Quantity,0) = 0
				AND iq.Quantity > 0
				AND iq.STATUS = N'Active'
				AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND ilq.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoors

		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = N'Active'
			OUTER APPLY(SELECT TOP 1 COALESCE(p.PromisedOn, p.POCreated, p.AddDate) PoDate FROM inventory.Po AS p 
				WHERE p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0
				AND p.PoNumber = ilusl.PoNumber)po
			OUTER APPLY(SELECT TOP 1 po.ProductionEndDate PoDate 
			FROM acumaticaManufacturing.ProductionOrders AS po
			WHERE po.DeleteFlag = 0
			AND po.ProductionNumber = ilusl.PoNumber)wo
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND locationsAss.Location IS NULL
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					237,
					238
					)
				AND il2sl.Warehouse = r.BucketWarhouseId
				AND il2sl.ExcludeFrmStock = 0
				AND il2sl.Location LIKE 'WAG-DR-%'
				AND il2sl.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			ORDER BY CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				COALESCE(po.PoDate, wo.PoDate)
			) locationsDoorsWag
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = r.BucketWarhouseId
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND ISNULL(qtyAss.Quantity,0) = 0
				AND iq.Quantity > 0
				AND iq.STATUS = N'Active'
				AND iq.ItemCode = r.ItemCode
				AND r.BucketId IN (
					237,
					238
					)
				AND ilq.Location LIKE 'WAG-DR-%'
				AND ilq.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoorsWag
		OUTER APPLY (
			SELECT TOP (1) Sub.ShortItemCode,
				qty.Quantity,
				locations.Location,
				locations.Warehouse,
				locations.Section,
				locations.Isle,
				locations.PoNumber,
				locations.SectionN,
				locations.IsleNumeric
			FROM 
			(
				SELECT TOP (1) tilSub.ShortItemCode, tilSub.ID SubId, aism.MainItemListId MainId
				FROM picking.AutomaticItemSubstitutionDetail AS aisd
				JOIN picking.AutomaticItemSubstitutionMaster AS aism ON aism.AutomaticItemSubstitutionMasterId = aisd.AutomaticItemSubstitutionMasterId
				JOIN picking.AutomaticItemSubstitutionDetail AS aisd2 ON aisd2.AutomaticItemSubstitutionMasterId = aism.AutomaticItemSubstitutionMasterId
				JOIN dbo.tb_ItemList AS tilSub ON tilSub.ID = aisd2.ItemlistId
				JOIN dbo.ItemLocationsUpdate ILU ON tilSub.ShortItemCode = ILU.ItemCode AND ILU.Quantity > 0
				WHERE aisd.Active = 1
				AND aisd2.Active = 1
				AND aism.Active = 1
				AND r.ItemListID = aisd.ItemlistId
				ORDER BY CASE 
					WHEN tilSub.ID <> aism.MainItemListId
						THEN 0
					ELSE 1
					END

				UNION

				SELECT tilPid.ShortItemCode, tilPid.ID SubId, pi.ItemlistId MainId
				FROM Picking.ProductionItem AS pi
				JOIN picking.ProductionItemDetail AS pid ON pid.ProductionItemId = pi.ProductionItemId AND pid.Deleted = 0
				JOIN dbo.tb_ItemList AS tilPid ON tilPid.ID = pid.ItemlistId
				WHERE pi.OrderItemId = te.ID
				AND pid.Deleted = 0
				AND pi.Deleted = 0
				AND pid.Picked = 0
				AND pid.PickingTypeId = 7
			)AS Sub
			OUTER APPLY (
				SELECT TOP 1 il2sl.Location,
					ilusl.PoNumber,
					il2sl.Isle,
					il2sl.Section,
					w.Description AS Warehouse,
					il2sl.IsleNumeric,
					CASE 
						WHEN il2sl.Section IS NOT NULL
							AND ISNUMERIC(il2sl.Section) = 1
							THEN CAST(il2sl.Section AS INT)
						ELSE CAST(10000 AS INT)
						END SectionN
				FROM dbo.InventoryLocation il2sl
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
					AND il2sl.ExcludeFrmStock = 0
					AND il2sl.IsPickable = 1
				JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
					AND ilusl.Quantity > 0
					AND ilusl.STATUS = N'Active'
				OUTER APPLY(SELECT TOP 1 p.PoNumber, COALESCE(p.PromisedOn, p.POCreated, p.AddDate) PoDate FROM inventory.Po AS p 
					WHERE p.Status <> 'Canceled' OR p.Status IS NULL AND p.Deleted = 0
					AND p.PoNumber = ilusl.PoNumber)po
				OUTER APPLY(SELECT TOP 1 po.ProductionNumber AS PoNumber, po.ProductionEndDate PoDate 
					FROM acumaticaManufacturing.ProductionOrders AS po
					WHERE po.DeleteFlag = 0
					AND po.ProductionNumber = ilusl.PoNumber)wo
				WHERE Sub.ShortItemCode = ildic.ItemCode
				ORDER BY CASE 
						WHEN ilusl.Location IS NOT NULL
							THEN 0
						ELSE 1
						END,
					CASE 
						WHEN COALESCE(po.PoNumber, wo.PoNumber) IS NOT NULL
							THEN 0
						ELSE 10000
						END,
					COALESCE(po.PoDate, wo.PoDate),
					il2sl.AddTime
				) locations
			OUTER APPLY (
				SELECT SUM(iq.Quantity) Quantity
				FROM dbo.ItemLocationsUpdate iq
				JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
					AND ilq.ExcludeFrmStock = 0
					AND ilq.IsPickable = 1
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
				JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
				WHERE iq.Quantity > 0
					AND iq.STATUS = N'Active'
					AND iq.ItemCode = Sub.ShortItemCode
				GROUP BY iq.ItemCode
				) qty
			WHERE qty.Quantity > 0
			AND ISNULL(qtyAss.Quantity,0) = 0
			) automaticSubstitute
		OUTER APPLY (
			SELECT CAST(1 AS BIT) NotEnough
			FROM picking.PickingTask pt2
			JOIN picking.PickingTaskDetail ptd2 ON ptd2.PickingTaskId = pt2.PickingTaskId
			JOIN dbo.TranEntry te2 ON te2.ID = ptd2.ItemId
				AND te2.isActive = 1
			WHERE ptd2.PickingTaskId = r.TaskId
				AND te2.ItemNumber = te.ItemNumber
				AND pt2.Active = 1
				AND ptd2.Active = 1
				AND ptd2.Picked = 0
			GROUP BY te2.ItemNumber,
				pt2.PickingTaskId
			HAVING COUNT(*) > COALESCE( qtyDoorsWag.Quantity, qtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity,qtyAss.Quantity, 0)
			) ne
			ORDER BY PickingTaskDetailId
			--OPTION(RECOMPILE)
RETURN
END
GO
/****** Object:  UserDefinedFunction [picking].[SQLskills_PickingTaskDetailsView]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [picking].[SQLskills_PickingTaskDetailsView] (@taskId INT)
RETURNS @RetVal TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [nvarchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL
) 
AS
BEGIN


DECLARE @Ret TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [nvarchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL,
	AssembledOnly BIT,
	BucketID INT,
	ItemListID INT,
	ItemTypeCode INT,
	ISEID INT,
	ABNID INT,
	INDEX IX_Ret_ItemCode CLUSTERED (ItemCode) 
) 

INSERT INTO @Ret ([TaskId], [PickingTaskDetailId], [ItemId], [STATUS], [ItemStatus], [Active], [ProductType], [ItemType], [KD], [Picked], 
[PickedTime],
[ItemCode], 
[PickItem], 
[Description], [OrderNumber], [EstimatedCompleteDate], [Serial], [Abn], [APN], [ApnId], 
[LocationToPick], 
--[Warehouse], 
[Section], [Isle], 
--[PoNumberToPick], 
[PrintApn], 
--[Quantity], [HasEnougeStock], [SectionN], [IsleNumeric], 
[SubstituteReasonId], 
[Hinge], [AvailableToPick], [ParentItemId], [ItemSubTypeID], [PickingDate], [FulfillmentType], [AssembledOnly], [BucketID], ItemListID,
ItemTypeCode, ISEID, ABNID)
		SELECT pt.PickingTaskId TaskId,
			ptd.PickingTaskDetailId,
			ptd.ItemId,
			pts.Name AS STATUS,
			d.STATUS AS ItemStatus,
			ptd.Active,
			it.TypeName AS ProductType,
			te.ItemType,
			te.KD,
			ptd.Picked,
			COALESCE(abn.PickedTime, ise.PickedTime) AS PickedTime,
			il.ShortItemCode AS ItemCode,
			COALESCE(abn.ItemCode, ise.ItemCode/*, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode, il.ShortItemCode*/) AS PickItem,
			te.Description,
			o.SOnumber AS OrderNumber,
			o.EstimatedCompleteDate,
			ise.SerielID AS Serial,
			abn.ABNNumber AS Abn,
			apn.APN,
			apn.ID AS ApnId,
			COALESCE(abn.PickedFromLocation, ise.PickedFromLocation/*, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location*/) AS LocationToPick,
			--COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(abn.SectionPicked, ise.SectionPicked/*, locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section*/) AS Section,
			COALESCE(abn.IslePicked, ise.IslePicked/*, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle*/) AS Isle,
			--COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			b.PrintApn,
			--CASE 
			--	WHEN b.AssembledOnly = 1
			--		THEN ISNULL(qtyAss.Quantity, 0)
			--	ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			--	END Quantity,
			--CAST(CASE 
			--		WHEN qty.Quantity IS NULL
			--			AND qtyAss.Quantity IS NULL
			--			AND qtyDoors.Quantity IS NULL
			--			AND qtyDoorsWag.Quantity IS NULL
			--			AND automaticSubstitute.Quantity IS NULL
			--			OR (
			--				ise.ID IS NULL
			--				AND abn.ID IS NULL
			--				AND ne.NotEnough = 1
			--				)
			--			THEN 0
			--		ELSE 1
			--		END AS BIT) HasEnougeStock,
			--COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			--COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			COALESCE(ise.SubstituteTypeID, abn.SubstituteTypeID, CASE 
					WHEN te.SubstituteItemCode IS NOT NULL
						THEN 41
					ELSE NULL
					END) AS SubstituteReasonId,
			te.Hinge,
			ptd.AvailableToPick,
			ptd.ParentItemId,
			il.ItemSubTypeID,
			te.PickingDate,
			te.FulfillmentType,
			b.AssembledOnly,
			b.BucketID,
			il.ID,
			il.ItemTypeCode, ise.ID, abn.ID
		FROM picking.PickingTask pt
		JOIN picking.Buckets b ON b.BucketID = pt.BucketId
		JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId
			AND pt.Active = 1
			AND ptd.Active = 1
		JOIN dbo.TranEntry te ON te.ID = ptd.ItemId
			AND te.isActive = 1
		JOIN dbo.[Order] o ON o.ID = te.OrderID
			AND o.IsActive = 1
		JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
		JOIN dbo.ItemType it ON il.ItemTypeCode = it.TypeID
		LEFT OUTER JOIN dbo.tb_AccPickNumber apn ON apn.TranEntryID = te.ID
			AND apn.isActive = 1

		LEFT OUTER JOIN (
			SELECT ise.ID,
				ise.SerielID,
				ise.ItemCode,
				ise.PONumber,
				ise.PickedTime,
				ise.SubstituteTypeID,
				il2.Location AS PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				TranEntryID
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2 ON il2.ID = ise.PickedFromLocation
			WHERE ise.Picked = 1
			) ise ON ise.TranEntryID = te.ID


		LEFT OUTER JOIN  (
			SELECT abni.ID,
				abni.ABNID,
				abn.ABNNumber,
				abn.ItemCode,
				abn.PONumber,
				abni.PickedTime,
				abni.SubstituteTypeID,
				il2.Location PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				abni.TranEntryID
			FROM dbo.tb_AccBoxNumberItems abni
			JOIN dbo.tb_AccBoxNumber abn ON abn.ID = abni.ABNID
			JOIN dbo.InventoryLocation il2 ON il2.ID = abni.PickedFromLocation
			WHERE abni.Picked = 1
				AND abni.CreatedABNID IS NULL
			) abn ON abn.TranEntryID = te.ID


		WHERE pt.PickingTaskId = @TaskID

INSERT INTO @RetVal
SELECT r.TaskId,
			r.PickingTaskDetailId,
			r.ItemId,
			r.STATUS,
			r.ItemStatus,
			r.Active,
			r.ProductType,
			r.ItemType,
			r.KD,
			r.Picked,
			r.PickedTime,
			r.ItemCode,
			COALESCE(r.ItemCode, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode) AS PickItem,
			r.Description,
			r.OrderNumber,
			r.EstimatedCompleteDate,
			r.Serial,
			r.Abn,
			r.APN,
			r.ApnId,
			COALESCE(r.LocationToPick, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location) AS LocationToPick,
			COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(r.Section,locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section) AS Section,
			COALESCE(r.Isle, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle) AS Isle,
			COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			r.PrintApn,
			CASE 
				WHEN r.AssembledOnly = 1
					THEN ISNULL(qtyAss.Quantity, 0)
				ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
				END Quantity,
			CAST(CASE 
					WHEN qty.Quantity IS NULL
						AND qtyAss.Quantity IS NULL
						AND qtyDoors.Quantity IS NULL
						AND qtyDoorsWag.Quantity IS NULL
						AND automaticSubstitute.Quantity IS NULL
						OR (
							r.iseID IS NULL
							AND r.abnID IS NULL
							AND ne.NotEnough = 1
							)
						THEN 0
					ELSE 1
					END AS BIT) HasEnougeStock,
			COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			r.SubstituteReasonId,
			r.Hinge,
			r.AvailableToPick,
			r.ParentItemId,
			r.ItemSubTypeID,
			r.PickingDate,
			r.FulfillmentType
FROM @Ret AS r
JOIN dbo.TranEntry te ON te.ID = r.ItemId
		AND te.isActive = 1
LEFT JOIN dbo.tb_ItemList ilsub
			ON te.SubstituteItemCode = ilsub.ItemCode
OUTER APPLY (
	SELECT TOP 1 il2sl.Location,
		ilusl.PoNumber,
		il2sl.Isle,
		il2sl.Section,
		w.Description AS Warehouse,
		il2sl.IsleNumeric,
		CASE 
			WHEN il2sl.Section IS NOT NULL
				AND ISNUMERIC(il2sl.Section) = 1
				THEN CAST(il2sl.Section AS INT)
			ELSE CAST(10000 AS INT)
			END SectionN
	FROM dbo.InventoryLocation il2sl
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
		AND il2sl.ExcludeFrmStock = 0
		AND il2sl.IsPickable = 1
	JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
	LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
		AND ilusl.Quantity > 0
		AND ilusl.STATUS = 'Active'
	LEFT JOIN inventory.PoWo AS pw ON ilusl.PoNumber = pw.PoNumber
	WHERE COALESCE(ilsub.ShortItemCode, r.ItemCode) = ildic.ItemCode
	ORDER BY CASE 
			WHEN ilusl.Location IS NOT NULL
				THEN 0
			ELSE 1
			END,
		CASE 
			WHEN pw.PoNumber IS NOT NULL
				THEN pw.PoDate
			ELSE 10000
			END,
		il2sl.AddTime
	) locations
OUTER APPLY (
	SELECT SUM(iq.Quantity) Quantity
	FROM dbo.ItemLocationsUpdate iq
	JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
		AND ilq.ExcludeFrmStock = 0
		AND ilq.IsPickable = 1
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
	JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
	WHERE iq.Quantity > 0
		AND iq.STATUS = 'Active'
		AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
	GROUP BY iq.ItemCode
) qty
		OUTER APPLY (
			SELECT TOP 1 ise.ReceivedLocation Location,
				ise.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(te.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219
							)
						THEN 5
					ELSE 0
					END
			) locationsAss
		OUTER APPLY (
			SELECT COUNT(*) AS Quantity
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(r.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219
							)
						THEN 5
					ELSE 0
					END
			) qtyAss
		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = 'Active'
			JOIN inventory.PoWo AS pw ON pw.PoNumber = ilusl.PoNumber
			WHERE COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND il2sl.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
				AND il2sl.Warehouse = 5
				AND il2sl.ExcludeFrmStock = 0
				AND locationsAss.Location IS NULL
			ORDER BY CASE 
					WHEN il2sl.Location LIKE 'WAG-DR-%'
						THEN 1
					ELSE 0
					END,
				CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				pw.PoDate
			) locationsDoors
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = 5
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND qtyAss.Quantity IS NULL
				AND iq.Quantity > 0
				AND iq.STATUS = 'Active'
				AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND ilq.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoors

		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = 'Active'
			JOIN inventory.PoWo AS pw ON pw.PoNumber = ilusl.PoNumber
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND locationsAss.Location IS NULL
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					237,
					238
					)
				AND il2sl.Warehouse = 5
				AND il2sl.ExcludeFrmStock = 0
				AND il2sl.Location LIKE 'WAG-DR-%'
				AND il2sl.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			ORDER BY CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				pw.PoDate
			) locationsDoorsWag
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = 5
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND qtyAss.Quantity IS NULL
				AND iq.Quantity > 0
				AND iq.STATUS = 'Active'
				AND iq.ItemCode = r.ItemCode
				AND r.BucketId IN (
					237,
					238
					)
				AND ilq.Location LIKE 'WAG-DR-%'
				AND ilq.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoorsWag
		OUTER APPLY (
			SELECT TOP (1) til.ShortItemCode,
				qty.Quantity,
				locations.Location,
				locations.Warehouse,
				locations.Section,
				locations.Isle,
				locations.PoNumber,
				locations.SectionN,
				locations.IsleNumeric
			FROM picking.AutomaticItemSubstitutionDetail AS aisd
			JOIN picking.AutomaticItemSubstitutionMaster AS aism ON aism.AutomaticItemSubstitutionMasterId = aisd.AutomaticItemSubstitutionMasterId
			JOIN picking.AutomaticItemSubstitutionDetail AS aisd2 ON aisd2.AutomaticItemSubstitutionMasterId = aism.AutomaticItemSubstitutionMasterId
			JOIN dbo.tb_ItemList AS til ON til.ID = aisd2.ItemlistId
			OUTER APPLY (
				SELECT TOP 1 il2sl.Location,
					ilusl.PoNumber,
					il2sl.Isle,
					il2sl.Section,
					w.Description AS Warehouse,
					il2sl.IsleNumeric,
					CASE 
						WHEN il2sl.Section IS NOT NULL
							AND ISNUMERIC(il2sl.Section) = 1
							THEN CAST(il2sl.Section AS INT)
						ELSE CAST(10000 AS INT)
						END SectionN
				FROM dbo.InventoryLocation il2sl
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
					AND il2sl.ExcludeFrmStock = 0
					AND il2sl.IsPickable = 1
				JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
					AND ilusl.Quantity > 0
					AND ilusl.STATUS = 'Active'
				LEFT JOIN inventory.PoWo AS pw ON pw.PoNumber = ilusl.PoNumber
				WHERE til.ShortItemCode = ildic.ItemCode
				ORDER BY CASE 
						WHEN ilusl.Location IS NOT NULL
							THEN 0
						ELSE 1
						END,
					CASE 
						WHEN pw.PoNumber IS NOT NULL
							THEN 0
						ELSE 10000
						END,
					pw.PoDate,
					il2sl.AddTime
				) locations
			OUTER APPLY (
				SELECT SUM(iq.Quantity) Quantity
				FROM dbo.ItemLocationsUpdate iq
				JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
					AND ilq.ExcludeFrmStock = 0
					AND ilq.IsPickable = 1
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
				JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
				WHERE iq.Quantity > 0
					AND iq.STATUS = 'Active'
					AND iq.ItemCode = til.ShortItemCode
				GROUP BY iq.ItemCode
				) qty
			WHERE r.ItemListID = aisd.ItemlistId
				AND qty.Quantity > 0
				AND aisd.Active = 1
				AND aisd2.Active = 1
				AND aism.Active = 1
				AND qtyAss.Quantity IS NULL

			ORDER BY CASE 
					WHEN til.ID <> aism.MainItemListId
						THEN 0
					ELSE 1
					END
			) automaticSubstitute
		OUTER APPLY (
			SELECT CAST(1 AS BIT) NotEnough
			FROM picking.PickingTask pt2
			JOIN picking.PickingTaskDetail ptd2 ON ptd2.PickingTaskId = pt2.PickingTaskId
			JOIN dbo.TranEntry te2 ON te2.ID = ptd2.ItemId
				AND te2.isActive = 1
			WHERE ptd2.PickingTaskId = r.TaskId
				AND te2.ItemNumber = te.ItemNumber
				AND pt2.Active = 1
				AND ptd2.Active = 1
				AND ptd2.Picked = 0
			GROUP BY te2.ItemNumber,
				pt2.PickingTaskId
			HAVING COUNT(*) > COALESCE(qtyAss.Quantity, qtyDoorsWag.Quantity, qtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			) ne
			ORDER BY PickingTaskDetailId
			OPTION(RECOMPILE)
RETURN
END

GO
/****** Object:  UserDefinedFunction [picking].[SQLskills2_PickingTaskDetailsView]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [picking].[SQLskills2_PickingTaskDetailsView] (@taskId INT)
RETURNS @RetVal TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [nvarchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL
) 
AS
BEGIN


DECLARE @Ret TABLE (
	[TaskId] [int] NOT NULL,
	[PickingTaskDetailId] [int] NOT NULL,
	[ItemId] [int] NULL,
	[STATUS] [nvarchar](15) NOT NULL,
	[ItemStatus] [nvarchar](150) NOT NULL,
	[Active] [bit] NOT NULL,
	[ProductType] [varchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[KD] [bit] NOT NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[PickItem] [nvarchar](150) NULL,
	[Description] [nvarchar](2000) NULL,
	[OrderNumber] [nvarchar](50) NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Serial] [varchar](50) NULL,
	[Abn] [varchar](50) NULL,
	[APN] [varchar](150) NULL,
	[ApnId] [int] NULL,
	[LocationToPick] [nvarchar](255) NULL,
	[Warehouse] [varchar](50) NULL,
	[Section] [nvarchar](255) NULL,
	[Isle] [nvarchar](255) NULL,
	[PoNumberToPick] [nvarchar](50) NULL,
	[PrintApn] [bit] NOT NULL,
	[Quantity] [int] NULL,
	[HasEnougeStock] [bit] NULL,
	[SectionN] [int] NULL,
	[IsleNumeric] [int] NULL,
	[SubstituteReasonId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[AvailableToPick] [bit] NOT NULL,
	[ParentItemId] [int] NULL,
	[ItemSubTypeID] [int] NULL,
	[PickingDate] [date] NULL,
	[FulfillmentType] [varchar](50) NULL,
	AssembledOnly BIT,
	BucketID INT,
	ItemListID INT,
	ItemTypeCode INT,
	ISEID INT,
	ABNID INT,
	INDEX IX_Ret_ItemCode CLUSTERED (ItemCode) 
) 

INSERT INTO @Ret ([TaskId], [PickingTaskDetailId], [ItemId], [STATUS], [ItemStatus], [Active], [ProductType], [ItemType], [KD], [Picked], 
[PickedTime],
[ItemCode], 
[PickItem], 
[Description], [OrderNumber], [EstimatedCompleteDate], [Serial], [Abn], [APN], [ApnId], 
[LocationToPick], 
--[Warehouse], 
[Section], [Isle], 
--[PoNumberToPick], 
[PrintApn], 
--[Quantity], [HasEnougeStock], [SectionN], [IsleNumeric], 
[SubstituteReasonId], 
[Hinge], [AvailableToPick], [ParentItemId], [ItemSubTypeID], [PickingDate], [FulfillmentType], [AssembledOnly], [BucketID], ItemListID,
ItemTypeCode, ISEID, ABNID)
		SELECT pt.PickingTaskId TaskId,
			ptd.PickingTaskDetailId,
			ptd.ItemId,
			pts.Name AS STATUS,
			d.STATUS AS ItemStatus,
			ptd.Active,
			it.TypeName AS ProductType,
			te.ItemType,
			te.KD,
			ptd.Picked,
			COALESCE(abn.PickedTime, ise.PickedTime) AS PickedTime,
			il.ShortItemCode AS ItemCode,
			COALESCE(abn.ItemCode, ise.ItemCode/*, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode, il.ShortItemCode*/) AS PickItem,
			te.Description,
			o.SOnumber AS OrderNumber,
			o.EstimatedCompleteDate,
			ise.SerielID AS Serial,
			abn.ABNNumber AS Abn,
			apn.APN,
			apn.ID AS ApnId,
			COALESCE(abn.PickedFromLocation, ise.PickedFromLocation/*, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location*/) AS LocationToPick,
			--COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(abn.SectionPicked, ise.SectionPicked/*, locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section*/) AS Section,
			COALESCE(abn.IslePicked, ise.IslePicked/*, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle*/) AS Isle,
			--COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			b.PrintApn,
			--CASE 
			--	WHEN b.AssembledOnly = 1
			--		THEN ISNULL(qtyAss.Quantity, 0)
			--	ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			--	END Quantity,
			--CAST(CASE 
			--		WHEN qty.Quantity IS NULL
			--			AND qtyAss.Quantity IS NULL
			--			AND qtyDoors.Quantity IS NULL
			--			AND qtyDoorsWag.Quantity IS NULL
			--			AND automaticSubstitute.Quantity IS NULL
			--			OR (
			--				ise.ID IS NULL
			--				AND abn.ID IS NULL
			--				AND ne.NotEnough = 1
			--				)
			--			THEN 0
			--		ELSE 1
			--		END AS BIT) HasEnougeStock,
			--COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			--COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			COALESCE(ise.SubstituteTypeID, abn.SubstituteTypeID, CASE 
					WHEN te.SubstituteItemCode IS NOT NULL
						THEN 41
					ELSE NULL
					END) AS SubstituteReasonId,
			te.Hinge,
			ptd.AvailableToPick,
			ptd.ParentItemId,
			il.ItemSubTypeID,
			te.PickingDate,
			te.FulfillmentType,
			b.AssembledOnly,
			b.BucketID,
			il.ID,
			il.ItemTypeCode, ise.ID, abn.ID
		FROM picking.PickingTask pt
		JOIN picking.Buckets b ON b.BucketID = pt.BucketId
		JOIN picking.PickingTaskStatus pts ON pts.PickingTaskStatusId = pt.PickingTaskStatusId
		JOIN picking.PickingTaskDetail ptd ON ptd.PickingTaskId = pt.PickingTaskId
			AND pt.Active = 1
			AND ptd.Active = 1
		JOIN dbo.TranEntry te ON te.ID = ptd.ItemId
			AND te.isActive = 1
		JOIN dbo.[Order] o ON o.ID = te.OrderID
			AND o.IsActive = 1
		JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
		JOIN dbo.tb_ItemList il ON il.ItemCode = te.ItemNumber
		JOIN dbo.ItemType it ON il.ItemTypeCode = it.TypeID
		LEFT OUTER JOIN dbo.tb_AccPickNumber apn ON apn.TranEntryID = te.ID
			AND apn.isActive = 1

		LEFT OUTER JOIN (
			SELECT ise.ID,
				ise.SerielID,
				ise.ItemCode,
				ise.PONumber,
				ise.PickedTime,
				ise.SubstituteTypeID,
				il2.Location AS PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				TranEntryID
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2 ON il2.ID = ise.PickedFromLocation
			WHERE ise.Picked = 1
			) ise ON ise.TranEntryID = te.ID


		LEFT OUTER JOIN  (
			SELECT abni.ID,
				abni.ABNID,
				abn.ABNNumber,
				abn.ItemCode,
				abn.PONumber,
				abni.PickedTime,
				abni.SubstituteTypeID,
				il2.Location PickedFromLocation,
				il2.Isle IslePicked,
				il2.Section SectionPicked,
				abni.TranEntryID
			FROM dbo.tb_AccBoxNumberItems abni
			JOIN dbo.tb_AccBoxNumber abn ON abn.ID = abni.ABNID
			JOIN dbo.InventoryLocation il2 ON il2.ID = abni.PickedFromLocation
			WHERE abni.Picked = 1
				AND abni.CreatedABNID IS NULL
			) abn ON abn.TranEntryID = te.ID


		WHERE pt.PickingTaskId = @TaskID

--Create CTE for inventory.powo

;WITH cte_inventory_powo (PoNumber, PoDate) AS (
	SELECT PoNumber, PoDate
	FROM inventory.PoWo )

INSERT INTO @RetVal
SELECT r.TaskId,
			r.PickingTaskDetailId,
			r.ItemId,
			r.STATUS,
			r.ItemStatus,
			r.Active,
			r.ProductType,
			r.ItemType,
			r.KD,
			r.Picked,
			r.PickedTime,
			r.ItemCode,
			COALESCE(r.ItemCode, ilsub.ShortItemCode, automaticSubstitute.ShortItemCode) AS PickItem,
			r.Description,
			r.OrderNumber,
			r.EstimatedCompleteDate,
			r.Serial,
			r.Abn,
			r.APN,
			r.ApnId,
			COALESCE(r.LocationToPick, locationsAss.Location, locationsDoors.Location, locationsDoorsWag.Location, automaticSubstitute.Location, locations.Location) AS LocationToPick,
			COALESCE(locationsAss.Warehouse, locationsDoors.Warehouse, locationsDoorsWag.Warehouse, automaticSubstitute.Warehouse, locations.Warehouse) AS Warehouse,
			COALESCE(r.Section,locationsAss.Section, locationsDoors.Section, locationsDoorsWag.Section, automaticSubstitute.Section, locations.Section) AS Section,
			COALESCE(r.Isle, locationsAss.Isle, locationsDoors.Isle, locationsDoorsWag.Isle, automaticSubstitute.Isle, locations.Isle) AS Isle,
			COALESCE(locationsAss.PoNumber, locationsDoors.PoNumber, locationsDoorsWag.PoNumber, automaticSubstitute.PoNumber, locations.PoNumber) AS PoNumberToPick,
			r.PrintApn,
			CASE 
				WHEN r.AssembledOnly = 1
					THEN ISNULL(qtyAss.Quantity, 0)
				ELSE COALESCE(QtyDoorsWag.Quantity, QtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
				END Quantity,
			CAST(CASE 
					WHEN qty.Quantity IS NULL
						AND qtyAss.Quantity IS NULL
						AND qtyDoors.Quantity IS NULL
						AND qtyDoorsWag.Quantity IS NULL
						AND automaticSubstitute.Quantity IS NULL
						OR (
							r.iseID IS NULL
							AND r.abnID IS NULL
							AND ne.NotEnough = 1
							)
						THEN 0
					ELSE 1
					END AS BIT) HasEnougeStock,
			COALESCE(locationsAss.SectionN, locationsDoors.SectionN, locationsDoorsWag.SectionN, automaticSubstitute.SectionN, locations.SectionN, 1000) AS SectionN,
			COALESCE(locationsAss.IsleNumeric, locationsDoors.IsleNumeric, locationsDoorsWag.IsleNumeric, automaticSubstitute.IsleNumeric, locations.IsleNumeric, 1000) AS IsleNumeric,
			r.SubstituteReasonId,
			r.Hinge,
			r.AvailableToPick,
			r.ParentItemId,
			r.ItemSubTypeID,
			r.PickingDate,
			r.FulfillmentType
FROM @Ret AS r
JOIN dbo.TranEntry te ON te.ID = r.ItemId
		AND te.isActive = 1
LEFT JOIN dbo.tb_ItemList ilsub
			ON te.SubstituteItemCode = ilsub.ItemCode
OUTER APPLY (
	SELECT TOP 1 il2sl.Location,
		ilusl.PoNumber,
		il2sl.Isle,
		il2sl.Section,
		w.Description AS Warehouse,
		il2sl.IsleNumeric,
		CASE 
			WHEN il2sl.Section IS NOT NULL
				AND ISNUMERIC(il2sl.Section) = 1
				THEN CAST(il2sl.Section AS INT)
			ELSE CAST(10000 AS INT)
			END SectionN
	FROM dbo.InventoryLocation il2sl
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
		AND il2sl.ExcludeFrmStock = 0
		AND il2sl.IsPickable = 1
	JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
	LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
		AND ilusl.Quantity > 0
		AND ilusl.STATUS = 'Active'
	LEFT JOIN cte_inventory_powo AS pw ON ilusl.PoNumber = pw.PoNumber
	WHERE COALESCE(ilsub.ShortItemCode, r.ItemCode) = ildic.ItemCode
	ORDER BY CASE 
			WHEN ilusl.Location IS NOT NULL
				THEN 0
			ELSE 1
			END,
		CASE 
			WHEN pw.PoNumber IS NOT NULL
				THEN pw.PoDate
			ELSE 10000
			END,
		il2sl.AddTime
	) locations
OUTER APPLY (
	SELECT SUM(iq.Quantity) Quantity
	FROM dbo.ItemLocationsUpdate iq
	JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
		AND ilq.ExcludeFrmStock = 0
		AND ilq.IsPickable = 1
	JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
	JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
	WHERE iq.Quantity > 0
		AND iq.STATUS = 'Active'
		AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
	GROUP BY iq.ItemCode
) qty
		OUTER APPLY (
			SELECT TOP 1 ise.ReceivedLocation Location,
				ise.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(te.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219
							)
						THEN 5
					ELSE 0
					END
			) locationsAss
		OUTER APPLY (
			SELECT COUNT(*) AS Quantity
			FROM dbo.tb_ItemSeriel ise
			JOIN dbo.InventoryLocation il2sl ON ise.ReceivedLocation = il2sl.Location
				AND il2sl.ExcludeFrmStock = 0
				AND ise.Assembled = 1
				AND ise.Received = 1
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				AND (
					il2sl.Location LIKE 'ASC-%'
					OR il2sl.Location LIKE 'AST-%'
					AND il2sl.Location NOT IN ('ASC-1-1')
					)
			WHERE ise.ItemCode = r.ItemCode
				AND r.AssembledOnly = 1
				AND (
					ISNULL(ise.Hinge, 'N') = ISNULL(r.Hinge, 'N')
					OR NOT EXISTS (
						SELECT 1
						FROM dbo.tb_itemClassDetail icd
						WHERE icd.ItemCode = r.ItemCode
							AND icd.ClassID = 115
						)
					)
				AND il2sl.Warehouse = CASE 
					WHEN r.BucketId IN (
							13,
							129
							)
						THEN 1
					WHEN r.BucketId = 14
						THEN 3
					WHEN r.BucketId = 15
						THEN 2
					WHEN r.BucketId IN (
							207,
							219
							)
						THEN 5
					ELSE 0
					END
			) qtyAss
		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = 'Active'
			JOIN cte_inventory_powo AS pw ON pw.PoNumber = ilusl.PoNumber
			WHERE COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND il2sl.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
				AND il2sl.Warehouse = 5
				AND il2sl.ExcludeFrmStock = 0
				AND locationsAss.Location IS NULL
			ORDER BY CASE 
					WHEN il2sl.Location LIKE 'WAG-DR-%'
						THEN 1
					ELSE 0
					END,
				CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				pw.PoDate
			) locationsDoors
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = 5
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND qtyAss.Quantity IS NULL
				AND iq.Quantity > 0
				AND iq.STATUS = 'Active'
				AND iq.ItemCode = COALESCE(ilsub.ShortItemCode, r.ItemCode)
				AND r.BucketID IN (
					130,
					135,
					237,
					238
					)
				AND ilq.Location NOT IN (
					'1-1-50',
					'1-2-50',
					'1-3-50',
					'1-4-50',
					'DMG-99-1',
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoors

		OUTER APPLY (
			SELECT TOP 1 il2sl.Location,
				ilusl.PoNumber,
				il2sl.Isle,
				il2sl.Section,
				w.Description AS Warehouse,
				il2sl.IsleNumeric,
				CASE 
					WHEN il2sl.Section IS NOT NULL
						AND ISNUMERIC(il2sl.Section) = 1
						THEN CAST(il2sl.Section AS INT)
					ELSE CAST(10000 AS INT)
					END SectionN
			FROM dbo.InventoryLocation il2sl
			JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
			JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
				AND ilusl.Quantity > 0
				AND ilusl.STATUS = 'Active'
			JOIN cte_inventory_powo AS pw ON pw.PoNumber = ilusl.PoNumber
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND locationsAss.Location IS NULL
				AND COALESCE(ilsub.ShortItemCode, r.ItemCode) = ilusl.ItemCode
				AND il2sl.IsPickable = 1
				AND r.BucketID IN (
					237,
					238
					)
				AND il2sl.Warehouse = 5
				AND il2sl.ExcludeFrmStock = 0
				AND il2sl.Location LIKE 'WAG-DR-%'
				AND il2sl.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			ORDER BY CASE 
					WHEN il2sl.LocationType IN (
							29,
							32,
							44,
							46
							)
						THEN 0
					ELSE 1
					END,
				pw.PoDate
			) locationsDoorsWag
		OUTER APPLY (
			SELECT SUM(iq.Quantity) Quantity
			FROM dbo.ItemLocationsUpdate iq
			JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
				AND ilq.ExcludeFrmStock = 0
				AND ilq.Warehouse = 5
			JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
			WHERE 
				COALESCE(ilsub.ItemTypeCode, r.ItemTypeCode) = 12
				AND qtyAss.Quantity IS NULL
				AND iq.Quantity > 0
				AND iq.STATUS = 'Active'
				AND iq.ItemCode = r.ItemCode
				AND r.BucketId IN (
					237,
					238
					)
				AND ilq.Location LIKE 'WAG-DR-%'
				AND ilq.Location NOT IN (
					'WAG-DR-49',
					'WAG-DR-50',
					'WAG-DR-35',
					'WAG-DR-39',
					'WAG-DR-29',
					'WAG-DR-42',
					'WAG-DR-44',
					'WAG-DR-36',
					'WAG-DR-38',
					'WAG-DR-45',
					'WAG-DR-40'
					)
			GROUP BY iq.ItemCode
			) qtyDoorsWag
		OUTER APPLY (
			SELECT TOP (1) til.ShortItemCode,
				qty.Quantity,
				locations.Location,
				locations.Warehouse,
				locations.Section,
				locations.Isle,
				locations.PoNumber,
				locations.SectionN,
				locations.IsleNumeric
			FROM picking.AutomaticItemSubstitutionDetail AS aisd
			JOIN picking.AutomaticItemSubstitutionMaster AS aism ON aism.AutomaticItemSubstitutionMasterId = aisd.AutomaticItemSubstitutionMasterId
			JOIN picking.AutomaticItemSubstitutionDetail AS aisd2 ON aisd2.AutomaticItemSubstitutionMasterId = aism.AutomaticItemSubstitutionMasterId
			JOIN dbo.tb_ItemList AS til ON til.ID = aisd2.ItemlistId
			OUTER APPLY (
				SELECT TOP 1 il2sl.Location,
					ilusl.PoNumber,
					il2sl.Isle,
					il2sl.Section,
					w.Description AS Warehouse,
					il2sl.IsleNumeric,
					CASE 
						WHEN il2sl.Section IS NOT NULL
							AND ISNUMERIC(il2sl.Section) = 1
							THEN CAST(il2sl.Section AS INT)
						ELSE CAST(10000 AS INT)
						END SectionN
				FROM dbo.InventoryLocation il2sl
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = il2sl.ID
					AND il2sl.ExcludeFrmStock = 0
					AND il2sl.IsPickable = 1
				JOIN dbo.tb_Warehouse w ON w.ID = il2sl.Warehouse
				LEFT OUTER JOIN dbo.ItemLocationsUpdate ilusl ON il2sl.Location = ilusl.Location
					AND ilusl.Quantity > 0
					AND ilusl.STATUS = 'Active'
				LEFT JOIN cte_inventory_powo AS pw ON pw.PoNumber = ilusl.PoNumber
				WHERE til.ShortItemCode = ildic.ItemCode
				ORDER BY CASE 
						WHEN ilusl.Location IS NOT NULL
							THEN 0
						ELSE 1
						END,
					CASE 
						WHEN pw.PoNumber IS NOT NULL
							THEN 0
						ELSE 10000
						END,
					pw.PoDate,
					il2sl.AddTime
				) locations
			OUTER APPLY (
				SELECT SUM(iq.Quantity) Quantity
				FROM dbo.ItemLocationsUpdate iq
				JOIN dbo.InventoryLocation ilq ON iq.Location = ilq.Location
					AND ilq.ExcludeFrmStock = 0
					AND ilq.IsPickable = 1
				JOIN dbo.InventoryLocationDefaultItemCode ildic ON ildic.LocationID = ilq.ID
				JOIN dbo.tb_Warehouse w ON w.ID = ilq.Warehouse
				WHERE iq.Quantity > 0
					AND iq.STATUS = 'Active'
					AND iq.ItemCode = til.ShortItemCode
				GROUP BY iq.ItemCode
				) qty
			WHERE r.ItemListID = aisd.ItemlistId
				AND qty.Quantity > 0
				AND aisd.Active = 1
				AND aisd2.Active = 1
				AND aism.Active = 1
				AND qtyAss.Quantity IS NULL

			ORDER BY CASE 
					WHEN til.ID <> aism.MainItemListId
						THEN 0
					ELSE 1
					END
			) automaticSubstitute
		OUTER APPLY (
			SELECT CAST(1 AS BIT) NotEnough
			FROM picking.PickingTask pt2
			JOIN picking.PickingTaskDetail ptd2 ON ptd2.PickingTaskId = pt2.PickingTaskId
			JOIN dbo.TranEntry te2 ON te2.ID = ptd2.ItemId
				AND te2.isActive = 1
			WHERE ptd2.PickingTaskId = r.TaskId
				AND te2.ItemNumber = te.ItemNumber
				AND pt2.Active = 1
				AND ptd2.Active = 1
				AND ptd2.Picked = 0
			GROUP BY te2.ItemNumber,
				pt2.PickingTaskId
			HAVING COUNT(*) > COALESCE(qtyAss.Quantity, qtyDoorsWag.Quantity, qtyDoors.Quantity, automaticSubstitute.Quantity, qty.Quantity, 0)
			) ne
			ORDER BY PickingTaskDetailId
			OPTION(RECOMPILE)
RETURN
END

GO
/****** Object:  Table [dbo].[AccessoriesBoxDetail]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[AccessoriesBoxDetail](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HeaderId] [int] NOT NULL,
	[TranEntryId] [int] NULL,
	[AddDate] [datetime] NOT NULL,
	[IsPrinted] [bit] NULL,
	[IsActive] [bit] NOT NULL,
	[HostName] [varchar](50) NULL,
	[UserId] [int] NULL,
	[DeacUID] [int] NULL,
	[DeactiveDate] [datetime] NULL,
	[DeacHostName] [varchar](50) NULL,
	[APN] [numeric](18, 0) NULL,
	[SNid] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[TranEntry]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TranEntry](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ItemNumber] [varchar](150) NOT NULL,
	[DepartmentstatusID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[OrderID] [int] NOT NULL,
	[Addtime] [datetime] NOT NULL,
	[Location] [nvarchar](255) NOT NULL,
	[Modification] [nvarchar](255) NULL,
	[Description] [nvarchar](2000) NULL,
	[itemcomplete] [nvarchar](50) NOT NULL,
	[HingeFinish] [nvarchar](150) NULL,
	[POnumber] [nvarchar](50) NULL,
	[OrderIdentity] [varchar](50) NOT NULL,
	[isActive] [bit] NOT NULL,
	[LastUpdate] [datetime] NOT NULL,
	[PrintNumber] [int] NULL,
	[BackOrdered] [bit] NOT NULL,
	[LabelPrinted] [bit] NOT NULL,
	[labelPrinted2] [bit] NOT NULL,
	[KD] [bit] NOT NULL,
	[BoxMade] [bit] NOT NULL,
	[UpdatedViaItemScan] [bit] NOT NULL,
	[Reimported] [bit] NOT NULL,
	[AssembleLabelPrinted] [bit] NOT NULL,
	[ETAfinishing] [nvarchar](50) NULL,
	[ParentID] [int] NOT NULL,
	[FWPONumber] [varchar](50) NULL,
	[SubStatusID] [int] NULL,
	[Minutes] [int] NULL,
	[ItemMemo] [varchar](255) NULL,
	[PalletID] [int] NULL,
	[SubUserID] [int] NULL,
	[qbQuantity] [int] NULL,
	[qbTxnLineID] [nvarchar](50) NULL,
	[ItemType] [int] NOT NULL,
	[EZProdID] [varchar](25) NULL,
	[TableId] [int] NULL,
	[Hinge] [varchar](50) NULL,
	[Finish] [varchar](50) NULL,
	[onHold] [bit] NULL,
	[isDeleted] [bit] NULL,
	[EZProdSubID] [int] NULL,
	[ActualUpdate] [datetime] NULL,
	[TimeInStatus]  AS ((0)),
	[AutoEZProdID]  AS (case when [EZProdID] IS NOT NULL AND [EZProdSubID] IS NOT NULL AND [isDeleted]=(0) then ([EZProdID]+'.')+CONVERT([varchar](25),[EZProdSubID],(0)) else 'G'+CONVERT([varchar](25),[ID],(0)) end),
	[QBListId] [varchar](255) NULL,
	[PickDropLoc] [varchar](50) NULL,
	[Style] [varchar](50) NULL,
	[StandAlone] [bit] NULL,
	[Room] [varchar](50) NULL,
	[EZParentProdID] [varchar](25) NULL,
	[HasCustomizing] [bit] NULL,
	[HasFinishing] [bit] NULL,
	[ProductDescriptionAdditions] [varchar](8000) NULL,
	[IsBackOrdered] [bit] NULL,
	[DeactivateDate] [datetime] NULL,
	[KDStyle] [bit] NULL,
	[PickingDate] [date] NULL,
	[BoxOnly] [bit] NULL,
	[SubstituteItemCode] [varchar](150) NULL,
	[FulfillmentOnly] [bit] NULL,
	[PartsOnly] [bit] NULL,
	[AcumaticaID] [int] NULL,
	[WarehouseNote] [varchar](8000) NULL,
	[BoOrigOrderItemId] [int] NULL,
	[FulfillmentType] [varchar](50) NULL,
	[DontDeductStock] [bit] NULL,
 CONSTRAINT [PK_TransactionEntry] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[tb_PalletOrder]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[tb_PalletOrder](
	[ID] [int] IDENTITY(125001,1) NOT NULL,
	[RangeID] [int] NOT NULL,
	[OrderID] [int] NOT NULL,
	[OrderNum] [varchar](50) NOT NULL,
	[AddTime] [datetime] NOT NULL,
	[MisMatchedByPassedBy] [int] NULL,
 CONSTRAINT [PK_tb_PalletOrder] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[tb_Pallet]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[tb_Pallet](
	[ID] [int] IDENTITY(205001,1) NOT NULL,
	[PalletNum] [varchar](50) NOT NULL,
	[RangeID] [int] NOT NULL,
	[AddTime] [datetime] NOT NULL,
	[LabelPrinted] [bit] NULL,
	[PackingSlipPrinted] [bit] NULL,
	[PSUID] [int] NULL,
	[PSDatePrinted] [datetime] NULL,
	[PackingSlipMasterPrinted] [bit] NULL,
	[PSMUID] [int] NULL,
	[PSMDatePrinted] [datetime] NULL,
	[PSHostname] [varchar](50) NULL,
	[PSMHostname] [varchar](50) NULL,
	[HostName] [varchar](100) NULL,
	[UserId] [int] NULL,
 CONSTRAINT [PK_tb_Pallet] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[AccessoriesBoxHeader]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[AccessoriesBoxHeader](
	[Id] [int] IDENTITY(10000,1) NOT NULL,
	[OrderId] [int] NOT NULL,
	[AddDate] [datetime] NOT NULL,
	[DatePrinted] [datetime] NULL,
	[IsActive] [bit] NOT NULL,
	[BoxType] [int] NULL,
	[HostName] [varchar](50) NULL,
	[UserId] [int] NULL,
	[DeacUserId] [int] NULL,
	[DeacDate] [datetime] NULL,
	[DeacHost] [varchar](50) NULL,
	[BoxNumber] [varchar](20) NULL,
	[PreActivated] [bit] NOT NULL,
 CONSTRAINT [PK__Accessor__3214EC077B3CED68] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Departmentstatus]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Departmentstatus](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Departmentid] [int] NOT NULL,
	[Status] [nvarchar](150) NOT NULL,
	[Scantimes] [int] NOT NULL,
	[viewColor] [nvarchar](50) NULL,
	[ShowInChangeStatus] [bit] NOT NULL,
	[OverDue] [int] NULL,
	[StopsDuration] [bit] NULL,
	[ShowDisplayUpdateLocationOption] [bit] NOT NULL,
	[ShowDisplayBigNumberOption] [bit] NOT NULL,
	[StatusGUID] [uniqueidentifier] ROWGUIDCOL  NULL,
	[DisallowLabels] [bit] NOT NULL,
	[SortNumber] [decimal](9, 4) NULL,
	[ColorHex] [varchar](25) NULL,
	[ts] [timestamp] NOT NULL,
	[MsgID] [int] NULL,
	[SecondID] [int] NOT NULL,
	[IgnoreItemScanFlag] [bit] NULL,
	[IncludeInDeptCycle] [bit] NOT NULL,
	[MsgBoxID] [int] NULL,
	[BigNumberColorHex] [varchar](25) NULL,
	[HistFlag] [bit] NULL,
	[StatusChangeOverdueInt] [varchar](50) NULL,
	[StatusChangeOverdueTime] [int] NULL,
	[Step] [int] NULL,
	[isShipped] [bit] NULL,
	[isIgnoreable] [bit] NULL,
	[MGPS_RTSF_GridColor] [varchar](50) NULL,
	[ActualStatus] [bit] NOT NULL,
	[FunctionStatus] [bit] NULL,
	[DiscontinuedStatues] [bit] NULL,
	[StatusStageId] [int] NULL,
	[StatusTypeId] [int] NOT NULL,
	[SubUserDepartmentId] [int] NULL,
 CONSTRAINT [PK_Departmentstatus] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[tb_ItemList]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[tb_ItemList](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ItemCode] [varchar](150) NOT NULL,
	[Weight] [real] NULL,
	[Desc] [nvarchar](255) NOT NULL,
	[CubicFtAssemble] [float] NOT NULL,
	[CubicFtKD] [float] NOT NULL,
	[CubicMeterKD] [decimal](10, 3) NOT NULL,
	[ItemTypeCode] [int] NOT NULL,
	[SubTypeCode] [varchar](10) NULL,
	[NoBarCode] [bit] NULL,
	[Label2x1Qty] [int] NOT NULL,
	[Label4x6Qty] [int] NOT NULL,
	[Label4x12Qty] [int] NOT NULL,
	[ServiceType] [varchar](50) NULL,
	[UseQbQty] [bit] NULL,
	[ShortItemCode] [nvarchar](150) NOT NULL,
	[StockThreshhold] [int] NULL,
	[Minutes] [int] NULL,
	[IsCabinet] [bit] NULL,
	[IsItemActive] [bit] NOT NULL,
	[StyleCode] [varchar](10) NULL,
	[QBListID] [varchar](255) NULL,
	[HingeCount] [int] NULL,
	[HingeType] [nvarchar](25) NULL,
	[Minutes_1] [decimal](10, 2) NULL,
	[Minutes_2] [decimal](10, 2) NULL,
	[Discontinued] [bit] NOT NULL,
	[PalletRackLineName] [varchar](255) NOT NULL,
	[Series] [varchar](255) NULL,
	[VendorItemCode] [varchar](255) NULL,
	[WHThreshhold] [int] NULL,
	[PurchasingCategory] [int] NOT NULL,
	[ItemSubTypeID] [int] NULL,
	[UnpackingMinutes] [decimal](10, 2) NULL,
	[ProductID] [int] NULL,
	[DoorStyleID] [int] NULL,
	[AcumaticaID] [int] NULL,
	[AcumaticaName] [varchar](450) NULL,
	[AcumaticaDesc] [varchar](1000) NULL,
	[ComponentPartTypeId] [int] NULL,
	[SkinMinutes] [decimal](10, 2) NULL,
 CONSTRAINT [PK__ItemList__3214EC270DCF0841] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY],
 CONSTRAINT [ItemList_uq] UNIQUE NONCLUSTERED 
(
	[ItemCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  UserDefinedFunction [dbo].[GetCCOPLItemsSBN]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[GetCCOPLItemsSBN]
(	
	@pallet VARCHAR(20) 
)
RETURNS TABLE 
AS
RETURN 
(
	SELECT CAST(te.ID AS VARCHAR(12)) AS ItemSBN, til.ShortItemCode AS ItemCode, d.Status ,te.OrderIdentity AS OrderNumber FROM dbo.TranEntry AS te
						JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
						JOIN dbo.tb_ItemList AS til ON til.ItemCode = te.ItemNumber
						JOIN dbo.tb_Pallet AS tp ON tp.ID = te.PalletID
						JOIN dbo.tb_PalletOrder AS tpo ON tp.RangeID = tpo.RangeID AND tpo.OrderID = te.OrderID
						WHERE tp.PalletNum = @pallet
						AND NOT EXISTS (SELECT 1 FROM dbo.AccessoriesBoxDetail AS abd WHERE abd.TranEntryId = te.ID AND abd.IsActive = 1)
						UNION ALL 
						SELECT  abh.BoxNumber,NULL, Status.status, te.OrderIdentity 
						FROM dbo.AccessoriesBoxDetail AS abd
						 JOIN dbo.AccessoriesBoxHeader AS abh ON abh.Id = abd.HeaderId AND abd.IsActive =1
						 JOIN dbo.TranEntry AS te ON abd.TranEntryId = te.ID
						 JOIN dbo.tb_Pallet AS tp ON tp.ID = te.PalletID
						JOIN dbo.tb_PalletOrder AS tpo ON tp.RangeID = tpo.RangeID AND tpo.OrderID = te.OrderID
						 OUTER APPLY(
							 SELECT abd2.HeaderId, d.Status,te.DepartmentstatusID FROM dbo.TranEntry AS te
							 JOIN dbo.AccessoriesBoxDetail AS abd2 ON abd2.TranEntryId = te.ID
							 JOIN dbo.Departmentstatus AS d ON d.ID = te.DepartmentstatusID
							 WHERE abd2.HeaderId = abd.HeaderId AND abd2.IsActive =1
							 GROUP BY abd2.HeaderId,d.Status,te.DepartmentstatusID
							 HAVING COUNT(DISTINCT te.DepartmentstatusID)=1
							 )Status
						 WHERE tp.PalletNum = @pallet
						 GROUP BY abh.BoxNumber, Status.Status, te.OrderIdentity
)


GO
/****** Object:  Table [dbo].[tb_itemClassDetail]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[tb_itemClassDetail](
	[ClassID] [int] NOT NULL,
	[ItemCode] [nvarchar](150) NOT NULL,
	[AddDate] [datetime] NOT NULL,
	[DisplayOrder] [smallint] NULL,
	[Hostname] [varchar](150) NULL,
	[IsActive] [bit] NOT NULL,
 CONSTRAINT [PK_tb_itemClassDetail] PRIMARY KEY CLUSTERED 
(
	[ClassID] ASC,
	[ItemCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Comments]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Comments](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Comment] [nvarchar](max) NULL,
	[type] [int] NULL,
	[UserID] [int] NULL,
	[Date] [datetime] NOT NULL,
	[OrderID] [int] NULL,
	[itemID] [int] NULL,
	[HostName] [varchar](50) NOT NULL,
	[m mn] [char](10) NULL,
	[NoteID] [varchar](50) NULL,
 CONSTRAINT [PK_Comments] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [inventory].[Po]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [inventory].[Po](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[PoNumber] [varchar](50) NOT NULL,
	[VendorName] [varchar](255) NULL,
	[VendorID] [int] NULL,
	[AcumaticaID] [nvarchar](450) NULL,
	[Status] [varchar](1000) NULL,
	[PromisedOn] [date] NULL,
	[AddDate] [datetime] NOT NULL,
	[Closed] [bit] NOT NULL,
	[Deleted] [bit] NOT NULL,
	[Hardware] [bit] NULL,
	[HingeOnly] [bit] NULL,
	[BlumSlide] [varchar](10) NULL,
	[POCreated] [date] NULL,
	[CarbIIComplient] [bit] NULL,
	[Type] [varchar](1000) NULL,
 CONSTRAINT [PK_Po] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[tb_ItemSeriel]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[tb_ItemSeriel](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[SerielID] [varchar](50) NOT NULL,
	[ItemCode] [varchar](50) NULL,
	[PONumber] [varchar](50) NULL,
	[PalletID] [int] NOT NULL,
	[LocationID] [varchar](255) NULL,
	[UserID] [int] NOT NULL,
	[Hostname] [varchar](50) NOT NULL,
	[TranEntryID] [int] NULL,
	[AddTime] [datetime] NOT NULL,
	[PickedFromLocation] [int] NULL,
	[PickerUserID] [int] NULL,
	[OrderID] [int] NULL,
	[Picked] [bit] NOT NULL,
	[PickedTime] [datetime] NULL,
	[PickedHostname] [varchar](50) NULL,
	[Received] [bit] NOT NULL,
	[ReceivedLocation] [varchar](50) NULL,
	[ReceivedTime] [datetime] NULL,
	[ReceivedHostName] [varchar](255) NULL,
	[ReceivedUserID] [int] NULL,
	[RMATranEntryID] [int] NULL,
	[SubstitueItemCode] [varchar](50) NULL,
	[SubstituteTypeID] [int] NULL,
	[OrigSerialID] [varchar](50) NULL,
	[DeptStatusID] [int] NULL,
	[Assembled] [bit] NULL,
	[WasPicked] [bit] NOT NULL,
	[WasModified] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[Hinge] [varchar](5) NULL,
	[CreatedABNID] [int] NULL,
	[ContainerID] [int] NULL,
	[ReceivingSourceTypeID] [int] NULL,
	[DeleteFlag] [bit] NOT NULL,
	[DeletedUser] [int] NULL,
	[DeletedTime] [datetime] NULL,
	[ProductionItemDetailId] [int] NULL,
	[ProductionItemId] [int] NULL,
	[WorkOrderFulfillmentItemsID] [int] NULL,
	[ExcludeFromPo] [bit] NOT NULL,
 CONSTRAINT [PK_tb_ItemSeriel] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Order]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Order](
	[OrderID] [int] NULL,
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[CustomerName] [nvarchar](250) NOT NULL,
	[CustomerAddress] [nvarchar](200) NULL,
	[CustomerShippingAddress] [nvarchar](200) NULL,
	[Addtime] [datetime] NOT NULL,
	[Departmentstatusid] [int] NOT NULL,
	[Location] [nvarchar](100) NULL,
	[Modification] [nvarchar](255) NOT NULL,
	[Memo] [nvarchar](500) NULL,
	[OrderOpen] [bit] NOT NULL,
	[Finishing] [nvarchar](50) NOT NULL,
	[Customizing] [nvarchar](50) NOT NULL,
	[Shippingmethor] [nvarchar](50) NULL,
	[QBcreatedTime] [datetime] NOT NULL,
	[EST] [nvarchar](50) NULL,
	[PONumber] [varchar](50) NULL,
	[IsActive] [bit] NOT NULL,
	[SOnumber] [nvarchar](50) NULL,
	[LastUpdate] [datetime] NULL,
	[BillAddr1] [varchar](50) NOT NULL,
	[BillAddr2] [varchar](50) NOT NULL,
	[BillCity] [varchar](50) NOT NULL,
	[BillState] [varchar](50) NOT NULL,
	[BillPostalCode] [varchar](50) NOT NULL,
	[BillCountry] [varchar](50) NOT NULL,
	[BillNote] [varchar](50) NOT NULL,
	[ShipAddr1] [varchar](50) NOT NULL,
	[ShipAddr2] [varchar](50) NULL,
	[ShipCity] [varchar](50) NOT NULL,
	[ShipState] [varchar](50) NOT NULL,
	[ShipPostalCode] [varchar](50) NULL,
	[ShipCountry] [varchar](50) NULL,
	[ShipNote] [varchar](50) NULL,
	[LabelPrinted] [bit] NOT NULL,
	[AccPrinted] [bit] NOT NULL,
	[KD] [bit] NOT NULL,
	[RushOrder] [bit] NOT NULL,
	[EstimatedCompleteDate] [datetime] NOT NULL,
	[Updated] [bit] NOT NULL,
	[UpdatedTime] [datetime] NULL,
	[TrackID] [int] NOT NULL,
	[CustomerQbListID] [nvarchar](50) NULL,
	[ShipVia] [nvarchar](50) NOT NULL,
	[Other] [nvarchar](50) NOT NULL,
	[Terms] [nvarchar](50) NOT NULL,
	[isBackOrder] [bit] NOT NULL,
	[qbShipDate] [datetime] NULL,
	[qbTxnID] [nvarchar](50) NULL,
	[qbEditSequence] [nvarchar](50) NULL,
	[qbTimeCreated] [datetime] NULL,
	[qbDueDate] [datetime] NULL,
	[qbSalesRepFullName] [nvarchar](50) NULL,
	[qbTimeModified] [datetime] NULL,
	[qbTemplateFullName] [nvarchar](50) NULL,
	[qbClassFullName] [nvarchar](50) NULL,
	[qbFOB] [nvarchar](50) NULL,
	[qbCustomerMsgFullName] [nvarchar](50) NULL,
	[qbTxnNumber] [int] NULL,
	[qbSubTotal] [money] NULL,
	[qbTotalAmount] [money] NULL,
	[qbItemSalesTaxFullName] [nvarchar](50) NULL,
	[qbSalesTaxTotal] [money] NULL,
	[qbCustomerSalesTaxCodeFullName] [nvarchar](50) NULL,
	[UserID] [int] NULL,
	[UseFlag] [bit] NOT NULL,
	[ConfNumber] [varchar](50) NULL,
	[OrdSubStatusID] [int] NULL,
	[OrigETA] [date] NULL,
	[OrigAddTime] [datetime] NULL,
	[OrigOrderID] [int] NULL,
	[ActiveInt]  AS (case when [IsActive]=(1) then (0) else [ID] end),
	[SubUserID] [int] NULL,
	[TransactionMemo] [nvarchar](500) NULL,
	[OnHold] [bit] NOT NULL,
	[EstShipTime] [datetime] NULL,
	[OrderTracks] [varchar](250) NULL,
	[isShipped] [bit] NULL,
	[PLocation] [varchar](max) NULL,
	[PriorityLevel] [int] NULL,
	[StyleCode] [varchar](25) NULL,
	[ActualUpdate] [datetime] NULL,
	[Incomplete2]  AS ([dbo].[GetCountDown2]([ID])),
	[Incomplete]  AS ([dbo].[GetCountDown1]([ID])),
	[InActiveReason] [varchar](50) NULL,
	[LinkedQuoteNumber] [varchar](50) NULL,
	[StockOrder] [bit] NULL,
	[TruckRouteID] [int] NULL,
	[EsdConfirmed] [bit] NULL,
	[OrderTag] [varchar](50) NULL,
	[OrderOnHold] [bit] NULL,
	[LargeProject] [bit] NULL,
	[OrderType] [varchar](5) NULL,
	[ArRelease] [int] NULL,
 CONSTRAINT [PK_Order] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[CabinetTrack]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CabinetTrack](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[TranEntryID] [int] NOT NULL,
	[TrackID] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[Active] [bit] NOT NULL,
	[ExcludeItemCF] [bit] NULL,
	[ReservedForSpecialItems] [bit] NULL,
PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Tracks]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Tracks](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](255) NOT NULL,
	[Section] [char](1) NOT NULL,
	[MaxCabinets] [int] NOT NULL,
	[MinQtyReq] [int] NOT NULL,
	[MaxQtyReq] [int] NOT NULL,
	[Active] [bit] NOT NULL,
	[Isle] [int] NULL,
 CONSTRAINT [PK__Tracks__3214EC2748EFCE0F] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  View [dbo].[v_CabinetInTracks]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO




CREATE VIEW [dbo].[v_CabinetInTracks]
AS
SELECT dbo.Tracks.ID, Name, Section, MaxCabinets, MinQtyReq, MaxQtyReq,
       TranEntryID, TrackID, DateCreated
FROM    dbo.Tracks
        INNER JOIN dbo.CabinetTrack
        ON dbo.Tracks.ID = dbo.CabinetTrack.TrackID
WHERE  dbo.CabinetTrack.Active = 1


GO
/****** Object:  View [dbo].[v_TranEntryItems]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO









CREATE VIEW [dbo].[v_TranEntryItems]
AS
SELECT        od.CustomerName, od.CustomerAddress, od.CustomerShippingAddress, od.Addtime AS OrdAddtime, od.Departmentstatusid AS OrdDepartmentstatusid, 
                         od.Location AS OrdLocation, od.Modification AS OrdModification, od.qbFOB AS Acknowledgement, od.Memo, od.OrderOpen, od.Finishing, od.Customizing, 
                         od.Shippingmethor, od.QBcreatedTime, od.EST, od.PONumber AS OrdPONumber, od.IsActive AS OrdIsActive, od.SOnumber, od.LastUpdate AS OrdLastUpdate, 
                         od.BillAddr1, od.BillAddr2, od.BillCity, od.BillState, od.BillPostalCode, od.BillCountry, od.BillNote, od.ShipAddr1, od.ShipAddr2, od.ShipCity, od.ShipState, 
                         od.ShipPostalCode, od.ShipCountry, od.ShipNote, od.LabelPrinted AS OrdLabelPrinted, od.AccPrinted, od.KD AS OrdKD, od.RushOrder, od.EstimatedCompleteDate, 
                         od.Updated, od.UpdatedTime, od.TrackID AS OrdTrackID, od.Incomplete, od.Incomplete2, od.CustomerQbListID, od.ShipVia, od.Other, od.Terms, od.isBackOrder, 
                         od.OrderTracks, CASE WHEN ItemTypeCode = 4 THEN 1 ELSE 0 END AS isService, CASE WHEN ItemTypeCode = 3 THEN 1 ELSE 0 END AS isAccessory, 
                         CASE WHEN ItemTypeCode = 3 AND tb_ItemList.SubTypeCode = 'P' THEN 1 ELSE 0 END AS isPly, dbo.tb_ItemList.NoBarCode AS isNoBarCodeItem, 
                         ISNULL(dbo.tb_ItemList.Label4x6Qty, 1) AS Label4x6Qty, ISNULL(dbo.tb_ItemList.Label2x1Qty, 1) AS Label2x1Qty, ISNULL(dbo.tb_ItemList.Label4x12Qty, 1) 
                         AS Label4x12Qty, ct.Name AS CabinetTrackName, dbo.tb_ItemList.[Desc], dbo.tb_ItemList.SubTypeCode AS ServiceItemType, dbo.tb_ItemList.UseQbQty, te.ID, 
                         te.ItemNumber, te.DepartmentstatusID, te.UserID, te.OrderID, te.Addtime, te.Location, te.Modification, te.Description, te.itemcomplete, te.HingeFinish, od.PONumber, 
                         te.OrderIdentity, te.isActive, te.LastUpdate, te.PrintNumber, te.BackOrdered, te.LabelPrinted, te.labelPrinted2, te.KD, te.BoxMade, te.TimeInStatus, 
                         te.UpdatedViaItemScan, te.Reimported, te.AssembleLabelPrinted, te.ETAfinishing, te.ParentID, te.FWPONumber, te.SubStatusID, te.Minutes, te.ItemMemo, te.PalletID, 
                         te.SubUserID, te.qbQuantity, te.qbTxnLineID, te.ItemType, CONVERT(VARCHAR(10), te.ItemType) + dbo.tb_ItemList.SubTypeCode AS FullItemType, 
                         CASE WHEN te.PickDropLoc IS NULL THEN 'A' ELSE te.PickDropLoc END AS PickDropLocation, gpsPO.CarbIIComplient, dbo.tb_ItemList.IsCabinet, 
                         dbo.tb_ItemList.StyleCode AS ilStyleCode, te.StandAlone AS isStandAlone, dbo.tb_ItemList.HingeCount, dbo.tb_ItemList.HingeType, te.Hinge, te.Finish, 
                         its.SerielID AS SerielNumber, te.Room AS RoomTag, dbo.tb_ItemList.ShortItemCode, dbo.tb_ItemList.Weight, dbo.fn_getHingetype(te.ID) AS HingeONlbl, 
                         xBlum.ClassID AS excludeFromPickSheetClass, te.HasCustomizing, te.HasFinishing, 
						 CASE WHEN tb_ItemList.Series IN ('Allure','Classic') AND te.ProductDescriptionAdditions NOT LIKE '%BLUM SLIDE%' THEN dbo.GetBlumSlideOnLabelDesc(dbo.tb_ItemList.ID,te.FWPONumber) ELSE '' END + 
						 REPLACE(REPLACE(te.ProductDescriptionAdditions, CHAR(13), ''), CHAR(10), '') AS ProductDescriptionAdditions,  
						CASE WHEN tb_ItemList.Series IN ('Allure','Classic') AND dbo.GetBlumSlideOnLabelDesc(dbo.tb_ItemList.ID,te.FWPONumber) <> '' THEN gpsPO.Blumslide ELSE '' END AS SlideInitials,
						 dbo.fn_ShippingWarehouse(od.OrderID) AS ordShippingWarehouse, te.EZParentProdID, od.OrderTag,gpsPO.BlumSlide,tb_ItemList.Series, tb_ItemList.ID AS ItemListID, CASE WHEN EXISTS(SELECT 1 FROM comments WHERE comments.itemid = te.id AND type = 6) THEN 1 ELSE 0 END AS Type6Comment,
						 RIGHT(CONVERT(VARCHAR(10),DATEADD(m,2,POCreated),103),7) AS poMFGdate, od.OrderType 
FROM            dbo.TranEntry AS te WITH (NOLOCK) INNER JOIN
                         dbo.[Order] AS od WITH (NOLOCK) ON od.ID = te.OrderID AND te.Addtime >= DATEADD(YEAR, - 1, GETDATE()) LEFT OUTER JOIN
                         dbo.tb_ItemList ON dbo.tb_ItemList.ItemCode = te.ItemNumber LEFT OUTER JOIN
                         dbo.v_CabinetInTracks AS ct ON te.ID = ct.TranEntryID LEFT OUTER JOIN
					     inventory.Po AS gpsPO ON te.FWPONumber = gpsPO.PoNumber LEFT OUTER JOIN
                         dbo.tb_ItemSeriel AS its ON te.ID = its.TranEntryID LEFT OUTER JOIN
                             (SELECT        ItemCode, ClassID
                               FROM            dbo.tb_itemClassDetail
                               WHERE        (ClassID = 23)) AS xBlum ON dbo.tb_ItemList.ShortItemCode = xBlum.ItemCode

GO
/****** Object:  Table [dbo].[tb_ItemDefaultValues]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[tb_ItemDefaultValues](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ItemType] [int] NULL,
	[DefaultStatus] [int] NOT NULL,
	[ItemComplete] [bit] NULL,
	[ItemCodeDefaultValue] [varchar](150) NULL,
	[StandAlone] [bit] NULL,
 CONSTRAINT [PK_tb_ItemDefaultValues] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  View [dbo].[v_ItemDefaultValues]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [dbo].[v_ItemDefaultValues]
AS

    SELECT * FROM dbo.tb_ItemDefaultValues
    -- ORDER BY ItemCodeDefaultValue

GO
/****** Object:  Table [dbo].[User]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[User](
	[ID] [int] IDENTITY(427,1) NOT NULL,
	[FirstName] [nvarchar](150) NULL,
	[LastName] [nvarchar](50) NULL,
	[DepartmentID] [int] NOT NULL,
	[UserLevel] [int] NOT NULL,
	[UserNumber] [nvarchar](50) NOT NULL,
	[LoginInfo] [varchar](50) NOT NULL,
	[DeleteSO] [bit] NOT NULL,
	[ChangeSOstatus] [bit] NOT NULL,
	[BackEndAccess] [bit] NOT NULL,
	[PrintAllLabel] [bit] NOT NULL,
	[IsAdmin] [bit] NOT NULL,
	[ViewProductionReport] [bit] NOT NULL,
	[StatusID] [int] NULL,
	[ScanMode] [int] NOT NULL,
	[PrintLabel] [bit] NOT NULL,
	[PrintDrawerLabel] [bit] NOT NULL,
	[PrintLabelCopies] [int] NOT NULL,
	[PrintDrawerLabelCopies] [int] NOT NULL,
	[ViewActiveOrders] [bit] NOT NULL,
	[ViewDeactivatedOrders] [bit] NOT NULL,
	[ViewOrderRevised] [bit] NOT NULL,
	[ViewError] [bit] NOT NULL,
	[ViewArchivedOrderItemHistory] [bit] NOT NULL,
	[ViewTabChangeStatust] [bit] NOT NULL,
	[ViewRMA] [bit] NOT NULL,
	[ShowInChangeStatus] [bit] NOT NULL,
	[ScanModeMobile] [int] NOT NULL,
	[ChangeStatusTabOverrideOrder] [bit] NOT NULL,
	[EditETAfinishing] [bit] NOT NULL,
	[BigNumberColor] [int] NOT NULL,
	[ImportOrder] [bit] NOT NULL,
	[DisplayBigNumber] [bit] NOT NULL,
	[DisplayBigNumberSingleScan] [bit] NOT NULL,
	[DisplayUpdateLocationOption] [bit] NOT NULL,
	[AddTime] [datetime] NOT NULL,
	[MsgID] [int] NULL,
	[EditLocation] [bit] NOT NULL,
	[Active] [bit] NOT NULL,
	[MsgBoxID] [int] NULL,
	[BigNumberColorHex] [varchar](25) NULL,
	[MBPCSPassword] [varchar](200) NULL,
	[HistoryMemo] [varchar](255) NULL,
	[PID] [varchar](75) NULL,
 CONSTRAINT [PK_User] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[tb_TabChangeStatusUid]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[tb_TabChangeStatusUid](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Uid] [int] NOT NULL,
	[ckUid] [int] NOT NULL,
	[LastUpdateTime] [datetime] NOT NULL,
	[StatusId] [int] NULL,
	[Sort] [int] NULL,
	[Hostname] [varchar](50) NULL,
	[AddDate] [datetime] NULL,
 CONSTRAINT [PK_tb_TabChangeStatusUid] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  View [dbo].[v_UsersUserList]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[v_UsersUserList]
AS
SELECT  [Uid] RID, dbo.tb_TabChangeStatusUid.ckUid AS ID,
        dbo.[User].UserNumber + '  ' + dbo.[User].FirstName AS userNum
FROM    dbo.tb_TabChangeStatusUid
        INNER JOIN dbo.[User]
        ON dbo.[User].ID = dbo.tb_TabChangeStatusUid.ckUid

GO
/****** Object:  Table [dbo].[PrintAccListOrders]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PrintAccListOrders](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[OrderID] [int] NOT NULL,
	[AccListPrinted] [bit] NOT NULL,
	[AddTime] [datetime] NOT NULL,
	[AccLabelPrinted] [bit] NOT NULL,
	[AccOnly] [bit] NULL,
	[BackOrder] [bit] NULL,
	[KD] [bit] NULL,
	[isActive] [bit] NULL,
	[OrderInAssembly] [bit] NULL,
 CONSTRAINT [PK__PrintAcc__3214EC2702E7657A] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  View [dbo].[v_AccPickingDropLocations]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO












CREATE VIEW [dbo].[v_AccPickingDropLocations]
AS
SELECT DISTINCT
        te.OrderID, te.ID EntryID,
		--CASE WHEN ISNULL(PickDropLoc,'A') NOT  IN('C','F') THEN 'Inspecting Accessories' ELSE PickDropLoc END
        CASE WHEN (te.KD = 1 OR
                  [Order].KD = 1 OR 
                  dbo.PrintAccListOrders.AccOnly = 1 ) AND ISNULL(PickDropLoc,'A') NOT  IN('C','F')  THEN 'KD'
             ELSE ISNULL(PickDropLoc,'A') END 
		ModType,
        CASE --WHEN ItemCode = 'RD-Drawer Box' THEN 'Drawer''
             WHEN ItemType = 12 THEN 'Door'
             --WHEN [Order].KD = 1 THEN 'KD'
             WHEN [Order].KD = 1 AND ( tb_ItemList.StyleCode  IS NULL OR tb_ItemList.StyleCode <>'1') THEN 'KD'
			 WHEN [Order].KD = 1 AND tb_ItemList.StyleCode ='1' THEN 'KD 1'
			 WHEN ItemCode LIKE '% DW%' THEN 'DWR'
             WHEN tb_ItemList.StyleCode IS NOT NULL
             THEN CASE WHEN tb_ItemList.StyleCode = 'IS'
                       THEN ISNULL((
                                     SELECT TOP 1
                                            tb_ItemList.StyleCode
                                     FROM   dbo.tb_ItemList
                                            INNER JOIN dbo.TranEntry tf
                                            ON dbo.tb_ItemList.ItemCode = tf.ItemNumber
                                     WHERE  tf.OrderID = te.OrderID AND
                                            IsCabinet = 1 AND
                                            tf.isActive = 1
                                     GROUP BY tb_ItemList.StyleCode
                                     ORDER BY COUNT(*) DESC
                                   ), 'IS')
                       ELSE tb_ItemList.StyleCode
                  END
             ELSE 'UNK'
        END StyleCode, EstimatedCompleteDate,SubTypeCode
FROM    dbo.TranEntry (NOLOCK) te
        INNER JOIN dbo.[Order]
        ON te.OrderID = dbo.[Order].ID
        INNER JOIN tb_ItemList
        ON ItemNumber = ItemCode
        LEFT JOIN dbo.PrintAccListOrders
        ON [Order].ID = PrintAccListOrders.OrderID
WHERE   ItemType = 3 AND
        te.DepartmentstatusID IN ( 6, 57, 58, 24 )











GO
/****** Object:  Table [dbo].[QccVendorNumbers]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[QccVendorNumbers](
	[VendorNumber] [int] NOT NULL,
	[VendorName] [varchar](100) NOT NULL,
	[VendorId] [int] NULL
) ON [PRIMARY]
GO
/****** Object:  Table [inventory].[Containers]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [inventory].[Containers](
	[ContainerID] [int] IDENTITY(1,1) NOT NULL,
	[Container] [varchar](50) NOT NULL,
	[ETA] [date] NULL,
	[Received] [bit] NOT NULL,
	[ReceivedDate] [datetime] NULL,
	[AddDate] [datetime] NOT NULL,
	[Arrived] [bit] NULL,
	[AcumaticaID] [nvarchar](450) NULL,
	[Vendor] [varchar](500) NULL,
	[AcumaticaReceiptID] [varchar](50) NULL,
	[Notes] [varchar](1000) NULL,
	[ContainerTypeId] [int] NOT NULL,
	[ReadyToInspect] [bit] NOT NULL,
	[InspectionComplete] [bit] NOT NULL,
	[Released] [bit] NOT NULL,
 CONSTRAINT [PK_Containers] PRIMARY KEY CLUSTERED 
(
	[ContainerID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [inventory].[ContainerBay]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [inventory].[ContainerBay](
	[ContainerBayID] [int] IDENTITY(1,1) NOT NULL,
	[ContainerID] [int] NOT NULL,
	[LocationID] [int] NOT NULL,
	[ContainerStatusID] [int] NOT NULL,
	[AddTime] [datetime] NOT NULL,
	[LastUpdate] [datetime] NULL,
	[ClosedTime] [datetime] NULL,
	[ClosedBy] [nvarchar](128) NULL,
	[Deleted] [bit] NOT NULL,
 CONSTRAINT [PK_ContainerBay] PRIMARY KEY CLUSTERED 
(
	[ContainerBayID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [inventory].[ContainerList]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [inventory].[ContainerList](
	[ContainerListID] [int] IDENTITY(1,1) NOT NULL,
	[ContainerID] [int] NOT NULL,
	[ItemID] [int] NULL,
	[ItemCode] [varchar](50) NULL,
	[PONumber] [varchar](50) NOT NULL,
	[Qty] [int] NOT NULL,
	[Received] [bit] NOT NULL,
	[QtyReceived] [int] NULL,
	[ReceivedDate] [datetime] NULL,
	[AddDate] [datetime] NOT NULL,
	[UpdateDate] [datetime] NULL,
	[Approved] [bit] NULL,
	[ApprovedBy] [nvarchar](128) NULL,
	[ApprovedAmount] [int] NULL,
	[Deleted] [bit] NOT NULL,
	[ApprovedNote] [varchar](4000) NULL,
 CONSTRAINT [PK_ContainerList] PRIMARY KEY CLUSTERED 
(
	[ContainerListID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[InventoryLocation]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[InventoryLocation](
	[Location] [nvarchar](255) NOT NULL,
	[ID] [int] IDENTITY(101001,1) NOT NULL,
	[Status] [nchar](25) NULL,
	[AllowAddItemCodeInv] [bit] NOT NULL,
	[AllowItemCodeInv] [bit] NOT NULL,
	[AllowAddItemCodeUL] [bit] NOT NULL,
	[AllowItemCodeUL] [bit] NOT NULL,
	[AllowAddPalletInv] [bit] NOT NULL,
	[AllowAddPalletUL] [bit] NOT NULL,
	[Isle] [nvarchar](255) NULL,
	[Section] [nvarchar](255) NULL,
	[IsActive] [bit] NOT NULL,
	[IsPickable] [bit] NOT NULL,
	[LocationType] [int] NOT NULL,
	[UserID] [int] NULL,
	[HostName] [varchar](250) NULL,
	[AddTime] [datetime] NOT NULL,
	[CombinedIsle] [nvarchar](50) NULL,
	[AllowAddPalletULPrompt] [bit] NOT NULL,
	[AllowILUAddtnlRcrds] [bit] NOT NULL,
	[AllowILUAddtnlRcrdsPrompt] [bit] NOT NULL,
	[BlockPalletInv] [bit] NOT NULL,
	[BlockPalletUL] [bit] NOT NULL,
	[Slot] [int] NULL,
	[Warehouse] [int] NULL,
	[ExcludeFrmStock] [bit] NOT NULL,
	[IsleNumeric] [int] NOT NULL,
	[AllowSNABN] [bit] NOT NULL,
	[NonSellableStock] [bit] NOT NULL,
	[PromptChangeDOL] [bit] NULL,
	[IgnoreSNABNInStock] [bit] NOT NULL,
	[isDeleted] [bit] NULL,
	[Shelf] [int] NULL,
	[Rack] [nvarchar](50) NULL,
	[RackNumeric] [int] NULL,
 CONSTRAINT [PK_LocationNumbers] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ItemLocationsUpdate]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ItemLocationsUpdate](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ItemCode] [nvarchar](50) NULL,
	[Location] [nvarchar](50) NULL,
	[PoNumber] [varchar](50) NULL,
	[Quantity] [int] NULL,
	[UserId] [int] NULL,
	[Status] [nvarchar](50) NULL,
	[Note] [nvarchar](1000) NULL,
	[AddDate] [datetime] NULL,
	[PalletID] [int] NULL,
	[Hostname] [nvarchar](50) NULL,
	[SerialNumber] [nvarchar](50) NULL,
	[LastUpdated] [datetime] NULL,
	[LastUpdatedAppName] [varchar](1000) NULL,
 CONSTRAINT [PK_ItemLocationsUpdate] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  View [inventory].[ContainerBasicInfo]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO













--select * from inventory.containersummary
--select top 10 * from inventory.ContainerBay

CREATE VIEW [inventory].[ContainerBasicInfo]
AS 
SELECT c.ContainerID, c.Container, cb.Location AS Bay, cb.LocationID AS BayId,
CASE WHEN c.Received = 1 OR c.ReceivedDate IS NOT NULL THEN 3 
	WHEN cb.ContainerStatusID IN (1,3) THEN 2 
	WHEN ISNULL(C.ARRIVED,0 ) = 1 THEN 1 
	WHEN c.ETA < GETDATE() + 20  THEN 4 
	ELSE 0 END AS ContainerStatusID,
	c.Received AS AllowReopen,
ISNULL(cb.ClosedTime,c.ReceivedDate)  AS ReceivedDate,
cb.ClosedBy AS ReceivedBy,
c.ETA,
c.AcumaticaReceiptID,
c.AcumaticaID,
vn.VendorNumber,
c.ContainerTypeId,c.ReadyToInspect,c.InspectionComplete, cb.Quantity AS ItemsInBay
 FROM INVENTORY.Containers c
 OUTER APPLY (SELECT TOP 1 il.Location, cb.LocationID, ContainerStatusID , cb.ClosedTime, cb.ClosedBy, ilu.Quantity FROM  inventory.ContainerBay cb  
JOIN dbo.InventoryLocation il ON il.id = cb.LocationID
OUTER APPLY(SELECT TOP 1 ilu2.Quantity FROM dbo.ItemLocationsUpdate AS ilu2 WHERE  ilu2.Location = il.Location AND ilu2.Quantity > 0) AS ilu
WHERE cb.containerid = c.ContainerID AND cb.Deleted = 0
) cb
OUTER APPLY (SELECT TOP 1 qvn.VendorNumber FROM dbo.QccVendorNumbers qvn 
JOIN inventory.Po p ON p.VendorID = qvn.VendorId AND p.Deleted =0
JOIN inventory.ContainerList cl ON cl.PONumber = p.PoNumber AND cl.Deleted = 0
WHERE  cl.ContainerID=c.ContainerID ) vn

















GO
/****** Object:  UserDefinedFunction [dbo].[f_ItemDefaultValues]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[f_ItemDefaultValues]
    (
      @ItemType INT,
      @ItemCode VARCHAR(150)
    )
RETURNS TABLE
    AS
RETURN
    SELECT TOP 1
            *
    FROM    dbo.tb_ItemDefaultValues
    WHERE   ItemType = @ItemType OR
            ItemCodeDefaultValue = @ItemCode
    ORDER BY ItemCodeDefaultValue DESC
GO
/****** Object:  Table [inventory].[AcumaticaStockItems]    Script Date: 6/17/2021 11:37:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [inventory].[AcumaticaStockItems](
	[AcumaticaID] [int] NOT NULL,
	[Name] [nvarchar](450) NULL,
	[Description] [nvarchar](max) NULL,
	[ItemStatus] [nvarchar](max) NULL,
	[SubTypeCode] [nvarchar](max) NULL,
	[ItemTypeCode] [nvarchar](max) NULL,
	[BookPrice] [numeric](18, 2) NULL,
	[IsAccessory] [bit] NULL,
	[IsNetPrice] [bit] NULL,
	[RemoveFlag] [bit] NULL,
	[ProductDescOverwrite] [nvarchar](max) NULL,
	[Width] [numeric](18, 3) NULL,
	[Height] [numeric](18, 3) NULL,
	[Depth] [numeric](18, 3) NULL,
	[Weight] [numeric](18, 2) NULL,
	[KdWidth] [numeric](18, 2) NULL,
	[KdHeight] [numeric](18, 2) NULL,
	[KdDepth] [numeric](18, 2) NULL,
	[CubicFtKD] [numeric](18, 2) NULL,
	[CubicFtAssemble] [numeric](18, 2) NULL,
	[CubicMeterKD] [numeric](18, 2) NULL,
	[AcumaticaProductID] [int] NULL,
	[AcumaticaDoorStyleID] [int] NULL